

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptBillingTagToCopy.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptBillingTagToCopy.sp,v $ $Id: RptBillingTagToCopy.sp,v 1.4.2.2 2020/12/02 16:52:20 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptBillingTagToCopy')
BEGIN
	print '>>> Drop Stored Procedure: RptBillingTagToCopy <<<'
	drop procedure RptBillingTagToCopy
END
IF EXISTS (select * from GxQscripts where name='RptBillingTagToCopy')
	delete from GxQscripts where name = 'RptBillingTagToCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBillingTagToCopy')
	delete from GXDBVersions where aliasname = 'RptBillingTagToCopy'
GO
print '... Creating Procedure: RptBillingTagToCopy'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptBillingTagToCopy
  @i_UserId INT = -1,
  @i_EntityId INT,
  @i_AllAssociated INT = 1,
  @i_CellUniqueId INT = 0,
  @i_PolicyId INT = 0,
  @i_CopyId INT = 0
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
CREATE TABLE #CommCell (CommServUniqueId INT, CommServName NVARCHAR(256))
INSERT	INTO  #CommCell
SELECT	C.ID, C.CommServName
FROM	cf_CommcellIdNameMap C
		INNER JOIN dbo.cf_SurveyResultFuncV1(2, 0, 1, NULL, NULL, @i_UserId, -1) R ON R.CommServUniqueId = C.ID
WHERE	(C.CommCellSurveyServices&32) = 32
-- Show copy tag associations
IF @i_AllAssociated = 1
BEGIN
	IF @i_EntityId > 0
		SELECT	CC.CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
			CC.CommServName AS 'CommCell Name',
			C.PolicyName AS 'Storage Policy',
			C.CopyId AS 'Copy ID<DONOTSHOW>',
			C.CopyName AS 'Copy Name',
			CASE WHEN C.IsDefaultCopy = 1 THEN 'Yes' ELSE 'No' END AS 'Is Primary Copy',
			CASE WHEN C.IsSnapCopy = 1 THEN 'Yes' ELSE 'No' END AS 'Is Snap Copy',
			CASE ISNULL( C.DedupeFlags, -1) WHEN -1 THEN 'N/A' WHEN 0 THEN 'No' ELSE 'Yes' END AS 'Is Dedup Copy',
			ISNULL(C.DefaultLibrary, 'N/A') AS 'Library Name'
		FROM	 #CommCell CC
			INNER JOIN cf_SurveyCopyBasicRetention C  ON C.CommServUniqueId = CC.CommServUniqueId
			INNER JOIN cf_SurveyBillingEntityToCopy M ON M.CommServUniqueId = CC.CommServUniqueId AND C.CopyId = M.CopyId AND M.EntityID = @i_EntityId
		ORDER BY 'CommCell Name', 'Storage Policy', 'Copy Name'
	ELSE
		SELECT	E.ID AS 'Tag ID<DONOTSHOW>',
			E.Name AS 'Tag Name',
			CC.CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
			CC.CommServName AS 'CommCell Name',
			ISNULL(C.PolicyName, '') AS 'Storage Policy',
			M.CopyId AS 'Copy ID<DONOTSHOW>',
			ISNULL(C.CopyName, '') AS 'Copy Name',
			CASE WHEN C.IsDefaultCopy = 1 THEN 'Yes' ELSE 'No' END AS 'Is Primary Copy',
			CASE WHEN C.IsSnapCopy = 1 THEN 'Yes' ELSE 'No' END AS 'Is Snap Copy',
			CASE ISNULL( C.DedupeFlags, -1) WHEN -1 THEN 'N/A' WHEN 0 THEN 'No' ELSE 'Yes' END AS 'Is Dedup Copy',
			ISNULL(C.DefaultLibrary, 'N/A') AS 'Library Name'
		FROM	 #CommCell CC
			INNER JOIN cf_SurveyCopyBasicRetention C  ON C.CommServUniqueId = CC.CommServUniqueId
			INNER JOIN cf_SurveyBillingEntityToCopy M ON C.CommServUniqueId = M.CommServUniqueId AND C.CopyId = M.CopyId
			INNER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
		ORDER BY 'Tag Name', 'CommCell Name', 'Storage Policy', 'Copy Name'
END
-- New copy tag association
ELSE
IF @i_CellUniqueId <= 0
	SELECT	CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
			CommServName AS 'CommCell Name'
	FROM	#CommCell
	ORDER BY 'CommCell Name'
ELSE
IF @i_CellUniqueId > 0 AND @i_PolicyId <= 0
	SELECT	DISTINCT PolicyId AS 'Policy ID<DONOTSHOW>',
			PolicyName AS 'Storage Policy'
	FROM	cf_SurveyCopyBasicRetention C
	WHERE	CommservUniqueId = @i_CellUniqueId AND Deleted = 0
	ORDER BY 'Storage Policy'
ELSE
IF @i_CellUniqueId > 0 AND @i_PolicyId > 0 AND @i_CopyId <= 0
	SELECT	C.CopyId AS 'Copy ID<DONOTSHOW>',
			C.CopyName AS 'Copy Name',
			CASE WHEN C.IsDefaultCopy = 1 THEN 'Yes' ELSE 'No' END AS 'Is Primary Copy',
			CASE WHEN C.IsSnapCopy = 1 THEN 'Yes' ELSE 'No' END AS 'Is Snap Copy',
			CASE ISNULL( C.DedupeFlags, -1) WHEN -1 THEN 'N/A' WHEN 0 THEN 'No' ELSE 'Yes' END AS 'Is Dedup Copy',
			ISNULL(C.DefaultLibrary, 'N/A') AS 'Library Name',
			CASE WHEN M.CopyId IS NULL THEN 0 ELSE 1 END AS 'Associated',
			ISNULL(E.ID, 0) AS 'Tag ID',
			ISNULL(E.Name, '') AS 'Tag Name'
	FROM	cf_SurveyCopyBasicRetention C
			LEFT OUTER JOIN cf_SurveyBillingEntityToCopy M ON M.CommServUniqueId = @i_CellUniqueId AND M.CopyId = C.CopyId
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
	WHERE	C.CommservUniqueId = @i_CellUniqueId AND C.PolicyId = @i_PolicyId AND C.Deleted = 0
	ORDER BY 'Copy Name'
ELSE
IF @i_CellUniqueId > 0 AND @i_PolicyId > 0 AND @i_CopyId > 0
	SELECT	C.CopyId AS 'Copy ID<DONOTSHOW>',
			C.CopyName AS 'Copy Name',
			CASE WHEN C.IsDefaultCopy = 1 THEN 'Yes' ELSE 'No' END AS 'Is Primary Copy',
			CASE WHEN C.IsSnapCopy = 1 THEN 'Yes' ELSE 'No' END AS 'Is Snap Copy',
			CASE ISNULL( C.DedupeFlags, -1) WHEN -1 THEN 'N/A' WHEN 0 THEN 'No' ELSE 'Yes' END AS 'Is Dedup Copy',
			ISNULL(C.DefaultLibrary, 'N/A') AS 'Library Name',
			CASE WHEN M.CopyId IS NULL THEN 0 ELSE 1 END AS 'Associated',
			ISNULL(E.ID, 0) AS 'Tag ID',
			ISNULL(E.Name, '') AS 'Tag Name'
	FROM	cf_SurveyCopyBasicRetention C
			LEFT OUTER JOIN cf_SurveyBillingEntityToCopy M ON M.CommServUniqueId = @i_CellUniqueId AND M.CopyId = C.CopyId
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
	WHERE	C.CommservUniqueId = @i_CellUniqueId AND C.PolicyId = @i_PolicyId AND C.CopyId = @i_CopyId
	ORDER BY 'Copy Name'
DROP TABLE #CommCell
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptBillingTagToCopy')
	delete from GxQscripts where name = 'RptBillingTagToCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBillingTagToCopy')
	delete from GXDBVersions where aliasname = 'RptBillingTagToCopy'
GO

insert into GXDBVersions values(2, 'RptBillingTagToCopy',  '00010004000200020000', 'RptBillingTagToCopy', '00010004000200020000')
GO

