

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptCapacityLicenseSurvey.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptCapacityLicenseSurvey.sp,v $ $Id: RptCapacityLicenseSurvey.sp,v 1.22.2.37 2020/12/17 02:52:47 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptCapacityLicenseSurvey')
BEGIN
	print '>>> Drop Stored Procedure: RptCapacityLicenseSurvey <<<'
	drop procedure RptCapacityLicenseSurvey
END
IF EXISTS (select * from GxQscripts where name='RptCapacityLicenseSurvey')
	delete from GxQscripts where name = 'RptCapacityLicenseSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCapacityLicenseSurvey')
	delete from GXDBVersions where aliasname = 'RptCapacityLicenseSurvey'
GO
print '... Creating Procedure: RptCapacityLicenseSurvey'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptCapacityLicenseSurvey
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll,
  @i_csvOutput INT  = 0,
  @i_monthsOfTrend INT = 12
AS
DECLARE @i_QueryId INT = 1
SET NOCOUNT ON
DECLARE @isPrivate	INT = 0
SELECT  @isPrivate = ISNULL(CAST(Value AS INT), 0) FROM cf_SurveyConfig (NoLOCK) WHERE Name = 'isPrivate'
CREATE TABLE #CommServResults (
	CommServUniqueId INT, CommCellID VARCHAR(32), CommServIP VARCHAR(256), CommServGUID VARCHAR(256), DisplayName NVARCHAR(256),
	CommServName NVARCHAR(256), CommServTimeZone VARCHAR(256), SurveyResultId BIGINT, LogDate DATETIME, LogDateUTC DATETIME,
	CommvaultCompleteEnabled INT
)
IF @blaggregate = 1 AND @blLatestSurvey = 0 -- Capacity Growth
	INSERT INTO #CommServResults
	SELECT	CommServUniqueId, CommCellID, CommServIP, CommServGUID, DisplayName, CommServName, CommServTimeZone, SurverResultId, LogDate, LogDateUTC, 0
	FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
ELSE -- Capacity Usage and CommCell Details
	INSERT INTO #CommServResults
	SELECT	CommServUniqueId, CommCellID, CommServIP, CommServGUID, DisplayName, CommServName, CommServTimeZone, SurverResultId, LogDate, LogDateUTC, 0
	FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
UPDATE	T SET CommvaultCompleteEnabled = -1
FROM	#CommServResults T
		INNER JOIN Lic_LicenseInfo L WITH(NOLOCK)
			ON T.CommServUniqueId = L.CommServUniqueId AND L.LicType = 205
UPDATE T SET CommvaultCompleteEnabled = 1
FROM	#CommServResults T
		INNER JOIN Lic_LicenseInfo B WITH(NOLOCK)
			ON T.CommServUniqueId = B.CommServUniqueId AND B.LicType = 100002
		INNER JOIN Lic_LicenseInfo A WITH(NOLOCK)
			ON T.CommServUniqueId = A.CommServUniqueId AND A.LicType = 100004
WHERE	T.CommvaultCompleteEnabled = -1
	AND B.PermTotal = A.PermTotal AND B.EvalTotal = A.EvalTotal AND B.TermDate = A.TermDate
DECLARE @now DATETIME = GETDATE()
IF (SELECT COUNT(DISTINCT CommServTimeZone) FROM #CommServResults WHERE ISNULL(CommServTimeZone, '') <> '') = 1
BEGIN
	DECLARE @csTimeZone VARCHAR(256)
	SELECT	@csTimeZone = CommServTimeZone
	FROM	#CommServResults
	WHERE	ISNULL(CommServTimeZone, '') <> ''
	IF @csTimeZone IS NOT NULL
		SET @now = dbo.UTCToLocalDateTimeConversion(GETUTCDATE(), @csTimeZone)
END
IF @blaggregate <> 1 AND @blLatestSurvey = 1 -- CommCell Details
BEGIN
	IF @i_CommServUniqueID = 0
	BEGIN
		IF @blaggregate = 0 --Capacity Usage
			SELECT
				CommServUniqueId AS 'CommServ UniqueId',
				CommCellID AS 'CommCell ID',
				CommServIP AS 'CommServe IP<HIDDEN>',
				CommServGUID AS 'CommServer GUID',
				DisplayName AS 'CommCell Name',
				DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME><HIDDEN>',
				ISNULL(CommServTimeZone, '')  AS 'TimeZone<HIDDEN>',
				CASE WHEN CommvaultCompleteEnabled > 0  AND ISNULL(TotalBackupSize,0) > 0 THEN TotalBackupSize ELSE -1 END AS 'Purchased CommVault Complete Size<LicenseSizeMB>',
				CASE WHEN CommvaultCompleteEnabled > 0 THEN ISNULL(BackupSize,0) ELSE -1 END AS 'Used CommVault Complete Size<LicenseSizeMB>',
				CASE WHEN CommvaultCompleteEnabled <=0  AND ISNULL(TotalBackupSize,0) > 0 THEN TotalBackupSize ELSE -1 END AS 'Purchased Backup Size<LicenseSizeMB>',
				CASE WHEN CommvaultCompleteEnabled <=0 THEN ISNULL(BackupSize,0) ELSE -1 END AS 'Used Backup Size<LicenseSizeMB>',
				CASE WHEN CommvaultCompleteEnabled <=0  AND ISNULL(TotalArchiveSize, 0) > 0 THEN TotalArchiveSize ELSE -1 END AS 'Purchased Archive Size<LicenseSizeMB>',
				CASE WHEN CommvaultCompleteEnabled <=0 THEN ISNULL(ArchiveSize, 0) ELSE -1 END AS 'Used Archive Size<LicenseSizeMB>',
				CASE WHEN ISNULL(TotalSnapshotSize, 0) <= 0 THEN -1 ELSE TotalSnapshotSize END AS 'Purchased Snapshot Size<LicenseSizeMB>',
				ISNULL(SnapshotSize, 0) AS 'Used Snapshot Size<LicenseSizeMB>',
				CASE WHEN ISNULL(TotalReplicationSize, 0) <= 0 THEN -1 ELSE TotalReplicationSize END AS 'Purchased Replication Size<LicenseSizeMB>',
				ISNULL(ReplicationSize, 0) AS 'Used Replication Size<LicenseSizeMB>',
				CASE WHEN ISNULL(TotalDiskSpaceMB, 0) <= 0 THEN -1 ELSE TotalDiskSpaceMB END AS 'Purchased Library Disk Space<LicenseSizeMB>',
				ISNULL(UsedDiskSpaceMB, 0) AS 'Used Disk Space<LicenseSizeMB>',
				CASE WHEN ISNULL(TotalStoreSpaceMB, 0) <= 0 THEN -1 ELSE TotalStoreSpaceMB END AS 'Purchased Dedup Data Size<LicenseSizeMB>',
				ISNULL(DedupDataSizeMB, 0) AS 'Used Dedup Data Size<LicenseSizeMB>'
			FROM cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK)
				INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			ORDER BY LogDateUTC DESC, DisplayName ASC
		ELSE
		IF @blaggregate = 2 --Virtualization License Usage
			SELECT
				CommServUniqueId AS 'CommServ UniqueId',
				CommCellID AS 'CommCell ID',
				CommServIP AS 'CommServe IP<HIDDEN>',
				CommServGUID AS 'CommServer GUID',
				DisplayName AS 'CommCell Name',
				DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME><HIDDEN>',
				ISNULL(CommServTimeZone, '')  AS 'TimeZone<HIDDEN>',
				CASE WHEN TotalVMSockets IS NULL THEN -2 WHEN ISNUMERIC(TotalVMSockets) = 1 THEN CAST(TotalVMSockets AS INT) ELSE -1 END AS 'Purchased VM Sockets<NumberUnlimitedNA>',
				ISNULL(VMSockets, 0) AS 'Used VM Sockets<FORMATNUMBERNA>',
				CASE WHEN TotalProtectedVMs IS NULL THEN -2 WHEN ISNUMERIC(TotalProtectedVMs) = 1 THEN CAST(TotalProtectedVMs AS INT) ELSE -1 END AS 'Purchased Protected VMs<NumberUnlimitedNA>',
				ISNULL(ProtectedVMs, 0) AS 'Used Protected VMs<FORMATNUMBERNA>',
				CASE WHEN TotalArchivedVMs IS NULL THEN -2 WHEN ISNUMERIC(TotalArchivedVMs) = 1 THEN CAST(TotalArchivedVMs AS INT) ELSE -1 END AS 'Purchased Archived VMs<NumberUnlimitedNA>',
				ISNULL(ArchivedVMs, 0) AS 'Used Archived VMs<FORMATNUMBERNA>',
				CASE WHEN TotalAppClassVMs IS NULL THEN -2 WHEN ISNUMERIC(TotalAppClassVMs) = 1 THEN CAST(TotalAppClassVMs AS INT) ELSE -1 END AS 'Purchased Application Class Virtual<NumberUnlimitedNA>',
				ISNULL(AppClassVMs, 0) AS 'Used Application Class Virtual<FORMATNUMBERNA>'
			FROM cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK)
				INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			ORDER BY LogDateUTC DESC, DisplayName ASC
		ELSE
		IF @blaggregate = 4 --Archiving License Usage
			SELECT
				CommServUniqueId AS 'CommServ UniqueId',
				CommCellID AS 'CommCell ID',
				CommServIP AS 'CommServe IP<HIDDEN>',
				CommServGUID AS 'CommServer GUID',
				DisplayName AS 'CommCell Name',
				DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME><HIDDEN>',
				ISNULL(CommServTimeZone, '')  AS 'TimeZone<HIDDEN>',
				CASE WHEN TotalArchivedMailBoxes IS NULL THEN -2 WHEN ISNUMERIC(TotalArchivedMailBoxes) = 1 THEN CAST(TotalArchivedMailBoxes AS INT) ELSE -1 END AS 'Purchased Archived MailBoxes<NumberUnlimitedNA>',
				ISNULL(ArchivedMailBoxes, 0) AS 'Used Archived MailBoxes<FORMATNUMBERNA>',
				CASE WHEN TotalMBArchivedUsers IS NULL THEN -2 WHEN ISNUMERIC(TotalMBArchivedUsers) = 1 THEN CAST(TotalMBArchivedUsers AS INT) ELSE -1 END AS 'Purchased MailBox Archive Solution<NumberUnlimitedNA>',
				ISNULL(MBArchivedUsers, 0) AS 'Used MailBox Archive Solution<FORMATNUMBERNA>',
				CASE WHEN TotalCIObjectsInMillion IS NULL THEN -2 WHEN ISNUMERIC(TotalCIObjectsInMillion) = 1 THEN CAST(TotalCIObjectsInMillion AS INT) ELSE -1 END AS 'Purchased CI Objects (million)<NumberUnlimitedNA>',
				CAST(0.000001*ISNULL(CIObjects, 0) AS DECIMAL(20,2)) AS 'Used CI Objects (million)'
			FROM cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK)
				INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			ORDER BY LogDateUTC DESC, DisplayName ASC
		ELSE
		IF @blaggregate = 3 --Users Count Usage
			SELECT
				CommServUniqueId AS 'CommServ UniqueId',
				CommCellID AS 'CommCell ID',
				CommServIP AS 'CommServe IP<HIDDEN>',
				CommServGUID AS 'CommServer GUID',
				DisplayName AS 'CommCell Name',
				DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME><HIDDEN>',
				ISNULL(CommServTimeZone, '')  AS 'TimeZone<HIDDEN>',
				CASE WHEN TotalEndPointUsers IS NULL THEN -2 WHEN ISNUMERIC(TotalEndPointUsers) = 1 THEN CAST(TotalEndPointUsers AS INT) ELSE -1 END AS 'Purchased Users<NumberUnlimitedNA>',
				ISNULL(EndpointUsers, 0) AS 'Used Users<FORMATNUMBERNA>',
				CASE WHEN TotalSharingUsers IS NULL THEN -2 WHEN ISNUMERIC(TotalSharingUsers) = 1 THEN CAST(TotalSharingUsers AS INT) ELSE -1 END AS 'Purchased Sharing Users<NumberUnlimitedNA>',
				ISNULL(SharingUsers, 0) AS 'Used Sharing Users<FORMATNUMBERNA>',
				CASE WHEN TotaleDiscoveryUsers IS NULL THEN -2 WHEN ISNUMERIC(TotaleDiscoveryUsers) = 1 THEN CAST(TotaleDiscoveryUsers AS INT) ELSE -1 END AS 'Purchased eDiscovery Users<NumberUnlimitedNA>',
				ISNULL(eDiscoveryUsers, 0) AS 'Used eDiscovery Users<FORMATNUMBERNA>'
			FROM cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK)
				INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			ORDER BY LogDateUTC DESC, DisplayName ASC
	END
	ELSE
	BEGIN
		DECLARE @LicenseUsageTbl TABLE (License VARCHAR(32), Total BIGINT, Used BIGINT)
		IF @blaggregate = 0 --Capacity Usage
		BEGIN
			DECLARE @CapacityUsageTbl TABLE (CapacityType VARCHAR(32), PurchasedMB BIGINT, UsedMB BIGINT, LoanedMB BIGINT, ExpiresOn INT)
			INSERT INTO @CapacityUsageTbl
			SELECT 	CASE WHEN CommvaultCompleteEnabled <= 0 THEN 'Backup' ELSE 'Commvault Complete' END AS 'Capacity License',
					CASE WHEN ISNULL(TotalBackupSize,0) <= 0 THEN -1 ELSE TotalBackupSize END AS 'Purchased<LicenseSizeMB>',
					ISNULL(BackupSize,0) AS 'Used<LicenseSizeMB>',
					CASE WHEN ISNULL(EvalBackupExpiry, '1970-01-01') <= '1970-01-01' OR ISNULL(EvalBackupExpiry, '1970-01-01') > @now THEN ISNULL(EvalBackupSizeMB, 0) ELSE 0 END AS 'Loaned<LicenseSizeMB>',
					CASE WHEN ISNULL(EvalBackupExpiry, '1970-01-01') <= @now THEN 0 ELSE dbo.GetUnixTimeBig(EvalBackupExpiry) END AS 'Expires on<DATETIME>'
			FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			UNION ALL
			SELECT 	'Archive' AS 'Capacity License',
					CASE WHEN ISNULL(TotalArchiveSize, 0) <= 0 THEN -1 ELSE TotalArchiveSize END AS 'Purchased<LicenseSizeMB>',
					ISNULL(ArchiveSize, 0) AS 'Used<LicenseSizeMB>',
					CASE WHEN ISNULL(EvalArchiveExpiry, '1970-01-01') <= '1970-01-01' OR ISNULL(EvalArchiveExpiry, '1970-01-01') > @now THEN ISNULL(EvalArchiveSizeMB, 0) ELSE 0 END AS 'Loaned<LicenseSizeMB>',
					CASE WHEN ISNULL(EvalArchiveExpiry, '1970-01-01') <= @now THEN 0 ELSE dbo.GetUnixTimeBig(EvalArchiveExpiry) END AS 'Expires on<DATETIME>'
			FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			WHERE	results.CommvaultCompleteEnabled <= 0
			UNION ALL
			SELECT 	'Snapshot' AS 'Capacity License',
					CASE WHEN ISNULL(TotalSnapshotSize, 0) <= 0 THEN -1 ELSE TotalSnapshotSize END AS 'Purchased<LicenseSizeMB>',
					ISNULL(SnapshotSize, 0) AS 'Used<LicenseSizeMB>',
					CASE WHEN ISNULL(EvalSnapshotExpiry, '1970-01-01') <= '1970-01-01' OR ISNULL(EvalSnapshotExpiry, '1970-01-01') > @now THEN ISNULL(EvalSnapshotSizeMB, 0) ELSE 0 END AS 'Loaned<LicenseSizeMB>',
					CASE WHEN ISNULL(EvalSnapshotExpiry, '1970-01-01') <= @now THEN 0 ELSE dbo.GetUnixTimeBig(EvalSnapshotExpiry) END AS 'Expires on<DATETIME>'
			FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			UNION ALL
			SELECT 	'Replication' AS 'Capacity License',
					CASE WHEN ISNULL(TotalReplicationSize, 0) <= 0 THEN -1 ELSE TotalReplicationSize END AS 'Purchased<LicenseSizeMB>',
					ISNULL(ReplicationSize, 0) AS 'Used<LicenseSizeMB>',
					CASE WHEN ISNULL(EvalReplicationExpiry, '1970-01-01') <= '1970-01-01' OR ISNULL(EvalReplicationExpiry, '1970-01-01') > @now THEN ISNULL(EvalReplicationSizeMB, 0) ELSE 0 END AS 'Loaned<LicenseSizeMB>',
					CASE WHEN ISNULL(EvalReplicationExpiry, '1970-01-01') <= @now THEN 0 ELSE dbo.GetUnixTimeBig(EvalReplicationExpiry) END AS 'Expires on<DATETIME>'
			FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			UNION ALL
			SELECT 	'Library Disk Space' AS 'Capacity License',
					CASE WHEN ISNULL(TotalDiskSpaceMB, 0) <= 0 THEN -1 ELSE TotalDiskSpaceMB END  AS 'Purchased<LicenseSizeMB>',
					ISNULL(UsedDiskSpaceMB, 0) AS 'Used<LicenseSizeMB>',
					-1 AS 'Loaned<LicenseSizeMB>',
					-1 AS 'Expires on<DATETIME>'
			FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			UNION ALL
			SELECT 	'Dedup Data Size' AS 'Capacity License',
					CASE WHEN ISNULL(TotalStoreSpaceMB, 0) <= 0 THEN -1 ELSE TotalStoreSpaceMB END AS 'Purchased<LicenseSizeMB>',
					ISNULL(DedupDataSizeMB, 0) AS 'Used<LicenseSizeMB>',
					-1 AS 'Loaned<LicenseSizeMB>',
					-1 AS 'Expires on<DATETIME>'
			FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			UNION ALL
			SELECT 	'Appliance Store Usage' AS 'Capacity License',
					CASE WHEN ISNULL(TotalAppStoreSpaceMB, 0) <= 0 THEN -1 ELSE TotalAppStoreSpaceMB END AS 'Purchased<LicenseSizeMB>',
					ISNULL(AppStoreSpaceMB, 0) AS 'Used<LicenseSizeMB>',
					-1 AS 'Loaned<LicenseSizeMB>',
					-1 AS 'Expires on<DATETIME>'
			FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			IF NOT EXISTS (SELECT * FROM #CommServResults WHERE CommCellID <> '-1')
				SELECT	CapacityType AS 'Capacity License',
						LoanedMB AS 'Evaluation<LicenseSizeMB>',
						UsedMB AS 'Used<LicenseSizeMB>',
						ExpiresOn AS 'Expires on<DATETIME>'
				FROM	@CapacityUsageTbl
			ELSE
				SELECT	CapacityType AS 'Capacity License',
						PurchasedMB AS 'Purchased<LicenseSizeMB>',
						UsedMB AS 'Used<LicenseSizeMB>',
						LoanedMB AS 'Loaned<LicenseSizeMB>',
						ExpiresOn AS 'Expires on<DATETIME>'
				FROM	@CapacityUsageTbl
		END
		ELSE
		BEGIN
			IF @blaggregate = 2 --Virtualization License Usage
				INSERT	INTO @LicenseUsageTbl
				SELECT	'VM Sockets' AS 'License',
						CASE WHEN TotalVMSockets IS NULL THEN -2 WHEN ISNUMERIC(TotalVMSockets) = 1 THEN CAST(TotalVMSockets AS INT) ELSE -1 END AS 'Purchased<NumberUnlimitedNA>',
						ISNULL(VMSockets, 0) AS 'Used'
				FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
				UNION ALL
				SELECT	'Protected VMs' AS 'License',
						CASE WHEN TotalProtectedVMs IS NULL THEN -2 WHEN ISNUMERIC(TotalProtectedVMs) = 1 THEN CAST(TotalProtectedVMs AS INT) ELSE -1 END AS 'Purchased<NumberUnlimitedNA>',
						ISNULL(ProtectedVMs, 0) AS 'Used'
				FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
				UNION ALL
				SELECT	'Archived VMs' AS 'License',
						CASE WHEN TotalArchivedVMs IS NULL THEN -2 WHEN ISNUMERIC(TotalArchivedVMs) = 1 THEN CAST(TotalArchivedVMs AS INT) ELSE -1 END AS 'Purchased<NumberUnlimitedNA>',
						ISNULL(ArchivedVMs, 0) AS 'Used'
				FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
				UNION ALL
				SELECT	'Application Class Virtual' AS 'License',
						CASE WHEN TotalAppClassVMs IS NULL THEN -2 WHEN ISNUMERIC(TotalAppClassVMs) = 1 THEN CAST(TotalAppClassVMs AS INT) ELSE -1 END AS 'Purchased<NumberUnlimitedNA>',
						ISNULL(AppClassVMs, 0) AS 'Used'
				FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			ELSE
			IF @blaggregate = 4 --Archiving License Usage
				INSERT	INTO @LicenseUsageTbl
				SELECT	'Archived MailBoxes' AS 'License',
						CASE WHEN TotalArchivedMailBoxes IS NULL THEN -2 WHEN ISNUMERIC(TotalArchivedMailBoxes) = 1 THEN CAST(TotalArchivedMailBoxes AS INT) ELSE -1 END AS 'Purchased<NumberUnlimitedNA>',
						ISNULL(ArchivedMailBoxes, 0) AS 'Used'
				FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
				UNION ALL
				SELECT	'MailBox Archive Solution' AS 'License',
						CASE WHEN TotalMBArchivedUsers IS NULL THEN -2 WHEN ISNUMERIC(TotalMBArchivedUsers) = 1 THEN CAST(TotalMBArchivedUsers AS INT) ELSE -1 END AS 'Purchased<NumberUnlimitedNA>',
						ISNULL(MBArchivedUsers, 0) AS 'Used'
				FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
				UNION ALL
				SELECT	'CI Objects (million)' AS 'License',
						CASE WHEN TotalCIObjectsInMillion IS NULL THEN -2 WHEN ISNUMERIC(TotalCIObjectsInMillion) = 1 THEN CAST(TotalCIObjectsInMillion AS INT) ELSE -1 END AS 'Purchased<NumberUnlimitedNA>',
						CAST(0.000001*ISNULL(CIObjects, 0) AS DECIMAL(20,2)) AS 'Used'
				FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			ELSE
			IF @blaggregate = 3 --Endpoint Users Count Usage
				INSERT	INTO @LicenseUsageTbl
				SELECT 	'Users' AS 'License',
						CASE WHEN TotalEndPointUsers IS NULL THEN -2 WHEN ISNUMERIC(TotalEndPointUsers) = 1 THEN CAST(TotalEndPointUsers AS INT) ELSE -1 END AS 'Purchased<NumberUnlimitedNA>',
						ISNULL(EndpointUsers, 0) AS 'Used'
				FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
				UNION ALL
				SELECT	'Sharing Users' AS 'License',
						CASE WHEN TotalSharingUsers IS NULL THEN -2 WHEN ISNUMERIC(TotalSharingUsers) = 1 THEN CAST(TotalSharingUsers AS INT) ELSE -1 END AS 'Purchased<NumberUnlimitedNA>',
						ISNULL(SharingUsers, 0) AS 'Used'
				FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
				UNION ALL
				SELECT	'eDiscovery Users' AS 'License',
						CASE WHEN TotaleDiscoveryUsers IS NULL THEN -2 WHEN ISNUMERIC(TotaleDiscoveryUsers) = 1 THEN CAST(TotaleDiscoveryUsers AS INT) ELSE -1 END AS 'Purchased<NumberUnlimitedNA>',
						ISNULL(eDiscoveryUsers, 0) AS 'Used'
				FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			IF NOT EXISTS (SELECT * FROM #CommServResults WHERE CommCellID <> '-1')
				SELECT	License, Total AS 'Evaluation<NumberUnlimitedNA>', Used
				FROM	@LicenseUsageTbl
			ELSE
				SELECT	License, Total AS 'Purchased<NumberUnlimitedNA>', Used
				FROM	@LicenseUsageTbl
		END
	END
END
ELSE IF @blaggregate = 1
BEGIN
	CREATE TABLE #tmpSurveyCLAInfo (
		CommServUniqueId INT, LogDate DATETIME,
		TotalCompleteSize BIGINT, CompleteSize BIGINT, EvalCompleteSize BIGINT,
		TotalBackupSize BIGINT, BackupSize BIGINT, EvalBackupSize BIGINT,
		TotalArchiveSize BIGINT, ArchiveSize BIGINT, EvalArchiveSize BIGINT,
		TotalSnapshotSize BIGINT, SnapshotSize BIGINT, EvalSnapshotSize BIGINT,
		TotalReplicationSize BIGINT, ReplicationSize BIGINT, EvalReplicationSize BIGINT,
		TotalVMSockets INT, VMSockets INT,
		TotalProtectedVMs INT, ProtectedVMs INT,
--		TotalArchivedVMs INT, ArchivedVMs INT,
		TotalAppClassVMs INT, AppClassVMs INT,
		TotalEndpointUsers INT, EndpointUsers INT,
		TotalSharingUsers INT, SharingUsers INT,
		TotaleDiscoveryUsers INT, eDiscoveryUsers INT,
		TotalArchivedMailBoxes INT, ArchivedMailBoxes INT,
		TotalMBArchivedUsers INT, MBArchivedUsers INT,
		TotalCIObjectsInMillion INT, CIObjects BIGINT
	)
	INSERT INTO #tmpSurveyCLAInfo
	SELECT
		CommServUniqueId, LogDate,
		CASE WHEN CommvaultCompleteEnabled <=0 THEN -1 WHEN ISNULL(TotalBackupSize, 0) >= 0 THEN ISNULL(TotalBackupSize, 0) WHEN @i_CommServUniqueID = 0 THEN ISNULL(BackupSize, 0) ELSE -1 END,
		CASE WHEN CommvaultCompleteEnabled <=0 THEN 0  ELSE ISNULL(BackupSize, 0) END,
		CASE WHEN CommvaultCompleteEnabled <=0 THEN 0  WHEN ISNULL(EvalBackupExpiry, '1970-01-01') <= '1970-01-01' OR ISNULL(EvalBackupExpiry, '1970-01-01') > @now THEN ISNULL(EvalBackupSizeMB, 0) ELSE 0 END,
		CASE WHEN CommvaultCompleteEnabled > 0 THEN -1 WHEN ISNULL(TotalBackupSize, 0) >= 0 THEN ISNULL(TotalBackupSize, 0) WHEN @i_CommServUniqueID = 0 THEN ISNULL(BackupSize, 0) ELSE -1 END,
		CASE WHEN CommvaultCompleteEnabled > 0 THEN 0  ELSE ISNULL(BackupSize, 0) END,
		CASE WHEN CommvaultCompleteEnabled > 0 THEN 0  WHEN ISNULL(EvalBackupExpiry, '1970-01-01') <= '1970-01-01' OR ISNULL(EvalBackupExpiry, '1970-01-01') > @now THEN ISNULL(EvalBackupSizeMB, 0) ELSE 0 END,
		CASE WHEN CommvaultCompleteEnabled > 0 THEN -1 WHEN ISNULL(TotalArchiveSize, 0) >= 0 THEN ISNULL(TotalArchiveSize, 0) WHEN @i_CommServUniqueID = 0 THEN ISNULL(ArchiveSize, 0) ELSE -1 END,
		CASE WHEN CommvaultCompleteEnabled > 0 THEN 0  ELSE ISNULL(ArchiveSize, 0) END,
		CASE WHEN CommvaultCompleteEnabled > 0 THEN 0  WHEN ISNULL(EvalArchiveExpiry, '1970-01-01') <= '1970-01-01' OR ISNULL(EvalArchiveExpiry, '1970-01-01') > @now THEN ISNULL(EvalArchiveSizeMB, 0) ELSE 0 END,
		CASE WHEN ISNULL(TotalSnapshotSize, 0) >= 0 THEN ISNULL(TotalSnapshotSize, 0) WHEN @i_CommServUniqueID = 0 THEN ISNULL(SnapshotSize, 0) ELSE -1 END, ISNULL(SnapshotSize, 0),
		CASE WHEN ISNULL(EvalSnapshotExpiry, '1970-01-01') <= '1970-01-01' OR ISNULL(EvalSnapshotExpiry, '1970-01-01') > @now THEN ISNULL(EvalSnapshotSizeMB, 0) ELSE 0 END,
		CASE WHEN ISNULL(TotalReplicationSize, 0) >= 0 THEN ISNULL(TotalReplicationSize, 0) WHEN @i_CommServUniqueID = 0 THEN ISNULL(ReplicationSize, 0) ELSE -1 END, ISNULL(ReplicationSize, 0),
		CASE WHEN ISNULL(EvalReplicationExpiry, '1970-01-01') <= '1970-01-01' OR ISNULL(EvalReplicationExpiry, '1970-01-01') > @now THEN ISNULL(EvalReplicationSizeMB, 0) ELSE 0 END,
		CASE WHEN TotalVMSockets IS NULL THEN 0 WHEN ISNUMERIC(TotalVMSockets) = 1 THEN TotalVMSockets WHEN @i_CommServUniqueID = 0 THEN ISNULL(VMSockets, 0) ELSE -1 END, ISNULL(VMSockets, 0),
		CASE WHEN TotalProtectedVMs IS NULL THEN 0 WHEN ISNUMERIC(TotalProtectedVMs) = 1 THEN TotalProtectedVMs WHEN @i_CommServUniqueID = 0 THEN ISNULL(ProtectedVMs, 0) ELSE -1 END, ISNULL(ProtectedVMs, 0),
--		CASE WHEN TotalArchivedVMs IS NULL THEN 0 WHEN ISNUMERIC(TotalArchivedVMs) = 1 THEN TotalArchivedVMs WHEN @i_CommServUniqueID = 0 THEN ISNULL(ArchivedVMs, 0) ELSE -1 END, ISNULL(ArchivedVMs, 0),
		CASE WHEN TotalAppClassVMs IS NULL THEN 0 WHEN ISNUMERIC(TotalAppClassVMs) = 1 THEN TotalAppClassVMs WHEN @i_CommServUniqueID = 0 THEN ISNULL(AppClassVMs, 0) ELSE -1 END, ISNULL(AppClassVMs, 0),
		CASE WHEN TotalEndpointUsers IS NULL THEN 0 WHEN ISNUMERIC(TotalEndpointUsers) = 1 THEN TotalEndpointUsers WHEN @i_CommServUniqueID = 0 THEN ISNULL(EndpointUsers, 0) ELSE -1 END, ISNULL(EndpointUsers, 0),
		CASE WHEN TotalSharingUsers IS NULL THEN 0 WHEN ISNUMERIC(TotalSharingUsers) = 1 THEN TotalSharingUsers WHEN @i_CommServUniqueID = 0 THEN ISNULL(SharingUsers, 0) ELSE -1 END, ISNULL(SharingUsers, 0),
		CASE WHEN TotaleDiscoveryUsers IS NULL THEN 0 WHEN ISNUMERIC(TotaleDiscoveryUsers) = 1 THEN TotaleDiscoveryUsers WHEN @i_CommServUniqueID = 0 THEN ISNULL(eDiscoveryUsers, 0) ELSE -1 END, ISNULL(eDiscoveryUsers, 0),
		CASE WHEN TotalArchivedMailBoxes IS NULL THEN 0 WHEN ISNUMERIC(TotalArchivedMailBoxes) = 1 THEN TotalArchivedMailBoxes WHEN @i_CommServUniqueID = 0 THEN ISNULL(ArchivedMailBoxes, 0) ELSE -1 END, ISNULL(ArchivedMailBoxes, 0),
		CASE WHEN TotalMBArchivedUsers IS NULL THEN 0 WHEN ISNUMERIC(TotalMBArchivedUsers) = 1 THEN TotalMBArchivedUsers WHEN @i_CommServUniqueID = 0 THEN ISNULL(MBArchivedUsers, 0) ELSE -1 END, ISNULL(MBArchivedUsers, 0),
		CASE WHEN TotalCIObjectsInMillion IS NULL THEN 0 WHEN ISNUMERIC(TotalCIObjectsInMillion) = 1 THEN TotalCIObjectsInMillion WHEN @i_CommServUniqueID = 0 THEN ISNULL(CIObjects, 0) ELSE -1 END, ISNULL(CIObjects, 0)
	FROM
		cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK)
		INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
	DECLARE @CommCellCount BIGINT = 0
	DECLARE @LatestLogDate DATETIME
	SELECT 	@CommCellCount = COUNT(DISTINCT CommServUniqueId), @LatestLogDate = MAX(LogDate)
	FROM	#tmpSurveyCLAInfo
	DECLARE @AggrResultTempTable TABLE (LogDate DATETIME,
		TotalCompleteSize BIGINT, CompleteSize BIGINT, EvalCompleteSize BIGINT, CurrCompleteSize BIGINT,
		TotalBackupSize BIGINT, BackupSize BIGINT, EvalBackupSize BIGINT, CurrBackupSize BIGINT,
		TotalArchiveSize BIGINT, ArchiveSize BIGINT, EvalArchiveSize BIGINT, CurrArchiveSize BIGINT,
		TotalSnapshotSize BIGINT, SnapshotSize BIGINT, EvalSnapshotSize BIGINT, CurrSnapshotSize BIGINT,
		TotalReplicationSize BIGINT, ReplicationSize BIGINT, EvalReplicationSize BIGINT, CurrReplicationSize BIGINT,
		TotalVMSockets INT, VMSockets INT, CurrVMSockets INT,
		TotalProtectedVMs INT, ProtectedVMs INT, CurrProtectedVMs INT,
--		TotalArchivedVMs INT, ArchivedVMs INT, CurrArchivedVMs INT,
		TotalAppClassVMs INT, AppClassVMs INT, CurrAppClassVMs INT,
		TotalEndpointUsers INT, EndpointUsers INT, CurrEndpointUsers INT,
		TotalSharingUsers INT, SharingUsers INT, CurrSharingUsers INT,
		TotaleDiscoveryUsers INT, eDiscoveryUsers INT, CurreDiscoveryUsers INT,
		TotalArchivedMailBoxes INT, ArchivedMailBoxes INT, CurrArchivedMailBoxes INT,
		TotalMBArchivedUsers INT, MBArchivedUsers INT, CurrMBArchivedUsers INT,
		TotalCIObjectsInMillion INT, CIObjects BIGINT, CurrCIObjects BIGINT
		)
	IF @blLatestSurvey = 0
	BEGIN
		DECLARE @FromMonth DATE = DATEADD(MONTH, DATEDIFF(MONTH, 0, @LatestLogDate)-@i_monthsOfTrend, 0)
		INSERT INTO @AggrResultTempTable
		SELECT
			P.MonthStart,
			T.TotalCompleteSize, P.CompleteSize, T.EvalCompleteSize, T.CurrCompleteSize,
			T.TotalBackupSize, P.BackupSize, T.EvalBackupSize, T.CurrBackupSize,
			T.TotalArchiveSize, P.ArchiveSize, T.EvalArchiveSize, T.CurrArchiveSize,
			T.TotalSnapshotSize, P.SnapshotSize, T.EvalSnapshotSize, T.CurrSnapshotSize,
			T.TotalReplicationSize, P.ReplicationSize, T.EvalReplicationSize, T.CurrReplicationSize,
			T.TotalVMSockets, P.VMSockets, T.CurrVMSockets,
			T.TotalProtectedVMs, P.ProtectedVMs, T.CurrProtectedVMs,
--			T.TotalArchivedVMs, P.ArchivedVMs, T.CurrArchivedVMs,
			T.TotalAppClassVMs, P.AppClassVMs, T.CurrAppClassVMs,
			T.TotalEndpointUsers, P.EndpointUsers, T.CurrEndpointUsers,
			T.TotalSharingUsers, P.SharingUsers, T.CurrSharingUsers,
			T.TotaleDiscoveryUsers, P.eDiscoveryUsers, T.CurreDiscoveryUsers,
			T.TotalArchivedMailBoxes, P.ArchivedMailBoxes, T.CurrArchivedMailBoxes,
			T.TotalMBArchivedUsers, P.MBArchivedUsers, T.CurrMBArchivedUsers,
			T.TotalCIObjectsInMillion, P.CIObjects, T.CurrCIObjects
		FROM
			(SELECT	MonthStart,
					SUM(CASE WHEN CommvaultCompleteEnabled <=0 THEN 0 ELSE ISNULL(BackupSize, 0) + ISNULL(ArchiveSize,0) END) AS CompleteSize,
					SUM(CASE WHEN CommvaultCompleteEnabled > 0 THEN 0 ELSE ISNULL(BackupSize, 0) END) AS BackupSize,
					SUM(CASE WHEN CommvaultCompleteEnabled > 0 THEN 0 ELSE ISNULL(ArchiveSize,0) END) AS ArchiveSize,
					SUM(ISNULL(SnapshotSize, 0)) AS SnapshotSize,
					SUM(ISNULL(ReplicationSize, 0)) AS ReplicationSize,
					SUM(ISNULL(VMSockets, 0)) AS VMSockets,
					SUM(ISNULL(ProtectedVMs, 0)) ProtectedVMs,
--					SUM(ISNULL(ArchivedVMs, 0)) ArchivedVMs,
					SUM(ISNULL(AppClassVMs, 0)) AppClassVMs,
					SUM(ISNULL(EndpointUsers, 0)) AS EndpointUsers,
					SUM(ISNULL(SharingUsers, 0)) AS SharingUsers,
					SUM(ISNULL(eDiscoveryUsers, 0)) eDiscoveryUsers,
					SUM(ISNULL(ArchivedMailBoxes, 0)) AS ArchivedMailBoxes,
					SUM(ISNULL(MBArchivedUsers, 0)) AS MBArchivedUsers,
					SUM(ISNULL(CIObjects, 0)) AS CIObjects
			FROM	cf_SurveyCapacityLicensePeakUsage U WITH (NOLOCK)
					INNER JOIN #CommServResults AS R ON U.CommServUniqueId = R.CommServUniqueId
			WHERE	U.MonthStart >= @FromMonth
			GROUP BY MonthStart
			) AS P,
			(SELECT	SUM(TotalCompleteSize) AS TotalCompleteSize, SUM(EvalCompleteSize) AS EvalCompleteSize, SUM(CompleteSize) AS CurrCompleteSize,
					SUM(TotalBackupSize) AS TotalBackupSize, SUM(EvalBackupSize) AS EvalBackupSize, SUM(BackupSize) AS CurrBackupSize,
					SUM(TotalArchiveSize) AS TotalArchiveSize, SUM(EvalArchiveSize) AS EvalArchiveSize, SUM(ArchiveSize) AS CurrArchiveSize,
					SUM(TotalSnapshotSize) AS TotalSnapshotSize, SUM(EvalSnapshotSize) AS EvalSnapshotSize, SUM(SnapshotSize) AS CurrSnapshotSize,
					SUM(TotalReplicationSize) AS TotalReplicationSize, SUM(EvalReplicationSize) AS EvalReplicationSize, SUM(ReplicationSize) AS CurrReplicationSize,
					SUM(TotalVMSockets) AS TotalVMSockets, SUM(VMSockets) AS CurrVMSockets,
					SUM(TotalProtectedVMs) AS TotalProtectedVMs, SUM(ProtectedVMs) AS CurrProtectedVMs,
--					SUM(TotalArchivedVMs) AS TotalArchivedVMs, SUM(ArchivedVMs) AS CurrArchivedVMs,
					SUM(TotalAppClassVMs) AS TotalAppClassVMs, SUM(AppClassVMs) AS CurrAppClassVMs,
					SUM(TotalEndpointUsers) AS TotalEndpointUsers, SUM(EndpointUsers) AS CurrEndpointUsers,
					SUM(TotalSharingUsers) AS TotalSharingUsers, SUM(SharingUsers) AS CurrSharingUsers,
					SUM(TotaleDiscoveryUsers) AS TotaleDiscoveryUsers, SUM(eDiscoveryUsers) AS CurreDiscoveryUsers,
					SUM(TotalArchivedMailBoxes) AS TotalArchivedMailBoxes, SUM(ArchivedMailBoxes) AS CurrArchivedMailBoxes,
					SUM(TotalMBArchivedUsers) AS TotalMBArchivedUsers, SUM(MBArchivedUsers) AS CurrMBArchivedUsers,
					SUM(TotalCIObjectsInMillion) AS TotalCIObjectsInMillion, SUM(CIObjects) AS CurrCIObjects
			FROM	#tmpSurveyCLAInfo
			) AS T
		ORDER BY P.MonthStart
	END
	ELSE
		INSERT INTO @AggrResultTempTable
		SELECT
			@LatestLogDate,
			SUM(TotalCompleteSize), 0, SUM(EvalCompleteSize), SUM(CompleteSize),
			SUM(TotalBackupSize), 0, SUM(EvalBackupSize), SUM(BackupSize),
			SUM(TotalArchiveSize), 0, SUM(EvalArchiveSize), SUM(ArchiveSize),
			SUM(TotalSnapshotSize), 0, SUM(EvalSnapshotSize), SUM(SnapshotSize),
			SUM(TotalReplicationSize), 0, SUM(EvalReplicationSize), SUM(ReplicationSize),
			SUM(TotalVMSockets), 0, SUM(VMSockets),
			SUM(TotalProtectedVMs), 0, SUM(ProtectedVMs),
--			SUM(TotalArchivedVMs), 0, SUM(ArchivedVMs),
			SUM(TotalAppClassVMs), 0, SUM(AppClassVMs),
			SUM(TotalEndpointUsers), 0, SUM(EndpointUsers),
			SUM(TotalSharingUsers), 0, SUM(SharingUsers),
			SUM(TotaleDiscoveryUsers), 0, SUM(eDiscoveryUsers),
			SUM(TotalArchivedMailBoxes), 0, SUM(ArchivedMailBoxes),
			SUM(TotalMBArchivedUsers), 0, SUM(MBArchivedUsers),
			SUM(TotalCIObjectsInMillion), 0, SUM(CIObjects)
		FROM #tmpSurveyCLAInfo
	IF @isPrivate = 1 AND EXISTS (SELECT * FROM cf_SurveyClientGroupQuotaUsage WITH (NOLOCK) WHERE ClientGroupName = 'CommCell Inherited Capacity' AND QuotaEnabled = 7)
	BEGIN
		UPDATE	T SET TotalBackupSize = ISNULL([100002],0)*1024, TotalArchiveSize = ISNULL([100004],0)*1024,
				TotalSnapshotSize = ISNULL([100005],0)*1024, TotalReplicationSize = ISNULL([100006],0)*1024,
				TotalArchivedMailBoxes = ISNULL([100013],0), TotalCIObjectsInMillion = ISNULL([100017],0)/1000000,
				TotalVMSockets = ISNULL([100018],0), TotalProtectedVMs = ISNULL([100019],0), --TotalArchivedVMs = ISNULL([100021],0),
				TotalAppClassVMs = ISNULL([100027],0), TotalMBArchivedUsers = ISNULL([100028],0),
				TotalEndpointUsers = ISNULL([100024],0), TotalSharingUsers = ISNULL([100025],0), TotaleDiscoveryUsers = ISNULL([100026],0)
		FROM	@AggrResultTempTable T,
				(SELECT	QuotaType, QuotaLimitGB
				FROM	cf_SurveyClientGroupQuotaUsage Q WITH (NOLOCK)
						INNER JOIN cf_CommservSurveyResults R WITH (NOLOCK) ON Q.SurveyResultId = R.CommservSurveyResults_ID AND R.Flags = 1
				WHERE	Q.ClientGroupName = 'CommCell Inherited Capacity' AND Q.QuotaEnabled = 7
				) S
				PIVOT	(MAX(QuotaLimitGB) FOR QuotaType IN ([100002],[100004],[100005],[100006],[100013],[100017],[100018],[100019],[100024],[100025],[100026],[100027],[100028])
				) AS P
	END
	DECLARE @AggrResultTable TABLE (ID INT, Name VARCHAR(256), LogDate DATETIME, Total FLOAT, Eval FLOAT, Peak FLOAT, Used FLOAT, MonthlyGrowthTB FLOAT)
	IF @blLatestSurvey = 1 -- Total Capacity Usage bar chart
	BEGIN
		INSERT INTO @AggrResultTable
			SELECT	0, 'Commvault Complete', LogDate, TotalCompleteSize/(1024.0*1024.0), EvalCompleteSize/(1024.0*1024.0), CompleteSize/(1024.0*1024.0), CurrCompleteSize/(1024.0*1024.0), NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	1, 'Backup', LogDate, TotalBackupSize/(1024.0*1024.0), EvalBackupSize/(1024.0*1024.0), BackupSize/(1024.0*1024.0), CurrBackupSize/(1024.0*1024.0), NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	2, 'Archive', LogDate, TotalArchiveSize/(1024.0*1024.0), EvalArchiveSize/(1024.0*1024.0), ArchiveSize/(1024.0*1024.0), CurrArchiveSize/(1024.0*1024.0), NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	10, 'Snapshot', LogDate, TotalSnapshotSize/(1024.0*1024.0), EvalSnapshotSize/(1024.0*1024.0), SnapshotSize/(1024.0*1024.0), CurrSnapshotSize/(1024.0*1024.0), NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	11, 'Replication', LogDate, TotalReplicationSize/(1024.0*1024.0), EvalReplicationSize/(1024.0*1024.0), ReplicationSize/(1024.0*1024.0), CurrReplicationSize/(1024.0*1024.0), NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	3, 'VM Sockets', LogDate, TotalVMSockets, 0.0, VMSockets, CurrVMSockets, NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	4, 'Protected VMs', LogDate, TotalProtectedVMs, 0.0, ProtectedVMs, CurrProtectedVMs, NULL
			FROM	@AggrResultTempTable
--		UNION ALL
--			SELECT	13, 'Archived VMs', LogDate, TotalArchivedVMs, 0.0, ArchivedVMs, CurrArchivedVMs, NULL
--			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	14, 'Application Class Virtual', LogDate, TotalAppClassVMs, 0.0, AppClassVMs, CurrAppClassVMs, NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	12, 'Devices', MAX(R.LogDate), ISNULL(SUM(U.PermLicensesIssued),0), 0.0, ISNULL(SUM(U.PermLicensesUsed),0), ISNULL(SUM(U.PermLicensesUsed),0), NULL
			FROM	cf_SurveyAgentLicenseUsage AS U WITH (NOLOCK)
					INNER JOIN dbo.cf_SurveyResultFuncV1(3, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId) AS R
					ON R.SurverResultId = U.SurveyResultId AND U.TypeId = 2
		UNION ALL
			SELECT	5, 'Users', LogDate, TotalEndpointUsers, 0.0, EndpointUsers, CurrEndpointUsers, NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	6, 'Sharing Users', LogDate, TotalSharingUsers, 0.0, SharingUsers, CurrSharingUsers, NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	7, 'eDiscovery Users', LogDate, TotaleDiscoveryUsers, 0.0, eDiscoveryUsers, CurreDiscoveryUsers, NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	8, 'Archived MailBoxes', LogDate, TotalArchivedMailBoxes, 0.0,  ArchivedMailBoxes, CurrArchivedMailBoxes, NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	9, 'CI Objects', LogDate, TotalCIObjectsInMillion, 0.0, 0.000001*CIObjects, 0.000001*CurrCIObjects, NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	15, 'Mailbox Archive Solution', LogDate, TotalMBArchivedUsers, 0.0, MBArchivedUsers, CurrMBArchivedUsers, NULL
			FROM	@AggrResultTempTable
		SELECT	@CommCellCount AS 'CommCell Count',
				Name,
				ROUND(Total+Eval, 2) AS Total,
				ROUND(Used, 2) AS Used,
				CASE CAST(Total+Eval AS INT)
					WHEN 0 THEN 0
					WHEN -1 THEN 100
					ELSE CAST (ROUND((Used*100)/(Total+Eval), 2) AS DECIMAL(30, 2))
				END AS PercentUsed,
				@LatestLogDate AS LogDate,
				ROUND(Eval, 2) AS Eval
		FROM	@AggrResultTable
		ORDER BY ID ASC
	END
	ELSE IF @blLatestSurvey = 0 -- Monthly Usage bar chart for a given CommCel
	BEGIN
		INSERT INTO @AggrResultTable
			SELECT	0, 'Commvault Complete', LogDate, TotalCompleteSize/(1024.0*1024.0), EvalCompleteSize/(1024.0*1024.0), CompleteSize/(1024.0*1024.0), CurrCompleteSize/(1024.0*1024.0), NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	1, 'Backup', LogDate, TotalBackupSize/(1024.0*1024.0), EvalBackupSize/(1024.0*1024.0), BackupSize/(1024.0*1024.0), CurrBackupSize/(1024.0*1024.0), NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	2, 'Archive', LogDate, TotalArchiveSize/(1024.0*1024.0), EvalArchiveSize/(1024.0*1024.0), ArchiveSize/(1024.0*1024.0), CurrArchiveSize/(1024.0*1024.0), NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	3, 'Snapshot', LogDate, TotalSnapshotSize/(1024.0*1024.0), EvalSnapshotSize/(1024.0*1024.0), SnapshotSize/(1024.0*1024.0), CurrSnapshotSize/(1024.0*1024.0), NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	4, 'Replication', LogDate, TotalReplicationSize/(1024.0*1024.0), EvalReplicationSize/(1024.0*1024.0), ReplicationSize/(1024.0*1024.0), CurrReplicationSize/(1024.0*1024.0), NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	5, 'VM Sockets', LogDate, TotalVMSockets, 0.0, VMSockets, CurrVMSockets, NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	6, 'Protected VMs', LogDate, TotalProtectedVMs, 0.0, ProtectedVMs, CurrProtectedVMs, NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	7, 'Users', LogDate, (TotalEndpointUsers+TotalSharingUsers+TotaleDiscoveryUsers), 0.0, (EndpointUsers+SharingUsers+eDiscoveryUsers), (CurrEndpointUsers+CurrSharingUsers+CurreDiscoveryUsers), NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	8, 'Archived MailBoxes', LogDate, TotalArchivedMailBoxes, 0.0, ArchivedMailBoxes, CurrArchivedMailBoxes, NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	9, 'CI Objects', LogDate, TotalCIObjectsInMillion, 0.0, 0.000001*CIObjects, 0.000001*CurrCIObjects, NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	10, 'Mailbox Archive Solution', LogDate, TotalMBArchivedUsers, 0.0, MBArchivedUsers, CurrMBArchivedUsers, NULL
			FROM	@AggrResultTempTable
		DECLARE @CurrMonth DATE = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)
		DECLARE	@MaxNumOfMonthsforGrowthRate INT = 6
		CREATE TABLE #GrowthData (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(MAX), X INT, Y FLOAT, SeqId INT) -- for input
		CREATE TABLE #GrowthRate (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(MAX), GrowthRate FLOAT, GrowthStDev FLOAT) -- for output
		INSERT INTO #GrowthData
		SELECT	0, 0, Name, DATEDIFF(MONTH, @CurrMonth, LogDate), Peak, ROW_NUMBER() OVER (PARTITION BY Name ORDER BY LogDate)
		FROM	@AggrResultTable
		WHERE	(DATEDIFF(MONTH, LogDate, @CurrMonth) BETWEEN 1 AND @MaxNumOfMonthsforGrowthRate) AND Used > 0
		EXEC GetLinearGrowthRate 0
		UPDATE	S SET MonthlyGrowthTB = T.GrowthRate
		FROM	@AggrResultTable S
				INNER JOIN #GrowthRate T ON S.Name = T.EntityName
		DROP TABLE #GrowthData
		DROP TABLE #GrowthRate
		IF (@i_csvOutput = 0)
		BEGIN
			SELECT	@CommCellCount AS 'CommCell Count',
					Name,
					RIGHT(convert(varchar, LogDate, 106), 8) AS 'X-Value',
					'DATE' AS 'X-Datatype',
					Used AS 'Y-Value',
					'Percentage' AS 'Y-Datatype',
					CASE WHEN ID < 5 THEN Name + ' - '
						+ CAST(CAST(CASE WHEN CAST(Total+Eval AS INT) = 0 THEN 0 WHEN (Total+Eval) < 0 OR (Total+Eval) < Used THEN 100 ELSE (Used*100)/(Total+Eval) END AS DECIMAL(30, 6)) AS VARCHAR(10)) + '% Used, Total: '
						+ CAST(CAST(Total AS DECIMAL(30, 6)) AS VARCHAR(20)) + ' TB, Peak: '
						+ CAST(CAST(Peak  AS DECIMAL(30, 6)) AS VARCHAR(20)) + ' TB, Growth Rate: '
						+ CAST(CAST(ISNULL(MonthlyGrowthTB, 0)*1024.0/30 AS DECIMAL(30, 6)) AS VARCHAR(20)) + ', Loaned: '
						+ CAST(CAST(Eval  AS DECIMAL(30, 6)) AS VARCHAR(20)) + ' TB, Used: '
						+ CAST(CAST(Used  AS DECIMAL(30, 6)) AS VARCHAR(20)) + ' TB'
					ELSE Name + ' - '
						+ CAST(CAST(CASE WHEN CAST(Total AS INT) = 0 THEN 0 WHEN Total < 0 OR Total < Used THEN 100 ELSE (Used*100)/Total END AS DECIMAL(30, 6)) AS VARCHAR(10)) + '% Used, Total: '
						+ CAST(CAST(Total AS DECIMAL(30, 6)) AS VARCHAR(20)) + ', Peak: '
						+ CAST(CAST(Peak  AS DECIMAL(30, 6)) AS VARCHAR(20)) + ', Growth Rate: '
						+ CAST(CAST(ISNULL(MonthlyGrowthTB, 0)/30 AS DECIMAL(30, 6)) AS VARCHAR(20)) + ', Used: '
						+ CAST(CAST(Used  AS DECIMAL(30, 6)) AS VARCHAR(20)) END AS 'Label',
					1 AS 'ChartGroup'
			FROM	@AggrResultTable
			ORDER BY Name, LogDate
		END
		ELSE
		BEGIN
			DECLARE	@i			INT = 0
			DECLARE @dtEnd		DATETIME = null
			DECLARE	@dtBegin	DATETIME = null
			DECLARE	@predictionM	DATETIME = null
				IF object_id('tempdb.dbo.#MonthlyTbl') is not null DROP TABLE #MonthlyTbl
				CREATE TABLE #MonthlyTbl (monthVal date, MonthBeginDT DATETIME, MonthEndDT DATETIME)
				SET @dtBegin	= DATEADD(MONTH, DATEDIFF(MONTH, 0, (select ISNULL(max (logdate),GETDATE()) from @AggrResultTable)), 0)
				set @predictionM = @dtBegin
				SET @dtEnd	= DATEADD(MONTH, 1, @dtBegin)
				SET @i = 0
				WHILE @i < @i_monthsOfTrend
				BEGIN
					INSERT	INTO #MonthlyTbl
					SELECT	@dtBegin, @dtBegin, @dtEnd
					SET @dtEnd	 = @dtBegin
					SET @dtBegin = DATEADD(MONTH, -1, @dtEnd)
					SET @i = (@i + 1)
				END
				CREATE TABLE #MonthlyDATA (monthVal date,VALUE  DECIMAL(30, 2),Name VARCHAR(256),[ID<DONOTSHOW>] INT,)
				INSERT INTO #MonthlyDATA
				SELECT M.monthVal, r.Peak, r.name + CASE WHEN ID IN (0,1,2,3,4) THEN ' (TB)' WHEN ID = 9 THEN ' (million)' ELSE '' END, r.ID
				FROM #MonthlyTbl M LEFT OUTER JOIN
				@AggrResultTable r on
				M.monthVal= r.LogDate
				INSERT INTO #MonthlyDATA
				SELECT r.LogDate, r.total, r.name +  CASE WHEN ID IN (0,1,2,3,4) THEN ' Purchased (TB)' WHEN ID = 9 THEN ' Purchased (million)' ELSE ' Purchased' END, r.ID
				FROM #MonthlyTbl M INNER JOIN
				@AggrResultTable r on
				M.monthVal= r.LogDate
				DECLARE @cols AS NVARCHAR(MAX),
					@query  AS NVARCHAR(MAX)
				select @cols = STUFF((SELECT  ',' + QUOTENAME(RIGHT(convert(varchar,monthVal, 106), 8))
									from (select distinct monthVal from #MonthlyDATA) as p
									order by monthVal asc
							FOR XML PATH(''), TYPE
							).value('.', 'NVARCHAR(MAX)')
						,1,1,'')
			set @query = 'SELECT [ID<DONOTSHOW>],Name,' + @cols + ' into #outdata from
						 (
							select value, [monthVal], NAME,[ID<DONOTSHOW>]
							from #MonthlyDATA
						) x
						pivot
						(
							max(value)
							for monthVal in (' + @cols + ')
						) p
			select * from #outdata    WHERE [ID<DONOTSHOW>] IS NOT NULL  order by [ID<DONOTSHOW>]       '
			exec          sp_executesql @query
				drop table #MonthlyDATA
				drop table #MonthlyTbl
	END
	END
	IF (OBJECT_ID('tempdb.dbo.#tmpSurveyCLAInfo') IS NOT NULL)
		DROP TABLE #tmpSurveyCLAInfo
END
DROP TABLE #CommServResults
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptCapacityLicenseSurvey')
	delete from GxQscripts where name = 'RptCapacityLicenseSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCapacityLicenseSurvey')
	delete from GXDBVersions where aliasname = 'RptCapacityLicenseSurvey'
GO

insert into GXDBVersions values(2, 'RptCapacityLicenseSurvey',  '00010022000200370000', 'RptCapacityLicenseSurvey', '00010022000200370000')
GO

