

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptClientAudit.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptClientAudit.sp,v $ $Id: RptClientAudit.sp,v 1.1.2.9 2020/12/17 02:52:02 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptClientAudit')
BEGIN
	print '>>> Drop Stored Procedure: RptClientAudit <<<'
	drop procedure RptClientAudit
END
IF EXISTS (select * from GxQscripts where name='RptClientAudit')
	delete from GxQscripts where name = 'RptClientAudit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptClientAudit')
	delete from GXDBVersions where aliasname = 'RptClientAudit'
GO
print '... Creating Procedure: RptClientAudit'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptClientAudit
  @i_UserID INT = NULL,
  @i_GroupID INT = NULL,
  @i_Aggregate INT = 1,
  @i_stdCommServUniqueID INT = 0,
  @i_stdClientID INT = 0,
  @i_stdAppTypeID INT = 0,
  @i_stdInstanceID INT = 0,
  @i_stdBackupsetID INT = 0,
  @i_stdAppID INT = 0,
  @i_CommServUniqueID INT = 0,
  @i_ClientGroupName NVARCHAR(512) = '',
  @i_PropertyGroup VARCHAR(32) = '',
  @i_Flags INT = 0
AS
SET NOCOUNT ON
DECLARE @i_QueryID BIGINT = 180
IF	@i_stdCommServUniqueID = 0
	RETURN
-- default is for all properties
DECLARE @i_Category INT = 0
IF		@i_PropertyGroup = 'Passed Audit'
	SET @i_Category = -1
ELSE IF	@i_PropertyGroup = 'Client'
	SET @i_Category = 1
ELSE IF	@i_PropertyGroup = 'Network'
	SET @i_Category = 2
ELSE IF	@i_PropertyGroup = 'Agent'
	SET @i_Category = 3
ELSE IF	@i_PropertyGroup = 'Instance'
	SET @i_Category = 4
ELSE IF	@i_PropertyGroup = 'Backupset'
	SET @i_Category = 5
ELSE IF	@i_PropertyGroup = 'Subclient'
	SET @i_Category = 6
DECLARE	@STORAGE_POLICY_DIFF_FLAG	INT = 1
DECLARE	@ACROSS_CLIENT_TYPES_FLAG	INT = 2
DECLARE	@COUNT_CHILD_ENTITIES_FLAG	INT = 4
DECLARE	@StoragePolicyDiff	INT = (@i_Flags & @STORAGE_POLICY_DIFF_FLAG)
DECLARE	@AcrossClientTypes	INT = (@i_Flags & @ACROSS_CLIENT_TYPES_FLAG)
DECLARE	@CountChildEntities	INT = (@i_Flags & @COUNT_CHILD_ENTITIES_FLAG)
-- StoragePolicyDiff option only applies for subclients in the template CommCell
IF	@i_CommServUniqueID > 0 AND @i_CommServUniqueID <> @i_stdCommServUniqueID
	SET @StoragePolicyDiff = 0
DECLARE @stdCustomerName	VARCHAR(256) = ''
DECLARE @isPrivate 			INT = 0
SELECT	@isPrivate = ISNULL(CAST(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
IF	@isPrivate = 0
	SELECT @stdCustomerName = CustomerName FROM cf_CommcellIdNameMap WHERE ID = @i_stdCommServUniqueID
IF OBJECT_ID('tempdb.dbo.#LatestResult') IS NOT NULL DROP TABLE #LatestResult
CREATE TABLE #LatestResult (CommServId INT, SurveyResultId BIGINT, LogDate DATETIME)
INSERT	INTO #LatestResult
SELECT	CommServUniqueId, SurverResultId, LogDate
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryID, 0, 1, NULL, NULL, @i_UserID, @i_GroupID)
WHERE	(@stdCustomerName = '' OR CustomerName = @stdCustomerName)
	AND (@i_CommServUniqueID = 0 OR CommServUniqueId IN (@i_stdCommServUniqueID, @i_CommServUniqueID))
DECLARE @stdSurveyResultID BIGINT = (SELECT SurveyResultId FROM #LatestResult WHERE CommServId = @i_stdCommServUniqueID)
DECLARE @stdClientType VARCHAR(32) = ''
IF	@i_stdClientID > 0
	SELECT	@stdClientType = ParamValue
	FROM	cf_SurveyClientProp
	WHERE	SurveyResultId = @stdSurveyResultID AND ClientId = @i_stdClientID AND Category = 1 AND ParamName = 'Client Type'
IF	@i_Aggregate = -1 -- specify template client/subclient
BEGIN
	IF	@i_stdClientID = 0
		SELECT	S.CommServUniqueId	AS [CommServ UniqueId],
				S.ClientId			AS [Client ID],
				ISNULL (CL.ClientDisplayName, S.clientName) AS [Client Name],
				S.clientName  AS [Client(classic)<HIDDEN>],
				P.ParamValue		AS [Client Type]
		FROM	cf_SurveyClientProp P
				INNER JOIN (
					SELECT	DISTINCT CommServUniqueId, ClientId, ClientName
					FROM	cf_SurveySubclientAssociation
					WHERE	CommServUniqueId = @i_stdCommServUniqueID
				) S ON P.ClientId = S.ClientId
				LEFT JOIN cf_SurveyClient CL WITH (NOLOCK)
				ON CL.CommServUniqueId = S.CommServUniqueId  AND CL.ClientId = S.ClientId
		WHERE	P.SurveyResultId = @stdSurveyResultID AND P.Category = 1 AND P.ParamName = 'Client Type' AND P.AppTypeId = 0
		ORDER BY [Client Name]
	ELSE
		SELECT	S.CommServUniqueId	AS [CommServ UniqueId],
				S.ClientId			AS [Client ID],
				ISNULL (CL.ClientDisplayName, S.clientName) AS [Client Name],
				S.clientName  AS [Client(classic)<HIDDEN>],
				@stdClientType		AS [Client Type],
				S.AppTypeId			AS [AppType ID],
				CASE WHEN T.AppTypeId = 0 THEN '' ELSE AT.displayName END
									AS [Agent Name],
				S.InstanceId		AS [Instance ID],
				CASE WHEN T.InstanceId = 0 THEN '' ELSE S.InstanceName END
									AS [Instance Name],
				S.BackupsetId		AS [Backupset ID],
				CASE WHEN T.BackupsetId = 0 THEN '' ELSE S.BackupsetName END
									AS [Backupset Name],
				S.AppId				AS [App ID],
				CASE WHEN T.AppId = 0 THEN '' ELSE S.SubclientName END
									AS [Subclient Name]
		FROM	cf_SurveySubclientAssociation S
				INNER JOIN cf_SurveyAgentType AT ON S.AppTypeId = AT.id
				INNER JOIN (
					SELECT	DISTINCT CommServId, ClientId, AppTypeId, InstanceId, BackupsetId, AppId
					FROM	cf_SurveyClientProp P
							INNER JOIN #LatestResult R ON P.SurveyResultId = R.SurveyResultId AND P.AppTypeId > 0
					WHERE	P.SurveyResultId = @stdSurveyResultID AND P.ClientId = @i_stdClientID
				) T ON  T.CommServId = S.CommServUniqueId AND T.ClientId = S.ClientId
					AND T.AppTypeId IN (S.AppTypeId, 0) AND T.InstanceId IN (S.InstanceId, 0)
					AND T.BackupsetId IN (S.BackupsetId, 0) AND T.AppId IN (S.AppId, 0)
				LEFT JOIN cf_SurveyClient CL WITH (NOLOCK)
					ON CL.CommServUniqueId = S.CommServUniqueId  AND CL.ClientId = S.ClientId
					ORDER BY [Client Name], [Agent Name], [Instance Name], [Backupset Name], [Subclient Name]
	DROP TABLE #LatestResult
	RETURN
END
ELSE
IF	@i_Aggregate = -2 -- specify client group name
BEGIN
	SELECT	DISTINCT CG.ClientGroupId AS [Client Group ID], CG.ClientGroupName AS [Client Group Name]
	FROM	cf_SurveyClientGroup CG
			INNER JOIN cf_SurveyClientGroupAssociation CGA ON CG.CommservUniqueId = CGA.CommservUniqueId AND CG.ClientGroupId = CGA.ClientGroupId
			INNER JOIN (
				SELECT	DISTINCT R.commservId, P.ClientId
				FROM	cf_SurveyClientProp P INNER JOIN #LatestResult R ON P.SurveyResultId = R.SurveyResultId
			) CL ON CGA.CommservUniqueId = CL.commservId AND CGA.ClientId = CL.ClientId
	ORDER BY [Client Group Name]
	RETURN
END
-- Get subclients of the template client
IF OBJECT_ID('tempdb.dbo.#stdEntities') IS NOT NULL DROP TABLE #stdEntities
CREATE TABLE #stdEntities (AppTypeId INT, AppTypeName VARCHAR(256), InstanceId INT, InstanceName NVARCHAR(512),
		BackupsetId INT, BackupsetName NVARCHAR(128), AppId INT, SubclientStatus INT, SubclientName NVARCHAR(256), SubclientType VARCHAR(32))
INSERT	INTO #stdEntities
SELECT	S.AppTypeId, AT.displayName, S.InstanceId, S.InstanceName, S.BackupsetId, S.BackupsetName, S.AppId, S.SubclientStatus, S.SubclientName, P.ParamValue
FROM	cf_SurveyClientProp P
		INNER JOIN cf_SurveySubclientAssociation S
			ON S.CommservUniqueId = @i_stdCommServUniqueID AND S.ClientId = P.ClientId AND S.AppId = P.AppId
		INNER JOIN cf_SurveyAgentType AT ON S.AppTypeId = AT.id
WHERE	P.SurveyResultId = @stdSurveyResultID AND P.ClientId = @i_stdClientID
	AND @i_stdAppTypeID IN (S.AppTypeId, 0) AND @i_stdInstanceID IN (S.InstanceId, 0)
	AND @i_stdBackupsetID IN (S.BackupsetId, 0) AND @i_stdAppID IN (S.AppId, 0)
	AND P.Category = 6 AND P.ParamName = 'Subclient Type'
-- Get subclients of the comparing clients
IF OBJECT_ID('tempdb.dbo.#SubclientList') IS NOT NULL DROP TABLE #SubclientList
CREATE TABLE #SubclientList (SurveyResultId BIGINT, CommServId INT, ClientId INT, AppId INT, SubclientType VARCHAR(32))
INSERT	INTO #SubclientList
SELECT	P.SurveyResultId, CL.CommServId, P.ClientId, P.AppId, P.ParamValue
FROM	cf_SurveyClientProp P
		INNER JOIN (
			SELECT	C.SurveyResultId, CommServId, ClientId
			FROM	cf_SurveyClientProp C INNER JOIN #LatestResult L
				 ON C.SurveyResultId = L.SurveyResultId AND Category = 1 AND ParamName = 'Client Type'
					AND (ParamValue = @stdClientType OR @AcrossClientTypes > 0)
			WHERE	C.SurveyResultId <> @stdSurveyResultID OR ClientId <> @i_stdClientID
		) CL ON P.SurveyResultId = CL.SurveyResultId AND P.ClientId = CL.ClientId
			AND P.Category = 6 AND ParamName = 'Subclient Type'
IF OBJECT_ID('tempdb.dbo.#EntityList') IS NOT NULL DROP TABLE #EntityList
CREATE TABLE #EntityList (SurveyResultId BIGINT, CommServId INT, ClientId INT, ClientName NVARCHAR(256), AppTypeId INT, AppTypeName VARCHAR(256),
		InstanceId INT, InstanceName NVARCHAR(512), BackupsetId INT, BackupsetName NVARCHAR(128),
		AppId INT, SubclientName NVARCHAR(256), SubclientStatus INT, SubclientType VARCHAR(32), StdAppId INT)
INSERT	INTO #EntityList
SELECT	T.SurveyResultId, S.CommServUniqueId, S.ClientId, S.ClientName, S.AppTypeId, AT.displayName,
		S.InstanceId, S.InstanceName, S.BackupsetId, S.BackupsetName, S.AppId, S.SubclientName, S.SubclientStatus, SubclientType, 0
FROM	cf_SurveySubclientAssociation S
		INNER JOIN (SELECT id, displayName FROM cf_SurveyAgentType WHERE displayName IN (SELECT DISTINCT AppTypeName FROM #stdEntities)
			) AT ON S.AppTypeId = AT.id
		INNER JOIN #SubclientList T	ON S.CommservUniqueId = T.CommServId AND S.ClientId = T.ClientId AND S.AppId = T.AppId
WHERE	@i_CommServUniqueID IN (S.CommServUniqueId, 0)
CREATE INDEX #EntityList_SurveyResultId_ClientId_idx ON #EntityList (SurveyResultId, ClientId) INCLUDE (CommServId, ClientName)
DROP TABLE #SubclientList
-- Apply client group filter
IF	ISNULL(@i_ClientGroupName, '') <> ''
	DELETE T FROM #EntityList T
			LEFT OUTER JOIN
			(SELECT	CGA.CommServUniqueId, CGA.ClientId
			FROM	cf_SurveyClientGroupAssociation CGA
					INNER JOIN cf_SurveyClientGroup CG ON CGA.CommServUniqueId = CG.CommServUniqueId AND CGA.ClientGroupId = CG.ClientGroupId
					INNER JOIN #LatestResult R ON CGA.CommServUniqueId = R.CommServId
			WHERE CG.ClientGroupName = @i_ClientGroupName
			) S ON T.CommservId = S.CommservUniqueId AND T.ClientId = S.ClientId
	WHERE	S.ClientId IS NULL
-- Set StdAppId
IF (SELECT COUNT(*) FROM #stdEntities) = 1
	UPDATE #EntityList SET StdAppId = (SELECT AppId FROM #stdEntities)
ELSE
BEGIN
	UPDATE	T SET StdAppId = S.AppId
	FROM	#EntityList T INNER JOIN #stdEntities S
			ON T.AppTypeName = S.AppTypeName AND T.InstanceName = S.InstanceName
			AND T.BackupsetName = S.BackupsetName AND T.SubclientName = S.SubclientName
	IF EXISTS (SELECT TOP 1 0 FROM #EntityList WHERE StdAppId = 0)
	UPDATE	T SET StdAppId = S.AppId
	FROM	#EntityList T INNER JOIN
			(SELECT	AppTypeName, InstanceName, BackupsetName, SubclientType, AppId,
					ROW_NUMBER() OVER (PARTITION BY AppTypeName, InstanceName, BackupsetName, SubclientType ORDER BY AppId) AS RowId
			FROM	#stdEntities
			) S ON T.AppTypeName = S.AppTypeName AND T.InstanceName = S.InstanceName
			AND T.BackupsetName = S.BackupsetName AND T.SubclientType = S.SubclientType
	WHERE	T.StdAppId = 0 AND S.RowId = 1
	IF EXISTS (SELECT TOP 1 0 FROM #EntityList WHERE StdAppId = 0)
	UPDATE	T SET StdAppId = S.AppId
	FROM	#EntityList T INNER JOIN
			(SELECT	AppTypeName, InstanceName, SubclientType, AppId,
					ROW_NUMBER() OVER (PARTITION BY AppTypeName, InstanceName, SubclientType ORDER BY AppId) AS RowId
			FROM	#stdEntities
			) S ON T.AppTypeName = S.AppTypeName AND T.InstanceName = S.InstanceName AND T.SubclientType = S.SubclientType
	WHERE	T.StdAppId = 0 AND S.RowId = 1
	IF EXISTS (SELECT TOP 1 0 FROM #EntityList WHERE StdAppId = 0)
	UPDATE	T SET StdAppId = S.AppId
	FROM	#EntityList T INNER JOIN
			(SELECT	AppTypeName, SubclientType, AppId,
					ROW_NUMBER() OVER (PARTITION BY AppTypeName, SubclientType ORDER BY AppId) AS RowId
			FROM	#stdEntities
			) S ON T.AppTypeName = S.AppTypeName AND T.SubclientType = S.SubclientType
	WHERE	T.StdAppId = 0 AND S.RowId = 1
END
IF OBJECT_ID('tempdb.dbo.#TempParams') IS NOT NULL DROP TABLE #TempParams
CREATE TABLE #TempParams (
	CommServId INT, ClientId INT, ClientName NVARCHAR(256), AppTypeId INT, AppTypeName VARCHAR(256), InstanceId INT, InstanceName NVARCHAR(512),
	BackupsetId INT, BackupsetName NVARCHAR(128), AppId INT, SubclientName NVARCHAR(256), SubclientType VARCHAR(32),
	Property VARCHAR(64), ParamName NVARCHAR(1024), ParamValue NVARCHAR(MAX), DefaultValue NVARCHAR(MAX)
)
IF OBJECT_ID('tempdb.dbo.#DiffParams') IS NOT NULL DROP TABLE #DiffParams
CREATE TABLE #DiffParams (
	CommServId INT, ClientId INT, ClientName NVARCHAR(256), AppTypeId INT, AppTypeName VARCHAR(256), InstanceId INT, InstanceName NVARCHAR(512),
	BackupsetId INT, BackupsetName NVARCHAR(128), AppId INT, SubclientName NVARCHAR(256),
	Category INT, Property VARCHAR(64), ParamName NVARCHAR(1024), ParamValue NVARCHAR(MAX), stdValue NVARCHAR(MAX), DefaultValue NVARCHAR(MAX)
)
IF OBJECT_ID('tempdb.dbo.#stdParams') IS NOT NULL DROP TABLE #stdParams
CREATE TABLE #stdParams  (
	AppTypeName VARCHAR(256), InstanceName NVARCHAR(512), BackupsetName NVARCHAR(128),
	AppId INT, SubclientName NVARCHAR(256), SubclientType VARCHAR(32),
	Property VARCHAR(64), ParamName NVARCHAR(1024), ParamValue NVARCHAR(MAX), DefaultValue NVARCHAR(MAX)
)
IF @i_Category IN (0, -1, 1)
BEGIN
	INSERT	INTO #stdParams
	SELECT	'', '', '', 0, '', '',
			Property, ParamName, ParamValue, DefaultValue
	FROM	cf_SurveyClientProp P
	WHERE	SurveyResultId = @stdSurveyResultID AND ClientId = @i_stdClientID
			AND Category = 1 AND ParamName  <> 'Client Type'
	INSERT	INTO #TempParams
	SELECT	E.CommServId, E.ClientId, E.ClientName,
			NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
			P.Property, P.ParamName, P.ParamValue, P.DefaultValue
	FROM	cf_SurveyClientProp P
			INNER JOIN (
				SELECT DISTINCT SurveyResultId, CommServId, ClientId, ClientName FROM #EntityList
			) E ON P.SurveyResultId = E.SurveyResultId AND P.ClientId = E.ClientId
				AND P.Category = 1 AND P.ParamName <> 'Client Type'
	INSERT	INTO #TempParams
	SELECT	DISTINCT E.CommServId, E.ClientId, E.ClientName,
			NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
			P.Property, P.ParamName, ISNULL(T.ParamValue, P.DefaultValue), P.DefaultValue
	FROM	(SELECT DISTINCT CommServId, ClientId, ClientName FROM #TempParams) E
			CROSS JOIN (SELECT Property, ParamName, DefaultValue FROM #stdParams WHERE ParamValue <> DefaultValue) P
			LEFT OUTER JOIN (
				SELECT	A.CommServId, A.ClientId, A.Property, A.ParamName, B.ParamValue
				FROM	#TempParams A INNER JOIN #stdParams B ON A.Property = B.Property AND A.ParamName = B.ParamName
				WHERE	B.ParamValue <> B.DefaultValue
			) T ON E.CommServId = T.CommServId AND E.ClientId = T.ClientId AND P.Property = T.Property AND P.ParamName = T.ParamName
	WHERE	T.ParamName IS NULL
	IF	@CountChildEntities > 0
	BEGIN
		INSERT	INTO #stdParams
		SELECT	'', '', '', 0, '', '',
				'General', 'Number of Agents', CAST(COUNT(DISTINCT AppTypeId) AS VARCHAR(32)), '1'
		FROM	#stdEntities
		INSERT	INTO #TempParams
		SELECT	CommServId, ClientId, ClientName, 0, '', 0, '', 0, '', 0, '', '',
				'General', 'Number of Agents', CAST(COUNT(DISTINCT AppTypeId) AS VARCHAR(32)), '1'
		FROM	#EntityList
		GROUP BY CommServId, ClientId, ClientName
	END
	INSERT	INTO #DiffParams
	SELECT	P.CommServId, P.ClientId, P.ClientName, 0, '', 0, '', 0, '', 0, '',
			1, P.Property, P.ParamName, P.ParamValue, ISNULL(S.ParamValue, P.DefaultValue), P.DefaultValue
	FROM	#TempParams P
			LEFT OUTER JOIN #stdParams S ON P.Property = S.Property AND P.ParamName = S.ParamName
	WHERE	P.ParamValue <> ISNULL(S.ParamValue, P.DefaultValue)
END
IF @i_Category IN (0, -1, 2)
BEGIN
	DELETE	FROM #stdParams
	DELETE	FROM #TempParams
	INSERT	INTO #stdParams
	SELECT	'', '', '', 0, '', '',
			Property, ParamName, ParamValue, DefaultValue
	FROM	cf_SurveyClientProp P
	WHERE	SurveyResultId = @stdSurveyResultID AND ClientId = @i_stdClientID
			AND Category = 2 AND ParamName NOT IN ('Client Type', 'Subclient Type')
	INSERT	INTO #TempParams
	SELECT	E.CommServId, E.ClientId, E.ClientName,
			NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
			P.Property, P.ParamName, P.ParamValue, P.DefaultValue
	FROM	cf_SurveyClientProp P
			INNER JOIN (
				SELECT DISTINCT SurveyResultId, CommServId, ClientId, ClientName FROM #EntityList
			) E ON P.SurveyResultId = E.SurveyResultId AND P.ClientId = E.ClientId
				AND P.Category = 2 AND P.ParamName <> 'Client Type'
	INSERT	INTO #TempParams
	SELECT	DISTINCT E.CommServId, E.ClientId, E.ClientName,
			NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
			P.Property, P.ParamName, ISNULL(T.ParamValue, P.DefaultValue), P.DefaultValue
	FROM	(SELECT DISTINCT CommServId, ClientId, ClientName FROM #TempParams) E
			CROSS JOIN (SELECT Property, ParamName, DefaultValue FROM #stdParams WHERE ParamValue <> DefaultValue) P
			LEFT OUTER JOIN (
				SELECT	A.CommServId, A.ClientId, A.Property, A.ParamName, B.ParamValue
				FROM	#TempParams A INNER JOIN #stdParams B ON A.Property = B.Property AND A.ParamName = B.ParamName
				WHERE	B.ParamValue <> B.DefaultValue
			) T ON E.CommServId = T.CommServId AND E.ClientId = T.ClientId AND P.Property = T.Property AND P.ParamName = T.ParamName
	WHERE	T.ParamName IS NULL
	INSERT	INTO #DiffParams
	SELECT	P.CommServId, P.ClientId, P.ClientName, 0, '', 0, '', 0, '', 0, '',
			2, P.Property, P.ParamName, P.ParamValue, ISNULL(S.ParamValue, P.DefaultValue), P.DefaultValue
	FROM	#TempParams P
			LEFT OUTER JOIN #stdParams S ON P.Property = S.Property AND P.ParamName = S.ParamName
	WHERE	P.ParamValue <> ISNULL(S.ParamValue, P.DefaultValue)
	DELETE	D FROM #DiffParams D
	INNER JOIN (
		SELECT	CommServId, ClientId
		FROM	#DiffParams
		WHERE	Category = 2 AND Property = 'Firewall Configuration' AND ParamName = 'Configure Firewall Settings' AND (ParamValue = 'No' OR stdValue = 'No')
		) T ON D.CommServId = T.CommServId AND D.ClientId = T.ClientId AND Category = 2 AND Property = 'Firewall Configuration' AND ParamName <> 'Configure Firewall Settings'
END
IF @i_Category IN (0, -1, 3)
BEGIN
	DELETE	FROM #stdParams
	DELETE	FROM #TempParams
	INSERT	INTO #stdParams
	SELECT	E.AppTypeName, '', '', 0, '', '',
			Property, ParamName, ParamValue, DefaultValue
	FROM	cf_SurveyClientProp P
			INNER JOIN #stdEntities E ON P.SurveyResultId = @stdSurveyResultID AND P.ClientId = @i_stdClientID
				AND P.AppTypeId = E.AppTypeId
	WHERE	P.Category = 3
	INSERT	INTO #TempParams
	SELECT	E.CommServId, E.ClientId, E.ClientName, E.AppTypeId, E.AppTypeName,
			NULL, NULL, NULL, NULL, NULL, NULL, NULL,
			P.Property, P.ParamName, P.ParamValue, P.DefaultValue
	FROM	cf_SurveyClientProp P
			INNER JOIN (
				SELECT	DISTINCT SurveyResultId, CommServId, ClientId, ClientName, AppTypeId, AppTypeName
				FROM	#EntityList
			) E ON P.SurveyResultId = E.SurveyResultId AND P.ClientId = E.ClientId AND P.AppTypeId = E.AppTypeId
				AND P.Category = 3
	INSERT	INTO #TempParams
	SELECT	DISTINCT E.CommServId, E.ClientId, E.ClientName, E.AppTypeId, E.AppTypeName,
			NULL, NULL, NULL, NULL, NULL, NULL, NULL,
			P.Property, P.ParamName, ISNULL(T.ParamValue, P.DefaultValue), P.DefaultValue
	FROM	(SELECT DISTINCT CommServId, ClientId, ClientName, AppTypeId, AppTypeName FROM #TempParams) E
			CROSS JOIN (SELECT Property, ParamName, DefaultValue FROM #stdParams WHERE ParamValue <> DefaultValue) P
			LEFT OUTER JOIN (
				SELECT	A.CommServId, A.ClientId, A.AppTypeId, A.Property, A.ParamName, B.ParamValue
				FROM	#TempParams A INNER JOIN #stdParams B ON A.Property = B.Property AND A.ParamName = B.ParamName
				WHERE	B.ParamValue <> B.DefaultValue
			) T ON E.CommServId = T.CommServId AND E.ClientId = T.ClientId AND E.AppTypeId = T.AppTypeId
				AND P.Property = T.Property AND P.ParamName = T.ParamName
	WHERE	T.ParamName IS NULL
	IF	@CountChildEntities > 0
	BEGIN
		INSERT	INTO #stdParams
		SELECT	AppTypeName, '', '', 0, '', '',
				'General', 'Number of Instances', CAST(COUNT(DISTINCT InstanceId) AS VARCHAR(32)), '1'
		FROM	#stdEntities
		GROUP BY AppTypeName
		INSERT	INTO #TempParams
		SELECT	CommServId, ClientId, ClientName, AppTypeId, AppTypeName, 0, '', 0, '', 0, '', '',
				'General', 'Number of Instances', CAST(COUNT(DISTINCT InstanceId) AS VARCHAR(32)), '1'
		FROM	#EntityList
		GROUP BY CommServId, ClientId, ClientName, AppTypeId, AppTypeName
	END
	INSERT	INTO #DiffParams
	SELECT	P.CommServId, P.ClientId, P.ClientName, P.AppTypeId, P.AppTypeName, 0, '', 0, '', 0, '',
			3, P.Property, P.ParamName, P.ParamValue, ISNULL(S.ParamValue, P.DefaultValue), P.DefaultValue
	FROM	#TempParams P
			INNER JOIN #EntityList E ON P.CommServId = E.CommServId AND P.ClientId = E.ClientId AND P.AppId = E.AppId
			LEFT OUTER JOIN #stdParams S ON E.StdAppId = S.AppId AND P.Property = S.Property AND P.ParamName = S.ParamName
	WHERE	P.ParamValue <> ISNULL(S.ParamValue, P.DefaultValue)
END
IF @i_Category IN (0, -1, 4)
BEGIN
	DELETE	FROM #stdParams
	DELETE	FROM #TempParams
	INSERT	INTO #stdParams
	SELECT	E.AppTypeName, E.InstanceName, '', 0, '', '',
			Property, ParamName, ParamValue, DefaultValue
	FROM	cf_SurveyClientProp P
			INNER JOIN #stdEntities E ON P.SurveyResultId = @stdSurveyResultID AND P.ClientId = @i_stdClientID
				AND P.AppTypeId = E.AppTypeId AND P.InstanceId = E.InstanceId
	WHERE	P.Category = 4
	INSERT	INTO #TempParams
	SELECT	E.CommServId, E.ClientId, E.ClientName, E.AppTypeId, E.AppTypeName, E.InstanceId, E.InstanceName,
			NULL, NULL, NULL, NULL, NULL,
			P.Property, P.ParamName, P.ParamValue, P.DefaultValue
	FROM	cf_SurveyClientProp P
			INNER JOIN (
				SELECT	DISTINCT SurveyResultId, CommServId, ClientId, ClientName, AppTypeId, AppTypeName, InstanceId, InstanceName
				FROM	#EntityList
				WHERE	SurveyResultId <> @stdSurveyResultID OR ClientId <> @i_stdClientID
			) E ON P.SurveyResultId = E.SurveyResultId AND P.Category = 4
				AND P.ClientId = E.ClientId AND P.AppTypeId = E.AppTypeId AND E.InstanceId = P.InstanceId
	INSERT	INTO #TempParams
	SELECT	DISTINCT E.CommServId, E.ClientId, E.ClientName, E.AppTypeId, E.AppTypeName, E.InstanceId, E.InstanceName,
			NULL, NULL, NULL, NULL, NULL,
			P.Property, P.ParamName, ISNULL(T.ParamValue, P.DefaultValue), P.DefaultValue
	FROM	(SELECT DISTINCT CommServId, ClientId, ClientName, AppTypeId, AppTypeName, InstanceId, InstanceName FROM #TempParams) E
			CROSS JOIN (SELECT Property, ParamName, DefaultValue FROM #stdParams WHERE ParamValue <> DefaultValue) P
			LEFT OUTER JOIN (
				SELECT	A.CommServId, A.ClientId, A.AppTypeId, A.InstanceId, A.Property, A.ParamName, B.ParamValue
				FROM	#TempParams A INNER JOIN #stdParams B ON A.Property = B.Property AND A.ParamName = B.ParamName
				WHERE	B.ParamValue <> B.DefaultValue
			) T ON E.CommServId = T.CommServId AND E.ClientId = T.ClientId AND E.AppTypeId = T.AppTypeId AND E.InstanceId = T.InstanceId
				AND P.Property = T.Property AND P.ParamName = T.ParamName
	WHERE	T.ParamName IS NULL
	IF	@CountChildEntities > 0
	BEGIN
		INSERT	INTO #stdParams
		SELECT	AppTypeName, InstanceName, '', 0, '', '',
				'General', 'Number of Backupsets', CAST(COUNT(DISTINCT BackupsetId) AS VARCHAR(32)), '1'
		FROM	#stdEntities
		GROUP BY AppTypeName, InstanceName
		INSERT	INTO #TempParams
		SELECT	CommServId, ClientId, ClientName, AppTypeId, AppTypeName, InstanceId, InstanceName, 0, '', 0, '', '',
				'General', 'Number of Backupsets', CAST(COUNT(DISTINCT BackupsetId) AS VARCHAR(32)), '1'
		FROM	#EntityList
		GROUP BY CommServId, ClientId, ClientName, AppTypeId, AppTypeName, InstanceId, InstanceName
	END
	INSERT	INTO #DiffParams
	SELECT	P.CommServId, P.ClientId, P.ClientName, P.AppTypeId, P.AppTypeName, P.InstanceId, P.InstanceName, 0, '', 0, '',
			4, P.Property, P.ParamName, P.ParamValue, ISNULL(S.ParamValue, P.DefaultValue), P.DefaultValue
	FROM	#TempParams P
			INNER JOIN #EntityList E ON P.CommServId = E.CommServId AND P.ClientId = E.ClientId AND P.AppId = E.AppId
			LEFT OUTER JOIN #stdParams S ON E.StdAppId = S.AppId AND P.Property = S.Property AND P.ParamName = S.ParamName
	WHERE	P.ParamValue <> ISNULL(S.ParamValue, P.DefaultValue)
END
IF @i_Category IN (0, -1, 5)
BEGIN
	DELETE	FROM #stdParams
	DELETE	FROM #TempParams
	INSERT	INTO #stdParams
	SELECT	E.AppTypeName, E.InstanceName, E.BackupsetName, 0, '', '',
			Property, ParamName, ParamValue, DefaultValue
	FROM	cf_SurveyClientProp P
			INNER JOIN #stdEntities E ON P.SurveyResultId = @stdSurveyResultID AND P.ClientId = @i_stdClientID
				AND P.AppTypeId = E.AppTypeId AND P.InstanceId = E.InstanceId AND P.BackupsetId = E.BackupsetId
	WHERE	P.Category = 5
	INSERT	INTO #TempParams
	SELECT	E.CommServId, E.ClientId, E.ClientName, E.AppTypeId, E.AppTypeName, E.InstanceId, E.InstanceName, E.BackupsetId, E.BackupsetName,
			NULL, NULL, NULL,
			P.Property, P.ParamName, P.ParamValue, P.DefaultValue
	FROM	cf_SurveyClientProp P
			INNER JOIN (
				SELECT	DISTINCT SurveyResultId, CommServId, ClientId, ClientName, AppTypeId, AppTypeName, InstanceId, InstanceName, BackupsetId, BackupsetName
				FROM	#EntityList
				WHERE	SurveyResultId <> @stdSurveyResultID OR ClientId <> @i_stdClientID
			) E ON P.SurveyResultId = E.SurveyResultId AND P.Category = 5
				AND P.ClientId = E.ClientId AND P.AppTypeId = E.AppTypeId AND E.InstanceId = P.InstanceId AND P.BackupsetId = E.BackupsetId
	INSERT	INTO #TempParams
	SELECT	DISTINCT E.CommServId, E.ClientId, E.ClientName, E.AppTypeId, E.AppTypeName, E.InstanceId, E.InstanceName, E.BackupsetId, E.BackupsetName,
			NULL, NULL, NULL,
			P.Property, P.ParamName, ISNULL(T.ParamValue, P.DefaultValue), P.DefaultValue
	FROM	(	SELECT	DISTINCT CommServId, ClientId, ClientName, AppTypeId, AppTypeName, InstanceId, InstanceName, BackupsetId, BackupsetName
				FROM	#TempParams
			) E
			CROSS JOIN (SELECT Property, ParamName, DefaultValue FROM #stdParams WHERE ParamValue <> DefaultValue) P
			LEFT OUTER JOIN (
				SELECT	A.CommServId, A.ClientId, A.AppTypeId, A.InstanceId, A.BackupsetId, A.Property, A.ParamName, B.ParamValue
				FROM	#TempParams A INNER JOIN #stdParams B ON A.Property = B.Property AND A.ParamName = B.ParamName
				WHERE	B.ParamValue <> B.DefaultValue
			) T ON E.CommServId = T.CommServId AND E.ClientId = T.ClientId AND E.AppTypeId = T.AppTypeId
				AND E.InstanceId = T.InstanceId AND E.BackupsetId = T.BackupsetId
				AND P.Property = T.Property AND P.ParamName = T.ParamName
	WHERE	T.ParamName IS NULL
	IF	@CountChildEntities > 0
	BEGIN
		INSERT	INTO #stdParams
		SELECT	AppTypeName, InstanceName, BackupsetName, 0, '', '',
				'General', 'Number of Subclients', CAST(COUNT(DISTINCT AppId) AS VARCHAR(32)), '1'
		FROM	#stdEntities
		GROUP BY AppTypeName, InstanceName, BackupsetName
		INSERT	INTO #TempParams
		SELECT	CommServId, ClientId, ClientName, AppTypeId, AppTypeName, InstanceId, InstanceName,
				BackupsetId, BackupsetName, 0, '', '',
				'General', 'Number of Subclients', CAST(COUNT(DISTINCT AppId) AS VARCHAR(32)), '1'
		FROM	#EntityList
		GROUP BY CommServId, ClientId, ClientName, AppTypeId, AppTypeName, InstanceId, InstanceName, BackupsetId, BackupsetName
	END
	INSERT	INTO #DiffParams
	SELECT	P.CommServId, P.ClientId, P.ClientName, P.AppTypeId, P.AppTypeName, P.InstanceId, P.InstanceName,
			P.BackupsetId, P.BackupsetName, 0, '',
			5, P.Property, P.ParamName, P.ParamValue, ISNULL(S.ParamValue, P.DefaultValue), P.DefaultValue
	FROM	#TempParams P
			INNER JOIN #EntityList E ON P.CommServId = E.CommServId AND P.ClientId = E.ClientId AND P.AppId = E.AppId
			LEFT OUTER JOIN #stdParams S ON E.StdAppId = S.AppId AND P.Property = S.Property AND P.ParamName = S.ParamName
	WHERE	P.ParamValue <> ISNULL(S.ParamValue, P.DefaultValue)
END
IF @i_Category IN (0, -1, 6)
BEGIN
	DELETE	FROM #stdParams
	DELETE	FROM #TempParams
	INSERT	INTO #stdParams
	SELECT	E.AppTypeName, E.InstanceName, E.BackupsetName, E.AppId, E.SubclientName, E.SubclientType,
			Property, ParamName, ParamValue, DefaultValue
	FROM	cf_SurveyClientProp P
			INNER JOIN #stdEntities E ON P.SurveyResultId = @stdSurveyResultID AND P.ClientId = @i_stdClientID
				AND P.AppTypeId = E.AppTypeId AND P.InstanceId = E.InstanceId AND P.BackupsetId = E.BackupsetId	AND P.AppId = E.AppId
	WHERE	P.Category = 6 AND P.ParamName <> 'Subclient Type'
	INSERT	INTO #TempParams
	SELECT	E.CommServId, E.ClientId, E.ClientName, E.AppTypeId, E.AppTypeName, E.InstanceId, E.InstanceName,
			E.BackupsetId, E.BackupsetName, E.AppId, E.SubclientName, E.SubclientType,
			P.Property, P.ParamName, P.ParamValue, P.DefaultValue
	FROM	cf_SurveyClientProp P
			INNER JOIN #EntityList E ON P.SurveyResultId = E.SurveyResultId AND P.ClientId = E.ClientId
				AND P.AppTypeId = E.AppTypeId AND E.InstanceId = P.InstanceId AND P.BackupsetId = E.BackupsetId AND P.AppId = E.AppId
				AND P.Category = 6 AND P.ParamName <> 'Subclient Type'
	INSERT	INTO #TempParams
	SELECT	DISTINCT E.CommServId, E.ClientId, E.ClientName, E.AppTypeId, E.AppTypeName, E.InstanceId, E.InstanceName,
			E.BackupsetId, E.BackupsetName, E.AppId, E.SubclientName, E.SubclientType,
			P.Property, P.ParamName, ISNULL(T.ParamValue, P.DefaultValue), P.DefaultValue
	FROM	(SELECT DISTINCT CommServId, ClientId, ClientName, AppTypeId, AppTypeName, InstanceId, InstanceName,
				BackupsetId, BackupsetName, AppId, SubclientName, SubclientType FROM #TempParams) E
			CROSS JOIN (SELECT Property, ParamName, DefaultValue FROM #stdParams WHERE ParamValue <> DefaultValue) P
			LEFT OUTER JOIN (
				SELECT	A.CommServId, A.ClientId, A.AppTypeId, A.InstanceId, A.BackupsetId, A.AppId, A.Property, A.ParamName, B.ParamValue
				FROM	#TempParams A INNER JOIN #stdParams B ON A.Property = B.Property AND A.ParamName = B.ParamName
				WHERE	B.ParamValue <> B.DefaultValue
			) T ON E.CommServId = T.CommServId AND E.ClientId = T.ClientId AND E.AppTypeId = T.AppTypeId
				AND E.InstanceId = T.InstanceId AND E.BackupsetId = T.BackupsetId AND E.AppId = T.AppId
				AND P.Property = T.Property AND P.ParamName = T.ParamName
	WHERE	T.ParamName IS NULL
	IF	@StoragePolicyDiff > 0
	BEGIN
		INSERT	INTO #stdParams
		SELECT	E.AppTypeName, E.InstanceName, E.BackupsetName, E.AppId, E.SubclientName, E.SubclientType,
				'General', 'Storage Policy', T.PolicyName, ''
		FROM	#stdEntities E
				INNER JOIN (
				SELECT	DISTINCT S.AppId, C.PolicyName
				FROM	cf_SurveySubclientAssociation S
						INNER JOIN cf_SurveyCopyBasicRetention C ON S.CommservUniqueId = C.CommservUniqueId AND S.DataPolicyId = C.PolicyId
				WHERE	S.CommservUniqueId = @i_stdCommServUniqueID AND S.ClientId = @i_stdClientID AND S.DataPolicyId > 1
				) T	ON E.AppId = T.AppId
		UNION ALL
		SELECT	E.AppTypeName, E.InstanceName, E.BackupsetName, E.AppId, E.SubclientName, E.SubclientType,
				'General', 'Log Storage Policy', T.PolicyName, ''
		FROM	#stdEntities E
				INNER JOIN (
				SELECT	DISTINCT S.AppId, C.PolicyName
				FROM	cf_SurveySubclientAssociation S
						INNER JOIN cf_SurveyCopyBasicRetention C ON S.CommservUniqueId = C.CommservUniqueId AND S.LogPolicyId = C.PolicyId
				WHERE	S.CommservUniqueId = @i_stdCommServUniqueID AND S.ClientId = @i_stdClientID AND S.LogPolicyId > 1
				) T	ON E.AppId = T.AppId
		INSERT	INTO #TempParams
		SELECT	E.CommServId, E.ClientId, E.ClientName, E.AppTypeId, E.AppTypeName, E.InstanceId, E.InstanceName,
				E.BackupsetId, E.BackupsetName, E.AppId, E.SubclientName, E.SubclientType,
				'General', 'Storage Policy', T.PolicyName, ''
		FROM	#EntityList E
				INNER JOIN (
				SELECT	DISTINCT S.CommservUniqueId, S.AppId, C.PolicyName
				FROM	cf_SurveySubclientAssociation S
						INNER JOIN cf_SurveyCopyBasicRetention C ON S.CommservUniqueId = C.CommservUniqueId AND S.DataPolicyId = C.PolicyId
				WHERE	S.DataPolicyId > 1
				) T	ON E.CommServId = T.CommservUniqueId AND E.AppId = T.AppId
		UNION ALL
		SELECT	E.CommServId, E.ClientId, E.ClientName, E.AppTypeId, E.AppTypeName, E.InstanceId, E.InstanceName,
				E.BackupsetId, E.BackupsetName, E.AppId, E.SubclientName, E.SubclientType,
				'General', 'Log Storage Policy', T.PolicyName, ''
		FROM	#EntityList E
				INNER JOIN (
				SELECT	DISTINCT S.CommservUniqueId, S.AppId, C.PolicyName
				FROM	cf_SurveySubclientAssociation S
						INNER JOIN cf_SurveyCopyBasicRetention C ON S.CommservUniqueId = C.CommservUniqueId AND S.LogPolicyId = C.PolicyId
				WHERE	S.LogPolicyId > 1
				) T	ON E.CommServId = T.CommservUniqueId AND E.AppId = T.AppId
	END
	INSERT	INTO #DiffParams
	SELECT	P.CommServId, P.ClientId, P.ClientName, P.AppTypeId, P.AppTypeName, P.InstanceId, P.InstanceName,
			P.BackupsetId, P.BackupsetName, P.AppId, P.SubclientName,
			6, P.Property, P.ParamName, P.ParamValue, ISNULL(S.ParamValue, P.DefaultValue), P.DefaultValue
	FROM	#TempParams P
			INNER JOIN #EntityList E ON P.CommServId = E.CommServId AND P.ClientId = E.ClientId AND P.AppId = E.AppId
			LEFT OUTER JOIN #stdParams S ON E.StdAppId = S.AppId AND P.Property = S.Property AND P.ParamName = S.ParamName
	WHERE	P.ParamValue <> ISNULL(S.ParamValue, P.DefaultValue)
END
IF OBJECT_ID('tempdb.dbo.#stdEntities') IS NOT NULL DROP TABLE #stdEntities
IF OBJECT_ID('tempdb.dbo.#TempParams') IS NOT NULL DROP TABLE #TempParams
IF OBJECT_ID('tempdb.dbo.#stdParams') IS NOT NULL DROP TABLE #stdParams
DECLARE	@TblSummary TABLE (CommServId INT, ClientCount INT, PassedClients INT,
		ClientParams INT, NetworkParams INT, AgentParams INT, InstanceParams INT, BackupsetParams INT, SubclientParams INT, AllParams INT)
IF @i_Aggregate = 1 OR @i_Category = -1
BEGIN
	IF OBJECT_ID('tempdb.dbo.#PassedClients') IS NOT NULL DROP TABLE #PassedClients
	CREATE TABLE #PassedClients (CommServId INT, ClientId INT, ClientName NVARCHAR(256))
	INSERT	INTO #PassedClients
	SELECT	E.CommServId, E.ClientId, E.ClientName
	FROM	(SELECT DISTINCT CommServId, ClientId, ClientName FROM #EntityList WHERE CommServId <> @i_stdCommServUniqueID OR ClientId <> @i_stdClientID
			) E LEFT OUTER JOIN
			(SELECT DISTINCT CommServId, ClientId FROM #DiffParams
			) D ON E.CommServId = D.CommServId AND E.ClientId = D.ClientId
	WHERE	D.ClientId IS NULL
	IF	@i_Category = -1
	BEGIN
		IF	@i_CommServUniqueID = 0
			SELECT	CS.CommServName	AS [CommCell],
					ISNULL (CL.ClientDisplayName, P.clientName) AS [Client],
					P.clientName  AS [Client(classic)<HIDDEN>]
			FROM	#PassedClients P
					INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
					LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = P.CommServId  AND CL.ClientId = P.ClientId
					ORDER BY CS.CommServName, [Client]
		ELSE
			SELECT	ISNULL (CL.ClientDisplayName, P.clientName) AS [Client],
					P.clientName  AS [Client(classic)<HIDDEN>]
			FROM	#PassedClients P
			LEFT JOIN cf_SurveyClient CL WITH (NOLOCK)
				ON CL.CommServUniqueId = P.CommServId  AND CL.ClientId = P.ClientId
			ORDER BY [Client]
		RETURN
	END
	INSERT	INTO @TblSummary
	SELECT	P.CommServId,
			(SELECT COUNT(DISTINCT ClientId) FROM #EntityList WHERE CommServId = P.CommServId),
			(SELECT COUNT(DISTINCT ClientId) FROM #PassedClients WHERE CommServId = P.CommServId),
			ISNULL([1], 0), ISNULL([2], 0), ISNULL([3], 0), ISNULL([4], 0), ISNULL([5], 0), ISNULL([6], 0),
			ISNULL([1], 0) + ISNULL([2], 0) + ISNULL([3], 0) + ISNULL([4], 0) + ISNULL([5], 0) + ISNULL([6], 0)
	FROM	(SELECT	CommServId, Category, COUNT(*) AS Counts
			FROM	#DiffParams
			GROUP BY CommServId, Category) AS S
			PIVOT (MAX(Counts) FOR S.Category IN ([1], [2], [3], [4], [5], [6])) AS P
	DROP TABLE #PassedClients
END
IF OBJECT_ID('tempdb.dbo.#EntityList') IS NOT NULL DROP TABLE #EntityList
DECLARE @AppTypeIdName TABLE (AppTypeId INT, AgentName VARCHAR(256))
INSERT INTO @AppTypeIdName
SELECT	DISTINCT AppTypeId, AgentName
FROM	cf_SurveySubclientAssociation SA
		INNER JOIN #LatestResult LR ON SA.CommServUniqueId = LR.CommServId
IF @i_Aggregate = 1
BEGIN
	SELECT	'All CommCells'			AS [CommCell],
			0						AS [CommServ UniqueId],
			''						AS [CommCell ID],
			SUM(ClientCount)		AS [All Clients],
			SUM(PassedClients)		AS [Passed Audit],
			SUM(ClientParams)		AS [Client],
			SUM(NetworkParams)		AS [Network],
			SUM(AgentParams)		AS [Agent],
			SUM(InstanceParams)		AS [Instance],
			SUM(BackupsetParams)	AS [Backupset],
			SUM(SubclientParams)	AS [Subclient],
			SUM(AllParams)			AS [Any],
			''						AS [Collection Time (Time Zone)],
			-1						AS [FirstOrder<DONOTSHOW>]
	FROM	@TblSummary
	UNION ALL
	SELECT	CASE
				WHEN @isPrivate = 1 THEN CS.CommServName
				ELSE CS.CustomerName + ' - ' + CS.CommServName
			END						AS [CommCell],
			CS.ID					AS [CommServ UniqueId],
			CS.CommCellID			AS [CommCell ID],
			ClientCount				AS [All Clients],
			PassedClients			AS [Passed Audit],
			ClientParams			AS [Client],
			NetworkParams			AS [Network],
			AgentParams				AS [Agent],
			InstanceParams			AS [Instance],
			BackupsetParams			AS [Backupset],
			SubclientParams			AS [Subclient],
			AllParams				AS [Any],
			CONVERT(VARCHAR(20), LR.LogDate, 100) + ' (' + CS.CommServTZ + ')'
									AS [Collection Time (Time Zone)],
			0						AS [FirstOrder<DONOTSHOW>]
	FROM	@TblSummary D
			INNER JOIN cf_CommcellIdNameMap CS ON D.CommServId = CS.ID
			INNER JOIN #LatestResult LR ON D.CommServId = LR.CommServId
	ORDER BY [FirstOrder<DONOTSHOW>], [CommCell]
END
ELSE
IF	@i_Category = 0
BEGIN
	IF @i_CommServUniqueID = 0
	BEGIN
		SELECT	CASE WHEN @isPrivate = 1 THEN CS.CommServName ELSE CS.CustomerName + ' - ' + CS.CommServName END AS [CommCell],
				ISNULL (CL.ClientDisplayName, P.clientName) AS [Client],
				P.clientName  AS [Client(classic)<HIDDEN>],
				''				AS [Agent],
				''				AS [Instance],
				''				AS [Backupset],
				''				AS [Subclient],
				CASE P.Category WHEN 1 THEN 'Client' ELSE 'Network' END AS [Category],
				P.Property		AS [Property],
				P.ParamName		AS [Parameter],
				P.ParamValue	AS [Value],
				P.stdValue		AS [Template Value]
		FROM	#DiffParams P
				INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
				LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = P.CommServId  AND CL.ClientId = P.ClientId
		WHERE Category IN (1,2) AND P.AppTypeId = 0
		UNION
		SELECT	CASE WHEN @isPrivate = 1 THEN CS.CommServName ELSE CS.CustomerName + ' - ' + CS.CommServName END AS [CommCell],
				ISNULL (CL.ClientDisplayName, P.clientName) AS [Client],
				P.clientName  AS [Client(classic)<HIDDEN>],
				A.AgentName		AS [Agent],
				''				AS [Instance],
				''				AS [Backupset],
				''				AS [Subclient],
				'Agent'			AS [Category],
				P.Property		AS [Property],
				P.ParamName		AS [Parameter],
				P.ParamValue	AS [Value],
				P.stdValue		AS [Template Value]
		FROM	#DiffParams P
				INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
				INNER JOIN @AppTypeIdName A ON P.AppTypeId = A.AppTypeId
				LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = P.CommServId  AND CL.ClientId = P.ClientId
		WHERE	Category = 3 AND P.AppTypeId > 0 AND P.InstanceId = 0
		UNION
		SELECT	CASE WHEN @isPrivate = 1 THEN CS.CommServName ELSE CS.CustomerName + ' - ' + CS.CommServName END AS [CommCell],
				ISNULL (CL.ClientDisplayName, P.clientName) AS [Client],
				P.clientName  AS [Client(classic)<HIDDEN>],
				A.AgentName		AS [Agent],
				P.InstanceName	AS [Instance],
				''				AS [Backupset],
				''				AS [Subclient],
				'Instance'		AS [Category],
				P.Property		AS [Property],
				P.ParamName		AS [Parameter],
				P.ParamValue	AS [Value],
				P.stdValue		AS [Template Value]
		FROM	#DiffParams P
				INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
				INNER JOIN @AppTypeIdName A ON P.AppTypeId = A.AppTypeId
				LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = P.CommServId  AND CL.ClientId = P.ClientId
		WHERE	Category = 4 AND P.AppTypeId > 0 AND P.InstanceId > 0 AND P.BackupsetId = 0
		UNION
		SELECT	CASE WHEN @isPrivate = 1 THEN CS.CommServName ELSE CS.CustomerName + ' - ' + CS.CommServName END AS [CommCell],
				ISNULL (CL.ClientDisplayName, P.clientName) AS [Client],
				P.clientName  AS [Client(classic)<HIDDEN>],
				A.AgentName		AS [Agent],
				P.InstanceName	AS [Instance],
				P.BackupsetName	AS [Backupset],
				''				AS [Subclient],
				'Backupset'		AS [Category],
				P.Property		AS [Property],
				P.ParamName		AS [Parameter],
				P.ParamValue	AS [Value],
				P.stdValue		AS [Template Value]
		FROM	#DiffParams P
				INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
				INNER JOIN @AppTypeIdName A ON P.AppTypeId = A.AppTypeId
				LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = P.CommServId  AND CL.ClientId = P.ClientId
		WHERE	Category = 5 AND P.AppTypeId > 0 AND P.InstanceId > 0 AND P.BackupsetId > 0 AND P.AppId = 0
		UNION
		SELECT	CASE WHEN @isPrivate = 1 THEN CS.CommServName ELSE CS.CustomerName + ' - ' + CS.CommServName END AS [CommCell],
				ISNULL (CL.ClientDisplayName, P.clientName) AS [Client],
				P.clientName  AS [Client(classic)<HIDDEN>],
				A.AgentName		AS [Agent],
				P.InstanceName	AS [Instance],
				P.BackupsetName	AS [Backupset],
				P.SubclientName	AS [Subclient],
				'Subclient'		AS [Category],
				P.Property		AS [Property],
				P.ParamName		AS [Parameter],
				P.ParamValue	AS [Value],
				P.stdValue		AS [Template Value]
		FROM	#DiffParams P
				INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
				INNER JOIN @AppTypeIdName A ON P.AppTypeId = A.AppTypeId
				LEFT JOIN cf_SurveyClient CL WITH (NOLOCK)ON CL.CommServUniqueId = P.CommServId  AND CL.ClientId = P.ClientId
		WHERE	Category = 6 AND P.AppId > 0
		ORDER BY [CommCell],  [Client], [Agent], [Instance], [Backupset], [Subclient], [Category], [Property], [Parameter]
	END
	ELSE
	BEGIN
		SELECT  ISNULL (CL.ClientDisplayName, P.clientName) AS [Client],
				P.clientName  AS [Client(classic)<HIDDEN>],
				''				AS [Agent],
				''				AS [Instance],
				''				AS [Backupset],
				''				AS [Subclient],
				CASE P.Category WHEN 1 THEN 'Client' ELSE 'Network' END AS [Category],
				P.Property		AS [Property],
				P.ParamName		AS [Parameter],
				P.ParamValue	AS [Value],
				P.stdValue		AS [Template Value]
		FROM	#DiffParams P
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = P.CommServId  AND CL.ClientId = P.ClientId
		WHERE	Category IN (1,2) AND P.AppTypeId = 0
		UNION
		SELECT	 ISNULL (CL.ClientDisplayName, P.clientName) AS [Client],
				P.clientName  AS [Client(classic)<HIDDEN>],
				A.AgentName		AS [Agent],
				''				AS [Instance],
				''				AS [Backupset],
				''				AS [Subclient],
				'Agent'			AS [Category],
				P.Property		AS [Property],
				P.ParamName		AS [Parameter],
				P.ParamValue	AS [Value],
				P.stdValue		AS [Template Value]
		FROM	#DiffParams P
				INNER JOIN @AppTypeIdName A ON P.AppTypeId = A.AppTypeId
				LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = P.CommServId  AND CL.ClientId = P.ClientId
		WHERE	Category = 3 AND P.AppTypeId > 0 AND P.InstanceId = 0
		UNION
		SELECT  ISNULL (CL.ClientDisplayName, P.clientName) AS [Client],
				P.clientName  AS [Client(classic)<HIDDEN>],
				A.AgentName		AS [Agent],
				P.InstanceName	AS [Instance],
				''				AS [Backupset],
				''				AS [Subclient],
				'Instance'		AS [Category],
				P.Property		AS [Property],
				P.ParamName		AS [Parameter],
				P.ParamValue	AS [Value],
				P.stdValue		AS [Template Value]
		FROM	#DiffParams P
				INNER JOIN @AppTypeIdName A ON P.AppTypeId = A.AppTypeId
				LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = P.CommServId  AND CL.ClientId = P.ClientId
		WHERE	Category = 4 AND P.AppTypeId > 0 AND P.InstanceId > 0 AND P.BackupsetId = 0
		UNION
		SELECT  ISNULL (CL.ClientDisplayName, P.clientName) AS [Client],
				P.clientName  AS [Client(classic)<HIDDEN>],
				A.AgentName		AS [Agent],
				P.InstanceName	AS [Instance],
				P.BackupsetName	AS [Backupset],
				''				AS [Subclient],
				'Backupset'		AS [Category],
				P.Property		AS [Property],
				P.ParamName		AS [Parameter],
				P.ParamValue	AS [Value],
				P.stdValue		AS [Template Value]
		FROM	#DiffParams P
				INNER JOIN @AppTypeIdName A ON P.AppTypeId = A.AppTypeId
				LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = P.CommServId  AND CL.ClientId = P.ClientId
		WHERE	Category = 5 AND P.AppTypeId > 0 AND P.InstanceId > 0 AND P.BackupsetId > 0 AND P.AppId = 0
		UNION
		SELECT  ISNULL (CL.ClientDisplayName, P.clientName) AS [Client],
				P.clientName  AS [Client(classic)<HIDDEN>],
				A.AgentName		AS [Agent],
				P.InstanceName	AS [Instance],
				P.BackupsetName	AS [Backupset],
				P.SubclientName	AS [Subclient],
				'Subclient'		AS [Category],
				P.Property		AS [Property],
				P.ParamName		AS [Parameter],
				P.ParamValue	AS [Value],
				P.stdValue		AS [Template Value]
		FROM	#DiffParams P
				INNER JOIN @AppTypeIdName A ON P.AppTypeId = A.AppTypeId
				LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = P.CommServId  AND CL.ClientId = P.ClientId
		WHERE	Category = 6 AND P.AppId > 0
		ORDER BY [Client], [Agent], [Instance], [Backupset], [Subclient], [Category], [Property], [Parameter]
	END
END
ELSE
IF	@i_Category IN (1,2)
BEGIN
	DELETE #DiffParams WHERE Category <> @i_Category
	IF @i_CommServUniqueID = 0
		SELECT	CASE WHEN @isPrivate = 1 THEN CS.CommServName ELSE CS.CustomerName + ' - ' + CS.CommServName END AS [CommCell],
				ISNULL (CL.ClientDisplayName, P.clientName) AS [Client],
				P.clientName  AS [Client(classic)<HIDDEN>],
				CASE P.Category WHEN 1 THEN 'Client' ELSE 'Network' END AS [Category],
				P.Property		AS [Property],
				P.ParamName		AS [Parameter],
				P.ParamValue	AS [Value],
				P.stdValue		AS [Template Value]
		FROM	#DiffParams P
				INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
				LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = P.CommServId  AND CL.ClientId = P.ClientId
				WHERE	P.AppTypeId = 0
		ORDER BY [CommCell], [Client], [Category], [Property], [Parameter]
	ELSE
		SELECT	ISNULL (CL.ClientDisplayName, P.clientName) AS [Client],
				P.clientName  AS [Client(classic)<HIDDEN>],
				CASE P.Category WHEN 1 THEN 'Client' ELSE 'Network' END AS [Category],
				P.Property		AS [Property],
				P.ParamName		AS [Parameter],
				P.ParamValue	AS [Value],
				P.stdValue		AS [Template Value]
		FROM	#DiffParams P
				LEFT JOIN cf_SurveyClient CL WITH (NOLOCK)ON CL.CommServUniqueId = P.CommServId  AND CL.ClientId = P.ClientId
				WHERE	P.AppTypeId = 0
		ORDER BY [Client], [Category], [Property], [Parameter]
END
ELSE
IF	@i_Category = 3
BEGIN
	DELETE #DiffParams WHERE Category <> @i_Category
	IF @i_CommServUniqueID = 0
		SELECT	CASE WHEN @isPrivate = 1 THEN CS.CommServName ELSE CS.CustomerName + ' - ' + CS.CommServName END AS [CommCell],
				ISNULL (CL.ClientDisplayName, P.clientName) AS [Client],
				P.clientName  AS [Client(classic)<HIDDEN>],
				A.AgentName		AS [Agent],
				'Agent'			AS [Category],
				P.Property		AS [Property],
				P.ParamName		AS [Parameter],
				P.ParamValue	AS [Value],
				P.stdValue		AS [Template Value]
		FROM	#DiffParams P
				INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
				INNER JOIN @AppTypeIdName A ON P.AppTypeId = A.AppTypeId
				LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = P.CommServId  AND CL.ClientId = P.ClientId
		WHERE	P.AppTypeId > 0 AND P.InstanceId = 0
		ORDER BY [CommCell], [Client], [Agent], [Category], [Property], [Parameter]
	ELSE
		SELECT	ISNULL (CL.ClientDisplayName, P.clientName) AS [Client],
				P.clientName  AS [Client(classic)<HIDDEN>],
				A.AgentName		AS [Agent],
				'Agent'			AS [Category],
				P.Property		AS [Property],
				P.ParamName		AS [Parameter],
				P.ParamValue	AS [Value],
				P.stdValue		AS [Template Value]
		FROM	#DiffParams P
				INNER JOIN @AppTypeIdName A ON P.AppTypeId = A.AppTypeId
				LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = P.CommServId  AND CL.ClientId = P.ClientId
		WHERE	P.AppTypeId > 0 AND P.InstanceId = 0
		ORDER BY [Client], [Agent], [Category], [Property], [Parameter]
END
ELSE
IF	@i_Category = 4
BEGIN
	DELETE #DiffParams WHERE Category <> @i_Category
	IF @i_CommServUniqueID = 0
		SELECT	CASE WHEN @isPrivate = 1 THEN CS.CommServName ELSE CS.CustomerName + ' - ' + CS.CommServName END AS [CommCell],
				ISNULL (CL.ClientDisplayName, P.clientName) AS [Client],
				P.clientName  AS [Client(classic)<HIDDEN>],
				A.AgentName		AS [Agent],
				P.InstanceName	AS [Instance],
				'Instance'		AS [Category],
				P.Property		AS [Property],
				P.ParamName		AS [Parameter],
				P.ParamValue	AS [Value],
				P.stdValue		AS [Template Value]
		FROM	#DiffParams P
				INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
				INNER JOIN @AppTypeIdName A ON P.AppTypeId = A.AppTypeId
				LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = P.CommServId  AND CL.ClientId = P.ClientId
		WHERE	P.AppTypeId > 0 AND P.InstanceId > 0 AND P.BackupsetId = 0
		ORDER BY [CommCell], [Client], [Agent], [Instance], [Category], [Property], [Parameter]
	ELSE
		SELECT	ISNULL (CL.ClientDisplayName, P.clientName) AS [Client],
				P.clientName  AS [Client(classic)<HIDDEN>],
				A.AgentName		AS [Agent],
				P.InstanceName	AS [Instance],
				'Instance'		AS [Category],
				P.Property		AS [Property],
				P.ParamName		AS [Parameter],
				P.ParamValue	AS [Value],
				P.stdValue		AS [Template Value]
		FROM	#DiffParams P
				INNER JOIN @AppTypeIdName A ON P.AppTypeId = A.AppTypeId
				LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = P.CommServId  AND CL.ClientId = P.ClientId
		WHERE	P.AppTypeId > 0 AND P.InstanceId > 0 AND P.BackupsetId = 0
		ORDER BY [Client], [Agent], [Instance], [Category], [Property], [Parameter]
END
ELSE
IF	@i_Category = 5
BEGIN
	DELETE #DiffParams WHERE Category <> @i_Category
	IF @i_CommServUniqueID = 0
		SELECT	CASE WHEN @isPrivate = 1 THEN CS.CommServName ELSE CS.CustomerName + ' - ' + CS.CommServName END AS [CommCell],
				ISNULL (CL.ClientDisplayName, P.clientName) AS [Client],
				P.clientName  AS [Client(classic)<HIDDEN>],
				A.AgentName		AS [Agent],
				P.InstanceName	AS [Instance],
				P.BackupsetName	AS [Backupset],
				'Backupset'		AS [Category],
				P.Property		AS [Property],
				P.ParamName		AS [Parameter],
				P.ParamValue	AS [Value],
				P.stdValue		AS [Template Value]
		FROM	#DiffParams P
				INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
				INNER JOIN @AppTypeIdName A ON P.AppTypeId = A.AppTypeId
				LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = P.CommServId  AND CL.ClientId = P.ClientId
		WHERE	P.AppTypeId > 0 AND P.InstanceId > 0 AND P.BackupsetId > 0 AND P.AppId = 0
		ORDER BY [CommCell], [Client], [Agent], [Instance], [Backupset], [Category], [Property], [Parameter]
	ELSE
		SELECT	ISNULL (CL.ClientDisplayName, P.clientName) AS [Client],
				P.clientName  AS [Client(classic)<HIDDEN>],
				A.AgentName		AS [Agent],
				P.InstanceName	AS [Instance],
				P.BackupsetName	AS [Backupset],
				'Backupset'		AS [Category],
				P.Property		AS [Property],
				P.ParamName		AS [Parameter],
				P.ParamValue	AS [Value],
				P.stdValue		AS [Template Value]
		FROM	#DiffParams P
				INNER JOIN @AppTypeIdName A ON P.AppTypeId = A.AppTypeId
				LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = P.CommServId  AND CL.ClientId = P.ClientId
		WHERE	P.AppTypeId > 0 AND P.InstanceId > 0 AND P.BackupsetId > 0 AND P.AppId = 0
		ORDER BY [Client], [Agent], [Instance], [Backupset], [Category], [Property], [Parameter]
END
ELSE
IF	@i_Category = 6
BEGIN
	DELETE #DiffParams WHERE Category <> @i_Category
	IF @i_CommServUniqueID = 0
		SELECT	CASE WHEN @isPrivate = 1 THEN CS.CommServName ELSE CS.CustomerName + ' - ' + CS.CommServName END AS [CommCell],
				ISNULL (CL.ClientDisplayName, P.clientName) AS [Client],
				P.clientName  AS [Client(classic)<HIDDEN>],
				A.AgentName		AS [Agent],
				P.InstanceName	AS [Instance],
				P.BackupsetName	AS [Backupset],
				P.SubclientName	AS [Subclient],
				'Subclient'		AS [Category],
				P.Property		AS [Property],
				P.ParamName		AS [Parameter],
				P.ParamValue	AS [Value],
				P.stdValue		AS [Template Value]
		FROM	#DiffParams P
				INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
				INNER JOIN @AppTypeIdName A ON P.AppTypeId = A.AppTypeId
				LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = P.CommServId  AND CL.ClientId = P.ClientId
		WHERE	P.AppId > 0
		ORDER BY [CommCell], [Client], [Agent], [Instance], [Backupset], [Subclient], [Category], [Property], [Parameter]
	ELSE
		SELECT	ISNULL (CL.ClientDisplayName, P.clientName) AS [Client],
				P.clientName  AS [Client(classic)<HIDDEN>],
				A.AgentName		AS [Agent],
				P.InstanceName	AS [Instance],
				P.BackupsetName	AS [Backupset],
				P.SubclientName	AS [Subclient],
				'Subclient'		AS [Category],
				P.Property		AS [Property],
				P.ParamName		AS [Parameter],
				P.ParamValue	AS [Value],
				P.stdValue		AS [Template Value]
		FROM	#DiffParams P
				INNER JOIN @AppTypeIdName A ON P.AppTypeId = A.AppTypeId
				LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = P.CommServId  AND CL.ClientId = P.ClientId
		WHERE	P.AppId > 0
		ORDER BY [Client], [Agent], [Instance], [Backupset], [Subclient], [Category], [Property], [Parameter]
END
SET NOCOUNT OFF
GO
/*
-- STANDALONE:
  DECLARE @i_UserID INT = 1
  DECLARE @i_GroupID INT = 0
  DECLARE @i_Aggregate INT = -1
  DECLARE @i_stdCommServUniqueID INT = 10000
  DECLARE @i_stdClientID INT = 0
  DECLARE @i_stdAppTypeID INT = 0
  DECLARE @i_stdInstanceID INT = 0
  DECLARE @i_stdBackupsetID INT = 0
  DECLARE @i_stdAppID INT = 0
  DECLARE @i_CommServUniqueID INT = 0
  DECLARE @i_ClientGroupName NVARCHAR(512) = ''
  DECLARE @i_PropertyGroup VARCHAR(32) = ''
  DECLARE @i_Flags INT = 0
  exec RptClientAudit @i_UserID, @i_GroupID, @i_Aggregate, @i_stdCommServUniqueID, @i_stdClientID, @i_stdAppTypeID,
		@i_stdInstanceID, @i_stdBackupsetID, @i_stdAppID, @i_ClientGroupName, @i_PropertyGroup, @i_Flags
*/

IF EXISTS (select * from GxQscripts where name = 'RptClientAudit')
	delete from GxQscripts where name = 'RptClientAudit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptClientAudit')
	delete from GXDBVersions where aliasname = 'RptClientAudit'
GO

insert into GXDBVersions values(2, 'RptClientAudit',  '00010001000200090000', 'RptClientAudit', '00010001000200090000')
GO

