

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptClientsByJobPriority.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptClientsByJobPriority.sp,v $ $Id: RptClientsByJobPriority.sp,v 1.6 2015/07/06 20:31:48 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptClientsByJobPriority <<<'

IF EXISTS (select * from sysobjects where name='RptClientsByJobPriority')
	drop procedure RptClientsByJobPriority
IF EXISTS (select * from GxQscripts where name='RptClientsByJobPriority')
	delete from GxQscripts where name = 'RptClientsByJobPriority'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptClientsByJobPriority')
	delete from GXDBVersions where aliasname = 'RptClientsByJobPriority'
GO
print '... Creating Procedure: RptClientsByJobPriority'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptClientsByJobPriority
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 34
IF (OBJECT_ID('tempdb.dbo.#tmpClientsByJobPriority') IS NOT NULL)
	DROP TABLE #tmpClientsByJobPriority
CREATE TABLE #tmpClientsByJobPriority(
	CommServUniqueId INTEGER NOT NULL,
	CommCellID VARCHAR(32) NOT NULL,
	CommServIP VARCHAR(256) NOT NULL,
	CommServGUID VARCHAR(256) NOT NULL,
	CustomerName NVARCHAR(256) NOT NULL,
	LogDate DATETIME NOT NULL,
	RunningTime INT NOT NULL,
	CommServTZ NVARCHAR(MAX) NOT NULL,
	JobPriority INTEGER,
	ClientCount BIGINT
)
INSERT INTO #tmpClientsByJobPriority
SELECT
	tmpsurveyxml.CommServUniqueId,
	tmpsurveyxml.CommCellID,
	tmpsurveyxml.CommServIP,
	tmpsurveyxml.CommServGUID,
	tmpsurveyxml.CustomerName,
	tmpsurveyxml.LogDate,
	tmpsurveyxml.RunningTime,
	tmpsurveyxml.CommServTZ,
	csInfo.n.value('@JobPriority','INTEGER') AS JobPriority,
    csInfo.n.value('@ClientCount','BIGINT') AS ClientCount
FROM
	dbo.RptGetSurveyResultsFunc(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId) AS tmpsurveyxml
	CROSS apply tmpsurveyxml.surveyxml.nodes('/ClientJobPriorityInfo') AS csInfo(n)
IF(@blaggregate=1)
SELECT DISTINCT
	'Priority Level : ' + CAST(JobPriority AS VARCHAR(2)) AS 'Job Priority',
	SUM(ClientCount) AS 'Client Count',
	COUNT(CommServUniqueId) AS 'CommCell Count'
FROM #tmpClientsByJobPriority AS info
GROUP BY JobPriority
ELSE
BEGIN
IF @i_CommServUniqueID = 0
BEGIN
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
SELECT
	ccMap.CommServUniqueId AS 'CommServ UniqueId',
	ccMap.CommCellID AS 'CommCell ID',
	ccMap.CommServIP AS 'CommServe IP<HIDDEN>',
	CASE
		WHEN @param_isPrivate = 1 THEN ISNULL(ccMap.CommServName, '')
		ELSE ISNULL(ccMap.CustomerName,'') + ' - ' + ISNULL(ccMap.CommServName, '')
	END AS 'CommCell Name',
	ccMap.CommServGUID AS 'CommServer GUID',
	DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME>',
	ISNULL(info.CommServTZ, '')  AS 'TimeZone',
	CASE
		WHEN info.RunningTime = -1 THEN 'N/A'
		ELSE CAST(info.RunningTime AS VARCHAR(MAX))
	END AS 'Running Time in Seconds',
	'Priority Level : ' + CAST(JobPriority AS VARCHAR(2)) AS 'Job Priority',
	ClientCount AS 'Client Count'
FROM #tmpClientsByJobPriority AS info
	INNER JOIN cf_CommcellIdNameMap AS ccMap
		ON info.CommServUniqueId = ccMap.ID
ORDER BY info.LogDate DESC, info.CustomerName ASC
END
ELSE
SELECT
	info.CommServUniqueId AS 'CommServ UniqueId',
	DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME>',
	CASE
		WHEN info.RunningTime = -1 THEN 'N/A'
		ELSE CAST(info.RunningTime AS VARCHAR(MAX))
	END AS 'Running Time in Seconds',
	'Priority Level : ' + CAST(JobPriority AS VARCHAR(2)) AS 'Job Priority',
	ClientCount AS 'Client Count'
FROM #tmpClientsByJobPriority AS info
ORDER BY info.LogDate DESC, info.CustomerName ASC
END
IF (OBJECT_ID('tempdb.dbo.#tmpClientsByJobPriority') IS NOT NULL)
	DROP TABLE #tmpClientsByJobPriority
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptClientsByJobPriority')
	delete from GxQscripts where name = 'RptClientsByJobPriority'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptClientsByJobPriority')
	delete from GXDBVersions where aliasname = 'RptClientsByJobPriority'
GO

insert into GXDBVersions values(2, 'RptClientsByJobPriority',  '00010006000000000000', 'RptClientsByJobPriority', '00010006000000000000')
GO

