

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptCommCellParamAudit.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptCommCellParamAudit.sp,v $ $Id: RptCommCellParamAudit.sp,v 1.4.56.3 2020/12/17 02:49:29 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptCommCellParamAudit')
BEGIN
	print '>>> Drop Stored Procedure: RptCommCellParamAudit <<<'
	drop procedure RptCommCellParamAudit
END
IF EXISTS (select * from GxQscripts where name='RptCommCellParamAudit')
	delete from GxQscripts where name = 'RptCommCellParamAudit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommCellParamAudit')
	delete from GXDBVersions where aliasname = 'RptCommCellParamAudit'
GO
print '... Creating Procedure: RptCommCellParamAudit'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptCommCellParamAudit
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @bAggregate INT = 1,
  @i_stdCommServUniqueID INT = 0,
  @i_CommServUniqueID INT = 0,
  @i_PropertyGroup VARCHAR(32) = ''
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 159
-- default is for all properties
DECLARE @i_Category INT = 0
IF		@i_PropertyGroup = 'Global Filters'
	SET @i_Category = 1
ELSE IF	@i_PropertyGroup = 'Job Manager'
	SET @i_Category = 2
ELSE IF	@i_PropertyGroup = 'Media Manager'
	SET @i_Category = 3
ELSE IF	@i_PropertyGroup = 'Browse/Search/Recovery'
	SET @i_Category = 4
IF	@i_stdCommServUniqueID IN (0, @i_CommServUniqueID)
	RETURN
DECLARE @stdCustomerName	VARCHAR(256) = ''
DECLARE @isPrivate 			INT = 0
SELECT	@isPrivate = ISNULL(CAST(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
IF	@isPrivate = 0
	SELECT @stdCustomerName = CustomerName FROM cf_CommcellIdNameMap WHERE ID = @i_stdCommServUniqueID
CREATE	TABLE #LatestResult (CommServId INT, SurveyResultId BIGINT, LogDate DATETIME)
INSERT	INTO #LatestResult
SELECT	CommServUniqueId, SurverResultId, LogDate
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, 0, 1, NULL, NULL, @i_UserId,@i_GroupId)
WHERE	(@stdCustomerName = '' OR CustomerName = @stdCustomerName)
	AND (@i_CommServUniqueID = 0 OR CommServUniqueId IN (@i_stdCommServUniqueID, @i_CommServUniqueID))
CREATE TABLE #DiffParams (
	CommServId INT, Category INT, Property VARCHAR(64), ParamName VARCHAR(256), ParamValue VARCHAR(MAX), stdValue VARCHAR(MAX), DefaultValue VARCHAR(MAX)
)
CREATE TABLE #stdParams  (
	Category INT, Property VARCHAR(64), ParamName VARCHAR(256), ParamValue VARCHAR(MAX), DefaultValue VARCHAR(MAX)
)
INSERT	INTO #stdParams
SELECT	P.Category, P.Property, P.ParamName, P.ParamValue, P.DefaultValue
FROM	cf_SurveyCommCellParams P INNER JOIN #LatestResult R
		ON R.SurveyResultId = P.SurveyResultId AND R.CommServId = @i_stdCommServUniqueID AND @i_Category IN (0, P.Category)
INSERT	INTO #DiffParams
SELECT	R.CommServId, P.Category, P.Property, P.ParamName, P.ParamValue, ISNULL(S.ParamValue, P.DefaultValue), P.DefaultValue
FROM	cf_SurveyCommCellParams P INNER JOIN #LatestResult R
		ON R.SurveyResultId = P.SurveyResultId AND R.CommServId <> @i_stdCommServUniqueID AND @i_Category IN (0, P.Category)
		LEFT OUTER JOIN #stdParams S
		ON P.Category = S.Category AND P.Property = S.Property AND P.ParamName = S.ParamName
WHERE	S.ParamName IS NULL AND P.ParamValue <> P.DefaultValue
	 OR S.ParamName IS NOT NULL AND P.ParamValue <> S.ParamValue
UNION
SELECT	C.CommServId, S.Category, S.Property, S.ParamName, ISNULL(T.ParamValue, S.DefaultValue), S.ParamValue, S.DefaultValue
FROM	#stdParams S
		CROSS JOIN
		(SELECT DISTINCT CommServId FROM #LatestResult WHERE CommServId <> @i_stdCommServUniqueID) C
		LEFT OUTER JOIN
		(SELECT R.CommServId, P.Category, P.Property, P.ParamName, P.ParamValue, P.DefaultValue
		FROM	cf_SurveyCommCellParams P
				INNER JOIN #LatestResult R
				ON R.SurveyResultId = P.SurveyResultId AND R.CommServId <> @i_stdCommServUniqueID AND @i_Category IN (0, P.Category)
		) T ON C.CommServId = T.CommServId AND S.Category = T.Category AND S.Property = T.Property AND S.ParamName = T.ParamName
WHERE	T.ParamName IS NULL AND S.ParamValue <> S.DefaultValue
	 OR T.ParamName IS NOT NULL AND S.ParamValue <> T.ParamValue
DELETE	#DiffParams
FROM	#DiffParams D
		INNER JOIN
		(SELECT CommServId, ParamName FROM #DiffParams
		  WHERE Category = 2 AND Property = 'Job Restart - Enable Total Running Time'
		) T  ON D.CommServId = T.CommServId AND Category = 2 AND D.ParamName = T.ParamName
			AND D.Property IN ('Job Restart - Total Running Time', 'Job Restart - Kill Job if Running Time Expires')
DELETE	#DiffParams
FROM	#DiffParams D
		INNER JOIN
		(SELECT CommServId, Property FROM #DiffParams
		  WHERE Category = 2 AND Property LIKE 'Job Status on Errors - %' AND ParamName = 'Enabled'
		) T ON D.CommServId = T.CommServId AND D.Property = T.Property AND D.ParamName <> 'Enabled'
IF @bAggregate = 1
BEGIN
	DECLARE	@TblSummary TABLE (CommServId INT, GlobalFilters INT, JMParams INT, MMParams INT, BrowseParams INT, AllParams INT)
	INSERT	INTO @TblSummary
	SELECT	P.CommServId, ISNULL([1], 0), ISNULL([2], 0), ISNULL([3], 0), ISNULL([4], 0),
			ISNULL([1], 0) + ISNULL([2], 0) + ISNULL([3], 0) + ISNULL([4], 0)
	FROM	(SELECT	CommServId, Category, COUNT(*) AS Counts
			FROM	#DiffParams
			GROUP BY CommServId, Category) AS S
			PIVOT (MAX(Counts) FOR S.Category IN ([1], [2], [3], [4])) AS P
	SELECT	'All CommCells' AS 'CommCell',
			'' AS 'CommServ UniqueId',
			'' AS 'CommCell ID',
			SUM(GlobalFilters)	AS 'Global Filters',
			SUM(JMParams)		AS 'Job Manager',
			SUM(MMParams)		AS 'Media Manager',
			SUM(BrowseParams)	AS 'Browse/Search/Recovery',
			SUM(AllParams)		AS 'Any',
			'' AS 'Collection Time (Time Zone)',
			-1 AS 'FirstOrder<DONOTSHOW>'
	FROM	@TblSummary
	UNION ALL
	SELECT	CASE
				WHEN @isPrivate = 1 THEN CS.CommServName
				ELSE CS.CustomerName + ' - ' + CS.CommServName
			END AS 'CommCell',
			CS.ID			AS 'CommServ UniqueId',
			CS.CommCellID	AS 'CommCell ID',
			D.GlobalFilters	AS 'Global Filters',
			D.JMParams		AS 'Job Manager',
			D.MMParams		AS 'Media Manager',
			D.BrowseParams	AS 'Browse/Search/Recovery',
			D.AllParams		AS 'Any',
			CONVERT(VARCHAR(20), LR.LogDate, 100) + ' (' + CS.CommServTZ + ')' AS 'Collection Time (Time Zone)',
			0				AS 'FirstOrder<DONOTSHOW>'
	FROM	@TblSummary D
			INNER JOIN cf_CommcellIdNameMap CS ON D.CommServId = CS.ID
			INNER JOIN #LatestResult LR ON D.CommServId = LR.CommServId
	ORDER BY 'FirstOrder<DONOTSHOW>', 'CommCell'
END
ELSE
BEGIN
	IF	@i_Category > 0
		DELETE #DiffParams WHERE Category <> @i_Category
	IF @i_CommServUniqueID = 0
		SELECT	CASE
					WHEN @isPrivate = 1 THEN CS.CommServName
					ELSE CS.CustomerName + ' - ' + CS.CommServName
				END			AS 'CommCell',
				CASE P.Category	WHEN 1 THEN 'Global Filters' WHEN 2 THEN 'Job Manager' WHEN 3 THEN 'Media Manager' WHEN 4 THEN 'Browse/Search/Recovery'
				END	AS 'Category',
				P.Property	AS 'Property',
				P.ParamName	AS 'Parameter',
				CASE WHEN P.ParamName = 'Job Restart - Total Running Time'
					 THEN CAST(CAST(P.ParamValue AS INT)/3600 AS VARCHAR(256)) + ' hr(s) ' + CAST((CAST(P.ParamValue AS INT)%3600)/60 AS VARCHAR(256)) + ' min(s)'
					 ELSE P.ParamValue
				END			AS 'Value',
				CASE WHEN P.ParamName = 'Job Restart - Total Running Time'
					 THEN CAST(CAST(P.stdValue AS INT)/3600 AS VARCHAR(256)) + ' hr(s) ' + CAST((CAST(P.stdValue AS INT)%3600)/60 AS VARCHAR(256)) + ' min(s)'
					 ELSE P.stdValue
				END			AS 'Template Value'
		FROM	#DiffParams P
				INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
		ORDER BY CS.CommServName, P.Category, P.Property, P.ParamName
	ELSE
		SELECT	CASE P.Category	WHEN 1 THEN 'Global Filters' WHEN 2 THEN 'Job Manager' WHEN 3 THEN 'Media Manager' WHEN 4 THEN 'Browse/Search/Recovery'
				END	AS 'Category',
				P.Property	AS 'Property',
				P.ParamName	AS 'Parameter',
				CASE WHEN P.ParamName = 'Job Restart - Total Running Time'
					 THEN CAST(CAST(P.ParamValue AS INT)/3600 AS VARCHAR(256)) + ' hr(s) ' + CAST((CAST(P.ParamValue AS INT)%3600)/60 AS VARCHAR(256)) + ' min(s)'
					 ELSE P.ParamValue
				END			AS 'Value',
				CASE WHEN P.ParamName = 'Job Restart - Total Running Time'
					 THEN CAST(CAST(P.stdValue AS INT)/3600 AS VARCHAR(256)) + ' hr(s) ' + CAST((CAST(P.stdValue AS INT)%3600)/60 AS VARCHAR(256)) + ' min(s)'
					 ELSE P.stdValue
				END			AS 'Template Value'
		FROM	#DiffParams P
		ORDER BY P.Category, P.Property, P.ParamName
END
DROP TABLE #LatestResult
DROP TABLE #stdParams
DROP TABLE #DiffParams
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptCommCellParamAudit')
	delete from GxQscripts where name = 'RptCommCellParamAudit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommCellParamAudit')
	delete from GXDBVersions where aliasname = 'RptCommCellParamAudit'
GO

insert into GXDBVersions values(2, 'RptCommCellParamAudit',  '00010004005600030000', 'RptCommCellParamAudit', '00010004005600030000')
GO

