

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptCommCellUsageCount.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptCommCellUsageCount.sp,v $ $Id: RptCommCellUsageCount.sp,v 1.4.2.4 2019/05/14 18:47:10 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptCommCellUsageCount')
BEGIN
	print '>>> Drop Stored Procedure: RptCommCellUsageCount <<<'
	drop procedure RptCommCellUsageCount
END
IF EXISTS (select * from GxQscripts where name='RptCommCellUsageCount')
	delete from GxQscripts where name = 'RptCommCellUsageCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommCellUsageCount')
	delete from GXDBVersions where aliasname = 'RptCommCellUsageCount'
GO
print '... Creating Procedure: RptCommCellUsageCount'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptCommCellUsageCount
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 8
DECLARE @i_QueryId2 BIGINT = 1
DECLARE @param_isPrivate INT = 0
SELECT @param_isPrivate = Isnull(Cast(value AS INT), 0) FROM   cf_surveyconfig WHERE  name = 'isPrivate'
SELECT [Entities], [Count]
FROM
(SELECT SUM(ISNULL(csInfo.TotalActiveClients, 0)) -
		SUM(ISNULL(csInfo.TotalLaptops, 0)) -
		SUM(ISNULL(csInfo.TotalActiveVMs, 0)) AS [Servers],
		SUM(ISNULL(csInfo.TotalLaptops, 0)) AS [Laptops],
		SUM(ISNULL(csInfo.TotalActiveVMs, 0)) AS [VMs]
FROM   cf_SurveyClientStatisticsInfo AS csInfo WITH (nolock)
    INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId) AS results
    ON results.SurverResultId = csInfo.SurveyResultId) AS S
UNPIVOT ([Count] FOR [Entities] IN ([Servers], [Laptops], [VMs])) AS U
UNION
SELECT [Entities], [Count]
FROM
(SELECT SUM(ISNULL(csInfo.EndpointUsers, 0))+
        SUM(ISNULL(csInfo.SharingUsers, 0))+
        SUM(ISNULL(csInfo.eDiscoveryUsers, 0)) AS [Users]
FROM   cf_SurveyCapacityLicenseUsage AS csInfo WITH (nolock)
        INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId2, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId) AS results
        ON results.SurverResultId = csInfo.SurveyResultId) AS S
UNPIVOT ([Count] FOR [Entities] IN ([Users])) AS U
UNION
SELECT [Entities], [Count]
FROM
(SELECT SUM(ISNULL(csInfo.UsedDiskSpaceMB, 0)) AS [Disk Library],
        SUM(ISNULL(csInfo.DedupDataSizeMB, 0)) AS [Dedupe Store],
        SUM(ISNULL(csInfo.CIObjects, 0)) AS [CI Objects]
FROM   cf_SurveyCapacityLicenseUsage AS csInfo WITH (nolock)
        INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId2, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId) AS results
        ON results.SurverResultId = csInfo.SurveyResultId) AS S
UNPIVOT ([Count] FOR [Entities] IN ([Disk Library], [Dedupe Store], [CI Objects])) AS U
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptCommCellUsageCount')
	delete from GxQscripts where name = 'RptCommCellUsageCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommCellUsageCount')
	delete from GXDBVersions where aliasname = 'RptCommCellUsageCount'
GO

insert into GXDBVersions values(2, 'RptCommCellUsageCount',  '00010004000200040000', 'RptCommCellUsageCount', '00010004000200040000')
GO

