

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptCopyRedundancySLA.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptCopyRedundancySLA.sp,v $ $Id: RptCopyRedundancySLA.sp,v 1.1.2.11 2020/12/17 02:48:14 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptCopyRedundancySLA')
BEGIN
	print '>>> Drop Stored Procedure: RptCopyRedundancySLA <<<'
	drop procedure RptCopyRedundancySLA
END
IF EXISTS (select * from GxQscripts where name='RptCopyRedundancySLA')
	delete from GxQscripts where name = 'RptCopyRedundancySLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCopyRedundancySLA')
	delete from GXDBVersions where aliasname = 'RptCopyRedundancySLA'
GO
print '... Creating Procedure: RptCopyRedundancySLA'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptCopyRedundancySLA
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NULL
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 211
/*
DECLARE @strGood VARCHAR(10) = '1_Good'
DECLARE @strInfo VARCHAR(10) = '2_Info'
DECLARE @strwarning VARCHAR(10) = '3_Warning'
DECLARE @strCritical VARCHAR(10) = '4_Critical'
DECLARE @criticalVal int
DECLARE @warningVal int
SELECT	@warningVal = WarningThreshold,
		@criticalVal =CriticalThreshold
FROM	cf_SurveyHealthParam where queryId = @i_QueryId
*/
CREATE TABLE #LatestResult (SurveyResultId BIGINT, CommServUniqueId INT, DisplayName NVARCHAR(256))
INSERT	INTO #LatestResult
SELECT	SurverResultId, CommServUniqueId, DisplayName
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
CREATE TABLE #ClientsMissedSLA (SurveyResultId BIGINT, CommServUniqueId INT, ClientId INT)
INSERT	INTO #ClientsMissedSLA
SELECT	DISTINCT SurveyResultId, CommServUniqueId, ClientId
FROM	cf_SurveySLADetails AS S WITH (NOLOCK)
		INNER JOIN (
			SELECT	SurverResultId, CommServUniqueId
			FROM	dbo.cf_SurveyResultFuncV1(242, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
			UNION
			SELECT	SurverResultId, CommServUniqueId
			FROM	dbo.cf_SurveyResultFuncV1(27, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
			) R ON R.SurverResultId = S.SurveyResultId AND (S.Days = 30 OR S.Days < 0)
IF @blaggregate = 1
BEGIN
	CREATE TABLE #Summary (SurveyResultId BIGINT, ClientsTotal INT, ClientsMet INT)
	INSERT	INTO #Summary
	SELECT	P.SurveyResultId, ISNULL([0], 0) + ISNULL([1], 0), ISNULL([1], 0)
	FROM	(
			SELECT	R.SurveyResultId,
					(CASE WHEN M.ClientId IS NULL AND MinRedundancy >= CopyRedundancy AND MaxBehindDays <= CopyBehindDays THEN 1 ELSE 0 END) AS RedundancyMet,
					COUNT(DISTINCT S.ClientId) AS ClientCount
			FROM	cf_SurveyRecoverabilitySLA AS S WITH (NOLOCK)
					INNER JOIN #LatestResult R ON R.SurveyResultId = S.SurveyResultId
					LEFT OUTER JOIN #ClientsMissedSLA M ON R.CommServUniqueId = M.CommServUniqueId AND S.ClientId = M.ClientId
			WHERE	LastJobId > 0 OR M.ClientId IS NOT NULL
			GROUP BY R.SurveyResultId, (CASE WHEN M.ClientId IS NULL AND MinRedundancy >= CopyRedundancy AND MaxBehindDays <= CopyBehindDays THEN 1 ELSE 0 END)
			) AS S
			PIVOT (
				MAX(ClientCount) FOR RedundancyMet IN ([0], [1])
			) AS P
	SELECT 	R.CommServUniqueId  AS 'CommServ UniqueId',
			R.DisplayName AS 'CommCell Name',
			ClientsMet    AS 'Clients Met Redundancy',
			(ClientsTotal - ClientsMet) AS 'Clients Not Met Redundancy',
			CAST((CASE WHEN ClientsTotal > 0 THEN ClientsMet*100.0/ClientsTotal ELSE 0 END) AS INT) AS 'Redundancy SLA (%)'/*,
			(CASE
					WHEN ClientsTotal > 0 and ClientsMet*100/ClientsTotal < @criticalVal THEN @strCritical
					WHEN ClientsTotal > 0 and ClientsMet*100/ClientsTotal < @warningVal THEN @strWarning
					ELSE @strGood END
			) AS 'Status<HEALTH_STATUS>'*/
	FROM	#Summary AS S INNER JOIN #LatestResult AS R ON S.SurveyResultId = R.SurveyResultId
	ORDER BY 'Redundancy SLA (%)' ASC
	DROP TABLE #Summary
END
ELSE
IF @blaggregate = 2
BEGIN
	CREATE TABLE #StoragePolicy (CommServUniqueId INT, PolicyId INT, nAuxCopies INT, CopyRedundancy INT)
	INSERT	INTO #StoragePolicy
	SELECT	R.CommServUniqueId, (CASE WHEN SA.DataPolicyId > 1 THEN SA.DataPolicyId ELSE SA.LogPolicyId END),
			MIN(S.nAuxCopies), MAX(CopyRedundancy)
	FROM	cf_SurveyRecoverabilitySLA AS S WITH (NOLOCK)
			INNER JOIN #LatestResult R ON R.SurveyResultId = S.SurveyResultId
			INNER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK) ON R.CommServUniqueId = SA.CommServUniqueId AND S.AppId = SA.AppId
				AND S.AppId > 0 AND SA.Deleted = 0
	WHERE	S.LastJobId > 0 AND S.nAuxCopies < S.CopyRedundancy
	GROUP BY R.CommServUniqueId, (CASE WHEN SA.DataPolicyId > 1 THEN SA.DataPolicyId ELSE SA.LogPolicyId END)
	SELECT 	DISTINCT R.CommServUniqueId  AS 'CommServ UniqueId',
			R.DisplayName AS 'CommCell Name',
			C.PolicyName  AS 'Storage Policy',
			S.nAuxCopies  AS 'Redundant Copies',
			S.CopyRedundancy AS 'Copy Redundancy Required'
	FROM	#StoragePolicy AS S
			INNER JOIN #LatestResult AS R ON S.CommServUniqueId = R.CommServUniqueId
			INNER JOIN cf_SurveyCopyBasicRetention C WITH (NOLOCK) ON R.CommServUniqueId = C.CommServUniqueId AND S.PolicyId = C.PolicyId
	ORDER BY 'CommCell Name', 'Storage Policy'
	DROP TABLE #StoragePolicy
END
ELSE
BEGIN
	CREATE TABLE #ClientGroupsString (CommservUniqueId INT, ClientId INT, ClientGroups NVARCHAR(MAX))
	EXEC GetClientGroupsString @i_CommServUniqueID
	CREATE TABLE #SubclientsMissedSLA (CommServUniqueId INT, ClientId INT, AppId INT)
	INSERT	INTO #SubclientsMissedSLA
	SELECT	M.CommServUniqueId, S.ClientId, S.AppId
	FROM	cf_SurveySLADetails AS S WITH (NOLOCK)
		INNER JOIN #ClientsMissedSLA M ON S.SurveyResultId = M.SurveyResultId AND S.ClientId = M.ClientId
	SELECT 	R.CommServUniqueId AS 'CommServ UniqueId',
			ISNULL (CL.ClientDisplayName, CL.clientName) AS [Client],
			CL.clientName  AS [Client(classic)<HIDDEN>],
			ISNULL(SA.AgentName, 'N/A') + CASE WHEN ISNULL(SA.AppTypeId, 0) = 106 AND CL.ClientId <> SA.ClientId THEN ' in ' + SA.ClientName ELSE '' END AS 'Agent',
			ISNULL(SA.InstanceName, 'N/A') As 'Instance',
			ISNULL(SA.BackupsetName, 'N/A') AS 'Backupset',
			ISNULL(SA.SubclientName, 'N/A') AS 'Subclient',
			ISNULL((SELECT TOP 1 PolicyName FROM cf_SurveyCopyBasicRetention WITH (NOLOCK) WHERE CommservUniqueId = R.CommServUniqueId
				AND PolicyId = (CASE WHEN SA.DataPolicyId > 1 THEN SA.DataPolicyId ELSE SA.LogPolicyId END) AND Deleted = 0), 'N/A') AS 'Storage Policy',
			CASE WHEN nAuxCopies >= 0 THEN nAuxCopies ELSE 0 END AS 'Redundant Copies',
			CASE WHEN nAuxCopies > 0 AND DaysBehind >= 0 THEN DaysBehind ELSE 0 END AS 'Days Fallen Behind',
			CopyRedundancy AS 'Copy Redundancy Required',
			CopyBehindDays AS 'Copy Behind Days Allowed',
			CASE WHEN nAuxCopies >= 0 AND nAuxCopies < CopyRedundancy THEN 'Less Redundancy'
				 WHEN DaysBehind >= 0 AND DaysBehind > CopyBehindDays THEN 'Aux Copy Fallen Behind'
				 WHEN M.ClientId IS NOT NULL THEN 'Missed Backup SLA'
				 WHEN nAuxCopies >= CopyRedundancy AND DaysBehind <= CopyBehindDays THEN 'Met Copy Redundancy SLA'
				 ELSE 'Missed Copy Redundancy SLA'
			END AS [Status],
			ISNULL(CGS.ClientGroups, '') AS 'Client Groups<HIDDEN>'
	FROM 	cf_SurveyRecoverabilitySLA AS S WITH (NOLOCK)
			INNER JOIN #LatestResult R ON R.SurveyResultId = S.SurveyResultId
			INNER JOIN cf_SurveyClient CL WITH (NOLOCK) ON R.CommServUniqueId = CL.CommServUniqueId AND S.ClientId = CL.ClientId AND CL.Deleted = 0
			INNER JOIN #SubclientsMissedSLA M ON CL.CommServUniqueId = M.CommServUniqueId AND CL.ClientId = M.ClientId
			LEFT OUTER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK) ON M.CommServUniqueId = SA.CommServUniqueId AND M.AppId = SA.AppId AND M.AppId > 0
			LEFT OUTER JOIN #ClientGroupsString CGS ON CL.CommServUniqueId = CGS.CommServUniqueId AND CL.ClientId = CGS.ClientId
	WHERE	S.AppId <= 0
		AND (M.ClientId IS NOT NULL OR nAuxCopies < CopyRedundancy OR DaysBehind > CopyBehindDays)
	UNION ALL
	SELECT 	R.CommServUniqueId AS 'CommServ UniqueId',
			ISNULL (CL.ClientDisplayName, CL.clientName) AS [Client],
			CL.clientName  AS [Client(classic)<HIDDEN>],
			ISNULL(SA.AgentName, 'N/A') + CASE WHEN ISNULL(SA.AppTypeId, 0) = 106 AND CL.ClientId <> SA.ClientId THEN ' in ' + SA.ClientName ELSE '' END AS 'Agent',
			ISNULL(SA.InstanceName, 'N/A') As 'Instance',
			ISNULL(SA.BackupsetName, 'N/A') AS 'Backupset',
			ISNULL(SA.SubclientName, 'N/A') AS 'Subclient',
			ISNULL((SELECT TOP 1 PolicyName FROM cf_SurveyCopyBasicRetention WITH (NOLOCK) WHERE CommservUniqueId = R.CommServUniqueId
				AND PolicyId = (CASE WHEN SA.DataPolicyId > 1 THEN SA.DataPolicyId ELSE SA.LogPolicyId END) AND Deleted = 0), 'N/A') AS 'Storage Policy',
			CASE WHEN nAuxCopies >= 0 THEN nAuxCopies ELSE 0 END AS 'Redundant Copies',
			CASE WHEN nAuxCopies > 0 AND DaysBehind >= 0 THEN DaysBehind ELSE 0 END AS 'Days Fallen Behind',
			CopyRedundancy AS 'Copy Redundancy Required',
			CopyBehindDays AS 'Copy Behind Days Allowed',
			CASE WHEN nAuxCopies >= 0 AND nAuxCopies < CopyRedundancy THEN 'Less Redundancy'
				 WHEN DaysBehind >= 0 AND DaysBehind > CopyBehindDays THEN 'Aux Copy Fallen Behind'
				 WHEN M.ClientId IS NOT NULL THEN 'Missed Backup SLA'
				 WHEN nAuxCopies >= CopyRedundancy AND DaysBehind <= CopyBehindDays THEN 'Met Copy Redundancy SLA'
				 ELSE 'Missed Copy Redundancy SLA'
			END AS [Status],
			ISNULL(CGS.ClientGroups, '') AS 'Client Groups<HIDDEN>'
	FROM 	cf_SurveyRecoverabilitySLA AS S WITH (NOLOCK)
			INNER JOIN #LatestResult R ON R.SurveyResultId = S.SurveyResultId
			INNER JOIN cf_SurveyClient CL WITH (NOLOCK) ON R.CommServUniqueId = CL.CommServUniqueId AND S.ClientId = CL.ClientId AND CL.Deleted = 0
			LEFT OUTER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK) ON CL.CommServUniqueId = SA.CommServUniqueId AND S.AppId = SA.AppId AND S.AppId > 0
			LEFT OUTER JOIN #ClientGroupsString CGS ON CL.CommServUniqueId = CGS.CommServUniqueId AND CL.ClientId = CGS.ClientId
			LEFT OUTER JOIN #SubclientsMissedSLA M ON CL.CommServUniqueId = M.CommServUniqueId AND CL.ClientId = M.ClientId AND S.AppId = M.AppId
	WHERE	S.AppId > 0 AND (LastJobId > 0 OR M.ClientId IS NOT NULL)
		AND (M.ClientId IS NOT NULL OR nAuxCopies < CopyRedundancy OR DaysBehind > CopyBehindDays)
	ORDER BY 'Client', 'Agent', 'Instance', 'Backupset', 'Subclient'
	DROP TABLE #ClientGroupsString
	DROP TABLE #SubclientsMissedSLA
END
DROP TABLE #LatestResult
DROP TABLE #ClientsMissedSLA
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0
  DECLARE @blLatestSurvey INT			= 1
  DECLARE @i_CommServUniqueID INT		= 11065
  DECLARE @i_LogDateStart DATETIME		= NULL
  DECLARE @i_LogDateEND DATETIME		= NULL
exec RptCopyRedundancySLA @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey,
                               @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND
*/

IF EXISTS (select * from GxQscripts where name = 'RptCopyRedundancySLA')
	delete from GxQscripts where name = 'RptCopyRedundancySLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCopyRedundancySLA')
	delete from GXDBVersions where aliasname = 'RptCopyRedundancySLA'
GO

insert into GXDBVersions values(2, 'RptCopyRedundancySLA',  '00010001000200110000', 'RptCopyRedundancySLA', '00010001000200110000')
GO

