

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptDDBDiskSpaceUsage.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptDDBDiskSpaceUsage.sp,v $ $Id: RptDDBDiskSpaceUsage.sp,v 1.1.2.23 2020/12/17 02:49:02 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptDDBDiskSpaceUsage')
BEGIN
	print '>>> Drop Stored Procedure: RptDDBDiskSpaceUsage <<<'
	drop procedure RptDDBDiskSpaceUsage
END
IF EXISTS (select * from GxQscripts where name='RptDDBDiskSpaceUsage')
	delete from GxQscripts where name = 'RptDDBDiskSpaceUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDDBDiskSpaceUsage')
	delete from GXDBVersions where aliasname = 'RptDDBDiskSpaceUsage'
GO
print '... Creating Procedure: RptDDBDiskSpaceUsage'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptDDBDiskSpaceUsage
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 61
DECLARE @Never  BIGINT= CAST(0x7FFFFFFFFF AS bigint)-1
DECLARE @NA  BIGINT =CAST(0x7FFFFFFFFF AS bigint)
DECLARE @criticalThreshold int = 30
DECLARE @warningThreshold int = 90
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @useStoredPrediction BIT = ISNULL((SELECT Value from cf_SurveyConfig WHERE Name = 'useStoredPrediction'), 0)
DECLARE @strGood		VARCHAR(10) = '1_Good'
DECLARE @strAttention	VARCHAR(10) = '1a_Good'
DECLARE @strInfo		VARCHAR(10) = '2_Info'
DECLARE @strwarning		VARCHAR(10) = '3_Warning'
DECLARE @strCritical	VARCHAR(10) = '4_Critical'
DECLARE @criticalVal	INT = 0
DECLARE @warningVal		INT = 0
SELECT	@warningVal = WarningThreshold,
		@criticalVal =CriticalThreshold
FROM	cf_SurveyHealthParam WITH (NOLOCK)
WHERE	QueryId = 206
DECLARE @CurrWeek DATE = DATEADD(WEEK, DATEDIFF(WEEK, 0, GETDATE()), 0)
DECLARE	@MaxNumOfWeeksforGrowthRate INT = 12
DECLARE @FirstWeek DATE = DATEADD(WEEK, -@MaxNumOfWeeksforGrowthRate, @CurrWeek)
IF object_id('tempdb.dbo.#LatestResult') is not null DROP TABLE #LatestResult
CREATE	TABLE #LatestResult (
		CommServUniqueId INT,
		CommCellId VARCHAR(32),
		CommServIP VARCHAR(256),
		DisplayName      NVARCHAR(256),
		SurveyResultId BIGINT)
INSERT	INTO #LatestResult
SELECT	CommServUniqueId,CommCellID, CommServIP,DisplayName,SurverResultId
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId,  @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId,@i_GroupId)
 -- Create tmp predict table to store calculated predicted data
IF object_id('tempdb.dbo.#PredictionData') is not null DROP TABLE #PredictionData
CREATE TABLE #PredictionData (
	CommServUniqueId INT,
	SubstoreId INT,
	DaysToBeFull BIGINT,
	DateToBeFull BIGINT
)
-- Get prediction data
IF @useStoredPrediction = 0 -- Use default linear regression model
BEGIN
	-- Create tmp tables for Growth data calculation
	IF object_id('tempdb.dbo.#GrowthData') IS NOT null DROP TABLE #GrowthData
	CREATE TABLE #GrowthData (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(MAX), X INT, Y FLOAT, SeqId INT) -- for input
	IF object_id('tempdb.dbo.#GrowthRate') IS NOT null DROP TABLE #GrowthRate
	CREATE TABLE #GrowthRate (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(MAX), GrowthRate FLOAT, GrowthStDev FLOAT) -- for output
	-- Fill input data
	INSERT INTO #GrowthData
		select B.CommServUniqueId, B.SubstoreId, B.EntityName, B.Weeks, max(B.SpaceMB),
		ROW_NUMBER() OVER (PARTITION BY B.CommServUniqueId, B.SubstoreId, B.EntityName ORDER BY B.Weeks desc)
		from
		(SELECT S.CommServUniqueId, S.SubstoreId, '' as EntityName, DATEDIFF(WEEK, S.WeekStart, @CurrWeek) as Weeks, ISNULL(S.DDBUsedDiskSpaceMB, -1) as SpaceMB
		FROM cf_SurveyDeDupStoreConfigPeakSize S
					INNER JOIN (
							select A.CommServUniqueId, A.SubstoreId, isnull(max(A.DDBDiskTotalSpaceMB),0) as TotalCapacityMBMax
							from cf_SurveyDeDupStoreConfig as A
							INNER JOIN #LatestResult AS result
							ON result.SurveyResultId = A.SurveyResultId
							group by A.CommServUniqueId, A.SubstoreId
					) T ON S.CommservUniqueId = T.CommServUniqueId AND S.SubstoreId = T.SubstoreId
		WHERE   S.WeekStart >= @FirstWeek AND ISNULL(S.DDBUsedDiskSpaceMB, -1) > 0 and T.TotalCapacityMBMax > 0) as B
		group by B.CommServUniqueId, B.SubstoreId, B.EntityName, B.Weeks
	-- Run Growh rate calculation
	EXEC GetLinearGrowthRate 0
	-- Insert tmp prediction data
	INSERT INTO #PredictionData
		SELECT F.*,
				CASE
				WHEN F.DaysToBeFull IS NULL THEN @NA
				WHEN F.DaysToBeFull = @NA THEN @NA
				WHEN F.DaysToBeFull = @Never THEN @Never
				ELSE
					dbo.getUnixtimebig(DATEADD(DAY, F.DaysToBeFull, GETUTCDATE()))
				END -- DateToBeFull
		FROM (
			SELECT 	S.CommServUniqueId, S.SubstoreId,
					CAST(dbo.CalculateDaysToBeFull (S.DDBDiskFreeSpaceMB, R.GrowthRate/7.0, S.LogDateUTC) AS BIGINT) AS DaysToBeFull-- DaysToBeFull
			FROM cf_SurveyDeDupStoreConfig AS S
			INNER JOIN #LatestResult AS U
			on U.SurveyResultId = S.SurveyResultId
			left join #GrowthRate R
			on S.CommServUniqueId = R.CommServUniqueId
			and S.SubstoreId = R.EntityId
			where (S.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
		) AS F
	-- Drop tmp tables
	IF object_id('tempdb.dbo.#GrowthData') IS NOT null DROP TABLE #GrowthData
	IF object_id('tempdb.dbo.#GrowthRate') IS NOT null DROP TABLE #GrowthRate
END
ELSE -- Use prediction data from CvStatAnalysis
BEGIN
	INSERT INTO #PredictionData
		SELECT DISTINCT
			I.CommServUniqueId, I.SubstoreId,
			I.DaysToBeFull,
			CASE
			WHEN I.DateToBeFull IS NULL THEN I.DaysToBeFull
			ELSE
				dbo.getUnixtimebig(I.DateToBeFull)
			END AS DateToBeFull
		FROM cf_SurveyDeDupStoreConfig AS S
		INNER JOIN #LatestResult AS U
		ON U.SurveyResultId = S.SurveyResultId
		LEFT JOIN (
			SELECT CommServUniqueId, SubstoreId, MAX(LogDateUTC) AS LogDate
			FROM DeDupDiskPrediction
			GROUP BY CommServUniqueId, SubstoreId
		) R
		ON S.CommServUniqueId = R.CommServUniqueId AND S.SubstoreId = R.SubstoreId
		LEFT JOIN DeDupDiskPrediction I
		ON R.CommServUniqueId = I.CommServUniqueId AND R.SubstoreId = I.SubstoreId AND R.LogDate = I.LogDateUTC
		WHERE (S.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
END
IF @i_CommServUniqueID = 0
BEGIN
SELECT DISTINCT
	resultView.CommServUniqueId  AS 'CommServ UniqueId<DONOTSHOW>',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	resultView.CommServGUID AS 'CommServer GUID',
	resultView.DisplayName AS 'CommCell Name',
	STUFF((
		SELECT ', ' + csInfo2.SIDBStoreAliasName
		FROM cf_SurveyDeDupStoreConfig AS csInfo2
		WHERE csInfo2.CommServUniqueId = csInfo.CommServUniqueId
		AND csInfo2.SurveyResultId = csInfo.SurveyResultId
		AND csInfo2.idxAccessPathId = csInfo.idxAccessPathId
		ORDER BY csInfo.SIDBStoreAliasName
		FOR XML PATH('')
	), 1, 2, '') AS 'DDB Names',
	ISNULL(CSL.clientDisplayName, csInfo.MediaAgentName) AS 'MediaAgent',
	csInfo.accessPath AS 'DDB Path',
	ISNULL(csInfo.DDBUsedDiskSpaceMB, 0) AS 'Used DDB Size<SIZEMB>',
	ISNULL(csInfo.DDBDiskTotalSpaceMB, 0) AS 'Total Path Size<SIZEMB>',
	ISNULL(csInfo.DDBDiskFreeSpaceMB, 0) AS 'Path Free Space<SIZEMB>',
	CAST((CASE WHEN csInfo.DDBDiskTotalSpaceMB = 0 THEN 0 ELSE ISNULL(csInfo.DDBDiskFreeSpaceMB, 0) * 100 / CAST(csInfo.DDBDiskTotalSpaceMB AS DECIMAL(15,2)) END) AS DECIMAL(5,2)) AS 'Free Space (%)',
	F.DateToBeFull as 'Date to be Full<MMMDDYYYYNEVER>',
	CASE
		WHEN csInfo.DDBDiskFreeSpaceMB is NULL THEN @strInfo
		WHEN ISNULL(csInfo.DDBDiskTotalSpaceMB, 0) <= 0 THEN @strInfo
		WHEN ISNULL(csInfo.DDBUsedDiskSpaceMB, 0) <= 0 THEN @strInfo
              WHEN ( F.DaysToBeFull != @NA and F.DaysToBeFull != @Never and F.DaysToBeFull<@criticalThreshold ) THEN @strCritical
		WHEN (1.0*ISNULL(csInfo.DDBDiskFreeSpaceMB, 0))/(0.01*ISNULL(csInfo.DDBDiskTotalSpaceMB, 0)) < @criticalVal THEN @strCritical	--criticalVal = 10
              WHEN ( F.DaysToBeFull != @NA and F.DaysToBeFull != @Never and F.DaysToBeFull>=@criticalThreshold and F.DaysToBeFull <= @warningThreshold ) THEN @strwarning
		WHEN (1.0*ISNULL(csInfo.DDBDiskFreeSpaceMB, 0))/(0.01*ISNULL(csInfo.DDBDiskTotalSpaceMB, 0)) < @warningVal THEN @strwarning		--warningVal = 25
		ELSE @strGood
	END AS 'Status<HEALTH_STATUS>'
FROM cf_SurveyDeDupStoreConfig AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
		AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
		AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
       left join #PredictionData F
		on csInfo.CommServUniqueId = F.CommServUniqueId
              and csInfo.SubstoreId = F.SubstoreId
	LEFT OUTER JOIN cf_SurveyClient CSL WITH (NOLOCK)   ON CSL.CommservUniqueId = csInfo.CommservUniqueId AND CSL.ClientId = csInfo.mediaAgentId
		ORDER BY [Status<HEALTH_STATUS>] DESC, 'CommCell Name', 'DDB Names', 'DDB Path'
END
ELSE
SELECT DISTINCT
	csInfo.CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
	STUFF((
		SELECT ', ' + csInfo2.SIDBStoreAliasName
		FROM cf_SurveyDeDupStoreConfig AS csInfo2
		WHERE csInfo2.CommServUniqueId = csInfo.CommServUniqueId
		AND csInfo2.SurveyResultId = csInfo.SurveyResultId
		AND csInfo2.idxAccessPathId = csInfo.idxAccessPathId
		ORDER BY csInfo.SIDBStoreAliasName
		FOR XML PATH('')
	), 1, 2, '') AS 'DDB Names',
	ISNULL(CSL.clientDisplayName, csInfo.MediaAgentName) AS 'MediaAgent',
	csInfo.accessPath AS 'DDB Path',
	ISNULL(csInfo.DDBUsedDiskSpaceMB, 0) AS 'Used DDB Size<SIZEMB>',
	ISNULL(csInfo.DDBDiskTotalSpaceMB, 0) AS 'Total Path Size<SIZEMB>',
	ISNULL(csInfo.DDBDiskFreeSpaceMB, 0) AS 'Path Free Space<SIZEMB>',
	CAST((CASE WHEN csInfo.DDBDiskTotalSpaceMB = 0 THEN 0 ELSE ISNULL(csInfo.DDBDiskFreeSpaceMB, 0) * 100 / CAST(csInfo.DDBDiskTotalSpaceMB AS DECIMAL(15,2)) END) AS DECIMAL(5,2)) AS 'Free Space (%)',
	F.DateToBeFull as 'Date to be Full<MMMDDYYYYNEVER>',
	CASE
		WHEN csInfo.DDBDiskFreeSpaceMB is NULL THEN @strInfo
		WHEN ISNULL(csInfo.DDBDiskTotalSpaceMB, 0) <= 0 THEN @strInfo
		WHEN ISNULL(csInfo.DDBUsedDiskSpaceMB, 0) <= 0 THEN @strInfo
              WHEN ( F.DaysToBeFull != @NA and F.DaysToBeFull != @Never and F.DaysToBeFull<@criticalThreshold ) THEN @strCritical
		WHEN (1.0*ISNULL(csInfo.DDBDiskFreeSpaceMB, 0))/(0.01*ISNULL(csInfo.DDBDiskTotalSpaceMB, 0)) < @criticalVal THEN @strCritical	--criticalVal = 10
              WHEN ( F.DaysToBeFull != @NA and F.DaysToBeFull != @Never and F.DaysToBeFull>=@criticalThreshold and F.DaysToBeFull <= @warningThreshold ) THEN @strwarning
		WHEN (1.0*ISNULL(csInfo.DDBDiskFreeSpaceMB, 0))/(0.01*ISNULL(csInfo.DDBDiskTotalSpaceMB, 0)) < @warningVal THEN @strwarning		--warningVal = 25
		ELSE @strGood
	END AS 'Status<HEALTH_STATUS>'
FROM cf_SurveyDeDupStoreConfig AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
		AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
		AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
       left join #PredictionData F
		on csInfo.CommServUniqueId = F.CommServUniqueId
              and csInfo.SubstoreId = F.SubstoreId
	LEFT OUTER JOIN cf_SurveyClient CSL WITH (NOLOCK)   ON CSL.CommservUniqueId = csInfo.CommservUniqueId AND CSL.ClientId = csInfo.mediaAgentId
ORDER BY [Status<HEALTH_STATUS>] DESC, 'DDB Names', 'DDB Path'
IF object_id('tempdb.dbo.#GrowthData') IS NOT null DROP TABLE #GrowthData
IF object_id('tempdb.dbo.#GrowthRate') IS NOT null DROP TABLE #GrowthRate
IF object_id('tempdb.dbo.#GrowthRate') IS NOT null DROP TABLE #PredictionData
SET NOCOUNT OFF
GO
/*
DECLARE   @i_UserId INT = 1
DECLARE   @i_GroupId INT = NULL
DECLARE   @blaggregate INT = 0
DECLARE   @blLatestSurvey INT = 0
DECLARE    @i_CommServUniqueID INT = 0
DECLARE    @i_LogDateStart DATETIME = NULL
DECLARE    @i_LogDateEND DATETIME = NUll
exec RptDDBDiskSpaceUsage  @i_UserId, @i_GroupId,   @blaggregate,  @blLatestSurvey,  @i_CommServUniqueID,  @i_LogDateStart,  @i_LogDateEND
-- 2nd USE Case:
SET @i_CommServUniqueID = 11048
exec RptDDBDiskSpaceUsage  @i_UserId, @i_GroupId,   @blaggregate,  @blLatestSurvey,  @i_CommServUniqueID,  @i_LogDateStart,  @i_LogDateEND
*/

IF EXISTS (select * from GxQscripts where name = 'RptDDBDiskSpaceUsage')
	delete from GxQscripts where name = 'RptDDBDiskSpaceUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDDBDiskSpaceUsage')
	delete from GXDBVersions where aliasname = 'RptDDBDiskSpaceUsage'
GO

insert into GXDBVersions values(2, 'RptDDBDiskSpaceUsage',  '00010001000200230000', 'RptDDBDiskSpaceUsage', '00010001000200230000')
GO

