

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptDeDupRatioBySPCopy.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptDeDupRatioBySPCopy.sp,v $ $Id: RptDeDupRatioBySPCopy.sp,v 1.12.14.2 2018/05/29 14:17:05 nbirru Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptDeDupRatioBySPCopy <<<'

IF EXISTS (select * from sysobjects where name='RptDeDupRatioBySPCopy')
	drop procedure RptDeDupRatioBySPCopy
IF EXISTS (select * from GxQscripts where name='RptDeDupRatioBySPCopy')
	delete from GxQscripts where name = 'RptDeDupRatioBySPCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDeDupRatioBySPCopy')
	delete from GXDBVersions where aliasname = 'RptDeDupRatioBySPCopy'
GO
print '... Creating Procedure: RptDeDupRatioBySPCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptDeDupRatioBySPCopy
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll,
  @dedupe INT = 1
AS
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 26
IF @blaggregate=1
BEGIN
	IF @dedupe = 1
	BEGIN
	SELECT
		CAST((SUM(csInfo.appSizeGB)*1024.00) AS Decimal(20,2)) AS 'Application Size<SIZEMB>',
		CAST((SUM(csInfo.SizeOnMediaGB)*1024.00)AS Decimal(20,2)) AS 'Size on Media<SIZEMB>',
		CASE
			WHEN SUM(csInfo.SizeOnMediaGB)<=0 THEN 'N/A'
			ELSE CAST(
				CAST((100.0*(SUM(csInfo.appSizeGB)-SUM(csInfo.SizeOnMediaGB))/SUM(csInfo.appSizeGB))AS Decimal(20,2))
				AS VARCHAR(MAX))
		END AS 'DeDup Ratio (%)',
		CASE
			WHEN SUM(csInfo.SizeOnMediaGB)<=0 THEN 'N/A'
		ELSE CAST (CAST (( SUM(csInfo.appSizeGB)/SUM(csInfo.SizeOnMediaGB) +0.5) AS INT) AS NVARCHAR(MAX))+': 1'
		END AS 'DeDup Ratio'
	FROM cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId)  AS result
			ON result.SurverResultId = csInfo.SurveyResultId
			AND csInfo.Jobs>0 and ( csInfo.DedupeRatio <>0 or  csInfo.SizeOnMediaGB <>0)
			AND csInfo.DedupeRatio>-1
	RETURN
	END
	IF @dedupe = 0
	BEGIN
	SELECT
		CAST((SUM(csInfo.appSizeGB)*1024.00) AS Decimal(20,2)) AS 'Application Size<SIZEMB>',
		CAST((SUM(csInfo.SizeOnMediaGB)*1024.00)AS Decimal(20,2)) AS 'Size on Media<SIZEMB>'
	FROM cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId)  AS result
			ON result.SurverResultId = csInfo.SurveyResultId
			AND csInfo.DedupeRatio = -1
	RETURN
	END
	IF @dedupe = -1
	BEGIN
	SELECT
		CAST((SUM(csInfo.appSizeGB)/1024.00) AS Decimal(20,2)) AS 'Application Size (TB)',
		CAST((SUM(csInfo.SizeOnMediaGB)/1024.00)AS Decimal(20,2)) AS 'Media Size (TB)'
	FROM cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId)  AS result
			ON result.SurverResultId = csInfo.SurveyResultId
	RETURN
	END
	IF @dedupe = -1
	BEGIN
	SELECT
		CAST((SUM(csInfo.appSizeGB)/1024.00) AS Decimal(20,2)) AS 'Application Size (TB)',
		CAST((SUM(csInfo.SizeOnMediaGB)/1024.00)AS Decimal(20,2)) AS 'Media Size (TB)'
	FROM cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId)  AS result
			ON result.SurverResultId = csInfo.SurveyResultId
	RETURN
	END
END
DECLARE @strGood VARCHAR(10) = '1_Good'
	DECLARE @strInfo VARCHAR(10) = '2_Info'
	DECLARE @strwarning VARCHAR(10) = '3_Warning'
	DECLARE @strCritical VARCHAR(10) = '4_Critical'
	DECLARE @criticalVal int
	DECLARE @warningVal int
		SELECT	@warningVal = WarningThreshold,
				@criticalVal =CriticalThreshold
		FROM	cf_SurveyHealthParam where queryId = @i_QueryId
IF @i_CommServUniqueID = 0
BEGIN
	IF @dedupe = 1
	BEGIN
	SELECT
		resultView.CommServUniqueId  AS 'CommServ UniqueId',
		resultView.CommCellID AS 'CommCell ID',
		resultView.DisplayName AS 'CommCell Name',
		csInfo.StoragePolicy AS 'Storage Policy',
		csInfo.Copy AS 'Copy',
		--CONVERT(VARCHAR(12), csInfo.WeekStartDate, 107) AS 'Week Start Date',
		CAST ((csInfo.appSizeGB*1024.00) AS Decimal(20,2)) AS 'Application Size<SIZEMB>',
		CAST ((csInfo.SizeOnMediaGB*1024.00) AS Decimal(20,2))AS 'Size on Media<SIZEMB>',
		CAST (csInfo.DedupeRatio AS Decimal(20,2))AS 'DeDup Ratio (%)',
		csInfo.Jobs AS 'Number of Jobs',
		csInfo.Clients AS 'Number of Clients',
		CASE
			WHEN csInfo.SizeOnMediaGB < =0 THEN 'N/A'
			ELSE CAST (CAST (( csInfo.appSizeGB/csInfo.SizeOnMediaGB +0.5) AS INT) AS NVARCHAR(MAX))+': 1'
		END AS 'DeDup Ratio (%)'
	FROM cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND csInfo.Jobs>0 and ( csInfo.DedupeRatio <>0 or  csInfo.SizeOnMediaGB <>0)
			AND csInfo.DedupeRatio > -1
	ORDER BY csInfo.LogDate DESC, resultView.DisplayName ASC
	END
	IF @dedupe = 0
	BEGIN
	SELECT
		resultView.CommServUniqueId  AS 'CommServ UniqueId',
		resultView.CommCellID AS 'CommCell ID',
		resultView.DisplayName AS 'CommCell Name',
		csInfo.StoragePolicy AS 'Storage Policy',
		csInfo.Copy AS 'Copy',
		--CONVERT(VARCHAR(12), csInfo.WeekStartDate, 107) AS 'Week Start Date',
		CAST ((csInfo.appSizeGB*1024.00) AS Decimal(20,2)) AS 'Application Size<SIZEMB>',
		CAST ((csInfo.SizeOnMediaGB*1024.00) AS Decimal(20,2))AS 'Size on Media<SIZEMB>',
		csInfo.Jobs AS 'Number of Jobs',
		csInfo.Clients AS 'Number of Clients'
	FROM cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND csInfo.DedupeRatio=-1
		ORDER BY csInfo.LogDate DESC, resultView.DisplayName ASC
	END
END
ELSE
	IF @dedupe = 1
	BEGIN
	SELECT
		csInfo.CommServUniqueId AS 'CommServ UniqueId',
		csInfo.StoragePolicy AS 'Storage Policy',
		csInfo.Copy AS 'Copy',
		--CONVERT(VARCHAR(12), csInfo.WeekStartDate, 107) AS 'Week Start Date',
		CAST ((csInfo.appSizeGB*1024.00) AS Decimal(20,2))AS 'Application Size<SIZEMB>',
		CAST ((csInfo.SizeOnMediaGB*1024.00) AS Decimal(20,2))AS 'Size on Media<SIZEMB>',
		CAST (csInfo.DedupeRatio AS Decimal(20,2))AS 'DeDup Ratio (%)',
		csInfo.Jobs AS 'Number of Jobs',
		csInfo.Clients AS 'Number of Clients',
		CASE
			WHEN csInfo.SizeOnMediaGB < =0 THEN 'N/A'
			ELSE CAST (CAST (( csInfo.appSizeGB/(csInfo.SizeOnMediaGB +0.5)) AS INT) AS NVARCHAR(MAX))+': 1'
		END AS 'DeDup Ratio<ALTSORT>',
		CAST (( csInfo.appSizeGB/(csInfo.SizeOnMediaGB +0.5)) AS INT) AS 'DeDup Ratio<SORTCOLUMN>'
	FROM cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND csInfo.Jobs>0 and ( csInfo.DedupeRatio <>0 or  csInfo.SizeOnMediaGB <>0)
			AND csInfo.DedupeRatio>-1
	ORDER BY csInfo.DedupeRatio
	END
	IF @dedupe = 0
	BEGIN
	SELECT
		csInfo.CommServUniqueId AS 'CommServ UniqueId',
		csInfo.StoragePolicy AS 'Storage Policy',
		csInfo.Copy AS 'Copy',
		--CONVERT(VARCHAR(12), csInfo.WeekStartDate, 107) AS 'Week Start Date',
		CAST ((csInfo.appSizeGB*1024.00) AS Decimal(20,2))AS 'Application Size<SIZEMB>',
		CAST ((csInfo.SizeOnMediaGB*1024.00) AS Decimal(20,2))AS 'Size on Media<SIZEMB>',
		csInfo.Jobs AS 'Number of Jobs',
		csInfo.Clients AS 'Number of Clients'
	FROM cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND csInfo.DedupeRatio=-1
	ORDER BY csInfo.LogDate DESC
	END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptDeDupRatioBySPCopy')
	delete from GxQscripts where name = 'RptDeDupRatioBySPCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDeDupRatioBySPCopy')
	delete from GXDBVersions where aliasname = 'RptDeDupRatioBySPCopy'
GO

insert into GXDBVersions values(2, 'RptDeDupRatioBySPCopy',  '00010012001400020000', 'RptDeDupRatioBySPCopy', '00010012001400020000')
GO

