

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptDedupeSavingTrend.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptDedupeSavingTrend.sp,v $ $Id: RptDedupeSavingTrend.sp,v 1.1.2.9 2018/08/16 11:33:29 skatz Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptDedupeSavingTrend <<<'

IF EXISTS (select * from sysobjects where name='RptDedupeSavingTrend')
	drop procedure RptDedupeSavingTrend
IF EXISTS (select * from GxQscripts where name='RptDedupeSavingTrend')
	delete from GxQscripts where name = 'RptDedupeSavingTrend'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDedupeSavingTrend')
	delete from GXDBVersions where aliasname = 'RptDedupeSavingTrend'
GO
print '... Creating Procedure: RptDedupeSavingTrend'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptDedupeSavingTrend
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_CommServUniqueID INT = 0,
  @i_IsGraph INT = 0,
  @i_TopN INT = -1, -- 0 for No Aggregate, -1 for Total Aggregate
  @i_GroupBy VARCHAR(64) = 'Subclient', -- 'Subclient', 'Agent Type', 'Storage Policy' or 'CommCell'
  @i_GroupByID INT = 0, -- For Entity Selection
  @i_EntityType VARCHAR(64) = '', -- 'Subclient', 'Agent Type', 'Storage Policy' or 'CommCell'
  @i_EntityID INT = 0, -- NULL for trending chart of total
  @i_IsFullBackup INT = 1, -- 0 for Incr/Diff, 1 for Full, 2 for Both
  @i_IntervalType INT = 2, -- 1 for Daily, 2 for Weekly, 3 for Monthly
  @i_NumOfInterval INT = 12,
  @i_EndDate DATE = NULL
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @i_QueryId INT = 174
CREATE TABLE #TimeInterval (FirstDate DATE, LastDate DATE, IntervalName VARCHAR(16))
DECLARE @FirstDate DATE
DECLARE @LastDate  DATE = @i_EndDate
DECLARE @PrevDate  DATE
DECLARE	@i INT = 0
IF @i_TopN <= 0 SET @i_TopN = 0x7FFFFFFF
IF @i_IntervalType = 1 -- daily
BEGIN
	IF @LastDate IS NULL
		SET @LastDate = DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()), 0)
	SET @FirstDate = DATEADD(DAY, -1, @LastDate)
	WHILE @i < @i_NumOfInterval
	BEGIN
		INSERT	INTO #TimeInterval
		SELECT	@FirstDate, @FirstDate,
				CAST(MONTH(@FirstDate) AS VARCHAR(3)) + '/' + CAST(DAY(@FirstDate) AS VARCHAR(2)) + ' ('
				+ SUBSTRING(DATENAME(DW, @FirstDate),1,3) + ')'
		SET @FirstDate = DATEADD(DAY, -1, @FirstDate)
		SET @i += 1
	END
END
ELSE
IF @i_IntervalType = 2 -- weekly
BEGIN
	IF @LastDate IS NULL
		SET @LastDate = DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()), 0)
	SET @FirstDate = DATEADD(DAY, -6, @LastDate)
	WHILE @i < @i_NumOfInterval
	BEGIN
		INSERT	INTO #TimeInterval
		SELECT	@FirstDate, @LastDate,
				CAST(MONTH(@FirstDate) AS VARCHAR(3)) + '/' + CAST(DAY(@FirstDate) AS VARCHAR(2)) + ' - '
				+ CAST(MONTH(@LastDate) AS VARCHAR(3)) + '/' + CAST(DAY(@LastDate) AS VARCHAR(2))
		SET @FirstDate = DATEADD(WEEK, -1, @FirstDate)
		SET @LastDate  = DATEADD(WEEK, -1, @LastDate)
		SET @i += 1
	END
END
ELSE
IF @i_IntervalType = 3 -- monthly
BEGIN
	IF @LastDate IS NULL
		SET @LastDate = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)
	SET @FirstDate = @LastDate
	SET @LastDate  = DATEADD(DAY, 1, @FirstDate)
	WHILE @i < @i_NumOfInterval
	BEGIN
		INSERT	INTO #TimeInterval
		SELECT	@FirstDate, @LastDate,
				SUBSTRING(DATENAME(MONTH, @FirstDate), 1, 3) + ' ' + CAST(YEAR(@FirstDate) AS VARCHAR(4))
		SET @LastDate =  DATEADD(DAY, -1, @FirstDate)
		SET @FirstDate = DATEADD(MONTH, -1, @FirstDate)
		SET @i += 1
	END
END
DECLARE @QueryStr NVARCHAR(MAX)
DECLARE @Columns  VARCHAR(MAX)
SELECT	@Columns = ISNULL(@Columns + ', ', '') + QUOTENAME(IntervalName)
FROM	#TimeInterval
ORDER BY FirstDate
CREATE TABLE #Results (CommservUniqueId INT, CommCellID VARCHAR(32), CommServName NVARCHAR(288))
INSERT	INTO #Results
SELECT	DISTINCT CommservUniqueId, CommCellID,
 		DisplayName + CASE WHEN @i_CommServUniqueID > 0 THEN '' WHEN CommCellID = -1 THEN ' - FFFFFFFF' ELSE ' - ' + dbo.ConvertBigIntToHexStr(CommCellID) END
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId)
CREATE TABLE #DedupeSaving (
		CommservUniqueId INT, AppId INT, PrimaryCopyId INT, FirstDate DATE, IntervalName VARCHAR(16), BackupSize BIGINT, DataWritten BIGINT, DedupeSavingPct DECIMAL(32,2))
IF @i_IntervalType = 3
	INSERT INTO #DedupeSaving
	SELECT	S.CommservUniqueId, S.AppId, S.PrimaryCopyId, I.FirstDate, I.IntervalName,
			SUM(S.BackupSize), SUM(S.DataWritten), CASE WHEN SUM(S.BackupSize) > SUM(S.DataWritten) THEN 1.0*(SUM(S.BackupSize) - SUM(S.DataWritten))/(0.01*SUM(S.BackupSize)) ELSE 0 END
	FROM	cf_SurveyMonthlyDedupeSaving S
		INNER JOIN #Results R ON S.CommservUniqueId = R.CommservUniqueId
		INNER JOIN #TimeInterval I ON S.MonthStart BETWEEN I.FirstDate AND I.LastDate
	WHERE	(S.IsFullBackup = @i_IsFullBackup OR @i_IsFullBackup = 2)
	GROUP BY S.CommservUniqueId, S.AppId, S.PrimaryCopyId, I.FirstDate, I.IntervalName
ELSE
	INSERT INTO #DedupeSaving
	SELECT	S.CommservUniqueId, S.AppId, S.PrimaryCopyId, I.FirstDate, I.IntervalName,
			SUM(S.BackupSize), SUM(S.DataWritten), CASE WHEN SUM(S.BackupSize) > SUM(S.DataWritten) THEN 1.0*(SUM(S.BackupSize) - SUM(S.DataWritten))/(0.01*SUM(S.BackupSize)) ELSE 0 END
	FROM	cf_SurveyDailyDedupeSaving S
		INNER JOIN #Results R ON S.CommservUniqueId = R.CommservUniqueId
		INNER JOIN #TimeInterval I ON S.JobEndDate BETWEEN I.FirstDate AND I.LastDate
	WHERE	(S.IsFullBackup = @i_IsFullBackup OR @i_IsFullBackup = 2)
	GROUP BY S.CommservUniqueId, S.AppId, S.PrimaryCopyId, I.FirstDate, I.IntervalName
IF @i_GroupBy = 'Subclient' AND @i_GroupByID > 0 AND @i_CommServUniqueID > 0
	DELETE	#DedupeSaving
	WHERE	CommservUniqueId <> @i_CommServUniqueID OR AppId <> @i_GroupByID
ELSE
IF @i_GroupBy = 'Agent Type' AND @i_GroupByID > 0
	DELETE	D FROM #DedupeSaving D LEFT OUTER JOIN cf_SurveySubclientAssociation S
		 ON D.CommservUniqueId = S.CommservUniqueId AND D.AppId = S.AppId AND S.AppTypeId = @i_GroupByID
	WHERE	S.AppId IS NULL
ELSE
IF @i_GroupBy = 'Storage Policy' AND @i_GroupByID > 0 AND @i_CommServUniqueID > 0
	DELETE	D FROM #DedupeSaving D LEFT OUTER JOIN cf_SurveyCopyBasicRetention C
		 ON D.CommservUniqueId = C.CommservUniqueId AND D.PrimaryCopyId = C.CopyId AND C.PolicyId = @i_GroupByID
	WHERE	D.CommservUniqueId = @i_CommServUniqueID AND C.CopyId IS NULL
ELSE
IF @i_GroupBy = 'CommCell' AND @i_GroupByID > 0
	DELETE	#DedupeSaving
	WHERE	CommservUniqueId <> @i_GroupByID
IF @i_EntityType = 'Subclient' AND @i_EntityID > 0 AND @i_CommServUniqueID > 0
	DELETE	#DedupeSaving
	WHERE	CommservUniqueId <> @i_CommServUniqueID OR AppId <> @i_EntityID
ELSE
IF @i_EntityType = 'Agent Type' AND @i_EntityID > 0
	DELETE	D FROM #DedupeSaving D LEFT OUTER JOIN cf_SurveySubclientAssociation S
		 ON D.CommservUniqueId = S.CommservUniqueId AND D.AppId = S.AppId AND S.AppTypeId = @i_EntityID
	WHERE	S.AppId IS NULL
ELSE
IF @i_EntityType = 'Storage Policy' AND @i_EntityID > 0 AND @i_CommServUniqueID > 0
	DELETE	D FROM #DedupeSaving D LEFT OUTER JOIN cf_SurveyCopyBasicRetention C
		 ON D.CommservUniqueId = C.CommservUniqueId AND D.PrimaryCopyId = C.CopyId AND C.PolicyId = @i_EntityID
	WHERE	D.CommservUniqueId = @i_CommServUniqueID AND C.CopyId IS NULL
ELSE
IF @i_EntityType = 'CommCell' AND @i_EntityID > 0
	DELETE	#DedupeSaving
	WHERE	CommservUniqueId <> @i_EntityID
CREATE TABLE #EntityDedupeTrend (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(1024), FirstDate DATE, IntervalName VARCHAR(16), BackupSize BIGINT, DataWritten BIGINT)
CREATE TABLE #EntityDedupeOrder (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(1024), AvgDedupeSavingPct DECIMAL(32,2), LastSavingPct DECIMAL(32,2), PrevSavingPct DECIMAL(32,2))
IF @i_GroupBy = 'CommCell'
BEGIN
	INSERT	INTO #EntityDedupeTrend
	SELECT	D.CommservUniqueId, D.CommservUniqueId, CommServName, FirstDate, IntervalName, SUM(BackupSize), SUM(DataWritten)
	FROM	#DedupeSaving D
		INNER JOIN #Results R ON D.CommservUniqueId = R.CommservUniqueId
	GROUP BY D.CommservUniqueId, D.CommservUniqueId, CommServName, FirstDate, IntervalName
END
ELSE
IF @i_GroupBy = 'Agent Type'
BEGIN
	INSERT	INTO #EntityDedupeTrend
	SELECT	0, AppTypeId, A.name, FirstDate, IntervalName, SUM(BackupSize), SUM(DataWritten)
	FROM	#DedupeSaving D
		INNER JOIN cf_SurveySubclientAssociation S ON D.CommservUniqueId = S.CommservUniqueId AND D.AppId = S.AppId
		INNER JOIN cf_SurveyAgentType A ON S.AppTypeId = A.id
	GROUP BY AppTypeId, A.name, FirstDate, IntervalName
END
ELSE
IF @i_GroupBy = 'Storage Policy'
BEGIN
	INSERT	INTO #EntityDedupeTrend
	SELECT	D.CommservUniqueId, PolicyId, PolicyName, FirstDate, IntervalName, SUM(BackupSize), SUM(DataWritten)
	FROM	#DedupeSaving D
		INNER JOIN cf_SurveyCopyBasicRetention C ON D.CommservUniqueId = C.CommservUniqueId AND D.PrimaryCopyId = C.CopyId AND C.Deleted = 0
	GROUP BY D.CommservUniqueId, PolicyId, PolicyName, FirstDate, IntervalName
END
ELSE
IF @i_GroupBy = 'Subclient'
BEGIN
	INSERT	INTO #EntityDedupeTrend
	SELECT	D.CommservUniqueId, D.AppId, ISNULL(CL.clientDisplayName, S.ClientName)+':'+A.name+':'+InstanceName+':'+BackupsetName+':'+SubclientName,
			FirstDate, IntervalName, SUM(BackupSize), SUM(DataWritten)
	FROM	#DedupeSaving D
		INNER JOIN cf_SurveySubclientAssociation S ON D.CommservUniqueId = S.CommservUniqueId AND D.AppId = S.AppId AND S.Deleted = 0
		INNER JOIN cf_SurveyAgentType A ON S.AppTypeId = A.id
		LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = S.CommServUniqueId AND CL.ClientId = S.ClientId
	GROUP BY D.CommservUniqueId, D.AppId, ISNULL(CL.clientDisplayName, S.ClientName)+':'+A.name+':'+InstanceName+':'+BackupsetName+':'+SubclientName, FirstDate, IntervalName
END
IF  @i_CommServUniqueID = 0 AND @i_IsGraph = 1 AND @i_GroupBy IN ('Storage Policy', 'Subclient')
	UPDATE	#EntityDedupeTrend SET EntityName += (' - ' + CASE WHEN CommCellID = -1 THEN 'FFFFFFFF' ELSE dbo.ConvertBigIntToHexStr(CommCellID) END)
	FROM	#EntityDedupeTrend S
			INNER JOIN #Results R ON S.CommservUniqueId = R.CommservUniqueId
INSERT	INTO #EntityDedupeOrder
SELECT	TOP (@i_TopN) CommservUniqueId, EntityId, EntityName,
		CASE WHEN SUM(BackupSize) > SUM(DataWritten) THEN 1.0*(SUM(BackupSize) - SUM(DataWritten))/(0.01*SUM(BackupSize)) ELSE 0 END AS DedupeSavingPct, NULL, NULL
FROM	#EntityDedupeTrend
GROUP BY CommservUniqueId, EntityId, EntityName
ORDER BY DedupeSavingPct DESC, EntityName
INSERT	INTO #EntityDedupeTrend
SELECT	O.CommservUniqueId, O.EntityId, O.EntityName, I.FirstDate, I.IntervalName, -1, -1
FROM	#TimeInterval I CROSS JOIN #EntityDedupeOrder O
	LEFT OUTER JOIN #EntityDedupeTrend T ON T.FirstDate = I.FirstDate AND T.CommservUniqueId = O.CommservUniqueId AND T.EntityId = O.EntityId
WHERE	T.FirstDate IS NULL
IF @i_IsGraph > 0
BEGIN
	IF @i_TopN = 0x7FFFFFFF -- Total Aggregate
		SELECT	I.FirstDate, I.IntervalName,
				CAST(ISNULL(CASE WHEN SUM(BackupSize) > SUM(DataWritten) THEN 1.0*(SUM(BackupSize) - SUM(DataWritten))/(0.01*SUM(BackupSize)) ELSE 0 END, -1) AS DECIMAL(32,2)) AS DedupeSavingPct
		FROM	#TimeInterval I LEFT OUTER JOIN #EntityDedupeTrend T ON I.FirstDate = T.FirstDate
		GROUP BY I.FirstDate, I.IntervalName
		ORDER BY I.FirstDate
	ELSE
	IF @i_GroupBy = 'Agent Type'
		SELECT	O.EntityName, I.FirstDate, I.IntervalName,
				CAST(ISNULL(CASE WHEN BackupSize = -1 THEN -1 WHEN BackupSize > DataWritten THEN 1.0*(BackupSize - DataWritten)/(0.01*BackupSize) ELSE 0 END, -1) AS DECIMAL(32,2)) AS DedupeSavingPct
		FROM	#TimeInterval I CROSS JOIN #EntityDedupeOrder O
			LEFT OUTER JOIN #EntityDedupeTrend T ON T.FirstDate = I.FirstDate AND T.CommservUniqueId = O.CommservUniqueId AND T.EntityId = O.EntityId
		ORDER BY O.AvgDedupeSavingPct DESC, O.EntityName, I.FirstDate
	ELSE
		SELECT	R.CommServName, O.EntityName, I.FirstDate, I.IntervalName,
				CAST(ISNULL(CASE WHEN BackupSize = -1 THEN -1 WHEN BackupSize > DataWritten THEN 1.0*(BackupSize - DataWritten)/(0.01*BackupSize) ELSE 0 END, -1) AS DECIMAL(32,2)) AS DedupeSavingPct
		FROM	#TimeInterval I CROSS JOIN #EntityDedupeOrder O
			INNER JOIN #Results R ON O.CommservUniqueId = R.CommservUniqueId
			LEFT OUTER JOIN #EntityDedupeTrend T ON T.FirstDate = I.FirstDate AND T.CommservUniqueId = O.CommservUniqueId AND T.EntityId = O.EntityId
		ORDER BY O.AvgDedupeSavingPct DESC, O.EntityName, I.FirstDate
END
ELSE
BEGIN
	SET	@LastDate = (SELECT MAX(FirstDate) FROM #TimeInterval)
	SET	@PrevDate = (SELECT MAX(FirstDate) FROM #TimeInterval WHERE FirstDate < @LastDate)
	UPDATE	O SET LastSavingPct = CASE WHEN BackupSize > DataWritten THEN 1.0*(BackupSize - DataWritten)/(0.01*BackupSize) ELSE NULL END
	FROM	#EntityDedupeOrder O
			INNER JOIN #EntityDedupeTrend E ON O.CommservUniqueId = E.CommservUniqueId AND O.EntityId = E.EntityId
	WHERE	E.FirstDate = @LastDate
	UPDATE	O SET PrevSavingPct = CASE WHEN BackupSize > DataWritten THEN 1.0*(BackupSize - DataWritten)/(0.01*BackupSize) ELSE NULL END
	FROM	#EntityDedupeOrder O
			INNER JOIN #EntityDedupeTrend E ON O.CommservUniqueId = E.CommservUniqueId AND O.EntityId = E.EntityId
	WHERE	E.FirstDate = @PrevDate
  IF @i_GroupBy = 'Agent Type'
	SET @QueryStr =
		N'SELECT
			EntityId AS [EntityId<DONOTSHOW>], EntityName AS [Agent Name],
			AvgDedupeSavingPct AS [Average Saving (%)<HIDDEN>], LastSavingChange AS [Lastest Saving (%) Change<DifferenceNA><HIDDEN>], ' + @Columns +
		'FROM
		(
			SELECT	T.EntityId, T.EntityName, O.AvgDedupeSavingPct, (O.LastSavingPct - O.PrevSavingPct) AS LastSavingChange, IntervalName,
					CAST(CASE WHEN BackupSize = -1 THEN -1 WHEN BackupSize > DataWritten THEN 1.0*(BackupSize - DataWritten)/(0.01*BackupSize) ELSE 0 END AS DECIMAL(32,2)) AS DedupeSavingPct
			FROM	#EntityDedupeTrend T
				INNER JOIN #EntityDedupeOrder O ON T.CommservUniqueId = O.CommservUniqueId AND T.EntityId = O.EntityId
		) X
		PIVOT
		(
			MAX(DedupeSavingPct)
			FOR IntervalName IN (' + @Columns + N')
		) P
		ORDER BY AvgDedupeSavingPct DESC, EntityName'
  ELSE
  IF @i_GroupBy = 'CommCell'
  	SET @QueryStr =
		N'SELECT
			CommservUniqueId AS [CommservUniqueId<DONOTSHOW>], CommServName AS [CommCell Name],
			AvgDedupeSavingPct AS [Average Saving (%)<HIDDEN>], LastSavingChange AS [Lastest Saving (%) Change<DifferenceNA><HIDDEN>], ' + @Columns +
		'FROM
		(
			SELECT	T.CommservUniqueId, CommServName, O.AvgDedupeSavingPct, (O.LastSavingPct - O.PrevSavingPct) AS LastSavingChange, IntervalName,
					CAST(CASE WHEN BackupSize = -1 THEN -1 WHEN BackupSize > DataWritten THEN 1.0*(BackupSize - DataWritten)/(0.01*BackupSize) ELSE 0 END AS DECIMAL(32,2)) AS DedupeSavingPct
			FROM	#EntityDedupeTrend T
				INNER JOIN #EntityDedupeOrder O ON T.CommservUniqueId = O.CommservUniqueId AND T.EntityId = O.EntityId
				INNER JOIN #Results R ON T.CommservUniqueId = R.CommservUniqueId
		) X
		PIVOT
		(
			MAX(DedupeSavingPct)
			FOR IntervalName IN (' + @Columns + N')
		) P
		ORDER BY AvgDedupeSavingPct DESC, CommServName'
  ELSE
  IF @i_GroupBy = 'Storage Policy'
 	SET @QueryStr =
		N'SELECT
			CommservUniqueId AS [CommservUniqueId<DONOTSHOW>], CommServName AS [CommCell Name],
			EntityId AS [EntityId<DONOTSHOW>], EntityName AS [Storage Policy],
			AvgDedupeSavingPct AS [Average Saving (%)<HIDDEN>], LastSavingChange AS [Lastest Saving (%) Change<DifferenceNA><HIDDEN>], ' + @Columns +
		'FROM
		(
			SELECT	T.CommservUniqueId, CommServName, T.EntityId, T.EntityName, O.AvgDedupeSavingPct, (O.LastSavingPct - O.PrevSavingPct) AS LastSavingChange, IntervalName,
					CAST(CASE WHEN BackupSize = -1 THEN -1 WHEN BackupSize > DataWritten THEN 1.0*(BackupSize - DataWritten)/(0.01*BackupSize) ELSE 0 END AS DECIMAL(32,2)) AS DedupeSavingPct
			FROM	#EntityDedupeTrend T
				INNER JOIN #EntityDedupeOrder O ON T.CommservUniqueId = O.CommservUniqueId AND T.EntityId = O.EntityId
				INNER JOIN #Results R ON T.CommservUniqueId = R.CommservUniqueId
		) X
		PIVOT
		(
			MAX(DedupeSavingPct)
			FOR IntervalName IN (' + @Columns + N')
		) P
		ORDER BY AvgDedupeSavingPct DESC, EntityName'
  ELSE
  IF @i_GroupBy = 'Subclient'
 	SET @QueryStr =
		N'SELECT
			CommservUniqueId AS [CommservUniqueId<DONOTSHOW>], CommServName AS [CommCell Name],
			EntityId AS [EntityId<DONOTSHOW>], EntityName AS [Subclient],
			AvgDedupeSavingPct AS [Average Saving (%)<HIDDEN>], LastSavingChange AS [Lastest Saving (%) Change<DifferenceNA><HIDDEN>], ' + @Columns +
		'FROM
		(
			SELECT	T.CommservUniqueId, CommServName, T.EntityId, T.EntityName, O.AvgDedupeSavingPct, (O.LastSavingPct - O.PrevSavingPct) AS LastSavingChange, IntervalName,
					CAST(CASE WHEN BackupSize = -1 THEN -1 WHEN BackupSize > DataWritten THEN 1.0*(BackupSize - DataWritten)/(0.01*BackupSize) ELSE 0 END AS DECIMAL(32,2)) AS DedupeSavingPct
			FROM	#EntityDedupeTrend T
				INNER JOIN #EntityDedupeOrder O ON T.CommservUniqueId = O.CommservUniqueId AND T.EntityId = O.EntityId
				INNER JOIN #Results R ON T.CommservUniqueId = R.CommservUniqueId
		) X
		PIVOT
		(
			MAX(DedupeSavingPct)
			FOR IntervalName IN (' + @Columns + N')
		) P
		ORDER BY AvgDedupeSavingPct DESC, EntityName'
	EXEC sp_executesql @QueryStr
END
DROP TABLE #Results
DROP TABLE #TimeInterval
DROP TABLE #DedupeSaving
DROP TABLE #EntityDedupeTrend
DROP TABLE #EntityDedupeOrder
SET NOCOUNT OFF
GO
/*
-- STANDALONE:
  DECLARE   @i_UserId INT = 1
  DECLARE   @i_GroupId INT = NULL
  DECLARE   @i_CommServUniqueID INT = 0
  DECLARE   @i_IsGraph INT = 0
  DECLARE   @i_TopN INT = -1 						-- 0 for No Aggregate -1 for Total Aggregate
  DECLARE   @i_GroupBy VARCHAR(64) = 'Subclient'	-- 'Subclient', 'Agent Type', 'Storage Policy' or 'CommCell'
  DECLARE   @i_GroupByID INT = 0					-- For Entity Selection
  DECLARE   @i_EntityType VARCHAR(64) = ''			-- 'Subclient', 'Agent Type', 'Storage Policy' or 'CommCell'
  DECLARE   @i_EntityID INT = 0						-- NULL for trending chart of total
  DECLARE   @i_IsFullBackup INT = 1					-- 0 for Incr/Diff, 1 for Full, 2 for Both
  DECLARE   @i_IntervalType INT = 2					-- 1 for Daily, 2 for Weekly, 3 for Monthly
  DECLARE   @i_NumOfInterval INT = 12
  DECLARE   @i_EndDate DATE = NULL
  Exec RptDedupeSavingTrend @i_UserId, @i_GroupId, @i_CommServUniqueID, @i_IsGraph, @i_TopN, @i_GroupBy,
		@i_GroupByID, @i_EntityType, @i_EntityID, @i_IsFullBackup, @i_IntervalType, @i_NumOfInterval, @i_EndDate
*/

IF EXISTS (select * from GxQscripts where name = 'RptDedupeSavingTrend')
	delete from GxQscripts where name = 'RptDedupeSavingTrend'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDedupeSavingTrend')
	delete from GXDBVersions where aliasname = 'RptDedupeSavingTrend'
GO

insert into GXDBVersions values(2, 'RptDedupeSavingTrend',  '00010001000200090000', 'RptDedupeSavingTrend', '00010001000200090000')
GO

