

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptGetMetricsCompanyInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptGetMetricsCompanyInfo.sp,v $ $Id: RptGetMetricsCompanyInfo.sp,v 1.1.2.2 2019/11/21 01:19:05 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetMetricsCompanyInfo')
BEGIN
	print '>>> Drop Stored Procedure: RptGetMetricsCompanyInfo <<<'
	drop procedure RptGetMetricsCompanyInfo
END
IF EXISTS (select * from GxQscripts where name='RptGetMetricsCompanyInfo')
	delete from GxQscripts where name = 'RptGetMetricsCompanyInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetMetricsCompanyInfo')
	delete from GXDBVersions where aliasname = 'RptGetMetricsCompanyInfo'
GO
print '... Creating Procedure: RptGetMetricsCompanyInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetMetricsCompanyInfo
  @i_UserId INT =NULL,
  @blLatestSurvey INT = 1
AS
DECLARE @UserCapability INT = -1
SET @UserCapability = (SELECT surveycapability FROM cf_MetricsLoggedInUsers WITH (NOLOCK) WHERE UserId = @i_UserId)
DECLARE @UserProp xml
DECLARE @IncludeDisabled INT = 0
SET @IncludeDisabled = @blLatestSurvey & 2
SET @blLatestSurvey = @blLatestSurvey & 1
SET @blLatestSurvey = @blLatestSurvey | @IncludeDisabled
IF object_id('tempdb.dbo.#groupTbl') is not null DROP TABLE #groupTbl
CREATE TABLE #groupTbl (gId INT)
IF object_id('tempdb.dbo.#GroupAssoc') is not null DROP TABLE #GroupAssoc
CREATE TABLE #GroupAssoc (gId INT, ccuId INT)
IF object_id('tempdb.dbo.#tempFinalResult') is not null 	drop table #tempFinalResult
CREATE TABLE #tempFinalResult(CommServUniqueId INT,ProtectedClients INT, NotProtectedClients INT,ActiveClients INT, SLAPercent INT, GUID NVARCHAR(256))
	INSERT	INTO #tempFinalResult(CommServUniqueId,ProtectedClients,NotProtectedClients,GUID)
	SELECT	CommServUniqueId,  csInfo.ProtectedClients, csInfo.NotProtectedClients,resultView.CommServGUID
	FROM	dbo.cf_SurveyResultFuncV1(146, 0, 1, null, null, @i_UserId, -1) AS resultView
	INNER JOIN cf_CommcellSummary AS csInfo WITH (NOLOCK) ON resultView.SurverResultId = csInfo.SurveyResultId
	CREATE INDEX tempFinalResultIdx ON #tempFinalResult (CommServUniqueId)
	UPDATE	T SET ActiveClients = csinfo.TotalActiveClients
				 , SLAPercent  =   CAST((CASE WHEN ISNULL(T.NotProtectedClients + T.ProtectedClients, 0) > 0
                    THEN ISNULL(T.ProtectedClients, 0)*100.0/ISNULL(T.NotProtectedClients + T.ProtectedClients, 0) ELSE -1 END) AS INT)
	FROM	#tempFinalResult T
			INNER JOIN dbo.cf_SurveyResultFuncV1(8, 0, @blLatestSurvey, null, null, @i_UserId, -1) AS result
				ON T.CommServUniqueId = result.CommServUniqueId
			INNER JOIN cf_SurveyClientStatisticsInfo csinfo ON result.SurverResultId = csinfo.SurveyResultId
--Commcell Info
	IF (@i_UserId = -1 OR @UserCapability = 1)
	BEGIN
		INSERT INTO #groupTbl(gId) SELECT id FROM cf_CommcellGroup WITH (NOLOCK) WHERE status & 32 <> 0
	END
	ELSE IF (@i_UserId IS NOT NULL)
	BEGIN                                                                           --security check
		SET @UserProp = (SELECT UserProp FROM cf_MetricsLoggedInUsers WITH (NOLOCK) WHERE UserId =@i_UserId)
		INSERT INTO #groupTbl(gId)
		SELECT CG.id
		FROM (
				SELECT
					ccg.value('@userGroupId', 'INT') companyId
				From @UserProp.nodes('WebReport_CloudMetricsUserResp') AS resp(resp)
					CROSS apply resp.nodes('companies/company') AS ccg(ccg)
			) UG
			INNER JOIN cf_CustomerGroup G WITH(NOLOCK)
				ON G.id = UG.companyId
			INNER JOIN cf_CommcellGroup CG WITH(NOLOCK)
				ON CG.id = G.clientGroupId
				AND CG.status & 32 <> 0
	END
		INSERT INTO #GroupAssoc
		SELECT DISTINCT up.gId, ISNULL(sub.CommcellIdNameMap_ID, -1)
		FROM #groupTbl up
			INNER JOIN cf_CommcellGroup g WITH (NOLOCK, READUNCOMMITTED)
				ON g.id = up.gId
			LEFT OUTER JOIN
			(	SELECT  ga.commCellGroupId, ga.CommcellIdNameMap_ID, CommCellSurveyServices
				FROM cf_CommcellGroupAssoc ga WITH (NOLOCK, READUNCOMMITTED)
					INNER JOIN cf_CommcellIdNameMap cc WITH (NOLOCK)
						ON cc.ID = ga.CommcellIdNameMap_ID
				UNION --Permanent CommCells
				SELECT
					(SELECT id AS commCellGroupId FROM cf_CommcellGroup cg WITH (NOLOCK) WHERE name in ('Permanent CommCells')) AS commCellGroupId,
					ID AS CommcellIdNameMap_ID, CommCellSurveyServices
				FROM cf_CommcellIdNameMap cc WITH (NOLOCK) WHERE CommCellID >= 655360
				UNION --Eval CommCells
				SELECT
					(SELECT id AS commCellGroupId FROM cf_CommcellGroup cg WITH (NOLOCK) WHERE name in ('Eval CommCells')) AS commCellGroupId,
					ID AS CommcellIdNameMap_ID, CommCellSurveyServices
				FROM cf_CommcellIdNameMap cc WITH (NOLOCK) WHERE CommCellID = -1
				UNION --NFR CommCells
				SELECT
					(SELECT id AS commCellGroupId FROM cf_CommcellGroup cg WITH (NOLOCK) WHERE name in ('NFR CommCells')) AS commCellGroupId,
					ID AS CommcellIdNameMap_ID, CommCellSurveyServices
				FROM cf_CommcellIdNameMap cc WITH (NOLOCK) WHERE (CommCellID > 0 AND CommCellID < 655360)
			) AS sub
				ON up.gId = sub.commCellGroupId
		IF object_id('tempdb.dbo.#CommCellCount') is not null DROP TABLE #CommCellCount
		CREATE TABLE #CommCellCount (gId INT, nCommCells INT)
		INSERT	INTO #CommCellCount
		SELECT	gId, COUNT(DISTINCT ccuId)
		FROM	cf_CommcellGroupAssoc WITH (NOLOCK)
				RIGHT OUTER JOIN #GroupAssoc ON gId = commCellGroupId AND ccuId = CommcellIdNameMap_ID
		WHERE ccuId <> -1
		GROUP BY gId
		IF object_id('tempdb.dbo.#ClientCount') is not null DROP TABLE #ClientCount
		CREATE TABLE #ClientCount (gId INT, nActiveClients INT)
		INSERT	INTO #ClientCount
		SELECT	gId, SUM(ISNULL(TotalActiveClients,0))
		FROM	dbo.cf_SurveyResultFuncV1(8, 0, 3, NULL, NULL, @i_UserId, -1) AS R
				INNER JOIN cf_SurveyClientStatisticsInfo C WITH (NOLOCK) ON C.SurveyResultId = R.SurverResultId
				INNER JOIN #GroupAssoc ON ccuId = R.CommServUniqueId AND ccuId <> -1
		GROUP BY gId
		IF object_id('tempdb.dbo.#SLACounts') is not null DROP TABLE #SLACounts
		CREATE TABLE #SLACounts (gId INT, ProtectedClients INT, NotProtectedClients INT)
		INSERT	INTO #SLACounts
		SELECT	gId, SUM(ISNULL(ProtectedClients,0)), SUM(ISNULL(NotProtectedClients,0))
		FROM	dbo.cf_SurveyResultFuncV1(146, 0, 3, NULL, NULL, @i_UserId, -1) AS R
				INNER JOIN cf_CommcellSummary C WITH (NOLOCK) ON C.SurveyResultId = R.SurverResultId
				INNER JOIN #GroupAssoc ON ccuId = R.CommServUniqueId AND ccuId <> -1
		GROUP BY gId
		SELECT DISTINCT
		     g.gId as 'GroupID',
			-1 AS 'CommServUniqueId',
			ISNULL(cc.nCommCells, 0) AS 'Number of CommCells',
			ISNULL(cl.nActiveClients, 0) AS 'Active Clients',
			ISNULL(CAST((CASE WHEN (NotProtectedClients+ProtectedClients)>0 THEN 100.0*ProtectedClients/(NotProtectedClients+ProtectedClients) ELSE 0 END) AS INT), 0) AS 'SLA (%)'
			,''	as 'GUID'
		FROM #GroupAssoc G
		    LEFT OUTER JOIN #CommCellCount cc ON cc.gId = g.gId
			LEFT OUTER JOIN #ClientCount cl ON cl.gId = g.gId
			LEFT OUTER JOIN #SLACounts sla ON sla.gId = g.gId
       UNION
	       SELECT
		    -1 as 'GroupID' ,
			csinfo.CommServUniqueId as 'CommServUniqueId',
			1,
			csinfo.ActiveClients AS 'Active Clients',
			csinfo.SLAPercent as 'SLA (%)',
			csinfo.GUID AS 'GUID'
			FROM #tempFinalResult csinfo
IF object_id('tempdb.dbo.#groupTbl') is not null DROP TABLE #groupTbl
IF object_id('tempdb.dbo.#GroupAssoc') is not null DROP TABLE #GroupAssoc
IF object_id('tempdb.dbo.#CommCellCount') is not null DROP TABLE #CommCellCount
IF object_id('tempdb.dbo.#ClientCount') is not null DROP TABLE #ClientCount
IF object_id('tempdb.dbo.#SLACounts') is not null DROP TABLE #SLACounts
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetMetricsCompanyInfo')
	delete from GxQscripts where name = 'RptGetMetricsCompanyInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetMetricsCompanyInfo')
	delete from GXDBVersions where aliasname = 'RptGetMetricsCompanyInfo'
GO

insert into GXDBVersions values(2, 'RptGetMetricsCompanyInfo',  '00010001000200020000', 'RptGetMetricsCompanyInfo', '00010001000200020000')
GO

