

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptIndexBackupStatus.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptIndexBackupStatus.sp,v $ $Id: RptIndexBackupStatus.sp,v 1.1.2.11.12.1 2021/06/02 19:03:13 mmansano Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptIndexBackupStatus')
BEGIN
	print '>>> Drop Stored Procedure: RptIndexBackupStatus <<<'
	drop procedure RptIndexBackupStatus
END
IF EXISTS (select * from GxQscripts where name='RptIndexBackupStatus')
	delete from GxQscripts where name = 'RptIndexBackupStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptIndexBackupStatus')
	delete from GXDBVersions where aliasname = 'RptIndexBackupStatus'
GO
print '... Creating Procedure: RptIndexBackupStatus'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptIndexBackupStatus
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 200
DECLARE @strGood VARCHAR(10) = '1_Good'
DECLARE @strInfo VARCHAR(10) = '2_Info'
DECLARE @strwarning VARCHAR(10) = '3_Warning'
DECLARE @strCritical VARCHAR(10) = '4_Critical'
DECLARE @criticalVal int
DECLARE @warningVal int
SELECT  @warningVal = WarningThreshold,
        @criticalVal = CriticalThreshold
FROM cf_SurveyHealthParam where queryId = 200
DECLARE @bufferDaysVal INT = 2
IF object_id('tempdb.dbo.#tmpIdxBackupReportResults') IS NOT NULL DROP TABLE #tmpIdxBackupReportResults
SELECT
	resultView.CommServUniqueId AS [CommServ UniqueId],
	resultView.DisplayName AS [CommCell],
	csInfo.Client AS [Client],
	csInfo.appType AS [Agent],
	csInfo.Backupset AS [Backup Set],
	csInfo.subclientName as [Subclient],
	csInfo.IndexType AS [Index Type],
	csInfo.IndexServer AS [Index Server],
	CASE WHEN csInfo.LastBackupTime != -1 THEN dbo.GetUnixTimeBig(dbo.UTCToLocalDateTimeConversion(dbo.GetDateTime(csInfo.LastBackupTime), CM.CommServTZ)) ELSE -1 END AS [Last Index Backup Time<DATETIME>],
	CASE WHEN (csInfo.LastBackupTime = -1 AND csInfo.IndexType = 'Classic' AND csInfo.LastBackupForDb > CM.CriticalTimestamp AND csInfo.FirstBackupForDb < CM.BufferTimestamp AND csInfo.FirstBackupForDb != -1 AND csInfo.ScIdxConversionTime < CM.BufferTimestamp) -- Apply this only when new data comes in
			  OR (csInfo.LastBackupTime != -1 AND csInfo.LastBackupTime < CM.CriticalTimestamp AND (csInfo.LastBackupForDb = -1 OR csInfo.LastBackupForDb > CM.CriticalTimestamp) AND csInfo.FirstBackupForDb < CM.BufferTimestamp) THEN @strCritical
	     WHEN (csInfo.LastBackupTime != -1 AND csInfo.LastBackupTime >= CM.CriticalTimestamp AND csInfo.LastBackupTime < CM.WarningTimestamp AND (csInfo.LastBackupForDb = -1 OR csInfo.LastBackupForDb > CM.WarningTimestamp) AND csInfo.FirstBackupForDb < CM.BufferTimestamp) THEN @strWarning
		 ELSE @strGood
	END AS [Status<HEALTH_STATUS>]
INTO #tmpIdxBackupReportResults
FROM cf_SurveyIndexBackupStatus AS csInfo WITH (NOLOCK)
INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView ON resultView.SurverResultId = csInfo.SurveyResultId
JOIN (SELECT ID, CommservTZ, dbo.GetUnixTimeBig(ModifiedTime - @criticalVal) CriticalTimestamp, dbo.GetUnixTimeBig(ModifiedTime - @warningVal) WarningTimestamp, dbo.GetUnixTimeBig(ModifiedTime - @bufferDaysVal) BufferTimestamp FROM cf_CommcellIdNameMap WITH (NOLOCK)) CM ON CM.ID = resultView.CommServUniqueId
IF(@blaggregate=1)
BEGIN
	IF @i_CommServUniqueID = 0
	BEGIN
		SELECT
			[CommServ UniqueId],
			[CommCell],
			SUM(CASE WHEN [Status<HEALTH_STATUS>] = @strCritical THEN 1 ELSE 0 END) AS [Critical Count],
			SUM(CASE WHEN [Status<HEALTH_STATUS>] = @strWarning THEN 1 ELSE 0 END) AS [Warning Count],
			SUM(CASE WHEN ([Status<HEALTH_STATUS>] = @strCritical) OR ([Status<HEALTH_STATUS>] = @strWarning) THEN 1  ELSE 0 END) AS [Total Affected]
		FROM #tmpIdxBackupReportResults
		GROUP BY [CommServ UniqueId], [CommCell]
		ORDER BY [Total Affected] DESC
	END
	ELSE
	BEGIN
		SELECT
			SUM(CASE WHEN [Status<HEALTH_STATUS>] = @strCritical THEN 1 ELSE 0 END) AS [Critical Count],
			SUM(CASE WHEN [Status<HEALTH_STATUS>] = @strWarning THEN 1 ELSE 0 END) AS [Warning Count],
			SUM(CASE WHEN ([Status<HEALTH_STATUS>] = @strCritical) OR ([Status<HEALTH_STATUS>] = @strWarning) THEN 1  ELSE 0 END) AS [Total Affected]
		FROM #tmpIdxBackupReportResults
	END
END
ELSE
BEGIN
	IF @i_CommServUniqueID = 0
	BEGIN
		SELECT
			[CommServ UniqueId],
			[CommCell],
			[Client],
			[Agent],
			[Backup Set],
			[Subclient],
			[Index Type],
			[Index Server],
			[Last Index Backup Time<DATETIME>],
			[Status<HEALTH_STATUS>]
		FROM #tmpIdxBackupReportResults
		ORDER BY [Status<HEALTH_STATUS>] DESC, [CommCell] ASC
	END
	ELSE
	BEGIN
		SELECT
			[Client],
			[Agent],
			[Backup Set],
			[Subclient],
			[Index Type],
			[Index Server],
			[Last Index Backup Time<DATETIME>],
			[Status<HEALTH_STATUS>]
		FROM #tmpIdxBackupReportResults ORDER BY [Status<HEALTH_STATUS>] DESC
	END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptIndexBackupStatus')
	delete from GxQscripts where name = 'RptIndexBackupStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptIndexBackupStatus')
	delete from GXDBVersions where aliasname = 'RptIndexBackupStatus'
GO

insert into GXDBVersions values(2, 'RptIndexBackupStatus',  'v1.1.2.11.12.1', 'RptIndexBackupStatus', 'v1.1.2.11.12.1')
GO

