

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptIndexCacheUsage.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptIndexCacheUsage.sp,v $ $Id: RptIndexCacheUsage.sp,v 1.8.56.6 2020/05/05 01:56:07 mmansano Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptIndexCacheUsage')
BEGIN
	print '>>> Drop Stored Procedure: RptIndexCacheUsage <<<'
	drop procedure RptIndexCacheUsage
END
IF EXISTS (select * from GxQscripts where name='RptIndexCacheUsage')
	delete from GxQscripts where name = 'RptIndexCacheUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptIndexCacheUsage')
	delete from GXDBVersions where aliasname = 'RptIndexCacheUsage'
GO
print '... Creating Procedure: RptIndexCacheUsage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptIndexCacheUsage
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 39
DECLARE @strGood VARCHAR(10) = '1_Good'
DECLARE @strInfo VARCHAR(10) = '2_Info'
DECLARE @strwarning VARCHAR(10) = '3_Warning'
DECLARE @strCritical VARCHAR(10) = '4_Critical'
IF @i_CommServUniqueID = 0
BEGIN
SELECT
	resultView.CommServUniqueId AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	resultView.DisplayName AS 'CommCell Name',
	ISNULL(CL.clientDisplayName, csInfo.MAName) AS 'Media Agent',
	csInfo.IndexCachePath AS 'Index Cache Path',
	CASE
		WHEN csInfo.IsShared = 0 THEN 'No'
		ELSE 'Yes'
	END AS 'Is Shared',
	CASE
		WHEN csInfo.IsUNC = 0 THEN 'No'
		ELSE 'Yes'
	END AS 'Is UNC',
	CASE
		WHEN csInfo.IsUNC = 0 THEN @strGood
		ELSE @strwarning
	END AS 'Status<HEALTH_STATUS>',
	CASE
		WHEN csInfo.CacheType = 0 THEN 'Index'
		ELSE 'Logs'
	END AS 'Cache Type'
FROM cf_SurveyIndexCacheUsage AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId AND csInfo.IndexAccessPathEnabled = 1
	LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = csInfo.CommServUniqueId AND CL.ClientName = csInfo.MAName
ORDER BY  [Status<HEALTH_STATUS>] DESC, 'CommCell Name' ASC
END
ELSE
SELECT
	csInfo.CommServUniqueId AS 'CommServ UniqueId',
	ISNULL(CL.clientDisplayName, csInfo.MAName) AS 'Media Agent',
	csInfo.IndexCachePath AS 'Index Cache Path',
	CASE
		WHEN csInfo.IsShared = 0 THEN 'No'
		ELSE 'Yes'
	END AS 'Is Shared',
	CASE
		WHEN csInfo.IsUNC = 0 THEN 'No'
		ELSE 'Yes'
	END AS 'Is UNC',
	CASE
		WHEN csInfo.IsUNC = 0 THEN @strGood
		ELSE @strwarning
	END AS 'Status<HEALTH_STATUS>',
	CASE
		WHEN csInfo.CacheType = 0 THEN 'Index'
		ELSE 'Logs'
	END AS 'Cache Type'
FROM cf_SurveyIndexCacheUsage AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId AND csInfo.IndexAccessPathEnabled = 1
	LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = csInfo.CommServUniqueId AND CL.ClientName = csInfo.MAName
ORDER BY [Status<HEALTH_STATUS>] DESC
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0
  DECLARE @blLatestSurvey INT			= 1
  DECLARE @i_CommServUniqueID INT		= 11065
  DECLARE @i_LogDateEND DATETIME		= 	NULL    -- getDate()
  DECLARE @i_LogDateStart DATETIME		= NULL   --DateAdd(Month, -36, @i_LogDateEND)
exec RptIndexCacheUsage @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND
*/

IF EXISTS (select * from GxQscripts where name = 'RptIndexCacheUsage')
	delete from GxQscripts where name = 'RptIndexCacheUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptIndexCacheUsage')
	delete from GXDBVersions where aliasname = 'RptIndexCacheUsage'
GO

insert into GXDBVersions values(2, 'RptIndexCacheUsage',  '00010008005600060000', 'RptIndexCacheUsage', '00010008005600060000')
GO

