

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptIndexFragmentationDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptIndexFragmentationDetails.sp,v $ $Id: RptIndexFragmentationDetails.sp,v 1.1.2.6 2020/05/11 17:59:07 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptIndexFragmentationDetails')
BEGIN
	print '>>> Drop Stored Procedure: RptIndexFragmentationDetails <<<'
	drop procedure RptIndexFragmentationDetails
END
IF EXISTS (select * from GxQscripts where name='RptIndexFragmentationDetails')
	delete from GxQscripts where name = 'RptIndexFragmentationDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptIndexFragmentationDetails')
	delete from GXDBVersions where aliasname = 'RptIndexFragmentationDetails'
GO
print '... Creating Procedure: RptIndexFragmentationDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptIndexFragmentationDetails
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll,
  @detailWindow INT = 0,
  @databaseName NVARCHAR(MAX) = NULL
AS
SET NOCOUNT ON
IF(@detailWindow < 0 OR @detailWindow > 4) SET @detailWindow = 0
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 144
DECLARE @strGood VARCHAR(10) = '1_Good'
DECLARE @strInfo VARCHAR(10) = '2_Info'
DECLARE @strwarning VARCHAR(10) = '3_Warning'
DECLARE @strCritical VARCHAR(10) = '4_Critical'
DECLARE @strUnknown VARCHAR(10) = '0_Unknown'
DECLARE @criticalThreshold int
DECLARE @warningThreshold int
SELECT  @warningThreshold = WarningThreshold,
        @criticalThreshold =CriticalThreshold
FROM    cf_SurveyHealthParam where queryId = @i_QueryId --Picking up health params for report Database Index Fragmentation
/*Fragmentation of Operational Indices
Good      = No index fragmentation or last DB maintenance ran in last 7 days
Warning = Found indices fragmented over 30% and No DB maintenance ran in last 7 days
Critical    = Found indices fragmented over 30% and No DB maintenance ran in last 30 days
*/
IF @blaggregate = 1 --Summary Report
BEGIN
	IF OBJECT_ID('tempdb.dbo.#summaryTbl') IS NOT NULL DROP TABLE #summaryTbl
	CREATE TABLE #summaryTbl
	(
		CommservUniqueId	INT,
		CommCellName NVARCHAR(MAX),
		ServerName			NVARCHAR(MAX),
		DatabaseName		NVARCHAR(32),
		TotalIndices		INT,
		OperationalIndices	INT,
		WarningIndices		INT,
		CriticalIndices		INT,
		LastFullReindexOperation INT,
        Version INT
	)
	INSERT INTO #summaryTbl
	SELECT
			resultView.CommServUniqueId,
			resultView.DisplayName,
			csInfo.ServerName,
			csInfo.DatabaseName,
			SUM(CASE WHEN csInfo.FragmentationPct = 101 THEN IndexCount ELSE 0 END), --101: Total indices
			SUM(CASE WHEN csInfo.FragmentationPct = 102 THEN IndexCount ELSE 0 END), --102: Total operational indices
			SUM(CASE WHEN csInfo.FragmentationPct >= @warningThreshold AND csInfo.FragmentationPct < @criticalThreshold THEN IndexCount ELSE 0 END),
			SUM(CASE WHEN csInfo.FragmentationPct >= @criticalThreshold AND csInfo.FragmentationPct < 100 THEN IndexCount ELSE 0 END),
			MAX(LastFullReindexOperation) LastFullReindexOperation,
			CASE WHEN LEFT(resultView.CommServVersion,2) LIKE '11%' THEN 11
				 WHEN LEFT(resultView.CommServVersion,2) LIKE '9.%' THEN 9
				 WHEN LEFT(resultView.CommServVersion,2) LIKE '10%' THEN 10
			ELSE 0 END
		FROM cf_SurveyIndexFragmentation AS csInfo WITH (NOLOCK)
				INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
					ON resultView.SurverResultId = csInfo.SurveyResultId
		GROUP BY resultView.CommServUniqueId, csInfo.ServerName, csInfo.DbId, csInfo.DatabaseName, resultView.DisplayName,resultView.CommServVersion
	IF @i_CommServUniqueID = 0
	BEGIN
        SELECT *
        FROM
	    (
		SELECT smy.CommservUniqueId  AS 'CommServ UniqueId', CommCellName AS 'CommCell',
				ServerName AS 'Server<HIDDEN>',
				DatabaseName AS 'Database',
				OperationalIndices AS 'Total Operational Indexes',
				WarningIndices AS '30% to 50% Fragmented Indexes<DBINDEXFRAG1>',
				CriticalIndices AS '50% to 100% Fragmented Indexes<DBINDEXFRAG2>',
				CASE WHEN (DATEDIFF(day,dbo.GetDateTime(LastFullReindexOperation),getdate()) <= 7) OR (CriticalIndices=0 and WarningIndices=0) THEN  @strGood
					 WHEN (DATEDIFF(day,dbo.GetDateTime(LastFullReindexOperation),getdate()) BETWEEN  7 AND 30) AND (WarningIndices>0 or CriticalIndices >0 ) THEN @strWarning
					 WHEN (DATEDIFF(day,dbo.GetDateTime(LastFullReindexOperation),getdate()) > 30) AND (WarningIndices>0 or CriticalIndices >0 ) THEN @strCritical
				END AS 'Status<HEALTH_STATUS>',
				CASE WHEN LastFullReindexOperation > 0 THEN LastFullReindexOperation
					ELSE -3 END
				AS 'Last DB Maintenance Time<MMMDDYYYY><HIDDEN>'
		FROM #summaryTbl smy
 	                         WHERE  smy.version<11
		 UNION
		SELECT smy.CommservUniqueId  AS 'CommServ UniqueId', CommCellName AS 'CommCell',
						ServerName AS 'Server<HIDDEN>',
						DatabaseName AS 'Database',
						OperationalIndices AS 'Total Operational Indexes',
						WarningIndices AS '30% to 50% Fragmented Indexes<DBINDEXFRAG1>',
						CriticalIndices AS '50% to 100% Fragmented Indexes<DBINDEXFRAG2>',
						CASE	WHEN CriticalIndices > 0.25*OperationalIndices THEN @strCritical
								WHEN WarningIndices > 0.25*OperationalIndices THEN @strWarning
								ELSE @strGood
						END AS 'Status<HEALTH_STATUS>',
						CASE WHEN LastFullReindexOperation > 0 THEN LastFullReindexOperation
							ELSE -3 END
						AS 'Last DB Maintenance Time<MMMDDYYYY><HIDDEN>'
		FROM #summaryTbl smy WHERE Smy.version>=11
        )Details ORDER BY CommCell, [Database]
	END
	ELSE
	BEGIN
        SELECT *
        FROM
	    (
        SELECT	ServerName AS 'Server<HIDDEN>',
				DatabaseName AS 'Database',
				OperationalIndices AS 'Total Operational Indexes',
				WarningIndices AS '30% to 50% Fragmented Indexes<DBINDEXFRAG1>',
				CriticalIndices AS '50% to 100% Fragmented Indexes<DBINDEXFRAG2>',
				CASE	WHEN CriticalIndices > 0.25*OperationalIndices THEN @strCritical
						WHEN WarningIndices > 0.25*OperationalIndices THEN @strWarning
						ELSE @strGood
				END AS 'Status<HEALTH_STATUS>',
				CASE WHEN LastFullReindexOperation > 0 THEN LastFullReindexOperation
					ELSE -3 END
				AS 'Last DB Maintenance Time<MMMDDYYYY><HIDDEN>'
		FROM #summaryTbl smy  WHERE Smy.version<11
		UNION
		SELECT	ServerName AS 'Server<HIDDEN>',
				DatabaseName AS 'Database',
				OperationalIndices AS 'Total Operational Indexes',
				WarningIndices AS '30% to 50% Fragmented Indexes<DBINDEXFRAG1>',
				CriticalIndices AS '50% to 100% Fragmented Indexes<DBINDEXFRAG2>',
				CASE WHEN (DATEDIFF(day,dbo.GetDateTime(LastFullReindexOperation),getdate()) <= 7) OR (CriticalIndices=0 and WarningIndices=0) THEN  @strGood
					 WHEN (DATEDIFF(day,dbo.GetDateTime(LastFullReindexOperation),getdate()) BETWEEN  7 AND 30) AND (WarningIndices>0 or CriticalIndices >0 ) THEN @strWarning
					 WHEN (DATEDIFF(day,dbo.GetDateTime(LastFullReindexOperation),getdate()) > 30) AND (WarningIndices>0 or CriticalIndices >0 ) THEN @strCritical
				END AS 'Status<HEALTH_STATUS>',
				CASE WHEN LastFullReindexOperation > 0 THEN LastFullReindexOperation
					ELSE -3 END
				AS 'Last DB Maintenance Time<MMMDDYYYY><HIDDEN>'
		FROM #summaryTbl smy
		 WHERE Smy.version>=11
          )Details ORDER BY  [Database]
	END
	IF OBJECT_ID('tempdb.dbo.#summaryTbl') IS NOT NULL DROP TABLE #summaryTbl
END
ELSE --Detailed Report
BEGIN
	IF @i_CommServUniqueID = 0 OR @databaseName IS NULL OR @detailWindow = 0
		RETURN
	SELECT
		csInfo.TableName AS 'Table',
		csInfo.RowsCount AS 'Row Count',
		csInfo.IndexName AS 'Index',
		CASE csInfo.IndexType
			WHEN 1 THEN 'Clustered index'
			WHEN 2 THEN 'Nonclustered index'
			WHEN 3 THEN 'XML index'
			WHEN 4 THEN 'Spatial index'
			WHEN 5 THEN 'Clustered columnstore index'
			WHEN 6 THEN 'Nonclustered columnstore index'
			WHEN 7 THEN 'Nonclustered hash index'
		END AS 'Index Type',
		csInfo.AvgFragPercent AS 'Average Fragmentation Percent',
		csInfo.IndexFillFactor AS 'Fill Factor<HIDDEN>',
		csInfo.PageCount AS 'Page Count<HIDDEN>',
		csInfo.AvgFragSizePageCount AS 'Fragment Count<HIDDEN>',
		csInfo.PageSplitForIndex AS 'Page Split<HIDDEN>',
		csInfo.PageAllocByPageSplit AS 'Page Allocations By Page Split<HIDDEN>'
	FROM cf_SurveyIndexFragmentationDetails AS csInfo WITH (NOLOCK)
				INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
					ON resultView.SurverResultId = csInfo.SurveyResultId
	WHERE (csInfo.DatabaseName = @databaseName)
		AND (	(@detailWindow = 1 AND csInfo.AvgFragPercent >= @warningThreshold AND csInfo.AvgFragPercent < @criticalThreshold) OR
				(@detailWindow = 2 AND csInfo.AvgFragPercent >= @criticalThreshold))
	ORDER BY csInfo.AvgFragPercent DESC
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptIndexFragmentationDetails')
	delete from GxQscripts where name = 'RptIndexFragmentationDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptIndexFragmentationDetails')
	delete from GXDBVersions where aliasname = 'RptIndexFragmentationDetails'
GO

insert into GXDBVersions values(2, 'RptIndexFragmentationDetails',  '00010001000200060000', 'RptIndexFragmentationDetails', '00010001000200060000')
GO

