

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptLibraryAudit.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptLibraryAudit.sp,v $ $Id: RptLibraryAudit.sp,v 1.7.2.5 2020/12/17 02:54:44 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptLibraryAudit')
BEGIN
	print '>>> Drop Stored Procedure: RptLibraryAudit <<<'
	drop procedure RptLibraryAudit
END
IF EXISTS (select * from GxQscripts where name='RptLibraryAudit')
	delete from GxQscripts where name = 'RptLibraryAudit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLibraryAudit')
	delete from GXDBVersions where aliasname = 'RptLibraryAudit'
GO
print '... Creating Procedure: RptLibraryAudit'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptLibraryAudit
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @bAggregate INT = 1,
  @i_stdCommServUniqueID INT = 0,
  @i_stdLibraryID INT = 0,
  @i_stdMountPathID INT = 0,
  @i_CommServUniqueID INT = 0,
  @i_PropertyGroup VARCHAR(32) = ''
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 93
-- default is for all properties
DECLARE @i_PropertyGroupId INT = 0
IF	@i_PropertyGroup = 'Passed Audit'
	SET @i_PropertyGroupId = -1
ELSE IF	@i_PropertyGroup = 'General'
	SET @i_PropertyGroupId = 1
ELSE IF	@i_PropertyGroup = 'Mount Path'
	SET @i_PropertyGroupId = 2
ELSE IF	@i_PropertyGroup = 'Media'
	SET @i_PropertyGroupId = 3
ELSE IF	@i_PropertyGroup = 'Drive'
	SET @i_PropertyGroupId = 4
ELSE IF	@i_PropertyGroup = 'Advanced'
	SET @i_PropertyGroupId = 5
/* Library Types:
1	- TAPE
2	- OPTICAL
3	- DISK
4	- STANDALONE TAPE
5	- STANDALONE OPTICAL
*/
DECLARE @stdLibraryTypeId		INT = 0
DECLARE @LibraryAttributes		BIGINT = 0
DECLARE @stdLibAttributes		BIGINT = 0
DECLARE @LibraryExtAttributes	INT = 0
DECLARE @stdLibExtAttributes	INT = 0
DECLARE @MountPathAttributes	INT = 0
DECLARE @stdMPAttributes		INT = 0
DECLARE @stdDefMediaTypeName	VARCHAR(32) = ''
DECLARE @stdVMSForExport		VARCHAR(32) = ''
DECLARE @stdCustomerName		VARCHAR(256) = ''
DECLARE @isPrivate 				INT = 0
DECLARE @showHiddenLibraries	INT = 0
IF EXISTS (SELECT TOP 1 1 FROM cf_SurveyConfig WHERE name = 'showHiddenLibraries' AND value = '1')
	SET @showHiddenLibraries = 1
SELECT	@isPrivate = ISNULL(CAST(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
IF	@isPrivate = 0
	SELECT @stdCustomerName = CustomerName FROM cf_CommcellIdNameMap WHERE ID = @i_stdCommServUniqueID
CREATE	TABLE #LatestResult (CommServId INT, SurveyResultId BIGINT, LogDate DATETIME)
INSERT	INTO #LatestResult
SELECT	CommServUniqueId, SurverResultId, LogDate
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, 0, 1, NULL, NULL, @i_UserId,@i_GroupId)
WHERE	(@stdCustomerName = '' OR CustomerName = @stdCustomerName)
IF	@i_stdCommServUniqueID > 0 AND @i_stdLibraryID = 0
BEGIN
	SELECT	R.CommServId	AS 'CommServ UniqueId',
			L.LibraryName	AS 'Library',
			L.LibraryID		AS 'Library ID',
			ISNULL(MP.MountPathName, '') AS 'MountPath',
			ISNULL(MP.MountPathID, 0)    AS 'MountPath ID'
	FROM	#LatestResult R
			INNER JOIN cf_SurveyLibraryProp L
ON L.SurveyResultId = R.SurveyResultId AND (@showHiddenLibraries = 1 OR (L.ExtendedAttributes & 33554432) = 0)
			LEFT OUTER JOIN cf_SurveyMountPathProp MP
				ON MP.SurveyResultId = L.SurveyResultId AND MP.LibraryId = L.LibraryId
	WHERE	R.CommServId = @i_stdCommServUniqueID
	ORDER BY 'Library', 'MountPath'
	DROP TABLE #LatestResult
	RETURN
END
ELSE
IF	@i_stdCommServUniqueID > 0 AND @i_stdLibraryID > 0 AND @i_stdMountPathID = 0
BEGIN
	DECLARE	@MountPathCounts INT = 0
	SELECT	@i_stdMountPathID = ISNULL(MAX(MountPathId), 0), @MountPathCounts = COUNT(*)
	FROM	#LatestResult R
			INNER JOIN cf_SurveyMountPathProp MP
				ON MP.SurveyResultId = R.SurveyResultId
	WHERE	R.CommServId = @i_stdCommServUniqueID AND MP.LibraryId = @i_stdLibraryID
	IF	@MountPathCounts > 1
		RETURN
END
DECLARE @TblLibraryAttribute TABLE (attribute BIGINT, name VARCHAR(128), propertyGroup INT)
INSERT INTO @TblLibraryAttribute
SELECT 1,	'Enable Auto-Cleaning: On sense code', 4
--UNION ALL SELECT MMS2_LIBRARY_PREIMPORT_OFF, ''
--UNION ALL SELECT MMS2_LIBRARY_INVALID_CONFIG, ''
UNION ALL SELECT 8, 'Enable Auto-Discovery of media into default scratch pool', 3
UNION ALL SELECT 16, 'Overwite media when content verification fails', 3
UNION ALL SELECT 32, 'Overwite media when it is from different CommCell', 3
UNION ALL SELECT 64, 'Enable Auto-Recovery when media is stuck in drive', 3
UNION ALL SELECT 128, 'Start new media when required media is exported', 3
UNION ALL SELECT 256, 'Start new media when required media is stuck in drive', 3
UNION ALL SELECT 512, 'Use Appendable Media', 3
UNION ALL SELECT 1024, 'Mark Library/Drive broken when error threshold exceeded', 4
UNION ALL SELECT 2048, 'Continue using drive even if need cleaning during restore', 4
UNION ALL SELECT 4096, 'Attempt to remove media from the drive when unload fails', 3
UNION ALL SELECT 8192, 'Enable Auto-Cleaning: Cleaning thresholds exceed', 4
UNION ALL SELECT 16384, 'Overwrite Media in Drive if Media Not Written to in N Days/Hours', 3
UNION ALL SELECT 32768, 'Use media in virtual mail slot for data protection', 3
UNION ALL SELECT 65536, 'Check for cleaning media loaded in Drive', 4
UNION ALL SELECT 131072, 'Verify access path using Serial Number for Drive', 4
UNION ALL SELECT 262144, 'Mark Media Appendable', 3
UNION ALL SELECT 524288, 'Check for Tape Alerts', 4
UNION ALL SELECT 1048576, 'Unmount Media after N Hours/Minutes of inactivity', 3
UNION ALL SELECT 2097152, 'Show Media related pop-up messages on CommCell Console', 3
--UNION ALL SELECT MMS2_LIBRARY_ENABLE_STDALN_CACHEMNT, ''
UNION ALL SELECT 8388608, 'Mark Archive files as Read-Only', 1
UNION ALL SELECT 16777216, 'Use SCSI-3 Reserve for contention resolution', 4
UNION ALL SELECT 33554432, 'Set drive as needs cleaning on Cyclic Redundancy Check (CRC) errors', 4
--UNION ALL SELECT MMS2_LIBRARY_SN6K, ''
UNION ALL SELECT 134217728, 'Check for media change in drive every N minute(s)', 4
UNION ALL SELECT 268435456, 'Disks within this library support Hardware Single Instancing', 2
UNION ALL SELECT 536870912, 'Automatically create storage policy for new data paths', 1
UNION ALL SELECT 1073741824, 'Retry read operations on SCSI errors', 5
UNION ALL SELECT 2147483648, 'Automatically add data paths for new drivepools configured', 5
SELECT @LibraryAttributes = SUM(attribute) FROM @TblLibraryAttribute
DECLARE @TblLibraryExtAttribute	TABLE (attribute INT, name VARCHAR(128), propertyGroup INT)
INSERT INTO @TblLibraryExtAttribute
SELECT 1, 'Spill and fill mount paths', 2
UNION ALL SELECT 2, 'Use SCSI-2 Reserve for contention resolution', 4
UNION ALL SELECT 4, 'Automatically use spare media from different scratch pool if found in drive', 3
UNION ALL SELECT 8, 'Automatically update barcodes on firmware changes', 5
UNION ALL SELECT 16, 'Unload media in standalone drive when different media is required', 4
UNION ALL SELECT 32, 'Skip unload drive for Autoloaders before unmounting media', 4
UNION ALL SELECT 64, 'Detect and update media type when media is loaded into the drive', 4
UNION ALL SELECT 128, 'Reset container when assigned media re-appears in library', 3
UNION ALL SELECT 256, 'Reset export location when assigned media re-appears in library', 3
UNION ALL SELECT 512, 'Mark library offline for maintenance', 1
--UNION ALL SELECT MMS2_LIBRARY_EXT_VTL, ''
UNION ALL SELECT 2048, 'Prevent use of tapes from a different backup vendor', 3
--UNION ALL SELECT MMS2_LIBRARY_EXT_PNP_DISK_BASED, ''
UNION ALL SELECT 8192, 'Only use PnP disk when it is blank', 3
UNION ALL SELECT 16384, 'Enable Auto Drive Replacement when new device is detected during Mount', 4
UNION ALL SELECT 32768, 'Submit full scan on library when finding an empty barcode during drive unmounts', 5
--UNION ALL SELECT MMS2_LIBRARY_EXT_MAG_SDR_ENABLED, ''
UNION ALL SELECT 131072, 'Do not import media from I/E port back to the slots', 5
UNION ALL SELECT 262144, 'Prevent accidental deletion of data from mount paths', 2
--UNION ALL SELECT MMS2_LIBRARY_EXT_KEEP_SCRATCH_MEDIA_ON_DECONFIGURE, 'Keep scratch media if library is deconfigured', 3
--UNION ALL SELECT MMS2_LIBRARY_EXT_COMMNET2_REGISTERED_COMMCELL, ''
UNION ALL SELECT 33554432, 'Hidden Library', 1
SELECT @LibraryExtAttributes = SUM(attribute) FROM @TblLibraryExtAttribute
DECLARE @TblMountPathAttribute TABLE (attribute INT, name VARCHAR(128))
INSERT INTO @TblMountPathAttribute
SELECT 1, 'Use unbuffered I/O'
UNION ALL SELECT 2, 'Reserve space for SILO restores'
UNION ALL SELECT 4, ''
SELECT @MountPathAttributes	= SUM(attribute) FROM @TblMountPathAttribute
CREATE TABLE #LibraryProp
(
	CommServId					INT,
	LibraryId					INT,
	LibraryName					NVARCHAR(128),
	LibraryEnabled				INT,
	LibraryTypeId				INT,
	LowWaterMarkMB				INT,
	LibraryAttribute 			BIGINT,
	MountTimeoutMinutes			INT,
	UnmountTimeoutMinutes		INT,
	DefaultMediaTypeName		VARCHAR(32),
	UseAppendableWithinDays		INT,
	DriveCleanIntervalInDay		INT,
	VirtualMailSlotForExport	VARCHAR(64),
	CacheMountPeriodInMinute	INT,
	StdAlnMedRetentionHours		INT,
	TURIntervalInSec			INT,
	ConfigParams				VARCHAR(256),
	StdAlnChkIntervalInMinute	INT,
	ReadRetryIntervalInMinute	INT,
	ReadRetryAttempts			INT,
	ExtendedAttributes			INT,
	UpperThreshold				INT,
	LowerThreshold				INT,
	WarningWaterMark			INT,
	MaxSwitchForHost			INT,
	PreventPhysicalInventory	INT,
	PeriodicMailSlotCheck		INT,
	PreventAutoImport			INT,
	RemoveMediaFromMailSlot		INT,
	MountPathPropMatch			INT
)
CREATE TABLE #MountPathProp
(
	CommServId					INT,
	LibraryId					INT,
	MountPathId					INT,
	MountPathName				NVARCHAR(1024),
	IsEnabled					INT,
	MaxConcurrentWriters 		INT,
	MaxDataToWriteMB 			INT,
	MagneticSpaceRsrvInMB		INT,
	Attribute 					INT,
	MagneticChunkFileIncrSizeMB INT,
	DeviceEnabled 				INT
)
INSERT	INTO #LibraryProp
SELECT	R.CommServId,
		LibraryId,
		LibraryName,
		LibraryEnabled,
		LibraryTypeId,
		LowWaterMarkMB,
		LibraryAttribute & @LibraryAttributes,
		MountTimeoutSec/60,
		UnmountTimeoutSec/60,
		DefaultMediaTypeName,
		UseWithinDaysInSec/60/24,
		DriveCleanIntervalInSec/60/24,
		CASE VMSDirection
			 WHEN 1 THEN 'Start from Slot ' + CAST(StartVMSElementAddress AS VARCHAR(32)) + ' and UP'
			 WHEN 2 THEN 'Start from Slot ' + CAST(StartVMSElementAddress AS VARCHAR(32)) + ' and DOWN'
			 ELSE 'Not Enabled'
		END,
		CacheMountPeriodInSec/60,
		StdAlnMedRetentionTime/60/60,
		TURIntervalInSec,
		RIGHT(ConfigParams, LEN(ConfigParams) - CHARINDEX('-', ConfigParams)),
		StdAlnChkIntervalInSec/60,
		ReadRetryIntervalInSec/60,
		ReadRetryAttempts,
(ExtendedAttributes ^ 4) & @LibraryExtAttributes,
		ThresholdPercentage,
		ThresholdPercentage - ThresholdVariation,
		WarningWaterMark,
		MaxSwitchForHost,
		0, 0, 0, 0,
		CASE WHEN R.CommServId = @i_stdCommServUniqueID AND L.LibraryId = @i_stdLibraryID OR @i_stdMountPathID = 0 THEN 1 ELSE 0 END
FROM	#LatestResult R
		INNER JOIN cf_SurveyLibraryProp L
ON L.SurveyResultId = R.SurveyResultId AND (@showHiddenLibraries = 1 OR (L.ExtendedAttributes & 33554432) = 0)
WHERE	(R.CommServId = @i_stdCommServUniqueID AND L.LibraryId = @i_stdLibraryID
		OR  @i_CommServUniqueID = 0 OR R.CommServId = @i_CommServUniqueID)
SELECT	@stdLibraryTypeId = LibraryTypeId,
		@stdLibAttributes = LibraryAttribute,
		@stdLibExtAttributes = ExtendedAttributes,
		@stdDefMediaTypeName = DefaultMediaTypeName,
		@stdVMSForExport = VirtualMailSlotForExport
FROM	#LibraryProp
WHERE	CommServId = @i_stdCommServUniqueID AND LibraryId = @i_stdLibraryID
IF @stdLibraryTypeId IN (1, 2)
	DELETE #LibraryProp WHERE LibraryTypeId NOT IN (1, 2)
ELSE IF @stdLibraryTypeId = 3
	DELETE #LibraryProp WHERE LibraryTypeId <> 3
ELSE IF @stdLibraryTypeId IN (4, 5)
	DELETE #LibraryProp WHERE LibraryTypeId NOT IN (4, 5)
UPDATE	#LibraryProp SET ReadRetryIntervalInMinute = S.ReadRetryIntervalInMinute, ReadRetryAttempts = S.ReadRetryAttempts
FROM	(SELECT * FROM #LibraryProp WHERE CommServId = @i_stdCommServUniqueID AND LibraryId = @i_stdLibraryID) S
WHERE	(#LibraryProp.CommServId <> @i_stdCommServUniqueID OR #LibraryProp.LibraryId <> @i_stdLibraryID)
AND ((#LibraryProp.LibraryAttribute & 1073741824) = 0 OR (S.LibraryAttribute & 1073741824) = 0)
DECLARE	@idx INT = 1
DECLARE	@cnt INT = 1
WHILE @idx > 0 AND @cnt < 10
BEGIN
	IF	@cnt = 1
		UPDATE	#LibraryProp
		SET		ConfigParams = RIGHT(ConfigParams, LEN(ConfigParams) - CHARINDEX('-', ConfigParams)),
				PreventPhysicalInventory =  SUBSTRING(ConfigParams, 0, CHARINDEX('-', ConfigParams))
		WHERE	ConfigParams <> ''
	ELSE IF	@cnt = 2
		UPDATE	#LibraryProp
		SET		ConfigParams = RIGHT(ConfigParams, LEN(ConfigParams) - CHARINDEX('-', ConfigParams)),
				PeriodicMailSlotCheck =  SUBSTRING(ConfigParams, 0, CHARINDEX('-', ConfigParams))
		WHERE	ConfigParams <> ''
	ELSE IF	@cnt = 4
		UPDATE	#LibraryProp
		SET		ConfigParams = RIGHT(ConfigParams, LEN(ConfigParams) - CHARINDEX('-', ConfigParams)),
				PreventAutoImport =  SUBSTRING(ConfigParams, 0, CHARINDEX('-', ConfigParams))
		WHERE	ConfigParams <> ''
	ELSE IF	@cnt = 9
		UPDATE	#LibraryProp
		SET		ConfigParams = RIGHT(ConfigParams, LEN(ConfigParams) - CHARINDEX('-', ConfigParams)),
				RemoveMediaFromMailSlot =  SUBSTRING(ConfigParams, 0, CHARINDEX('-', ConfigParams))
		WHERE	ConfigParams <> ''
	ELSE
		UPDATE	#LibraryProp
		SET		ConfigParams = RIGHT(ConfigParams, LEN(ConfigParams) - CHARINDEX('-', ConfigParams))
		WHERE	ConfigParams <> ''
	SET @cnt = @cnt+1
END
DECLARE	@TblLibraryCount	TABLE (CommServId INT, Count INT)
DECLARE	@TblPassedMountPath TABLE (CommServId INT, LibraryId INT, MountPathId INT, MountPathName NVARCHAR(1024))
IF  @i_stdMountPathID > 0
BEGIN
	INSERT	INTO #MountPathProp
	SELECT	R.CommServId,
			LibraryId,
			MountPathId,
			MountPathName,
			IsEnabled,
			MaxConcurrentWriters,
			MaxDataToWriteMB,
			MagneticSpaceRsrvInMB,
			Attribute & @MountPathAttributes,
			MagneticChunkFileIncrSizeMB,
			DeviceEnabled
	FROM	#LatestResult R
			INNER JOIN cf_SurveyMountPathProp MP
				ON MP.SurveyResultId = R.SurveyResultId
	WHERE	(R.CommServId = @i_stdCommServUniqueID AND MP.MountPathId = @i_stdMountPathID
			OR  @i_CommServUniqueID = 0 OR R.CommServId = @i_CommServUniqueID)
	SELECT	@stdMPAttributes = Attribute
	FROM	#MountPathProp
	WHERE	CommServId = @i_stdCommServUniqueID AND MountPathId = @i_stdMountPathID
	INSERT	INTO @TblPassedMountPath
	SELECT	P.CommServId, P.LibraryId, P.MountPathId, P.MountPathName
	FROM	#MountPathProp P INNER JOIN
			(SELECT * FROM #MountPathProp WHERE CommServId = @i_stdCommServUniqueID AND MountPathId = @i_stdMountPathID) S
		ON	(P.CommServId <> S.CommServId OR P.MountPathId <> S.MountPathId)
		AND P.IsEnabled = S.IsEnabled
		AND P.MaxConcurrentWriters = S.MaxConcurrentWriters
		AND P.MaxDataToWriteMB = S.MaxDataToWriteMB
		AND P.MagneticSpaceRsrvInMB = S.MagneticSpaceRsrvInMB
		AND P.Attribute = S.Attribute
		AND P.MagneticChunkFileIncrSizeMB = S.MagneticChunkFileIncrSizeMB
		AND P.DeviceEnabled = S.DeviceEnabled
	INSERT	INTO @TblLibraryCount
	SELECT	CommServId, COUNT(DISTINCT LibraryId)
	FROM	#MountPathProp
	WHERE	CommServId <> @i_stdCommServUniqueID OR MountPathID <> @i_stdMountPathID
	GROUP BY CommServId
	DELETE	#MountPathProp
	FROM	@TblPassedMountPath D
	WHERE	#MountPathProp.CommServId = D.CommServId AND #MountPathProp.MountPathId = D.MountPathId
	UPDATE	#LibraryProp SET MountPathPropMatch = 1
	FROM	(SELECT DISTINCT CommServId, LibraryId FROM @TblPassedMountPath) P
			LEFT OUTER JOIN #MountPathProp MP ON P.CommServId = MP.CommServId AND P.LibraryId = MP.LibraryId
	WHERE	MP.LibraryId IS NULL
		AND #LibraryProp.CommServId = P.CommServId AND #LibraryProp.LibraryId = P.LibraryId
END
ELSE
	INSERT	INTO @TblLibraryCount
	SELECT	CommServId, COUNT(LibraryId)
	FROM	#LibraryProp
	WHERE	CommServId <> @i_stdCommServUniqueID OR LibraryId <> @i_stdLibraryID
	GROUP BY CommServId
DECLARE	@TblPassedLibrary TABLE (CommServId INT, LibraryId INT, LibraryName NVARCHAR(128))
INSERT	INTO @TblPassedLibrary
SELECT	P.CommServId, P.LibraryId, P.LibraryName
FROM	#LibraryProp P INNER JOIN
		(SELECT * FROM #LibraryProp WHERE CommServId = @i_stdCommServUniqueID AND LibraryId = @i_stdLibraryID) S
	ON	(P.CommServId <> S.CommServId OR P.LibraryId <> S.LibraryId)
	AND P.LowWaterMarkMB = S.LowWaterMarkMB
	AND P.LibraryAttribute = S.LibraryAttribute
	AND P.MountTimeoutMinutes = S.MountTimeoutMinutes
	AND P.UnmountTimeoutMinutes = S.UnmountTimeoutMinutes
	AND P.DefaultMediaTypeName = S.DefaultMediaTypeName
	AND P.UseAppendableWithinDays = S.UseAppendableWithinDays
	AND P.DriveCleanIntervalInDay = S.DriveCleanIntervalInDay
	AND P.VirtualMailSlotForExport = S.VirtualMailSlotForExport
	AND P.CacheMountPeriodInMinute = S.CacheMountPeriodInMinute
	AND P.StdAlnMedRetentionHours = S.StdAlnMedRetentionHours
	AND P.TURIntervalInSec = S.TURIntervalInSec
	AND P.StdAlnChkIntervalInMinute = S.StdAlnChkIntervalInMinute
	AND P.ReadRetryIntervalInMinute = S.ReadRetryIntervalInMinute
	AND P.ReadRetryAttempts = S.ReadRetryAttempts
	AND P.ExtendedAttributes = S.ExtendedAttributes
	AND P.UpperThreshold = S.UpperThreshold
	AND P.LowerThreshold = S.LowerThreshold
	AND P.WarningWaterMark = S.WarningWaterMark
	AND P.MaxSwitchForHost = S.MaxSwitchForHost
	AND	P.PreventPhysicalInventory = S.PreventPhysicalInventory
	AND	P.PeriodicMailSlotCheck = S.PeriodicMailSlotCheck
	AND	P.PreventAutoImport = S.PreventAutoImport
	AND	P.RemoveMediaFromMailSlot = S.RemoveMediaFromMailSlot
	AND P.MountPathPropMatch = 1
IF	@i_PropertyGroupId = -1
BEGIN
	IF	@i_CommServUniqueID = 0
		SELECT	CS.CommServName	AS 'CommCell',
				P.LibraryName AS 'Library'
		FROM	@TblPassedLibrary P
				INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
		ORDER BY CS.CommServName, P.LibraryName
	ELSE
		SELECT	LibraryName AS 'Library'
		FROM	@TblPassedLibrary
		ORDER BY LibraryName
	DROP TABLE #LatestResult
	DROP TABLE #LibraryProp
	DROP TABLE #MountPathProp
	RETURN
END
DELETE	#LibraryProp
FROM	@TblPassedLibrary P
WHERE	#LibraryProp.CommServId = P.CommServId AND #LibraryProp.LibraryId = P.LibraryId
CREATE	TABLE #LibraryProperty (CommServId INT, LibraryId INT, MountPathId INT,
		PropertyGroup INT, Property VARCHAR(128), Value NVARCHAR(MAX), stdValue NVARCHAR(MAX))
;WITH LibraryProperty (CommServId, LibraryId, Property, Value) AS
(
	SELECT	P.CommServId, P.LibraryId, P.Property, P.Value
	FROM	#LibraryProp
			UNPIVOT (Value FOR Property IN (
				LibraryEnabled,	LowWaterMarkMB, MountTimeoutMinutes, UnmountTimeoutMinutes,
				UseAppendableWithinDays, DriveCleanIntervalInDay, CacheMountPeriodInMinute, StdAlnMedRetentionHours,
				TURIntervalInSec, StdAlnChkIntervalInMinute, ReadRetryIntervalInMinute, ReadRetryAttempts,
				UpperThreshold, LowerThreshold, WarningWaterMark, MaxSwitchForHost,
				PreventPhysicalInventory, PeriodicMailSlotCheck, PreventAutoImport, RemoveMediaFromMailSlot)
			) P
)
INSERT	INTO #LibraryProperty
SELECT	P.CommServId, P.LibraryId, 0,
		CASE WHEN P.Property IN ('LibraryEnabled', 'LowWaterMarkMB', 'WarningWaterMark', 'MountTimeoutMinutes',
								'UnmountTimeoutMinutes') THEN 1
			WHEN P.Property IN ('UpperThreshold', 'LowerThreshold', 'MaxSwitchForHost') THEN 2
			WHEN P.Property IN ('UseAppendableWithinDays', 'CacheMountPeriodInMinute', 'StdAlnMedRetentionHours') THEN 3
			WHEN P.Property IN ('DriveCleanIntervalInDay', 'StdAlnChkIntervalInMinute') THEN 4
			WHEN P.Property IN ('TURIntervalInSec', 'ReadRetryIntervalInMinute', 'ReadRetryAttempts', 'PreventPhysicalInventory',
								'PeriodicMailSlotCheck', 'PreventAutoImport', 'RemoveMediaFromMailSlot') THEN 5
		END,
		CASE WHEN P.Property = 'LibraryEnabled' THEN 'Enable Library'
			WHEN P.Property = 'LowWaterMarkMB' THEN 'Low Watermark (%)'
			WHEN P.Property = 'WarningWaterMark' THEN 'Warning Watermark (%)'
			WHEN P.Property = 'MountTimeoutMinutes' THEN 'Mount Timeouts (in minutes)'
			WHEN P.Property = 'UnmountTimeoutMinutes' THEN 'Unmount Timeouts (in minutes)'
			WHEN P.Property = 'UpperThreshold' THEN 'Start aging when data occupied on disk is N%'
			WHEN P.Property = 'LowerThreshold' THEN 'Stop aging when data occupied on disk is N%'
			WHEN P.Property = 'MaxSwitchForHost' THEN 'Mount Path Allocation Policy - Allocate number of Writers'
			WHEN P.Property = 'CacheMountPeriodInMinute' THEN 'Unmount Media from the drive after N minutes of inactivity'
			WHEN P.Property = 'StdAlnMedRetentionHours' THEN 'Overwrite Media in Drive if Media Not Written to in N Days/Hours'
			WHEN P.Property = 'DriveCleanIntervalInDay' THEN 'Enable Auto Cleaning - Wait N day(s) after last cleaning'
			WHEN P.Property = 'StdAlnChkIntervalInMinute' THEN 'Check for media change in drive every N minute(s)'
			WHEN P.Property = 'TURIntervalInSec' THEN 'Library Status Check Interval in seconds'
			WHEN P.Property = 'ReadRetryIntervalInMinute' THEN 'Retry Read operations on SCSI errors - retry interval in minutes'
			WHEN P.Property = 'ReadRetryAttempts' THEN 'Retry Read operations on SCSI errors - retry times'
			WHEN P.Property = 'PreventPhysicalInventory' THEN 'Prevent physical inventory of the library'
			WHEN P.Property = 'PeriodicMailSlotCheck' THEN 'Do Periodic mail slot check for any change in status'
			WHEN P.Property = 'PreventAutoImport' THEN 'Prevent Auto Import of Media from mail slot'
			WHEN P.Property = 'RemoveMediaFromMailSlot' THEN 'Allow Medium Removal from mail slot'
		END,
		CASE WHEN P.Property IN ('LibraryEnabled', 'PreventPhysicalInventory', 'PeriodicMailSlotCheck', 'PreventAutoImport', 'RemoveMediaFromMailSlot')
				THEN (CASE P.Value WHEN 0 THEN 'No' ELSE 'Yes' END)
			WHEN P.Property = 'MaxSwitchForHost'
				THEN (CASE P.Value WHEN -1 THEN 'Maximum Allowed Writers' ELSE 'Allocate number of Writers: ' + CAST(P.Value AS VARCHAR(32)) END)
			WHEN P.Value = -1 THEN 'Maximum'
			ELSE CAST (P.Value AS VARCHAR(32))
		END,
		CASE WHEN S.Property IN ('LibraryEnabled', 'PreventPhysicalInventory', 'PeriodicMailSlotCheck', 'PreventAutoImport', 'RemoveMediaFromMailSlot')
				THEN (CASE S.Value WHEN 0 THEN 'No' ELSE 'Yes' END)
			WHEN S.Property = 'MaxSwitchForHost'
				THEN (CASE S.Value WHEN -1 THEN 'Maximum Allowed Writers' ELSE 'Allocate number of Writers: ' + CAST(S.Value AS VARCHAR(32)) END)
			WHEN S.Value = -1 THEN 'Maximum'
			ELSE CAST (S.Value AS VARCHAR(32))
		END
FROM	LibraryProperty P
		INNER JOIN
		(
			SELECT	Property, Value
			FROM	LibraryProperty
			WHERE	CommServId = @i_stdCommServUniqueID AND LibraryId = @i_stdLibraryID
		) S
		ON P.Property = S.Property AND P.Value <> S.Value
IF	@i_PropertyGroupId IN (0, 3)
BEGIN
	INSERT	INTO #LibraryProperty
	SELECT	CommServId, LibraryId, 0, 3, 'Default Media Type', DefaultMediaTypeName, @stdDefMediaTypeName
	FROM	#LibraryProp
	WHERE	(CommServId <> @i_stdCommServUniqueID OR LibraryId <> @i_stdLibraryID)
		AND DefaultMediaTypeName <> @stdDefMediaTypeName
	INSERT	INTO #LibraryProperty
	SELECT	CommServId, LibraryId, 0, 3, 'Virtual Mail Slot For Export', VirtualMailSlotForExport, @stdVMSForExport
	FROM	#LibraryProp
	WHERE	(CommServId <> @i_stdCommServUniqueID OR LibraryId <> @i_stdLibraryID)
		AND VirtualMailSlotForExport <> @stdVMSForExport
END
INSERT	INTO #LibraryProperty
SELECT	P.CommServId, P.LibraryId, 0, F.propertyGroup, F.name,
		CASE WHEN (P.LibraryAttribute & F.attribute) = 0 THEN 'No' ELSE 'Yes' END,
		CASE WHEN (@stdLibAttributes & F.attribute) = 0 THEN 'No' ELSE 'Yes' END
FROM	(SELECT CommServId, LibraryId, LibraryAttribute FROM #LibraryProp WHERE LibraryAttribute <> @stdLibAttributes) P
		CROSS JOIN @TblLibraryAttribute F
WHERE	(P.LibraryAttribute & F.attribute) <> (@stdLibAttributes & F.attribute)
INSERT	INTO #LibraryProperty
SELECT	P.CommServId, P.LibraryId, 0, F.propertyGroup, F.name,
		CASE WHEN (P.ExtendedAttributes & F.attribute) = 0 THEN 'No' ELSE 'Yes' END,
		CASE WHEN (@stdLibExtAttributes & F.attribute) = 0 THEN 'No' ELSE 'Yes' END
FROM	(SELECT CommServId, LibraryId, ExtendedAttributes FROM #LibraryProp WHERE ExtendedAttributes <> @stdLibExtAttributes) P
		CROSS JOIN @TblLibraryExtAttribute F
WHERE	(P.ExtendedAttributes & F.attribute) <> (@stdLibExtAttributes & F.attribute)
IF	@i_PropertyGroupId IN (0, 2)
BEGIN
	INSERT	INTO #LibraryProperty
	SELECT	P.CommServId, P.LibraryId, P.MountPathId, 2, F.name,
			CASE WHEN (P.Attribute & F.attribute) = 0 THEN 'No' ELSE 'Yes' END,
			CASE WHEN (@stdMPAttributes & F.attribute) = 0 THEN 'No' ELSE 'Yes' END
	FROM	(SELECT CommServId, LibraryId, MountPathId, Attribute FROM #MountPathProp WHERE Attribute <> @stdMPAttributes) P
			CROSS JOIN @TblMountPathAttribute F
	WHERE	(P.Attribute & F.attribute) <> (@stdMPAttributes & F.attribute)
	;WITH MountPathProperty (CommServId, LibraryId, MountPathId, Property, Value) AS
	(
		SELECT	P.CommServId, P.LibraryId, P.MountPathId, P.Property, P.Value
		FROM	#MountPathProp
				UNPIVOT (Value FOR Property IN (
						IsEnabled, MaxConcurrentWriters, MaxDataToWriteMB, MagneticSpaceRsrvInMB,
						MagneticChunkFileIncrSizeMB, DeviceEnabled)
				) P
	)
	INSERT	INTO #LibraryProperty
	SELECT	P.CommServId, P.LibraryId, P.MountPathId, 2,
			CASE WHEN P.Property = 'IsEnabled' THEN 'Enable Mount Path'
				WHEN P.Property = 'MaxConcurrentWriters' THEN 'Mount Path Allocation Policy'
				WHEN P.Property = 'MaxDataToWriteMB' THEN 'Space Allocation'
				WHEN P.Property = 'MagneticSpaceRsrvInMB' THEN 'Space Allocation - Reserve Space in MB'
				WHEN P.Property = 'MagneticChunkFileIncrSizeMB' THEN 'Minimize fragmentation by allocating write blocks of N MB'
				WHEN P.Property = 'DeviceEnabled' THEN 'Device Enabled'
			END,
			CASE WHEN P.Property IN ('IsEnabled', 'DeviceEnabled')
					THEN (CASE P.Value WHEN 0 THEN 'No' ELSE 'Yes' END)
				WHEN P.Property = 'MaxConcurrentWriters'
					THEN (CASE P.Value WHEN 0 THEN 'Disable mount path for write' WHEN 1000 THEN 'Maximum Allowed Writers'
								ELSE 'Allocate number of Writers: ' + CAST(P.Value AS VARCHAR(32)) END)
				WHEN P.Property = 'MaxDataToWriteMB'
					THEN (CASE P.Value WHEN -1 THEN 'Use until free space on mount path reaches Reserved Space'
								ELSE 'Do not consume more than ' + CAST(P.Value AS VARCHAR(32)) + ' GB' END)
				WHEN P.Property = 'MagneticChunkFileIncrSizeMB' AND P.Value = 0 THEN 'Not Enabled'
				ELSE CAST (P.Value AS VARCHAR(32))
			END,
			CASE WHEN S.Property IN ('IsEnabled', 'DeviceEnabled')
					THEN (CASE S.Value WHEN 0 THEN 'No' ELSE 'Yes' END)
				WHEN S.Property = 'MaxConcurrentWriters'
					THEN (CASE S.Value WHEN 0 THEN 'Disable mount path for write' WHEN 1000 THEN 'Maximum Allowed Writers'
								ELSE 'Allocate number of Writers: ' + CAST(S.Value AS VARCHAR(32)) END)
				WHEN S.Property = 'MaxDataToWriteMB'
					THEN (CASE S.Value WHEN -1 THEN 'Use until free space on mount path reaches Reserved Space'
								ELSE 'Do not consume more than ' + CAST(S.Value AS VARCHAR(32))  + ' GB'END)
				WHEN S.Property = 'MagneticChunkFileIncrSizeMB' AND S.Value = 0 THEN 'Not Enabled'
				ELSE CAST (S.Value AS VARCHAR(32))
			END
	FROM	MountPathProperty P
			INNER JOIN
			(
				SELECT	Property, Value
				FROM	MountPathProperty
				WHERE	CommServId = @i_stdCommServUniqueID AND MountPathId = @i_stdMountPathID
			) S
			ON P.Property = S.Property AND P.Value <> S.Value
END
IF @stdLibraryTypeId = 3
	DELETE #LibraryProperty WHERE PropertyGroup IN (3,4,5)
ELSE
	DELETE #LibraryProperty WHERE PropertyGroup = 2
IF @bAggregate = 1
BEGIN
	DECLARE	@TblSummary TABLE (CommServId INT, LibCount INT, AllProp INT,
			General INT, MountPath INT, Media INT, Drive INT, Advanced INT)
	INSERT	INTO @TblSummary
	SELECT	P.CommServId, 0, 0, ISNULL([1], 0), ISNULL([2], 0), ISNULL([3], 0), ISNULL([4], 0), ISNULL([5], 0)
	FROM	(SELECT	CommServId, PropertyGroup, COUNT(DISTINCT LibraryId) AS Counts
			FROM	#LibraryProperty
			GROUP BY CommServId, PropertyGroup) AS S
			PIVOT (MAX(Counts) FOR S.PropertyGroup IN ([1], [2], [3], [4], [5])) AS P
	UPDATE	@TblSummary
	SET		LibCount = C.Count
	FROM	@TblSummary T
			INNER JOIN @TblLibraryCount C ON T.CommServId = C.CommServId
	UPDATE	@TblSummary
	SET		AllProp = S.Counts
	FROM	@TblSummary T
			INNER JOIN
			(SELECT	CommServId, COUNT(DISTINCT LibraryId) AS Counts
			FROM	#LibraryProperty
			GROUP BY CommServId) AS S
			ON T.CommServId = S.CommServId
	IF	NOT EXISTS (SELECT * FROM @TblSummary)
	INSERT	INTO @TblSummary
	SELECT	CommServId, Count, 0, 0,
			CASE WHEN @i_stdMountPathID > 0 THEN 0 ELSE -1 END,
			CASE WHEN @i_stdMountPathID = 0 THEN 0 ELSE -1 END,
			CASE WHEN @i_stdMountPathID = 0 THEN 0 ELSE -1 END,
			CASE WHEN @i_stdMountPathID = 0 THEN 0 ELSE -1 END
	FROM	@TblLibraryCount
	SELECT	'All CommCells' AS 'CommCell',
			'' AS 'CommServ UniqueId',
			'' AS 'CommCell ID',
			D.LibCount		AS 'All Libraries',
			(SELECT COUNT(*) FROM @TblPassedLibrary) AS 'Passed Audit',
			D.General		AS 'General',
			CASE WHEN @i_stdMountPathID > 0 THEN D.MountPath ELSE -1 END AS 'Mount Path',
			CASE WHEN @i_stdMountPathID = 0 THEN D.Media     ELSE -1 END AS 'Media',
			CASE WHEN @i_stdMountPathID = 0 THEN D.Drive     ELSE -1 END AS 'Drive',
			CASE WHEN @i_stdMountPathID = 0 THEN D.Advanced  ELSE -1 END AS 'Advanced',
			D.AllProp		AS 'Any',
			'' AS 'Collection Time (Time Zone)',
			-1				AS 'FirstOrder<DONOTSHOW>'
	FROM	(SELECT SUM(LibCount) AS LibCount, SUM(AllProp) AS AllProp, SUM(General) AS General,
					SUM(MountPath) AS MountPath, SUM(Media) AS Media, SUM(Drive) AS Drive, SUM(Advanced) AS Advanced
			FROM	@TblSummary) D
	UNION ALL
	SELECT	CASE
				WHEN @isPrivate = 1 THEN CS.CommServName
				ELSE CS.CustomerName + ' - ' + CS.CommServName
			END AS 'CommCell',
			CS.ID			AS 'CommServ UniqueId',
			CS.CommCellID	AS 'CommCell ID',
			D.LibCount		AS 'All Libraries',
			(SELECT COUNT(*) FROM @TblPassedLibrary WHERE CommServId = D.CommServId) AS 'Passed Audit',
			D.General		AS 'General',
			CASE WHEN @i_stdMountPathID > 0 THEN D.MountPath ELSE -1 END AS 'Mount Path',
			CASE WHEN @i_stdMountPathID = 0 THEN D.Media     ELSE -1 END AS 'Media',
			CASE WHEN @i_stdMountPathID = 0 THEN D.Drive     ELSE -1 END AS 'Drive',
			CASE WHEN @i_stdMountPathID = 0 THEN D.Advanced  ELSE -1 END AS 'Advanced',
			D.AllProp		AS 'Any',
			CONVERT(VARCHAR(20), LR.LogDate, 100) + ' (' + CS.CommServTZ + ')' AS 'Collection Time (Time Zone)',
			0				AS 'FirstOrder<DONOTSHOW>'
	FROM	@TblSummary D
			INNER JOIN cf_CommcellIdNameMap CS ON D.CommServId = CS.ID
			INNER JOIN #LatestResult LR ON D.CommServId = LR.CommServId
	ORDER BY 'FirstOrder<DONOTSHOW>', 'CommCell'
END
ELSE
BEGIN
	IF	@i_PropertyGroupId <> 0
		DELETE #LibraryProperty WHERE PropertyGroup <> @i_PropertyGroupId
	IF EXISTS (SELECT * FROM #LibraryProperty WHERE MountPathId > 0)
	BEGIN
		IF @i_CommServUniqueID = 0
			SELECT	CASE
						WHEN @isPrivate = 1 THEN CS.CommServName
						ELSE CS.CustomerName + ' - ' + CS.CommServName
					END AS 'CommCell',
					S.LibraryName	AS 'Library',
					ISNULL(M.MountPathName, 'N/A') AS 'Mount Path',
					P.Property		AS 'Property',
					P.Value			AS 'Value',
					P.stdValue		AS 'Template Value'
			FROM	#LibraryProperty P
					INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
					INNER JOIN #LibraryProp S ON P.CommServId = S.CommServId AND P.LibraryId = S.LibraryId
					LEFT OUTER JOIN #MountPathProp M ON P.CommServId = M.CommServId AND P.MountPathId = M.MountPathId
			ORDER BY CS.CommServName, S.LibraryName, 'Mount Path', P.PropertyGroup, P.Property
		ELSE
			SELECT	S.LibraryName AS 'Library',
					ISNULL(M.MountPathName, 'N/A') AS 'Mount Path',
					P.Property		AS 'Property',
					P.Value			AS 'Value',
					P.stdValue		AS 'Template Value'
			FROM	#LibraryProperty P
					INNER JOIN #LibraryProp S ON P.CommServId = S.CommServId AND P.LibraryId = S.LibraryId
					LEFT OUTER JOIN #MountPathProp M ON P.CommServId = M.CommServId AND P.MountPathId = M.MountPathId
			ORDER BY S.LibraryName, 'Mount Path', P.PropertyGroup, P.Property
	END
	ELSE
	IF @i_CommServUniqueID = 0
		SELECT	CASE
					WHEN @isPrivate = 1 THEN CS.CommServName
					ELSE CS.CustomerName + ' - ' + CS.CommServName
				END AS 'CommCell',
				S.LibraryName	AS 'Library',
				P.Property		AS 'Property',
				P.Value			AS 'Value',
				P.stdValue		AS 'Template Value'
		FROM	#LibraryProperty P
				INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
				INNER JOIN #LibraryProp S ON P.CommServId = S.CommServId AND P.LibraryId = S.LibraryId
		ORDER BY CS.CommServName, S.LibraryName, P.PropertyGroup, P.Property
	ELSE
		SELECT	S.LibraryName AS 'Library',
				P.Property		AS 'Property',
				P.Value			AS 'Value',
				P.stdValue		AS 'Template Value'
		FROM	#LibraryProperty P
				INNER JOIN #LibraryProp S ON P.CommServId = S.CommServId AND P.LibraryId = S.LibraryId
		ORDER BY S.LibraryName, P.PropertyGroup, P.Property
END
DROP TABLE #LatestResult
DROP TABLE #LibraryProperty
DROP TABLE #LibraryProp
DROP TABLE #MountPathProp
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptLibraryAudit')
	delete from GxQscripts where name = 'RptLibraryAudit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLibraryAudit')
	delete from GXDBVersions where aliasname = 'RptLibraryAudit'
GO

insert into GXDBVersions values(2, 'RptLibraryAudit',  '00010007000200050000', 'RptLibraryAudit', '00010007000200050000')
GO

