

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptLiveSyncVMDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptLiveSyncVMDetails.sp,v $ $Id: RptLiveSyncVMDetails.sp,v 1.1.2.7 2019/09/26 06:26:47 samrutkar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptLiveSyncVMDetails')
BEGIN
	print '>>> Drop Stored Procedure: RptLiveSyncVMDetails <<<'
	drop procedure RptLiveSyncVMDetails
END
IF EXISTS (select * from GxQscripts where name='RptLiveSyncVMDetails')
	delete from GxQscripts where name = 'RptLiveSyncVMDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLiveSyncVMDetails')
	delete from GXDBVersions where aliasname = 'RptLiveSyncVMDetails'
GO
print '... Creating Procedure: RptLiveSyncVMDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptLiveSyncVMDetails
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
DECLARE @i_QueryId BIGINT = 181
DECLARE @strGood VARCHAR(10) = '1_Good'
DECLARE @strInfo VARCHAR(10) = '2_Info'
DECLARE @strwarning VARCHAR(10) = '3_Warning'
DECLARE @strCritical VARCHAR(10) = '4_Critical'
SET @blLatestSurvey = 1
SELECT 	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.DisplayName AS 'CommCell Name',
	vmInfo.SourceVMClientName AS 'Source VM Name',
	vmInfo.DestVMClientName  AS 'Destination VM Name',
    CASE
        WHEN vmInfo.LastRestoreTime = 0 THEN  -50
        ELSE vmInfo.LastRestoreTime
    END AS 'Last Sync Time<MMMDDYYYYHrMinAM>',
	vmInfo.TaskName AS 'Schedule Name',
    CASE
        WHEN vmInfo.Status = 0 THEN 'Never has been synced'
        WHEN vmInfo.Status = 1 THEN 'In Sync'
        WHEN vmInfo.Status = 2 THEN 'Needs Sync'
        WHEN vmInfo.Status = 3 THEN 'Sync In Progress'
        WHEN vmInfo.Status = 4 THEN 'Sync Paused'
        WHEN vmInfo.Status = 5 THEN 'Sync Failed'
        WHEN vmInfo.Status = 6 THEN 'Sync Disabled'
        WHEN vmInfo.Status = 7 THEN 'Sync Enabled'
        WHEN vmInfo.Status = 8 THEN 'Validation Failed'
        WHEN vmInfo.Status = 9 THEN 'Sync Queued'
        ELSE 'Unknown'
    END AS 'Sync Status',
    CASE
        WHEN vmInfo.Status = 6 THEN @strWarning
		WHEN (vmInfo.Status = 5 OR DATEDIFF(d, dbo.GetDateTime(vmInfo.LastRestoreTime), SYSDATETIME()) > 7) THEN  @strCritical
        ELSE @strGood
    END AS 'Status<HEALTH_STATUS>'
FROM cf_SurveyLiveSyncVMDetails AS vmInfo WITH (NOLOCK)
INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) resultView
ON vmInfo.SurveyResultId = resultView.SurverResultId
ORDER BY 'Status<HEALTH_STATUS>' DESC
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0
  DECLARE @blLatestSurvey INT			= 1
  DECLARE @i_CommServUniqueID INT		= 11065
  DECLARE @i_LogDateEND DATETIME		= 	NULL    -- getDate()
  DECLARE @i_LogDateStart DATETIME		= NULL   --DateAdd(Month, -36, @i_LogDateEND)
exec RptLiveSyncVMDetails @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND
*/

IF EXISTS (select * from GxQscripts where name = 'RptLiveSyncVMDetails')
	delete from GxQscripts where name = 'RptLiveSyncVMDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLiveSyncVMDetails')
	delete from GXDBVersions where aliasname = 'RptLiveSyncVMDetails'
GO

insert into GXDBVersions values(2, 'RptLiveSyncVMDetails',  '00010001000200070000', 'RptLiveSyncVMDetails', '00010001000200070000')
GO

