

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptLongRunningFullJobs.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptLongRunningFullJobs.sp,v $ $Id: RptLongRunningFullJobs.sp,v 1.10.56.3 2018/08/16 11:32:56 skatz Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptLongRunningFullJobs <<<'

IF EXISTS (select * from sysobjects where name='RptLongRunningFullJobs')
	drop procedure RptLongRunningFullJobs
IF EXISTS (select * from GxQscripts where name='RptLongRunningFullJobs')
	delete from GxQscripts where name = 'RptLongRunningFullJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLongRunningFullJobs')
	delete from GXDBVersions where aliasname = 'RptLongRunningFullJobs'
GO
print '... Creating Procedure: RptLongRunningFullJobs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptLongRunningFullJobs
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 24
IF @i_CommServUniqueID = 0
BEGIN
SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	resultView.DisplayName AS 'CommCell Name',
	ISNULL(CL.clientDisplayName, csInfo.clientName) AS 'Client',
	csInfo.AgentName AS 'Agent<HIDDEN>',
	csInfo.BackupType AS 'Backup Type<HIDDEN>',
	csInfo.JobId AS 'Job Id<HIDDEN>',
	CAST(csInfo.DurationHr*60 AS INT) AS 'Duration (hh:mm)<HHMM>',
	CAST(csInfo.ActualBKPDurationHr*60 AS INT) AS 'Transfer Time (hh:mm)<HHMM>',
	CAST((csInfo.ApplicationSize/1024.00/1024.00) AS DECIMAL(32,2)) AS 'Application Size<SIZEMB>',
	csInfo.Status AS 'Job Status<HIDDEN>',
	CASE WHEN csInfo.IsDeDupEnabled = 1 AND csInfo.IsSourceDeDupEnabled = 1 THEN 'Yes' ELSE 'No' END AS 'Client Side Deduplication<HIDDEN>',
	CASE csInfo.IsDASHEnabled WHEN 1 THEN 'Yes' ELSE 'No' END AS 'DASH Full Enabled<HIDDEN>',
	CASE csInfo.IsSPEnabled WHEN 1 THEN 'Yes' ELSE 'No' END AS 'IntelliSnap Enabled'
FROM cf_SurveyLongRunningFullJobs AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId AND csInfo.JobId <> 0
		LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = csInfo.CommServUniqueId AND CL.ClientId = csInfo.ClientId
ORDER BY   csInfo.ActualBKPDurationHr DESC,'CommCell Name' ASC
END
ELSE
SELECT
	csInfo.CommServUniqueId AS 'CommServ UniqueId',
	ISNULL(CL.clientDisplayName, csInfo.clientName) AS 'Client',
	csInfo.AgentName AS 'Agent<HIDDEN>',
	csInfo.BackupType AS 'Backup Type<HIDDEN>',
	csInfo.JobId AS 'Job Id<HIDDEN>',
	CAST(csInfo.DurationHr*60 AS INT) AS 'Duration (hh:mm)<HHMM>',
	CAST(csInfo.ActualBKPDurationHr*60 AS INT) AS 'Transfer Time (hh:mm)<HHMM>',
	CAST((csInfo.ApplicationSize/1024.00/1024.00) AS DECIMAL(32,2)) AS 'Application Size<SIZEMB>',
	csInfo.Status AS 'Job Status<HIDDEN>',
	CASE WHEN csInfo.IsDeDupEnabled = 1 AND csInfo.IsSourceDeDupEnabled = 1 THEN 'Yes' ELSE 'No' END AS 'Client Side Deduplication<HIDDEN>',
	CASE csInfo.IsDASHEnabled WHEN 1 THEN 'Yes' ELSE 'No' END AS 'DASH Full Enabled<HIDDEN>',
	CASE csInfo.IsSPEnabled WHEN 1 THEN 'Yes' ELSE 'No' END AS 'IntelliSnap Enabled'
FROM cf_SurveyLongRunningFullJobs AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId		AND csInfo.JobId <> 0
		LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = csInfo.CommServUniqueId AND CL.ClientId = csInfo.ClientId
ORDER BY csInfo.ActualBKPDurationHr DESC
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0
  DECLARE @blLatestSurvey INT			= 1
  DECLARE @i_CommServUniqueID INT		= 11065
  DECLARE @i_LogDateEND DATETIME		= 	NULL    -- getDate()
  DECLARE @i_LogDateStart DATETIME		= NULL   --DateAdd(Month, -36, @i_LogDateEND)
exec RptLongRunningFullJobs @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND
*/

IF EXISTS (select * from GxQscripts where name = 'RptLongRunningFullJobs')
	delete from GxQscripts where name = 'RptLongRunningFullJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLongRunningFullJobs')
	delete from GXDBVersions where aliasname = 'RptLongRunningFullJobs'
GO

insert into GXDBVersions values(2, 'RptLongRunningFullJobs',  '00010010005600030000', 'RptLongRunningFullJobs', '00010010005600030000')
GO

