

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptMailboxQuotaUsage.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptMailboxQuotaUsage.sp,v $ $Id: RptMailboxQuotaUsage.sp,v 1.6 2014/07/28 21:50:50 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptMailboxQuotaUsage <<<'

IF EXISTS (select * from sysobjects where name='RptMailboxQuotaUsage')
	drop procedure RptMailboxQuotaUsage
IF EXISTS (select * from GxQscripts where name='RptMailboxQuotaUsage')
	delete from GxQscripts where name = 'RptMailboxQuotaUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptMailboxQuotaUsage')
	delete from GXDBVersions where aliasname = 'RptMailboxQuotaUsage'
GO
print '... Creating Procedure: RptMailboxQuotaUsage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptMailboxQuotaUsage
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_Aggregate INT = 0,
  @i_CommCellID INT = 0
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 134
DECLARE @IsPrivate INT = 0
SELECT	@IsPrivate = ISNULL(CAST(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
IF @IsPrivate = 0
	RETURN
CREATE	TABLE #OrderedQuotaUsage (
		UserGUID			VARCHAR(64),
		UserName			NVARCHAR(MAX),
		QuotaEnabled		INT,
		QuotaSizeMB			BIGINT,
		SpaceConsumed		BIGINT,
		GlobalSpaceConsumed	BIGINT,
		LastUpdateTime		DATETIME,
		CommCellID			INT,
		OrderId				INT)
INSERT	INTO #OrderedQuotaUsage
SELECT	UserGUID, UserName, QuotaEnabled, QuotaSizeMB, SpaceConsumed, GlobalSpaceConsumed, LastUpdateTime, CommCellID,
		ROW_NUMBER() OVER (PARTITION BY UserGUID ORDER BY LastUpdateTime DESC)
FROM	cf_SurveyMailboxQuotaUsage AS S WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, 0, 1, NULL, NULL, @i_UserId,@i_GroupId) R ON S.SurveyResultId = R.SurverResultId
IF @i_CommCellID > 0 -- Web Server API
BEGIN
	;WITH DuplicatedUser (UserGUID, GlobalSpaceConsumed) AS
	(
		SELECT	UserGUID, SUM(SpaceConsumed)
		FROM	#OrderedQuotaUsage U
		GROUP BY UserGUID
		HAVING MAX(QuotaEnabled) > 0 AND COUNT(*) > 1
	)
	SELECT	U.UserGUID, T.QuotaSizeMB, T.GlobalSpaceConsumed, T.LastUpdateTime
	FROM	#OrderedQuotaUsage U
			INNER JOIN (
			SELECT	Q.UserGUID, Q.QuotaSizeMB, D.GlobalSpaceConsumed, Q.LastUpdateTime
			FROM	#OrderedQuotaUsage Q INNER JOIN DuplicatedUser D ON Q.UserGUID = D.UserGUID AND Q.OrderId = 1
			) T ON U.UserGUID = T.UserGUID
	WHERE	U.CommCellId = @i_CommCellID
		AND (U.QuotaSizeMB <> T.QuotaSizeMB OR U.GlobalSpaceConsumed <> T.GlobalSpaceConsumed OR U.LastUpdateTime <> T.LastUpdateTime)
END
ELSE
IF	@i_Aggregate = 1 -- Usage Distribution chart
BEGIN
	DECLARE @RangeTbl TABLE (RangeBegin INT, RangeEnd INT, Bucket VARCHAR(8))
	INSERT INTO @RangeTbl
	SELECT 0, 10, '0-10' UNION SELECT 10, 20, '10-20' UNION SELECT 20, 30, '20-30' UNION SELECT 30, 40, '30-40'
	UNION SELECT 40, 50, '40-50' UNION SELECT 50, 60, '50-60' UNION SELECT 60, 70, '60-70' UNION SELECT 70, 80, '70-80'
	UNION SELECT 80, 90, '80-90' UNION SELECT 90, 100, '90-100' UNION SELECT 100, 0x7FFFFFFF, '>100'
	;WITH QuotaUsagePct (UserGUID, UsagePct) AS
	(
		SELECT	UserGUID, SUM(SpaceConsumed)/10.24/1024/SUM(CASE WHEN OrderId = 1 THEN QuotaSizeMB ELSE 0 END)
		FROM	#OrderedQuotaUsage
		GROUP BY UserGUID
		HAVING	MAX(QuotaEnabled) > 0 AND SUM(CASE WHEN OrderId = 1 THEN QuotaSizeMB ELSE 0 END) > 0
	)
	SELECT	Bucket AS 'Quota Used (%)',
			ISNULL(Counts, 0) AS 'Number of Users'
	FROM	@RangeTbl R
			LEFT OUTER JOIN (
			SELECT	RangeBegin, COUNT(*) AS Counts
			FROM	QuotaUsagePct INNER JOIN @RangeTbl ON UsagePct >= RangeBegin AND UsagePct < RangeEnd
			GROUP BY RangeBegin
			) T ON R.RangeBegin = T.RangeBegin
	ORDER BY R.RangeBegin
END
ELSE -- Top 100 users and all users with UsagePct >= 100
BEGIN
	;WITH QuotaUsagePct (UserGUID, SpaceConsumed, UsagePct) AS
	(
		SELECT	UserGUID,
				SUM(SpaceConsumed), SUM(SpaceConsumed)/10.24/1024/SUM(CASE WHEN OrderId = 1 THEN QuotaSizeMB ELSE 0 END)
		FROM	#OrderedQuotaUsage
		GROUP BY UserGUID
		HAVING	MAX(QuotaEnabled) > 0 AND SUM(CASE WHEN OrderId = 1 THEN QuotaSizeMB ELSE 0 END) > 0
			AND SUM(SpaceConsumed)/1024.0/1024 >= SUM(CASE WHEN OrderId = 1 THEN QuotaSizeMB ELSE 0 END)
		UNION
		SELECT	TOP 100 UserGUID,
				SUM(SpaceConsumed), SUM(SpaceConsumed)/10.24/1024/SUM(CASE WHEN OrderId = 1 THEN QuotaSizeMB ELSE 0 END)
		FROM	#OrderedQuotaUsage
		GROUP BY UserGUID
		HAVING	MAX(QuotaEnabled) > 0 AND SUM(CASE WHEN OrderId = 1 THEN QuotaSizeMB ELSE 0 END) > 0
		ORDER BY SUM(SpaceConsumed)/SUM(CASE WHEN OrderId = 1 THEN QuotaSizeMB ELSE 0 END) DESC
	)
	SELECT 	U.UserName AS 'User Name',
			U.QuotaSizeMB AS 'Quota Size<SIZEMB>',
			CAST(1.0*P.SpaceConsumed/1024/1024 AS DECIMAL(20,2)) AS 'Space Consumed<SIZEMB>',
			CAST(P.UsagePct AS DECIMAL(20,2)) AS 'Quota Used (%)',
			DATEDIFF(S, '1970-01-01', U.LastUpdateTime) AS 'Last Backup Time<DATETIME>'
	FROM	#OrderedQuotaUsage U
			INNER JOIN QuotaUsagePct P ON U.UserGUID = P.UserGUID AND U.OrderId = 1
	ORDER BY P.UsagePct DESC
END
DROP TABLE #OrderedQuotaUsage
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptMailboxQuotaUsage')
	delete from GxQscripts where name = 'RptMailboxQuotaUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptMailboxQuotaUsage')
	delete from GXDBVersions where aliasname = 'RptMailboxQuotaUsage'
GO

insert into GXDBVersions values(2, 'RptMailboxQuotaUsage',  '00010006000000000000', 'RptMailboxQuotaUsage', '00010006000000000000')
GO

