

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptMonthlyPptData.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptMonthlyPptData.sp,v $ $Id: RptMonthlyPptData.sp,v 1.3.12.16 2020/03/31 19:15:34 nbirru Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptMonthlyPptData')
BEGIN
	print '>>> Drop Stored Procedure: RptMonthlyPptData <<<'
	drop procedure RptMonthlyPptData
END
IF EXISTS (select * from GxQscripts where name='RptMonthlyPptData')
	delete from GxQscripts where name = 'RptMonthlyPptData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptMonthlyPptData')
	delete from GXDBVersions where aliasname = 'RptMonthlyPptData'
GO
print '... Creating Procedure: RptMonthlyPptData'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptMonthlyPptData
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NULL,
  @i_param INT = NULL,
  @lastNMonths INT = 12,
  @groupName NVARCHAR(512) = NULL,
  @groupIdList NVARCHAR(MAX) = NULL
AS
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
DECLARE @queryId INT = 152
DECLARE @ThisMonth  DATE = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()),0)
DECLARE @STARTDATE  DATE = DATEADD(MONTH, -1, @ThisMonth)
DECLARE @ENDDATE    DATE = DATEADD(MONTH, 1, @STARTDATE)
DECLARE @query NVARCHAR(MAX)
DECLARE @cols AS NVARCHAR(MAX)
IF OBJECT_ID('tempdb.dbo.#CommCells') IS NOT NULL DROP TABLE #CommCells
CREATE TABLE #CommCells (CommServUniqueId INT)
IF OBJECT_ID('tempdb.dbo.#CCGrpAssoc') IS NOT NULL DROP TABLE #CCGrpAssoc
CREATE TABLE #CCGrpAssoc (Id INT, Name NVARCHAR(512), CommServUniqueId INT)
IF OBJECT_ID('tempdb.dbo.#LastNMonths') IS NOT NULL DROP TABLE #LastNMonths
DECLARE @inputGroups TABLE (groupId INT)
--INSERT INTO @inputGroups SELECT CAST(Data AS INT) FROM dbo.Split(@groupIdList, ',')
WHILE (CHARINDEX(' ',@groupIdList)>0)
BEGIN
	INSERT INTO @inputGroups (groupId)
	SELECT LTRIM(RTRIM(SUBSTRING(@groupIdList,1,CHARINDEX(' ',@groupIdList)-1)))
	SET @groupIdList = SUBSTRING(@groupIdList,CHARINDEX(' ',@groupIdList)+1,LEN(@groupIdList))
END
IF(@groupIdList IS NOT NULL AND LEN(@groupIdList) > 0)
	INSERT INTO @inputGroups (groupId)
	SELECT LTRIM(RTRIM(@groupIdList))
IF @i_param IN (1,4,5,6,7,8,9) -- Job stats cf_SurveyJobStats
	SET @queryId = 177
ELSE IF @i_param = 2 -- Bacjup Retention cf_SurveyCopyBasicRetention
	SET @queryId = 178
ELSE IF @i_param = 3 -- Restore Summary cf_SurveyRestoreJobStats
	SET @queryId = 176
IF ISNULL(@groupName,'') <> ''
	SELECT @i_GroupId = id FROM cf_CommCellGroup WHERE name = @groupName
IF ISNULL(@i_GroupId,-1) > 0
	SELECT @groupName = name FROM cf_CommCellGroup WHERE id = @i_GroupId
INSERT INTO #CCGrpAssoc
SELECT CG.GroupId AS Id, CG.GroupName AS Name, GA.commcellIdNameMap_ID AS CommServUniqueId
FROM RptGetCommCellGroups(@i_UserId) CG
	INNER JOIN cf_CommCellGroupAssoc GA WITH (NOLOCK)
		ON GA.CommCellGroupId = CG.GroupId
IF EXISTS (SELECT * FROM @inputGroups WHERE groupId IS NOT NULL)
BEGIN
	DELETE #CCGrpAssoc
	FROM #CCGrpAssoc CG LEFT OUTER JOIN @inputGroups IG ON CG.Id = IG.groupId
	WHERE IG.GroupId IS NULL
END
IF @i_GroupId > 0
	DELETE FROM #CCGrpAssoc WHERE id NOT IN (@i_GroupId)
IF @i_param = 1 -- We need only past 3 months data
	SET @lastNMonths = 3
;WITH MONTHS(Cnt, STARTDATE , ENDDATE ) AS
(
	SELECT 1,@STARTDATE, @ENDDATE
	UNION ALL
	SELECT Cnt+1,DATEADD(MONTH, -1, STARTDATE),STARTDATE
	FROM MONTHS WHERE Cnt < @lastNMonths
)
SELECT *
INTO #LastNMonths
FROM MONTHS
IF @i_param IN (1, 7, 8, 9)
BEGIN
	DECLARE @tblErrorExceptions TABLE (ErrorCode NVARCHAR(20))
	DECLARE @ErrorExceptions NVARCHAR(MAX) = (SELECT ISNULL(value, '') FROM cf_SurveyConfig WHERE name = 'ExecSummary_ErrorCodeExceptions')
	WHILE (CHARINDEX(',',@ErrorExceptions)>0)
	BEGIN
		INSERT INTO @tblErrorExceptions (ErrorCode)
		SELECT LTRIM(RTRIM(SUBSTRING(@ErrorExceptions,1,CHARINDEX(',',@ErrorExceptions)-1)))
		SET @ErrorExceptions = SUBSTRING(@ErrorExceptions,CHARINDEX(',',@ErrorExceptions)+1,LEN(@ErrorExceptions))
	END
	IF(@ErrorExceptions IS NOT NULL AND LEN(@ErrorExceptions) > 0)
		INSERT INTO @tblErrorExceptions (ErrorCode)
		SELECT LTRIM(RTRIM(@ErrorExceptions))
END
IF @i_GroupId <= 0 AND @i_CommServUniqueID > 0
BEGIN
	INSERT INTO #CommCells SELECT @i_CommServUniqueID
END
ELSE
BEGIN
	INSERT INTO #CommCells SELECT DISTINCT CommServUniqueId FROM #CCGrpAssoc
END
IF @i_param = -1 -- Returns list of past N mopnths name
BEGIN
	SELECT DATENAME(MONTH,STARTDATE) AS Months FROM #LastNMonths ORDER BY STARTDATE
END
ELSE IF @i_param = 0	-- Returns Commcell Group names for which data needs to be populated
BEGIN
	SELECT DISTINCT Id AS 'GroupId', Name AS 'CommcellGroups' FROM #CCGrpAssoc
END
ELSE IF @i_param = 1 -- Retuns information that needs to be filled on slide 1 (all non-chart data, free floater values)
BEGIN
	DECLARE @NoOfRstJobs INT, @RstDataForLastMonthMB DECIMAL(20,2)
	DECLARE @lastMonth INT = 1,
			@last2lastMonth INT = 2
	DECLARE @JobDetails TABLE (MonthNo INT, NoOfDays INT, MonthStartDate DATE, Total BIGINT, Success BIGINT, ApplicationSizeMB BIGINT)
	INSERT INTO @JobDetails (MonthNo, MonthStartDate, Total, Success, ApplicationSizeMB)
	SELECT M.Cnt,
		   M.STARTDATE,
		   ISNULL(SUM(ISNULL(TotalJobs,0) - ISNULL(KilledJobs, 0) - ISNULL(SkippedJobs, 0)), 0) AS Total, ISNULL(SUM(ISNULL(CompletedJobs,0)), 0) + ISNULL(SUM(ISNULL(CWWJobs,0)), 0) + ISNULL(SUM(ISNULL(CWEJobs,0)), 0) AS Success,
		   ISNULL(SUM(ISNULL(BackupSize,0))/1024.0/1024.0, 0) AS ApplicationSizeMB
	FROM cf_SurveyIDAMonthlyBkpJobStats IDA WITH (NOLOCK)
		INNER JOIN #CommCells CC
			ON IDA.CommServUniqueId = CC.CommServUniqueId
		RIGHT JOIN #LastNMonths M
			ON IDA.MonthStart = M.STARTDATE
	GROUP BY M.Cnt,M.STARTDATE
	UPDATE @JobDetails SET NoOfDays = DATEDIFF(D,MonthStartDate,DATEADD(M,1,MonthStartDate))
	SELECT @NoOfRstJobs = SUM(JobCount), @RstDataForLastMonthMB = SUM(RstSizeMB)
	FROM cf_SurveyMonthlyRstJobStats Rst WITH (NOLOCK)
		INNER JOIN #CommCells CC
			ON Rst.CommServUniqueId = CC.CommServUniqueId
	WHERE Rst.MonthStart = @STARTDATE
	DECLARE @totalRstJobs BIGINT, @totalRstSizeMB DECIMAL(20,2)
	SELECT @totalRstJobs = SUM(JobCount), @totalRstSizeMB = SUM(RstSizeMB)
	FROM cf_SurveyMonthlyRstJobStats Rst WITH (NOLOCK)
		INNER JOIN #CommCells CC
			ON Rst.CommServUniqueId = CC.CommServUniqueId
	WHERE Rst.MonthStart >= DATEADD(YEAR,-1,@ENDDATE) AND Rst.MonthStart <= @STARTDATE
	DECLARE @TotalErrors BIGINT, @Top5Errors BIGINT
	SELECT @TotalErrors = SUM(numberOfJobsAffected)
	FROM cf_surveyMonthlyErrorSummary E WITH (NOLOCK)
			INNER JOIN #CommCells CC
				ON CC.CommServUniqueId = E.CommServUniqueId
	WHERE E.MonthStart = @STARTDATE AND ErrorCode NOT IN (SELECT ErrorCode FROM @tblErrorExceptions)
	SELECT @Top5Errors = SUM(Freq)
	FROM
	(SELECT TOP 5 ErrorCode , SUM(numberOfJobsAffected) AS Freq
	FROM cf_surveyMonthlyErrorSummary E WITH (NOLOCK)
			INNER JOIN #CommCells CC
				ON CC.CommServUniqueId = E.CommServUniqueId
	WHERE E.MonthStart = @STARTDATE AND ErrorCode NOT IN (SELECT ErrorCode FROM @tblErrorExceptions)
	GROUP BY ErrorCode
	ORDER BY Freq DESC) R
	DECLARE @StrikeSuccessRate DECIMAL(5,2)
	SET @queryId = 25
	SELECT @StrikeSuccessRate = CASE WHEN SUM(ISNULL(Strike0, 0) + ISNULL(Strike1, 0) + ISNULL(Strike2, 0) + ISNULL(Strike3, 0)) = 0 THEN 0 ELSE CAST(SUM(ISNULL(Strike0, 0))*100.0/(SUM(ISNULL(Strike0, 0) + ISNULL(Strike1, 0) + ISNULL(Strike2, 0) + ISNULL(Strike3, 0))) AS DECIMAL(5,2)) END
	FROM cf_SurveyMonthlyStrikes AS csInfo WITH (NOLOCK)
			INNER JOIN #CommCells CC ON CC.CommServUniqueId = csInfo.CommServUniqueId
            INNER JOIN dbo.cf_SurveyResultFuncV1(@queryId, 0, 1, NULL, NULL,@i_UserId,-1) AS resultView
				ON resultView.CommServUniqueId = csInfo.CommServUniqueId
	WHERE MonthStart = @STARTDATE
	GROUP BY MonthStart
	DECLARE @StrikeSuccessRateTarget DECIMAL(5,2) = (SELECT value FROM cf_SurveyConfig WHERE name = 'ExecSummary_StrikeSuccessRateTarget')
	IF(ISNULL(@StrikeSuccessRateTarget, 0) = 0)
		SELECT @StrikeSuccessRateTarget = WarningThreshold FROM cf_SurveyHealthParam WHERE ParamId = 17 --SLA
	DECLARE @LastMonthDailyBackupAvgMB BIGINT = (SELECT CAST(ApplicationSizeMB/NoOfDays AS DECIMAL(20,2)) FROM @JobDetails WHERE MonthNo = @lastMonth)
	DECLARE @Last2LastMonthDailyBackupAvgMB BIGINT = (SELECT CAST(ApplicationSizeMB/NoOfDays AS DECIMAL(20,2)) FROM @JobDetails WHERE MonthNo = @last2lastMonth)
	DECLARE @DailyAvgDiff BIGINT = ABS(@LastMonthDailyBackupAvgMB - @Last2LastMonthDailyBackupAvgMB)
	DECLARE @DailyDiffVerb NVARCHAR(20) = CASE WHEN  @LastMonthDailyBackupAvgMB >= @Last2LastMonthDailyBackupAvgMB THEN 'increased' ELSE 'decreased' END
	DECLARE @LastMonthBackupMB BIGINT = (SELECT ApplicationSizeMB FROM @JobDetails WHERE MonthNo = @lastMonth)
	DECLARE @Last2LastMonthBackupMB BIGINT = (SELECT ApplicationSizeMB FROM @JobDetails WHERE MonthNo = @last2lastMonth)
	DECLARE @DiffMonthlyBackupMB BIGINT = ABS(@LastMonthBackupMB - @Last2LastMonthBackupMB)
	DECLARE @MonthlyDiffVerb NVARCHAR(20) = CASE WHEN  @LastMonthBackupMB >= @Last2LastMonthBackupMB THEN 'increased' ELSE 'decreased' END
	SELECT (SELECT CASE WHEN total = 0 THEN 0 ELSE CAST(success*100/(total*1.0) AS DECIMAL(20,2)) END  FROM @JobDetails WHERE MonthNo = @lastMonth) 'LastMonthSuccessRate',
		   (SELECT CASE WHEN total = 0 THEN 0 ELSE CAST(success*100/(total*1.0) AS DECIMAL(20,2)) END FROM @JobDetails WHERE MonthNo = @last2lastMonth) AS 'SecondLastMonthSuccessRate',
		   (SELECT DATENAME(MONTH, MonthStartDate) +''''+ SUBSTRING(CONVERT(VARCHAR(11),MonthStartDate,7),9,11) FROM @JobDetails WHERE MonthNo = @lastMonth) AS 'LastMonthName',
		   (SELECT DATENAME(MONTH, MonthStartDate) +''''+ SUBSTRING(CONVERT(VARCHAR(11),MonthStartDate,7),9,11) FROM @JobDetails WHERE MonthNo = @last2lastMonth) AS 'Last2LastMonthName',
		   dbo.FormatBytes(@LastMonthDailyBackupAvgMB, 'MB') AS 'LastMonthDailyBackupAvgMB',
		   dbo.FormatBytes(@Last2LastMonthDailyBackupAvgMB, 'MB') AS 'Last2LastMonthDailyBackupAvgMB',
		   dbo.FormatBytes(@DailyAvgDiff, 'MB') AS 'DailyAvgDiff',
		   @DailyDiffVerb AS 'DailyDiffVerb',
		   dbo.FormatBytes(@LastMonthBackupMB, 'MB') AS 'LastMonthBackupMB',
		   dbo.FormatBytes(@DiffMonthlyBackupMB, 'MB') AS 'DiffMonthlyBackupMB',
		   @MonthlyDiffVerb AS 'MonthlyDiffVerb',
		   ISNULL(@NoOfRstJobs,0) AS 'NoOfRestoreJobs',
		   dbo.FormatBytes(ISNULL(@RstDataForLastMonthMB,0), 'MB') AS 'LastMonthRstData',
		   ISNULL(@totalRstJobs,0) AS 'TotalRestoreJobs',
		   dbo.FormatBytes(ISNULL(@totalRstSizeMB,0), 'MB') AS 'TotalRestoreSizeMB',
		   DATENAME(MONTH, @STARTDATE) AS 'CurrMonth',
		   CASE WHEN @TotalErrors = 0 THEN '0' ELSE ISNULL(CAST(CAST(ROUND((@Top5Errors*100.0/@TotalErrors),0) AS decimal(20,0)) AS varchar(5))+'%','0') END AS 'PercentageOfErrors',
		   DATENAME(MONTH, getdate())+' '+CAST(YEAR(getdate()) AS VARCHAR(5)) AS 'CurrFullMonthNameAndYear',
		   CASE WHEN ISNULL(@StrikeSuccessRate,0) >= @StrikeSuccessRateTarget THEN 'above' ELSE 'under' END AS 'SuccessTargetCompare',
		   CAST(@StrikeSuccessRateTarget AS NVARCHAR(20)) + '%' AS 'StrikeSuccessRateTarget'
END
ELSE IF @i_param = 2 -- Long and short term retention chart data
BEGIN
	SELECT
			SUBSTRING(CONVERT(VARCHAR(11),STARTDATE,106),4,11) AS MonthStartDate,
			SUM(ISNULL(CAST((ShortRetBackupSize/1024.0/1024.0/1024.0/1024.0) AS DECIMAL(20,2)), 0)) AS 'STR',
			SUM(ISNULL(CAST((LongRetBackupSize/1024.0/1024.0/1024.0/1024.0) AS DECIMAL(20,2)), 0)) AS 'LTR'
	FROM cf_SurveyMonthlyDataRetentionStats csInfo WITH (NOLOCK)
		INNER JOIN #CommCells CC
			ON csInfo.CommServUniqueId = CC.CommServUniqueId
		RIGHT OUTER JOIN #LastNMonths M
			ON csInfo.MonthStart = M.STARTDATE
	GROUP BY STARTDATE
	ORDER BY STARTDATE
END
ELSE IF @i_param = 3 -- Restore Summary Charts data
BEGIN
	IF OBJECT_ID('tempdb.dbo.#RstStats') IS NOT NULL DROP TABLE #RstStats
	SELECT R.CommservUniqueId, MonthStart, JobCount, RstSizeMB
	INTO #RstStats
	FROM cf_SurveyMonthlyRstJobStats R WITH (NOLOCK)
		INNER JOIN #CommCells CC
			ON CC.CommServUniqueId = R.CommServUniqueId
		INNER JOIN #LastNMonths M
			ON MonthStart = M.STARTDATE
	IF @i_GroupId <= 0 -- Global Restore SUmamry Chart data on slide 12 (slide number from template)
	BEGIN
		SELECT @cols = REPLACE(STUFF((SELECT ',' + QUOTENAME(Name)
							from (SELECT DISTINCT Name FROM #CCGrpAssoc)  CG
							order by Name
					FOR XML PATH(''))
				,1,1,''),'&amp;','&')
		SET @query = N'SELECT RIGHT(CONVERT(VARCHAR(20),CAST(M.STARTDATE AS DATE),6),6) AS Months, ' +
								  REPLACE(STUFF((SELECT ',ISNULL(' + QUOTENAME(Name) + ',0) AS '+ QUOTENAME(Name)
																from (SELECT DISTINCT Name FROM #CCGrpAssoc)  CG
																order by Name
														FOR XML PATH(''))
													,1,1,''),'&amp;','&') + N', ISNULL([Total Count],0) AS ''Total Count'', ISNULL([Size(TB)],0) AS ''Size(TB)''
						FROM #LastNMonths M LEFT OUTER JOIN
						(SELECT Months, ' + @cols + N', [Total Count], [Size(TB)] from
						 (
							SELECT CG.name AS CCGroupName,R.MonthStart AS Months,
								   SUM(R.JobCount) AS Val
							FROM #RstStats R
								INNER JOIN #CCGrpAssoc CG
									ON R.CommServUniqueId = CG.CommServUniqueId
							GROUP BY CG.id, CG.name, R.MonthStart
							UNION
							SELECT ''Total Count'' AS CCGroupName,R.MonthStart AS Months,
									SUM(R.JobCount) AS Val
							FROM #RstStats R
							GROUP BY R.MonthStart
							UNION
							SELECT ''Size(TB)'' AS CCGroupName,R.MonthStart AS Months,
									CAST(ROUND(CAST(SUM(R.RstSizeMB)/(1024.0 * 1024.0) AS DECIMAL(20,2)),0) AS BIGINT) AS Val
							FROM #RstStats R
							GROUP BY R.MonthStart
						) A
						pivot
						(
							max(Val)
							for CCGroupName in (' + @cols + N', [Total Count], [Size(TB)])
						) p
					) R
					ON M.STARTDATE = R.Months
					order by M.STARTDATE	'
		EXEC sp_executesql @query;
	END
	ELSE -- Other restore summary charts for indiviual commcell groups from slide 7 to slide 10
	BEGIN
		SELECT RIGHT(CONVERT(VARCHAR(20),CAST(M.STARTDATE AS DATE),6),6) AS Months, ISNULL(JobCount,0) AS 'Count', ISNULL(CompleteRstSize,0) AS 'Size(TB)'
		FROM #LastNMonths M LEFT OUTER JOIN
		(SELECT MonthStart, SUM(JobCount) AS JobCount, CAST(ROUND(CAST(SUM(RstSizeMB)/(1024.0 * 1024.0) AS DECIMAL(20,2)),0) AS INT) AS CompleteRstSize
				FROM #RstStats
				GROUP BY MonthStart) R
			ON M.STARTDATE = R.MonthStart
		ORDER BY M.STARTDATE
	END
	IF OBJECT_ID('tempdb.dbo.#RstStats') IS NOT NULL DROP TABLE #RstStats
END
ELSE IF @i_param IN (4, 5) -- 4: Consumer Report(slide 3-6); 5: Factory Report (slide 7-10)
BEGIN
	DECLARE @ClientsProtected TABLE (MonthStart date, ProtectedClients int)
	INSERT INTO @ClientsProtected
		SELECT M.STARTDATE, ISNULL(SUM(ISNULL(S.ClientsProtected, 0)), 0)
		FROM cf_SurveyMonthlyStrikes S
			INNER JOIN #CommCells CC
				ON S.CommServUniqueId = CC.CommServUniqueId
			RIGHT OUTER JOIN #LastNMonths M ON S.MonthStart = M.STARTDATE
		GROUP BY M.STARTDATE
	DECLARE @JobSummary TABLE(MonthStart date, Succeeded int, Failed int, Killed int, Total int, BackupSizeTB int)
	IF @i_param = 5
		INSERT INTO @JobSummary
			SELECT M.STARTDATE AS MonthStart,
				ISNULL(SUM(ISNULL(CompletedJobs,0)), 0) + ISNULL(SUM(ISNULL(CWWJobs, 0)), 0) + ISNULL(SUM(ISNULL(CWEJobs,0)), 0),
				ISNULL(SUM(ISNULL(FailedJobs,0)), 0) AS Failed,
				ISNULL(SUM(ISNULL(KilledJobs,0)), 0) AS Killed,
				ISNULL(SUM(ISNULL(TotalJobs,0)), 0) - ISNULL(SUM(ISNULL(SkippedJobs,0)), 0),
				ISNULL(CAST((SUM(ISNULL(BackupSize,0))/1024.0/1024.0/1024.0/1024.0) AS DECIMAL(20,2)), 0)
			FROM cf_SurveyIDAMonthlyBkpJobStats IDA WITH (NOLOCK)
					INNER JOIN #CommCells CC
							ON IDA.CommServUniqueId = CC.CommServUniqueId
					RIGHT OUTER JOIN #LastNMonths M ON IDA.MonthStart = M.STARTDATE
			GROUP BY M.STARTDATE
	ELSE
		INSERT INTO @JobSummary
			SELECT M.STARTDATE AS MonthStart,
				ISNULL(SUM(ISNULL(CompletedJobs,0)), 0) + ISNULL(SUM(ISNULL(CWWJobs, 0)), 0) + ISNULL(SUM(ISNULL(CWEJobs,0)), 0),
				ISNULL(SUM(ISNULL(FailedJobs,0)), 0) AS Failed,
				ISNULL(SUM(ISNULL(KilledJobs,0)), 0) AS Killed,
				ISNULL(SUM(ISNULL(TotalJobs,0)), 0) - ISNULL(SUM(ISNULL(SkippedJobs,0)), 0),
				ISNULL(CAST((SUM(ISNULL(BackupSize,0))/1024.0/1024.0/1024.0/1024.0) AS DECIMAL(20,2)), 0)
			FROM cf_SurveyConsumerMonthlyBkpJobStats IDA WITH (NOLOCK)
					INNER JOIN #CommCells CC
							ON IDA.CommServUniqueId = CC.CommServUniqueId
					RIGHT OUTER JOIN #LastNMonths M ON IDA.MonthStart = M.STARTDATE
			GROUP BY M.STARTDATE
	SELECT RIGHT(CONVERT(VARCHAR(20), J.MonthStart,106),8) AS Month,
		ISNULL(Succeeded, 0) AS 'Succeeded',
		ISNULL(Failed, 0) AS 'Failed',
		ISNULL(Killed, 0) AS 'Killed',
		CASE WHEN (ISNULL(Succeeded, 0) + ISNULL(Failed, 0)) <= 0 THEN 0
				ELSE CAST(ROUND((ISNULL(Succeeded, 0))*1.0/(ISNULL(Succeeded, 0) + ISNULL(Failed, 0)),4) AS DECIMAL(20,4))
		END AS [Success Rate],
		ISNULL(Total, 0) 'Total',
		ISNULL(BackupSizeTB, 0) [Size(TB)],
		ISNULL(ProtectedClients, 0) [Client Count]
	FROM @JobSummary J INNER JOIN @ClientsProtected C ON J.MonthStart = C.MonthStart
	ORDER BY J.MonthStart
END
ELSE IF @i_param IN (7) -- Monthly Backup Error Summary for current month for slides 7-10 and for global error summary on slide 16
BEGIN
	IF OBJECT_ID('tempDB..#ErrorCodeFreq') IS NOT NULL
		DROP TABLE #ErrorCodeFreq
	SELECT E.CommServUniqueId, ErrorCode, SUM(numberOfJobsAffected) AS Frequency
	INTO #ErrorCodeFreq
		FROM cf_surveyMonthlyErrorSummary E WITH (NOLOCK)
			 INNER JOIN #CommCells CC
					ON CC.CommServUniqueId = E.CommServUniqueId
		WHERE E.MonthStart = @STARTDATE AND ErrorCode NOT IN (SELECT ErrorCode FROM @tblErrorExceptions)
		GROUP BY E.CommServUniqueId, ErrorCode
	IF @i_GroupId <= 0  -- Global Backup Services on slide 16
	BEGIN
		SELECT @cols = REPLACE(STUFF((SELECT ',' + QUOTENAME(Name)
							from (SELECT DISTINCT name FROM #CCGrpAssoc) CG
							order by Name
					FOR XML PATH(''))
				,1,1,''),'&amp;','&')
		SET @query = N'SELECT ErrCode AS ErrorCode,' +
					'ErrCode+'' - ''+(SELECT TOP 1 LEFT(ErrorDescription,CASE WHEN CHARINDEX(''Source:'',ErrorDescription) = 0 THEN LEN(ErrorDescription) ELSE CHARINDEX(''Source:'',ErrorDescription)-1 END) FROM cf_surveyMonthlyErrorSummary JM WITH (NOLOCK) WHERE JM.ErrorCode = ErrCode) AS ErrorDescription,' +
							  REPLACE(STUFF((SELECT ',ISNULL(' + QUOTENAME(CG.Name) + ',0) AS '+ QUOTENAME(CG.Name)
															from (SELECT DISTINCT Name FROM #CCGrpAssoc) CG
															order by CG.Name
													FOR XML PATH(''))
												,1,1,''),'&amp;','&') + N' from
					 (
						SELECT CG.name AS CCGroupName,E.ErrorCode AS ErrCode,
							   SUM(E.Frequency) AS Frequency
						FROM #ErrorCodeFreq E
							INNER JOIN (SELECT TOP 5 ErrorCode,SUM(Frequency) AS Freq FROM #ErrorCodeFreq GROUP BY ErrorCode ORDER BY Freq DESC) Top5
								ON E.ErrorCode = Top5.ErrorCode
							INNER JOIN #CCGrpAssoc CG
								ON E.CommServUniqueId = CG.CommServUniqueId
						GROUP BY CG.id, CG.name, E.ErrorCode
					) A
					pivot
					(
						max(Frequency)
						for CCGroupName in (' + @cols + N')
					) p '
		EXEC sp_executesql @query;
	END
	ELSE -- For individual commcell groups error summary for slides 7-10
		SELECT TOP 5 ErrorCode,	Freq
		FROM (SELECT TOP 5 ErrorCode,SUM(Frequency) AS Freq FROM #ErrorCodeFreq GROUP BY ErrorCode ORDER BY Freq DESC) E ORDER BY Freq DESC
	IF OBJECT_ID('tempDB..#ErrorCodeFreq') IS NOT NULL
		DROP TABLE #ErrorCodeFreq
END
ELSE IF @i_param IN (8, 9) -- Past 5 months Backup Error Summary Globally for slide 18
BEGIN
	IF OBJECT_ID('tempDB..#ErrorCodeFreqForPast5Months') IS NOT NULL
		DROP TABLE #ErrorCodeFreqForPast5Months
	DECLARE @TopNErrors INT = 1
	IF @i_param = 9
		SET @TopNErrors = @TopNErrors + 5 -- Return next 5 error codes
	SELECT M.STARTDATE, ErrorCode,SUM(numberOfJobsAffected) AS Frequency
	INTO #ErrorCodeFreqForPast5Months
		FROM cf_surveyMonthlyErrorSummary E WITH (NOLOCK)
			 INNER JOIN #CommCells CC
				ON CC.CommServUniqueId = E.CommServUniqueId
				   AND ErrorCode <> '' AND ErrorCode NOT IN (SELECT ErrorCode FROM @tblErrorExceptions)
			INNER JOIN #LastNMonths M
				ON E.MonthStart = M.STARTDATE
		GROUP BY M.STARTDATE, ErrorCode
	SELECT @cols = REPLACE(STUFF((SELECT ',' + QUOTENAME(DATENAME(MONTH,STARTDATE))
							from #LastNMonths
							order by STARTDATE
					FOR XML PATH(''))
				,1,1,''),'&amp;','&')
	SET @query = N'SELECT ErrCode AS ErrorCode,' +
						  REPLACE(STUFF((SELECT ',ISNULL(' + QUOTENAME(DATENAME(MONTH,STARTDATE)) + ',0) AS '+ DATENAME(MONTH,STARTDATE)
														from #LastNMonths
														order by STARTDATE
												FOR XML PATH(''))
											,1,1,''),'&amp;','&') + N' from
				 (
					SELECT DATENAME(MONTH,E.STARTDATE) AS Month, E.ErrorCode AS ErrCode, E.Frequency ErrorCount
					FROM #ErrorCodeFreqForPast5Months E
						INNER JOIN (SELECT ROW_NUMBER() OVER (order by SUM(Frequency) DESC) Rank, ErrorCode
										FROM  #ErrorCodeFreqForPast5Months
										GROUP BY ErrorCode ) T
							ON E.ErrorCode = T.ErrorCode AND T.Rank BETWEEN '+CAST(@TopNErrors AS NVARCHAR(2))+N' AND '+CAST((@TopNErrors+4) AS NVARCHAR(2))+'
				) A
				pivot
				(
					max(ErrorCount)
					for Month in (' + @cols + N')
				) p '
	EXEC sp_executesql @query;
	IF OBJECT_ID('tempDB..#ErrorCodeFreqForPast5Months') IS NOT NULL
		DROP TABLE #ErrorCodeFreqForPast5Months
END
ELSE IF @i_param IN (10) -- System Restore Age for slide 7
BEGIN
	DECLARE @firstJan1970 DATETIME = '01-01-1970'
	DECLARE @Tomorrow DATETIME = DATEADD(day, DATEDIFF(day, 0, GETDATE()), 1)
	IF OBJECT_ID('tempdb.dbo.#RestoreAgePeriods') IS NOT NULL DROP TABLE #RestoreAgePeriods
	CREATE TABLE #RestoreAgePeriods (SlNo int, PeriodName nvarchar(50), DiffStart BIGINT, DiffEnd BIGINT)
	INSERT INTO #RestoreAgePeriods (SlNo, PeriodName, DiffStart, DiffEnd)
	(
		SELECT 1, 'Less than 7 days', 0, DATEDIFF(second, @firstJan1970, DATEADD(day, 7, @firstJan1970))
		UNION ALL
		SELECT 2, '1-2 weeks', DATEDIFF(second, @firstJan1970, DATEADD(week, 1, @firstJan1970)), DATEDIFF(second, @firstJan1970, DATEADD(week, 2, @firstJan1970))
		UNION ALL
		SELECT 3, '2-3 weeks', DATEDIFF(second, @firstJan1970, DATEADD(week, 2, @firstJan1970)), DATEDIFF(second, @firstJan1970, DATEADD(week, 3, @firstJan1970))
		UNION ALL
		SELECT 4, '3-4 weeks', DATEDIFF(second, @firstJan1970, DATEADD(week, 3, @firstJan1970)), DATEDIFF(second, @firstJan1970, DATEADD(week, 4, @firstJan1970))
		UNION ALL
		SELECT 5, '1-2 months', DATEDIFF(second, @firstJan1970, DATEADD(month, 1, @firstJan1970)), DATEDIFF(second, @firstJan1970, DATEADD(month, 2, @firstJan1970))
		UNION ALL
		SELECT 6, '2-3 months', DATEDIFF(second, @firstJan1970, DATEADD(month, 2, @firstJan1970)), DATEDIFF(second, @firstJan1970, DATEADD(month, 3, @firstJan1970))
		UNION ALL
		SELECT 7, '3-6 months', DATEDIFF(second, @firstJan1970, DATEADD(month, 3, @firstJan1970)), DATEDIFF(second, @firstJan1970, DATEADD(month, 6, @firstJan1970))
		UNION ALL
		SELECT 8, '6-9 months', DATEDIFF(second, @firstJan1970, DATEADD(month, 6, @firstJan1970)), DATEDIFF(second, @firstJan1970, DATEADD(month, 9, @firstJan1970))
		UNION ALL
		SELECT 9, '9-12 months', DATEDIFF(second, @firstJan1970, DATEADD(month, 9, @firstJan1970)), DATEDIFF(second, @firstJan1970, DATEADD(month, 12, @firstJan1970))
		UNION ALL
		SELECT 10, '1-2 years', DATEDIFF(second, @firstJan1970, DATEADD(year, 1, @firstJan1970)), DATEDIFF(second, @firstJan1970, DATEADD(year, 2, @firstJan1970))
		UNION ALL
		SELECT 11, 'Greater than 2 years', DATEDIFF(second, @firstJan1970, DATEADD(year, 2, @firstJan1970)), DATEDIFF(second, @firstJan1970, @Tomorrow)
		UNION ALL
		SELECT 12, 'Unknown', NULL, NULL
	)
	SELECT TOP 1 @STARTDATE = StartDate FROM #LastNMonths ORDER BY StartDate ASC
	SELECT TOP 1 @ENDDATE = EndDate FROM #LastNMonths ORDER BY EndDate DESC
	DECLARE @StartTime BIGINT = dbo.getUnixTimeBig(@StartDate)
	DECLARE @EndTime BIGINT = dbo.getUnixTimeBig(@Enddate)
	IF OBJECT_ID('tempdb.dbo.#RstAgeStats') IS NOT NULL DROP TABLE #RstAgeStats
	SELECT R.CommservUniqueId, P.PeriodName, Count(*) AS RestoreJobCount
	INTO #RstAgeStats
	FROM cf_SurveyRestoreJobStats R WITH(NOLOCK)
		INNER JOIN #RestoreAgePeriods P ON (P.DiffStart IS NULL AND (R.BackupTime IS NULL OR R.BackupTime < @firstJan1970 OR (EndTime-(DATEDIFF(second, @firstJan1970, R.BackupTime)) < 0)))
			OR (R.BackupTime>=@firstJan1970 AND EndTime-(DATEDIFF(second, @firstJan1970, R.BackupTime)) >= P.DiffStart AND EndTime-(DATEDIFF(second, @firstJan1970, R.BackupTime)) < P.DiffEnd)
		INNER JOIN #CommCells CC
			ON R.CommServUniqueId = CC.CommServUniqueId
	WHERE R.EndTime >= @StartTime AND R.EndTime < @EndTime AND R.JobStatus IN (1, 3, 14) --Completed, Completed with errors, Completed with warnings
	GROUP BY R.CommservUniqueId, P.PeriodName
	SELECT @cols = REPLACE(STUFF((SELECT ',' + QUOTENAME(Name)
							from (SELECT DISTINCT Name FROM #CCGrpAssoc)  CG
							order by Name
					FOR XML PATH(''))
				,1,1,''),'&amp;','&')
	SET @query = N'SELECT P.PeriodName, ' +
                                  REPLACE(STUFF((SELECT ',ISNULL(' + QUOTENAME(Name) + ',0) AS '+ QUOTENAME(Name)
                                                                from (SELECT DISTINCT Name FROM #CCGrpAssoc)  CG
                                                                order by Name
                                                        FOR XML PATH(''))
                                                    ,1,1,''),'&amp;','&') + N', ISNULL([Total Count],0) AS ''Total Count''
                        FROM #RestoreAgePeriods P LEFT OUTER JOIN
						(SELECT Period, ' + @cols + N', [Total Count] from
                         (
							SELECT CG.name AS CCGroupName,R.PeriodName AS Period, SUM(R.RestoreJobCount) AS JobCount
							FROM #RstAgeStats R
								INNER JOIN #CCGrpAssoc CG
									ON R.CommServUniqueId = CG.CommServUniqueId
							GROUP BY CG.id, CG.name, R.PeriodName
							UNION ALL
							SELECT ''Total Count'' AS CCGroupName,R.PeriodName AS Period,
									SUM(R.RestoreJobCount) AS JobCount
							FROM #RstAgeStats R
							GROUP BY R.PeriodName
                        ) A
                        pivot
                        (
                            max(JobCount)
                            for CCGroupName in (' + @cols + N', [Total Count])
                        ) p
                    ) R
                    ON P.PeriodName = R.Period
                    order by P.DiffStart '
	EXEC sp_executesql @query;
	IF OBJECT_ID('tempdb.dbo.#RstAgeStats') IS NOT NULL DROP TABLE #RstAgeStats
END
IF OBJECT_ID('tempdb.dbo.#LastNMonths') IS NOT NULL DROP TABLE #LastNMonths
IF OBJECT_ID('tempdb.dbo.#CommCells') IS NOT NULL DROP TABLE #CommCells
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptMonthlyPptData')
	delete from GxQscripts where name = 'RptMonthlyPptData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptMonthlyPptData')
	delete from GXDBVersions where aliasname = 'RptMonthlyPptData'
GO

insert into GXDBVersions values(2, 'RptMonthlyPptData',  '00010003001200160000', 'RptMonthlyPptData', '00010003001200160000')
GO

