

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptMostFrequentErrors.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptMostFrequentErrors.sp,v $ $Id: RptMostFrequentErrors.sp,v 1.13.2.5 2020/08/19 18:45:09 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptMostFrequentErrors')
BEGIN
	print '>>> Drop Stored Procedure: RptMostFrequentErrors <<<'
	drop procedure RptMostFrequentErrors
END
IF EXISTS (select * from GxQscripts where name='RptMostFrequentErrors')
	delete from GxQscripts where name = 'RptMostFrequentErrors'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptMostFrequentErrors')
	delete from GXDBVersions where aliasname = 'RptMostFrequentErrors'
GO
print '... Creating Procedure: RptMostFrequentErrors'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptMostFrequentErrors
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll,
  @i_ErrorCode nvarchar(50) = NULL
AS
DECLARE @i_QueryId BIGINT = 30
BEGIN
SET NOCOUNT ON
--Get excluded error list
DECLARE @tblExcludedErrors TABLE (ErrorCode NVARCHAR(20))
DECLARE @ExcludedErrors NVARCHAR(MAX) = (SELECT ISNULL(value, '') FROM cf_SurveyConfig WHERE name = 'ExcludedErrorCodes')
WHILE (CHARINDEX(',',@ExcludedErrors)>0)
BEGIN
    INSERT INTO @tblExcludedErrors (ErrorCode)
    SELECT LTRIM(RTRIM(SUBSTRING(@ExcludedErrors,1,CHARINDEX(',',@ExcludedErrors)-1)))
    SET @ExcludedErrors = SUBSTRING(@ExcludedErrors,CHARINDEX(',',@ExcludedErrors)+1,LEN(@ExcludedErrors))
END
IF(@ExcludedErrors IS NOT NULL AND LEN(@ExcludedErrors) > 0)
    INSERT INTO @tblExcludedErrors (ErrorCode)
    SELECT LTRIM(RTRIM(@ExcludedErrors))
IF object_id('tempdb.dbo.#summary') IS NOT NULL DROP TABLE #summary
CREATE TABLE #summary (ErrorCode nvarchar(50) NOT NULL, NumberOfJobsAffected BIGINT NOT NULL, ErrorDescription nvarchar(max) NULL)
DECLARE @top INT =10
IF(@blaggregate=1)
BEGIN
	INSERT INTO #summary
	SELECT TOP (@top) csInfo.ErrorCode, sum(csInfo.NumberOfJobsAffected), NULL
	FROM cf_SurveyMostFrequentErrors AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
		LEFT OUTER JOIN @tblExcludedErrors E
			ON E.ErrorCode = csInfo.ErrorCode
	WHERE E.ErrorCode IS NULL
	GROUP BY csInfo.ErrorCode
	ORDER BY sum(csInfo.NumberOfJobsAffected) DESC
	UPDATE #summary
	set ErrorDescription = T.ErrorDescription
	FROM #summary summary
	inner join  (SELECT    csInfo.ErrorDescription, errorCode, ROW_NUMBER() OVER(PARTITION BY errorCode order by NumberOfJobsAffected) as number FROM
	 cf_SurveyMostFrequentErrors AS csInfo WITH (NOLOCK)
	 INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
	  ) AS T
	ON T.ErrorCode = summary.ErrorCode
	AND T.number =1
	SELECT
		dbo.cf_surveyKBLink(summ.ErrorCode) AS 'Error Code',
		summ.NumberOfJobsAffected AS 'Jobs Affected<FORMATNUMBERNA>',
		summ.ErrorDescription AS 'Description'
	FROM #summary AS summ
	RETURN
END
SET @blLatestSurvey = 1 --Always pickup the latest
IF @i_CommServUniqueID = 0
BEGIN
	SELECT
		resultView.CommServUniqueId  AS 'CommServ UniqueId',
		resultView.CommCellID AS 'CommCell ID<HIDDEN>',
		resultView.DisplayName AS 'CommCell Name',
		dbo.cf_surveyKBLink(csInfo.ErrorCode) AS 'Error Code',
		csInfo.ErrorDescription AS 'Description',
		csInfo.NumberOfJobsAffected AS 'Total Jobs Affected<FORMATNUMBERNA>' -- renamed this as Jobs Affected is hyperlink now
	FROM cf_SurveyMostFrequentErrors AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND (csInfo.ErrorCode = @i_ErrorCode OR @i_ErrorCode IS NULL)
		LEFT OUTER JOIN @tblExcludedErrors E
			ON E.ErrorCode = csInfo.ErrorCode
		WHERE E.ErrorCode IS NULL
	ORDER BY  csInfo.NumberOfJobsAffected DESC
END
ELSE
BEGIN
	IF @i_ErrorCode IS NULL
	BEGIN
		INSERT INTO #summary
		SELECT TOP (@top) csInfo.ErrorCode, sum(csInfo.NumberOfJobsAffected), NULL
		FROM cf_SurveyMostFrequentErrors AS csInfo WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.SurverResultId = csInfo.SurveyResultId
			LEFT OUTER JOIN @tblExcludedErrors E
				ON E.ErrorCode = csInfo.ErrorCode
			WHERE E.ErrorCode IS NULL
		GROUP BY csInfo.ErrorCode
		ORDER BY sum(csInfo.NumberOfJobsAffected) desc
		UPDATE #summary
		set ErrorDescription = T.ErrorDescription
		FROM #summary summary
		inner join  (SELECT    csInfo.ErrorDescription, errorCode, ROW_NUMBER() OVER(PARTITION BY errorCode order by NumberOfJobsAffected) as number FROM
		 cf_SurveyMostFrequentErrors   AS csInfo WITH (NOLOCK)
		  INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.SurverResultId = csInfo.SurveyResultId
		) AS T
		ON T.ErrorCode = summary.ErrorCode
		AND T.number =1
		SELECT
			dbo.cf_surveyKBLink(summ.ErrorCode) AS 'Error Code',
			summ.NumberOfJobsAffected AS 'Jobs Affected<FORMATNUMBERNA>',
			summ.ErrorDescription AS 'Description'
		FROM #summary AS summ
	END
	ELSE
	BEGIN
		SELECT
			dbo.cf_surveyKBLink(csInfo.ErrorCode) AS 'Error Code',
			csInfo.ErrorDescription AS 'Description',
			csInfo.NumberOfJobsAffected AS 'Jobs Affected<FORMATNUMBERNA>'
		FROM cf_SurveyMostFrequentErrors AS csInfo WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.SurverResultId = csInfo.SurveyResultId
				AND (csInfo.ErrorCode = @i_ErrorCode OR @i_ErrorCode IS NULL)
		ORDER BY csInfo.NumberOfJobsAffected desc
	END
END
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'RptMostFrequentErrors')
	delete from GxQscripts where name = 'RptMostFrequentErrors'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptMostFrequentErrors')
	delete from GXDBVersions where aliasname = 'RptMostFrequentErrors'
GO

insert into GXDBVersions values(2, 'RptMostFrequentErrors',  '00010013000200050000', 'RptMostFrequentErrors', '00010013000200050000')
GO

