

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptRecoverabilitySLA.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptRecoverabilitySLA.sp,v $ $Id: RptRecoverabilitySLA.sp,v 1.1.2.12 2020/12/17 02:52:41 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptRecoverabilitySLA')
BEGIN
	print '>>> Drop Stored Procedure: RptRecoverabilitySLA <<<'
	drop procedure RptRecoverabilitySLA
END
IF EXISTS (select * from GxQscripts where name='RptRecoverabilitySLA')
	delete from GxQscripts where name = 'RptRecoverabilitySLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptRecoverabilitySLA')
	delete from GXDBVersions where aliasname = 'RptRecoverabilitySLA'
GO
print '... Creating Procedure: RptRecoverabilitySLA'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptRecoverabilitySLA
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NULL
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 211
/*
DECLARE @strGood VARCHAR(10) = '1_Good'
DECLARE @strInfo VARCHAR(10) = '2_Info'
DECLARE @strwarning VARCHAR(10) = '3_Warning'
DECLARE @strCritical VARCHAR(10) = '4_Critical'
DECLARE @criticalVal int
DECLARE @warningVal int
SELECT	@warningVal = WarningThreshold,
		@criticalVal =CriticalThreshold
FROM	cf_SurveyHealthParam where queryId = @i_QueryId
*/
CREATE TABLE #LatestResult (SurveyResultId BIGINT, CommServUniqueId INT, DisplayName NVARCHAR(256))
INSERT	INTO #LatestResult
SELECT	SurverResultId, CommServUniqueId, DisplayName
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
CREATE TABLE #ClientsMissedSLA (SurveyResultId BIGINT, CommServUniqueId INT, ClientId INT)
INSERT	INTO #ClientsMissedSLA
SELECT	DISTINCT SurveyResultId, CommServUniqueId, ClientId
FROM	cf_SurveySLADetails AS S WITH (NOLOCK)
		INNER JOIN (
			SELECT	SurverResultId, CommServUniqueId
			FROM	dbo.cf_SurveyResultFuncV1(242, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
			UNION
			SELECT	SurverResultId, CommServUniqueId
			FROM	dbo.cf_SurveyResultFuncV1(27, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
			) R ON R.SurverResultId = S.SurveyResultId AND (S.Days = 30 OR S.Days < 0)
IF @blaggregate = 1
BEGIN
	CREATE TABLE #Summary (SurveyResultId BIGINT, ClientsTotal INT, ClientsMet INT)
	INSERT	INTO #Summary
	SELECT	P.SurveyResultId, ISNULL([0], 0) + ISNULL([1], 0), ISNULL([1], 0)
	FROM	(
			SELECT	R.SurveyResultId, (CASE WHEN M.ClientId IS NULL AND RTAMinutes > 0 AND RTAMinutes <= RTOMinutes THEN 1 ELSE 0 END) AS RecoverabilityMet,
					COUNT(DISTINCT S.ClientId) AS ClientCount
			FROM	cf_SurveyRecoverabilitySLA AS S WITH (NOLOCK)
					INNER JOIN #LatestResult R ON R.SurveyResultId = S.SurveyResultId
					LEFT OUTER JOIN #ClientsMissedSLA M ON R.CommServUniqueId = M.CommServUniqueId AND S.ClientId = M.ClientId
			GROUP BY R.SurveyResultId, (CASE WHEN M.ClientId IS NULL AND RTAMinutes > 0 AND RTAMinutes <= RTOMinutes THEN 1 ELSE 0 END)
			) AS S
			PIVOT (
				MAX(ClientCount) FOR RecoverabilityMet IN ([0], [1])
			) AS P
	SELECT 	R.CommServUniqueId  AS 'CommServ UniqueId',
			R.DisplayName AS 'CommCell Name',
			ClientsMet AS 'RTO Met',
			(ClientsTotal - ClientsMet) AS 'RTO Not Met',
			CAST((CASE WHEN ClientsTotal > 0 THEN ClientsMet*100.0/ClientsTotal ELSE 0 END) AS INT) AS 'RTO (%)'/*,
			(CASE
					WHEN ClientsTotal > 0 and ClientsMet*100/ClientsTotal < @criticalVal THEN @strCritical
					WHEN ClientsTotal > 0 and ClientsMet*100/ClientsTotal < @warningVal THEN @strWarning
					ELSE @strGood END
			) AS 'Status<HEALTH_STATUS>'*/
	FROM	#Summary AS S INNER JOIN #LatestResult AS R ON S.SurveyResultId = R.SurveyResultId
	ORDER BY 'RTO (%)' ASC
	DROP TABLE #Summary
END
ELSE
BEGIN
	CREATE TABLE #ClientGroupsString (CommservUniqueId INT, ClientId INT, ClientGroups NVARCHAR(MAX))
	EXEC GetClientGroupsString @i_CommServUniqueID
	CREATE TABLE #SubclientsMissedSLA (CommServUniqueId INT, ClientId INT, AppId INT)
	INSERT	INTO #SubclientsMissedSLA
	SELECT	M.CommServUniqueId, S.ClientId, S.AppId
	FROM	cf_SurveySLADetails AS S WITH (NOLOCK)
		INNER JOIN #ClientsMissedSLA M ON S.SurveyResultId = M.SurveyResultId AND S.ClientId = M.ClientId
	SELECT 	R.CommServUniqueId AS 'CommServ UniqueId',
			ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Client',
			ISNULL(SA.AgentName, 'N/A') + CASE WHEN ISNULL(SA.AppTypeId, 0) = 106 AND CL.ClientId <> SA.ClientId THEN ' in ' + SA.ClientName ELSE '' END AS 'Agent',
			ISNULL(SA.InstanceName, 'N/A') As 'Instance',
			ISNULL(SA.BackupsetName, 'N/A') AS 'Backupset',
			ISNULL(SA.SubclientName, 'N/A') AS 'Subclient',
			CASE WHEN LastJobId >= 0 THEN LastJobId ELSE 0 END AS 'Last Job Id<HIDDEN>',
			CASE WHEN (LastJobId <= 0 OR LastJobStart <= '1970-01-01') THEN -50
				ELSE datediff(second, '01/01/1970', LastJobStart)
			END AS 'Last Job Start<MMMDDYYYY>',
			AppSizeMB AS 'App Size<SIZEMB>',
			CAST(RstThruputMbps*(3600.0/1024.0) AS DECIMAL(20,2)) AS 'Estimated Throughput (GB/Hr)<HIDDEN>',
			CASE WHEN OpType <= 0 THEN 'N/A' WHEN OpType IN (59, 65) THEN 'Yes' ELSE 'No' END AS 'Is Snap Backup',
			CASE WHEN TapeExported < 0 THEN 'N/A' WHEN TapeExported > 0 THEN 'Yes' ELSE 'No' END AS 'Tape Exported',
			CASE WHEN RstThruputMbps > 0 THEN CAST(1.0*AppSizeMB/60.0/RstThruputMbps AS INT) ELSE 0 END AS 'Recovery Time (hh:mm)<HHMM>',
			RTOMinutes AS 'RTO (hh:mm)<HHMM><HIDDEN>',
			CASE WHEN RTAMinutes >= 0 THEN RTAMinutes ELSE 0 END AS 'Client Recovery Time (hh:mm)<HHMM><HIDDEN>',
			RTASizeMB  AS 'Client Size<SIZEMB><HIDDEN>',
			CASE WHEN M.ClientId IS NOT NULL THEN 'Missed Backup SLA'
				 WHEN RTAMinutes >= 0 AND RTAMinutes <= RTOMinutes THEN 'Met RTO'
				 ELSE 'Missed RTO'
			END AS [Client Status],
			ISNULL(CGS.ClientGroups, '') AS 'Client Groups<HIDDEN>'
	FROM 	cf_SurveyRecoverabilitySLA AS S WITH (NOLOCK)
			INNER JOIN #LatestResult R ON R.SurveyResultId = S.SurveyResultId
			INNER JOIN cf_SurveyClient CL WITH (NOLOCK) ON R.CommServUniqueId = CL.CommServUniqueId AND S.ClientId = CL.ClientId AND CL.Deleted = 0
			INNER JOIN #SubclientsMissedSLA M ON CL.CommServUniqueId = M.CommServUniqueId AND CL.ClientId = M.ClientId
			LEFT OUTER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK) ON M.CommServUniqueId = SA.CommServUniqueId AND M.AppId = SA.AppId AND M.AppId > 0
			LEFT OUTER JOIN #ClientGroupsString CGS ON CL.CommServUniqueId = CGS.CommServUniqueId AND CL.ClientId = CGS.ClientId
	WHERE	S.AppId <= 0
		AND (M.ClientId IS NOT NULL OR RTAMinutes < 0 OR RTAMinutes > RTOMinutes)
	UNION ALL
	SELECT 	R.CommServUniqueId AS 'CommServ UniqueId',
			ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Client',
			ISNULL(SA.AgentName, 'N/A') + CASE WHEN ISNULL(SA.AppTypeId, 0) = 106 AND CL.ClientId <> SA.ClientId THEN ' in ' + SA.ClientName ELSE '' END AS 'Agent',
			ISNULL(SA.InstanceName, 'N/A') As 'Instance',
			ISNULL(SA.BackupsetName, 'N/A') AS 'Backupset',
			ISNULL(SA.SubclientName, 'N/A') AS 'Subclient',
			CASE WHEN LastJobId >= 0 THEN LastJobId ELSE 0 END AS 'Last Job Id<HIDDEN>',
			CASE WHEN (LastJobId <= 0 OR LastJobStart <= '1970-01-01') THEN -50
				ELSE datediff(second, '01/01/1970', LastJobStart)
			END AS 'Last Job Start<MMMDDYYYY>',
			AppSizeMB AS 'App Size<SIZEMB>',
			CAST(RstThruputMbps*(3600.0/1024.0) AS DECIMAL(20,2)) AS 'Estimated Throughput (GB/Hr)<HIDDEN>',
			CASE WHEN OpType <= 0 THEN 'N/A' WHEN OpType IN (59, 65) THEN 'Yes' ELSE 'No' END AS 'Is Snap Backup',
			CASE WHEN TapeExported < 0 THEN 'N/A' WHEN TapeExported > 0 THEN 'Yes' ELSE 'No' END AS 'Tape Exported',
			CASE WHEN RstThruputMbps > 0 THEN CAST(1.0*AppSizeMB/60.0/RstThruputMbps AS INT) ELSE 0 END AS 'Recovery Time (hh:mm)<HHMM>',
			RTOMinutes AS 'RTO (hh:mm)<HHMM><HIDDEN>',
			CASE WHEN RTAMinutes >= 0 THEN RTAMinutes ELSE 0 END AS 'Client Recovery Time (hh:mm)<HHMM><HIDDEN>',
			RTASizeMB  AS 'Client Size<SIZEMB><HIDDEN>',
			CASE WHEN M.ClientId IS NOT NULL THEN 'Missed Backup SLA'
				 WHEN RTAMinutes >= 0 AND RTAMinutes <= RTOMinutes THEN 'Met RTO'
				 ELSE 'Missed RTO'
			END AS [Client Status],
			ISNULL(CGS.ClientGroups, '') AS 'Client Groups<HIDDEN>'
	FROM 	cf_SurveyRecoverabilitySLA AS S WITH (NOLOCK)
			INNER JOIN #LatestResult R ON R.SurveyResultId = S.SurveyResultId
			INNER JOIN cf_SurveyClient CL WITH (NOLOCK) ON R.CommServUniqueId = CL.CommServUniqueId AND S.ClientId = CL.ClientId AND CL.Deleted = 0
			LEFT OUTER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK) ON CL.CommServUniqueId = SA.CommServUniqueId AND S.AppId = SA.AppId AND S.AppId > 0
			LEFT OUTER JOIN #ClientGroupsString CGS ON CL.CommServUniqueId = CGS.CommServUniqueId AND CL.ClientId = CGS.ClientId
			LEFT OUTER JOIN #ClientsMissedSLA M ON CL.CommServUniqueId = M.CommServUniqueId AND CL.ClientId = M.ClientId
	WHERE	S.AppId > 0 AND (LastJobId > 0 OR M.ClientId IS NOT NULL)
		AND (M.ClientId IS NOT NULL OR RTAMinutes < 0 OR RTAMinutes > RTOMinutes)
	ORDER BY 'Client', 'Agent', 'Instance', 'Backupset', 'Subclient'
	DROP TABLE #ClientGroupsString
	DROP TABLE #SubclientsMissedSLA
END
DROP TABLE #LatestResult
DROP TABLE #ClientsMissedSLA
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0
  DECLARE @blLatestSurvey INT			= 1
  DECLARE @i_CommServUniqueID INT		= 11065
  DECLARE @i_LogDateEND DATETIME		= 	NULL    -- getDate()
  DECLARE @i_LogDateStart DATETIME		= NULL   --DateAdd(Month, -36, @i_LogDateEND)
exec RptRecoverabilitySLA @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND
*/

IF EXISTS (select * from GxQscripts where name = 'RptRecoverabilitySLA')
	delete from GxQscripts where name = 'RptRecoverabilitySLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptRecoverabilitySLA')
	delete from GXDBVersions where aliasname = 'RptRecoverabilitySLA'
GO

insert into GXDBVersions values(2, 'RptRecoverabilitySLA',  '00010001000200120000', 'RptRecoverabilitySLA', '00010001000200120000')
GO

