

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptRestoreStatus.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptRestoreStatus.sp,v $ $Id: RptRestoreStatus.sp,v 1.6.40.3 2018/08/16 11:32:44 skatz Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptRestoreStatus <<<'

IF EXISTS (select * from sysobjects where name='RptRestoreStatus')
	drop procedure RptRestoreStatus
IF EXISTS (select * from GxQscripts where name='RptRestoreStatus')
	delete from GxQscripts where name = 'RptRestoreStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptRestoreStatus')
	delete from GXDBVersions where aliasname = 'RptRestoreStatus'
GO
print '... Creating Procedure: RptRestoreStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptRestoreStatus
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 17
IF @blaggregate = 0
BEGIN
	IF @i_CommServUniqueID = 0
		SELECT
			R.CommServUniqueId AS 'CommServ UniqueId',
			R.CommCellID AS 'CommCell ID',
			R.CommServIP AS 'CommServe IP<HIDDEN>',
			R.CommServGUID AS 'CommServer GUID',
			R.DisplayName AS 'CommCell Name',
			ISNULL(CL.clientDisplayName, F.Client) AS 'Client',
			F.Agent,
			F.Instance,
			F.Backupset,
			F.LastRestoreJobId AS 'Last Restore Job ID',
			DATEDIFF(SS, '01/01/1970', F.LastJobEndTime) AS 'Last Job End<MMMDDYYYY>',
			F.LastJobStatus AS 'Last Job Status',
			dbo.cf_surveyKBLink(F.ErrorCode) AS 'Error Code'
		FROM	cf_SurveyRestoreFailures AS F WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) AS R
				ON R.SurverResultId = F.SurveyResultId
			LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = R.CommServUniqueId AND CL.ClientId = F.ClientId
		ORDER BY F.Client, F.Agent, F.Instance, F.Backupset
	ELSE
		SELECT
			R.CommServUniqueId AS 'CommServ UniqueId',
			ISNULL(CL.clientDisplayName, F.Client) AS 'Client',
			F.Agent,
			F.Instance,
			F.Backupset,
			F.LastRestoreJobId AS 'Last Restore Job ID',
			DATEDIFF(SS, '01/01/1970', F.LastJobEndTime) AS 'Last Job End<MMMDDYYYY>',
			F.LastJobStatus AS 'Last Job Status',
			dbo.cf_surveyKBLink(F.ErrorCode) AS 'Error Code'
		FROM	cf_SurveyRestoreFailures AS F WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) AS R
				ON R.SurverResultId = F.SurveyResultId
			LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = R.CommServUniqueId AND CL.ClientId = F.ClientId
		ORDER BY F.Client, F.Agent, F.Instance, F.Backupset
END
IF @blaggregate = 1
BEGIN
	IF @i_CommServUniqueID = 0
		SELECT
			R.CommServUniqueId AS 'CommServ UniqueId',
			R.CommCellID AS 'CommCell ID',
			R.CommServIP AS 'CommServe IP<HIDDEN>',
			R.CommServGUID AS 'CommServer GUID',
			R.DisplayName AS 'CommCell Name',
			R.SuccessfulClients AS 'Successful Clients',
			R.SuccAfterFailClients AS 'Successful After Failures Clients',
			R.FailedClients AS 'Failed Clients'
		FROM
			(SELECT	CommServUniqueId, CommCellID, CommServIP, CommServGUID, DisplayName,
					SUM(SuccessfulClients) AS SuccessfulClients, SUM(SuccAfterFailClients) AS SuccAfterFailClients, SUM(FailedClients) AS FailedClients
			FROM	cf_SurveyRestoreClientStats AS A WITH (NOLOCK)
				INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) B
					ON B.SurverResultId = A.SurveyResultId
			GROUP BY CommServUniqueId, CommCellID, CommServIP, CommServGUID, DisplayName) R
	ELSE
		SELECT
			R.CommServUniqueId AS 'CommServ UniqueId',
			S.SuccessfulClients AS 'Successful Clients',
			S.SuccAfterFailClients AS 'Successful After Failures Clients',
			S.FailedClients AS 'Failed Clients'
		FROM	cf_SurveyRestoreClientStats AS S WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) AS R
				ON R.SurverResultId = S.SurveyResultId
END
IF @blaggregate = 2
BEGIN
	IF @i_CommServUniqueID = 0
		SELECT
			R.CommServUniqueId AS 'CommServ UniqueId',
			R.CommCellID AS 'CommCell ID',
			R.CommServIP AS 'CommServe IP<HIDDEN>',
			R.CommServGUID AS 'CommServer GUID',
			R.DisplayName AS 'CommCell Name',
			dbo.cf_surveyKBLink(R.ErrorCode) AS 'Error Code',
			R.Frequency AS 'No of Failed Restores',
			R.Message AS 'Description'
		FROM	(
			SELECT	CommServUniqueId, CommCellID, CommServIP, CommServGUID, DisplayName, ErrorCode, Message, SUM(Frequency) AS Frequency
			FROM	cf_SurveyRestoreErrorStats AS A WITH (NOLOCK)
				INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) B
					ON B.SurverResultId = A.SurveyResultId
			GROUP BY CommServUniqueId, CommCellID, CommServIP, CommServGUID, DisplayName, ErrorCode, Message) R
		ORDER BY R.Frequency DESC
	ELSE
		SELECT
			R.CommServUniqueId AS 'CommServ UniqueId',
			S.ErrorCode AS 'Error Code',
			S.Frequency AS 'No of Failed Restores',
			S.Message AS 'Description'
		FROM	cf_SurveyRestoreErrorStats AS S WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) AS R
				ON R.SurverResultId = S.SurveyResultId
		ORDER BY S.Frequency DESC
END
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0
  DECLARE @blLatestSurvey INT			= 1
  DECLARE @i_CommServUniqueID INT		= 11065
  DECLARE @i_LogDateEND DATETIME		= 	NULL    -- getDate()
  DECLARE @i_LogDateStart DATETIME		= NULL   --DateAdd(Month, -36, @i_LogDateEND)
exec RptRestoreStatus @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND
*/

IF EXISTS (select * from GxQscripts where name = 'RptRestoreStatus')
	delete from GxQscripts where name = 'RptRestoreStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptRestoreStatus')
	delete from GXDBVersions where aliasname = 'RptRestoreStatus'
GO

insert into GXDBVersions values(2, 'RptRestoreStatus',  '00010006004000030000', 'RptRestoreStatus', '00010006004000030000')
GO

