

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptSlowestClients.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptSlowestClients.sp,v $ $Id: RptSlowestClients.sp,v 1.9.44.4 2020/04/29 23:45:22 nbirru Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptSlowestClients')
BEGIN
	print '>>> Drop Stored Procedure: RptSlowestClients <<<'
	drop procedure RptSlowestClients
END
IF EXISTS (select * from GxQscripts where name='RptSlowestClients')
	delete from GxQscripts where name = 'RptSlowestClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSlowestClients')
	delete from GXDBVersions where aliasname = 'RptSlowestClients'
GO
print '... Creating Procedure: RptSlowestClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptSlowestClients
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll,
  @i_TenantName NVARCHAR(255) = NULL
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 251
IF object_id('tempdb.dbo.#TenantClients') IS NOT NULL DROP TABLE #TenantClients
CREATE TABLE #TenantClients (CommServUniqueId INT, TenantName NVARCHAR(255), ClientId INT)
exec GetTenantEntities @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND, @i_TenantName
SET @i_QueryId = 44
IF(@blaggregate=1)
BEGIN
		SELECT
			sub.ThroughputMBS AS 'Throughput(MB/sec)',
			COUNT (sub.clientId) AS 'No of Clients<FORMATNUMBERNA>',
			SUM (sub.NumberOfJobs) AS 'No of Jobs<FORMATNUMBERNA>'
		FROM
			(
				SELECT DISTINCT
					csInfo.CommServUniqueId,
					csInfo.LogDate,
					csInfo.clientId,
					CASE
					WHEN ThroughputMBS>=0.00 AND ThroughputMBS<10 then ' 0 - 10'
					WHEN ThroughputMBS>=10.00 AND ThroughputMBS<20 then ' 10 - 20'
					ELSE '20 and Above' end AS 'ThroughputMBS',
				csInfo.NumberOfJobs
			FROM cf_SurveySlowestClients AS csInfo WITH (NOLOCK)
				INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
					ON resultView.SurverResultId = csInfo.SurveyResultId
				LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                     ON csInfo.CommServUniqueId = TC.CommServUniqueId AND csInfo.ClientId = TC.ClientId
                WHERE ((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL)
			) AS sub
				GROUP BY sub.ThroughputMBS
				ORDER BY sub.ThroughputMBS
END
ELSE
BEGIN
IF @i_CommServUniqueID = 0
BEGIN
SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.DisplayName AS 'CommCell Name',
	ISNULL(CL.clientDisplayName, csInfo.clientName) AS 'Client',
	ISNULL(CAST((csInfo.AppSize/1024.0/1024.0) AS DECIMAL(20,2)),-1) AS 'Application Size<SIZEMB>',
	CAST(csInfo.ThroughputMBS AS DECIMAL(20, 2)) AS 'Throughput(MB/sec)',
	csInfo.NumberofJobs AS 'NumberofJobs<FORMATNUMBERNA>'
FROM cf_SurveySlowestClients AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
	LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                     ON csInfo.CommServUniqueId = TC.CommServUniqueId AND csInfo.ClientId = TC.ClientId
	LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = csInfo.CommServUniqueId AND CL.ClientId = csInfo.ClientId
WHERE ((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL)
ORDER BY resultView.DisplayName, csInfo.ThroughputMBS
END
ELSE
SELECT
	ISNULL(CL.clientDisplayName, csInfo.clientName) AS 'Client',
	CAST(csInfo.ThroughputMBS AS DECIMAL(20, 2)) AS 'Throughput(MB/sec)',
	ISNULL(CAST((csInfo.AppSize/1024.0/1024.0) AS DECIMAL(20,2)),-1) AS 'Application Size<SIZEMB>',
	csInfo.NumberofJobs AS 'NumberofJobs<FORMATNUMBERNA>'
FROM cf_SurveySlowestClients AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
	LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                     ON csInfo.CommServUniqueId = TC.CommServUniqueId AND csInfo.ClientId = TC.ClientId
	LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = csInfo.CommServUniqueId AND CL.ClientId = csInfo.ClientId
WHERE ((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL)
ORDER BY csInfo.ThroughputMBS
END
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0
  DECLARE @blLatestSurvey INT			= 1
  DECLARE @i_CommServUniqueID INT		= 10035
  DECLARE @i_LogDateEND DATETIME		= 	NULL    -- getDate()
  DECLARE @i_LogDateStart DATETIME		= NULL   --DateAdd(Month, -36, @i_LogDateEND)
exec RptSlowestClients @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND
*/

IF EXISTS (select * from GxQscripts where name = 'RptSlowestClients')
	delete from GxQscripts where name = 'RptSlowestClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSlowestClients')
	delete from GXDBVersions where aliasname = 'RptSlowestClients'
GO

insert into GXDBVersions values(2, 'RptSlowestClients',  '00010009004400040000', 'RptSlowestClients', '00010009004400040000')
GO

