

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptSubclientsNoRecentFull.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptSubclientsNoRecentFull.sp,v $ $Id: RptSubclientsNoRecentFull.sp,v 1.1.2.7 2020/12/17 02:50:17 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptSubclientsNoRecentFull')
BEGIN
	print '>>> Drop Stored Procedure: RptSubclientsNoRecentFull <<<'
	drop procedure RptSubclientsNoRecentFull
END
IF EXISTS (select * from GxQscripts where name='RptSubclientsNoRecentFull')
	delete from GxQscripts where name = 'RptSubclientsNoRecentFull'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSubclientsNoRecentFull')
	delete from GXDBVersions where aliasname = 'RptSubclientsNoRecentFull'
GO
print '... Creating Procedure: RptSubclientsNoRecentFull'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptSubclientsNoRecentFull
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll,
  @i_TopN INT = -1
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 207
IF OBJECT_ID('tempdb.dbo.#LatestResult') IS NOT NULL DROP TABLE #LatestResult
CREATE TABLE #LatestResult (CommServUniqueId INT, CommCellId VARCHAR(32), CommServIP VARCHAR(256), DisplayName NVARCHAR(256), SurveyResultId BIGINT, LogDate DATETIME)
INSERT	INTO #LatestResult
SELECT	CommServUniqueId, CommCellId, CommServIP, DisplayName, SurverResultId, LogDate
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
IF @blaggregate = 0
BEGIN
	SELECT
		R.CommServUniqueId  AS 'CommServ UniqueId<DONOTSHOW>',
		R.CommCellID AS 'CommCell ID<HIDDEN>',
		R.CommServIP AS 'CommServe IP<HIDDEN>',
		R.DisplayName AS 'CommCell Name',
		ISNULL(CL.clientDisplayName, S.ClientName) AS 'Client',
		AT.shortName AS 'Agent Type',
		S.InstanceName AS 'Instance',
		S.BackupsetName AS 'Backupset',
		S.SubclientName AS 'Subclient',
		T.LastFullStart AS 'Last Full Start',
		T.LastFullAppSize/1024/1024 AS 'Last Full App Size<SIZEMB>',
		T.IncrJobsAppSize/1024/1024 AS 'Incr Jobs App Size<SIZEMB>',
		T.NumOfIncrJobs AS 'Number of Incr Jobs',
		C.PolicyName AS 'Storage Policy',
		CASE WHEN AT.IsDMAppType = 1 THEN C.ArchiverRetDays ELSE C.RetentionDays END AS 'Primary Retention Days<HIDDEN>',
		ISNULL(C.DefaultLibrary, '') AS 'Default Library'
	FROM #LatestResult R
		INNER JOIN cf_SurveySubclientsNoRecentFull T ON R.SurveyResultId = T.SurveyResultId
		INNER JOIN cf_SurveySubclientAssociation S ON R.CommservUniqueId = S.CommservUniqueId AND T.AppId = S.AppId AND S.Deleted = 0 AND S.BackupDisabled =0
		INNER JOIN cf_SurveyCopyBasicRetention C ON R.CommservUniqueId = C.CommservUniqueId AND T.ArchGrpId = C.PolicyId
			AND C.IsDefaultCopy = 1 AND C.IsSnapCopy = 0 AND C.Deleted = 0
		INNER JOIN cf_SurveyAgentType AT ON S.AppTypeId = AT.id
		LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = S.CommServUniqueId AND CL.ClientId = S.ClientId
	ORDER BY T.NumOfIncrJobs DESC
END
DROP TABLE #LatestResult
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0
  DECLARE @blLatestSurvey INT			= 1
  DECLARE @i_CommServUniqueID INT		= 11065
  DECLARE @i_LogDateEND DATETIME		= 	NULL    -- getDate()
  DECLARE @i_LogDateStart DATETIME		= NULL   --DateAdd(Month, -36, @i_LogDateEND)
  DECLARE @i_TopN INT					= -1
exec RptSubclientsNoRecentFull @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND, @i_TopN
*/

IF EXISTS (select * from GxQscripts where name = 'RptSubclientsNoRecentFull')
	delete from GxQscripts where name = 'RptSubclientsNoRecentFull'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSubclientsNoRecentFull')
	delete from GXDBVersions where aliasname = 'RptSubclientsNoRecentFull'
GO

insert into GXDBVersions values(2, 'RptSubclientsNoRecentFull',  '00010001000200070000', 'RptSubclientsNoRecentFull', '00010001000200070000')
GO

