

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptSurveyCloudConnector.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptSurveyCloudConnector.sp,v $ $Id: RptSurveyCloudConnector.sp,v 1.5 2015/03/17 17:56:32 pushpendrasingh Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptSurveyCloudConnector <<<'

IF EXISTS (select * from sysobjects where name='RptSurveyCloudConnector')
	drop procedure RptSurveyCloudConnector
IF EXISTS (select * from GxQscripts where name='RptSurveyCloudConnector')
	delete from GxQscripts where name = 'RptSurveyCloudConnector'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSurveyCloudConnector')
	delete from GXDBVersions where aliasname = 'RptSurveyCloudConnector'
GO
print '... Creating Procedure: RptSurveyCloudConnector'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptSurveyCloudConnector
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
DECLARE @i_QueryId BIGINT = 62
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
IF(@blaggregate=1)
BEGIN
SELECT
	--resultView.CommServUniqueId  AS 'CommServ UniqueId',
	--resultView.CommCellID AS 'CommCell ID',
	--resultView.CommServIP AS 'CommServer IP',
	--resultView.CommServGUID AS 'CommServer GUID',
	--ISNULL((CONVERT(VARCHAR(20), csInfo.LogDate, 100) + ' (' + resultView.CommServTimeZone + ')'), 'N/A') AS 'Collection Time',
	--CASE
	--	WHEN resultView.RunningTime = -1 THEN 'N/A'
	--	ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
	--END AS 'Running Time in Seconds',
	--csInfo.ClientId AS 'Client Id',
	csInfo.CloudConnector AS 'Cloud Connector Type',
	SUM(csInfo.DataStored) AS 'Data Stored <SIZEMB>',
	count(*) as 'Number of Commcells'
FROM cf_SurveyCloudConnector AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
		AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
		AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
		group by csInfo.CloudConnector
ORDER BY  csInfo.CloudConnector ASC
RETURN
end
ELSE
BEGIN
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	--resultView.CommServIP AS 'CommServer IP',
	--resultView.CommServGUID AS 'CommServer GUID',
	CASE
		WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
		ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
	END AS 'CommCell Name',
	--ISNULL((CONVERT(VARCHAR(20), csInfo.LogDate, 100) + ' (' + resultView.CommServTimeZone + ')'), 'N/A') AS 'Collection Time',
	--CASE
	--	WHEN resultView.RunningTime = -1 THEN 'N/A'
	--	ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
	--END AS 'Running Time in Seconds',
	--csInfo.ClientId AS 'Client Id',
	csInfo.CloudConnector AS 'Cloud Connector Type',
	csInfo.DataStored AS 'Data Stored <SIZEMB>'
FROM cf_SurveyCloudConnector AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
		AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
		AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
ORDER BY csInfo.LogDate DESC, csInfo.CloudConnector ASC
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptSurveyCloudConnector')
	delete from GxQscripts where name = 'RptSurveyCloudConnector'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSurveyCloudConnector')
	delete from GXDBVersions where aliasname = 'RptSurveyCloudConnector'
GO

insert into GXDBVersions values(2, 'RptSurveyCloudConnector',  '00010005000000000000', 'RptSurveyCloudConnector', '00010005000000000000')
GO

