

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptSurveyDDBPendingDelete.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptSurveyDDBPendingDelete.sp,v $ $Id: RptSurveyDDBPendingDelete.sp,v 1.5.42.6 2017/08/24 10:33:16 bheemesh Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptSurveyDDBPendingDelete <<<'

IF EXISTS (select * from sysobjects where name='RptSurveyDDBPendingDelete')
	drop procedure RptSurveyDDBPendingDelete
IF EXISTS (select * from GxQscripts where name='RptSurveyDDBPendingDelete')
	delete from GxQscripts where name = 'RptSurveyDDBPendingDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSurveyDDBPendingDelete')
	delete from GXDBVersions where aliasname = 'RptSurveyDDBPendingDelete'
GO
print '... Creating Procedure: RptSurveyDDBPendingDelete'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptSurveyDDBPendingDelete
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
BEGIN
DECLARE @i_QueryId BIGINT = 65
DECLARE @i_secQueryId BIGINT = 35
DECLARE @i_HealthParamQueryId BIGINT = 156
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
IF(@blaggregate=1)
BEGIN
RETURN
end
ELSE
DECLARE @strGood VARCHAR(10) = '1_Good'
	DECLARE @strInfo VARCHAR(10) = '2_Info'
	DECLARE @strwarning VARCHAR(10) = '3_Warning'
	DECLARE @strCritical VARCHAR(10) = '4_Critical'
	DECLARE @criticalVal int
	DECLARE @warningVal int
		SELECT	@warningVal = WarningThreshold,
				@criticalVal =CriticalThreshold
		FROM	cf_SurveyHealthParam where queryId = @i_HealthParamQueryId
	DECLARE @criticalAFVal int = 10000
	DECLARE @warningAFVal int  = 5000
IF object_id('tempdb.dbo.#secQueryTable') IS NOT null DROP TABLE #secQueryTable
CREATE TABLE #secQueryTable(
	CommServUniqueId				INT,
	SIDBStoreId						INT,
	SealedOrNot						nvarchar(max) ,
	DeletedAFCount					bigint NULL,
	SevenDaysOldMMDeletedAFtable	BIGINT NULL
)
INSERT INTO #secQueryTable (CommServUniqueId,SIDBStoreId,SealedOrNot,DeletedAFCount,SevenDaysOldMMDeletedAFtable)
SELECT DISTINCT resultView.CommServUniqueId,DD.SIDBStoreId,SealedOrNot,DeletedAFCount,SevenDaysOldMMDeletedAFtable FROM cf_SurveyDeDupDeletedAFCount DD WITH (NOLOCK)
				INNER JOIN dbo.cf_SurveyResultFuncV1(@i_secQueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.SurverResultId=DD.SurveyResultId
IF @i_CommServUniqueID = 0
BEGIN
SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.DisplayName AS 'CommCell Name',
	csInfo.SidbStoreName AS 'Store name',
	CASE WHEN csInfo.CreatedTime < '1970/01/01' THEN -100
		ELSE datediff(second,'1970/01/01',csInfo.CreatedTime) END AS 'Created Time<HIDDEN><MMMDDYYYYHrMinAM>',
	AF.SealedOrNot AS 'Store Status',
	AF.DeletedAFCount AS 'CommServe Job Records to be Deleted<FORMATNUMBERNA>',
	AF.SevenDaysOldMMDeletedAFtable AS 'CommServe Job Records older than 7 Days to be Deleted<FORMATNUMBERNA>',
	csInfo.ZeroRefCount AS 'DDB Prunable Block Count<FORMATNUMBERNA>',
	csInfo.PrimaryRecords AS 'DDB Primary Block Count<FORMATNUMBERNA>',
	CASE WHEN csInfo.PrimaryRecords <= 0 THEN 0
		 ELSE CAST(((csInfo.ZeroRefCount* 100.0)/(csInfo.ZeroRefCount+csInfo.PrimaryRecords) ) AS DECIMAL(10,1)) END AS 'DDB Prunable Blocks Percentage<percentNA>',
	CASE WHEN csInfo.PrimaryRecords <= 0 THEN @strGood
		 ELSE
		(CASE WHEN AF.SevenDaysOldMMDeletedAFtable > ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND CommServUniqueId =csInfo.CommServUniqueID  AND attrName ='DDBPendingDeleteCriticalLimit' and attrtype =10),@criticalAFVal) OR ((csInfo.ZeroRefCount* 100.0)/(csInfo.ZeroRefCount+csInfo.PrimaryRecords) ) > @criticalVal
				THEN @strCritical
			 WHEN AF.SevenDaysOldMMDeletedAFtable BETWEEN ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND CommServUniqueId =csInfo.CommServUniqueID  AND attrName ='DDBPendingDeleteWarningLimit' and attrtype =10),@warningAFVal) AND ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND CommServUniqueId =csInfo.CommServUniqueID  AND attrName ='DDBPendingDeleteCriticalLimit' and attrtype =10),@criticalAFVal) OR ((csInfo.ZeroRefCount* 100.0)/(csInfo.ZeroRefCount+csInfo.PrimaryRecords) ) BETWEEN @warningVal AND @criticalVal
				THEN @strWarning
			 ELSE @strGood
			 END)
	END AS 'Status<HEALTH_STATUS>',
	ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND CommServUniqueId =csInfo.CommServUniqueID  AND attrName ='DDBPendingDeleteCriticalLimit' and attrtype =10),@criticalAFVal)  AS 'Critical Threshold for CommServe Job Records older than 7 Days to be Deleted <HIDDEN>',
	ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND CommServUniqueId =csInfo.CommServUniqueID  AND attrName ='DDBPendingDeleteWarningLimit' and attrtype =10),@warningAFVal)  AS 'Warning Threshold for CommServe Job Records older than 7 Days to be Deleted <HIDDEN>'
FROM cf_SurveyDDBPerformance AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
	INNER JOIN #secQueryTable AS AF
		ON csInfo.SidbStoreId = AF.SIDBStoreId
		AND csinfo.CommServUniqueId = AF.CommServUniqueId
ORDER BY resultView.CustomerName, [Status<HEALTH_STATUS>] DESC, csInfo.ZeroRefCount DESC
END
ELSE
BEGIN
SELECT
	csInfo.SidbStoreName AS 'Store name',
	CASE WHEN csInfo.CreatedTime < '1970/01/01' THEN -100
		ELSE datediff(second,'1970/01/01',csInfo.CreatedTime) END AS 'Created Time<HIDDEN><MMMDDYYYYHrMinAM>',
	AF.SealedOrNot AS 'Store Status',
	AF.DeletedAFCount AS 'CommServe Job Records to be Deleted<FORMATNUMBERNA>',
	AF.SevenDaysOldMMDeletedAFtable AS 'CommServe Job Records older than 7 Days to be Deleted<FORMATNUMBERNA>',
	csInfo.ZeroRefCount AS 'DDB Prunable Block Count<FORMATNUMBERNA>',
	csInfo.PrimaryRecords AS 'DDB Primary Block Count<FORMATNUMBERNA>',
	CASE WHEN csInfo.PrimaryRecords <= 0 THEN 0
		 ELSE CAST(((csInfo.ZeroRefCount* 100.0)/(csInfo.ZeroRefCount+csInfo.PrimaryRecords) ) AS DECIMAL(10,1)) END AS 'DDB Prunable Blocks Percentage<percentNA>',
	CASE WHEN csInfo.PrimaryRecords <= 0 THEN @strGood
		 ELSE
		(CASE WHEN AF.SevenDaysOldMMDeletedAFtable > ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND CommServUniqueId =csInfo.CommServUniqueID  AND attrName ='DDBPendingDeleteCriticalLimit' and attrtype =10),@criticalAFVal) OR ((csInfo.ZeroRefCount* 100.0)/(csInfo.ZeroRefCount+csInfo.PrimaryRecords) ) > @criticalVal
				THEN @strCritical
			 WHEN AF.SevenDaysOldMMDeletedAFtable BETWEEN ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND CommServUniqueId =csInfo.CommServUniqueID  AND attrName ='DDBPendingDeleteWarningLimit' and attrtype =10),@warningAFVal) AND ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND CommServUniqueId =csInfo.CommServUniqueID  AND attrName ='DDBPendingDeleteCriticalLimit' and attrtype =10),@criticalAFVal) OR ((csInfo.ZeroRefCount* 100.0)/(csInfo.ZeroRefCount+csInfo.PrimaryRecords) ) BETWEEN @warningVal AND @criticalVal
				THEN @strWarning
			 ELSE @strGood
			 END)
	END AS 'Status<HEALTH_STATUS>',
	ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND CommServUniqueId =csInfo.CommServUniqueID  AND attrName ='DDBPendingDeleteCriticalLimit' and attrtype =10),@criticalAFVal)  AS 'Critical Threshold for CommServe Job Records older than 7 Days to be Deleted <HIDDEN>',
	ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND CommServUniqueId =csInfo.CommServUniqueID  AND attrName ='DDBPendingDeleteWarningLimit' and attrtype =10),@warningAFVal)  AS 'Warning Threshold for CommServe Job Records older than 7 Days to be Deleted <HIDDEN>'
FROM cf_SurveyDDBPerformance AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
	INNER JOIN #secQueryTable AS AF
		ON csInfo.SidbStoreId = AF.SIDBStoreId
		AND csinfo.CommServUniqueId = AF.CommServUniqueId
ORDER BY  [Status<HEALTH_STATUS>] DESC,csInfo.ZeroRefCount DESC
END
DROP TABLE #secQueryTable
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'RptSurveyDDBPendingDelete')
	delete from GxQscripts where name = 'RptSurveyDDBPendingDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSurveyDDBPendingDelete')
	delete from GXDBVersions where aliasname = 'RptSurveyDDBPendingDelete'
GO

insert into GXDBVersions values(2, 'RptSurveyDDBPendingDelete',  '00010005004200060000', 'RptSurveyDDBPendingDelete', '00010005004200060000')
GO

