

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptTapeLibraryUsage.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptTapeLibraryUsage.sp,v $ $Id: RptTapeLibraryUsage.sp,v 1.1.2.9 2020/12/17 02:50:53 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptTapeLibraryUsage')
BEGIN
	print '>>> Drop Stored Procedure: RptTapeLibraryUsage <<<'
	drop procedure RptTapeLibraryUsage
END
IF EXISTS (select * from GxQscripts where name='RptTapeLibraryUsage')
	delete from GxQscripts where name = 'RptTapeLibraryUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptTapeLibraryUsage')
	delete from GXDBVersions where aliasname = 'RptTapeLibraryUsage'
GO
print '... Creating Procedure: RptTapeLibraryUsage'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptTapeLibraryUsage
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NULL
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 186
DECLARE @strGood VARCHAR(10) = '1_Good'
DECLARE @strInfo VARCHAR(10) = '2_Info'
DECLARE @strwarning VARCHAR(10) = '3_Warning'
DECLARE @strCritical VARCHAR(10) = '4_Critical'
DECLARE @strUnknown VARCHAR(10) = '0_Unknown'
DECLARE @criticalThreshold int
DECLARE @warningThreshold int
SELECT	@warningThreshold = WarningThreshold,
		@criticalThreshold =CriticalThreshold
FROM	cf_SurveyHealthParam where queryId = @i_QueryId
DECLARE @showHiddenLibraries INT = 0
IF EXISTS (SELECT TOP 1 1 FROM cf_SurveyConfig WHERE name = 'showHiddenLibraries' AND value = '1')
	SET @showHiddenLibraries = 1
IF(@blaggregate=1)
	RETURN
--Never value should be lower than (N/A), to get sorting like Date->Never->N/A order
DECLARE @Never  BIGINT= CAST(0x7FFFFFFFFF AS bigint)-1
DECLARE @NA  BIGINT =CAST(0x7FFFFFFFFF AS bigint)
DECLARE @CurrMonth DATE = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)
DECLARE	@MaxNumOfMonthsforGrowthRate INT = 6
DECLARE @FirstMonth DATE = DATEADD(MONTH, -@MaxNumOfMonthsforGrowthRate, @CurrMonth)
CREATE TABLE #Results (ResultId BIGINT, CommservUniqueId INT, CommCellID VARCHAR(32), CommServName NVARCHAR(256), DisplayName NVARCHAR(256), LogDateUTC DATETIME)
INSERT	INTO #Results
SELECT	SurverResultId, CommservUniqueId, CommCellID, CommServName, DisplayName, LogDateUTC
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId)
CREATE TABLE #Summary (CommservUniqueId INT, LibraryId INT, TotalSpaceMB BIGINT, UsedSpaceMB BIGINT,
		AppSizeMB BIGINT, DataWrittenMB BIGINT, UsedTapeCount INT, SpareTapeCount INT,
		CurrMonthUsedTapes INT, PrevMonthUsedTapes INT, Pre2MonthUsedTapes INT,
		MonthlyGrowth FLOAT, StDevGrowth FLOAT, DaysToBeFull INT, MinDaysToBeFull INT, MaxDaysToBeFull INT)
INSERT	INTO #Summary
SELECT	R.CommservUniqueId, L.LibraryId, L.TotalSpaceMB, L.UsedSpaceMB, L.AppSizeMB, L.DataWrittenMB, L.UsedTapeCount, L.SpareTapeCount,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
FROM	cf_SurveyTapeUsageByLibrary L WITH (NOLOCK)
		INNER JOIN #Results R ON L.SurveyResultId = R.ResultId
		INNER JOIN cf_SurveyLibrary LP WITH(NOLOCK) ON R.CommServUniqueId = LP.CommservUniqueId AND L.LibraryId = LP.LibraryId AND (@showHiddenLibraries = 1 OR LP.Hidden = 0)
CREATE TABLE #GrowthData (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(MAX), X INT, Y FLOAT, SeqId INT) -- for input
CREATE TABLE #GrowthRate (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(MAX), GrowthRate FLOAT, GrowthStDev FLOAT) -- for output
INSERT	INTO #GrowthData
SELECT	S.CommservUniqueId, S.LibraryId, '', DATEDIFF(MONTH, @CurrMonth, S.MonthStart), S.UsedTapeCount,
		ROW_NUMBER() OVER (PARTITION BY S.CommservUniqueId, S.LibraryId ORDER BY S.MonthStart)
FROM	cf_SurveyMonthlyTapeUsageByLibrary S
		INNER JOIN #Summary T ON S.CommservUniqueId = T.CommservUniqueId AND S.LibraryId = T.LibraryId
WHERE	S.MonthStart >= @FirstMonth
UPDATE	#Summary SET CurrMonthUsedTapes = F.Y
FROM	#GrowthData F
WHERE	#Summary.CommservUniqueId = F.CommservUniqueId AND #Summary.LibraryId = F.EntityId
	AND F.X = 0 AND F.Y > 0
UPDATE	#Summary SET PrevMonthUsedTapes = F.Y
FROM	#GrowthData F
WHERE	#Summary.CommservUniqueId = F.CommservUniqueId AND #Summary.LibraryId = F.EntityId
	AND F.X = -1 AND F.Y > 0
UPDATE	#Summary SET Pre2MonthUsedTapes = F.Y
FROM	#GrowthData F
WHERE	#Summary.CommservUniqueId = F.CommservUniqueId AND #Summary.LibraryId = F.EntityId
	AND F.X = -2 AND F.Y > 0
EXEC GetLinearGrowthRate 0
UPDATE	S SET MonthlyGrowth = T.GrowthRate, StDevGrowth = T.GrowthStDev
FROM	#Summary S
		INNER JOIN #GrowthRate T ON S.CommservUniqueId = T.CommservUniqueId AND S.LibraryId = T.EntityId
DROP TABLE #GrowthData
DROP TABLE #GrowthRate
UPDATE	#Summary
SET		DaysToBeFull = CASE
			WHEN 30.0*SpareTapeCount > MonthlyGrowth*(DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) + 9999) THEN 10000
			ELSE 30.0*SpareTapeCount/MonthlyGrowth - DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) END
FROM	#Summary S INNER JOIN #Results R ON S.CommservUniqueId = R.CommservUniqueId
WHERE	ABS(ISNULL(MonthlyGrowth, 0)) > 0.001 AND SpareTapeCount > 0
UPDATE	#Summary
SET		MinDaysToBeFull = CASE
			WHEN 30.0*SpareTapeCount > (MonthlyGrowth+StDevGrowth)*(DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) + 9999) THEN 10000
			ELSE 30.0*SpareTapeCount/(MonthlyGrowth+StDevGrowth) - DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) END,
		MaxDaysToBeFull = CASE
			WHEN 30.0*SpareTapeCount > (MonthlyGrowth-StDevGrowth)*(DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) + 9999) THEN 10000
			ELSE 30.0*SpareTapeCount/(MonthlyGrowth-StDevGrowth) - DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) END
FROM	#Summary S INNER JOIN #Results R ON S.CommservUniqueId = R.CommservUniqueId
WHERE	DaysToBeFull BETWEEN 1 AND 9999 AND StDevGrowth > 0
IF(@i_CommServUniqueID = 0)
BEGIN
	SELECT
		R.CommServUniqueId		AS 'CommServ UniqueId',
		R.DisplayName			AS 'CommCell Name',
		R.CommCellID			AS 'CommCell ID',
		L.LibraryName			AS 'Library',
		TotalSpaceMB			AS 'Capacity<SIZEMB>',
		UsedSpaceMB				AS 'Used Space<SIZEMB>',
		(TotalSpaceMB - UsedSpaceMB) AS 'Free Space<SIZEMB>',
		AppSizeMB				AS 'App Size<SIZEMB>',
		DataWrittenMB			AS 'Data Written<SIZEMB>',
		UsedTapeCount			AS 'Used Tapes',
		SpareTapeCount			AS 'Spare Tapes',
		CASE WHEN ISNULL(DaysToBeFull, -1) < 0 THEN @NA -- For N/A
			 WHEN DaysToBeFull > 9999 THEN @Never -- For Never
		     ELSE dbo.getUnixtimebig(DATEADD(DAY, DaysToBeFull, GETUTCDATE()))
		END AS 'Date to be Full<MMMDDYYYYNEVER>',
		CASE WHEN ISNULL(DaysToBeFull, -1) NOT BETWEEN 1 AND 9999 OR ISNULL(MaxDaysToBeFull, -1) NOT BETWEEN 1 AND 9999 THEN 'N/A'
			 WHEN MinDaysToBeFull < MAXDaysToBeFull
			 THEN CONVERT(VARCHAR(12), DATEADD(DAY, MinDaysToBeFull, GETUTCDATE()), 107) + ' - ' + CONVERT(VARCHAR(12), DATEADD(DAY, MaxDaysToBeFull, GETUTCDATE()), 107)
		     ELSE CONVERT(VARCHAR(12), DATEADD(DAY, MaxDaysToBeFull, GETUTCDATE()), 107) + ' - ' + CONVERT(VARCHAR(12), DATEADD(DAY, MinDaysToBeFull, GETUTCDATE()), 107)
		END AS 'Range of Date to be Full<HIDDEN>',
		CASE WHEN ISNULL(Pre2MonthUsedTapes, 0) = 0 OR ISNULL(PrevMonthUsedTapes, 0) = 0 THEN NULL
				ELSE (PrevMonthUsedTapes-Pre2MonthUsedTapes)
		END AS 'Previous Month Change<DifferenceNA><HIDDEN>',
		CASE WHEN ISNULL(Pre2MonthUsedTapes, 0) = 0 OR ISNULL(PrevMonthUsedTapes, 0) = 0 THEN NULL
				ELSE CAST(1.0*(PrevMonthUsedTapes-Pre2MonthUsedTapes)/(0.01*Pre2MonthUsedTapes) AS DECIMAL(30, 2))
		END AS 'Previous Month Change (%)<DifferenceNA><HIDDEN>',
		CASE WHEN ISNULL(PrevMonthUsedTapes, 0) = 0 OR ISNULL(CurrMonthUsedTapes, 0) = 0 THEN NULL
				ELSE (CurrMonthUsedTapes-PrevMonthUsedTapes)
		END AS 'Current Month Change<DifferenceNA>',
		CASE WHEN ISNULL(PrevMonthUsedTapes, 0) = 0 OR ISNULL(CurrMonthUsedTapes, 0) = 0 THEN NULL
				ELSE CAST(1.0*(CurrMonthUsedTapes-PrevMonthUsedTapes)/(0.01*PrevMonthUsedTapes) AS DECIMAL(30, 2))
		END AS 'Current Month Change (%)<DifferenceNA>',
		CAST(MonthlyGrowth*6  AS BIGINT) AS  '6 Month Growth<DifferenceNA><HIDDEN>',
		CAST(MonthlyGrowth*12 AS BIGINT) AS '12 Month Growth<DifferenceNA><HIDDEN>',
		CAST(MonthlyGrowth*18 AS BIGINT) AS '18 Month Growth<DifferenceNA><HIDDEN>',
		CASE WHEN UsedTapeCount  = 0 AND SpareTapeCount = 0 THEN @strInfo
			 WHEN ISNULL(MonthlyGrowth, -1) <= 0 OR ISNULL(DaysToBeFull, -1) = -1 THEN @strGood
			 WHEN DaysToBeFull <  @criticalThreshold THEN @strCritical
			 WHEN DaysToBeFull >= @criticalThreshold AND DaysToBeFull <= @warningThreshold THEN @strwarning
			 ELSE @strGood
		END AS 'Status<HEALTH_STATUS>'
	FROM #Summary S INNER JOIN #Results R ON S.CommServUniqueId = R.CommServUniqueId
			INNER JOIN cf_SurveyLibrary L ON S.CommservUniqueId = L.CommservUniqueId AND S.LibraryId = L.LibraryId AND L.Deleted = 0
	ORDER BY [Status<HEALTH_STATUS>] DESC,'Date to be Full<MMMDDYYYYNEVER>' ASC
END
ELSE
BEGIN
	SELECT
		R.CommServName			AS 'CommCell Name',
		L.LibraryName			AS 'Library',
		TotalSpaceMB			AS 'Capacity<SIZEMB>',
		UsedSpaceMB				AS 'Used Space<SIZEMB>',
		(TotalSpaceMB - UsedSpaceMB) AS 'Free Space<SIZEMB>',
		AppSizeMB				AS 'App Size<SIZEMB>',
		DataWrittenMB			AS 'Data Written<SIZEMB>',
		UsedTapeCount			AS 'Used Tapes',
		SpareTapeCount			AS 'Spare Tapes',
		CASE WHEN ISNULL(DaysToBeFull, -1) < 0 THEN @NA -- For N/A
			 WHEN DaysToBeFull > 9999 THEN @Never -- For Never
		     ELSE dbo.getUnixtimebig(DATEADD(DAY, DaysToBeFull, GETUTCDATE()))
		END AS 'Date to be Full<MMMDDYYYYNEVER>',
		CASE WHEN ISNULL(DaysToBeFull, -1) NOT BETWEEN 1 AND 9999 OR ISNULL(MaxDaysToBeFull, -1) NOT BETWEEN 1 AND 9999 THEN 'N/A'
			 WHEN MinDaysToBeFull < MAXDaysToBeFull
			 THEN CONVERT(VARCHAR(12), DATEADD(DAY, MinDaysToBeFull, GETUTCDATE()), 107) + ' - ' + CONVERT(VARCHAR(12), DATEADD(DAY, MaxDaysToBeFull, GETUTCDATE()), 107)
		     ELSE CONVERT(VARCHAR(12), DATEADD(DAY, MaxDaysToBeFull, GETUTCDATE()), 107) + ' - ' + CONVERT(VARCHAR(12), DATEADD(DAY, MinDaysToBeFull, GETUTCDATE()), 107)
		END AS 'Range of Date to be Full<HIDDEN>',
		CASE WHEN ISNULL(Pre2MonthUsedTapes, 0) = 0 OR ISNULL(PrevMonthUsedTapes, 0) = 0 THEN NULL
				ELSE (PrevMonthUsedTapes-Pre2MonthUsedTapes)
		END AS 'Previous Month Change<DifferenceNA><HIDDEN>',
		CASE WHEN ISNULL(Pre2MonthUsedTapes, 0) = 0 OR ISNULL(PrevMonthUsedTapes, 0) = 0 THEN NULL
				ELSE CAST(1.0*(PrevMonthUsedTapes-Pre2MonthUsedTapes)/(0.01*Pre2MonthUsedTapes) AS DECIMAL(30, 2))
		END AS 'Previous Month Change (%)<DifferenceNA><HIDDEN>',
		CASE WHEN ISNULL(PrevMonthUsedTapes, 0) = 0 OR ISNULL(CurrMonthUsedTapes, 0) = 0 THEN NULL
				ELSE (CurrMonthUsedTapes-PrevMonthUsedTapes)
		END AS 'Current Month Change<DifferenceNA>',
		CASE WHEN ISNULL(PrevMonthUsedTapes, 0) = 0 OR ISNULL(CurrMonthUsedTapes, 0) = 0 THEN NULL
				ELSE CAST(1.0*(CurrMonthUsedTapes-PrevMonthUsedTapes)/(0.01*PrevMonthUsedTapes) AS DECIMAL(30, 2))
		END AS 'Current Month Change (%)<DifferenceNA>',
		CAST(MonthlyGrowth*6  AS BIGINT) AS  '6 Month Growth<DifferenceNA><HIDDEN>',
		CAST(MonthlyGrowth*12 AS BIGINT) AS '12 Month Growth<DifferenceNA><HIDDEN>',
		CAST(MonthlyGrowth*18 AS BIGINT) AS '18 Month Growth<DifferenceNA><HIDDEN>',
		CASE WHEN UsedTapeCount  = 0 AND SpareTapeCount = 0 THEN @strInfo
			 WHEN ISNULL(MonthlyGrowth, -1) <= 0 OR ISNULL(DaysToBeFull, -1) = -1 THEN @strGood
			 WHEN DaysToBeFull <  @criticalThreshold THEN @strCritical
			 WHEN DaysToBeFull >= @criticalThreshold AND DaysToBeFull <= @warningThreshold THEN @strwarning
			 ELSE @strGood
		END AS 'Status<HEALTH_STATUS>'
	FROM #Summary S INNER JOIN #Results R ON S.CommServUniqueId = R.CommServUniqueId
			INNER JOIN cf_SurveyLibrary L ON S.CommservUniqueId = L.CommservUniqueId AND S.LibraryId = L.LibraryId AND L.Deleted = 0
	ORDER BY [Status<HEALTH_STATUS>] DESC,'Date to be Full<MMMDDYYYYNEVER>' ASC
END
DROP TABLE #Results
DROP TABLE #Summary
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptTapeLibraryUsage')
	delete from GxQscripts where name = 'RptTapeLibraryUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptTapeLibraryUsage')
	delete from GXDBVersions where aliasname = 'RptTapeLibraryUsage'
GO

insert into GXDBVersions values(2, 'RptTapeLibraryUsage',  '00010001000200090000', 'RptTapeLibraryUsage', '00010001000200090000')
GO

