

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptUpdateInfoSurvey.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptUpdateInfoSurvey.sp,v $ $Id: RptUpdateInfoSurvey.sp,v 1.34.2.59.14.2 2021/02/24 02:55:05 nbirru Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptUpdateInfoSurvey')
BEGIN
	print '>>> Drop Stored Procedure: RptUpdateInfoSurvey <<<'
	drop procedure RptUpdateInfoSurvey
END
IF EXISTS (select * from GxQscripts where name='RptUpdateInfoSurvey')
	delete from GxQscripts where name = 'RptUpdateInfoSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptUpdateInfoSurvey')
	delete from GXDBVersions where aliasname = 'RptUpdateInfoSurvey'
GO
print '... Creating Procedure: RptUpdateInfoSurvey'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptUpdateInfoSurvey
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll,
  @i_SLADays INT = 30
AS
IF (@blaggregate = 1 AND @blLatestSurvey = 0 AND @i_CommServUniqueID <> 0)
	RETURN
	SET NOCOUNT ON
	if object_id('tempdb.dbo.#tempFinalResult') is not null
		drop table #tempFinalResult
	if object_id('tempdb.dbo.#tempUsedCapacity') is not null
		drop table #tempUsedCapacity
	if object_id('tempdb.dbo.#LastMonthJobCount') is not null
		drop table #LastMonthJobCount
	if object_id('tempdb.dbo.#tempClients') is not null
		drop table #tempClients
	if object_id('tempdb.dbo.#tempLicenseServer') is not null
		drop table #tempLicenseServer
DECLARE @i_QueryId BIGINT = 12
--SLA related
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig (NOLOCK) WHERE Name = 'isPrivate'
DECLARE @strGood VARCHAR(10) = '1_Good'
DECLARE @strInfo VARCHAR(10) = '2_Info'
DECLARE @strwarning VARCHAR(10) = '3_Warning'
DECLARE @strCritical VARCHAR(10) = '4_Critical'
--DECLARE @criticalVal int
--DECLARE @warningVal int
DECLARE @NA int = -50
DECLARE @CSDetails INT = 0 --Used for company listing
SELECT @CSDetails = CASE WHEN @blLatestSurvey & 4 = 4 THEN 1 ELSE 0 END
DECLARE @IncludeDisabled INT = 0
SET @IncludeDisabled = @blLatestSurvey & 2
SET @blLatestSurvey = @blLatestSurvey & 1
--SELECT	@warningVal = WarningThreshold,
--		@criticalVal =CriticalThreshold
--FROM	cf_SurveyHealthParam where queryId = 27
IF @blaggregate = 1
BEGIN
IF @blLatestSurvey = 1
BEGIN
	IF @i_CommServUniqueID = 0
	BEGIN
		SET @blLatestSurvey = @blLatestSurvey | @IncludeDisabled
		IF OBJECT_ID('tempdb.dbo.#tempResult') IS NOT NULL DROP TABLE #tempResult
		CREATE TABLE #tempResult (CommServVersion NVARCHAR(32),CommcellCount INT)
		INSERT INTO #tempResult
		SELECT
			sub.CommServVersion,
			COUNT(sub.CommServUniqueId) AS 'CommCell Count<FORMATNUMBERNA>'
		FROM
		(
			SELECT
				ccMap.CommServUniqueId,
				CAST(SP.Release AS VARCHAR(10)) + '.' + CAST(SP.ServicePack AS VARCHAR(10)) AS CommServVersion
			FROM dbo.cf_SurveyResultFuncV1(146, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS ccMap
				CROSS APPLY SplitVersionString(CommServVersion) SP
		) AS sub
		GROUP BY sub.CommServVersion
		DECLARE @RegisteredCommCells DECIMAL(10,2)
		SELECT @RegisteredCommCells = SUM(CommCellCount) from #tempResult
		SELECT
			sub.CommServVersion AS 'CommServe Version<ALTSORT>',
			dbo.GetServicePackSortRank(sub.CommServVersion) AS 'CommServe Version<SORTCOLUMN>',
			sub.CommcellCount AS 'CommCell Count<FORMATNUMBERNA>',
			CASE WHEN R.ServicePack % 4 = 0 AND R.ServicePack >= 16 AND R.Release > 10 THEN 1 WHEN rls.IsLTS IS NULL THEN 0 ELSE rls.IsLTS END AS 'Is LTS<DONOTSHOW>',
			CAST((sub.CommcellCount/@RegisteredCommCells)*100.0 AS DECIMAL(10, 2)) AS 'Percentage (%)<percentNA>'
		FROM #tempResult AS sub
		CROSS APPLY dbo.SplitVersionString(sub.CommServVersion) R
		LEFT OUTER JOIN cf_ReleaseUpdatePackInfo rls ON rls.releaseid = (R.Release+5) AND rls.ServicePack = R.ServicePack
		ORDER BY dbo.GetServicePackSortRank(sub.CommServVersion) DESC
		DROP TABLE #tempResult
	END
	ELSE --NOT @i_CommServUniqueID = 0
		SELECT
			CASE
				WHEN resultView.CommServVersion IS NULL THEN 'Not Found'
				ELSE LTRIM(RTRIM(SUBSTRING(resultView.CommServVersion, 0, CHARINDEX('(', resultView.CommServVersion)) + ' ' + SUBSTRING(resultView.CommServVersion, CHARINDEX(')', resultView.CommServVersion)+1, LEN(resultView.CommServVersion))))
			END AS 'Installed Version',
			ISNULL(csInfo.CSAddUpdates, '') AS 'Installed Additional Updates',
		    CASE  WHEN csInfo1.CacheSP IS NULL OR LEN(csInfo1.CacheSP)<1 THEN ''
			      ELSE '11.' + CAST(csInfo1.CacheSP AS VARCHAR(10))
			END AS 'Cache Version',
			ISNULL(csInfo1.CacheAddUpdates, '') AS 'Cache Additional Updates',
			CASE WHEN ISNULL(US.Total, 0) = 0 THEN 'No' ELSE 'Yes' END AS 'Missing Update',
			CASE WHEN ISNULL(US.Total, 0) = 0 THEN @strGood ELSE @strCritical END AS 'Status<HEALTH_STATUS>'
		FROM cf_SurveyUpdateInfo AS csInfo WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.SurverResultId = csInfo.SurveyResultId
			LEFT OUTER JOIN cf_SurveyUpdateCacheInfo AS csInfo1 WITH (NOLOCK)
				ON resultView.SurverResultId = csInfo1.SurveyResultId
				AND csInfo1.OSName = 'UPDATE_OS_WINDOWSX64'
			LEFT OUTER JOIN cf_SurveyUpdateStatus US WITH (NOLOCK)
				ON resultView.SurverResultId = US.SurveyResultId
				AND US.ClientTypeId = 0
END
ELSE --NOT @blLatestSurvey = 1
BEGIN
	SELECT
		COUNT(sub.CommServUniqueId) AS 'CommCell Count',
		CASE
			WHEN sub.CommServVersion IS NULL THEN 'Not Found'
			ELSE LTRIM(RTRIM(SUBSTRING(sub.CommServVersion, 0, CHARINDEX('(', sub.CommServVersion)) + ' ' + SUBSTRING(sub.CommServVersion, CHARINDEX(')', sub.CommServVersion)+1, LEN(sub.CommServVersion))))
		END AS 'Name',
		sub.LogDate AS 'X-Value',
		'DATE' AS 'X-Datatype',
		COUNT(sub.CommServUniqueId) AS 'Y-Value',
		'Count' AS 'Y-Datatype',
		' CommCell Count : ' + CAST(COUNT(sub.CommServUniqueId) AS NVARCHAR(25)) AS 'Label',
		1 AS 'ChartGroup'
	FROM
	(
		SELECT
			CONVERT(VARCHAR(10),resultView.LogDate,101) AS LogDate,
			ccMap.CommServUniqueId,
			ISNULL(resultView.CommServVersion,'Not Found') as CommServVersion ,
			ROW_NUMBER() OVER (PARTITION BY resultView.CommServVersion, DATEDIFF(d, 0, resultView.LogDate) ORDER BY resultView.CommServVersion, resultView.LogDate DESC) AS RowId
		FROM cf_SurveyUpdateInfo AS csInfo WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.SurverResultId = csInfo.SurveyResultId
			LEFT OUTER JOIN cf_SurveyUpdateCacheInfo AS csInfo1 WITH (NOLOCK)
				ON resultView.SurverResultId = csInfo1.SurveyResultId
				AND csInfo1.OSName = 'UPDATE_OS_WINDOWSX64'
			RIGHT OUTER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS ccMap
				ON csInfo.CommServUniqueId = ccMap.CommServUniqueId
	) AS sub
	WHERE sub.RowId = 1
	GROUP BY sub.CommServVersion, sub.LogDate
END
END
ELSE --IF @blaggregate = 0
BEGIN
IF (@i_CommServUniqueID = 0 OR @CSDetails = 1)
BEGIN
	IF (OBJECT_ID('tempdb.dbo.#CommServResults') IS NOT NULL)
        DROP TABLE #CommServResults
	CREATE TABLE #CommServResults (
		CommServUniqueId INT, CommCellID VARCHAR(32), CommServIP VARCHAR(256), CommServGUID VARCHAR(256), DisplayName NVARCHAR(256),
		CommServName NVARCHAR(256), CommServTimeZone VARCHAR(256), SurveyResultId BIGINT, LogDate DATETIME, LogDateUTC DATETIME,
		CommvaultCompleteEnabled INT
	)
	-- Capacity Usage and CommCell Details
	INSERT INTO #CommServResults
	SELECT  CommServUniqueId, CommCellID, CommServIP, CommServGUID, DisplayName, CommServName, CommServTimeZone, SurverResultId, LogDate, LogDateUTC, 0
	FROM    dbo.cf_SurveyResultFuncV1(1, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
	UPDATE  T SET CommvaultCompleteEnabled = -1
	FROM    #CommServResults T
			INNER JOIN Lic_LicenseInfo L WITH(NOLOCK)
				ON T.CommServUniqueId = L.CommServUniqueId AND L.LicType = 205
	UPDATE T SET CommvaultCompleteEnabled = 1
	FROM    #CommServResults T
			INNER JOIN Lic_LicenseInfo B WITH(NOLOCK)
				ON T.CommServUniqueId = B.CommServUniqueId AND B.LicType = 100002
			INNER JOIN Lic_LicenseInfo A WITH(NOLOCK)
				ON T.CommServUniqueId = A.CommServUniqueId AND A.LicType = 100004
	WHERE   T.CommvaultCompleteEnabled = -1
		AND B.PermTotal = A.PermTotal AND B.EvalTotal = A.EvalTotal AND B.TermDate = A.TermDate
	SET @blLatestSurvey = @blLatestSurvey | @IncludeDisabled
	DECLARE @LastMonthStart DATETIME = DATEADD(MM, DATEDIFF(MM,0,GETDATE())-1, 0)
	CREATE TABLE #tempUsedCapacity (CommServUniqueId INT, TotalCapacityMB BIGINT, UsedCapacityMB BIGINT)
	INSERT	INTO #tempUsedCapacity
	SELECT	R.CommServUniqueId,
			CASE WHEN CommvaultCompleteEnabled > 0 THEN SUM(U.TotalBackupSize) ELSE SUM(U.TotalBackupSize + U.TotalArchiveSize) END,
			CASE WHEN CommvaultCompleteEnabled > 0 THEN SUM(U.BackupSize) ELSE SUM(U.BackupSize + U.ArchiveSize) END
	FROM	dbo.cf_SurveyResultFuncV1(1, @i_CommServUniqueID, 1, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) AS R
			INNER JOIN cf_SurveyCapacityLicenseUsage U (NOLOCK) ON U.SurveyResultId = R.SurverResultId
			INNER JOIN #CommServResults AS results ON results.SurveyResultId = U.SurveyResultId
	GROUP BY R.CommServUniqueId, CommvaultCompleteEnabled
	IF (OBJECT_ID('tempdb.dbo.#CommServResults') IS NOT NULL)
        DROP TABLE #CommServResults
	CREATE CLUSTERED INDEX tempUsedCapacityIdx ON #tempUsedCapacity (CommServUniqueId)
	CREATE TABLE #LastMonthJobCount (CommServUniqueId INT, LastMonthJobs BIGINT)
	INSERT	INTO #LastMonthJobCount
	SELECT	J.CommServUniqueId, SUM(J.TotalJobs - J.SkippedJobs)
	FROM	dbo.cf_SurveyResultFuncV1(173, @i_CommServUniqueID, 1, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) AS R
			INNER JOIN cf_SurveyIDAMonthlyBkpJobStats J (NOLOCK) ON J.CommServUniqueId = R.CommServUniqueId
	WHERE	J.MonthStart = @LastMonthStart AND J.AppTypeID > 0
	GROUP BY J.CommServUniqueId
	CREATE CLUSTERED INDEX LastMonthJobCountIdx ON #LastMonthJobCount (CommServUniqueId)
	CREATE TABLE #tempClients (CommServUniqueId INT, ActiveServers INT, ActiveLaptops INT, ActiveVMs INT, ProtectedClients INT, NotProtectedClients INT)
	IF @i_SLADays = 30
		INSERT	INTO #tempClients
		SELECT	CommServUniqueId, -1, -1, -1, csInfo.ProtectedClients, csInfo.NotProtectedClients
		FROM	dbo.cf_SurveyResultFuncV1(146, @i_CommServUniqueID, 1, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) AS resultView
			INNER JOIN cf_CommcellSummary AS csInfo WITH (NOLOCK) ON resultView.SurverResultId = csInfo.SurveyResultId
	ELSE
		INSERT	INTO #tempClients
		SELECT	CommServUniqueId, -1, -1, -1, csInfo.ProtectedClients, csInfo.NotProtectedClients
		FROM	dbo.cf_SurveyResultFuncV1(146, @i_CommServUniqueID, 1, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) AS resultView
			INNER JOIN cf_SurveySLASummary AS csInfo WITH (NOLOCK) ON resultView.SurverResultId = csInfo.SurveyResultId AND csInfo.Days = @i_SLADays
	CREATE CLUSTERED INDEX tempClientsIdx ON #tempClients (CommServUniqueId)
	UPDATE	T SET ActiveServers = csinfo.TotalActiveClients - ISNULL(TotalLaptops, 0) - ISNULL(TotalActiveVMs, 0),
			ActiveLaptops = ISNULL(TotalLaptops, 0), ActiveVMs = ISNULL(TotalActiveVMs, 0)
	FROM	#tempClients T
			INNER JOIN dbo.cf_SurveyResultFuncV1(8, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) AS result
				ON T.CommServUniqueId = result.CommServUniqueId
			INNER JOIN cf_SurveyClientStatisticsInfo csinfo (NOLOCK) ON result.SurverResultId = csinfo.SurveyResultId
	CREATE TABLE #tempLicenseServer(CommServUniqueId INT, QuotaEnabled INT)
	INSERT	INTO #tempLicenseServer
	SELECT	R.CommcellIdNameMap_ID, MAX(S.QuotaEnabled)
	FROM	cf_CommservSurveyResults R WITH (NOLOCK)
			INNER JOIN (SELECT SurveyResultId, MAX(QuotaEnabled&(1|4)) AS QuotaEnabled
				FROM cf_SurveyClientGroupQuotaUsage WITH (NOLOCK)
				WHERE ClientGroupName = 'CommCell Inherited Capacity'
				GROUP BY SurveyResultId) S ON R.CommservSurveyResults_ID = S.SurveyResultId
	GROUP BY R.CommcellIdNameMap_ID
	CREATE TABLE #tempFinalResult(
		CommServeUniqueId INT, CommCellID VARCHAR(32), DisplayName NVARCHAR(256), CurrCSIpAddress VARCHAR(256), CommServIP VARCHAR(256), Status VARCHAR(50), CommServVersionALTSORT VARCHAR(256),
		ActiveServers INT, ActiveLaptops INT, ActiveVMs INT, ProtectedClients INT, NotProtectedClients INT, SLAPercent INT, LastMonthJobs BIGINT, TotalCapacityMB BIGINT, UsedCapacityMB BIGINT,
		DeDupRatioPercent DECIMAL(10,1), HoursSinceLastUpdate INT, LastUpdatedTime INT, CommServTimeZone VARCHAR(256),
		Health VARCHAR(10), Activity VARCHAR(10), Audit VARCHAR(10), Chargeback VARCHAR(10), RemoteTroubleshooting VARCHAR(10), SPBilling VARCHAR(10), LicenseServer VARCHAR(10),
		VersionSORTCOLUMN INT, GUID VARCHAR(256), DisplayNameDONOTSHOW NVARCHAR(256), SQLVersion NVARCHAR(256), OperatingSystem VARCHAR(255)
	)
    CREATE CLUSTERED INDEX tempFinalResultIdx ON #tempFinalResult(CommServeUniqueId,CommCellID)
	INSERT INTO #tempFinalResult
	SELECT
        csinfo.ID,
        csinfo.CommCellID,
        resultView.DisplayName,
        CASE WHEN csinfo.CurrCSIpAddress IS NULL OR LEN(csinfo.CurrCSIpAddress) <= 0 THEN 'N/A' ELSE csinfo.CurrCSIpAddress END,
        csinfo.CommServIP,
        CASE WHEN (csinfo.Flags & 1) <> 1  THEN 'Enabled' ELSE 'Disabled' END,
        csinfo.CommServVersion,
        C.ActiveServers,
        C.ActiveLaptops,
        C.ActiveVMs,
		C.ProtectedClients,
		C.NotProtectedClients,
        CAST((CASE WHEN ISNULL(C.NotProtectedClients + C.ProtectedClients, 0) > 0
                    THEN ISNULL(C.ProtectedClients, 0)*100.0/ISNULL(C.NotProtectedClients + C.ProtectedClients, 0) ELSE -1 END) AS INT) as ' SLA (%)<percentNA>',
		ISNULL(J.LastMonthJobs, 0),
		ISNULL(U.TotalCapacityMB, 0),
		ISNULL(U.UsedCapacityMB, 0),
        ISNULL(CAST(ROUND((CASE WHEN csSummary.TotalMediaSizeGB <=0 OR csSummary.TotalAppSizeGB = 0 OR csSummary.TotalMediaSizeGB > csSummary.TotalAppSizeGB THEN 0
			                    ELSE ((100.0*(csSummary.TotalAppSizeGB-csSummary.TotalMediaSizeGB))/csSummary.TotalAppSizeGB)
		                    END),1) AS DECIMAL(10,1)),0),
        CASE WHEN HT.LogDateUTC <GETUTCDATE() THEN  DATEDIFF(HH, ISNULL(HT.LogDateUTC, '1970-01-01 00:00:00'),GETUTCDATE())
											  ELSE -1 END ,
        DATEDIFF(s, '1970-01-01 00:00:00', HT.LogDate),
		HT.CommServTimeZone,
        case when (csInfo.CommCellSurveyServices & 1) =1 then 'Yes' else 'No' end,
        case when (csInfo.CommCellSurveyServices & 4) =4 then 'Yes' else 'No' end,
        -- case when (csInfo.CommCellSurveyServices & 2) =2 then 'Yes' else 'No' end,
        case when (csInfo.CommCellSurveyServices & 16) =16 then 'Yes' else 'No' end,
        case when (csInfo.CommCellSurveyServices & 32) =32 then 'Yes' else 'No' end,
        case when (csInfo.CommCellSurveyServices & 64) =64 then 'Yes' else 'No' end,
        case when (csInfo.CommCellSurveyServices & 256) =256 then 'Yes' else 'No' end,
		CASE ISNULL(LS.QuotaEnabled, 0) WHEN 0 THEN '' WHEN 1 THEN 'Child' ELSE 'Server' END,
  		dbo.GetServicePackSortRank(csinfo.CommServVersion),
		csinfo.CommServGUID,
		ISNULL(csinfo.CustomerName,''),
		'',
		''
	FROM
        cf_CommcellIdNameMap csinfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(146, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
                on resultView.CommServUniqueId = csinfo.ID
		inner join cf_CommcellSummary  csSummary WITH (NOLOCK)
                on csSummary.SurveyResultId = resultView.SurverResultId
		LEFT OUTER JOIN #LastMonthJobCount J ON resultView.CommServUniqueId = J.CommServUniqueId
		LEFT OUTER JOIN #tempUsedCapacity U ON resultView.CommServUniqueId = U.CommServUniqueId
        LEFT OUTER JOIN #tempClients C ON resultView.CommServUniqueId = C.CommServUniqueId
        LEFT OUTER JOIN #tempLicenseServer LS ON resultView.CommServUniqueId = LS.CommServUniqueId
		INNER JOIN dbo.cf_SurveyResultFuncV1(2, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS HT
        on HT.CommServUniqueId = csinfo.ID
	if object_id('tempdb.dbo.#tempUsedCapacity') is not null
		drop table #tempUsedCapacity
	if object_id('tempdb.dbo.#LastMonthJobCount') is not null
		drop table #LastMonthJobCount
	if object_id('tempdb.dbo.#tempClients') is not null
		drop table #tempClients
	if object_id('tempdb.dbo.#tempLicenseServer') is not null
		drop table #tempLicenseServer
	DECLARE @UserCapability INT = 0
	SET @UserCapability = (SELECT surveycapability FROM cf_MetricsLoggedInUsers WITH (NOLOCK) WHERE UserId = @i_UserId)
	IF (@param_isPrivate = 0 AND @UserCapability = 0 AND @CSDetails = 0)
	BEGIN
		--In case of public cloud add all registered commcells for the customer logins
		DECLARE @UserProp xml
		SET @UserProp=(SELECT UserProp FROM cf_MetricsLoggedInUsers WITH (NOLOCK) WHERE UserId = @i_UserId)
		CREATE TABLE #VisibleCommcells (CommCellID VARCHAR(32), CommServGUID VARCHAR(256), DisplayName NVARCHAR(256))
		INSERT INTO #VisibleCommcells
		SELECT
			commcells.value('@commCellId', '[NVARCHAR](MAX)'),
			commcells.value('@csGUID', '[NVARCHAR](MAX)'),
			commcells.value('@commCellName', '[NVARCHAR](MAX)')
		FROM @UserProp.nodes('WebReport_CloudMetricsUserResp') AS resp(resp)
			CROSS APPLY resp.nodes('commcells') AS commcells(commcells)
		DELETE FROM #VisibleCommcells WHERE CommServGUID IN (SELECT GUID FROM #tempFinalResult)
		INSERT INTO #tempFinalResult
		SELECT
			0, VC.CommCellID, VC.DisplayName, 'N/A', '', 'Disabled', 'N/A', -1, -1, -1, NULL, NULL, NULL, NULL, NULL, -1, -1, NULL, NULL, NULL, 'No', 'No', 'No', 'No', 'No', 'No', '', NULL, VC.CommServGUID, '', '', ''
		FROM #VisibleCommcells VC
		DROP TABLE #VisibleCommcells
	END
	IF OBJECT_ID('tempdb..#LastConnectionTimeResults') IS NOT NULL
		DROP TABLE #LastConnectionTimeResults
	create table #LastConnectionTimeResults (
		CSID int,
		LastConnectionTimeNum int,
		HoursSinceLastConnection	INT,
		LastConnectionTimeDate datetime,
		CommServTimeZone VARCHAR(256)
	)
    CREATE CLUSTERED INDEX LastConnectionTimeResultsIdx ON #LastConnectionTimeResults(CSID)
	insert into #LastConnectionTimeResults
	SELECT CommServeUniqueId, 0, 0, 0, CommServTimeZone FROM #tempFinalResult  where CommServeUniqueId!=0
	exec CalculateLastConnectionTime
	update #LastConnectionTimeResults
    set LastConnectionTimeNum = (
		case
			when LastConnectionTimeDate is not null and LastConnectionTimeDate != 0 and CommServTimeZone is not null
			then DATEDIFF(SECOND, '01/01/1970', isnull(dbo.UTCToLocalDateTimeConversion(LastConnectionTimeDate, CommServTimeZone),0))
			else 0
		end
	),
	HoursSinceLastConnection = case WHEN LastConnectionTimeDate is not null and LastConnectionTimeDate != 0 and CommServTimeZone is not null
										THEN DATEDIFF(HOUR,LastConnectionTimeDate, GETUTCDATE())
									ELSE -1
								END
	UPDATE T SET SQLVersion = C.SQLVersion
	FROM	#tempFinalResult T
			INNER JOIN (
				SELECT	CommServUniqueId, MAX(SurveyResultId) AS SurveyResultId
				FROM	cf_SurveyCSDetailsInfo WITH(NOLOCK)
				WHERE	SQLVersion IS NOT NULL
				GROUP BY CommServUniqueId
				) S ON T.CommServeUniqueId = S.CommServUniqueId
			INNER JOIN cf_SurveyCSDetailsInfo C WITH(NOLOCK) ON S.SurveyResultId = C.SurveyResultId
	UPDATE C SET C.OperatingSystem  = T.OperatingSystem
    FROM #tempFinalResult C WITH (PAGLOCK) INNER JOIN cf_SurveyClient T (NOLOCK) ON C.CommServeUniqueId = T.CommServUniqueId AND T.ClientId = 2
	IF (@param_isPrivate = 0)
	BEGIN
		SELECT
			csinfo.CommServeUniqueId as 'CommServe UniqueId',
			csinfo.CommCellID AS 'CommCell ID',
			csinfo.DisplayName AS 'CommCell Name',
			csinfo.CurrCSIpAddress AS 'CommServe IP<HIDDEN>',
			csinfo.CommServIP AS 'Gateway IP Address<HIDDEN>',
			csinfo.Status AS 'Status<HIDDEN><COMMCELL_STATUS>',
			csinfo.CommServVersionALTSORT AS 'Software Version<ALTSORT>',
			csinfo.ActiveServers AS 'Active Servers<NumberNA>',
			csinfo.ActiveLaptops AS 'Active Laptops<NumberNA>',
			csinfo.ActiveVMs AS 'Active VMs<NumberNA>',
			csinfo.ProtectedClients as 'Clients Met SLA<FORMATNUMBERNA>',
			csinfo.NotProtectedClients as 'Clients Missed SLA<FORMATNUMBERNA>',
			csinfo.SLAPercent as 'SLA (%)<percentNA>',
			csinfo.LastMonthJobs AS 'Last Month Job Count<HIDDEN>',
			CAST(1.0*csinfo.TotalCapacityMB/1024/1024 AS DECIMAL(20,2)) AS 'Total Purchased Capacity (TB)<HIDDEN>',
			CAST(1.0*csinfo.UsedCapacityMB/1024/1024 AS DECIMAL(20,2)) AS 'Total Used Capacity (TB)<HIDDEN>',
			csinfo.DeDupRatioPercent AS 'DeDup Ratio (%)<HIDDEN>',
			csinfo.HoursSinceLastUpdate AS 'Hours Since Last Update<NumberNA>',
			csinfo.LastUpdatedTime AS 'Last Updated Time<DATETIME><HIDDEN>',
			case
			when LastConn.LastConnectionTimeNum is null then @NA
			when
			LastConn.LastConnectionTimeNum > 0 and SP.Release > 10
			then
			LastConn.LastConnectionTimeNum
			else
			@NA
			end as 'Last Connection Time<MMMDDYYYYHrMinAM><HIDDEN>',
			CASE
				WHEN SP.Release > 10
					THEN ISNULL(LastConn.HoursSinceLastConnection, -1)
				ELSE -1
			END AS 'Hours Since Last Connection<NumberNA><HIDDEN>',
			-- for debug purpose
			/*
			(
			case
				when LastConn.LastConnectionTimeDate is null then 0
				when LastConn.LastConnectionTimeDate != 0
				then DATEDIFF(SECOND, '01/01/1970', LastConn.LastConnectionTimeDate)
				else 0
			end
			) as LastConnectionTimeDate,
			*/
			csinfo.CommServTimeZone AS 'Time Zone<HIDDEN>',
			csinfo.Health AS 'Health<BOOLEAN><HIDDEN>',
			csinfo.Activity AS 'Activity<BOOLEAN><HIDDEN>',
			csinfo.Audit AS 'Audit<BOOLEAN><HIDDEN>',
			csinfo.Chargeback AS 'Chargeback<BOOLEAN><HIDDEN>',
			csinfo.RemoteTroubleshooting AS 'Proactive Support<BOOLEAN><HIDDEN>',
			csinfo.SPBilling AS 'Service Provider Billing<BOOLEAN><HIDDEN>',
			csinfo.LicenseServer AS 'License Server<HIDDEN>',
			csinfo.VersionSORTCOLUMN AS 'Version<SORTCOLUMN>',
			csinfo.GUID AS 'GUID<DONOTSHOW>',
			csinfo.DisplayNameDONOTSHOW AS 'DisplayName<DONOTSHOW>',
		    csinfo.SQLVersion AS 'SQL Server Version<HIDDEN>',
			csinfo.OperatingSystem AS 'Operating System<HIDDEN>'
			FROM #tempFinalResult csinfo
			left join #LastConnectionTimeResults LastConn
		on csinfo.CommServeUniqueId = LastConn.CSID
		CROSS APPLY SplitVersionString(CASE WHEN CommServVersionALTSORT = 'N/A' THEN '0' ELSE CommServVersionALTSORT END) SP
		ORDER BY LastUpdatedTime
	END
	ELSE
	BEGIN
		SELECT
			csinfo.CommServeUniqueId as 'CommServe UniqueId',
			csinfo.CommCellID AS 'CommCell ID',
			csinfo.DisplayName AS 'CommCell Name',
			csinfo.CurrCSIpAddress AS 'CommServe IP<HIDDEN>',
			csinfo.CommServIP AS 'Gateway IP Address<HIDDEN>',
			csinfo.Status AS 'Status<HIDDEN><COMMCELL_STATUS>',
			csinfo.CommServVersionALTSORT AS 'Software Version<ALTSORT>',
			csinfo.ActiveServers AS 'Active Servers<NumberNA>',
			csinfo.ActiveLaptops AS 'Active Laptops<NumberNA>',
			csinfo.ActiveVMs AS 'Active VMs<NumberNA>',
			csinfo.ProtectedClients as 'Clients Met SLA<FORMATNUMBERNA>',
			csinfo.NotProtectedClients as 'Clients Missed SLA<FORMATNUMBERNA>',
			csinfo.SLAPercent as 'SLA (%)<percentNA>',
			csinfo.LastMonthJobs AS 'Last Month Job Count<HIDDEN>',
			CAST(1.0*csinfo.TotalCapacityMB/1024/1024 AS DECIMAL(20,2)) AS 'Total Purchased Capacity (TB)<HIDDEN>',
			CAST(1.0*csinfo.UsedCapacityMB/1024/1024 AS DECIMAL(20,2)) AS 'Total Used Capacity (TB)<HIDDEN>',
			csinfo.DeDupRatioPercent AS 'DeDup Ratio (%)<HIDDEN>',
			csinfo.HoursSinceLastUpdate AS 'Hours Since Last Update<FORMATNUMBERNA>',
			csinfo.LastUpdatedTime AS 'Last Updated Time<DATETIME><HIDDEN>',
			csinfo.CommServTimeZone AS 'Time Zone<HIDDEN>',
			csinfo.Health AS 'Health<BOOLEAN><HIDDEN>',
			csinfo.Activity AS 'Activity<BOOLEAN><HIDDEN>',
			csinfo.Audit AS 'Audit<BOOLEAN><HIDDEN>',
			csinfo.Chargeback AS 'Chargeback<BOOLEAN><HIDDEN>',
			csinfo.SPBilling AS 'Service Provider Billing<BOOLEAN><HIDDEN>',
			csinfo.LicenseServer AS 'License Server<HIDDEN>',
			csinfo.VersionSORTCOLUMN AS 'Version<SORTCOLUMN>',
			csinfo.GUID AS 'GUID<DONOTSHOW>',
			csinfo.DisplayNameDONOTSHOW AS 'DisplayName<DONOTSHOW>',
            csinfo.SQLVersion AS 'SQL Server Version<HIDDEN>',
			csinfo.OperatingSystem AS 'Operating System<HIDDEN>'
		FROM #tempFinalResult csinfo
		ORDER BY LastUpdatedTime
	END
	if object_id('tempdb.dbo.#LastConnectionTimeResults') is not null
		drop table #LastConnectionTimeResults
	if object_id('tempdb.dbo.#tempFinalResult') is not null
		DROP TABLE #tempFinalResult
END
ELSE
BEGIN
	SELECT
		ClientType AS 'Entity',
		Total AS 'Total Missing Updates',
		BehindRel AS 'Behind Major Version',
		BehindSP AS 'Behind Feature Release',
		NeedHotFix AS 'Missing Maintenance Releases',
		CASE WHEN ISNULL(Total, 0) = 0 THEN @strGood ELSE @strCritical END AS 'Status<HEALTH_STATUS>'
	FROM
		cf_SurveyUpdateStatus AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND csInfo.ClientTypeId <> 0
	ORDER BY csInfo.ClientTypeId
END
END
SET NOCOUNT OFF
/*  FOR STANDALONE TESTING:
DECLARE @i_UserId    INT = 1
DECLARE @i_GroupId INT = 0
DECLARE @blaggregate INT = 0
DECLARE @blLatestSurvey INT = 0
DECLARE @i_CommServUniqueID INT = 0
DECLARE @i_LogDateEND DATETIME = NULL     --getDate()
DECLARE @i_LogDateStart DATETIME = NULL   -- Dateadd(month, -1, @i_LogDateEnd)
DECLARE @i_SLADays INT = 30
exec RptUpdateInfoSurvey @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueId, @i_LogDateStart, @i_LogDateEND, @i_SLADays
*/
GO

IF EXISTS (select * from GxQscripts where name = 'RptUpdateInfoSurvey')
	delete from GxQscripts where name = 'RptUpdateInfoSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptUpdateInfoSurvey')
	delete from GXDBVersions where aliasname = 'RptUpdateInfoSurvey'
GO

insert into GXDBVersions values(2, 'RptUpdateInfoSurvey',  'v1.34.2.59.14.2', 'RptUpdateInfoSurvey', 'v1.34.2.59.14.2')
GO

