

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Rpt_77ClientDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Rpt_77ClientDetails.sp,v $ $Id: Rpt_77ClientDetails.sp,v 1.8.56.12.20.1 2021/02/03 10:31:04 nbirru Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='Rpt_77ClientDetails')
BEGIN
	print '>>> Drop Stored Procedure: Rpt_77ClientDetails <<<'
	drop procedure Rpt_77ClientDetails
END
IF EXISTS (select * from GxQscripts where name='Rpt_77ClientDetails')
	delete from GxQscripts where name = 'Rpt_77ClientDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_77ClientDetails')
	delete from GXDBVersions where aliasname = 'Rpt_77ClientDetails'
GO
print '... Creating Procedure: Rpt_77ClientDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure Rpt_77ClientDetails
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll,
  @i_TenantName NVARCHAR(255) = NULL
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 1
DECLARE	@CurrMonth DATE = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)
DECLARE	@TempMonth DATE = @CurrMonth
DECLARE	@TempMonthEnd DATE = DATEADD(MM, 1, @TempMonth)
IF object_id('tempdb.dbo.#TenantClients') IS NOT NULL DROP TABLE #TenantClients
CREATE TABLE #TenantClients (CommServUniqueId INT, TenantName NVARCHAR(255), ClientId INT)
exec GetTenantEntities @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND, @i_TenantName
IF @blLatestSurvey = 1
BEGIN
	SELECT
		resultView.CommServUniqueId  AS 'CommServ UniqueId',
		resultView.CommCellID AS 'CommCell ID',
		resultView.DisplayName AS 'CommCell Name',
		csInfo.clientName  AS 'Client Name'
		--, csInfo.clientId  AS clientId
		, csInfo.operatingSystem  AS 'Operating System'
		,CASE WHEN csInfo.installdate IS NULL THEN -50 ELSE datediff(second, '01/01/1970',CAST(csInfo.installdate AS DATE)) END AS 'Install Date<MMMDDYYYY>'
		, csInfo.servicePack  AS 'Software Version'
		, csInfo.StoragePolicy  AS 'Storage Policy'
		, CASE
		WHEN csInfo.latestDataProtection IS NULL  THEN -50
		ELSE
		datediff(second, '01/01/1970',csInfo.latestDataProtection)
		END AS 'Latest Data Protection<MMMDDYYYY>'
		, CASE
		WHEN csInfo.latestDataProtection IS NULL THEN 'N/A'
		ELSE CAST(DATEDIFF(DD, csInfo.latestDataProtection, GETUTCDATE()) AS NVARCHAR(10))
		END  AS 'Days Since Last Backup',
		CASE WHEN csInfo.type &1=1 THEN 'Laptops ' ELSE '' END +
		CASE WHEN csInfo.type &2=2 THEN 'MediAgents ' ELSE '' END  +
		CASE WHEN csInfo.type &8=8 THEN 'Virtual Machine ' ELSE '' END+
		CASE WHEN csInfo.type &4=4 THEN 'No Package' ELSE '' END
		AS 'Entity Types<HIDDEN>'
	FROM cf_SurveyClient AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.CommServUniqueId = csInfo.CommServUniqueId
		LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                     ON csInfo.CommServUniqueId = TC.CommServUniqueId AND csInfo.ClientId = TC.ClientId
	WHERE ((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL) AND
		csInfo.InstallStatus <> 2 AND csInfo.Deleted = 0
	ORDER BY resultView.CustomerName ASC , csInfo.clientName ASC
END
ELSE
IF @blaggregate = 0 -- Chart
BEGIN
	CREATE TABLE #MonthlyClients (MonthStart DATE, MonthEnd DATE, Year INT, Month INT, Added INT, Removed INT, Total INT)
	DECLARE @i INT = 0
	WHILE @i <= 13
	BEGIN
		INSERT INTO #MonthlyClients
		SELECT	@TempMonth, @TempMonthEnd, YEAR(@TempMonth), MONTH(@TempMonth), 0, 0, COUNT(*)
		FROM	cf_SurveyClient AS C WITH (NOLOCK)
				INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) AS R
					ON C.CommServUniqueId = R.CommServUniqueId
				LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                     ON C.CommServUniqueId = TC.CommServUniqueId AND C.ClientId = TC.ClientId
		WHERE	((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL) AND (C.InstallDate < @TempMonthEnd
			AND (C.InstallStatus < 2 OR ISNULL(C.UninstallTime, '1970') > @TempMonthEnd OR ISNULL(C.LatestDataProtection, '1970') > @TempMonth) AND C.Deleted = 0)
		SET @TempMonthEnd = @TempMonth
		SET @TempMonth = DATEADD(MM, -1, @TempMonth)
		SET @i += 1
	END
	UPDATE	#MonthlyClients SET Added = T.Counts
	FROM	#MonthlyClients M
		INNER JOIN (
			SELECT	YEAR(C.InstallDate) AS Year, MONTH(C.InstallDate) AS Month, COUNT(*) AS Counts
			FROM	cf_SurveyClient AS C WITH (NOLOCK)
					INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) AS R
						ON C.CommServUniqueId = R.CommServUniqueId
					LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                     ON C.CommServUniqueId = TC.CommServUniqueId AND C.ClientId = TC.ClientId
			WHERE	((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL) AND C.InstallDate >= @TempMonthEnd
			GROUP BY YEAR(C.InstallDate), MONTH(C.InstallDate)
		) T ON M.Year = T.Year AND M.Month = T.Month
	UPDATE	#MonthlyClients SET Removed = (N.Total + M.Added - M.Total)
	FROM	#MonthlyClients M
			INNER JOIN (SELECT MonthEnd, Total FROM #MonthlyClients) N ON M.MonthStart = N.MonthEnd
	SELECT	dbo.GetUnixTimeBig(MonthStart) AS MonthStart, Added, Removed, Total
	FROM	#MonthlyClients
	WHERE	MonthStart > @TempMonthEnd
	ORDER BY MonthStart
	DROP TABLE #MonthlyClients
END
ELSE
IF @blaggregate = 1
BEGIN
	CREATE TABLE #Summary (CommServUniqueId INT, CommCellName NVARCHAR(288), ID INT IDENTITY (1,1), Name VARCHAR(32), Value INT)
	CREATE TABLE #YearlyTotal (CommServUniqueId INT, Year INT, Total INT)
	CREATE TABLE #MonthlyTotal (CommServUniqueId INT, MonthStart DATE, X INT, Y FLOAT)
	DECLARE @ColumnNameTbl TABLE (ID INT IDENTITY (1,1), Name VARCHAR(32))
	DECLARE @CurrYear INT = YEAR(GETDATE())
	DECLARE @TempYear INT = @CurrYear - 2
	WHILE @TempYear <= @CurrYear
	BEGIN
		INSERT INTO #YearlyTotal
		SELECT	R.CommServUniqueId, @TempYear,
				ISNULL((SELECT	COUNT(*)
						FROM	cf_SurveyClient C WITH (NOLOCK)
						LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
							ON C.CommServUniqueId = TC.CommServUniqueId AND C.ClientId = TC.ClientId
						WHERE ((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL) AND	(C.CommServUniqueId = R.CommServUniqueId
							AND YEAR(InstallDate) <= @TempYear
							AND (InstallStatus < 2
								OR YEAR(ISNULL(UninstallTime, '1970')) > @TempYear
								OR YEAR(ISNULL(LatestDataProtection, '1970')) > @TempYear) AND Deleted = 0)
						), 0)
		FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) AS R
		INSERT INTO  @ColumnNameTbl (Name) SELECT CAST(@TempYear AS VARCHAR(32))
		SET @TempYear += 1
	END
	INSERT	INTO #Summary (CommServUniqueId, Name, Value)
	SELECT	CommServUniqueId, CAST(Year AS VARCHAR(32)), Total
	FROM	#YearlyTotal
	ORDER BY Year
	SET @TempMonth = DATEADD(MONTH, -12, @CurrMonth)
	SET	@TempMonthEnd = DATEADD(MM, 1, @TempMonth)
	DECLARE @M INT = 1
	WHILE @TempMonth <= @CurrMonth
	BEGIN
		INSERT INTO #MonthlyTotal
		SELECT	R.CommServUniqueId, @TempMonth, @M,
				ISNULL((SELECT	COUNT(*)
						FROM	cf_SurveyClient C WITH (NOLOCK)
						LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
							ON C.CommServUniqueId = TC.CommServUniqueId AND C.ClientId = TC.ClientId
						WHERE ((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL) AND	(C.CommServUniqueId = R.CommServUniqueId
							AND InstallDate <= @TempMonthEnd
							AND (InstallStatus < 2
								OR ISNULL(UninstallTime, '1970') > @TempMonthEnd
								OR ISNULL(LatestDataProtection, '1970') > @TempMonth) AND Deleted = 0)
						), 0)
		FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) AS R
		INSERT INTO  @ColumnNameTbl (Name) SELECT CONVERT(VARCHAR(3), @TempMonth, 100) + ' ' + CAST(YEAR(@TempMonth) AS VARCHAR(4))
		SET	@TempMonth = @TempMonthEnd
		SET @TempMonthEnd = DATEADD(MM, 1, @TempMonth)
		SET @M += 1
	END
	INSERT	INTO #Summary (CommServUniqueId, Name, Value)
	SELECT	CommServUniqueId, CONVERT(VARCHAR(3), MonthStart, 100) + ' ' + CAST(YEAR(MonthStart) AS VARCHAR(4)), Y
	FROM	#MonthlyTotal
	ORDER BY MonthStart
	DELETE #MonthlyTotal WHERE DATEDIFF(MM, MonthStart, @CurrMonth) >= 6
	;WITH LeastSquareAvg(CommservUniqueId, AvgX, AvgY) AS
	(
		SELECT	CommservUniqueId, AVG(X), AVG(Y)
		FROM	#MonthlyTotal
		GROUP BY CommservUniqueId
	)
	,LeastSquareFit(CommservUniqueId, Slope) AS
	(
		SELECT	A.CommservUniqueId, SUM((X - AvgX)*(Y - AvgY))/SUM((X - AvgX)*(X - AvgX))
		FROM	LeastSquareAvg A INNER JOIN #MonthlyTotal D ON A.CommservUniqueId = D.CommservUniqueId
		GROUP BY A.CommservUniqueId
		HAVING SUM((X - AvgX)*(X - AvgX)) > 0
	)
	INSERT	INTO #Summary (CommServUniqueId, Name, Value)
	SELECT	F.CommServUniqueId, 'Monthly Growth', F.Slope
	FROM	LeastSquareFit F
	UPDATE	S SET CommCellName = R.DisplayName
	FROM	#Summary S
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) AS R
				ON S.CommservUniqueId = R.CommservUniqueId
	DECLARE @QueryStr NVARCHAR(MAX)
	DECLARE @Columns  VARCHAR(MAX)
	INSERT INTO @ColumnNameTbl (Name) SELECT 'Monthly Growth'
	SELECT	@Columns = ISNULL(@Columns + ', ', '') + QUOTENAME(Name)
	FROM	@ColumnNameTbl
	ORDER BY ID
  	SET @QueryStr =
		N'SELECT
			CommservUniqueId AS [CommservUniqueId<DONOTSHOW>], CommCellName AS [CommCell Name], ' + @Columns +
		'FROM
		(
			SELECT	CommservUniqueId, CommCellName, Name, Value
			FROM	#Summary
		) X
		PIVOT
		(
			MAX(Value)
			FOR Name IN (' + @Columns + N')
		) P
		ORDER BY CommCellName'
	EXEC sp_executesql @QueryStr
	DROP TABLE #YearlyTotal
	DROP TABLE #MonthlyTotal
	DROP TABLE #Summary
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Rpt_77ClientDetails')
	delete from GxQscripts where name = 'Rpt_77ClientDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_77ClientDetails')
	delete from GXDBVersions where aliasname = 'Rpt_77ClientDetails'
GO

insert into GXDBVersions values(2, 'Rpt_77ClientDetails',  'v1.8.56.12.20.1', 'Rpt_77ClientDetails', 'v1.8.56.12.20.1')
GO

