

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Rpt_96DiskLibDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Rpt_96DiskLibDetails.sp,v $ $Id: Rpt_96DiskLibDetails.sp,v 1.19.2.26 2020/12/17 02:49:50 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='Rpt_96DiskLibDetails')
BEGIN
	print '>>> Drop Stored Procedure: Rpt_96DiskLibDetails <<<'
	drop procedure Rpt_96DiskLibDetails
END
IF EXISTS (select * from GxQscripts where name='Rpt_96DiskLibDetails')
	delete from GxQscripts where name = 'Rpt_96DiskLibDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_96DiskLibDetails')
	delete from GXDBVersions where aliasname = 'Rpt_96DiskLibDetails'
GO
print '... Creating Procedure: Rpt_96DiskLibDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure Rpt_96DiskLibDetails
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1, -- 0 for Disk libraries and 2 for Cloud libraries
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NULL,
  @i_optParameter varchar(Max)= NULL, -- '1' for showing Average Space Consumed/Freed Per Day
  @i_trend int =0,
  @i_Library varchar(Max)=NULL
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 96
DECLARE @showHiddenLibraries INT = 0
IF EXISTS (SELECT TOP 1 1 FROM cf_SurveyConfig WHERE name = 'showHiddenLibraries' AND value = '1')
	SET @showHiddenLibraries = 1
DECLARE @strGood VARCHAR(10) = '1_Good'
DECLARE @strInfo VARCHAR(10) = '2_Info'
DECLARE @strwarning VARCHAR(10) = '3_Warning'
DECLARE @strCritical VARCHAR(10) = '4_Critical'
DECLARE @strUnknown VARCHAR(10) = '0_Unknown'
DECLARE @criticalThreshold int
DECLARE @warningThreshold int
SELECT	@warningThreshold = WarningThreshold,
		@criticalThreshold =CriticalThreshold
FROM	cf_SurveyHealthParam where queryId = @i_QueryId
IF(@blaggregate=1)
	RETURN
--Never value should be lower than (N/A), to get sorting like Date->Never->N/A order
DECLARE @Never  BIGINT= CAST(0x7FFFFFFFFF AS bigint)-1
DECLARE @NA  BIGINT =CAST(0x7FFFFFFFFF AS bigint)
DECLARE @CurrMonth DATE = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)
DECLARE	@MaxNumOfMonthsforGrowthRate INT = 6
DECLARE @FirstMonth DATE = DATEADD(MONTH, -@MaxNumOfMonthsforGrowthRate, @CurrMonth)
DECLARE @useStoredPrediction BIT = ISNULL((SELECT Value from cf_SurveyConfig WHERE Name = 'useStoredPrediction'), 0)
CREATE TABLE #Results (ResultId BIGINT, CommservUniqueId INT, CommCellID VARCHAR(32), CommServName NVARCHAR(256), DisplayName NVARCHAR(256))
INSERT	INTO #Results
SELECT	SurverResultId, CommservUniqueId, CommCellID, CommServName, DisplayName
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId)
CREATE TABLE #Summary (CommservUniqueId INT, LibraryId INT, LibraryName NVARCHAR(256),
		TotalSpaceMB BIGINT, TotalFreeSpaceMB BIGINT, TotalReserveSpaceMB BIGINT,
		TotalValidDataMB BIGINT, TotalDataWrittenMB BIGINT, TotalAppSizeMB BIGINT,
		AvgConsumedMBPerDay BIGINT, AvgFreedMBPerDay BIGINT, DataAgingProblem NVARCHAR(MAX), DAProblemSeverity INT,
		LowWatermark INT, LogDateUTC DATE, CurrMonthSizeMB BIGINT, PrevMonthSizeMB BIGINT, Pre2MonthSizeMB BIGINT,
		MonthlyGrowthMB FLOAT, StDevGrowthMB FLOAT, DaysToBeFull INT, MinDaysToBeFull INT, MaxDaysToBeFull INT, DaysToReachLowWatermark INT,
		[6MonthsGrowth] BIGINT, [12MonthsGrowth] BIGINT, [18MonthsGrowth] BIGINT)
INSERT	INTO #Summary
SELECT	L.CommservUniqueId, L.LibraryId, L.LibraryName,
		ISNULL(totalSpaceGB*1024, -1), ISNULL(totalFreeSpaceGB*1024, -1), ISNULL(totalReserveSpaceMB, -1),
		ISNULL(totalValidDataGB*1024, -1), ISNULL(totalDataWrittenGB*1024, -1), ISNULL(totalAppSizeGB*1024, -1),
		ISNULL(avgConsumedMBPerDay, 0), ISNULL(avgFreedMBPerDay, 0), N'', 0,
		ISNULL(lowWatermark, 0), D.LogDateUTC, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL
FROM	cf_Survey96DiskLibDetails D WITH (NOLOCK)
		INNER JOIN cf_SurveyLibrary L WITH (NOLOCK) ON D.commservUniqueId = L.commservUniqueId AND D.LibraryId = L.LibraryId
		INNER JOIN #Results R ON D.SurveyResultId = R.ResultId
WHERE	((@blaggregate <> 2 AND L.LibraryTypeId = 3) OR (@blaggregate = 2 AND L.LibraryTypeId = -3))
	AND (@showHiddenLibraries = 1 OR L.Hidden = 0) AND L.Enabled = 1
-- Data Aging Troubleshooting
	UPDATE	S SET DataAgingProblem = P.ProblemDescription, DAProblemSeverity = P.Severity
	FROM	#Summary S
			INNER JOIN (
				SELECT	R.CommservUniqueId, Info.LibraryId, Info.ProblemDescription, Info.Severity,
						ROW_NUMBER() OVER (PARTITION BY R.CommservUniqueId, Info.LibraryId ORDER BY Info.Severity DESC) AS RowId
				FROM	dbo.cf_SurveyResultFuncV1(260, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId) R
						INNER JOIN cf_SurveyDATroubleshootingInfo Info ON R.SurverResultId = Info.SurveyResultId
			) P ON S.CommservUniqueId = P.CommservUniqueId AND S.LibraryId = P.LibraryId
	WHERE	P.RowId = 1
-- Get prediction data
IF @useStoredPrediction = 0
BEGIN
	IF object_id('tempdb.dbo.#GrowthData') IS NOT null DROP TABLE #GrowthData
	CREATE TABLE #GrowthData (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(MAX), X INT, Y FLOAT, SeqId INT) -- for input
	IF object_id('tempdb.dbo.#GrowthRate') IS NOT null DROP TABLE #GrowthRate
	CREATE TABLE #GrowthRate (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(MAX), GrowthRate FLOAT, GrowthStDev FLOAT) -- for output
	IF @blaggregate = 2
		INSERT INTO #GrowthData
		SELECT	S.CommservUniqueId, S.LibraryId, '', DATEDIFF(MONTH, @CurrMonth, S.MonthStart), ISNULL(S.DataWrittenMB, -1),
				ROW_NUMBER() OVER (PARTITION BY S.CommservUniqueId, S.LibraryId ORDER BY S.MonthStart)
		FROM	cf_SurveyDiskLibraryPeakSize S WITH (NOLOCK)
				INNER JOIN #Summary T ON S.CommservUniqueId = T.CommservUniqueId AND S.LibraryId = T.LibraryId
		WHERE	S.MonthStart >= @FirstMonth AND ISNULL(S.DataWrittenMB, -1) > 0
	ELSE
		INSERT INTO #GrowthData
		SELECT	S.CommservUniqueId, S.LibraryId, '', DATEDIFF(MONTH, @CurrMonth, S.MonthStart), ISNULL(S.UsedSpaceMB, -1),
				ROW_NUMBER() OVER (PARTITION BY S.CommservUniqueId, S.LibraryId ORDER BY S.MonthStart)
		FROM	cf_SurveyDiskLibraryPeakSize S WITH (NOLOCK)
				INNER JOIN #Summary T ON S.CommservUniqueId = T.CommservUniqueId AND S.LibraryId = T.LibraryId
		WHERE	S.MonthStart >= @FirstMonth AND ISNULL(S.UsedSpaceMB, -1) > 0 AND T.TotalSpaceMB > 0
	UPDATE	#Summary SET CurrMonthSizeMB = F.Y
	FROM	#GrowthData F
	WHERE	#Summary.CommservUniqueId = F.CommservUniqueId AND #Summary.LibraryId = F.EntityId
		AND F.X = 0 AND F.Y > 0
	UPDATE	#Summary SET PrevMonthSizeMB = F.Y
	FROM	#GrowthData F
	WHERE	#Summary.CommservUniqueId = F.CommservUniqueId AND #Summary.LibraryId = F.EntityId
		AND F.X = -1 AND F.Y > 0
	UPDATE	#Summary SET Pre2MonthSizeMB = F.Y
	FROM	#GrowthData F
	WHERE	#Summary.CommservUniqueId = F.CommservUniqueId AND #Summary.LibraryId = F.EntityId
		AND F.X = -2 AND F.Y > 0
	EXEC GetLinearGrowthRate 0
	UPDATE	S SET MonthlyGrowthMB = T.GrowthRate, StDevGrowthMB = T.GrowthStDev
	FROM	#Summary S
			INNER JOIN #GrowthRate T ON S.CommservUniqueId = T.CommservUniqueId AND S.LibraryId = T.EntityId
	DROP TABLE #GrowthData
	DROP TABLE #GrowthRate
	UPDATE	#Summary
	SET		DaysToBeFull = CASE
				WHEN 30.0*(TotalFreeSpaceMB-TotalReserveSpaceMB) > MonthlyGrowthMB*(DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) + 9999) THEN 10000
				ELSE 30.0*(TotalFreeSpaceMB-TotalReserveSpaceMB)/MonthlyGrowthMB - DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) END,
			DaysToReachLowWatermark = CASE
				WHEN 30.0*(TotalFreeSpaceMB - TotalSpaceMB*LowWatermark/100) > MonthlyGrowthMB*(DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) + 9999) THEN 10000
				ELSE 30.0*(TotalFreeSpaceMB - TotalSpaceMB*LowWatermark/100)/MonthlyGrowthMB - DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) END
	WHERE	ABS(ISNULL(MonthlyGrowthMB, 0)) > 0.001 AND (TotalFreeSpaceMB-TotalReserveSpaceMB) > 0
	UPDATE	#Summary
	SET		DaysToBeFull = 0
	WHERE	(TotalFreeSpaceMB-TotalReserveSpaceMB) <= 0 AND TotalFreeSpaceMB >= 0
	UPDATE	#Summary
	SET		MinDaysToBeFull = CASE
				WHEN 30.0*(TotalFreeSpaceMB-TotalReserveSpaceMB)> (MonthlyGrowthMB+StDevGrowthMB)*(DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) + 9999) THEN 10000
				ELSE 30.0*(TotalFreeSpaceMB-TotalReserveSpaceMB)/(MonthlyGrowthMB+StDevGrowthMB) - DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) END,
			MaxDaysToBeFull = CASE
				WHEN 30.0*(TotalFreeSpaceMB-TotalReserveSpaceMB)> (MonthlyGrowthMB-StDevGrowthMB)*(DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) + 9999) THEN 10000
				ELSE 30.0*(TotalFreeSpaceMB-TotalReserveSpaceMB)/(MonthlyGrowthMB-StDevGrowthMB) - DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) END
	WHERE	DaysToBeFull BETWEEN 1 AND 9999 AND StDevGrowthMB > 0
	UPDATE	#Summary
	SET [6MonthsGrowth] = ISNULL(MonthlyGrowthMB*6, -1),
		[12MonthsGrowth] = ISNULL(MonthlyGrowthMB*12, -1),
		[18MonthsGrowth] = ISNULL(MonthlyGrowthMB*18, -1)
END
ELSE
BEGIN
	-- Use stored prediction from DiskLibraryPrediction
	UPDATE S
	SET S.DaysToBeFull = P.DaysToBeFull,
		S.MonthlyGrowthMB = P.MonthlyGrowthRate,
		S.[6MonthsGrowth] = P.[6MonthsGrowth],
		S.[12MonthsGrowth] = P.[12MonthsGrowth],
		S.[18MonthsGrowth] = P.[18MonthsGrowth]
	FROM #Summary S
	INNER JOIN (
		SELECT CommServUniqueId, LibraryId, MAX(LogDateUTC) AS LogDate
		FROM DiskLibraryPrediction
		GROUP BY CommServUniqueId, LibraryId) AS P0
		ON S.CommservUniqueId = P0.CommServUniqueId AND S.LibraryId = P0.LibraryId
	INNER JOIN DiskLibraryPrediction P
	ON P.CommServUniqueId = P0.CommServUniqueId AND P.LibraryId = P0.LibraryId AND P.LogDateUTC = P0.LogDate
END
CREATE TABLE #MountPathResults (SurveyResultId BIGINT, CommServUniqueId INT)
INSERT	INTO #MountPathResults
SELECT	SurverResultId, CommservUniqueId
FROM	dbo.cf_SurveyResultFuncV1(117, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId)
IF @i_optParameter = '1'
BEGIN
  IF(@i_CommServUniqueID = 0)
  BEGIN
	SELECT
		R.CommServUniqueId		AS 'CommServ UniqueId',
		R.DisplayName			AS 'CommCell Name',
		R.CommCellID			AS 'CommCell ID',
		LibraryName				AS 'Library',
		CASE SM.HardDriveShared WHEN -1 THEN 'N/A' WHEN 0 THEN 'No' ELSE 'Yes' END
								AS 'MountPath/HardDrive Shared<HIDDEN>',
		TotalSpaceMB			AS 'Capacity<SIZEMB>',
		TotalFreeSpaceMB		AS 'Free Space<SIZEMB>',
		CASE
			WHEN (TotalFreeSpaceMB-TotalReserveSpaceMB) <= 0 THEN 0
			ELSE (TotalFreeSpaceMB-TotalReserveSpaceMB)
			END AS 'Available Space<SIZEMB>',
		CASE
			WHEN TotalSpaceMB <= 0 OR (TotalFreeSpaceMB-TotalReserveSpaceMB) <= 0 THEN 0
			ELSE CAST((TotalFreeSpaceMB-TotalReserveSpaceMB)*100.0/TotalSpaceMB AS DECIMAL(10,2))
			END AS 'Available Space(%)<percentNA>',
		TotalReserveSpaceMB		AS 'Reserve Space<SIZEMB><HIDDEN>',
		CASE WHEN ISNULL(DaysToBeFull, -1) < 0 THEN @NA -- For N/A
			 WHEN DaysToBeFull > 9999 THEN @Never -- For Never
		     ELSE dbo.getUnixtimebig(DATEADD(DAY, DaysToBeFull, GETUTCDATE()))
		END AS 'Date to be Full<MMMDDYYYYNEVER>',
		CASE WHEN ISNULL(DaysToBeFull, -1) NOT BETWEEN 1 AND 9999 OR ISNULL(MaxDaysToBeFull, -1) NOT BETWEEN 1 AND 9999 THEN 'N/A'
			 WHEN MinDaysToBeFull < MAXDaysToBeFull
			 THEN CONVERT(VARCHAR(12), DATEADD(DAY, MinDaysToBeFull, GETUTCDATE()), 107) + ' - ' + CONVERT(VARCHAR(12), DATEADD(DAY, MaxDaysToBeFull, GETUTCDATE()), 107)
		     ELSE CONVERT(VARCHAR(12), DATEADD(DAY, MaxDaysToBeFull, GETUTCDATE()), 107) + ' - ' + CONVERT(VARCHAR(12), DATEADD(DAY, MinDaysToBeFull, GETUTCDATE()), 107)
		END AS 'Range of Date to be Full<HIDDEN>',
		TotalDataWrittenMB		AS 'Data Written<SIZEMB>',
		TotalAppSizeMB			AS 'App Size<SIZEMB>',
		AvgConsumedMBPerDay		AS 'Average Space Consumed Per Day<SIZEMB><HIDDEN>',
		AvgFreedMBPerDay		AS 'Average Space Freed Per Day<SIZEMB><HIDDEN>',
		DataAgingProblem		AS 'Data Aging Problem<HIDDEN>',
		CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
				ELSE (PrevMonthSizeMB-Pre2MonthSizeMB)
		END AS 'Previous Month Change<DifferenceMB><HIDDEN>',
		CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
				ELSE CAST(1.0*(PrevMonthSizeMB-Pre2MonthSizeMB)/(0.01*Pre2MonthSizeMB) AS DECIMAL(30, 2))
		END AS 'Previous Month Change (%)<DifferenceNA><HIDDEN>',
		CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR ISNULL(CurrMonthSizeMB, 0) = 0 THEN NULL
				ELSE (CurrMonthSizeMB-PrevMonthSizeMB)
		END AS 'Current Month Change<DifferenceMB>',
		CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR ISNULL(CurrMonthSizeMB, 0) = 0 THEN NULL
				ELSE CAST(1.0*(CurrMonthSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
		END AS 'Current Month Change (%)<DifferenceNA>',
		CASE WHEN LowWatermark = 0 THEN 'N/A' ELSE CAST(LowWatermark AS NVARCHAR(20)) END	AS 'Low Watermark (%)<HIDDEN>',
		CASE WHEN ISNULL(DaysToReachLowWatermark, -1) < 0 THEN @NA -- For N/A
			 WHEN DaysToReachLowWatermark > 9999 THEN @Never -- For Never
		     ELSE dbo.getUnixtimebig(DATEADD(DAY, DaysToReachLowWatermark, GETUTCDATE()))
		   END AS 'Reach Low Watermark<HIDDEN><MMMDDYYYYNEVER>',
		S.[6MonthsGrowth] AS '6 Month Growth<SIZEMB><HIDDEN>',
		S.[12MonthsGrowth] AS '12 Month Growth<SIZEMB><HIDDEN>',
		S.[18MonthsGrowth] AS '18 Month Growth<SIZEMB><HIDDEN>',
		CASE WHEN TotalSpaceMB  = -1024 AND TotalFreeSpaceMB = -1024 THEN @strInfo
			 WHEN TotalSpaceMB < 0 THEN @strUnknown
			 WHEN ISNULL(DaysToBeFull, -1) >= 0 AND DaysToBeFull < @criticalThreshold THEN @strCritical
			 WHEN ISNULL(DaysToBeFull, -1) >= 0 AND DaysToBeFull >= @criticalThreshold AND DaysToBeFull <= @warningThreshold THEN @strwarning
			 ELSE @strGood
		END AS 'Status<HEALTH_STATUS>'
	FROM #Summary S
		INNER JOIN #Results R ON S.CommServUniqueId = R.CommServUniqueId
		LEFT OUTER JOIN (
			SELECT	R.CommServUniqueId, MP.LibraryId, MAX(MP.HardDriveShared) AS HardDriveShared
			FROM	cf_SurveyMountPathSummary MP
					INNER JOIN #MountPathResults R ON MP.SurveyResultId = R.SurveyResultId
			GROUP BY R.CommServUniqueId, MP.LibraryId
			) SM ON S.CommServUniqueId = SM.CommServUniqueId AND S.LibraryId = SM.LibraryId
	ORDER BY [Status<HEALTH_STATUS>] DESC,'Date to be Full<MMMDDYYYYNEVER>' ASC
  END
  ELSE
  BEGIN
	SELECT
		R.CommServUniqueId		AS 'CommServ UniqueId<DONOTSHOW>',
		R.CommServName			AS 'CommCell Name',
		LibraryName				AS 'Library',
		CASE SM.HardDriveShared WHEN -1 THEN 'N/A' WHEN 0 THEN 'No' ELSE 'Yes' END
								AS 'MountPath/HardDrive Shared<HIDDEN>',
		TotalSpaceMB			AS 'Capacity<SIZEMB>',
		TotalFreeSpaceMB		AS 'Free Space<SIZEMB>',
		CASE
			WHEN (TotalFreeSpaceMB-TotalReserveSpaceMB) <= 0 THEN 0
			ELSE (TotalFreeSpaceMB-TotalReserveSpaceMB)
			END AS 'Available Space<SIZEMB>',
		CASE
			WHEN TotalSpaceMB <= 0 OR (TotalFreeSpaceMB-TotalReserveSpaceMB) <= 0 THEN 0
			ELSE CAST((TotalFreeSpaceMB-TotalReserveSpaceMB)*100.0/TotalSpaceMB AS DECIMAL(10,2))
			END AS 'Available Space(%)<percentNA>',
		TotalReserveSpaceMB		AS 'Reserve Space<SIZEMB><HIDDEN>',
		CASE WHEN ISNULL(DaysToBeFull, -1) < 0 THEN @NA -- For N/A
			 WHEN DaysToBeFull > 9999 THEN @Never -- For Never
		     ELSE dbo.getUnixtimebig(DATEADD(DAY, DaysToBeFull, GETUTCDATE()))
		END AS 'Date to be Full<MMMDDYYYYNEVER>',
		CASE WHEN ISNULL(DaysToBeFull, -1) NOT BETWEEN 1 AND 9999 OR ISNULL(MaxDaysToBeFull, -1) NOT BETWEEN 1 AND 9999 THEN 'N/A'
			 WHEN MinDaysToBeFull < MAXDaysToBeFull
			 THEN CONVERT(VARCHAR(12), DATEADD(DAY, MinDaysToBeFull, GETUTCDATE()), 107) + ' - ' + CONVERT(VARCHAR(12), DATEADD(DAY, MaxDaysToBeFull, GETUTCDATE()), 107)
		     ELSE CONVERT(VARCHAR(12), DATEADD(DAY, MaxDaysToBeFull, GETUTCDATE()), 107) + ' - ' + CONVERT(VARCHAR(12), DATEADD(DAY, MinDaysToBeFull, GETUTCDATE()), 107)
		END AS 'Range of Date to be Full<HIDDEN>',
		TotalDataWrittenMB		AS 'Data Written<SIZEMB>',
		TotalAppSizeMB			AS 'App Size<SIZEMB>',
		AvgConsumedMBPerDay		AS 'Average Space Consumed Per Day<SIZEMB><HIDDEN>',
		AvgFreedMBPerDay		AS 'Average Space Freed Per Day<SIZEMB><HIDDEN>',
		DataAgingProblem		AS 'Data Aging Problem<HIDDEN>',
		CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
				ELSE (PrevMonthSizeMB-Pre2MonthSizeMB)
		END AS 'Previous Month Change<DifferenceMB><HIDDEN>',
		CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
				ELSE CAST(1.0*(PrevMonthSizeMB-Pre2MonthSizeMB)/(0.01*Pre2MonthSizeMB) AS DECIMAL(30, 2))
		END AS 'Previous Month Change (%)<DifferenceNA><HIDDEN>',
		CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR ISNULL(CurrMonthSizeMB, 0) = 0 THEN NULL
				ELSE (CurrMonthSizeMB-PrevMonthSizeMB)
		END AS 'Current Month Change<DifferenceMB>',
		CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR ISNULL(CurrMonthSizeMB, 0) = 0 THEN NULL
				ELSE CAST(1.0*(CurrMonthSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
		END AS 'Current Month Change (%)<DifferenceNA>',
		CASE WHEN LowWatermark = 0 THEN 'N/A' ELSE CAST(LowWatermark AS NVARCHAR(20)) END	AS 'Low Watermark (%)<HIDDEN>',
		CASE WHEN ISNULL(DaysToReachLowWatermark, -1) < 0 THEN @NA -- For N/A
			 WHEN DaysToReachLowWatermark > 9999 THEN @Never -- For Never
		     ELSE dbo.getUnixtimebig(DATEADD(DAY, DaysToReachLowWatermark, GETUTCDATE()))
		   END AS 'Reach Low Watermark<HIDDEN><MMMDDYYYYNEVER>',
		S.[6MonthsGrowth] AS '6 Month Growth<SIZEMB><HIDDEN>',
		S.[12MonthsGrowth] AS '12 Month Growth<SIZEMB><HIDDEN>',
		S.[18MonthsGrowth] AS '18 Month Growth<SIZEMB><HIDDEN>',
		CASE WHEN TotalSpaceMB = -1024 AND TotalFreeSpaceMB = -1024 THEN @strInfo
			 WHEN TotalSpaceMB <= 0 THEN @strUnknown
			 WHEN ISNULL(DaysToBeFull, -1) >= 0 AND DaysToBeFull < @criticalThreshold THEN @strCritical
			 WHEN ISNULL(DaysToBeFull, -1) >= 0 AND DaysToBeFull >= @criticalThreshold AND DaysToBeFull <= @warningThreshold THEN @strwarning
			 ELSE @strGood
		END AS 'Status<HEALTH_STATUS>'
	FROM #Summary S
		INNER JOIN #Results R ON S.CommServUniqueId = R.CommServUniqueId
		LEFT OUTER JOIN (
			SELECT	R.CommServUniqueId, MP.LibraryId, MAX(MP.HardDriveShared) AS HardDriveShared
			FROM	cf_SurveyMountPathSummary MP
					INNER JOIN #MountPathResults R ON MP.SurveyResultId = R.SurveyResultId
			GROUP BY R.CommServUniqueId, MP.LibraryId
			) SM ON S.CommServUniqueId = SM.CommServUniqueId AND S.LibraryId = SM.LibraryId
	ORDER BY [Status<HEALTH_STATUS>] DESC,'Date to be Full<MMMDDYYYYNEVER>' ASC
  END
END
ELSE
BEGIN
  IF(@i_CommServUniqueID = 0)
  BEGIN
	SELECT
		R.CommServUniqueId		AS 'CommServ UniqueId',
		R.DisplayName			AS 'CommCell Name',
		R.CommCellID			AS 'CommCell ID',
		LibraryName				AS 'Library',
		CASE SM.HardDriveShared WHEN -1 THEN 'N/A' WHEN 0 THEN 'No' ELSE 'Yes' END
								AS 'MountPath/HardDrive Shared<HIDDEN>',
		TotalSpaceMB			AS 'Capacity<SIZEMB>',
		TotalFreeSpaceMB		AS 'Free Space<SIZEMB>',
		CASE
			WHEN (TotalFreeSpaceMB-TotalReserveSpaceMB) <= 0 THEN 0
			ELSE (TotalFreeSpaceMB-TotalReserveSpaceMB)
			END AS 'Available Space<SIZEMB>',
		CASE
			WHEN TotalSpaceMB <= 0 OR (TotalFreeSpaceMB-TotalReserveSpaceMB) <= 0 THEN 0
			ELSE CAST((TotalFreeSpaceMB-TotalReserveSpaceMB)*100.0/TotalSpaceMB AS DECIMAL(10,2))
			END AS 'Available Space(%)<percentNA>',
		TotalReserveSpaceMB		AS 'Reserve Space<SIZEMB><HIDDEN>',
		CASE WHEN ISNULL(DaysToBeFull, -1) < 0 THEN @NA -- For N/A
			 WHEN DaysToBeFull > 9999 THEN @Never -- For Never
		     ELSE dbo.getUnixtimebig(DATEADD(DAY, DaysToBeFull, GETUTCDATE()))
		END AS 'Date to be Full<MMMDDYYYYNEVER>',
		CASE WHEN ISNULL(DaysToBeFull, -1) NOT BETWEEN 1 AND 9999 OR ISNULL(MaxDaysToBeFull, -1) NOT BETWEEN 1 AND 9999 THEN 'N/A'
			 WHEN MinDaysToBeFull < MAXDaysToBeFull
			 THEN CONVERT(VARCHAR(12), DATEADD(DAY, MinDaysToBeFull, GETUTCDATE()), 107) + ' - ' + CONVERT(VARCHAR(12), DATEADD(DAY, MaxDaysToBeFull, GETUTCDATE()), 107)
		     ELSE CONVERT(VARCHAR(12), DATEADD(DAY, MaxDaysToBeFull, GETUTCDATE()), 107) + ' - ' + CONVERT(VARCHAR(12), DATEADD(DAY, MinDaysToBeFull, GETUTCDATE()), 107)
		END AS 'Range of Date to be Full<HIDDEN>',
		TotalDataWrittenMB		AS 'Data Written<SIZEMB>',
		TotalAppSizeMB			AS 'App Size<SIZEMB>',
		DataAgingProblem		AS 'Data Aging Problem<HIDDEN>',
		CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
				ELSE (PrevMonthSizeMB-Pre2MonthSizeMB)
		END AS 'Previous Month Change<DifferenceMB><HIDDEN>',
		CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
				ELSE CAST(1.0*(PrevMonthSizeMB-Pre2MonthSizeMB)/(0.01*Pre2MonthSizeMB) AS DECIMAL(30, 2))
		END AS 'Previous Month Change (%)<DifferenceNA><HIDDEN>',
		CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR ISNULL(CurrMonthSizeMB, 0) = 0 THEN NULL
				ELSE (CurrMonthSizeMB-PrevMonthSizeMB)
		END AS 'Current Month Change<DifferenceMB>',
		CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR ISNULL(CurrMonthSizeMB, 0) = 0 THEN NULL
				ELSE CAST(1.0*(CurrMonthSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
		END AS 'Current Month Change (%)<DifferenceNA>',
		CASE WHEN LowWatermark = 0 THEN 'N/A' ELSE CAST(LowWatermark AS NVARCHAR(20)) END	AS 'Low Watermark (%)<HIDDEN>',
		CASE WHEN ISNULL(DaysToReachLowWatermark, -1) < 0 THEN @NA -- For N/A
			 WHEN DaysToReachLowWatermark > 9999 THEN @Never -- For Never
		     ELSE dbo.getUnixtimebig(DATEADD(DAY, DaysToReachLowWatermark, GETUTCDATE()))
		   END AS 'Reach Low Watermark<HIDDEN><MMMDDYYYYNEVER>',
		S.[6MonthsGrowth] AS '6 Month Growth<SIZEMB><HIDDEN>',
		S.[12MonthsGrowth] AS '12 Month Growth<SIZEMB><HIDDEN>',
		S.[18MonthsGrowth] AS '18 Month Growth<SIZEMB><HIDDEN>',
		CASE WHEN TotalSpaceMB  = -1024 AND TotalFreeSpaceMB = -1024 THEN @strInfo
			 WHEN TotalSpaceMB < 0 THEN @strUnknown
			 WHEN ISNULL(DaysToBeFull, -1) >= 0 AND DaysToBeFull < @criticalThreshold THEN @strCritical
			 WHEN ISNULL(DaysToBeFull, -1) >= 0 AND DaysToBeFull >= @criticalThreshold AND DaysToBeFull <= @warningThreshold THEN @strwarning
			 ELSE @strGood
		END AS 'Status<HEALTH_STATUS>'
	FROM #Summary S
		INNER JOIN #Results R ON S.CommServUniqueId = R.CommServUniqueId
		LEFT OUTER JOIN (
			SELECT	R.CommServUniqueId, MP.LibraryId, MAX(MP.HardDriveShared) AS HardDriveShared
			FROM	cf_SurveyMountPathSummary MP
					INNER JOIN #MountPathResults R ON MP.SurveyResultId = R.SurveyResultId
			GROUP BY R.CommServUniqueId, MP.LibraryId
			) SM ON S.CommServUniqueId = SM.CommServUniqueId AND S.LibraryId = SM.LibraryId
	ORDER BY [Status<HEALTH_STATUS>] DESC,'Date to be Full<MMMDDYYYYNEVER>' ASC
  END
  ELSE
  BEGIN
	SELECT
		R.CommServUniqueId		AS 'CommServ UniqueId<DONOTSHOW>',
		R.CommServName			AS 'CommCell Name',
		LibraryName				AS 'Library',
		CASE SM.HardDriveShared WHEN -1 THEN 'N/A' WHEN 0 THEN 'No' ELSE 'Yes' END
								AS 'MountPath/HardDrive Shared<HIDDEN>',
		TotalSpaceMB			AS 'Capacity<SIZEMB>',
		TotalFreeSpaceMB		AS 'Free Space<SIZEMB>',
		CASE
			WHEN (TotalFreeSpaceMB-TotalReserveSpaceMB) <= 0 THEN 0
			ELSE (TotalFreeSpaceMB-TotalReserveSpaceMB)
			END AS 'Available Space<SIZEMB>',
		CASE
			WHEN TotalSpaceMB <= 0 OR (TotalFreeSpaceMB-TotalReserveSpaceMB) <= 0 THEN 0
			ELSE CAST((TotalFreeSpaceMB-TotalReserveSpaceMB)*100.0/TotalSpaceMB AS DECIMAL(10,2))
			END AS 'Available Space(%)<percentNA>',
		TotalReserveSpaceMB		AS 'Reserve Space<SIZEMB><HIDDEN>',
		CASE WHEN ISNULL(DaysToBeFull, -1) < 0 THEN @NA -- For N/A
			 WHEN DaysToBeFull > 9999 THEN @Never -- For Never
		     ELSE dbo.getUnixtimebig(DATEADD(DAY, DaysToBeFull, GETUTCDATE()))
		END AS 'Date to be Full<MMMDDYYYYNEVER>',
		CASE WHEN ISNULL(DaysToBeFull, -1) NOT BETWEEN 1 AND 9999 OR ISNULL(MaxDaysToBeFull, -1) NOT BETWEEN 1 AND 9999 THEN 'N/A'
			 WHEN MinDaysToBeFull < MAXDaysToBeFull
			 THEN CONVERT(VARCHAR(12), DATEADD(DAY, MinDaysToBeFull, GETUTCDATE()), 107) + ' - ' + CONVERT(VARCHAR(12), DATEADD(DAY, MaxDaysToBeFull, GETUTCDATE()), 107)
		     ELSE CONVERT(VARCHAR(12), DATEADD(DAY, MaxDaysToBeFull, GETUTCDATE()), 107) + ' - ' + CONVERT(VARCHAR(12), DATEADD(DAY, MinDaysToBeFull, GETUTCDATE()), 107)
		END AS 'Range of Date to be Full<HIDDEN>',
		TotalDataWrittenMB		AS 'Data Written<SIZEMB>',
		TotalAppSizeMB			AS 'App Size<SIZEMB>',
		DataAgingProblem		AS 'Data Aging Problem<HIDDEN>',
		CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
				ELSE (PrevMonthSizeMB-Pre2MonthSizeMB)
		END AS 'Previous Month Change<DifferenceMB><HIDDEN>',
		CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
				ELSE CAST(1.0*(PrevMonthSizeMB-Pre2MonthSizeMB)/(0.01*Pre2MonthSizeMB) AS DECIMAL(30, 2))
		END AS 'Previous Month Change (%)<DifferenceNA><HIDDEN>',
		CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR ISNULL(CurrMonthSizeMB, 0) = 0 THEN NULL
				ELSE (CurrMonthSizeMB-PrevMonthSizeMB)
		END AS 'Current Month Change<DifferenceMB>',
		CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR ISNULL(CurrMonthSizeMB, 0) = 0 THEN NULL
				ELSE CAST(1.0*(CurrMonthSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
		END AS 'Current Month Change (%)<DifferenceNA>',
		CASE WHEN LowWatermark = 0 THEN 'N/A' ELSE CAST(LowWatermark AS NVARCHAR(20)) END	AS 'Low Watermark (%)<HIDDEN>',
		CASE WHEN ISNULL(DaysToReachLowWatermark, -1) < 0 THEN @NA -- For N/A
			 WHEN DaysToReachLowWatermark > 9999 THEN @Never -- For Never
		     ELSE dbo.getUnixtimebig(DATEADD(DAY, DaysToReachLowWatermark, GETUTCDATE()))
		   END AS 'Reach Low Watermark<HIDDEN><MMMDDYYYYNEVER>',
		S.[6MonthsGrowth] AS '6 Month Growth<SIZEMB><HIDDEN>',
		S.[12MonthsGrowth] AS '12 Month Growth<SIZEMB><HIDDEN>',
		S.[18MonthsGrowth] AS '18 Month Growth<SIZEMB><HIDDEN>',
		CASE WHEN TotalSpaceMB = -1024 AND TotalFreeSpaceMB = -1024 THEN @strInfo
			 WHEN TotalSpaceMB <= 0 THEN @strUnknown
			 WHEN ISNULL(DaysToBeFull, -1) >= 0 AND DaysToBeFull < @criticalThreshold THEN @strCritical
			 WHEN ISNULL(DaysToBeFull, -1) >= 0 AND DaysToBeFull >= @criticalThreshold AND DaysToBeFull <= @warningThreshold THEN @strwarning
			 ELSE @strGood
		END AS 'Status<HEALTH_STATUS>'
	FROM #Summary S
		INNER JOIN #Results R ON S.CommServUniqueId = R.CommServUniqueId
		LEFT OUTER JOIN (
			SELECT	R.CommServUniqueId, MP.LibraryId, MAX(MP.HardDriveShared) AS HardDriveShared
			FROM	cf_SurveyMountPathSummary MP
					INNER JOIN #MountPathResults R ON MP.SurveyResultId = R.SurveyResultId
			GROUP BY R.CommServUniqueId, MP.LibraryId
			) SM ON S.CommServUniqueId = SM.CommServUniqueId AND S.LibraryId = SM.LibraryId
	ORDER BY [Status<HEALTH_STATUS>] DESC,'Date to be Full<MMMDDYYYYNEVER>' ASC
  END
END
DROP TABLE #MountPathResults
DROP TABLE #Results
DROP TABLE #Summary
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Rpt_96DiskLibDetails')
	delete from GxQscripts where name = 'Rpt_96DiskLibDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_96DiskLibDetails')
	delete from GXDBVersions where aliasname = 'Rpt_96DiskLibDetails'
GO

insert into GXDBVersions values(2, 'Rpt_96DiskLibDetails',  '00010019000200260000', 'Rpt_96DiskLibDetails', '00010019000200260000')
GO

