

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/SaveAvailableUpdatePack.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/SaveAvailableUpdatePack.sp,v $ $Id: SaveAvailableUpdatePack.sp,v 1.1.2.3 2019/12/12 19:25:51 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SaveAvailableUpdatePack')
BEGIN
	print '>>> Drop Stored Procedure: SaveAvailableUpdatePack <<<'
	drop procedure SaveAvailableUpdatePack
END
IF EXISTS (select * from GxQscripts where name='SaveAvailableUpdatePack')
	delete from GxQscripts where name = 'SaveAvailableUpdatePack'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SaveAvailableUpdatePack')
	delete from GXDBVersions where aliasname = 'SaveAvailableUpdatePack'
GO
print '... Creating Procedure: SaveAvailableUpdatePack'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SaveAvailableUpdatePack
  @SPInfoXML XML
AS
BEGIN
SET NOCOUNT ON
	DECLARE @ErrorCode INTEGER
	DECLARE @ErrorString NVARCHAR(MAX)
	DECLARE @SaveAvailableUpdatePackTran INT
	SET @SaveAvailableUpdatePackTran = 0
	SET @ErrorCode = 0
	SET @ErrorString = 'SaveAvailableUpdatePack - Start'
	BEGIN TRY
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION SaveAvailableUpdatePackTran
			SET @SaveAvailableUpdatePackTran = 1
		END
		IF object_id('tempdb.dbo.#AvailableUPInfo') is not null DROP TABLE #AvailableUPInfo
		CREATE TABLE #AvailableUPInfo (ReleaseId INT NOT NULL, ServicePack INT NOT NULL, LatestAvailableUPNumber INT NOT NULL, LatestAvailableUPFriendlyName VARCHAR(64) NULL, IsLTS INT)
		INSERT INTO #AvailableUPInfo (ReleaseId, ServicePack, LatestAvailableUPNumber, LatestAvailableUPFriendlyName, IsLTS)
		SELECT
			R.ref.value('@Release', 'INT') AS ReleaseId,
			ISNULL(R.ref.value('@SPMajor', 'INT'), '') AS SPMajor,
			ISNULL(R.ref.value('@UPNumber', 'INT'), '') AS UPNumber,
			ISNULL(R.ref.value('@UPFriendlyName', 'VARCHAR(64)'), 0) AS UPFriendlyName,
			ISNULL(R.ref.value('@IsLTS', 'INT'), 0) AS IsLTS
		FROM @SPInfoXML.nodes('/SPUPInfo') R(ref)
		MERGE cf_ReleaseUpdatePackInfo AS T
		USING #AvailableUPInfo AS S
		ON T.ReleaseId = S.ReleaseId AND T.ServicePack = S.ServicePack
		WHEN MATCHED AND (S.LatestAvailableUPNumber <> T.LatestAvailableUPNumber OR T.IsLTS IS NULL OR T.IsLTS <> S.IsLTS)
			THEN UPDATE SET T.LatestAvailableUPNumber = S.LatestAvailableUPNumber, T.LatestAvailableUPFriendlyName = S.LatestAvailableUPFriendlyName, T.IsLTS = S.IsLTS
		WHEN NOT MATCHED BY TARGET
			THEN INSERT(ReleaseId, ServicePack, LatestAvailableUPNumber, LatestAvailableUPFriendlyName, IsLTS)
			VALUES (S.ReleaseId, S.ServicePack, S.LatestAvailableUPNumber, S.LatestAvailableUPFriendlyName, S.IsLTS);
		IF object_id('tempdb.dbo.#AvailableUPInfo') is not null DROP TABLE #AvailableUPInfo
		IF (@SaveAvailableUpdatePackTran = 1)
		BEGIN
			COMMIT TRANSACTION SaveAvailableUpdatePackTran
			IF @ErrorCode = 0
				SET @ErrorString = 'SaveAvailableUpdatePack  - completed successfully'
			SET @SaveAvailableUpdatePackTran = 0
		END
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END TRY
	BEGIN CATCH
/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
*/
	IF (XACT_STATE() <> 0 AND @SaveAvailableUpdatePackTran = 1)
		ROLLBACK TRANSACTION SaveAvailableUpdatePackTran
		SET @SaveAvailableUpdatePackTran = 0
		SET @ErrorCode = 1
		SET @ErrorString = 'SaveAvailableUpdatePack  - failed with error :: ' + ERROR_MESSAGE()
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END CATCH
	SELECT @ErrorCode, @ErrorString
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'SaveAvailableUpdatePack')
	delete from GxQscripts where name = 'SaveAvailableUpdatePack'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SaveAvailableUpdatePack')
	delete from GXDBVersions where aliasname = 'SaveAvailableUpdatePack'
GO

insert into GXDBVersions values(2, 'SaveAvailableUpdatePack',  '00010001000200030000', 'SaveAvailableUpdatePack', '00010001000200030000')
GO

