

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/SetBillingTag.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/SetBillingTag.sp,v $ $Id: SetBillingTag.sp,v 1.7.2.1 2016/03/11 21:17:03 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SetBillingTag <<<'

IF EXISTS (select * from sysobjects where name='SetBillingTag')
	drop procedure SetBillingTag
IF EXISTS (select * from GxQscripts where name='SetBillingTag')
	delete from GxQscripts where name = 'SetBillingTag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetBillingTag')
	delete from GXDBVersions where aliasname = 'SetBillingTag'
GO
print '... Creating Procedure: SetBillingTag'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SetBillingTag
  @i_UserId INT = NULL,
  @i_DeleteTag INT,
  @i_EntityId INT,
  @i_EntityName NVARCHAR(256),
  @i_Description NVARCHAR(256) = '',
  @i_ContactInfo NVARCHAR(2048) = '',
  @i_PricePerTB DECIMAL(10, 3) = -1,
  @i_BasePriceLevel INT = -1,
  @i_BasePrice DECIMAL(10, 3) = 0,
  @i_DiscountLevel INT = -1,
  @i_DiscountTB DECIMAL(10, 3) = 0,
  @i_DiscountPct DECIMAL(10, 3) = 0,
  @i_SizeType INT = 0
AS
SET NOCOUNT ON
DECLARE @ErrorCode INT = 0
DECLARE @ERROR_TAG_NOT_EXIST INT = 1
DECLARE @ERROR_TAG_ALREADY_EXIST INT = 2
IF @i_DeleteTag = 1
BEGIN
	IF EXISTS (SELECT * FROM cf_SurveyBillingEntity WHERE ID = @i_EntityId)
	BEGIN
		DELETE cf_SurveyPriceTag WHERE TagType = 0 AND TagNameId = @i_EntityId AND UsageType = @i_SizeType
		IF NOT EXISTS (SELECT * FROM cf_SurveyPriceTag WHERE TagType = 0 AND TagNameId = @i_EntityId)
			DELETE cf_SurveyBillingEntity WHERE ID = @i_EntityId
	END
	ELSE
		SET @ErrorCode = @ERROR_TAG_NOT_EXIST
END
ELSE
IF ISNULL(@i_EntityName, '') <> ''
BEGIN
	IF @i_EntityId > 0
	BEGIN
		UPDATE	cf_SurveyBillingEntity
		SET		Name = @i_EntityName, Description = @i_Description, ContactInfo = @i_ContactInfo
		WHERE	ID = @i_EntityId
		IF @i_PricePerTB = -1
			DELETE cf_SurveyPriceTag WHERE TagType = 0 AND TagNameId = @i_EntityId
		ELSE
		IF EXISTS (SELECT * FROM cf_SurveyPriceTag WHERE TagType = 0 AND TagNameId = @i_EntityId AND UsageType = @i_SizeType
		AND (PricePerTB <> @i_PricePerTB OR BasePriceLevel <> @i_BasePriceLevel OR BasePrice <> @i_BasePrice
			OR DiscountLevel <> @i_DiscountLevel OR DiscountTB <> @i_DiscountTB OR DiscountPct <> @i_DiscountPct))
			UPDATE	cf_SurveyPriceTag
			SET		PricePerTB = @i_PricePerTB, BasePriceLevel = @i_BasePriceLevel, BasePrice = @i_BasePrice,
					DiscountLevel = @i_DiscountLevel, DiscountTB = @i_DiscountTB, DiscountPct = @i_DiscountPct
			WHERE	TagType = 0 AND TagNameId = @i_EntityId AND UsageType = @i_SizeType
		ELSE
		IF NOT EXISTS (SELECT * FROM cf_SurveyPriceTag WHERE TagType = 0 AND TagNameId = @i_EntityId AND UsageType = @i_SizeType)
			INSERT	INTO cf_SurveyPriceTag
			SELECT	0, @i_SizeType, 0, 0, '', @i_PricePerTB, @i_EntityId, 0, @i_BasePriceLevel, @i_BasePrice, @i_DiscountLevel, @i_DiscountTB, @i_DiscountPct
		ELSE
			SET @ErrorCode = @ERROR_TAG_ALREADY_EXIST
	END
	ELSE
	IF NOT EXISTS (SELECT * FROM cf_SurveyBillingEntity WHERE Name = @i_EntityName)
	BEGIN
		INSERT INTO cf_SurveyBillingEntity
		SELECT NEWID(), @i_EntityName, @i_Description, @i_ContactInfo, GETUTCDATE()
		SET @i_EntityId = ISNULL(SCOPE_IDENTITY(), 0)
		IF  @i_EntityId > 0 AND @i_PricePerTB >= 0
			INSERT	INTO cf_SurveyPriceTag
			SELECT	0, @i_SizeType, 0, 0, '', @i_PricePerTB, @i_EntityId, 0, @i_BasePriceLevel, @i_BasePrice, @i_DiscountLevel, @i_DiscountTB, @i_DiscountPct
	END
END
SELECT @ErrorCode
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SetBillingTag')
	delete from GxQscripts where name = 'SetBillingTag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetBillingTag')
	delete from GXDBVersions where aliasname = 'SetBillingTag'
GO

insert into GXDBVersions values(2, 'SetBillingTag',  '00010007000200010000', 'SetBillingTag', '00010007000200010000')
GO

