

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/UpdateCommCellGroupAssociation.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/UpdateCommCellGroupAssociation.sp,v $ $Id: UpdateCommCellGroupAssociation.sp,v 1.7.2.11 2020/02/20 04:48:47 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='UpdateCommCellGroupAssociation')
BEGIN
	print '>>> Drop Stored Procedure: UpdateCommCellGroupAssociation <<<'
	drop procedure UpdateCommCellGroupAssociation
END
IF EXISTS (select * from GxQscripts where name='UpdateCommCellGroupAssociation')
	delete from GxQscripts where name = 'UpdateCommCellGroupAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateCommCellGroupAssociation')
	delete from GXDBVersions where aliasname = 'UpdateCommCellGroupAssociation'
GO
print '... Creating Procedure: UpdateCommCellGroupAssociation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure UpdateCommCellGroupAssociation
  @i_Association XML,
  @i_inputType INT = 0, --0:XML, 1:CSV
  @i_fileName NVARCHAR(1024) = ''
AS
BEGIN
SET NOCOUNT ON
	DECLARE @ErrorCode INTEGER
	DECLARE @ErrorString NVARCHAR(MAX)
	SET @i_inputType = ISNULL(@i_inputType, 0)
	DECLARE @UpdateCommCellGroupTran INT
	SET @UpdateCommCellGroupTran = 0
	SET @ErrorCode = 0
	SET @ErrorString = 'UpdateCommCellGroupAssociation - Start'
	BEGIN TRY
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION UpdateCommCellGroupTran
			SET @UpdateCommCellGroupTran = 1
		END
		IF (@i_inputType = 0) --XML based input.
		BEGIN
			--<DeletedGroup GroupName="NoCvltEmp" GroupType="1"/>
			DECLARE @delGroupId INT = -1, @delGroupName NVARCHAR(512) = '', @delGroupType INT = 1
			SELECT
				@delGroupName = ISNULL(R.ref.value('@GroupName', 'NVARCHAR(512)'), ''),
				@delGroupType = ISNULL(R.ref.value('@GroupType', 'INT'), 1)
			FROM @i_Association.nodes('/DeletedGroup') R(ref)
			--<UpdatedGroup />
			IF object_id('tempdb.dbo.#updatedCommCellGroups') is not null DROP TABLE #updatedCommCellGroups
			CREATE TABLE #updatedCommCellGroups(
				GroupId				INT,
				GroupName			NVARCHAR(512),
				GroupDescription	NVARCHAR(MAX),
				GroupModified		INT,
				modifiedBy			INT,
				GroupCreated		INT,
				createdBy			INT,
				modifiedByUser		nvarchar(255),
				createdByUser		nvarchar(255),
				isProfileEnabled	INT,
				Flag				INT,
				Status				INT)
			IF object_id('tempdb.dbo.#updatedCommCellGroupAssoc') is not null DROP TABLE #updatedCommCellGroupAssoc
			CREATE TABLE #updatedCommCellGroupAssoc(GroupId INT, ClientGUID VARCHAR(256))
			DECLARE @updatedClientGroupId INT = 0
			IF object_id('tempdb.dbo.#companies') IS NOT NULL DROP TABLE #companies
			CREATE TABLE #companies(GroupId INT, GroupName NVARCHAR(512), AssocClientGroupId INT DEFAULT 0)
			INSERT INTO #companies(GroupId, GroupName, AssocClientGroupId)
			SELECT
				R.ref.value('company[1]/@userGroupId', 'INT') AS GroupId,
				ISNULL(R.ref.value('company[1]/@userGroupName', 'NVARCHAR(512)'), '') AS GroupName,
				ISNULL(R.ref.value('commcellGroup[1]/@clientGroupId', 'INT'), 0) AS AssocClientGroupId
			FROM @i_Association.nodes('/companies') R(ref)
			IF EXISTS (SELECT 1 FROM #companies) --From Companies
			BEGIN
				INSERT INTO #updatedCommCellGroups(GroupId, GroupName, GroupDescription, GroupModified, modifiedBy, GroupCreated, createdBy, modifiedByUser, createdByUser, isProfileEnabled, Flag, Status)
				SELECT
					R.ref.value('@GroupId', 'int') AS GroupId,
					ISNULL(R.ref.value('@GroupName', 'NVARCHAR(512)'), '') AS GroupName,
					ISNULL(R.ref.value('@GroupDescription', 'NVARCHAR(MAX)'), '') AS GroupDescription,
					ISNULL(R.ref.value('@GroupModified', 'int'), 0) AS GroupModified,
					ISNULL(R.ref.value('@modifiedBy', 'int'), 0) AS modifiedBy,
					ISNULL(R.ref.value('@GroupCreated', 'int'), 0) AS GroupCreated,
					ISNULL(R.ref.value('@createdBy', 'int'), 0) AS createdBy,
					ISNULL(R.ref.value('@modifiedByUser', 'NVARCHAR(MAX)'), '') AS modifiedByUser,
					ISNULL(R.ref.value('@createdByUser', 'NVARCHAR(MAX)'), '') AS createdByUser,
					ISNULL(R.ref.value('@isProfileEnabled', 'int'), 0) AS isProfileEnabled,
					ISNULL(R.ref.value('@Flag', 'int'), 0) AS Flag,
					ISNULL(R.ref.value('@Status', 'int'), 0) AS Status
				FROM @i_Association.nodes('/companies/UpdatedGroup') R(ref)
				SELECT @updatedClientGroupId = (SELECT TOP 1 GroupId FROM #updatedCommCellGroups)
				INSERT INTO #updatedCommCellGroupAssoc(GroupId, ClientGUID)
				SELECT
					@updatedClientGroupId AS GroupId,
					ISNULL(R.ref.value('@ClientGUID', 'VARCHAR(256)'), '') AS ClientGUID
				FROM @i_Association.nodes('/companies/UpdatedGroup/Client') R(ref)
			END
			ELSE
			BEGIN --From App_ClientGroups
				INSERT INTO #updatedCommCellGroups(GroupId, GroupName, GroupDescription, GroupModified, modifiedBy, GroupCreated, createdBy, modifiedByUser, createdByUser, isProfileEnabled, Flag, Status)
				SELECT
					R.ref.value('@GroupId', 'int') AS GroupId,
					ISNULL(R.ref.value('@GroupName', 'NVARCHAR(512)'), '') AS GroupName,
					ISNULL(R.ref.value('@GroupDescription', 'NVARCHAR(MAX)'), '') AS GroupDescription,
					ISNULL(R.ref.value('@GroupModified', 'int'), 0) AS GroupModified,
					ISNULL(R.ref.value('@modifiedBy', 'int'), 0) AS modifiedBy,
					ISNULL(R.ref.value('@GroupCreated', 'int'), 0) AS GroupCreated,
					ISNULL(R.ref.value('@createdBy', 'int'), 0) AS createdBy,
					ISNULL(R.ref.value('@modifiedByUser', 'NVARCHAR(MAX)'), '') AS modifiedByUser,
					ISNULL(R.ref.value('@createdByUser', 'NVARCHAR(MAX)'), '') AS createdByUser,
					ISNULL(R.ref.value('@isProfileEnabled', 'int'), 0) AS isProfileEnabled,
					ISNULL(R.ref.value('@Flag', 'int'), 0) AS Flag,
					ISNULL(R.ref.value('@Status', 'int'), 0) AS Status
				FROM @i_Association.nodes('/UpdatedGroup') R(ref)
				SELECT @updatedClientGroupId = (SELECT TOP 1 GroupId FROM #updatedCommCellGroups)
				IF (@updatedClientGroupId > 0)
				BEGIN
					INSERT INTO #updatedCommCellGroupAssoc(GroupId, ClientGUID)
					SELECT
						@updatedClientGroupId AS GroupId,
						ISNULL(R.ref.value('@ClientGUID', 'VARCHAR(256)'), '') AS ClientGUID
					FROM @i_Association.nodes('/UpdatedGroup/Client') R(ref)
				END
			END
			IF LEN(@delGroupName) > 0
			BEGIN
				IF @delGroupType = 1	--delete app_clientgroup based entry
					DELETE FROM cf_CommcellGroup WHERE name = @delGroupName
				ELSE
				BEGIN	--delete company entry
					SELECT @delGroupId = clientGroupId FROM cf_CustomerGroup WHERE name = @delGroupName
					DELETE FROM cf_CommcellGroup WHERE id = @delGroupId
					DELETE FROM cf_CustomerGroup WHERE name = @delGroupName
				END
			END
			IF EXISTS (SELECT 1 FROM #companies)
			BEGIN
				DELETE CG FROM cf_CustomerGroup CG
					INNER JOIN #companies C
						ON CG.id = C.GroupId
				INSERT INTO cf_CustomerGroup(id, name, clientGroupId)
				SELECT GroupId, GroupName, AssocClientGroupId FROM #companies
			END
			IF EXISTS (SELECT 1 FROM #updatedCommCellGroups)
			BEGIN
				--Remove deleted groups and association
				-- 10001 is the CommCell Group for Shrinking CommCells report.
				DELETE FROM cf_CommcellGroup WHERE (id <> 10001) AND id IN (SELECT GroupId FROM #updatedCommCellGroups)
				INSERT INTO cf_CommcellGroup(id, name, description, modified, modifiedBy, created, createdBy, modifiedByUser, createdByUser, isProfileEnabled, flag, status)
					SELECT t.GroupId, t.GroupName, t.GroupDescription, t.GroupModified, t.modifiedBy, t.GroupCreated, t.createdBy, t.modifiedByUser, t.createdByUser, t.isProfileEnabled, t.Flag, t.Status
						FROM #updatedCommCellGroups t
				INSERT INTO cf_CommcellGroupAssoc
					SELECT t.GroupId, c.ID, ta.ClientGUID
						FROM #updatedCommCellGroups t
							INNER JOIN #updatedCommCellGroupAssoc ta
								ON t.GroupId = ta.GroupId
							INNER JOIN cf_CommcellIdNameMap c WITH(NOLOCK)
								ON ta.ClientGUID = c.CommServGUID
			END
			IF object_id('tempdb.dbo.#updatedCommCellGroups') is not null DROP TABLE #updatedCommCellGroups
			IF object_id('tempdb.dbo.#updatedCommCellGroupAssoc') is not null DROP TABLE #updatedCommCellGroupAssoc
			IF object_id('tempdb.dbo.#companies') IS NOT NULL DROP TABLE #companies
		END
		ELSE IF (@i_inputType = 1) 		--Full sync up based on csv file
		BEGIN
			--if CommCellGroupInitProfileFlag Force FULL Sync
			IF EXISTS(SELECT * FROM cf_SurveyConfig WITH(NOLOCK) WHERE Name = 'CommCellGroupInitProfileFlag' AND Value = '0')
			BEGIN
				--Delete all groups so that full sync will be done
				--10001 is the CommCell Group for Shrinking CommCells report.
				DELETE FROM cf_CommcellGroup WHERE (id <> 10001)
				UPDATE cf_SurveyConfig SET Value = '1' WHERE Name = 'CommCellGroupInitProfileFlag'
			END
			IF object_id('tempdb.dbo.#CommCellGroupAssociation') is not null DROP TABLE #CommCellGroupAssociation
			CREATE TABLE #CommCellGroupAssociation(
				GroupType			INT,
				GroupId				INT,
				GroupName			NVARCHAR(512),
				GroupDescription	NVARCHAR(MAX),
				GroupModified		INT,
				modifiedBy			INT,
				GroupCreated		INT,
				createdBy			INT,
				modifiedByUser		nvarchar(255),
				createdByUser		nvarchar(255),
				isProfileEnabled	INT,
				Flag				INT,
				Status				INT,
				ClientGUID			VARCHAR(256),
				AssocClientGroupId	INT)
			DECLARE @sql NVARCHAR(2000) = 'BULK INSERT #CommCellGroupAssociation FROM ''' + @i_fileName + ''' WITH ( FIELDTERMINATOR =''~'', ROWTERMINATOR =''\n'' )';
			EXEC(@sql);
			SELECT @ErrorCode = @@ERROR
			IF @ErrorCode = 0
			BEGIN
				MERGE cf_CommcellGroup CG
				USING (
				SELECT DISTINCT
						GroupId,
						ISNULL(GroupName, '') AS GroupName,
						ISNULL(GroupDescription, '') AS GroupDescription,
						ISNULL(GroupModified, 0) AS GroupModified,
						ISNULL(modifiedBy, 0) AS modifiedBy,
						ISNULL(GroupCreated, 0) AS GroupCreated,
						ISNULL(createdBy, 0) AS createdBy,
						ISNULL(modifiedByUser, '') AS modifiedByUser,
						ISNULL(createdByUser, '') AS createdByUser,
						ISNULL(isProfileEnabled, 0) AS isProfileEnabled,
						Flag,
						Status
				FROM #CommCellGroupAssociation WHERE GroupType = 1) AS TCG
					ON CG.id = TCG.GroupId
				WHEN MATCHED AND CG.modified < TCG.GroupModified THEN
					UPDATE SET CG.name = TCG.GroupName,
						CG.description = TCG.GroupDescription,
						CG.modified =TCG.GroupModified,
						CG.modifiedBy = TCG.modifiedBy,
						CG.modifiedByUser = TCG.modifiedByUser,
						CG.isProfileEnabled = TCG.isProfileEnabled,
						CG.flag = TCG.Flag,
						CG.status = TCG.Status
				WHEN NOT MATCHED BY TARGET THEN
					INSERT (id, name, description, modified, modifiedBy, created, createdBy, modifiedByUser, createdByUser, isProfileEnabled, flag, status)
					VALUES (TCG.GroupId, TCG.GroupName, TCG.GroupDescription, TCG.GroupModified, TCG.modifiedBy, TCG.GroupCreated, TCG.createdBy, TCG.modifiedByUser, TCG.createdByUser, TCG.isProfileEnabled, TCG.Flag, TCG.Status)
				WHEN NOT MATCHED BY SOURCE AND CG.id <> 10001 THEN -- 10001 is the CommCell Group for Shrinking CommCells report.
					DELETE;
				MERGE cf_CommcellGroupAssoc T
				USING (
					SELECT DISTINCT t.GroupId, c.ID, t.ClientGUID
					FROM #CommCellGroupAssociation t
						INNER JOIN cf_CommcellIdNameMap c WITH(NOLOCK)
							ON t.ClientGUID = c.CommServGUID
				) S
					ON T.CommCellGroupId = S.GroupId AND T.CommCellGUID = S.ClientGUID
				WHEN NOT MATCHED BY TARGET THEN
					INSERT(CommCellGroupId, CommcellIdNameMap_ID, CommCellGUID)
					VALUES(S.GroupId, S.ID, S.ClientGUID)
				WHEN NOT MATCHED BY SOURCE THEN
					DELETE;
				--Update CommCellUniqueId for those commcells which are deleted and recreated in CVCloud database
				UPDATE CGA SET CGA.CommcellIdNameMap_ID = CC.ID
					FROM cf_CommcellGroupAssoc CGA
					INNER JOIN cf_CommcellIdNameMap CC
						ON CGA.CommCellGUID = CC.CommServGUID
						AND CGA.CommcellIdNameMap_ID <> CC.ID
				IF EXISTS (SELECT 1 FROM #CommCellGroupAssociation WHERE GroupType = 2)
				BEGIN
					DELETE FROM cf_CustomerGroup
					INSERT INTO cf_CustomerGroup(id, name, clientGroupId, flag, status)
					SELECT GroupId, GroupName, AssocClientGroupId, ISNULL(flag, 0), ISNULL(status, 0) FROM #CommCellGroupAssociation WHERE GroupType = 2
				END
			END
			ELSE
				SET @ErrorString = 'UpdateCommCellGroupAssociation  - failed with error :: ' + ERROR_MESSAGE()
			IF object_id('tempdb.dbo.#CommCellGroupAssociation') is not null DROP TABLE #CommCellGroupAssociation
		END
		ELSE
		BEGIN
			SET @ErrorCode = 1
			SET @ErrorString = 'UpdateCommCellGroupAssociation  - failed. Incorrect arguments passed.'
		END
		IF (@UpdateCommCellGroupTran = 1)
		BEGIN
			COMMIT TRANSACTION UpdateCommCellGroupTran
			IF @ErrorCode = 0
				SET @ErrorString = 'UpdateCommCellGroupAssociation  - completed successfully'
			SET @UpdateCommCellGroupTran = 0
		END
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END TRY
	BEGIN CATCH
/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
*/
	IF (XACT_STATE() <> 0 AND @UpdateCommCellGroupTran = 1)
		ROLLBACK TRANSACTION UpdateCommCellGroupTran
		SET @UpdateCommCellGroupTran = 0
		SET @ErrorCode = 1
		SET @ErrorString = 'UpdateCommCellGroupAssociation  - failed with error :: ' + ERROR_MESSAGE()
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END CATCH
	SELECT @ErrorCode, @ErrorString
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'UpdateCommCellGroupAssociation')
	delete from GxQscripts where name = 'UpdateCommCellGroupAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateCommCellGroupAssociation')
	delete from GXDBVersions where aliasname = 'UpdateCommCellGroupAssociation'
GO

insert into GXDBVersions values(2, 'UpdateCommCellGroupAssociation',  '00010007000200110000', 'UpdateCommCellGroupAssociation', '00010007000200110000')
GO

