

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/cvsp_setPermissionsOnUsers.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/cvsp_setPermissionsOnUsers.sp,v $ $Id: cvsp_setPermissionsOnUsers.sp,v 1.1.2.8 2018/05/03 03:39:36 sjohnson Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: cvsp_setPermissionsOnUsers <<<'

IF EXISTS (select * from sysobjects where name='cvsp_setPermissionsOnUsers')
	drop procedure cvsp_setPermissionsOnUsers
IF EXISTS (select * from GxQscripts where name='cvsp_setPermissionsOnUsers')
	delete from GxQscripts where name = 'cvsp_setPermissionsOnUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_setPermissionsOnUsers')
	delete from GXDBVersions where aliasname = 'cvsp_setPermissionsOnUsers'
GO
print '... Creating Procedure: cvsp_setPermissionsOnUsers'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure cvsp_setPermissionsOnUsers
  @errorCode INT OUTPUT,
  @errorMessage NVARCHAR(MAX) OUTPUT
AS
SET NOCOUNT ON
DECLARE @id			   INT
DECLARE @i_userName    NVARCHAR(1024)
DECLARE @i_state       NVARCHAR(256)
DECLARE @i_pname       NVARCHAR(256)
DECLARE @i_oname	   NVARCHAR(1024)
DECLARE @i_oType	   NVARCHAR(16)
DECLARE @i_columnName  NVARCHAR(256)
DECLARE @count		   INT
DECLARE @retVal		   INT
DECLARE @getTotalCounts INT
DECLARE @debug		   INT = 0
DECLARE @datetime	   DATETIME
DECLARE @VFlag		   INT = 0
SET @retVal = 0
SET @count  = 0
SET @getTotalCounts = (select COUNT(*) from cvDBPermissionsOnUsers WITH(NOLOCK) where flags IN (0,2,3))
BEGIN TRY
	BEGIN TRANSACTION SetPermissionOnUser
		DECLARE set_permission CURSOR FOR
		SELECT  Id,UserName,permissionType,permissionState,objectName,objectType,columnName
FROM cvDBPermissionsOnUsers WITH (NOLOCK) where flags IN (0,2,3)
		OPEN set_permission
		DECLARE @permission nvarchar(max)
		FETCH FROM set_permission INTO @id,@i_userName,@i_state,@i_pname,@i_oname,@i_oType,@i_columnName
		WHILE @@Fetch_status = 0
		BEGIN
			SET @datetime = GETUTCDATE()
			IF @i_state = 'GRANT_WITH_GRANT_OPTION'
			SET @permission = 'GRANT ' + @i_pname+' on '+@i_oname+' '+ (CASE WHEN @i_columnName IS NULL THEN '' ELSE +'('+@i_columnName+') ' END) + 'to ['+ @i_userName +'] WITH GRANT OPTION'
			ELSE
			SET @permission = @i_state +' '+@i_pname+' on '+@i_oname+' '+ (CASE WHEN @i_columnName IS NULL THEN '' ELSE +'('+@i_columnName+') ' END) + 'to ['+ @i_userName +']'
			IF @debug  <> 0
				PRINT @permission
			IF EXISTS(select * from sysobjects where id  = (SELECT object_id(@i_oname)))
			BEGIN
				IF ISNULL(@i_columnName,'') <> ''
				BEGIN
					IF EXISTS(SELECT * FROM information_schema.COLUMNS WHERE TABLE_NAME = (SELECT SUBSTRING(@i_oname, CHARINDEX('.', @i_oname) + 1, LEN(@i_oname))) AND COLUMN_NAME = @i_columnName)
					BEGIN
						EXECUTE @retval = sp_executeSql @permission
SET @VFlag = 1
					END
					ELSE
					BEGIN
						SET @retVal = 0
SET @VFlag = 3 -- Column Not Found for Table
					END
				END
				ELSE
				BEGIN
					EXECUTE @retval = sp_executeSql @permission
SET @VFlag = 1
				END
			END
			ELSE
			BEGIN
SET @vFlag = 2 -- Object Not Found in Database
				SET @retVal = 0
			END
			IF @retval = 0
			BEGIN
				SET @count = @count + 1
				UPDATE   a
				SET flags = @vFlag, lastActivity = @datetime
				from  cvDBPermissionsOnUsers as a where a.Id = @id
			END
			FETCH FROM set_permission INTO @id,@i_userName,@i_state,@i_pname,@i_oname,@i_oType,@i_columnName
		END
		CLOSE set_permission
		DEALLOCATE set_permission
		IF @getTotalCounts = @count
		BEGIN
				COMMIT TRANSACTION SetPermissionOnUser
				SET @errorCode = 0
				SET @errorMessage = ''
		END
		ELSE
		BEGIN
			ROLLBACK TRANSACTION SetPermissionOnUser
			SET @errorCode = 1
			SET @errorMessage = 'Error: Set Permissions are failed for Permission:'+@permission
		END
END TRY
BEGIN CATCH
	CLOSE set_permission
	DEALLOCATE set_permission
    ROLLBACK TRANSACTION SetPermissionOnUser
/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
*/
    SET @errorCode = ERROR_NUMBER()
    SET @errorMessage = 'Error : Procedure [cvsp_setPermissionsOnUsers] Failed to execute Permission' + @permission
END CATCH
--delete  from cvDBPermissionsOnUsers
RETURN @errorCode;
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'cvsp_setPermissionsOnUsers')
	delete from GxQscripts where name = 'cvsp_setPermissionsOnUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_setPermissionsOnUsers')
	delete from GXDBVersions where aliasname = 'cvsp_setPermissionsOnUsers'
GO

insert into GXDBVersions values(2, 'cvsp_setPermissionsOnUsers',  '00010001000200080000', 'cvsp_setPermissionsOnUsers', '00010001000200080000')
GO

