

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/runCustomAlarm.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/runCustomAlarm.sp,v $ $Id: runCustomAlarm.sp,v 1.19.2.4 2016/08/25 13:47:19 dkraplanee Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: runCustomAlarm <<<'

IF EXISTS (select * from sysobjects where name='runCustomAlarm')
	drop procedure runCustomAlarm
IF EXISTS (select * from GxQscripts where name='runCustomAlarm')
	delete from GxQscripts where name = 'runCustomAlarm'
GO

IF EXISTS (select * from GXDBVersions where aliasname='runCustomAlarm')
	delete from GXDBVersions where aliasname = 'runCustomAlarm'
GO
print '... Creating Procedure: runCustomAlarm'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure runCustomAlarm
  @i_inXML XML,
  @i_type INTEGER,
  @i_CCGUID NVARCHAR(1024)
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@i_ParamName		NVARCHAR(1024)
	DECLARE	@i_ParamValue		NVARCHAR(1024)
	DECLARE	@i_Operator			INTEGER
	DECLARE	@i_Status			NVARCHAR(1024)
	-- Operator 0 - <, 1 - >, 2 - =
	DECLARE @warningThreshold	INT
	DECLARE @criticalThreshold	INT
	DECLARE @i_CommServUniqueId INT
	DECLARE @goodMessage		NVARCHAR(MAX)
	DECLARE @warningMessage		NVARCHAR(MAX)
	DECLARE @criticalMessage	NVARCHAR(MAX)
	DECLARE @infoMessage		NVARCHAR(MAX)
	SELECT @i_CommServUniqueId = ID FROM cf_CommCellIdNameMap WHERE CommServGUID = @i_CCGUID
	DECLARE @TblSurveyResult TABLE
	(
		CommServUniqueId INTEGER NULL,
		GroupId INTEGER NULL,
		GroupName NVARCHAR(MAX) NULL,
		MonitorId INTEGER NULL,
		Monitor NVARCHAR(MAX) NULL,
		Status VARCHAR(10) NULL,
		LogDate DATETIME,
		Result NVARCHAR(MAX),
		ExpectedResult NVARCHAR(MAX),
		Recommendation NVARCHAR(MAX),
		GroupSortOrder INT,
		MonitorSortOrder INT
	)
	DECLARE @TblLatestResult TABLE (QueryId INT, SurveyResultId INT)
	INSERT INTO @tblSurveyResult
	SELECT	@i_CommServUniqueId, sGroup.SurveyGroupId, sGroup.Name, survey.QueryId, CASE WHEN LEN(map.ParameterName) > 0 THEN map.ParameterName ELSE survey.Name END, 'Unknown', '', '', '', '' , map.GroupSortOrder, map.SurveySortOrder
	FROM	cf_CommservSurveyQueries AS survey
			INNER JOIN cf_CommservSurveyGroupMap AS map
				ON map.SurveyId = survey.QueryId
				AND Flags & 4 = 4
			INNER JOIN cf_CommservSurveyGroups as sGroup
				ON sGroup.SurveyGroupId = map.GroupId
	INSERT	INTO @TblLatestResult
	SELECT	DISTINCT R.QueryId, R.CommservSurveyResults_ID
	FROM	cf_CommservSurveyResults R WITH (NOLOCK)
			INNER JOIN @TblSurveyResult S ON R.QueryId = S.MonitorId
	WHERE	R.CommcellIdNameMap_ID = @i_CommServUniqueId AND R.Flags = 1
	IF object_id('tempdb.dbo.#resultTbl') is not null DROP TABLE #resultTbl
	CREATE TABLE #resultTbl (Result NVARCHAR(MAX), CommServeName NVARCHAR(256), Reason NVARCHAR(MAX), Remarks NVARCHAR(MAX))
	DECLARE @tmpStatus NVARCHAR(MAX)
	DECLARE @tmpReason NVARCHAR(MAX)
	DECLARE @tmpRemarks NVARCHAR(MAX)
	DECLARE @query NVARCHAR(MAX) = N''
	IF @i_type = 0
	BEGIN
		SELECT	@i_paramName = T.cc.value('@name', 'nvarchar(255)'),
				@i_status = ISNULL(T.cc.value('@status', 'nvarchar(255)'), ''),
				@i_paramValue = T.cc.value('@value', 'nvarchar(255)'),
				@i_operator = T.cc.value('@operator', 'nvarchar(255)')
		FROM	@i_inXML.nodes('/survey_AlarmCondition/columnList') T(cc)
		IF @i_paramName = 'SLA'
		BEGIN
			DECLARE @slaPercent FLOAT =100
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 27
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage FROM cf_SurveyHealthParam WHERE QueryId = 27
			SELECT	@slaPercent = CASE
					WHEN (sub.NotProtectedSubclients+sub.ProtectedSubclients)>0
					THEN sub.ProtectedSubclients*100/(sub.NotProtectedSubclients+sub.ProtectedSubclients)
					ELSE 0 END
			FROM	(SELECT TOP 1
							csInfo.CommServUniqueId,
							csInfo.ProtectedSubclients,
							csInfo.NotProtectedSubclients
					FROM	cf_SurveyUnprotectedClients AS csInfo WITH (NOLOCK)
							INNER JOIN @TblLatestResult AS result
								ON result.SurveyResultId = csInfo.SurveyResultId
								AND result.QueryID = 27 AND (csInfo.Days = 30 OR csInfo.Days < 0)
					) AS sub
			SET @slaPercent = CAST (@slaPercent AS INT)
			if (@slaPercent < @criticalThreshold)
				SET @tmpStatus = 'Critical'
			else if (@slaPercent < @warningThreshold)
				SET @tmpStatus = 'Warning'
			else
				SET @tmpStatus = 'Good'
			IF @i_status = ''
			BEGIN
				IF ((@i_operator = 0 AND @slaPercent < @i_ParamValue) OR
							(@i_operator = 1 AND @slaPercent > @i_ParamValue) OR
							(@i_operator = 2 AND @slaPercent = @i_ParamValue))
				BEGIN
					INSERT INTO #resultTbl(Result) VALUES (CAST(@slaPercent AS NVARCHAR(32))+'%')
					UPDATE	#resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
					UPDATE #resultTbl SET Result = '<b>' + @i_ParamName + '</b> of CommCell <b>' + CommServeName + '</b> has reached <b>' + Result + '</b>'
					UPDATE #resultTbl SET Reason = 'SLA is ' + CAST(@slaPercent AS NVARCHAR(32))+'%'
				END
			END
			ELSE
			BEGIN
				IF (@i_status = 'Critical' AND @slaPercent < @criticalThreshold)
				BEGIN
					INSERT INTO #resultTbl(Result) VALUES (CAST(@slaPercent AS NVARCHAR(32))+'%')
				END
				ELSE IF (@i_status = 'Warning' AND @slaPercent < @warningThreshold)
				BEGIN
					INSERT INTO #resultTbl(Result) VALUES (CAST(@slaPercent AS NVARCHAR(32))+'%')
				END
				ELSE IF (@i_status = 'Good' AND @slaPercent >= @warningThreshold)
				BEGIN
					INSERT INTO #resultTbl(Result) VALUES (CAST(@slaPercent AS NVARCHAR(32))+'%')
				END
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTbl SET Result = '<b>' + @i_ParamName + '</b> of CommCell <b>' + CommServeName + '</b> is at <b>'+ @tmpStatus +'</b> status.'
				UPDATE #resultTbl SET Reason = 'SLA is ' + CAST(@slaPercent AS NVARCHAR(32))+'%'
			END
			UPDATE	#resultTbl
			SET		Remarks = (CASE WHEN @tmpStatus = 'Critical' THEN 'Look at the failing clients'
									WHEN @tmpStatus = 'Critical' THEN 'Look at the failing clients'
									ELSE 'Meets SLA' END) + '<br><br>' +
									'For suggestions on how to improve SLA, visit documentation: <a class="hc-cell-a" href="http://documentation.commvault.com/commvault/release_10_0_0/books_online_1/english_us/features/reports/metrics/health_check_settings.htm">How to Improve SLA?</a>'
			--SET		Remarks = (CASE WHEN @slaPercent < P.CriticalThreshold THEN P.CriticalMessage WHEN @slaPercent < P.WarningThreshold THEN P.WarningMessage ELSE P.GoodMessage END)
			--FROM	#resultTbl S, cf_SurveyHealthParam P
			--WHERE	P.QueryId = 27
		END
		ELSE IF @i_paramName = 'CommCell Version'
		BEGIN
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 12
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage FROM cf_SurveyHealthParam WHERE QueryId = 12
			DECLARE @CSVersion VARCHAR(128) = ''
			DECLARE @ReleaseNo INT
			DECLARE @SPMajorNo INT
			DECLARE @SPMinorNo VARCHAR(1) = ''
			DECLARE @LatestSP  INT
			SELECT	@CSVersion = CASE
						WHEN CommServVersion IS NULL THEN 'Unknown'
						WHEN CommServVersion = 'Not Found' THEN 'Unknown'
						ELSE SUBSTRING(CommServVersion, 0, CHARINDEX('(', CommServVersion)) + ' ' + SUBSTRING(CommServVersion, CHARINDEX(')', CommServVersion)+1, LEN(CommServVersion))
					END
			FROM	cf_CommCellIdNameMap WITH (NOLOCK)
			WHERE	CommServGUID = @i_CCGUID
			IF @CSVersion <> 'Unknown' AND ISNULL(@CSVersion, '') <> ''
			BEGIN
				DECLARE @CSVersionToRpt VARCHAR(128)
				SET @CSVersion = REPLACE(LTRIM(@CSVersion), '.', ' ')
				SET @CSVersionToRpt = @CSVersion
				IF CHARINDEX(' ', @CSVersion) > 0
					SET @ReleaseNo = LEFT(@CSVersion, CHARINDEX(' ', @CSVersion) - 1)
				ELSE
					SET @ReleaseNo = @CSVersion
				SET @CSVersion = SUBSTRING(@CSVersion, CHARINDEX('SP', @CSVersion)+2, LEN(@CSVersion))
				IF ISNUMERIC(RIGHT(@CSVersion, 1)) = 1
					SET @SPMajorNo = @CSVersion
				ELSE
				BEGIN
					SET @SPMajorNo = SUBSTRING(@CSVersion, 1, LEN(@CSVersion)-1)
					SET @SPMinorNo = SUBSTRING(@CSVersion, LEN(@CSVersion)-1, LEN(@CSVersion))
				END
				IF @ReleaseNo = 9
					SELECT @LatestSP = CAST(value AS INT) FROM cf_SurveyConfig WHERE name = '9_0_LatestSPMajorNo'
				ELSE IF @ReleaseNo = 10
					SELECT @LatestSP = CAST(value AS INT) FROM cf_SurveyConfig WHERE name = '10_0_LatestSPMajorNo'
				ELSE IF @ReleaseNo = 11
					SELECT @LatestSP = CAST(value AS INT) FROM cf_SurveyConfig WHERE name = '11_0_LatestSPMajorNo'
				SET @tmpStatus =
					CASE
						WHEN (@LatestSP - @SPMajorNo) >= @criticalThreshold THEN 'Critical'
						WHEN (@SPMinorNo <> '') OR ((@LatestSP - @SPMajorNo) >= @warningThreshold) THEN 'Warning'
						ELSE 'Good'
					END
				IF (@i_status <> '')
				BEGIN
					IF (@i_status = 'Critical' AND @tmpStatus = 'Critical')
					BEGIN
						INSERT INTO #resultTbl (Result) VALUES (@CSVersionToRpt)
					END
					ELSE IF (@i_status = 'Warning' AND (@tmpStatus = 'Critical' OR @tmpStatus = 'Warning'))
					BEGIN
						INSERT INTO #resultTbl (Result) VALUES (@CSVersionToRpt)
					END
					ELSE IF (@i_status = 'Good' AND (@tmpStatus = 'Critical' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Good'))
					BEGIN
						INSERT INTO #resultTbl (Result) VALUES (@CSVersionToRpt)
					END
					UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
					UPDATE #resultTbl SET Result = 'CommCell Version of <b>' + CommServeName + '</b> is at <b>' + @tmpStatus + '</b> status.'
					UPDATE #resultTbl SET Reason = 'Currently on Version <b>' + @CSVersionToRpt + '</b>'
					UPDATE #resultTbl SET Remarks = CASE	WHEN @tmpStatus = 'Critical' THEN @criticalMessage
															WHEN @tmpStatus = 'Warning' THEN @warningMessage
															ELSE @goodMessage
													END
				END
				ELSE
				BEGIN
					IF ((@LatestSP - @SPMajorNo) >= @i_ParamValue)
					BEGIN
						INSERT INTO #resultTbl (Result) VALUES(@CSVersionToRpt)
						UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
						UPDATE #resultTbl SET Result = 'Installed service pack version of CommCell <b>' + CommServeName + '</b> is lagging by <b>'+ CAST((@LatestSP - @SPMajorNo) AS NVARCHAR(64)) +'</b> major service packs.'
						UPDATE #resultTbl SET Reason = 'Currently on Version <b>' + @CSVersionToRpt + '</b>'
						UPDATE #resultTbl SET Remarks = CASE	WHEN @tmpStatus = 'Critical' THEN @criticalMessage
															WHEN @tmpStatus = 'Warning' THEN @warningMessage
															ELSE @goodMessage
														END
					END
				END
			END
		END
		ELSE IF @i_paramName = 'DR Backup'
		BEGIN
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 31
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage FROM cf_SurveyHealthParam WHERE QueryId = 31
			DECLARE @DRTABLE TABLE (LogDate	datetime NOT NULL, FullJobsToRetain int NULL, IsUingNetworkPath NVARCHAR(20), LastSuccessfulDRTime INT DEFAULT 0)
			INSERT INTO @DRTABLE
				SELECT 	0, csInfo.FullJobsToRetain, csInfo.IsUingNetworkPath, 0
							FROM	cf_SurveyDRBkpConfiguration AS csInfo WITH (NOLOCK)
							INNER JOIN @TblLatestResult AS result ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = 31
			UPDATE @DRTABLE SET LogDate = csInfo.LogDateUTC, LastSuccessfulDRTime = csInfo.LastSuccessfulDRTime
			FROM cf_SurveyDRStats AS csInfo WITH (NOLOCK)
				INNER JOIN cf_CommservSurveyResults R WITH (NOLOCK)
					ON R.QueryID = 19 --User Query id 19(BR Backup Statistics)
					AND csInfo.SurveyResultId = R.CommservSurveyResults_ID
					AND R.CommcellIdNameMap_ID = @i_CommServUniqueId
					AND R.Flags = 1
			DECLARE @ISUNC NVARCHAR(20) = NULL
			DECLARE @FullJobsToRetain int =  NULL
			DECLARE @LastDRBkpTime int = 0
			DECLARE @LastDRCollTime datetime = NULL
			SELECT 	@ISUNC = MAX(IsUingNetworkPath), @FullJobsToRetain = MAX(FullJobsToRetain), @LastDRBkpTime = MAX(LastSuccessfulDRTime), @LastDRCollTime = MAX(LogDate) FROM @DRTABLE
			IF EXISTS(SELECT * FROM @DRTABLE WHERE @ISUNC = 'false' OR @FullJobsToRetain = 0 OR ISNULL(@LastDRBkpTime, 0) = 0 OR DATEDIFF(DAY, DATEADD(second, @LastDRBkpTime, {d '1970-01-01'}), @LastDRCollTime) > @criticalThreshold)
			BEGIN
				SET @tmpStatus = 'Critical'
				SET @tmpRemarks = @criticalMessage
			END
			ELSE IF EXISTS(SELECT * FROM @DRTABLE WHERE (@FullJobsToRetain > 0 AND @FullJobsToRetain < 5) OR DATEDIFF(DAY, DATEADD(second, @LastDRBkpTime, {d '1970-01-01'}), @LastDRCollTime) > @warningThreshold)
			BEGIN
				SET @tmpStatus = 'Warning'
				SET @tmpRemarks = @warningMessage
			END
			ELSE IF EXISTS(SELECT * FROM @DRTABLE WHERE @ISUNC = 'true' AND @FullJobsToRetain >= 5 AND DATEDIFF(DAY, DATEADD(second, @LastDRBkpTime, {d '1970-01-01'}), @LastDRCollTime) <= @warningThreshold)
			BEGIN
				SET @tmpStatus = 'Good'
				SET @tmpRemarks = @goodMessage
			END
			SET @tmpReason =
			CASE
				WHEN ISNULL(@LastDRBkpTime, 0) = 0 THEN 'There is no successful DR job so far.<DELIM>'
				ELSE 'Last successful DR backup ran on <b>' + CONVERT(VARCHAR(12), DATEADD(second, @LastDRBkpTime, {d '1970-01-01'}), 107) + '</b>.<DELIM>'
			END
			IF (@ISUNC = 'true')
				SET @tmpReason = @tmpReason + 'DR Backup is scheduled to run with <b>UNC path</b> as destination.<DELIM>' + 'It is currently configured to retain <b>' + CAST(@FullJobsToRetain AS VARCHAR(MAX)) + '</b> metadata backupset(s).<DELIM>'
			ELSE IF (@ISUNC = 'false')
				SET @tmpReason = @tmpReason + 'DR Backup is scheduled to run with <b>local path</b> as destination.<DELIM>' + 'It is currently configured to retain <b>' + CAST(@FullJobsToRetain AS VARCHAR(MAX)) + '</b> metadata backupset(s).<DELIM>'
			IF ((@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
				(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
				(@i_status = 'Good' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical' OR @tmpStatus = 'Good')))
			BEGIN
				INSERT INTO #resultTbl (Result, CommServeName, Reason, Remarks)
				SELECT	'DR Backup for CommCell <b>' + CommServName + '</b> is at <b>' + @tmpStatus + '</b> status.', CommServName, @tmpReason, @tmpRemarks
				FROM	cf_CommCellIdNameMap
				WHERE	ID = @i_CommServUniqueId
				--UPDATE #resultTbl SET Reason = '<b>' + @i_ParamName + '</b> of CommCell <b>' + CommServeName + '</b> has reached <b>'+ @tmpStatus +'</b> status.<br/>' + Reason
			END
		END
		ELSE IF @i_paramName = 'Client Strike Count'
		BEGIN
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 25
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage FROM cf_SurveyHealthParam WHERE QueryId = 25
			DECLARE @tmpStrikeTable TABLE(StrikeCount INT, scCount INT, clientCount INT)
			INSERT INTO @tmpStrikeTable
			SELECT	sub.StrikeCounts AS 'StrikeCount', COUNT (*) AS 'SubclientCount', COUNT (DISTINCT sub.ClientName) AS 'ClientCount'
			FROM	(SELECT DISTINCT
							csInfo.CommServUniqueId,
							csInfo.LogDate,
							csInfo.ClientGroups,
							csInfo.ClientName,
							csInfo.AgentName,
							csInfo.InstanceName,
							csInfo.BackupSet,
							csInfo.Subclient,
							csInfo.StrikeCounts
					FROM	cf_SurveyFailingClients AS csInfo WITH (NOLOCK)
							INNER JOIN @TblLatestResult AS result
								ON result.SurveyResultId = csInfo.SurveyResultId
								AND result.QueryID = 25
								AND csInfo.StrikeCounts <> -1
					) AS sub
			GROUP BY StrikeCounts
			ORDER BY StrikeCounts DESC
			DECLARE @strike3Count VARCHAR(MAX) = ''
			DECLARE @strike2Count VARCHAR(MAX) = ''
			DECLARE @strike1Count VARCHAR(MAX) = ''
			SELECT	@strike3Count = 'Strike 3 : <b>' + CAST(scCount AS VARCHAR(10)) + '</b> Subclient(s) from <b>' + CAST(clientCount AS VARCHAR(10)) + '</b> Client(s)'
			FROM	@tmpStrikeTable WHERE StrikeCount = 3
			SELECT 	@strike2Count = 'Strike 2 : <b>' + CAST(scCount AS VARCHAR(10)) + '</b> Subclient(s) from <b>' + CAST(clientCount AS VARCHAR(10)) + '</b> Client(s)'
			FROM	@tmpStrikeTable WHERE StrikeCount = 2
			SELECT 	@strike1Count = 'Strike 1 : <b>' + CAST(scCount AS VARCHAR(10)) + '</b> Subclient(s) from <b>' + CAST(clientCount AS VARCHAR(10)) + '</b> Client(s)'
			FROM	@tmpStrikeTable WHERE StrikeCount = 1
			SET @tmpStatus = CASE	WHEN ISNULL(@strike3Count, '')='' AND	ISNULL(@strike2Count, '')='' AND ISNULL(@strike1Count, '')='' THEN 'Good'
									ELSE 'Critical'
							 END
			IF (@tmpStatus = 'Good')
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES ('Good')
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTbl SET Reason = 'There are no clients having any consecutive failed/killed jobs hence there is no strike.'
				UPDATE #resultTbl SET Remarks = 'Good'
			END
			ELSE IF ( (@i_status = 'Warning' OR @i_status = 'Critical') AND (ISNULL(@strike3Count, '')<>'' OR ISNULL(@strike3Count, '')<>'' OR ISNULL(@strike3Count, '')<>''))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES ('Critical')
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTbl SET Reason = @strike3Count + '<br/>' + @strike2Count + '<br/>' + @strike1Count
				UPDATE #resultTbl SET Remarks = 'Please look at the failing clients'
			END
			UPDATE #resultTbl SET Result = 'Client Strike Count of CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus + '</b> status'
		END
		ELSE IF @i_paramName = 'Clients completing with errors in last 30 days'
		BEGIN
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 37
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage FROM cf_SurveyHealthParam WHERE QueryId = 37
			SET @tmpReason = 'There are no clients with Jobs completed with errors.'
			SET @tmpStatus = 'Good'
			SELECT	@tmpStatus = CASE WHEN ISNULL(sub.ClientCount, 0) = 0 THEN 'Good' ELSE 'Warning' END,
					@tmpReason = '<b>' + CAST(sub.ClientCount AS VARCHAR(10)) + '</b> client(s) with one or more jobs completed with error.'
			FROM	(SELECT csInfo.CommServUniqueId, csInfo.LogDate, COUNT(csInfo.ClientName) AS ClientCount
					FROM	cf_SurveyClientJobsCompletingWithError AS csInfo WITH (NOLOCK)
							INNER JOIN @TblLatestResult AS result
								ON result.SurveyResultId = csInfo.SurveyResultId
								AND result.QueryID = 37
					GROUP BY csInfo.CommServUniqueId, csInfo.SurveyResultId, csInfo.LogDate
					) AS sub
			IF ((@i_status = 'Warning' AND @tmpStatus = 'Warning') OR (@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning')))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTbl SET Result = 'Clients completing with errors in last 30 days for CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus + '</b> status'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = CASE WHEN @tmpStatus = 'Good' THEN 'Good' ELSE 'Please look at the clients completing with errors' END
			END
		END
		ELSE IF @i_paramName = 'Subclients without Storage Policy Association'
		BEGIN
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 20
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage FROM cf_SurveyHealthParam WHERE QueryId = 20
			SET @tmpStatus = 'Good'
			SET @tmpReason = 'No subclient is without storage policy association.'
			SET @tmpRemarks = 'None.'
			SELECT 	@tmpStatus = CASE WHEN sub.ClientsWithoutSP > @warningThreshold THEN 'Warning' ELSE 'Good' END,
					@tmpReason = CASE
						WHEN sub.ClientsWithoutSP > 0 THEN '<b>' +
							CAST(sub.SubclientCount AS NVARCHAR(100)) + '</b> Subclient(s) from <b>'
							+ CAST(sub.ClientsWithoutSP AS NVARCHAR(100)) + '</b> Client(s) ' +
							+ ' <b>(' + CAST(sub.ClientsWithoutSPPercent AS NVARCHAR(100)) + '%)</b> are not associated with Storage Policy.'
						ELSE 'All Subclients are associated with Storage Policy.' END,
					@tmpRemarks = CASE WHEN sub.ClientsWithoutSP > @warningThreshold THEN @warningMessage ELSE @goodMessage END
			FROM	(SELECT TOP 1
							csInfo.CommServUniqueId,
							csInfo.LogDate,
							csInfo.ClientGroups,
							csInfo.ClientsWithoutSP,
							csInfo.ClientsWithoutSPPercent,
							csInfo.TotalClients,
							COUNT(csInfo.Subclient) AS 'SubclientCount'
					FROM	cf_SurveyClientsWithoutSPInfo AS csInfo WITH (NOLOCK)
							INNER JOIN @TblLatestResult AS result
								ON result.SurveyResultId = csInfo.SurveyResultId
								AND result.QueryID = 20
					GROUP BY csInfo.CommServUniqueId,
							csInfo.LogDate,
							csInfo.ClientGroups,
							csInfo.ClientsWithoutSP,
							csInfo.ClientsWithoutSPPercent,
							csInfo.TotalClients
					) AS sub
			IF ((@i_status = 'Warning' AND @tmpStatus = 'Warning') OR (@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning')))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTbl SET Result = 'Subclients without Storage Policy Association for CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus + '</b> status'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		ELSE IF @i_paramName = 'Clients at 2 versions behind CommServer'
		BEGIN
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 18
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage FROM cf_SurveyHealthParam WHERE QueryId = 18
			SET @tmpStatus = 'Good'
			SET @tmpReason = ''
			SET @tmpRemarks = 'All Clients are at supported version.'
			SELECT 	@tmpStatus = CASE WHEN sub.ClientCount <= @warningThreshold THEN 'Good' ELSE 'Critical' END,
					@tmpReason = 'There are <b>' + CAST(sub.ClientCount AS NVARCHAR(100)) + '</b> older clients.',
					@tmpRemarks = CASE WHEN sub.ClientCount <= @warningThreshold THEN @goodMessage ELSE @criticalMessage END
			FROM	(SELECT csInfo.CommServUniqueId,
							csInfo.LogDate,
							COUNT(csInfo.ClientId) AS ClientCount
					FROM	cf_SurveyUnsupportedClientInfo AS csInfo WITH (NOLOCK)
							INNER JOIN @TblLatestResult AS result
								ON result.SurveyResultId = csInfo.SurveyResultId
								AND result.QueryID = 18
					GROUP BY csInfo.CommServUniqueId, csInfo.SurveyResultId, csInfo.LogDate
					) AS sub
			IF (((@i_status = 'Warning' OR @i_status = 'Critical') AND @tmpStatus = 'Critical') OR (@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Critical')))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTbl SET Result = 'Clients at 2 versions behind CommServer for CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus + '</b> status'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		ELSE IF @i_paramName = 'Backup Job Statistics for last 60 days'
		BEGIN
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 16
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage FROM cf_SurveyHealthParam WHERE QueryId = 16
			SET @tmpStatus = 'Good'
			SET @tmpReason = ''
			SET @tmpRemarks = ''
			DECLARE @successRatePct FLOAT
			SELECT
				@tmpStatus =
					CASE
						WHEN sub.SuccessRatePercent >= @warningThreshold THEN 'Good'
						WHEN sub.SuccessRatePercent >= @criticalThreshold AND sub.SuccessRatePercent < @warningThreshold THEN 'Warning'
						WHEN sub.SuccessRatePercent < @criticalThreshold THEN 'Critical'
					END,
				@successRatePct = sub.SuccessRatePercent,
				@tmpReason = 'Success Rate : <b>' + CAST(sub.SuccessRatePercent AS NVARCHAR(MAX))
					+ ' %</b><br/>Total : <b>' + CAST(sub.TotalJobs AS NVARCHAR(100))
					+ '</b>, Successful : <b>' + CAST(sub.SuccessfulJobs AS NVARCHAR(100))
					+ '</b>, Failed : <b>' + CAST(sub.FailedJobs AS NVARCHAR(100))
					+ '</b><br/>Completed with Errors : <b>' + CAST(sub.CompletedWithErrorJobs AS NVARCHAR(20))
					+ '</b>, Completed with Warning : <b>' + CAST(sub.CompletedWithWarningJobs AS NVARCHAR(20)) + '</b>',
				@tmpRemarks =
					CASE
						WHEN sub.SuccessRatePercent >= @warningThreshold THEN @goodMessage
						WHEN sub.SuccessRatePercent >= @criticalThreshold THEN 'Success Rate should be greater than ' + CAST(@warningThreshold AS NVARCHAR(16)) + '%. Please look at the failed jobs.'
						ELSE 'Success Rate is less than ' + CAST(@criticalThreshold AS NVARCHAR(16)) + '%. Please look at the failed jobs.'
					END
			FROM
			(
				SELECT
					csInfo.CommServUniqueId,
					csInfo.LogDate,
					csInfo.ClientGroups,
					csInfo.TotalJobs,
					csInfo.SuccessfulJobs,
					ISNULL(csInfo.CompletedWithErrorJobs, 0) AS CompletedWithErrorJobs,
					ISNULL(csInfo.CompletedWithWarningJobs, 0) AS CompletedWithWarningJobs,
					ISNULL(csInfo.FailedJobs, 0) FailedJobs,
					CASE
						WHEN csInfo.TotalJobs = 0 THEN 0
						ELSE CAST(((ISNULL(csInfo.CompletedWithErrorJobs, 0) + ISNULL(csInfo.CompletedWithWarningJobs, 0)+ ISNULL(csInfo.SuccessfulJobs, 0)) * 100.0)/csInfo.TotalJobs AS DECIMAL(7, 0))
					END AS SuccessRatePercent
				FROM cf_SurveyBkpJobStats AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = 16
			) AS sub
			IF (@i_status = '')
			BEGIN
				IF ((@i_Operator = 0 AND @successRatePct < @i_paramValue) OR
					(@i_Operator = 1 AND @successRatePct > @i_paramValue) OR
					(@i_Operator = 2 AND @successRatePct = @i_paramValue))
				BEGIN
					INSERT INTO #resultTbl (Result) VALUES (CAST(@successRatePct AS NVARCHAR(32)) + '%')
					UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
					UPDATE #resultTbl SET Result = 'Backup Success Rate for last 60 days for CommCell <b>' + CommServeName + '</b> is <b>' +
											CAST(@successRatePct AS NVARCHAR(32)) + '%</b>'
					UPDATE #resultTbl SET Reason = @tmpReason
					UPDATE #resultTbl SET Remarks = @tmpRemarks
				END
			END
			ELSE IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
						(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
						(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTbl SET Result = 'Backup Success Rate for last 60 days for CommCell <b>' + CommServeName + '</b> is at <b>' +
											@tmpStatus + '</b> status'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		ELSE IF @i_paramName = 'Restore Statistics for last 60 days'
		BEGIN
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 17
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 17
			SET @tmpStatus = 'Good'
			SET @tmpReason = ''
			SET @tmpRemarks = ''
			DECLARE @rstSuccessRatePct FLOAT
			SELECT 	@tmpStatus =
						CASE
							WHEN sub.SuccessRatePercent = -1 OR sub.SuccessRatePercent >= @criticalThreshold THEN 'Good' --No Restores Jobs or All Restore Jobs success
							ELSE 'Critical'
						END,
					@rstSuccessRatePct = sub.SuccessRatePercent,
					@tmpReason = 'Success Rate : <b>' + CASE sub.SuccessRatePercent
						WHEN -1 THEN 'N/A'
						ELSE CAST(sub.SuccessRatePercent AS NVARCHAR(7)) + ' %'
						END
						+ '</b><br/>Total : <b>' + CAST(sub.TotalRestores AS NVARCHAR(100))
						+ '</b>, Successful : <b>' + CAST(sub.SuccessfulRestores AS NVARCHAR(100))
						+ '</b>, Failed : <b>' + CAST(sub.FailedRestores AS NVARCHAR(100))
						+ '</b><br/>Completed with Errors : <b>' + CAST(sub.CompletedWithErrorJobs AS NVARCHAR(100)) + '</b>',
					@tmpRemarks =
						CASE WHEN sub.SuccessRatePercent = -1 THEN @infoMessage
							WHEN sub.SuccessRatePercent >= @criticalThreshold THEN @goodMessage
							ELSE 'Restore success rate should be 100%. Please look at the failed jobs and completed with errors jobs.'
						END
			FROM	(SELECT	csInfo.CommServUniqueId,
							csInfo.LogDate,
							csInfo.ClientGroups,
							csInfo.TotalRestores,
							csInfo.SuccessfulRestores,
							ISNULL(csInfo.CompletedWithErrorJobs, 0) AS CompletedWithErrorJobs,
							ISNULL(csInfo.FailedRestores, 0) AS FailedRestores,
							CASE
								WHEN csInfo.TotalRestores = 0 THEN -1 --No Restore Job
								ELSE CAST((csInfo.SuccessfulRestores * 100.0)/csInfo.TotalRestores AS DECIMAL(7, 0))
							END AS SuccessRatePercent
					FROM	cf_SurveyRestoreStats AS csInfo WITH (NOLOCK)
							INNER JOIN @TblLatestResult AS result
								ON result.SurveyResultId = csInfo.SurveyResultId
								AND result.QueryID = 17
					) AS sub
			IF (@i_status = '')
			BEGIN
				IF ((@i_Operator = 0 AND @rstSuccessRatePct < @i_paramValue) OR
					(@i_Operator = 1 AND @rstSuccessRatePct > @i_paramValue) OR
					(@i_Operator = 2 AND @rstSuccessRatePct = @i_paramValue))
				BEGIN
					INSERT INTO #resultTbl (Result) VALUES (CAST(@rstSuccessRatePct AS NVARCHAR(32)) + '%')
					UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
					UPDATE #resultTbl SET Result = 'Restore success rate for last 60 days for CommCell <b>' + CommServeName + '</b> is <b>' + CAST(@rstSuccessRatePct AS NVARCHAR(32)) + '%</b>'
					UPDATE #resultTbl SET Reason = @tmpReason
					UPDATE #resultTbl SET Remarks = @tmpRemarks
				END
			END
			ELSE IF (	((@i_status = 'Critical' OR @i_status = 'Warning') AND @tmpStatus = 'Critical') OR
						(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Critical')))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTbl SET Result = 'Restore success rate for last 60 days for CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus + '</b> status'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		ELSE IF @i_paramName = 'Long Running Backup Jobs for last 1 day'
		BEGIN
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 24
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 24
			SET @tmpStatus = 'Good'
			SET @tmpReason = ''
			SET @tmpRemarks = ''
			DECLARE @jobCount INT
			SELECT	TOP 1 @jobCount = csInfo.LongRunningJobs
			FROM	cf_SurveyLongRunningJobs AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = 24
			SET @tmpStatus = CASE WHEN @jobCount > 0 THEN 'Warning' ELSE 'Good'	END
			SET @tmpReason = CASE
				WHEN @jobCount > 0 THEN 'There are <b>' + CAST(@jobCount AS VARCHAR(MAX)) + '</b> jobs running for more than <b>12 hours</b> in last 1 day.'
				ELSE 'No jobs are found running more than 12 hours in last 1 day.' END
			IF (	(@i_status = 'Warning' AND @tmpStatus = 'Warning') OR
					(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTbl SET Result = 'Long Running Backup Jobs for CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus + '</b> status'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		ELSE IF @i_paramName = 'Top 10 Errors in last 1 day'
		BEGIN
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 30
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 30
			SET @tmpStatus = 'Good'
			SET @tmpReason = 'No errors are found'
			SET @tmpRemarks = 'None'
			DECLARE @errorCount INT
			SELECT	@tmpStatus = CASE WHEN ISNULL(sub.TotalErrors, 0) = 0 THEN 'Good' ELSE 'Warning' END,
							@tmpReason = CASE WHEN ISNULL(sub.TotalErrors, 0) = 0 THEN 'No errors are found.' ELSE CAST(ISNULL(sub.TotalErrors, 0) AS NVARCHAR(16)) + ' errors found in last 1 day.' END,
							@errorCount = ISNULL(sub.TotalErrors, 0)
					FROM	(SELECT csInfo.CommServUniqueId, csInfo.LogDate, COUNT(csInfo.NumberOfJobsAffected) AS TotalErrors
							FROM	cf_SurveyMostFrequentErrors AS csInfo WITH (NOLOCK)
									INNER JOIN @TblLatestResult AS result
										ON result.SurveyResultId = csInfo.SurveyResultId
										AND result.QueryID = 30
							GROUP BY csInfo.CommServUniqueId, csInfo.SurveyResultId, csInfo.LogDate
							) AS sub
			IF (	(@i_status = 'Warning' AND @tmpStatus = 'Warning') OR
					(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning')))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTbl SET Result = 'Top 10 errors for CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus + '</b> status'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		ELSE IF @i_paramName = 'DDB Partitions on Media Agents'
		BEGIN
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 61
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 61
			SET @tmpStatus = 'Good'
			SET @tmpReason = ''
			SET @tmpRemarks = ''
			DECLARE @MAStoreConfigResults TABLE
			(
				MediaAgentId INT,
				LogDate DATETIME,
				ValidSIDBCount INT,
				Status INT
			)
			declare @criticalMANum int = 0
			declare @warningMANum int = 0
			declare @totalMANum int = 0
			INSERT INTO @MAStoreConfigResults
			SELECT
				sub.MediaAgentId,
				sub.LogDate,
				SUM(sub.IsValid),
				CASE
					WHEN SUM(sub.IsValid) > @criticalThreshold THEN 3
					WHEN SUM(sub.IsValid) >= @warningThreshold and SUM(sub.IsValid) <= @criticalThreshold THEN 2
					ELSE 1
				END
			FROM
			(
			SELECT
				csInfo.MediaAgentId,
				csInfo.LogDate,
				CASE
					WHEN csInfo.SealedStatus = 'Active' OR (csInfo.SIDBStoreStatus <> 1 AND csInfo.TotalRecords >= 100000000) THEN 1
					ELSE 0
				END AS 'IsValid'
			FROM	cf_SurveyDeDupStoreConfig AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = 61
						AND	csInfo.MediaAgentId > 1
			) AS sub
			GROUP BY sub.MediaAgentId, sub.LogDate
			select @criticalMANum = ISNULL(COUNT(MediaAgentId), 0) from @MAStoreConfigResults where ValidSIDBCount > @criticalThreshold
			select @warningMANum = ISNULL(COUNT(MediaAgentId), 0) from @MAStoreConfigResults where ValidSIDBCount >= @warningThreshold and ValidSIDBCount <= @criticalThreshold
			select @totalMANum = ISNULL(COUNT(*), 0) from @MAStoreConfigResults
			SET @tmpStatus =
				CASE
					WHEN @totalMANum = 0 THEN 'Warning'
					WHEN @criticalMANum > 0 THEN 'Critical'
					WHEN @warningMANum > 0 THEN 'Warning'
					ELSE 'Good'
				END
			IF (@totalMANum > 0)
				BEGIN
					SET @tmpReason = 'Media Agents with DDB Partitions: <br/>'
					SET @tmpReason += 'Total: <B>'+ CAST(@totalMANum AS NVARCHAR(5)) + '</B>  '
					SET @tmpReason += 'Good: <B>' + CAST((@totalMANum-@warningMANum-@criticalMANum) AS NVARCHAR(5)) + '</B>  '
					SET @tmpReason += 'Warning: <B>' + CAST(@warningMANum AS NVARCHAR(5)) + '</B>  '
					SET @tmpReason += 'Critical: <B>' + CAST(@criticalMANum AS NVARCHAR(5)) + '</B>  '
				END
			ELSE
				SET @tmpReason =  'There are no Media Agents hosting DDB store.'
			SET @tmpRemarks =
				CASE
					WHEN @totalMANum = 0 THEN @infoMessage
					WHEN @totalMANum > 0 AND @criticalMANum = 0 AND @warningMANum = 0 THEN @goodMessage
					ELSE @warningMessage
				END
			IF (@i_status = '')
			BEGIN
				IF EXISTS (select * from @MAStoreConfigResults where ValidSIDBCount > @i_paramValue)
				BEGIN
					SET @totalMANum = (SELECT COUNT(*) FROM @MAStoreConfigResults where ValidSIDBCount > @i_paramValue)
					INSERT INTO #resultTbl (Result) VALUES (@totalMANum)
					UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
					UPDATE #resultTbl SET Result = 'There are <b>' + CAST(@totalMANum AS NVARCHAR(16)) + '</b> MediaAgents with more than <b>' + CAST(@i_paramValue AS NVARCHAR(16)) + '</b> Dedupe Stores on CommCell <b>' + CommServeName + '</b>'
					UPDATE #resultTbl SET Reason = @tmpReason
					UPDATE #resultTbl SET Remarks = @tmpRemarks
				END
			END
			IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
					(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
					(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTbl SET Result = 'DDB Partitions on Media Agents for CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus + '</b> status'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		ELSE IF @i_paramName = 'DDB Performance in last 3 days'
		BEGIN
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 65
			SET @criticalThreshold =ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND CommServUniqueId =@i_CommServUniqueId AND attrName ='AvgQITimeCriticalLimit' and attrtype =10),@criticalThreshold)
			SET @warningThreshold =ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1  AND CommServUniqueId =@i_CommServUniqueId AND attrName ='AvgQITimeWarningLimit' and attrtype =10),@warningThreshold)
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 65
			SET @tmpStatus = 'Good'
			SET @tmpReason = ''
			SET @tmpRemarks = ''
			declare @criticalNum int = 0
			declare @warningNum int = 0
			declare @goodNum int = 0
			declare @totalNum int = 0
			declare @qiTime table
			(
				SidbStoreId int,
				AvgQITime	bigint,
				PrimaryRecords	bigint
			)
			INSERT INTO @qiTime
			SELECT	csInfo.SidbStoreId,
					csInfo.AvgQITime,
					csInfo.PrimaryRecords
			FROM	cf_SurveyDDBPerformance AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = 65
			SET @goodNum    = (SELECT COUNT(SidbStoreId) FROM @qiTime WHERE AvgQITime <  @warningThreshold OR  PrimaryRecords<100000000)
			SET @criticalNum= (SELECT COUNT(SidbStoreId) FROM @qiTime WHERE AvgQITime > @criticalThreshold AND PrimaryRecords>200000000)
			SET @totalNum	= (SELECT COUNT(SidbStoreId) FROM @qiTime)
			SET @warningNum = (@totalNum - @goodNum - @criticalNum)
			SET @tmpStatus = CASE
				WHEN @criticalNum > 0 THEN 'Critical'
				WHEN @warningNum > 0 THEN 'Warning'
				ELSE 'Good' END
			IF (@totalNum > 0)
			BEGIN
				SET @tmpReason = 'DDBs: <br/>'
				SET @tmpReason += 'Total: <B>'+ CAST(@totalNum AS NVARCHAR(5)) + '</B>  '
				SET @tmpReason += 'Good: <B>' + CAST(@goodNum  AS NVARCHAR(5)) + '</B>  '
				SET @tmpReason += 'Warning: <B>' + CAST(@warningNum AS NVARCHAR(5)) + '</B>  '
				SET @tmpReason += 'Critical: <B>' + CAST(@criticalNum AS NVARCHAR(5)) + '</B>  '
			END
			ELSE
				SET @tmpReason = 'There are no Media Agents hosting DDB store.'
			SET @tmpRemarks = CASE
				WHEN @totalNum = 0 THEN @infoMessage
				WHEN @totalNum > 0 AND @criticalNum = 0 AND @warningNum = 0 THEN @goodMessage
				ELSE @warningMessage END
			IF (@i_status = '')
			BEGIN
				IF ((@i_Operator = 0 AND (SELECT COUNT(SidbStoreId) FROM @qiTime WHERE AvgQITime < @i_paramValue) > 0) OR
					(@i_Operator = 1 AND (SELECT COUNT(SidbStoreId) FROM @qiTime WHERE AvgQITime > @i_paramValue) > 0) OR
					(@i_Operator = 2 AND (SELECT COUNT(SidbStoreId) FROM @qiTime WHERE AvgQITime = @i_paramValue) > 0))
				BEGIN
					DECLARE @noOfDDBsWithQITime INT
					SELECT @noOfDDBsWithQITime = COUNT(SidbStoreId) FROM @qiTime WHERE ((@i_Operator = 0 AND AvgQITime < @i_paramValue) OR (@i_Operator = 1 AND AvgQITime > @i_paramValue) OR (@i_Operator = 2 AND AvgQITime = @i_paramValue))
					INSERT INTO #resultTbl (Result) VALUES (@noOfDDBsWithQITime)
					UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
					UPDATE #resultTbl SET Result = 'There are <b>' + CAST(@noOfDDBsWithQITime AS NVARCHAR(16)) + '</b> DDB Stores on CommCell <b>' + CommServeName + '</b> that have Average Q&I time ' +
						CASE @i_operator WHEN 0 THEN 'less than' WHEN 1 THEN 'more than' WHEN 2 THEN 'equal to' END + ' <b>' + CAST(@i_paramValue AS NVARCHAR(16)) + '</b>'
					UPDATE #resultTbl SET Reason = @tmpReason
					UPDATE #resultTbl SET Remarks = @tmpRemarks
				END
			END
			IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
					(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
					(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTbl SET Result = 'DDB Performance of CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus +'</b> status'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		ELSE IF @i_paramName = 'Fallen Behind Secondary Copies'
		BEGIN
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 64
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 64
			SET @tmpStatus = 'Good'
			SET @tmpReason = ''
			SET @tmpRemarks = ''
			declare @criticalCopyNum int = 0
			declare @warningCopyNum int = 0
			declare @totalCopyNum int = 0
			declare @dashCoppySummary table
			(
				spName nvarchar(255),
				copyName nvarchar(255),
				FallenBehindDays int
			)
			INSERT INTO @dashCoppySummary
			SELECT 	csInfo.storagePolicyName,
					csInfo.StoragePolicyCopyName,
					csInfo.FallenBehindDays
			FROM	cf_SurveyFallenBehindCopies AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = 64
			set @warningCopyNum = (select COUNT( copyName) FROM @dashCoppySummary where FallenBehindDays >= @warningThreshold and FallenBehindDays <= @criticalThreshold)
			set @criticalCopyNum =( select COUNT( copyName) FROM @dashCoppySummary where FallenBehindDays > @criticalThreshold)
			set @totalCopyNum = (select COUNT( copyName) FROM 	@dashCoppySummary)
			SET @tmpStatus =
				CASE
					WHEN @criticalCopyNum > 0 THEN 'Critical'
					WHEN @warningCopyNum > 0 THEN 'Warning'
					ELSE 'Good'
				END
			IF (@totalCopyNum > 0)
				BEGIN
					SET @tmpReason = 'Dash Copies: <br/>'
					SET @tmpReason += 'Total: <B>'+ CAST(@totalCopyNum AS NVARCHAR(5)) + '</B>  '
					SET @tmpReason += 'Good: <B>' + CAST((@totalCopyNum-@warningCopyNum-@criticalCopyNum) AS NVARCHAR(5)) + '</B>  '
					SET @tmpReason += 'Warning: <B>' + CAST(@warningCopyNum AS NVARCHAR(5)) + '</B>  '
					SET @tmpReason += 'Critical: <B>' + CAST(@criticalCopyNum AS NVARCHAR(5)) + '</B>  '
				END
			ELSE
				SET @tmpReason =  'There are no Fallen Behind Dash Copies.<br/>'
			SET @tmpRemarks =
				CASE
					WHEN @totalCopyNum = 0 THEN @infoMessage
					WHEN @totalCopyNum > 0 AND @criticalCopyNum = 0 AND @warningCopyNum = 0 THEN  @goodMessage
					ELSE @warningMessage
				END
			IF (@i_status = '')
			BEGIN
				DECLARE @noOfDashCopies INT
				SELECT @noOfDashCopies = COUNT( copyName) FROM @dashCoppySummary where FallenBehindDays >= @i_ParamValue
				IF (@noOfDashCopies > 0)
				BEGIN
					INSERT INTO #resultTbl (Result) VALUES (@noOfDashCopies)
					UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
					UPDATE #resultTbl SET Result = 'There are <b>' + Result +'</b> dash copies on CommCell <b>' + CommServeName + '</b> that have fallend behind <b>' + CAST(@i_ParamValue AS VARCHAR(32)) + '</b> or more days'
					UPDATE #resultTbl SET Reason = @tmpReason
					UPDATE #resultTbl SET Remarks = @tmpRemarks
				END
			END
			IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
					(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
					(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTble SET Result = @i_ParamName + ' of CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus +'</b> status'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		ELSE IF @i_paramName = 'DDB are protected via subclient'
		BEGIN
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 66
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 66
			SET @tmpStatus = 'Good'
			SET @tmpReason = ''
			SET @tmpRemarks = ''
			DECLARE @TotalDDBs int
			declare @WarningDDBs int
			declare @CriticalDDBs int
			DECLARE @DDBsWithNoRecentBackup INT
			SELECT 	@totalDDBs = COUNT(csInfo.SidbStoreName),
					@CriticalDDBs = SUM( case when csInfo.LastDDBBackupJobId =0 THEN 1
												ELSE case when ISNULL(csInfo.HoursSinceNoBackup,-1) <> -1  AND ISNULL(csInfo.HoursSinceNoBackup,-1) > @criticalThreshold THEN 1
														ELSE 0
														END
											END),
					@WarningDDBs = SUM( 	case when (csInfo.LastDDBBackupJobId  >0 AND ISNULL(csInfo.HoursSinceNoBackup,-1) = -1)
														OR (csInfo.LastDDBBackupJobId  >0 AND ISNULL(csInfo.HoursSinceNoBackup,-1) <> -1 AND ISNULL(csInfo.HoursSinceNoBackup,-1) < @criticalThreshold
														AND ISNULL(csInfo.HoursSinceNoBackup,-1) > @warningThreshold)
													THEN 1
												ELSE 0
											END
											),
					@DDBsWithNoRecentBackup = SUM( case when csInfo.LastDDBBackupJobId =0 THEN 1
												ELSE case when ISNULL(csInfo.HoursSinceNoBackup,-1) <> -1  AND ISNULL(csInfo.HoursSinceNoBackup,-1) > ISNULL(@i_ParamValue, 0) THEN 1
														ELSE 0
														END
											END)
			FROM	cf_SurveyDDBProtection AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = 66
			SET @tmpStatus = CASE WHEN @CriticalDDBs > 0 THEN 'Critical'
									WHEN @WarningDDBs >0 THEN 'Warning'
									ELSE 'Good' END
			IF ( @TotalDDBs >0 )
			BEGIN
				set @tmpReason = ' DDB Partitions: <BR>'
				SET @tmpReason += 'Total: <B>'+ CAST(@TotalDDBs AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
				SET @tmpReason += 'Good: <B>' + CAST((@TotalDDBs-@WarningDDBs-@CriticalDDBs) AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
				SET @tmpReason += 'Warning: <B>' + CAST(@WarningDDBs AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
				SET @tmpReason += 'Critical: <B>' + CAST(@CriticalDDBs AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
			END
			ELSE
			BEGIN
				SET @tmpReason =  'There are no Media Agents hosting DDB store'
			END
			SET @tmpRemarks = CASE WHEN @TotalDDBs = 0 THEN @infoMessage
										    WHEN @CriticalDDBs > 0 or @WarningDDBs > 0 THEN @warningMessage ELSE @goodMessage END
			IF (@i_status = '' AND @DDBsWithNoRecentBackup > 0)
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@DDBsWithNoRecentBackup)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTbl SET Result = 'There are <b>' + CAST(@DDBsWithNoRecentBackup AS NVARCHAR(16)) + '</b> Dedupe stores that are not protected in last ' + CAST(@i_ParamValue AS NVARCHAR(MAX)) + ' hours'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
			IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
					(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
					(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTbl SET Reason = 'DDB are protected via subclient of CommCell <b>' + CommServeName + '</b> is at <b>' + Result +'</b> status'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		ELSE IF @i_paramName = 'DeDuplication Ratio by Storage Policy Copy in last 30 days'
		BEGIN
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 26
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 26
			SET @tmpStatus = 'Good'
			SET @tmpReason = ''
			SET @tmpRemarks = ''
			DECLARE @TotalCopies INT = 0
			DECLARE @Count1 INT = 0	-->= 80
			DECLARE @Count1Percent INT = 0	-->= 80
			DECLARE @Count2 INT = 0	-->= 60 < 80
			DECLARE @Count2Percent INT = 0	-->= 60 < 80
			DECLARE @Count3 INT = 0	--< 60
			DECLARE @Count3Percent INT = 0	-->= 60 < 80
			DECLARE @DeDupRatioSPCount TABLE(Copy NVARCHAR(256), DeDupRatio DECIMAL(20, 2))
			INSERT INTO @DeDupRatioSPCount
			SELECT 	csInfo.Copy, csInfo.DedupeRatio
			FROM	cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = 26
			AND csInfo.Jobs > 0 and ( csInfo.DedupeRatio <>0 or  csInfo.SizeOnMediaGB <>0)
			AND csInfo.DedupeRatio > -1
			SELECT @TotalCopies = COUNT(*) FROM @DeDupRatioSPCount
			IF @TotalCopies > 0
			BEGIN
				SELECT @Count1 = COUNT(*) FROM @DeDupRatioSPCount WHERE DeDupRatio > @warningThreshold
				SET @Count1Percent = (@Count1*100)/@TotalCopies
				SELECT @Count2 = COUNT(*) FROM @DeDupRatioSPCount WHERE DeDupRatio >= @criticalThreshold AND DeDupRatio <= @warningThreshold
				SET @Count2Percent = (@Count2*100)/@TotalCopies
				SELECT @Count3 = COUNT(*) FROM @DeDupRatioSPCount WHERE DeDupRatio < @criticalThreshold
				SET @Count3Percent = (@Count3*100)/@TotalCopies
			END
			SET	@tmpStatus = CASE
				WHEN @TotalCopies = 0 THEN 'Info'
				WHEN @Count3Percent <> 0 THEN 'Critical'
				WHEN @Count2Percent <> 0  THEN 'Warning'
				ELSE 'Good' END
			IF (@TotalCopies > 0)
			BEGIN
				SET @tmpReason = 'Dedup Copies: <BR/>'
				SET @tmpReason += 'Total: <B>'+ CAST(@TotalCopies AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
				SET @tmpReason += 'Good: <B>' + CAST(@Count1 AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
				SET @tmpReason += 'Warning: <B>' + CAST(@Count2 AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
				SET @tmpReason += 'Critical: <B>' + CAST(@Count3 AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
			END
			ELSE
				SET @tmpReason =  'There are no storage policy copies with DeDup Ratio.<BR/>'
			SET @tmpRemarks = CASE
							WHEN @tmpStatus = 'Good' THEN @goodMessage
							ELSE @criticalMessage
				END
			IF (@i_status = '')
			BEGIN
				IF ((@i_Operator = 0 AND (SELECT COUNT(*) FROM @DeDupRatioSPCount WHERE DeDupRatio < @i_paramValue) > 0) OR
					(@i_Operator = 1 AND (SELECT COUNT(*) FROM @DeDupRatioSPCount WHERE DeDupRatio > @i_paramValue) > 0) OR
					(@i_Operator = 2 AND (SELECT COUNT(*) FROM @DeDupRatioSPCount WHERE DeDupRatio = @i_paramValue) > 0))
				BEGIN
					DECLARE @noOfLowDedupe INT
					SELECT @noOfLowDedupe = COUNT(*) FROM @DeDupRatioSPCount where ((@i_Operator = 0 AND DeDupRatio < @i_paramValue) OR (@i_Operator = 1 AND DeDupRatio > @i_paramValue) OR (@i_Operator = 2 AND DeDupRatio = @i_paramValue))
					INSERT INTO #resultTbl (Result) VALUES (@noOfLowDedupe)
					UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
					UPDATE #resultTbl SET Result = 'There are <b>' + Result +'</b> storage policy copies on CommCell <b>' + CommServeName + '</b> that have deduplicaton ratio ' +
						CASE @i_operator WHEN 0 THEN 'less than' WHEN 1 THEN 'more than' WHEN 2 THEN 'equal to' END + ' <b>' + @i_paramValue + '%</b>'
					UPDATE #resultTbl SET Reason = @tmpReason
					UPDATE #resultTbl SET Remarks = @tmpRemarks
				END
			END
			IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
					(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
					(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTbl SET Result = @i_ParamName + '</b> of CommCell <b>' + CommServeName + '</b> is at <b>' + Result +'</b> status'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		ELSE IF @i_paramName = 'Low Disk Space'
		BEGIN
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 70
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 70
			SET @tmpStatus = 'Good'
			SET @tmpReason = ''
			SET @tmpRemarks = ''
			declare @criticalCopies int = 0
			declare @warningCopies int = 0
			declare @totalNCopies int = 0
			declare @copiesSize table
			(
				copyId int,
				percentFree decimal(10,2)
			)
			INSERT INTO @copiesSize
			SELECT	csInfo.CopyId,
					case when csInfo.CapacityMB > 0 THEN cast ((csInfo.FreeSpaceMB *100.0 / csInfo.CapacityMB ) AS decimal(10,2)) else '0' END AS percentFree
			FROM	cf_SurveyCopyFreeSpace AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = 70
			SET @warningCopies	= (select COUNT(CopyId) FROM @copiesSize where percentFree >= @criticalThreshold and percentFree <= @warningThreshold)
			SET @criticalCopies = (select COUNT(CopyId) FROM @copiesSize where percentFree < @criticalThreshold)
			SET @totalNCopies	= (select COUNT(CopyId) FROM @copiesSize)
			SET @tmpStatus = CASE
				WHEN @criticalCopies > 0 THEN 'Critical'
				WHEN @warningCopies > 0 THEN 'Warning'
				ELSE 'Good' END
			IF (@totalNCopies > 0)
			BEGIN
				SET @tmpReason = 'Storage Policy Copies: <BR/>'
				SET @tmpReason += 'Total: <B>'+ CAST(@totalNCopies AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
				SET @tmpReason += 'Good: <B>' + CAST((@totalNCopies-@warningCopies-@criticalCopies) AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
				SET @tmpReason += 'Warning: <B>' + CAST(@warningCopies AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
				SET @tmpReason += 'Critical: <B>' + CAST(@criticalCopies AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
			END
			ELSE
				SET @tmpReason =  'All Copies have sufficient space.<BR/>'
			SET @tmpRemarks = CASE
				WHEN @totalNCopies = 0 THEN @infoMessage
				WHEN @totalNCopies > 0 AND @criticalCopies = 0 AND @warningCopies = 0 THEN @goodMessage
				ELSE @warningMessage END
			IF (@i_status = '')
			BEGIN
				IF ((@i_Operator = 0 AND (select COUNT(CopyId) FROM @copiesSize where percentFree < @i_paramValue) > 0) OR
					(@i_Operator = 1 AND (select COUNT(CopyId) FROM @copiesSize where percentFree > @i_paramValue) > 0) OR
					(@i_Operator = 2 AND (select COUNT(CopyId) FROM @copiesSize where percentFree = @i_paramValue) > 0))
				BEGIN
					DECLARE @noOfLowSpace INT
					SELECT @noOfLowSpace = COUNT(CopyId) FROM @copiesSize where ((@i_Operator = 0 AND percentFree < @i_paramValue) OR (@i_Operator = 1 AND percentFree > @i_paramValue) OR (@i_Operator = 2 AND percentFree = @i_paramValue))
					INSERT INTO #resultTbl (Result) VALUES (@noOfLowSpace)
					UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
					UPDATE #resultTbl SET Result = 'There are <b>' + Result +'</b> copies on CommCell <b>' + CommServeName + '</b> that have free space ' +
						CASE @i_operator WHEN 0 THEN 'less than' WHEN 1 THEN 'more than' WHEN 2 THEN 'equal to' END + ' <b>' + @i_paramValue + '%</b>'
					UPDATE #resultTbl SET Reason = @tmpReason
					UPDATE #resultTbl SET Remarks = @tmpRemarks
				END
			END
			IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
					(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
					(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTbl SET Result = @i_ParamName + ' of CommCell <b>' + CommServeName + '</b> is at <b>' + Result +'</b> status'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		--Deduplication Stores with pending archive files for pruning
		ELSE IF @i_paramName = 'Deduplication Stores with pending archive files for pruning'
		BEGIN
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 35
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 35
			SET @tmpStatus = 'Good'
			SET @tmpReason = ''
			SET @tmpRemarks = ''
			DECLARE @tmpDeletedAFCount TABLE(DeletedAFCount BIGINT)
			INSERT INTO @tmpDeletedAFCount
			SELECT
				csInfo.DeletedAFCount
			FROM cf_SurveyDeDupDeletedAFCount AS csInfo WITH (NOLOCK)
				INNER JOIN @TblLatestResult AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = 35
			DECLARE @TotalDDBCount INT = 0
			DECLARE @goodDDBCount INT = 0
			DECLARE @warningDDBCount INT = 0
			DECLARE @criticalDDBCount INT = 0
			SELECT @TotalDDBCount = COUNT(*) FROM @tmpDeletedAFCount
			SELECT @goodDDBCount = COUNT(*) FROM @tmpDeletedAFCount WHERE DeletedAFCount < @warningThreshold
			SELECT @warningDDBCount = COUNT(*) FROM @tmpDeletedAFCount WHERE DeletedAFCount >= @warningThreshold AND DeletedAFCount <= @criticalThreshold
			SELECT @criticalDDBCount = COUNT(*) FROM @tmpDeletedAFCount WHERE DeletedAFCount > @criticalThreshold
			SET @tmpStatus =
			CASE
				WHEN @TotalDDBCount = 0 THEN 'Info'
				WHEN @criticalDDBCount > 0 THEN 'Critical'
				WHEN @warningDDBCount > 0 THEN 'Warning'
				ELSE 'Good'
			END
			SET @tmpStatus = 'Critical'
			IF (@TotalDDBCount > 0)
			BEGIN
				SET @tmpReason = 'Deduplication Stores: <BR>'
				SET @tmpReason += 'Total: <B>'+ CAST(@TotalDDBCount AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
				SET @tmpReason += 'Good: <B>' + CAST(@goodDDBCount AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
				SET @tmpReason += 'Warning: <B>' + CAST(@warningDDBCount AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
				SET @tmpReason += 'Critical: <B>' + CAST(@criticalDDBCount AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
			END
			ELSE
				SET @tmpReason =  'There are no DDB stores with pending archive files for pruning'
			SET @tmpRemarks =
			CASE
				WHEN @tmpStatus = 'Critical' THEN @criticalMessage
				WHEN @tmpStatus = 'Warning' THEN @warningMessage
				WHEN @tmpStatus = 'Good' THEN @goodMessage
				ELSE @infoMessage
			END
			IF (@i_status = '')
			BEGIN
				IF EXISTS (SELECT * FROM @tmpDeletedAFCount WHERE DeletedAFCount > @i_paramValue)
				BEGIN
					SELECT @TotalDDBCount = COUNT(*) FROM @tmpDeletedAFCount WHERE DeletedAFCount > @i_paramValue
					INSERT INTO #resultTbl (Result) VALUES (@TotalDDBCount)
					UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
					UPDATE #resultTbl SET Result = 'There are <b>' + Result +'</b> Dedupe stores on CommCell <b>' + CommServeName + '</b> that have more than <b>' + CAST(@i_ParamValue AS NVARCHAR(16))
					 + '</b> thousand archive files pending to be pruned'
					UPDATE #resultTbl SET Reason = @tmpReason
					UPDATE #resultTbl SET Remarks = @tmpRemarks
				END
			END
			IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
					(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
					(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTbl SET Result = @i_ParamName + ' of CommCell <b>' + CommServeName + '</b> is at <b>' + Result +'</b> status'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		ELSE IF @i_paramName = 'Index Cache Location'
		BEGIN
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 39
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 39
			SET @tmpStatus = 'Good'
			SET @tmpReason = ''
			SET @tmpRemarks = ''
			DECLARE @localIdxCount INT = 0
			DECLARE @networkIdxCount INT = 0
			DECLARE @intermediateIdxCount INT = 0
			SELECT @localIdxCount = COUNT(csInfo.MAId)
			FROM cf_SurveyIndexCacheUsage AS csInfo WITH (NOLOCK)
				INNER JOIN @TblLatestResult AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = 39
					AND csInfo.IsUNC = 0
			SELECT @networkIdxCount = COUNT(csInfo.MAId)
			FROM cf_SurveyIndexCacheUsage AS csInfo WITH (NOLOCK)
				INNER JOIN @TblLatestResult AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = 39
					AND csInfo.IsUNC = 1
			SELECT @intermediateIdxCount = COUNT(csInfo.MAId)
			FROM cf_SurveyIndexCacheUsage AS csInfo WITH (NOLOCK)
				INNER JOIN @TblLatestResult AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = 39
					AND LEN(csInfo.IntermediateCachePath) > 0 AND csInfo.IntermediateCachePath <> 'N/A'
			SELECT
				@tmpStatus =
				CASE
					WHEN (@localIdxCount + @networkIdxCount = 0) THEN 'Info'
					WHEN @networkIdxCount >= @warningThreshold THEN 'Warning'
					ELSE 'Good'
				END,
				@tmpReason =
				CASE
					WHEN @localIdxCount+@networkIdxCount = 0 THEN @infoMessage
					ELSE 'Index cache distribution by location: <BR/>'
					+ 'Total : <b>' + CAST((@localIdxCount+@networkIdxCount) AS VARCHAR(10))
					+ '</b>&nbsp;&nbsp;Local Disk : <b>' + CAST(@localIdxCount AS VARCHAR(10))
					+ '</b>&nbsp;&nbsp;Network Share : <b>' + CAST(@networkIdxCount AS VARCHAR(10))
					+ '</b><BR/>Intermediate Cache : <b>' + CAST(@intermediateIdxCount AS VARCHAR(10)) + '</b><BR/>'
				END,
				@tmpRemarks =
				CASE
					WHEN (@localIdxCount + @networkIdxCount = 0) THEN @infoMessage
					WHEN @networkIdxCount >= @warningThreshold OR @intermediateIdxCount >= @warningThreshold THEN @warningMessage
					ELSE @goodMessage
				END
			IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
					(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
					(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTbl SET Result = 'Index Cache Location of CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus + '</b> status'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		ELSE IF @i_paramName = 'Index Cache Space Utilization'
		BEGIN
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 105
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 105
			SET @tmpStatus = 'Good'
			SET @tmpReason = ''
			SET @tmpRemarks = ''
			DECLARE @totalIdxCache int = 0
			DECLARE @warningIdxCache int = 0
			DECLARE @criticalIdxCache int = 0
			DECLARE @unknownIdxCache int = 0
			--Disk space free: good:   > 25%   warning: 10  25%, critical < 10%
			DECLARE @idxCacheSize TABLE
			(
				MAId INT,
				percentFree DECIMAL(10,2),
				FreeDiskSpaceMB BIGINT,
				warningSpaceMB	BIGINT,
				criticalSpaceMB	BIGINT
			)
			IF object_id('tempdb.dbo.#LatestThreshold') is not null DROP TABLE #LatestThreshold
			CREATE	TABLE #LatestThreshold (
					CommServUniqueId INT,
					clientId INT,
					warningSpaceMB BIGINT,  criticalSpaceMB BIGINT)
			INSERT INTO #LatestThreshold
			SELECT  CommServUniqueId ,entityId  AS clientId,
					CASE ISNUMERIC([warningSpaceMB]) WHEN 1 THEN CAST([warningSpaceMB] AS BIGINT) ELSE 0 END AS warningSpaceMB,
					CASE ISNUMERIC([criticalSpaceMB]) WHEN 1 THEN CAST([criticalSpaceMB] AS BIGINT) ELSE 0 END  AS criticalSpaceMB
			FROM    (SELECT csInfo.CommServUniqueId,entityId, attrName ,attrVal
					 FROM cf_SurveyCommcellThresholdInfo csInfo (NOLOCK)
					 where csInfo.CommServUniqueId =@i_CommServUniqueId
					and attrName IN ( 'warningSpaceMB', 'criticalSpaceMB')
					 ) AS clients
			PIVOT
			(
				MAX(attrVal) FOR attrName IN ( warningSpaceMB, [criticalSpaceMB])
			) AS P
		INSERT INTO @idxCacheSize (MAId,percentFree,FreeDiskSpaceMB,warningSpaceMB,criticalSpaceMB)
		SELECT
			csInfo.MAId,
			CASE
				WHEN csInfo.TotalCapacityMB <= 0 THEN -1
				ELSE CAST((csInfo.FreeDiskSpaceMB * 100.0 / csInfo.TotalCapacityMB) AS DECIMAL(10,2))
			END AS percentFree,
				CASE WHEN csInfo.TotalCapacityMB <= 0 THEN -1 ELSE csInfo.FreeDiskSpaceMB END,
			CASE WHEN T.warningSpaceMB IS NOT NULL THEN T.warningSpaceMB ELSE csInfo.FreeDiskSpaceMB*@warningThreshold END,
			CASE WHEN T.criticalSpaceMB IS NOT NULL THEN T.criticalSpaceMB ELSE csInfo.FreeDiskSpaceMB*@criticalThreshold END
		FROM
			cf_SurveyIndexCacheUsage AS csInfo WITH (NOLOCK)
				INNER JOIN @TblLatestResult AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = 39	AND csInfo.TotalCapacityMB > 0 AND csInfo.IndexAccessPathEnabled = 1
			LEFT OUTER JOIN #LatestThreshold T
			ON T.CommServUniqueId =csInfo.CommServUniqueId AND csInfo.MAId =T.clientId
		SET @totalIdxCache = (SELECT COUNT(MAId) FROM @idxCacheSize)
		SET @unknownIdxCache = (select COUNT(MAId) FROM @idxCacheSize where percentFree = -1 )
		SET @warningIdxCache = (SELECT COUNT(MAId) FROM @idxCacheSize where (FreeDiskSpaceMB>=criticalSpaceMB AND FreeDiskSpaceMB<=warningSpaceMB ))
		SET @criticalIdxCache = (select COUNT(MAId) FROM @idxCacheSize where (FreeDiskSpaceMB>0 AND FreeDiskSpaceMB<criticalSpaceMB ))
		IF object_id('tempdb.dbo.#LatestThreshold') is not null DROP TABLE #LatestThreshold
			SELECT
				@tmpStatus =
				CASE
					WHEN @totalIdxCache = 0 THEN 'Info'
					WHEN @criticalIdxCache > 0 THEN 'Critical'
					WHEN @warningIdxCache > 0 THEN 'Warning'
					ELSE 'Good'
				END
			IF (@totalIdxCache > 0)
				BEGIN
					SET @tmpReason = 'Index cache distribution by available space: <BR/>'
					SET @tmpReason += 'Total : <B>'+ CAST(@totalIdxCache AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
					SET @tmpReason += 'Good : <B>' + CAST((@totalIdxCache-@warningIdxCache-@criticalIdxCache-@unknownIdxCache) AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
					SET @tmpReason += 'Warning : <B>' + CAST(@warningIdxCache AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
					SET @tmpReason += 'Critical : <B>' + CAST(@criticalIdxCache AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
					SET @tmpReason += '<BR/>Excluded : <B>' + CAST(@unknownIdxCache AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
				END
			ELSE
				SET @tmpReason =  'There is no index cache configured.<BR/>'
			SELECT @tmpRemarks =
			CASE
				WHEN @totalIdxCache = 0 THEN @infoMessage
				WHEN @totalIdxCache > 0 AND @criticalIdxCache = 0 AND @warningIdxCache = 0 THEN @goodMessage
				ELSE @warningMessage
			END
			IF (@i_status = '')
			BEGIN
				IF ((@i_Operator = 0 AND (select COUNT(MAId) FROM @idxCacheSize where percentFree < @i_paramValue) > 0) OR
					(@i_Operator = 1 AND (select COUNT(MAId) FROM @idxCacheSize where percentFree > @i_paramValue) > 0) OR
					(@i_Operator = 2 AND (select COUNT(MAId) FROM @idxCacheSize where percentFree = @i_paramValue) > 0))
				BEGIN
					DECLARE @noOfIdxCache INT
					SELECT @noOfIdxCache = COUNT(MAId) FROM @idxCacheSize where ((@i_Operator = 0 AND percentFree < @i_paramValue) OR (@i_Operator = 1 AND percentFree > @i_paramValue) OR (@i_Operator = 2 AND percentFree = @i_paramValue))
					INSERT INTO #resultTbl (Result) VALUES (@noOfIdxCache)
					UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
					UPDATE #resultTbl SET Result = 'There are <b>' + Result +'</b> Index Caches on CommCell <b>' + CommServeName + '</b> that have free disk space ' +
						CASE @i_operator WHEN 0 THEN 'less than ' WHEN 1 THEN 'more than ' WHEN 2 THEN 'equal to ' END + '<b>' + @i_paramValue + '%</b>.<br/>'
					UPDATE #resultTbl SET Reason = @tmpReason
					UPDATE #resultTbl SET Remarks = @tmpRemarks
				END
			END
			IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
					(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
					(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTbl SET Result = 'Index Cache Space Utilization of CommCell <b>' + CommServeName + '</b> is at <b>'+ @tmpStatus + '</b> status'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		ELSE IF @i_paramName = 'Schedule Policy Association'
		BEGIN
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 22
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 22
			SET @tmpStatus = 'Good'
			SET @tmpReason = ''
			SET @tmpRemarks = ''
			DECLARE @totalSchCount INT = 0
			DECLARE @unusedSchCount INT = 0
			DECLARE @tmpSchPolicy TABLE(IsUsed INT, SPCount INT)
			INSERT INTO @tmpSchPolicy
			SELECT 	csInfo.IsUsed, COUNT(*)
			FROM	cf_SurveySchedulePolicyUsage AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = 22
			GROUP BY csInfo.CommServUniqueId, csInfo.SurveyResultId, csInfo.LogDate, csInfo.IsUsed
			SELECT @totalSchCount = COALESCE(SUM(SPCount), 0) FROM @tmpSchPolicy
			SELECT @unusedSchCount = COALESCE(SUM(SPCount), 0) FROM @tmpSchPolicy WHERE IsUsed = 0
			IF @unusedSchCount > 0
			BEGIN
				SET @tmpReason = '<b>' + CAST(@unusedSchCount AS NVARCHAR(100)) + '</b> out of <b>'
					+ CAST(@totalSchCount AS NVARCHAR(100))
					+ '</b> Schedule Policies are not used.<BR/>'
				SET @tmpStatus = 'Warning'
				SET @tmpRemarks = @warningMessage
			END
			ELSE
			BEGIN
				SET @tmpReason =
					CASE
						WHEN @totalSchCount = 0 THEN 'There is no Schedule Policy.<BR/>'
						WHEN @totalSchCount > 0 THEN 'All <b>' + CAST(@totalSchCount AS NVARCHAR(100)) + '</b> Schedule Policies are in use.<BR/>'
					END
				SET @tmpStatus = 'Warning'
				SET @tmpRemarks = CASE WHEN @totalSchCount > 0 THEN @goodMessage ELSE '' END
			END
			IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
					(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
					(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTbl SET Result = 'Schedule Policy Usage in last 7 days for CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus +'</b> status'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		ELSE IF @i_paramName = 'Mount Path'
		BEGIN
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 95
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 95
			SET @tmpStatus = 'Good'
			SET @tmpReason = ''
			SET @tmpRemarks = ''
			DECLARE @totalMountPaths     int = 0
			DECLARE @goodMountPaths      int = 0
			DECLARE @warningMountPaths   int = 0
			DECLARE @criticalMountPaths  int = 0
			--Disk space free: good:   > 25%   warning: 10  25%, critical < 10%
			DECLARE @MountPathsSize TABLE
			(
				MountPathName NVARCHAR(256),
				percentFree DECIMAL(20,2)
			)
			INSERT INTO @MountPathsSize
			SELECT
				csInfo.MountPathName,
				csInfo.FreeSpacePerc
			FROM
				cf_Survey95MountPathDetails AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = 95
			SET @totalMountPaths     = (SELECT COUNT(MountPathName) FROM @MountPathsSize)
			SET @goodMountPaths		 = (SELECT COUNT(MountPathName) FROM @MountPathsSize where percentFree >= @warningThreshold)
			SET @warningMountPaths	 = (SELECT COUNT(MountPathName) FROM @MountPathsSize where percentFree >= @criticalThreshold and percentFree <= @warningThreshold)
			SET @criticalMountPaths	 = (select COUNT(MountPathName) FROM @MountPathsSize where percentFree < @criticalThreshold)
			SELECT
				@tmpStatus =
				CASE
					WHEN @totalMountPaths = 0 THEN 'Info'
					WHEN @criticalMountPaths > 0 THEN 'Critical'
					WHEN @warningMountPaths > 0 THEN 'Warning'
					ELSE 'Good'
				END
			IF (@totalMountPaths > 0)
				BEGIN
					SET @tmpReason = 'Mount Path distribution by Free space: <BR/>'
					SET @tmpReason += 'Total : <B>'+ CAST(@totalMountPaths AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
					SET @tmpReason += 'Good : <B>' + CAST(@goodMountPaths  AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
					SET @tmpReason += 'Warning : <B>' + CAST(@warningMountPaths AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
					SET @tmpReason += 'Critical : <B>' + CAST(@criticalMountPaths AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
				END
			ELSE
				SET @tmpReason =  'There is no mount path configured.<BR/>'
			SELECT @tmpRemarks =
			CASE
				WHEN @totalMountPaths = 0 THEN @infoMessage
				WHEN @totalMountPaths > 0 AND @criticalMountPaths = 0 AND @warningMountPaths = 0 THEN @goodMessage
				ELSE @warningMessage
			END
			IF (@i_status = '')
			BEGIN
				IF ((@i_Operator = 0 AND (SELECT COUNT(MountPathName) FROM @MountPathsSize where percentFree < @i_paramValue) > 0) OR
					(@i_Operator = 1 AND (SELECT COUNT(MountPathName) FROM @MountPathsSize where percentFree > @i_paramValue) > 0) OR
					(@i_Operator = 2 AND (SELECT COUNT(MountPathName) FROM @MountPathsSize where percentFree = @i_paramValue) > 0))
				BEGIN
					DECLARE @noOfMP INT
					SELECT @noOfMP = COUNT(MountPathName) FROM @MountPathsSize where ((@i_Operator = 0 AND percentFree < @i_paramValue) OR (@i_Operator = 1 AND percentFree > @i_paramValue) OR (@i_Operator = 2 AND percentFree = @i_paramValue))
					INSERT INTO #resultTbl (Result) VALUES (@noOfMP)
					UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
					UPDATE #resultTbl SET Result = 'There are <b>' + CAST(@noOfMP AS NVARCHAR(16)) +'</b> Mount Paths on CommCell <b>' + CommServeName + '</b> that have free disk space ' +
						CASE @i_operator WHEN 0 THEN 'less than ' WHEN 1 THEN 'more than ' WHEN 2 THEN 'equal to ' END + '<b>'+ CAST (@i_paramValue AS NVARCHAR(16)) + '%</b>'
					UPDATE #resultTbl SET Reason = @tmpReason
					UPDATE #resultTbl SET Remarks = @tmpRemarks
				END
			END
			IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
					(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
					(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTbl SET Result = 'Mount Path free disk space of CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus + '</b> status'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		ELSE IF @i_paramName = 'Disk Library Growth'
		BEGIN
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 96
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 96
			SET @tmpStatus = 'Good'
			SET @tmpReason = ''
			SET @tmpRemarks = ''
			DECLARE @totalDiskLib     int = 0
			DECLARE @goodDiskLib      int = 0
			DECLARE @warningDiskLib   int = 0
			DECLARE @criticalDiskLib  int = 0
			--Disk space free: good:   > 25%   warning: 10  25%, critical < 10%
			DECLARE @DiskLibDays TABLE
			(
				DiskLibId BIGINT,
				estimatedSpaceRunoutDays BIGINT,
				LogDateUTC					DATETIME
			)
			INSERT INTO @DiskLibDays
			SELECT
				csInfo.LibraryId,
				csInfo.estimatedSpaceRunoutDays,
				 csInfo.LogDateUTC
			FROM
				cf_Survey96DiskLibDetails AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = 96
			SET @totalDiskLib     = (SELECT COUNT(DiskLibId) FROM @DiskLibDays)
			SET @goodDiskLib		 = (SELECT COUNT(DiskLibId) FROM @DiskLibDays where (((estimatedSpaceRunoutDays -datediff (DAY,LogDateUTC,GETUTCDATE())) >= @warningThreshold) OR (estimatedSpaceRunoutDays IS NULL) OR (estimatedSpaceRunoutDays < 0)))
			SET @warningDiskLib	 = (SELECT COUNT(DiskLibId) FROM @DiskLibDays where (estimatedSpaceRunoutDays -datediff (DAY,LogDateUTC,GETUTCDATE())) >= @criticalThreshold and (estimatedSpaceRunoutDays -datediff (DAY,LogDateUTC,GETUTCDATE())) <= @warningThreshold)
			SET @criticalDiskLib	 = (select COUNT(DiskLibId) FROM @DiskLibDays where estimatedSpaceRunoutDays > -1 and (estimatedSpaceRunoutDays -datediff (DAY,LogDateUTC,GETUTCDATE())) < @criticalThreshold)
			SELECT
				@tmpStatus =
				CASE
					WHEN @totalDiskLib = 0 THEN 'Info'
					WHEN @criticalDiskLib > 0 THEN 'Critical'
					WHEN @warningDiskLib > 0 THEN 'Warning'
					ELSE 'Good'
				END
			IF (@totalDiskLib > 0)
				BEGIN
					SET @tmpReason = 'Disk Library distribution by estimated days to be full: <BR/>'
					SET @tmpReason += 'Total : <B>'+ CAST(@totalDiskLib AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
					SET @tmpReason += 'Good : <B>' + CAST(@goodDiskLib  AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
					SET @tmpReason += 'Warning : <B>' + CAST(@warningDiskLib AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
					SET @tmpReason += 'Critical : <B>' + CAST(@criticalDiskLib AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
				END
			ELSE
				SET @tmpReason =  'There is no disk library configured.<BR/>'
			SELECT @tmpRemarks =
			CASE
				WHEN @totalDiskLib = 0 THEN @infoMessage
				WHEN @totalDiskLib > 0 AND @criticalDiskLib = 0 AND @warningDiskLib = 0 THEN @goodMessage
				ELSE @warningMessage
			END
			IF (@i_status = '')
			BEGIN
				IF ((@i_Operator = 0 AND (SELECT COUNT(DiskLibId) FROM @DiskLibDays where ISNULL(estimatedSpaceRunoutDays, -1) != -1 AND (estimatedSpaceRunoutDays -datediff (DAY,LogDateUTC,GETUTCDATE())) < @i_paramValue) > 0) OR
					(@i_Operator = 1 AND (SELECT COUNT(DiskLibId) FROM @DiskLibDays where ISNULL(estimatedSpaceRunoutDays, -1) = -1 OR (estimatedSpaceRunoutDays -datediff (DAY,LogDateUTC,GETUTCDATE())) > @i_paramValue) > 0) OR
					(@i_Operator = 2 AND (SELECT COUNT(DiskLibId) FROM @DiskLibDays where (estimatedSpaceRunoutDays -datediff (DAY,LogDateUTC,GETUTCDATE())) = @i_paramValue) = 0))
				BEGIN
					DECLARE @daysToBeFull INT
					SELECT @daysToBeFull = COUNT(DiskLibId) FROM @DiskLibDays where ((@i_Operator = 0 AND (estimatedSpaceRunoutDays != -1 AND (estimatedSpaceRunoutDays -datediff (DAY,LogDateUTC,GETUTCDATE())) < @i_paramValue)) OR (@i_Operator = 1 AND ((estimatedSpaceRunoutDays -datediff (DAY,LogDateUTC,GETUTCDATE())) > @i_paramValue OR estimatedSpaceRunoutDays = -1)) OR (@i_Operator = 2 AND (estimatedSpaceRunoutDays -datediff (DAY,LogDateUTC,GETUTCDATE())) = @i_paramValue))
					INSERT INTO #resultTbl (Result) VALUES (@daysToBeFull)
					UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
					UPDATE #resultTbl SET Result = 'There are <b>' + Result +'</b> Disk Libraries on CommCell <b>' + CommServeName + '</b> that are estimated to be full in ' +
						CASE @i_operator WHEN 0 THEN 'less than' WHEN 1 THEN 'greater than' WHEN 2 THEN '' END + ' <b>' + @i_paramValue + ' days</b>'
					UPDATE #resultTbl SET Reason = @tmpReason
					UPDATE #resultTbl SET Remarks = @tmpRemarks
				END
			END
			IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
					(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
					(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTbl SET Result = 'Disk Library Growth of CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus +'</b> status'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		ELSE IF @i_paramName = 'Database Index Fragmentation'
		BEGIN
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 144
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 144
			SET @tmpStatus = 'Good'
			SET @tmpReason = ''
			SET @tmpRemarks = ''
			DECLARE @TblFragmentation TABLE (DatabaseName VARCHAR(32), TotalIndexCount INT, IndexCount INT, Percentage INT)
			INSERT INTO @TblFragmentation
			SELECT  DatabaseName, SUM(IndexCount), SUM(CASE WHEN FragmentationPct > 30 THEN IndexCount ELSE 0 END), 0
			FROM    cf_SurveyIndexFragmentation AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
			GROUP BY DatabaseName
			UPDATE	@TblFragmentation SET Percentage = 100*IndexCount/TotalIndexCount
			IF EXISTS (SELECT * FROM @TblFragmentation WHERE Percentage > @criticalThreshold)
			BEGIN
				SET @tmpStatus = 'Critical'
				SET @tmpRemarks = @criticalMessage
			END
			ELSE
			IF EXISTS (SELECT * FROM @TblFragmentation WHERE Percentage > @warningThreshold)
			BEGIN
				SET @tmpStatus = 'Warning'
				SET @tmpRemarks = @warningMessage
			END
			ELSE
			IF EXISTS (SELECT * FROM @TblFragmentation)
			BEGIN
				SET @tmpStatus = 'Good'
				SET @tmpRemarks = @goodMessage
			END
			ELSE
			BEGIN
				SET @tmpStatus = 'Info'
				SET @tmpRemarks = ''
				SET @tmpReason = 'No data available'
			END
			IF EXISTS (SELECT * FROM @TblFragmentation)
				SELECT @tmpReason += (DatabaseName
					+ CASE WHEN Percentage > @criticalThreshold THEN ': Critical, <b>'
						WHEN Percentage > @warningThreshold THEN ': Warning, <b>' ELSE ': Info, <b>' END
					+ CAST(Percentage AS VARCHAR(3)) + '% </b> indices are over 30% fragmented<BR/>')
				FROM   @TblFragmentation
				ORDER BY DatabaseName
			IF (@i_status = '')
			BEGIN
				IF EXISTS (SELECT * FROM @TblFragmentation WHERE Percentage > @i_paramValue)
				BEGIN
					DECLARE @databases NVARCHAR(258) = 'Database(s) <b>'
					SET @databases += STUFF((SELECT ', ' + DatabaseName
					FROM @tblFragmentation
					WHERE Percentage > @i_paramValue
					FOR XML PATH('')), 1, 1, '')
					SET @databases += '</b> have more than <b>' + CAST(@i_paramValue AS NVARCHAR(16)) + '%</b> of indices fragmented over 30%'
					INSERT INTO #resultTbl (Result) VALUES (@databases)
					UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
					UPDATE #resultTbl SET Reason = @tmpReason
					UPDATE #resultTbl SET Remarks = @tmpRemarks
				END
			END
			IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
					(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
					(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTbl SET Result = 'Database Index Fragmentation for CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus + '</b> status'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		ELSE IF @i_paramName = 'Prune All Database Agent Logs Only By Days Retention Rule'
		BEGIN
			SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 124
			SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 144
			SET @tmpStatus = 'Good'
			SET @tmpReason = ''
			SET @tmpRemarks = ''
			DECLARE @settingValue INT = 0
			DECLARE @settingValueString NVARCHAR(MAX) = ''
			SELECT @settingValue = csInfo.Value, @settingValueString = csInfo.ValueString
				FROM cf_surveyHighRiskSettings AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = 124
						AND	csInfo.Name = 'Prune All Database Agent Logs Only By Days Retention Rule'
			SET @tmpStatus = CASE WHEN @settingValue = 0 THEN 'Good' ELSE 'Critical' END
			SET @tmpReason = @settingValueString
			SET @tmpRemarks = CASE WHEN @settingValue = 0 THEN @goodMessage ELSE @CriticalMessage END
			IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
					(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
					(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @i_CCGUID)
				UPDATE #resultTbl SET Result = 'Prune All Database Agent Logs Only By Days Retention Rule property for CommCell <b>' + CommServeName + '</b> is <b>' + LOWER(@settingValueString) + '</b>'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		ELSE
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES ('NoNotifReq')
		END
		IF NOT EXISTS (SELECT * FROM #resultTbl)
			INSERT INTO #resultTbl (Result) VALUES ('NoNotifReq')
		SET @query = 'SELECT Result AS "' + @i_paramName + '",
						ISNULL(CommServeName, '''') AS "CommServeName",
						CASE WHEN ISNULL(Reason, '''') = '''' THEN ''None'' ELSE Reason END AS "Reason",
						CASE WHEN ISNULL(Remarks, '''') = '''' THEN ''None'' ELSE Remarks END AS "Remarks",
						0 AS "CsUniqueId"
					  FROM #resultTbl'
		EXEC sp_executesql @query
		IF object_id('tempdb.dbo.#resultTbl') is not null DROP TABLE #resultTbl
	END
	ELSE IF @i_type = 1
	BEGIN
		IF object_id('tempdb.dbo.#finalResultSet') is not null DROP TABLE #finalResultSet
		IF object_id('tempdb.dbo.#columnList') is not null DROP TABLE #columnList
		CREATE TABLE #columnList
		(
			position INT,
			columnName	NVARCHAR(1024),
			dataType    NVARCHAR(32),
			value		NVARCHAR(MAX),
			operator	INT,
			renderer	NVARCHAR(128),
			visible		NVARCHAR(32),
			rel			INT
		)
		DECLARE @whereClause NVARCHAR(MAX) = N''
		DECLARE @tableQuery NVARCHAR(MAX) = N''
		DECLARE	@selectQuery NVARCHAR(MAX) = N''
		DECLARE @andOrOr NVARCHAR(8) = N''
		SELECT  @andOrOr = T.cc.value('@andOrOr', 'nvarchar(8)')
		FROM	@i_inXML.nodes('/survey_AlarmCondition') T(cc)
		SELECT	@query = T.cc.value('@query', 'nvarchar(MAX)')
		FROM	@i_inXML.nodes('/survey_AlarmCondition') T(cc)
		INSERT INTO #columnList
		SELECT	T.cc.value('@index', 'INT'),
				T.cc.value('@name', 'nvarchar(1024)'),
				ISNULL(T.cc.value('@type', 'nvarchar(32)'),''),
				ISNULL(T.cc.value('@value', 'nvarchar(MAX)'),''),
				T.cc.value('@operator', 'INT'),
				ISNULL(T.cc.value('@renderer', 'nvarchar(128)'),''),
				T.cc.value('@visible', 'nvarchar(32)'),
				ISNULL(T.cc.value('@rel', 'INT'),0)
		FROM	@i_inXML.nodes('/survey_AlarmCondition/columnList') T(cc)
		ORDER BY T.cc.value('@index', 'INT')
		--Dirty code to detect and add check on LogDateUTC column
		DECLARE @needToAddLogDateUTC INT = 0
		DECLARE @maxIndex INT = 0
		IF CHARINDEX('csInfo.CommCellSurveyServices', @query) <> 0
			SET @needToAddLogDateUTC = 1
		IF @needToAddLogDateUTC = 1
		BEGIN
			SELECT @maxIndex = MAX(position) FROM #columnList
			INSERT	INTO #columnList
			SELECT	@maxIndex + 1,
					'Collection Time(UTC)',
					dataType,
					value,
					operator,
					renderer,
					'false',
					rel
			FROM	#columnList
			WHERE	columnName = 'Collection Time'
				AND	ISNULL(value, '') <> ''
				AND visible = 'true'
			UPDATE #columnList SET value = '' WHERE columnName = 'Collection Time'
			SET @query = REPLACE (@query, 'FROM cf_SurveyResultFunc', ', DATEDIFF(s, ''1970-01-01 00:00:00'', ISNULL(resultFn.LogDateUTC, ''1970-01-01 00:00:00'')) AS ''Collection Time(UTC)'' FROM cf_SurveyResultFunc')
		END
		SELECT @tableQuery=(select '['+columnName+(CASE
		WHEN renderer = 'capacityMB' OR renderer = 'sizeMB' OR dataType = 'decimal' or dataType = 'float'
			THEN '] DECIMAL(38,2), '
		WHEN renderer like 'Number%' OR dataType like '%int' OR renderer = 'dateTimeRenderer'
			THEN '] BIGINT, '
		WHEN dataType = 'DATE'
			THEN '] DATE, '
		WHEN dataType = 'DATETIME'
			THEN '] DATETIME, '
		WHEN renderer = 'dashboard'
			THEN ''
		ELSE
			'] NVARCHAR(MAX), '
		END)
		FROM (SELECT distinct position,columnName,renderer,dataType FROM #columnList) A
		ORDER BY position
		FOR XML path(''))
		DECLARE @now INTEGER = DATEDIFF(SECOND,'01/01/1970',GETUTCDATE())
		SELECT @whereClause=STUFF((SELECT ' '+@andOrOr+' '+(CASE
												WHEN renderer = 'booleanRenderer' THEN
													'[' + columnName + ']' + (CASE operator WHEN 0 THEN ' < ' WHEN 1 THEN ' > ' ELSE ' = ' END) + '''' + REPLACE(value,'''','''''') + ''''
												WHEN renderer = 'dateTimeRenderer' AND rel <> 1 THEN
													'[' + columnName + ']-DATEPART(SECOND,dbo.GETDATEtime([' + columnName + ']))' + (CASE operator WHEN 0 THEN ' < ' WHEN 1 THEN ' > ' ELSE ' = ' END) + ' CAST (' + value + ' AS BIGINT) '
												WHEN renderer = 'HEALTH_STATUS' THEN
													'[' + columnName + ']' + (CASE operator WHEN 0 THEN ' < ' WHEN 1 THEN ' > ' ELSE ' = ' END) + '''' + REPLACE(value,'''','''''') + ''''
												WHEN renderer = 'capacityMB' OR renderer = 'sizeMB' OR dataType = 'decimal' THEN
													'CAST([' + columnName + '] AS DECIMAL(38,7))' + (CASE operator WHEN 0 THEN ' < ' WHEN 1 THEN ' > ' ELSE ' = ' END) + ' CAST (' + value+ ' AS DECIMAL(38,7)) '
												WHEN renderer like 'Number%' OR dataType like '%int' THEN
													'[' + columnName + ']' +	(CASE WHEN rel = 1 THEN
																						  (CASE operator
																										WHEN 4 THEN ' BETWEEN ' + CAST ((@now - value) AS NVARCHAR(16)) + ' AND ' + CAST (@now AS NVARCHAR(16)) -- In Last n Days
																										WHEN 5 THEN ' < ' + CAST ((@now - value) AS NVARCHAR(16)) + ' AND [' + columnName + '] >= 0'			-- Beyond Last n Days
																										WHEN 6 THEN ' BETWEEN ' + CAST (@now AS NVARCHAR(16)) + ' AND ' + CAST ((@now + value) AS NVARCHAR(16))	-- In Next n Days
																										WHEN 7 THEN ' > ' + CAST ((@now + value) AS NVARCHAR(16)) + ' OR [' + columnName + '] = -3'				-- Beyond Next n Days
																										WHEN 0 THEN ' > ' + CAST ((@now - value) AS NVARCHAR(16))
																										WHEN 1 THEN ' < ' + CAST ((@now - value) AS NVARCHAR(16))
																						  END)
																					  ELSE (CASE operator WHEN 0 THEN ' < ' WHEN 1 THEN ' > ' ELSE ' = ' END) + ' CAST (' + value+ ' AS BIGINT) '
																				END)
												WHEN renderer = 'MMMYYYY' THEN
													'CAST([' + columnName + '] AS DATE)' + (CASE operator WHEN 0 THEN ' < ' WHEN 1 THEN ' > ' ELSE ' = ' END) + 'CAST (''' + value + ''' AS DATE)'
												WHEN dataType = 'DATE' THEN
													'CAST([' + columnName + '] AS DATE)' + (CASE operator WHEN 0 THEN ' < ' WHEN 1 THEN ' > ' ELSE ' = ' END) + 'CAST (''' + value + ''' AS DATE)'
												WHEN dataType = 'DATETIME' THEN
													'CAST([' + columnName + '] AS DATETIME)' + (CASE operator WHEN 0 THEN ' < ' WHEN 1 THEN ' > ' ELSE ' = ' END) + 'CAST (''' + value + ''' AS DATETIME)'
												ELSE
													'[' + columnName + ']' + (CASE operator WHEN 0 THEN ' < ' WHEN 1 THEN ' > ' WHEN 2 THEN ' = ' ELSE ' LIKE ' END) + '''' +
													CASE WHEN operator = 3 THEN '%' ELSE '' END + REPLACE(value,'''','''''') + CASE WHEN operator = 3 THEN '%' ELSE '' END + ''''
											END)
											FROM #columnList WHERE value <> ''
											FOR XML path('')),1,LEN(@andOrOr)+1,'')
		SELECT  @selectQuery=STUFF((SELECT ',dbo.GetRenderedValue([' + columnName + '], ' + '''' + renderer + ''','''+ dataType +''') AS [' + columnName + ']'
			FROM #columnList
			WHERE visible = 'true' AND renderer <> 'dashboard'
			FOR XML path('')),1,1,'')
		IF @tableQuery IS NOT NULL AND @tableQuery <> ''
		SET @tableQuery='CREATE TABLE #finalResultSet ( '+ @tableQuery +')'
		IF @whereClause IS NOT NULL AND @whereClause <> ''
		BEGIN
			SET @whereClause = REPLACE(@whereClause,'&gt;','>')
			SET @whereClause = REPLACE(@whereClause,'&lt;','<')
			SET @whereClause = REPLACE(@whereClause,'&amp;','&')
			SET @whereClause = REPLACE(@whereClause,'&apos;','''')
			SET @whereClause = REPLACE(@whereClause,'&quot;','"')
			SET @whereClause = ' WHERE '+@whereClause
		END
		IF @selectQuery IS NOT NULL AND @selectQuery <> ''
		SET @selectQuery=	'SELECT TOP 50 '+ @selectQuery +' FROM #finalResultSet '
		IF @query IS NOT NULL AND @query <> ''
		SET @tableQuery=@tableQuery+'INSERT INTO #finalResultSet '+@query
		IF @selectQuery IS NOT NULL AND @selectQuery <> ''
		SET @tableQuery = @tableQuery+' IF EXISTS (SELECT * FROM #finalResultSet' + @whereClause + ' ) '
									+ @selectQuery + @whereClause + '
								ELSE
									SELECT ''NoNotifReq'' AS "Result" '
		ELSE
		SET @tableQuery = 'SELECT ''NoNotifReq'' AS "Result" '
		EXEC sp_executesql @tableQuery
		IF object_id('tempdb.dbo.#columnList') is not null DROP TABLE #columnList
		IF object_id('tempdb.dbo.#finalResultSet') is not null DROP TABLE #finalResultSet
	END
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'runCustomAlarm')
	delete from GxQscripts where name = 'runCustomAlarm'
GO

IF EXISTS (select * from GXDBVersions where aliasname='runCustomAlarm')
	delete from GXDBVersions where aliasname = 'runCustomAlarm'
GO

insert into GXDBVersions values(2, 'runCustomAlarm',  '00010019000200040000', 'runCustomAlarm', '00010019000200040000')
GO

