SET QUOTED_IDENTIFIER OFF


--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ManageSurvey.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ManageSurvey.sp,v $ $Id: ManageSurvey.sp,v 1.2 2014/02/26 11:21:16 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ManageSurvey <<<'

IF EXISTS (select * from sysobjects where name='ManageSurvey')
	drop procedure ManageSurvey
IF EXISTS (select * from GxQscripts where name='ManageSurvey')
	delete from GxQscripts where name = 'ManageSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ManageSurvey')
	delete from GXDBVersions where aliasname = 'ManageSurvey'
GO
print '... Creating Procedure: ManageSurvey'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ManageSurvey
  @Operation INTEGER = 0,
  @SurveyId INTEGER = 0,
  @Name nvarchar(200)	= '',
  @Description nvarchar(1024)	= '',
  @Details nvarchar(max)	= '',
  @DoneBy nvarchar(1024)	= '',
  @AssignedTo nvarchar(1024)	= '',
  @Status nvarchar(200)	= '',
  @CollectScript nvarchar(max)	= '',
  @CollectScriptName nvarchar(200)	= '',
  @CollectScriptURL nvarchar(1024)	= '',
  @CollectionEnabled INTEGER = 0,
  @ReportScriptName nvarchar(200)	= '',
  @ReportScript nvarchar(max)	= '',
  @ReportingEnabled INTEGER = 0 ,
  @flags INTEGER = 0 ,
  @ReportRetentionDays INTEGER =30
AS
BEGIN
SET NOCOUNT ON
DECLARE @tblFlag INTEGER = 0
IF @Operation = 1 --Add new
BEGIN
	DECLARE @QueryId INTEGER = -1
	SELECT @QueryId = ISNULL(MAX(QueryId), 1)+1 FROM cf_CommservSurveyQueries
	DECLARE @param_isPrivate INT = 0
	SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
	IF((@QueryId<10000)AND (@param_isPrivate = 1))
		SET @QueryId =10000
	INSERT INTO cf_CommservSurveyQueries(QueryId, Name, Description, Details, SubmittedBy, AssignedTo, LastUpdatedBy, ParserScriptName, Flags,DataRetentionDays)
		VALUES(@QueryId, @Name, @Description, @Details, @DoneBy, @AssignedTo, @DoneBy, 'RptSurveyResultsXML', @flags,@ReportRetentionDays )
END
ELSE IF @Operation = 2 --Update General Information
BEGIN
	IF (@SurveyId <= 1 OR LEN(@Name) <= 0 OR LEN(@Description) <= 0 OR LEN(@Details) <= 0 OR LEN(@DoneBy) <= 0 OR LEN(@AssignedTo) <= 0)
		RETURN
	UPDATE cf_CommservSurveyQueries SET
		Name = @Name,
		Description = @Description,
		Details = @Details,
		AssignedTo = @AssignedTo,
		LastUpdatedBy = @DoneBy,
		LastUpdatedTime = GETUTCDATE(),
		Flags = @flags , -- this will be allowed before review completed
		DataRetentionDays = @ReportRetentionDays
	WHERE QueryId = @SurveyId
END
ELSE IF @Operation = 3 --Update Collection Information
BEGIN
	IF (@SurveyId <= 1)
		RETURN
	UPDATE cf_CommservSurveyQueries SET
		Status = @Status,
		CollectScript = @CollectScript,
		--Flags = 3,
		CollectScriptName = @CollectScriptName,
		CollectScriptURL = @CollectScriptURL
	WHERE QueryId = @SurveyId
END
ELSE IF @Operation = 4 --Update Only Parser & Reporting Information
BEGIN
	IF (@SurveyId <= 1 )
		RETURN
	SELECT @tblFlag = Flags  FROM cf_CommservSurveyQueries WHERE QueryId = @SurveyId
	IF (LEN(@ReportScriptName) > 0 )
	BEGIN
	IF ((@tblFlag& 1)=0) -- TO UPDATE REPORTING SP ONLY
		SET @tblFlag = @tblFlag + 1
	UPDATE cf_CommservSurveyQueries SET
		ParserScriptName = @ReportScriptName,
		Flags = @tblFlag
	WHERE QueryId = @SurveyId
	END
	IF (LEN(@ReportScript) > 0 )
	BEGIN
	IF ((@tblFlag& 2)=0) -- TO UPDATE Parser SP ONLY
		SET @tblFlag = @tblFlag + 2
	UPDATE cf_CommservSurveyQueries SET
		ParserScript = @ReportScript,
		Flags = @tblFlag
	WHERE QueryId = @SurveyId
	END
END
ELSE IF @Operation = 5 --Change Survey Status
BEGIN
	IF (@SurveyId <= 1)
		RETURN
	UPDATE cf_CommservSurveyQueries SET
		Status = @Status,
		CollectScriptURL = @CollectScriptURL
	WHERE QueryId = @SurveyId
END
ELSE IF @Operation = 6 --Change Survey RetentionDays
BEGIN
	IF (@SurveyId <= 1)
		RETURN
	UPDATE cf_CommservSurveyQueries SET
		DataRetentionDays = @ReportRetentionDays
	WHERE QueryId = @SurveyId
END
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'ManageSurvey')
	delete from GxQscripts where name = 'ManageSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ManageSurvey')
	delete from GXDBVersions where aliasname = 'ManageSurvey'
GO

insert into GXDBVersions values(2, 'ManageSurvey',  '00010002000000000000', 'ManageSurvey', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/StartParsingCollectedFiles.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/StartParsingCollectedFiles.sp,v $ $Id: StartParsingCollectedFiles.sp,v 1.4 2014/09/19 19:32:10 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: StartParsingCollectedFiles <<<'

IF EXISTS (select * from sysobjects where name='StartParsingCollectedFiles')
	drop procedure StartParsingCollectedFiles
IF EXISTS (select * from GxQscripts where name='StartParsingCollectedFiles')
	delete from GxQscripts where name = 'StartParsingCollectedFiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='StartParsingCollectedFiles')
	delete from GXDBVersions where aliasname = 'StartParsingCollectedFiles'
GO
print '... Creating Procedure: StartParsingCollectedFiles'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure StartParsingCollectedFiles
  @parseTime DATETIME,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @ErrorFlag INT = 0
DECLARE @ErrorString NVARCHAR(MAX) = 'Processing Survey - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
--Set ShredStaus = 3(Not Required) for blocked CommCells
UPDATE cf_CustomerFeedbackXmlFile
	SET
		ShredStatus = 3,
		--Logging = Logging + 'Warn: Parsing Not required!!!',
		ParseTime = @parseTime
	FROM cf_CustomerFeedbackXmlFile AS files
		INNER JOIN cf_CommcellIdNameMap AS CommCell
			ON files.CommcellIdNameMap_ID = CommCell.ID
				AND (CommCell.Flags & 1) = 1
				AND ShredStatus = 0
--Set ShredStaus = 3(Not Required) for blocked CommCells
UPDATE cf_CommservSurveyResults SET ShredStatus = 3
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ID = results.CustomerFeedbackXmlFile_ID
			AND files.ShredStatus = 3
			AND results.ShredStatus NOT IN (2, 3)
--Delete Collected Results with future date
--DELETE	FROM cf_CommservSurveyResults
--WHERE	LogDateUTC > GETUTCDATE()
--Set ShredStatus = 1 for files which are to be processed
UPDATE	cf_CustomerFeedbackXmlFile
SET		ShredStatus = 1, ParseTime = @parseTime
WHERE	ShredStatus IN (0,1)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'StartParsingCollectedFiles')
	delete from GxQscripts where name = 'StartParsingCollectedFiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='StartParsingCollectedFiles')
	delete from GXDBVersions where aliasname = 'StartParsingCollectedFiles'
GO

insert into GXDBVersions values(2, 'StartParsingCollectedFiles',  '00010004000000000000', 'StartParsingCollectedFiles', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCollectedResultsForSurvey.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCollectedResultsForSurvey.sp,v $ $Id: ParseCollectedResultsForSurvey.sp,v 1.7 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseCollectedResultsForSurvey <<<'

IF EXISTS (select * from sysobjects where name='ParseCollectedResultsForSurvey')
	drop procedure ParseCollectedResultsForSurvey
IF EXISTS (select * from GxQscripts where name='ParseCollectedResultsForSurvey')
	delete from GxQscripts where name = 'ParseCollectedResultsForSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCollectedResultsForSurvey')
	delete from GXDBVersions where aliasname = 'ParseCollectedResultsForSurvey'
GO
print '... Creating Procedure: ParseCollectedResultsForSurvey'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseCollectedResultsForSurvey
  @parseTime DATETIME,
  @surveyId INTEGER,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @ParseSP SYSNAME
SELECT  @ParseSP = ParserScript FROM cf_CommservSurveyQueries WHERE QueryId = @surveyId
IF LEN(@ParseSP) <= 0
BEGIN
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'No Parse script available for Query ID ' + CAST(@surveyId AS VARCHAR(10))
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	RETURN
END
SELECT @ErrorString = 'Start Parsing Collected Results for Query ID ' + CAST(@surveyId AS VARCHAR(10))
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
--Set ShredStatus = 1(Processing) for the results which are falling in sepecified intervals
UPDATE	cf_CommservSurveyResults SET ShredStatus = 1
FROM	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON results.QueryId = @surveyId
			AND files.ShredStatus = 1
			AND files.ParseTime = @parseTime
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 0
--Execute corresponding Parser script by building Dynamic Query
DECLARE @SQLString NVARCHAR(500)
DECLARE @ParmDefinition NVARCHAR(500)
DECLARE @RetErrorCode INTEGER = 0
DECLARE @RetErrorString NVARCHAR(MAX) = ''
SET @SQLString=N'EXEC ' + @ParseSP + ' @iParseTime, @errorCode OUTPUT, @errorString OUTPUT, @printOn'
SET @ParmDefinition=N'@iParseTime DATETIME, @errorCode INTEGER OUTPUT, @errorString NVARCHAR(MAX) OUTPUT, @printOn INTEGER'
BEGIN TRY
    EXECUTE sp_executesql @SQLString, @ParmDefinition, @iParseTime = @parseTime, @errorCode = @RetErrorCode OUTPUT,@errorString = @RetErrorString OUTPUT, @printOn = @isPrintOn
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	IF (@@TRANCOUNT > 0)
		ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ErrorCode = 1
	SET @ErrorString = 'Exception from the parser for Query ID ' + CAST(@surveyId AS VARCHAR(10)) + ' !!! Failed with error :: ' + ERROR_MESSAGE()
	IF  @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	RETURN
END CATCH
--If success set ShredStatus = 2(Completed)
--else set ShredStatus = 0(to be processed again) be rolling back the transaction
IF @RetErrorCode = 0
BEGIN
	DECLARE @ProcessSurveyResultTran INT
	SET @ProcessSurveyResultTran = 0
  BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	UPDATE	cf_CommservSurveyResults
	SET		ShredStatus = 2, CollectedResults = CASE WHEN @surveyId = 40 THEN results.CollectedResults ELSE NULL END
	FROM	cf_CommservSurveyResults AS results
			INNER JOIN cf_CustomerFeedbackXmlFile AS files
				ON files.ShredStatus = 1
				AND files.ParseTime = @parseTime
				AND files.ID = results.CustomerFeedbackXmlFile_ID
				AND results.ShredStatus = 1
				AND results.QueryId = @surveyId
	--Reset LatestSurveyResult Flags
	UPDATE	cf_CommservSurveyResults SET Flags = 0
	WHERE	QueryId = @surveyId AND Flags = 1
	--Set Flags = 1 for the latest parsed results
	UPDATE	cf_CommservSurveyResults SET Flags = 1
	FROM	(SELECT	S.CommcellIdNameMap_ID, MAX(S.CommservSurveyResults_ID) AS CommservSurveyResults_ID
			FROM	cf_CommservSurveyResults AS S
					INNER JOIN (SELECT	CommcellIdNameMap_ID, MAX(LogDateUTC) AS LogDateUTC
								FROM	cf_CommservSurveyResults
								WHERE	QueryId = @surveyId AND ShredStatus = 2
								GROUP BY CommcellIdNameMap_ID) AS T
							ON S.QueryId = @surveyId
						AND S.ShredStatus = 2
						AND S.LogDateUTC = T.LogDateUTC
						AND S.CommcellIdNameMap_ID = T.CommcellIdNameMap_ID
			GROUP BY S.CommcellIdNameMap_ID) L
	WHERE	cf_CommservSurveyResults.CommcellIdNameMap_ID = L.CommcellIdNameMap_ID
		AND cf_CommservSurveyResults.CommservSurveyResults_ID = L.CommservSurveyResults_ID
	IF @ProcessSurveyResultTran = 1
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Successfully parsed Collected Results for Query ID ' + CAST(@surveyId AS VARCHAR(10))
  END TRY
  BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
	BEGIN
		ROLLBACK TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
		SET @ErrorCode = 1
		SET @ErrorString = 'Failed to parse Collected Results for Query ID ' + CAST(@surveyId AS VARCHAR(10)) + ' !!! Failed with error :: ' + ERROR_MESSAGE()
	END
  END CATCH
END
ELSE
	SELECT @ErrorString = 'Failed to parse Collected Results for Query ID ' + CAST(@surveyId AS VARCHAR(10))
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCollectedResultsForSurvey')
	delete from GxQscripts where name = 'ParseCollectedResultsForSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCollectedResultsForSurvey')
	delete from GXDBVersions where aliasname = 'ParseCollectedResultsForSurvey'
GO

insert into GXDBVersions values(2, 'ParseCollectedResultsForSurvey',  '00010007000000000000', 'ParseCollectedResultsForSurvey', '00010007000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ProcessCollectedResults.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ProcessCollectedResults.sp,v $ $Id: ProcessCollectedResults.sp,v 1.1 2013/03/15 00:28:47 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ProcessCollectedResults <<<'

IF EXISTS (select * from sysobjects where name='ProcessCollectedResults')
	drop procedure ProcessCollectedResults
IF EXISTS (select * from GxQscripts where name='ProcessCollectedResults')
	delete from GxQscripts where name = 'ProcessCollectedResults'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ProcessCollectedResults')
	delete from GXDBVersions where aliasname = 'ProcessCollectedResults'
GO
print '... Creating Procedure: ProcessCollectedResults'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ProcessCollectedResults
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @IsAnyError INTEGER = 0
DECLARE @curTime DATETIME = GETUTCDATE()
--Identify the Collection Categories that are enabled
DECLARE @CollectionList TABLE(Id INTEGER, Processed INTEGER)
INSERT INTO @CollectionList
	SELECT QueryId, 0 FROM cf_CommservSurveyQueries WHERE Flags & 2 = 2
--Initialise Files to be processes
EXEC StartParsingCollectedFiles @curTime, @isPrintOn
--Parse Each collection category
DECLARE @CurrentId INTEGER = 0
WHILE (SELECT COUNT(*) FROM @CollectionList WHERE Processed = 0) > 0
BEGIN
	SELECT TOP 1 @CurrentId = Id FROM @CollectionList WHERE Processed = 0
	DECLARE @retErrorCode INTEGER
	DECLARE @retError NVARCHAR(MAX)
	EXEC ParseCollectedResultsForSurvey @curTime, @CurrentId, @retErrorCode OUTPUT, @retError OUTPUT, @isPrintOn
	IF @retErrorCode <> 0
		SET @IsAnyError = 1
	UPDATE @CollectionList SET Processed = 1 Where Id = @CurrentId
END
--Finalize the processed files
EXEC EndParsingCollectedFiles @curTime, @IsAnyError, @isPrintOn
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ProcessCollectedResults')
	delete from GxQscripts where name = 'ProcessCollectedResults'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ProcessCollectedResults')
	delete from GXDBVersions where aliasname = 'ProcessCollectedResults'
GO

insert into GXDBVersions values(2, 'ProcessCollectedResults',  '00010001000000000000', 'ProcessCollectedResults', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/EndParsingCollectedFiles.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/EndParsingCollectedFiles.sp,v $ $Id: EndParsingCollectedFiles.sp,v 1.1 2013/03/15 00:28:47 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: EndParsingCollectedFiles <<<'

IF EXISTS (select * from sysobjects where name='EndParsingCollectedFiles')
	drop procedure EndParsingCollectedFiles
IF EXISTS (select * from GxQscripts where name='EndParsingCollectedFiles')
	delete from GxQscripts where name = 'EndParsingCollectedFiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EndParsingCollectedFiles')
	delete from GXDBVersions where aliasname = 'EndParsingCollectedFiles'
GO
print '... Creating Procedure: EndParsingCollectedFiles'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure EndParsingCollectedFiles
  @parseTime DATETIME,
  @ErrorFlag INTEGER,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @ErrorString NVARCHAR(MAX)
--If success set ShredStatus = 2(Completed)
--else set ShredStatus = 0(to be processed again)
UPDATE	cf_CustomerFeedbackXmlFile
SET		ShredStatus = (CASE @ErrorFlag WHEN 0 THEN 2 ELSE 0 END)
WHERE	ShredStatus = 1 AND ParseTime = @parseTime
SET @ErrorString = (CASE @ErrorFlag WHEN 0 THEN 'Processing Survey - successfully completed' ELSE 'Processing Survey - completed with some error' END)
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'EndParsingCollectedFiles')
	delete from GxQscripts where name = 'EndParsingCollectedFiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='EndParsingCollectedFiles')
	delete from GXDBVersions where aliasname = 'EndParsingCollectedFiles'
GO

insert into GXDBVersions values(2, 'EndParsingCollectedFiles',  '00010001000000000000', 'EndParsingCollectedFiles', '00010001000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/PruneSurveyResults.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/PruneSurveyResults.sp,v $ $Id: PruneSurveyResults.sp,v 1.15 2015/07/09 06:15:27 vmishra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: PruneSurveyResults <<<'

IF EXISTS (select * from sysobjects where name='PruneSurveyResults')
	drop procedure PruneSurveyResults
IF EXISTS (select * from GxQscripts where name='PruneSurveyResults')
	delete from GxQscripts where name = 'PruneSurveyResults'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PruneSurveyResults')
	delete from GXDBVersions where aliasname = 'PruneSurveyResults'
GO
print '... Creating Procedure: PruneSurveyResults'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure PruneSurveyResults
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @ErrorCode INTEGER
DECLARE @ErrorString NVARCHAR(MAX)
SELECT @ErrorString = 'PruneSurveyResults - Start'
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
CREATE TABLE #QueryRetention (QueryId INT, DataRetentionDays INT, RetainUntil DATETIME, DataRetentionFlags INT)
CREATE TABLE #SurveyResultsToDelete (CommservSurveyResults_ID INT)
DECLARE @nRow	INT = 1
DECLARE @counts	INT = 0
-- Remove CommCells which have no data collection for last 90 days
BEGIN TRANSACTION
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
DECLARE	@CCRetentionDays INT
IF ( @param_isPrivate = 1)
   SET @CCRetentionDays = 365
ELSE
   SET @CCRetentionDays = 90
SELECT	@CCRetentionDays  = CAST(Value AS INT)
FROM	cf_SurveyConfig
WHERE	Name = 'RetentionDaysForCellsNotUploading'
DELETE	cf_CommcellIdNameMap
FROM	cf_CommcellIdNameMap T
		LEFT OUTER JOIN
		(SELECT	CommcellIdNameMap_ID, MAX(cast(FileTime as Datetime)) AS maxFileTime
		FROM	cf_CustomerFeedbackXmlFile
		GROUP BY CommcellIdNameMap_ID
		HAVING MAX(cast(FileTime as Datetime)) > DATEADD(DAY, -@CCRetentionDays, GETUTCDATE())
		UNION
		SELECT	CommServUniqueId, MAX(LogDateUTC)
		FROM	cf_SurveyUpgradeReadiness
		GROUP BY CommServUniqueId
		HAVING MAX(LogDateUTC) > DATEADD(DAY, -@CCRetentionDays, GETUTCDATE())
		) S ON T.ID = S.CommcellIdNameMap_ID
WHERE	S.CommcellIdNameMap_ID IS NULL
SELECT @ErrorCode = @@ERROR, @nRow = @@ROWCOUNT
IF @ErrorCode = 0
	COMMIT TRANSACTION
ELSE
	ROLLBACK TRANSACTION
IF	@ErrorCode = 0
	SET	@ErrorString = 'PruneSurveyResults -  Remove CommCells which have no data collection for ' + CAST(@CCRetentionDays as varchar(20)) +' days. Deleted [' + CAST(@nRow AS VARCHAR(20)) + '] rows.'
ELSE
	SET @ErrorString = 'PruneSurveyResults - Failed with error :: ' + ERROR_MESSAGE()
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
-- Delete orphan results for missing QueryId
BEGIN TRANSACTION
DELETE	cf_CommservSurveyResults
FROM	cf_CommservSurveyResults R
		LEFT OUTER JOIN cf_CommservSurveyQueries Q ON R.QueryId = Q.QueryId
WHERE Q.QueryId IS NULL
SELECT @ErrorCode = @@ERROR, @nRow = @@ROWCOUNT
IF @ErrorCode = 0
	COMMIT TRANSACTION
ELSE
	ROLLBACK TRANSACTION
IF	@ErrorCode = 0
	SET	@ErrorString = 'PruneSurveyResults -  Delete orphan results for missing QueryId. Deleted [' + CAST(@nRow AS VARCHAR(20)) + '] rows.'
ELSE
	SET @ErrorString = 'PruneSurveyResults - Failed with error :: ' + ERROR_MESSAGE()
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
--Delete all entries for disabled queries
INSERT	INTO #QueryRetention
SELECT	QueryId, DataRetentionDays, DATEADD(DAY, -DataRetentionDays, GETUTCDATE()), DataRetentionIntervalHrs
FROM	cf_CommservSurveyQueries WITH (NOLOCK)
WHERE	(Flags & 2) = 0
SET @nRow = 1
SET	@counts = 0
WHILE @nRow > 0
BEGIN
	TRUNCATE TABLE #SurveyResultsToDelete
	INSERT	INTO #SurveyResultsToDelete
	SELECT	TOP 5000 A.CommservSurveyResults_ID
	FROM	cf_CommservSurveyResults A
			INNER JOIN #QueryRetention B
				ON A.QueryId = B.QueryId
	BEGIN TRANSACTION
	DELETE	cf_CommservSurveyResults WITH (PAGLOCK)
	FROM	#SurveyResultsToDelete T
	WHERE	cf_CommservSurveyResults.CommservSurveyResults_ID = T.CommservSurveyResults_ID
	SELECT @ErrorCode = @@ERROR, @nRow = @@ROWCOUNT
	IF @ErrorCode = 0
		COMMIT TRANSACTION
	ELSE
	BEGIN
		ROLLBACK TRANSACTION
		BREAK
	END
	SET	@counts += @nRow
END
IF	@ErrorCode = 0
	SET	@ErrorString = 'PruneSurveyResults - Deleted [' + CAST(@counts AS VARCHAR(20)) + '] results for disabled queries.'
ELSE
	SET @ErrorString = 'PruneSurveyResults - Failed with error :: ' + ERROR_MESSAGE()
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
--Delete entries not required for parsing (ShredStatus = 3)
TRUNCATE TABLE #QueryRetention
INSERT	INTO #QueryRetention
SELECT	QueryId, DataRetentionDays, DATEADD(DAY, -DataRetentionDays, GETUTCDATE()), DataRetentionIntervalHrs
FROM	cf_CommservSurveyQueries WITH (NOLOCK)
WHERE	(Flags & 2) = 2
SET @nRow = 1
SET	@counts = 0
WHILE @nRow > 0
BEGIN
	TRUNCATE TABLE #SurveyResultsToDelete
	INSERT	INTO #SurveyResultsToDelete
	SELECT	TOP 5000 A.CommservSurveyResults_ID
	FROM	cf_CommservSurveyResults A
			INNER JOIN #QueryRetention B
				ON A.QueryId = B.QueryId AND A.Flags <> 1 AND A.ShredStatus = 3
	BEGIN TRANSACTION
	DELETE	cf_CommservSurveyResults WITH (PAGLOCK)
	FROM	#SurveyResultsToDelete T
	WHERE	cf_CommservSurveyResults.CommservSurveyResults_ID = T.CommservSurveyResults_ID
	SELECT @ErrorCode = @@ERROR, @nRow = @@ROWCOUNT
	IF @ErrorCode = 0
		COMMIT TRANSACTION
	ELSE
	BEGIN
		ROLLBACK TRANSACTION
		BREAK
	END
	SET	@counts += @nRow
END
IF	@ErrorCode = 0
	SET	@ErrorString = 'PruneSurveyResults - Deleted [' + CAST(@counts AS VARCHAR(20)) + '] not required results.'
ELSE
	SET @ErrorString = 'PruneSurveyResults - Failed with error :: ' + ERROR_MESSAGE()
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
--Delete aged entries and those which are not latest
SET @nRow = 1
SET	@counts = 0
WHILE @nRow > 0
BEGIN
	TRUNCATE TABLE #SurveyResultsToDelete
	INSERT	INTO #SurveyResultsToDelete
	SELECT	TOP 5000 A.CommservSurveyResults_ID
	FROM	cf_CommservSurveyResults A
			INNER JOIN #QueryRetention B
				ON A.QueryId = B.QueryId AND A.Flags <> 1 AND A.ShredStatus <> 1 AND A.LogDateUTC < B.RetainUntil
	WHERE	(A.QueryId <> 137 OR A.ShredStatus = 2)
	BEGIN TRANSACTION
	DELETE	cf_CommservSurveyResults WITH (PAGLOCK)
	FROM	#SurveyResultsToDelete T
	WHERE	cf_CommservSurveyResults.CommservSurveyResults_ID = T.CommservSurveyResults_ID
	SELECT @ErrorCode = @@ERROR, @nRow = @@ROWCOUNT
	IF @ErrorCode = 0
		COMMIT TRANSACTION
	ELSE
	BEGIN
		ROLLBACK TRANSACTION
		BREAK
	END
	SET	@counts += @nRow
END
IF	@ErrorCode = 0
	SET	@ErrorString = 'PruneSurveyResults - Deleted [' + CAST(@counts AS VARCHAR(20)) + '] aged survey results.'
ELSE
	SET @ErrorString = 'PruneSurveyResults - Failed with error :: ' + ERROR_MESSAGE()
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
-- Retain results for recent 30 days.
-- Retain the last result per week for recent 90 days.
-- Retain the last result per month.
-- DataRetentionIntervalHrs = 0 for retaining all not aged results
DELETE FROM #QueryRetention WHERE DataRetentionDays = 1 or DataRetentionFlags = 0
CREATE TABLE #TblPeriod (BeginDT DATETIME, EndDT DATETIME)
DECLARE	@periodCounter	INT = 10
DECLARE @tempEndDT		DATETIME = DATEADD(WK, DATEDIFF(WK, 30, GETUTCDATE()), 0)
DECLARE @tempBeginDT	DATETIME = DATEADD(WK, -1, @tempEndDT)
WHILE (@periodCounter > 0)
BEGIN
	INSERT	INTO #TblPeriod
	SELECT	@tempBeginDT, @tempEndDT
	SET @tempEndDT	= @tempBeginDT
	SET @tempBeginDT = DATEADD(WK, -1, @tempEndDT)
	SET	@periodCounter = (@periodCounter - 1)
END
SET	@periodCounter	= 10
SET @tempEndDT		= DATEADD(MM, DATEDIFF(MM, 90, GETUTCDATE()), 0)
SET @tempBeginDT	= DATEADD(MM, -1, @tempEndDT)
WHILE (@periodCounter > 0)
BEGIN
	INSERT	INTO #TblPeriod
	SELECT	@tempBeginDT, @tempEndDT
	SET @tempEndDT	= @tempBeginDT
	SET @tempBeginDT = DATEADD(MM, -1, @tempEndDT)
	SET	@periodCounter = (@periodCounter - 1)
END
CREATE TABLE #SurveyResultsToRetain (PeriodEndDT DATETIME, CommServUniqueId INT, SurveyID INT, CommservSurveyResults_ID INT)
INSERT	INTO #SurveyResultsToRetain
SELECT	P.EndDT, A.CommcellIdNameMap_ID, A.QueryId, MAX(A.CommservSurveyResults_ID)
FROM	cf_CommservSurveyResults A
		INNER JOIN #QueryRetention B
			 ON A.QueryId = B.QueryId AND A.ShredStatus = 2 AND A.LogDateUTC > B.RetainUntil
		INNER JOIN #TblPeriod P
			 ON A.LogDateUTC BETWEEN P.BeginDT AND P.EndDT
GROUP BY P.EndDT, A.CommcellIdNameMap_ID, A.QueryId
SET @nRow = 1
SET	@counts = 0
SELECT @tempBeginDT = MIN(BeginDT) FROM #TblPeriod
SELECT @tempEndDT	= MAX(EndDT) FROM #TblPeriod
WHILE @nRow > 0
BEGIN
	TRUNCATE TABLE #SurveyResultsToDelete
	INSERT	INTO #SurveyResultsToDelete
	SELECT	TOP 5000 A.CommservSurveyResults_ID
	FROM	cf_CommservSurveyResults A
			INNER JOIN #QueryRetention B
				ON A.QueryId = B.QueryId AND A.Flags <> 1 AND A.ShredStatus <> 1 AND A.LogDateUTC BETWEEN @tempBeginDT AND @tempEndDT
			LEFT OUTER JOIN #SurveyResultsToRetain C
				ON A.CommservSurveyResults_ID = C.CommservSurveyResults_ID
	WHERE	C.CommservSurveyResults_ID IS NULL
	BEGIN TRANSACTION
	DELETE	cf_CommservSurveyResults WITH (PAGLOCK)
	FROM	#SurveyResultsToDelete T
	WHERE	cf_CommservSurveyResults.CommservSurveyResults_ID = T.CommservSurveyResults_ID
	SELECT @ErrorCode = @@ERROR, @nRow = @@ROWCOUNT
	IF @ErrorCode = 0
		COMMIT TRANSACTION
	ELSE
	BEGIN
		ROLLBACK TRANSACTION
		BREAK
	END
	SET @counts += @nRow
	IF	@counts%10000 = 0
	BEGIN
		SET	@ErrorString = 'PruneSurveyResults - Deleted [' + CAST(@counts AS VARCHAR(20)) + '] survey results which are older than 30 days and not the last of each week or month.'
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
END
IF	@ErrorCode = 0
	SET	@ErrorString = 'PruneSurveyResults - Deleted [' + CAST(@counts AS VARCHAR(20)) + '] survey results which are older than 30 days and not the last of each week or month.'
ELSE
	SET @ErrorString = 'PruneSurveyResults - Failed with error :: ' + ERROR_MESSAGE()
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DROP TABLE #QueryRetention
DROP TABLE #SurveyResultsToDelete
DROP TABLE #SurveyResultsToRetain
DROP TABLE #TblPeriod
-- Delete TransferXMLFile file which are transferred or reach to max RetentionDays
DECLARE @param_RetentionDaysTransferXMLFile INT = 7
SELECT	@param_RetentionDaysTransferXMLFile = ISNULL(cast(Value AS INT), 7) FROM cf_SurveyConfig WHERE Name = 'RetentionDaysTransferXMLFile'
DELETE	cf_MetricTransferXMLFile WITH (PAGLOCK)  WHERE Status =0 OR (datediff(hour, LastRetriedDateUTC,getutcdate()) >= @param_RetentionDaysTransferXMLFile*24 )
-- Delete unreferenced CustomerFeedbackXmlFile
DELETE	cf_CustomerFeedbackXmlFile WITH (PAGLOCK)
FROM	cf_CustomerFeedbackXmlFile A LEFT OUTER JOIN cf_CommservSurveyResults B
	ON A.ID = B.CustomerFeedbackXmlFile_ID
WHERE	B.CustomerFeedbackXmlFile_ID IS NULL
SET @nRow = @@ROWCOUNT
SET @ErrorString = 'PruneSurveyResults - Deleted [' + CAST(@nRow AS VARCHAR(20)) + '] unreferenced CustomerFeedbackXmlFile'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
-- Delete SurveyLogger older than 30 days
DECLARE	@RetainLogUntil DATETIME = DATEADD(DAY, -30, GETUTCDATE())
DELETE	FROM cf_SurveyLogger WITH (PAGLOCK)
WHERE	LogDateUTC < @RetainLogUntil
SET @nRow = @@ROWCOUNT
SET @ErrorString = 'PruneSurveyResults - Deleted [' + CAST(@nRow AS VARCHAR(20)) + '] SurveyLogger older than 30 days'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
-- Prune tables not based on retention
DECLARE	@RetentionMonths INT = 26
SELECT	@RetentionMonths = CAST(Value AS INT)
FROM	cf_SurveyConfig
WHERE	Name = 'RetentionMonthsForJobDetails'
DECLARE	@RetainJobUntil INT = DATEDIFF(SECOND, '1970/01/01', DATEADD(MONTH, -@RetentionMonths, GETUTCDATE()))
DELETE	FROM cf_SurveyJobStats WITH (PAGLOCK)
WHERE	EndDate < @RetainJobUntil
DELETE	FROM cf_SurveyRestoreJobStats WITH (PAGLOCK)
WHERE	EndTime < @RetainJobUntil
DECLARE	@RetentionDays INT = 7
SELECT	@RetentionDays = CAST(Value AS INT)
FROM	cf_SurveyConfig
WHERE	Name = 'RetentionDaysForJobDbSize'
SET @RetainJobUntil = DATEDIFF(SECOND, '1970/01/01', DATEADD(DAY, -@RetentionDays, GETUTCDATE()))
DELETE	FROM cf_SurveyJobDbSize WITH (PAGLOCK)
WHERE	JobEndDate < @RetainJobUntil
SET @RetentionMonths = -1
SELECT	@RetentionMonths = CAST(Value AS INT)
FROM	cf_SurveyConfig
WHERE	Name = 'RetentionMonthsForGrowth'
IF @RetentionMonths > 0
BEGIN
	DECLARE	@FromDate DATETIME = DATEADD(MONTH, -@RetentionMonths, GETUTCDATE())
	DELETE cf_SurveyAgentCapacityPeakUsage WHERE MonthStart > @FromDate
	DELETE cf_SurveyAgentLicensePeakUsage WHERE MonthStart > @FromDate
	DELETE cf_SurveyCapacityLicensePeakUsage WHERE MonthStart > @FromDate
	DELETE cf_SurveyAgentPeakSize WHERE MonthStart > @FromDate
	DELETE cf_SurveyClientGroupPeakSize WHERE MonthStart > @FromDate
	DELETE cf_SurveyDiskLibraryPeakSize WHERE MonthStart > @FromDate
END
-- For cf_SurveyBkpJobStats_Daily used in Quarterly PPT
SET	@RetentionDays = 130
SET @RetainJobUntil = DATEDIFF(SECOND, '1970/01/01', DATEADD(DAY, -@RetentionDays, GETUTCDATE()))
DELETE	FROM cf_SurveyBkpJobStats_Daily WITH (PAGLOCK)
WHERE	servEndDate < @RetainJobUntil
SET @ErrorString = 'PruneSurveyResults - Complete'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
SELECT @ErrorCode AS 'ErrorCode', @ErrorString AS 'ErrorString'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'PruneSurveyResults')
	delete from GxQscripts where name = 'PruneSurveyResults'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PruneSurveyResults')
	delete from GXDBVersions where aliasname = 'PruneSurveyResults'
GO

insert into GXDBVersions values(2, 'PruneSurveyResults',  '00010015000000000000', 'PruneSurveyResults', '00010015000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/UpdateCommCellGroupAssociation.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/UpdateCommCellGroupAssociation.sp,v $ $Id: UpdateCommCellGroupAssociation.sp,v 1.7 2015/07/14 13:50:09 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: UpdateCommCellGroupAssociation <<<'

IF EXISTS (select * from sysobjects where name='UpdateCommCellGroupAssociation')
	drop procedure UpdateCommCellGroupAssociation
IF EXISTS (select * from GxQscripts where name='UpdateCommCellGroupAssociation')
	delete from GxQscripts where name = 'UpdateCommCellGroupAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateCommCellGroupAssociation')
	delete from GXDBVersions where aliasname = 'UpdateCommCellGroupAssociation'
GO
print '... Creating Procedure: UpdateCommCellGroupAssociation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure UpdateCommCellGroupAssociation
  @i_Association XML
AS
BEGIN
SET NOCOUNT ON
	DECLARE @ErrorCode INTEGER
	DECLARE @ErrorString NVARCHAR(MAX)
	DECLARE @UpdateCommCellGroupTran INT
	SET @UpdateCommCellGroupTran = 0
	SET @ErrorCode = 0
	SET @ErrorString = 'UpdateCommCellGroupAssociation - Start'
	BEGIN TRY
		SET @ErrorString = 'UpdateCommCellGroupAssociation - Start'
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION UpdateCommCellGroupTran
			SET @UpdateCommCellGroupTran = 1
		END
		--<DeletedGroup GroupName="NoCvltEmp" />
		DECLARE @deletedCommCellGroups TABLE(GroupId INT, GroupName VARCHAR(512))
		INSERT INTO @deletedCommCellGroups
		SELECT -1, R.ref.value('@GroupName', 'VARCHAR(512)') FROM @i_Association.nodes('/DeletedGroup') R(ref)
		--<UpdatedGroup />
		DECLARE @updatedCommCellGroups TABLE(GroupId INT, GroupName VARCHAR(512), GroupDescription VARCHAR(MAX), GroupModified INT, modifiedBy	INT,GroupCreated	INT,createdBy INT,  ClientGUID VARCHAR(256),modifiedByUser nvarchar(255), createdByUser	nvarchar(255))
		INSERT INTO @updatedCommCellGroups(GroupId , GroupName, GroupDescription , GroupModified , modifiedBy	,GroupCreated,createdBy, ClientGUID,modifiedByUser, createdByUser)
		SELECT
			R.ref.value('@GroupId', 'int') AS GroupId,
			ISNULL(R.ref.value('@GroupName', 'VARCHAR(512)'), 0) AS GroupName,
			ISNULL(R.ref.value('@GroupDescription', 'VARCHAR(MAX)'), 0) AS GroupDescription,
			ISNULL(R.ref.value('@GroupModified', 'int'), 0) AS GroupModified,
			ISNULL(R.ref.value('@modifiedBy', 'int'), 0) AS modifiedBy,
			ISNULL(R.ref.value('@GroupCreated', 'int'), 0) AS GroupCreated,
			ISNULL(R.ref.value('@createdBy', 'int'), 0) AS createdBy,
			ISNULL(R.ref.value('@ClientGUID', 'VARCHAR(256)'), 0) AS ClientGUID,
			ISNULL(R.ref.value('@modifiedByUser', 'NVARCHAR(MAX)'), 0) AS modifiedByUser,
			ISNULL(R.ref.value('@createdByUser', 'NVARCHAR(MAX)'), 0) AS createdByUser
		FROM @i_Association.nodes('/UpdatedGroup') R(ref)
		IF EXISTS (SELECT * FROM @deletedCommCellGroups)
		BEGIN
			UPDATE @deletedCommCellGroups
			SET GroupId = g.id
			FROM @deletedCommCellGroups INNER JOIN cf_CommcellGroup AS g WITH (NOLOCK)
				ON g.name = GroupName
			--Remove deleted groups and association
			-- 10001 is the CommCell Group for Shrinking CommCells report.
			DELETE FROM cf_CommcellGroup WHERE (id <> 10001) AND id IN (SELECT GroupId FROM @deletedCommCellGroups)
			DELETE FROM cf_CommcellGroupAssoc WHERE (CommCellGroupId <> 10001) AND CommCellGroupId IN (SELECT GroupId FROM @deletedCommCellGroups)
		END
		ELSE IF EXISTS (SELECT * FROM @updatedCommCellGroups)
		BEGIN
			--Remove deleted groups and association
			-- 10001 is the CommCell Group for Shrinking CommCells report.
			DELETE FROM cf_CommcellGroup WHERE (id <> 10001) AND id IN (SELECT GroupId FROM @updatedCommCellGroups)
			DELETE FROM cf_CommcellGroupAssoc WHERE (CommCellGroupId <> 10001) AND CommCellGroupId IN (SELECT GroupId FROM @updatedCommCellGroups)
			INSERT INTO cf_CommcellGroup(id,name,description,modified,modifiedBy,created,createdBy,modifiedByUser, createdByUser)
				SELECT DISTINCT t.GroupId, t.GroupName, t.GroupDescription, t.GroupModified, t.modifiedBy,t.GroupCreated,t.createdBy,t.modifiedByUser,t.createdByUser
					FROM @updatedCommCellGroups t
			INSERT INTO cf_CommcellGroupAssoc
				SELECT t.GroupId, c.ID, t.ClientGUID
					FROM @updatedCommCellGroups t
						INNER JOIN cf_CommcellIdNameMap c
							ON t.ClientGUID = c.CommServGUID
		END
		ELSE
		BEGIN
		--Full sync up
			DECLARE @tmpGrpAssocTbl TABLE(GroupId INT, GroupName VARCHAR(512), GroupDescription VARCHAR(MAX), GroupModified INT, modifiedBy	INT,GroupCreated	INT,createdBy INT, ClientGUID VARCHAR(256),modifiedByUser nvarchar(255), createdByUser	nvarchar(255))
			DECLARE @tmpModifiedGroups TABLE(id INT)
			INSERT INTO @tmpGrpAssocTbl(GroupId , GroupName, GroupDescription , GroupModified , modifiedBy	,GroupCreated,createdBy, ClientGUID,modifiedByUser, createdByUser)
			SELECT
				R.ref.value('@GroupId', 'int') AS GroupId,
				ISNULL(R.ref.value('@GroupName', 'VARCHAR(512)'), 0) AS GroupName,
				ISNULL(R.ref.value('@GroupDescription', 'VARCHAR(MAX)'), 0) AS GroupDescription,
				ISNULL(R.ref.value('@GroupModified', 'int'), 0) AS GroupModified,
				ISNULL(R.ref.value('@modifiedBy', 'int'), 0) AS modifiedBy,
				ISNULL(R.ref.value('@GroupCreated', 'int'), 0) AS GroupCreated,
				ISNULL(R.ref.value('@createdBy', 'int'), 0) AS createdBy,
				ISNULL(R.ref.value('@ClientGUID', 'VARCHAR(256)'), 0) AS ClientGUID,
				ISNULL(R.ref.value('@modifiedByUser', 'NVARCHAR(MAX)'), 0) AS modifiedByUser,
				ISNULL(R.ref.value('@createdByUser', 'NVARCHAR(MAX)'), 0) AS createdByUser
			FROM @i_Association.nodes('/GroupAssociation') R(ref)
			--Remove deleted groups and association
			-- 10001 is the CommCell Group for Shrinking CommCells report.
			DELETE FROM cf_CommcellGroup WHERE (id <> 10001) AND id NOT IN (SELECT DISTINCT GroupId FROM @tmpGrpAssocTbl)
			DELETE FROM cf_CommcellGroupAssoc WHERE (CommCellGroupId <> 10001) AND CommCellGroupId NOT IN (SELECT DISTINCT GroupId FROM @tmpGrpAssocTbl)
			--Remove modified groups and association
			INSERT INTO @tmpModifiedGroups
				SELECT DISTINCT g.id FROM cf_CommcellGroup g WITH (NOLOCK)
					INNER JOIN @tmpGrpAssocTbl t
						ON g.id = t.GroupId
							AND g.modified < t.GroupModified
			DELETE FROM cf_CommcellGroup WHERE (id <> 10001) AND id IN (SELECT id FROM @tmpModifiedGroups)
			DELETE FROM cf_CommcellGroupAssoc WHERE (CommCellGroupId <> 10001) AND CommCellGroupId IN (SELECT id FROM @tmpModifiedGroups)
			--Add missing groups
			DELETE FROM @tmpModifiedGroups
			INSERT INTO @tmpModifiedGroups
				SELECT DISTINCT t.GroupId FROM @tmpGrpAssocTbl t WHERE t.GroupId NOT IN (SELECT g.id FROM cf_CommcellGroup g WITH (NOLOCK))
			INSERT INTO cf_CommcellGroup(id,name,description,modified,modifiedBy,created,createdBy,modifiedByUser, createdByUser)
				SELECT DISTINCT t.GroupId, t.GroupName, t.GroupDescription, t.GroupModified, t.modifiedBy,t.GroupCreated,t.createdBy,t.modifiedByUser,t.createdByUser
					FROM @tmpGrpAssocTbl t
						INNER JOIN @tmpModifiedGroups m
							ON t.GroupId = m.id
			INSERT INTO cf_CommcellGroupAssoc
				SELECT t.GroupId, c.ID, t.ClientGUID
					FROM @tmpGrpAssocTbl t
						INNER JOIN cf_CommcellIdNameMap c
							ON t.ClientGUID = c.CommServGUID
						INNER JOIN @tmpModifiedGroups m
							ON t.GroupId = m.id
		END
		IF (@UpdateCommCellGroupTran = 1)
		BEGIN
			COMMIT TRANSACTION UpdateCommCellGroupTran
			SET @UpdateCommCellGroupTran = 0
		END
		SET @ErrorCode = 0
		SET @ErrorString = 'UpdateCommCellGroupAssociation  - completed successfully'
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END TRY
	BEGIN CATCH
	
	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	IF (XACT_STATE() <> 0 AND @UpdateCommCellGroupTran = 1)
		ROLLBACK TRANSACTION UpdateCommCellGroupTran
		SET @UpdateCommCellGroupTran = 0
		SET @ErrorCode = 1
		SET @ErrorString = 'UpdateCommCellGroupAssociation  - failed with error :: ' + ERROR_MESSAGE()
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END CATCH
	SELECT @ErrorCode, @ErrorString
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'UpdateCommCellGroupAssociation')
	delete from GxQscripts where name = 'UpdateCommCellGroupAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateCommCellGroupAssociation')
	delete from GXDBVersions where aliasname = 'UpdateCommCellGroupAssociation'
GO

insert into GXDBVersions values(2, 'UpdateCommCellGroupAssociation',  '00010007000000000000', 'UpdateCommCellGroupAssociation', '00010007000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseAgentCapacityLicenseSurvey.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseAgentCapacityLicenseSurvey.sp,v $ $Id: ParseAgentCapacityLicenseSurvey.sp,v 1.7 2015/06/10 18:21:27 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseAgentCapacityLicenseSurvey <<<'

IF EXISTS (select * from sysobjects where name='ParseAgentCapacityLicenseSurvey')
	drop procedure ParseAgentCapacityLicenseSurvey
IF EXISTS (select * from GxQscripts where name='ParseAgentCapacityLicenseSurvey')
	delete from GxQscripts where name = 'ParseAgentCapacityLicenseSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseAgentCapacityLicenseSurvey')
	delete from GXDBVersions where aliasname = 'ParseAgentCapacityLicenseSurvey'
GO
print '... Creating Procedure: ParseAgentCapacityLicenseSurvey'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseAgentCapacityLicenseSurvey
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 3
SELECT @ErrorString = 'Agent CLA - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	CREATE TABLE #Results (SurveyResultId INT, CommServUniqueId INT, MonthStart DATETIME)
	INSERT INTO  #Results (SurveyResultId, CommServUniqueId, MonthStart)
	SELECT	R.CommservSurveyResults_ID, R.CommcellIdNameMap_ID, DATEADD(SECOND, -1, DATEADD(DAY, DATEDIFF(DAY, 0, R.LogDate), 0))
	FROM	cf_CommservSurveyResults AS R
			INNER JOIN cf_CustomerFeedbackXmlFile AS F
		ON F.ID = R.CustomerFeedbackXmlFile_ID
		AND F.ShredStatus = 1 AND F.ParseTime = @parseTime
		AND R.ShredStatus = 1 AND R.QueryId = @surveyId
	UPDATE #Results SET MonthStart = DATEADD(MONTH, DATEDIFF(MONTH, 0, MonthStart), 0)
	INSERT INTO cf_SurveyAgentLicenseUsage (
		SurveyResultId, TypeId, TypeName,
		PermLicensesIssued, PermLicensesAvailable, PermLicensesUsed,
		EvalLicensesIssued, EvalLicensesAvailable, EvalLicensesUsed
		)
	SELECT
		R.CommservSurveyResults_ID,
		csInfo.n.value('@Type', 'INTEGER'),
		csInfo.n.value('@Name', 'VARCHAR(1024)'),
		csInfo.n.value('@PermLicensesIssued', 'INTEGER'),
		csInfo.n.value('@PermLicensesAvailable', 'INTEGER'),
		CASE
			WHEN csInfo.n.value('@PermLicensesUsed', 'INTEGER') IS NOT NULL THEN csInfo.n.value('@PermLicensesUsed', 'INTEGER')
			WHEN csInfo.n.value('@PermLicensesUsed', 'INTEGER') IS NULL AND csInfo.n.value('@PermLicensesIssued', 'INTEGER') = -1 THEN 0
			ELSE csInfo.n.value('@PermLicensesIssued', 'INTEGER') - csInfo.n.value('@PermLicensesAvailable', 'INTEGER')
		END,
		csInfo.n.value('@EvalLicensesIssued', 'INTEGER'),
		csInfo.n.value('@EvalLicensesAvailable', 'INTEGER'),
		CASE
			WHEN csInfo.n.value('@EvalLicensesUsed', 'INTEGER') IS NOT NULL THEN csInfo.n.value('@EvalLicensesUsed', 'INTEGER')
			WHEN csInfo.n.value('@EvalLicensesUsed', 'INTEGER') IS NULL AND csInfo.n.value('@EvalLicensesIssued', 'INTEGER') = -1 THEN 0
			ELSE csInfo.n.value('@EvalLicensesIssued', 'INTEGER') - csInfo.n.value('@EvalLicensesAvailable', 'INTEGER')
		END
	FROM
		cf_CommservSurveyResults AS R
		INNER JOIN #Results T ON R.CommservSurveyResults_ID = T.SurveyResultId
		CROSS apply R.CollectedResults.nodes('/AgentCapacityLicenseUsage') AS csInfo(n)
	WHERE csInfo.n.value('@IsLicType', 'INTEGER') = 1
	INSERT INTO cf_SurveyAgentCapacityUsage (
		SurveyResultId, TypeId, TypeName,
		BackupSize, ArchiveSize, SnapshotSize, ReplicationSize, UsedAgents, LicType
		)
	SELECT
		S.SurveyResultId, S.TypeId, S.TypeName,
		MAX(BackupSize), MAX(ArchiveSize), MAX(SnapshotSize), MAX(ReplicationSize), MAX(UsedAgents), S.LicType
	FROM
		(SELECT
			R.CommservSurveyResults_ID AS SurveyResultId,
			csInfo.n.value('@Type', 'INTEGER') AS TypeId,
			csInfo.n.value('@Name', 'VARCHAR(1024)') AS TypeName,
			ISNULL(csInfo.n.value('@UsedBackupSize', 'BIGINT'), 0) AS BackupSize,
			ISNULL(csInfo.n.value('@UsedArchiveSize', 'BIGINT'), 0) AS ArchiveSize,
			ISNULL(csInfo.n.value('@UsedSnapSize', 'BIGINT'), 0) AS SnapshotSize,
			ISNULL(csInfo.n.value('@UsedReplicationSize', 'BIGINT'), 0) AS ReplicationSize,
			ISNULL(csInfo.n.value('@UsedAgents', 'INTEGER'), 0) AS UsedAgents,
			ISNULL(csInfo.n.value('@LicType', 'INTEGER'), 0) AS LicType
		FROM
			cf_CommservSurveyResults AS R
			INNER JOIN #Results T ON R.CommservSurveyResults_ID = T.SurveyResultId
			CROSS apply R.CollectedResults.nodes('/AgentCapacityLicenseUsage') AS csInfo(n)
		WHERE csInfo.n.value('@IsLicType', 'INTEGER') = 0
		) S
	GROUP BY S.SurveyResultId, S.TypeId, S.TypeName, S.LicType
	UPDATE cf_SurveyAgentLicensePeakUsage
	SET	PermLicensesUsed = CASE WHEN U.PermLicensesUsed > P.PermLicensesUsed THEN U.PermLicensesUsed ELSE P.PermLicensesUsed END,
		EvalLicensesUsed = CASE WHEN U.EvalLicensesUsed > P.EvalLicensesUsed THEN U.EvalLicensesUsed ELSE P.EvalLicensesUsed END
	FROM
		cf_SurveyAgentLicenseUsage U
		INNER JOIN #Results T ON U.SurveyResultId = T.SurveyResultId
		INNER JOIN cf_SurveyAgentLicensePeakUsage P ON P.CommServUniqueId = T.CommServUniqueId AND P.MonthStart = T.MonthStart AND P.TypeId = U.TypeId AND P.TypeName = U.TypeName
	INSERT INTO cf_SurveyAgentLicensePeakUsage (
		CommServUniqueId, MonthStart, TypeId, TypeName,
		PermLicensesUsed, EvalLicensesUsed
		)
	SELECT
		T.CommServUniqueId, T.MonthStart, U.TypeId, U.TypeName,
		MAX(U.PermLicensesUsed), MAX(U.EvalLicensesUsed)
	FROM
		cf_SurveyAgentLicenseUsage U
		INNER JOIN #Results T ON U.SurveyResultId = T.SurveyResultId
		LEFT OUTER JOIN cf_SurveyAgentLicensePeakUsage P ON P.CommServUniqueId = T.CommServUniqueId AND P.MonthStart = T.MonthStart
	WHERE
		P.CommServUniqueId IS NULL
	GROUP BY T.CommServUniqueId, T.MonthStart, U.TypeId, U.TypeName
	UPDATE cf_SurveyAgentCapacityPeakUsage
	SET	BackupSize = CASE WHEN T.BackupSize > P.BackupSize THEN T.BackupSize ELSE P.BackupSize END,
		ArchiveSize = CASE WHEN T.ArchiveSize > P.ArchiveSize THEN T.ArchiveSize ELSE P.ArchiveSize END,
		SnapshotSize = CASE WHEN T.SnapshotSize > P.SnapshotSize THEN T.SnapshotSize ELSE P.SnapshotSize END,
		ReplicationSize = CASE WHEN T.ReplicationSize > P.ReplicationSize THEN T.ReplicationSize ELSE P.ReplicationSize END,
		UsedAgents = CASE WHEN T.UsedAgents > P.UsedAgents THEN T.UsedAgents ELSE P.UsedAgents END
	FROM
		(SELECT CommServUniqueId, MonthStart, TypeId, TypeName,
				SUM(BackupSize) AS BackupSize, SUM(ArchiveSize) AS ArchiveSize,
				SUM(SnapshotSize) AS SnapshotSize, SUM(ReplicationSize) AS ReplicationSize, MAX(UsedAgents) AS UsedAgents
		FROM	cf_SurveyAgentCapacityUsage U INNER JOIN #Results R ON U.SurveyResultId = R.SurveyResultId
		GROUP BY CommServUniqueId, MonthStart, TypeId, TypeName
		) T
		INNER JOIN cf_SurveyAgentCapacityPeakUsage P ON P.CommServUniqueId = T.CommServUniqueId AND P.MonthStart = T.MonthStart AND P.TypeId = T.TypeId AND P.TypeName = T.TypeName
	INSERT INTO cf_SurveyAgentCapacityPeakUsage (
		CommServUniqueId, MonthStart, TypeId, TypeName,
		BackupSize, ArchiveSize, SnapshotSize, ReplicationSize, UsedAgents
		)
	SELECT
		T.CommServUniqueId, T.MonthStart, U.TypeId, U.TypeName,
		MAX(U.BackupSize), MAX(U.ArchiveSize), MAX(U.SnapshotSize), MAX(U.ReplicationSize), MAX(U.UsedAgents)
	FROM
		cf_SurveyAgentCapacityUsage U
		INNER JOIN #Results T ON U.SurveyResultId = T.SurveyResultId
		LEFT OUTER JOIN cf_SurveyAgentCapacityPeakUsage P ON P.CommServUniqueId = T.CommServUniqueId AND P.MonthStart = T.MonthStart
	WHERE
		P.CommServUniqueId IS NULL
	GROUP BY T.CommServUniqueId, T.MonthStart, U.TypeId, U.TypeName
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Agent CLA - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Agent CLA - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseAgentCapacityLicenseSurvey')
	delete from GxQscripts where name = 'ParseAgentCapacityLicenseSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseAgentCapacityLicenseSurvey')
	delete from GXDBVersions where aliasname = 'ParseAgentCapacityLicenseSurvey'
GO

insert into GXDBVersions values(2, 'ParseAgentCapacityLicenseSurvey',  '00010007000000000000', 'ParseAgentCapacityLicenseSurvey', '00010007000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseArchiveGroupandCopyInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseArchiveGroupandCopyInfo.sp,v $ $Id: ParseArchiveGroupandCopyInfo.sp,v 1.5 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseArchiveGroupandCopyInfo <<<'

IF EXISTS (select * from sysobjects where name='ParseArchiveGroupandCopyInfo')
	drop procedure ParseArchiveGroupandCopyInfo
IF EXISTS (select * from GxQscripts where name='ParseArchiveGroupandCopyInfo')
	delete from GxQscripts where name = 'ParseArchiveGroupandCopyInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseArchiveGroupandCopyInfo')
	delete from GXDBVersions where aliasname = 'ParseArchiveGroupandCopyInfo'
GO
print '... Creating Procedure: ParseArchiveGroupandCopyInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseArchiveGroupandCopyInfo
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 63
SELECT @ErrorString = 'Parse Archive and Copy Info - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyArchiveGroupInfo
	SELECT DISTINCT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@ID', 'int'),
		csInfo.n.value('@StoragePolicyName', 'nvarchar(256)'),
		csInfo.n.value('@NumberOfCopies', 'int'),
		csInfo.n.value('@NumberOfSnapCopies', 'int'),
		csInfo.n.value('@NumberofStreams', 'int'),
		csInfo.n.value('@StoragePolicytype', 'int'),
		csInfo.n.value('@StoragePolicyFlags', 'int'),
		csInfo.n.value('@IncrementalPolicyId', 'int'),
		csInfo.n.value('@SIBlockSizeKB', 'int'),
		csInfo.n.value('@AuxCopyAlertGB', 'int'),
		csInfo.n.value('@AuxCopyAlertDays', 'int'),
		csInfo.n.value('@TimeZoneType', 'int')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/StoragePoliciesDetails/ArchiveGroupInfo') AS csInfo(n)
	INSERT INTO cf_SurveyArchiveGroupCopyInfo
	SELECT DISTINCT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@ID', 'int'),
		csInfo.n.value('@CopyName', 'nvarchar(256)'),
		csInfo.n.value('@ArchGroupID', 'int'),
		csInfo.n.value('@IsSnapcopy', 'int'),
		csInfo.n.value('@Type', 'int'),
		csInfo.n.value('@MaxMultiplex', 'int'),
		csInfo.n.value('@Flags', 'int'),
		csInfo.n.value('@DedupeFlags', 'int'),
		csInfo.n.value('@ExtendedFlags', 'int'),
		csInfo.n.value('@WaitForIfOffline', 'int'),
		csInfo.n.value('@WaitForIfBusy', 'int'),
		csInfo.n.value('@SilosInCache', 'int'),
		csInfo.n.value('@DrivePoolType', 'int'),
		csInfo.n.value('@NewStorePeriodType', 'int'),
		csInfo.n.value('@NewStoreNumPeriod', 'int'),
		csInfo.n.value('@NewStoreSizeTB', 'int'),
		csInfo.n.value('@MaxCorruptPartitions', 'int'),
		csInfo.n.value('@SIDBStoreFlags', 'int'),
		csInfo.n.value('@DDBPartitions', 'int'),
		csInfo.n.value('@MRFlags', 'int'),
		csInfo.n.value('@MRDaysAfterWritten', 'int'),
		csInfo.n.value('@MRDaysBeforeAged', 'int'),
		csInfo.n.value('@MRPercentage', 'int'),
		csInfo.n.value('@RetentionDays', 'int'),
		csInfo.n.value('@RetentionCycles', 'int'),
		csInfo.n.value('@ArchiverRetentionDays', 'int'),
		csInfo.n.value('@RetentionJobs', 'int'),
		csInfo.n.value('@AgingFlags', 'int')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/StoragePoliciesDetails/ArchiveGroupInfo/ArchiveGroupCopy') AS csInfo(n)
	INSERT INTO cf_SurveyExtendedRetention
	SELECT DISTINCT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@CopyID', 'int'),
		csInfo.n.value('@RetentionRule', 'int'),
		csInfo.n.value('@RetentionDays', 'int'),
		csInfo.n.value('@GraceDays', 'int')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/StoragePoliciesDetails/ArchiveGroupInfo/ExtendedRetention') AS csInfo(n)
	WHERE csInfo.n.value('@RetentionRule', 'int') > 0
	INSERT INTO cf_SurveyBackupCopyInfo
	SELECT DISTINCT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@ArchGroupID', 'int'),
		csInfo.n.value('@Enabled', 'int'),
		csInfo.n.value('@Type', 'int'),
		csInfo.n.value('@Flags', 'int'),
		csInfo.n.value('@SourceCopyId', 'int'),
		csInfo.n.value('@DeferredDays', 'int'),
		csInfo.n.value('@NumberPeriod', 'int'),
		csInfo.n.value('@DayNumber', 'int')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/StoragePoliciesDetails/ArchiveGroupInfo/BackupCopyInfo') AS csInfo(n)
	WHERE csInfo.n.value('@Enabled', 'int') = 1
	INSERT INTO cf_SurveyContentIndexing
	SELECT DISTINCT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@ArchGroupID', 'int'),
		csInfo.n.value('@Enabled', 'int'),
		csInfo.n.value('@Type', 'int'),
		csInfo.n.value('@Flags', 'int'),
		csInfo.n.value('@SubclientAssoc', 'int'),
		csInfo.n.value('@SourceCopyId', 'int'),
		csInfo.n.value('@DeferredDays', 'int'),
		csInfo.n.value('@RetentionDays', 'int'),
		csInfo.n.value('@NumberPeriod', 'int'),
		csInfo.n.value('@DayNumber', 'int'),
		csInfo.n.value('@MinDocSizeKB', 'int'),
		csInfo.n.value('@MaxDocSizeKB', 'int'),
		csInfo.n.value('@IncludeDocTypes', 'nvarchar(max)'),
		csInfo.n.value('@ExcludeDocTypes', 'nvarchar(max)'),
		csInfo.n.value('@EntityIds', 'nvarchar(max)'),
		csInfo.n.value('@FilterSelected', 'int')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/StoragePoliciesDetails/ArchiveGroupInfo/ContentIndexing') AS csInfo(n)
	WHERE csInfo.n.value('@Enabled', 'int') = 1
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Parse Archive and Copy Info - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Parse Archive and Copy Info - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseArchiveGroupandCopyInfo')
	delete from GxQscripts where name = 'ParseArchiveGroupandCopyInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseArchiveGroupandCopyInfo')
	delete from GXDBVersions where aliasname = 'ParseArchiveGroupandCopyInfo'
GO

insert into GXDBVersions values(2, 'ParseArchiveGroupandCopyInfo',  '00010005000000000000', 'ParseArchiveGroupandCopyInfo', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseAvgBkpThroughput.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseAvgBkpThroughput.sp,v $ $Id: ParseAvgBkpThroughput.sp,v 1.3 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseAvgBkpThroughput <<<'

IF EXISTS (select * from sysobjects where name='ParseAvgBkpThroughput')
	drop procedure ParseAvgBkpThroughput
IF EXISTS (select * from GxQscripts where name='ParseAvgBkpThroughput')
	delete from GxQscripts where name = 'ParseAvgBkpThroughput'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseAvgBkpThroughput')
	delete from GXDBVersions where aliasname = 'ParseAvgBkpThroughput'
GO
print '... Creating Procedure: ParseAvgBkpThroughput'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseAvgBkpThroughput
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 55
SELECT @ErrorString = 'Average Backup Throughput  - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyAvgBkpThroughputV1
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@AppSizeGB', 'FLOAT'),
		csInfo.n.value('@WriteTimeHr', 'FLOAT'),
		csInfo.n.value('@IsDisk', 'INT'),
		csInfo.n.value('@EndDate', 'DATETIME')
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/AvgBkpThroughputInfo') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Average Backup Throughput - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Average Backup Throughput - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseAvgBkpThroughput')
	delete from GxQscripts where name = 'ParseAvgBkpThroughput'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseAvgBkpThroughput')
	delete from GXDBVersions where aliasname = 'ParseAvgBkpThroughput'
GO

insert into GXDBVersions values(2, 'ParseAvgBkpThroughput',  '00010003000000000000', 'ParseAvgBkpThroughput', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseBackupSchedules.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseBackupSchedules.sp,v $ $Id: ParseBackupSchedules.sp,v 1.8 2015/02/20 17:49:21 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseBackupSchedules <<<'

IF EXISTS (select * from sysobjects where name='ParseBackupSchedules')
	drop procedure ParseBackupSchedules
IF EXISTS (select * from GxQscripts where name='ParseBackupSchedules')
	delete from GxQscripts where name = 'ParseBackupSchedules'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseBackupSchedules')
	delete from GXDBVersions where aliasname = 'ParseBackupSchedules'
GO
print '... Creating Procedure: ParseBackupSchedules'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseBackupSchedules
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
-------------------------------------------------------------------------------
-- Looping for each result:
--   Commit transaction for each result
--   Set ShredStatus = 3 immediately on error so it will be skipped in future
-- Always return ErrorCode = 0 so parsed results will be set to ShredStatus = 2
-------------------------------------------------------------------------------
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 155
SELECT @ErrorCode = 0, @ErrorString = 'Parsing results for Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
DECLARE @CSUniqueId INT = 0
DECLARE @ResultId INT = 0
DECLARE	SurveyResultCur CURSOR FOR
SELECT	F.CommcellIdNameMap_ID, R.CommservSurveyResults_ID
FROM	cf_CommservSurveyResults AS R INNER JOIN cf_CustomerFeedbackXmlFile AS F
	 ON F.ID = R.CustomerFeedbackXmlFile_ID
	AND F.ParseTime = @parseTime
	AND F.ShredStatus = 1
	AND R.ShredStatus = 1
	AND R.QueryId = @surveyId
ORDER BY R.LogDateUTC
OPEN SurveyResultCur
FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @ErrorCode = 0
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		ELSE
			SET @ProcessSurveyResultTran = 0
		DELETE cf_SurveyBackupSchedule WHERE CommservUniqueId = @CSUniqueId
		INSERT INTO cf_SurveyBackupSchedule (
			CommservUniqueId, SchedulePolicy, ScheduleName, Disabled, SchedBackupType,
			SchedPattern, SchedInterval, SchedBackupDay, SchedBackupTime, SchedNextBackupTime,
			ClientGroupId, ClientId, AppTypeId, InstanceId, BackupsetId, AppId, AssocType, MaxRunningSec, Exclude)
		SELECT
			@CSUniqueId,
			csInfo.n.value('@schedulePolicy','NVARCHAR(256)'),
			csInfo.n.value('@scheduleName','NVARCHAR(256)'),
			csInfo.n.value('@disabled','INT'),
			csInfo.n.value('@schedBackupType','VARCHAR(32)'),
			csInfo.n.value('@schedPattern','VARCHAR(32)'),
			csInfo.n.value('@schedInterval','VARCHAR(32)'),
			csInfo.n.value('@schedBackupDay','VARCHAR(MAX)'),
			csInfo.n.value('@schedBackupTime','VARCHAR(12)'),
			csInfo.n.value('@schedNextBackupTime','DATETIME'),
			csInfo.n.value('@clientGroupId','INT'),
			csInfo.n.value('@clientId','INT'),
			csInfo.n.value('@appTypeId','INT'),
			csInfo.n.value('@instanceId','INT'),
			csInfo.n.value('@backupsetId','INT'),
			csInfo.n.value('@appId','INT'),
			ISNULL(csInfo.n.value('@assocType','INT'), 0),
			ISNULL(csInfo.n.value('@maxRunningSec','INT'), -1),
			ISNULL(csInfo.n.value('@exclude','INT'), 0)
		FROM
			cf_CommservSurveyResults
			CROSS APPLY CollectedResults.nodes('Schedule') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		DELETE cf_SurveyBackupMaxRunningTime WHERE CommservUniqueId = @CSUniqueId
		INSERT INTO cf_SurveyBackupMaxRunningTime (
			CommservUniqueId, AppTypeId, MaxRunningSec)
		SELECT
			@CSUniqueId,
			csInfo.n.value('@appTypeId','INT'),
			csInfo.n.value('@maxRunningSec','INT')
		FROM
			cf_CommservSurveyResults
			CROSS APPLY CollectedResults.nodes('MaxRunningTime') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		DELETE cf_SurveyHoliday WHERE CommservUniqueId = @CSUniqueId
		INSERT INTO cf_SurveyHoliday (
			CommservUniqueId, StartYear, StartMonth, StartDay, StartHour, StartMinute, StartSecond,
			EndYear, EndMonth, EndDay, EndHour, EndMinute, EndSecond, Description, ClientGroupId, ClientId)
		SELECT
			@CSUniqueId,
			csInfo.n.value('@startYear','INT'),
			csInfo.n.value('@startMonth','INT'),
			csInfo.n.value('@startDay','INT'),
			csInfo.n.value('@startHour','INT'),
			csInfo.n.value('@startMinute','INT'),
			csInfo.n.value('@startSecond','INT'),
			csInfo.n.value('@endYear','INT'),
			csInfo.n.value('@endMonth','INT'),
			csInfo.n.value('@endDay','INT'),
			csInfo.n.value('@endHour','INT'),
			csInfo.n.value('@endMinute','INT'),
			csInfo.n.value('@endSecond','INT'),
			csInfo.n.value('@description','NVARCHAR(80)'),
			csInfo.n.value('@clientGroupId','INT'),
			csInfo.n.value('@clientId','INT')
		FROM
			cf_CommservSurveyResults
			CROSS APPLY CollectedResults.nodes('Holiday') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		IF (@ProcessSurveyResultTran = 1)
			COMMIT TRANSACTION ProcessSurveyResultTran
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		SELECT	@ErrorCode = 1,
				@ErrorString = 'Query ID ' + CAST(@surveyId AS VARCHAR(20))
					+ ' - Parsing failed for Result ID ' + CAST(@ResultId AS VARCHAR(20)) + ' with error :: ' + ERROR_MESSAGE()
		IF (@ProcessSurveyResultTran = 1)
			ROLLBACK TRANSACTION ProcessSurveyResultTran
	END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId
		IF @isPrintOn = 1 PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
	FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId
END
CLOSE SurveyResultCur
DEALLOCATE SurveyResultCur
SET @ErrorCode = 0
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseBackupSchedules')
	delete from GxQscripts where name = 'ParseBackupSchedules'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseBackupSchedules')
	delete from GXDBVersions where aliasname = 'ParseBackupSchedules'
GO

insert into GXDBVersions values(2, 'ParseBackupSchedules',  '00010008000000000000', 'ParseBackupSchedules', '00010008000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseBillingEntities.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseBillingEntities.sp,v $ $Id: ParseBillingEntities.sp,v 1.3 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseBillingEntities <<<'

IF EXISTS (select * from sysobjects where name='ParseBillingEntities')
	drop procedure ParseBillingEntities
IF EXISTS (select * from GxQscripts where name='ParseBillingEntities')
	delete from GxQscripts where name = 'ParseBillingEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseBillingEntities')
	delete from GXDBVersions where aliasname = 'ParseBillingEntities'
GO
print '... Creating Procedure: ParseBillingEntities'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseBillingEntities
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 150
SELECT @ErrorCode = 0, @ErrorString = 'Parsing results for Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
CREATE TABLE #BillingEntity (GUID VARCHAR(64), Name NVARCHAR(255), Description NVARCHAR(255), ContactInfo NVARCHAR(2048), ModifiedTime DATETIME)
CREATE TABLE #EntityMembers (GUID VARCHAR(64), ClientId INT, AppTypeId INT, InstanceId INT, BackupsetId INT, AppId INT)
DECLARE @ProcessSurveyResultTran INT = 0
DECLARE @CSUniqueId INT = 0
DECLARE @ResultId INT = 0
DECLARE	SurveyResultCur CURSOR FOR
SELECT	F.CommcellIdNameMap_ID, R.CommservSurveyResults_ID
FROM	cf_CommservSurveyResults AS R INNER JOIN cf_CustomerFeedbackXmlFile AS F
	 ON F.ID = R.CustomerFeedbackXmlFile_ID
	AND F.ParseTime = @parseTime
	AND F.ShredStatus = 1
	AND R.ShredStatus = 1
	AND R.QueryId = @surveyId
ORDER BY R.LogDateUTC
OPEN SurveyResultCur
FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @ErrorCode = 0
	TRUNCATE TABLE #BillingEntity
	TRUNCATE TABLE #EntityMembers
	INSERT INTO #BillingEntity (GUID, Name, Description, ContactInfo, ModifiedTime)
	SELECT
		csInfo.n.value('@GUID', 'VARCHAR(64)'),
		csInfo.n.value('@Name', 'NVARCHAR(255)'),
		csInfo.n.value('@Description', 'NVARCHAR(256)'),
		csInfo.n.value('@ContactInfo', 'NVARCHAR(2048)'),
		csInfo.n.value('@ModifiedTime','DATETIME')
	FROM
		cf_CommservSurveyResults
		CROSS APPLY CollectedResults.nodes('/BillingEntities/Entity') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	INSERT INTO #EntityMembers (GUID, ClientId, AppTypeId, InstanceId, BackupsetId, AppId)
	SELECT
		csInfo.n.value('@GUID', 'VARCHAR(64)'),
		csInfo.n.value('@ClientID', 'INT'),
		csInfo.n.value('@AppTypeId', 'INT'),
		csInfo.n.value('@InstanceId', 'INT'),
		csInfo.n.value('@BackupsetId', 'INT'),
		csInfo.n.value('@AppID', 'INT')
	FROM
		cf_CommservSurveyResults
		CROSS APPLY CollectedResults.nodes('/BillingEntities/Member') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		ELSE
			SET @ProcessSurveyResultTran = 0
		DELETE	#BillingEntity
		FROM	cf_SurveyBillingEntity E INNER JOIN #BillingEntity T ON E.GUID = T.GUID
		INSERT	INTO cf_SurveyBillingEntity
		SELECT	GUID, Name, Description, ContactInfo, ModifiedTime
		FROM	#BillingEntity
		DELETE	#EntityMembers
		FROM	#EntityMembers T
				INNER JOIN cf_SurveyBillingEntity E ON E.GUID = T.GUID
				INNER JOIN cf_SurveyBillingEntityMember M ON M.EntityID = E.ID
					AND M.ClientId = T.ClientId AND M.AppTypeId = T.AppTypeId
					AND M.InstanceId = T.InstanceId AND M.BackupsetId = T.BackupsetId AND M.AppId = T.AppId
		INSERT	INTO cf_SurveyBillingEntityMember (EntityID, CommServUniqueId, ClientGroupId, ClientId, AppTypeId, InstanceId, BackupsetId, AppId)
		SELECT	E.ID, @CSUniqueId, 0, M.ClientId, M.AppTypeId, M.InstanceId, M.BackupsetId, M.AppId
		FROM	#EntityMembers M
				INNER JOIN cf_SurveyBillingEntity E ON M.GUID = E.GUID
		IF (@ProcessSurveyResultTran = 1)
			COMMIT TRANSACTION ProcessSurveyResultTran
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		SELECT	@ErrorCode = 1,
				@ErrorString = 'Query ID ' + CAST(@surveyId AS VARCHAR(20))
					+ ' - Parsing failed for Result ID ' + CAST(@ResultId AS VARCHAR(20)) + ' with error :: ' + ERROR_MESSAGE()
		IF (@ProcessSurveyResultTran = 1)
			ROLLBACK TRANSACTION ProcessSurveyResultTran
	END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId
		IF @isPrintOn = 1 PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
	FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId
END
CLOSE SurveyResultCur
DEALLOCATE SurveyResultCur
SET @ErrorCode = 0
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseBillingEntities')
	delete from GxQscripts where name = 'ParseBillingEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseBillingEntities')
	delete from GXDBVersions where aliasname = 'ParseBillingEntities'
GO

insert into GXDBVersions values(2, 'ParseBillingEntities',  '00010003000000000000', 'ParseBillingEntities', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseBkpDataRetention.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseBkpDataRetention.sp,v $ $Id: ParseBkpDataRetention.sp,v 1.3 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseBkpDataRetention <<<'

IF EXISTS (select * from sysobjects where name='ParseBkpDataRetention')
	drop procedure ParseBkpDataRetention
IF EXISTS (select * from GxQscripts where name='ParseBkpDataRetention')
	delete from GxQscripts where name = 'ParseBkpDataRetention'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseBkpDataRetention')
	delete from GXDBVersions where aliasname = 'ParseBkpDataRetention'
GO
print '... Creating Procedure: ParseBkpDataRetention'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseBkpDataRetention
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 141
SELECT @ErrorString = 'Backup Data Retention - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyBkpDataRetention(SurveyResultId, AgeIn30DaysMB, AgeIn30To90DaysMB, AgeIn90To365DaysMB, AgeAfter365DaysMB)
	SELECT
		results.CommservSurveyResults_ID,
		ISNULL(csInfo.n.value('@AgeIn30DaysMB' , 'BIGINT'), 0),
		ISNULL(csInfo.n.value('@AgeIn30To90DaysMB' , 'BIGINT'), 0),
		ISNULL(csInfo.n.value('@AgeIn90To365DaysMB' , 'BIGINT'), 0),
		ISNULL(csInfo.n.value('@AgeAfter365DaysMB' , 'BIGINT'), 0)
	FROM
	cf_CommservSurveyResults AS results
	INNER JOIN cf_CustomerFeedbackXmlFile AS files
	ON files.ShredStatus = 1
	AND files.ID = results.CustomerFeedbackXmlFile_ID
	AND results.ShredStatus = 1
	AND results.QueryId = @surveyId
	AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('StorageDataRetention') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString ='Backup Data Retention - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
	BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString ='Backup Data Retention - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseBkpDataRetention')
	delete from GxQscripts where name = 'ParseBkpDataRetention'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseBkpDataRetention')
	delete from GXDBVersions where aliasname = 'ParseBkpDataRetention'
GO

insert into GXDBVersions values(2, 'ParseBkpDataRetention',  '00010003000000000000', 'ParseBkpDataRetention', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseBkpJobStatus.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseBkpJobStatus.sp,v $ $Id: ParseBkpJobStatus.sp,v 1.3 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseBkpJobStatus <<<'

IF EXISTS (select * from sysobjects where name='ParseBkpJobStatus')
	drop procedure ParseBkpJobStatus
IF EXISTS (select * from GxQscripts where name='ParseBkpJobStatus')
	delete from GxQscripts where name = 'ParseBkpJobStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseBkpJobStatus')
	delete from GXDBVersions where aliasname = 'ParseBkpJobStatus'
GO
print '... Creating Procedure: ParseBkpJobStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseBkpJobStatus
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
-------------------------------------------------------------------------------
-- Looping for each result:
--   Commit transaction for each result
--   Set ShredStatus = 3 immediately on error so it will be skipped in future
-- Always return ErrorCode = 0 so parsed results will be set to ShredStatus = 2
-------------------------------------------------------------------------------
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 16
SELECT @ErrorCode = 0, @ErrorString = 'Parsing results for Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
DECLARE @CSUniqueId INT = 0
DECLARE @ResultId INT = 0
DECLARE @LogDateUTC datetime
DECLARE @LogDate    datetime
DECLARE	SurveyResultCur CURSOR FOR
SELECT	F.CommcellIdNameMap_ID, R.CommservSurveyResults_ID, R.LogDateUTC, R.LogDate
FROM	cf_CommservSurveyResults AS R INNER JOIN cf_CustomerFeedbackXmlFile AS F
	 ON F.ID = R.CustomerFeedbackXmlFile_ID
	AND F.ParseTime = @parseTime
	AND F.ShredStatus = 1
	AND R.ShredStatus = 1
	AND R.QueryId = @surveyId
ORDER BY R.LogDateUTC
OPEN SurveyResultCur
FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId, @LogDateUTC, @LogDate
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @ErrorCode = 0
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		ELSE
			SET @ProcessSurveyResultTran = 0
		INSERT INTO cf_SurveyBkpJobStats(
			CommServUniqueId,
			SurveyResultId,
			LogDateUTC,
			LogDate,
			ClientGroups,
			TotalJobs,
			SuccessfulJobs,
			CompletedWithErrorJobs,
			CompletedWithWarningJobs,
			FailedJobs)
		SELECT
			@CSUniqueId,
			@ResultId,
			@LogDateUTC,
			@LogDate,
			csInfo.n.value('@clientGroups', 'NVARCHAR(MAX)'),
			csInfo.n.value('@No_Of_Backup', 'BIGINT'),
			csInfo.n.value('@Successful_Backup', 'BIGINT'),
			csInfo.n.value('@CompletedWithErrorJobs', 'BIGINT'),
			csInfo.n.value('@CompletedWithWarningJobs', 'BIGINT'),
			csInfo.n.value('@Failed_Backup', 'BIGINT')
		FROM
		cf_CommservSurveyResults AS results
		CROSS apply CollectedResults.nodes('/BackupStats') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		IF (@ProcessSurveyResultTran = 1)
		BEGIN
			COMMIT TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 0
		END
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		SELECT	@ErrorCode = 1,
				@ErrorString = 'Query ID ' + CAST(@surveyId AS VARCHAR(20))
					+ ' - Parsing failed for Result ID ' + CAST(@ResultId AS VARCHAR(20)) + ' with error :: ' + ERROR_MESSAGE()
		IF (@ProcessSurveyResultTran = 1)
			ROLLBACK TRANSACTION ProcessSurveyResultTran
	END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId
		IF @isPrintOn = 1 PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
	FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId, @LogDateUTC,  @LogDate
END
CLOSE SurveyResultCur
DEALLOCATE SurveyResultCur
SET @ErrorCode = 0
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseBkpJobStatus')
	delete from GxQscripts where name = 'ParseBkpJobStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseBkpJobStatus')
	delete from GXDBVersions where aliasname = 'ParseBkpJobStatus'
GO

insert into GXDBVersions values(2, 'ParseBkpJobStatus',  '00010003000000000000', 'ParseBkpJobStatus', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseBkpJobStatus_WMon.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseBkpJobStatus_WMon.sp,v $ $Id: ParseBkpJobStatus_WMon.sp,v 1.9 2015/07/09 08:55:57 vmishra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseBkpJobStatus_WMon <<<'

IF EXISTS (select * from sysobjects where name='ParseBkpJobStatus_WMon')
	drop procedure ParseBkpJobStatus_WMon
IF EXISTS (select * from GxQscripts where name='ParseBkpJobStatus_WMon')
	delete from GxQscripts where name = 'ParseBkpJobStatus_WMon'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseBkpJobStatus_WMon')
	delete from GXDBVersions where aliasname = 'ParseBkpJobStatus_WMon'
GO
print '... Creating Procedure: ParseBkpJobStatus_WMon'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseBkpJobStatus_WMon
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
-------------------------------------------------------------------------------
-- Looping for each result:
--   Commit transaction for each result
--   Set ShredStatus = 3 immediately on error so it will be skipped in future
-- Always return ErrorCode = 0 so parsed results will be set to ShredStatus = 2
-------------------------------------------------------------------------------
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 51
SELECT @ErrorCode = 0, @ErrorString = 'Parsing results for Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
DECLARE @CSUniqueId INT = 0
DECLARE @ResultId INT = 0
DECLARE @LogDateUTC datetime
DECLARE @LogDate    datetime
DECLARE	SurveyResultCur CURSOR FOR
SELECT	F.CommcellIdNameMap_ID, R.CommservSurveyResults_ID, R.LogDateUTC, R.LogDate
FROM	cf_CommservSurveyResults AS R INNER JOIN cf_CustomerFeedbackXmlFile AS F
	 ON F.ID = R.CustomerFeedbackXmlFile_ID
	AND F.ParseTime = @parseTime
	AND F.ShredStatus = 1
	AND R.ShredStatus = 1
	AND R.QueryId = @surveyId
ORDER BY R.LogDateUTC
OPEN SurveyResultCur
FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId, @LogDateUTC, @LogDate
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @ErrorCode = 0
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		ELSE
			SET @ProcessSurveyResultTran = 0
		INSERT INTO cf_SurveyBkpJobStats_WMon (
		CommServUniqueId,SurveyResultId,LogDateUTC,LogDate,ClientGroups,TotalJobs,SuccessfulJobs,CompletedWithErrorJobs,CompletedWithWarningJobs,FailedJobs,servEndDate, outType	,KilledJobs,appTypeId, BackupSize, SizeOnMedia)
		SELECT
			@CSUniqueId,
			@ResultId,
			@LogDateUTC,
			@LogDate,
			csInfo.n.value('../@clientGroups', 'NVARCHAR(MAX)'),
			csInfo.n.value('@No_Of_Backup', 'BIGINT'),
			csInfo.n.value('@Successful_Backup', 'BIGINT'),
			csInfo.n.value('@CompletedWithErrorJobs', 'BIGINT'),
			csInfo.n.value('@CompletedWithWarningJobs', 'BIGINT'),
			csInfo.n.value('@Failed_Backup', 'BIGINT'),
			csInfo.n.value('@servEndDate', 'DATE'),
			csInfo.n.value('@outType', 'INT'),
			ISNULL(csInfo.n.value('@Killed_Backup', 'BIGINT'),0),
			ISNULL(csInfo.n.value('@AppTypeId', 'INT'),0),
			ISNULL(csInfo.n.value('@BackupSize', 'BIGINT'),0),
			ISNULL(csInfo.n.value('@SizeOnMedia', 'BIGINT'),0)
		FROM
		cf_CommservSurveyResults AS results
		CROSS apply results.CollectedResults.nodes('/BackupStatsXML/BackupStats') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		INSERT INTO cf_SurveyHourlyBkpJobs(SurveyResultId,DayVal,HourComp,Completed,Partial,Failed,KilledJobs)
		SELECT
			@ResultId,
			ISNULL(csInfo.n.value('@DayVal' , 'datetime'),NULL),
			ISNULL(csInfo.n.value('@HourComp' , 'int'),0),
			ISNULL(csInfo.n.value('@CompletedJobs' , '[INT]'),0),
			ISNULL(csInfo.n.value('@PartialJobs' , '[INT]'),0),
			ISNULL(csInfo.n.value('@FailedJobs' , 'BIGINT'),0),
			ISNULL(csInfo.n.value('@KilledJobs' , 'BIGINT'),0)
		FROM
			cf_CommservSurveyResults AS results
			CROSS apply results.CollectedResults.nodes('/BackupStatsXML/HourlyStats') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		IF OBJECT_ID('tempdb..#SurveyBkpJobStats_Daily') IS NOT NULL
			DROP TABLE #SurveyBkpJobStats_Daily
		SELECT
			@CSUniqueId AS CommservUniqueId,
			csInfo.n.value('@No_Of_Backup', 'BIGINT') AS TotalJobs,
			csInfo.n.value('@Successful_Backup', 'BIGINT') AS SuccessfulJobs,
			csInfo.n.value('@CompletedWithErrorJobs', 'BIGINT') AS CompletedWithErrorJobs,
			csInfo.n.value('@CompletedWithWarningJobs', 'BIGINT') AS CompletedWithWarningJobs,
			csInfo.n.value('@Failed_Backup', 'BIGINT') AS FailedJobs,
			csInfo.n.value('@servEndDate', 'DATE') AS servEndDate,
			ISNULL(csInfo.n.value('@Killed_Backup', 'BIGINT'),0) AS KilledJobs,
			ISNULL(csInfo.n.value('@AppTypeId', 'INT'),0) AS AppTypeId,
			ISNULL(csInfo.n.value('@BackupSize', 'BIGINT'),0) AS BackupSize,
			ISNULL(csInfo.n.value('@SizeOnMedia', 'BIGINT'),0) AS SizeOnMedia
		INTO #SurveyBkpJobStats_Daily
		FROM
		cf_CommservSurveyResults AS results
		CROSS apply results.CollectedResults.nodes('/BackupStatsXML/BackupStats') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId AND csInfo.n.value('@outType', 'INT') = 3 -- Daily Job Stats
		DELETE D
		FROM cf_SurveyBkpJobStats_Daily D
			INNER JOIN #SurveyBkpJobStats_Daily B
				ON D.servEndDate = B.servEndDate AND D.CommservUniqueId = B.CommservUniqueId AND D.appTypeId = B.appTypeId
		INSERT INTO cf_SurveyBkpJobStats_Daily (
		CommservUniqueId,servEndDate,SuccessfulJobs,CompletedWithErrorJobs,CompletedWithWarningJobs,FailedJobs,KilledJobs, AppTypeId, BackupSize, SizeOnMedia)
		SELECT
			CommservUniqueId,
			servEndDate,
			SuccessfulJobs,
			CompletedWithErrorJobs,
			CompletedWithWarningJobs,
			FailedJobs,
			KilledJobs,
			AppTypeId,
			BackupSize,
			SizeOnMedia
		FROM #SurveyBkpJobStats_Daily
		IF (@ProcessSurveyResultTran = 1)
		BEGIN
			COMMIT TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 0
		END
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		SELECT	@ErrorCode = 1,
				@ErrorString = 'Query ID ' + CAST(@surveyId AS VARCHAR(20))
					+ ' - Parsing failed for Result ID ' + CAST(@ResultId AS VARCHAR(20)) + ' with error :: ' + ERROR_MESSAGE()
		IF (@ProcessSurveyResultTran = 1)
			ROLLBACK TRANSACTION ProcessSurveyResultTran
	END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId
		IF @isPrintOn = 1 PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
	FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId, @LogDateUTC,  @LogDate
END
CLOSE SurveyResultCur
DEALLOCATE SurveyResultCur
SET @ErrorCode = 0
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseBkpJobStatus_WMon')
	delete from GxQscripts where name = 'ParseBkpJobStatus_WMon'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseBkpJobStatus_WMon')
	delete from GXDBVersions where aliasname = 'ParseBkpJobStatus_WMon'
GO

insert into GXDBVersions values(2, 'ParseBkpJobStatus_WMon',  '00010009000000000000', 'ParseBkpJobStatus_WMon', '00010009000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCapacityLicenseSurvey.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCapacityLicenseSurvey.sp,v $ $Id: ParseCapacityLicenseSurvey.sp,v 1.4 2015/03/30 17:31:10 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseCapacityLicenseSurvey <<<'

IF EXISTS (select * from sysobjects where name='ParseCapacityLicenseSurvey')
	drop procedure ParseCapacityLicenseSurvey
IF EXISTS (select * from GxQscripts where name='ParseCapacityLicenseSurvey')
	delete from GxQscripts where name = 'ParseCapacityLicenseSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCapacityLicenseSurvey')
	delete from GXDBVersions where aliasname = 'ParseCapacityLicenseSurvey'
GO
print '... Creating Procedure: ParseCapacityLicenseSurvey'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseCapacityLicenseSurvey
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 1
SELECT @ErrorString = 'Capacity License Usage - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	CREATE TABLE #Results (SurveyResultId INT, CommServUniqueId INT, MonthStart DATETIME)
	INSERT INTO  #Results (SurveyResultId, CommServUniqueId, MonthStart)
	SELECT	R.CommservSurveyResults_ID, R.CommcellIdNameMap_ID, DATEADD(SECOND, -1, DATEADD(DAY, DATEDIFF(DAY, 0, R.LogDate), 0))
	FROM	cf_CommservSurveyResults AS R
			INNER JOIN cf_CustomerFeedbackXmlFile AS F
		ON F.ID = R.CustomerFeedbackXmlFile_ID
		AND F.ShredStatus = 1 AND F.ParseTime = @parseTime
		AND R.ShredStatus = 1 AND R.QueryId = @surveyId
	UPDATE #Results SET MonthStart = DATEADD(MONTH, DATEDIFF(MONTH, 0, MonthStart), 0)
	INSERT INTO cf_SurveyCapacityLicenseUsage (
		SurveyResultId,
		TotalProtectedVMs, ProtectedVMs,
		TotalArchivedMailBoxes, ArchivedMailBoxes,
		TotalCIObjectsInMillion, CIObjects,
		TotalVMSockets, VMSockets,
		TotalEndpointUsers, EndpointUsers,
		TotalSharingUsers, SharingUsers,
		TotaleDiscoveryUsers, eDiscoveryUsers,
		TotalDiskSpaceMB, UsedDiskSpaceMB,
		TotalStoreSpaceMB, DedupDataSizeMB,
		TotalBackupSize, BackupSize,
		TotalArchiveSize, ArchiveSize,
		TotalSnapshotSize, SnapshotSize,
		TotalReplicationSize, ReplicationSize
		)
	SELECT
		T.SurveyResultId,
		csInfo.n.value('SubscriptionUsageTotal[1]/@nProtectedVM','NVARCHAR(MAX)'),
		csInfo.n.value('SubscriptionUsageUsed[1]/@nProtectedVM','INTEGER'),
		csInfo.n.value('SubscriptionUsageTotal[1]/@nArchivedMailBox','NVARCHAR(MAX)'),
		csInfo.n.value('SubscriptionUsageUsed[1]/@nArchivedMailBox','INTEGER'),
		csInfo.n.value('SubscriptionUsageTotal[1]/@CIObjectsInMillion','NVARCHAR(MAX)'),
		csInfo.n.value('SubscriptionUsageUsed[1]/@CIObjects','BIGINT'),
		csInfo.n.value('SubscriptionUsageTotal[1]/@VMSockets','NVARCHAR(MAX)'),
		csInfo.n.value('SubscriptionUsageUsed[1]/@VMSockets','INTEGER'),
		csInfo.n.value('SubscriptionUsageTotal[1]/@EndpointUsers','NVARCHAR(MAX)'),
		csInfo.n.value('SubscriptionUsageUsed[1]/@EndpointUsers','INTEGER'),
		csInfo.n.value('SubscriptionUsageTotal[1]/@SharingUsers','NVARCHAR(MAX)'),
		csInfo.n.value('SubscriptionUsageUsed[1]/@SharingUsers','INTEGER'),
		csInfo.n.value('SubscriptionUsageTotal[1]/@eDiscoveryUsers','NVARCHAR(MAX)'),
		csInfo.n.value('SubscriptionUsageUsed[1]/@eDiscoveryUsers','INTEGER'),
		CASE
			WHEN csInfo.n.value('SubscriptionUsageTotal[1]/@DiskLibSpaceMB','NVARCHAR(MAX)') = 'Client Unlimited' THEN -1
			ELSE csInfo.n.value('SubscriptionUsageTotal[1]/@DiskLibSpaceMB','BIGINT')
		END,
		csInfo.n.value('SubscriptionUsageUsed[1]/@UsedDiskSpaceMB','BIGINT'),
		CASE
			WHEN csInfo.n.value('SubscriptionUsageTotal[1]/@DedupStoreSpaceMB','NVARCHAR(MAX)') = 'Client Unlimited' THEN -1
			ELSE csInfo.n.value('SubscriptionUsageTotal[1]/@DedupStoreSpaceMB','BIGINT')
		END,
		csInfo.n.value('SubscriptionUsageUsed[1]/@DedupDataSizeMB','BIGINT'),
		csInfo.n.value('LicenseUsageTotal[1]/@EnterpriseBackupSize','BIGINT') + csInfo.n.value('LicenseUsageTotal[1]/@CoreBackupSize','BIGINT'),
		csInfo.n.value('LicenseUsageUsed[1]/@EnterpriseBackupSize','BIGINT')  + csInfo.n.value('LicenseUsageUsed[1]/@CoreBackupSize','BIGINT'),
		csInfo.n.value('LicenseUsageTotal[1]/@EnterpriseArchiveSize','BIGINT')+ csInfo.n.value('LicenseUsageTotal[1]/@CoreArchiveSize','BIGINT'),
		csInfo.n.value('LicenseUsageUsed[1]/@EnterpriseArchiveSize','BIGINT') + csInfo.n.value('LicenseUsageUsed[1]/@CoreArchiveSize','BIGINT'),
		csInfo.n.value('LicenseUsageTotal[1]/@SnapshotSize','BIGINT'),
		csInfo.n.value('LicenseUsageUsed[1]/@SnapshotSize','BIGINT'),
		csInfo.n.value('LicenseUsageTotal[1]/@ReplicationSize','BIGINT'),
		csInfo.n.value('LicenseUsageUsed[1]/@ReplicationSize','BIGINT')
	FROM
		cf_CommservSurveyResults AS R
		INNER JOIN #Results T ON R.CommservSurveyResults_ID = T.SurveyResultId
		CROSS apply R.CollectedResults.nodes('/CapacityLicenseUsage') AS csInfo(n)
	UPDATE cf_SurveyCapacityLicensePeakUsage
	SET	ProtectedVMs		= CASE WHEN U.ProtectedVMs > P.ProtectedVMs THEN U.ProtectedVMs ELSE P.ProtectedVMs END,
		ArchivedMailBoxes	= CASE WHEN U.ArchivedMailBoxes > P.ArchivedMailBoxes THEN U.ArchivedMailBoxes ELSE P.ArchivedMailBoxes END,
		CIObjects			= CASE WHEN U.CIObjects > P.CIObjects THEN U.CIObjects ELSE P.CIObjects END,
		VMSockets			= CASE WHEN U.VMSockets > P.VMSockets THEN U.VMSockets ELSE P.VMSockets END,
		EndpointUsers		= CASE WHEN U.EndpointUsers > P.EndpointUsers THEN U.EndpointUsers ELSE P.EndpointUsers END,
		SharingUsers		= CASE WHEN U.SharingUsers > P.SharingUsers THEN U.SharingUsers ELSE P.SharingUsers END,
		eDiscoveryUsers		= CASE WHEN U.eDiscoveryUsers > P.eDiscoveryUsers THEN U.eDiscoveryUsers ELSE P.eDiscoveryUsers END,
		UsedDiskSpaceMB		= CASE WHEN U.UsedDiskSpaceMB > P.UsedDiskSpaceMB THEN U.UsedDiskSpaceMB ELSE P.UsedDiskSpaceMB END,
		DedupDataSizeMB		= CASE WHEN U.DedupDataSizeMB > P.DedupDataSizeMB THEN U.DedupDataSizeMB ELSE P.DedupDataSizeMB END,
		BackupSize			= CASE WHEN U.BackupSize > P.BackupSize THEN U.BackupSize ELSE P.BackupSize END,
		ArchiveSize			= CASE WHEN U.ArchiveSize > P.ArchiveSize THEN U.ArchiveSize ELSE P.ArchiveSize END,
		SnapshotSize		= CASE WHEN U.SnapshotSize > P.SnapshotSize THEN U.SnapshotSize ELSE P.SnapshotSize END,
		ReplicationSize		= CASE WHEN U.ReplicationSize > P.ReplicationSize THEN U.ReplicationSize ELSE P.ReplicationSize END
	FROM
		cf_SurveyCapacityLicenseUsage U
		INNER JOIN #Results T ON U.SurveyResultId = T.SurveyResultId
		INNER JOIN cf_SurveyCapacityLicensePeakUsage P ON P.CommServUniqueId = T.CommServUniqueId AND P.MonthStart = T.MonthStart
	INSERT INTO cf_SurveyCapacityLicensePeakUsage (
		CommServUniqueId, MonthStart, ProtectedVMs, ArchivedMailBoxes,
		CIObjects, VMSockets, EndpointUsers, SharingUsers, eDiscoveryUsers,
		UsedDiskSpaceMB, DedupDataSizeMB, BackupSize, ArchiveSize, SnapshotSize, ReplicationSize
		)
	SELECT
		T.CommServUniqueId, T.MonthStart, MAX(U.ProtectedVMs), MAX(U.ArchivedMailBoxes),
		MAX(U.CIObjects), MAX(U.VMSockets), MAX(U.EndpointUsers), MAX(U.SharingUsers), MAX(U.eDiscoveryUsers),
		MAX(U.UsedDiskSpaceMB), MAX(U.DedupDataSizeMB), MAX(U.BackupSize), MAX(U.ArchiveSize), MAX(U.SnapshotSize), MAX(U.ReplicationSize)
	FROM
		cf_SurveyCapacityLicenseUsage U
		INNER JOIN #Results T ON U.SurveyResultId = T.SurveyResultId
		LEFT OUTER JOIN cf_SurveyCapacityLicensePeakUsage P ON P.CommServUniqueId = T.CommServUniqueId AND P.MonthStart = T.MonthStart
	WHERE
		P.CommServUniqueId IS NULL
	GROUP BY T.CommServUniqueId, T.MonthStart
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Capacity License Usage - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Capacity License Usage - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCapacityLicenseSurvey')
	delete from GxQscripts where name = 'ParseCapacityLicenseSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCapacityLicenseSurvey')
	delete from GXDBVersions where aliasname = 'ParseCapacityLicenseSurvey'
GO

insert into GXDBVersions values(2, 'ParseCapacityLicenseSurvey',  '00010004000000000000', 'ParseCapacityLicenseSurvey', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCapacityUsageHistory.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCapacityUsageHistory.sp,v $ $Id: ParseCapacityUsageHistory.sp,v 1.5 2015/06/23 13:51:36 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseCapacityUsageHistory <<<'

IF EXISTS (select * from sysobjects where name='ParseCapacityUsageHistory')
	drop procedure ParseCapacityUsageHistory
IF EXISTS (select * from GxQscripts where name='ParseCapacityUsageHistory')
	delete from GxQscripts where name = 'ParseCapacityUsageHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCapacityUsageHistory')
	delete from GXDBVersions where aliasname = 'ParseCapacityUsageHistory'
GO
print '... Creating Procedure: ParseCapacityUsageHistory'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseCapacityUsageHistory
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 129
SELECT @ErrorCode = 0, @ErrorString = 'Parsing results for Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
DECLARE @CSUniqueId INT = 0
DECLARE @ResultId INT = 0
DECLARE @MonthStart DATETIME
DECLARE	SurveyResultCur CURSOR FOR
SELECT	F.CommcellIdNameMap_ID, R.CommservSurveyResults_ID, DATEADD(MONTH, DATEDIFF(MONTH, 0, R.LogDate), 0)
FROM	cf_CommservSurveyResults AS R INNER JOIN cf_CustomerFeedbackXmlFile AS F
	 ON F.ID = R.CustomerFeedbackXmlFile_ID
	AND F.ParseTime = @parseTime
	AND F.ShredStatus = 1
	AND R.ShredStatus = 1
	AND R.QueryId = @surveyId
ORDER BY R.LogDateUTC
OPEN SurveyResultCur
FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId, @MonthStart
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @ErrorCode = 0
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		ELSE
			SET @ProcessSurveyResultTran = 0
		INSERT INTO cf_SurveyCapacityUsageHistory (
			SurveyResultId, Month, EnterpriseBackupSizeMB, CoreBackupSizeMB, EnterpriseArchiveSizeMB, CoreArchiveSizeMB, SnapSizeMB, ReplicationSizeMB)
		SELECT
			@ResultId,
			csInfo.n.value('@Month','DATETIME'),
			csInfo.n.value('@EnterpriseBackupSizeMB','BIGINT'),
			csInfo.n.value('@CoreBackupSizeMB','BIGINT'),
			csInfo.n.value('@EnterpriseArchiveSizeMB','BIGINT'),
			csInfo.n.value('@CoreArchiveSizeMB','BIGINT'),
			csInfo.n.value('@SnapSizeMB','BIGINT'),
			csInfo.n.value('@ReplicationSizeMB','BIGINT')
		FROM
			cf_CommservSurveyResults
			CROSS apply CollectedResults.nodes('CapacityUsageHistory') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		INSERT INTO cf_SurveyCapacityLicensePeakUsage (
			CommServUniqueId, MonthStart, BackupSize, ArchiveSize, SnapshotSize, ReplicationSize)
		SELECT
			@CSUniqueId, U.Month,
			MAX(U.EnterpriseBackupSizeMB + U.CoreBackupSizeMB), MAX(U.EnterpriseArchiveSizeMB + U.CoreArchiveSizeMB),
			MAX(U.SnapSizeMB), MAX(U.ReplicationSizeMB)
		FROM
			cf_SurveyCapacityUsageHistory U
			LEFT OUTER JOIN cf_SurveyCapacityLicensePeakUsage P ON P.CommServUniqueId = @CSUniqueId AND P.MonthStart = U.Month
		WHERE U.SurveyResultId = @ResultId AND P.MonthStart IS NULL
		GROUP BY U.Month
		INSERT INTO cf_SurveyAgentSize (
			SurveyResultId, AppTypeId, AgentName, AppSizeMB, SizeOnMediaMB, NumOfClients)
		SELECT
			@ResultId,
			csInfo.n.value('@AppTypeId','INT'),
			csInfo.n.value('@AppTypeName','VARCHAR(256)'),
			csInfo.n.value('@AppSizeMB','BIGINT'),
			csInfo.n.value('@SizeOnMediaMB','BIGINT'),
			csInfo.n.value('@NumOfClients','INT')
		FROM
			cf_CommservSurveyResults
			CROSS apply CollectedResults.nodes('AgentDataSize') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		INSERT INTO cf_SurveyAgentSize (
			SurveyResultId, AppTypeId, AgentName, AppSizeMB, SizeOnMediaMB, NumOfClients)
		SELECT
			@ResultId, 0, '', SUM(AppSizeMB), SUM(SizeOnMediaMB), SUM(NumOfClients)
		FROM
			cf_SurveyAgentSize
		WHERE
			SurveyResultId = @ResultId
		UPDATE cf_SurveyAgentPeakSize
		SET	AppSizeMB = CASE WHEN S.AppSizeMB > P.AppSizeMB THEN S.AppSizeMB ELSE P.AppSizeMB END,
			SizeOnMediaMB = CASE WHEN S.SizeOnMediaMB > P.SizeOnMediaMB THEN S.SizeOnMediaMB ELSE P.SizeOnMediaMB END,
			NumOfClients = CASE WHEN S.NumOfClients > P.NumOfClients THEN S.NumOfClients ELSE P.NumOfClients END
		FROM
			cf_SurveyAgentSize S
			INNER JOIN cf_SurveyAgentPeakSize P ON P.CommServUniqueId = @CSUniqueId AND P.MonthStart = @MonthStart AND P.AppTypeId = S.AppTypeId
		WHERE
			S.SurveyResultId = @ResultId
		INSERT INTO cf_SurveyAgentPeakSize (
			CommServUniqueId, MonthStart, AppTypeId, AgentName, AppSizeMB, SizeOnMediaMB, NumOfClients)
		SELECT
			@CSUniqueId, @MonthStart, S.AppTypeId, S.AgentName, MAX(S.AppSizeMB), MAX(S.SizeOnMediaMB), MAX(S.NumOfClients)
		FROM
			cf_SurveyAgentSize S
			LEFT OUTER JOIN cf_SurveyAgentPeakSize P ON P.CommServUniqueId = @CSUniqueId AND P.MonthStart = @MonthStart AND P.AppTypeId = S.AppTypeId
		WHERE
			S.SurveyResultId = @ResultId AND P.MonthStart IS NULL
		GROUP BY S.AppTypeId, S.AgentName
		INSERT INTO cf_SurveyClientGroupSize (
			SurveyResultId, ClientGroupId, AppSizeMB, SizeOnMediaMB, NumOfClients)
		SELECT
			@ResultId,
			csInfo.n.value('@ClientGroupId','INT'),
			csInfo.n.value('@AppSizeMB','BIGINT'),
			csInfo.n.value('@SizeOnMediaMB','BIGINT'),
			csInfo.n.value('@NumOfClients','INT')
		FROM
			cf_CommservSurveyResults
			CROSS apply CollectedResults.nodes('ClientGroupDataSize') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		UPDATE cf_SurveyClientGroupPeakSize
		SET	AppSizeMB = CASE WHEN S.AppSizeMB > P.AppSizeMB THEN S.AppSizeMB ELSE P.AppSizeMB END,
			SizeOnMediaMB = CASE WHEN S.SizeOnMediaMB > P.SizeOnMediaMB THEN S.SizeOnMediaMB ELSE P.SizeOnMediaMB END,
			NumOfClients = CASE WHEN S.NumOfClients > P.NumOfClients THEN S.NumOfClients ELSE P.NumOfClients END
		FROM
			cf_SurveyClientGroupSize S
			INNER JOIN cf_SurveyClientGroupPeakSize P ON P.CommServUniqueId = @CSUniqueId AND P.MonthStart = @MonthStart AND P.ClientGroupId = S.ClientGroupId
		WHERE
			S.SurveyResultId = @ResultId
		INSERT INTO cf_SurveyClientGroupPeakSize (
			CommServUniqueId, MonthStart, ClientGroupId, AppSizeMB, SizeOnMediaMB, NumOfClients)
		SELECT
			@CSUniqueId, @MonthStart, S.ClientGroupId, MAX(S.AppSizeMB), MAX(S.SizeOnMediaMB), MAX(S.NumOfClients)
		FROM
			cf_SurveyClientGroupSize S
			LEFT OUTER JOIN cf_SurveyClientGroupPeakSize P ON P.CommServUniqueId = @CSUniqueId AND P.MonthStart = @MonthStart AND P.ClientGroupId = S.ClientGroupId
		WHERE
			S.SurveyResultId = @ResultId AND P.MonthStart IS NULL
		GROUP BY S.ClientGroupId
		IF (@ProcessSurveyResultTran = 1)
			COMMIT TRANSACTION ProcessSurveyResultTran
	END TRY
	BEGIN CATCH
		SELECT	@ErrorCode = 1,
				@ErrorString = 'Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' Commserv Unique ID ' + CAST(@CSUniqueId AS VARCHAR(20))
					+ ' Result ID ' + CAST(@ResultId AS VARCHAR(20)) + ' - Parsing failed with error :: ' + ERROR_MESSAGE()
		IF (@ProcessSurveyResultTran = 1)
			ROLLBACK TRANSACTION ProcessSurveyResultTran
	END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId
		IF @isPrintOn = 1 PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
	FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId, @MonthStart
END
CLOSE SurveyResultCur
DEALLOCATE SurveyResultCur
SET @ErrorCode = 0
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCapacityUsageHistory')
	delete from GxQscripts where name = 'ParseCapacityUsageHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCapacityUsageHistory')
	delete from GXDBVersions where aliasname = 'ParseCapacityUsageHistory'
GO

insert into GXDBVersions values(2, 'ParseCapacityUsageHistory',  '00010005000000000000', 'ParseCapacityUsageHistory', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseClientJobsCompletingWithError.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseClientJobsCompletingWithError.sp,v $ $Id: ParseClientJobsCompletingWithError.sp,v 1.2 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseClientJobsCompletingWithError <<<'

IF EXISTS (select * from sysobjects where name='ParseClientJobsCompletingWithError')
	drop procedure ParseClientJobsCompletingWithError
IF EXISTS (select * from GxQscripts where name='ParseClientJobsCompletingWithError')
	delete from GxQscripts where name = 'ParseClientJobsCompletingWithError'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseClientJobsCompletingWithError')
	delete from GXDBVersions where aliasname = 'ParseClientJobsCompletingWithError'
GO
print '... Creating Procedure: ParseClientJobsCompletingWithError'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseClientJobsCompletingWithError
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 37
SELECT @ErrorString = 'Clients Completing with Errors - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyClientJobsCompletingWithError
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@clientGroups', 'NVARCHAR(MAX)'),
		csInfo.n.value('@clientId', 'BIGINT'),
		csInfo.n.value('@clientName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@totalCWECount', 'BIGINT'),
		csInfo.n.value('@lastJobId', 'INTEGER'),
		csInfo.n.value('@failureReason', 'NVARCHAR(MAX)'),
		csInfo.n.value('@failureMsgIds', 'NVARCHAR(MAX)')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/ClientsWithCWE') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Clients Completing with Errors - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Clients Completing with Errors - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseClientJobsCompletingWithError')
	delete from GxQscripts where name = 'ParseClientJobsCompletingWithError'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseClientJobsCompletingWithError')
	delete from GXDBVersions where aliasname = 'ParseClientJobsCompletingWithError'
GO

insert into GXDBVersions values(2, 'ParseClientJobsCompletingWithError',  '00010002000000000000', 'ParseClientJobsCompletingWithError', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseClientStatisticsSurvey.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseClientStatisticsSurvey.sp,v $ $Id: ParseClientStatisticsSurvey.sp,v 1.2 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseClientStatisticsSurvey <<<'

IF EXISTS (select * from sysobjects where name='ParseClientStatisticsSurvey')
	drop procedure ParseClientStatisticsSurvey
IF EXISTS (select * from GxQscripts where name='ParseClientStatisticsSurvey')
	delete from GxQscripts where name = 'ParseClientStatisticsSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseClientStatisticsSurvey')
	delete from GXDBVersions where aliasname = 'ParseClientStatisticsSurvey'
GO
print '... Creating Procedure: ParseClientStatisticsSurvey'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseClientStatisticsSurvey
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 8
SELECT @ErrorString = 'Client Statistics - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyClientStatisticsInfo
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@total', 'INTEGER'),
		csInfo.n.value('LAPTOPCLIENTS[1]/@totalclients', 'INTEGER'),
		csInfo.n.value('INSTALLED[1]/@totalClients', 'INTEGER'),
		csInfo.n.value('UNINSTALLED[1]/@totalclient', 'INTEGER'),
		csInfo.n.value('DECONFIGURED[1]/@totalclient', 'INTEGER'),
		csInfo.n.value('DECONFIGURED[1]/@restoreonlyclients', 'INTEGER'),
		csInfo.n.value('UNINSTALLED[1]/@MiniSRMAgent', 'INTEGER'),
		csInfo.n.value('UNINSTALLED[1]/@VirtualServerDiscoveredClients', 'INTEGER'),
		csInfo.n.value('UNINSTALLED[1]/@ProxyforExchange', 'INTEGER'),
		csInfo.n.value('UNINSTALLED[1]/@DataClassificationInstalledonClient', 'INTEGER'),
		csInfo.n.value('UNINSTALLED[1]/@DB2DPF', 'INTEGER'),
		csInfo.n.value('UNINSTALLED[1]/@ORACLERac', 'INTEGER'),
		csInfo.n.value('UNINSTALLED[1]/@DAG', 'INTEGER'),
		csInfo.n.value('UNINSTALLED[1]/@EDCdiscoveredClient', 'INTEGER'),
		csInfo.n.value('UNINSTALLED[1]/@others', 'INTEGER')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/CLIENTS') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Client Statistics - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Client Statistics - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseClientStatisticsSurvey')
	delete from GxQscripts where name = 'ParseClientStatisticsSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseClientStatisticsSurvey')
	delete from GXDBVersions where aliasname = 'ParseClientStatisticsSurvey'
GO

insert into GXDBVersions values(2, 'ParseClientStatisticsSurvey',  '00010002000000000000', 'ParseClientStatisticsSurvey', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseClientsWithoutSP.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseClientsWithoutSP.sp,v $ $Id: ParseClientsWithoutSP.sp,v 1.2 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseClientsWithoutSP <<<'

IF EXISTS (select * from sysobjects where name='ParseClientsWithoutSP')
	drop procedure ParseClientsWithoutSP
IF EXISTS (select * from GxQscripts where name='ParseClientsWithoutSP')
	delete from GxQscripts where name = 'ParseClientsWithoutSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseClientsWithoutSP')
	delete from GXDBVersions where aliasname = 'ParseClientsWithoutSP'
GO
print '... Creating Procedure: ParseClientsWithoutSP'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseClientsWithoutSP
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 20
SELECT @ErrorString = 'Clients Without Storage Policy - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyClientsWithoutSPInfo
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('../@clientGroups', 'NVARCHAR(MAX)'),
		csInfo.n.value('../@Number_Of_Client', 'BIGINT'),
		csInfo.n.value('../@Client_Without_sp', 'BIGINT'),
		csInfo.n.value('../@Percent_Of_Client_Without_SP', 'DECIMAL(5, 2)'),
		csInfo.n.value('@clientId', 'BIGINT'),
		csInfo.n.value('@clientName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@agentName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@instanceName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@bkpsetName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@scName', 'NVARCHAR(MAX)')
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/Client_Without_sp/CLIENTENTITY') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Clients Without Storage Policy - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Clients Without Storage Policy - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseClientsWithoutSP')
	delete from GxQscripts where name = 'ParseClientsWithoutSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseClientsWithoutSP')
	delete from GXDBVersions where aliasname = 'ParseClientsWithoutSP'
GO

insert into GXDBVersions values(2, 'ParseClientsWithoutSP',  '00010002000000000000', 'ParseClientsWithoutSP', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseClientGroupAssociation.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseClientGroupAssociation.sp,v $ $Id: ParseClientGroupAssociation.sp,v 1.3 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseClientGroupAssociation <<<'

IF EXISTS (select * from sysobjects where name='ParseClientGroupAssociation')
	drop procedure ParseClientGroupAssociation
IF EXISTS (select * from GxQscripts where name='ParseClientGroupAssociation')
	delete from GxQscripts where name = 'ParseClientGroupAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseClientGroupAssociation')
	delete from GXDBVersions where aliasname = 'ParseClientGroupAssociation'
GO
print '... Creating Procedure: ParseClientGroupAssociation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseClientGroupAssociation
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
-------------------------------------------------------------------------------
-- Looping for each result:
--   Commit transaction for each result
--   Set ShredStatus = 3 immediately on error so it will be skipped in future
-- Always return ErrorCode = 0 so parsed results will be set to ShredStatus = 2
-------------------------------------------------------------------------------
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 151
SELECT @ErrorCode = 0, @ErrorString = 'Parsing results for Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
DECLARE @CSUniqueId INT = 0
DECLARE @ResultId INT = 0
DECLARE	SurveyResultCur CURSOR FOR
SELECT	F.CommcellIdNameMap_ID, R.CommservSurveyResults_ID
FROM	cf_CommservSurveyResults AS R INNER JOIN cf_CustomerFeedbackXmlFile AS F
	 ON F.ID = R.CustomerFeedbackXmlFile_ID
	AND F.ParseTime = @parseTime
	AND F.ShredStatus = 1
	AND R.ShredStatus = 1
	AND R.QueryId = @surveyId
ORDER BY R.LogDateUTC
OPEN SurveyResultCur
FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @ErrorCode = 0
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		ELSE
			SET @ProcessSurveyResultTran = 0
		DELETE cf_SurveyClientGroup WHERE CommservUniqueId = @CSUniqueId
		DELETE cf_SurveyClientGroupAssociation WHERE CommservUniqueId = @CSUniqueId
		INSERT INTO cf_SurveyClientGroup (
			CommservUniqueId, ClientGroupId, ClientGroupName)
		SELECT
			@CSUniqueId,
			csInfo.n.value('@clientGroupId','INT'),
			csInfo.n.value('@clientGroupName','NVARCHAR(512)')
		FROM cf_CommservSurveyResults
			CROSS APPLY CollectedResults.nodes('ClientGroupAssociation/ClientGroup') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		INSERT INTO cf_SurveyClientGroupAssociation (
			CommservUniqueId, ClientGroupId, ClientId)
		SELECT
			@CSUniqueId,
			csInfo.n.value('@clientGroupId','INT'),
			csInfo.n.value('@clientId','INT')
		FROM
			cf_CommservSurveyResults
			CROSS APPLY CollectedResults.nodes('ClientGroupAssociation/Association') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		IF (@ProcessSurveyResultTran = 1)
			COMMIT TRANSACTION ProcessSurveyResultTran
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		SELECT	@ErrorCode = 1,
				@ErrorString = 'Query ID ' + CAST(@surveyId AS VARCHAR(20))
					+ ' - Parsing failed for Result ID ' + CAST(@ResultId AS VARCHAR(20)) + ' with error :: ' + ERROR_MESSAGE()
		IF (@ProcessSurveyResultTran = 1)
			ROLLBACK TRANSACTION ProcessSurveyResultTran
	END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId
		IF @isPrintOn = 1 PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
	FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId
END
CLOSE SurveyResultCur
DEALLOCATE SurveyResultCur
SET @ErrorCode = 0
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseClientGroupAssociation')
	delete from GxQscripts where name = 'ParseClientGroupAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseClientGroupAssociation')
	delete from GXDBVersions where aliasname = 'ParseClientGroupAssociation'
GO

insert into GXDBVersions values(2, 'ParseClientGroupAssociation',  '00010003000000000000', 'ParseClientGroupAssociation', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCloudConnector.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCloudConnector.sp,v $ $Id: ParseCloudConnector.sp,v 1.2 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseCloudConnector <<<'

IF EXISTS (select * from sysobjects where name='ParseCloudConnector')
	drop procedure ParseCloudConnector
IF EXISTS (select * from GxQscripts where name='ParseCloudConnector')
	delete from GxQscripts where name = 'ParseCloudConnector'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCloudConnector')
	delete from GXDBVersions where aliasname = 'ParseCloudConnector'
GO
print '... Creating Procedure: ParseCloudConnector'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseCloudConnector
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 62
SELECT @ErrorString = 'Parse Cloud Connector- started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyCloudConnector
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@CloudConnectorType', 'NVARCHAR(125)'),
		csInfo.n.value('@DataStored', 'bigint')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/CloudSP/cloudConnector') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Parse Cloud Connector - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Parse Cloud Connector - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCloudConnector')
	delete from GxQscripts where name = 'ParseCloudConnector'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCloudConnector')
	delete from GXDBVersions where aliasname = 'ParseCloudConnector'
GO

insert into GXDBVersions values(2, 'ParseCloudConnector',  '00010002000000000000', 'ParseCloudConnector', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCommCellParamAudit.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCommCellParamAudit.sp,v $ $Id: ParseCommCellParamAudit.sp,v 1.3 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseCommCellParamAudit <<<'

IF EXISTS (select * from sysobjects where name='ParseCommCellParamAudit')
	drop procedure ParseCommCellParamAudit
IF EXISTS (select * from GxQscripts where name='ParseCommCellParamAudit')
	delete from GxQscripts where name = 'ParseCommCellParamAudit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCommCellParamAudit')
	delete from GXDBVersions where aliasname = 'ParseCommCellParamAudit'
GO
print '... Creating Procedure: ParseCommCellParamAudit'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseCommCellParamAudit
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
-------------------------------------------------------------------------------
-- Looping for each result:
--   Commit transaction for each result
--   Set ShredStatus = 3 immediately on error so it will be skipped in future
-- Always return ErrorCode = 0 so parsed results will be set to ShredStatus = 2
-------------------------------------------------------------------------------
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 159
SELECT @ErrorCode = 0, @ErrorString = 'Parsing results for Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
DECLARE @CSUniqueId INT = 0
DECLARE @ResultId INT = 0
DECLARE	SurveyResultCur CURSOR FOR
SELECT	F.CommcellIdNameMap_ID, R.CommservSurveyResults_ID
FROM	cf_CommservSurveyResults AS R INNER JOIN cf_CustomerFeedbackXmlFile AS F
	 ON F.ID = R.CustomerFeedbackXmlFile_ID
	AND F.ParseTime = @parseTime
	AND F.ShredStatus = 1
	AND R.ShredStatus = 1
	AND R.QueryId = @surveyId
ORDER BY R.LogDateUTC
OPEN SurveyResultCur
FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @ErrorCode = 0
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		ELSE
			SET @ProcessSurveyResultTran = 0
		INSERT INTO cf_SurveyCommCellParams (SurveyResultId, Category, Property, ParamName, ParamValue, DefaultValue)
		SELECT
			@ResultId,
			csInfo.n.value('@Category','INT'),
			csInfo.n.value('@Property','VARCHAR(64)'),
			csInfo.n.value('@Name','VARCHAR(256)'),
			csInfo.n.value('@Value','NVARCHAR(MAX)'),
			csInfo.n.value('@Default','NVARCHAR(MAX)')
		FROM
			cf_CommservSurveyResults
			CROSS APPLY CollectedResults.nodes('ParamAudit') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		IF (@ProcessSurveyResultTran = 1)
			COMMIT TRANSACTION ProcessSurveyResultTran
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		SELECT	@ErrorCode = 1,
				@ErrorString = 'Query ID ' + CAST(@surveyId AS VARCHAR(20))
					+ ' - Parsing failed for Result ID ' + CAST(@ResultId AS VARCHAR(20)) + ' with error :: ' + ERROR_MESSAGE()
		IF (@ProcessSurveyResultTran = 1)
			ROLLBACK TRANSACTION ProcessSurveyResultTran
	END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId
		IF @isPrintOn = 1 PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
	FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId
END
CLOSE SurveyResultCur
DEALLOCATE SurveyResultCur
SET @ErrorCode = 0
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCommCellParamAudit')
	delete from GxQscripts where name = 'ParseCommCellParamAudit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCommCellParamAudit')
	delete from GXDBVersions where aliasname = 'ParseCommCellParamAudit'
GO

insert into GXDBVersions values(2, 'ParseCommCellParamAudit',  '00010003000000000000', 'ParseCommCellParamAudit', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCommServDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCommServDetails.sp,v $ $Id: ParseCommServDetails.sp,v 1.3 2014/12/16 21:13:34 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseCommServDetails <<<'

IF EXISTS (select * from sysobjects where name='ParseCommServDetails')
	drop procedure ParseCommServDetails
IF EXISTS (select * from GxQscripts where name='ParseCommServDetails')
	delete from GxQscripts where name = 'ParseCommServDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCommServDetails')
	delete from GXDBVersions where aliasname = 'ParseCommServDetails'
GO
print '... Creating Procedure: ParseCommServDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseCommServDetails
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 2
SELECT @ErrorString = 'Commserv Details - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyCSDetailsInfo (
				CommServUniqueId, SurveyResultId, LogDateUTC, LogDate,
				CommServTZ, CommServVersion, QNetRegCount, LicExpirationDate)
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		ISNULL(csInfo.n.value('@CommServTZ', 'NVARCHAR(MAX)'), ''),
		ISNULL(csInfo.n.value('@CommServVersion', 'NVARCHAR(MAX)'),'Not Found'),
		ISNULL(csInfo.n.value('@QNetRegCount', 'INTEGER'),-1),
		ISNULL(csInfo.n.value('@LicExpirationDate', 'INTEGER'),0)
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/CommServerInfo') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Commserv Details - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Commserv Details - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCommServDetails')
	delete from GxQscripts where name = 'ParseCommServDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCommServDetails')
	delete from GXDBVersions where aliasname = 'ParseCommServDetails'
GO

insert into GXDBVersions values(2, 'ParseCommServDetails',  '00010003000000000000', 'ParseCommServDetails', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCopyBasicRetention.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCopyBasicRetention.sp,v $ $Id: ParseCopyBasicRetention.sp,v 1.7 2015/05/21 10:00:54 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseCopyBasicRetention <<<'

IF EXISTS (select * from sysobjects where name='ParseCopyBasicRetention')
	drop procedure ParseCopyBasicRetention
IF EXISTS (select * from GxQscripts where name='ParseCopyBasicRetention')
	delete from GxQscripts where name = 'ParseCopyBasicRetention'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCopyBasicRetention')
	delete from GXDBVersions where aliasname = 'ParseCopyBasicRetention'
GO
print '... Creating Procedure: ParseCopyBasicRetention'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseCopyBasicRetention
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
-------------------------------------------------------------------------------
-- Looping for each result:
--   Commit transaction for each result
--   Set ShredStatus = 3 immediately on error so it will be skipped in future
-- Always return ErrorCode = 0 so parsed results will be set to ShredStatus = 2
-------------------------------------------------------------------------------
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 153
SELECT @ErrorCode = 0, @ErrorString = 'Parsing results for Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
CREATE TABLE #CopyBasicRetention
(
	PolicyId			INT,
	PolicyName			NVARCHAR(144),
	CopyId				INT,
	CopyName			NVARCHAR(64),
	CopyType			INT,
	IsDefaultCopy		INT,
	IsSnapCopy			INT,
	RetentionDays		INT NULL,
	ArchiverRetDays		INT NULL,
	RetentionCycles		INT NULL,
	AgingFlags			INT NULL,
	ExtRretentionRules	INT NULL,
	DedupeFlags			INT NULL,
	DefaultLibrary		NVARCHAR(128) NULL
)
DECLARE @CSUniqueId INT = 0
DECLARE @ResultId INT = 0
DECLARE	SurveyResultCur CURSOR FOR
SELECT	F.CommcellIdNameMap_ID, R.CommservSurveyResults_ID
FROM	cf_CommservSurveyResults AS R INNER JOIN cf_CustomerFeedbackXmlFile AS F
	 ON F.ID = R.CustomerFeedbackXmlFile_ID
	AND F.ParseTime = @parseTime
	AND F.ShredStatus = 1
	AND R.ShredStatus = 1
	AND R.QueryId = @surveyId
ORDER BY R.LogDateUTC
OPEN SurveyResultCur
FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @ErrorCode = 0
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		ELSE
			SET @ProcessSurveyResultTran = 0
		TRUNCATE TABLE #CopyBasicRetention
		INSERT INTO #CopyBasicRetention (
			PolicyId, PolicyName, CopyId, CopyName, CopyType, IsDefaultCopy, IsSnapCopy,
			RetentionDays, ArchiverRetDays, RetentionCycles, AgingFlags, ExtRretentionRules,
			DedupeFlags, DefaultLibrary)
		SELECT
			csInfo.n.value('@policyId','INT'),
			csInfo.n.value('@policyName','NVARCHAR(144)'),
			csInfo.n.value('@copyId','INT'),
			csInfo.n.value('@copyName','VARCHAR(64)'),
			csInfo.n.value('@copyType','INT'),
			csInfo.n.value('@isDefaultCopy','INT'),
			csInfo.n.value('@isSnapCopy','INT'),
			csInfo.n.value('@retentionDays','INT'),
			csInfo.n.value('@archiverRetDays','INT'),
			csInfo.n.value('@retentionCycles','INT'),
			csInfo.n.value('@agingFlags','INT'),
			csInfo.n.value('@extRretentionRules','INT'),
			csInfo.n.value('@dedupeFlags','INT'),
			csInfo.n.value('@defaultLibrary','NVARCHAR(128)')
		FROM
			cf_CommservSurveyResults
			CROSS APPLY CollectedResults.nodes('Copy') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		DELETE	cf_SurveyCopyBasicRetention
		FROM	cf_SurveyCopyBasicRetention C INNER JOIN #CopyBasicRetention T
			 ON C.CommservUniqueId = @CSUniqueId AND C.CopyId = T.CopyId
		UPDATE	cf_SurveyCopyBasicRetention SET Deleted = 1
		WHERE	CommservUniqueId = @CSUniqueId AND Deleted = 0
		INSERT INTO cf_SurveyCopyBasicRetention (CommservUniqueId,
				PolicyId, PolicyName, CopyId, CopyName, CopyType, IsDefaultCopy, IsSnapCopy,
				RetentionDays, ArchiverRetDays, RetentionCycles, AgingFlags, ExtRretentionRules,
				Deleted, DedupeFlags, DefaultLibrary)
		SELECT	@CSUniqueId, PolicyId, PolicyName, CopyId, CopyName, CopyType, IsDefaultCopy, IsSnapCopy,
				RetentionDays, ArchiverRetDays, RetentionCycles, AgingFlags, ExtRretentionRules,
				0, DedupeFlags, DefaultLibrary
		FROM	#CopyBasicRetention
		DELETE cf_SurveyArchSelectiveCopy WHERE CommservUniqueId = @CSUniqueId
		INSERT INTO cf_SurveyArchSelectiveCopy (CommservUniqueId,
			CopyId, type, NumPeriod, dayNumber, copyflag)
		SELECT
			@CSUniqueId,
			csInfo.n.value('@copyId','INT'),
			csInfo.n.value('@type','TINYINT'),
            csInfo.n.value('@numPeriod','TINYINT'),
            csInfo.n.value('@dayNumber','SMALLINT'),
            csInfo.n.value('@copyflags','INT')
		FROM
			cf_CommservSurveyResults
			CROSS APPLY CollectedResults.nodes('ArchSelectiveCopy') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		IF (@ProcessSurveyResultTran = 1)
			COMMIT TRANSACTION ProcessSurveyResultTran
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		SELECT	@ErrorCode = 1,
				@ErrorString = 'Query ID ' + CAST(@surveyId AS VARCHAR(20))
					+ ' - Parsing failed for Result ID ' + CAST(@ResultId AS VARCHAR(20)) + ' with error :: ' + ERROR_MESSAGE()
		IF (@ProcessSurveyResultTran = 1)
			ROLLBACK TRANSACTION ProcessSurveyResultTran
	END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId
		IF @isPrintOn = 1 PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
	FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId
END
CLOSE SurveyResultCur
DEALLOCATE SurveyResultCur
SET @ErrorCode = 0
DROP TABLE #CopyBasicRetention
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCopyBasicRetention')
	delete from GxQscripts where name = 'ParseCopyBasicRetention'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCopyBasicRetention')
	delete from GXDBVersions where aliasname = 'ParseCopyBasicRetention'
GO

insert into GXDBVersions values(2, 'ParseCopyBasicRetention',  '00010007000000000000', 'ParseCopyBasicRetention', '00010007000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCopyFreeSpace.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCopyFreeSpace.sp,v $ $Id: ParseCopyFreeSpace.sp,v 1.2 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseCopyFreeSpace <<<'

IF EXISTS (select * from sysobjects where name='ParseCopyFreeSpace')
	drop procedure ParseCopyFreeSpace
IF EXISTS (select * from GxQscripts where name='ParseCopyFreeSpace')
	delete from GxQscripts where name = 'ParseCopyFreeSpace'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCopyFreeSpace')
	delete from GXDBVersions where aliasname = 'ParseCopyFreeSpace'
GO
print '... Creating Procedure: ParseCopyFreeSpace'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseCopyFreeSpace
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 70
SELECT @ErrorString = 'Parse CopyFreeSpace - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO [cf_SurveyCopyFreeSpace]
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@agId', 'int') as AgId,
		csInfo.n.value('@agName', 'NVARCHAR(255)') as AgName,
		csInfo.n.value('@copyId', 'int') as CopyId,
		csInfo.n.value('@copyName', 'nvarchar(255)') as CopyName,
		csInfo.n.value('@freeSpaceMB', 'bigint') as FreeSpaceMB,
		csInfo.n.value('@capacityMB', 'bigint') as CapacityMB
	FROM 	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/CopySpaceDetails/Copy') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Parse CopyFreeSpace - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Parse CopyFreeSpace - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCopyFreeSpace')
	delete from GxQscripts where name = 'ParseCopyFreeSpace'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCopyFreeSpace')
	delete from GXDBVersions where aliasname = 'ParseCopyFreeSpace'
GO

insert into GXDBVersions values(2, 'ParseCopyFreeSpace',  '00010002000000000000', 'ParseCopyFreeSpace', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseDailyStorageUsage.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseDailyStorageUsage.sp,v $ $Id: ParseDailyStorageUsage.sp,v 1.2 2015/04/17 15:49:40 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseDailyStorageUsage <<<'

IF EXISTS (select * from sysobjects where name='ParseDailyStorageUsage')
	drop procedure ParseDailyStorageUsage
IF EXISTS (select * from GxQscripts where name='ParseDailyStorageUsage')
	delete from GxQscripts where name = 'ParseDailyStorageUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDailyStorageUsage')
	delete from GXDBVersions where aliasname = 'ParseDailyStorageUsage'
GO
print '... Creating Procedure: ParseDailyStorageUsage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseDailyStorageUsage
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
-------------------------------------------------------------------------------
-- Looping for each result:
--   Commit transaction for each result
--   Set ShredStatus = 3 immediately on error so it will be skipped in future
-- Always return ErrorCode = 0 so parsed results will be set to ShredStatus = 2
-------------------------------------------------------------------------------
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 72
SELECT @ErrorCode = 0, @ErrorString = 'Parsing results for Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
DECLARE @CSUniqueId INT = 0
DECLARE @ResultId INT = 0
DECLARE	SurveyResultCur CURSOR FOR
SELECT	F.CommcellIdNameMap_ID, R.CommservSurveyResults_ID
FROM	cf_CommservSurveyResults AS R INNER JOIN cf_CustomerFeedbackXmlFile AS F
	 ON F.ID = R.CustomerFeedbackXmlFile_ID
	AND F.ParseTime = @parseTime
	AND F.ShredStatus = 1
	AND R.ShredStatus = 1
	AND R.QueryId = @surveyId
ORDER BY R.LogDateUTC
OPEN SurveyResultCur
FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @ErrorCode = 0
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		ELSE
			SET @ProcessSurveyResultTran = 0
		INSERT INTO cf_SurveyMonthlyChargeback (
			CommservUniqueId, SurveyResultId, StartDate, Type, ClientId, AppId, CopyId,
			FrontEndSize, DataProtected, DataWritten, TotalProtectedApp, TotalDataOnMedia, FrontEndSizeType)
		SELECT
			@CSUniqueId,
			@ResultId,
			csInfo.n.value('@StartDate','DATETIME'),
			csInfo.n.value('@Type','INT'),
			csInfo.n.value('@ClientId','INT'),
			csInfo.n.value('@AppId','INT'),
			csInfo.n.value('@CopyId','INT'),
			csInfo.n.value('@FrontEndSize','BIGINT'),
			csInfo.n.value('@DataProtected','BIGINT'),
			csInfo.n.value('@DataWritten','BIGINT'),
			csInfo.n.value('@TotalProtectedApp','BIGINT'),
			csInfo.n.value('@TotalDataOnMedia','BIGINT'),
			csInfo.n.value('@FrontEndSizeType','INT')
		FROM
			cf_CommservSurveyResults
			CROSS APPLY CollectedResults.nodes('DailyStorageUsage') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		IF	@@ROWCOUNT = 0
			SELECT	@ErrorCode = 1,
				@ErrorString = 'Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' Commserv Unique ID ' + CAST(@CSUniqueId AS VARCHAR(20))
					+ ' Result ID ' + CAST(@ResultId AS VARCHAR(20)) + ' - No data. Skipped.'
		IF (@ProcessSurveyResultTran = 1)
			COMMIT TRANSACTION ProcessSurveyResultTran
	END TRY
	BEGIN CATCH
		
	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		SELECT	@ErrorCode = 1,
				@ErrorString = 'Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' Commserv Unique ID ' + CAST(@CSUniqueId AS VARCHAR(20))
					+ ' Result ID ' + CAST(@ResultId AS VARCHAR(20)) + ' - Parsing failed with error :: ' + ERROR_MESSAGE()
		IF (@ProcessSurveyResultTran = 1)
			ROLLBACK TRANSACTION ProcessSurveyResultTran
	END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId
		IF @isPrintOn = 1 PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
	FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId
END
CLOSE SurveyResultCur
DEALLOCATE SurveyResultCur
SET @ErrorCode = 0
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseDailyStorageUsage')
	delete from GxQscripts where name = 'ParseDailyStorageUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDailyStorageUsage')
	delete from GXDBVersions where aliasname = 'ParseDailyStorageUsage'
GO

insert into GXDBVersions values(2, 'ParseDailyStorageUsage',  '00010002000000000000', 'ParseDailyStorageUsage', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseDDBPerformance.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseDDBPerformance.sp,v $ $Id: ParseDDBPerformance.sp,v 1.4 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseDDBPerformance <<<'

IF EXISTS (select * from sysobjects where name='ParseDDBPerformance')
	drop procedure ParseDDBPerformance
IF EXISTS (select * from GxQscripts where name='ParseDDBPerformance')
	delete from GxQscripts where name = 'ParseDDBPerformance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDDBPerformance')
	delete from GXDBVersions where aliasname = 'ParseDDBPerformance'
GO
print '... Creating Procedure: ParseDDBPerformance'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseDDBPerformance
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 65
SELECT @ErrorString = 'Parse DDBPerformance - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO [cf_SurveyDDBPerformance]
	(	 [CommServUniqueId]
        ,[SurveyResultId]
        ,[LogDateUTC]
        ,[LogDate]
        ,[SidbStoreId]
        ,[SidbStoreName]
        ,[LastRecordedTime]
        ,[AvgQITime]
        ,[CreatedTime]
        ,[PrimaryRecords]
		,[DDBSizeMB]
		,[ZeroRefCount]
		)
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@StoreId', 'int') as SidbStoreId,
		csInfo.n.value('@StoreName', 'NVARCHAR(255)') as SidbStoreName,
		csInfo.n.value('@LastRecordedTime', 'datetime') as LastRecordedTime,
		csInfo.n.value('@AvgQITime', 'bigint')	as AvgQITime,
		ISNULL(csInfo.n.value('@CreatedTime','datetime'),-1) as CreatedTime,
		ISNULL(csInfo.n.value('@PrimaryRecords','bigint'),-1) as PrimaryRecords,
		ISNULL(csInfo.n.value('@DDBSizeMB','bigint'),-1) as DDBSizeMB,
		ISNULL(csInfo.n.value('@ZeroRefRecords','bigint'),-1) as ZeroRefCount
	FROM 	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/DDBPerformance/Metric') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Parse DDBPerformance - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Parse DDBPerformance - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseDDBPerformance')
	delete from GxQscripts where name = 'ParseDDBPerformance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDDBPerformance')
	delete from GXDBVersions where aliasname = 'ParseDDBPerformance'
GO

insert into GXDBVersions values(2, 'ParseDDBPerformance',  '00010004000000000000', 'ParseDDBPerformance', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseDDBProtection.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseDDBProtection.sp,v $ $Id: ParseDDBProtection.sp,v 1.5 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseDDBProtection <<<'

IF EXISTS (select * from sysobjects where name='ParseDDBProtection')
	drop procedure ParseDDBProtection
IF EXISTS (select * from GxQscripts where name='ParseDDBProtection')
	delete from GxQscripts where name = 'ParseDDBProtection'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDDBProtection')
	delete from GXDBVersions where aliasname = 'ParseDDBProtection'
GO
print '... Creating Procedure: ParseDDBProtection'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseDDBProtection
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 66
SELECT @ErrorString = 'Parse DDBProtection - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO [cf_SurveyDDBProtection]
        ([CommServUniqueId]
        ,[SurveyResultId]
        ,[LogDateUTC]
        ,[LogDate]
        ,[SidbStoreId]
        ,[SidbStoreName]
        ,[LastDDBBackupJobId]
        ,[SPName]
        ,[LastBackupTime]
        ,[HoursSinceNoBackup])
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@SidbStoreId', 'int') as SidbStoreId,
		csInfo.n.value('@SidbStoreName', 'NVARCHAR(255)') as SidbStoreName,
		csInfo.n.value('@LastDDBBackupJobId', 'int') as LastDDBBackupJobId,
		ISNULL(csInfo.n.value('@SPName', 'nvarchar(max)'), ''),
		ISNULL(csInfo.n.value('@LastBackupTime', 'datetime'), NULL),
		ISNULL(csInfo.n.value('@HoursSinceNoBackup', 'int'), -1)
	FROM 	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/DDBProtection/DDBStore') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Parse DDBProtection - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Parse DDBProtection - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseDDBProtection')
	delete from GxQscripts where name = 'ParseDDBProtection'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDDBProtection')
	delete from GXDBVersions where aliasname = 'ParseDDBProtection'
GO

insert into GXDBVersions values(2, 'ParseDDBProtection',  '00010005000000000000', 'ParseDDBProtection', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseDeDupDeletedAFCount.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseDeDupDeletedAFCount.sp,v $ $Id: ParseDeDupDeletedAFCount.sp,v 1.3 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseDeDupDeletedAFCount <<<'

IF EXISTS (select * from sysobjects where name='ParseDeDupDeletedAFCount')
	drop procedure ParseDeDupDeletedAFCount
IF EXISTS (select * from GxQscripts where name='ParseDeDupDeletedAFCount')
	delete from GxQscripts where name = 'ParseDeDupDeletedAFCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDeDupDeletedAFCount')
	delete from GXDBVersions where aliasname = 'ParseDeDupDeletedAFCount'
GO
print '... Creating Procedure: ParseDeDupDeletedAFCount'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseDeDupDeletedAFCount
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 35
SELECT @ErrorString = 'DeDup Deleted Archive File Count - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyDeDupDeletedAFCount
		(
			CommServUniqueId,
			SurveyResultId,
			LogDateUTC,
			LogDate,
			SIDBStoreId,
			SIDBStoreName,
			DeletedAFCount,
			SealedOrNot,
			DDBHost,
			SevenDaysOldMMDeletedAFtable
		)
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@SIDBStoreId', 'INT'),
		csInfo.n.value('@SIDBStoreName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@DeletedAFCount', 'BIGINT'),
		csInfo.n.value('@SealedOrNot', 'NVARCHAR(MAX)'),
		csInfo.n.value('@DDBHost', 'NVARCHAR(MAX)'),
		csInfo.n.value('@OlderDeletedAFCount', 'BIGINT')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/DeDupDeletedAFCountXML') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'DeDup Deleted Archive File Count - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'DeDup Deleted Archive File Count - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseDeDupDeletedAFCount')
	delete from GxQscripts where name = 'ParseDeDupDeletedAFCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDeDupDeletedAFCount')
	delete from GXDBVersions where aliasname = 'ParseDeDupDeletedAFCount'
GO

insert into GXDBVersions values(2, 'ParseDeDupDeletedAFCount',  '00010003000000000000', 'ParseDeDupDeletedAFCount', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseDeDupDiskUsage.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseDeDupDiskUsage.sp,v $ $Id: ParseDeDupDiskUsage.sp,v 1.2 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseDeDupDiskUsage <<<'

IF EXISTS (select * from sysobjects where name='ParseDeDupDiskUsage')
	drop procedure ParseDeDupDiskUsage
IF EXISTS (select * from GxQscripts where name='ParseDeDupDiskUsage')
	delete from GxQscripts where name = 'ParseDeDupDiskUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDeDupDiskUsage')
	delete from GXDBVersions where aliasname = 'ParseDeDupDiskUsage'
GO
print '... Creating Procedure: ParseDeDupDiskUsage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseDeDupDiskUsage
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 56
SELECT @ErrorString = 'CommCell DeDup Disk Usage  - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyDeDupDiskUsage
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@DataOnDiskMB', 'BIGINT'),
		csInfo.n.value('@DedupedDataMB', 'BIGINT'),
		csInfo.n.value('@FreeDiskSpaceMB', 'BIGINT')
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/DeDupDiskUsageInfo') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'CommCell DeDup Disk Usage - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'CommCell DeDup Disk Usage - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseDeDupDiskUsage')
	delete from GxQscripts where name = 'ParseDeDupDiskUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDeDupDiskUsage')
	delete from GXDBVersions where aliasname = 'ParseDeDupDiskUsage'
GO

insert into GXDBVersions values(2, 'ParseDeDupDiskUsage',  '00010002000000000000', 'ParseDeDupDiskUsage', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseDeDupRatioBySPCopy.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseDeDupRatioBySPCopy.sp,v $ $Id: ParseDeDupRatioBySPCopy.sp,v 1.3 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseDeDupRatioBySPCopy <<<'

IF EXISTS (select * from sysobjects where name='ParseDeDupRatioBySPCopy')
	drop procedure ParseDeDupRatioBySPCopy
IF EXISTS (select * from GxQscripts where name='ParseDeDupRatioBySPCopy')
	delete from GxQscripts where name = 'ParseDeDupRatioBySPCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDeDupRatioBySPCopy')
	delete from GXDBVersions where aliasname = 'ParseDeDupRatioBySPCopy'
GO
print '... Creating Procedure: ParseDeDupRatioBySPCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseDeDupRatioBySPCopy
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 26
SELECT @ErrorString = 'Dedupe Ratio by Storage Policy Copy - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyDDBRatioBySPCopy
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@LastNDays', 'INTEGER'),
		'',
		'',
		'',
		0,
		0,
		0,
		0,
		0,
		csInfo.n.value('@PrimCopies', 'INTEGER'),
		csInfo.n.value('@DeDupPrimCopies', 'INTEGER'),
		csInfo.n.value('@TotalAppSizeGB', 'FLOAT'),
		csInfo.n.value('@TotalSizeOnMediaGB', 'FLOAT')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/DedupeRatioByCopy') AS csInfo(n)
	INSERT INTO cf_SurveyDDBRatioBySPCopy
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('../@LastNDays', 'INTEGER'),
		csInfo.n.value('@storagePolicy', 'NVARCHAR(256)'),
		csInfo.n.value('@copy', 'NVARCHAR(256)'),
		csInfo.n.value('@weekStartDate', 'DATETIME'),
		csInfo.n.value('@appSizeGB', 'DECIMAL(20,2)'),
		csInfo.n.value('@sizeOnMediaGB', 'DECIMAL(20,2)'),
		csInfo.n.value('@dedupeRatio', 'DECIMAL(20,2)'),
		csInfo.n.value('@jobs', 'INTEGER'),
		csInfo.n.value('@clients', 'INTEGER'),
		csInfo.n.value('../@PrimCopies', 'INTEGER'),
		csInfo.n.value('../@DeDupPrimCopies', 'INTEGER'),
		csInfo.n.value('../@TotalAppSizeGB', 'FLOAT'),
		csInfo.n.value('../@TotalSizeOnMediaGB', 'FLOAT')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/DedupeRatioByCopy/Copy') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Dedupe Ratio by Storage Policy Copy - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Dedupe Ratio by Storage Policy Copy - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseDeDupRatioBySPCopy')
	delete from GxQscripts where name = 'ParseDeDupRatioBySPCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDeDupRatioBySPCopy')
	delete from GXDBVersions where aliasname = 'ParseDeDupRatioBySPCopy'
GO

insert into GXDBVersions values(2, 'ParseDeDupRatioBySPCopy',  '00010003000000000000', 'ParseDeDupRatioBySPCopy', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseDeDupStoreConfig.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseDeDupStoreConfig.sp,v $ $Id: ParseDeDupStoreConfig.sp,v 1.4 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseDeDupStoreConfig <<<'

IF EXISTS (select * from sysobjects where name='ParseDeDupStoreConfig')
	drop procedure ParseDeDupStoreConfig
IF EXISTS (select * from GxQscripts where name='ParseDeDupStoreConfig')
	delete from GxQscripts where name = 'ParseDeDupStoreConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDeDupStoreConfig')
	delete from GXDBVersions where aliasname = 'ParseDeDupStoreConfig'
GO
print '... Creating Procedure: ParseDeDupStoreConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseDeDupStoreConfig
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 61
SELECT @ErrorString = 'DeDup Store Config - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyDeDupStoreConfig
           (CommServUniqueId
           ,SurveyResultId
           ,LogDateUTC
           ,LogDate
           ,MediaAgentId
           ,MediaAgentName
           ,SIDBStoreId
           ,SubstoreId
           ,idxAccessPathId
           ,SIDBStoreAliasName
           ,accessPath
           ,MACount
           ,SIDBCountForMA
           ,SubstoreCountForMA
           ,SubstoreCountForStore
           ,SealedStatus
           ,SIDBStoreStatus
           ,TotalDataSizeMB
           ,SealedTime
		   ,TotalRecords
		   ,SealedReason)
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@clientId', 'BIGINT'),
		csInfo.n.value('@clientName', 'NVARCHAR(256)'),
		csInfo.n.value('@SIDBStoreId', 'INTEGER'),
		csInfo.n.value('@SubstoreId', 'INTEGER'),
		csInfo.n.value('@idxAccessPathId', 'INTEGER'),
		csInfo.n.value('@SIDBStoreAliasName', 'NVARCHAR(256)'),
		csInfo.n.value('@AccessPath', 'NVARCHAR(256)'),
		csInfo.n.value('@MACount', 'INTEGER'),
		csInfo.n.value('@SIDBCountForMA', 'INTEGER'),
		csInfo.n.value('@SubstoreCountForMA', 'INTEGER'),
		csInfo.n.value('@SubstoreCountForStore', 'INTEGER'),
		csInfo.n.value('@SealedStatus', 'VARCHAR(16)'),
		ISNULL(csInfo.n.value('@SIDBStoreStatus', 'INTEGER'), 0),
		ISNULL(csInfo.n.value('@TotalDataSizeMB', 'BIGINT'), 0),
		ISNULL(csInfo.n.value('@SealedTime', 'INTEGER'), 0),
		ISNULL(csInfo.n.value('@TotalRecords', 'BIGINT'), 0),
		ISNULL(csInfo.n.value('@SealedReason', 'INTEGER'), 0)
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/DedupStoreConfigXML/DedupStoreConfig') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'DeDup Store Config - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'DeDup Store Config - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseDeDupStoreConfig')
	delete from GxQscripts where name = 'ParseDeDupStoreConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDeDupStoreConfig')
	delete from GXDBVersions where aliasname = 'ParseDeDupStoreConfig'
GO

insert into GXDBVersions values(2, 'ParseDeDupStoreConfig',  '00010004000000000000', 'ParseDeDupStoreConfig', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseDRBkpConfiguration.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseDRBkpConfiguration.sp,v $ $Id: ParseDRBkpConfiguration.sp,v 1.4 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseDRBkpConfiguration <<<'

IF EXISTS (select * from sysobjects where name='ParseDRBkpConfiguration')
	drop procedure ParseDRBkpConfiguration
IF EXISTS (select * from GxQscripts where name='ParseDRBkpConfiguration')
	delete from GxQscripts where name = 'ParseDRBkpConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDRBkpConfiguration')
	delete from GXDBVersions where aliasname = 'ParseDRBkpConfiguration'
GO
print '... Creating Procedure: ParseDRBkpConfiguration'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseDRBkpConfiguration
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 31
SELECT @ErrorString = 'DR Backup Configuration - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyDRBkpConfiguration(CommServUniqueId,SurveyResultId,LogDateUTC,LogDate,FullJobsToRetain,
											IsUingNetworkPath,LogFilesToBackup,WritingToTape,Schedule,LastJobId,ScheduleName)
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		DRConfig.value('@fullJobsToRetain', 'INTEGER'),
		DRConfig.value('@usingNetworkPath', 'NVARCHAR(20)'),
		DRConfig.value('@logFilesToBackup', 'NVARCHAR(MAX)'),
		DRConfig.value('@writingToTape', 'NVARCHAR(20)'),
		Schedule.value('@scheduleName', 'NVARCHAR(20)'),
		ISNULL(Schedule.value('@lastJobId', 'INTEGER'),-1),
		ISNULL(Schedule.value('@scheduleFullName', 'NVARCHAR(MAX)'),'')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('DRBackupConfigurationInfo') AS csInfo(DRConfig)
	CROSS apply DRConfig.nodes('schInfo') AS schInfo(schInfo)
	CROSS apply schInfo.nodes('Schedule') AS Schedule(Schedule)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'DR Backup Configuration - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'DR Backup Configuration - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseDRBkpConfiguration')
	delete from GxQscripts where name = 'ParseDRBkpConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDRBkpConfiguration')
	delete from GXDBVersions where aliasname = 'ParseDRBkpConfiguration'
GO

insert into GXDBVersions values(2, 'ParseDRBkpConfiguration',  '00010004000000000000', 'ParseDRBkpConfiguration', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseDRBkpStatus.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseDRBkpStatus.sp,v $ $Id: ParseDRBkpStatus.sp,v 1.2 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseDRBkpStatus <<<'

IF EXISTS (select * from sysobjects where name='ParseDRBkpStatus')
	drop procedure ParseDRBkpStatus
IF EXISTS (select * from GxQscripts where name='ParseDRBkpStatus')
	delete from GxQscripts where name = 'ParseDRBkpStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDRBkpStatus')
	delete from GXDBVersions where aliasname = 'ParseDRBkpStatus'
GO
print '... Creating Procedure: ParseDRBkpStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseDRBkpStatus
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 19
SELECT @ErrorString = 'DR Backup Statistics  - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	--Delete old last entry
	--DELETE a FROM cf_SurveyDRStats AS a
	--	INNER JOIN cf_CommservSurveyResults AS b
	--		ON a.SurveyResultId = b.CommservSurveyResults_ID
	--		AND a.LogDateUTC = b.LogDateUTC
	--		AND a.CommServUniqueId IN (SELECT DISTINCT CommcellIdNameMap_ID FROM cf_CustomerFeedbackXmlFile WHERE ShredStatus = 1 AND ParseTime = @parseTime)
	--		AND b.Flags = 1
	INSERT INTO cf_SurveyDRStats
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@DR_No_Of_Success', 'BIGINT'),
		csInfo.n.value('@DR_No_Of_Failure', 'BIGINT'),
		csInfo.n.value('@Last_Successful_Dr', 'INTEGER'),
		csInfo.n.value('@full_backup_time_period', 'DECIMAL(10, 2)'),
		csInfo.n.value('@differential_backup_frequency', 'DECIMAL(10, 2)')
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/DRstats') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'DR Backup Statistics - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'DR Backup Statistics - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseDRBkpStatus')
	delete from GxQscripts where name = 'ParseDRBkpStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDRBkpStatus')
	delete from GXDBVersions where aliasname = 'ParseDRBkpStatus'
GO

insert into GXDBVersions values(2, 'ParseDRBkpStatus',  '00010002000000000000', 'ParseDRBkpStatus', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseFailingClients.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseFailingClients.sp,v $ $Id: ParseFailingClients.sp,v 1.5 2014/12/05 18:55:28 vmishra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseFailingClients <<<'

IF EXISTS (select * from sysobjects where name='ParseFailingClients')
	drop procedure ParseFailingClients
IF EXISTS (select * from GxQscripts where name='ParseFailingClients')
	delete from GxQscripts where name = 'ParseFailingClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseFailingClients')
	delete from GXDBVersions where aliasname = 'ParseFailingClients'
GO
print '... Creating Procedure: ParseFailingClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseFailingClients
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
-------------------------------------------------------------------------------
-- Looping for each result:
--   Commit transaction for each result
--   Set ShredStatus = 3 immediately on error so it will be skipped in future
-- Always return ErrorCode = 0 so parsed results will be set to ShredStatus = 2
-------------------------------------------------------------------------------
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 25
SELECT @ErrorCode = 0, @ErrorString = 'Parsing results for Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
DECLARE @CSUniqueId INT = 0
DECLARE @ResultId INT = 0
DECLARE @LogDateUTC datetime
DECLARE @LogDate    datetime
DECLARE	SurveyResultCur CURSOR FOR
SELECT	F.CommcellIdNameMap_ID, R.CommservSurveyResults_ID, R.LogDateUTC, R.LogDate
FROM	cf_CommservSurveyResults AS R INNER JOIN cf_CustomerFeedbackXmlFile AS F
	 ON F.ID = R.CustomerFeedbackXmlFile_ID
	AND F.ParseTime = @parseTime
	AND F.ShredStatus = 1
	AND R.ShredStatus = 1
	AND R.QueryId = @surveyId
ORDER BY R.LogDateUTC
OPEN SurveyResultCur
FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId, @LogDateUTC, @LogDate
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @ErrorCode = 0
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		ELSE
			SET @ProcessSurveyResultTran = 0
		INSERT INTO cf_SurveyFailingClients
				(
					CommServUniqueId,
					SurveyResultId,
					LogDateUTC,
					LogDate,
					ClientGroups,
					ClientId,
					ClientName,
					InstanceName,
					AgentName,
					Backupset,
					Subclient,
					StrikeCounts,
					BackupType,
					FailedFrom,
					FailedDays,
					LastJobId,
					LastJobStartTime,
					LastJobEndTime,
					LastJobStatus,
					FailureMsgIds,
					FailureReason,
					AppGroup,
					ClientGroupName,
					PhysicalClientName
				)
		SELECT
			@CSUniqueId,
			@ResultId,
			@LogDateUTC,
			@LogDate,
			csInfo.n.value('../@clientGroups', 'NVARCHAR(MAX)'),
			csInfo.n.value('@clientId', 'BIGINT'),
			csInfo.n.value('@clientName', 'NVARCHAR(MAX)'),
			csInfo.n.value('@Instance', 'NVARCHAR(MAX)'),
			csInfo.n.value('@agentName', 'NVARCHAR(MAX)'),
			csInfo.n.value('@Backupset', 'NVARCHAR(MAX)'),
			csInfo.n.value('@Subclient', 'NVARCHAR(MAX)'),
			csInfo.n.value('@StrikeCounts', 'INTEGER'),
			csInfo.n.value('@backupType', 'NVARCHAR(25)'),
			csInfo.n.value('@FailedFrom', 'DATETIME'),
			csInfo.n.value('@FailedDays', 'INTEGER'),
			csInfo.n.value('@lasJobId', 'BIGINT'),
			csInfo.n.value('@lastJobStartTime', 'DATETIME'),
			csInfo.n.value('@lastJobEndTime', 'DATETIME'),
			csInfo.n.value('@lastJobStatus', 'NVARCHAR(32)'),
			csInfo.n.value('@errorCode', 'NVARCHAR(MAX)'),
			csInfo.n.value('@FailureReason', 'NVARCHAR(MAX)'),
			csInfo.n.value('@AppGroup', 'NVARCHAR(MAX)'),
			ISNULL(csInfo.n.value('@ClientGroups', 'NVARCHAR(MAX)'),''),
			csInfo.n.value('@physicalClientName', 'NVARCHAR(MAX)')
		FROM
		cf_CommservSurveyResults
		CROSS apply CollectedResults.nodes('/ContinuousFailedClients/Client') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		IF (@ProcessSurveyResultTran = 1)
		BEGIN
			COMMIT TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 0
		END
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		SELECT	@ErrorCode = 1,
				@ErrorString = 'Query ID ' + CAST(@surveyId AS VARCHAR(20))
					+ ' - Parsing failed for Result ID ' + CAST(@ResultId AS VARCHAR(20)) + ' with error :: ' + ERROR_MESSAGE()
		IF (@ProcessSurveyResultTran = 1)
			ROLLBACK TRANSACTION ProcessSurveyResultTran
	END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId
		IF @isPrintOn = 1 PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
	FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId, @LogDateUTC,  @LogDate
END
CLOSE SurveyResultCur
DEALLOCATE SurveyResultCur
SET @ErrorCode = 0
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseFailingClients')
	delete from GxQscripts where name = 'ParseFailingClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseFailingClients')
	delete from GXDBVersions where aliasname = 'ParseFailingClients'
GO

insert into GXDBVersions values(2, 'ParseFailingClients',  '00010005000000000000', 'ParseFailingClients', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseFallenBehindCopies.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseFallenBehindCopies.sp,v $ $Id: ParseFallenBehindCopies.sp,v 1.3 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseFallenBehindCopies <<<'

IF EXISTS (select * from sysobjects where name='ParseFallenBehindCopies')
	drop procedure ParseFallenBehindCopies
IF EXISTS (select * from GxQscripts where name='ParseFallenBehindCopies')
	delete from GxQscripts where name = 'ParseFallenBehindCopies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseFallenBehindCopies')
	delete from GXDBVersions where aliasname = 'ParseFallenBehindCopies'
GO
print '... Creating Procedure: ParseFallenBehindCopies'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseFallenBehindCopies
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 64
SELECT @ErrorString = 'Parse Fallen Behind Copies - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO [cf_SurveyFallenBehindCopies]
        ([CommServUniqueId]
        ,[SurveyResultId]
        ,[LogDateUTC]
        ,[LogDate]
        ,[StoragePolicyName]
        ,[StoragePolicyCopyName]
        ,[FallenBehindDays]
        ,[JobsToCopyCount]
        ,[OldestJobId]
        ,[OldestJobStartTime]
        ,[TotalToBeCopiedJobsApplicationSizeGB]
        ,[EstTotalToBeCopiedJobsMediaSizeGB]
        ,[EstCompletionDateForAllData]
		,[AvgAuxCopyJobThroughput])
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@StoragePolicyName', 'NVARCHAR(255)'),
		csInfo.n.value('@StoragePolicyCopyName', 'NVARCHAR(255)'),
		csInfo.n.value('@FallenBehindDays', 'int'),
		csInfo.n.value('@JobsToCopyCount', 'int'),
		csInfo.n.value('@OldestJobId', 'int'),
		csInfo.n.value('@OldestJobStartTime', 'datetime'),
		ISNULL(csInfo.n.value('@TotalToBeCopiedJobsApplicationSizeGB', 'FLOAT'), 0),
		ISNULL(csInfo.n.value('@EstTotalToBeCopiedJobsMediaSizeGB', 'FLOAT'), 0),
		ISNULL(csInfo.n.value('@EstCompletionDateForAllData', 'BIGINT'), -1),
		ISNULL(csInfo.n.value('@AvgAuxCopyJobThroughput', 'FLOAT'), -1)
	FROM 	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/FallenBehindCopy/DashCopy') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Parse Fallen Behind Copies - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Parse Fallen Behind Copies - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseFallenBehindCopies')
	delete from GxQscripts where name = 'ParseFallenBehindCopies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseFallenBehindCopies')
	delete from GXDBVersions where aliasname = 'ParseFallenBehindCopies'
GO

insert into GXDBVersions values(2, 'ParseFallenBehindCopies',  '00010003000000000000', 'ParseFallenBehindCopies', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseGUILoginLanguageSurvey.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseGUILoginLanguageSurvey.sp,v $ $Id: ParseGUILoginLanguageSurvey.sp,v 1.2 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseGUILoginLanguageSurvey <<<'

IF EXISTS (select * from sysobjects where name='ParseGUILoginLanguageSurvey')
	drop procedure ParseGUILoginLanguageSurvey
IF EXISTS (select * from GxQscripts where name='ParseGUILoginLanguageSurvey')
	delete from GxQscripts where name = 'ParseGUILoginLanguageSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseGUILoginLanguageSurvey')
	delete from GXDBVersions where aliasname = 'ParseGUILoginLanguageSurvey'
GO
print '... Creating Procedure: ParseGUILoginLanguageSurvey'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseGUILoginLanguageSurvey
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 5
SELECT @ErrorString = 'GUI Login Language - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyGUILoginInfo
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@Locale','NVARCHAR(MAX)'),
		csInfo.n.value('@Count','BIGINT')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/GUILoginLanguages') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'GUI Login Language - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'GUI Login Language - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseGUILoginLanguageSurvey')
	delete from GxQscripts where name = 'ParseGUILoginLanguageSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseGUILoginLanguageSurvey')
	delete from GXDBVersions where aliasname = 'ParseGUILoginLanguageSurvey'
GO

insert into GXDBVersions values(2, 'ParseGUILoginLanguageSurvey',  '00010002000000000000', 'ParseGUILoginLanguageSurvey', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseHighRiskSettings.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseHighRiskSettings.sp,v $ $Id: ParseHighRiskSettings.sp,v 1.3 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseHighRiskSettings <<<'

IF EXISTS (select * from sysobjects where name='ParseHighRiskSettings')
	drop procedure ParseHighRiskSettings
IF EXISTS (select * from GxQscripts where name='ParseHighRiskSettings')
	delete from GxQscripts where name = 'ParseHighRiskSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseHighRiskSettings')
	delete from GXDBVersions where aliasname = 'ParseHighRiskSettings'
GO
print '... Creating Procedure: ParseHighRiskSettings'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseHighRiskSettings
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 124
SELECT @ErrorString = 'High Risk Settings  - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_surveyHighRiskSettings(SurveyResultId, Name, Value, ValueString)
	SELECT
		results.CommservSurveyResults_ID,
		csInfo.n.value('@Name', 'NVARCHAR(MAX)'),
		ISNULL(csInfo.n.value('@Value', 'INT'), 0),
		ISNULL(csInfo.n.value('@ValueString', 'NVARCHAR(MAX)'), '')
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/HighRiskSettings') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'High Risk Settings - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'High Risk Settings - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseHighRiskSettings')
	delete from GxQscripts where name = 'ParseHighRiskSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseHighRiskSettings')
	delete from GXDBVersions where aliasname = 'ParseHighRiskSettings'
GO

insert into GXDBVersions values(2, 'ParseHighRiskSettings',  '00010003000000000000', 'ParseHighRiskSettings', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseIncrBkpChangeRate.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseIncrBkpChangeRate.sp,v $ $Id: ParseIncrBkpChangeRate.sp,v 1.2 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseIncrBkpChangeRate <<<'

IF EXISTS (select * from sysobjects where name='ParseIncrBkpChangeRate')
	drop procedure ParseIncrBkpChangeRate
IF EXISTS (select * from GxQscripts where name='ParseIncrBkpChangeRate')
	delete from GxQscripts where name = 'ParseIncrBkpChangeRate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseIncrBkpChangeRate')
	delete from GXDBVersions where aliasname = 'ParseIncrBkpChangeRate'
GO
print '... Creating Procedure: ParseIncrBkpChangeRate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseIncrBkpChangeRate
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 28
SELECT @ErrorString = 'Incremental Backup Change Rate - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	--Delete old last entry
	--DELETE a FROM cf_SurveyIncrBkpChangeRate AS a
	--	INNER JOIN cf_CommservSurveyResults AS b
	--		ON a.SurveyResultId = b.CommservSurveyResults_ID
	--		AND a.LogDateUTC = b.LogDateUTC
	--		AND a.CommServUniqueId IN (SELECT DISTINCT CommcellIdNameMap_ID FROM cf_CustomerFeedbackXmlFile WHERE ShredStatus = 1 AND ParseTime = @parseTime)
	--		AND b.Flags = 1
	INSERT INTO cf_SurveyIncrBkpChangeRate
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('../@TOTAL_BKP_SIZE', 'FLOAT'),
		csInfo.n.value('../@TOTAL_JOBS', 'BIGINT'),
		csInfo.n.value('@DAY', 'INTEGER'),
		csInfo.n.value('@Percentage_Change', 'NVARCHAR(20)'),
		csInfo.n.value('@Total_Change_In_Gb', 'FLOAT'),
		csInfo.n.value('@Backup_Size', 'FLOAT')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/INCREMENTAL_BACKUP_CHANGE_RATE/DAY_ENTITY') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Incremental Backup Change Rate - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Incremental Backup Change Rate - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseIncrBkpChangeRate')
	delete from GxQscripts where name = 'ParseIncrBkpChangeRate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseIncrBkpChangeRate')
	delete from GXDBVersions where aliasname = 'ParseIncrBkpChangeRate'
GO

insert into GXDBVersions values(2, 'ParseIncrBkpChangeRate',  '00010002000000000000', 'ParseIncrBkpChangeRate', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseIndexFragmentation.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseIndexFragmentation.sp,v $ $Id: ParseIndexFragmentation.sp,v 1.3 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseIndexFragmentation <<<'

IF EXISTS (select * from sysobjects where name='ParseIndexFragmentation')
	drop procedure ParseIndexFragmentation
IF EXISTS (select * from GxQscripts where name='ParseIndexFragmentation')
	delete from GxQscripts where name = 'ParseIndexFragmentation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseIndexFragmentation')
	delete from GXDBVersions where aliasname = 'ParseIndexFragmentation'
GO
print '... Creating Procedure: ParseIndexFragmentation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseIndexFragmentation
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 144
SELECT @ErrorString = 'IndexFragmentation - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyIndexFragmentation (SurveyResultId, DatabaseName, FragmentationPct, IndexCount)
	SELECT
		results.CommservSurveyResults_ID,
		csInfo.n.value('@DatabaseName', 'VARCHAR(32)'),
		csInfo.n.value('@FragmentationPct', 'INT'),
		csInfo.n.value('@IndexCount', 'INT')
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/IndexFragmentation') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'IndexFragmentation - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'IndexFragmentation - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseIndexFragmentation')
	delete from GxQscripts where name = 'ParseIndexFragmentation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseIndexFragmentation')
	delete from GXDBVersions where aliasname = 'ParseIndexFragmentation'
GO

insert into GXDBVersions values(2, 'ParseIndexFragmentation',  '00010003000000000000', 'ParseIndexFragmentation', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseJobDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseJobDetails.sp,v $ $Id: ParseJobDetails.sp,v 1.11 2015/06/30 16:09:56 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseJobDetails <<<'

IF EXISTS (select * from sysobjects where name='ParseJobDetails')
	drop procedure ParseJobDetails
IF EXISTS (select * from GxQscripts where name='ParseJobDetails')
	delete from GxQscripts where name = 'ParseJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseJobDetails')
	delete from GXDBVersions where aliasname = 'ParseJobDetails'
GO
print '... Creating Procedure: ParseJobDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseJobDetails
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 137
SELECT @ErrorCode = 0, @ErrorString = 'Parsing results for Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
IF object_id('tempdb.dbo.#SurveySubclients') is not null DROP TABLE #SurveySubclients
IF object_id('tempdb.dbo.#SurveyJobStats') is not null DROP TABLE #SurveyJobStats
CREATE TABLE #SurveySubclients (
	CommservUniqueId INT, AppId INT, AppTypeId INT, ClientName NVARCHAR(256), AgentName VARCHAR(256),
	InstanceName NVARCHAR(512), BackupsetName NVARCHAR(128), SubclientName NVARCHAR(128), ClientGroups NVARCHAR(MAX))
CREATE TABLE #SurveyJobStats (
	CommservUniqueId INT, JobId INT, AppId INT, OpType INT, BkpLevel INT, Status INT, StartDate INT, EndDate INT,
	ScanType INT, SizeChangePct INT, TransferTime INT, ProtectedObjects BIGINT, FailedObjects BIGINT, FailedFolders BIGINT,
	DataProtected BIGINT, DataCompressed BIGINT, DataTransferred BIGINT, DataWritten BIGINT,
	ErrorCode VARCHAR(32), FailureReason NVARCHAR(512), StoragePolicy NVARCHAR(144), StoragePolicyID INT,
	SchedulePolicy NVARCHAR(256), ScheduleName NVARCHAR(256), Attempts INT,InitFrom INT,Phases INT)
CREATE TABLE #SurveyJobDbSize (
	CommservUniqueId INT, JobId INT, JobEndDate INT, DbName NVARCHAR(1024), DbSize BIGINT)
CREATE TABLE #RunningJobStats (
	CommservUniqueId INT, JobId INT, AppId INT, OpType INT,	BkpLevel INT, StartDate INT, State INT,	InitFrom INT)
DECLARE @CSUniqueId INT = 0
DECLARE @ResultId INT = 0
DECLARE	SurveyResultCur CURSOR FOR
SELECT	F.CommcellIdNameMap_ID, R.CommservSurveyResults_ID
FROM	cf_CommservSurveyResults AS R INNER JOIN cf_CustomerFeedbackXmlFile AS F
	 ON F.ID = R.CustomerFeedbackXmlFile_ID
	AND F.ParseTime = @parseTime
	AND F.ShredStatus = 1
	AND R.ShredStatus = 1
	AND R.QueryId = @surveyId
ORDER BY R.LogDateUTC
OPEN SurveyResultCur
FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @ErrorCode = 0
  BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	ELSE
		SET @ProcessSurveyResultTran = 0
	DELETE FROM #SurveySubclients
	DELETE FROM #SurveyJobStats
	DELETE FROM #SurveyJobDbSize
	DELETE FROM #RunningJobStats
	INSERT INTO #SurveySubclients (
		CommservUniqueId, AppId, AppTypeId, ClientName, AgentName, InstanceName, BackupsetName, SubclientName, ClientGroups)
	SELECT DISTINCT
		CommcellIdNameMap_ID,
		csInfo.n.value('@AppId', 'INT'),
		csInfo.n.value('@AppTypeId', 'INT'),
		csInfo.n.value('@ClientName', 'NVARCHAR(256)'),
		csInfo.n.value('@AgentName', 'VARCHAR(256)'),
		csInfo.n.value('@InstanceName', 'NVARCHAR(512)'),
		csInfo.n.value('@BackupsetName', 'NVARCHAR(128)'),
		csInfo.n.value('@SubclientName', 'NVARCHAR(128)'),
		csInfo.n.value('@ClientGroups', 'NVARCHAR(MAX)')
	FROM
		cf_CommservSurveyResults
			CROSS apply CollectedResults.nodes('/JobDetails/Subclients') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	INSERT INTO #SurveyJobStats (
		CommservUniqueId, JobId, AppId, OpType, BkpLevel, Status, StartDate, EndDate,
		ScanType, SizeChangePct, TransferTime, ProtectedObjects, FailedObjects, FailedFolders,
		DataProtected, DataCompressed, DataTransferred, DataWritten, ErrorCode, FailureReason,
		StoragePolicy, StoragePolicyID, SchedulePolicy, ScheduleName, Attempts,InitFrom,Phases)
	SELECT DISTINCT
		CommcellIdNameMap_ID,
		csInfo.n.value('@JobId', 'INT'),
		csInfo.n.value('@AppId', 'INT'),
		csInfo.n.value('@OpType', 'INT'),
		csInfo.n.value('@BkpLevel', 'INT'),
		csInfo.n.value('@Status', 'INT'),
		csInfo.n.value('@StartDate', 'INT'),
		csInfo.n.value('@EndDate', 'INT'),
		csInfo.n.value('@ScanType', 'INT'),
		csInfo.n.value('@SizeChangePct', 'INT'),
		csInfo.n.value('@TransferTime', 'INT'),
		csInfo.n.value('@ProtectedObjects', 'BIGINT'),
		csInfo.n.value('@FailedObjects', 'BIGINT'),
		csInfo.n.value('@FailedFolders', 'BIGINT'),
		csInfo.n.value('@DataProtected', 'BIGINT'),
		csInfo.n.value('@DataCompressed', 'BIGINT'),
		csInfo.n.value('@DataTransferred', 'BIGINT'),
		csInfo.n.value('@DataWritten', 'BIGINT'),
		csInfo.n.value('@ErrorCode', 'VARCHAR(32)'),
		csInfo.n.value('@FailureReason', 'NVARCHAR(512)'),
		csInfo.n.value('@StoragePolicy', 'NVARCHAR(144)'),
		ISNULL(csInfo.n.value('@StoragePolicyID', 'INT'),1),
		csInfo.n.value('@SchedulePolicy', 'NVARCHAR(256)'),
		csInfo.n.value('@ScheduleName', 'NVARCHAR(256)'),
		csInfo.n.value('@Attempts', 'INT'),
		ISNULL(csInfo.n.value('@InitFrom', 'INT'),0),
		ISNULL(csInfo.n.value('@Phases'  , 'INT'),0)
	FROM
		cf_CommservSurveyResults
			CROSS apply CollectedResults.nodes('/JobDetails/JobStats') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	INSERT INTO #SurveyJobDbSize (
		CommservUniqueId, JobId, JobEndDate, DbName, DbSize)
	SELECT DISTINCT
		CommcellIdNameMap_ID,
		csInfo.n.value('@JobId', 'INT'),
		csInfo.n.value('@JobEndDate', 'INT'),
		csInfo.n.value('@DbName', 'NVARCHAR(1024)'),
		csInfo.n.value('@DbSize', 'BIGINT')
	FROM
		cf_CommservSurveyResults
		CROSS apply CollectedResults.nodes('/JobDetails/JobDBSize') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	INSERT INTO #RunningJobStats (
		CommservUniqueId ,JobId ,AppId ,OpType ,BkpLevel ,StartDate ,State ,InitFrom)
	SELECT DISTINCT
		CommcellIdNameMap_ID,
		csInfo.n.value('@JobId', 'INT'),
		csInfo.n.value('@AppId', 'INT'),
		csInfo.n.value('@OpType', 'INT'),
		csInfo.n.value('@BkpLevel', 'INT'),
		csInfo.n.value('@StartDate', 'INT'),
		csInfo.n.value('@State', 'INT'),
		csInfo.n.value('@InitFrom', 'INT')
	FROM
		cf_CommservSurveyResults
		CROSS apply CollectedResults.nodes('/JobDetails/RunningJobStats') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	IF NOT EXISTS (select * from #RunningJobStats WHERE CommservUniqueId =  (SELECT CommcellIdNameMap_ID FROM cf_CommservSurveyResults WHERE CommservSurveyResults_ID = @ResultId))
	INSERT INTO #RunningJobStats (CommservUniqueId ,JobId ,AppId ,OpType ,BkpLevel ,StartDate ,State ,InitFrom) SELECT CommcellIdNameMap_ID,0,0,0,0,0,0,0 FROM cf_CommservSurveyResults WHERE CommservSurveyResults_ID = @ResultId
	UPDATE	cf_SurveySubclients
	SET		ClientName = B.ClientName, InstanceName = B.InstanceName, BackupsetName = B.BackupsetName,
			SubclientName = B.SubclientName, ClientGroups = B.ClientGroups
	FROM	cf_SurveySubclients A
			INNER JOIN #SurveySubclients B ON A.CommservUniqueId = B.CommservUniqueId AND A.AppId = B.AppId
	WHERE	A.ClientName <> B.ClientName OR A.InstanceName <> B.InstanceName OR A.BackupsetName <> B.BackupsetName
			OR A.SubclientName <> B.SubclientName OR A.ClientGroups <> B.ClientGroups
	DELETE  #SurveySubclients
	FROM	cf_SurveySubclients S
	WHERE	#SurveySubclients.CommservUniqueId = S.CommservUniqueId AND #SurveySubclients.AppId = S.AppId
	INSERT INTO cf_SurveySubclients (
			CommservUniqueId, AppId, AppTypeId, ClientName, AgentName, InstanceName, BackupsetName, SubclientName, ClientGroups)
	SELECT	CommservUniqueId, AppId, AppTypeId, ClientName, AgentName, InstanceName, BackupsetName, SubclientName, ClientGroups
	FROM	#SurveySubclients
	DELETE  #SurveyJobStats
	FROM	cf_SurveyJobStats S
	WHERE	#SurveyJobStats.CommservUniqueId = S.CommservUniqueId AND #SurveyJobStats.JobId = S.JobId
	INSERT INTO cf_SurveyJobStats (
			CommservUniqueId, JobId, AppId, OpType, BkpLevel, Status, StartDate, EndDate,
			ScanType, SizeChangePct, TransferTime, ProtectedObjects, FailedObjects, FailedFolders,
			DataProtected, DataCompressed, DataTransferred, DataWritten, ErrorCode, FailureReason,
			StoragePolicy, StoragePolicyID, SchedulePolicy, ScheduleName, Attempts,InitFrom,Phases)
	SELECT	CommservUniqueId, JobId, AppId, OpType, BkpLevel, Status, StartDate, EndDate,
			ScanType, SizeChangePct, TransferTime, ProtectedObjects, FailedObjects, FailedFolders,
			DataProtected, DataCompressed, DataTransferred, DataWritten, ErrorCode, FailureReason,
			StoragePolicy,StoragePolicyID, SchedulePolicy, ScheduleName, Attempts,InitFrom,Phases
	FROM	#SurveyJobStats
	DELETE  #SurveyJobDbSize
	FROM	cf_SurveyJobDbSize S
	WHERE	#SurveyJobDbSize.CommservUniqueId = S.CommservUniqueId AND #SurveyJobDbSize.JobId = S.JobId
	INSERT INTO cf_SurveyJobDbSize (
			CommservUniqueId, JobId, JobEndDate, DbName, DbSize)
	SELECT	CommservUniqueId, JobId, JobEndDate, DbName, DbSize
	FROM	#SurveyJobDbSize
	DELETE  cf_SurveyRunningJobStats
	FROM	#RunningJobStats S
	WHERE	cf_SurveyRunningJobStats.CommservUniqueId = S.CommservUniqueId
	INSERT INTO cf_SurveyRunningJobStats (
			CommservUniqueId ,JobId ,AppId ,OpType ,BkpLevel ,StartDate ,State ,InitFrom)
	SELECT	CommservUniqueId ,JobId ,AppId ,OpType ,BkpLevel ,StartDate ,State ,InitFrom
	FROM	#RunningJobStats
	WHERE JobId>0
	IF (@ProcessSurveyResultTran = 1)
		COMMIT TRANSACTION ProcessSurveyResultTran
  END TRY
  BEGIN CATCH
  
	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	SELECT	@ErrorCode = 1,
		@ErrorString = 'Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' Commserv Unique ID ' + CAST(@CSUniqueId AS VARCHAR(20))
			+ ' Result ID ' + CAST(@ResultId AS VARCHAR(20)) + ' - Parsing failed with error :: ' + ERROR_MESSAGE()
	IF (@ProcessSurveyResultTran = 1)
		ROLLBACK TRANSACTION ProcessSurveyResultTran
  END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId
		IF @isPrintOn = 1 PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
	FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId
END
CLOSE SurveyResultCur
DEALLOCATE SurveyResultCur
SET @ErrorCode = 0
IF object_id('tempdb.dbo.#SurveySubclients') is not null DROP TABLE #SurveySubclients
IF object_id('tempdb.dbo.#SurveyJobStats') is not null DROP TABLE #SurveyJobStats
IF object_id('tempdb.dbo.#SurveyJobDbSize') is not null DROP TABLE #SurveyJobDbSize
IF object_id('tempdb.dbo.#RunningJobStats') is not null DROP TABLE #RunningJobStats
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseJobDetails')
	delete from GxQscripts where name = 'ParseJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseJobDetails')
	delete from GXDBVersions where aliasname = 'ParseJobDetails'
GO

insert into GXDBVersions values(2, 'ParseJobDetails',  '00010011000000000000', 'ParseJobDetails', '00010011000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseLargestClientsByBKPSize.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseLargestClientsByBKPSize.sp,v $ $Id: ParseLargestClientsByBKPSize.sp,v 1.5 2014/10/21 16:08:41 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseLargestClientsByBKPSize <<<'

IF EXISTS (select * from sysobjects where name='ParseLargestClientsByBKPSize')
	drop procedure ParseLargestClientsByBKPSize
IF EXISTS (select * from GxQscripts where name='ParseLargestClientsByBKPSize')
	delete from GxQscripts where name = 'ParseLargestClientsByBKPSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLargestClientsByBKPSize')
	delete from GXDBVersions where aliasname = 'ParseLargestClientsByBKPSize'
GO
print '... Creating Procedure: ParseLargestClientsByBKPSize'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseLargestClientsByBKPSize
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 23
SELECT @ErrorString = 'Largest Clients by Backup Size - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyLargestClientsByBKPSize
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('../@clientGroups', 'NVARCHAR(MAX)'),
		csInfo.n.value('@clientId', 'BIGINT'),
		csInfo.n.value('@clientName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@applicationSizeGB', 'FLOAT'),
		csInfo.n.value('@ShareOfTotal', 'FLOAT'),
		csInfo.n.value('@TotalSizeGB', 'FLOAT')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/LargestClientStatisticsXML/Client') AS csInfo(n)
	--Process Largest FS Clients
	INSERT INTO cf_SurveyLargestNoArchiveFSClients
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@clientGroups', 'NVARCHAR(MAX)'),
		csInfo.n.value('@LargestFSClients', 'INTEGER'),
		csInfo.n.value('@LargestNoArchiveFSClients', 'INTEGER'),
		csInfo.n.value('@TopN', 'INTEGER'),
		0, '', 0, '', 0
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/LargestClientStatisticsXML') AS csInfo(n)
	INSERT INTO cf_SurveyLargestNoArchiveFSClients
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('../@clientGroups', 'NVARCHAR(MAX)'),
		csInfo.n.value('../@LargestFSClients', 'INTEGER'),
		csInfo.n.value('../@LargestNoArchiveFSClients', 'INTEGER'),
		csInfo.n.value('../@TopN', 'INTEGER'),
		csInfo.n.value('@ClientId', 'BIGINT'),
		csInfo.n.value('@ClientName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@AppTypeId', 'BIGINT'),
		csInfo.n.value('@AppTypeName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@AppSizeTB', 'FLOAT')
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/LargestClientStatisticsXML/NoArchiveClients') AS csInfo(n)
	--Process Largest Other Clients
	INSERT INTO cf_SurveyLargestNoSnapClients
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@clientGroups', 'NVARCHAR(MAX)'),
		csInfo.n.value('@LargestAppClients', 'INTEGER'),
		csInfo.n.value('@LargestNoSnapAppClients', 'INTEGER'),
		csInfo.n.value('@AvgRestoreThroughputGBPerHR', 'FLOAT'),
		csInfo.n.value('@TopN', 'INTEGER'),
		0, '', 0, '', 0, 0, 0
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/LargestClientStatisticsXML') AS csInfo(n)
	INSERT INTO cf_SurveyLargestNoSnapClients
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('../@clientGroups', 'NVARCHAR(MAX)'),
		csInfo.n.value('../@LargestAppClients', 'INTEGER'),
		csInfo.n.value('../@LargestNoSnapAppClients', 'INTEGER'),
		csInfo.n.value('../@AvgRestoreThroughputGBPerHR', 'FLOAT'),
		csInfo.n.value('../@TopN', 'INTEGER'),
		csInfo.n.value('@ClientId', 'BIGINT'),
		csInfo.n.value('@ClientName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@AppTypeId', 'BIGINT'),
		csInfo.n.value('@AppTypeName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@AppSizeTB', 'FLOAT'),
		csInfo.n.value('@LastRestoreThroughputGBPerHR', 'FLOAT'),
		csInfo.n.value('@RecoverDurationTimeInSeconds', 'INT')
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/LargestClientStatisticsXML/NoSnapClients') AS csInfo(n)
	--Process Largest Email Clients
	INSERT INTO cf_SurveyLargestNoArcEmailClients
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@clientGroups', 'NVARCHAR(MAX)'),
		csInfo.n.value('@LargestEmailClients', 'INTEGER'),
		csInfo.n.value('@LargestNoArchiveEmailClients', 'INTEGER'),
		csInfo.n.value('@TopN', 'INTEGER'),
		0, '', 0, '', 0, 0
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/LargestClientStatisticsXML') AS csInfo(n)
	INSERT INTO cf_SurveyLargestNoArcEmailClients
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('../@clientGroups', 'NVARCHAR(MAX)'),
		csInfo.n.value('../@LargestEmailClients', 'INTEGER'),
		csInfo.n.value('../@LargestNoArchiveEmailClients', 'INTEGER'),
		csInfo.n.value('../@TopN', 'INTEGER'),
		csInfo.n.value('@ClientId', 'BIGINT'),
		csInfo.n.value('@ClientName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@AppTypeId', 'BIGINT'),
		csInfo.n.value('@AppTypeName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@AppSizeTB', 'FLOAT'),
		csInfo.n.value('@TotalWriteTimeHR', 'FLOAT')
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/LargestClientStatisticsXML/NoArchiveEmailClients') AS csInfo(n)
	--Process CountsBySize
	INSERT INTO cf_SurveyClientCountBySize
	SELECT
		results.CommservSurveyResults_ID,
		csInfo.n.value('@LowerLimitGB', 'BIGINT'),
		csInfo.n.value('@UpperLimitGB', 'BIGINT'),
		csInfo.n.value('@Range', 'VARCHAR(256)'),
		ISNULL(csInfo.n.value('@ClientCount', 'INTEGER'), 0),
		ISNULL(csInfo.n.value('@TotalSizeGB', 'BIGINT'), 0),
		ISNULL(csInfo.n.value('@AverageSizeGB', 'BIGINT'), 0)
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/LargestClientStatisticsXML/CountsBySize') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Largest Clients by Backup Size - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Largest Clients by Backup Size - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseLargestClientsByBKPSize')
	delete from GxQscripts where name = 'ParseLargestClientsByBKPSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLargestClientsByBKPSize')
	delete from GXDBVersions where aliasname = 'ParseLargestClientsByBKPSize'
GO

insert into GXDBVersions values(2, 'ParseLargestClientsByBKPSize',  '00010005000000000000', 'ParseLargestClientsByBKPSize', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseLeastDedupedSubclients.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseLeastDedupedSubclients.sp,v $ $Id: ParseLeastDedupedSubclients.sp,v 1.3 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseLeastDedupedSubclients <<<'

IF EXISTS (select * from sysobjects where name='ParseLeastDedupedSubclients')
	drop procedure ParseLeastDedupedSubclients
IF EXISTS (select * from GxQscripts where name='ParseLeastDedupedSubclients')
	delete from GxQscripts where name = 'ParseLeastDedupedSubclients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLeastDedupedSubclients')
	delete from GXDBVersions where aliasname = 'ParseLeastDedupedSubclients'
GO
print '... Creating Procedure: ParseLeastDedupedSubclients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseLeastDedupedSubclients
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 119
SELECT @ErrorString = 'Parse LeastDedupedSubclients - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyLeastDedupedSubclients (
		SurveyResultId, AppId, Client, Agent, Instance, Backupset, Subclient,
		StoragePolicy, OnFullJobs, AppSize, DataWritten, DedupSavingPct)
	SELECT DISTINCT
		results.CommservSurveyResults_ID,
		csInfo.n.value('@AppId', 'INT'),
		csInfo.n.value('@Client', 'NVARCHAR(256)'),
		csInfo.n.value('@Agent', 'VARCHAR(256)'),
		csInfo.n.value('@Instance', 'NVARCHAR(512)'),
		csInfo.n.value('@Backupset', 'NVARCHAR(128)'),
		csInfo.n.value('@Subclient', 'NVARCHAR(128)'),
		csInfo.n.value('@StoragePolicy', 'NVARCHAR(144)'),
		csInfo.n.value('@OnFullJobs', 'INT'),
		csInfo.n.value('@AppSize', 'BIGINT'),
		csInfo.n.value('@DataWritten', 'BIGINT'),
		csInfo.n.value('@DedupSavingPct', 'FLOAT')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('LeastDedupedSubclients') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Parse LeastDedupedSubclients - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Parse LeastDedupedSubclients - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseLeastDedupedSubclients')
	delete from GxQscripts where name = 'ParseLeastDedupedSubclients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLeastDedupedSubclients')
	delete from GXDBVersions where aliasname = 'ParseLeastDedupedSubclients'
GO

insert into GXDBVersions values(2, 'ParseLeastDedupedSubclients',  '00010003000000000000', 'ParseLeastDedupedSubclients', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseLibraryProp.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseLibraryProp.sp,v $ $Id: ParseLibraryProp.sp,v 1.3 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseLibraryProp <<<'

IF EXISTS (select * from sysobjects where name='ParseLibraryProp')
	drop procedure ParseLibraryProp
IF EXISTS (select * from GxQscripts where name='ParseLibraryProp')
	delete from GxQscripts where name = 'ParseLibraryProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLibraryProp')
	delete from GXDBVersions where aliasname = 'ParseLibraryProp'
GO
print '... Creating Procedure: ParseLibraryProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseLibraryProp
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 93
SELECT @ErrorString = 'Parse Library prop - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyLibraryProp
	SELECT DISTINCT
		results.CommservSurveyResults_ID,
		csInfo.n.value('@LibraryId', 'INT'),
		csInfo.n.value('@LibraryName', 'NVARCHAR(128)'),
		csInfo.n.value('@LibraryEnabled', 'INT'),
		csInfo.n.value('@LibraryTypeId', 'INT'),
		csInfo.n.value('@LowWaterMarkMB', 'INT'),
		csInfo.n.value('@LibraryAttribute', 'INT'),
		csInfo.n.value('@MountTimeoutSec', 'INT'),
		csInfo.n.value('@UnmountTimeoutSec', 'INT'),
		csInfo.n.value('@DefaultMediaTypeName', 'VARCHAR(32)'),
		csInfo.n.value('@UseWithinDaysInSec', 'INT'),
		csInfo.n.value('@DriveCleanIntervalInSec', 'INT'),
		csInfo.n.value('@VMSDirection', 'INT'),
		csInfo.n.value('@CacheMountPeriodInSec', 'INT'),
		csInfo.n.value('@StdAlnMedRetentionTime', 'INT'),
		csInfo.n.value('@TURIntervalInSec', 'INT'),
		csInfo.n.value('@ConfigParams', 'VARCHAR(256)'),
		csInfo.n.value('@StdAlnChkIntervalInSec', 'INT'),
		csInfo.n.value('@ReadRetryIntervalInSec', 'INT'),
		csInfo.n.value('@ReadRetryAttempts', 'INT'),
		csInfo.n.value('@StartVMSElementAddress', 'INT'),
		csInfo.n.value('@ExtendedAttributes', 'INT'),
		csInfo.n.value('@ThresholdPercentage', 'INT'),
		csInfo.n.value('@ThresholdVariation', 'INT'),
		csInfo.n.value('@WarningWaterMark', 'INT'),
		csInfo.n.value('@MaxSwitchForHost', 'INT')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/LibraryAudit/Library') AS csInfo(n)
	INSERT INTO cf_SurveyMountPathProp
	SELECT DISTINCT
		results.CommservSurveyResults_ID,
		csInfo.n.value('@LibraryId', 'INT'),
		csInfo.n.value('@MountPathId', 'INT'),
		csInfo.n.value('@MountPathName', 'NVARCHAR(1024)'),
		csInfo.n.value('@IsEnabled', 'INT'),
		csInfo.n.value('@MaxConcurrentWriters', 'INT'),
		csInfo.n.value('@MaxDataToWriteMB', 'INT'),
		csInfo.n.value('@MagneticSpaceRsrvInMB', 'INT'),
		csInfo.n.value('@Attribute', 'INT'),
		csInfo.n.value('@MagneticChunkFileIncrSizeMB', 'INT'),
		csInfo.n.value('@DeviceEnabled', 'INT')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/LibraryAudit/MountPath') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Parse Library prop - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Parse Library prop - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseLibraryProp')
	delete from GxQscripts where name = 'ParseLibraryProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLibraryProp')
	delete from GXDBVersions where aliasname = 'ParseLibraryProp'
GO

insert into GXDBVersions values(2, 'ParseLibraryProp',  '00010003000000000000', 'ParseLibraryProp', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseLongRunningJobs.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseLongRunningJobs.sp,v $ $Id: ParseLongRunningJobs.sp,v 1.5 2015/02/12 09:01:13 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseLongRunningJobs <<<'

IF EXISTS (select * from sysobjects where name='ParseLongRunningJobs')
	drop procedure ParseLongRunningJobs
IF EXISTS (select * from GxQscripts where name='ParseLongRunningJobs')
	delete from GxQscripts where name = 'ParseLongRunningJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLongRunningJobs')
	delete from GXDBVersions where aliasname = 'ParseLongRunningJobs'
GO
print '... Creating Procedure: ParseLongRunningJobs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseLongRunningJobs
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 24
SELECT @ErrorString = 'Slowest Clients by Long Running Jobs - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	--Process all Long Running Jobs
	INSERT INTO cf_SurveyLongRunningJobs
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('../@clientGroups', 'NVARCHAR(MAX)'),
		csInfo.n.value('@jobId', 'BIGINT'),
		csInfo.n.value('@clientId', 'BIGINT'),
		csInfo.n.value('@clientName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@agentName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@backupType', 'NVARCHAR(25)'),
		csInfo.n.value('@durationHr', 'DECIMAL(8, 2)'),
		csInfo.n.value('@appSizeGB', 'FLOAT'),
		csInfo.n.value('../@TopN', 'INTEGER'),
		ISNULL(csInfo.n.value('../@LongRunningJobs', 'INTEGER'), 0)
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/LongRunJobs/Job') AS csInfo(n)
	--Process FS Full Long Running Jobs
	INSERT INTO cf_SurveyLongRunningFSFullJobs
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@clientGroups', 'NVARCHAR(MAX)'),
		csInfo.n.value('@TopN', 'INTEGER'),
		ISNULL(csInfo.n.value('@LongRunningFSFullJobs', 'INTEGER'), 0),
		ISNULL(csInfo.n.value('@TotalFSSCCount', 'INTEGER'), 0),
		ISNULL(csInfo.n.value('@LongRunningFSSCCount', 'INTEGER'), 0),
		0, 0, '', 0, '', '', 0, 0, 0, '', 0, 0, 0
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/LongRunJobs') AS csInfo(n)
	INSERT INTO cf_SurveyLongRunningFSFullJobs
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('../@clientGroups', 'NVARCHAR(MAX)'),
		csInfo.n.value('../@TopN', 'INTEGER'),
		ISNULL(csInfo.n.value('../@LongRunningFSFullJobs', 'INTEGER'), 0),
		ISNULL(csInfo.n.value('../@TotalFSSCCount', 'INTEGER'), 0),
		ISNULL(csInfo.n.value('../@LongRunningFSSCCount', 'INTEGER'), 0),
		csInfo.n.value('@jobId', 'BIGINT'),
		csInfo.n.value('@clientId', 'BIGINT'),
		csInfo.n.value('@clientName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@agentTypeId', 'BIGINT'),
		csInfo.n.value('@agentName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@backupType', 'NVARCHAR(25)'),
		csInfo.n.value('@durationHr', 'DECIMAL(8, 2)'),
		csInfo.n.value('@actualBKPDurationHr', 'DECIMAL(8, 2)'),
		csInfo.n.value('@appSizeGB', 'FLOAT'),
		csInfo.n.value('@status', 'NVARCHAR(MAX)'),
		csInfo.n.value('@isDeDupEnabled', 'INTEGER'),
		csInfo.n.value('@isSourceDeDupEnabled', 'INTEGER'),
		csInfo.n.value('@isDASHEnabled', 'INTEGER')
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/LongRunJobs/FSFulljobs') AS csInfo(n)
	--Process VSA Full Long Running Jobs
	INSERT INTO cf_SurveyLongRunningVSAFullJobs
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@clientGroups', 'NVARCHAR(MAX)'),
		csInfo.n.value('@TopN', 'INTEGER'),
		ISNULL(csInfo.n.value('@LongRunningVSAFullJobs', 'INTEGER'), 0),
		ISNULL(csInfo.n.value('@TotalVSASCCount', 'INTEGER'), 0),
		ISNULL(csInfo.n.value('@LongRunningVSASCCount', 'INTEGER'), 0),
		0, 0, '', 0, '', '', 0, 0, 0, '', 0, 0, 0, '', 0, ''
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/LongRunJobs') AS csInfo(n)
	INSERT INTO cf_SurveyLongRunningVSAFullJobs
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('../@clientGroups', 'NVARCHAR(MAX)'),
		csInfo.n.value('../@TopN', 'INTEGER'),
		ISNULL(csInfo.n.value('../@LongRunningVSAFullJobs', 'INTEGER'), 0),
		ISNULL(csInfo.n.value('../@TotalVSASCCount', 'INTEGER'), 0),
		ISNULL(csInfo.n.value('../@LongRunningVSASCCount', 'INTEGER'), 0),
		csInfo.n.value('@jobId', 'BIGINT'),
		csInfo.n.value('@clientId', 'BIGINT'),
		csInfo.n.value('@clientName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@agentTypeId', 'BIGINT'),
		csInfo.n.value('@agentName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@backupType', 'NVARCHAR(25)'),
		csInfo.n.value('@durationHr', 'DECIMAL(8, 2)'),
		csInfo.n.value('@actualBKPDurationHr', 'DECIMAL(8, 2)'),
		csInfo.n.value('@appSizeGB', 'FLOAT'),
		csInfo.n.value('@status', 'NVARCHAR(MAX)'),
		csInfo.n.value('@isDeDupEnabled', 'INTEGER'),
		csInfo.n.value('@isSourceDeDupEnabled', 'INTEGER'),
		csInfo.n.value('@isDASHEnabled', 'INTEGER'),
		csInfo.n.value('@hypervisorType', 'NVARCHAR(25)'),
		csInfo.n.value('@isSPEnabled', 'INTEGER'),
		csInfo.n.value('@transportMode', 'NVARCHAR(MAX)')
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/LongRunJobs/VSAjobs') AS csInfo(n)
	--Process Other Application Full Long Running Jobs
	INSERT INTO cf_SurveyLongRunningFullJobs
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@clientGroups', 'NVARCHAR(MAX)'),
		csInfo.n.value('@TopN', 'INTEGER'),
		ISNULL(csInfo.n.value('@LongRunningOtherFullJobs', 'INTEGER'), 0),
		ISNULL(csInfo.n.value('@TotalOtherSCCount', 'INTEGER'), 0),
		ISNULL(csInfo.n.value('@LongRunningOtherSCCount', 'INTEGER'), 0),
		0, 0, '', 0, '', '', 0, 0, 0, '', 0, 0, 0, 0
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/LongRunJobs') AS csInfo(n)
	INSERT INTO cf_SurveyLongRunningFullJobs
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('../@clientGroups', 'NVARCHAR(MAX)'),
		csInfo.n.value('../@TopN', 'INTEGER'),
		ISNULL(csInfo.n.value('../@LongRunningOtherFullJobs', 'INTEGER'), 0),
		ISNULL(csInfo.n.value('../@TotalOtherSCCount', 'INTEGER'), 0),
		ISNULL(csInfo.n.value('../@LongRunningOtherSCCount', 'INTEGER'), 0),
		csInfo.n.value('@jobId', 'BIGINT'),
		csInfo.n.value('@clientId', 'BIGINT'),
		csInfo.n.value('@clientName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@agentTypeId', 'BIGINT'),
		csInfo.n.value('@agentName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@backupType', 'NVARCHAR(25)'),
		csInfo.n.value('@durationHr', 'DECIMAL(8, 2)'),
		csInfo.n.value('@actualBKPDurationHr', 'DECIMAL(8, 2)'),
		csInfo.n.value('@appSizeGB', 'FLOAT'),
		csInfo.n.value('@status', 'NVARCHAR(MAX)'),
		csInfo.n.value('@isDeDupEnabled', 'INTEGER'),
		csInfo.n.value('@isSourceDeDupEnabled', 'INTEGER'),
		csInfo.n.value('@isDASHEnabled', 'INTEGER'),
		csInfo.n.value('@isSPEnabled', 'INTEGER')
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/LongRunJobs/Appjobs') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Slowest Clients by Long Running Jobs - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Slowest Clients by Long Running Jobs - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseLongRunningJobs')
	delete from GxQscripts where name = 'ParseLongRunningJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLongRunningJobs')
	delete from GXDBVersions where aliasname = 'ParseLongRunningJobs'
GO

insert into GXDBVersions values(2, 'ParseLongRunningJobs',  '00010005000000000000', 'ParseLongRunningJobs', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseMailboxQuotaUsage.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseMailboxQuotaUsage.sp,v $ $Id: ParseMailboxQuotaUsage.sp,v 1.6 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseMailboxQuotaUsage <<<'

IF EXISTS (select * from sysobjects where name='ParseMailboxQuotaUsage')
	drop procedure ParseMailboxQuotaUsage
IF EXISTS (select * from GxQscripts where name='ParseMailboxQuotaUsage')
	delete from GxQscripts where name = 'ParseMailboxQuotaUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseMailboxQuotaUsage')
	delete from GXDBVersions where aliasname = 'ParseMailboxQuotaUsage'
GO
print '... Creating Procedure: ParseMailboxQuotaUsage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseMailboxQuotaUsage
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
-------------------------------------------------------------------------------
-- Looping for each result:
--   BULK INSERT from a csv file
--   Set ShredStatus = 3 immediately on error so it will be skipped in future
--   Commit transaction for each result
-- Always return ErrorCode = 0 so parsed results will be set to ShredStatus = 2
-------------------------------------------------------------------------------
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 134
SELECT @ErrorCode = 0
SELECT @ErrorString = 'Mailbox Quota Usage - started'
IF @isPrintOn = 1 PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
IF OBJECT_ID('tempdb..#MailboxQuotaUsage') IS NOT NULL
	DROP TABLE #MailboxQuotaUsage
CREATE TABLE #MailboxQuotaUsage
(
--	SurveyResultId		INT,
	UserGUID			VARCHAR(64),
	UserName			NVARCHAR(MAX),
	QuotaEnabled		INT,
	QuotaSizeMB			BIGINT,
	SpaceConsumed		BIGINT,
	GlobalSpaceConsumed	BIGINT,
	LastUpdateTime		DATETIME
)
DECLARE @CSUniqueId INT = 0
DECLARE @ResultId INT = 0
DECLARE @FileName NVARCHAR(1024)
DECLARE @ProcessSurveyResultTran INT = 0
DECLARE	SurveyResultCur CURSOR FOR
SELECT	F.CommcellIdNameMap_ID, R.CommservSurveyResults_ID, CAST(R.CollectedResults as NVARCHAR(1024))
FROM	cf_CommservSurveyResults AS R INNER JOIN cf_CustomerFeedbackXmlFile AS F
	 ON F.ID = R.CustomerFeedbackXmlFile_ID
	AND F.ParseTime = @parseTime
	AND F.ShredStatus = 1
	AND R.ShredStatus = 1
	AND R.QueryId = @surveyId
ORDER BY R.LogDateUTC
OPEN SurveyResultCur
FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId, @FileName
WHILE @@FETCH_STATUS = 0
BEGIN
	SELECT @ErrorCode = 0
	TRUNCATE TABLE #MailboxQuotaUsage
	DECLARE @sql NVARCHAR(256) = 'BULK INSERT #MailboxQuotaUsage FROM ''' + @FileName + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'' )';
	BEGIN TRY
		EXEC(@sql);
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	IF (XACT_STATE() <> 0)
	BEGIN
		SELECT @ErrorCode = 1
		SELECT @ErrorString = 'MailboxQuotaUsage - BULK INSERT failed with error :: ' + ERROR_MESSAGE()
	END
	END CATCH
	IF @ErrorCode = 0 AND EXISTS (SELECT * FROM #MailboxQuotaUsage)
	BEGIN
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
			INSERT INTO cf_SurveyMailboxQuotaUsage (SurveyResultId,
					UserGUID, UserName, QuotaEnabled, QuotaSizeMB, SpaceConsumed, GlobalSpaceConsumed, LastUpdateTime)
			SELECT	@ResultId,
					UserGUID, UserName, QuotaEnabled, QuotaSizeMB, SpaceConsumed, GlobalSpaceConsumed, LastUpdateTime
			FROM #MailboxQuotaUsage
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		IF (XACT_STATE() <> 0)
		BEGIN
			IF (@ProcessSurveyResultTran = 1)
			BEGIN
				ROLLBACK TRANSACTION ProcessSurveyResultTran
				SET @ProcessSurveyResultTran = 0
			END
			SELECT @ErrorCode = 1
			SELECT @ErrorString = 'MailboxQuotaUsage - INSERT INTO cf_SurveyMailboxQuotaUsage failed with error :: ' + ERROR_MESSAGE()
		END
	END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId
		IF @isPrintOn = 1 PRINT @ErrorString
			INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
		END
	END
	FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId, @FileName
END
CLOSE SurveyResultCur
DEALLOCATE SurveyResultCur
DROP TABLE #MailboxQuotaUsage
SET @ErrorCode = 0
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseMailboxQuotaUsage')
	delete from GxQscripts where name = 'ParseMailboxQuotaUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseMailboxQuotaUsage')
	delete from GXDBVersions where aliasname = 'ParseMailboxQuotaUsage'
GO

insert into GXDBVersions values(2, 'ParseMailboxQuotaUsage',  '00010006000000000000', 'ParseMailboxQuotaUsage', '00010006000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseMediaAgentProp.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseMediaAgentProp.sp,v $ $Id: ParseMediaAgentProp.sp,v 1.4 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseMediaAgentProp <<<'

IF EXISTS (select * from sysobjects where name='ParseMediaAgentProp')
	drop procedure ParseMediaAgentProp
IF EXISTS (select * from GxQscripts where name='ParseMediaAgentProp')
	delete from GxQscripts where name = 'ParseMediaAgentProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseMediaAgentProp')
	delete from GXDBVersions where aliasname = 'ParseMediaAgentProp'
GO
print '... Creating Procedure: ParseMediaAgentProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseMediaAgentProp
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 88
SELECT @ErrorString = 'MediaAgentProp - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyMediaAgentProp
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@MAClientID', 'INT'),
		csInfo.n.value('@MediaAgentName', 'NVARCHAR(256)'),
		csInfo.n.value('@MAReleaseVersion', 'VARCHAR(8)'),
		csInfo.n.value('@MAEnabled', 'INT'),
		csInfo.n.value('@MAAttribute', 'INT'),
		csInfo.n.value('@ScanIntervalInSec', 'INT'),
		csInfo.n.value('@MaxReservations', 'INT'),
		csInfo.n.value('@NwErrorRetryFlag', 'INT'),
		csInfo.n.value('@NwErrorRetryFrequency', 'INT'),
		csInfo.n.value('@NwErrorRetryCount', 'INT'),
		csInfo.n.value('@AccessPathEnabled', 'INT'),
		csInfo.n.value('@UseNetworkShare', 'INT'),
		csInfo.n.value('@AccessPathFlags', 'INT'),
		csInfo.n.value('@IdxCleanupPct', 'INT'),
		csInfo.n.value('@IdxCacheServerClientId', 'INT'),
		csInfo.n.value('@IdxMinFreeSpaceMB', 'INT'),
		csInfo.n.value('@IdxFreeSpaceWarningMB', 'INT'),
		csInfo.n.value('@IdxCacheFlags', 'INT'),
		csInfo.n.value('@IdxPoolIsShared', 'INT'),
		csInfo.n.value('@IdxRetentionDays', 'INT'),
		csInfo.n.value('@FirewallSettings', 'INT'),
		csInfo.n.value('@FwNetworkWithCS', 'INT'),
		csInfo.n.value('@FwConnectionWithCS', 'INT'),
		csInfo.n.value('@FwUseRemoteProxyCS', 'INT'),
		csInfo.n.value('@FwNetworkWithMA', 'INT'),
		csInfo.n.value('@FwConnectionWithMA', 'INT'),
		csInfo.n.value('@FwUseRemoteProxyMA', 'INT'),
		csInfo.n.value('@FwKeepAliveSeconds', 'INT'),
		csInfo.n.value('@FwTunnelInitSeconds', 'INT'),
		csInfo.n.value('@FwForeceSSL', 'INT'),
		csInfo.n.value('@FwLockDown', 'INT'),
		csInfo.n.value('@FwBindOpenPortsOnly', 'INT'),
		csInfo.n.value('@FwIsDMZ', 'INT'),
		csInfo.n.value('@FwIsRoamingClient', 'INT'),
		ISNULL(csInfo.n.value('@FwDefOutgoingProtocol', 'INT'), 0),
		csInfo.n.value('@NwThrottlingEnabled', 'INT'),
		csInfo.n.value('@NwShareBandwidth', 'INT'),
		csInfo.n.value('@NwDaysOfWeek', 'INT'),
		csInfo.n.value('@NwStartTime', 'INT'),
		csInfo.n.value('@NwEndTime', 'INT'),
		csInfo.n.value('@NwIsAbsolute', 'INT'),
		csInfo.n.value('@NwSendEnabled', 'INT'),
		csInfo.n.value('@NwSendRate', 'INT'),
		csInfo.n.value('@NwSendRatePct', 'INT'),
		csInfo.n.value('@NwRecvEnabled', 'INT'),
		csInfo.n.value('@NwRecvRate', 'INT'),
		csInfo.n.value('@NwRecvRatePct', 'INT')
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/MediaAgentProp') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'MediaAgentProp - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'MediaAgentProp - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseMediaAgentProp')
	delete from GxQscripts where name = 'ParseMediaAgentProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseMediaAgentProp')
	delete from GXDBVersions where aliasname = 'ParseMediaAgentProp'
GO

insert into GXDBVersions values(2, 'ParseMediaAgentProp',  '00010004000000000000', 'ParseMediaAgentProp', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseMediaManagementSummary.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseMediaManagementSummary.sp,v $ $Id: ParseMediaManagementSummary.sp,v 1.3 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseMediaManagementSummary <<<'

IF EXISTS (select * from sysobjects where name='ParseMediaManagementSummary')
	drop procedure ParseMediaManagementSummary
IF EXISTS (select * from GxQscripts where name='ParseMediaManagementSummary')
	delete from GxQscripts where name = 'ParseMediaManagementSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseMediaManagementSummary')
	delete from GXDBVersions where aliasname = 'ParseMediaManagementSummary'
GO
print '... Creating Procedure: ParseMediaManagementSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseMediaManagementSummary
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 117
SELECT @ErrorString = 'Parse MediaManagementSummary - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyMediaAgentSummary (
			SurveyResultId, MAClientId, MediaAgentName, Offline, OfflineReason, OfflineTimeStamp, OSName, ReleaseVersion, DataWrittenLastWeek)
	SELECT DISTINCT
			results.CommservSurveyResults_ID,
			csInfo.n.value('@MAClientId', 'INT'),
			csInfo.n.value('@MediaAgentName', 'NVARCHAR(256)'),
			csInfo.n.value('@Offline', 'INT'),
			csInfo.n.value('@OfflineReason', 'INT'),
			csInfo.n.value('@OfflineTimeStamp', 'INT'),
			csInfo.n.value('@OSName', 'VARCHAR(256)'),
			csInfo.n.value('@ReleaseVersion', 'VARCHAR(32)'),
			csInfo.n.value('@DataWrittenLastWeek', 'BIGINT')
	FROM	cf_CommservSurveyResults AS results
			INNER JOIN cf_CustomerFeedbackXmlFile AS files
				ON files.ShredStatus = 1
				AND files.ID = results.CustomerFeedbackXmlFile_ID
				AND results.ShredStatus = 1
				AND results.QueryId = @surveyId
				AND files.ParseTime = @parseTime
	CROSS APPLY results.CollectedResults.nodes('/MediaManagementSummary/MediaAgent') AS csInfo(n)
	INSERT INTO cf_SurveyLibrarySummary (
			SurveyResultId, LibraryId, LibraryName, LibraryTypeId, Offline, OfflineReason, OfflineTimeStamp,
			DataWrittenLastWeek, FreeSpaceMB, LowWaterMark, ScratchPoolsBelowLWM, SpareInLibrary, SpareTotal,
			Manufacturer, Model, SerialNumber, FirmwareRevision, Slots, EmptySlots)
	SELECT DISTINCT
			results.CommservSurveyResults_ID,
			csInfo.n.value('@LibraryId', 'INT'),
			csInfo.n.value('@LibraryName', 'NVARCHAR(128)'),
			csInfo.n.value('@LibraryTypeId', 'INT'),
			csInfo.n.value('@Offline', 'INT'),
			csInfo.n.value('@OfflineReason', 'INT'),
			csInfo.n.value('@OfflineTimeStamp', 'INT'),
			csInfo.n.value('@DataWrittenLastWeek', 'BIGINT'),
			ISNULL(csInfo.n.value('@FreeSpaceMB', 'BIGINT'), -1),
			csInfo.n.value('@LowWaterMark', 'BIGINT'),
			csInfo.n.value('@ScratchPoolsBelowLWM', 'INT'),
			csInfo.n.value('@SpareInLibrary', 'INT'),
			csInfo.n.value('@SpareTotal', 'INT'),
			csInfo.n.value('@Manufacturer', 'VARCHAR(16)'),
			csInfo.n.value('@Model', 'VARCHAR(32)'),
			csInfo.n.value('@SerialNumber', 'VARCHAR(32)'),
			csInfo.n.value('@FirmwareRevision', 'VARCHAR(32)'),
			csInfo.n.value('@Slots', 'INT'),
			csInfo.n.value('@EmptySlots', 'INT')
	FROM	cf_CommservSurveyResults AS results
			INNER JOIN cf_CustomerFeedbackXmlFile AS files
				ON files.ShredStatus = 1
				AND files.ID = results.CustomerFeedbackXmlFile_ID
				AND results.ShredStatus = 1
				AND results.QueryId = @surveyId
				AND files.ParseTime = @parseTime
	CROSS APPLY results.CollectedResults.nodes('/MediaManagementSummary/Library') AS csInfo(n)
	INSERT INTO cf_SurveyLibraryControllerSummary (
			SurveyResultId, MAClientId, LibraryId, ControllerId, ControllerName, Active, Enabled, SCSIAddress)
	SELECT DISTINCT
			results.CommservSurveyResults_ID,
			csInfo.n.value('@MAClientId', 'INT'),
			csInfo.n.value('@LibraryId', 'INT'),
			csInfo.n.value('@ControllerId', 'INT'),
			csInfo.n.value('@ControllerName', 'VARCHAR(144)'),
			csInfo.n.value('@Active', 'INT'),
			csInfo.n.value('@Enabled', 'INT'),
			csInfo.n.value('@SCSIAddress', 'VARCHAR(32)')
	FROM	cf_CommservSurveyResults AS results
			INNER JOIN cf_CustomerFeedbackXmlFile AS files
				ON files.ShredStatus = 1
				AND files.ID = results.CustomerFeedbackXmlFile_ID
				AND results.ShredStatus = 1
				AND results.QueryId = @surveyId
				AND files.ParseTime = @parseTime
	CROSS APPLY results.CollectedResults.nodes('/MediaManagementSummary/LibraryController') AS csInfo(n)
	INSERT INTO cf_SurveyMountPathSummary (
			SurveyResultId, LibraryId, LibraryName, MountPathId, MountPathName, Offline, OfflineReason, OfflineTimeStamp, CostCategory)
	SELECT DISTINCT
			results.CommservSurveyResults_ID,
			csInfo.n.value('@LibraryId', 'INT'),
			csInfo.n.value('@LibraryName', 'NVARCHAR(128)'),
			csInfo.n.value('@MountPathId', 'INT'),
			csInfo.n.value('@MountPathName', 'NVARCHAR(1024)'),
			csInfo.n.value('@Offline', 'INT'),
			csInfo.n.value('@OfflineReason', 'INT'),
			csInfo.n.value('@OfflineTimeStamp', 'INT'),
			csInfo.n.value('@CostCategory', 'NVARCHAR(256)')
	FROM	cf_CommservSurveyResults AS results
			INNER JOIN cf_CustomerFeedbackXmlFile AS files
				ON files.ShredStatus = 1
				AND files.ID = results.CustomerFeedbackXmlFile_ID
				AND results.ShredStatus = 1
				AND results.QueryId = @surveyId
				AND files.ParseTime = @parseTime
	CROSS APPLY results.CollectedResults.nodes('/MediaManagementSummary/MountPath') AS csInfo(n)
	INSERT INTO cf_SurveyDriveSummary (
			SurveyResultId, LibraryId, LibraryName, DriveId, DriveName, Offline, OfflineReason, OfflineTimeStamp,
			RatedThroughputMbps, Manufacturer, Type, Model, SerialNumber, FirmwareRevision, CostCategory)
	SELECT DISTINCT
			results.CommservSurveyResults_ID,
			csInfo.n.value('@LibraryId', 'INT'),
			csInfo.n.value('@LibraryName', 'NVARCHAR(128)'),
			csInfo.n.value('@DriveId', 'INT'),
			csInfo.n.value('@DriveName', 'NVARCHAR(1024)'),
			csInfo.n.value('@Offline', 'INT'),
			csInfo.n.value('@OfflineReason', 'INT'),
			csInfo.n.value('@OfflineTimeStamp', 'INT'),
			csInfo.n.value('@RatedThroughputMbps', 'FLOAT'),
			csInfo.n.value('@Manufacturer', 'VARCHAR(16)'),
			csInfo.n.value('@Type', 'VARCHAR(15)'),
			csInfo.n.value('@Model', 'VARCHAR(32)'),
			csInfo.n.value('@SerialNumber', 'VARCHAR(32)'),
			csInfo.n.value('@FirmwareRevision', 'VARCHAR(32)'),
			csInfo.n.value('@CostCategory', 'NVARCHAR(256)')
	FROM	cf_CommservSurveyResults AS results
			INNER JOIN cf_CustomerFeedbackXmlFile AS files
				ON files.ShredStatus = 1
				AND files.ID = results.CustomerFeedbackXmlFile_ID
				AND results.ShredStatus = 1
				AND results.QueryId = @surveyId
				AND files.ParseTime = @parseTime
	CROSS APPLY results.CollectedResults.nodes('/MediaManagementSummary/Drive') AS csInfo(n)
	INSERT INTO cf_SurveyDriveControllerSummary (
			SurveyResultId, MAClientId, DriveId, ControllerId, ControllerName,
			Active, Enabled, DriveAccessible, OfflineTimeStamp, SCSIAddress)
	SELECT DISTINCT
			results.CommservSurveyResults_ID,
			csInfo.n.value('@MAClientId', 'INT'),
			csInfo.n.value('@DriveId', 'INT'),
			csInfo.n.value('@ControllerId', 'INT'),
			csInfo.n.value('@ControllerName', 'VARCHAR(144)'),
			csInfo.n.value('@Active', 'INT'),
			csInfo.n.value('@Enabled', 'INT'),
			csInfo.n.value('@DriveAccessible', 'INT'),
			csInfo.n.value('@OfflineTimeStamp', 'INT'),
			csInfo.n.value('@SCSIAddress', 'VARCHAR(32)')
	FROM	cf_CommservSurveyResults AS results
			INNER JOIN cf_CustomerFeedbackXmlFile AS files
				ON files.ShredStatus = 1
				AND files.ID = results.CustomerFeedbackXmlFile_ID
				AND results.ShredStatus = 1
				AND results.QueryId = @surveyId
				AND files.ParseTime = @parseTime
	CROSS APPLY results.CollectedResults.nodes('/MediaManagementSummary/DriveController') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Parse MediaManagementSummary - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Parse MediaManagementSummary - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseMediaManagementSummary')
	delete from GxQscripts where name = 'ParseMediaManagementSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseMediaManagementSummary')
	delete from GXDBVersions where aliasname = 'ParseMediaManagementSummary'
GO

insert into GXDBVersions values(2, 'ParseMediaManagementSummary',  '00010003000000000000', 'ParseMediaManagementSummary', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseMonthlyStorageUsage.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseMonthlyStorageUsage.sp,v $ $Id: ParseMonthlyStorageUsage.sp,v 1.10 2015/04/17 15:49:40 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseMonthlyStorageUsage <<<'

IF EXISTS (select * from sysobjects where name='ParseMonthlyStorageUsage')
	drop procedure ParseMonthlyStorageUsage
IF EXISTS (select * from GxQscripts where name='ParseMonthlyStorageUsage')
	delete from GxQscripts where name = 'ParseMonthlyStorageUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseMonthlyStorageUsage')
	delete from GXDBVersions where aliasname = 'ParseMonthlyStorageUsage'
GO
print '... Creating Procedure: ParseMonthlyStorageUsage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseMonthlyStorageUsage
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
-------------------------------------------------------------------------------
-- Looping for each result:
--   Commit transaction for each result
--   Set ShredStatus = 3 immediately on error so it will be skipped in future
-- Always return ErrorCode = 0 so parsed results will be set to ShredStatus = 2
-------------------------------------------------------------------------------
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 136
SELECT @ErrorCode = 0, @ErrorString = 'Parsing results for Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
DECLARE @CSUniqueId INT = 0
DECLARE @ResultId INT = 0
DECLARE	SurveyResultCur CURSOR FOR
SELECT	F.CommcellIdNameMap_ID, R.CommservSurveyResults_ID
FROM	cf_CommservSurveyResults AS R INNER JOIN cf_CustomerFeedbackXmlFile AS F
	 ON F.ID = R.CustomerFeedbackXmlFile_ID
	AND F.ParseTime = @parseTime
	AND F.ShredStatus = 1
	AND R.ShredStatus = 1
	AND R.QueryId = @surveyId
ORDER BY R.LogDateUTC
OPEN SurveyResultCur
FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @ErrorCode = 0
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		ELSE
			SET @ProcessSurveyResultTran = 0
		INSERT INTO cf_SurveyMonthlyChargeback (
			CommservUniqueId, SurveyResultId, StartDate, Type, ClientId, AppId, CopyId,
			FrontEndSize, DataProtected, DataWritten, TotalProtectedApp, TotalDataOnMedia, FrontEndSizeType)
		SELECT
			@CSUniqueId,
			@ResultId,
			ISNULL(csInfo.n.value('@StartDate','DATETIME'), csInfo.n.value('@Month','DATETIME')),
			ISNULL(csInfo.n.value('@Type','INT'), 1),
			csInfo.n.value('@ClientId','INT'),
			csInfo.n.value('@AppId','INT'),
			csInfo.n.value('@CopyId','INT'),
			csInfo.n.value('@FrontEndSize','BIGINT'),
			csInfo.n.value('@DataProtected','BIGINT'),
			csInfo.n.value('@DataWritten','BIGINT'),
			ISNULL(csInfo.n.value('@TotalProtectedApp','BIGINT'), 0),
			ISNULL(csInfo.n.value('@TotalDataOnMedia','BIGINT'), 0),
			csInfo.n.value('@FrontEndSizeType','INT')
		FROM
			cf_CommservSurveyResults
			CROSS APPLY CollectedResults.nodes('MonthlyStorageUsage') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		IF	@@ROWCOUNT = 0
			SELECT	@ErrorCode = 1,
				@ErrorString = 'Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' Commserv Unique ID ' + CAST(@CSUniqueId AS VARCHAR(20))
					+ ' Result ID ' + CAST(@ResultId AS VARCHAR(20)) + ' - No data. Skipped.'
		IF	EXISTS (SELECT * FROM cf_SurveyMonthlyChargeback WHERE SurveyResultId = @ResultId AND FrontEndSizeType IS NULL)
		BEGIN
			UPDATE cf_SurveyMonthlyChargeback
			SET    FrontEndSizeType = CASE WHEN S.AppTypeId IN (45,56,57,58,66,67,68,73,82,83,89,90,124) THEN 1 ELSE 0 END
			FROM   cf_SurveyMonthlyChargeback M INNER JOIN cf_SurveySubclientAssociation S
				ON M.CommservUniqueId = S.CommservUniqueId AND M.appId = S.AppId
				AND M.SurveyResultId = @ResultId AND M.FrontEndSizeType IS NULL
			UPDATE cf_SurveyMonthlyChargeback
			SET    FrontEndSizeType = 0
			WHERE  SurveyResultId = @ResultId AND FrontEndSizeType IS NULL
		END
		IF (@ProcessSurveyResultTran = 1)
			COMMIT TRANSACTION ProcessSurveyResultTran
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		SELECT	@ErrorCode = 1,
				@ErrorString = 'Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' Commserv Unique ID ' + CAST(@CSUniqueId AS VARCHAR(20))
					+ ' Result ID ' + CAST(@ResultId AS VARCHAR(20)) + ' - Parsing failed with error :: ' + ERROR_MESSAGE()
		IF (@ProcessSurveyResultTran = 1)
			ROLLBACK TRANSACTION ProcessSurveyResultTran
	END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId
		IF @isPrintOn = 1 PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
	FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId
END
CLOSE SurveyResultCur
DEALLOCATE SurveyResultCur
SET @ErrorCode = 0
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseMonthlyStorageUsage')
	delete from GxQscripts where name = 'ParseMonthlyStorageUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseMonthlyStorageUsage')
	delete from GXDBVersions where aliasname = 'ParseMonthlyStorageUsage'
GO

insert into GXDBVersions values(2, 'ParseMonthlyStorageUsage',  '00010010000000000000', 'ParseMonthlyStorageUsage', '00010010000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseMostFrequentErrors.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseMostFrequentErrors.sp,v $ $Id: ParseMostFrequentErrors.sp,v 1.2 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseMostFrequentErrors <<<'

IF EXISTS (select * from sysobjects where name='ParseMostFrequentErrors')
	drop procedure ParseMostFrequentErrors
IF EXISTS (select * from GxQscripts where name='ParseMostFrequentErrors')
	delete from GxQscripts where name = 'ParseMostFrequentErrors'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseMostFrequentErrors')
	delete from GXDBVersions where aliasname = 'ParseMostFrequentErrors'
GO
print '... Creating Procedure: ParseMostFrequentErrors'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseMostFrequentErrors
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 30
SELECT @ErrorString = 'Most Frequent Errors - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyMostFrequentErrors
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@errorCode', 'NVARCHAR(50)'),
		csInfo.n.value('@errorDescription', 'NVARCHAR(MAX)'),
		csInfo.n.value('@numberOfJobsAffected', 'INTEGER'),
		csInfo.n.value('@messageId', 'BIGINT')
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/JobManager_TopMostJobErrorsResp/waitingErrorList') AS csInfo(n)
	INSERT INTO cf_SurveyMostFrequentErrors
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@errorCode', 'NVARCHAR(50)'),
		csInfo.n.value('@errorDescription', 'NVARCHAR(MAX)'),
		csInfo.n.value('@numberOfJobsAffected', 'INTEGER'),
		csInfo.n.value('@messageId', 'BIGINT')
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/JobManager_TopMostJobErrorsResp/pendingErrorList') AS csInfo(n)
	INSERT INTO cf_SurveyMostFrequentErrors
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@errorCode', 'NVARCHAR(50)'),
		csInfo.n.value('@errorDescription', 'NVARCHAR(MAX)'),
		csInfo.n.value('@numberOfJobsAffected', 'INTEGER'),
		csInfo.n.value('@messageId', 'BIGINT')
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/JobManager_TopMostJobErrorsResp/failedErrorList') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Most Frequent Errors - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Most Frequent - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseMostFrequentErrors')
	delete from GxQscripts where name = 'ParseMostFrequentErrors'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseMostFrequentErrors')
	delete from GXDBVersions where aliasname = 'ParseMostFrequentErrors'
GO

insert into GXDBVersions values(2, 'ParseMostFrequentErrors',  '00010002000000000000', 'ParseMostFrequentErrors', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseProtectedDataPerAgent.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseProtectedDataPerAgent.sp,v $ $Id: ParseProtectedDataPerAgent.sp,v 1.3 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseProtectedDataPerAgent <<<'

IF EXISTS (select * from sysobjects where name='ParseProtectedDataPerAgent')
	drop procedure ParseProtectedDataPerAgent
IF EXISTS (select * from GxQscripts where name='ParseProtectedDataPerAgent')
	delete from GxQscripts where name = 'ParseProtectedDataPerAgent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseProtectedDataPerAgent')
	delete from GXDBVersions where aliasname = 'ParseProtectedDataPerAgent'
GO
print '... Creating Procedure: ParseProtectedDataPerAgent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseProtectedDataPerAgent
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 54
SELECT @ErrorString = 'ParseProtectedDataPerAgent Statistics - started'
IF @isPrintOn = 1
                PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
                IF (@@TRANCOUNT = 0)
                BEGIN
                                BEGIN TRANSACTION ProcessSurveyResultTran
                                SET @ProcessSurveyResultTran = 1
                END
                INSERT INTO cf_SurveyProtectedDataPerAgent
                SELECT
                                files.CommcellIdNameMap_ID,
                                results.CommservSurveyResults_ID,
                                results.LogDateUTC,
                                results.LogDate,
                                csInfo.n.value('@AgentType', 'NVARCHAR(256)'),
                                csInfo.n.value('@ApplicationSizeMB', 'FLOAT'),
                                csInfo.n.value('@AgentTypeId', 'INT'),
                                ISNULL(csInfo.n.value('@BackupLevel', 'INT'), -1),
                                ISNULL(csInfo.n.value('@JobCount', 'BIGINT'), -1)
                FROM cf_CommservSurveyResults AS results
                                INNER JOIN cf_CustomerFeedbackXmlFile AS files
                                                ON files.ShredStatus = 1
                                                AND files.ID = results.CustomerFeedbackXmlFile_ID
                                                AND results.ShredStatus = 1
                                                AND results.QueryId = @surveyId
                                                AND files.ParseTime = @parseTime
                                CROSS apply results.CollectedResults.nodes('/ProtectedDataPerAgentInfo') AS csInfo(n)
                IF (@ProcessSurveyResultTran = 1)
                BEGIN
                                COMMIT TRANSACTION ProcessSurveyResultTran
                                SET @ProcessSurveyResultTran = 0
                END
                SELECT @ErrorCode = 0
                SELECT @ErrorString = 'Protected Data Per Agent - complete'
                IF @isPrintOn = 1
                                PRINT @ErrorString
                INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
                ROLLBACK TRANSACTION ProcessSurveyResultTran
                SET @ProcessSurveyResultTran = 0
                SELECT @ErrorCode = 1
                SELECT @ErrorString = 'Protected Data Per Agent - failed with error :: ' + ERROR_MESSAGE()
                IF @isPrintOn = 1
                                PRINT @ErrorString
                INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseProtectedDataPerAgent')
	delete from GxQscripts where name = 'ParseProtectedDataPerAgent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseProtectedDataPerAgent')
	delete from GXDBVersions where aliasname = 'ParseProtectedDataPerAgent'
GO

insert into GXDBVersions values(2, 'ParseProtectedDataPerAgent',  '00010003000000000000', 'ParseProtectedDataPerAgent', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseRestoreJobDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseRestoreJobDetails.sp,v $ $Id: ParseRestoreJobDetails.sp,v 1.4 2014/12/05 18:55:58 vmishra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseRestoreJobDetails <<<'

IF EXISTS (select * from sysobjects where name='ParseRestoreJobDetails')
	drop procedure ParseRestoreJobDetails
IF EXISTS (select * from GxQscripts where name='ParseRestoreJobDetails')
	delete from GxQscripts where name = 'ParseRestoreJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseRestoreJobDetails')
	delete from GXDBVersions where aliasname = 'ParseRestoreJobDetails'
GO
print '... Creating Procedure: ParseRestoreJobDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseRestoreJobDetails
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 152
SELECT @ErrorString = 'Parse RestoreJobDetails - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	create table #SurveyRestJobDetails (
		CommservUniqueId INT,
		Jobid INT,
		JobStatus INT,
		SrcClientId INT,
		SrcClientName NVARCHAR(512),
		DestClientId INT,
		DestClientName NVARCHAR(512),
		AppTypeId INT,
		AppType NVARCHAR(512),
		InstanceId INT,
		Instance NVARCHAR(512),
		BkpsetId INT,
		Bkpset NVARCHAR(512),
		StartTime INT,
		EndTime INT,
		Duration INT,
		TotFiles2xfer BIGINT,
		TotSuccess BIGINT,
		SkippedObjects BIGINT,
		FailedObjects BIGINT,
		TotCompMB BIGINT,
		TotUnCompMB BIGINT,
		ErrorCode VARCHAR(32),
		FailedReason NVARCHAR(512),
		UserName NVARCHAR(255),
		JobDescription	NVARCHAR(MAX),
		SrcPhysicalClientName NVARCHAR(512),
		DestPhysicalClientName NVARCHAR(512)
	)
	INSERT INTO #SurveyRestJobDetails (
		CommservUniqueId,
		Jobid,
		JobStatus,
		SrcClientId,
		SrcClientName,
		DestClientId,
		DestClientName,
		AppTypeId,
		AppType,
		InstanceId,
		Instance,
		BkpsetId,
		Bkpset,
		StartTime,
		EndTime,
		Duration,
		TotFiles2xfer,
		TotSuccess,
		SkippedObjects,
		FailedObjects,
		TotCompMB,
		TotUnCompMB,
		ErrorCode,
		FailedReason,
		UserName,
		JobDescription,
		SrcPhysicalClientName,
		DestPhysicalClientName
		)
	SELECT DISTINCT
		results.CommcellIdNameMap_ID,
		csInfo.n.value('@Jobid', 'INT'),
		csInfo.n.value('@JobStatus', 'INT'),
		csInfo.n.value('@SrcClientId', 'INT'),
		csInfo.n.value('@SrcClientName', 'NVARCHAR(512)'),
		csInfo.n.value('@DestClientId', 'INT'),
		csInfo.n.value('@DestClientName', 'NVARCHAR(512)'),
		csInfo.n.value('@AppTypeId', 'INT'),
		csInfo.n.value('@AppType', 'NVARCHAR(512)'),
		csInfo.n.value('@InstanceId', 'INT'),
		csInfo.n.value('@Instance', 'NVARCHAR(512)'),
		csInfo.n.value('@BkpsetId', 'BIGINT'),
		csInfo.n.value('@Bkpset', 'NVARCHAR(512)'),
		csInfo.n.value('@StartTime', 'INT'),
		csInfo.n.value('@EndTime', 'INT'),
		csInfo.n.value('@Duration', 'INT'),
		csInfo.n.value('@TotFiles2xfer', 'BIGINT'),
		csInfo.n.value('@TotSuccess', 'BIGINT'),
		csInfo.n.value('@SkippedObjects', 'BIGINT'),
		csInfo.n.value('@FailedObjects', 'BIGINT'),
		csInfo.n.value('@TotCompMB', 'BIGINT'),
		csInfo.n.value('@TotUnCompMB', 'BIGINT'),
		csInfo.n.value('@ErrorCode', 'VARCHAR(32)'),
		csInfo.n.value('@FailedReason', 'NVARCHAR(512)'),
		csInfo.n.value('@UserName', 'NVARCHAR(255)'),
		csInfo.n.value('@JobDescription', 'NVARCHAR(MAX)'),
		csInfo.n.value('@SrcPhysicalClientName', 'NVARCHAR(512)'),
		csInfo.n.value('@DestPhysicalClientName', 'NVARCHAR(512)')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/RestoreJobStats') AS csInfo(n)
	DELETE  #SurveyRestJobDetails
	FROM	cf_SurveyRestoreJobStats S
	WHERE	#SurveyRestJobDetails.CommservUniqueId = S.CommservUniqueId AND #SurveyRestJobDetails.JobId = S.JobId
	INSERT INTO cf_SurveyRestoreJobStats (
		CommservUniqueId,
		Jobid,
		JobStatus,
		SrcClientId,
		SrcClientName,
		DestClientId,
		DestClientName,
		AppTypeId,
		AppType,
		InstanceId,
		Instance,
		BkpsetId,
		Bkpset,
		StartTime,
		EndTime,
		Duration,
		TotFiles2xfer,
		TotSuccess,
		SkippedObjects,
		FailedObjects,
		TotCompMB,
		TotUnCompMB,
		ErrorCode,
		FailedReason,
		UserName,
		JobDescription,
		SrcPhysicalClientName,
		DestPhysicalClientName
		)
	SELECT
		CommservUniqueId,
		Jobid,
		JobStatus,
		SrcClientId,
		SrcClientName,
		DestClientId,
		DestClientName,
		AppTypeId,
		AppType,
		InstanceId,
		Instance,
		BkpsetId,
		Bkpset,
		StartTime,
		EndTime,
		Duration,
		TotFiles2xfer,
		TotSuccess,
		SkippedObjects,
		FailedObjects,
		TotCompMB,
		TotUnCompMB,
		ErrorCode,
		FailedReason,
		UserName,
		JobDescription,
		SrcPhysicalClientName,
		DestPhysicalClientName
	FROM	#SurveyRestJobDetails
	IF OBJECT_ID('tempdb..#SurveyRestJobDetails') IS NOT NULL
		DROP TABLE #SurveyRestJobDetails
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Parse RestoreJobDetails - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Parse RestoreJobDetails - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
IF OBJECT_ID('tempdb..#SurveyRestJobDetails') IS NOT NULL
	DROP TABLE #SurveyRestJobDetails
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseRestoreJobDetails')
	delete from GxQscripts where name = 'ParseRestoreJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseRestoreJobDetails')
	delete from GXDBVersions where aliasname = 'ParseRestoreJobDetails'
GO

insert into GXDBVersions values(2, 'ParseRestoreJobDetails',  '00010004000000000000', 'ParseRestoreJobDetails', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseRestoreStatus.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseRestoreStatus.sp,v $ $Id: ParseRestoreStatus.sp,v 1.5 2014/12/31 15:26:45 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseRestoreStatus <<<'

IF EXISTS (select * from sysobjects where name='ParseRestoreStatus')
	drop procedure ParseRestoreStatus
IF EXISTS (select * from GxQscripts where name='ParseRestoreStatus')
	delete from GxQscripts where name = 'ParseRestoreStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseRestoreStatus')
	delete from GXDBVersions where aliasname = 'ParseRestoreStatus'
GO
print '... Creating Procedure: ParseRestoreStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseRestoreStatus
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 17
SELECT @ErrorCode = 0, @ErrorString = 'Parsing results for Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
DECLARE @CSUniqueId INT = 0
DECLARE @ResultId INT = 0
DECLARE	SurveyResultCur CURSOR FOR
SELECT	F.CommcellIdNameMap_ID, R.CommservSurveyResults_ID
FROM	cf_CommservSurveyResults AS R INNER JOIN cf_CustomerFeedbackXmlFile AS F
	 ON F.ID = R.CustomerFeedbackXmlFile_ID
	AND F.ParseTime = @parseTime
	AND F.ShredStatus = 1
	AND R.ShredStatus = 1
	AND R.QueryId = @surveyId
ORDER BY R.LogDateUTC
OPEN SurveyResultCur
FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @ErrorCode = 0
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		ELSE
			SET @ProcessSurveyResultTran = 0
		INSERT INTO cf_SurveyRestoreClientStats (
			SurveyResultId, ClientGroups, SuccessfulClients, SuccAfterFailClients, FailedClients)
		SELECT
			@ResultId,
			csInfo.n.value('@ClientGroups', 'NVARCHAR(MAX)'),
			csInfo.n.value('@SuccessfulClients', 'INT'),
			csInfo.n.value('@SuccAfterFailClients', 'INT'),
			csInfo.n.value('@FailedClients', 'INT')
		FROM
			cf_CommservSurveyResults
			CROSS apply CollectedResults.nodes('/RestoreStats') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		INSERT INTO cf_SurveyRestoreFailures (
			SurveyResultId, ClientId, Client, Agent, Instance, Backupset,
			ErrorCode, LastRestoreJobId, LastJobStatus, LastJobEndTime, ClientOwners)
		SELECT
			@ResultId,
			csInfo.n.value('@ClientId', 'INT'),
			csInfo.n.value('@Client', 'NVARCHAR(256)'),
			csInfo.n.value('@Agent', 'NVARCHAR(256)'),
			csInfo.n.value('@Instance', 'NVARCHAR(256)'),
			csInfo.n.value('@Backupset', 'NVARCHAR(256)'),
			csInfo.n.value('@ErrorCode', 'VARCHAR(MAX)'),
			csInfo.n.value('@LastRestoreJobId', 'INT'),
			csInfo.n.value('@LastJobStatus', 'NVARCHAR(32)'),
			csInfo.n.value('@LastJobEndTime', 'DATETIME'),
			csInfo.n.value('@ClientOwners', 'NVARCHAR(MAX)')
		FROM
			cf_CommservSurveyResults
			CROSS apply CollectedResults.nodes('/RestoreStats/FailedRestore') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		INSERT INTO cf_SurveyRestoreErrorStats (
			SurveyResultId, ErrorCode, Frequency, Message)
		SELECT
			@ResultId,
			csInfo.n.value('@ErrorCode', 'VARCHAR(32)'),
			csInfo.n.value('@Frequency', 'INT'),
			csInfo.n.value('@Message', 'NVARCHAR(MAX)')
		FROM
			cf_CommservSurveyResults
			CROSS apply CollectedResults.nodes('/RestoreStats/ErrorStats') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		IF (@ProcessSurveyResultTran = 1)
			COMMIT TRANSACTION ProcessSurveyResultTran
	END TRY
	BEGIN CATCH
	
	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		SELECT	@ErrorCode = 1,
				@ErrorString = 'Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' Commserv Unique ID ' + CAST(@CSUniqueId AS VARCHAR(20))
					+ ' Result ID ' + CAST(@ResultId AS VARCHAR(20)) + ' - Parsing failed with error :: ' + ERROR_MESSAGE()
		IF (@ProcessSurveyResultTran = 1)
			ROLLBACK TRANSACTION ProcessSurveyResultTran
	END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId
		IF @isPrintOn = 1 PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
	FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId
END
CLOSE SurveyResultCur
DEALLOCATE SurveyResultCur
SET @ErrorCode = 0
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseRestoreStatus')
	delete from GxQscripts where name = 'ParseRestoreStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseRestoreStatus')
	delete from GXDBVersions where aliasname = 'ParseRestoreStatus'
GO

insert into GXDBVersions values(2, 'ParseRestoreStatus',  '00010005000000000000', 'ParseRestoreStatus', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseRoyaltyStats.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseRoyaltyStats.sp,v $ $Id: ParseRoyaltyStats.sp,v 1.3 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseRoyaltyStats <<<'

IF EXISTS (select * from sysobjects where name='ParseRoyaltyStats')
	drop procedure ParseRoyaltyStats
IF EXISTS (select * from GxQscripts where name='ParseRoyaltyStats')
	delete from GxQscripts where name = 'ParseRoyaltyStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseRoyaltyStats')
	delete from GXDBVersions where aliasname = 'ParseRoyaltyStats'
GO
print '... Creating Procedure: ParseRoyaltyStats'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseRoyaltyStats
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 92
SELECT @ErrorString = 'Royalty Stats - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyRoyaltyStats
	SELECT
		results.CommservSurveyResults_ID,
		csInfo.n.value('@ClientId', 'INT'),
		csInfo.n.value('@ClientName', 'NVARCHAR(256)'),
		csInfo.n.value('@IsVM', 'INT'),
		csInfo.n.value('@HasFSAgent', 'INT'),
		csInfo.n.value('@IsOneTouch', 'INT')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/RoyaltyStats') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Royalty Stats - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Royalty Stats - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseRoyaltyStats')
	delete from GxQscripts where name = 'ParseRoyaltyStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseRoyaltyStats')
	delete from GXDBVersions where aliasname = 'ParseRoyaltyStats'
GO

insert into GXDBVersions values(2, 'ParseRoyaltyStats',  '00010003000000000000', 'ParseRoyaltyStats', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseScalereportCommcellStatusSurvey.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseScalereportCommcellStatusSurvey.sp,v $ $Id: ParseScalereportCommcellStatusSurvey.sp,v 1.2 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseScalereportCommcellStatusSurvey <<<'

IF EXISTS (select * from sysobjects where name='ParseScalereportCommcellStatusSurvey')
	drop procedure ParseScalereportCommcellStatusSurvey
IF EXISTS (select * from GxQscripts where name='ParseScalereportCommcellStatusSurvey')
	delete from GxQscripts where name = 'ParseScalereportCommcellStatusSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseScalereportCommcellStatusSurvey')
	delete from GXDBVersions where aliasname = 'ParseScalereportCommcellStatusSurvey'
GO
print '... Creating Procedure: ParseScalereportCommcellStatusSurvey'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseScalereportCommcellStatusSurvey
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 7
SELECT @ErrorString = 'Scale Report - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyScaleReportInfo
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@Query', 'VARCHAR(MAX)'),
		csInfo.n.value('@LastHour', 'FLOAT'),
		csInfo.n.value('@Last24Hours', 'FLOAT'),
		csInfo.n.value('@Unit', 'VARCHAR(MAX)')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/ScaleReport/ScaleReportCommcellStatusXML') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Scale Report - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Scale Report - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseScalereportCommcellStatusSurvey')
	delete from GxQscripts where name = 'ParseScalereportCommcellStatusSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseScalereportCommcellStatusSurvey')
	delete from GXDBVersions where aliasname = 'ParseScalereportCommcellStatusSurvey'
GO

insert into GXDBVersions values(2, 'ParseScalereportCommcellStatusSurvey',  '00010002000000000000', 'ParseScalereportCommcellStatusSurvey', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseSchedulePolicyUsage.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseSchedulePolicyUsage.sp,v $ $Id: ParseSchedulePolicyUsage.sp,v 1.2 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseSchedulePolicyUsage <<<'

IF EXISTS (select * from sysobjects where name='ParseSchedulePolicyUsage')
	drop procedure ParseSchedulePolicyUsage
IF EXISTS (select * from GxQscripts where name='ParseSchedulePolicyUsage')
	delete from GxQscripts where name = 'ParseSchedulePolicyUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseSchedulePolicyUsage')
	delete from GXDBVersions where aliasname = 'ParseSchedulePolicyUsage'
GO
print '... Creating Procedure: ParseSchedulePolicyUsage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseSchedulePolicyUsage
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 22
SELECT @ErrorString = 'Schedule Policy Usage Statistics - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	--Delete old last entry
	--DELETE a FROM cf_SurveySchedulePolicyUsage AS a
	--	INNER JOIN cf_CommservSurveyResults AS b
	--		ON a.SurveyResultId = b.CommservSurveyResults_ID
	--		AND a.LogDateUTC = b.LogDateUTC
	--		AND a.CommServUniqueId IN (SELECT DISTINCT CommcellIdNameMap_ID FROM cf_CustomerFeedbackXmlFile WHERE ShredStatus = 1 AND ParseTime = @parseTime)
	--		AND b.Flags = 1
	INSERT INTO cf_SurveySchedulePolicyUsage
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@policyId', 'BIGINT'),
		csInfo.n.value('@policyName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@beingUsed', 'INTEGER')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/Sch_policy') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Schedule Policy Usage Statistics - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Schedule Policy Usage Statistics - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseSchedulePolicyUsage')
	delete from GxQscripts where name = 'ParseSchedulePolicyUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseSchedulePolicyUsage')
	delete from GXDBVersions where aliasname = 'ParseSchedulePolicyUsage'
GO

insert into GXDBVersions values(2, 'ParseSchedulePolicyUsage',  '00010002000000000000', 'ParseSchedulePolicyUsage', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseScheduledJobDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseScheduledJobDetails.sp,v $ $Id: ParseScheduledJobDetails.sp,v 1.3 2015/04/28 11:36:21 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseScheduledJobDetails <<<'

IF EXISTS (select * from sysobjects where name='ParseScheduledJobDetails')
	drop procedure ParseScheduledJobDetails
IF EXISTS (select * from GxQscripts where name='ParseScheduledJobDetails')
	delete from GxQscripts where name = 'ParseScheduledJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseScheduledJobDetails')
	delete from GXDBVersions where aliasname = 'ParseScheduledJobDetails'
GO
print '... Creating Procedure: ParseScheduledJobDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseScheduledJobDetails
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 165
SELECT @ErrorString = 'Scheduled job details - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyScheduledJobDetails(CommServUniqueId, SurveyResultId, DailySchJobCount, DailySchJobComputedtime)
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		ISNULL(csInfo.n.value('@DailySchJobCount', 'INTEGER'), 0),
		ISNULL(csInfo.n.value('@DailySchJobComputedtime', 'INTEGER'), 0)
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/ScheduledJobDetails') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Scheduled job details - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH
IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Scheduled job details - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseScheduledJobDetails')
	delete from GxQscripts where name = 'ParseScheduledJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseScheduledJobDetails')
	delete from GXDBVersions where aliasname = 'ParseScheduledJobDetails'
GO

insert into GXDBVersions values(2, 'ParseScheduledJobDetails',  '00010003000000000000', 'ParseScheduledJobDetails', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseSlowestClients.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseSlowestClients.sp,v $ $Id: ParseSlowestClients.sp,v 1.3 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseSlowestClients <<<'

IF EXISTS (select * from sysobjects where name='ParseSlowestClients')
	drop procedure ParseSlowestClients
IF EXISTS (select * from GxQscripts where name='ParseSlowestClients')
	delete from GxQscripts where name = 'ParseSlowestClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseSlowestClients')
	delete from GXDBVersions where aliasname = 'ParseSlowestClients'
GO
print '... Creating Procedure: ParseSlowestClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseSlowestClients
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 44
SELECT @ErrorString = 'Continuous Slowest Clients - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveySlowestClients(commservuniqueid,surveyresultid,LogDateUTC,LogDate,ClientId,ClientName,ThroughputMBS,NumberOfJobs,AppSize)
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@clientId', 'BIGINT'),
		csInfo.n.value('@clientName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@ThroughputMBS', 'DECIMAL(20,2)'),
		csInfo.n.value('@NumberOfJobs', 'INTEGER'),
		ISNULL(csInfo.n.value('@appsize', 'BIGINT'), 0)
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/SlowestClients/Client') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Continuous Failed Clients - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Continuous Slowest Clients - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseSlowestClients')
	delete from GxQscripts where name = 'ParseSlowestClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseSlowestClients')
	delete from GXDBVersions where aliasname = 'ParseSlowestClients'
GO

insert into GXDBVersions values(2, 'ParseSlowestClients',  '00010003000000000000', 'ParseSlowestClients', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseSnapshotEngineSurvey.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseSnapshotEngineSurvey.sp,v $ $Id: ParseSnapshotEngineSurvey.sp,v 1.4 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseSnapshotEngineSurvey <<<'

IF EXISTS (select * from sysobjects where name='ParseSnapshotEngineSurvey')
	drop procedure ParseSnapshotEngineSurvey
IF EXISTS (select * from GxQscripts where name='ParseSnapshotEngineSurvey')
	delete from GxQscripts where name = 'ParseSnapshotEngineSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseSnapshotEngineSurvey')
	delete from GXDBVersions where aliasname = 'ParseSnapshotEngineSurvey'
GO
print '... Creating Procedure: ParseSnapshotEngineSurvey'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseSnapshotEngineSurvey
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 4
SELECT @ErrorString = 'Snapshot Engine Usage - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		INSERT INTO cf_Survey4SnapInfo(SurveyResultId,appTypeId,appTypeName,AppGroup,snapEngineId,snapEngineName,commCellId,commCellName,LicCapacityType,SubClients,SnapCounts,SnapSize)
SELECT
results.CommservSurveyResults_ID,
SnapEngineUsage.value('@appTypeId'		, 'INT'),
ISNULL(SnapEngineUsage.value('@appTypeName'		, '[NVARCHAR](MAX)'),''),
ISNULL(SnapEngineUsage.value('@appGroup'		, '[NVARCHAR](MAX)'),''),
SnapEngineUsage.value('@snapEngineId'		, 'INT'),
ISNULL(SnapEngineUsage.value('@snapEngineName'		, '[NVARCHAR](MAX)'),''),
SnapEngineUsage.value('@commCellId'		, 'INT'),
ISNULL(SnapEngineUsage.value('@commCellName'	, '[NVARCHAR](MAX)'),''),
ISNULL(SnapEngineUsage.value('@LicCapacityType'	, '[NVARCHAR](MAX)'),''),
ISNULL(SnapEngineUsage.value('@totalSubClients'	, 'INT'),0),
ISNULL(SnapEngineUsage.value('@totalSnapCount'	, 'INT'),0),
ISNULL(SnapEngineUsage.value('@totalSnapSize'	, 'BIGINT'),0)
FROM
cf_CommservSurveyResults AS results
INNER JOIN cf_CustomerFeedbackXmlFile AS files
ON files.ShredStatus = 1
AND files.ID = results.CustomerFeedbackXmlFile_ID
AND results.ShredStatus = 1
AND results.QueryId = @surveyId
AND files.ParseTime = @parseTime
CROSS apply results.CollectedResults.nodes('SnapEngineXML') AS SnapEngineXML(SnapEngineXML)
CROSS apply SnapEngineXML.nodes('SnapEngineUsage') AS SnapEngineUsage(SnapEngineUsage)
		IF (@ProcessSurveyResultTran = 1)
		BEGIN
			COMMIT TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 0
		END
		SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Snapshot Engine Usage - complete'
		IF @isPrintOn = 1
			PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
		BEGIN
		ROLLBACK TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
		SELECT @ErrorCode = 1
		SELECT @ErrorString = 'Snapshot Engine Usage - failed with error :: ' + ERROR_MESSAGE()
		IF @isPrintOn = 1
			PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
		END
	END CATCH
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseSnapshotEngineSurvey')
	delete from GxQscripts where name = 'ParseSnapshotEngineSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseSnapshotEngineSurvey')
	delete from GXDBVersions where aliasname = 'ParseSnapshotEngineSurvey'
GO

insert into GXDBVersions values(2, 'ParseSnapshotEngineSurvey',  '00010004000000000000', 'ParseSnapshotEngineSurvey', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCloudNodeInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCloudNodeInfo.sp,v $ $Id: ParseCloudNodeInfo.sp,v 1.4 2014/11/11 20:51:46 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseCloudNodeInfo <<<'

IF EXISTS (select * from sysobjects where name='ParseCloudNodeInfo')
	drop procedure ParseCloudNodeInfo
IF EXISTS (select * from GxQscripts where name='ParseCloudNodeInfo')
	delete from GxQscripts where name = 'ParseCloudNodeInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCloudNodeInfo')
	delete from GXDBVersions where aliasname = 'ParseCloudNodeInfo'
GO
print '... Creating Procedure: ParseCloudNodeInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseCloudNodeInfo
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 161
SELECT @ErrorString = 'CloudNodeInfo - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyCloudNodeInfo(SurveyResultId,CloudName,NodeName,SegmentCount,TermIndexFileSizeMB,DocumentCount,FreeSpaceMB,IndexSizeMB,DocMaxCriticalLimit,DocMaxWarningLimit)
	SELECT
		results.CommservSurveyResults_ID,
		csInfo.n.value('@CloudName', 'NVARCHAR (MAX)'),
		csInfo.n.value('@NodeName', 'NVARCHAR (MAX)'),
		csInfo.n.value('@SegmentCount', 'int'),
		csInfo.n.value('@TermIndexFileSizeMB', 'BIGINT'),
		csInfo.n.value('@DocumentCount', 'int'),
		csInfo.n.value('@FreeSpaceMB', 'BIGINT'),
		csInfo.n.value('@IndexSizeMB', 'BIGINT'),
		ISNULL(csInfo.n.value('@DocMaxCriticalLimit', 'BIGINT'),30000000),
		ISNULL(csInfo.n.value('@DocMaxWarningLimit', 'BIGINT'),20000000)
	FROM cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
			CROSS apply results.CollectedResults.nodes('CloudInfoXML') AS CloudInfoXML(CloudInfoXML)
			CROSS apply CloudInfoXML.nodes('CloudNodeInfo') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'CloudNodeInfo - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'CloudNodeInfo - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCloudNodeInfo')
	delete from GxQscripts where name = 'ParseCloudNodeInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCloudNodeInfo')
	delete from GXDBVersions where aliasname = 'ParseCloudNodeInfo'
GO

insert into GXDBVersions values(2, 'ParseCloudNodeInfo',  '00010004000000000000', 'ParseCloudNodeInfo', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseSubclientConfig.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseSubclientConfig.sp,v $ $Id: ParseSubclientConfig.sp,v 1.9 2015/07/10 18:40:22 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseSubclientConfig <<<'

IF EXISTS (select * from sysobjects where name='ParseSubclientConfig')
	drop procedure ParseSubclientConfig
IF EXISTS (select * from GxQscripts where name='ParseSubclientConfig')
	delete from GxQscripts where name = 'ParseSubclientConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseSubclientConfig')
	delete from GXDBVersions where aliasname = 'ParseSubclientConfig'
GO
print '... Creating Procedure: ParseSubclientConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseSubclientConfig
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
-------------------------------------------------------------------------------
-- Looping for each result:
--   Commit transaction for each result
--   Set ShredStatus = 3 immediately on error so it will be skipped in future
-- Always return ErrorCode = 0 so parsed results will be set to ShredStatus = 2
-------------------------------------------------------------------------------
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 145
SELECT @ErrorCode = 0, @ErrorString = 'Parsing results for Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
CREATE TABLE #SubclientAssociation
(
	ClientId			INT,
	ClientName			NVARCHAR(256),
	AppTypeId			INT,
	AgentName			VARCHAR(256),
	InstanceId			INT,
	InstanceName		NVARCHAR(512),
	BackupsetId			INT,
	BackupsetName		NVARCHAR(128),
	AppId				INT,
	SubclientName		NVARCHAR(128),
	SubclientStatus		INT,
	DataPolicyId		INT,
	LogPolicyId			INT,
	SubclientPolicyAppId INT,
	PhysicalClientName  NVARCHAR(256),
	BackupDisabled		INT,
	FilterFlags			INT,
	Archive1PassFlags	INT
)
DECLARE @CSUniqueId INT = 0
DECLARE @ResultId INT = 0
DECLARE	SurveyResultCur CURSOR FOR
SELECT	F.CommcellIdNameMap_ID, R.CommservSurveyResults_ID
FROM	cf_CommservSurveyResults AS R INNER JOIN cf_CustomerFeedbackXmlFile AS F
	 ON F.ID = R.CustomerFeedbackXmlFile_ID
	AND F.ParseTime = @parseTime
	AND F.ShredStatus = 1
	AND R.ShredStatus = 1
	AND R.QueryId = @surveyId
ORDER BY R.LogDateUTC
OPEN SurveyResultCur
FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @ErrorCode = 0
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		ELSE
			SET @ProcessSurveyResultTran = 0
		TRUNCATE TABLE #SubclientAssociation
		INSERT INTO #SubclientAssociation (
			ClientId, ClientName, AppTypeId, AgentName, InstanceId, InstanceName, BackupsetId, BackupsetName, AppId, SubclientName,
			SubclientStatus, DataPolicyId, LogPolicyId, SubclientPolicyAppId, PhysicalClientName, BackupDisabled, FilterFlags, Archive1PassFlags)
		SELECT
			csInfo.n.value('@clientId','INT'),
			csInfo.n.value('@clientName','NVARCHAR(256)'),
			csInfo.n.value('@appTypeId','INT'),
			csInfo.n.value('@agentName','VARCHAR(256)'),
			ISNULL(csInfo.n.value('@instanceId','INT'), 0),
			ISNULL(csInfo.n.value('@instanceName','NVARCHAR(512)'), ''),
			ISNULL(csInfo.n.value('@backupsetId','INT'), 0),
			ISNULL(csInfo.n.value('@backupsetName','NVARCHAR(128)'), ''),
			ISNULL(csInfo.n.value('@appId','INT'), 0),
			ISNULL(csInfo.n.value('@subclientName','NVARCHAR(128)'), ''),
			ISNULL(csInfo.n.value('@subclientStatus','INT'), 0),
			ISNULL(csInfo.n.value('@dataPolicyId','INT'), 0),
			ISNULL(csInfo.n.value('@logPolicyId','INT'), 0),
			ISNULL(csInfo.n.value('@subclientPolicyAppId','INT'), 0),
			csInfo.n.value('@physicalClientName','NVARCHAR(256)'),
			ISNULL(csInfo.n.value('@backupDisabled','INT'), 0),
			ISNULL(csInfo.n.value('@filterFlags','INT'), 0),
			ISNULL(csInfo.n.value('@archive1PassFlags','INT'), 0)
		FROM
			cf_CommservSurveyResults
			CROSS APPLY CollectedResults.nodes('Subclient') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		DELETE	cf_SurveySubclientAssociation
		FROM	cf_SurveySubclientAssociation S INNER JOIN #SubclientAssociation T
			 ON S.CommservUniqueId = @CSUniqueId AND S.ClientId = T.ClientId AND S.AppId = T.AppId
		UPDATE	cf_SurveySubclientAssociation SET Deleted = 1
		WHERE	CommservUniqueId = @CSUniqueId AND Deleted = 0
		INSERT INTO cf_SurveySubclientAssociation (
				CommservUniqueId, ClientId, ClientName, AppTypeId, AgentName, InstanceId, InstanceName, BackupsetId, BackupsetName, AppId, SubclientName,
				SubclientStatus, DataPolicyId, LogPolicyId, SubclientPolicyAppId, Deleted, PhysicalClientName, BackupDisabled, FilterFlags, Archive1PassFlags)
		SELECT	@CSUniqueId, ClientId, ClientName, AppTypeId, AgentName, InstanceId, InstanceName, BackupsetId, BackupsetName, AppId, SubclientName,
				SubclientStatus, DataPolicyId, LogPolicyId, SubclientPolicyAppId, 0, PhysicalClientName, BackupDisabled, FilterFlags, Archive1PassFlags
		FROM	#SubclientAssociation
		IF (@ProcessSurveyResultTran = 1)
			COMMIT TRANSACTION ProcessSurveyResultTran
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		SELECT	@ErrorCode = 1,
				@ErrorString = 'Query ID ' + CAST(@surveyId AS VARCHAR(20))
					+ ' - Parsing failed for Result ID ' + CAST(@ResultId AS VARCHAR(20)) + ' with error :: ' + ERROR_MESSAGE()
		IF (@ProcessSurveyResultTran = 1)
			ROLLBACK TRANSACTION ProcessSurveyResultTran
	END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId
		IF @isPrintOn = 1 PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
	FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId
END
CLOSE SurveyResultCur
DEALLOCATE SurveyResultCur
SET @ErrorCode = 0
DROP TABLE #SubclientAssociation
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseSubclientConfig')
	delete from GxQscripts where name = 'ParseSubclientConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseSubclientConfig')
	delete from GXDBVersions where aliasname = 'ParseSubclientConfig'
GO

insert into GXDBVersions values(2, 'ParseSubclientConfig',  '00010009000000000000', 'ParseSubclientConfig', '00010009000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseSubclientContents.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseSubclientContents.sp,v $ $Id: ParseSubclientContents.sp,v 1.4 2015/02/27 21:09:49 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseSubclientContents <<<'

IF EXISTS (select * from sysobjects where name='ParseSubclientContents')
	drop procedure ParseSubclientContents
IF EXISTS (select * from GxQscripts where name='ParseSubclientContents')
	delete from GxQscripts where name = 'ParseSubclientContents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseSubclientContents')
	delete from GXDBVersions where aliasname = 'ParseSubclientContents'
GO
print '... Creating Procedure: ParseSubclientContents'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseSubclientContents
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
-------------------------------------------------------------------------------
-- Looping for each result:
--   Commit transaction for each result
--   Set ShredStatus = 3 immediately on error so it will be skipped in future
-- Always return ErrorCode = 0 so parsed results will be set to ShredStatus = 2
-------------------------------------------------------------------------------
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 154
SELECT @ErrorCode = 0, @ErrorString = 'Parsing results for Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
DECLARE @CSUniqueId INT = 0
DECLARE @ResultId INT = 0
DECLARE	SurveyResultCur CURSOR FOR
SELECT	F.CommcellIdNameMap_ID, R.CommservSurveyResults_ID
FROM	cf_CommservSurveyResults AS R INNER JOIN cf_CustomerFeedbackXmlFile AS F
	 ON F.ID = R.CustomerFeedbackXmlFile_ID
	AND F.ParseTime = @parseTime
	AND F.ShredStatus = 1
	AND R.ShredStatus = 1
	AND R.QueryId = @surveyId
ORDER BY R.LogDateUTC
OPEN SurveyResultCur
FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @ErrorCode = 0
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		ELSE
			SET @ProcessSurveyResultTran = 0
		DELETE cf_SurveySubclientContent WHERE CommservUniqueId = @CSUniqueId
		INSERT INTO cf_SurveySubclientContent (
			CommservUniqueId, AppId, Type, Content, Created)
		SELECT
			@CSUniqueId,
			csInfo.n.value('@appId','INT'),
			csInfo.n.value('@type','INT'),
			csInfo.n.value('@content','NVARCHAR(MAX)'),
			csInfo.n.value('@created','INT')
		FROM
			cf_CommservSurveyResults
			CROSS APPLY CollectedResults.nodes('Content') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		DELETE cf_SurveyGlobalFilters WHERE CommservUniqueId = @CSUniqueId
		INSERT INTO cf_SurveyGlobalFilters (
			CommservUniqueId, name, value)
		SELECT
			@CSUniqueId,
			csInfo.n.value('@name','NVARCHAR(64)'),
			csInfo.n.value('@value','NVARCHAR(MAX)')
		FROM
			cf_CommservSurveyResults
			CROSS APPLY CollectedResults.nodes('GlobalFilter') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		IF (@ProcessSurveyResultTran = 1)
			COMMIT TRANSACTION ProcessSurveyResultTran
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		SELECT	@ErrorCode = 1,
				@ErrorString = 'Query ID ' + CAST(@surveyId AS VARCHAR(20))
					+ ' - Parsing failed for Result ID ' + CAST(@ResultId AS VARCHAR(20)) + ' with error :: ' + ERROR_MESSAGE()
		IF (@ProcessSurveyResultTran = 1)
			ROLLBACK TRANSACTION ProcessSurveyResultTran
	END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId
		IF @isPrintOn = 1 PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
	FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId
END
CLOSE SurveyResultCur
DEALLOCATE SurveyResultCur
SET @ErrorCode = 0
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseSubclientContents')
	delete from GxQscripts where name = 'ParseSubclientContents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseSubclientContents')
	delete from GXDBVersions where aliasname = 'ParseSubclientContents'
GO

insert into GXDBVersions values(2, 'ParseSubclientContents',  '00010004000000000000', 'ParseSubclientContents', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseUnprotectedClients.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseUnprotectedClients.sp,v $ $Id: ParseUnprotectedClients.sp,v 1.7 2015/06/11 13:55:56 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseUnprotectedClients <<<'

IF EXISTS (select * from sysobjects where name='ParseUnprotectedClients')
	drop procedure ParseUnprotectedClients
IF EXISTS (select * from GxQscripts where name='ParseUnprotectedClients')
	delete from GxQscripts where name = 'ParseUnprotectedClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseUnprotectedClients')
	delete from GXDBVersions where aliasname = 'ParseUnprotectedClients'
GO
print '... Creating Procedure: ParseUnprotectedClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseUnprotectedClients
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
-------------------------------------------------------------------------------
-- Looping for each result:
--   Commit transaction for each result
--   Set ShredStatus = 3 immediately on error so it will be skipped in future
-- Always return ErrorCode = 0 so parsed results will be set to ShredStatus = 2
-------------------------------------------------------------------------------
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 27
SELECT @ErrorCode = 0, @ErrorString = 'Parsing results for Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
DECLARE @CSUniqueId INT = 0
DECLARE @ResultId INT = 0
DECLARE @LogDateUTC datetime
DECLARE @LogDate    datetime
DECLARE	SurveyResultCur CURSOR FOR
SELECT	F.CommcellIdNameMap_ID, R.CommservSurveyResults_ID, R.LogDateUTC, R.LogDate
FROM	cf_CommservSurveyResults AS R INNER JOIN cf_CustomerFeedbackXmlFile AS F
	 ON F.ID = R.CustomerFeedbackXmlFile_ID
	AND F.ParseTime = @parseTime
	AND F.ShredStatus = 1
	AND R.ShredStatus = 1
	AND R.QueryId = @surveyId
ORDER BY R.LogDateUTC
OPEN SurveyResultCur
FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId, @LogDateUTC, @LogDate
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @ErrorCode = 0
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		ELSE
			SET @ProcessSurveyResultTran = 0
		INSERT INTO cf_SurveyUnprotectedClients(
			CommServUniqueId,
			SurveyResultId,
			LogDateUTC,
			LogDate,
			ProtectedSubclients,
			NotProtectedSubclients,
			ExcludedSubclients,
			ClientGroups,
			ClientId,
			ClientName,
			AgentName,
			InstanceName,
			BackupSet,
			Subclient,
			Reason,
			LastBackupJobId,
			LastJobStatus,
			LastJobStartTime,
			ClientOwners,
			Days)
		SELECT
			@CSUniqueId,
			@ResultId,
			ISNULL(csInfo.n.value('../@SLAEndDateUTC', 'DATETIME'), LogDateUTC),
			ISNULL(csInfo.n.value('../@SLAEndDate', 'DATETIME'), LogDate),
			ISNULL(csInfo.n.value('@nProtectedSubclients', 'INTEGER'), csInfo.n.value('../@nProtectedSubclients', 'INTEGER')),
			ISNULL(csInfo.n.value('@nNotProtectedSubclients', 'INTEGER'), csInfo.n.value('../@nNotProtectedSubclients', 'INTEGER')),
			ISNULL(csInfo.n.value('@nExcludedSubclients', 'INTEGER'), csInfo.n.value('../@nExcludedSubclients', 'INTEGER')),
			ISNULL(csInfo.n.value('@clientGroups', 'NVARCHAR(MAX)'), ''),
			csInfo.n.value('@clientId', 'INTEGER'),
			csInfo.n.value('@clientName', 'NVARCHAR(256)'),
			csInfo.n.value('@agentName', 'NVARCHAR(256)'),
			csInfo.n.value('@instanceName', 'NVARCHAR(256)'),
			csInfo.n.value('@backupSet', 'NVARCHAR(256)'),
			csInfo.n.value('@subclient', 'NVARCHAR(256)'),
			csInfo.n.value('@reason', 'NVARCHAR(256)'),
			csInfo.n.value('@lastBackupJobId', 'INTEGER'),
			csInfo.n.value('@lastJobStatus', 'NVARCHAR(32)'),
			csInfo.n.value('@lastJobStartTime', 'DATETIME'),
			csInfo.n.value('@clientOwners', 'NVARCHAR(MAX)'),
			ISNULL(csInfo.n.value('@days', 'INT'), 30)
		FROM
			cf_CommservSurveyResults
			CROSS apply CollectedResults.nodes('/NotProtectedClients/client') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		IF (@ProcessSurveyResultTran = 1)
		BEGIN
			COMMIT TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 0
		END
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		SELECT	@ErrorCode = 1,
				@ErrorString = 'Query ID ' + CAST(@surveyId AS VARCHAR(20))
					+ ' - Parsing failed for Result ID ' + CAST(@ResultId AS VARCHAR(20)) + ' with error :: ' + ERROR_MESSAGE()
		IF (@ProcessSurveyResultTran = 1)
			ROLLBACK TRANSACTION ProcessSurveyResultTran
	END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId
		IF @isPrintOn = 1 PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
	FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId, @LogDateUTC,  @LogDate
END
CLOSE SurveyResultCur
DEALLOCATE SurveyResultCur
SET @ErrorCode = 0
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseUnprotectedClients')
	delete from GxQscripts where name = 'ParseUnprotectedClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseUnprotectedClients')
	delete from GXDBVersions where aliasname = 'ParseUnprotectedClients'
GO

insert into GXDBVersions values(2, 'ParseUnprotectedClients',  '00010007000000000000', 'ParseUnprotectedClients', '00010007000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseUnsupportedClient.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseUnsupportedClient.sp,v $ $Id: ParseUnsupportedClient.sp,v 1.2 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseUnsupportedClient <<<'

IF EXISTS (select * from sysobjects where name='ParseUnsupportedClient')
	drop procedure ParseUnsupportedClient
IF EXISTS (select * from GxQscripts where name='ParseUnsupportedClient')
	delete from GxQscripts where name = 'ParseUnsupportedClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseUnsupportedClient')
	delete from GXDBVersions where aliasname = 'ParseUnsupportedClient'
GO
print '... Creating Procedure: ParseUnsupportedClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseUnsupportedClient
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 18
SELECT @ErrorString = 'Unsupported Clients - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyUnsupportedClientInfo
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@ClientId', 'BIGINT'),
		csInfo.n.value('@ClientName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@ReleaseId', 'INTEGER'),
		csInfo.n.value('@Version', 'NVARCHAR(10)')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/UnSupportedClients/Client') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Unsupported Clients - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Unsupported Clients - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseUnsupportedClient')
	delete from GxQscripts where name = 'ParseUnsupportedClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseUnsupportedClient')
	delete from GXDBVersions where aliasname = 'ParseUnsupportedClient'
GO

insert into GXDBVersions values(2, 'ParseUnsupportedClient',  '00010002000000000000', 'ParseUnsupportedClient', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseUpdateInfoSurvey.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseUpdateInfoSurvey.sp,v $ $Id: ParseUpdateInfoSurvey.sp,v 1.2 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseUpdateInfoSurvey <<<'

IF EXISTS (select * from sysobjects where name='ParseUpdateInfoSurvey')
	drop procedure ParseUpdateInfoSurvey
IF EXISTS (select * from GxQscripts where name='ParseUpdateInfoSurvey')
	delete from GxQscripts where name = 'ParseUpdateInfoSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseUpdateInfoSurvey')
	delete from GXDBVersions where aliasname = 'ParseUpdateInfoSurvey'
GO
print '... Creating Procedure: ParseUpdateInfoSurvey'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseUpdateInfoSurvey
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 12
SELECT @ErrorString = 'Update Information - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	--DELETE a FROM cf_SurveyUpdateCacheInfo AS a
	--	INNER JOIN cf_CommservSurveyResults AS b
	--		ON a.SurveyResultId = b.CommservSurveyResults_ID
	--		AND a.LogDateUTC = b.LogDateUTC
	--		AND a.CommServUniqueId IN (SELECT DISTINCT CommcellIdNameMap_ID FROM cf_CustomerFeedbackXmlFile WHERE ShredStatus = 1 AND ParseTime = @parseTime)
	--		AND b.Flags = 1
	INSERT INTO cf_SurveyUpdateInfo
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@HighestSP', 'VARCHAR(MAX)'),
		csInfo.n.value('@AdditionalUpdates', 'VARCHAR(MAX)')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/UpdateInfo/CSDBUpdateInfo') AS csInfo(n)
	INSERT INTO cf_SurveyUpdateCacheInfo
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@HighestSP', 'VARCHAR(MAX)'),
		csInfo.n.value('@AdditionalUpdates', 'VARCHAR(MAX)'),
		csInfo.n.value('@OSName', 'VARCHAR(MAX)')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/UpdateInfo/UpdateCacheInfo') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Update Information - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Update Information - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseUpdateInfoSurvey')
	delete from GxQscripts where name = 'ParseUpdateInfoSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseUpdateInfoSurvey')
	delete from GXDBVersions where aliasname = 'ParseUpdateInfoSurvey'
GO

insert into GXDBVersions values(2, 'ParseUpdateInfoSurvey',  '00010002000000000000', 'ParseUpdateInfoSurvey', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseUpgradeCheck.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseUpgradeCheck.sp,v $ $Id: ParseUpgradeCheck.sp,v 1.2 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseUpgradeCheck <<<'

IF EXISTS (select * from sysobjects where name='ParseUpgradeCheck')
	drop procedure ParseUpgradeCheck
IF EXISTS (select * from GxQscripts where name='ParseUpgradeCheck')
	delete from GxQscripts where name = 'ParseUpgradeCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseUpgradeCheck')
	delete from GXDBVersions where aliasname = 'ParseUpgradeCheck'
GO
print '... Creating Procedure: ParseUpgradeCheck'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseUpgradeCheck
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 40
SELECT @ErrorString = 'Upgrade Check - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyUpgradeCheck
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@appTypeName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@totalNoOfJobs', 'BIGINT'),
		csInfo.n.value('@noOfJobsSucceeded', 'BIGINT'),
		csInfo.n.value('@noOfJobsCWE', 'BIGINT'),
		csInfo.n.value('@noOfJobsFailed', 'BIGINT'),
		csInfo.n.value('@noOfJobsKilled', 'BIGINT'),
		csInfo.n.value('@avgJobThroughput', 'FLOAT(2)'),
		csInfo.n.value('@avgJobAttempts', 'BIGINT'),
		csInfo.n.value('@avgJobRunTime', 'BIGINT'),
		1,
		3,
		csInfo.n.value('@failureReason', 'NVARCHAR(MAX)')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/JobAggregateStats/JobStatsForPre3Days/Jobstats') AS csInfo(n)
	INSERT INTO cf_SurveyUpgradeCheck
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@appTypeName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@totalNoOfJobs', 'BIGINT'),
		csInfo.n.value('@noOfJobsSucceeded', 'BIGINT'),
		csInfo.n.value('@noOfJobsCWE', 'BIGINT'),
		csInfo.n.value('@noOfJobsFailed', 'BIGINT'),
		csInfo.n.value('@noOfJobsKilled', 'BIGINT'),
		csInfo.n.value('@avgJobThroughput', 'FLOAT(2)'),
		csInfo.n.value('@avgJobAttempts', 'BIGINT'),
		csInfo.n.value('@avgJobRunTime', 'BIGINT'),
		1,
		7,
		csInfo.n.value('@failureReason', 'NVARCHAR(MAX)')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/JobAggregateStats/JobStatsForPre7Days/Jobstats') AS csInfo(n)
	INSERT INTO cf_SurveyUpgradeCheck
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@appTypeName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@totalNoOfJobs', 'BIGINT'),
		csInfo.n.value('@noOfJobsSucceeded', 'BIGINT'),
		csInfo.n.value('@noOfJobsCWE', 'BIGINT'),
		csInfo.n.value('@noOfJobsFailed', 'BIGINT'),
		csInfo.n.value('@noOfJobsKilled', 'BIGINT'),
		csInfo.n.value('@avgJobThroughput', 'FLOAT(2)'),
		csInfo.n.value('@avgJobAttempts', 'BIGINT'),
		csInfo.n.value('@avgJobRunTime', 'BIGINT'),
		1,
		21,
		csInfo.n.value('@failureReason', 'NVARCHAR(MAX)')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/JobAggregateStats/JobStatsForPre21Days/Jobstats') AS csInfo(n)
	INSERT INTO cf_SurveyUpgradeCheck
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@appTypeName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@totalNoOfJobs', 'BIGINT'),
		csInfo.n.value('@noOfJobsSucceeded', 'BIGINT'),
		csInfo.n.value('@noOfJobsCWE', 'BIGINT'),
		csInfo.n.value('@noOfJobsFailed', 'BIGINT'),
		csInfo.n.value('@noOfJobsKilled', 'BIGINT'),
		csInfo.n.value('@avgJobThroughput', 'FLOAT(2)'),
		csInfo.n.value('@avgJobAttempts', 'BIGINT'),
		csInfo.n.value('@avgJobRunTime', 'BIGINT'),
		2,
		3,
		csInfo.n.value('@failureReason', 'NVARCHAR(MAX)')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/JobAggregateStats/JobStatsForPost3Days/Jobstats') AS csInfo(n)
	INSERT INTO cf_SurveyUpgradeCheck
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@appTypeName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@totalNoOfJobs', 'BIGINT'),
		csInfo.n.value('@noOfJobsSucceeded', 'BIGINT'),
		csInfo.n.value('@noOfJobsCWE', 'BIGINT'),
		csInfo.n.value('@noOfJobsFailed', 'BIGINT'),
		csInfo.n.value('@noOfJobsKilled', 'BIGINT'),
		csInfo.n.value('@avgJobThroughput', 'FLOAT(2)'),
		csInfo.n.value('@avgJobAttempts', 'BIGINT'),
		csInfo.n.value('@avgJobRunTime', 'BIGINT'),
		2,
		7,
		csInfo.n.value('@failureReason', 'NVARCHAR(MAX)')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/JobAggregateStats/JobStatsForPost7Days/Jobstats') AS csInfo(n)
	INSERT INTO cf_SurveyUpgradeCheck
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@appTypeName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@totalNoOfJobs', 'BIGINT'),
		csInfo.n.value('@noOfJobsSucceeded', 'BIGINT'),
		csInfo.n.value('@noOfJobsCWE', 'BIGINT'),
		csInfo.n.value('@noOfJobsFailed', 'BIGINT'),
		csInfo.n.value('@noOfJobsKilled', 'BIGINT'),
		csInfo.n.value('@avgJobThroughput', 'FLOAT(2)'),
		csInfo.n.value('@avgJobAttempts', 'BIGINT'),
		csInfo.n.value('@avgJobRunTime', 'BIGINT'),
		2,
		21,
		csInfo.n.value('@failureReason', 'NVARCHAR(MAX)')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/JobAggregateStats/JobStatsForPost21Days/Jobstats') AS csInfo(n)
	INSERT INTO cf_SurveyUpgradeCheck
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@appTypeName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@totalNoOfJobs', 'BIGINT'),
		csInfo.n.value('@noOfJobsSucceeded', 'BIGINT'),
		csInfo.n.value('@noOfJobsCWE', 'BIGINT'),
		csInfo.n.value('@noOfJobsFailed', 'BIGINT'),
		csInfo.n.value('@noOfJobsKilled', 'BIGINT'),
		csInfo.n.value('@avgJobThroughput', 'FLOAT(2)'),
		csInfo.n.value('@avgJobAttempts', 'BIGINT'),
		csInfo.n.value('@avgJobRunTime', 'BIGINT'),
		3,
		3,
		csInfo.n.value('@failureReason', 'NVARCHAR(MAX)')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/JobAggregateStats/JobStatsForLatest3Days/Jobstats') AS csInfo(n)
	INSERT INTO cf_SurveyUpgradeCheck
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@appTypeName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@totalNoOfJobs', 'BIGINT'),
		csInfo.n.value('@noOfJobsSucceeded', 'BIGINT'),
		csInfo.n.value('@noOfJobsCWE', 'BIGINT'),
		csInfo.n.value('@noOfJobsFailed', 'BIGINT'),
		csInfo.n.value('@noOfJobsKilled', 'BIGINT'),
		csInfo.n.value('@avgJobThroughput', 'FLOAT(2)'),
		csInfo.n.value('@avgJobAttempts', 'BIGINT'),
		csInfo.n.value('@avgJobRunTime', 'BIGINT'),
		3,
		7,
		csInfo.n.value('@failureReason', 'NVARCHAR(MAX)')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/JobAggregateStats/JobStatsForLatest7Days/Jobstats') AS csInfo(n)
	INSERT INTO cf_SurveyUpgradeCheck
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@appTypeName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@totalNoOfJobs', 'BIGINT'),
		csInfo.n.value('@noOfJobsSucceeded', 'BIGINT'),
		csInfo.n.value('@noOfJobsCWE', 'BIGINT'),
		csInfo.n.value('@noOfJobsFailed', 'BIGINT'),
		csInfo.n.value('@noOfJobsKilled', 'BIGINT'),
		csInfo.n.value('@avgJobThroughput', 'FLOAT(2)'),
		csInfo.n.value('@avgJobAttempts', 'BIGINT'),
		csInfo.n.value('@avgJobRunTime', 'BIGINT'),
		3,
		21,
		csInfo.n.value('@failureReason', 'NVARCHAR(MAX)')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/JobAggregateStats/JobStatsForLatest21Days/Jobstats') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Upgrade Check  - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Upgrade Check  - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseUpgradeCheck')
	delete from GxQscripts where name = 'ParseUpgradeCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseUpgradeCheck')
	delete from GXDBVersions where aliasname = 'ParseUpgradeCheck'
GO

insert into GXDBVersions values(2, 'ParseUpgradeCheck',  '00010002000000000000', 'ParseUpgradeCheck', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseUpgradeHistory.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseUpgradeHistory.sp,v $ $Id: ParseUpgradeHistory.sp,v 1.2 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseUpgradeHistory <<<'

IF EXISTS (select * from sysobjects where name='ParseUpgradeHistory')
	drop procedure ParseUpgradeHistory
IF EXISTS (select * from GxQscripts where name='ParseUpgradeHistory')
	delete from GxQscripts where name = 'ParseUpgradeHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseUpgradeHistory')
	delete from GXDBVersions where aliasname = 'ParseUpgradeHistory'
GO
print '... Creating Procedure: ParseUpgradeHistory'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseUpgradeHistory
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 38
SELECT @ErrorString = 'Upgrade History - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyUpgradeHistory
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@ReleaseId', 'INTEGER'),
		csInfo.n.value('@Version', 'NVARCHAR(MAX)'),
		csInfo.n.value('@InstallTime', 'DATETIME')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/SimpanaInstallHistory') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Upgrade History - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Upgrade History - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseUpgradeHistory')
	delete from GxQscripts where name = 'ParseUpgradeHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseUpgradeHistory')
	delete from GXDBVersions where aliasname = 'ParseUpgradeHistory'
GO

insert into GXDBVersions values(2, 'ParseUpgradeHistory',  '00010002000000000000', 'ParseUpgradeHistory', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseWeeklyStorageUsage.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseWeeklyStorageUsage.sp,v $ $Id: ParseWeeklyStorageUsage.sp,v 1.6 2015/04/17 15:49:40 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseWeeklyStorageUsage <<<'

IF EXISTS (select * from sysobjects where name='ParseWeeklyStorageUsage')
	drop procedure ParseWeeklyStorageUsage
IF EXISTS (select * from GxQscripts where name='ParseWeeklyStorageUsage')
	delete from GxQscripts where name = 'ParseWeeklyStorageUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseWeeklyStorageUsage')
	delete from GXDBVersions where aliasname = 'ParseWeeklyStorageUsage'
GO
print '... Creating Procedure: ParseWeeklyStorageUsage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseWeeklyStorageUsage
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
-------------------------------------------------------------------------------
-- Looping for each result:
--   Commit transaction for each result
--   Set ShredStatus = 3 immediately on error so it will be skipped in future
-- Always return ErrorCode = 0 so parsed results will be set to ShredStatus = 2
-------------------------------------------------------------------------------
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 162
SELECT @ErrorCode = 0, @ErrorString = 'Parsing results for Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
DECLARE @CSUniqueId INT = 0
DECLARE @ResultId INT = 0
DECLARE	SurveyResultCur CURSOR FOR
SELECT	F.CommcellIdNameMap_ID, R.CommservSurveyResults_ID
FROM	cf_CommservSurveyResults AS R INNER JOIN cf_CustomerFeedbackXmlFile AS F
	 ON F.ID = R.CustomerFeedbackXmlFile_ID
	AND F.ParseTime = @parseTime
	AND F.ShredStatus = 1
	AND R.ShredStatus = 1
	AND R.QueryId = @surveyId
ORDER BY R.LogDateUTC
OPEN SurveyResultCur
FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @ErrorCode = 0
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		ELSE
			SET @ProcessSurveyResultTran = 0
		INSERT INTO cf_SurveyMonthlyChargeback (
			CommservUniqueId, SurveyResultId, StartDate, Type, ClientId, AppId, CopyId,
			FrontEndSize, DataProtected, DataWritten, TotalProtectedApp, TotalDataOnMedia, FrontEndSizeType)
		SELECT
			@CSUniqueId,
			@ResultId,
			ISNULL(csInfo.n.value('@StartDate','DATETIME'), csInfo.n.value('@Week','DATETIME')),
			ISNULL(csInfo.n.value('@Type','INT'), 2),
			csInfo.n.value('@ClientId','INT'),
			csInfo.n.value('@AppId','INT'),
			csInfo.n.value('@CopyId','INT'),
			csInfo.n.value('@FrontEndSize','BIGINT'),
			csInfo.n.value('@DataProtected','BIGINT'),
			csInfo.n.value('@DataWritten','BIGINT'),
			ISNULL(csInfo.n.value('@TotalProtectedApp','BIGINT'), 0),
			ISNULL(csInfo.n.value('@TotalDataOnMedia','BIGINT'), 0),
			csInfo.n.value('@FrontEndSizeType','INT')
		FROM
			cf_CommservSurveyResults
			CROSS APPLY CollectedResults.nodes('WeeklyStorageUsage') AS csInfo(n)
		WHERE
			CommservSurveyResults_ID = @ResultId
		IF	@@ROWCOUNT = 0
			SELECT	@ErrorCode = 1,
				@ErrorString = 'Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' Commserv Unique ID ' + CAST(@CSUniqueId AS VARCHAR(20))
					+ ' Result ID ' + CAST(@ResultId AS VARCHAR(20)) + ' - No data. Skipped.'
		IF	EXISTS (SELECT * FROM cf_SurveyMonthlyChargeback WHERE SurveyResultId = @ResultId AND FrontEndSizeType IS NULL)
		BEGIN
			UPDATE cf_SurveyMonthlyChargeback
			SET    FrontEndSizeType = CASE WHEN S.AppTypeId IN (45,56,57,58,66,67,68,73,82,83,89,90,124) THEN 1 ELSE 0 END
			FROM   cf_SurveyMonthlyChargeback M INNER JOIN cf_SurveySubclientAssociation S
				ON M.CommservUniqueId = S.CommservUniqueId AND M.appId = S.AppId
				AND M.SurveyResultId = @ResultId AND M.FrontEndSizeType IS NULL
			UPDATE cf_SurveyMonthlyChargeback
			SET    FrontEndSizeType = 0
			WHERE  SurveyResultId = @ResultId AND FrontEndSizeType IS NULL
		END
		IF (@ProcessSurveyResultTran = 1)
			COMMIT TRANSACTION ProcessSurveyResultTran
	END TRY
	BEGIN CATCH
		
	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		SELECT	@ErrorCode = 1,
				@ErrorString = 'Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' Commserv Unique ID ' + CAST(@CSUniqueId AS VARCHAR(20))
					+ ' Result ID ' + CAST(@ResultId AS VARCHAR(20)) + ' - Parsing failed with error :: ' + ERROR_MESSAGE()
		IF (@ProcessSurveyResultTran = 1)
			ROLLBACK TRANSACTION ProcessSurveyResultTran
	END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId
		IF @isPrintOn = 1 PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
	FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId
END
CLOSE SurveyResultCur
DEALLOCATE SurveyResultCur
SET @ErrorCode = 0
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseWeeklyStorageUsage')
	delete from GxQscripts where name = 'ParseWeeklyStorageUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseWeeklyStorageUsage')
	delete from GXDBVersions where aliasname = 'ParseWeeklyStorageUsage'
GO

insert into GXDBVersions values(2, 'ParseWeeklyStorageUsage',  '00010006000000000000', 'ParseWeeklyStorageUsage', '00010006000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ManageMetricsUsers.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ManageMetricsUsers.sp,v $ $Id: ManageMetricsUsers.sp,v 1.2 2013/07/23 14:15:15 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ManageMetricsUsers <<<'

IF EXISTS (select * from sysobjects where name='ManageMetricsUsers')
	drop procedure ManageMetricsUsers
IF EXISTS (select * from GxQscripts where name='ManageMetricsUsers')
	delete from GxQscripts where name = 'ManageMetricsUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ManageMetricsUsers')
	delete from GXDBVersions where aliasname = 'ManageMetricsUsers'
GO
print '... Creating Procedure: ManageMetricsUsers'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ManageMetricsUsers
  @Operation INTEGER = 0,
  @UserId INT     = -1,
  @UserProp xml = NULL
AS
  DECLARE @response INT
BEGIN
SET NOCOUNT ON
DECLARE @errorString    VARCHAR(4096)
IF @Operation = 1 --ADD /UPDATE
BEGIN
	DECLARE @surveycapability   INT =-1
	IF ((SELECT @UserProp.exist('/WebReport_CloudMetricsUserResp/@surveycapability')) = 1)
	SET @surveycapability = ISNULL(@UserProp.value('(/WebReport_CloudMetricsUserResp/@surveycapability)[1]', 'integer'), 0)
	IF NOT EXISTS (SELECT * FROM cf_MetricsLoggedInUsers WHERE UserId = @UserId)
		INSERT INTO cf_MetricsLoggedInUsers (UserId,surveycapability,LogDateUTC, UserProp) VALUES (@UserId,@surveycapability, getUTCDate(),@UserProp )
	ELSE
		UPDATE cf_MetricsLoggedInUsers SET UserProp = @UserProp, surveycapability = @surveycapability, LogDateUTC = getUTCDate()  WHERE UserId =@UserId
GOTO procExit
END
IF @Operation = 2 --DELETE
BEGIN
	IF  EXISTS (SELECT * FROM cf_MetricsLoggedInUsers WHERE UserId = @UserId)
		DELETE cf_MetricsLoggedInUsers WHERE UserId =@UserId
GOTO procExit
END
procExit:
SET NOCOUNT OFF
 SELECT 0 AS response
END
GO

IF EXISTS (select * from GxQscripts where name = 'ManageMetricsUsers')
	delete from GxQscripts where name = 'ManageMetricsUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ManageMetricsUsers')
	delete from GXDBVersions where aliasname = 'ManageMetricsUsers'
GO

insert into GXDBVersions values(2, 'ManageMetricsUsers',  '00010002000000000000', 'ManageMetricsUsers', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Parse_57CommservInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Parse_57CommservInfo.sp,v $ $Id: Parse_57CommservInfo.sp,v 1.5 2015/03/09 20:26:12 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Parse_57CommservInfo <<<'

IF EXISTS (select * from sysobjects where name='Parse_57CommservInfo')
	drop procedure Parse_57CommservInfo
IF EXISTS (select * from GxQscripts where name='Parse_57CommservInfo')
	delete from GxQscripts where name = 'Parse_57CommservInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_57CommservInfo')
	delete from GXDBVersions where aliasname = 'Parse_57CommservInfo'
GO
print '... Creating Procedure: Parse_57CommservInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Parse_57CommservInfo
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 57
SELECT @ErrorString = 'Parse_57CommservInfo Statistics - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		IF object_id('tempdb.dbo.#majorSP4Releases') is not null DROP TABLE #majorSP4Releases
		CREATE TABLE #majorSP4Releases (version INT , majorSPNum INT)
		INSERT INTO #majorSP4Releases (version , majorSPNum )
		SELECT  10,	V10SPInfoFTP.value('@majorSP'		, 'INT')
		FROM
		cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
		ON files.ShredStatus = 1
		AND files.ID = results.CustomerFeedbackXmlFile_ID
		AND results.ShredStatus = 1
		AND results.QueryId = @surveyId
		AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('CommServInfo') AS CommServInfo(CommServInfo)
		CROSS apply CommServInfo.nodes('V10SPInfoFTP') AS V10SPInfoFTP(V10SPInfoFTP)
		WHERE  V10SPInfoFTP.value('@majorSP'       , 'INT')<100
		UNION
		SELECT  9,	V9SPInfoCommserv.value('@majorSP'		, 'INT')
		FROM
		cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
		ON files.ShredStatus = 1
		AND files.ID = results.CustomerFeedbackXmlFile_ID
		AND results.ShredStatus = 1
		AND results.QueryId = @surveyId
		AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('CommServInfo') AS CommServInfo(CommServInfo)
		CROSS apply CommServInfo.nodes('V9SPInfoCommserv') AS V9SPInfoCommserv(V9SPInfoCommserv)
		DECLARE @maxV9New INT =0,@maxV10New INT =0
		Select @maxV9New = MAX(majorSPNum) FROM #majorSP4Releases WHERE Version  = 9
		Select @maxV10New = MAX(majorSPNum) FROM #majorSP4Releases WHERE Version = 10
		DECLARE @maxV9Old INT =0,@maxV10Old INT =0
		Select @maxV9Old =  CAST(Value AS INT)  FROM cf_SurveyConfig  WHERE Name = '9_0_LatestSPMajorNo'
		Select @maxV10Old = CAST(Value AS INT) FROM cf_SurveyConfig WHERE Name = '10_0_LatestSPMajorNo'
		IF (@maxV10New>@maxV10Old)
		BEGIN
			IF EXISTS(Select *  FROM cf_SurveyConfig  WHERE Name = '10_0_LatestSPMajorNo')
			   UPDATE cf_SurveyConfig SET Value = @maxV10New, LogDateUTC = GETUTCDATE() WHERE Name = '10_0_LatestSPMajorNo'
			ELSE
			   INSERT INTO cf_SurveyConfig (Name, Value) values ('10_0_LatestSPMajorNo', @maxV10New)
		END
		IF (@maxV9New>@maxV9Old)
		BEGIN
			IF EXISTS(Select *  FROM cf_SurveyConfig  WHERE Name = '9_0_LatestSPMajorNo')
			   UPDATE cf_SurveyConfig SET Value = @maxV9New, LogDateUTC = GETUTCDATE() WHERE Name = '9_0_LatestSPMajorNo'
			ELSE
			   INSERT INTO cf_SurveyConfig (Name, Value) values ('9_0_LatestSPMajorNo', @maxV9New)
		END
		IF object_id('tempdb.dbo.#majorSP4Releases') is not null DROP TABLE #majorSP4Releases
		IF (@ProcessSurveyResultTran = 1)
		BEGIN
			COMMIT TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 0
		END
		SELECT @ErrorCode = 0
		SELECT @ErrorString ='Parse_57CommservInfo Statistics - complete'
		IF @isPrintOn = 1
			PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
		BEGIN
		ROLLBACK TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
		SELECT @ErrorCode = 1
		SELECT @ErrorString ='Parse_57CommservInfo Statistics - failed with error :: ' + ERROR_MESSAGE()
		IF @isPrintOn = 1
			PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
		END
	END CATCH
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Parse_57CommservInfo')
	delete from GxQscripts where name = 'Parse_57CommservInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_57CommservInfo')
	delete from GXDBVersions where aliasname = 'Parse_57CommservInfo'
GO

insert into GXDBVersions values(2, 'Parse_57CommservInfo',  '00010005000000000000', 'Parse_57CommservInfo', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Parse_73Backup_Count.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Parse_73Backup_Count.sp,v $ $Id: Parse_73Backup_Count.sp,v 1.4 2015/07/09 06:15:54 vmishra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Parse_73Backup_Count <<<'

IF EXISTS (select * from sysobjects where name='Parse_73Backup_Count')
	drop procedure Parse_73Backup_Count
IF EXISTS (select * from GxQscripts where name='Parse_73Backup_Count')
	delete from GxQscripts where name = 'Parse_73Backup_Count'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_73Backup_Count')
	delete from GXDBVersions where aliasname = 'Parse_73Backup_Count'
GO
print '... Creating Procedure: Parse_73Backup_Count'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Parse_73Backup_Count
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 73
SELECT @ErrorString = 'Parse_73Backup_Count - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_Survey73Backup_Count(CommServUniqueId, SurveyResultId, LogDateUTC, LogDate, Backup_Count_successJobCountPerDay, Backup_Count_failureJobCountPerDay, Backup_Count_topJobCountPerHour, EncryptedMediaSizeMB, NonEncryptedMediaSizeMB, EncryptedAppSizeMB, NonEncryptedAppSizeMB)
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		Backup_Count.value('@successJobCountPerDay' , '[BIGINT]'),
		Backup_Count.value('@failureJobCountPerDay' , '[BIGINT]'),
		Backup_Count.value('@topJobCountPerHour' , '[BIGINT]'),
		Backup_Count.value('@EncryptedMediaSizeMB' , '[BIGINT]'),
		Backup_Count.value('@NonEncryptedMediaSizeMB' , '[BIGINT]'),
		Backup_Count.value('@EncryptedAppSizeMB' , '[BIGINT]'),
		Backup_Count.value('@NonEncrptedAppSizeMB' , '[BIGINT]')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('Backup_Count') AS Backup_Count(Backup_Count)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString ='Parse_73Backup_Count  - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Parse_73Backup_Count  - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Parse_73Backup_Count')
	delete from GxQscripts where name = 'Parse_73Backup_Count'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_73Backup_Count')
	delete from GXDBVersions where aliasname = 'Parse_73Backup_Count'
GO

insert into GXDBVersions values(2, 'Parse_73Backup_Count',  '00010004000000000000', 'Parse_73Backup_Count', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Parse_77ClientDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Parse_77ClientDetails.sp,v $ $Id: Parse_77ClientDetails.sp,v 1.12 2015/06/12 19:01:31 vmishra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Parse_77ClientDetails <<<'

IF EXISTS (select * from sysobjects where name='Parse_77ClientDetails')
	drop procedure Parse_77ClientDetails
IF EXISTS (select * from GxQscripts where name='Parse_77ClientDetails')
	delete from GxQscripts where name = 'Parse_77ClientDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_77ClientDetails')
	delete from GXDBVersions where aliasname = 'Parse_77ClientDetails'
GO
print '... Creating Procedure: Parse_77ClientDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Parse_77ClientDetails
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
-------------------------------------------------------------------------------
-- Looping for each result:
--   Commit transaction for each result
--   Set ShredStatus = 3 immediately on error so it will be skipped in future
-- Always return ErrorCode = 0 so parsed results will be set to ShredStatus = 2
-------------------------------------------------------------------------------
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 77
SELECT @ErrorCode = 0, @ErrorString = 'Parsing results for Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
DECLARE @CSUniqueId INT = 0
DECLARE @ResultId INT = 0
DECLARE @LogDateUTC datetime
DECLARE @LogDate    datetime
DECLARE	SurveyResultCur CURSOR FOR
SELECT	F.CommcellIdNameMap_ID, R.CommservSurveyResults_ID, R.LogDateUTC,R.LogDate
FROM	cf_CommservSurveyResults AS R INNER JOIN cf_CustomerFeedbackXmlFile AS F
	 ON F.ID = R.CustomerFeedbackXmlFile_ID
	AND F.ParseTime = @parseTime
	AND F.ShredStatus = 1
	AND R.ShredStatus = 1
	AND R.QueryId = @surveyId
ORDER BY R.LogDateUTC
OPEN SurveyResultCur
FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId,@LogDateUTC,  @LogDate
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @ErrorCode = 0
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		ELSE
			SET @ProcessSurveyResultTran = 0
		INSERT INTO cf_Survey77ClientDetails(CommServUniqueId,SurveyResultId,LogDateUTC,LogDate,
										 clientName,clientId,operatingSystem,installdate,servicePack,
										 StoragePolicy,latestDataProtection,lastbkp,type,info,
										 UninstallTime,DeleteTime,Timezone,AdditionalUpdates,PhysicalClientName)
		SELECT
			@CSUniqueId,
			@ResultId,
			@LogDateUTC,
			@LogDate,
			Client.value('@clientName' , '[NVARCHAR](MAX)'),
			Client.value('@clientId' , '[BIGINT]'),
			Client.value('@operatingSystem' , '[NVARCHAR](MAX)'),
			CASE
			WHEN Client.value('@installdate' , '[DATETIME]')<'1970-01-02'
			THEN NULL
			ELSE Client.value('@installdate' , '[DATETIME]')END ,
			Client.value('@servicePack' , '[NVARCHAR](MAX)'),
			Client.value('@StoragePolicy' , '[NVARCHAR](MAX)'),
			Client.value('@latestDataProtection' , '[DATETIME]'),
			Client.value('@lastbkp' , '[BIGINT]'),
			Client.value('@type' , '[BIGINT]'),
			Client.query('info'),
			CASE
			WHEN Client.value('@uninstallTime' , '[DATETIME]')<'1970-01-02'
			THEN NULL
			ELSE Client.value('@uninstallTime' , '[DATETIME]')END ,
			CASE
			WHEN Client.value('@deleteTime' , '[DATETIME]')<'1970-01-02'
			THEN NULL
			ELSE Client.value('@deleteTime' , '[DATETIME]')END,
			Client.value('@timezone' , '[nvarchar](255)'),
			Client.value('@additionalUpdates' , '[NVARCHAR](MAX)'),
			Client.value('@physicalClientName' , '[NVARCHAR](MAX)')
		FROM
			cf_CommservSurveyResults
			CROSS apply CollectedResults.nodes('ClientDetails') AS ClientDetails(ClientDetails)
			CROSS apply ClientDetails.nodes('Client') AS Client(Client)
		WHERE
			CommservSurveyResults_ID = @ResultId
		INSERT INTO cf_Survey106ClientVersion(CommServUniqueId,SurveyResultId,LogDateUTC,LogDate,Months,Years,LatestVersionCount,IILatestVersionCount,IIILatestversionCount)
		SELECT
			@CSUniqueId,
			@ResultId,
			@LogDateUTC,
			@LogDate,
			ClientVersion.value('@MONTHS' , '[INT]'),
			ClientVersion.value('@YEARS' , '[INT]'),
			ClientVersion.value('@version1' , '[INT]'),
			ClientVersion.value('@version2' , '[INT]'),
			ClientVersion.value('@version3' , '[INT]')
		FROM
			cf_CommservSurveyResults
			CROSS apply CollectedResults.nodes('ClientDetails') AS ClientDetails(ClientDetails)
			CROSS apply ClientDetails.nodes('ClientVersion') AS ClientVersion(ClientVersion)
		WHERE
			CommservSurveyResults_ID = @ResultId
		IF (@ProcessSurveyResultTran = 1)
			COMMIT TRANSACTION ProcessSurveyResultTran
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		SELECT	@ErrorCode = 1,
				@ErrorString = 'Query ID ' + CAST(@surveyId AS VARCHAR(20))
					+ ' - Parsing failed for Result ID ' + CAST(@ResultId AS VARCHAR(20)) + ' with error :: ' + ERROR_MESSAGE()
		IF (@ProcessSurveyResultTran = 1)
			ROLLBACK TRANSACTION ProcessSurveyResultTran
	END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId
		IF @isPrintOn = 1 PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
	FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId,@LogDateUTC,  @LogDate
END
CLOSE SurveyResultCur
DEALLOCATE SurveyResultCur
SET @ErrorCode = 0
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Parse_77ClientDetails')
	delete from GxQscripts where name = 'Parse_77ClientDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_77ClientDetails')
	delete from GXDBVersions where aliasname = 'Parse_77ClientDetails'
GO

insert into GXDBVersions values(2, 'Parse_77ClientDetails',  '00010012000000000000', 'Parse_77ClientDetails', '00010012000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Parse_95MountPathDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Parse_95MountPathDetails.sp,v $ $Id: Parse_95MountPathDetails.sp,v 1.5 2015/07/09 06:15:34 vmishra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Parse_95MountPathDetails <<<'

IF EXISTS (select * from sysobjects where name='Parse_95MountPathDetails')
	drop procedure Parse_95MountPathDetails
IF EXISTS (select * from GxQscripts where name='Parse_95MountPathDetails')
	delete from GxQscripts where name = 'Parse_95MountPathDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_95MountPathDetails')
	delete from GXDBVersions where aliasname = 'Parse_95MountPathDetails'
GO
print '... Creating Procedure: Parse_95MountPathDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Parse_95MountPathDetails
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 95
SELECT @ErrorString = 'Parse_95MountPathDetails Statistics - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		INSERT INTO cf_Survey95MountPathDetails
		SELECT
			files.CommcellIdNameMap_ID,
			results.CommservSurveyResults_ID,
			results.LogDateUTC,
			results.LogDate
			,
			MountPath.value('@LibraryId'		, 'BIGINT'),
			MountPath.value('@LibraryName'		, '[NVARCHAR](MAX)'),
			MountPath.value('@MountPathName'	, '[NVARCHAR](MAX)'),
			MountPath.value('@Status'			, 'NVARCHAR (16)'),
			MountPath.value('@FreeSpaceGB'		, 'FLOAT'),
			MountPath.value('@TotalCapacityGB'  , 'FLOAT'),
			MountPath.value('@UsedSpaceGB'		, 'FLOAT'),
			MountPath.value('@FreeSpacePerc'    , 'FLOAT'),
			ISNULL(MountPath.value('@MountPathId'		, 'BIGINT'),0),
			ISNULL(MountPath.value('@BaseFolderName'	, '[NVARCHAR](MAX)'),''),
			ISNULL(MountPath.value('@Device'	, '[NVARCHAR](MAX)'),''),
			ISNULL(MountPath.value('@MAId'	, 'INT'),0),
			MountPath.value('@MAName'	, '[NVARCHAR](MAX)')
		FROM
		cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
		ON files.ShredStatus = 1
		AND files.ID = results.CustomerFeedbackXmlFile_ID
		AND results.ShredStatus = 1
		AND results.QueryId = @surveyId
		AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('MountPathDetails') AS MountPathDetails(MountPathDetails)
		CROSS apply MountPathDetails.nodes('MountPath') AS MountPath(MountPath)
		IF (@ProcessSurveyResultTran = 1)
		BEGIN
			COMMIT TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 0
		END
		SELECT @ErrorCode = 0
		SELECT @ErrorString ='Parse_95MountPathDetails Statistics - complete'
		IF @isPrintOn = 1
			PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
		BEGIN
		ROLLBACK TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
		SELECT @ErrorCode = 1
		SELECT @ErrorString ='Parse_95MountPathDetails Statistics - failed with error :: ' + ERROR_MESSAGE()
		IF @isPrintOn = 1
			PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
		END
	END CATCH
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Parse_95MountPathDetails')
	delete from GxQscripts where name = 'Parse_95MountPathDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_95MountPathDetails')
	delete from GXDBVersions where aliasname = 'Parse_95MountPathDetails'
GO

insert into GXDBVersions values(2, 'Parse_95MountPathDetails',  '00010005000000000000', 'Parse_95MountPathDetails', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Parse_96DiskLibDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Parse_96DiskLibDetails.sp,v $ $Id: Parse_96DiskLibDetails.sp,v 1.5 2015/06/23 13:51:36 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Parse_96DiskLibDetails <<<'

IF EXISTS (select * from sysobjects where name='Parse_96DiskLibDetails')
	drop procedure Parse_96DiskLibDetails
IF EXISTS (select * from GxQscripts where name='Parse_96DiskLibDetails')
	delete from GxQscripts where name = 'Parse_96DiskLibDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_96DiskLibDetails')
	delete from GXDBVersions where aliasname = 'Parse_96DiskLibDetails'
GO
print '... Creating Procedure: Parse_96DiskLibDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Parse_96DiskLibDetails
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 96
SELECT @ErrorString = 'Parse_96DiskLibDetails Statistics - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
	CREATE TABLE #Results (SurveyResultId INT, CommServUniqueId INT, MonthStart DATETIME)
	INSERT INTO  #Results (SurveyResultId, CommServUniqueId, MonthStart)
	SELECT	R.CommservSurveyResults_ID, R.CommcellIdNameMap_ID, DATEADD(MONTH, DATEDIFF(MONTH, 0, R.LogDate), 0)
	FROM	cf_CommservSurveyResults AS R
			INNER JOIN cf_CustomerFeedbackXmlFile AS F
		ON F.ID = R.CustomerFeedbackXmlFile_ID
		AND F.ShredStatus = 1 AND F.ParseTime = @parseTime
		AND R.ShredStatus = 1 AND R.QueryId = @surveyId
	UPDATE #Results SET MonthStart = DATEADD(MONTH, DATEDIFF(MONTH, 0, MonthStart), 0)
INSERT INTO cf_Survey96DiskLibDetails (
	CommServUniqueId, SurveyResultId, LogDateUTC, LogDate, LibraryId, LibraryName,
	totalValidDataGB, totalDataWrittenGB, totalAppSizeGB, totalFreeSpaceGB, totalReserveSpaceMB, totalSpaceGB,
	avgDataWrittenPerDayMB, avgCapacityFreedMB, avgMediaConsumedPerDay, avgMediaFreedPerDay, lastNumDays,
	estimatedSpaceRunoutDays, lowWatermark, warningWatermark, macroPrunableGB
)
SELECT
files.CommcellIdNameMap_ID,
results.CommservSurveyResults_ID,
results.LogDateUTC,
results.LogDate
,
DiskLib.value('@LibraryId'					, 'BIGINT'),
DiskLib.value('@LibraryName'				, '[NVARCHAR](MAX)'),
DiskLib.value('@totalValidDataGB'			, 'FLOAT'),
DiskLib.value('@totalDataWrittenGB'			, 'FLOAT'),
DiskLib.value('@totalAppSizeGB'				, 'FLOAT'),
DiskLib.value('@totalFreeSpaceGB'			, 'FLOAT'),
DiskLib.value('@totalReserveSpaceMB'		, 'BIGINT'),
DiskLib.value('@totalSpaceGB'			    , 'FLOAT'),
DiskLib.value('@avgDataWrittenPerDayMB'     , 'BIGINT'),
DiskLib.value('@avgCapacityFreedMB'         , 'BIGINT'),
DiskLib.value('@avgMediaConsumedPerDay'     , 'BIGINT'),
DiskLib.value('@avgMediaFreedPerDay'        , 'BIGINT'),
DiskLib.value('@lastNumDays'			    , 'INT'),
DiskLib.value('@estimatedSpaceRunoutDays'   , 'INT'),
DiskLib.value('@lowWatermark'				, 'INT'),
DiskLib.value('@warningWatermark'			, 'INT'),
ISNULL(DiskLib.value('@macroPrunableGB'		, 'FLOAT'), 0)
FROM
cf_CommservSurveyResults AS results
INNER JOIN cf_CustomerFeedbackXmlFile AS files
ON files.ShredStatus = 1
AND files.ID = results.CustomerFeedbackXmlFile_ID
AND results.ShredStatus = 1
AND results.QueryId = @surveyId
AND files.ParseTime = @parseTime
CROSS apply results.CollectedResults.nodes('DiskLibDetails') AS DiskLibDetails(DiskLibDetails)
CROSS apply DiskLibDetails.nodes('DiskLib') AS DiskLib(DiskLib)
	UPDATE cf_SurveyDiskLibraryPeakSize
	SET	UsedSpaceMB = CASE WHEN (S.totalSpaceGB - S.totalFreeSpaceGB)*1024 > P.UsedSpaceMB THEN (S.totalSpaceGB - S.totalFreeSpaceGB)*1024 ELSE P.UsedSpaceMB END,
		FreeSpaceMB = CASE WHEN (S.totalFreeSpaceGB*1024 < P.FreeSpaceMB) OR P.FreeSpaceMB <= 0 THEN S.totalFreeSpaceGB*1024 ELSE P.FreeSpaceMB END
	FROM
		cf_Survey96DiskLibDetails S
		INNER JOIN #Results T ON S.SurveyResultId = T.SurveyResultId
		INNER JOIN cf_SurveyDiskLibraryPeakSize P ON P.CommServUniqueId = T.CommServUniqueId AND P.MonthStart = T.MonthStart AND P.LibraryId = S.LibraryId
	WHERE S.totalSpaceGB > 0
	INSERT INTO cf_SurveyDiskLibraryPeakSize (
		CommServUniqueId, MonthStart, LibraryId, LibraryName, UsedSpaceMB, FreeSpaceMB, AppSizeMB, DataWrittenMB)
	SELECT
		R.CommServUniqueId, R.MonthStart, S.LibraryId, S.LibraryName,
		MAX(S.totalSpaceGB - S.totalFreeSpaceGB)*1024, MIN(S.totalFreeSpaceGB)*1024,
		MAX(ISNULL(S.totalAppSizeGB,0))*1024, MAX(ISNULL(S.totalDataWrittenGB,0))*1024
	FROM
		cf_Survey96DiskLibDetails S
		INNER JOIN #Results R ON S.SurveyResultId = R.SurveyResultId
		LEFT OUTER JOIN cf_SurveyDiskLibraryPeakSize P ON P.CommServUniqueId = R.CommServUniqueId AND P.MonthStart = R.MonthStart AND P.LibraryId = S.LibraryId
	WHERE P.CommServUniqueId IS NULL AND S.totalSpaceGB > 0
	GROUP BY R.CommServUniqueId, R.MonthStart, S.LibraryId, S.LibraryName
	DROP TABLE #Results
		IF (@ProcessSurveyResultTran = 1)
		BEGIN
			COMMIT TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 0
		END
		SELECT @ErrorCode = 0
		SELECT @ErrorString ='Parse_96DiskLibDetails Statistics - complete'
		IF @isPrintOn = 1
			PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
		BEGIN
		ROLLBACK TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
		SELECT @ErrorCode = 1
		SELECT @ErrorString ='Parse_96DiskLibDetails Statistics - failed with error :: ' + ERROR_MESSAGE()
		IF @isPrintOn = 1
			PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
		END
	END CATCH
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Parse_96DiskLibDetails')
	delete from GxQscripts where name = 'Parse_96DiskLibDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_96DiskLibDetails')
	delete from GXDBVersions where aliasname = 'Parse_96DiskLibDetails'
GO

insert into GXDBVersions values(2, 'Parse_96DiskLibDetails',  '00010005000000000000', 'Parse_96DiskLibDetails', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Parse_104ExceptionalClients.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Parse_104ExceptionalClients.sp,v $ $Id: Parse_104ExceptionalClients.sp,v 1.4 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Parse_104ExceptionalClients <<<'

IF EXISTS (select * from sysobjects where name='Parse_104ExceptionalClients')
	drop procedure Parse_104ExceptionalClients
IF EXISTS (select * from GxQscripts where name='Parse_104ExceptionalClients')
	delete from GxQscripts where name = 'Parse_104ExceptionalClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_104ExceptionalClients')
	delete from GXDBVersions where aliasname = 'Parse_104ExceptionalClients'
GO
print '... Creating Procedure: Parse_104ExceptionalClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Parse_104ExceptionalClients
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 104
SELECT @ErrorString = 'Parse_104ExceptionalClients - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_Survey104ExceptionalClients(CommServUniqueId,SurveyResultId,LogDateUTC,LogDate,clientID,clientName,clientType)
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		client.value('@clientId' ,  '[INT]'),
		client.value('@clientName' ,'[NVARCHAR](MAX)'),
		client.value('@clientType' , '[BIGINT]')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('CLIENTS') AS CLIENTS(CLIENTS)
	CROSS apply CLIENTS.nodes('client') AS client(client)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Parse_104ExceptionalClients  - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Parse_104ExceptionalClients  - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Parse_104ExceptionalClients')
	delete from GxQscripts where name = 'Parse_104ExceptionalClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_104ExceptionalClients')
	delete from GXDBVersions where aliasname = 'Parse_104ExceptionalClients'
GO

insert into GXDBVersions values(2, 'Parse_104ExceptionalClients',  '00010004000000000000', 'Parse_104ExceptionalClients', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseIndexCacheUsage.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseIndexCacheUsage.sp,v $ $Id: ParseIndexCacheUsage.sp,v 1.4 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseIndexCacheUsage <<<'

IF EXISTS (select * from sysobjects where name='ParseIndexCacheUsage')
	drop procedure ParseIndexCacheUsage
IF EXISTS (select * from GxQscripts where name='ParseIndexCacheUsage')
	delete from GxQscripts where name = 'ParseIndexCacheUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseIndexCacheUsage')
	delete from GXDBVersions where aliasname = 'ParseIndexCacheUsage'
GO
print '... Creating Procedure: ParseIndexCacheUsage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseIndexCacheUsage
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 39
SELECT @ErrorString = 'Index Cache Usage - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyIndexCacheUsage
	SELECT DISTINCT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@MAId', 'BIGINT'),
		csInfo.n.value('@MAName','NVARCHAR(MAX)'),
		csInfo.n.value('@IndexCachePath','NVARCHAR(MAX)'),
		csInfo.n.value('@IntermediateCachePath','NVARCHAR(MAX)'),
		csInfo.n.value('@IsShared','INT'),
		csInfo.n.value('@IsUNC','INT'),
		csInfo.n.value('@TotalCapacityMB','BIGINT'),
		csInfo.n.value('@DiskUsageMB','BIGINT'),
		csInfo.n.value('@FreeDiskSpaceMB','BIGINT')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/MediaAgentIndexCacheInfo') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Index Cache Usage - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Index Cache Usage - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseIndexCacheUsage')
	delete from GxQscripts where name = 'ParseIndexCacheUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseIndexCacheUsage')
	delete from GXDBVersions where aliasname = 'ParseIndexCacheUsage'
GO

insert into GXDBVersions values(2, 'ParseIndexCacheUsage',  '00010004000000000000', 'ParseIndexCacheUsage', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseUpgradeIndexRestoreStats.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseUpgradeIndexRestoreStats.sp,v $ $Id: ParseUpgradeIndexRestoreStats.sp,v 1.3 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseUpgradeIndexRestoreStats <<<'

IF EXISTS (select * from sysobjects where name='ParseUpgradeIndexRestoreStats')
	drop procedure ParseUpgradeIndexRestoreStats
IF EXISTS (select * from GxQscripts where name='ParseUpgradeIndexRestoreStats')
	delete from GxQscripts where name = 'ParseUpgradeIndexRestoreStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseUpgradeIndexRestoreStats')
	delete from GXDBVersions where aliasname = 'ParseUpgradeIndexRestoreStats'
GO
print '... Creating Procedure: ParseUpgradeIndexRestoreStats'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseUpgradeIndexRestoreStats
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 85
SELECT @ErrorString = 'UpgradeIndexRestoreStats - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyUpgradeIndexRestoreStats
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@MaName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@IndexRestoreJobCount', 'BIGINT'),
		csInfo.n.value('@TotalCapacityMB', 'BIGINT'),
		csInfo.n.value('@DiskUsageMB', 'BIGINT'),
		csInfo.n.value('@FreeDiskSpaceMB', 'BIGINT'),
		1,
		3
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/IndexRestoreInfo/IndexRestoreStatsForPre3Days/IndexRestoreStats') AS csInfo(n)
	INSERT INTO cf_SurveyUpgradeIndexRestoreStats
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@MaName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@IndexRestoreJobCount', 'BIGINT'),
		csInfo.n.value('@TotalCapacityMB', 'BIGINT'),
		csInfo.n.value('@DiskUsageMB', 'BIGINT'),
		csInfo.n.value('@FreeDiskSpaceMB', 'BIGINT'),
		1,
		7
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/IndexRestoreInfo/IndexRestoreStatsForPre7Days/IndexRestoreStats') AS csInfo(n)
	INSERT INTO cf_SurveyUpgradeIndexRestoreStats
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@MaName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@IndexRestoreJobCount', 'BIGINT'),
		csInfo.n.value('@TotalCapacityMB', 'BIGINT'),
		csInfo.n.value('@DiskUsageMB', 'BIGINT'),
		csInfo.n.value('@FreeDiskSpaceMB', 'BIGINT'),
		1,
		21
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/IndexRestoreInfo/IndexRestoreStatsForPre21Days/IndexRestoreStats') AS csInfo(n)
	INSERT INTO cf_SurveyUpgradeIndexRestoreStats
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@MaName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@IndexRestoreJobCount', 'BIGINT'),
		csInfo.n.value('@TotalCapacityMB', 'BIGINT'),
		csInfo.n.value('@DiskUsageMB', 'BIGINT'),
		csInfo.n.value('@FreeDiskSpaceMB', 'BIGINT'),
		2,
		3
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/IndexRestoreInfo/IndexRestoreStatsForPost3Days/IndexRestoreStats') AS csInfo(n)
	INSERT INTO cf_SurveyUpgradeIndexRestoreStats
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@MaName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@IndexRestoreJobCount', 'BIGINT'),
		csInfo.n.value('@TotalCapacityMB', 'BIGINT'),
		csInfo.n.value('@DiskUsageMB', 'BIGINT'),
		csInfo.n.value('@FreeDiskSpaceMB', 'BIGINT'),
		2,
		7
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/IndexRestoreInfo/IndexRestoreStatsForPost7Days/IndexRestoreStats') AS csInfo(n)
	INSERT INTO cf_SurveyUpgradeIndexRestoreStats
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@MaName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@IndexRestoreJobCount', 'BIGINT'),
		csInfo.n.value('@TotalCapacityMB', 'BIGINT'),
		csInfo.n.value('@DiskUsageMB', 'BIGINT'),
		csInfo.n.value('@FreeDiskSpaceMB', 'BIGINT'),
		2,
		21
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/IndexRestoreInfo/IndexRestoreStatsForPost21Days/IndexRestoreStats') AS csInfo(n)
	INSERT INTO cf_SurveyUpgradeIndexRestoreStats
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@MaName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@IndexRestoreJobCount', 'BIGINT'),
		csInfo.n.value('@TotalCapacityMB', 'BIGINT'),
		csInfo.n.value('@DiskUsageMB', 'BIGINT'),
		csInfo.n.value('@FreeDiskSpaceMB', 'BIGINT'),
		3,
		3
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/IndexRestoreInfo/IndexRestoreStatsForLatest3Days/IndexRestoreStats') AS csInfo(n)
	INSERT INTO cf_SurveyUpgradeIndexRestoreStats
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@MaName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@IndexRestoreJobCount', 'BIGINT'),
		csInfo.n.value('@TotalCapacityMB', 'BIGINT'),
		csInfo.n.value('@DiskUsageMB', 'BIGINT'),
		csInfo.n.value('@FreeDiskSpaceMB', 'BIGINT'),
		3,
		7
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/IndexRestoreInfo/IndexRestoreStatsForLatest7Days/IndexRestoreStats') AS csInfo(n)
	INSERT INTO cf_SurveyUpgradeIndexRestoreStats
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@MaName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@IndexRestoreJobCount', 'BIGINT'),
		csInfo.n.value('@TotalCapacityMB', 'BIGINT'),
		csInfo.n.value('@DiskUsageMB', 'BIGINT'),
		csInfo.n.value('@FreeDiskSpaceMB', 'BIGINT'),
		3,
		21
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/IndexRestoreInfo/IndexRestoreStatsForLatest21Days/IndexRestoreStats') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'UpgradeIndexRestoreStats  - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'UpgradeIndexRestoreStats  - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseUpgradeIndexRestoreStats')
	delete from GxQscripts where name = 'ParseUpgradeIndexRestoreStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseUpgradeIndexRestoreStats')
	delete from GXDBVersions where aliasname = 'ParseUpgradeIndexRestoreStats'
GO

insert into GXDBVersions values(2, 'ParseUpgradeIndexRestoreStats',  '00010003000000000000', 'ParseUpgradeIndexRestoreStats', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Parse_81CommCellClientMAVersion.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Parse_81CommCellClientMAVersion.sp,v $ $Id: Parse_81CommCellClientMAVersion.sp,v 1.4 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Parse_81CommCellClientMAVersion <<<'

IF EXISTS (select * from sysobjects where name='Parse_81CommCellClientMAVersion')
	drop procedure Parse_81CommCellClientMAVersion
IF EXISTS (select * from GxQscripts where name='Parse_81CommCellClientMAVersion')
	delete from GxQscripts where name = 'Parse_81CommCellClientMAVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_81CommCellClientMAVersion')
	delete from GXDBVersions where aliasname = 'Parse_81CommCellClientMAVersion'
GO
print '... Creating Procedure: Parse_81CommCellClientMAVersion'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Parse_81CommCellClientMAVersion
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 81
SELECT @ErrorString = 'Parse_81CommCellClientMAVersion Statistics - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		INSERT INTO cf_Survey81CommCellClientMAVersion
SELECT
files.CommcellIdNameMap_ID,
results.CommservSurveyResults_ID,
results.LogDateUTC,
results.LogDate,
Nodes.value('@NodeId' , '[INT]'),
Nodes.value('@StatusId' , '[INT]'),
Nodes.value('@TypeofNode' , '[NVARCHAR](30)'),
Nodes.value('@Status' , '[NVARCHAR](30)'),
Nodes.value('@Count' , '[INT]')
FROM
cf_CommservSurveyResults AS results
INNER JOIN cf_CustomerFeedbackXmlFile AS files
ON files.ShredStatus = 1
AND files.ID = results.CustomerFeedbackXmlFile_ID
AND results.ShredStatus = 1
AND results.QueryId = @surveyId
AND files.ParseTime = @parseTime
CROSS apply results.CollectedResults.nodes('CommCellClientMAVersion') AS CommCellClientMAVersion(CommCellClientMAVersion)
CROSS apply CommCellClientMAVersion.nodes('Nodes') AS Nodes(Nodes)
WHERE Nodes.value('@NodeId' , '[INT]') IS NOT NULL
OR Nodes.value('@StatusId' , '[INT]') IS NOT NULL
		IF (@ProcessSurveyResultTran = 1)
		BEGIN
			COMMIT TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 0
		END
		SELECT @ErrorCode = 0
		SELECT @ErrorString ='Parse_81CommCellClientMAVersion Statistics - complete'
		IF @isPrintOn = 1
			PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
		BEGIN
		ROLLBACK TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
		SELECT @ErrorCode = 1
		SELECT @ErrorString ='Parse_81CommCellClientMAVersion Statistics - failed with error :: ' + ERROR_MESSAGE()
		IF @isPrintOn = 1
			PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
		END
	END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Parse_81CommCellClientMAVersion')
	delete from GxQscripts where name = 'Parse_81CommCellClientMAVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_81CommCellClientMAVersion')
	delete from GXDBVersions where aliasname = 'Parse_81CommCellClientMAVersion'
GO

insert into GXDBVersions values(2, 'Parse_81CommCellClientMAVersion',  '00010004000000000000', 'Parse_81CommCellClientMAVersion', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Parse_78TblSIDBStoreAndBaselineSize.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Parse_78TblSIDBStoreAndBaselineSize.sp,v $ $Id: Parse_78TblSIDBStoreAndBaselineSize.sp,v 1.4 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Parse_78TblSIDBStoreAndBaselineSize <<<'

IF EXISTS (select * from sysobjects where name='Parse_78TblSIDBStoreAndBaselineSize')
	drop procedure Parse_78TblSIDBStoreAndBaselineSize
IF EXISTS (select * from GxQscripts where name='Parse_78TblSIDBStoreAndBaselineSize')
	delete from GxQscripts where name = 'Parse_78TblSIDBStoreAndBaselineSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_78TblSIDBStoreAndBaselineSize')
	delete from GXDBVersions where aliasname = 'Parse_78TblSIDBStoreAndBaselineSize'
GO
print '... Creating Procedure: Parse_78TblSIDBStoreAndBaselineSize'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Parse_78TblSIDBStoreAndBaselineSize
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 78
SELECT @ErrorString = 'Parse_78TblSIDBStoreAndBaselineSize Statistics - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		INSERT INTO cf_Survey78TblSIDBStoreAndBaselineSize
SELECT
files.CommcellIdNameMap_ID,
results.CommservSurveyResults_ID,
results.LogDateUTC,
results.LogDate,
SIDBStrIdBlS.value('@SIDBStrId' , '[INT]'),
SIDBStrIdBlS.value('@SPName' , '[NVARCHAR](256)'),
SIDBStrIdBlS.value('@SIDBStoreAliasName' , '[NVARCHAR](256)'),
SIDBStrIdBlS.value('@StoragePolicyCpy' , '[NVARCHAR](256)'),
SIDBStrIdBlS.value('@totalAppSize' , '[BIGINT]'),
SIDBStrIdBlS.value('@sizeOnMedia' , '[BIGINT]'),
SIDBStrIdBlS.value('@BaselineSize' , '[BIGINT]'),
SIDBStrIdBlS.value('@PolicyId' , '[INT]'),
SIDBStrIdBlS.value('@CopyId' , '[INT]')
FROM
cf_CommservSurveyResults AS results
INNER JOIN cf_CustomerFeedbackXmlFile AS files
ON files.ShredStatus = 1
AND files.ID = results.CustomerFeedbackXmlFile_ID
AND results.ShredStatus = 1
AND results.QueryId = @surveyId
AND files.ParseTime = @parseTime
CROSS apply results.CollectedResults.nodes('TblSIDBStoreAndBaselineSize') AS TblSIDBStoreAndBaselineSize(TblSIDBStoreAndBaselineSize)
CROSS apply TblSIDBStoreAndBaselineSize.nodes('SIDBStrIdBlS') AS SIDBStrIdBlS(SIDBStrIdBlS)
WHERE SIDBStrIdBlS.value('@PolicyId' , '[INT]') IS NOT NULL
	  AND SIDBStrIdBlS.value('@CopyId' , '[INT]') IS NOT NULL
		IF (@ProcessSurveyResultTran = 1)
		BEGIN
			COMMIT TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 0
		END
		SELECT @ErrorCode = 0
		SELECT @ErrorString ='Parse_78TblSIDBStoreAndBaselineSize Statistics - complete'
		IF @isPrintOn = 1
			PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
		BEGIN
		ROLLBACK TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
		SELECT @ErrorCode = 1
		SELECT @ErrorString ='Parse_78TblSIDBStoreAndBaselineSize Statistics - failed with error :: ' + ERROR_MESSAGE()
		IF @isPrintOn = 1
			PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
		END
	END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Parse_78TblSIDBStoreAndBaselineSize')
	delete from GxQscripts where name = 'Parse_78TblSIDBStoreAndBaselineSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_78TblSIDBStoreAndBaselineSize')
	delete from GXDBVersions where aliasname = 'Parse_78TblSIDBStoreAndBaselineSize'
GO

insert into GXDBVersions values(2, 'Parse_78TblSIDBStoreAndBaselineSize',  '00010004000000000000', 'Parse_78TblSIDBStoreAndBaselineSize', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Parse_91ProtectedDataPerAgent6WeekInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Parse_91ProtectedDataPerAgent6WeekInfo.sp,v $ $Id: Parse_91ProtectedDataPerAgent6WeekInfo.sp,v 1.5 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Parse_91ProtectedDataPerAgent6WeekInfo <<<'

IF EXISTS (select * from sysobjects where name='Parse_91ProtectedDataPerAgent6WeekInfo')
	drop procedure Parse_91ProtectedDataPerAgent6WeekInfo
IF EXISTS (select * from GxQscripts where name='Parse_91ProtectedDataPerAgent6WeekInfo')
	delete from GxQscripts where name = 'Parse_91ProtectedDataPerAgent6WeekInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_91ProtectedDataPerAgent6WeekInfo')
	delete from GXDBVersions where aliasname = 'Parse_91ProtectedDataPerAgent6WeekInfo'
GO
print '... Creating Procedure: Parse_91ProtectedDataPerAgent6WeekInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Parse_91ProtectedDataPerAgent6WeekInfo
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 91
SELECT @ErrorString = 'Parse_91ProtectedDataPerAgent6WeekInfo Statistics - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		INSERT INTO cf_Survey91ProtectedDataPerAgent6WeekInfo
SELECT
files.CommcellIdNameMap_ID,
results.CommservSurveyResults_ID,
results.LogDateUTC,
results.LogDate,
Agent.value('@weekNo' , '[INT]'),
Agent.value('@AgentType' , '[NVARCHAR](256)'),
Agent.value('@AgentTypeId' , '[INT]'),
Agent.value('@FullAppSize' , '[BIGINT]'),
Agent.value('@NonFullAppSize' , '[BIGINT]'),
Agent.value('@FullJobCount' , '[INT]'),
Agent.value('@NonFullJobCount' , '[INT]'),
Agent.value('@endDate' , '[DATE]')
FROM
cf_CommservSurveyResults AS results
INNER JOIN cf_CustomerFeedbackXmlFile AS files
ON files.ShredStatus = 1
AND files.ID = results.CustomerFeedbackXmlFile_ID
AND results.ShredStatus = 1
AND results.QueryId = @surveyId
AND files.ParseTime = @parseTime
CROSS apply results.CollectedResults.nodes('ProtectedDataPerAgent6WeekInfo') AS ProtectedDataPerAgent6WeekInfo(ProtectedDataPerAgent6WeekInfo)
CROSS apply ProtectedDataPerAgent6WeekInfo.nodes('Agent') AS Agent(Agent)
		IF (@ProcessSurveyResultTran = 1)
		BEGIN
			COMMIT TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 0
		END
		SELECT @ErrorCode = 0
		SELECT @ErrorString ='Parse_91ProtectedDataPerAgent6WeekInfo Statistics - complete'
		IF @isPrintOn = 1
			PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END TRY
	BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
		BEGIN
		ROLLBACK TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
		SELECT @ErrorCode = 1
		SELECT @ErrorString ='Parse_91ProtectedDataPerAgent6WeekInfo Statistics - failed with error :: ' + ERROR_MESSAGE()
		IF @isPrintOn = 1
			PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
		END
	END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Parse_91ProtectedDataPerAgent6WeekInfo')
	delete from GxQscripts where name = 'Parse_91ProtectedDataPerAgent6WeekInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_91ProtectedDataPerAgent6WeekInfo')
	delete from GXDBVersions where aliasname = 'Parse_91ProtectedDataPerAgent6WeekInfo'
GO

insert into GXDBVersions values(2, 'Parse_91ProtectedDataPerAgent6WeekInfo',  '00010005000000000000', 'Parse_91ProtectedDataPerAgent6WeekInfo', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseSourceDeDupEfficiency.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseSourceDeDupEfficiency.sp,v $ $Id: ParseSourceDeDupEfficiency.sp,v 1.4 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseSourceDeDupEfficiency <<<'

IF EXISTS (select * from sysobjects where name='ParseSourceDeDupEfficiency')
	drop procedure ParseSourceDeDupEfficiency
IF EXISTS (select * from GxQscripts where name='ParseSourceDeDupEfficiency')
	delete from GxQscripts where name = 'ParseSourceDeDupEfficiency'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseSourceDeDupEfficiency')
	delete from GXDBVersions where aliasname = 'ParseSourceDeDupEfficiency'
GO
print '... Creating Procedure: ParseSourceDeDupEfficiency'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseSourceDeDupEfficiency
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 97
SELECT @ErrorString = 'Network Efficiency - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveySourceDeDupEfficiency (
		CommServUniqueId, SurveyResultId, LogDateUTC, LogDate,
		NonMAClients, NonMASubClients, NonMASCWithSourceDeDup, AvgDeDupSavings)
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@NonMAClients', 'BIGINT'),
		csInfo.n.value('@NonMASubClients', 'BIGINT'),
		csInfo.n.value('@NonMASCWithSourceDeDup', 'BIGINT'),
		csInfo.n.value('@AvgDeDupSavings', 'FLOAT')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/SourceDeDupEfficiency') AS csInfo(n)
	INSERT INTO cf_SurveySubclientsNoSourceDedup (
		SurveyResultId, ClientName, AgentName, InstanceName, BackupsetName, SubclientName, SubclientDedupProp, ClientDedupProp,
		StoragePolicyName, PrimaryCopyName, DedupOnSource, ProtectedBytes, NwTransBytes)
	SELECT
		results.CommservSurveyResults_ID,
		csInfo.n.value('@client','NVARCHAR(256)'),
		csInfo.n.value('@agent','VARCHAR(256)'),
		csInfo.n.value('@instance','NVARCHAR(512)'),
		csInfo.n.value('@backupset','NVARCHAR(128)'),
		csInfo.n.value('@subclient','NVARCHAR(128)'),
		ISNULL(csInfo.n.value('@subclientDedupProp','INT'), 0),
		ISNULL(csInfo.n.value('@clientDedupProp','INT'), 0),
		ISNULL(csInfo.n.value('@storagePolicy','NVARCHAR(144)'), ''),
		ISNULL(csInfo.n.value('@primaryCopy','NVARCHAR(64)'), ''),
		ISNULL(csInfo.n.value('@dedupOnSource','INT'), 0),
		ISNULL(csInfo.n.value('@protectedBytes','BIGINT'), 0),
		ISNULL(csInfo.n.value('@nwTransBytes','BIGINT'), 0)
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('/SourceDeDupEfficiency/Subclient') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Network Efficiency - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Network Efficiency - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseSourceDeDupEfficiency')
	delete from GxQscripts where name = 'ParseSourceDeDupEfficiency'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseSourceDeDupEfficiency')
	delete from GXDBVersions where aliasname = 'ParseSourceDeDupEfficiency'
GO

insert into GXDBVersions values(2, 'ParseSourceDeDupEfficiency',  '00010004000000000000', 'ParseSourceDeDupEfficiency', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Parse_unfinishedJobs.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Parse_unfinishedJobs.sp,v $ $Id: Parse_unfinishedJobs.sp,v 1.3 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Parse_unfinishedJobs <<<'

IF EXISTS (select * from sysobjects where name='Parse_unfinishedJobs')
	drop procedure Parse_unfinishedJobs
IF EXISTS (select * from GxQscripts where name='Parse_unfinishedJobs')
	delete from GxQscripts where name = 'Parse_unfinishedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_unfinishedJobs')
	delete from GXDBVersions where aliasname = 'Parse_unfinishedJobs'
GO
print '... Creating Procedure: Parse_unfinishedJobs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Parse_unfinishedJobs
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 103
SELECT @ErrorString = 'Parse_unfinishedJobs - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyunfinishedJobs
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		unfinishedJob.value('@jobId' , '[BIGINT]'),
		unfinishedJob.value('@clientName' , '[NVARCHAR](1024)'),
		unfinishedJob.value('@idataagent' , '[NVARCHAR](1024)'),
		unfinishedJob.value('@instance' , '[NVARCHAR](1024)'),
		unfinishedJob.value('@backupset' , '[NVARCHAR](1024)'),
		unfinishedJob.value('@subclient' , '[NVARCHAR](1024)'),
		unfinishedJob.value('@data_sp' , '[NVARCHAR](1024)'),
		unfinishedJob.value('@backuplevel' , '[NVARCHAR](64)'),
		unfinishedJob.value('@jobstatus' , '[NVARCHAR](20)'),
		unfinishedJob.value('@jobfailedreason' , '[NVARCHAR](MAX)'),
		unfinishedJob.value('@startdateUTC' , '[INT]'),
		unfinishedJob.value('@enddateUTC' , '[INT]')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('unfinishedJobsXML') AS unfinishedJobsXML(unfinishedJobsXML)
	CROSS apply unfinishedJobsXML.nodes('unfinishedJob') AS unfinishedJob(unfinishedJob)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Parse_unfinishedJobs  - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Parse_unfinishedJobs  - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Parse_unfinishedJobs')
	delete from GxQscripts where name = 'Parse_unfinishedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_unfinishedJobs')
	delete from GXDBVersions where aliasname = 'Parse_unfinishedJobs'
GO

insert into GXDBVersions values(2, 'Parse_unfinishedJobs',  '00010003000000000000', 'Parse_unfinishedJobs', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseTapeMediaMgmt.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseTapeMediaMgmt.sp,v $ $Id: ParseTapeMediaMgmt.sp,v 1.3 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseTapeMediaMgmt <<<'

IF EXISTS (select * from sysobjects where name='ParseTapeMediaMgmt')
	drop procedure ParseTapeMediaMgmt
IF EXISTS (select * from GxQscripts where name='ParseTapeMediaMgmt')
	delete from GxQscripts where name = 'ParseTapeMediaMgmt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseTapeMediaMgmt')
	delete from GXDBVersions where aliasname = 'ParseTapeMediaMgmt'
GO
print '... Creating Procedure: ParseTapeMediaMgmt'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseTapeMediaMgmt
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 113
SELECT @ErrorString = 'Tape Media Management - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyTapeMediaMgmt
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@TapeLibUsed', 'INTEGER'),
		csInfo.n.value('@VTPolicyUsed', 'INTEGER'),
		csInfo.n.value('@VTEntFeatureEnabled', 'INTEGER')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/TapeMediaInfo') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Tape Media Management - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Tape Media Management - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseTapeMediaMgmt')
	delete from GxQscripts where name = 'ParseTapeMediaMgmt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseTapeMediaMgmt')
	delete from GXDBVersions where aliasname = 'ParseTapeMediaMgmt'
GO

insert into GXDBVersions values(2, 'ParseTapeMediaMgmt',  '00010003000000000000', 'ParseTapeMediaMgmt', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseSelfServiceInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseSelfServiceInfo.sp,v $ $Id: ParseSelfServiceInfo.sp,v 1.3 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseSelfServiceInfo <<<'

IF EXISTS (select * from sysobjects where name='ParseSelfServiceInfo')
	drop procedure ParseSelfServiceInfo
IF EXISTS (select * from GxQscripts where name='ParseSelfServiceInfo')
	delete from GxQscripts where name = 'ParseSelfServiceInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseSelfServiceInfo')
	delete from GXDBVersions where aliasname = 'ParseSelfServiceInfo'
GO
print '... Creating Procedure: ParseSelfServiceInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseSelfServiceInfo
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 114
SELECT @ErrorString = 'Self-Service - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveySelfServiceInfo
	SELECT
		files.CommcellIdNameMap_ID,
		results.CommservSurveyResults_ID,
		results.LogDateUTC,
		results.LogDate,
		csInfo.n.value('@PkgID', 'INTEGER'),
		csInfo.n.value('@PkgName', 'VARCHAR(256)'),
		csInfo.n.value('@ClientCounts', 'INTEGER')
	FROM
	cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
			ON files.ShredStatus = 1
			AND files.ID = results.CustomerFeedbackXmlFile_ID
			AND results.ShredStatus = 1
			AND results.QueryId = @surveyId
			AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('/WebPackageInfo') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Self-Service - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString = 'Self-Service - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseSelfServiceInfo')
	delete from GxQscripts where name = 'ParseSelfServiceInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseSelfServiceInfo')
	delete from GXDBVersions where aliasname = 'ParseSelfServiceInfo'
GO

insert into GXDBVersions values(2, 'ParseSelfServiceInfo',  '00010003000000000000', 'ParseSelfServiceInfo', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseVMWithAgentInstalled.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseVMWithAgentInstalled.sp,v $ $Id: ParseVMWithAgentInstalled.sp,v 1.3 2015/04/20 17:42:16 pushpendrasingh Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseVMWithAgentInstalled <<<'

IF EXISTS (select * from sysobjects where name='ParseVMWithAgentInstalled')
	drop procedure ParseVMWithAgentInstalled
IF EXISTS (select * from GxQscripts where name='ParseVMWithAgentInstalled')
	delete from GxQscripts where name = 'ParseVMWithAgentInstalled'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseVMWithAgentInstalled')
	delete from GXDBVersions where aliasname = 'ParseVMWithAgentInstalled'
GO
print '... Creating Procedure: ParseVMWithAgentInstalled'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseVMWithAgentInstalled
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
-------------------------------------------------------------------------------
-- Looping for each result:
--   Commit transaction for each result
--   Set ShredStatus = 3 immediately on error so it will be skipped in future
-- Always return ErrorCode = 0 so parsed results will be set to ShredStatus = 2
-------------------------------------------------------------------------------
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 166
SELECT @ErrorCode = 0, @ErrorString = 'Parsing results for Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
DECLARE @CSUniqueId INT = 0
DECLARE @ResultId INT = 0
DECLARE @LogDateUTC datetime
DECLARE @LogDate    datetime
DECLARE	SurveyResultCur CURSOR FOR
SELECT	F.CommcellIdNameMap_ID, R.CommservSurveyResults_ID, R.LogDateUTC,R.LogDate
FROM	cf_CommservSurveyResults AS R INNER JOIN cf_CustomerFeedbackXmlFile AS F
	 ON F.ID = R.CustomerFeedbackXmlFile_ID
	AND F.ParseTime = @parseTime
	AND F.ShredStatus = 1
	AND R.ShredStatus = 1
	AND R.QueryId = @surveyId
ORDER BY R.LogDateUTC
OPEN SurveyResultCur
FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId,@LogDateUTC,  @LogDate
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @ErrorCode = 0
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		ELSE
			SET @ProcessSurveyResultTran = 0
		INSERT INTO cf_SurveyVMWithAgentInstalled
		(	CommServUniqueId,
			SurveyResultId,
			Name,
			Value,
			Size
		)
		SELECT
			@CSUniqueId,
			@ResultId,
			VMWithAgentInstalled.value('@name', 'NVARCHAR(MAX)'),
			VMWithAgentInstalled.value('@value', 'BIGINT'),
			VMWithAgentInstalled.value('@size', 'BIGINT')
		FROM
			cf_CommservSurveyResults
			CROSS apply CollectedResults.nodes('VMWithAgentInstalled') AS VMWithAgentInstalled(VMWithAgentInstalled)
		WHERE
			CommservSurveyResults_ID = @ResultId
		IF (@ProcessSurveyResultTran = 1)
			COMMIT TRANSACTION ProcessSurveyResultTran
	END TRY
	BEGIN CATCH
		SELECT	@ErrorCode = 1,
				@ErrorString = 'Query ID ' + CAST(@surveyId AS VARCHAR(20))
					+ ' - Parsing failed for Result ID ' + CAST(@ResultId AS VARCHAR(20)) + ' with error :: ' + ERROR_MESSAGE()
		IF (@ProcessSurveyResultTran = 1)
			ROLLBACK TRANSACTION ProcessSurveyResultTran
	END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId
		IF @isPrintOn = 1 PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
	FETCH FROM SurveyResultCur INTO @CSUniqueId, @ResultId,@LogDateUTC,  @LogDate
END
CLOSE SurveyResultCur
DEALLOCATE SurveyResultCur
SET @ErrorCode = 0
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseVMWithAgentInstalled')
	delete from GxQscripts where name = 'ParseVMWithAgentInstalled'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseVMWithAgentInstalled')
	delete from GXDBVersions where aliasname = 'ParseVMWithAgentInstalled'
GO

insert into GXDBVersions values(2, 'ParseVMWithAgentInstalled',  '00010003000000000000', 'ParseVMWithAgentInstalled', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Rpt_78TblSIDBStoreAndBaselineSize.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Rpt_78TblSIDBStoreAndBaselineSize.sp,v $ $Id: Rpt_78TblSIDBStoreAndBaselineSize.sp,v 1.5 2014/07/28 21:50:58 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Rpt_78TblSIDBStoreAndBaselineSize <<<'

IF EXISTS (select * from sysobjects where name='Rpt_78TblSIDBStoreAndBaselineSize')
	drop procedure Rpt_78TblSIDBStoreAndBaselineSize
IF EXISTS (select * from GxQscripts where name='Rpt_78TblSIDBStoreAndBaselineSize')
	delete from GxQscripts where name = 'Rpt_78TblSIDBStoreAndBaselineSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_78TblSIDBStoreAndBaselineSize')
	delete from GXDBVersions where aliasname = 'Rpt_78TblSIDBStoreAndBaselineSize'
GO
print '... Creating Procedure: Rpt_78TblSIDBStoreAndBaselineSize'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Rpt_78TblSIDBStoreAndBaselineSize
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 78
IF(@blaggregate=1)
	RETURN
ELSE
BEGIN
	SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	resultView.CommServGUID AS 'CommServer GUID',
	ISNULL(resultView.CustomerName, '')  AS 'Customer Name',
	ISNULL((CONVERT(VARCHAR(20), csInfo.LogDate, 100) + ' (' + resultView.CommServTimeZone + ')'), 'N/A') AS 'Collection Time (TimeZone)',
	CASE
	WHEN resultView.RunningTime = -1 THEN 'N/A'
	ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
	END AS 'Running Time in Seconds',
	csInfo.SIDBStrId  AS SIDBStrId,
	csInfo.SPName  AS SPName,
	csInfo.SIDBStoreAliasName  AS SIDBStoreAliasName,
	csInfo.StoragePolicyCpy  AS StoragePolicyCpy,
	CAST(((csInfo.totalAppSize)/(1024.0*1024.0))AS decimal(32,6)) AS totalAppSizeMB,
	CAST(((csInfo.sizeOnMedia)/(1024.0*1024.0))AS decimal(32,6)) AS sizeOnMediaMB,
	CAST(((csInfo.BaselineSize)/(1024.0*1024.0)) AS decimal(32,6)) AS BaselineSizeMB
	FROM cf_Survey78TblSIDBStoreAndBaselineSize AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
	ON resultView.SurverResultId = csInfo.SurveyResultId
	AND resultView.LogDateUTC = csInfo.LogDateUTC
	AND resultView.CommServUniqueId = csInfo.CommServUniqueId
	AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
	AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
	ORDER BY csInfo.LogDate DESC, resultView.CustomerName ASC
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Rpt_78TblSIDBStoreAndBaselineSize')
	delete from GxQscripts where name = 'Rpt_78TblSIDBStoreAndBaselineSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_78TblSIDBStoreAndBaselineSize')
	delete from GXDBVersions where aliasname = 'Rpt_78TblSIDBStoreAndBaselineSize'
GO

insert into GXDBVersions values(2, 'Rpt_78TblSIDBStoreAndBaselineSize',  '00010005000000000000', 'Rpt_78TblSIDBStoreAndBaselineSize', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Rpt_81CommCellClientMAVersion.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Rpt_81CommCellClientMAVersion.sp,v $ $Id: Rpt_81CommCellClientMAVersion.sp,v 1.5 2014/07/28 21:48:20 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Rpt_81CommCellClientMAVersion <<<'

IF EXISTS (select * from sysobjects where name='Rpt_81CommCellClientMAVersion')
	drop procedure Rpt_81CommCellClientMAVersion
IF EXISTS (select * from GxQscripts where name='Rpt_81CommCellClientMAVersion')
	delete from GxQscripts where name = 'Rpt_81CommCellClientMAVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_81CommCellClientMAVersion')
	delete from GXDBVersions where aliasname = 'Rpt_81CommCellClientMAVersion'
GO
print '... Creating Procedure: Rpt_81CommCellClientMAVersion'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Rpt_81CommCellClientMAVersion
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 81
IF(@blaggregate=1)
	RETURN
ELSE
BEGIN
	SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	resultView.CommServGUID AS 'CommServer GUID',
	ISNULL(resultView.CustomerName, '')  AS 'Customer Name',
	ISNULL((CONVERT(VARCHAR(20), csInfo.LogDate, 100) + ' (' + resultView.CommServTimeZone + ')'), 'N/A') AS 'Collection Time (TimeZone)',
	CASE
	WHEN resultView.RunningTime = -1 THEN 'N/A'
	ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
	END AS 'Running Time in Seconds',
	csInfo.Nodes_NodeId  AS Nodes_NodeId,
    csInfo.Nodes_StatusId  AS Nodes_StatusId,
    csInfo.Nodes_TypeofNode  AS Nodes_TypeofNode,
    csInfo.Nodes_Status  AS Nodes_Status,
    csInfo.Nodes_Count  AS Nodes_Count
	FROM cf_Survey81CommCellClientMAVersion AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
	ON resultView.SurverResultId = csInfo.SurveyResultId
	AND resultView.LogDateUTC = csInfo.LogDateUTC
	AND resultView.CommServUniqueId = csInfo.CommServUniqueId
	AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
	AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
	ORDER BY csInfo.LogDate DESC, resultView.CustomerName ASC
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Rpt_81CommCellClientMAVersion')
	delete from GxQscripts where name = 'Rpt_81CommCellClientMAVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_81CommCellClientMAVersion')
	delete from GXDBVersions where aliasname = 'Rpt_81CommCellClientMAVersion'
GO

insert into GXDBVersions values(2, 'Rpt_81CommCellClientMAVersion',  '00010005000000000000', 'Rpt_81CommCellClientMAVersion', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Rpt_91ProtectedDataPerAgent6WeekInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Rpt_91ProtectedDataPerAgent6WeekInfo.sp,v $ $Id: Rpt_91ProtectedDataPerAgent6WeekInfo.sp,v 1.7 2015/01/22 02:55:10 ashajikumar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Rpt_91ProtectedDataPerAgent6WeekInfo <<<'

IF EXISTS (select * from sysobjects where name='Rpt_91ProtectedDataPerAgent6WeekInfo')
	drop procedure Rpt_91ProtectedDataPerAgent6WeekInfo
IF EXISTS (select * from GxQscripts where name='Rpt_91ProtectedDataPerAgent6WeekInfo')
	delete from GxQscripts where name = 'Rpt_91ProtectedDataPerAgent6WeekInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_91ProtectedDataPerAgent6WeekInfo')
	delete from GXDBVersions where aliasname = 'Rpt_91ProtectedDataPerAgent6WeekInfo'
GO
print '... Creating Procedure: Rpt_91ProtectedDataPerAgent6WeekInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Rpt_91ProtectedDataPerAgent6WeekInfo
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 91
DECLARE @TblSize TABLE (
	weekNo INT,
	endDate DATE,
	AgentType VARCHAR(256),
	FullAppSize FLOAT,
	NonFullAppSize FLOAT,
	FullJobCount INT,
	NonFullJobCount INT,
	TotalSizeChangePct FLOAT
	)
INSERT INTO @TblSize
SELECT
csInfo.weekNo,
csInfo.endDate,
csInfo.AgentType,
SUM(csInfo.FullAppSize)/(1024.0*1024.0*1024.0)  ,
SUM(csInfo.NonFullAppSize)/(1024.0*1024.0*1024.0)  ,
SUM(csInfo.FullJobCount)  ,
SUM(csInfo.NonFullJobCount)  ,0.0
FROM cf_Survey91ProtectedDataPerAgent6WeekInfo AS csInfo WITH (NOLOCK)
INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
ON resultView.SurverResultId = csInfo.SurveyResultId
AND resultView.LogDateUTC = csInfo.LogDateUTC
AND resultView.CommServUniqueId = csInfo.CommServUniqueId
AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
GROUP BY csInfo.AgentType,csInfo.weekNo,csInfo.endDate
UPDATE	@TblSize
SET		TotalSizeChangePct = CASE WHEN T.totalSize = 0 THEN 0
	ELSE 100.0*(S.FullAppSize + S.NonFullAppSize - T.totalSize)/T.totalSize END
FROM	@TblSize S
INNER JOIN (SELECT weekNo ,AgentType ,(FullAppSize + NonFullAppSize) AS totalSize FROM @TblSize) T
	ON S.weekNo = (T.weekNo + 1) AND S.AgentType = T.AgentType
IF(@blaggregate=1)
BEGIN
	DECLARE @TotalFull FLOAT
	DECLARE @TotalNonFull FLOAT
	SELECT @TotalFull=SUM(FullAppSize),@TotalNonFull=SUM(NonFullAppSize)
		FROM (SELECT AVG(FullAppSize) AS FullAppSize,
			AVG(NonFullAppSize) As NonFullAppSize
			FROM @TblSize
			GROUP BY AgentType) A
	SELECT AgentType,
			CAST(ROUND(AVG(FullAppSize),3) AS DECIMAL(20,3)) AS FullAppSizeGB,
			CAST(ROUND(AVG(NonFullAppSize),3) AS DECIMAL(20,3)) As NonFullAppSizeGB,
			CAST(ROUND(AVG(TotalSizeChangePct),2) AS DECIMAL(20,2)) AS WeeklyChange,
			CASE @TotalFull WHEN 0 THEN -1
			ELSE CAST(ROUND((AVG(FullAppSize)/@TotalFull)*100.0 ,2) AS DECIMAL(15,3)) END AS 'PerFullBckUp'
			FROM @TblSize GROUP BY AgentType ORDER BY AgentType
END
ELSE
BEGIN
	SELECT weekNo,
		   SUBSTRING(CONVERT(VARCHAR(15),endDate,101),1,5)+'-'+SUBSTRING(CONVERT(VARCHAR(15),DATEADD(DAY,-6,endDate),101),1,5) AS Interval,
		   AgentType,
		   FullAppSize,
		   NonFullAppSize,
		   FullJobCount,
		   NonFullJobCount,
		   TotalSizeChangePct
		   FROM @TblSize WHERE weekNo > 1 ORDER BY AgentType,weekNo DESC
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Rpt_91ProtectedDataPerAgent6WeekInfo')
	delete from GxQscripts where name = 'Rpt_91ProtectedDataPerAgent6WeekInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_91ProtectedDataPerAgent6WeekInfo')
	delete from GXDBVersions where aliasname = 'Rpt_91ProtectedDataPerAgent6WeekInfo'
GO

insert into GXDBVersions values(2, 'Rpt_91ProtectedDataPerAgent6WeekInfo',  '00010007000000000000', 'Rpt_91ProtectedDataPerAgent6WeekInfo', '00010007000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Rpt_106ClientVersion.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Rpt_106ClientVersion.sp,v $ $Id: Rpt_106ClientVersion.sp,v 1.7 2015/06/12 19:01:46 vmishra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Rpt_106ClientVersion <<<'

IF EXISTS (select * from sysobjects where name='Rpt_106ClientVersion')
	drop procedure Rpt_106ClientVersion
IF EXISTS (select * from GxQscripts where name='Rpt_106ClientVersion')
	delete from GxQscripts where name = 'Rpt_106ClientVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_106ClientVersion')
	delete from GXDBVersions where aliasname = 'Rpt_106ClientVersion'
GO
print '... Creating Procedure: Rpt_106ClientVersion'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Rpt_106ClientVersion
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NULL
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 77
IF @blaggregate = 1
BEGIN
	IF(@i_CommServUniqueID<=0)
	BEGIN
		IF object_id('tempdb.dbo.#TAB1') is not null
			DROP TABLE #TAB1
		IF object_id('tempdb.dbo.#MONTHS') is not null
			DROP TABLE #MONTHS
		CREATE TABLE #MONTHS (MM INT,YEARS INT)
		CREATE TABLE #TAB1 (MM INT,YY INT,MONTHS VARCHAR(15),V11 INT,V10 INT,V9 INT)
		DECLARE @CNT INT
		DECLARE @STARTDATE DATE
		SET @STARTDATE=GETUTCDATE()
		SET @CNT = 12
		WHILE @CNT >0
		BEGIN
			INSERT INTO #MONTHS VALUES(MONTH(@STARTDATE),YEAR(@STARTDATE))
			SET @STARTDATE=DATEADD(MONTH,-1,@STARTDATE)
			SET @CNT=@CNT-1
		END
		INSERT INTO #TAB1
		SELECT M.MM,M.YEARS,CONVERT(VARCHAR(15),DATEADD(MONTH,(M.YEARS-1970)*12 + M.MM - 1,'01-01-1970'), 106) AS MONTHS,
				V11 ,
				V10 ,
				V9
		FROM (SELECT MONTHS,YEARS,
			SUM(LatestVersionCount) AS V11,
			SUM(IILatestVersionCount) AS V10,
			SUM(IIILatestVersionCount) AS V9
			FROM cf_Survey106ClientVersion CC INNER JOIN cf_CommservSurveyResults CS
			ON CommcellIdNameMap_ID=CommServUniqueId
			AND CC.LogDateUTC=CS.LogDateUTC
			AND CC.SurveyResultId=CS.CommservSurveyResults_ID
			AND CS.QueryId = @i_QueryId
			AND CS.Flags = 1
			WHERE ((YEARS = YEAR(@STARTDATE) AND MONTHS >= MONTH(@STARTDATE)) OR
				  (YEARS > YEAR(@STARTDATE) AND MONTHS <= MONTH(@STARTDATE))) AND LatestVersionCount<>-1
			GROUP BY MONTHS,YEARS) A
		RIGHT OUTER JOIN #MONTHS M
			ON A.MONTHS=M.MM AND A.YEARS=M.YEARS
		DROP TABLE #MONTHS
		UPDATE #TAB1 SET V11=-1,V10=-1,V9=-1 WHERE V11 IS NULL AND V10 IS NULL AND V9 IS NULL
		SELECT MONTHS AS 'Month<clientVersion>',
			   V11 AS 'Version11 Client Count<NumberNA>',
			   V10 AS 'Version10 Client Count<NumberNA>',
			   V9 AS 'Version9 Client Count<NumberNA>'
		FROM #TAB1 ORDER BY YY,MM
		DROP TABLE #TAB1
	END
	ELSE
	BEGIN
		SELECT
		datediff(second, '01/01/1970', DATEADD(MONTH,((Years-1970)*12)+Months-1,'01/01/1970')) AS 'Month<MMMYYYY>',
		csInfo.LatestVersionCount AS 'Version11 Client Count<NumberNA>',
		csInfo.IILatestVersionCount AS 'Version10 Client Count<NumberNA>',
		csInfo.IIILatestVersionCount AS 'Version9 Client Count<NumberNA>'
		FROM cf_Survey106ClientVersion AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		ORDER BY csInfo.YEARS DESC, csInfo.MONTHS DESC
	END
END
ELSE
BEGIN
	IF @i_CommServUniqueID >0
	BEGIN
		SET @blLatestSurvey=1
		SELECT clientName AS 'Client',servicePack AS 'Client Version'
		FROM cf_Survey77ClientDetails csInfo
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND csInfo.lastbkp = 0 -- lastbkp is actually used for install status: 0 for installed, 1 for deconfigured, 2 for deleted
	END
	ELSE
		RETURN
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Rpt_106ClientVersion')
	delete from GxQscripts where name = 'Rpt_106ClientVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_106ClientVersion')
	delete from GXDBVersions where aliasname = 'Rpt_106ClientVersion'
GO

insert into GXDBVersions values(2, 'Rpt_106ClientVersion',  '00010007000000000000', 'Rpt_106ClientVersion', '00010007000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Rpt_unfinishedJobs.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Rpt_unfinishedJobs.sp,v $ $Id: Rpt_unfinishedJobs.sp,v 1.5 2014/07/28 21:50:04 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Rpt_unfinishedJobs <<<'

IF EXISTS (select * from sysobjects where name='Rpt_unfinishedJobs')
	drop procedure Rpt_unfinishedJobs
IF EXISTS (select * from GxQscripts where name='Rpt_unfinishedJobs')
	delete from GxQscripts where name = 'Rpt_unfinishedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_unfinishedJobs')
	delete from GXDBVersions where aliasname = 'Rpt_unfinishedJobs'
GO
print '... Creating Procedure: Rpt_unfinishedJobs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Rpt_unfinishedJobs
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 103
IF(@blaggregate=1)
	RETURN
IF @i_CommServUniqueID = 0
BEGIN
	DECLARE @param_isPrivate INT = 0
	SELECT  @param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
	SELECT
		resultView.CommServUniqueId  AS 'CommServ UniqueId',
		resultView.CommCellID AS 'CommCell ID',
		resultView.CommServIP AS 'CommServe IP<HIDDEN>',
		resultView.CommServGUID AS 'CommServer GUID',
		CASE
			WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
			ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
			END AS 'CommCell Name',
		DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(unfinishedJob.LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME><HIDDEN>',
		resultView.CommServTimeZone as 'TimeZone<HIDDEN>',
		CASE
			WHEN resultView.RunningTime = -1 THEN 'N/A'
			ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
			END AS 'Running Time in Seconds<HIDDEN>',
		unfinishedJob.jobId as 'Job Id',
		unfinishedJob.clientName as 'Client Name',
		unfinishedJob.idataAgent as 'iData Agent',
		unfinishedJob.instance as 'Instance<HIDDEN>',
		unfinishedJob.backupset as 'BackupSet<HIDDEN>',
		unfinishedJob.subclient as 'SubClient',
		unfinishedJob.data_sp as 'Storage Policy<HIDDEN>',
		unfinishedJob.backupLevel as 'Backup Level',
		unfinishedJob.jobStatus as 'Job Status',
		unfinishedJob.jobFailedReason as 'Job Failure Reason',
		unfinishedJob.startDateUTC as 'Start Time<DATETIME><HIDDEN>',
		unfinishedJob.endDateUTC AS 'End Time<DATETIME><HIDDEN>'
	FROM cf_SurveyunfinishedJobs AS unfinishedJob WITH (NOLOCK)
			JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId,@i_GroupId) AS resultView
				ON resultView.SurverResultId = unfinishedJob.SurveyResultId
					AND resultView.LogDateUTC = unfinishedJob.LogDateUTC
					AND resultView.CommServUniqueId = unfinishedJob.CommServUniqueId
					AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
					--AND (unfinishedJob.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
	ORDER BY unfinishedJob.LogDate DESC, resultView.CustomerName ASC
END
ELSE
BEGIN
	SELECT
		resultView.CommServUniqueId  AS 'CommServ UniqueId',
		unfinishedJob.jobId as 'Job Id',
		unfinishedJob.clientName as 'Client Name',
		unfinishedJob.idataAgent as 'iData Agent',
		unfinishedJob.instance as 'Instance',
		unfinishedJob.backupset as 'BackupSet',
		unfinishedJob.subclient as 'SubClient',
		unfinishedJob.data_sp as 'Storage Policy',
		unfinishedJob.backupLevel as 'Backup Level',
		unfinishedJob.jobStatus as 'Job Status',
		unfinishedJob.jobFailedReason as 'Job Failure Reason',
		unfinishedJob.startDateUTC as 'Start Time<DATETIME>',
		unfinishedJob.endDateUTC AS 'End Time<DATETIME>'
	FROM cf_SurveyunfinishedJobs AS unfinishedJob WITH (NOLOCK)
			JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId,@i_GroupId) AS resultView
				ON resultView.SurverResultId = unfinishedJob.SurveyResultId
					AND resultView.LogDateUTC = unfinishedJob.LogDateUTC
					AND resultView.CommServUniqueId = unfinishedJob.CommServUniqueId
					AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
					AND (unfinishedJob.CommServUniqueId = @i_CommServUniqueID)-- OR @i_CommServUniqueID = 0)
	ORDER BY unfinishedJob.LogDate DESC, resultView.CustomerName ASC
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Rpt_unfinishedJobs')
	delete from GxQscripts where name = 'Rpt_unfinishedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_unfinishedJobs')
	delete from GXDBVersions where aliasname = 'Rpt_unfinishedJobs'
GO

insert into GXDBVersions values(2, 'Rpt_unfinishedJobs',  '00010005000000000000', 'Rpt_unfinishedJobs', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptEmailDataPlacement.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptEmailDataPlacement.sp,v $ $Id: RptEmailDataPlacement.sp,v 1.7 2014/07/28 21:49:27 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptEmailDataPlacement <<<'

IF EXISTS (select * from sysobjects where name='RptEmailDataPlacement')
	drop procedure RptEmailDataPlacement
IF EXISTS (select * from GxQscripts where name='RptEmailDataPlacement')
	delete from GxQscripts where name = 'RptEmailDataPlacement'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptEmailDataPlacement')
	delete from GXDBVersions where aliasname = 'RptEmailDataPlacement'
GO
print '... Creating Procedure: RptEmailDataPlacement'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptEmailDataPlacement
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 23
DECLARE @param_isPrivate INT = 0
IF @i_CommServUniqueID = 0
BEGIN
 SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
 SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	CASE
		WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
		ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
	END AS 'CommCell Name',
	csInfo.ClientName AS 'Client',
	csInfo.AppTypeName AS 'Agent Type',
	CAST(ISNULL(csInfo.ApplicationSizeTB, 0)*1024.00*1024.00 AS DECIMAL(32,2)) AS 'Application Size<SIZEMB>',
	CAST(csInfo.TotalWriteTimeHR*60 AS INT) AS 'Transfer Time (hh:mm)<HHMM>',
	CAST(csInfo.TotalWriteTimeHR*60/2 AS INT) AS 'Estimated Transfer Time with Archive (hh:mm)<HHMM>',
	'No' AS 'OnePass / Archive Configured'
 FROM cf_SurveyLargestNoArcEmailClients AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND csInfo.ClientId <> 0
 ORDER BY csInfo.ApplicationSizeTB DESC
END
ELSE
SELECT
	csInfo.CommServUniqueId AS 'CommServ UniqueId',
	csInfo.ClientName AS 'Client',
	csInfo.AppTypeName AS 'Agent Type',
	CAST(ISNULL(csInfo.ApplicationSizeTB, 0)*1024.00*1024.00 AS DECIMAL(32,2)) AS 'Application Size<SIZEMB>',
	CAST(csInfo.TotalWriteTimeHR*60 AS INT) AS 'Transfer Time (hh:mm)<HHMM>',
	CAST(csInfo.TotalWriteTimeHR*60/2 AS INT) AS 'Estimated Transfer Time with Archive (hh:mm)<HHMM>',
	'No' AS 'OnePass / Archive Configured'
FROM cf_SurveyLargestNoArcEmailClients AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND csInfo.ClientId <> 0
ORDER BY csInfo.ApplicationSizeTB DESC
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptEmailDataPlacement')
	delete from GxQscripts where name = 'RptEmailDataPlacement'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptEmailDataPlacement')
	delete from GXDBVersions where aliasname = 'RptEmailDataPlacement'
GO

insert into GXDBVersions values(2, 'RptEmailDataPlacement',  '00010007000000000000', 'RptEmailDataPlacement', '00010007000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptTapeMediaMgmt.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptTapeMediaMgmt.sp,v $ $Id: RptTapeMediaMgmt.sp,v 1.4 2014/07/28 21:48:49 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptTapeMediaMgmt <<<'

IF EXISTS (select * from sysobjects where name='RptTapeMediaMgmt')
	drop procedure RptTapeMediaMgmt
IF EXISTS (select * from GxQscripts where name='RptTapeMediaMgmt')
	delete from GxQscripts where name = 'RptTapeMediaMgmt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptTapeMediaMgmt')
	delete from GXDBVersions where aliasname = 'RptTapeMediaMgmt'
GO
print '... Creating Procedure: RptTapeMediaMgmt'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptTapeMediaMgmt
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 113
DECLARE @param_isPrivate INT = 0
IF @i_CommServUniqueID = 0
BEGIN
 SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
 SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	CASE
		WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
		ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
	END AS 'CommCell Name',
	CASE csInfo.TapeLibUsed
		WHEN 0 THEN 'No'
		ELSE 'Yes'
	END AS 'Tape Library Used',
	CASE csInfo.VTPolicyUsed
		WHEN 0 THEN 'No'
		ELSE 'Yes'
	END
	AS 'Vault Tracker Policy Configured',
	CASE csInfo.VTEntFeatureEnabled
		WHEN 0 THEN 'No'
		ELSE 'Yes'
	END AS 'Vault Tracker Enterprise Feature'
 FROM cf_SurveyTapeMediaMgmt AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
ORDER BY 'CommCell Name' ASC
END
ELSE
SELECT
	csInfo.CommServUniqueId AS 'CommServ UniqueId',
	CASE csInfo.TapeLibUsed
		WHEN 0 THEN 'No'
		ELSE 'Yes'
	END AS 'Tape Library Used',
	CASE csInfo.VTPolicyUsed
		WHEN 0 THEN 'No'
		ELSE 'Yes'
	END
	AS 'Vault Tracker Policy Configured',
	CASE csInfo.VTEntFeatureEnabled
		WHEN 0 THEN 'No'
		ELSE 'Yes'
	END AS 'Vault Tracker Enterprise Feature'
FROM cf_SurveyTapeMediaMgmt AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptTapeMediaMgmt')
	delete from GxQscripts where name = 'RptTapeMediaMgmt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptTapeMediaMgmt')
	delete from GXDBVersions where aliasname = 'RptTapeMediaMgmt'
GO

insert into GXDBVersions values(2, 'RptTapeMediaMgmt',  '00010004000000000000', 'RptTapeMediaMgmt', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptSelfServiceInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptSelfServiceInfo.sp,v $ $Id: RptSelfServiceInfo.sp,v 1.4 2014/07/28 21:50:02 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptSelfServiceInfo <<<'

IF EXISTS (select * from sysobjects where name='RptSelfServiceInfo')
	drop procedure RptSelfServiceInfo
IF EXISTS (select * from GxQscripts where name='RptSelfServiceInfo')
	delete from GxQscripts where name = 'RptSelfServiceInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSelfServiceInfo')
	delete from GXDBVersions where aliasname = 'RptSelfServiceInfo'
GO
print '... Creating Procedure: RptSelfServiceInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptSelfServiceInfo
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 114
DECLARE @param_isPrivate INT = 0
IF @i_CommServUniqueID = 0
BEGIN
 SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
 SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	CASE
		WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
		ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
	END AS 'CommCell Name',
	csInfo.PackageName AS 'Package',
	csInfo.ClientCounts AS 'Number of Clients'
 FROM cf_SurveySelfServiceInfo AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		ORDER BY 'CommCell Name' ASC
END
ELSE
SELECT
	csInfo.CommServUniqueId AS 'CommServ UniqueId',
	csInfo.PackageName AS 'Package',
	csInfo.ClientCounts AS 'Number of Clients'
FROM cf_SurveySelfServiceInfo AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptSelfServiceInfo')
	delete from GxQscripts where name = 'RptSelfServiceInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSelfServiceInfo')
	delete from GXDBVersions where aliasname = 'RptSelfServiceInfo'
GO

insert into GXDBVersions values(2, 'RptSelfServiceInfo',  '00010004000000000000', 'RptSelfServiceInfo', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/createfeedback.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/createfeedback.sp,v $ $Id: createfeedback.sp,v 1.3 2014/06/24 06:53:56 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: createfeedback <<<'

IF EXISTS (select * from sysobjects where name='createfeedback')
	drop procedure createfeedback
IF EXISTS (select * from GxQscripts where name='createfeedback')
	delete from GxQscripts where name = 'createfeedback'
GO

IF EXISTS (select * from GXDBVersions where aliasname='createfeedback')
	delete from GXDBVersions where aliasname = 'createfeedback'
GO
print '... Creating Procedure: createfeedback'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure createfeedback
  @i_oemId INT,
  @i_feedbacktypeId INT,
  @i_productId INT,
  @i_source NVARCHAR(MAX),
  @i_release VARCHAR(512),
  @i_subject NVARCHAR(MAX),
  @i_comments NVARCHAR(MAX),
  @i_url NVARCHAR(MAX) ='',
  @i_email NVARCHAR(MAX) = '',	
  @i_fbattribute INT= 0
AS
SET NOCOUNT ON
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	DECLARE @o_fbId			INT			= 0,
			@o_errorCode	INT			= 0,
			@o_errorMessage	VARCHAR(MAX) = ''
	--perform some validation
	IF( NOT EXISTS(SELECT * FROM Feedback_CVOEM WHERE oemId = ISNULL(@i_oemId,0)))
	BEGIN
		SELECT @o_fbId='', @o_errorCode = 101, @o_errorMessage = 'Invalid OEM is provided. Id:'+ CONVERT(VARCHAR(10), ISNULL(@i_oemId,0))
		GOTO EXIT_;
	END
	IF( NOT EXISTS(SELECT * FROM FeedbackType WHERE feedbackTypeId = ISNULL(@i_feedbacktypeId,0)))
	BEGIN
		SELECT @o_fbId='', @o_errorCode = 102, @o_errorMessage = 'Invalid feedback type is provided. Id:'+ CONVERT(VARCHAR(10), ISNULL(@i_feedbacktypeId,0))
		GOTO EXIT_;
	END
	IF( NOT EXISTS(SELECT * FROM Feedback_Product WHERE productId = ISNULL(@i_productId,0)))
	BEGIN
		SELECT @o_fbId='', @o_errorCode = 103, @o_errorMessage = 'Invalid Product is provided. Id:'+ CONVERT(VARCHAR(10), ISNULL(@i_productId,0))
		GOTO EXIT_;
	END
	--Now insert into Feedback table.
	DECLARE @l_fbId INT = 0
	INSERT INTO FeedbackData (refFeedbackTypeId, refOEMId, refProductId, release, sourceValue,attribute, createDate)
	SELECT @i_feedbacktypeId, @i_oemId, @i_productId, @i_release, @i_source, @i_fbattribute, GETUTCDATE();
	SELECT @l_fbId = @@IDENTITY, @o_errorCode = @@ERROR
	IF (@o_errorCode <> 0)
	BEGIN
		SELECT @o_fbId='', @o_errorCode = 104, @o_errorMessage = 'Unexpected error while insreting entry to feedback table. Error Code:'+ CONVERT(VARCHAR(10), ISNULL(@o_errorCode,0))
		GOTO EXIT_;
	END
	--now insert into feedback content
	INSERT INTO FeedbackContent(refFbId,email,subject,url,comments,createDate)
	SELECT @l_fbId, @i_email, @i_subject, @i_url, @i_comments , GETUTCDATE();
	SELECT @o_fbId = @l_fbId
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
EXIT_:
	IF (@o_errorCode <> 0 AND @ProcessSurveyResultTran = 1)
    BEGIN
        ROLLBACK TRANSACTION ProcessSurveyResultTran
        SET @ProcessSurveyResultTran = 0
    END
	SELECT @o_fbId AS FeedbackId, @o_errorCode	AS ErrorCode, @o_errorMessage AS ErrorMessage
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @o_errorCode = 1
	SELECT @o_errorMessage = 'feedback data insertion failed with error :: ' + ERROR_MESSAGE()
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'createfeedback')
	delete from GxQscripts where name = 'createfeedback'
GO

IF EXISTS (select * from GXDBVersions where aliasname='createfeedback')
	delete from GXDBVersions where aliasname = 'createfeedback'
GO

insert into GXDBVersions values(2, 'createfeedback',  '00010003000000000000', 'createfeedback', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCommcellSummary.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCommcellSummary.sp,v $ $Id: ParseCommcellSummary.sp,v 1.6 2015/06/10 20:40:01 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseCommcellSummary <<<'

IF EXISTS (select * from sysobjects where name='ParseCommcellSummary')
	drop procedure ParseCommcellSummary
IF EXISTS (select * from GxQscripts where name='ParseCommcellSummary')
	delete from GxQscripts where name = 'ParseCommcellSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCommcellSummary')
	delete from GXDBVersions where aliasname = 'ParseCommcellSummary'
GO
print '... Creating Procedure: ParseCommcellSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseCommcellSummary
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 146
SELECT @ErrorString = 'CommcellSummary  - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_CommcellSummary(SurveyResultId,ProtectedClients,NotProtectedClients,ExcludedClients,TotalJobs,FailedJobs,SuccessfulJobs,Strike3Clients,Strike2Clients,Strike1Clients,Strike3SubClients,Strike2SubClients,Strike1SubClients, TotalAppSizeGB, TotalMediaSizeGB)
	SELECT
		results.CommservSurveyResults_ID,
		ISNULL(csInfo.n.value('@ProtectedClients' , 'int'),0),
		ISNULL(csInfo.n.value('@NotProtectedClients' , '[INT]'),0),
		ISNULL(csInfo.n.value('@ExcludedClients' , '[INT]'),0),
		ISNULL(csInfo.n.value('@TotalJobs' , '[BIGINT]'),0),
		ISNULL(csInfo.n.value('@FailedJobs' , '[BIGINT]'),0),
		ISNULL(csInfo.n.value('@SuccessfulJobs' , '[BIGINT]'),0),
		ISNULL(csInfo.n.value('@Strike3Clients' , '[INT]'),0),
		ISNULL(csInfo.n.value('@Strike2Clients' , '[INT]'),0),
		ISNULL(csInfo.n.value('@Strike1Clients' , '[INT]'),0),
		ISNULL(csInfo.n.value('@Strike3SubClients' , '[INT]'),0),
		ISNULL(csInfo.n.value('@Strike2SubClients' , '[INT]'),0),
		ISNULL(csInfo.n.value('@Strike1SubClients' , '[INT]'),0),
		ISNULL(csInfo.n.value('@TotalAppSizeGB' , '[FLOAT]'),0),
		ISNULL(csInfo.n.value('@TotalMediaSizeGB' , '[FLOAT]'),0)
	FROM
		cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
	ON files.ShredStatus = 1
		AND files.ID = results.CustomerFeedbackXmlFile_ID
		AND results.ShredStatus = 1
		AND results.QueryId = @surveyId
		AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('CommCellSummaryXML') AS csInfo(n)
	INSERT INTO cf_SurveySLASummary(SurveyResultId, days, ProtectedClients, NotProtectedClients, ExcludedClients)
	SELECT
		results.CommservSurveyResults_ID,
		csInfo.n.value('@days', 'INT'),
		ISNULL(csInfo.n.value('@ProtectedClients' , 'INT'),0),
		ISNULL(csInfo.n.value('@NotProtectedClients' , 'INT'),0),
		ISNULL(csInfo.n.value('@ExcludedClients' , 'INT'),0)
	FROM
		cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
	ON files.ShredStatus = 1
		AND files.ID = results.CustomerFeedbackXmlFile_ID
		AND results.ShredStatus = 1
		AND results.QueryId = @surveyId
		AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('CommCellSummaryXML/MultiDaySLA') AS csInfo(n)
	INSERT INTO cf_SurveySLATrend(SurveyResultId, MonthBegin, nClientsMet, nClientsMissed)
	SELECT
		results.CommservSurveyResults_ID,
		csInfo.n.value('@MonthBegin', '[DATETIME]'),
		ISNULL(csInfo.n.value('@nClientsMet', '[INT]'), 0),
		ISNULL(csInfo.n.value('@nClientsMissed', '[INT]'), 0)
	FROM
		cf_CommservSurveyResults AS results
		INNER JOIN cf_CustomerFeedbackXmlFile AS files
	ON files.ShredStatus = 1
		AND files.ID = results.CustomerFeedbackXmlFile_ID
		AND results.ShredStatus = 1
		AND results.QueryId = @surveyId
		AND files.ParseTime = @parseTime
		CROSS apply results.CollectedResults.nodes('CommCellSummaryXML/SLATrend') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString ='CommcellSummary - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
	BEGIN
		ROLLBACK TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
		SELECT @ErrorCode = 1
		SELECT @ErrorString ='Hourly Job Count Data- failed with error :: ' + ERROR_MESSAGE()
		IF @isPrintOn = 1
			PRINT @ErrorString
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCommcellSummary')
	delete from GxQscripts where name = 'ParseCommcellSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCommcellSummary')
	delete from GXDBVersions where aliasname = 'ParseCommcellSummary'
GO

insert into GXDBVersions values(2, 'ParseCommcellSummary',  '00010006000000000000', 'ParseCommcellSummary', '00010006000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptCommcellSummary.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptCommcellSummary.sp,v $ $Id: RptCommcellSummary.sp,v 1.5 2015/06/10 20:43:57 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptCommCellSummary <<<'

IF EXISTS (select * from sysobjects where name='RptCommCellSummary')
	drop procedure RptCommCellSummary
IF EXISTS (select * from GxQscripts where name='RptCommCellSummary')
	delete from GxQscripts where name = 'RptCommCellSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommCellSummary')
	delete from GXDBVersions where aliasname = 'RptCommCellSummary'
GO
print '... Creating Procedure: RptCommCellSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptCommCellSummary
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_type INT =1,
  @i_LatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll,
  @i_SLADays INT = 30
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 146
DECLARE @resultID int
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
IF(@i_type=1)
BEGIN
  IF @i_SLADays = 30
	SELECT
		SUM(ProtectedClients) as ProtectedClients,
		SUM(NotProtectedClients) as NotProtectedClients
	FROM
		cf_CommcellSummary AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
  ELSE
	SELECT
		SUM(ProtectedClients) as ProtectedClients,
		SUM(NotProtectedClients) as NotProtectedClients
	FROM
		cf_SurveySLASummary AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId AND csInfo.Days = @i_SLADays
	RETURN
END
ELSE IF ( @i_type =2 )
BEGIN
      SELECT
            3 as StrikeCount ,
            SUM(Strike3Clients) as Clients,
            sum(Strike3SubClients) as SubClients
      FROM
            cf_CommcellSummary AS csInfo WITH (NOLOCK)
            INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
            ON resultView.SurverResultId = csInfo.SurveyResultId
      UNION
      SELECT
            2 as StrikeCount,
            sum(Strike2Clients) as Clients,
            sum(Strike2SubClients) as SubClients
      FROM
            cf_CommcellSummary AS csInfo WITH (NOLOCK)
            INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
            ON resultView.SurverResultId = csInfo.SurveyResultId
      UNION
      SELECT
            1 as StrikeCount,
            sum(Strike1Clients) as Clients,
            sum(Strike1SubClients) as SubClients
      FROM
            cf_CommcellSummary AS csInfo WITH (NOLOCK)
            INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
            ON resultView.SurverResultId = csInfo.SurveyResultId
      RETURN
END
ELSE IF ( @i_type =3 )
BEGIN
      SELECT
            CAST(CAST(case when sum(TotalJobs) =0 then 0 else
                  sum(SuccessfulJobs)*100.0/sum(TotalJobs) END AS DECIMAL(7, 1)) AS VARCHAR(MAX))  AS 'Success Rate'
            FROM cf_CommcellSummary AS csInfo WITH (NOLOCK)
            INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
            ON resultView.SurverResultId = csInfo.SurveyResultId
      RETURN
END
ELSE IF ( @i_type =4 )
BEGIN
	CREATE TABLE #SLATrend (CommServUniqueId INT, CommCellName VARCHAR(1024), MonthBegin DATETIME, nClientsMet INT, nClientsMissed INT)
	INSERT INTO #SLATrend
	SELECT	resultView.CommServUniqueId,
			CASE WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
				 ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '') END,
			MonthBegin,
			nClientsMet,
			nClientsMissed
	FROM cf_SurveySLATrend AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
	DECLARE @maxMonth DATETIME = (SELECT MAX(MonthBegin) FROM #SLATrend)
	DECLARE @numMonth INT = 12
	DECLARE @tblMonth TABLE (MonthBegin DATETIME)
	WHILE	@numMonth > 0
	BEGIN
		SET @numMonth -= 1
		INSERT INTO @tblMonth
		SELECT DATEADD(MONTH, -@numMonth, @maxMonth)
	END
	SELECT	C.CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
			C.CommCellName AS 'CommCell Name<commcellName>',
			dbo.GetUnixTimeBig(M.MonthBegin) AS 'Month<MMMYYYY>',
			ISNULL(T.nClientsMet, 0) AS 'Met SLA',
			ISNULL(T.nClientsMissed, 0) AS 'Missed SLA',
			CASE WHEN ISNULL(T.nClientsMet + T.nClientsMissed, 0) = 0 THEN 0 ELSE (100*T.nClientsMet)/(T.nClientsMet + T.nClientsMissed) END AS 'SLA (%)'
	FROM	@tblMonth M CROSS JOIN (SELECT DISTINCT CommServUniqueId, CommCellName FROM #SLATrend) AS C
			LEFT OUTER JOIN #SLATrend T ON T.CommServUniqueId = C.CommServUniqueId AND T.MonthBegin = M.MonthBegin
	ORDER BY C.CommServUniqueId, M.MonthBegin
	DROP TABLE #SLATrend
	RETURN
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptCommcellSummary')
	delete from GxQscripts where name = 'RptCommcellSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommcellSummary')
	delete from GXDBVersions where aliasname = 'RptCommcellSummary'
GO

insert into GXDBVersions values(2, 'RptCommcellSummary',  '00010005000000000000', 'RptCommcellSummary', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptHourlyJobStats.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptHourlyJobStats.sp,v $ $Id: RptHourlyJobStats.sp,v 1.7 2014/08/20 16:18:37 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptHourlyJobStats <<<'

IF EXISTS (select * from sysobjects where name='RptHourlyJobStats')
	drop procedure RptHourlyJobStats
IF EXISTS (select * from GxQscripts where name='RptHourlyJobStats')
	delete from GxQscripts where name = 'RptHourlyJobStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptHourlyJobStats')
	delete from GXDBVersions where aliasname = 'RptHourlyJobStats'
GO
print '... Creating Procedure: RptHourlyJobStats'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptHourlyJobStats
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_TimeRangeBegin DATETIME = NULL,
  @i_TimeRangeEnd DATETIME = NUll,
  @i_LatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 51
IF @i_TimeRangeBegin IS NULL
	RETURN
select  CONVERT(VARCHAR(11),DayVal,100) as 'Date <HIDDEN>',
	 HourComp*60  as 'Backup Hour<HOURS>',
	sum(Completed) as 'Completed', sum(Partial) as 'Completed with Errors or Warnings', sum(Failed) as 'Failed', ISNULL(sum(KilledJobs),-1) as 'Killed<NumberNA>'
FROM	cf_SurveyHourlyBkpJobs J WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, NULL, NULL,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = J.SurveyResultId
	AND J.DayVal BETWEEN @i_TimeRangeBegin AND @i_TimeRangeEnd
	group by DayVal, HourComp
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptHourlyJobStats')
	delete from GxQscripts where name = 'RptHourlyJobStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptHourlyJobStats')
	delete from GXDBVersions where aliasname = 'RptHourlyJobStats'
GO

insert into GXDBVersions values(2, 'RptHourlyJobStats',  '00010007000000000000', 'RptHourlyJobStats', '00010007000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptSurveyDDBPendingDelete.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptSurveyDDBPendingDelete.sp,v $ $Id: RptSurveyDDBPendingDelete.sp,v 1.5 2014/12/15 10:52:34 vmishra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptSurveyDDBPendingDelete <<<'

IF EXISTS (select * from sysobjects where name='RptSurveyDDBPendingDelete')
	drop procedure RptSurveyDDBPendingDelete
IF EXISTS (select * from GxQscripts where name='RptSurveyDDBPendingDelete')
	delete from GxQscripts where name = 'RptSurveyDDBPendingDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSurveyDDBPendingDelete')
	delete from GXDBVersions where aliasname = 'RptSurveyDDBPendingDelete'
GO
print '... Creating Procedure: RptSurveyDDBPendingDelete'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptSurveyDDBPendingDelete
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
BEGIN
DECLARE @i_QueryId BIGINT = 65
DECLARE @i_secQueryId BIGINT = 35
DECLARE @i_HealthParamQueryId BIGINT = 156
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
IF(@blaggregate=1)
BEGIN
RETURN
end
ELSE
DECLARE @strGood VARCHAR(10) = '1_Good'
	DECLARE @strInfo VARCHAR(10) = '2_Info'
	DECLARE @strwarning VARCHAR(10) = '3_Warning'
	DECLARE @strCritical VARCHAR(10) = '4_Critical'
	DECLARE @criticalVal int
	DECLARE @warningVal int
		SELECT	@warningVal = WarningThreshold,
				@criticalVal =CriticalThreshold
		FROM	cf_SurveyHealthParam where queryId = @i_HealthParamQueryId
IF @i_CommServUniqueID = 0
BEGIN
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	CASE
		WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
		ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
	END AS 'CommCell Name',
	csInfo.SidbStoreName AS 'Store name',
	CASE WHEN csInfo.CreatedTime < '1970/01/01' THEN -100
		ELSE datediff(second,'1970/01/01',csInfo.CreatedTime) END AS 'Created Time<HIDDEN><MMMDDYYYYHrMinAM>',
	AF.SealedOrNot AS 'Store Status',
	AF.DeletedAFCount AS 'Job Records to be Deleted',
	AF.SevenDaysOldMMDeletedAFtable AS 'Job Records older than 7 days',
	csInfo.ZeroRefCount AS 'Prunable blocks',
	csInfo.PrimaryRecords AS 'Primary block count',
	CASE WHEN csInfo.PrimaryRecords <= 0 THEN 100
		 ELSE CAST(((csInfo.ZeroRefCount* 100.0)/csInfo.PrimaryRecords ) AS DECIMAL(10,1)) END AS 'Percentage<percentNA>',
	CASE WHEN csInfo.PrimaryRecords <= 0 THEN @strCritical
		 ELSE
		(CASE WHEN AF.SevenDaysOldMMDeletedAFtable > 10000 OR (csInfo.ZeroRefCount/csInfo.PrimaryRecords * 100.0) > 10
				THEN @strCritical
			 WHEN AF.SevenDaysOldMMDeletedAFtable BETWEEN 5000 AND 10000 OR (csInfo.ZeroRefCount/csInfo.PrimaryRecords * 100.0) BETWEEN 5 AND 10
				THEN @strWarning
			 ELSE @strGood
			 END)
	END AS 'Status<HEALTH_STATUS>'
FROM cf_SurveyDDBPerformance AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
	INNER JOIN (SELECT DD.* FROM cf_SurveyDeDupDeletedAFCount DD WITH (NOLOCK)
				INNER JOIN dbo.cf_SurveyResultFuncV1(@i_secQueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.SurverResultId=DD.SurveyResultId) AS AF
		ON csInfo.SidbStoreId = AF.SIDBStoreId
ORDER BY resultView.CustomerName, [Status<HEALTH_STATUS>] DESC, csInfo.ZeroRefCount DESC
END
ELSE
BEGIN
SELECT
	csInfo.SidbStoreName AS 'Store name',
	CASE WHEN csInfo.CreatedTime < '1970/01/01' THEN -100
		ELSE datediff(second,'1970/01/01',csInfo.CreatedTime) END AS 'Created Time<HIDDEN><MMMDDYYYYHrMinAM>',
	AF.SealedOrNot AS 'Store Status',
	AF.DeletedAFCount AS 'Job Records to be Deleted',
	AF.SevenDaysOldMMDeletedAFtable AS 'Job Records older than 7 days',
	csInfo.ZeroRefCount AS 'Prunable blocks',
	csInfo.PrimaryRecords AS 'Primary block count',
	CASE WHEN csInfo.PrimaryRecords <= 0 THEN 100
		 ELSE CAST(((csInfo.ZeroRefCount*100.0)/csInfo.PrimaryRecords) AS DECIMAL(10,1)) END AS 'Percentage<percentNA>',
	CASE WHEN csInfo.PrimaryRecords <= 0 THEN @strCritical
		 ELSE
		(CASE WHEN AF.SevenDaysOldMMDeletedAFtable > 10000 OR ((csInfo.ZeroRefCount*100.0)/csInfo.PrimaryRecords) > 10
				THEN @strCritical
			 WHEN AF.SevenDaysOldMMDeletedAFtable BETWEEN 5000 AND 10000 OR ((csInfo.ZeroRefCount*100.0)/csInfo.PrimaryRecords) BETWEEN 5 AND 10
				THEN @strWarning
			 ELSE @strGood
			 END)
	END AS 'Status<HEALTH_STATUS>'
FROM cf_SurveyDDBPerformance AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
	INNER JOIN (SELECT DD.* FROM cf_SurveyDeDupDeletedAFCount DD WITH (NOLOCK)
				INNER JOIN dbo.cf_SurveyResultFuncV1(@i_secQueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.SurverResultId=DD.SurveyResultId) AS AF
		ON csInfo.SidbStoreId = AF.SIDBStoreId
ORDER BY  [Status<HEALTH_STATUS>] DESC,csInfo.ZeroRefCount DESC
END
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'RptSurveyDDBPendingDelete')
	delete from GxQscripts where name = 'RptSurveyDDBPendingDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSurveyDDBPendingDelete')
	delete from GXDBVersions where aliasname = 'RptSurveyDDBPendingDelete'
GO

insert into GXDBVersions values(2, 'RptSurveyDDBPendingDelete',  '00010005000000000000', 'RptSurveyDDBPendingDelete', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Parse_160WebConsoleURL.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Parse_160WebConsoleURL.sp,v $ $Id: Parse_160WebConsoleURL.sp,v 1.7 2015/03/31 16:09:44 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Parse_160WebConsoleURL <<<'

IF EXISTS (select * from sysobjects where name='Parse_160WebConsoleURL')
	drop procedure Parse_160WebConsoleURL
IF EXISTS (select * from GxQscripts where name='Parse_160WebConsoleURL')
	delete from GxQscripts where name = 'Parse_160WebConsoleURL'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_160WebConsoleURL')
	delete from GXDBVersions where aliasname = 'Parse_160WebConsoleURL'
GO
print '... Creating Procedure: Parse_160WebConsoleURL'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Parse_160WebConsoleURL
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 160
SELECT @ErrorString = 'Parse_160WebConsoleURL Statistics - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_WebConsoleURL
	SELECT
	results.CommservSurveyResults_ID,
	ISNULL(csInfo.n.value('@URL' , '[NVarchar](MAX)'), 'N/A'),
	ISNULL(csInfo.n.value('@CommcellConsoleURL' , '[NVarchar](MAX)'), 'N/A')
	FROM
	cf_CommservSurveyResults AS results
	INNER JOIN cf_CustomerFeedbackXmlFile AS files
	ON files.ShredStatus = 1
	AND files.ID = results.CustomerFeedbackXmlFile_ID
	AND results.ShredStatus = 1
	AND results.QueryId = @surveyId
	AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('WebConsole') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString ='Parse_160WebConsoleURL - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
	BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString ='Parse_160WebConsoleURL - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Parse_160WebConsoleURL')
	delete from GxQscripts where name = 'Parse_160WebConsoleURL'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_160WebConsoleURL')
	delete from GXDBVersions where aliasname = 'Parse_160WebConsoleURL'
GO

insert into GXDBVersions values(2, 'Parse_160WebConsoleURL',  '00010007000000000000', 'Parse_160WebConsoleURL', '00010007000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Rpt160WebNJavaConsoleURLs.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Rpt160WebNJavaConsoleURLs.sp,v $ $Id: Rpt160WebNJavaConsoleURLs.sp,v 1.2 2015/03/30 18:54:54 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Rpt160WebNJavaConsoleURLs <<<'

IF EXISTS (select * from sysobjects where name='Rpt160WebNJavaConsoleURLs')
	drop procedure Rpt160WebNJavaConsoleURLs
IF EXISTS (select * from GxQscripts where name='Rpt160WebNJavaConsoleURLs')
	delete from GxQscripts where name = 'Rpt160WebNJavaConsoleURLs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt160WebNJavaConsoleURLs')
	delete from GXDBVersions where aliasname = 'Rpt160WebNJavaConsoleURLs'
GO
print '... Creating Procedure: Rpt160WebNJavaConsoleURLs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Rpt160WebNJavaConsoleURLs
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 160
IF(@blaggregate=1)
    RETURN
ELSE
BEGIN
DECLARE @param_isPrivate INT = 0
SELECT  @param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
    SELECT
        resultView.CommServUniqueId  AS 'CommServ UniqueId',
        resultView.CommCellID AS 'CommCell ID',
        CASE
            WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
            ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
        END AS 'CommCell Name',
        DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(resultView.LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME>',
        ISNULL(resultView.CommServTimeZone, '')  AS 'TimeZone',
        CASE
			WHEN resultView.RunningTime = -1 THEN 'N/A'
			ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
        END AS 'Running Time in Seconds',
        csInfo.CommcellConsoleURL AS 'Commcell Console URL',
        csInfo.WebConsoleURL AS 'WebConsole URL'
    FROM
        cf_WebConsoleURL AS csInfo WITH (NOLOCK)
        INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) AS resultView
        ON resultView.SurverResultId = csInfo.SurveyResultId
        AND (resultView.SureyResultFlags = @blLatestSurvey OR @blLatestSurvey = 0)
        AND (resultView.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
    ORDER BY resultView.LogDate DESC, resultView.CustomerName ASC
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Rpt160WebNJavaConsoleURLs')
	delete from GxQscripts where name = 'Rpt160WebNJavaConsoleURLs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt160WebNJavaConsoleURLs')
	delete from GXDBVersions where aliasname = 'Rpt160WebNJavaConsoleURLs'
GO

insert into GXDBVersions values(2, 'Rpt160WebNJavaConsoleURLs',  '00010002000000000000', 'Rpt160WebNJavaConsoleURLs', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/CreateMetricsReportQuery.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/CreateMetricsReportQuery.sp,v $ $Id: CreateMetricsReportQuery.sp,v 1.6 2014/07/02 08:38:16 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CreateMetricsReportQuery <<<'

IF EXISTS (select * from sysobjects where name='CreateMetricsReportQuery')
	drop procedure CreateMetricsReportQuery
IF EXISTS (select * from GxQscripts where name='CreateMetricsReportQuery')
	delete from GxQscripts where name = 'CreateMetricsReportQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CreateMetricsReportQuery')
	delete from GXDBVersions where aliasname = 'CreateMetricsReportQuery'
GO
print '... Creating Procedure: CreateMetricsReportQuery'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CreateMetricsReportQuery
  @i_reportName NVARCHAR(MAX),
  @i_reportDescription NVARCHAR(MAX),
  @i_sqlQuery NVARCHAR(MAX),
  @i_columnList NVARCHAR(MAX),
  @i_flags INT,
  @i_retention INT,
  @i_queryId INT = 0,
  @i_retainData INT = 0
AS
SET NOCOUNT ON
DECLARE @queryId INT = 0
--This is for future. If the @i_retainData > 0 then we want to retain older data and create a new table etc.....
IF @i_queryId <> 0 AND @i_retainData <> 0
BEGIN
	SELECT @queryId
	RETURN
END
IF @i_queryId = 0
BEGIN
	SELECT TOP 1 @queryId =  QueryId + 1 FROM cf_CommservSurveyQueries
	WHERE QueryId >= 10000
	ORDER BY QueryId DESC
	IF @queryId = 0
		SET @queryId = 10000
END
ELSE
BEGIN
	SET @queryId = @i_queryId
	IF  EXISTS( SELECT * FROM cf_CommservSurveyQueries
            WHERE QueryId = @queryId)
	BEGIN
		DELETE FROM cf_CommservSurveyQueries WHERE QueryId = @queryId
	END
END
DECLARE @SplitChar NVARCHAR(10) = ',';
--Get the column names and types
DECLARE @repColsTable TABLE (
	columnName NVARCHAR(200),
	columnType NVARCHAR(200));
Declare @token NVARCHAR(200) = null
Declare @varname NVARCHAR(200) = null
Declare @vartype NVARCHAR(200) = null
Declare @trimvarname NVARCHAR(200) = null
DECLARE @stripRepName NVARCHAR(2000) = 'cf_MetricsQuery' + CAST(@queryId as NVARCHAR(100))
DECLARE @repTableName NVARCHAR(100) = 'cf_MetricsQuery' + CAST(@queryId as NVARCHAR(100))
DECLARE @repParseProcName NVARCHAR(100) = 'ParseMetricsQuery' + CAST(@queryId as NVARCHAR(100))
Declare @queryFileName NVARCHAR(200) = 'CommservSurveyQuery_' + CAST(@queryId as NVARCHAR(100))+ '.sql'
DECLARE @createTableQuery NVARCHAR(MAX)
DECLARE @parseProcQuery NVARCHAR(MAX)
DECLARE @insertQuery NVARCHAR(MAX)
IF EXISTS (SELECT *
           FROM INFORMATION_SCHEMA.TABLES
           WHERE TABLE_TYPE='BASE TABLE'
           AND TABLE_NAME= @repTableName)
BEGIN
	SET @createTableQuery = 'TRUNCATE TABLE ' + @repTableName
	exec sp_executesql @createTableQuery
	SET @createTableQuery = 'DROP TABLE ' + @repTableName
	exec sp_executesql @createTableQuery
END
SET @insertQuery = 'INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, SubmittedBy, AssignedTo, LastUpdatedBy, LastUpdatedTime, Status, Flags, Type, CollectScriptName, CollectScript, CollectScriptURL, ParserScriptName ,ParserScript, DataRetentionDays, DataRetentionIntervalHrs, DataTableName) VALUES(' + CAST(@queryId as NVARCHAR(100)) + ',''' + @i_reportName + ''',''' + @i_reportDescription + ''','''
	+ @i_reportDescription + ''',''CloudUsage@commvault.com'',''CloudUsage@commvault.com'',''CloudUsage@commvault.com'',GETUTCDATE(),''In Production'', ' + CAST(@i_flags as NVARCHAR(100)) + ',1,''CommservSurveyQuery_' + CAST(@queryId as NVARCHAR(100)) + '.sql'',''' + @i_sqlQuery + ''','''','''','''
	+ @repParseProcName + ''',' + CAST(@i_retention as NVARCHAR(100)) + ', ' + CAST((@i_retention * 24)as NVARCHAR(100)) + ', ''' + @repTableName + ''')'
WHILE LEN(@i_columnList) > 0
BEGIN
    IF PATINDEX('%,%',@i_columnList) > 0
    BEGIN
        SET @token = SUBSTRING(@i_columnList, 0, PATINDEX('%,%',@i_columnList))
        SET @i_columnList = SUBSTRING(@i_columnList, LEN(@token + ',') + 1,
                                                     LEN(@i_columnList))
    END
    ELSE
    BEGIN
        SET @token = @i_columnList
        SET @i_columnList = NULL
    END
    SET @token = LTRIM(RTRIM(@token))
    IF PATINDEX('%:%',@token) > 0
    BEGIN
        SET @varname = SUBSTRING(@token, 0, PATINDEX('%:%',@token))
        SET @vartype = SUBSTRING(@token, LEN(@varname + ':') + 1,
                                                     LEN(@token))
        SET @varname = LTRIM(RTRIM(@varname))
        SET @vartype = LTRIM(RTRIM(@vartype))
        insert into @repColsTable values (@varname, @vartype)
    END
END
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[' + @repParseProcName + ']') AND type in (N'P', N'PC'))
BEGIN
	SET @parseProcQuery = 'DROP PROCEDURE [dbo].[' + @repParseProcName + ']'
	exec sp_executesql @parseProcQuery
END
SET @parseProcQuery = 'CREATE PROCEDURE [dbo].[' + @repParseProcName + ']' + char(13) + '
	@parseTime DATETIME,' + char(13) + '	@ErrorCode INTEGER OUTPUT,' + char(13) + '	@ErrorString NVARCHAR(MAX) OUTPUT,' + char(13) + '	@isPrintOn INTEGER = 0' + char(13) + '
	AS' + char(13) + ' BEGIN' + char(13) + ' SET NOCOUNT ON' + char(13) + 'DECLARE @surveyId INTEGER = ' + CAST(@queryId as NVARCHAR(20)) + '' + char(13) + ''
SET @parseProcQuery = @parseProcQuery + 'SELECT @ErrorString = ''' + @i_reportName + '''' + char(13) + ''
SET @parseProcQuery = @parseProcQuery + 'DECLARE @ProcessSurveyResultTran INT' + char(13) + '
SET @ProcessSurveyResultTran = 0' + char(13) + '
BEGIN TRY ' + char(13) + '
	IF (@@TRANCOUNT = 0)' + char(13) + '
	BEGIN' + char(13) + '
		BEGIN TRANSACTION ProcessSurveyResultTran' + char(13) + '
		SET @ProcessSurveyResultTran = 1 ' + char(13) + '
	END ' + char(13) + '
	INSERT INTO '  + @repTableName + '	SELECT ' + char(13) + ' results.CommservSurveyResults_ID'
SET @createTableQuery = 'CREATE TABLE [dbo].[' + @repTableName + '] ([SurveyResultId] [int] NOT NULL'
DECLARE columns CURSOR FOR
	SELECT columnName, columnType FROM @repColsTable
OPEN columns
	FETCH NEXT FROM columns INTO @varname, @vartype
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @trimvarname = LTRIM(RTRIM(REPLACE(@varname,' ','')))
	SET @createTableQuery = @createTableQuery + ',[' + @trimvarname + '] ' + @vartype
	SET @parseProcQuery = @parseProcQuery + ',' + char(13) + 'csInfo.n.value(''@' + @trimvarname + ''' , ''' + @vartype + ''')'
	FETCH NEXT FROM columns INTO @varname, @vartype
END
CLOSE  columns
DEALLOCATE  columns
SET @createTableQuery = @createTableQuery + ', FOREIGN KEY (SurveyResultId) REFERENCES cf_CommservSurveyResults (CommservSurveyResults_ID) ON DELETE CASCADE);'
SET @parseProcQuery = @parseProcQuery + '	FROM' + char(13) + '	cf_CommservSurveyResults AS results' + char(13) + '
	INNER JOIN cf_CustomerFeedbackXmlFile AS files' + char(13) + '	ON files.ShredStatus = 1' + char(13) + '
	AND files.ID = results.CustomerFeedbackXmlFile_ID' + char(13) + '	AND results.ShredStatus = 1' + char(13) + '
	AND results.QueryId = @surveyId' + char(13) + '	AND files.ParseTime = @parseTime' + char(13) + '
	CROSS apply results.CollectedResults.nodes(''SurveyResults/' + @stripRepName
SET @parseProcQuery = @parseProcQuery + ''') AS csInfo(n) ' + char(13) + '
	IF (@ProcessSurveyResultTran = 1)' + char(13) + '	BEGIN ' + char(13) + ' COMMIT TRANSACTION ProcessSurveyResultTran ' + char(13) + '
		SET @ProcessSurveyResultTran = 0 ' + char(13) + ' END ' + char(13) + ' SELECT @ErrorCode = 0 ' + char(13) + ''
SET @parseProcQuery = @parseProcQuery + 'SELECT @ErrorString =''' + @i_reportName + ' - complete''' + char(13) + '
	IF @isPrintOn = 1 ' + char(13) + '
		PRINT @ErrorString' + char(13) + '
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)' + char(13) + '
END TRY' + char(13) + '
' + 'BEGIN CATCH' + char(13) + '
	IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)' + char(13) + '
	BEGIN' + char(13) + '
	ROLLBACK TRANSACTION ProcessSurveyResultTran' + char(13) + '
	SET @ProcessSurveyResultTran = 0' + char(13) + '
	SELECT @ErrorCode = 1' + char(13) + '
	SELECT @ErrorString =''' + @i_reportName + '- failed with error :: '' + ERROR_MESSAGE()' + char(13) + '
	IF @isPrintOn = 1' + char(13) + '
		PRINT @ErrorString' + char(13) + '
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)' + char(13) + '
	END' + char(13) + '
' + 'END CATCH' + char(13) + '
SET NOCOUNT OFF' + char(13) + '
END' + char(13)
IF NOT EXISTS (SELECT 1
           FROM INFORMATION_SCHEMA.TABLES
           WHERE TABLE_TYPE = 'BASE TABLE'
           AND TABLE_NAME = @repTableName)
BEGIN
	exec sp_executesql @createTableQuery
END
exec sp_executesql @parseProcQuery
exec sp_executesql @insertQuery
select @queryId, @repTableName
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CreateMetricsReportQuery')
	delete from GxQscripts where name = 'CreateMetricsReportQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CreateMetricsReportQuery')
	delete from GXDBVersions where aliasname = 'CreateMetricsReportQuery'
GO

insert into GXDBVersions values(2, 'CreateMetricsReportQuery',  '00010006000000000000', 'CreateMetricsReportQuery', '00010006000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/DeleteMetricsReportQuery.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/DeleteMetricsReportQuery.sp,v $ $Id: DeleteMetricsReportQuery.sp,v 1.2 2014/06/05 21:50:45 jnuthakki Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DeleteMetricsReportQuery <<<'

IF EXISTS (select * from sysobjects where name='DeleteMetricsReportQuery')
	drop procedure DeleteMetricsReportQuery
IF EXISTS (select * from GxQscripts where name='DeleteMetricsReportQuery')
	delete from GxQscripts where name = 'DeleteMetricsReportQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DeleteMetricsReportQuery')
	delete from GXDBVersions where aliasname = 'DeleteMetricsReportQuery'
GO
print '... Creating Procedure: DeleteMetricsReportQuery'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DeleteMetricsReportQuery
  @i_queryId INT = 0
AS
SET NOCOUNT ON
IF @i_queryId < 10000
BEGIN
	SELECT 'Query id ' + CAST(@i_queryId as NVARCHAR(100)) + ' is not a custom query'
	RETURN
END
DECLARE @parserSPName NVARCHAR(MAX)
DECLARE @tableName NVARCHAR(200)
IF NOT EXISTS(SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @i_queryId)
BEGIN
	SELECT 'Query id ' + CAST(@i_queryId as NVARCHAR(100)) + ' does not exist'
	RETURN
END
SELECT @parserSPName = ParserScript, @tableName = DataTableName FROM cf_CommservSurveyQueries WHERE QueryId = @i_queryId
declare @query nvarchar(MAX)
declare @message nvarchar(MAX)
SET @message = 'Deleting query id ' + CAST(@i_queryId as NVARCHAR(100))
INSERT INTO cf_SurveyLogger (Message) values (@message)
IF EXISTS (SELECT * FROM sys.objects WHERE type = 'P' AND name = @parserSPName)
BEGIN
	SET @query = 'DROP PROCEDURE ' + @parserSPName
	EXEC sp_executesql @query
END
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_TYPE = 'BASE TABLE' AND TABLE_NAME = @tableName)
BEGIN
	SET @query = 'TRUNCATE TABLE ' + @tableName
	EXEC sp_executesql @query
	SET @query = 'DROP TABLE ' + @tableName
	EXEC sp_executesql @query
END
DELETE FROM cf_CommservSurveyQueries WHERE QueryId = @i_queryId
SET @message = 'Query id ' + CAST(@i_queryId as NVARCHAR(100)) + ' deleted successfully.'
INSERT INTO cf_SurveyLogger (Message) values (@message)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'DeleteMetricsReportQuery')
	delete from GxQscripts where name = 'DeleteMetricsReportQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DeleteMetricsReportQuery')
	delete from GXDBVersions where aliasname = 'DeleteMetricsReportQuery'
GO

insert into GXDBVersions values(2, 'DeleteMetricsReportQuery',  '00010002000000000000', 'DeleteMetricsReportQuery', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/DeleteMetricsCommServData.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/DeleteMetricsCommServData.sp,v $ $Id: DeleteMetricsCommServData.sp,v 1.4 2015/05/07 06:51:32 vmishra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: DeleteMetricsCommServData <<<'

IF EXISTS (select * from sysobjects where name='DeleteMetricsCommServData')
	drop procedure DeleteMetricsCommServData
IF EXISTS (select * from GxQscripts where name='DeleteMetricsCommServData')
	delete from GxQscripts where name = 'DeleteMetricsCommServData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DeleteMetricsCommServData')
	delete from GXDBVersions where aliasname = 'DeleteMetricsCommServData'
GO
print '... Creating Procedure: DeleteMetricsCommServData'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DeleteMetricsCommServData
  @userId int,
  @commcellUniqId int
AS
BEGIN
	SET NOCOUNT ON;
	DECLARE @message NVARCHAR(MAX)
	SELECT @message =  'CommcellUniqId [' + CAST(@commcellUniqId as NVARCHAR(50)) + '], Commserv Name ['
		+ CM.CommServName + '] for Customer [' + CM.CustomerName + '] is deleted by user id [' + CAST(@userId as NVARCHAR(50)) + '], user name [' + userinfo.n.value('@userName', 'NVARCHAR(MAX)') + ']'
	FROM cf_CommcellIdNameMap CM, cf_MetricsLoggedInUsers Users
	CROSS APPLY Users.UserProp.nodes('/WebReport_CloudMetricsUserResp/user') AS userinfo(n)
		WHERE CM.ID = @commcellUniqId AND Users.UserId = @userId
	INSERT INTO cf_SurveyLogger (Message) VALUES ( @message)
	DELETE FROM cf_CommcellIdNameMap WHERE ID = @commcellUniqId
END
GO

IF EXISTS (select * from GxQscripts where name = 'DeleteMetricsCommServData')
	delete from GxQscripts where name = 'DeleteMetricsCommServData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DeleteMetricsCommServData')
	delete from GXDBVersions where aliasname = 'DeleteMetricsCommServData'
GO

insert into GXDBVersions values(2, 'DeleteMetricsCommServData',  '00010004000000000000', 'DeleteMetricsCommServData', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptEditCustomerName.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptEditCustomerName.sp,v $ $Id: RptEditCustomerName.sp,v 1.2 2015/05/07 06:51:48 vmishra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptEditCustomerName <<<'

IF EXISTS (select * from sysobjects where name='RptEditCustomerName')
	drop procedure RptEditCustomerName
IF EXISTS (select * from GxQscripts where name='RptEditCustomerName')
	delete from GxQscripts where name = 'RptEditCustomerName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptEditCustomerName')
	delete from GXDBVersions where aliasname = 'RptEditCustomerName'
GO
print '... Creating Procedure: RptEditCustomerName'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptEditCustomerName
  @UserId INT,
  @CommServUniqueID INT,
  @DisplayName NVARCHAR(MAX)
AS
SET NOCOUNT ON
DECLARE @retStr NVARCHAR(MAX) = ''
SET @DisplayName = ISNULL(LTRIM(RTRIM(@DisplayName)),'')
IF @DisplayName = ''
BEGIN
	SET @DisplayName = NULL
END
UPDATE cf_CommcellIDNameMap SET DisplayName = @DisplayName WHERE ID = @CommServUniqueID
SET @retStr = (SELECT ISNULL(DisplayName,ISNULL(CustomerName,'') + ' - ' + ISNULL(CommServName, '')) FROM cf_CommcellIDNameMap WHERE ID = @CommServUniqueID)
SELECT @retStr AS CommcellName
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptEditCustomerName')
	delete from GxQscripts where name = 'RptEditCustomerName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptEditCustomerName')
	delete from GXDBVersions where aliasname = 'RptEditCustomerName'
GO

insert into GXDBVersions values(2, 'RptEditCustomerName',  '00010002000000000000', 'RptEditCustomerName', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/cvsp_drop_fkeys.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/cvsp_drop_fkeys.sp,v $ $Id: cvsp_drop_fkeys.sp,v 1.2 2015/02/11 18:04:38 chandru Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  |   Procedure:  cvsp_drop_fkeys()
--  |
--  | Description:  Stored procedure to drop table foreign key
--  |
--  |       Input:  fromTable, fromColumn, ToTable
--	|
--  |      Output:  error code
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: cvsp_drop_fkeys <<<'

IF EXISTS (select * from sysobjects where name='cvsp_drop_fkeys')
	drop procedure cvsp_drop_fkeys
IF EXISTS (select * from GxQscripts where name='cvsp_drop_fkeys')
	delete from GxQscripts where name = 'cvsp_drop_fkeys'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_drop_fkeys')
	delete from GXDBVersions where aliasname = 'cvsp_drop_fkeys'
GO
print '... Creating Procedure: cvsp_drop_fkeys'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure cvsp_drop_fkeys
  @fromTable varchar(40),
  @fromColumn varChar(40),
  @ToTable varchar(40)
AS
declare @fkName     varchar (255)
declare @execString nvarchar (255)
declare @errCode    int
set	@errCode = 0
IF object_id('tempdb.dbo.#ffk') is not null DROP TABLE #ffk
CREATE TABLE #ffk
(
	PKTABLE_QUALIFIER		varchar(255),
	PKTABLE_OWNER	varchar(255),
	PKTABLE_NAME	varchar(255),
	PKCOLUMN_NAME	varchar(255),
	FKTABLE_QUALIFIER	varchar(255),
	FKTABLE_OWNER	varchar(255),
	FKTABLE_NAME	varchar(255),
	FKCOLUMN_NAME	varchar(255),
	KEY_SEQ		int,
	UPDATE_RULE	int,
	DELETE_RULE	int,
	FK_NAME	varchar(255),
	PK_NAME	varchar(255),
	DEFERRABILITY	varchar(255)
)
INSERT INTO  #ffk
EXEC  sp_fkeys @fktable_name=@fromTable
DECLARE fkCursor CURSOR FOR
	select distinct  FK_NAME from #ffk
	where PKTABLE_NAME = @ToTable
	AND FKCOLUMN_NAME = @fromColumn
OPEN fkCursor
FETCH	NEXT FROM fkCursor INTO @fkName
WHILE	@@FETCH_STATUS = 0
BEGIN
		--print 'Dropping constraint [' + @fkName + '] from table [' + @fromTable + '] to table [' + @ToTable + '].'
		set @execString = 'alter table ' + @fromTable +' drop ' + @fkName
		exec sp_executesql @execString
		set @errCode = @@error
		IF @errCode <> 0
			break;
		FETCH	NEXT FROM fkCursor INTO @fkName
END
CLOSE fkCursor
DEALLOCATE fkCursor
drop table #ffk
IF @errCode <> 0
	return @errCode
ELSE
	return 0
GO

IF EXISTS (select * from GxQscripts where name = 'cvsp_drop_fkeys')
	delete from GxQscripts where name = 'cvsp_drop_fkeys'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_drop_fkeys')
	delete from GXDBVersions where aliasname = 'cvsp_drop_fkeys'
GO

insert into GXDBVersions values(2, 'cvsp_drop_fkeys',  '00010002000000000000', 'cvsp_drop_fkeys', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/cvsp_drop_pk.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/cvsp_drop_pk.sp,v $ $Id: cvsp_drop_pk.sp,v 1.2 2015/02/11 18:04:38 chandru Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  |   Procedure:  cvsp_drop_pk()
--  |
--  | Description:  First drop all foreign keys referenced to the primary key
--  |				of the given table then drop the primary key
--  |
--  |       Input:  tblName
--	|
--  |      Output:  error code
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: cvsp_drop_pk <<<'

IF EXISTS (select * from sysobjects where name='cvsp_drop_pk')
	drop procedure cvsp_drop_pk
IF EXISTS (select * from GxQscripts where name='cvsp_drop_pk')
	delete from GxQscripts where name = 'cvsp_drop_pk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_drop_pk')
	delete from GXDBVersions where aliasname = 'cvsp_drop_pk'
GO
print '... Creating Procedure: cvsp_drop_pk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure cvsp_drop_pk
  @tblName varchar(40)
AS
DECLARE	@fkTable	varchar (40)
DECLARE @keyName	varchar (255)
DECLARE @execString	nvarchar(255)
DECLARE @errCode    int
SET	@errCode = 0
DECLARE fkCursor CURSOR FOR
	SELECT	DISTINCT object_name(constid), object_name(fkeyid)
	FROM	sysforeignkeys
	WHERE	rkeyid = object_id(@tblName)
OPEN	fkCursor
FETCH	NEXT FROM fkCursor INTO @keyName, @fkTable
WHILE	@@FETCH_STATUS = 0
BEGIN
		SET	@execString = 'ALTER TABLE ' + @fkTable +' DROP CONSTRAINT ' + @keyName
		EXEC sp_executesql @execString
		SET	@errCode = @@error
		IF	@errCode <> 0
			BREAK
		FETCH NEXT FROM fkCursor INTO @keyName, @fkTable
END
CLOSE		fkCursor
DEALLOCATE	fkCursor
IF	@errCode <> 0
	return @errCode
SELECT @keyName = name FROM sysobjects WHERE parent_obj = object_id(@tblName) AND xtype = 'PK'
IF (@keyName IS NOT null)
BEGIN
	SET @execString = 'ALTER TABLE ' + @tblName +' DROP CONSTRAINT ' + @keyName
	EXEC sp_executesql @execString
END
RETURN @errCode
GO

IF EXISTS (select * from GxQscripts where name = 'cvsp_drop_pk')
	delete from GxQscripts where name = 'cvsp_drop_pk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_drop_pk')
	delete from GXDBVersions where aliasname = 'cvsp_drop_pk'
GO

insert into GXDBVersions values(2, 'cvsp_drop_pk',  '00010002000000000000', 'cvsp_drop_pk', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptGetParamId.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptGetParamId.sp,v $ $Id: RptGetParamId.sp,v 1.2 2015/03/02 10:40:54 vmishra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptGetParamId <<<'

IF EXISTS (select * from sysobjects where name='RptGetParamId')
	drop procedure RptGetParamId
IF EXISTS (select * from GxQscripts where name='RptGetParamId')
	delete from GxQscripts where name = 'RptGetParamId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetParamId')
	delete from GXDBVersions where aliasname = 'RptGetParamId'
GO
print '... Creating Procedure: RptGetParamId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetParamId
  @i_surveyId INT = NULL
AS
SET NOCOUNT ON
	SELECT ISNULL(paramId,@i_surveyId) FROM cf_SurveyHealthParam WHERE queryId = @i_surveyId
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetParamId')
	delete from GxQscripts where name = 'RptGetParamId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetParamId')
	delete from GXDBVersions where aliasname = 'RptGetParamId'
GO

insert into GXDBVersions values(2, 'RptGetParamId',  '00010002000000000000', 'RptGetParamId', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptCommCellUsageCount.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptCommCellUsageCount.sp,v $ $Id: RptCommCellUsageCount.sp,v 1.4 2015/05/20 14:34:48 vmishra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptCommCellUsageCount <<<'

IF EXISTS (select * from sysobjects where name='RptCommCellUsageCount')
	drop procedure RptCommCellUsageCount
IF EXISTS (select * from GxQscripts where name='RptCommCellUsageCount')
	delete from GxQscripts where name = 'RptCommCellUsageCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommCellUsageCount')
	delete from GXDBVersions where aliasname = 'RptCommCellUsageCount'
GO
print '... Creating Procedure: RptCommCellUsageCount'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptCommCellUsageCount
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 8
DECLARE @i_QueryId2 BIGINT = 1
DECLARE @param_isPrivate INT = 0
SELECT @param_isPrivate = Isnull(Cast(value AS INT), 0) FROM   cf_surveyconfig WHERE  name = 'isPrivate'
SELECT [Entities], [Count]
FROM
(SELECT SUM(ISNULL(csInfo.TotalActiveClients, 0)) - SUM(ISNULL(csInfo.TotalLaptops, 0)) AS [Servers],
            SUM(ISNULL(csInfo.TotalLaptops, 0)) AS [Laptops]
FROM   cf_SurveyClientStatisticsInfo AS csInfo WITH (nolock)
    INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId) AS results
    ON results.SurverResultId = csInfo.SurveyResultId) AS S
UNPIVOT ([Count] FOR [Entities] IN ([Servers], [Laptops])) AS U
UNION
SELECT [Entities], [Count]
FROM
(SELECT SUM(ISNULL(csInfo.ProtectedVMs, 0)) AS [VMs],
        SUM(ISNULL(csInfo.EndpointUsers, 0))+
        SUM(ISNULL(csInfo.SharingUsers, 0))+
        SUM(ISNULL(csInfo.eDiscoveryUsers, 0)) AS [Users]
FROM   cf_SurveyCapacityLicenseUsage AS csInfo WITH (nolock)
        INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId2, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId) AS results
        ON results.SurverResultId = csInfo.SurveyResultId) AS S
UNPIVOT ([Count] FOR [Entities] IN ([VMs], [Users])) AS U
UNION
SELECT [Entities], [Count]
FROM
(SELECT SUM(ISNULL(csInfo.UsedDiskSpaceMB, 0)) AS [Disk Library],
        SUM(ISNULL(csInfo.DedupDataSizeMB, 0)) AS [Dedupe Store],
        SUM(ISNULL(csInfo.CIObjects, 0)) AS [CI Objects]
FROM   cf_SurveyCapacityLicenseUsage AS csInfo WITH (nolock)
        INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId2, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId) AS results
        ON results.SurverResultId = csInfo.SurveyResultId) AS S
UNPIVOT ([Count] FOR [Entities] IN ([Disk Library], [Dedupe Store], [CI Objects])) AS U
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptCommCellUsageCount')
	delete from GxQscripts where name = 'RptCommCellUsageCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommCellUsageCount')
	delete from GXDBVersions where aliasname = 'RptCommCellUsageCount'
GO

insert into GXDBVersions values(2, 'RptCommCellUsageCount',  '00010004000000000000', 'RptCommCellUsageCount', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptCommCellSLA.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptCommCellSLA.sp,v $ $Id: RptCommCellSLA.sp,v 1.3 2015/05/07 06:51:35 vmishra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptCommCellSLA <<<'

IF EXISTS (select * from sysobjects where name='RptCommCellSLA')
	drop procedure RptCommCellSLA
IF EXISTS (select * from GxQscripts where name='RptCommCellSLA')
	delete from GxQscripts where name = 'RptCommCellSLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommCellSLA')
	delete from GXDBVersions where aliasname = 'RptCommCellSLA'
GO
print '... Creating Procedure: RptCommCellSLA'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptCommCellSLA
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 146
DECLARE @param_isPrivate INT = 0
SELECT @param_isPrivate = Isnull(Cast(value AS INT), 0) FROM   cf_surveyconfig WHERE  name = 'isPrivate'
SELECT CASE
            WHEN @param_isPrivate = 1 THEN Isnull(resultView.commservname, '')
            ELSE Isnull(resultView.customername, '') + ' - '
                + Isnull(resultView.commservname, '')
        END AS 'CommCell Name',
        resultView.commservuniqueid,
		Cast(Round(CASE
						WHEN notprotectedclients + protectedclients > 0
							THEN protectedclients * 100.0 / (notprotectedclients + protectedclients)
						ELSE 0
                    END, 0) AS INT) AS 'SLA (%)',
        resultView.commservversion AS 'Version'
FROM   cf_commcellsummary AS csInfo WITH (nolock)
        INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, NULL, NULL, @i_UserId, @i_GroupId) AS resultView
			ON resultView.surverresultid = csInfo.surveyresultid
ORDER  BY [sla (%)]
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptCommCellSLA')
	delete from GxQscripts where name = 'RptCommCellSLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommCellSLA')
	delete from GXDBVersions where aliasname = 'RptCommCellSLA'
GO

insert into GXDBVersions values(2, 'RptCommCellSLA',  '00010003000000000000', 'RptCommCellSLA', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/CV_ExecuteQuery.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/CV_ExecuteQuery.sp,v $ $Id: CV_ExecuteQuery.sp,v 1.3 2015/07/09 06:15:24 vmishra Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: CV_ExecuteQuery <<<'

IF EXISTS (select * from sysobjects where name='CV_ExecuteQuery')
	drop procedure CV_ExecuteQuery
IF EXISTS (select * from GxQscripts where name='CV_ExecuteQuery')
	delete from GxQscripts where name = 'CV_ExecuteQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_ExecuteQuery')
	delete from GXDBVersions where aliasname = 'CV_ExecuteQuery'
GO
print '... Creating Procedure: CV_ExecuteQuery'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CV_ExecuteQuery
  @i_queryType INT,
  @i_sPName varchar(128),
  @i_argument0 NVARCHAR(MAX) = NULL,
  @i_argument1 NVARCHAR(MAX) = NULL,
  @i_argument2 NVARCHAR(MAX) = NULL,
  @i_argument3 NVARCHAR(MAX) = NULL,
  @i_argument4 NVARCHAR(MAX) = NULL,
  @i_argument5 NVARCHAR(MAX) = NULL,
  @i_argument6 NVARCHAR(MAX) = NULL,
  @i_argument7 NVARCHAR(MAX) = NULL,
  @i_argument8 NVARCHAR(MAX) = NULL,
  @i_argument9 NVARCHAR(MAX) = NULL,
  @i_argument10 NVARCHAR(MAX) = NULL,
  @i_argument11 NVARCHAR(MAX) = NULL,
  @i_argument12 NVARCHAR(MAX) = NULL,
  @i_argument13 NVARCHAR(MAX) = NULL,
  @i_argument14 NVARCHAR(MAX) = NULL,
  @i_argument15 NVARCHAR(MAX) = NULL
AS
BEGIN
	SET NOCOUNT ON
	IF @i_spName = 'CV_ExecuteQuery'
	BEGIN
		PRINT 'Could not run CV_ExecuteQuery'
		RETURN
	END
	IF @i_queryType <> 0
	   RETURN
	If NOT EXISTS(SELECT * FROM cf_CommservSurveyQueries where ParserScriptName = @i_spName)  AND
		NOT EXISTS(SELECT * FROM cf_SurveyReportsProcList where ProcName = @i_spName)
	BEGIN
		PRINT 'Procedure [' + @i_spName + '] not supported.'
		RETURN
	END
	IF @i_queryType = 0 AND ISNULL(OBJECTPROPERTY (object_id(@i_spName), 'IsProcedure'), 0) <> 1
	BEGIN
		PRINT 'Procedure [' + @i_spName + '] not found.'
		RETURN
	END
	DECLARE @i_arguments NVARCHAR(MAX) = ''
	DECLARE @Statement NVARCHAR(MAX) = ''
	BEGIN
		IF ISNULL(DATALENGTH(@i_argument0), 0) <> 0
		BEGIN
			--Sanitize input
			IF dbo.IsInputSafe(@i_argument0) = 0
			BEGIN
				PRINT 'Invalid Input ' + @i_argument0
				RETURN
			END
			SET @i_arguments += @i_argument0
		END
		IF ISNULL(DATALENGTH(@i_argument1), 0) <> 0
		BEGIN
			--Sanitize input
			IF dbo.IsInputSafe(@i_argument1) = 0
			BEGIN
				PRINT 'Invalid Input ' + @i_argument1
				RETURN
			END
			IF DATALENGTH(@i_arguments) <> 0
				SET @i_arguments += ', '
			SET @i_arguments += @i_argument1
		END
		IF ISNULL(DATALENGTH(@i_argument2), 0) <> 0
		BEGIN
			--Sanitize input
			IF dbo.IsInputSafe(@i_argument2) = 0
			BEGIN
				PRINT 'Invalid Input ' + @i_argument2
				RETURN
			END
			IF DATALENGTH(@i_arguments) <> 0
				SET @i_arguments += ', '
			SET @i_arguments += @i_argument2
		END
		IF ISNULL(DATALENGTH(@i_argument3), 0) <> 0
		BEGIN
			--Sanitize input
			IF dbo.IsInputSafe(@i_argument3) = 0
			BEGIN
				PRINT 'Invalid Input ' + @i_argument3
				RETURN
			END
			IF DATALENGTH(@i_arguments) <> 0
				SET @i_arguments += ', '
			SET @i_arguments += @i_argument3
		END
		IF ISNULL(DATALENGTH(@i_argument4), 0) <> 0
		BEGIN
			--Sanitize input
			IF dbo.IsInputSafe(@i_argument4) = 0
			BEGIN
				PRINT 'Invalid Input ' + @i_argument4
				RETURN
			END
			IF DATALENGTH(@i_arguments) <> 0
				SET @i_arguments += ', '
			SET @i_arguments += @i_argument4
		END
		IF ISNULL(DATALENGTH(@i_argument5), 0) <> 0
		BEGIN
			--Sanitize input
			IF dbo.IsInputSafe(@i_argument5) = 0
			BEGIN
				PRINT 'Invalid Input ' + @i_argument5
				RETURN
			END
			IF DATALENGTH(@i_arguments) <> 0
				SET @i_arguments += ', '
			SET @i_arguments += @i_argument5
		END
		IF ISNULL(DATALENGTH(@i_argument6), 0) <> 0
		BEGIN
			--Sanitize input
			IF dbo.IsInputSafe(@i_argument6) = 0
			BEGIN
				PRINT 'Invalid Input ' + @i_argument6
				RETURN
			END
			IF DATALENGTH(@i_arguments) <> 0
				SET @i_arguments += ', '
			--Sanitize input
			SET @i_arguments += @i_argument6
		END
		IF ISNULL(DATALENGTH(@i_argument7), 0) <> 0
		BEGIN
			--Sanitize input
			IF dbo.IsInputSafe(@i_argument7) = 0
			BEGIN
				PRINT 'Invalid Input ' + @i_argument7
				RETURN
			END
			IF DATALENGTH(@i_arguments) <> 0
				SET @i_arguments += ', '
			--Sanitize input
			SET @i_arguments += @i_argument7
		END
		IF ISNULL(DATALENGTH(@i_argument8), 0) <> 0
		BEGIN
			--Sanitize input
			IF dbo.IsInputSafe(@i_argument8) = 0
			BEGIN
				PRINT 'Invalid Input ' + @i_argument8
				RETURN
			END
			IF DATALENGTH(@i_arguments) <> 0
				SET @i_arguments += ', '
			SET @i_arguments += @i_argument8
		END
		IF ISNULL(DATALENGTH(@i_argument9), 0) <> 0
		BEGIN
			--Sanitize input
			IF dbo.IsInputSafe(@i_argument9) = 0
			BEGIN
				PRINT 'Invalid Input ' + @i_argument9
				RETURN
			END
			IF DATALENGTH(@i_arguments) <> 0
				SET @i_arguments += ', '
			SET @i_arguments += @i_argument9
		END
		IF ISNULL(DATALENGTH(@i_argument10), 0) <> 0
		BEGIN
			--Sanitize input
			IF dbo.IsInputSafe(@i_argument10) = 0
			BEGIN
				PRINT 'Invalid Input ' + @i_argument10
				RETURN
			END
			IF DATALENGTH(@i_arguments) <> 0
				SET @i_arguments += ', '
			SET @i_arguments += @i_argument10
		END
		IF ISNULL(DATALENGTH(@i_argument11), 0) <> 0
		BEGIN
			--Sanitize input
			IF dbo.IsInputSafe(@i_argument11) = 0
			BEGIN
				PRINT 'Invalid Input ' + @i_argument11
				RETURN
			END
			IF DATALENGTH(@i_arguments) <> 0
				SET @i_arguments += ', '
			SET @i_arguments += @i_argument11
		END
		IF ISNULL(DATALENGTH(@i_argument12), 0) <> 0
		BEGIN
			--Sanitize input
			IF dbo.IsInputSafe(@i_argument12) = 0
			BEGIN
				PRINT 'Invalid Input ' + @i_argument12
				RETURN
			END
			IF DATALENGTH(@i_arguments) <> 0
				SET @i_arguments += ', '
			SET @i_arguments += @i_argument12
		END
		IF ISNULL(DATALENGTH(@i_argument13), 0) <> 0
		BEGIN
			--Sanitize input
			IF dbo.IsInputSafe(@i_argument13) = 0
			BEGIN
				PRINT 'Invalid Input ' + @i_argument13
				RETURN
			END
			IF DATALENGTH(@i_arguments) <> 0
				SET @i_arguments += ', '
			SET @i_arguments += @i_argument13
		END
		IF ISNULL(DATALENGTH(@i_argument14), 0) <> 0
		BEGIN
			--Sanitize input
			IF dbo.IsInputSafe(@i_argument14) = 0
			BEGIN
				PRINT 'Invalid Input ' + @i_argument14
				RETURN
			END
			IF DATALENGTH(@i_arguments) <> 0
				SET @i_arguments += ', '
			SET @i_arguments += @i_argument14
		END
		IF ISNULL(DATALENGTH(@i_argument15), 0) <> 0
		BEGIN
			--Sanitize input
			IF dbo.IsInputSafe(@i_argument15) = 0
			BEGIN
				PRINT 'Invalid Input ' + @i_argument15
				RETURN
			END
			IF DATALENGTH(@i_arguments) <> 0
				SET @i_arguments += ', '
			SET @i_arguments += @i_argument15
		END
	END
	BEGIN
		IF DATALENGTH(@i_arguments) <> 0
			SET @Statement = 'EXEC ' + @i_spName  + ' ' + @i_arguments
		ELSE
			SET @Statement = @i_spName
	END
	IF DATALENGTH(@Statement) <> 0
		EXECUTE( @Statement)
SET NOCOUNT OFF
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'CV_ExecuteQuery')
	delete from GxQscripts where name = 'CV_ExecuteQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CV_ExecuteQuery')
	delete from GXDBVersions where aliasname = 'CV_ExecuteQuery'
GO

insert into GXDBVersions values(2, 'CV_ExecuteQuery',  '00010003000000000000', 'CV_ExecuteQuery', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptMonthlyPptData.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptMonthlyPptData.sp,v $ $Id: RptMonthlyPptData.sp,v 1.3 2015/04/30 18:17:24 vmishra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptMonthlyPptData <<<'

IF EXISTS (select * from sysobjects where name='RptMonthlyPptData')
	drop procedure RptMonthlyPptData
IF EXISTS (select * from GxQscripts where name='RptMonthlyPptData')
	delete from GxQscripts where name = 'RptMonthlyPptData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptMonthlyPptData')
	delete from GXDBVersions where aliasname = 'RptMonthlyPptData'
GO
print '... Creating Procedure: RptMonthlyPptData'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptMonthlyPptData
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll,
  @i_param INT = NUll,
  @lastNMonths INT = 12,
  @groupName VARCHAR(150) = NUll
AS
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
DECLARE @queryId INT = 152
DECLARE @ThisMonth  DATE = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()),0)
DECLARE @STARTDATE  DATE = @ThisMonth
DECLARE @ENDDATE    DATE = DATEADD(MONTH, 1, @STARTDATE)
DECLARE @query NVARCHAR(MAX)
DECLARE @cols AS NVARCHAR(MAX)
DECLARE @ccGpName XML = (SELECT CAST(Value AS XML) FROM cf_SurveyConfig WHERE Name = 'CommCellGrpsForMonthlyPPT')
IF OBJECT_ID('tempdb.dbo.#CCGrpAssoc') IS NOT NULL DROP TABLE #CCGrpAssoc
IF OBJECT_ID('tempdb.dbo.#LastNMonths') IS NOT NULL DROP TABLE #LastNMonths
IF @i_param IN (1,4,5,6,7,8,9) -- Job stats cf_SurveyJobStats
	SET @queryId = 137
ELSE IF @i_param = 2 -- Bacjup Retention cf_SurveyCopyBasicRetention
	SET @queryId = 153
ELSE IF @i_param = 3 -- Restore Summary cf_SurveyRestoreJobStats
	SET @queryId = 152
IF ISNULL(@groupName,'') <> ''
	SELECT @i_GroupId = id FROM cf_CommCellGroup WHERE name = @groupName
IF ISNULL(@i_GroupId,-1) > 0
	SELECT @groupName = name FROM cf_CommCellGroup WHERE id = @i_GroupId
SELECT CG.id, CG.name, CA.commcellIdNameMap_ID AS CommServUniqueId
INTO #CCGrpAssoc
FROM cf_CommCellGroupAssoc CA WITH (NOLOCK)
	 INNER JOIN cf_CommCellGroup CG WITH (NOLOCK)
		ON CA.CommCellGroupId = CG.id
	 INNER JOIN @ccGpName.nodes('CommCellGroups/name') C(n)
		ON CG.name = C.n.value('.','nvarchar(150)')
IF @i_GroupId > 0
	DELETE FROM #CCGrpAssoc WHERE id NOT IN (@i_GroupId)
IF @i_param = 1 -- We need only past 3 months data
	SET @lastNMonths = 3
;WITH MONTHS(Cnt, STARTDATE , ENDDATE ) AS
(
	SELECT 1,@STARTDATE, @ENDDATE
	UNION ALL
	SELECT Cnt+1,DATEADD(MONTH, -1, STARTDATE),STARTDATE
	FROM MONTHS WHERE Cnt < @lastNMonths
)
SELECT *
INTO #LastNMonths
FROM MONTHS
IF @i_param = -1 -- Returns list of past N mopnths name
BEGIN
	SELECT DATENAME(MONTH,STARTDATE) AS Months FROM #LastNMonths ORDER BY STARTDATE
END
ELSE IF @i_param = 0	-- Returns Commcell Group names for which data needs to be populated
BEGIN
	SELECT DISTINCT Name AS 'CommcellGroups' FROM #CCGrpAssoc
END
ELSE IF @i_param = 1 -- Retuns information that needs to be filled on slide 1 (all non-chart data, free floater values)
BEGIN
	DECLARE @NoOfRstJobs INT, @RstDataForLastMonthMB DECIMAL(20,2)
	DECLARE @lastMonth INT = 2,
			@last2lastMonth INT = 3
	DECLARE @JobDetails TABLE (MonthNo INT, NoOfDays INT, MonthStartDate DATE, Total INT, Success INT, ApplicationSizeMB BIGINT)
	INSERT INTO @JobDetails (MonthNo, MonthStartDate, Total, Success, ApplicationSizeMB)
	SELECT M.Cnt,
		   M.STARTDATE,
		   COUNT(*) AS Total, SUM(CASE WHEN Status IN (1,3,14) THEN 1 ELSE 0 END) AS Success,
		   SUM(CASE WHEN Status IN (1,3,14) THEN JM.DataProtected ELSE 0 END)/1024.0/1024.0 AS ApplicationSizeMB
	FROM cf_SurveyJobStats JM WITH (NOLOCK)
		INNER JOIN (SELECT DISTINCT CommServUniqueId FROM #CCGrpAssoc) CG
			ON JM.CommServUniqueId = CG.CommServUniqueId
		RIGHT JOIN #LastNMonths M
			ON JM.EndDate >= dbo.getunixtimebig(M.STARTDATE) AND JM.EndDate < dbo.getunixtimebig(M.ENDDATE) AND Cnt > 1
			   AND JM.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
	GROUP BY M.Cnt,M.STARTDATE
	UPDATE @JobDetails SET NoOfDays = DATEDIFF(D,MonthStartDate,DATEADD(M,1,MonthStartDate))
	SELECT @NoOfRstJobs = COUNT(*), @RstDataForLastMonthMB = SUM(TotUnCompMB)
	FROM cf_SurveyRestoreJobStats Rst WITH (NOLOCK)
		INNER JOIN (SELECT DISTINCT CommServUniqueId FROM #CCGrpAssoc) CG
			ON Rst.CommServUniqueId = CG.CommServUniqueId
	WHERE EndTime < dbo.GetUnixTimeBig(@ThisMonth) AND
		  EndTime >= dbo.GetUnixTimeBig(DATEADD(M,-1,@ThisMonth)) AND
		  JobStatus IN (1,3,14)
	DECLARE @totalRstJobs BIGINT, @totalRstSizeMB DECIMAL(10,2)
	SELECT @totalRstJobs = COUNT(Jobid), @totalRstSizeMB = SUM(TotUnCompMB)
	FROM cf_SurveyRestoreJobStats Rst WITH (NOLOCK)
		INNER JOIN (SELECT DISTINCT CommServUniqueId FROM #CCGrpAssoc) CG
			ON Rst.CommServUniqueId = CG.CommServUniqueId
	WHERE EndTime >= dbo.GetUnixTimeBig(DATEADD(YEAR,-1,@ENDDATE)) AND
		  JobStatus IN (1,3,14)
	DECLARE @TotalErrors BIGINT, @Top5Errors BIGINT
	SELECT @TotalErrors = COUNT(JobId)
	FROM cf_SurveyJobStats JM WITH (NOLOCK)
			INNER JOIN (SELECT DISTINCT CommServUniqueId FROM #CCGrpAssoc) resultview
				ON resultview.CommServUniqueId = JM.CommServUniqueId
	WHERE JM.EndDate < dbo.getunixtimebig(@ENDDATE)
			AND JM.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
			AND ErrorCode <> ''
	SELECT @Top5Errors = SUM(Freq)
	FROM
	(SELECT TOP 5 ErrorCode , Count(jobId) AS Freq
	FROM cf_SurveyJobStats JM WITH (NOLOCK)
			INNER JOIN (SELECT DISTINCT CommServUniqueId FROM #CCGrpAssoc) resultview
				ON resultview.CommServUniqueId = JM.CommServUniqueId
	WHERE JM.EndDate < dbo.getunixtimebig(@ENDDATE)
			AND JM.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
			AND ErrorCode <> ''
	GROUP BY ErrorCode
	ORDER BY Freq DESC) R
	SELECT (SELECT CAST(success*100/(total*1.0) AS DECIMAL(10,2)) FROM @JobDetails WHERE MonthNo = @lastMonth) 'LastMonthSuccessRate',
		   (SELECT CAST(success*100/(total*1.0) AS DECIMAL(10,2)) FROM @JobDetails WHERE MonthNo = @last2lastMonth) AS 'SecondLastMonthSuccessRate',
		   (SELECT DATENAME(MONTH, MonthStartDate) +''''+ SUBSTRING(CONVERT(VARCHAR(11),MonthStartDate,7),9,11) FROM @JobDetails WHERE MonthNo = @lastMonth) AS 'LastMonthName',
		   (SELECT DATENAME(MONTH, MonthStartDate) +''''+ SUBSTRING(CONVERT(VARCHAR(11),MonthStartDate,7),9,11) FROM @JobDetails WHERE MonthNo = @last2lastMonth) AS 'Last2LastMonthName',
		   (SELECT CAST(ApplicationSizeMB/NoOfDays AS DECIMAL(20,2)) FROM @JobDetails WHERE MonthNo = @lastMonth) AS 'LastMonthDailyBackupAvgMB',
		   (SELECT CAST(ApplicationSizeMB/NoOfDays AS DECIMAL(20,2)) FROM @JobDetails WHERE MonthNo = @last2lastMonth) AS 'Last2LastMonthDailyBackupAvgMB',
		   (SELECT ApplicationSizeMB FROM @JobDetails WHERE MonthNo = @lastMonth) AS 'LastMonthBackupMB',
		   (SELECT ApplicationSizeMB FROM @JobDetails WHERE MonthNo = @last2lastMonth) AS 'Last2LastMonthBackupMB',
		   ISNULL(@NoOfRstJobs,0) AS 'NoOfRestoreJobs',
		   ISNULL(@RstDataForLastMonthMB,0) AS 'LastMonthRstData',
		   ISNULL(@totalRstJobs,0) AS 'TotalRestoreJobs',
		   ISNULL(@totalRstSizeMB,0) AS 'TotalRestoreSizeMB',
		   DATENAME(MONTH, @STARTDATE) AS 'CurrMonth',
		   CASE WHEN @TotalErrors = 0 THEN '0' ELSE ISNULL(CAST(CAST(ROUND((@Top5Errors*100.0/@TotalErrors),0) AS decimal(10,0)) AS varchar(5))+'%','0') END AS 'PercentageOfErrors',
		   DATENAME(MONTH, getdate())+' '+CAST(YEAR(getdate()) AS VARCHAR(5)) AS 'CurrFullMonthNameAndYear'
	--select * from @JobDetails
	--select dbo.getdatetime(EndDate),* FROM cf_SurveyJobStats where CommservUniqueId = 10026 and EndDate < dbo.GetUnixTimeBig(DATEADD(M,-1,'2015-03-01'))
	--		 AND EndDate > dbo.GetUnixTimeBig(DATEADD(M,-1,'2015-02-01')) order by EndDate desc
	--select datepart(mm,GETDATE()),DATEADD(M,-1,@ThisMonth)
END
ELSE IF @i_param = 2 -- Long and short term retention chart data
BEGIN
	IF OBJECT_ID('tempdb.dbo.#SPInfo') IS NOT NULL DROP TABLE #SPInfo
	CREATE TABLE #SPInfo (
		CommservUniqueId INT,
		PolicyId INT,
		PolicyName NVARCHAR(144),
		PrimRetentionDays INT,
		PrimExtWeekRetDays INT,
		SyncRetentionDays INT,
		SelWeekRetentionDays INT,
		SelMonRetentionDays INT
		)
	--Primary Copies
	INSERT INTO #SPInfo
	SELECT
		csInfo.CommservUniqueId,
		PolicyId,
		PolicyName,
		RetentionDays,
		CASE WHEN (ExtRretentionRules & 4) = 4 THEN 1 ELSE 0 END,
		0, 0, 0
	FROM cf_SurveyCopyBasicRetention csInfo WITH (NOLOCK)
		INNER JOIN (SELECT DISTINCT CommServUniqueId FROM #CCGrpAssoc) resultview
			ON resultview.CommServUniqueId = csInfo.CommservUniqueId
	WHERE IsSnapCopy = 0 AND IsDefaultCopy = 1
	--Synchronous Copies
	UPDATE #SPInfo
	SET SyncRetentionDays = sub2.RetentionDays
	FROM #SPInfo AS sub1
	INNER JOIN
	(SELECT
		csInfo.CommservUniqueId,
		PolicyId,
		RetentionDays,
		ArchiverRetDays
	FROM cf_SurveyCopyBasicRetention csInfo WITH (NOLOCK)
		 INNER JOIN (SELECT DISTINCT CommServUniqueId FROM #CCGrpAssoc) resultview
			ON resultview.CommServUniqueId = csInfo.CommservUniqueId
	WHERE IsSnapCopy = 0 AND IsDefaultCopy = 0 AND CopyType = 1 AND RetentionDays > 60) AS sub2
	ON sub1.CommservUniqueId = sub2.CommservUniqueId AND sub1.PolicyId = sub2.PolicyId
	--Selective Copies Weekly
	UPDATE #SPInfo
	SET SelWeekRetentionDays = sub2.RetentionDays
	FROM #SPInfo AS sub1
	INNER JOIN
	(SELECT
		C.CommservUniqueId,
		C.PolicyId,
		C.RetentionDays,
		C.ArchiverRetDays
	FROM cf_SurveyCopyBasicRetention AS C WITH (NOLOCK)
		INNER JOIN (SELECT DISTINCT CommServUniqueId FROM #CCGrpAssoc) resultview
			ON resultview.CommServUniqueId = C.CommservUniqueId
		INNER JOIN cf_SurveyArchSelectiveCopy AS SC WITH (NOLOCK)
			ON C.CopyId = SC.CopyId
			AND C.IsSnapCopy = 0
			AND C.IsDefaultCopy = 0
			AND C.CopyType = 2
			AND SC.type = 2 ) AS sub2 --Weekly Fulls
	ON sub1.CommservUniqueId = sub2.CommservUniqueId AND sub1.PolicyId = sub2.PolicyId
	--Selective Copies Monthly
	UPDATE #SPInfo
	SET SelMonRetentionDays = sub2.RetentionDays
	FROM #SPInfo AS sub1
	INNER JOIN
	(SELECT
		C.CommservUniqueId,
		C.PolicyId,
		C.RetentionDays,
		C.ArchiverRetDays
	FROM cf_SurveyCopyBasicRetention AS C WITH (NOLOCK)
		INNER JOIN (SELECT DISTINCT CommServUniqueId FROM #CCGrpAssoc) resultview
			ON resultview.CommServUniqueId = C.CommservUniqueId
		INNER JOIN cf_SurveyArchSelectiveCopy AS SC WITH (NOLOCK)
			ON C.CopyId = SC.CopyId
			AND C.IsSnapCopy = 0
			AND C.IsDefaultCopy = 0
			AND C.CopyType = 2
			AND SC.type = 4 ) AS sub2 --Monthly Fulls
	ON sub1.CommservUniqueId = sub2.CommservUniqueId AND sub1.PolicyId = sub2.PolicyId
	SELECT
			SUBSTRING(CONVERT(VARCHAR(11),STARTDATE,106),4,11) AS MonthStartDate,
			SUM(CASE WHEN LongestRetentionDays <= 42 AND LongestRetentionDays <> -1 THEN DataProtectedTB ELSE 0 END) AS 'ShortTermRet',
			SUM(CASE WHEN LongestRetentionDays > 42 OR LongestRetentionDays = -1 THEN DataProtectedTB ELSE 0 END) AS 'LongTermRet'
	FROM
	(
	SELECT SP.CommservUniqueId,
		   JobId,
		   CASE
				WHEN SP.SyncRetentionDays > 0 THEN SP.SyncRetentionDays
				WHEN SP.SelWeekRetentionDays > 0 THEN SP.SelWeekRetentionDays
				WHEN SP.SelMonRetentionDays > 0 THEN SP.SelMonRetentionDays
				ELSE SP.PrimRetentionDays
		   END AS LongestRetentionDays,
		   CAST(JM.DataProtected/1024.0/1024.0/1024.0/1024.0 AS DECIMAL(20,2)) DataProtectedTB,
		   JM.EndDate,
		   M.Cnt,
		   M.STARTDATE
	FROM #SPInfo SP
		INNER JOIN cf_SurveyJobStats JM WITH (NOLOCK)
			ON SP.CommservUniqueId = JM.CommservUniqueId AND SP.PolicyId = JM.StoragePolicyID AND JM.Status IN (1,3,14)
		RIGHT OUTER JOIN #LastNMonths M
			ON JM.EndDate >= dbo.getunixtimebig(M.STARTDATE) AND JM.EndDate < dbo.getunixtimebig(M.ENDDATE)
	) A
	GROUP BY STARTDATE
	order by STARTDATE
	IF OBJECT_ID('tempdb.dbo.#SPInfo') IS NOT NULL DROP TABLE #SPInfo
END
ELSE IF @i_param = 3 -- Restore Summary Charts data
BEGIN
	IF OBJECT_ID('tempdb.dbo.#RstStats') IS NOT NULL DROP TABLE #RstStats
	SELECT R.CommservUniqueId, M.STARTDATE, COUNT(DISTINCT Jobid) AS JobCount, SUM(TotUnCompMB)/1024.0 AS RstSize
	INTO #RstStats
	FROM cf_SurveyRestoreJobStats R WITH (NOLOCK)
				  INNER JOIN (SELECT DISTINCT CommServUniqueId FROM #CCGrpAssoc) resultview
					ON resultview.CommServUniqueId = R.CommServUniqueId AND R.JobStatus IN (1,3,14)
				  INNER JOIN #LastNMonths M
					ON R.EndTime >= dbo.getunixtimebig(M.STARTDATE) AND R.EndTime < dbo.getunixtimebig(M.ENDDATE)
			GROUP BY R.CommservUniqueId, M.STARTDATE
	IF @i_GroupId <= 0 -- Global Restore SUmamry Chart data on slide 12 (slide number from template)
	BEGIN
		SELECT @cols = REPLACE(STUFF((SELECT ',' + QUOTENAME(Name)
							from (SELECT DISTINCT Name FROM #CCGrpAssoc)  CG
							order by Name
					FOR XML PATH(''))
				,1,1,''),'&amp;','&')
		SET @query = N'SELECT RIGHT(CONVERT(VARCHAR(20),CAST(M.STARTDATE AS DATE),6),6) AS Months, ' +
								  REPLACE(STUFF((SELECT ',ISNULL(' + QUOTENAME(Name) + ',0) AS '+ QUOTENAME(Name)
																from (SELECT DISTINCT Name FROM #CCGrpAssoc)  CG
																order by Name
														FOR XML PATH(''))
													,1,1,''),'&amp;','&') + N', ISNULL([Total Count],0) AS ''Total Count'', ISNULL([Size(GB)],0) AS ''Size(GB)''
						FROM #LastNMonths M LEFT OUTER JOIN
						(SELECT Months, ' + @cols + N', [Total Count], [Size(GB)] from
						 (
							SELECT CG.name AS CCGroupName,R.STARTDATE AS Months,
								   SUM(R.JobCount) AS Val
							FROM #RstStats R
								INNER JOIN #CCGrpAssoc CG
									ON R.CommServUniqueId = CG.CommServUniqueId
							GROUP BY CG.id, CG.name, R.STARTDATE
							UNION
							SELECT ''Total Count'' AS CCGroupName,R.STARTDATE AS Months,
									SUM(R.JobCount) AS Val
							FROM #RstStats R
							GROUP BY R.STARTDATE
							UNION
							SELECT ''Size(GB)'' AS CCGroupName,R.STARTDATE AS Months,
									CAST(ROUND(SUM(R.RstSize),0) AS BIGINT) AS Val
							FROM #RstStats R
							GROUP BY R.STARTDATE
						) A
						pivot
						(
							max(Val)
							for CCGroupName in (' + @cols + N', [Total Count], [Size(GB)])
						) p
					) R
					ON M.STARTDATE = R.Months
					order by M.STARTDATE	'
		EXEC sp_executesql @query;
	END
	ELSE -- Other restore summary charts for indiviual commcell groups from slide 7 to slide 10
	BEGIN
		SELECT RIGHT(CONVERT(VARCHAR(20),CAST(M.STARTDATE AS DATE),6),6) AS Months, ISNULL(JobCount,0) AS 'Count', ISNULL(CompleteRstSize,0) AS 'Size(GB)'
		FROM #LastNMonths M LEFT OUTER JOIN
		(SELECT STARTDATE, SUM(JobCount) AS JobCount, CAST(ROUND(SUM(RstSize),0) AS INT) AS CompleteRstSize
				FROM #RstStats
				GROUP BY STARTDATE) R
			ON M.STARTDATE = R.STARTDATE
		ORDER BY M.STARTDATE
	END
	IF OBJECT_ID('tempdb.dbo.#RstStats') IS NOT NULL DROP TABLE #RstStats
END
ELSE IF @i_param IN (4,5) --4: Consumer Report(slide 3-6) 5: Factory Report (slide 7-10)
BEGIN
	IF OBJECT_ID('tempdb.dbo.#JobsInfo') IS NOT NULL DROP TABLE #JobsInfo
	IF OBJECT_ID('tempdb.dbo.#TimeFrame') IS NOT NULL DROP TABLE #TimeFrame
	CREATE TABLE #TimeFrame (
		TimeFrameBegin INT,
		TimeFrameEnd INT
		)
	CREATE TABLE #JobsInfo (
		CommservUniqueId INT,
		JobId INT,
		SubclientId NVARCHAR(144),
		OpType INT,
		Status INT,
		StartDate INT,
		EndDate INT,
		DataProtected BIGINT,
		TimeFrameBegin INT,
		TimeFrameEnd INT
		)
	DECLARE @timeFrameEnd DATETIME = CAST(GETDATE() AS VARCHAR(11))+' 18:00:00.000'
	DECLARE @timeFrameBegin DATETIME = DATEADD(DAY,-1,@timeFrameEnd)
	;WITH TimeFrame(Cnt, DTimeFrameBegin , DTimeFrameEnd ) AS
	(
		SELECT 1,@timeFrameBegin, @timeFrameEnd
		UNION ALL
		SELECT Cnt+1,DATEADD(MONTH, -1, DTimeFrameBegin),DATEADD(DAY,1,DATEADD(MONTH, -1, DTimeFrameBegin))
		FROM TimeFrame WHERE Cnt < @lastNMonths
	),
	TimeFrame2 (Cnt, TimeFrameBegin , TimeFrameEnd ) AS
	(
		SELECT 1,DTimeFrameBegin,DTimeFrameEnd FROM TimeFrame
		UNION ALL
		SELECT Cnt+1,DATEADD(DAY,-1,TimeFrameBegin),DATEADD(DAY,1,DATEADD(DAY,-1,TimeFrameBegin)) FROM TimeFrame2
		WHERE Cnt <= 31
	)
	--select YEAR(TimeFrameBegin),MONTH(TimeFrameBegin),COUNT(*) from
	--(SELECT distinct TimeFrameBegin,TimeFrameEnd FROM TimeFrame2 ) A
	--group by YEAR(TimeFrameBegin),MONTH(TimeFrameBegin)
	--order by YEAR(TimeFrameBegin) desc,MONTH(TimeFrameBegin) desc
	INSERT INTO #JobsInfo(CommservUniqueId, JobId, SubclientId, OpType, Status, StartDate, EndDate, DataProtected, TimeFrameBegin, TimeFrameEnd)
	SELECT JM.CommservUniqueId,JobId, AppId, OpType, Status, StartDate, EndDate, DataProtected, F.TimeFrameBegin, F.TimeFrameEnd
		FROM cf_SurveyJobStats JM WITH (NOLOCK)
			INNER JOIN (SELECT DISTINCT CommServUniqueId FROM #CCGrpAssoc) resultview
				ON resultview.CommServUniqueId = JM.CommservUniqueId
		INNER JOIN (SELECT distinct dbo.GetUnixTimeBig(TimeFrameBegin) TimeFrameBegin,dbo.GetUnixTimeBig(TimeFrameEnd) TimeFrameEnd FROM TimeFrame2) F
			ON JM.EndDate >= F.TimeFrameBegin AND JM.EndDate < F.TimeFrameEnd
			   AND JM.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
	--SELECT CommservUniqueId, JobId, SubclientId, Status, dbo.GetDateTime(EndDate) JobEndate,
	--		dbo.GetDateTime(TimeFrameBegin) TimeFrameBegin, dbo.GetDateTime(TimeFrameEnd) TimeFrameEnd  FROM #JobStrike
	--ORDER BY CommservUniqueId, TimeFrameBegin, SubclientId, JobId
	IF @i_param IN (4) -- Special case for handling 6pm to next day 6pm window for Consumer report
	BEGIN
		;WITH SuccessfulJobsFrSubClientInTimeFrame (CommservUniqueId, TimeFrameBegin, TimeFrameEnd, SubclientId, SuccessfulJobId)
		AS
		(
			SELECT CommservUniqueId, TimeFrameBegin, TimeFrameEnd, SubclientId, MAX(JobId)
			FROM #JobsInfo WHERE Status IN (1,3,14)
			GROUP BY CommservUniqueId, TimeFrameBegin, TimeFrameEnd, SubclientId
		)
		DELETE J
		FROM #JobsInfo J
			INNER JOIN SuccessfulJobsFrSubClientInTimeFrame S
				ON J.CommservUniqueId = S.CommservUniqueId AND J.TimeFrameBegin = S.TimeFrameBegin AND J.TimeFrameEnd = S.TimeFrameEnd AND J.SubclientId = S.SubclientId
					AND J.JobId < S.SuccessfulJobId
		WHERE Status NOT IN (1,3,14)
		--SELECT CommservUniqueId, JobId, SubclientId, Status, dbo.GetDateTime(EndDate) JobEndate,
		--		dbo.GetDateTime(TimeFrameBegin) TimeFrameBegin, dbo.GetDateTime(TimeFrameEnd) TimeFrameEnd  FROM #JobStrike
		--ORDER BY CommservUniqueId, TimeFrameBegin, SubclientId, JobId
	END
	SELECT RIGHT(CONVERT(VARCHAR(20),CAST(STARTDATE AS DATE),106),8) Month, Success AS Succeeded, [Partial Success], Failed,
		   CASE WHEN Total <= 0 THEN 0
				ELSE CAST(ROUND((Success+[Partial Success])*100.0/Total,2) AS DECIMAL(10,2))
			END AS [Success Rate], Total, [Size(TB)], [Client Count]
	FROM (SELECT M.STARTDATE,
		   SUM(CASE WHEN Status IN (1,14) THEN 1 ELSE 0 END) Success,
		   SUM(CASE WHEN Status IN (3) THEN 1 ELSE 0 END) 'Partial Success',
		   SUM(CASE WHEN Status NOT IN (1,3,14) THEN 1 ELSE 0 END) Failed,
		   COUNT(JobId) Total,
		   ISNULL(CAST((SUM(DataProtected)/1024.0/1024.0/1024.0/1024.0) AS DECIMAL(20,2)),0) 'Size(TB)',
		   COUNT(DISTINCT clientId) 'Client Count'
	FROM #JobsInfo JM
		 INNER JOIN cf_SurveySubclientAssociation SA
			ON JM.CommservUniqueId = SA.CommservUniqueId AND JM.SubclientId = SA.AppId
		 RIGHT OUTER JOIN #LastNMonths M
			ON JM.EndDate >= dbo.getunixtimebig(M.STARTDATE) AND JM.EndDate < dbo.getunixtimebig(M.ENDDATE)
	GROUP BY M.STARTDATE ) J
	ORDER BY STARTDATE
	IF OBJECT_ID('tempdb.dbo.#JobsInfo') IS NOT NULL DROP TABLE #JobsInfo
	IF OBJECT_ID('tempdb.dbo.#TimeFrame') IS NOT NULL DROP TABLE #TimeFrame
END
ELSE IF @i_param = 6 -- Strike chart Data on slide 1
BEGIN
	IF OBJECT_ID('tempdb.dbo.#JobDetails') IS NOT NULL DROP TABLE #JobDetails
	IF OBJECT_ID('tempdb.dbo.#JobStrike') IS NOT NULL DROP TABLE #JobStrike
	CREATE TABLE #JobDetails (CommservUniqueId INT, MonthStartDate DATE, MonthEndDate DATE, JobId INT, appId INT, bkpLevel INT, status INT, opType INT, servStartDate INT, servEndDate INT
	)
	CREATE TABLE #JobStrike (
			CommservUniqueId INT, MonthStartDate DATE, appId INT, lastSuccJobId INT, nFailedJobs INT, failedSince DATETIME,
			lastJobId INT, lastJobStart INT, lastJobEnd INT, lastJobStatus INT, failureReason VARCHAR(256))
	INSERT INTO #Jobdetails
	SELECT JM.CommservUniqueId, M.STARTDATE, M.ENDDATE, JM.jobId,  JM.appId, JM.bkpLevel, JM.status, JM.opType, JM.StartDate, JM.EndDate
	FROM cf_SurveyJobStats JM WITH (NOLOCK)
		INNER JOIN (SELECT DISTINCT CommServUniqueId FROM #CCGrpAssoc) resultview
				ON resultview.CommServUniqueId = JM.CommservUniqueId
		INNER JOIN #LastNMonths M
			ON JM.EndDate >= dbo.getunixtimebig(M.STARTDATE) AND JM.EndDate < dbo.getunixtimebig(M.ENDDATE)
	INSERT INTO #JobStrike
	SELECT  CommservUniqueId, MonthStartDate, appId, MAX(ISNULL(jobId, 0)), 0, NULL, 0, 0, 0, 0, NULL
	FROM    #jobdetails
	WHERE bkpLevel NOT IN (64, 128, 16384)
		AND opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
	GROUP BY CommservUniqueId, MonthStartDate, appId
	HAVING SUM(CASE WHEN status NOT IN (1, 3, 14) THEN 1 ELSE 0 END)  = 0
	;WITH LastFailedJob (CommservUniqueId, MonthStartDate, appId, jobId) AS
	(
		SELECT  CommservUniqueId, MonthStartDate, appId, MAX(jobId)
		FROM    #jobdetails WITH (NOLOCK)
		WHERE   bkpLevel NOT IN (64, 128, 16384)
			AND status NOT IN (1, 3, 14)
			AND opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
		GROUP BY CommservUniqueId, MonthStartDate, appId
	)
	INSERT INTO #JobStrike
	SELECT  F.CommservUniqueId, F.MonthStartDate, F.appId, MAX(ISNULL(J.jobId, 0)), 0, NULL, F.jobId, 0, 0, 0, NULL
	FROM    LastFailedJob F
			LEFT OUTER JOIN #jobdetails J ON J.CommservUniqueId = F.CommservUniqueId AND J.MonthStartDate = F.MonthStartDate AND J.appId = F.appId
		AND bkpLevel NOT IN (64, 128, 16384)
		AND status IN (1, 3, 14)
		AND opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
	GROUP BY F.CommservUniqueId, F.MonthStartDate, F.appId, F.jobId
	HAVING  MAX(ISNULL(J.jobId, 0)) < F.jobId
	; WITH FailedJobStats (CommservUniqueId, MonthStartDate, appId, nFailedJobs, failedSince) AS
	(
		 SELECT F.CommservUniqueId, F.MonthStartDate, F.appId, COUNT(J.jobId), MIN(J.servStartDate)
		 FROM   #jobdetails J WITH (NOLOCK) INNER JOIN #JobStrike F ON J.CommservUniqueId = F.CommservUniqueId AND J.MonthStartDate = F.MonthStartDate AND J.appId = F.appId
		 WHERE  J.bkpLevel NOT IN (64, 128, 16384)
			AND J.status NOT IN (1, 3, 14)
			AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
			AND J.jobId > F.lastSuccJobId
		 GROUP BY F.CommservUniqueId, F.MonthStartDate, F.appId
	)
	UPDATE  #JobStrike
	SET     nFailedJobs = F.nFailedJobs, failedSince = dbo.GetDateTime(F.failedSince)
	FROM    #JobStrike J INNER JOIN FailedJobStats F ON J.CommservUniqueId = F.CommservUniqueId AND J.MonthStartDate = F.MonthStartDate AND J.appId = F.appId
	SELECT RIGHT(CONVERT(VARCHAR(20),CAST(M.STARTDATE AS DATE),6),6) Month,
		   ISNULL([0 Strike],0) AS [0 Strike],
		   ISNULL([1 Strike],0) AS [1 Strike],
		   ISNULL([2 Strike],0) AS [2 Strike],
		   ISNULL([3 Strike],0) AS [3 Strike]
	FROM #LastNMonths M LEFT OUTER JOIN
	(SELECT MonthStartDate,
		   SUM(CASE WHEN nFailedJobs = 0 THEN 1 ELSE 0 END) AS '0 Strike',
		   SUM(CASE WHEN nFailedJobs = 1 THEN 1 ELSE 0 END) AS '1 Strike',
		   SUM(CASE WHEN nFailedJobs = 2 THEN 1 ELSE 0 END) AS '2 Strike',
		   SUM(CASE WHEN nFailedJobs >= 3 THEN 1 ELSE 0 END) AS '3 Strike'
	FROM #JobStrike
	GROUP BY MonthStartDate	) J
		ON J.MonthStartDate = M.STARTDATE
	ORDER BY M.STARTDATE
	IF OBJECT_ID('tempdb.dbo.#JobDetails') IS NOT NULL DROP TABLE #JobDetails
	IF OBJECT_ID('tempdb.dbo.#JobStrike') IS NOT NULL DROP TABLE #JobStrike
END
ELSE IF @i_param IN (7) -- Monthly Backup Error Summary for current month for slides 7-10 and for global error summary on slide 16
BEGIN
	IF OBJECT_ID('tempDB..#ErrorCodeFreq') IS NOT NULL
		DROP TABLE #ErrorCodeFreq
	SELECT JM.CommServUniqueId, ErrorCode,COUNT(*) AS Frequency, MAX(JobId) AS JobId
	INTO #ErrorCodeFreq
		FROM cf_SurveyJobStats JM WITH (NOLOCK)
			 INNER JOIN (SELECT DISTINCT CommServUniqueId FROM #CCGrpAssoc) resultview
					ON resultview.CommServUniqueId = JM.CommServUniqueId
		WHERE JM.EndDate >= dbo.getunixtimebig(@STARTDATE) AND JM.EndDate < dbo.getunixtimebig(@ENDDATE)
			  AND JM.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
			  AND ErrorCode <> ''
		GROUP BY JM.CommServUniqueId, ErrorCode
	IF @i_GroupId <= 0  -- Global Backup Services on slide 16
	BEGIN
		SELECT @cols = REPLACE(STUFF((SELECT ',' + QUOTENAME(Name)
							from (SELECT DISTINCT Name FROM #CCGrpAssoc) CG
							order by Name
					FOR XML PATH(''))
				,1,1,''),'&amp;','&')
		SET @query = N'SELECT ErrCode+''-''+(SELECT TOP 1 LEFT(FailureReason,CASE WHEN CHARINDEX(''Source:'',FailureReason) = 0 THEN LEN(FailureReason) ELSE CHARINDEX(''Source:'',FailureReason)-1 END) FROM cf_SurveyJobStats JM WITH (NOLOCK) WHERE JM.ErrorCode = ErrCode) AS ErrorCode,' +
							  REPLACE(STUFF((SELECT ',ISNULL(' + QUOTENAME(CG.Name) + ',0) AS '+ QUOTENAME(CG.Name)
															from (SELECT DISTINCT Name FROM #CCGrpAssoc) CG
															order by CG.Name
													FOR XML PATH(''))
												,1,1,''),'&amp;','&') + N' from
					 (
						SELECT CG.name AS CCGroupName,E.ErrorCode AS ErrCode,
							   SUM(E.Frequency) AS Frequency
						FROM #ErrorCodeFreq E
							INNER JOIN (SELECT TOP 5 ErrorCode,SUM(Frequency) AS Freq FROM #ErrorCodeFreq GROUP BY ErrorCode ORDER BY Freq DESC) Top5
								ON E.ErrorCode = Top5.ErrorCode
							INNER JOIN #CCGrpAssoc CG
								ON E.CommServUniqueId = CG.CommServUniqueId
						GROUP BY CG.id, CG.name, E.ErrorCode
					) A
					pivot
					(
						max(Frequency)
						for CCGroupName in (' + @cols + N')
					) p '
		EXEC sp_executesql @query;
	END
	ELSE -- For individual commcell groups error summary for slides 7-10
		SELECT TOP 5 ErrorCode+'-'+(SELECT TOP 1 LEFT(FailureReason,CASE WHEN CHARINDEX('Source:',FailureReason) = 0 THEN LEN(FailureReason) ELSE CHARINDEX('Source:',FailureReason)-1 END) FROM cf_SurveyJobStats JM WITH (NOLOCK) WHERE JM.JobId = E.JobId AND JM.ErrorCode = E.ErrorCode) AS ErrorCode,
			Freq
		FROM (SELECT TOP 5 ErrorCode,SUM(Frequency) AS Freq, MAX(JobId) AS JobId  FROM #ErrorCodeFreq GROUP BY ErrorCode ORDER BY Freq DESC) E ORDER BY Freq DESC
	IF OBJECT_ID('tempDB..#ErrorCodeFreq') IS NOT NULL
		DROP TABLE #ErrorCodeFreq
END
ELSE IF @i_param IN (8, 9) -- Past 5 months Backup Error Summary Globally for slide 18
BEGIN
	IF OBJECT_ID('tempDB..#ErrorCodeFreqForPast5Months') IS NOT NULL
		DROP TABLE #ErrorCodeFreqForPast5Months
	DECLARE @TopNErrors INT = 1
	IF @i_param = 9
		SET @TopNErrors = @TopNErrors + 5 -- Return next 5 error codes
	SELECT M.STARTDATE, ErrorCode,COUNT(*) AS Frequency
	INTO #ErrorCodeFreqForPast5Months
		FROM cf_SurveyJobStats JM WITH (NOLOCK)
			 INNER JOIN (SELECT DISTINCT CommServUniqueId FROM #CCGrpAssoc) resultview
				ON resultview.CommServUniqueId = JM.CommServUniqueId
				   AND JM.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
				   AND ErrorCode <> ''
			INNER JOIN #LastNMonths M
				ON JM.EndDate >= dbo.getunixtimebig(M.STARTDATE) AND JM.EndDate < dbo.getunixtimebig(M.ENDDATE)
		GROUP BY M.STARTDATE, ErrorCode
	SELECT @cols = REPLACE(STUFF((SELECT ',' + QUOTENAME(DATENAME(MONTH,STARTDATE))
							from #LastNMonths
							order by STARTDATE
					FOR XML PATH(''))
				,1,1,''),'&amp;','&')
	SET @query = N'SELECT ErrCode+''-''+(SELECT TOP 1 LEFT(FailureReason,CASE WHEN CHARINDEX(''Source:'',FailureReason) = 0 THEN LEN(FailureReason) ELSE CHARINDEX(''Source:'',FailureReason)-1 END) FROM cf_SurveyJobStats JM WITH (NOLOCK) WHERE JM.ErrorCode = ErrCode) AS ErrorCode,' +
						  REPLACE(STUFF((SELECT ',ISNULL(' + QUOTENAME(DATENAME(MONTH,STARTDATE)) + ',0) AS '+ DATENAME(MONTH,STARTDATE)
														from #LastNMonths
														order by STARTDATE
												FOR XML PATH(''))
											,1,1,''),'&amp;','&') + N' from
				 (
					SELECT DATENAME(MONTH,E.STARTDATE) AS Month, E.ErrorCode AS ErrCode, E.Frequency ErrorCount
					FROM #ErrorCodeFreqForPast5Months E
						INNER JOIN (SELECT ROW_NUMBER() OVER (order by SUM(Frequency) DESC) Rank, ErrorCode
										FROM  #ErrorCodeFreqForPast5Months
										GROUP BY ErrorCode ) T
							ON E.ErrorCode = T.ErrorCode AND T.Rank BETWEEN '+CAST(@TopNErrors AS NVARCHAR(2))+N' AND '+CAST((@TopNErrors+4) AS NVARCHAR(2))+'
				) A
				pivot
				(
					max(ErrorCount)
					for Month in (' + @cols + N')
				) p '
	EXEC sp_executesql @query;
	IF OBJECT_ID('tempDB..#ErrorCodeFreqForPast5Months') IS NOT NULL
		DROP TABLE #ErrorCodeFreqForPast5Months
END
IF OBJECT_ID('tempdb.dbo.#LastNMonths') IS NOT NULL DROP TABLE #LastNMonths
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptMonthlyPptData')
	delete from GxQscripts where name = 'RptMonthlyPptData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptMonthlyPptData')
	delete from GXDBVersions where aliasname = 'RptMonthlyPptData'
GO

insert into GXDBVersions values(2, 'RptMonthlyPptData',  '00010003000000000000', 'RptMonthlyPptData', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseTurboUsage.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseTurboUsage.sp,v $ $Id: ParseTurboUsage.sp,v 1.3 2015/06/24 18:45:04 dscott Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ParseTurboUsage <<<'

IF EXISTS (select * from sysobjects where name='ParseTurboUsage')
	drop procedure ParseTurboUsage
IF EXISTS (select * from GxQscripts where name='ParseTurboUsage')
	delete from GxQscripts where name = 'ParseTurboUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseTurboUsage')
	delete from GXDBVersions where aliasname = 'ParseTurboUsage'
GO
print '... Creating Procedure: ParseTurboUsage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseTurboUsage
  @parseTime DATETIME,
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
SET NOCOUNT ON
DECLARE @surveyId INTEGER = 110
SELECT @ErrorString = 'Parsing results for Query ID ' + CAST(@surveyId AS VARCHAR(20)) + ' - started'
IF @isPrintOn = 1
	PRINT @ErrorString
INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
DECLARE @ProcessSurveyResultTran INT
SET @ProcessSurveyResultTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 1
	END
	INSERT INTO cf_SurveyTurboUsage
	SELECT
	files.CommcellIdNameMap_ID,
	results.CommservSurveyResults_ID,
	results.LogDateUTC,
	results.LogDate,
	csInfo.n.value('@AppType' , '[INT]'),
	csInfo.n.value('@Name' , '[VARCHAR](30)'),
	csInfo.n.value('@AppIdCount' , '[INT]'),
	csInfo.n.value('@SizeMB','FLOAT')
	FROM
	cf_CommservSurveyResults AS results
	INNER JOIN cf_CustomerFeedbackXmlFile AS files
	ON files.ShredStatus = 1
	AND files.ID = results.CustomerFeedbackXmlFile_ID
	AND results.ShredStatus = 1
	AND results.QueryId = @surveyId
	AND files.ParseTime = @parseTime
	CROSS apply results.CollectedResults.nodes('TurboSubClient') AS csInfo(n)
	IF (@ProcessSurveyResultTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessSurveyResultTran
		SET @ProcessSurveyResultTran = 0
	END
	SELECT @ErrorCode = 0
	SELECT @ErrorString ='Turbo Usage - complete'
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

IF (XACT_STATE() <> 0 AND @ProcessSurveyResultTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessSurveyResultTran
	SET @ProcessSurveyResultTran = 0
	SELECT @ErrorCode = 1
	SELECT @ErrorString ='Turbo Usage - failed with error :: ' + ERROR_MESSAGE()
	IF @isPrintOn = 1
		PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
END
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseTurboUsage')
	delete from GxQscripts where name = 'ParseTurboUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseTurboUsage')
	delete from GXDBVersions where aliasname = 'ParseTurboUsage'
GO

insert into GXDBVersions values(2, 'ParseTurboUsage',  '00010003000000000000', 'ParseTurboUsage', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptQuarterlyPptData.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptQuarterlyPptData.sp,v $ $Id: RptQuarterlyPptData.sp,v 1.5 2015/07/14 13:35:32 vmishra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptQuarterlyPptData <<<'

IF EXISTS (select * from sysobjects where name='RptQuarterlyPptData')
	drop procedure RptQuarterlyPptData
IF EXISTS (select * from GxQscripts where name='RptQuarterlyPptData')
	delete from GxQscripts where name = 'RptQuarterlyPptData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptQuarterlyPptData')
	delete from GXDBVersions where aliasname = 'RptQuarterlyPptData'
GO
print '... Creating Procedure: RptQuarterlyPptData'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptQuarterlyPptData
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll,
  @i_param INT = NUll,
  @lastNMonths INT = 12
AS
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
DECLARE @queryId INT = 51
DECLARE @ThisMonth  DATE = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()),0)
DECLARE @STARTDATE  DATE = @ThisMonth
DECLARE @ENDDATE    DATE = DATEADD(MONTH, 1, @STARTDATE)
DECLARE @query NVARCHAR(MAX)
DECLARE @cols AS NVARCHAR(MAX)
IF OBJECT_ID('tempdb.dbo.#CCGrpAssoc') IS NOT NULL DROP TABLE #CCGrpAssoc
IF OBJECT_ID('tempdb.dbo.#LastNMonths') IS NOT NULL DROP TABLE #LastNMonths
SELECT CG.id, CG.name, CA.commcellIdNameMap_ID AS CommServUniqueId
INTO #CCGrpAssoc
FROM RptGetCommCellGroups(@i_UserId) VG
	 INNER JOIN cf_CommCellGroupAssoc CA WITH (NOLOCK)
		ON VG.GroupId = CA.CommCellGroupId
	 INNER JOIN cf_CommCellGroup CG WITH (NOLOCK)
		ON CA.CommCellGroupId = CG.id
IF @i_GroupId > 0
	DELETE FROM #CCGrpAssoc WHERE id NOT IN (@i_GroupId)
;WITH MONTHS(Cnt, STARTDATE , ENDDATE ) AS
(
	SELECT 1,@STARTDATE, @ENDDATE
	UNION ALL
	SELECT Cnt+1,DATEADD(MONTH, -1, STARTDATE),STARTDATE
	FROM MONTHS WHERE Cnt < @lastNMonths
)
SELECT *
INTO #LastNMonths
FROM MONTHS
IF @i_param = -1
BEGIN
	Select TOP 1 CASE WHEN CustomerName LIKE '' THEN CommServName ELSE CustomerName
                            END AS CustomerName
	FROM RptGetCommCellGroups(@i_UserId) VG
		INNER JOIN cf_CommCellGroupAssoc CA WITH (NOLOCK)
			ON VG.GroupId = CA.CommCellGroupId
		INNER JOIN cf_CommcellIDNameMap CC WITH (NOLOCK)
			ON  CA.CommcellIdNameMap_ID = CC.id
END
ELSE IF @i_param = 0	-- Returns Commcell Group names for which data needs to be populated
BEGIN
	SELECT CAST(DATEPART(YEAR,MIN(ENDDATE)) AS VARCHAR(5)) + '-' + CAST(DATEPART(YEAR,MAX(ENDDATE)) AS VARCHAR(5)) AS Interval
	FROM #LastNMonths
END
ELSE IF @i_param = 1
BEGIN
	SET @queryId = 51
	SELECT SUBSTRING(DATENAME(MONTH,M.STARTDATE),1,3) AS Months, ISNULL(BackupSizeTB,0) BackupSizeTB
	FROM #LastNMonths M LEFT OUTER JOIN
	(
		SELECT B.servEndDate, CAST((SUM(BackupSize)/1024.0/1024.0/1024.0/1024.0) AS DECIMAL(10,1)) AS BackupSizeTB FROM
		cf_SurveyBkpJobStats_WMon B WITH (NOLOCK) INNER JOIN
		(
			SELECT B.CommServUniqueID, B.servEndDate, MAX(SurverResultId) AS SurveyResultId
			FROM cf_SurveyBkpJobStats_WMon B WITH (NOLOCK)
			INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueID, 0, null,null, @i_UserId, @i_GroupId) resultView
				ON B.surveyResultId = resultView.SurverResultId  AND outType = 1
			INNER JOIN (SELECT DISTINCT CommServUniqueID FROM #CCGrpAssoc) CG
				ON resultView.CommServUniqueId = CG.CommServUniqueId
			GROUP BY B.CommServUniqueID, B.servEndDate
		) S
			ON B.servEndDate = S.servEndDate AND B.SurveyResultId = S.SurveyResultId AND outType = 1
		GROUP BY B.servEndDate
	) I
		ON M.STARTDATE = I.servEndDate
	ORDER by M.STARTDATE
END
ELSE IF @i_param = 2
BEGIN
	SET @queryId = 77
	DECLARE @LastQStartDate DATETIME = DATEADD(MONTH,-3, @STARTDATE)
	--SELECT @STARTDATE, @LastQStartDate
	DECLARE @tempResults TABLE (SNo INT, Parameter VARCHAR(128), DateCol VARCHAR(16), ValOnDates VARCHAR(64))
	INSERT INTO @tempResults
	SELECT 1, 'Number of clients', CASE WHEN DATEADD(MONTH,Months -1 + (Years-1970)*12,'1970-01-01') <= @LastQStartDate THEN 'Date1' ELSE 'Date2' END, SUM(LatestVersionCount+IILatestVersionCount+IIILatestversionCount)
	FROM cf_Survey106ClientVersion V WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueID, 1, null,null, @i_UserId, @i_GroupId) resultView
			ON V.surveyResultId = resultView.surverResultId
		INNER JOIN (SELECT DISTINCT CommServUniqueID FROM #CCGrpAssoc) CG
				ON resultView.CommServUniqueId = CG.CommServUniqueId
	WHERE (V.Months = MONTH(@STARTDATE) AND V.Years = YEAR(@STARTDATE) ) OR
		  (V.Months = MONTH(@LastQStartDate) AND V.Years = YEAR(@LastQStartDate) )
	GROUP BY Months, Years
	DECLARE @LastCollectedJobsDate DATETIME = (SELECT MAX(servEndDate) FROM cf_SurveyBkpJobStats_Daily D WITH (NOLOCK)
												INNER JOIN #CCGrpAssoc CG
													ON D.CommServUniqueId = CG.CommServUniqueId	)
	INSERT INTO @tempResults
	SELECT 2, 'Total Data Size Backed Up in Last 24 Hours', CASE WHEN D.servEndDate < @LastQStartDate THEN 'Date1' ELSE 'Date2' END , SUM(BackupSize)
	FROM cf_SurveyBkpJobStats_Daily D WITH (NOLOCK)
		INNER JOIN (SELECT DISTINCT CommServUniqueID FROM #CCGrpAssoc) CG
				ON D.CommServUniqueId = CG.CommServUniqueId
	WHERE D.servEndDate = @LastCollectedJobsDate OR D.servEndDate = DATEADD(DD,-1,@LastQStartDate)
	GROUP BY D.servEndDate
	DECLARE @LastWeekEndDateFrmQ DATETIME = DATEADD(DD,-1*(CASE WHEN DATEPART(DW,@LastQStartDate) = 1 THEN 8 ELSE DATEPART(DW,@LastQStartDate) END), @LastQStartDate)
	DECLARE @LastWeekEndDateFrmLastCollection DATETIME = DATEADD(DD,-1*(CASE WHEN DATEPART(DW,@LastCollectedJobsDate) = 1 THEN 8 ELSE DATEPART(DW,@LastCollectedJobsDate) END), @LastCollectedJobsDate)
	--SELECT @LastWeekEndDateFrmQ, @LastWeekEndDateFrmLastCollection
	INSERT INTO @tempResults
	SELECT 3, 'Last WeekendData Size Backed Up', DateVal, SUM(BackupSize)
	FROM
	(SELECT CASE WHEN D.servEndDate < @LastQStartDate THEN 'Date1' ELSE 'Date2' END AS DateVal, BackupSize
	FROM cf_SurveyBkpJobStats_Daily D WITH (NOLOCK)
		INNER JOIN (SELECT DISTINCT CommServUniqueID FROM #CCGrpAssoc) CG
				ON D.CommServUniqueId = CG.CommServUniqueId
	WHERE D.servEndDate BETWEEN @LastWeekEndDateFrmQ AND DATEADD(DD,1,@LastWeekEndDateFrmQ)
		 OR D.servEndDate BETWEEN @LastWeekEndDateFrmLastCollection AND DATEADD(DD,1,@LastWeekEndDateFrmLastCollection)
	) B
	GROUP BY B.DateVal
	DECLARE @Last7DaysFrmQ DATETIME = DATEADD(DD,-7, @LastQStartDate)
	DECLARE @Last7DaysFrmLastCollection DATETIME = DATEADD(DD,-7, @LastCollectedJobsDate)
	INSERT INTO @tempResults
	SELECT 4, 'Data Size Backed Up in Last 7 Days', DateVal, SUM(BackupSize)
	FROM
	(SELECT CASE WHEN D.servEndDate <= @LastQStartDate THEN 'Date1' ELSE 'Date2' END AS DateVal, BackupSize
	FROM cf_SurveyBkpJobStats_Daily D WITH (NOLOCK)
		INNER JOIN (SELECT DISTINCT CommServUniqueID FROM #CCGrpAssoc) CG
				ON D.CommServUniqueId = CG.CommServUniqueId
	WHERE D.servEndDate BETWEEN @Last7DaysFrmQ AND @LastQStartDate
		 OR D.servEndDate BETWEEN @Last7DaysFrmLastCollection AND @LastCollectedJobsDate
	) B
	GROUP BY B.DateVal
	SELECT 0 AS SNo, '' AS Entity, CONVERT(VARCHAR(32), @LastQStartDate, 107) AS 'Date1', CONVERT(VARCHAR(32), ISNULL(@LastCollectedJobsDate,GETDATE()), 107) AS 'Date2'
	UNION ALL
	SELECT SNo, Parameter AS Entity,
		  CASE WHEN SNo IN (2,3,4) THEN dbo.FormatBytes(CAST(ISNULL([Date1],0) AS BIGINT), 'Bytes') ELSE ISNULL([Date1],0) END AS 'Date1',
		  CASE WHEN SNo IN (2,3,4) THEN dbo.FormatBytes(CAST(ISNULL([Date2],0) AS BIGINT), 'Bytes') ELSE ISNULL([Date2],0) END AS 'Date2'
	FROM @tempResults
	PIVOT
	(
		MAX(ValOnDates) FOR DateCol IN ([Date1], [Date2])
	) P
	ORDER BY SNo
END
ELSE IF @i_param = 3
BEGIN
	SET @queryId = 73
	SELECT GroupName+' Encrypted' AS Location, dbo.FormatBytes(ISNULL(EncryptedAppSizeMB,0),'MB') AS 'Size Of Application', dbo.FormatBytes(ISNULL(EncryptedMediaSizeMB,0),'MB')  AS 'Size After Deduplication',
		   CASE WHEN EncryptedAppSizeMB > 0 AND EncryptedAppSizeMB > EncryptedMediaSizeMB THEN CAST(CAST(((EncryptedAppSizeMB - EncryptedMediaSizeMB)/EncryptedAppSizeMB) AS DECIMAL(10,2)) AS VARCHAR(10))+'%'
				WHEN EncryptedAppSizeMB > 0  THEN '0%'
				ELSE 'N/A'
			END AS 'Percentage Saved'
	FROM
	( SELECT CG.name AS GroupName, SUM(EncryptedAppSizeMB) AS EncryptedAppSizeMB, SUM(EncryptedMediaSizeMB) AS EncryptedMediaSizeMB
	FROM cf_Survey73Backup_Count AS csInfo WITH (NOLOCK)
        INNER JOIN dbo.cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
		INNER JOIN #CCGrpAssoc CG
			ON resultView.CommServUniqueId = CG.CommServUniqueId
		GROUP BY CG.id, CG.name ) I
	UNION ALL
	SELECT GroupName AS Location, dbo.FormatBytes(ISNULL(NonEncryptedAppSizeMB,0),'MB') AS 'Size Of Application', dbo.FormatBytes(ISNULL(NonEncryptedMediaSizeMB,0),'MB')  AS 'Size After Deduplication',
			CASE WHEN NonEncryptedAppSizeMB > 0 AND NonEncryptedAppSizeMB > NonEncryptedMediaSizeMB THEN CAST(CAST(((NonEncryptedAppSizeMB - NonEncryptedMediaSizeMB)/NonEncryptedAppSizeMB) AS DECIMAL(10,2)) AS VARCHAR(10))+'%'
				WHEN NonEncryptedAppSizeMB > 0  THEN '0%'
				ELSE 'N/A'
			END AS 'Percentage Saved'
	FROM
	(SELECT CG.name AS GroupName, SUM(NonEncryptedAppSizeMB) AS NonEncryptedAppSizeMB, SUM(NonEncryptedMediaSizeMB) AS NonEncryptedMediaSizeMB
	FROM cf_Survey73Backup_Count AS csInfo WITH (NOLOCK)
        INNER JOIN dbo.cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
		INNER JOIN #CCGrpAssoc CG
			ON resultView.CommServUniqueId = CG.CommServUniqueId
		GROUP BY CG.id, CG.name ) I
END
ELSE IF @i_param = 4 -- Returns last quarter period for the data retunred by above param: 3
BEGIN
	SET @queryId = 73
	DECLARE @lastCollDate DATETIME = (select MAX(LogDate) FROM dbo.cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) )
	SET @lastQStartDate = (SELECT DATEADD(MONTH, -3, DATEADD(MONTH, (-1 * ((MONTH(@lastCollDate) -1) % 3)), @lastCollDate))) -- Last Quarter periord
	SELECT SUBSTRING(DATENAME(MONTH, @lastQStartDate), 1, 3) + '-' + SUBSTRING(DATENAME(MONTH, DATEADD(MONTH, 2, @lastQStartDate)), 1, 3) + ', '+CAST(YEAR(@lastCollDate) AS VARCHAR(5)) AS QuarterPeriod
END
ELSE IF @i_param = 5 -- Disk Usage Report for past 3 months
BEGIN
	SET @queryId = 117
	DECLARE @CustomerName VARCHAR(255) = ISNULL((Select TOP 1 CASE WHEN CustomerName LIKE '' THEN CommServName ELSE CustomerName
															  END AS CustomerName
												FROM RptGetCommCellGroups(@i_UserId) VG
													INNER JOIN cf_CommCellGroupAssoc CA WITH (NOLOCK)
														ON VG.GroupId = CA.CommCellGroupId
													INNER JOIN cf_CommcellIDNameMap CC WITH (NOLOCK)
														ON  CA.CommcellIdNameMap_ID = CC.id),'')
	DECLARE @CustomerNameToMatch VARCHAR(255) = (SELECT Value FROM cf_SurveyConfig WITH (NOLOCK) WHERE Name = 'QuarterlyPPTCustomerName1')
	IF @CustomerName = @CustomerNameToMatch
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#LatestResult') IS NOT NULL DROP TABLE #LatestResult
		CREATE TABLE #LatestResult (SurveyID INT, CommServUniqueId INT , SurveyResultId INT )
		INSERT INTO #LatestResult
		SELECT resultView.SurveyID, resultView.CommServUniqueId, resultView.SurverResultId
		FROM dbo.cf_SurveyResultFuncV1(95 , @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			INNER JOIN (SELECT DISTINCT CommServUniqueID FROM #CCGrpAssoc) CG
				ON resultView.CommServUniqueId = CG.CommServUniqueId
		UNION ALL
		SELECT resultView.SurveyID, resultView.CommServUniqueId, resultView.SurverResultId
		FROM dbo.cf_SurveyResultFuncV1(@queryId , @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			INNER JOIN (SELECT DISTINCT CommServUniqueID FROM #CCGrpAssoc) CG
				ON resultView.CommServUniqueId = CG.CommServUniqueId
		SELECT Location AS GroupName, CAST(SUM(MP.FreeSpaceGB/1024.0) AS DECIMAL(10,1)) AS Free, CAST(SUM(MP.UsedSpaceGB/1024.0) AS DECIMAL(10,1)) AS Used
		FROM (SELECT MP.*,
							CASE WHEN MP.MAName LIKE '%-FIT%' THEN 'FIT'
								 WHEN MP.MAName LIKE '%-MSP%' THEN 'MSP'
								 WHEN MP.MAName LIKE '%-MOT%' THEN 'MOT'
								 WHEN MP.MAName LIKE '%-PTO%' THEN 'PTO'
								 WHEN MP.MAName LIKE '%-ECD%' THEN 'ECD'
								 WHEN MP.MAName LIKE '%-LKF%' THEN 'LKF'
								 WHEN MP.MAName LIKE '%-RSP%' THEN 'RSP'
								 WHEN MP.MAName LIKE '%-XIA%' THEN 'XIA'
								 WHEN MP.MAName LIKE '%-XWF%' THEN 'XWF'
								 ELSE ''
							END AS Location
				FROM cf_Survey95MountPathDetails MP WITH (NOLOCK)
				INNER JOIN #LatestResult resultView
					ON SurveyID = 95 AND resultView.SurveyResultId = MP.SurveyResultId ) MP
			INNER JOIN (SELECT LS.libraryId, LS.libraryTypeId, resultView.commservUniqueId
						FROM cf_SurveyLibrarySummary LS	WITH (NOLOCK)
						INNER JOIN #LatestResult resultView
							ON SurveyID = @queryId AND resultView.SurveyResultId = LS.SurveyResultId AND LS.LibraryTypeId = 3
						) L
				ON MP.CommServUniqueId = L.CommServUniqueId AND MP.libraryId = L.libraryId
		WHERE MP.Location <> ''
		GROUP BY MP.Location
	END
	ELSE
	BEGIN
		SELECT CG.name AS GroupName, -- D.CommServUniqueId, L.LibraryId, L.LibraryName, L.LibraryTypeId, L.FreeSpaceMB/1024.0 AS FreeSpaceGB,
			   CAST(SUM(D.totalDataWrittenGB/1024.0) AS DECIMAL(10,1)) AS 'Used', CAST(SUM(totalFreeSpaceGB/1024.0) AS DECIMAL(10,1)) AS 'Free'
		FROM cf_SurveyLibrarySummary AS L WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = L.SurveyResultId AND LibraryTypeId = 3
		INNER JOIN (SELECT SurveyResultId, D.CommServUniqueId, LibraryId, totalAppSizeGB, totalDataWrittenGB, totalFreeSpaceGB, totalSpaceGB, totalValidDataGB
					FROM cf_Survey96DiskLibDetails AS D WITH (NOLOCK)
					INNER JOIN dbo.cf_SurveyResultFuncV1(96, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
						ON resultView.SurverResultId = D.SurveyResultId) D
			ON resultView.CommServUniqueId = D.CommServUniqueId AND L.LibraryId = D.LibraryId
		INNER JOIN #CCGrpAssoc CG
			ON D.CommServUniqueId = CG.CommServUniqueId
		GROUP BY CG.id, CG.name
	END
	IF OBJECT_ID('tempdb.dbo.#LatestResult') IS NOT NULL DROP TABLE #LatestResult
END
IF OBJECT_ID('tempdb.dbo.#LastNMonths') IS NOT NULL DROP TABLE #LastNMonths
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptQuarterlyPptData')
	delete from GxQscripts where name = 'RptQuarterlyPptData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptQuarterlyPptData')
	delete from GXDBVersions where aliasname = 'RptQuarterlyPptData'
GO

insert into GXDBVersions values(2, 'RptQuarterlyPptData',  '00010005000000000000', 'RptQuarterlyPptData', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptValueAssessmentInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptValueAssessmentInfo.sp,v $ $Id: RptValueAssessmentInfo.sp,v 1.2 2015/07/10 19:31:26 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptValueAssessmentInfo <<<'

IF EXISTS (select * from sysobjects where name='RptValueAssessmentInfo')
	drop procedure RptValueAssessmentInfo
IF EXISTS (select * from GxQscripts where name='RptValueAssessmentInfo')
	delete from GxQscripts where name = 'RptValueAssessmentInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptValueAssessmentInfo')
	delete from GXDBVersions where aliasname = 'RptValueAssessmentInfo'
GO
print '... Creating Procedure: RptValueAssessmentInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptValueAssessmentInfo
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
IF(@blaggregate=1 OR @i_CommServUniqueID = 0)
	RETURN
SET NOCOUNT ON
SELECT
	CommServUniqueId  AS 'CommServ UniqueId',
	MonitorId AS 'SurveyId<DONOTSHOW>',
	Monitor AS 'Parameter',
	Status AS 'Status<HEALTH_STATUS>',
	Result AS 'Outcome',
	Recommendation AS 'Remarks<VA_REMARKS_LINK>'
FROM RptGetValueAssessmentFunc(@i_CommServUniqueID, @i_UserId, @i_GroupId)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptValueAssessmentInfo')
	delete from GxQscripts where name = 'RptValueAssessmentInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptValueAssessmentInfo')
	delete from GXDBVersions where aliasname = 'RptValueAssessmentInfo'
GO

insert into GXDBVersions values(2, 'RptValueAssessmentInfo',  '00010002000000000000', 'RptValueAssessmentInfo', '00010002000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptBackupOperations.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptBackupOperations.sp,v $ $Id: RptBackupOperations.sp,v 1.7 2015/07/06 20:31:48 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptBackupOperations <<<'

IF EXISTS (select * from sysobjects where name='RptBackupOperations')
	drop procedure RptBackupOperations
IF EXISTS (select * from GxQscripts where name='RptBackupOperations')
	delete from GxQscripts where name = 'RptBackupOperations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBackupOperations')
	delete from GXDBVersions where aliasname = 'RptBackupOperations'
GO
print '... Creating Procedure: RptBackupOperations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptBackupOperations
AS
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#SubclientTable') IS NOT NULL DROP TABLE #SubclientTable
IF OBJECT_ID('tempdb.dbo.#SPInfo') IS NOT NULL DROP TABLE #SPInfo
CREATE TABLE #SubclientTable (
	CommservUniqueId INT,
	CommCellID INT,
	CommServName NVARCHAR(256),
	ClientID INT,
	ClientName NVARCHAR(256),
	PhysicalClientName NVARCHAR(256),
	AgentID INT,
	AgentName VARCHAR(256),
	InstanceID INT,
	InstanceName NVARCHAR(512),
	BackupsetID INT,
	BackupsetName NVARCHAR(128),
	SubclientID INT,
	SubclientName NVARCHAR(128),
	DailySchRetentionDays INT,
	WeeklySchRetentionDays INT,
	MonthlySchRetentionDays INT,
	PolicyId INT,
	OnHoliday INT
	)
INSERT INTO #SubclientTable
SELECT
	C.ID,
    CAST(C.CommCellID AS INT),
    C.CommServName,
    S.ClientId,
    S.ClientName,
    PhysicalClientName,
    S.AppTypeId,
    S.AgentName,
    S.InstanceId,
    S.InstanceName,
    S.BackupsetId,
    S.BackupsetName,
    S.AppId,
    S.SubclientName,
	0, 	0, 	0,
	S.DataPolicyId,
	0
FROM
    cf_SurveySubclientAssociation AS S WITH (NOLOCK)
    INNER JOIN cf_CommcellIdNameMap AS C WITH (NOLOCK)
        ON C.ID = S.CommservUniqueId AND (S.SubclientStatus & (2|4)) = 0
		AND S.Deleted = 0
--Daily backups => Daily or Weekly incremental schedules
UPDATE #SubclientTable
SET DailySchRetentionDays = 1
FROM #SubclientTable AS sub1
INNER JOIN
(
	SELECT CommCellID, ClientID, SubclientID FROM BackupSchedules WHERE SchedBackupType = 'Incremental' AND SchedInterval = 'Every 1' AND IsScheduleDisabled = 0
) AS sub2
ON sub1.CommCellID = sub2.CommCellID AND sub1.ClientID = sub2.ClientID AND sub1.SubclientID = sub2.SubclientID
--Daily backups => Weekly full schedules scheduled for more than one day
UPDATE #SubclientTable
SET DailySchRetentionDays = 1
FROM #SubclientTable AS sub1
INNER JOIN
(
	SELECT CommCellID, ClientID, SubclientID FROM BackupSchedules WHERE SchedBackupType = 'Full' AND SchedPattern = 'Weekly' AND CHARINDEX(' ', RTRIM(SchedBackupDay)) > 0 AND IsScheduleDisabled = 0
) AS sub2
ON sub1.CommCellID = sub2.CommCellID AND sub1.ClientID = sub2.ClientID AND sub1.SubclientID = sub2.SubclientID
--Weekly and Monthly backups => Weekly full schedules
UPDATE #SubclientTable
SET WeeklySchRetentionDays = 1, MonthlySchRetentionDays = 1
FROM #SubclientTable AS sub1
INNER JOIN
(
	SELECT CommCellID, ClientID, SubclientID FROM BackupSchedules WHERE SchedBackupType = 'Full' AND SchedPattern = 'Weekly' AND SchedInterval = 'Every 1' AND IsScheduleDisabled = 0
) AS sub2
ON sub1.CommCellID = sub2.CommCellID AND sub1.ClientID = sub2.ClientID AND sub1.SubclientID = sub2.SubclientID
--Daily and Weekly backups for Exch 2010 => Monthly Full and Monthly Pre-Selected Backup Type
DECLARE @Exch2010Sch TABLE(CCID INT, CId INT, SCId INT, IsMonFullSet INT, IsMonIncrSet INT)
INSERT INTO @Exch2010Sch
SELECT DISTINCT	CommCellID, ClientID, SubclientID, 1, 0 FROM BackupSchedules WHERE AgentID = 53 AND SchedBackupType = 'Full' AND SchedPattern = 'Monthly' AND IsScheduleDisabled = 0
UPDATE @Exch2010Sch
SET IsMonIncrSet = 1
FROM @Exch2010Sch AS sub1
	INNER JOIN BackupSchedules AS sub2
		ON sub1.CCID = sub2.CommCellID
			AND sub1.CId = sub2.ClientID
			AND sub1.SCId = sub2.SubclientID
			AND sub2.AgentID = 53
			AND sub2.SchedBackupType = 'Pre-Selected Backup Type'
			AND sub2.SchedPattern = 'Monthly'
UPDATE #SubclientTable
SET DailySchRetentionDays = 1, WeeklySchRetentionDays = 1
FROM #SubclientTable AS sub1
INNER JOIN @Exch2010Sch AS sub2
ON sub1.CommCellID = sub2.CCID AND sub1.ClientID = sub2.CId AND sub1.SubclientID = sub2.SCId AND sub2.IsMonFullSet = 1 AND sub2.IsMonIncrSet = 1
--Monthly backups
UPDATE #SubclientTable
SET MonthlySchRetentionDays = 1
FROM #SubclientTable AS sub1
INNER JOIN
(
	SELECT CommCellID, ClientID, SubclientID FROM BackupSchedules WHERE SchedBackupType = 'Full' AND SchedPattern = 'Monthly' AND SchedInterval = 'Every 1' AND IsScheduleDisabled = 0
) AS sub2
ON sub1.CommCellID = sub2.CommCellID AND sub1.ClientID = sub2.ClientID AND sub1.SubclientID = sub2.SubclientID
-- Clients with holiday set for more than 3 months are in permanent holiday.
UPDATE #SubclientTable
SET OnHoliday = 1
FROM cf_SurveyClientGroupAssociation CGA
	INNER JOIN (
		SELECT	DISTINCT CommservUniqueId, ClientGroupId
		FROM	cf_SurveyHoliday
		WHERE	ClientGroupId > 0 AND ClientId <= 0
			AND (EndYear - StartYear)*365 + (EndMonth - StartMonth)*30 + (EndDay - StartDay) > 90
	) T ON CGA.CommservUniqueId = T.CommservUniqueId AND CGA.ClientGroupId = T.ClientGroupId
WHERE #SubclientTable.ClientID = CGA.ClientID
UPDATE #SubclientTable
SET OnHoliday = 1
FROM (
		SELECT	DISTINCT CommservUniqueId, ClientId
		FROM	cf_SurveyHoliday
		WHERE	ClientId > 0
			AND (EndYear - StartYear)*365 + (EndMonth - StartMonth)*30 + (EndDay - StartDay) > 90
	) T
WHERE #SubclientTable.CommservUniqueId = T.CommservUniqueId AND #SubclientTable.ClientID = T.ClientID
UPDATE #SubclientTable
SET OnHoliday = 1
WHERE CommservUniqueId IN (
		SELECT	DISTINCT CommservUniqueId
		FROM	cf_SurveyHoliday
		WHERE	ClientGroupId <= 0 AND ClientId <= 0
			AND (EndYear - StartYear)*365 + (EndMonth - StartMonth)*30 + (EndDay - StartDay) > 90
	)
CREATE TABLE #SPInfo (
	CommservUniqueId INT,
	PolicyId INT,
	PolicyName NVARCHAR(144),
	PrimRetentionDays INT,
	PrimExtWeekRetDays INT,
	SyncRetentionDays INT,
	SelWeekRetentionDays INT,
	SelMonRetentionDays INT
	)
--Primary Copies
INSERT INTO #SPInfo
SELECT
	CommservUniqueId,
	PolicyId,
	PolicyName,
	RetentionDays,
	CASE WHEN (ExtRretentionRules & 4) = 4 THEN 1 ELSE 0 END,
	0, 0, 0
FROM cf_SurveyCopyBasicRetention WITH (NOLOCK)
WHERE IsSnapCopy = 0 AND IsDefaultCopy = 1
--Synchronous Copies
UPDATE #SPInfo
SET SyncRetentionDays = sub2.RetentionDays
FROM #SPInfo AS sub1
INNER JOIN
(SELECT
	CommservUniqueId,
	PolicyId,
	RetentionDays,
	ArchiverRetDays
FROM cf_SurveyCopyBasicRetention
WHERE IsSnapCopy = 0 AND IsDefaultCopy = 0 AND CopyType = 1 AND RetentionDays > 60) AS sub2
ON sub1.CommservUniqueId = sub2.CommservUniqueId AND sub1.PolicyId = sub2.PolicyId
--Selective Copies Weekly
UPDATE #SPInfo
SET SelWeekRetentionDays = sub2.RetentionDays
FROM #SPInfo AS sub1
INNER JOIN
(SELECT
	C.CommservUniqueId,
	C.PolicyId,
	C.RetentionDays,
	C.ArchiverRetDays
FROM cf_SurveyCopyBasicRetention AS C
	INNER JOIN cf_SurveyArchSelectiveCopy AS SC
		ON C.CopyId = SC.CopyId
		AND C.IsSnapCopy = 0
		AND C.IsDefaultCopy = 0
		AND C.CopyType = 2
		AND SC.type = 2 ) AS sub2 --Weekly Fulls
ON sub1.CommservUniqueId = sub2.CommservUniqueId AND sub1.PolicyId = sub2.PolicyId
--Selective Copies Monthly
UPDATE #SPInfo
SET SelMonRetentionDays = sub2.RetentionDays
FROM #SPInfo AS sub1
INNER JOIN
(SELECT
	C.CommservUniqueId,
	C.PolicyId,
	C.RetentionDays,
	C.ArchiverRetDays
FROM cf_SurveyCopyBasicRetention AS C
	INNER JOIN cf_SurveyArchSelectiveCopy AS SC
		ON C.CopyId = SC.CopyId
		AND C.IsSnapCopy = 0
		AND C.IsDefaultCopy = 0
		AND C.CopyType = 2
		AND SC.type = 4 ) AS sub2 --Monthly Fulls
ON sub1.CommservUniqueId = sub2.CommservUniqueId AND sub1.PolicyId = sub2.PolicyId
SELECT
	SC.CommCellID,
	SC.CommServName,
	SC.clientName AS ClientName,
	ISNULL(SC.PhysicalClientName,SC.clientName) AS PhysicalClientName,
	SC.AgentName,
	SC.InstanceName,
	SC.BackupsetName,
	SC.SubclientName,
	P.PolicyName,
	CASE
		WHEN SC.DailySchRetentionDays = 0 THEN 0
		WHEN P.SyncRetentionDays > 0 THEN P.SyncRetentionDays
		ELSE P.PrimRetentionDays
	END AS DailySchRetentionDays,
	CASE
		WHEN SC.WeeklySchRetentionDays = 0 THEN 0
		WHEN P.PrimExtWeekRetDays > 0 AND SC.AgentID = 53 THEN 28 --TODO: get proper retention days from CommServer
		WHEN P.SyncRetentionDays > 0 THEN P.SyncRetentionDays
		WHEN P.SelWeekRetentionDays > 0 THEN P.SelWeekRetentionDays
		ELSE P.PrimRetentionDays
	END AS WeeklySchRetentionDays,
	CASE
		WHEN SC.MonthlySchRetentionDays = 0 THEN 0
		WHEN P.SyncRetentionDays > 0 THEN P.SyncRetentionDays
		WHEN P.SelWeekRetentionDays > 0 THEN P.SelWeekRetentionDays
		WHEN P.SelMonRetentionDays > 0 THEN P.SelMonRetentionDays
		ELSE P.PrimRetentionDays
	END AS MonthlySchRetentionDays,
	CASE
		WHEN OnHoliday = 1 THEN 'Yes'
		ELSE 'No'
	END AS OnHoliday
FROM #SubclientTable AS SC
	INNER JOIN #SPInfo AS P
		ON SC.PolicyId = P.PolicyId
		AND SC.CommservUniqueId = P.CommservUniqueId
IF OBJECT_ID('tempdb.dbo.#SubclientTable') IS NOT NULL DROP TABLE #SubclientTable
IF OBJECT_ID('tempdb.dbo.#SPInfo') IS NOT NULL DROP TABLE #SPInfo
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptBackupOperations')
	delete from GxQscripts where name = 'RptBackupOperations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBackupOperations')
	delete from GXDBVersions where aliasname = 'RptBackupOperations'
GO

insert into GXDBVersions values(2, 'RptBackupOperations',  '00010007000000000000', 'RptBackupOperations', '00010007000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/UpdateReportParameter.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/UpdateReportParameter.sp,v $ $Id: UpdateReportParameter.sp,v 1.4 2015/05/07 06:51:38 vmishra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: UpdateReportParameter <<<'

IF EXISTS (select * from sysobjects where name='UpdateReportParameter')
	drop procedure UpdateReportParameter
IF EXISTS (select * from GxQscripts where name='UpdateReportParameter')
	delete from GxQscripts where name = 'UpdateReportParameter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateReportParameter')
	delete from GXDBVersions where aliasname = 'UpdateReportParameter'
GO
print '... Creating Procedure: UpdateReportParameter'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure UpdateReportParameter
  @i_UserId INT = -1,
  @i_Report VARCHAR(256),
  @i_ParamId INT,
  @i_Name NVARCHAR(256),
  @i_Parameter VARCHAR(256),
  @i_Value VARCHAR(256)
AS
SET NOCOUNT ON
IF	@i_Report = 'Health Report'
BEGIN
	IF	@i_Parameter IN ('9_0_LatestSPMajorNo', '10_0_LatestSPMajorNo')
		UPDATE	cf_SurveyConfig
		SET		Value = @i_Value, LogDateUTC = GetUTCDate()
		WHERE	Name = @i_Parameter AND Value <> @i_Value
	ELSE
	IF	@i_Parameter = 'WarningThreshold'
		UPDATE	cf_SurveyHealthParam
		SET		WarningThreshold = CAST(@i_Value AS BIGINT), LogDateUTC = GetUTCDate()
		WHERE	ParamId = @i_ParamId AND ParameterName = @i_Name
	ELSE
	IF	@i_Parameter = 'CriticalThreshold'
		UPDATE	cf_SurveyHealthParam
		SET		CriticalThreshold = CAST(@i_Value AS BIGINT), LogDateUTC = GetUTCDate()
		WHERE	ParamId = @i_ParamId AND ParameterName = @i_Name
	ELSE
	IF	@i_Parameter = 'InfoMessage'
		UPDATE	cf_SurveyHealthParam
		SET		InfoMessage = @i_Value, LogDateUTC = GetUTCDate()
		WHERE	ParamId = @i_ParamId AND ParameterName = @i_Name
	ELSE
	IF	@i_Parameter = 'GoodMessage'
		UPDATE	cf_SurveyHealthParam
		SET		GoodMessage = @i_Value, LogDateUTC = GetUTCDate()
		WHERE	ParamId = @i_ParamId AND ParameterName = @i_Name
	ELSE
	IF	@i_Parameter = 'WarningMessage'
		UPDATE	cf_SurveyHealthParam
		SET		WarningMessage = @i_Value, LogDateUTC = GetUTCDate()
		WHERE	ParamId = @i_ParamId AND ParameterName = @i_Name
	ELSE
	IF	@i_Parameter = 'CriticalMessage'
		UPDATE	cf_SurveyHealthParam
		SET		CriticalMessage = @i_Value, LogDateUTC = GetUTCDate()
		WHERE	ParamId = @i_ParamId AND ParameterName = @i_Name
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'UpdateReportParameter')
	delete from GxQscripts where name = 'UpdateReportParameter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateReportParameter')
	delete from GXDBVersions where aliasname = 'UpdateReportParameter'
GO

insert into GXDBVersions values(2, 'UpdateReportParameter',  '00010004000000000000', 'UpdateReportParameter', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/GetClientGroupsString.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/GetClientGroupsString.sp,v $ $Id: GetClientGroupsString.sp,v 1.4 2014/09/18 21:22:20 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetClientGroupsString <<<'

IF EXISTS (select * from sysobjects where name='GetClientGroupsString')
	drop procedure GetClientGroupsString
IF EXISTS (select * from GxQscripts where name='GetClientGroupsString')
	delete from GxQscripts where name = 'GetClientGroupsString'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientGroupsString')
	delete from GXDBVersions where aliasname = 'GetClientGroupsString'
GO
print '... Creating Procedure: GetClientGroupsString'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetClientGroupsString
  @i_CellUniqueID INT = 0,
  @i_ClientID INT = 0
AS
SET NOCOUNT ON
/* Caller will create this temp table
CREATE TABLE #ClientGroupsString (CommservUniqueId INT, ClientId INT, ClientGroups NVARCHAR(1024))
*/
CREATE TABLE #ClientGroupList (CommservUniqueId INT, Key1 BIGINT, Key2 BIGINT, ClientGroups NVARCHAR(MAX))
CREATE TABLE #ClientGroupKey  (CommservUniqueId INT, ClientId INT, Key1 BIGINT, Key2 BIGINT)
INSERT INTO #ClientGroupKey
SELECT	CommservUniqueId, ClientId, SUM(CAST(ClientGroupId AS BIGINT)), SUM(CAST(ClientGroupId AS BIGINT)*CAST(ClientGroupId AS BIGINT))
FROM	cf_SurveyClientGroupAssociation
WHERE	(@i_CellUniqueID = 0 OR CommservUniqueId = @i_CellUniqueID) AND (@i_ClientID = 0 OR ClientId = @i_ClientID)
GROUP BY CommservUniqueId, ClientId
DECLARE ClientGroupListCursor CURSOR FOR
SELECT	CG.CommservUniqueId, Key1, Key2, CG.ClientGroupName
FROM	cf_SurveyClientGroup CG, cf_SurveyClientGroupAssociation CGA,
 		(SELECT	CommservUniqueId, Key1, Key2, MIN(ClientId) AS ClientId
 		FROM	#ClientGroupKey
 		GROUP BY CommservUniqueId, Key1, Key2) T
WHERE	CG.CommservUniqueId = CGA.CommservUniqueId AND CG.ClientGroupId = CGA.ClientGroupId
 	AND CGA.CommservUniqueId = T.CommservUniqueId AND CGA.ClientId = T.ClientId
ORDER BY CG.CommservUniqueId, Key1, Key2, CG.ClientGroupId
DECLARE	@cc		INT = 0
DECLARE	@cell	INT = 0
DECLARE	@k1		BIGINT = 0
DECLARE	@k2		BIGINT = 0
DECLARE	@key1	BIGINT = 0
DECLARE	@key2	BIGINT = 0
DECLARE	@name	NVARCHAR(512) = ''
DECLARE	@list	NVARCHAR(MAX) = ''
OPEN ClientGroupListCursor
 	FETCH NEXT FROM ClientGroupListCursor INTO @cc, @k1, @k2, @name
WHILE @@FETCH_STATUS = 0
BEGIN
 	IF	@cell IN (0, @cc) AND @k1 = @key1 AND @k2 = @key2
 		SET @list = (@list + '; ' + @name)
 	ELSE
 	BEGIN
 		IF	@cell > 0 AND @key1 > 0 AND @key2 > 0
 			INSERT	INTO #ClientGroupList
 			SELECT	@cell, @key1, @key2, @list
 		SET	@cell = @cc
 		SET @list = @name
 		SET	@key1 = @k1
 		SET @key2 = @k2
 	END
 	FETCH NEXT FROM ClientGroupListCursor INTO @cc, @k1, @k2, @name
END
CLOSE ClientGroupListCursor
DEALLOCATE ClientGroupListCursor
IF	@cell > 0 AND @key1 > 0 AND @key2 > 0
 	INSERT	INTO #ClientGroupList
 	SELECT	@cell, @key1, @key2, @list
INSERT INTO #ClientGroupsString
SELECT	K.CommservUniqueId, K.ClientId, LEFT(L.ClientGroups, 1024)
FROM	#ClientGroupKey K, #ClientGroupList L
WHERE	K.CommservUniqueId = L.CommservUniqueId AND K.Key1 = L.Key1 AND K.Key2 = L.Key2
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetClientGroupsString')
	delete from GxQscripts where name = 'GetClientGroupsString'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetClientGroupsString')
	delete from GXDBVersions where aliasname = 'GetClientGroupsString'
GO

insert into GXDBVersions values(2, 'GetClientGroupsString',  '00010004000000000000', 'GetClientGroupsString', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptAgentCapacityLicenseSurvey.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptAgentCapacityLicenseSurvey.sp,v $ $Id: RptAgentCapacityLicenseSurvey.sp,v 1.16 2015/07/08 19:56:20 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptAgentCapacityLicenseSurvey <<<'

IF EXISTS (select * from sysobjects where name='RptAgentCapacityLicenseSurvey')
	drop procedure RptAgentCapacityLicenseSurvey
IF EXISTS (select * from GxQscripts where name='RptAgentCapacityLicenseSurvey')
	delete from GxQscripts where name = 'RptAgentCapacityLicenseSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptAgentCapacityLicenseSurvey')
	delete from GXDBVersions where aliasname = 'RptAgentCapacityLicenseSurvey'
GO
print '... Creating Procedure: RptAgentCapacityLicenseSurvey'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptAgentCapacityLicenseSurvey
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
DECLARE @i_QueryId BIGINT = 3
SET NOCOUNT ON
DECLARE @param_isPrivate INT = 0
IF @i_CommServUniqueID = 0
	SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
SET @blLatestSurvey = 1 --Pick up only the latest data for now
IF @blaggregate = 1 -- Aggregated Capacity Usage by Agent Types (pie chart)
	SELECT
		TypeName AS 'Agent Type',
		MAX(UsedAgents) AS 'Used Agents',
		CAST(SUM(BackupSize)/(1024.00*1024.00) AS DECIMAL(32,2)) AS 'Enterprise Backup Size<SIZEMB>',
		CAST(SUM(ArchiveSize)/(1024.00*1024.00) AS DECIMAL(32,2)) AS 'Enterprise Archive Size<SIZEMB>',
		CAST(SUM(SnapshotSize)/(1024.00*1024.00) AS DECIMAL(32,2)) AS 'Snapshot Size<SIZEMB>',
		CAST(SUM(ReplicationSize)/(1024.00*1024.00) AS DECIMAL(32,2)) AS 'Replication Size<SIZEMB>'
	FROM
		(SELECT	SurveyResultId, TypeId, TypeName, MAX(UsedAgents) AS UsedAgents, SUM(BackupSize) AS BackupSize, SUM(ArchiveSize) AS ArchiveSize,
				SUM(SnapshotSize) AS SnapshotSize, SUM(ReplicationSize) AS ReplicationSize
		FROM	cf_SurveyAgentCapacityUsage CU WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) AS R
			ON CU.SurveyResultId = R.SurverResultId
		GROUP BY SurveyResultId, TypeId, TypeName) S
	GROUP BY TypeName
	ORDER BY TypeName
ELSE
IF @blaggregate = 2 -- Aggregated License Usage (pie chart)
	SELECT
		licType.name AS 'License Name',
		SUM(PermLicensesUsed) AS 'Used Licenses',
		SUM(EvalLicensesUsed) AS 'Used Evaluation Licenses'
	FROM	cf_SurveyAgentLicenseUsage LU WITH (NOLOCK)
		INNER JOIN cf_SurveyLicType licType ON LU.TypeId = licType.id
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) AS R
			ON LU.SurveyResultId = R.SurverResultId
	GROUP BY licType.name
	ORDER BY licType.name
ELSE
IF @blaggregate = 3 -- Aggregated Capacity Usage by Licenses
	SELECT
		licType.name AS 'License Name',
		T.PermLicensesIssued AS 'Permanent License Issued<NumberUnlimitedNA>',
		T.PermLicensesUsed AS 'Permanent License Used<NumberNA>',
		T.PermLicensesAvailable AS 'Permanent License Available<NumberUnlimitedNA><HIDDEN>',
		T.EvalLicensesIssued AS 'Evaluation License Issued<NumberUnlimitedNA>',
		T.EvalLicensesUsed AS 'Evaluation License Used<NumberNA>',
		T.EvalLicensesAvailable AS 'Evaluation License Available<NumberUnlimitedNA><HIDDEN>',
		CAST(ISNULL(S.BackupSize, 0)/(1024.00*1024.00) AS DECIMAL(32,2)) AS 'Enterprise Backup Size<SIZEMB>',
		CAST(ISNULL(S.ArchiveSize, 0)/(1024.00*1024.00) AS DECIMAL(32,2)) AS 'Enterprise Archive Size<SIZEMB>',
		CAST(ISNULL(S.SnapshotSize, 0)/(1024.00*1024.00) AS DECIMAL(32,2)) AS 'Snapshot Size<SIZEMB>',
		CAST(ISNULL(S.ReplicationSize, 0)/(1024.00*1024.00) AS DECIMAL(32,2)) AS 'Replication Size<SIZEMB>'
	FROM cf_SurveyLicType licType
		INNER JOIN (
			SELECT
				LU.TypeId,
				SUM(CASE WHEN LU.PermLicensesIssued > 0 THEN LU.PermLicensesIssued ELSE 0 END) AS PermLicensesIssued,
				SUM(LU.PermLicensesUsed) AS PermLicensesUsed,
				SUM(CASE WHEN LU.PermLicensesAvailable > 0 THEN LU.PermLicensesAvailable ELSE 0	END) AS PermLicensesAvailable,
				SUM(CASE WHEN LU.EvalLicensesIssued > 0 THEN LU.EvalLicensesIssued ELSE 0 END) AS EvalLicensesIssued,
				SUM(LU.EvalLicensesUsed) AS EvalLicensesUsed,
				SUM(CASE WHEN LU.EvalLicensesAvailable > 0 THEN LU.EvalLicensesAvailable ELSE 0	END) AS EvalLicensesAvailable
			FROM	cf_SurveyAgentLicenseUsage AS LU WITH (NOLOCK)
				INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) AS R1
					ON LU.SurveyResultId = R1.SurverResultId
			GROUP BY LU.TypeId) T ON T.TypeId = licType.id
		LEFT OUTER JOIN (
			SELECT	CU.LicType, SUM(BackupSize) AS BackupSize, SUM(ArchiveSize) AS ArchiveSize, SUM(SnapshotSize) AS SnapshotSize, SUM(ReplicationSize) AS ReplicationSize
			FROM	cf_SurveyAgentCapacityUsage CU
				INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) AS R2
					ON CU.SurveyResultId = R2.SurverResultId
			GROUP BY CU.LicType) S ON T.TypeId = S.LicType
	WHERE licType.groupId = 3
	ORDER BY licType.name
ELSE
IF @blaggregate = 4 -- Feature licenses table (cell level & those not tracked at capacity.  Also put Disk library)
	SELECT
		resultView.CommServUniqueId AS 'CommServ UniqueId',
		CASE WHEN @param_isPrivate = 1 THEN CommServName ELSE CustomerName + ' - ' + CommServName END AS 'CommCell Name',
		CASE
			WHEN resultView.RunningTime = -1 THEN 'N/A'
			ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
		END AS 'Running Time in Seconds',
		licType.name AS 'License Name',
		CASE
			WHEN csInfo.PermLicensesIssued > -1 THEN csInfo.PermLicensesIssued
			WHEN csInfo.PermLicensesIssued = -1 THEN -1
			ELSE -2
		END AS 'Permanent License Issued<NumberUnlimitedNA>',
		csInfo.PermLicensesUsed AS 'Permanent License Used<NumberNA>',
		CASE
			WHEN csInfo.PermLicensesAvailable > -1 THEN csInfo.PermLicensesAvailable
			WHEN csInfo.PermLicensesAvailable = -1 THEN -1
			ELSE -2
		END AS 'Permanent License Available<NumberUnlimitedNA><HIDDEN>',
		CASE
			WHEN csInfo.EvalLicensesIssued > -1 THEN csInfo.EvalLicensesIssued
			WHEN csInfo.EvalLicensesIssued = -1 THEN -1
			ELSE -2
		END AS 'Evaluation License Issued<NumberUnlimitedNA>',
		csInfo.EvalLicensesUsed AS 'Evaluation License Used<NumberNA>',
		CASE
			WHEN csInfo.EvalLicensesAvailable > -1 THEN csInfo.EvalLicensesAvailable
			WHEN csInfo.EvalLicensesAvailable = -1 THEN -1
			ELSE -2
		END AS 'Evaluation License Available<NumberUnlimitedNA><HIDDEN>'
	FROM cf_SurveyAgentLicenseUsage AS csInfo WITH (NOLOCK)
		INNER JOIN cf_SurveyLicType licType ON csInfo.TypeId = licType.id
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
	WHERE licType.groupId NOT IN (3, 14, 15) OR licType.id IN (100015, 100016)
	ORDER BY 'CommCell Name', 'License Name'
ELSE
IF @blaggregate = 5 -- Retired and consolidated licenses table
	SELECT
		resultView.CommServUniqueId AS 'CommServ UniqueId',
		CASE WHEN @param_isPrivate = 1 THEN CommServName ELSE CustomerName + ' - ' + CommServName END AS 'CommCell Name',
		CASE
			WHEN resultView.RunningTime = -1 THEN 'N/A'
			ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
		END AS 'Running Time in Seconds',
		csInfo.TypeName AS 'License Name',
		CASE
			WHEN csInfo.PermLicensesIssued > -1 THEN csInfo.PermLicensesIssued
			WHEN csInfo.PermLicensesIssued = -1 THEN -1
			ELSE -2
		END AS 'Permanent License Issued<NumberUnlimitedNA>',
		csInfo.PermLicensesUsed AS 'Permanent License Used<NumberNA>',
		CASE
			WHEN csInfo.PermLicensesAvailable > -1 THEN csInfo.PermLicensesAvailable
			WHEN csInfo.PermLicensesAvailable = -1 THEN -1
			ELSE -2
		END AS 'Permanent License Available<NumberUnlimitedNA><HIDDEN>',
		CASE
			WHEN csInfo.EvalLicensesIssued > -1 THEN csInfo.EvalLicensesIssued
			WHEN csInfo.EvalLicensesIssued = -1 THEN -1
			ELSE -2
		END AS 'Evaluation License Issued<NumberUnlimitedNA>',
		csInfo.EvalLicensesUsed AS 'Evaluation License Used<NumberNA>',
		CASE
			WHEN csInfo.EvalLicensesAvailable > -1 THEN csInfo.EvalLicensesAvailable
			WHEN csInfo.EvalLicensesAvailable = -1 THEN -1
			ELSE -2
		END AS 'Evaluation License Available<NumberUnlimitedNA><HIDDEN>'
	FROM cf_SurveyAgentLicenseUsage AS csInfo WITH (NOLOCK)
		LEFT OUTER JOIN cf_SurveyLicType licType ON csInfo.TypeId = licType.id
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
	WHERE licType.id IS NULL
	ORDER BY 'CommCell Name', 'License Name'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptAgentCapacityLicenseSurvey')
	delete from GxQscripts where name = 'RptAgentCapacityLicenseSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptAgentCapacityLicenseSurvey')
	delete from GXDBVersions where aliasname = 'RptAgentCapacityLicenseSurvey'
GO

insert into GXDBVersions values(2, 'RptAgentCapacityLicenseSurvey',  '00010016000000000000', 'RptAgentCapacityLicenseSurvey', '00010016000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptAvgBkpThroughput.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptAvgBkpThroughput.sp,v $ $Id: RptAvgBkpThroughput.sp,v 1.12 2014/10/30 12:44:25 vmishra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptAvgBkpThroughput <<<'

IF EXISTS (select * from sysobjects where name='RptAvgBkpThroughput')
	drop procedure RptAvgBkpThroughput
IF EXISTS (select * from GxQscripts where name='RptAvgBkpThroughput')
	delete from GxQscripts where name = 'RptAvgBkpThroughput'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptAvgBkpThroughput')
	delete from GXDBVersions where aliasname = 'RptAvgBkpThroughput'
GO
print '... Creating Procedure: RptAvgBkpThroughput'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptAvgBkpThroughput
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 55
SET @blLatestSurvey = 1 --Always pickup the latest
IF(@blaggregate=1)
BEGIN
IF @i_CommServUniqueID = 0
BEGIN
	DECLARE	@lastDays INT = 7
	CREATE TABLE #week_table (WeekDate DATE)
	DECLARE @today DATE
	SET @today = (SELECT CAST(GETDATE() AS DATE))
	;WITH R(N) AS
	(
		SELECT 0
		UNION ALL
		SELECT N+1
		FROM R
			WHERE N < @lastDays
	)
	INSERT INTO #week_table
		SELECT  DATEADD(DAY,-N,@today) FROM R
	SELECT
		datediff(second, '01/01/1970', COALESCE(sub1.JobsEndDate, sub2.JobsEndDate)) AS 'Date<DWDDMMM>',
		CAST(ISNULL(sub1.Throughput, 0) AS DECIMAL(32,2)) AS 'Average Disk Throughput (GB/HR)',
		CAST(ISNULL(sub2.Throughput, 0) AS DECIMAL(32,2)) AS 'Average Tape Throughput (GB/HR)'
	FROM
		(SELECT
			csInfo.JobsEndDate,
			-- we are calculating the throughput for entire 24 hours
			CAST(SUM(csInfo.AppSizeGB)/24.0 AS DECIMAL(32,2)) AS Throughput
		FROM cf_SurveyAvgBkpThroughputV1 AS csInfo WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.SurverResultId = csInfo.SurveyResultId
				AND csInfo.IsDisk = 1
			INNER JOIN #week_table AS W
				ON csInfo.JobsEndDate = W.WeekDate
		GROUP BY csInfo.JobsEndDate) AS sub1
		FULL OUTER JOIN
		(SELECT
			csInfo.JobsEndDate,
			CAST(SUM(csInfo.AppSizeGB)/24.0 AS DECIMAL(32,2)) AS Throughput
		FROM cf_SurveyAvgBkpThroughputV1 AS csInfo WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.SurverResultId = csInfo.SurveyResultId
				AND csInfo.IsDisk = 0
			INNER JOIN #week_table AS W
				ON csInfo.JobsEndDate = W.WeekDate
		GROUP BY csInfo.JobsEndDate) AS sub2
		ON sub1.JobsEndDate = sub2.JobsEndDate
	ORDER BY sub1.JobsEndDate, sub2.JobsEndDate
	DROP TABLE #week_table
END
ELSE
BEGIN
	SELECT
		datediff(second, '01/01/1970',COALESCE(sub1.JobsEndDate, sub2.JobsEndDate)) AS 'Date<DWDDMMM>',
		CAST(ISNULL(sub1.Throughput, 0) AS DECIMAL(32,2)) AS 'Average Disk Throughput (GB/HR)',
		CAST(ISNULL(sub2.Throughput, 0) AS DECIMAL(32,2)) AS 'Average Tape Throughput (GB/HR)'
	FROM
	(SELECT
		csInfo.JobsEndDate,
		CAST(csInfo.AppSizeGB/24.0 AS DECIMAL(32,2))  AS Throughput
	FROM cf_SurveyAvgBkpThroughputV1 AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND csInfo.IsDisk = 1) AS sub1
	FULL OUTER JOIN
	(SELECT
		csInfo.JobsEndDate,
		CAST(csInfo.AppSizeGB/24.0 AS DECIMAL(32,2))   AS Throughput
	FROM cf_SurveyAvgBkpThroughputV1 AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND csInfo.IsDisk = 0) AS sub2
	ON sub1.JobsEndDate = sub2.JobsEndDate
ORDER BY COALESCE(sub1.JobsEndDate, sub2.JobsEndDate)
END
END
ELSE
BEGIN
IF @i_CommServUniqueID = 0
BEGIN
	DECLARE @param_isPrivate INT = 0
	SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
	SELECT
		resultView.CommServUniqueId  AS 'CommServ UniqueId',
		resultView.CommCellID AS 'CommCell ID',
		CASE
			WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
			ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
		END AS 'CommCell Name',
		CASE
			WHEN MAX(resultView.RunningTime) = -1 THEN 'N/A'
			ELSE CAST(MAX(resultView.RunningTime) AS VARCHAR(MAX))
		END AS 'Running Time in Seconds',
		CASE WHEN MAX(csInfo.JobsEndDate) IS NULL THEN -100
	 		ELSE datediff(second, '01/01/1970', MAX(csInfo.JobsEndDate)) END AS 'Date<MMMDDYYYY>',
		CASE csInfo.IsDisk
			 WHEN 1 THEN 'Disk'
			 ELSE 'Tape'
		END AS 'Type',
		CAST(ISNULL(SUM(csInfo.AppSizeGB*1024.0),0) AS DECIMAL(32,2)) AS 'Application Size<SIZEMB>',
		CAST(ISNULL((SUM(csInfo.AppSizeGB)/(24.0 * 8)),0) AS DECIMAL(32,2)) 	AS 'Throughput (GB/HR)'
	FROM cf_SurveyAvgBkpThroughputV1 AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
	GROUP BY resultView.CommServUniqueId, resultView.CommCellID, resultView.CommServName, resultView.CustomerName, csInfo.IsDisk
	ORDER BY [Date<MMMDDYYYY>]
	--ORDER BY csInfo.LogDate DESC, csInfo.JobsEndDate DESC
END
ELSE
	SELECT
		csInfo.CommServUniqueId AS 'CommServ UniqueId',
		CASE WHEN csInfo.JobsEndDate IS NULL THEN -100
			ELSE datediff(second, '01/01/1970', csInfo.JobsEndDate) END AS 'Date<MMMDDYYYY>',
		CASE csInfo.IsDisk
			 WHEN 1 THEN 'Disk'
			 ELSE 'Tape'
		END AS 'Type',
		CAST(ISNULL(csInfo.AppSizeGB*1024.0,0) AS DECIMAL(32,2)) AS 'Application Size<SIZEMB>',
		CAST(ISNULL((csInfo.AppSizeGB/24.0),0) AS DECIMAL(32,2)) 	AS 'Throughput (GB/HR)'
	FROM cf_SurveyAvgBkpThroughputV1 AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
	ORDER BY csInfo.JobsEndDate
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptAvgBkpThroughput')
	delete from GxQscripts where name = 'RptAvgBkpThroughput'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptAvgBkpThroughput')
	delete from GXDBVersions where aliasname = 'RptAvgBkpThroughput'
GO

insert into GXDBVersions values(2, 'RptAvgBkpThroughput',  '00010012000000000000', 'RptAvgBkpThroughput', '00010012000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptBillingAssociation.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptBillingAssociation.sp,v $ $Id: RptBillingAssociation.sp,v 1.11 2015/07/10 18:40:12 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptBillingAssociation <<<'

IF EXISTS (select * from sysobjects where name='RptBillingAssociation')
	drop procedure RptBillingAssociation
IF EXISTS (select * from GxQscripts where name='RptBillingAssociation')
	delete from GxQscripts where name = 'RptBillingAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBillingAssociation')
	delete from GXDBVersions where aliasname = 'RptBillingAssociation'
GO
print '... Creating Procedure: RptBillingAssociation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptBillingAssociation
  @i_UserId INT = -1,
  @i_EntityId INT,
  @i_AllAssociated INT = 1,
  @i_CellUniqueId INT = 0,
  @i_ClientGroupId INT = 0,
  @i_ClientId INT = 0,
  @i_AppTypeId INT = 0,
  @i_InstanceId INT = 0,
  @i_BackupsetId INT = 0
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF @i_AllAssociated = 1
BEGIN
	CREATE TABLE #CommCell (CommServUniqueId INT)
	CREATE TABLE #Client (CommServUniqueId INT, ClientId INT, ClientName NVARCHAR(256))
	CREATE TABLE #Agent (CommServUniqueId INT, AppTypeId INT, AgentName NVARCHAR(256), ArchiveEnabled INT)
	CREATE TABLE #Instance (CommServUniqueId INT, ClientId INT, AppTypeId INT, InstanceId INT, InstanceName NVARCHAR(256))
	CREATE TABLE #Backupset (CommServUniqueId INT, BackupsetId INT, BackupsetName NVARCHAR(256))
	CREATE TABLE #Subclient (CommServUniqueId INT, AppId INT, SubclientName NVARCHAR(256), OnePassEnabled INT)
	INSERT	INTO  #CommCell
	SELECT	CommServUniqueId
	FROM	dbo.cf_SurveyResultFuncV1(2, 0, 1, NULL, NULL, @i_UserId, -1)
	INSERT	INTO #Client
	SELECT	U.CommServUniqueId, U.ClientId, U.ClientName
	FROM	cf_SurveyBillingEntityMember M
			INNER JOIN #CommCell C ON M.CommServUniqueId = C.CommServUniqueId
			INNER JOIN cf_SurveySubclientAssociation U
				ON U.CommServUniqueId = M.CommServUniqueId AND U.ClientId = M.ClientId AND M.ClientId > 0 AND @i_EntityId IN (0, M.EntityID)
	GROUP BY U.CommServUniqueId, U.ClientId, U.ClientName
	INSERT	INTO #Agent
	SELECT	U.CommServUniqueId, U.AppTypeId, U.AgentName, MAX(U.Archive1PassFlags&1)
	FROM	cf_SurveyBillingEntityMember M
			INNER JOIN #CommCell C ON M.CommServUniqueId = C.CommServUniqueId
			INNER JOIN cf_SurveySubclientAssociation U
				ON U.CommServUniqueId = M.CommServUniqueId AND U.AppTypeId = M.AppTypeId AND M.AppTypeId > 0 AND @i_EntityId IN (0, M.EntityID)
	GROUP BY U.CommServUniqueId, U.AppTypeId, U.AgentName
	INSERT	INTO #Instance
	SELECT	U.CommServUniqueId, U.ClientId, U.AppTypeId, U.InstanceId, U.InstanceName
	FROM	cf_SurveyBillingEntityMember M
			INNER JOIN #CommCell C ON M.CommServUniqueId = C.CommServUniqueId
			INNER JOIN cf_SurveySubclientAssociation U
				ON U.CommServUniqueId = M.CommServUniqueId AND U.ClientId = M.ClientId AND U.AppTypeId = M.AppTypeId AND U.InstanceId = M.InstanceId
				AND M.ClientId > 0 AND M.AppTypeId > 0 AND M.InstanceId > 0 AND @i_EntityId IN (0, M.EntityID)
	GROUP BY U.CommServUniqueId, U.ClientId, U.AppTypeId, U.InstanceId, U.InstanceName
	INSERT	INTO #Backupset
	SELECT	U.CommServUniqueId, U.BackupsetId, U.BackupsetName
	FROM	cf_SurveyBillingEntityMember M
			INNER JOIN #CommCell C ON M.CommServUniqueId = C.CommServUniqueId
			INNER JOIN cf_SurveySubclientAssociation U
				ON U.CommServUniqueId = M.CommServUniqueId AND U.BackupsetId = M.BackupsetId AND M.BackupsetId > 0 AND @i_EntityId IN (0, M.EntityID)
	GROUP BY U.CommServUniqueId, U.BackupsetId, U.BackupsetName
	INSERT	INTO #Subclient
	SELECT	U.CommServUniqueId, U.AppId, U.SubclientName, MAX(U.Archive1PassFlags&2)
	FROM	cf_SurveyBillingEntityMember M
			INNER JOIN #CommCell C ON M.CommServUniqueId = C.CommServUniqueId
			INNER JOIN cf_SurveySubclientAssociation U
				ON U.CommServUniqueId = M.CommServUniqueId AND U.AppId = M.AppId AND M.AppId > 0 AND @i_EntityId IN (0, M.EntityID)
	GROUP BY U.CommServUniqueId, U.AppId, U.SubclientName
	IF @i_EntityId > 0
		SELECT	CC.ID AS 'CommServ UniqueId<DONOTSHOW>',
			CC.CommServName AS 'CommCell Name',
			M.ClientGroupId AS 'Client Group ID<DONOTSHOW>',
			ISNULL(CG.ClientGroupName, '') AS 'Client Group',
			M.ClientId AS 'Client ID<DONOTSHOW>',
			ISNULL(CL.ClientName, '') AS 'Client',
			M.AppTypeId AS 'Agent Type ID<DONOTSHOW>',
			ISNULL(A.AgentName, '') AS 'Agent',
			M.InstanceId AS 'InstanceId ID<DONOTSHOW>',
			ISNULL(I.InstanceName, '') AS 'Instance',
			M.BackupsetId AS 'Backupset ID<DONOTSHOW>',
			ISNULL(B.BackupsetName, '') AS 'Backupset',
			M.AppId AS 'App ID<DONOTSHOW>',
			ISNULL(S.SubclientName, '') AS 'Subclient',
			CASE A.ArchiveEnabled WHEN 1 THEN 'Yes' ELSE 'No' END AS 'Archive Enabled',
			CASE S.OnePassEnabled WHEN 1 THEN 'Yes' ELSE 'No' END AS 'OnePass Enabled'
		FROM	cf_SurveyBillingEntityMember M
			INNER JOIN #CommCell C ON M.CommServUniqueId = C.CommServUniqueId
			INNER JOIN cf_CommcellIdNameMap CC ON M.CommServUniqueId = CC.ID AND M.EntityID = @i_EntityId
			LEFT OUTER JOIN cf_SurveyClientGroup CG ON M.CommServUniqueId = CG.CommServUniqueId AND M.ClientGroupId = CG.ClientGroupId
			LEFT OUTER JOIN #Client CL ON M.CommServUniqueId = CL.CommServUniqueId AND M.ClientId = CL.ClientId
			LEFT OUTER JOIN #Agent A ON M.CommServUniqueId = A.CommServUniqueId AND M.AppTypeId = A.AppTypeId
			LEFT OUTER JOIN #Instance I ON M.CommServUniqueId = I.CommServUniqueId AND M.ClientId = I.ClientId AND M.AppTypeId = I.AppTypeId AND M.InstanceId = I.InstanceId
			LEFT OUTER JOIN #Backupset B ON M.CommServUniqueId = B.CommServUniqueId AND M.BackupsetId = B.BackupsetId
			LEFT OUTER JOIN #Subclient S ON M.CommServUniqueId = S.CommServUniqueId AND M.AppId = S.AppId
		ORDER BY CC.CommServName, 'Client Group', 'Client', 'Agent','Instance','Backupset','Subclient'
	ELSE
		SELECT	E.ID AS 'Tag ID<DONOTSHOW>',
			E.Name AS 'Tag Name',
			CC.ID AS 'CommServ UniqueId<DONOTSHOW>',
			CC.CommServName AS 'CommCell Name',
			M.ClientGroupId AS 'Client Group ID<DONOTSHOW>',
			ISNULL(CG.ClientGroupName, '') AS 'Client Group',
			M.ClientId AS 'Client ID<DONOTSHOW>',
			ISNULL(CL.ClientName, '') AS 'Client',
			M.AppTypeId AS 'Agent Type ID<DONOTSHOW>',
			ISNULL(A.AgentName, '') AS 'Agent',
			M.InstanceId AS 'InstanceId ID<DONOTSHOW>',
			ISNULL(I.InstanceName, '') AS 'Instance',
			M.BackupsetId AS 'Backupset ID<DONOTSHOW>',
			ISNULL(B.BackupsetName, '') AS 'Backupset',
			M.AppId AS 'App ID<DONOTSHOW>',
			ISNULL(S.SubclientName, '') AS 'Subclient',
			CASE A.ArchiveEnabled WHEN 1 THEN 'Yes' ELSE 'No' END AS 'Archive Enabled',
			CASE S.OnePassEnabled WHEN 1 THEN 'Yes' ELSE 'No' END AS 'OnePass Enabled'
		FROM	cf_SurveyBillingEntityMember M
			INNER JOIN #CommCell C ON M.CommServUniqueId = C.CommServUniqueId
			INNER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
			INNER JOIN cf_CommcellIdNameMap CC ON M.CommServUniqueId = CC.ID
			LEFT OUTER JOIN cf_SurveyClientGroup CG ON M.CommServUniqueId = CG.CommServUniqueId AND M.ClientGroupId = CG.ClientGroupId
			LEFT OUTER JOIN #Client CL ON M.CommServUniqueId = CL.CommServUniqueId AND M.ClientId = CL.ClientId
			LEFT OUTER JOIN #Agent A ON M.CommServUniqueId = A.CommServUniqueId AND M.AppTypeId = A.AppTypeId
			LEFT OUTER JOIN #Instance I ON M.CommServUniqueId = I.CommServUniqueId AND M.ClientId = I.ClientId AND M.AppTypeId = I.AppTypeId AND M.InstanceId = I.InstanceId
			LEFT OUTER JOIN #Backupset B ON M.CommServUniqueId = B.CommServUniqueId AND M.BackupsetId = B.BackupsetId
			LEFT OUTER JOIN #Subclient S ON M.CommServUniqueId = S.CommServUniqueId AND M.AppId = S.AppId
		ORDER BY E.Name, CC.CommServName, 'Client Group', 'Client', 'Agent','Instance','Backupset','Subclient'
	DROP TABLE #CommCell
	DROP TABLE #Client
	DROP TABLE #Agent
	DROP TABLE #Instance
	DROP TABLE #Backupset
	DROP TABLE #Subclient
END
ELSE
IF @i_CellUniqueId = 0
	SELECT	C.ID AS 'CommServ UniqueId',
			C.CommServName AS 'CommCell Name',
			CASE WHEN M.CommServUniqueId IS NULL THEN 0 ELSE 1 END AS 'Associated',
			ISNULL(E.ID, 0) AS 'Tag ID',
			ISNULL(E.Name, '') AS 'Tag Name'
	FROM	cf_CommcellIdNameMap C
			INNER JOIN dbo.cf_SurveyResultFuncV1(2, 0, 1, NULL, NULL, @i_UserId,-1) R ON R.CommServUniqueId = C.ID
			LEFT OUTER JOIN
			(SELECT EntityID, CommServUniqueId FROM cf_SurveyBillingEntityMember
			WHERE ClientGroupId = 0 AND ClientId = 0
			) M ON M.CommServUniqueId = C.ID
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
	WHERE	(C.CommCellSurveyServices&32) = 32
	ORDER BY C.CommServName
ELSE
IF @i_ClientGroupId = 0
	SELECT	-1 AS 'Client Group ID',
			'All Clients' AS 'Client Group Name',
			0 AS 'Associated',
			0 AS 'Tag ID',
			'' AS 'Tag Name'
	UNION
	SELECT	CG.ClientGroupId AS 'Client Group ID',
			CG.ClientGroupName AS 'Client Group Name',
			CASE WHEN M.ClientGroupId IS NULL THEN 0 ELSE 1 END AS 'Associated',
			ISNULL(E.ID, 0) AS 'Tag ID',
			ISNULL(E.Name, '') AS 'Tag Name'
	FROM	cf_SurveyClientGroup CG
			LEFT OUTER JOIN
			(SELECT EntityID, CommServUniqueId, ClientGroupId FROM cf_SurveyBillingEntityMember
			WHERE CommServUniqueId = @i_CellUniqueId AND ClientGroupId > 0 AND ClientId = 0
			) M ON M.CommServUniqueId = CG.CommServUniqueId AND M.ClientGroupId = CG.ClientGroupId
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
	WHERE	CG.CommservUniqueId = @i_CellUniqueId
	ORDER BY 'Client Group Name'
ELSE
IF @i_ClientGroupId = -1 AND @i_ClientId = 0
	SELECT	U.ClientId AS 'Client ID',
			U.ClientName AS 'Client Name',
			CASE WHEN M.ClientId IS NULL THEN 0 ELSE 1 END AS 'Associated',
			ISNULL(E.ID, 0) AS 'Tag ID',
			ISNULL(E.Name, '') AS 'Tag Name'
	FROM	(SELECT DISTINCT ClientId, ClientName FROM cf_SurveySubclientAssociation
			WHERE CommServUniqueId = @i_CellUniqueId) U
			LEFT OUTER JOIN
			(SELECT EntityID, ClientId FROM cf_SurveyBillingEntityMember
			WHERE CommServUniqueId = @i_CellUniqueId AND ClientId > 0 AND AppTypeId = 0
			) M ON M.ClientId = U.ClientId
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
	ORDER BY U.ClientName
ELSE
IF @i_ClientGroupId > 0 AND @i_ClientId = 0
	SELECT	U.ClientId AS 'Client ID',
			U.ClientName AS 'Client Name',
			CASE WHEN M.ClientId IS NULL THEN 0 ELSE 1 END AS 'Associated',
			ISNULL(E.ID, 0) AS 'Tag ID',
			ISNULL(E.Name, '') AS 'Tag Name'
	FROM	(SELECT DISTINCT ClientId, ClientName FROM cf_SurveySubclientAssociation
			WHERE CommServUniqueId = @i_CellUniqueId) U
			INNER JOIN cf_SurveyClientGroupAssociation CGA
				ON CGA.CommServUniqueId = @i_CellUniqueId AND CGA.ClientGroupId = @i_ClientGroupId AND CGA.ClientId = U.ClientId
			LEFT OUTER JOIN
			(SELECT EntityID, CommServUniqueId, ClientId FROM cf_SurveyBillingEntityMember
			WHERE CommServUniqueId = @i_CellUniqueId AND ClientGroupId = @i_ClientGroupId AND ClientId > 0 AND AppTypeId = 0
			) M ON M.CommServUniqueId = CGA.CommServUniqueId AND M.ClientId = CGA.ClientId
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
	ORDER BY U.ClientName
ELSE
IF @i_ClientGroupId = -1 AND @i_ClientId = 0
	SELECT	U.ClientId AS 'Client ID',
			U.ClientName AS 'Client Name',
			CASE WHEN M.ClientId IS NULL THEN 0 ELSE 1 END AS 'Associated',
			ISNULL(E.ID, 0) AS 'Tag ID',
			ISNULL(E.Name, '') AS 'Tag Name'
	FROM	(SELECT DISTINCT ClientId, ClientName FROM cf_SurveySubclientAssociation
			WHERE CommServUniqueId = @i_CellUniqueId) U
			LEFT OUTER JOIN
			(SELECT EntityID, ClientId FROM cf_SurveyBillingEntityMember
			WHERE CommServUniqueId = @i_CellUniqueId AND ClientId > 0 AND AppTypeId = 0
			) M ON M.ClientId = U.ClientId
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
	ORDER BY U.ClientName
ELSE
IF @i_ClientId > 0 AND @i_AppTypeId = 0
	SELECT	U.AppTypeId AS 'AppType ID',
			U.AgentName AS 'Agent Name',
			CASE U.Archive1PassFlags&1 WHEN 1 THEN 'Yes' ELSE 'No' END AS 'Archive Enabled',
			'N/A' AS 'OnePass Enabled',
			CASE WHEN M.AppTypeId IS NULL THEN 0 ELSE 1 END AS 'Associated',
			ISNULL(E.ID, 0) AS 'Tag ID',
			ISNULL(E.Name, '') AS 'Tag Name'
	FROM	(SELECT AppTypeId, AgentName, MAX(Archive1PassFlags) AS Archive1PassFlags FROM cf_SurveySubclientAssociation
			WHERE CommServUniqueId = @i_CellUniqueId AND ClientId = @i_ClientId
			GROUP BY AppTypeId, AgentName) U
			LEFT OUTER JOIN
			(SELECT EntityID, AppTypeId FROM cf_SurveyBillingEntityMember
			WHERE CommServUniqueId = @i_CellUniqueId AND ClientId = @i_ClientId
				AND AppTypeId > 0 AND InstanceId = 0
			) M ON M.AppTypeId = U.AppTypeId
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
	ORDER BY U.AgentName
ELSE
IF @i_AppTypeId > 0 AND @i_InstanceId = 0
	SELECT	U.InstanceId AS 'Instance ID',
			U.InstanceName AS 'Instance Name',
			CASE U.Archive1PassFlags&1 WHEN 1 THEN 'Yes' ELSE 'No' END AS 'Archive Enabled',
			'N/A' AS 'OnePass Enabled',
			CASE WHEN M.InstanceId IS NULL THEN 0 ELSE 1 END AS 'Associated',
			ISNULL(E.ID, 0) AS 'Tag ID',
			ISNULL(E.Name, 'N/A') AS 'Tag Name'
	FROM	(SELECT DISTINCT InstanceId, InstanceName, MAX(Archive1PassFlags) AS Archive1PassFlags FROM cf_SurveySubclientAssociation
			WHERE CommServUniqueId = @i_CellUniqueId AND ClientId = @i_ClientId AND AppTypeId = @i_AppTypeId
			GROUP BY InstanceId, InstanceName) U
			LEFT OUTER JOIN
			(SELECT EntityID, InstanceId FROM cf_SurveyBillingEntityMember
			WHERE CommServUniqueId = @i_CellUniqueId AND ClientId = @i_ClientId AND AppTypeId = @i_AppTypeId
				AND InstanceId > 0 AND BackupsetId = 0 AND AppId = 0
			) M ON M.InstanceId = U.InstanceId
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
	ORDER BY U.InstanceName
ELSE
IF @i_InstanceId > 0 AND @i_BackupsetId = 0
	SELECT	U.BackupsetId AS 'Backupset ID',
			U.BackupsetName AS 'Backupset Name',
			CASE U.Archive1PassFlags&1 WHEN 1 THEN 'Yes' ELSE 'No' END AS 'Archive Enabled',
			'N/A' AS 'OnePass Enabled',
			CASE WHEN M.BackupsetId IS NULL THEN 0 ELSE 1 END AS 'Associated',
			ISNULL(E.ID, 0) AS 'Tag ID',
			ISNULL(E.Name, 'N/A') AS 'Tag Name'
	FROM	(SELECT DISTINCT BackupsetId, BackupsetName, MAX(Archive1PassFlags) AS Archive1PassFlags FROM cf_SurveySubclientAssociation
			WHERE CommServUniqueId = @i_CellUniqueId AND ClientId = @i_ClientId AND AppTypeId = @i_AppTypeId
				AND InstanceId = @i_InstanceId
			GROUP BY BackupsetId, BackupsetName) U
			LEFT OUTER JOIN
			(SELECT EntityID, BackupsetId FROM cf_SurveyBillingEntityMember
			WHERE CommServUniqueId = @i_CellUniqueId AND ClientId = @i_ClientId AND AppTypeId = @i_AppTypeId
				AND InstanceId = @i_InstanceId AND BackupsetId > 0 AND AppId = 0
			) M ON M.BackupsetId = U.BackupsetId
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
	ORDER BY U.BackupsetName
ELSE
IF @i_BackupsetId > 0
	SELECT	U.AppId AS 'Backupset ID',
			U.SubclientName AS 'Subclient Name',
			CASE U.Archive1PassFlags&1 WHEN 1 THEN 'Yes' ELSE 'No' END AS 'Archive Enabled',
			CASE U.Archive1PassFlags&2 WHEN 2 THEN 'Yes' ELSE 'No' END AS 'OnePass Enabled',
			CASE WHEN M.AppId IS NULL THEN 0 ELSE 1 END AS 'Associated',
			ISNULL(E.ID, 0) AS 'Tag ID',
			ISNULL(E.Name, '') AS 'Tag Name'
	FROM	(SELECT AppId, SubclientName, MAX(Archive1PassFlags) AS Archive1PassFlags FROM cf_SurveySubclientAssociation
			WHERE CommServUniqueId = @i_CellUniqueId AND ClientId = @i_ClientId AND AppTypeId = @i_AppTypeId
				AND InstanceId = @i_InstanceId AND BackupsetId = @i_BackupsetId
			GROUP BY AppId, SubclientName) U
			LEFT OUTER JOIN
			(SELECT EntityID, AppId FROM cf_SurveyBillingEntityMember
			WHERE CommServUniqueId = @i_CellUniqueId AND ClientId = @i_ClientId AND AppTypeId = @i_AppTypeId
				AND InstanceId = @i_InstanceId AND BackupsetId = @i_BackupsetId AND AppId > 0
			) M ON M.AppId = U.AppId
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
	ORDER BY U.SubclientName
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptBillingAssociation')
	delete from GxQscripts where name = 'RptBillingAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBillingAssociation')
	delete from GXDBVersions where aliasname = 'RptBillingAssociation'
GO

insert into GXDBVersions values(2, 'RptBillingAssociation',  '00010011000000000000', 'RptBillingAssociation', '00010011000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/SetBillingAssociation.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/SetBillingAssociation.sp,v $ $Id: SetBillingAssociation.sp,v 1.4 2015/05/20 14:34:40 vmishra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SetBillingAssociation <<<'

IF EXISTS (select * from sysobjects where name='SetBillingAssociation')
	drop procedure SetBillingAssociation
IF EXISTS (select * from GxQscripts where name='SetBillingAssociation')
	delete from GxQscripts where name = 'SetBillingAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetBillingAssociation')
	delete from GXDBVersions where aliasname = 'SetBillingAssociation'
GO
print '... Creating Procedure: SetBillingAssociation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SetBillingAssociation
  @i_UserId INT = NULL,
  @i_AddOrDelete INT,
  @i_EntityId INT,
  @i_CellUniqueId INT = 0,
  @i_ClientGroupId INT = 0,
  @i_ClientId INT = 0,
  @i_AppTypeId INT = 0,
  @i_InstanceId INT = 0,
  @i_BackupsetId INT = 0,
  @i_AppId INT = 0
AS
SET NOCOUNT ON
DECLARE @ErrorCode INT = 0
DECLARE @ERROR_TAG_ASSOCIATION_EXIST INT = 1
DECLARE @ERROR_TAG_TO_CLIENT_EXIST INT = 2
DECLARE @ERROR_TAG_TO_COPY_EXIST INT = 3
DECLARE @Existing INT = 0
SELECT	@Existing = COUNT(*)
FROM	cf_SurveyBillingEntityMember
WHERE	EntityId = @i_EntityId AND CommServUniqueId = @i_CellUniqueId AND ClientGroupId = @i_ClientGroupId
	AND ClientId = @i_ClientId AND AppTypeId = @i_AppTypeId AND InstanceId = @i_InstanceId AND BackupsetId = @i_BackupsetId AND AppId = @i_AppId
IF @i_AddOrDelete = 1
BEGIN
	DECLARE @AnyTagToCopy INT = 0
	SELECT	@AnyTagToCopy = COUNT(*)
	FROM	cf_SurveyBillingEntityToCopy
	WHERE	CommServUniqueId = @i_CellUniqueId
	IF @Existing > 0
		SET @ErrorCode = @ERROR_TAG_ASSOCIATION_EXIST
	ELSE
	IF @AnyTagToCopy > 0
		SET @ErrorCode = @ERROR_TAG_TO_COPY_EXIST
	ELSE
	INSERT	INTO cf_SurveyBillingEntityMember
	SELECT	@i_EntityId, @i_CellUniqueId, @i_ClientGroupId, @i_ClientId, @i_AppTypeId, @i_InstanceId, @i_BackupsetId, @i_AppId
END
ELSE
IF @i_AddOrDelete = 0 AND @Existing > 0
	DELETE	cf_SurveyBillingEntityMember
	WHERE	EntityId = @i_EntityId AND CommServUniqueId = @i_CellUniqueId AND ClientGroupId = @i_ClientGroupId
		AND ClientId = @i_ClientId AND AppTypeId = @i_AppTypeId AND InstanceId = @i_InstanceId AND BackupsetId = @i_BackupsetId AND AppId = @i_AppId
SELECT @ErrorCode
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SetBillingAssociation')
	delete from GxQscripts where name = 'SetBillingAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetBillingAssociation')
	delete from GXDBVersions where aliasname = 'SetBillingAssociation'
GO

insert into GXDBVersions values(2, 'SetBillingAssociation',  '00010004000000000000', 'SetBillingAssociation', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptBillingTags.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptBillingTags.sp,v $ $Id: RptBillingTags.sp,v 1.5 2014/12/29 21:28:11 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptBillingTags <<<'

IF EXISTS (select * from sysobjects where name='RptBillingTags')
	drop procedure RptBillingTags
IF EXISTS (select * from GxQscripts where name='RptBillingTags')
	delete from GxQscripts where name = 'RptBillingTags'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBillingTags')
	delete from GXDBVersions where aliasname = 'RptBillingTags'
GO
print '... Creating Procedure: RptBillingTags'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptBillingTags
  @i_Dummy INT = 0
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT	B.ID AS 'Tag ID<DONOTSHOW>',
		B.Name AS 'Tag Name',
		ISNULL(P.PricePerTB, -1) AS 'Price (/TB)<NumberNA>',
		ISNULL(P.BasePriceLevel, -1) AS 'Additional Price Level<TagEntityLevel>',
		ISNULL(P.BasePrice, 0) AS 'Additional Price<NumberNA>',
		ISNULL(P.DiscountLevel, -1) AS 'Discount Level<TagEntityLevel>',
		ISNULL(P.DiscountTB, 0) AS 'Discount Size (TB)<NumberNA>',
		ISNULL(P.DiscountPct, 0) AS 'Discount (%)<NumberNA>',
		B.Description AS 'Description'
FROM	cf_SurveyBillingEntity B
		LEFT OUTER JOIN cf_SurveyPriceTag P ON P.TagNameId = B.ID AND P.TagType = 0
WHERE	B.ID > 0
ORDER BY B.Name
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptBillingTags')
	delete from GxQscripts where name = 'RptBillingTags'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBillingTags')
	delete from GXDBVersions where aliasname = 'RptBillingTags'
GO

insert into GXDBVersions values(2, 'RptBillingTags',  '00010005000000000000', 'RptBillingTags', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/SetBillingTag.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/SetBillingTag.sp,v $ $Id: SetBillingTag.sp,v 1.7 2015/05/20 14:35:03 vmishra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SetBillingTag <<<'

IF EXISTS (select * from sysobjects where name='SetBillingTag')
	drop procedure SetBillingTag
IF EXISTS (select * from GxQscripts where name='SetBillingTag')
	delete from GxQscripts where name = 'SetBillingTag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetBillingTag')
	delete from GXDBVersions where aliasname = 'SetBillingTag'
GO
print '... Creating Procedure: SetBillingTag'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SetBillingTag
  @i_UserId INT = NULL,
  @i_DeleteTag INT,
  @i_EntityId INT,
  @i_EntityName NVARCHAR(256),
  @i_Description NVARCHAR(256) = '',
  @i_ContactInfo NVARCHAR(2048) = '',
  @i_PricePerTB DECIMAL(10, 3) = -1,
  @i_BasePriceLevel INT = -1,
  @i_BasePrice DECIMAL(10, 3) = 0,
  @i_DiscountLevel INT = -1,
  @i_DiscountTB DECIMAL(10, 3) = 0,
  @i_DiscountPct DECIMAL(10, 3) = 0
AS
SET NOCOUNT ON
DECLARE @ErrorCode INT = 0
DECLARE @ERROR_TAG_NOT_EXIST INT = 1
DECLARE @ERROR_TAG_ALREADY_EXIST INT = 2
IF @i_DeleteTag = 1
BEGIN
	IF EXISTS (SELECT * FROM cf_SurveyBillingEntity WHERE ID = @i_EntityId)
	BEGIN
		DELETE cf_SurveyPriceTag WHERE TagType = 0 AND TagNameId = @i_EntityId
		DELETE cf_SurveyBillingEntity WHERE ID = @i_EntityId
	END
	ELSE
		SET @ErrorCode = @ERROR_TAG_NOT_EXIST
END
ELSE
IF ISNULL(@i_EntityName, '') <> ''
BEGIN
	IF @i_EntityId > 0
	BEGIN
		UPDATE	cf_SurveyBillingEntity
		SET		Name = @i_EntityName, Description = @i_Description, ContactInfo = @i_ContactInfo
		WHERE	ID = @i_EntityId
		IF @i_PricePerTB = -1
			DELETE cf_SurveyPriceTag WHERE TagType = 0 AND TagNameId = @i_EntityId
		ELSE
		IF EXISTS (SELECT * FROM cf_SurveyPriceTag WHERE TagType = 0 AND TagNameId = @i_EntityId
		AND (PricePerTB <> @i_PricePerTB OR BasePriceLevel <> @i_BasePriceLevel OR BasePrice <> @i_BasePrice
			OR DiscountLevel <> @i_DiscountLevel OR DiscountTB <> @i_DiscountTB OR DiscountPct <> @i_DiscountPct))
			UPDATE	cf_SurveyPriceTag
			SET		PricePerTB = @i_PricePerTB, BasePriceLevel = @i_BasePriceLevel, BasePrice = @i_BasePrice,
					DiscountLevel = @i_DiscountLevel, DiscountTB = @i_DiscountTB, DiscountPct = @i_DiscountPct
			WHERE	TagType = 0 AND TagNameId = @i_EntityId
		ELSE
		IF NOT EXISTS (SELECT * FROM cf_SurveyPriceTag WHERE TagType = 0 AND TagNameId = @i_EntityId)
			INSERT	INTO cf_SurveyPriceTag
			SELECT	0, 0, 0, 0, '', @i_PricePerTB, @i_EntityId, 0, @i_BasePriceLevel, @i_BasePrice, @i_DiscountLevel, @i_DiscountTB, @i_DiscountPct
		ELSE
			SET @ErrorCode = @ERROR_TAG_ALREADY_EXIST
	END
	ELSE
	IF NOT EXISTS (SELECT * FROM cf_SurveyBillingEntity WHERE Name = @i_EntityName)
	BEGIN
		INSERT INTO cf_SurveyBillingEntity
		SELECT NEWID(), @i_EntityName, @i_Description, @i_ContactInfo, GETUTCDATE()
		SET @i_EntityId = ISNULL(SCOPE_IDENTITY(), 0)
		IF  @i_EntityId > 0 AND @i_PricePerTB >= 0
			INSERT	INTO cf_SurveyPriceTag
			SELECT	0, 0, 0, 0, '', @i_PricePerTB, @i_EntityId, 0, @i_BasePriceLevel, @i_BasePrice, @i_DiscountLevel, @i_DiscountTB, @i_DiscountPct
	END
END
SELECT @ErrorCode
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SetBillingTag')
	delete from GxQscripts where name = 'SetBillingTag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetBillingTag')
	delete from GXDBVersions where aliasname = 'SetBillingTag'
GO

insert into GXDBVersions values(2, 'SetBillingTag',  '00010007000000000000', 'SetBillingTag', '00010007000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptBillingTagToCopy.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptBillingTagToCopy.sp,v $ $Id: RptBillingTagToCopy.sp,v 1.4 2015/07/06 20:31:48 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptBillingTagToCopy <<<'

IF EXISTS (select * from sysobjects where name='RptBillingTagToCopy')
	drop procedure RptBillingTagToCopy
IF EXISTS (select * from GxQscripts where name='RptBillingTagToCopy')
	delete from GxQscripts where name = 'RptBillingTagToCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBillingTagToCopy')
	delete from GXDBVersions where aliasname = 'RptBillingTagToCopy'
GO
print '... Creating Procedure: RptBillingTagToCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptBillingTagToCopy
  @i_UserId INT = -1,
  @i_EntityId INT,
  @i_AllAssociated INT = 1,
  @i_CellUniqueId INT = 0,
  @i_PolicyId INT = 0,
  @i_CopyId INT = 0
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
CREATE TABLE #CommCell (CommServUniqueId INT, CommServName NVARCHAR(256))
INSERT	INTO  #CommCell
SELECT	C.ID, C.CommServName
FROM	cf_CommcellIdNameMap C
		INNER JOIN dbo.cf_SurveyResultFuncV1(2, 0, 1, NULL, NULL, @i_UserId, -1) R ON R.CommServUniqueId = C.ID
WHERE	(C.CommCellSurveyServices&32) = 32
-- Show copy tag associations
IF @i_AllAssociated = 1
BEGIN
	IF @i_EntityId > 0
		SELECT	CC.CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
			CC.CommServName AS 'CommCell Name',
			C.PolicyName AS 'Storage Policy',
			C.CopyId AS 'Copy ID<DONOTSHOW>',
			C.CopyName AS 'Copy Name',
			CASE WHEN C.IsDefaultCopy = 1 THEN 'Yes' ELSE 'No' END AS 'Is Primary Copy',
			CASE WHEN C.IsSnapCopy = 1 THEN 'Yes' ELSE 'No' END AS 'Is Snap Copy',
			CASE ISNULL( C.DedupeFlags, -1) WHEN -1 THEN 'N/A' WHEN 0 THEN 'No' ELSE 'Yes' END AS 'Is Dedup Copy',
			ISNULL(C.DefaultLibrary, 'N/A') AS 'Library Name'
		FROM	 #CommCell CC
			INNER JOIN cf_SurveyCopyBasicRetention C  ON C.CommServUniqueId = CC.CommServUniqueId
			INNER JOIN cf_SurveyBillingEntityToCopy M ON M.CommServUniqueId = CC.CommServUniqueId AND C.CopyId = M.CopyId AND M.EntityID = @i_EntityId
		ORDER BY 'CommCell Name', 'Storage Policy', 'Copy Name'
	ELSE
		SELECT	E.ID AS 'Tag ID<DONOTSHOW>',
			E.Name AS 'Tag Name',
			CC.CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
			CC.CommServName AS 'CommCell Name',
			ISNULL(C.PolicyName, '') AS 'Storage Policy',
			M.CopyId AS 'Copy ID<DONOTSHOW>',
			ISNULL(C.CopyName, '') AS 'Copy Name',
			CASE WHEN C.IsDefaultCopy = 1 THEN 'Yes' ELSE 'No' END AS 'Is Primary Copy',
			CASE WHEN C.IsSnapCopy = 1 THEN 'Yes' ELSE 'No' END AS 'Is Snap Copy',
			CASE ISNULL( C.DedupeFlags, -1) WHEN -1 THEN 'N/A' WHEN 0 THEN 'No' ELSE 'Yes' END AS 'Is Dedup Copy',
			ISNULL(C.DefaultLibrary, 'N/A') AS 'Library Name'
		FROM	 #CommCell CC
			INNER JOIN cf_SurveyCopyBasicRetention C  ON C.CommServUniqueId = CC.CommServUniqueId
			INNER JOIN cf_SurveyBillingEntityToCopy M ON C.CommServUniqueId = M.CommServUniqueId AND C.CopyId = M.CopyId
			INNER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
		ORDER BY 'Tag Name', 'CommCell Name', 'Storage Policy', 'Copy Name'
END
-- New copy tag association
ELSE
IF @i_CellUniqueId <= 0
	SELECT	CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
			CommServName AS 'CommCell Name'
	FROM	#CommCell
	ORDER BY 'CommCell Name'
ELSE
IF @i_CellUniqueId > 0 AND @i_PolicyId <= 0
	SELECT	DISTINCT PolicyId AS 'Policy ID<DONOTSHOW>',
			PolicyName AS 'Storage Policy'
	FROM	cf_SurveyCopyBasicRetention C
	WHERE	CommservUniqueId = @i_CellUniqueId
	ORDER BY 'Storage Policy'
ELSE
IF @i_CellUniqueId > 0 AND @i_PolicyId > 0 AND @i_CopyId <= 0
	SELECT	C.CopyId AS 'Copy ID<DONOTSHOW>',
			C.CopyName AS 'Copy Name',
			CASE WHEN C.IsDefaultCopy = 1 THEN 'Yes' ELSE 'No' END AS 'Is Primary Copy',
			CASE WHEN C.IsSnapCopy = 1 THEN 'Yes' ELSE 'No' END AS 'Is Snap Copy',
			CASE ISNULL( C.DedupeFlags, -1) WHEN -1 THEN 'N/A' WHEN 0 THEN 'No' ELSE 'Yes' END AS 'Is Dedup Copy',
			ISNULL(C.DefaultLibrary, 'N/A') AS 'Library Name',
			CASE WHEN M.CopyId IS NULL THEN 0 ELSE 1 END AS 'Associated',
			ISNULL(E.ID, 0) AS 'Tag ID',
			ISNULL(E.Name, '') AS 'Tag Name'
	FROM	cf_SurveyCopyBasicRetention C
			LEFT OUTER JOIN cf_SurveyBillingEntityToCopy M ON M.CommServUniqueId = @i_CellUniqueId AND M.CopyId = C.CopyId
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
	WHERE	C.CommservUniqueId = @i_CellUniqueId AND C.PolicyId = @i_PolicyId
	ORDER BY 'Copy Name'
ELSE
IF @i_CellUniqueId > 0 AND @i_PolicyId > 0 AND @i_CopyId > 0
	SELECT	C.CopyId AS 'Copy ID<DONOTSHOW>',
			C.CopyName AS 'Copy Name',
			CASE WHEN C.IsDefaultCopy = 1 THEN 'Yes' ELSE 'No' END AS 'Is Primary Copy',
			CASE WHEN C.IsSnapCopy = 1 THEN 'Yes' ELSE 'No' END AS 'Is Snap Copy',
			CASE ISNULL( C.DedupeFlags, -1) WHEN -1 THEN 'N/A' WHEN 0 THEN 'No' ELSE 'Yes' END AS 'Is Dedup Copy',
			ISNULL(C.DefaultLibrary, 'N/A') AS 'Library Name',
			CASE WHEN M.CopyId IS NULL THEN 0 ELSE 1 END AS 'Associated',
			ISNULL(E.ID, 0) AS 'Tag ID',
			ISNULL(E.Name, '') AS 'Tag Name'
	FROM	cf_SurveyCopyBasicRetention C
			LEFT OUTER JOIN cf_SurveyBillingEntityToCopy M ON M.CommServUniqueId = @i_CellUniqueId AND M.CopyId = C.CopyId
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
	WHERE	C.CommservUniqueId = @i_CellUniqueId AND C.PolicyId = @i_PolicyId AND C.CopyId = @i_CopyId
	ORDER BY 'Copy Name'
DROP TABLE #CommCell
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptBillingTagToCopy')
	delete from GxQscripts where name = 'RptBillingTagToCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBillingTagToCopy')
	delete from GXDBVersions where aliasname = 'RptBillingTagToCopy'
GO

insert into GXDBVersions values(2, 'RptBillingTagToCopy',  '00010004000000000000', 'RptBillingTagToCopy', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/SetBillingTagToCopy.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/SetBillingTagToCopy.sp,v $ $Id: SetBillingTagToCopy.sp,v 1.3 2015/05/20 14:34:59 vmishra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SetBillingTagToCopy <<<'

IF EXISTS (select * from sysobjects where name='SetBillingTagToCopy')
	drop procedure SetBillingTagToCopy
IF EXISTS (select * from GxQscripts where name='SetBillingTagToCopy')
	delete from GxQscripts where name = 'SetBillingTagToCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetBillingTagToCopy')
	delete from GXDBVersions where aliasname = 'SetBillingTagToCopy'
GO
print '... Creating Procedure: SetBillingTagToCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SetBillingTagToCopy
  @i_UserId INT = NULL,
  @i_AddOrDelete INT,
  @i_EntityId INT,
  @i_CellUniqueId INT = 0,
  @i_CopyId INT = 0
AS
SET NOCOUNT ON
DECLARE @ErrorCode INT = 0
DECLARE @ERROR_TAG_ASSOCIATION_EXIST INT = 1
DECLARE @ERROR_TAG_TO_CLIENT_EXIST INT = 2
DECLARE @ERROR_TAG_TO_COPY_EXIST INT = 3
DECLARE @ERROR_TAG_TO_INVALID_COMMCELL INT = 4
DECLARE @ERROR_TAG_TO_INVALID_COPY INT = 5
DECLARE @Existing INT = 0
SELECT	@Existing = COUNT(*)
FROM	cf_SurveyBillingEntityToCopy
WHERE	EntityId = @i_EntityId AND CommServUniqueId = @i_CellUniqueId AND CopyId = @i_CopyId
IF @i_CellUniqueId <= 0
	SET @ErrorCode = @ERROR_TAG_TO_INVALID_COMMCELL
ELSE
IF @i_CopyId <= 0
	SET @ErrorCode = @ERROR_TAG_TO_INVALID_COPY
ELSE
IF @i_AddOrDelete = 1
BEGIN
	DECLARE @AnyTagToClient INT = 0
	SELECT	@AnyTagToClient = COUNT(*)
	FROM	cf_SurveyBillingEntityMember
	WHERE	CommServUniqueId = @i_CellUniqueId
	IF @Existing > 0
		SET @ErrorCode = @ERROR_TAG_ASSOCIATION_EXIST
	ELSE
	IF @AnyTagToClient > 0
		SET @ErrorCode = @ERROR_TAG_TO_CLIENT_EXIST
	ELSE
	INSERT	INTO cf_SurveyBillingEntityToCopy
	SELECT	@i_EntityId, @i_CellUniqueId, @i_CopyId
END
ELSE
IF @i_AddOrDelete = 0 AND @Existing > 0
	DELETE	cf_SurveyBillingEntityToCopy
	WHERE	EntityId = @i_EntityId AND CommServUniqueId = @i_CellUniqueId AND CopyId = @i_CopyId
SELECT @ErrorCode
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SetBillingTagToCopy')
	delete from GxQscripts where name = 'SetBillingTagToCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetBillingTagToCopy')
	delete from GXDBVersions where aliasname = 'SetBillingTagToCopy'
GO

insert into GXDBVersions values(2, 'SetBillingTagToCopy',  '00010003000000000000', 'SetBillingTagToCopy', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptBkpDataRetention.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptBkpDataRetention.sp,v $ $Id: RptBkpDataRetention.sp,v 1.3 2014/07/28 21:48:57 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptBkpDataRetention <<<'

IF EXISTS (select * from sysobjects where name='RptBkpDataRetention')
	drop procedure RptBkpDataRetention
IF EXISTS (select * from GxQscripts where name='RptBkpDataRetention')
	delete from GxQscripts where name = 'RptBkpDataRetention'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBkpDataRetention')
	delete from GXDBVersions where aliasname = 'RptBkpDataRetention'
GO
print '... Creating Procedure: RptBkpDataRetention'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptBkpDataRetention
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 141
SET @blLatestSurvey = 1
IF(@blaggregate=1)
BEGIN
	SELECT
	(SUM(csInfo.AgeIn30DaysMB))				AS '30 Days<SIZEMB>',
	(SUM(csInfo.AgeIn30To90DaysMB))			AS '30 To 90 Days<SIZEMB>',
	(SUM(csInfo.AgeIn90To365DaysMB))		AS '90 To 365 Days<SIZEMB>',
	(SUM(csInfo.AgeAfter365DaysMB))			AS 'Above 365 Days<SIZEMB>'
	FROM cf_SurveyBkpDataRetention AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId,@i_GroupId) AS resultView
	ON resultView.SurverResultId = csInfo.SurveyResultId
END
ELSE
BEGIN
	DECLARE @param_isPrivate INT = 0
	SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
	SELECT
	resultView.CommServUniqueId,
	resultView.CommCellID,
	CASE
		WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
		ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
	END AS 'CommCellName',
	csInfo.AgeIn30DaysMB 				AS '30 Days<SIZEMB>',
	csInfo.AgeIn30To90DaysMB 			AS '30 To 90 Days<SIZEMB>',
	csInfo.AgeIn90To365DaysMB 			AS '90 To 365 Days<SIZEMB>',
	csInfo.AgeAfter365DaysMB 			AS 'Above 365 Days<SIZEMB>'
	FROM cf_SurveyBkpDataRetention AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId,@i_GroupId) AS resultView
	ON resultView.SurverResultId = csInfo.SurveyResultId
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptBkpDataRetention')
	delete from GxQscripts where name = 'RptBkpDataRetention'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBkpDataRetention')
	delete from GXDBVersions where aliasname = 'RptBkpDataRetention'
GO

insert into GXDBVersions values(2, 'RptBkpDataRetention',  '00010003000000000000', 'RptBkpDataRetention', '00010003000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptBkpJobStatus.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptBkpJobStatus.sp,v $ $Id: RptBkpJobStatus.sp,v 1.5 2014/07/28 21:49:03 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptBkpJobStatus <<<'

IF EXISTS (select * from sysobjects where name='RptBkpJobStatus')
	drop procedure RptBkpJobStatus
IF EXISTS (select * from GxQscripts where name='RptBkpJobStatus')
	delete from GxQscripts where name = 'RptBkpJobStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBkpJobStatus')
	delete from GXDBVersions where aliasname = 'RptBkpJobStatus'
GO
print '... Creating Procedure: RptBkpJobStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptBkpJobStatus
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 16
IF @i_CommServUniqueID = 0
BEGIN
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	resultView.CommServGUID AS 'CommServer GUID',
	CASE
		WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
		ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
	END AS 'CommCell Name',
	DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(csInfo.LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME>',
	ISNULL(resultView.CommServTimeZone, '')  AS 'TimeZone',
	CASE
		WHEN resultView.RunningTime = -1 THEN 'N/A'
		ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
	END AS 'Running Time in Seconds',
	--csInfo.ClientGroups AS 'Client Groups',
	CAST(CAST(CASE csInfo.SuccessfulJobs
	WHEN 0 THEN 0
	ELSE (csInfo.SuccessfulJobs * 100.0)/csInfo.TotalJobs END
	AS DECIMAL(7, 2)) AS VARCHAR(MAX)) + ' %' AS 'Success Rate',
	csInfo.TotalJobs AS 'Total',
	csInfo.SuccessfulJobs AS 'Successful',
	csInfo.CompletedWithErrorJobs AS 'Completed With Error',
	csInfo.CompletedWithWarningJobs 'Completed With Warning',
	csInfo.FailedJobs AS 'Failed'
FROM cf_SurveyBkpJobStats AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
		AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
		AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
ORDER BY csInfo.LogDate DESC, resultView.CustomerName ASC
END
ELSE
SELECT
	csInfo.CommServUniqueId AS 'CommServ UniqueId',
	DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(csInfo.LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME>',
	--csInfo.ClientGroups AS 'Client Groups',
	CAST(CAST(CASE csInfo.SuccessfulJobs
	WHEN 0 THEN 0
	ELSE (csInfo.SuccessfulJobs * 100.0)/csInfo.TotalJobs END
	AS DECIMAL(7, 2)) AS VARCHAR(MAX)) + ' %' AS 'Success Rate',
	csInfo.TotalJobs AS 'Total',
	csInfo.SuccessfulJobs AS 'Successful',
	csInfo.CompletedWithErrorJobs AS 'Completed With Error',
	csInfo.CompletedWithWarningJobs 'Completed With Warning',
	csInfo.FailedJobs AS 'Failed'
FROM cf_SurveyBkpJobStats AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
		AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
		AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
ORDER BY csInfo.LogDate DESC
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptBkpJobStatus')
	delete from GxQscripts where name = 'RptBkpJobStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBkpJobStatus')
	delete from GXDBVersions where aliasname = 'RptBkpJobStatus'
GO

insert into GXDBVersions values(2, 'RptBkpJobStatus',  '00010005000000000000', 'RptBkpJobStatus', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptBkpJobStatus_WMon.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptBkpJobStatus_WMon.sp,v $ $Id: RptBkpJobStatus_WMon.sp,v 1.15 2015/07/15 04:35:25 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptBkpJobStatus_WMon <<<'

IF EXISTS (select * from sysobjects where name='RptBkpJobStatus_WMon')
	drop procedure RptBkpJobStatus_WMon
IF EXISTS (select * from GxQscripts where name='RptBkpJobStatus_WMon')
	delete from GxQscripts where name = 'RptBkpJobStatus_WMon'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBkpJobStatus_WMon')
	delete from GXDBVersions where aliasname = 'RptBkpJobStatus_WMon'
GO
print '... Creating Procedure: RptBkpJobStatus_WMon'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptBkpJobStatus_WMon
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll,
  @WeeklyMonth INT =0
AS
DECLARE @i_QueryId BIGINT = 51
declare @collectionDate date = (select cast(max(resultView.LogDate) as DATE) from
dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView)
SET NOCOUNT ON
IF(@blaggregate=1)
BEGIN
IF @WeeklyMonth = 0 --Last 24 Hours
SELECT
	CAST(CAST(CASE SUM(csInfo.SuccessfulJobs+csInfo.CompletedWithErrorJobs+csInfo.CompletedWithWarningJobs)
	WHEN 0 THEN 0
	ELSE (SUM(csInfo.SuccessfulJobs+csInfo.CompletedWithErrorJobs+csInfo.CompletedWithWarningJobs) * 100.0)/SUM(csInfo.TotalJobs) END
	AS DECIMAL(7, 1)) AS VARCHAR(MAX))  AS 'Success Rate',
	SUM(csInfo.TotalJobs) AS 'Total',
	SUM(csInfo.SuccessfulJobs) AS 'Completed',
	SUM(csInfo.CompletedWithErrorJobs) + SUM(csInfo.CompletedWithWarningJobs)  'Completed with Errors or Warnings',
	SUM(csInfo.FailedJobs) AS 'Failed',
	ISNULL(SUM(csInfo.KilledJobs),-1) AS 'Killed'
FROM cf_SurveyBkpJobStats_WMon AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND csInfo.outType = 2
ELSE IF @WeeklyMonth = 1 --Last 7 days
SELECT
	CAST(CAST(CASE SUM(csInfo.SuccessfulJobs+csInfo.CompletedWithErrorJobs+csInfo.CompletedWithWarningJobs)
	WHEN 0 THEN 0
	ELSE (SUM(csInfo.SuccessfulJobs+csInfo.CompletedWithErrorJobs+csInfo.CompletedWithWarningJobs) * 100.0)/SUM(csInfo.TotalJobs) END
	AS DECIMAL(7, 1)) AS VARCHAR(MAX))  AS 'Success Rate',
	SUM(csInfo.TotalJobs) AS 'Total',
	SUM(csInfo.SuccessfulJobs) AS 'Completed',
	SUM(csInfo.CompletedWithErrorJobs) + SUM(csInfo.CompletedWithWarningJobs)  'Completed with Errors or Warnings',
	SUM(csInfo.FailedJobs) AS 'Failed',
	ISNULL(SUM(csInfo.KilledJobs),-1) AS 'Killed'
FROM cf_SurveyBkpJobStats_WMon AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND csInfo.outType = 3
	RETURN
END
SET NOCOUNT ON
IF @WeeklyMonth = 0 --TODAY DATA ONLY
BEGIN
	DECLARE @param_isPrivate INT = 0
	SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
	SELECT
		csInfo.CommServUniqueId AS 'CommServ UniqueId',
		resultView.CommCellID AS 'CommCell ID',
		CASE
			WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
			ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
		END AS 'CommCell Name',
		CAST(CAST(CASE SUM(csInfo.SuccessfulJobs+csInfo.CompletedWithErrorJobs+csInfo.CompletedWithWarningJobs)
		WHEN 0 THEN 0
		ELSE (SUM(csInfo.SuccessfulJobs+csInfo.CompletedWithErrorJobs+csInfo.CompletedWithWarningJobs) * 100.0)/SUM(csInfo.TotalJobs) END
		AS DECIMAL(7, 1)) AS VARCHAR(MAX)) AS 'Success Rate (%)',
		SUM(csInfo.TotalJobs) AS 'Total',
		SUM(csInfo.SuccessfulJobs) AS 'Completed',
		SUM(csInfo.CompletedWithErrorJobs + csInfo.CompletedWithWarningJobs) AS 'Completed with Errors or Warnings',
	    SUM(csInfo.FailedJobs) AS 'Failed',
		ISNULL(SUM(csInfo.KilledJobs),-1) AS 'Killed',
		datediff(second, '01/01/1970', CAST(csInfo.servEndDate AS DATE)) AS 'As Of<DWDDMMM>'
	FROM cf_SurveyBkpJobStats_WMon AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND csInfo.outType =2
			AND resultView.CommCellID  !=-1
	GROUP BY csInfo.CommServUniqueId, resultView.CommCellID, resultView.CommServName, resultView.CustomerName, csInfo.servEndDate
	ORDER BY csInfo.servEndDate desc
END
ELSE IF @WeeklyMonth = 1 --LAST WEEK DATA ONLY
BEGIN
	DECLARE @Week_table TABLE
	(
	S_Rate						DECIMAL(7, 1),
	Total						BIGINT ,
	Successful					BIGINT ,
	CompletedWithErrorJobs		BIGINT ,
	CompletedWithWarningJobs	BIGINT ,
	Failed                      BIGINT ,
	Killed                      BIGINT ,
	servEndDate					DATE
	)
	DECLARE @today DATE
	if ( @i_CommServUniqueID =0)
	SET @today = (SELECT CAST(GETDATE() AS DATE))
	else
	set @today = @collectionDate
	;WITH R(N) AS
	(
	SELECT 0
	UNION ALL
	SELECT N+1
	FROM R
	WHERE N < 15
	)
	INSERT INTO @Week_table
	SELECT   -1,-1,-1,-1,-1,-1,-1,DATEADD(DAY,-N,@today)
	FROM R
	UPDATE @Week_table
	SET				 S_Rate = Sub.s_Rate ,
	Total	 				= Sub.t_Jobs,
	Successful				= Sub.s_Jobs,
	CompletedWithErrorJobs	= Sub.se_Jobs,
	CompletedWithWarningJobs= Sub.sw_Jobs,
	Failed					= Sub.f_Jobs,
	Killed					= Sub.k_Jobs
	FROM
	(
		SELECT
			CAST(CASE SUM(csInfo.SuccessfulJobs)+SUM(csInfo.CompletedWithErrorJobs)+SUM(csInfo.CompletedWithWarningJobs)
			WHEN 0 THEN 0
			ELSE ((SUM(csInfo.SuccessfulJobs) +SUM(csInfo.CompletedWithErrorJobs)+SUM(csInfo.CompletedWithWarningJobs))* 100.0)/SUM(csInfo.TotalJobs) END
			AS DECIMAL(7, 1)) AS  s_Rate,
		SUM(csInfo.TotalJobs) AS  t_Jobs,
		SUM(csInfo.SuccessfulJobs) AS  s_Jobs,
		SUM(csInfo.CompletedWithErrorJobs) AS  se_Jobs,
		SUM(csInfo.CompletedWithWarningJobs) AS  sw_Jobs,
		SUM(csInfo.FailedJobs) AS  f_Jobs,
		ISNULL(SUM(csInfo.KilledJobs),-1)  AS  k_Jobs,
		servEndDate as sdate
	FROM cf_SurveyBkpJobStats_WMon AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND csInfo.outType =3
			AND DATEDIFF(DAY,servEndDate,@today) BETWEEN 0 AND 15
		GROUP BY servEndDate
	) as Sub
	INNER JOIN @Week_table AS week
	ON week.servEndDate = Sub.sdate
	IF EXISTS(SELECT Total FROM @Week_table WHERE Total<>-1)
	BEGIN
	SELECT
		CAST(CASE S_Rate
			 WHEN -1 THEN '-'
			 ELSE CAST(S_Rate AS VARCHAR(MAX))
			 END
		 AS VARCHAR(MAX)) AS 'Success Rate (%)',
		CAST(CASE Total
			 WHEN -1 THEN '-'
			 ELSE CAST(Total AS VARCHAR(MAX))
			 END
		 AS VARCHAR(MAX)) AS 'Total',
		CAST(CASE Successful
			 WHEN -1 THEN '-'
			 ELSE CAST(Successful AS VARCHAR(MAX))
			 END
		 AS VARCHAR(MAX)) AS 'Completed',
		CAST(CASE CompletedWithErrorJobs + CompletedWithWarningJobs
			 WHEN -2 THEN '-'
			 ELSE CAST(CompletedWithErrorJobs + CompletedWithWarningJobs AS VARCHAR(MAX))
			 END
		 AS VARCHAR(MAX)) AS 'Completed with Errors or Warnings',
		CAST(CASE Failed
			 WHEN -1 THEN '-'
			 ELSE CAST(Failed AS VARCHAR(MAX))
			 END
		 AS VARCHAR(MAX)) AS 'Failed',
		CAST(CASE Killed
					 WHEN -1 THEN '-'
					 ELSE CAST(Killed AS VARCHAR(MAX))
					 END
				 AS VARCHAR(MAX)) AS 'Killed',
		datediff(second, '01/01/1970',servEndDate) AS 'As Of<DWDDMMM>'
	FROM @Week_table
	ORDER BY servEndDate
	END
	ELSE
	BEGIN
	SELECT
		CAST(CASE S_Rate
			 WHEN -1 THEN '-'
			 ELSE CAST(S_Rate AS VARCHAR(MAX))
			 END
		 AS VARCHAR(MAX)) AS 'Success Rate (%)',
		CAST(CASE Total
			 WHEN -1 THEN '-'
			 ELSE CAST(Total AS VARCHAR(MAX))
			 END
		 AS VARCHAR(MAX)) AS 'Total',
		CAST(CASE Successful
			 WHEN -1 THEN '-'
			 ELSE CAST(Successful AS VARCHAR(MAX))
			 END
		 AS VARCHAR(MAX)) AS 'Completed',
		CAST(CASE CompletedWithErrorJobs + CompletedWithWarningJobs
			 WHEN -2 THEN '-'
			 ELSE CAST(CompletedWithErrorJobs + CompletedWithWarningJobs AS VARCHAR(MAX))
			 END
		 AS VARCHAR(MAX)) AS 'Completed with Errors or Warnings',
		CAST(CASE Failed
			 WHEN -1 THEN '-'
			 ELSE CAST(Failed AS VARCHAR(MAX))
			 END
		 AS VARCHAR(MAX)) AS 'Failed',
		CAST(CASE Killed
			 WHEN -1 THEN '-'
			 ELSE CAST(Killed AS VARCHAR(MAX))
			 END
		 AS VARCHAR(MAX)) AS 'Killed',
		datediff(second, '01/01/1970',servEndDate) AS 'As Of<DWDDMMM>'
	FROM @Week_table WHERE Total<>-1
	ORDER BY servEndDate
	END
END
ELSE IF @WeeklyMonth = 2 --MONTHLY DATA ONLY
BEGIN
	DECLARE @Month_table TABLE
	(
	S_Rate						DECIMAL(7, 1),
	Total						BIGINT ,
	Successful					BIGINT ,
	CompletedWithErrorJobs		BIGINT ,
	CompletedWithWarningJobs	BIGINT ,
	Failed                      BIGINT ,
	Killed                      BIGINT ,
	servEndDate					DATE
	)
	DECLARE @mtoday DATE
	if ( @i_CommServUniqueID =0)
	SET @mtoday = (SELECT CAST(GETDATE() AS DATE))
	else
	set @mtoday = @collectionDate
	;WITH R(N) AS
	(
	SELECT 0
	UNION ALL
	SELECT N+1
	FROM R
	WHERE N < 11
	)
	INSERT INTO @Month_table
	SELECT   -1,-1,-1,-1,-1,-1,-1,DATEADD(MONTH,-N,DATEADD(DAY, -(DAY(@mtoday)-1),@mtoday))
	FROM R
	UPDATE @Month_table
	set Total					= (T.Total) ,
	Successful				= (T.Successful) ,
	CompletedWithErrorJobs	= (t.CompletedWithErrorJobs) ,
	CompletedWithWarningJobs= (T.CompletedWithWarningJobs) ,
	S_Rate = T.S_Rate,
	Failed = T.Failed,
	Killed = T.Killed
	FROM
	(
	SELECT S_Rate = CAST(CASE SUM(csInfo.SuccessfulJobs) +SUM(csInfo.CompletedWithErrorJobs)+SUM(csInfo.CompletedWithWarningJobs)
						WHEN 0 THEN 0
						ELSE ((SUM(csInfo.SuccessfulJobs)+SUM(csInfo.CompletedWithErrorJobs)+SUM(csInfo.CompletedWithWarningJobs)) * 100.0)/SUM(csInfo.TotalJobs)
					 END
					AS DECIMAL(7, 2)),
	Total					= SUM(csInfo.TotalJobs) ,
	Successful				= SUM(csInfo.SuccessfulJobs) ,
	CompletedWithErrorJobs	= SUM(csInfo.CompletedWithErrorJobs) ,
	CompletedWithWarningJobs= SUM(csInfo.CompletedWithWarningJobs) ,
	Failed			= sum(csInfo.FailedJobs),
	Killed			= ISNULL(SUM(csInfo.KilledJobs),-1),
	servEndDate
	FROM cf_SurveyBkpJobStats_WMon AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND csInfo.outType =1
			GROUP BY servEndDate
			) T
		INNER JOIN @Month_table AS mon
		ON mon.servEndDate = T.servEndDate
	IF EXISTS(SELECT Total FROM @Month_table WHERE Total<>-1)
	BEGIN
		SELECT
		CAST(CASE S_Rate
				 WHEN -1 THEN '-'
				 ELSE CAST(S_Rate AS VARCHAR(MAX))
				 END
			 AS VARCHAR(MAX)) AS 'Success Rate (%)',
			CAST(CASE Total
				 WHEN -1 THEN '-'
				 ELSE CAST(Total AS VARCHAR(MAX))
				 END
			 AS VARCHAR(MAX)) AS 'Total',
			CAST(CASE Successful
				 WHEN -1 THEN '-'
				 ELSE CAST(Successful AS VARCHAR(MAX))
				 END
			 AS VARCHAR(MAX)) AS 'Completed',
			CAST(CASE CompletedWithErrorJobs + CompletedWithWarningJobs
				 WHEN -2 THEN '-'
				 ELSE CAST(CompletedWithErrorJobs + CompletedWithWarningJobs AS VARCHAR(MAX))
				 END
			 AS VARCHAR(MAX)) AS 'Completed with Errors or Warnings',
			CAST(CASE Failed
				 WHEN -1 THEN '-'
				 ELSE CAST(Failed AS VARCHAR(MAX))
				 END
			 AS VARCHAR(MAX)) AS 'Failed',
			CAST(CASE Killed
				 WHEN -1 THEN '-'
				 ELSE CAST(Killed AS VARCHAR(MAX))
				 END
			 AS VARCHAR(MAX)) AS 'Killed',
			 datediff(second, '01/01/1970',servEndDate) AS 'As Of<DWDDMMM>'
		FROM @Month_table
		ORDER BY DATEPART(YEAR, servEndDate) ,DATEPART(MONTH,servEndDate)
	END
	ELSE
	BEGIN
		SELECT
		CAST(CASE S_Rate
				 WHEN -1 THEN '-'
				 ELSE CAST(S_Rate AS VARCHAR(MAX))
				 END
			 AS VARCHAR(MAX)) AS 'Success Rate (%)',
			CAST(CASE Total
				 WHEN -1 THEN '-'
				 ELSE CAST(Total AS VARCHAR(MAX))
				 END
			 AS VARCHAR(MAX)) AS 'Total',
			CAST(CASE Successful
				 WHEN -1 THEN '-'
				 ELSE CAST(Successful AS VARCHAR(MAX))
				 END
			 AS VARCHAR(MAX)) AS 'Completed',
			CAST(CASE CompletedWithErrorJobs + CompletedWithWarningJobs
				 WHEN -2 THEN '-'
				 ELSE CAST(CompletedWithErrorJobs + CompletedWithWarningJobs AS VARCHAR(MAX))
				 END
			 AS VARCHAR(MAX)) AS 'Completed with Errors or Warnings',
			CAST(CASE Failed
				 WHEN -1 THEN '-'
				 ELSE CAST(Failed AS VARCHAR(MAX))
				 END
			 AS VARCHAR(MAX)) AS 'Failed',
			CAST(CASE Killed
				 WHEN -1 THEN '-'
				 ELSE CAST(Killed AS VARCHAR(MAX))
				 END
			 AS VARCHAR(MAX)) AS 'Killed',
			 datediff(second, '01/01/1970',servEndDate) AS 'As Of<DWDDMMM>'
		FROM @Month_table
		WHERE Total<>-1
		ORDER BY DATEPART(YEAR, servEndDate) ,DATEPART(MONTH,servEndDate)
	END
END
ELSE --ALL DATAA
SELECT
	CAST(CAST(CASE SUM(csInfo.SuccessfulJobs +csInfo.CompletedWithErrorJobs+csInfo.CompletedWithWarningJobs)
	WHEN 0 THEN 0
	ELSE (SUM(csInfo.SuccessfulJobs+csInfo.CompletedWithErrorJobs+csInfo.CompletedWithWarningJobs) * 100.0)/SUM(csInfo.TotalJobs) END
	AS DECIMAL(7, 1)) AS VARCHAR(MAX)) AS 'Success Rate (%)',
	SUM(csInfo.TotalJobs) AS 'Total',
	SUM(csInfo.SuccessfulJobs) AS 'Completed',
	SUM(csInfo.CompletedWithErrorJobs) AS 'Completed With Error',
	SUM(csInfo.CompletedWithWarningJobs) 'Completed With Warning',
	SUM(csInfo.FailedJobs) AS 'Failed',
	ISNULL(SUM(csInfo.KilledJobs),-1) AS 'Killed',
	datediff(second, '01/01/1970', CAST(csInfo.servEndDate AS DATE)) AS 'As Of<DWDDMMM>'
FROM cf_SurveyBkpJobStats_WMon AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
	GROUP BY csInfo.servEndDate
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptBkpJobStatus_WMon')
	delete from GxQscripts where name = 'RptBkpJobStatus_WMon'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBkpJobStatus_WMon')
	delete from GXDBVersions where aliasname = 'RptBkpJobStatus_WMon'
GO

insert into GXDBVersions values(2, 'RptBkpJobStatus_WMon',  '00010015000000000000', 'RptBkpJobStatus_WMon', '00010015000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptCapacityLicenseSurvey.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptCapacityLicenseSurvey.sp,v $ $Id: RptCapacityLicenseSurvey.sp,v 1.22 2015/07/06 20:31:48 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptCapacityLicenseSurvey <<<'

IF EXISTS (select * from sysobjects where name='RptCapacityLicenseSurvey')
	drop procedure RptCapacityLicenseSurvey
IF EXISTS (select * from GxQscripts where name='RptCapacityLicenseSurvey')
	delete from GxQscripts where name = 'RptCapacityLicenseSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCapacityLicenseSurvey')
	delete from GXDBVersions where aliasname = 'RptCapacityLicenseSurvey'
GO
print '... Creating Procedure: RptCapacityLicenseSurvey'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptCapacityLicenseSurvey
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll,
  @i_csvOutput INT  = 0
AS
DECLARE @i_QueryId INT = 1
SET NOCOUNT ON
CREATE TABLE #CommServResults (
	CommServUniqueId INT, CommCellID VARCHAR(32), CommServIP VARCHAR(256), CommServGUID VARCHAR(256), CustomerName NVARCHAR(256),
	CommServName NVARCHAR(256), CommServTimeZone VARCHAR(256), SurveyResultId INT, LogDate DATETIME, LogDateUTC DATETIME
)
IF @blaggregate = 1 AND @blLatestSurvey = 0 -- Capacity Growth
	INSERT INTO #CommServResults
	SELECT	CommServUniqueId, CommCellID, CommServIP, CommServGUID, CustomerName, CommServName, CommServTimeZone, SurverResultId, LogDate, LogDateUTC
	FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
ELSE -- Capacity Usage and CommCell Details
	INSERT INTO #CommServResults
	SELECT	CommServUniqueId, CommCellID, CommServIP, CommServGUID, CustomerName, CommServName, CommServTimeZone, SurverResultId, LogDate, LogDateUTC
	FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
IF @blaggregate <> 1 AND @blLatestSurvey = 1 -- CommCell Details
BEGIN
	IF @i_CommServUniqueID = 0
	BEGIN
		DECLARE @param_isPrivate INT = 0
		SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
		IF @blaggregate = 0 --Capacity Usage
			SELECT
				CommServUniqueId AS 'CommServ UniqueId',
				CommCellID AS 'CommCell ID',
				CommServIP AS 'CommServe IP<HIDDEN>',
				CommServGUID AS 'CommServer GUID',
				CASE WHEN @param_isPrivate = 1 THEN CommServName ELSE CustomerName + ' - ' + CommServName END AS 'CommCell Name',
				DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME><HIDDEN>',
				ISNULL(CommServTimeZone, '')  AS 'TimeZone<HIDDEN>',
				CASE WHEN ISNULL(TotalBackupSize,0) <= 0 THEN -1 ELSE TotalBackupSize END AS 'Purchased Enterprise Backup Size<SIZEMB>',
				ISNULL(BackupSize,0) AS 'Used Enterprise Backup Size<SIZEMB>',
				CASE WHEN ISNULL(TotalArchiveSize, 0) <= 0 THEN -1 ELSE TotalArchiveSize END AS 'Purchased Enterprise Archive Size<SIZEMB>',
				ISNULL(ArchiveSize, 0) AS 'Used Enterprise Archive Size<SIZEMB>',
				CASE WHEN ISNULL(TotalSnapshotSize, 0) <= 0 THEN -1 ELSE TotalSnapshotSize END AS 'Purchased Snapshot Size<SIZEMB>',
				ISNULL(SnapshotSize, 0) AS 'Used Snapshot Size<SIZEMB>',
				CASE WHEN ISNULL(TotalReplicationSize, 0) <= 0 THEN -1 ELSE TotalReplicationSize END AS 'Purchased Replication Size<SIZEMB>',
				ISNULL(ReplicationSize, 0) AS 'Used Replication Size<SIZEMB>',
				CASE WHEN ISNULL(TotalDiskSpaceMB, 0) <= 0 THEN -1 ELSE TotalDiskSpaceMB END AS 'Purchased Library Disk Space<SIZEMB>',
				ISNULL(UsedDiskSpaceMB, 0) AS 'Used Disk Space<SIZEMB>',
				CASE WHEN ISNULL(TotalStoreSpaceMB, 0) <= 0 THEN -1 ELSE TotalStoreSpaceMB END AS 'Purchased Dedup Data Size<SIZEMB>',
				ISNULL(DedupDataSizeMB, 0) AS 'Used Dedup Data Size<SIZEMB>'
			FROM cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK)
				INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			ORDER BY LogDateUTC DESC, CustomerName ASC
		ELSE
		IF @blaggregate = 2 --Virtualization License Usage
			SELECT
				CommServUniqueId AS 'CommServ UniqueId',
				CommCellID AS 'CommCell ID',
				CommServIP AS 'CommServe IP<HIDDEN>',
				CommServGUID AS 'CommServer GUID',
				CASE WHEN @param_isPrivate = 1 THEN CommServName ELSE CustomerName + ' - ' + CommServName END AS 'CommCell Name',
				DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME><HIDDEN>',
				ISNULL(CommServTimeZone, '')  AS 'TimeZone<HIDDEN>',
				CASE WHEN TotalVMSockets IS NULL THEN -2 WHEN ISNUMERIC(TotalVMSockets) = 1 THEN CAST(TotalVMSockets AS INT) ELSE -1 END AS 'Purchased VM Sockets<NumberUnlimitedNA>',
				ISNULL(VMSockets, 0) AS 'Used VM Sockets',
				CASE WHEN TotalProtectedVMs IS NULL THEN -2 WHEN ISNUMERIC(TotalProtectedVMs) = 1 THEN CAST(TotalProtectedVMs AS INT) ELSE -1 END AS 'Purchased Protected VMs<NumberUnlimitedNA>',
				ISNULL(ProtectedVMs, 0) AS 'Used Protected VMs'
			FROM cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK)
				INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			ORDER BY LogDateUTC DESC, CustomerName ASC
		ELSE
		IF @blaggregate = 4 --Archiving License Usage
			SELECT
				CommServUniqueId AS 'CommServ UniqueId',
				CommCellID AS 'CommCell ID',
				CommServIP AS 'CommServe IP<HIDDEN>',
				CommServGUID AS 'CommServer GUID',
				CASE WHEN @param_isPrivate = 1 THEN CommServName ELSE CustomerName + ' - ' + CommServName END AS 'CommCell Name',
				DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME><HIDDEN>',
				ISNULL(CommServTimeZone, '')  AS 'TimeZone<HIDDEN>',
				CASE WHEN TotalArchivedMailBoxes IS NULL THEN -2 WHEN ISNUMERIC(TotalArchivedMailBoxes) = 1 THEN CAST(TotalArchivedMailBoxes AS INT) ELSE -1 END AS 'Purchased Archived MailBoxes<NumberUnlimitedNA>',
				ISNULL(ArchivedMailBoxes, 0) AS 'Used Archived MailBoxes',
				CASE WHEN TotalCIObjectsInMillion IS NULL THEN -2 WHEN ISNUMERIC(TotalCIObjectsInMillion) = 1 THEN CAST(TotalCIObjectsInMillion AS INT) ELSE -1 END AS 'Purchased CI Objects (million)<NumberUnlimitedNA>',
				CAST(0.000001*ISNULL(CIObjects, 0) AS DECIMAL(20,2)) AS 'Used CI Objects (million)'
			FROM cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK)
				INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			ORDER BY LogDateUTC DESC, CustomerName ASC
		ELSE
		IF @blaggregate = 3 --Users Count Usage
			SELECT
				CommServUniqueId AS 'CommServ UniqueId',
				CommCellID AS 'CommCell ID',
				CommServIP AS 'CommServe IP<HIDDEN>',
				CommServGUID AS 'CommServer GUID',
				CASE WHEN @param_isPrivate = 1 THEN CommServName ELSE CustomerName + ' - ' + CommServName END AS 'CommCell Name',
				DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME><HIDDEN>',
				ISNULL(CommServTimeZone, '')  AS 'TimeZone<HIDDEN>',
				CASE WHEN TotalEndPointUsers IS NULL THEN -2 WHEN ISNUMERIC(TotalEndPointUsers) = 1 THEN CAST(TotalEndPointUsers AS INT) ELSE -1 END AS 'Purchased Users<NumberUnlimitedNA>',
				ISNULL(EndpointUsers, 0) AS 'Used Users',
				CASE WHEN TotalSharingUsers IS NULL THEN -2 WHEN ISNUMERIC(TotalSharingUsers) = 1 THEN CAST(TotalSharingUsers AS INT) ELSE -1 END AS 'Purchased Sharing Users<NumberUnlimitedNA>',
				ISNULL(SharingUsers, 0) AS 'Used Sharing Users',
				CASE WHEN TotaleDiscoveryUsers IS NULL THEN -2 WHEN ISNUMERIC(TotaleDiscoveryUsers) = 1 THEN CAST(TotaleDiscoveryUsers AS INT) ELSE -1 END AS 'Purchased eDiscovery Users<NumberUnlimitedNA>',
				ISNULL(eDiscoveryUsers, 0) AS 'Used eDiscovery Users'
			FROM cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK)
				INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			ORDER BY LogDateUTC DESC, CustomerName ASC
	END
	ELSE
	BEGIN
		IF @blaggregate = 0 --Capacity Usage
			SELECT 	'Enterprise Backup' AS 'Capacity License',
					CASE WHEN ISNULL(TotalBackupSize,0) <= 0 THEN -1 ELSE TotalBackupSize END AS 'Purchased<SIZEMB>',
					ISNULL(BackupSize,0) AS 'Used<SIZEMB>'
			FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			UNION ALL
			SELECT 	'Enterprise Archive' AS 'Capacity License',
					CASE WHEN ISNULL(TotalArchiveSize, 0) <= 0 THEN -1 ELSE TotalArchiveSize END AS 'Purchased<SIZEMB>',
					ISNULL(ArchiveSize, 0) AS 'Used<SIZEMB>'
			FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			UNION ALL
			SELECT 	'Snapshot' AS 'Capacity License',
					CASE WHEN ISNULL(TotalSnapshotSize, 0) <= 0 THEN -1 ELSE TotalSnapshotSize END AS 'Purchased<SIZEMB>',
					ISNULL(SnapshotSize, 0) AS 'Used<SIZEMB>'
			FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			UNION ALL
			SELECT 	'Replication' AS 'Capacity License',
					CASE WHEN ISNULL(TotalReplicationSize, 0) <= 0 THEN -1 ELSE TotalReplicationSize END AS 'Purchased<SIZEMB>',
					ISNULL(ReplicationSize, 0) AS 'Used<SIZEMB>'
			FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			UNION ALL
			SELECT 	'Library Disk Space' AS 'Capacity License',
					CASE WHEN ISNULL(TotalDiskSpaceMB, 0) <= 0 THEN -1 ELSE TotalDiskSpaceMB END  AS 'Purchased<SIZEMB>',
					ISNULL(UsedDiskSpaceMB, 0) AS 'Used<SIZEMB>'
			FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			UNION ALL
			SELECT 	'Dedup Data Size' AS 'Capacity License',
					CASE WHEN ISNULL(TotalStoreSpaceMB, 0) <= 0 THEN -1 ELSE TotalStoreSpaceMB END AS 'Purchased<SIZEMB>',
					ISNULL(DedupDataSizeMB, 0) AS 'Used<SIZEMB>'
			FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
		ELSE
		IF @blaggregate = 2 --Virtualization License Usage
			SELECT	'VM Sockets' AS 'License',
					CASE WHEN TotalVMSockets IS NULL THEN -2 WHEN ISNUMERIC(TotalVMSockets) = 1 THEN CAST(TotalVMSockets AS INT) ELSE -1 END AS 'Purchased<NumberUnlimitedNA>',
					ISNULL(VMSockets, 0) AS 'Used'
			FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			UNION ALL
			SELECT	'Protected VMs' AS 'License',
					CASE WHEN TotalProtectedVMs IS NULL THEN -2 WHEN ISNUMERIC(TotalProtectedVMs) = 1 THEN CAST(TotalProtectedVMs AS INT) ELSE -1 END AS 'Purchased<NumberUnlimitedNA>',
					ISNULL(ProtectedVMs, 0) AS 'Used'
			FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
		ELSE
		IF @blaggregate = 4 --Archiving License Usage
			SELECT	'Archived MailBoxes' AS 'License',
					CASE WHEN TotalArchivedMailBoxes IS NULL THEN -2 WHEN ISNUMERIC(TotalArchivedMailBoxes) = 1 THEN CAST(TotalArchivedMailBoxes AS INT) ELSE -1 END AS 'Purchased<NumberUnlimitedNA>',
					ISNULL(ArchivedMailBoxes, 0) AS 'Used'
			FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			UNION ALL
			SELECT	'CI Objects (million)' AS 'License',
					CASE WHEN TotalCIObjectsInMillion IS NULL THEN -2 WHEN ISNUMERIC(TotalCIObjectsInMillion) = 1 THEN CAST(TotalCIObjectsInMillion AS INT) ELSE -1 END AS 'Purchased<NumberUnlimitedNA>',
					CAST(0.000001*ISNULL(CIObjects, 0) AS DECIMAL(20,2)) AS 'Used'
			FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
		ELSE
		IF @blaggregate = 3 --Endpoint Users Count Usage
			SELECT 	'Users' AS 'License',
					CASE WHEN TotalEndPointUsers IS NULL THEN -2 WHEN ISNUMERIC(TotalEndPointUsers) = 1 THEN CAST(TotalEndPointUsers AS INT) ELSE -1 END AS 'Purchased<NumberUnlimitedNA>',
					ISNULL(EndpointUsers, 0) AS 'Used'
			FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			UNION ALL
			SELECT	'Sharing Users' AS 'License',
					CASE WHEN TotalSharingUsers IS NULL THEN -2 WHEN ISNUMERIC(TotalSharingUsers) = 1 THEN CAST(TotalSharingUsers AS INT) ELSE -1 END AS 'Purchased<NumberUnlimitedNA>',
					ISNULL(SharingUsers, 0) AS 'Used'
			FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
			UNION ALL
			SELECT	'eDiscovery Users' AS 'License',
					CASE WHEN TotaleDiscoveryUsers IS NULL THEN -2 WHEN ISNUMERIC(TotaleDiscoveryUsers) = 1 THEN CAST(TotaleDiscoveryUsers AS INT) ELSE -1 END AS 'Purchased<NumberUnlimitedNA>',
					ISNULL(eDiscoveryUsers, 0) AS 'Used'
			FROM	cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK) INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
	END
END
ELSE IF @blaggregate = 1
BEGIN
	CREATE TABLE #tmpSurveyCLAInfo (
		CommServUniqueId INT, LogDate DATETIME,
		TotalBackupSize BIGINT, BackupSize BIGINT,
		TotalArchiveSize BIGINT, ArchiveSize BIGINT,
		TotalSnapshotSize BIGINT, SnapshotSize BIGINT,
		TotalReplicationSize BIGINT, ReplicationSize BIGINT,
		TotalVMSockets INT, VMSockets INT,
		TotalProtectedVMs INT, ProtectedVMs INT,
		TotalEndpointUsers INT, EndpointUsers INT,
		TotalSharingUsers INT, SharingUsers INT,
		TotaleDiscoveryUsers INT, eDiscoveryUsers INT,
		TotalArchivedMailBoxes INT, ArchivedMailBoxes INT,
		TotalCIObjectsInMillion INT, CIObjects BIGINT
	)
	INSERT INTO #tmpSurveyCLAInfo
	SELECT
		CommServUniqueId, LogDate,
		CASE WHEN ISNULL(TotalBackupSize, 0) >= 0 THEN TotalBackupSize ELSE -1 END, ISNULL(BackupSize, 0),
		CASE WHEN ISNULL(TotalArchiveSize, 0) >= 0 THEN TotalArchiveSize ELSE -1 END, ISNULL(ArchiveSize, 0),
		CASE WHEN ISNULL(TotalSnapshotSize, 0) >= 0 THEN TotalSnapshotSize ELSE -1 END, ISNULL(SnapshotSize, 0),
		CASE WHEN ISNULL(TotalReplicationSize, 0) >= 0 THEN TotalReplicationSize ELSE -1 END, ISNULL(ReplicationSize, 0),
		CASE WHEN TotalVMSockets IS NULL THEN 0 WHEN ISNUMERIC(TotalVMSockets) = 1 THEN TotalVMSockets ELSE -1 END, ISNULL(VMSockets, 0),
		CASE WHEN TotalProtectedVMs IS NULL THEN 0 WHEN ISNUMERIC(TotalProtectedVMs) = 1 THEN TotalProtectedVMs ELSE -1 END, ISNULL(csInfo.ProtectedVMs, 0),
		CASE WHEN TotalEndpointUsers IS NULL THEN 0 WHEN ISNUMERIC(TotalEndpointUsers) = 1 THEN TotalEndpointUsers ELSE -1 END, ISNULL(EndpointUsers, 0),
		CASE WHEN TotalSharingUsers IS NULL THEN 0 WHEN ISNUMERIC(TotalSharingUsers) = 1 THEN TotalSharingUsers ELSE -1 END, ISNULL(csInfo.SharingUsers, 0),
		CASE WHEN TotaleDiscoveryUsers IS NULL THEN 0 WHEN ISNUMERIC(TotaleDiscoveryUsers) = 1 THEN TotaleDiscoveryUsers ELSE -1 END, ISNULL(eDiscoveryUsers, 0),
		CASE WHEN TotalArchivedMailBoxes IS NULL THEN 0 WHEN ISNUMERIC(TotalArchivedMailBoxes) = 1 THEN TotalArchivedMailBoxes ELSE -1 END, ISNULL(ArchivedMailBoxes, 0),
		CASE WHEN TotalCIObjectsInMillion IS NULL THEN 0 WHEN ISNUMERIC(TotalCIObjectsInMillion) = 1 THEN TotalCIObjectsInMillion ELSE -1 END, ISNULL(CIObjects, 0)
	FROM
		cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK)
		INNER JOIN #CommServResults AS results ON results.SurveyResultId = csInfo.SurveyResultId
	DECLARE @CommCellCount BIGINT = 0
	DECLARE @LatestLogDate DATETIME
	SELECT 	@CommCellCount = COUNT(DISTINCT CommServUniqueId), @LatestLogDate = MAX(LogDate)
	FROM	#tmpSurveyCLAInfo
	DECLARE @AggrResultTempTable TABLE (LogDate DATETIME,
		TotalBackupSize BIGINT, BackupSize BIGINT,
		TotalArchiveSize BIGINT, ArchiveSize BIGINT,
		TotalSnapshotSize BIGINT, SnapshotSize BIGINT,
		TotalReplicationSize BIGINT, ReplicationSize BIGINT,
		TotalVMSockets INT, VMSockets INT,
		TotalProtectedVMs INT, ProtectedVMs INT,
		TotalEndpointUsers INT, EndpointUsers INT,
		TotalSharingUsers INT, SharingUsers INT,
		TotaleDiscoveryUsers INT, eDiscoveryUsers INT,
		TotalArchivedMailBoxes INT, ArchivedMailBoxes INT,
		TotalCIObjectsInMillion INT, CIObjects BIGINT
		)
	IF @blLatestSurvey = 0
	BEGIN
		DECLARE @FromMonth DATE = DATEADD(MONTH, DATEDIFF(MONTH, 0, @LatestLogDate)-12, 0)
		INSERT INTO @AggrResultTempTable
		SELECT
			P.MonthStart,
			SUM(CASE WHEN @i_CommServUniqueID = 0 AND T.TotalBackupSize = -1 THEN ISNULL(P.BackupSize, 0) ELSE T.TotalBackupSize END), SUM(ISNULL(P.BackupSize, 0)),
			SUM(CASE WHEN @i_CommServUniqueID = 0 AND T.TotalArchiveSize = -1 THEN ISNULL(P.ArchiveSize, 0) ELSE T.TotalArchiveSize END), SUM(ISNULL(P.ArchiveSize, 0)),
			SUM(CASE WHEN @i_CommServUniqueID = 0 AND T.TotalSnapshotSize = -1 THEN ISNULL(P.SnapshotSize, 0) ELSE T.TotalSnapshotSize END), SUM(ISNULL(P.SnapshotSize, 0)),
			SUM(CASE WHEN @i_CommServUniqueID = 0 AND T.TotalReplicationSize = -1 THEN ISNULL(P.ReplicationSize, 0) ELSE T.TotalReplicationSize END), SUM(ISNULL(P.ReplicationSize, 0)),
			SUM(CASE WHEN @i_CommServUniqueID = 0 AND T.TotalVMSockets = -1 THEN ISNULL(P.VMSockets, 0) ELSE T.TotalVMSockets END), SUM(ISNULL(P.VMSockets, 0)),
			SUM(CASE WHEN @i_CommServUniqueID = 0 AND T.TotalProtectedVMs = -1 THEN ISNULL(P.ProtectedVMs, 0) ELSE T.TotalProtectedVMs END), SUM(ISNULL(P.ProtectedVMs, 0)),
			SUM(CASE WHEN @i_CommServUniqueID = 0 AND T.TotalEndpointUsers = -1 THEN ISNULL(P.EndpointUsers, 0) ELSE T.TotalEndpointUsers END), SUM(ISNULL(P.EndpointUsers, 0)),
			SUM(CASE WHEN @i_CommServUniqueID = 0 AND T.TotalSharingUsers = -1 THEN ISNULL(P.SharingUsers, 0) ELSE T.TotalSharingUsers END), SUM(ISNULL(P.SharingUsers, 0)),
			SUM(CASE WHEN @i_CommServUniqueID = 0 AND T.TotaleDiscoveryUsers = -1 THEN ISNULL(P.eDiscoveryUsers, 0) ELSE T.TotaleDiscoveryUsers END), SUM(ISNULL(P.eDiscoveryUsers, 0)),
			SUM(CASE WHEN @i_CommServUniqueID = 0 AND T.TotalArchivedMailBoxes = -1 THEN ISNULL(P.ArchivedMailBoxes, 0) ELSE T.TotalArchivedMailBoxes END), SUM(ISNULL(P.ArchivedMailBoxes, 0)),
			SUM(CASE WHEN @i_CommServUniqueID = 0 AND T.TotalCIObjectsInMillion = -1 THEN ISNULL(P.CIObjects, 0) ELSE T.TotalCIObjectsInMillion END), SUM(ISNULL(P.CIObjects, 0))
		FROM
			cf_SurveyCapacityLicensePeakUsage AS P WITH (NOLOCK)
			INNER JOIN #tmpSurveyCLAInfo AS T ON P.CommServUniqueId = T.CommServUniqueId
		WHERE P.MonthStart >= @FromMonth
		GROUP BY P.MonthStart
	END
	ELSE
		INSERT INTO @AggrResultTempTable
		SELECT
			@LatestLogDate,
			SUM(CASE WHEN @i_CommServUniqueID = 0 AND TotalBackupSize = -1 THEN BackupSize ELSE TotalBackupSize END), SUM(BackupSize),
			SUM(CASE WHEN @i_CommServUniqueID = 0 AND TotalArchiveSize = -1 THEN ArchiveSize ELSE TotalArchiveSize END), SUM(ArchiveSize),
			SUM(CASE WHEN @i_CommServUniqueID = 0 AND TotalSnapshotSize = -1 THEN SnapshotSize ELSE TotalSnapshotSize END), SUM(SnapshotSize),
			SUM(CASE WHEN @i_CommServUniqueID = 0 AND TotalReplicationSize = -1 THEN ReplicationSize ELSE TotalReplicationSize END), SUM(ReplicationSize),
			SUM(CASE WHEN @i_CommServUniqueID = 0 AND TotalVMSockets = -1 THEN VMSockets ELSE TotalVMSockets END), SUM(VMSockets),
			SUM(CASE WHEN @i_CommServUniqueID = 0 AND TotalProtectedVMs = -1 THEN ProtectedVMs ELSE TotalProtectedVMs END), SUM(ProtectedVMs),
			SUM(CASE WHEN @i_CommServUniqueID = 0 AND TotalEndpointUsers = -1 THEN EndpointUsers ELSE TotalEndpointUsers END), SUM(EndpointUsers),
			SUM(CASE WHEN @i_CommServUniqueID = 0 AND TotalSharingUsers = -1 THEN SharingUsers ELSE TotalSharingUsers END), SUM(SharingUsers),
			SUM(CASE WHEN @i_CommServUniqueID = 0 AND TotaleDiscoveryUsers = -1 THEN eDiscoveryUsers ELSE TotaleDiscoveryUsers END), SUM(eDiscoveryUsers),
			SUM(CASE WHEN @i_CommServUniqueID = 0 AND TotalArchivedMailBoxes = -1 THEN ArchivedMailBoxes ELSE TotalArchivedMailBoxes END), SUM(ArchivedMailBoxes),
			SUM(CASE WHEN @i_CommServUniqueID = 0 AND TotalCIObjectsInMillion = -1 THEN CIObjects ELSE TotalCIObjectsInMillion END), SUM(CIObjects)
		FROM #tmpSurveyCLAInfo
	DECLARE @AggrResultTable TABLE (ID INT, Name VARCHAR(256), LogDate DATETIME, Total FLOAT, Used FLOAT, MonthlyGrowthTB FLOAT)
	IF @blLatestSurvey = 1 -- Total Capacity Usage bar chart
	BEGIN
		INSERT INTO @AggrResultTable
			SELECT	1, 'DP Enterprise', LogDate, TotalBackupSize/(1024.0*1024.0), BackupSize/(1024.0*1024.0), NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	2, 'Archive Enterprise', LogDate, TotalArchiveSize/(1024.0*1024.0), ArchiveSize/(1024.0*1024.0), NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	10, 'Snapshot', LogDate, TotalSnapshotSize/(1024.0*1024.0), SnapshotSize/(1024.0*1024.0), NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	11, 'Replication', LogDate, TotalReplicationSize/(1024.0*1024.0), ReplicationSize/(1024.0*1024.0), NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	3, 'VM Sockets', LogDate, TotalVMSockets, VMSockets, NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	4, 'Protected VMs', LogDate, TotalProtectedVMs, ProtectedVMs, NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	5, 'Users', LogDate, TotalEndpointUsers, EndpointUsers, NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	6, 'Sharing Users', LogDate, TotalSharingUsers, SharingUsers, NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	7, 'eDiscovery Users', LogDate, TotaleDiscoveryUsers, eDiscoveryUsers, NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	8, 'Archived MailBoxes', LogDate, TotalArchivedMailBoxes, ArchivedMailBoxes, NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	9, 'CI Objects', LogDate, TotalCIObjectsInMillion, 0.000001*CIObjects, NULL
			FROM	@AggrResultTempTable
		SELECT	@CommCellCount AS 'CommCell Count',
				Name,
				ROUND(Total, 2) AS Total,
				ROUND(Used, 2) AS Used,
				CASE Total
					WHEN 0 THEN 0
					WHEN -1 THEN 100
					ELSE CAST (ROUND((Used*100)/Total, 2) AS DECIMAL(10, 2))
				END AS PercentUsed,
				@LatestLogDate AS LogDate
		FROM	@AggrResultTable
		ORDER BY ID ASC
	END
	ELSE IF @blLatestSurvey = 0 -- Monthly Usage bar chart for a given CommCel
	BEGIN
		INSERT INTO @AggrResultTable
			SELECT	1, 'DP Enterprise', LogDate, TotalBackupSize/(1024.0*1024.0), BackupSize/(1024.0*1024.0), NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	2, 'Archive Enterprise', LogDate, TotalArchiveSize/(1024.0*1024.0), ArchiveSize/(1024.0*1024.0), NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	3, 'Snapshot', LogDate, TotalSnapshotSize/(1024.0*1024.0), SnapshotSize/(1024.0*1024.0), NULL
			FROM	@AggrResultTempTable
		UNION ALL
			SELECT	4, 'Replication', LogDate, TotalReplicationSize/(1024.0*1024.0), ReplicationSize/(1024.0*1024.0), NULL
			FROM	@AggrResultTempTable
		DECLARE @CurrMonth DATE = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)
		DECLARE	@MaxNumOfMonthsforGrowthRate INT = 12
		CREATE TABLE #LeastSquareData (EntityName NVARCHAR(256), X INT, Y FLOAT)
		INSERT INTO #LeastSquareData
		SELECT	Name, DATEDIFF(MONTH, LogDate, @CurrMonth), Used
		FROM	@AggrResultTable
		WHERE	(DATEDIFF(MONTH, LogDate, @CurrMonth) BETWEEN 1 AND @MaxNumOfMonthsforGrowthRate) AND Used > 0
		DELETE	#LeastSquareData
		FROM	#LeastSquareData T INNER JOIN
				(SELECT	EntityName, Max(X) AS MaxX, COUNT(*) AS NumOfPrevData
				FROM	#LeastSquareData
				GROUP BY EntityName
				) S ON T.EntityName = S.EntityName
		WHERE	X = MaxX AND NumOfPrevData > 2 OR NumOfPrevData < 2
		;WITH LeastSquareAvg(EntityName, AvgX, AvgY) AS
		(
			SELECT	EntityName, AVG(X), AVG(Y)
			FROM	#LeastSquareData
			GROUP BY EntityName
		)
		,LeastSquareFit(EntityName, Slope) AS
		(
			SELECT	A.EntityName, SUM((X - AvgX)*(Y - AvgY))/SUM((X - AvgX)*(X - AvgX))
			FROM	LeastSquareAvg A INNER JOIN #LeastSquareData D ON A.EntityName = D.EntityName
			GROUP BY A.EntityName
			HAVING SUM((X - AvgX)*(X - AvgX)) > 0
		)
		UPDATE	@AggrResultTable SET MonthlyGrowthTB = -Slope
		FROM	@AggrResultTable A INNER JOIN LeastSquareFit F ON A.Name = F.EntityName
		DROP TABLE #LeastSquareData
		IF (@i_csvOutput = 0)
		BEGIN
			SELECT	@CommCellCount AS 'CommCell Count',
					Name,
					RIGHT(convert(varchar, LogDate, 106), 8) AS 'X-Value',
					'DATE' AS 'X-Datatype',
					Used AS 'Y-Value',
					'Percentage' AS 'Y-Datatype',
					Name + ' - '
						+ CAST(CAST(CASE Total WHEN 0 THEN 0 WHEN -1 THEN 100 ELSE (Used*100)/Total END AS DECIMAL(30, 2)) AS VARCHAR(10)) + '% Used, Total: '
						+ CAST(CAST(Total AS DECIMAL(30, 2)) AS VARCHAR(20)) + ' TB, Used: '
						+ CAST(CAST(Used  AS DECIMAL(30, 2)) AS VARCHAR(20)) + ' TB, Growth Rate: '
						+ CAST(CAST(ISNULL(MonthlyGrowthTB, 0)*1024.0/30 AS DECIMAL(30, 6)) AS VARCHAR(20)) AS 'Label',
					1 AS 'ChartGroup'
			FROM	@AggrResultTable
		END
		ELSE
		BEGIN
			DECLARE	@i			INT = 0
			DECLARE @dtEnd		DATETIME = null
			DECLARE	@dtBegin	DATETIME = null
			DECLARE	@predictionM	DATETIME = null
				IF object_id('tempdb.dbo.#MonthlyTbl') is not null DROP TABLE #MonthlyTbl
				CREATE TABLE #MonthlyTbl (monthVal date, MonthBeginDT DATETIME, MonthEndDT DATETIME)
				SET @dtBegin	= DATEADD(MONTH, DATEDIFF(MONTH, 0, (select ISNULL(max (logdate),GETDATE()) from @AggrResultTable)), 0)
				set @predictionM = @dtBegin
				SET @dtEnd	= DATEADD(MONTH, 1, @dtBegin)
				SET @i = 0
				WHILE @i < 13
				BEGIN
					INSERT	INTO #MonthlyTbl
					SELECT	@dtBegin, @dtBegin, @dtEnd
					SET @dtEnd	 = @dtBegin
					SET @dtBegin = DATEADD(MONTH, -1, @dtEnd)
					SET @i = (@i + 1)
				END
				CREATE TABLE #MonthlyDATA (monthVal date,VALUE  DECIMAL(30, 2),Name VARCHAR(256),[ID<DONOTSHOW>] INT,)
				INSERT INTO #MonthlyDATA
				SELECT M.monthVal,r.used,case when r.name ='DP Enterprise' then 'Data Protection Enterprise'
											 when r.name ='Archive Enterprise' then 'Data Archive Enterprise'
											 else r.name end
										+ ' (TB)'
										,r.ID
				FROM #MonthlyTbl M LEFT OUTER JOIN
				@AggrResultTable r on
				M.monthVal= r.LogDate
				INSERT INTO #MonthlyDATA
				SELECT r.LogDate,r.total,
											case when r.name ='DP Enterprise' then 'Data Protection Enterprise'
											     when r.name ='Archive Enterprise' then 'Data Archive Enterprise'
											     else r.name end
											  + ' Purchased (TB)'
											  ,r.ID
				FROM #MonthlyTbl M INNER JOIN
				@AggrResultTable r on
				M.monthVal= r.LogDate
				DECLARE @cols AS NVARCHAR(MAX),
					@query  AS NVARCHAR(MAX)
				select @cols = STUFF((SELECT  ',' + QUOTENAME(RIGHT(convert(varchar,monthVal, 106), 8))
									from (select distinct monthVal from #MonthlyDATA) as p
									order by monthVal asc
							FOR XML PATH(''), TYPE
							).value('.', 'NVARCHAR(MAX)')
						,1,1,'')
			set @query = 'SELECT [ID<DONOTSHOW>],Name,' + @cols + ' into #outdata from
						 (
							select value, [monthVal], NAME,[ID<DONOTSHOW>]
							from #MonthlyDATA
						) x
						pivot
						(
							max(value)
							for monthVal in (' + @cols + ')
						) p
			select * from #outdata    WHERE [ID<DONOTSHOW>] IS NOT NULL  order by [ID<DONOTSHOW>]       '
			exec          sp_executesql @query
				drop table #MonthlyDATA
				drop table #MonthlyTbl
	END
	END
	IF (OBJECT_ID('tempdb.dbo.#tmpSurveyCLAInfo') IS NOT NULL)
		DROP TABLE #tmpSurveyCLAInfo
END
DROP TABLE #CommServResults
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptCapacityLicenseSurvey')
	delete from GxQscripts where name = 'RptCapacityLicenseSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCapacityLicenseSurvey')
	delete from GXDBVersions where aliasname = 'RptCapacityLicenseSurvey'
GO

insert into GXDBVersions values(2, 'RptCapacityLicenseSurvey',  '00010022000000000000', 'RptCapacityLicenseSurvey', '00010022000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Rpt_LargeStorageUtil.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Rpt_LargeStorageUtil.sp,v $ $Id: Rpt_LargeStorageUtil.sp,v 1.6 2015/02/11 11:25:05 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: Rpt_LargeStorageUtil <<<'

IF EXISTS (select * from sysobjects where name='Rpt_LargeStorageUtil')
	drop procedure Rpt_LargeStorageUtil
IF EXISTS (select * from GxQscripts where name='Rpt_LargeStorageUtil')
	delete from GxQscripts where name = 'Rpt_LargeStorageUtil'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_LargeStorageUtil')
	delete from GXDBVersions where aliasname = 'Rpt_LargeStorageUtil'
GO
print '... Creating Procedure: Rpt_LargeStorageUtil'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Rpt_LargeStorageUtil
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 136
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
CREATE TABLE #ClientGroupsString (CommservUniqueId INT, ClientId INT, ClientGroups NVARCHAR(1024))
EXEC GetClientGroupsString @i_CommServUniqueID, 0
IF(@blaggregate=1)
BEGIN
	IF @i_CommServUniqueID = 0
	BEGIN
		SELECT TOP(10)	resultView.CommServUniqueId  AS 'CommServ UniqueId',
				resultView.CommCellID AS 'CommCell ID',
				CASE
					WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
					ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
				END AS 'CommCell Name',
				A.ClientName AS 'Client',
				CAST(1.0*SUM(C.TotalDataOnMedia)/1024/1024/1024/1024 AS DECIMAL(32, 3)) AS 'Data Written (TB)'
		FROM	cf_SurveyMonthlyChargeback AS C WITH (NOLOCK)
				INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId)  AS resultView
					ON resultView.SurverResultId = C.SurveyResultId
				INNER JOIN cf_SurveySubclientAssociation A WITH (NOLOCK)
					ON C.CommServUniqueId = A.CommServUniqueId AND C.ClientId = A.ClientId AND C.AppId = A.AppId
		GROUP BY resultView.CommServUniqueId, resultView.CommCellID, resultView.CommServName, resultView.CustomerName, A.ClientName
		ORDER BY 'Data Written (TB)' DESC
	END
	ELSE
	BEGIN
		SELECT TOP(10)
				A.ClientName AS 'Client',
				CAST(1.0*SUM(C.FrontEndSize)/1024/1024/1024/1024 AS DECIMAL(32, 3)) AS 'Front End Size (TB)',
				CAST(1.0*SUM(C.TotalDataOnMedia)/1024/1024/1024/1024 AS DECIMAL(32, 3)) AS 'Data Written (TB)'
		FROM	cf_SurveyMonthlyChargeback AS C WITH (NOLOCK)
				INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId)  AS resultView
					ON resultView.SurverResultId = C.SurveyResultId
				INNER JOIN cf_SurveySubclientAssociation A WITH (NOLOCK)
					ON C.CommServUniqueId = A.CommServUniqueId AND C.ClientId = A.ClientId AND C.AppId = A.AppId
		GROUP BY A.ClientName
		ORDER BY 'Data Written (TB)' DESC
	END
END
ELSE IF @i_CommServUniqueID = 0
BEGIN
		SELECT
				resultView.CommServUniqueId  AS 'CommServ UniqueId',
				resultView.CommCellID AS 'CommCell ID',
				CASE
					WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
					ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
				END AS 'CommCell Name',
				A.ClientName AS 'Client',
				A.AgentName AS 'Agent',
				A.InstanceName	AS 'Instance',
				A.BackupsetName AS 'Backupset',
				A.SubclientName AS 'Subclient',
				CAST(1.0*C.FrontEndSize/1024/1024/1024/1024 AS DECIMAL(32, 3)) AS 'Front End Size (TB)',
				CAST(1.0*C.TotalDataOnMedia/1024/1024/1024/1024 AS DECIMAL(32, 3)) AS 'Data Written (TB)'
		FROM	cf_SurveyMonthlyChargeback AS C WITH (NOLOCK)
				INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId)  AS resultView
					ON resultView.SurverResultId = C.SurveyResultId
				INNER JOIN cf_SurveySubclientAssociation A WITH (NOLOCK)
					ON C.CommServUniqueId = A.CommServUniqueId AND C.ClientId = A.ClientId AND C.AppId = A.AppId
		ORDER BY 'CommCell Name',  'Data Written (TB)' DESC
END
ELSE
BEGIN
		SELECT 	A.ClientName AS 'Client',
				A.AgentName AS 'Agent',
				A.InstanceName	AS 'Instance',
				A.BackupsetName AS 'Backupset',
				A.SubclientName AS 'Subclient',
				CAST(1.0*C.FrontEndSize/1024/1024/1024/1024 AS DECIMAL(32, 3)) AS 'Front End Size (TB)',
				CAST(1.0*C.TotalDataOnMedia/1024/1024/1024/1024 AS DECIMAL(32, 3)) AS 'Data Written (TB)'
		FROM	cf_SurveyMonthlyChargeback AS C WITH (NOLOCK)
				INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId)  AS resultView
					ON resultView.SurverResultId = C.SurveyResultId
				INNER JOIN cf_SurveySubclientAssociation A WITH (NOLOCK)
					ON C.CommServUniqueId = A.CommServUniqueId AND C.ClientId = A.ClientId AND C.AppId = A.AppId
		ORDER BY 'Data Written (TB)' DESC
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Rpt_LargeStorageUtil')
	delete from GxQscripts where name = 'Rpt_LargeStorageUtil'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Rpt_LargeStorageUtil')
	delete from GXDBVersions where aliasname = 'Rpt_LargeStorageUtil'
GO

insert into GXDBVersions values(2, 'Rpt_LargeStorageUtil',  '00010006000000000000', 'Rpt_LargeStorageUtil', '00010006000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptClientJobsCompletingWithError.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptClientJobsCompletingWithError.sp,v $ $Id: RptClientJobsCompletingWithError.sp,v 1.5 2014/07/28 21:47:52 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptClientJobsCompletingWithError <<<'

IF EXISTS (select * from sysobjects where name='RptClientJobsCompletingWithError')
	drop procedure RptClientJobsCompletingWithError
IF EXISTS (select * from GxQscripts where name='RptClientJobsCompletingWithError')
	delete from GxQscripts where name = 'RptClientJobsCompletingWithError'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptClientJobsCompletingWithError')
	delete from GXDBVersions where aliasname = 'RptClientJobsCompletingWithError'
GO
print '... Creating Procedure: RptClientJobsCompletingWithError'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptClientJobsCompletingWithError
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 37
IF @i_CommServUniqueID = 0
BEGIN
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	resultView.CommServGUID AS 'CommServer GUID',
	CASE
		WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
		ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
	END AS 'CommCell Name',
	--ISNULL((CONVERT(VARCHAR(20), csInfo.LogDate, 100) + ' (' + resultView.CommServTimeZone + ')'), 'N/A') AS 'Collection Time',
	CASE
		WHEN resultView.RunningTime = -1 THEN 'N/A'
		ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
	END AS 'Running Time in Seconds',
	--csInfo.ClientId AS 'Client Id',
	csInfo.clientName AS 'Client',
	csInfo.CWEJobCount AS 'Job Count',
	csInfo.LastJobId AS 'Last Job Id',
	csInfo.FailureReason AS 'Failure Reason',
	CASE
		WHEN RIGHT(RTRIM(csInfo.FailureMsgIds ),1) = ';' then SUBSTRING(RTRIM(csInfo.FailureMsgIds ),1,LEN(RTRIM(csInfo.FailureMsgIds ))-1)
		ELSE csInfo.FailureMsgIds END
	AS 'Error Code'
FROM cf_SurveyClientJobsCompletingWithError AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
		AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
		AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
ORDER BY csInfo.LogDate DESC, resultView.CustomerName ASC
END
ELSE
SELECT
	csInfo.CommServUniqueId AS 'CommServ UniqueId',
	--CONVERT(VARCHAR(20), csInfo.LogDate, 100) AS 'Collection Time',
	--csInfo.ClientId AS 'Client Id',
	csInfo.clientName AS 'Client',
	csInfo.CWEJobCount AS 'Job Count',
	csInfo.LastJobId AS 'Last Job Id',
	csInfo.FailureReason AS 'Failure Reason',
	CASE
		WHEN RIGHT(RTRIM(csInfo.FailureMsgIds ),1) = ';' then SUBSTRING(RTRIM(csInfo.FailureMsgIds ),1,LEN(RTRIM(csInfo.FailureMsgIds ))-1)
		ELSE csInfo.FailureMsgIds END
	AS 'Error Code'
FROM cf_SurveyClientJobsCompletingWithError AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
		AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
		AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
ORDER BY csInfo.CWEJobCount DESC
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptClientJobsCompletingWithError')
	delete from GxQscripts where name = 'RptClientJobsCompletingWithError'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptClientJobsCompletingWithError')
	delete from GXDBVersions where aliasname = 'RptClientJobsCompletingWithError'
GO

insert into GXDBVersions values(2, 'RptClientJobsCompletingWithError',  '00010005000000000000', 'RptClientJobsCompletingWithError', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptClientsByJobPriority.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptClientsByJobPriority.sp,v $ $Id: RptClientsByJobPriority.sp,v 1.6 2015/07/06 20:31:48 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptClientsByJobPriority <<<'

IF EXISTS (select * from sysobjects where name='RptClientsByJobPriority')
	drop procedure RptClientsByJobPriority
IF EXISTS (select * from GxQscripts where name='RptClientsByJobPriority')
	delete from GxQscripts where name = 'RptClientsByJobPriority'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptClientsByJobPriority')
	delete from GXDBVersions where aliasname = 'RptClientsByJobPriority'
GO
print '... Creating Procedure: RptClientsByJobPriority'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptClientsByJobPriority
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 34
IF (OBJECT_ID('tempdb.dbo.#tmpClientsByJobPriority') IS NOT NULL)
	DROP TABLE #tmpClientsByJobPriority
CREATE TABLE #tmpClientsByJobPriority(
	CommServUniqueId INTEGER NOT NULL,
	CommCellID VARCHAR(32) NOT NULL,
	CommServIP VARCHAR(256) NOT NULL,
	CommServGUID VARCHAR(256) NOT NULL,
	CustomerName NVARCHAR(256) NOT NULL,
	LogDate DATETIME NOT NULL,
	RunningTime INT NOT NULL,
	CommServTZ NVARCHAR(MAX) NOT NULL,
	JobPriority INTEGER,
	ClientCount BIGINT
)
INSERT INTO #tmpClientsByJobPriority
SELECT
	tmpsurveyxml.CommServUniqueId,
	tmpsurveyxml.CommCellID,
	tmpsurveyxml.CommServIP,
	tmpsurveyxml.CommServGUID,
	tmpsurveyxml.CustomerName,
	tmpsurveyxml.LogDate,
	tmpsurveyxml.RunningTime,
	tmpsurveyxml.CommServTZ,
	csInfo.n.value('@JobPriority','INTEGER') AS JobPriority,
    csInfo.n.value('@ClientCount','BIGINT') AS ClientCount
FROM
	dbo.RptGetSurveyResultsFunc(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId) AS tmpsurveyxml
	CROSS apply tmpsurveyxml.surveyxml.nodes('/ClientJobPriorityInfo') AS csInfo(n)
IF(@blaggregate=1)
SELECT DISTINCT
	'Priority Level : ' + CAST(JobPriority AS VARCHAR(2)) AS 'Job Priority',
	SUM(ClientCount) AS 'Client Count',
	COUNT(CommServUniqueId) AS 'CommCell Count'
FROM #tmpClientsByJobPriority AS info
GROUP BY JobPriority
ELSE
BEGIN
IF @i_CommServUniqueID = 0
BEGIN
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
SELECT
	ccMap.CommServUniqueId AS 'CommServ UniqueId',
	ccMap.CommCellID AS 'CommCell ID',
	ccMap.CommServIP AS 'CommServe IP<HIDDEN>',
	CASE
		WHEN @param_isPrivate = 1 THEN ISNULL(ccMap.CommServName, '')
		ELSE ISNULL(ccMap.CustomerName,'') + ' - ' + ISNULL(ccMap.CommServName, '')
	END AS 'CommCell Name',
	ccMap.CommServGUID AS 'CommServer GUID',
	DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME>',
	ISNULL(info.CommServTZ, '')  AS 'TimeZone',
	CASE
		WHEN info.RunningTime = -1 THEN 'N/A'
		ELSE CAST(info.RunningTime AS VARCHAR(MAX))
	END AS 'Running Time in Seconds',
	'Priority Level : ' + CAST(JobPriority AS VARCHAR(2)) AS 'Job Priority',
	ClientCount AS 'Client Count'
FROM #tmpClientsByJobPriority AS info
	INNER JOIN cf_CommcellIdNameMap AS ccMap
		ON info.CommServUniqueId = ccMap.ID
ORDER BY info.LogDate DESC, info.CustomerName ASC
END
ELSE
SELECT
	info.CommServUniqueId AS 'CommServ UniqueId',
	DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME>',
	CASE
		WHEN info.RunningTime = -1 THEN 'N/A'
		ELSE CAST(info.RunningTime AS VARCHAR(MAX))
	END AS 'Running Time in Seconds',
	'Priority Level : ' + CAST(JobPriority AS VARCHAR(2)) AS 'Job Priority',
	ClientCount AS 'Client Count'
FROM #tmpClientsByJobPriority AS info
ORDER BY info.LogDate DESC, info.CustomerName ASC
END
IF (OBJECT_ID('tempdb.dbo.#tmpClientsByJobPriority') IS NOT NULL)
	DROP TABLE #tmpClientsByJobPriority
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptClientsByJobPriority')
	delete from GxQscripts where name = 'RptClientsByJobPriority'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptClientsByJobPriority')
	delete from GXDBVersions where aliasname = 'RptClientsByJobPriority'
GO

insert into GXDBVersions values(2, 'RptClientsByJobPriority',  '00010006000000000000', 'RptClientsByJobPriority', '00010006000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptClientStatisticsSurvey.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptClientStatisticsSurvey.sp,v $ $Id: RptClientStatisticsSurvey.sp,v 1.11 2014/07/28 21:50:34 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptClientStatisticsSurvey <<<'

IF EXISTS (select * from sysobjects where name='RptClientStatisticsSurvey')
	drop procedure RptClientStatisticsSurvey
IF EXISTS (select * from GxQscripts where name='RptClientStatisticsSurvey')
	delete from GxQscripts where name = 'RptClientStatisticsSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptClientStatisticsSurvey')
	delete from GXDBVersions where aliasname = 'RptClientStatisticsSurvey'
GO
print '... Creating Procedure: RptClientStatisticsSurvey'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptClientStatisticsSurvey
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 8
IF @blaggregate = 1
BEGIN
	DECLARE @nonlaptopClients INTEGER = 0
	DECLARE @laptopclients INTEGER = 0
	SELECT
		@nonlaptopClients  = ISNULL(SUM(csInfo.TotalActiveClients-csInfo.TotalLaptops), 0),
		@laptopclients = ISNULL(SUM(csInfo.TotalLaptops), 0)
	FROM cf_SurveyClientStatisticsInfo AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND resultView.LogDateUTC = csInfo.LogDateUTC
			AND resultView.CommServUniqueId = csInfo.CommServUniqueId
	SELECT 'Laptop Clients' AS [Clients], @laptopclients AS [Count]
	UNION
	SELECT 'Servers' AS [Clients], @nonlaptopClients AS [Count]
END
ELSE
BEGIN
IF @i_CommServUniqueID = 0
BEGIN
	DECLARE @param_isPrivate INT = 0
	SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
	SELECT
		resultView.CommServUniqueId AS 'CommServ UniqueId',
		resultView.CommCellID AS 'CommCell ID',
		resultView.CommServIP AS 'CommServe IP<HIDDEN>',
		CASE
			WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
			ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
		END AS 'CommCell Name',
		ISNULL(csInfo.TotalClients, 0) AS 'Total Clients',
		ISNULL(csInfo.TotalActiveClients, 0) AS 'Active Clients',
		ISNULL(csInfo.TotalLaptops, 0) AS 'Laptop Clients',
		ISNULL(csInfo.TotalDeconfiguredClients, 0) + ISNULL(csInfo.TotalUninstalledClients, 0) AS 'Deconfigured Clients<HIDDEN>',
		ISNULL(csInfo.RestoreonlyClients, 0) AS 'Deconfigured Restoreonly Clients<HIDDEN>',
		ISNULL(csInfo.UninstalledVirtualServerDiscoveredClients, 0) AS 'Virtual Server Discovered Clients'
	FROM cf_SurveyClientStatisticsInfo AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
	ORDER BY 'CommCell Name' ASC
END
ELSE
	SELECT
		csInfo.CommServUniqueId AS 'CommServ UniqueId',
		DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(csInfo.LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME>',
		CASE
			WHEN resultView.RunningTime = -1 THEN 'N/A'
			ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
		END AS 'Running Time in Seconds',
		ISNULL(csInfo.TotalClients, 0) AS 'Total Clients',
		ISNULL(csInfo.TotalActiveClients, 0) AS 'Active Clients',
		ISNULL(csInfo.TotalLaptops, 0) AS 'Laptop Clients',
		ISNULL(csInfo.TotalDeconfiguredClients, 0) + ISNULL(csInfo.TotalUninstalledClients, 0) AS 'Deconfigured Clients<HIDDEN>',
		ISNULL(csInfo.RestoreonlyClients, 0) AS 'Deconfigured Restoreonly Clients<HIDDEN>',
		ISNULL(csInfo.UninstalledVirtualServerDiscoveredClients, 0) AS 'Virtual Server Discovered Clients'
	FROM cf_SurveyClientStatisticsInfo AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
	ORDER BY csInfo.LogDateUTC DESC
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptClientStatisticsSurvey')
	delete from GxQscripts where name = 'RptClientStatisticsSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptClientStatisticsSurvey')
	delete from GXDBVersions where aliasname = 'RptClientStatisticsSurvey'
GO

insert into GXDBVersions values(2, 'RptClientStatisticsSurvey',  '00010011000000000000', 'RptClientStatisticsSurvey', '00010011000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptClientsWithoutSP.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptClientsWithoutSP.sp,v $ $Id: RptClientsWithoutSP.sp,v 1.7 2014/07/28 21:50:12 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptClientsWithoutSP <<<'

IF EXISTS (select * from sysobjects where name='RptClientsWithoutSP')
	drop procedure RptClientsWithoutSP
IF EXISTS (select * from GxQscripts where name='RptClientsWithoutSP')
	delete from GxQscripts where name = 'RptClientsWithoutSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptClientsWithoutSP')
	delete from GXDBVersions where aliasname = 'RptClientsWithoutSP'
GO
print '... Creating Procedure: RptClientsWithoutSP'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptClientsWithoutSP
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
IF(@blaggregate=1)
	RETURN
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 20
IF @i_CommServUniqueID = 0
BEGIN
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	CASE
		WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
		ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
	END AS 'CommCell Name',
	csInfo.TotalClients AS 'Total Client',
	csInfo.ClientsWithoutSP AS 'Clients Without Storage Policy',
	CAST(csInfo.ClientsWithoutSPPercent AS DECIMAL(5, 2)) AS '% Clients Without Storage Policy',
	csInfo.ClientName AS 'Client',
	csInfo.AgentName AS 'Agent',
	csInfo.InstanceName AS 'Instance',
	csInfo.Backupset AS 'Backupset',
	csInfo.Subclient AS 'Subclient'
FROM cf_SurveyClientsWithoutSPInfo AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
ORDER BY 'CommCell Name' ASC,csInfo.clientName
END
ELSE
SELECT
	csInfo.CommServUniqueId AS 'CommServ UniqueId',
	csInfo.ClientName AS 'Client',
	csInfo.AgentName AS 'Agent',
	csInfo.InstanceName AS 'Instance',
	csInfo.Backupset AS 'Backupset',
	csInfo.Subclient AS 'Subclient'
FROM cf_SurveyClientsWithoutSPInfo AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
ORDER BY csInfo.clientName
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptClientsWithoutSP')
	delete from GxQscripts where name = 'RptClientsWithoutSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptClientsWithoutSP')
	delete from GXDBVersions where aliasname = 'RptClientsWithoutSP'
GO

insert into GXDBVersions values(2, 'RptClientsWithoutSP',  '00010007000000000000', 'RptClientsWithoutSP', '00010007000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptCommCellParamAudit.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptCommCellParamAudit.sp,v $ $Id: RptCommCellParamAudit.sp,v 1.4 2014/07/28 21:48:37 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptCommCellParamAudit <<<'

IF EXISTS (select * from sysobjects where name='RptCommCellParamAudit')
	drop procedure RptCommCellParamAudit
IF EXISTS (select * from GxQscripts where name='RptCommCellParamAudit')
	delete from GxQscripts where name = 'RptCommCellParamAudit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommCellParamAudit')
	delete from GXDBVersions where aliasname = 'RptCommCellParamAudit'
GO
print '... Creating Procedure: RptCommCellParamAudit'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptCommCellParamAudit
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @bAggregate INT = 1,
  @i_stdCommServUniqueID INT = 0,
  @i_CommServUniqueID INT = 0,
  @i_PropertyGroup VARCHAR(32) = ''
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 159
-- default is for all properties
DECLARE @i_Category INT = 0
IF		@i_PropertyGroup = 'Global Filters'
	SET @i_Category = 1
ELSE IF	@i_PropertyGroup = 'Job Manager'
	SET @i_Category = 2
ELSE IF	@i_PropertyGroup = 'Media Manager'
	SET @i_Category = 3
ELSE IF	@i_PropertyGroup = 'Browse/Search/Recovery'
	SET @i_Category = 4
IF	@i_stdCommServUniqueID IN (0, @i_CommServUniqueID)
	RETURN
DECLARE @stdCustomerName	VARCHAR(256) = ''
DECLARE @isPrivate 			INT = 0
SELECT	@isPrivate = ISNULL(CAST(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
IF	@isPrivate = 0
	SELECT @stdCustomerName = CustomerName FROM cf_CommcellIdNameMap WHERE ID = @i_stdCommServUniqueID
CREATE	TABLE #LatestResult (CommServId INT, SurveyResultId INT, LogDate DATETIME)
INSERT	INTO #LatestResult
SELECT	CommServUniqueId, SurverResultId, LogDate
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, 0, 1, NULL, NULL, @i_UserId,@i_GroupId)
WHERE	(@stdCustomerName = '' OR CustomerName = @stdCustomerName)
	AND (@i_CommServUniqueID = 0 OR CommServUniqueId IN (@i_stdCommServUniqueID, @i_CommServUniqueID))
CREATE TABLE #DiffParams (
	CommServId INT, Category INT, Property VARCHAR(64), ParamName VARCHAR(256), ParamValue VARCHAR(MAX), stdValue VARCHAR(MAX), DefaultValue VARCHAR(MAX)
)
CREATE TABLE #stdParams  (
	Category INT, Property VARCHAR(64), ParamName VARCHAR(256), ParamValue VARCHAR(MAX), DefaultValue VARCHAR(MAX)
)
INSERT	INTO #stdParams
SELECT	P.Category, P.Property, P.ParamName, P.ParamValue, P.DefaultValue
FROM	cf_SurveyCommCellParams P INNER JOIN #LatestResult R
		ON R.SurveyResultId = P.SurveyResultId AND R.CommServId = @i_stdCommServUniqueID AND @i_Category IN (0, P.Category)
INSERT	INTO #DiffParams
SELECT	R.CommServId, P.Category, P.Property, P.ParamName, P.ParamValue, ISNULL(S.ParamValue, P.DefaultValue), P.DefaultValue
FROM	cf_SurveyCommCellParams P INNER JOIN #LatestResult R
		ON R.SurveyResultId = P.SurveyResultId AND R.CommServId <> @i_stdCommServUniqueID AND @i_Category IN (0, P.Category)
		LEFT OUTER JOIN #stdParams S
		ON P.Category = S.Category AND P.Property = S.Property AND P.ParamName = S.ParamName
WHERE	S.ParamName IS NULL AND P.ParamValue <> P.DefaultValue
	 OR S.ParamName IS NOT NULL AND P.ParamValue <> S.ParamValue
UNION
SELECT	C.CommServId, S.Category, S.Property, S.ParamName, ISNULL(T.ParamValue, S.DefaultValue), S.ParamValue, S.DefaultValue
FROM	#stdParams S
		CROSS JOIN
		(SELECT DISTINCT CommServId FROM #LatestResult WHERE CommServId <> @i_stdCommServUniqueID) C
		LEFT OUTER JOIN
		(SELECT R.CommServId, P.Category, P.Property, P.ParamName, P.ParamValue, P.DefaultValue
		FROM	cf_SurveyCommCellParams P
				INNER JOIN #LatestResult R
				ON R.SurveyResultId = P.SurveyResultId AND R.CommServId <> @i_stdCommServUniqueID AND @i_Category IN (0, P.Category)
		) T ON C.CommServId = T.CommServId AND S.Category = T.Category AND S.Property = T.Property AND S.ParamName = T.ParamName
WHERE	T.ParamName IS NULL AND S.ParamValue <> S.DefaultValue
	 OR T.ParamName IS NOT NULL AND S.ParamValue <> T.ParamValue
DELETE	#DiffParams
FROM	#DiffParams D
		INNER JOIN
		(SELECT CommServId, ParamName FROM #DiffParams
		  WHERE Category = 2 AND Property = 'Job Restart - Enable Total Running Time'
		) T  ON D.CommServId = T.CommServId AND Category = 2 AND D.ParamName = T.ParamName
			AND D.Property IN ('Job Restart - Total Running Time', 'Job Restart - Kill Job if Running Time Expires')
DELETE	#DiffParams
FROM	#DiffParams D
		INNER JOIN
		(SELECT CommServId, Property FROM #DiffParams
		  WHERE Category = 2 AND Property LIKE 'Job Status on Errors - %' AND ParamName = 'Enabled'
		) T ON D.CommServId = T.CommServId AND D.Property = T.Property AND D.ParamName <> 'Enabled'
IF @bAggregate = 1
BEGIN
	DECLARE	@TblSummary TABLE (CommServId INT, GlobalFilters INT, JMParams INT, MMParams INT, BrowseParams INT, AllParams INT)
	INSERT	INTO @TblSummary
	SELECT	P.CommServId, ISNULL([1], 0), ISNULL([2], 0), ISNULL([3], 0), ISNULL([4], 0),
			ISNULL([1], 0) + ISNULL([2], 0) + ISNULL([3], 0) + ISNULL([4], 0)
	FROM	(SELECT	CommServId, Category, COUNT(*) AS Counts
			FROM	#DiffParams
			GROUP BY CommServId, Category) AS S
			PIVOT (MAX(Counts) FOR S.Category IN ([1], [2], [3], [4])) AS P
	SELECT	'All CommCells' AS 'CommCell',
			'' AS 'CommServ UniqueId',
			'' AS 'CommCell ID',
			SUM(GlobalFilters)	AS 'Global Filters',
			SUM(JMParams)		AS 'Job Manager',
			SUM(MMParams)		AS 'Media Manager',
			SUM(BrowseParams)	AS 'Browse/Search/Recovery',
			SUM(AllParams)		AS 'Any',
			'' AS 'Collection Time (Time Zone)',
			-1 AS 'FirstOrder'
	FROM	@TblSummary
	UNION ALL
	SELECT	CASE
				WHEN @isPrivate = 1 THEN CS.CommServName
				ELSE CS.CustomerName + ' - ' + CS.CommServName
			END AS 'CommCell',
			CS.ID			AS 'CommServ UniqueId',
			CS.CommCellID	AS 'CommCell ID',
			D.GlobalFilters	AS 'Global Filters',
			D.JMParams		AS 'Job Manager',
			D.MMParams		AS 'Media Manager',
			D.BrowseParams	AS 'Browse/Search/Recovery',
			D.AllParams		AS 'Any',
			CONVERT(VARCHAR(20), LR.LogDate, 100) + ' (' + CS.CommServTZ + ')' AS 'Collection Time (Time Zone)',
			0				AS 'FirstOrder'
	FROM	@TblSummary D
			INNER JOIN cf_CommcellIdNameMap CS ON D.CommServId = CS.ID
			INNER JOIN #LatestResult LR ON D.CommServId = LR.CommServId
	ORDER BY 'FirstOrder', 'CommCell'
END
ELSE
BEGIN
	IF	@i_Category > 0
		DELETE #DiffParams WHERE Category <> @i_Category
	IF @i_CommServUniqueID = 0
		SELECT	CASE
					WHEN @isPrivate = 1 THEN CS.CommServName
					ELSE CS.CustomerName + ' - ' + CS.CommServName
				END			AS 'CommCell',
				CASE P.Category	WHEN 1 THEN 'Global Filters' WHEN 2 THEN 'Job Manager' WHEN 3 THEN 'Media Manager' WHEN 4 THEN 'Browse/Search/Recovery'
				END	AS 'Category',
				P.Property	AS 'Property',
				P.ParamName	AS 'Parameter',
				CASE WHEN P.ParamName = 'Job Restart - Total Running Time'
					 THEN CAST(CAST(P.ParamValue AS INT)/3600 AS VARCHAR(256)) + ' hr(s) ' + CAST((CAST(P.ParamValue AS INT)%3600)/60 AS VARCHAR(256)) + ' min(s)'
					 ELSE P.ParamValue
				END			AS 'Value',
				CASE WHEN P.ParamName = 'Job Restart - Total Running Time'
					 THEN CAST(CAST(P.stdValue AS INT)/3600 AS VARCHAR(256)) + ' hr(s) ' + CAST((CAST(P.stdValue AS INT)%3600)/60 AS VARCHAR(256)) + ' min(s)'
					 ELSE P.stdValue
				END			AS 'Template Value'
		FROM	#DiffParams P
				INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
		ORDER BY CS.CommServName, P.Category, P.Property, P.ParamName
	ELSE
		SELECT	CASE P.Category	WHEN 1 THEN 'Global Filters' WHEN 2 THEN 'Job Manager' WHEN 3 THEN 'Media Manager' WHEN 4 THEN 'Browse/Search/Recovery'
				END	AS 'Category',
				P.Property	AS 'Property',
				P.ParamName	AS 'Parameter',
				CASE WHEN P.ParamName = 'Job Restart - Total Running Time'
					 THEN CAST(CAST(P.ParamValue AS INT)/3600 AS VARCHAR(256)) + ' hr(s) ' + CAST((CAST(P.ParamValue AS INT)%3600)/60 AS VARCHAR(256)) + ' min(s)'
					 ELSE P.ParamValue
				END			AS 'Value',
				CASE WHEN P.ParamName = 'Job Restart - Total Running Time'
					 THEN CAST(CAST(P.stdValue AS INT)/3600 AS VARCHAR(256)) + ' hr(s) ' + CAST((CAST(P.stdValue AS INT)%3600)/60 AS VARCHAR(256)) + ' min(s)'
					 ELSE P.stdValue
				END			AS 'Template Value'
		FROM	#DiffParams P
		ORDER BY P.Category, P.Property, P.ParamName
END
DROP TABLE #LatestResult
DROP TABLE #stdParams
DROP TABLE #DiffParams
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptCommCellParamAudit')
	delete from GxQscripts where name = 'RptCommCellParamAudit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommCellParamAudit')
	delete from GXDBVersions where aliasname = 'RptCommCellParamAudit'
GO

insert into GXDBVersions values(2, 'RptCommCellParamAudit',  '00010004000000000000', 'RptCommCellParamAudit', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptCommServDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptCommServDetails.sp,v $ $Id: RptCommServDetails.sp,v 1.5 2014/07/28 21:47:22 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptCommServDetails <<<'

IF EXISTS (select * from sysobjects where name='RptCommServDetails')
	drop procedure RptCommServDetails
IF EXISTS (select * from GxQscripts where name='RptCommServDetails')
	delete from GxQscripts where name = 'RptCommServDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommServDetails')
	delete from GXDBVersions where aliasname = 'RptCommServDetails'
GO
print '... Creating Procedure: RptCommServDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptCommServDetails
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 2
IF @i_CommServUniqueID = 0
BEGIN
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
SELECT
	resultView.CommServUniqueId AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	resultView.CommServGUID AS 'CommServer GUID',
	CASE
		WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
		ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
	END AS 'CommCell Name',
	DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(csInfo.LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME>',
	ISNULL(resultView.CommServTimeZone, '')  AS 'TimeZone',
	CASE
		WHEN resultView.RunningTime = -1 THEN 'N/A'
		ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
	END AS 'Running Time in Seconds'--,
	--ISNULL(csInfo.CommServVersion, 'N/A') AS 'CommServ Version',
	--ISNULL(csInfo.QNetRegCount, 0) AS 'CommNet Registration Count'
FROM cf_SurveyCSDetailsInfo AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
ORDER BY csInfo.LogDate DESC, resultView.CustomerName ASC
END
ELSE
SELECT
	csInfo.CommServUniqueId AS 'CommServ UniqueId',
	DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(csInfo.LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME>',
	CASE
		WHEN resultView.RunningTime = -1 THEN 'N/A'
		ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
	END AS 'Running Time in Seconds'--,
	--ISNULL(csInfo.CommServVersion, 'N/A') AS 'CommServ Version',
	--ISNULL(csInfo.QNetRegCount, 0) AS 'CommNet Registration Count'
FROM cf_SurveyCSDetailsInfo AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
ORDER BY csInfo.LogDate DESC
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptCommServDetails')
	delete from GxQscripts where name = 'RptCommServDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommServDetails')
	delete from GXDBVersions where aliasname = 'RptCommServDetails'
GO

insert into GXDBVersions values(2, 'RptCommServDetails',  '00010005000000000000', 'RptCommServDetails', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptCostParam.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptCostParam.sp,v $ $Id: RptCostParam.sp,v 1.5 2014/07/28 21:50:42 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptCostParam <<<'

IF EXISTS (select * from sysobjects where name='RptCostParam')
	drop procedure RptCostParam
IF EXISTS (select * from GxQscripts where name='RptCostParam')
	delete from GxQscripts where name = 'RptCostParam'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCostParam')
	delete from GXDBVersions where aliasname = 'RptCostParam'
GO
print '... Creating Procedure: RptCostParam'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptCostParam
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_CommServUniqueID INT = 0,
  @i_LogDateEnd DATETIME = NULL
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 72
DECLARE @TblSurveyResult TABLE (CommServUniqueId INT, SurveyResultId INT)
IF	ISNULL(@i_LogDateEnd, 0) > 0
	INSERT	INTO @TblSurveyResult
	SELECT	R.CommcellIdNameMap_ID, R.CommservSurveyResults_ID
	FROM	(SELECT	ROW_NUMBER() OVER(PARTITION BY CommcellIdNameMap_ID ORDER BY LogDate DESC) AS RowId, CommcellIdNameMap_ID, CommservSurveyResults_ID
			FROM	cf_CommservSurveyResults WITH (NOLOCK)
			WHERE	QueryId = @i_QueryId AND ShredStatus = 1 AND LogDate < @i_LogDateEnd) R
	WHERE	R.RowId = 1
ELSE
	INSERT	INTO @TblSurveyResult
	SELECT	CommcellIdNameMap_ID, CommservSurveyResults_ID
	FROM	cf_CommservSurveyResults R WITH (NOLOCK)
	WHERE	QueryId = @i_QueryId AND (@i_CommServUniqueId = 0 OR CommcellIdNameMap_ID = @i_CommServUniqueId)
		AND Flags = 1
DECLARE	@l_FrontEndTBCost        FLOAT = 0
DECLARE	@l_DataWrittenCostPerTB  FLOAT = 0
DECLARE	@l_AdminCostPerClient    FLOAT = 0
DECLARE	@l_AdminCostPerSubclient FLOAT = 0
SELECT	@l_FrontEndTBCost        = FrontEndTBCost,
		@l_DataWrittenCostPerTB  = DataWrittenCostPerTB,
		@l_AdminCostPerClient    = AdminCostPerClient,
		@l_AdminCostPerSubclient = AdminCostPerSubclient
FROM	cf_GlobalCostParamView
SELECT 	ccMap.CommServUniqueId AS 'CommServ UniqueId',
		ccMap.CommCellID AS 'CommCell ID',
		ccMap.CommServName AS 'CommServer',
		Result.SurveyResultId AS 'ResultId',
		ISNULL(CostOnFrontEndTB, @l_FrontEndTBCost) AS 'FET (Front End TB)',
		ISNULL(CostOnDataWrittenPerTB, @l_DataWrittenCostPerTB) AS 'Data Written (Media) per TB',
		ISNULL(AdminCostPerClient, @l_AdminCostPerClient) AS 'Per Client',
		ISNULL(AdminCostPerSubclient, @l_AdminCostPerSubclient)  AS 'Per Subclient'
FROM	@TblSurveyResult Result
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, NULL, @i_LogDateEnd,@i_UserId,@i_GroupId)  AS ccMap
			ON Result.CommServUniqueId = ccMap.CommServUniqueId
		LEFT OUTER JOIN cf_SurveyCommCellCostParam AS csInfo WITH (NOLOCK)
			ON Result.CommServUniqueId = csInfo.CommServUniqueId AND Result.SurveyResultId = csInfo.SurveyResultId
			AND (CostOnFrontEndTB > 0 OR CostOnDataWrittenPerTB > 0 OR AdminCostPerClient > 0 OR AdminCostPerSubclient > 0)
ORDER BY ccMap.CommServName, ccMap.CommCellID
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptCostParam')
	delete from GxQscripts where name = 'RptCostParam'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCostParam')
	delete from GXDBVersions where aliasname = 'RptCostParam'
GO

insert into GXDBVersions values(2, 'RptCostParam',  '00010005000000000000', 'RptCostParam', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptDataGrowthTrend.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptDataGrowthTrend.sp,v $ $Id: RptDataGrowthTrend.sp,v 1.6 2015/07/06 20:31:48 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptDataGrowthTrend <<<'

IF EXISTS (select * from sysobjects where name='RptDataGrowthTrend')
	drop procedure RptDataGrowthTrend
IF EXISTS (select * from GxQscripts where name='RptDataGrowthTrend')
	delete from GxQscripts where name = 'RptDataGrowthTrend'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDataGrowthTrend')
	delete from GXDBVersions where aliasname = 'RptDataGrowthTrend'
GO
print '... Creating Procedure: RptDataGrowthTrend'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptDataGrowthTrend
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_IsGraph INT = 0,
  @i_TopN INT = -1,
  @i_CommServUniqueID INT = 0,
  @i_EntityType VARCHAR(64) = 'Agent Type', -- 'Agent Type' or 'Client Group' or 'CommCell' or 'Disk Library' or 'Capacity License Usage' or 'Capacity License Usage by Application'
  @i_EntityName NVARCHAR(256) = NULL, -- NULL for trending chart of total
  @i_GrowthType INT = 0, -- 0 for Media Size, 1 for App Size, 2 for Backup Capacity Usage, 3 for Archive Capacity Usage
  @i_Aggregate INT = 0  -- 1 for Total Aggregate, 3 for CommCell
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @i_QueryId INT = 129 -- Agent Type and CommCell
IF  @i_EntityType = 'Disk Library'
	SET @i_QueryId = 96
ELSE
IF  @i_EntityType = 'Capacity License Usage'
	SET @i_QueryId = 1
ELSE
IF  @i_EntityType = 'Capacity License Usage by Application'
	SET @i_QueryId = 3
CREATE TABLE #MonthTbl (MonthStart DATE)
DECLARE @FirstMonth DATE
DECLARE @CurrMonth DATE = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)
DECLARE	@i INT = 0
DECLARE	@MaxNumOfMonthsforGrowthRate INT = 12
WHILE @i <= 12
BEGIN
	INSERT	INTO #MonthTbl
	SELECT	DATEADD(MONTH, -@i, @CurrMonth)
	SET @i += 1
END
SET @FirstMonth = (SELECT MIN(MonthStart) FROM #MonthTbl)
CREATE TABLE #Results (ResultId INT, CommservUniqueId INT, CommServName NVARCHAR(256), MonthStart DATE)
INSERT	INTO #Results
SELECT	SurverResultId, CommservUniqueId, CommServName, DATEADD(MONTH, DATEDIFF(MONTH, 0, LogDate), 0)
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId)
DELETE #Results WHERE MonthStart < @FirstMonth
CREATE TABLE #EntitySize (
		CommservUniqueId INT, EntityName NVARCHAR(256), MonthStart DATE, AppSizeMB BIGINT, MediaSizeMB BIGINT, UpperLimitMB BIGINT, NumOfClients INT)
CREATE TABLE #Summary (
		CommservUniqueId INT, EntityName NVARCHAR(256), LastMonth DATE, AppSizeMB BIGINT, MediaSizeMB BIGINT, UpperLimitMB BIGINT, NumOfClients INT,
		MonthlyGrowthMB BIGINT, Size6Month BIGINT, Size12Month BIGINT, Size18Month BIGINT)
IF	@i_EntityType = 'Capacity License Usage'
BEGIN
 	INSERT	INTO #EntitySize
	SELECT	R.CommservUniqueId, R.CommServName, U.MonthStart, ArchiveSize, BackupSize, -1, -1
	FROM	cf_SurveyCapacityLicensePeakUsage U
			INNER JOIN #Results R ON U.CommservUniqueId = R.CommservUniqueId AND U.MonthStart >= @FirstMonth
	WHERE	ISNULL(@i_EntityName, '') = '' OR @i_EntityName = R.CommServName
	UPDATE	#EntitySize SET UpperLimitMB = (CASE @i_GrowthType WHEN 2 THEN L.TotalBackupSize ELSE L.TotalArchiveSize END)
	FROM	#EntitySize S
			INNER JOIN #Results R ON S.CommservUniqueId = R.CommservUniqueId
			INNER JOIN cf_SurveyCapacityLicenseUsage L ON L.SurveyResultId = R.ResultId
	WHERE	(CASE @i_GrowthType WHEN 2 THEN L.TotalBackupSize ELSE L.TotalArchiveSize END) >= 0
END
ELSE
IF	@i_EntityType = 'Capacity License Usage by Application'
BEGIN
 	INSERT	INTO #EntitySize
	SELECT	R.CommservUniqueId, CASE WHEN ISNULL(@i_Aggregate, 0) = 3 THEN R.CommServName ELSE L.name END,
			U.MonthStart, ArchiveSize/1024/1024, BackupSize/1024/1024, -1, -1
	FROM	cf_SurveyAgentCapacityPeakUsage U
			INNER JOIN cf_SurveyLicType L ON U.TypeId = L.id
			INNER JOIN #Results R ON U.CommservUniqueId = R.CommservUniqueId AND U.MonthStart >= @FirstMonth
	WHERE	ISNULL(@i_EntityName, '') = '' OR @i_EntityName = L.name
END
ELSE
IF	@i_EntityType = 'Disk Library'
BEGIN
	INSERT	INTO #EntitySize
	SELECT	R.CommservUniqueId, S.LibraryName, S.MonthStart, ISNULL(FreeSpaceMB, -1), ISNULL(UsedSpaceMB, -1), -1, -1
	FROM	cf_SurveyDiskLibraryPeakSize S
			INNER JOIN #Results R ON S.CommservUniqueId = R.CommservUniqueId AND S.MonthStart >= @FirstMonth
	WHERE	ISNULL(@i_EntityName, '') = '' OR @i_EntityName = S.LibraryName
	UPDATE	#EntitySize SET UpperLimitMB = totalSpaceGB*1024
	FROM	#EntitySize S
			INNER JOIN #Results R ON S.CommservUniqueId = R.CommservUniqueId
			INNER JOIN cf_Survey96DiskLibDetails L ON L.SurveyResultId = R.ResultId
	WHERE	totalSpaceGB >= 0
END
ELSE
IF	@i_EntityType = 'Agent Type'
	INSERT	INTO #EntitySize
	SELECT	0, S.AgentName, S.MonthStart, SUM(AppSizeMB), SUM(SizeOnMediaMB), -1, SUM(NumOfClients)
	FROM	cf_SurveyAgentPeakSize S
			INNER JOIN #Results R ON S.CommservUniqueId = R.CommservUniqueId AND S.MonthStart >= @FirstMonth AND S.AppTypeId > 0
	WHERE	ISNULL(@i_EntityName, '') = '' OR @i_EntityName = S.AgentName
	GROUP BY S.AgentName, S.MonthStart
ELSE
IF  @i_EntityType = 'Client Group'
	INSERT	INTO #EntitySize
	SELECT	0, CG.ClientGroupName, S.MonthStart, SUM(AppSizeMB), SUM(SizeOnMediaMB), -1, SUM(NumOfClients)
	FROM	cf_SurveyClientGroupPeakSize S
			INNER JOIN cf_SurveyClientGroup CG ON S.CommservUniqueId = CG.CommservUniqueId AND S.ClientGroupId = S.ClientGroupId
			INNER JOIN #Results R ON S.CommservUniqueId = R.CommservUniqueId AND S.MonthStart >= @FirstMonth
	WHERE	ISNULL(@i_EntityName, '') = '' OR @i_EntityName = CG.ClientGroupName
	GROUP BY CG.ClientGroupName, S.MonthStart
ELSE
IF  @i_EntityType = 'CommCell'
	INSERT	INTO #EntitySize
	SELECT	R.CommservUniqueId, R.CommServName, S.MonthStart, SUM(AppSizeMB), SUM(SizeOnMediaMB), -1, SUM(NumOfClients)
	FROM	cf_SurveyAgentPeakSize S
			INNER JOIN #Results R ON S.CommservUniqueId = R.CommservUniqueId AND S.MonthStart >= @FirstMonth AND S.AppTypeId = 0
	WHERE	ISNULL(@i_EntityName, '') = '' OR @i_EntityName = R.CommServName
	GROUP BY R.CommservUniqueId, R.CommServName, S.MonthStart
IF @i_TopN > 0
BEGIN
	IF @i_EntityType = 'Capacity License Usage by Application'
		DELETE	#EntitySize
		FROM	#EntitySize LEFT OUTER JOIN
			(SELECT TOP (@i_TopN) EntityName
			FROM	(SELECT EntityName, MAX(CASE WHEN @i_GrowthType IN (0,2) THEN MediaSizeMB ELSE AppSizeMB END) AS MaxSizeMB FROM #EntitySize GROUP BY EntityName) S
			ORDER BY MaxSizeMB DESC
			) T ON #EntitySize.EntityName = T.EntityName
		WHERE	T.EntityName IS NULL
	ELSE
		DELETE	#EntitySize
		FROM	#EntitySize LEFT OUTER JOIN
			(SELECT TOP (@i_TopN) CommservUniqueId, EntityName
			FROM	(SELECT CommservUniqueId, EntityName, MAX(CASE WHEN @i_GrowthType IN (0,2) THEN MediaSizeMB ELSE AppSizeMB END) AS MaxSizeMB FROM #EntitySize GROUP BY CommservUniqueId, EntityName) S
			ORDER BY MaxSizeMB DESC
			) T ON #EntitySize.CommservUniqueId = T.CommservUniqueId AND #EntitySize.EntityName = T.EntityName
		WHERE	T.EntityName IS NULL
END
IF	@i_IsGraph = 1
BEGIN
	IF	@i_EntityType = 'Capacity License Usage'
	BEGIN
		IF  @i_Aggregate = 1
			SELECT	M.MonthStart AS 'Month',
					SUM(CASE @i_GrowthType WHEN 2 THEN ISNULL(S.MediaSizeMB, -1) ELSE ISNULL(S.AppSizeMB, -1) END) AS 'Used Capacity<SIZEMB>',
					SUM(ISNULL(S.UpperLimitMB, -1)) AS 'Purchased Capacity<SIZEMB>'
			FROM	#MonthTbl M
					LEFT OUTER JOIN #EntitySize S ON S.MonthStart = M.MonthStart
			GROUP BY M.MonthStart
			ORDER BY 'Month'
		ELSE
			SELECT	M.MonthStart AS 'Month',
					E.EntityName AS 'Entity Name',
					CASE @i_GrowthType WHEN 2 THEN ISNULL(S.MediaSizeMB, -1) ELSE ISNULL(S.AppSizeMB, -1) END AS 'Used Capacity<SIZEMB>',
					ISNULL(S.UpperLimitMB, -1) AS 'Purchased Capacity<SIZEMB>'
			FROM	#MonthTbl M CROSS JOIN (SELECT DISTINCT EntityName FROM #EntitySize) E
					LEFT OUTER JOIN #EntitySize S ON S.MonthStart = M.MonthStart AND S.EntityName = E.EntityName
			ORDER BY 'Month', 'Entity Name'
	END
	ELSE
	IF	@i_EntityType = 'Capacity License Usage by Application'
	BEGIN
		IF  @i_Aggregate = 1
			SELECT	M.MonthStart AS 'Month',
					SUM(CASE @i_GrowthType WHEN 2 THEN ISNULL(S.MediaSizeMB, -1) ELSE ISNULL(S.AppSizeMB, -1) END) AS 'Used Capacity<SIZEMB>'
			FROM	#MonthTbl M
					LEFT OUTER JOIN #EntitySize S ON S.MonthStart = M.MonthStart
			GROUP BY M.MonthStart
			ORDER BY 'Month'
		ELSE
		IF	ISNULL(@i_Aggregate, 0) = 3
			SELECT	M.MonthStart AS 'Month',
					E.EntityName AS 'CommCell Name',
					CASE @i_GrowthType WHEN 2 THEN ISNULL(S.MediaSizeMB, -1) ELSE ISNULL(S.AppSizeMB, -1) END AS 'Used Capacity<SIZEMB>'
			FROM	#MonthTbl M CROSS JOIN (SELECT DISTINCT EntityName FROM #EntitySize) E
					LEFT OUTER JOIN (
					SELECT	MonthStart, EntityName, SUM(MediaSizeMB) AS MediaSizeMB, SUM(AppSizeMB) AS AppSizeMB
					FROM	#EntitySize
					GROUP BY MonthStart, EntityName
					) S ON S.MonthStart = M.MonthStart AND S.EntityName = E.EntityName
			ORDER BY 'Month', 'CommCell Name'
		ELSE
			SELECT	M.MonthStart AS 'Month',
					E.EntityName AS 'Entity Name',
					CASE @i_GrowthType WHEN 2 THEN ISNULL(S.MediaSizeMB, -1) ELSE ISNULL(S.AppSizeMB, -1) END AS 'Used Capacity<SIZEMB>'
			FROM	#MonthTbl M CROSS JOIN (SELECT DISTINCT EntityName FROM #EntitySize) E
					LEFT OUTER JOIN (
					SELECT	MonthStart, EntityName, SUM(MediaSizeMB) AS MediaSizeMB, SUM(AppSizeMB) AS AppSizeMB
					FROM	#EntitySize
					GROUP BY MonthStart, EntityName
					) S ON S.MonthStart = M.MonthStart AND S.EntityName = E.EntityName
			ORDER BY 'Month', 'Entity Name'
	END
	ELSE
	IF	@i_EntityType = 'Disk Library'
	BEGIN
		IF  @i_Aggregate = 1
			SELECT	M.MonthStart AS 'Month',
					ISNULL(S.MediaSizeMB, -1) AS 'Consumed Space<SIZEMB>',
					ISNULL(S.UpperLimitMB, -1) AS 'Total Space<SIZEMB>'
			FROM	#MonthTbl M
					LEFT OUTER JOIN (
					SELECT	MonthStart, SUM(MediaSizeMB) AS MediaSizeMB, SUM(UpperLimitMB) AS UpperLimitMB
					FROM	#EntitySize
					GROUP BY MonthStart
					) S ON S.MonthStart = M.MonthStart
			ORDER BY 'Month'
		ELSE
			SELECT	M.MonthStart AS 'Month',
					E.EntityName AS 'Entity Name',
					ISNULL(S.MediaSizeMB, -1) AS 'Consumed Space<SIZEMB>',
					ISNULL(S.UpperLimitMB, -1) AS 'Total Space<SIZEMB>'
			FROM	#MonthTbl M CROSS JOIN (SELECT DISTINCT EntityName FROM #EntitySize) E
					LEFT OUTER JOIN (
					SELECT	MonthStart, EntityName, SUM(MediaSizeMB) AS MediaSizeMB, SUM(UpperLimitMB) AS UpperLimitMB
					FROM	#EntitySize
					GROUP BY MonthStart, EntityName
					) S ON S.MonthStart = M.MonthStart AND S.EntityName = E.EntityName
			ORDER BY 'Month', 'Entity Name'
	END
	ELSE
	IF  @i_EntityType IN ('Agent Type', 'Client Group', 'CommCell')
	BEGIN
		IF  @i_Aggregate = 1
			SELECT	M.MonthStart AS 'Month',
					ISNULL(S.AppSizeMB, -1) AS 'Protected App Size <SIZEMB>',
					ISNULL(S.MediaSizeMB, -1) AS 'Size on Media<SIZEMB>',
					ISNULL(S.NumOfClients, -1) AS 'Number Of Clients'
			FROM	#MonthTbl M
					LEFT OUTER JOIN (
					SELECT	MonthStart, SUM(AppSizeMB) AS AppSizeMB, SUM(MediaSizeMB) AS MediaSizeMB, SUM(NumOfClients) AS NumOfClients
					FROM	#EntitySize
					GROUP BY MonthStart
					) S ON S.MonthStart = M.MonthStart
			ORDER BY 'Month'
		ELSE
			SELECT	M.MonthStart AS 'Month',
					E.EntityName AS 'Entity Name',
					ISNULL(S.AppSizeMB, -1) AS 'Protected App Size <SIZEMB>',
					ISNULL(S.MediaSizeMB, -1) AS 'Size on Media<SIZEMB>',
					ISNULL(S.NumOfClients, -1) AS 'Number Of Clients'
			FROM	#MonthTbl M CROSS JOIN (SELECT DISTINCT EntityName FROM #EntitySize) E
					LEFT OUTER JOIN (
					SELECT	MonthStart, EntityName, SUM(AppSizeMB) AS AppSizeMB, SUM(MediaSizeMB) AS MediaSizeMB, SUM(NumOfClients) AS NumOfClients
					FROM	#EntitySize
					GROUP BY MonthStart, EntityName
					) S ON S.MonthStart = M.MonthStart AND S.EntityName = E.EntityName
			ORDER BY 'Month', 'Entity Name'
		END
END
ELSE
--IF  @i_IsGraph = 0
BEGIN
	INSERT	INTO #Summary
	SELECT	T.CommservUniqueId, T.EntityName, T.MonthStart, T.AppSizeMB, T.MediaSizeMB, T.UpperLimitMB, NumOfClients, NULL, 0, 0, 0
	FROM	(SELECT	CommservUniqueId, EntityName, MonthStart, AppSizeMB, MediaSizeMB, UpperLimitMB, NumOfClients,
				ROW_NUMBER() OVER (PARTITION BY EntityName ORDER BY MonthStart DESC) AS RowId
			FROM	#EntitySize
			) T
	WHERE	T.RowId = 1
	CREATE TABLE #LeastSquareData (CommservUniqueId INT, EntityName NVARCHAR(256), X INT, Y FLOAT)
	INSERT INTO #LeastSquareData
	SELECT	CommservUniqueId, EntityName, DATEDIFF(MONTH, MonthStart, @CurrMonth),
			CASE WHEN @i_GrowthType IN (1, 3) THEN AppSizeMB ELSE MediaSizeMB END
	FROM	#EntitySize
	WHERE	(DATEDIFF(MONTH, MonthStart, @CurrMonth) BETWEEN 1 AND @MaxNumOfMonthsforGrowthRate)
		AND (CASE WHEN @i_GrowthType IN (1, 3) THEN AppSizeMB ELSE MediaSizeMB END) > 0
	DELETE	#LeastSquareData
	FROM	#LeastSquareData T INNER JOIN
			(SELECT	CommservUniqueId, EntityName, Max(X) AS MaxX, COUNT(*) AS NumOfPrevData
			FROM	#LeastSquareData
			GROUP BY CommservUniqueId, EntityName
			) S ON T.CommservUniqueId = S.CommservUniqueId AND T.EntityName = S.EntityName
	WHERE	X = MaxX AND NumOfPrevData > 2 OR NumOfPrevData < 2
	;WITH LeastSquareAvg(CommservUniqueId, EntityName, AvgX, AvgY) AS
	(
		SELECT	CommservUniqueId, EntityName, AVG(X), AVG(Y)
		FROM	#LeastSquareData
		GROUP BY CommservUniqueId, EntityName
	)
	,LeastSquareFit(CommservUniqueId, EntityName, Slope) AS
	(
		SELECT	A.CommservUniqueId, A.EntityName, SUM((X - AvgX)*(Y - AvgY))/SUM((X - AvgX)*(X - AvgX))
		FROM	LeastSquareAvg A INNER JOIN #LeastSquareData D ON A.CommservUniqueId = D.CommservUniqueId AND A.EntityName = D.EntityName
		GROUP BY A.CommservUniqueId, A.EntityName
		HAVING SUM((X - AvgX)*(X - AvgX)) > 0
	)
	UPDATE	#Summary SET MonthlyGrowthMB = -Slope
	FROM	LeastSquareFit F
	WHERE	#Summary.CommservUniqueId = F.CommservUniqueId AND #Summary.EntityName = F.EntityName
	DROP TABLE #LeastSquareData
	IF @i_GrowthType IN (1, 3)
		UPDATE	#Summary
		SET		Size6Month  = CASE WHEN (AppSizeMB + MonthlyGrowthMB*6) > 0 THEN AppSizeMB + MonthlyGrowthMB*6  ELSE 0 END,
				Size12Month = CASE WHEN (AppSizeMB + MonthlyGrowthMB*12)> 0 THEN AppSizeMB + MonthlyGrowthMB*12 ELSE 0 END,
				Size18Month = CASE WHEN (AppSizeMB + MonthlyGrowthMB*18)> 0 THEN AppSizeMB + MonthlyGrowthMB*18 ELSE 0 END
	ELSE
		UPDATE	#Summary
		SET		Size6Month  = CASE WHEN (MediaSizeMB + MonthlyGrowthMB*6) > 0 THEN MediaSizeMB + MonthlyGrowthMB*6  ELSE 0 END,
				Size12Month = CASE WHEN (MediaSizeMB + MonthlyGrowthMB*12)> 0 THEN MediaSizeMB + MonthlyGrowthMB*12 ELSE 0 END,
				Size18Month = CASE WHEN (MediaSizeMB + MonthlyGrowthMB*18)> 0 THEN MediaSizeMB + MonthlyGrowthMB*18 ELSE 0 END
	-- Add a row for Total
	IF  @i_EntityType <> 'Client Group'
		INSERT	INTO #Summary
		SELECT	0, 'Total', MAX(LastMonth), SUM(AppSizeMB), SUM(MediaSizeMB), SUM(UpperLimitMB), SUM(NumOfClients),
				SUM(ISNULL(MonthlyGrowthMB,0)), SUM(Size6Month), SUM(Size12Month), SUM(Size18Month)
		FROM	#Summary
	IF	@i_EntityType = 'Capacity License Usage'
		SELECT	CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
				EntityName  AS 'CommCell',
				LastMonth   AS 'Last Month',
				UpperLimitMB AS 'Purchased Capacity<SIZEMB>',
				CASE @i_GrowthType WHEN 2 THEN ISNULL(MediaSizeMB, 0) ELSE ISNULL(AppSizeMB, 0) END AS 'Used Capacity<SIZEMB>',
				CAST(1.0*ISNULL(MonthlyGrowthMB, 0)/1024/1024 AS DECIMAL(32, 3)) AS 'Growth Rate (TB/Month)',
				Size6Month  AS 'Size After 6 Months<SIZEMB>',
				Size12Month AS 'Size After 12 Months<SIZEMB>',
				Size18Month AS 'Size After 18 Months<SIZEMB>',
				CASE WHEN (Size6Month -UpperLimitMB) > 0 THEN (Size6Month -UpperLimitMB) ELSE 0 END AS 'Purchase After 6 Months<SIZEMB><HIDDEN>',
				CASE WHEN (Size12Month-UpperLimitMB) > 0 THEN (Size12Month-UpperLimitMB) ELSE 0 END AS 'Purchase After 12 Months<SIZEMB><HIDDEN>',
				CASE WHEN (Size18Month-UpperLimitMB) > 0 THEN (Size18Month-UpperLimitMB) ELSE 0 END AS 'Purchase After 18 Months<SIZEMB><HIDDEN>'
		FROM	#Summary
		ORDER BY 'Used Capacity<SIZEMB>' DESC
	ELSE
	IF	@i_EntityType = 'Capacity License Usage by Application'
	BEGIN
		IF	ISNULL(@i_Aggregate, 0) = 3
			SELECT	CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
					EntityName  AS 'CommCell Name',
					LastMonth   AS 'Last Month',
					CASE @i_GrowthType WHEN 2 THEN ISNULL(MediaSizeMB, 0) ELSE ISNULL(AppSizeMB, 0) END AS 'Used Capacity<SIZEMB>',
					CAST(1.0*ISNULL(MonthlyGrowthMB, 0)/1024/1024 AS DECIMAL(32, 3)) AS 'Growth Rate (TB/Month)',
					Size6Month  AS 'Size After 6 Months<SIZEMB>',
					Size12Month AS 'Size After 12 Months<SIZEMB>',
					Size18Month AS 'Size After 18 Months<SIZEMB>'
			FROM	#Summary
			ORDER BY 'Used Capacity<SIZEMB>' DESC
		ELSE
			SELECT	CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
					EntityName  AS 'Application',
					LastMonth   AS 'Last Month',
					CASE @i_GrowthType WHEN 2 THEN ISNULL(MediaSizeMB, 0) ELSE ISNULL(AppSizeMB, 0) END AS 'Used Capacity<SIZEMB>',
					CAST(1.0*ISNULL(MonthlyGrowthMB, 0)/1024/1024 AS DECIMAL(32, 3)) AS 'Growth Rate (TB/Month)',
					Size6Month  AS 'Size After 6 Months<SIZEMB>',
					Size12Month AS 'Size After 12 Months<SIZEMB>',
					Size18Month AS 'Size After 18 Months<SIZEMB>'
			FROM	#Summary
			ORDER BY 'Used Capacity<SIZEMB>' DESC
	END
	ELSE
	IF	@i_EntityType = 'Disk Library'
		SELECT	S.CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
				ISNULL(R.CommServName, '') AS 'CommCell Name',
				EntityName  AS 'Library Name',
				LastMonth   AS 'Last Month',
				UpperLimitMB AS 'Total Space<SIZEMB>',
				MediaSizeMB AS 'Consumed Space<SIZEMB>',
				CAST(1.0*ISNULL(MonthlyGrowthMB, 0)/1024/1024 AS DECIMAL(32, 3)) AS 'Growth Rate (TB/Month)',
				Size6Month  AS 'Size After 6 Months<SIZEMB>',
				Size12Month AS 'Size After 12 Months<SIZEMB>',
				Size18Month AS 'Size After 18 Months<SIZEMB>',
				CASE WHEN (Size6Month -UpperLimitMB) > 0 THEN (Size6Month -UpperLimitMB) ELSE 0 END AS 'Purchase After 6 Months<SIZEMB><HIDDEN>',
				CASE WHEN (Size12Month-UpperLimitMB) > 0 THEN (Size12Month-UpperLimitMB) ELSE 0 END AS 'Purchase After 12 Months<SIZEMB><HIDDEN>',
				CASE WHEN (Size18Month-UpperLimitMB) > 0 THEN (Size18Month-UpperLimitMB) ELSE 0 END AS 'Purchase After 18 Months<SIZEMB><HIDDEN>'
		FROM	#Summary S LEFT OUTER JOIN #Results R ON S.CommservUniqueId = R.CommservUniqueId
		ORDER BY 'Consumed Space<SIZEMB>' DESC
	ELSE
	IF	@i_EntityType = 'Agent Type'
		SELECT	CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
				EntityName  AS 'Agent Name',
				LastMonth   AS 'Last Month',
				NumOfClients AS 'Number of Clients',
				AppSizeMB AS 'Protected App Size<SIZEMB>',
				MediaSizeMB AS 'Size on Media<SIZEMB>',
				CAST(1.0*ISNULL(MonthlyGrowthMB, 0)/1024/1024 AS DECIMAL(32, 3)) AS 'Growth Rate (TB/Month)',
				Size6Month  AS 'Size After 6 Months<SIZEMB>',
				Size12Month AS 'Size After 12 Months<SIZEMB>',
				Size18Month AS 'Size After 18 Months<SIZEMB>'
		FROM	#Summary
		ORDER BY 'Size on Media<SIZEMB>' DESC
	ELSE
	IF  @i_EntityType = 'Client Group'
		SELECT	CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
				EntityName  AS 'Client Group',
				LastMonth   AS 'Last Month',
				NumOfClients AS 'Number of Clients',
				AppSizeMB AS 'Protected App Size<SIZEMB>',
				MediaSizeMB AS 'Size on Media<SIZEMB>',
				CAST(1.0*ISNULL(MonthlyGrowthMB, 0)/1024/1024 AS DECIMAL(32, 3)) AS 'Growth Rate (TB/Month)',
				Size6Month  AS 'Size After 6 Months<SIZEMB>',
				Size12Month AS 'Size After 12 Months<SIZEMB>',
				Size18Month AS 'Size After 18 Months<SIZEMB>'
		FROM	#Summary
		ORDER BY 'Size on Media<SIZEMB>' DESC
	ELSE
	IF  @i_EntityType = 'CommCell'
		SELECT	CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
				EntityName  AS 'CommCell',
				LastMonth   AS 'Last Month',
				NumOfClients AS 'Number of Clients',
				AppSizeMB AS 'Protected App Size<SIZEMB>',
				MediaSizeMB AS 'Size on Media<SIZEMB>',
				CAST(1.0*ISNULL(MonthlyGrowthMB, 0)/1024/1024 AS DECIMAL(32, 3)) AS 'Growth Rate (TB/Month)',
				Size6Month  AS 'Size After 6 Months<SIZEMB>',
				Size12Month AS 'Size After 12 Months<SIZEMB>',
				Size18Month AS 'Size After 18 Months<SIZEMB>'
		FROM	#Summary
		ORDER BY 'Size on Media<SIZEMB>' DESC
END
DROP TABLE #Results
DROP TABLE #Summary
DROP TABLE #MonthTbl
DROP TABLE #EntitySize
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptDataGrowthTrend')
	delete from GxQscripts where name = 'RptDataGrowthTrend'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDataGrowthTrend')
	delete from GXDBVersions where aliasname = 'RptDataGrowthTrend'
GO

insert into GXDBVersions values(2, 'RptDataGrowthTrend',  '00010006000000000000', 'RptDataGrowthTrend', '00010006000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptDeDupDeletedAFCount.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptDeDupDeletedAFCount.sp,v $ $Id: RptDeDupDeletedAFCount.sp,v 1.7 2014/07/28 21:47:28 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptDeDupDeletedAFCount <<<'

IF EXISTS (select * from sysobjects where name='RptDeDupDeletedAFCount')
	drop procedure RptDeDupDeletedAFCount
IF EXISTS (select * from GxQscripts where name='RptDeDupDeletedAFCount')
	delete from GxQscripts where name = 'RptDeDupDeletedAFCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDeDupDeletedAFCount')
	delete from GXDBVersions where aliasname = 'RptDeDupDeletedAFCount'
GO
print '... Creating Procedure: RptDeDupDeletedAFCount'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptDeDupDeletedAFCount
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 35
IF(@blaggregate=1 AND @i_CommServUniqueID <> 0)
	RETURN
IF(@blaggregate=1)
BEGIN
	IF @i_CommServUniqueID = 0
	BEGIN
		DECLARE @tmpCount TABLE(CSUID INT, DeletedAFCount BIGINT)
		INSERT INTO @tmpCount
		SELECT
			resultView.CommServUniqueId  AS 'CommServ UniqueId',
			csInfo.DeletedAFCount AS 'DeletedAFCount'
		FROM cf_SurveyDeDupDeletedAFCount AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.SurverResultId = csInfo.SurveyResultId
				AND csInfo.DeletedAFCount > 20000
		DECLARE @range0 INT = 0
		DECLARE @range1 INT = 0
		DECLARE @range2 INT = 0
		DECLARE @range3 INT = 0
		SELECT @range0 = COUNT(DISTINCT CSUID) FROM @tmpCount WHERE DeletedAFCount < 25000
		SELECT @range1 = COUNT(DISTINCT CSUID) FROM @tmpCount WHERE DeletedAFCount >= 25000 AND DeletedAFCount < 50000
		SELECT @range2 = COUNT(DISTINCT CSUID) FROM @tmpCount WHERE DeletedAFCount >= 50000 AND DeletedAFCount < 150000
		SELECT @range1 = COUNT(DISTINCT CSUID) FROM @tmpCount WHERE DeletedAFCount >= 150000
		SELECT '< 25K' AS 'DeletedAFCount', @range0 AS 'CommCell Count'
		UNION
		SELECT '25K To 50K' AS 'DeletedAFCount', @range1 AS 'CommCell Count'
		UNION
		SELECT '50K To 150K' AS 'DeletedAFCount', @range2 AS 'CommCell Count'
		UNION
		SELECT '> 150K' AS 'DeletedAFCount', @range3 AS 'CommCell Count'
	END
END
ELSE
BEGIN
DECLARE @strGood VARCHAR(10) = '1_Good'
DECLARE @strInfo VARCHAR(10) = '2_Info'
DECLARE @strwarning VARCHAR(10) = '3_Warning'
DECLARE @strCritical VARCHAR(10) = '4_Critical'
DECLARE @criticalVal int
DECLARE @warningVal int
SELECT	@warningVal = WarningThreshold,
		@criticalVal =CriticalThreshold
FROM	cf_SurveyHealthParam where queryId = @i_QueryId
IF @i_CommServUniqueID = 0
BEGIN
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	resultView.CommServGUID AS 'CommServer GUID',
	CASE
		WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
		ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
	END AS 'CommCell Name',
	DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(csInfo.LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME>',
	ISNULL(resultView.CommServTimeZone, '')  AS 'TimeZone',
	CASE
		WHEN resultView.RunningTime = -1 THEN 'N/A'
		ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
	END AS 'Running Time in Seconds',
	csInfo.SIDBStoreName AS 'SIDBStoreName',
	csInfo.DeletedAFCount AS 'DeletedAFCount',
	csInfo.SealedOrNot AS 'SealedOrNot',
	csInfo.DDBHost AS 'DDBHost'
FROM cf_SurveyDeDupDeletedAFCount AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND csInfo.DeletedAFCount > 20000
ORDER BY csInfo.DeletedAFCount DESC
END
ELSE
SELECT
	csInfo.CommServUniqueId AS 'CommServ UniqueId',
	csInfo.SIDBStoreName AS 'SIDBStoreName',
	csInfo.DeletedAFCount AS 'DeletedAFCount',
	csInfo.SealedOrNot AS 'SealedOrNot',
	csInfo.DDBHost AS 'DDBHost',
	CASE
		WHEN csInfo.DeletedAFCount > @criticalVal then @strCritical
		WHEN csInfo.DeletedAFCount >= @warningVal AND csInfo.DeletedAFCount <= @criticalVal  then @strWarning
		ELSE @strGood
	END AS 'Status<HEALTH_STATUS>'
FROM cf_SurveyDeDupDeletedAFCount AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND csInfo.DeletedAFCount > 20000
ORDER BY csInfo.DeletedAFCount DESC
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptDeDupDeletedAFCount')
	delete from GxQscripts where name = 'RptDeDupDeletedAFCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDeDupDeletedAFCount')
	delete from GXDBVersions where aliasname = 'RptDeDupDeletedAFCount'
GO

insert into GXDBVersions values(2, 'RptDeDupDeletedAFCount',  '00010007000000000000', 'RptDeDupDeletedAFCount', '00010007000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptDeDupDiskUsage.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptDeDupDiskUsage.sp,v $ $Id: RptDeDupDiskUsage.sp,v 1.5 2014/07/28 21:48:02 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptDeDupDiskUsage <<<'

IF EXISTS (select * from sysobjects where name='RptDeDupDiskUsage')
	drop procedure RptDeDupDiskUsage
IF EXISTS (select * from GxQscripts where name='RptDeDupDiskUsage')
	delete from GxQscripts where name = 'RptDeDupDiskUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDeDupDiskUsage')
	delete from GXDBVersions where aliasname = 'RptDeDupDiskUsage'
GO
print '... Creating Procedure: RptDeDupDiskUsage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptDeDupDiskUsage
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 56
SET @blLatestSurvey = 1 --Always pickup the latest
IF @i_CommServUniqueID = 0
BEGIN
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	resultView.CommServGUID AS 'CommServer GUID',
	CASE
		WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
		ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
	END AS 'CommCell Name',
	--ISNULL((CONVERT(VARCHAR(20), csInfo.LogDate, 100) + ' (' + resultView.CommServTimeZone + ')'), 'N/A') AS 'Collection Time',
	CASE
		WHEN resultView.RunningTime = -1 THEN 'N/A'
		ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
	END AS 'Running Time in Seconds',
	ISNULL(csInfo.DataOnDiskMB, 0) AS 'Data On Disk<SIZEMB>',
	ISNULL(csInfo.DedupedDataMB, 0) AS 'DeDuped Data<SIZEMB>',
	ISNULL(csInfo.FreeDiskSpaceMB, 0) AS 'Free Disk Space<SIZEMB>'
FROM cf_SurveyDeDupDiskUsage AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
		AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
		AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
ORDER BY csInfo.LogDate DESC, resultView.CustomerName, csInfo.DataOnDiskMB, csInfo.DedupedDataMB DESC
END
ELSE
SELECT
	csInfo.CommServUniqueId AS 'CommServ UniqueId',
	--CONVERT(VARCHAR(20), csInfo.LogDate, 100) AS 'Collection Time',
	ISNULL(csInfo.DataOnDiskMB, 0) AS 'Data On Disk<SIZEMB>',
	ISNULL(csInfo.DedupedDataMB, 0) AS 'DeDuped Data<SIZEMB>',
	ISNULL(csInfo.FreeDiskSpaceMB, 0) AS 'Free Disk Space<SIZEMB>'
FROM cf_SurveyDeDupDiskUsage AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
		AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
		AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
ORDER BY csInfo.DataOnDiskMB, csInfo.DedupedDataMB DESC
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptDeDupDiskUsage')
	delete from GxQscripts where name = 'RptDeDupDiskUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDeDupDiskUsage')
	delete from GXDBVersions where aliasname = 'RptDeDupDiskUsage'
GO

insert into GXDBVersions values(2, 'RptDeDupDiskUsage',  '00010005000000000000', 'RptDeDupDiskUsage', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptDeDupRatioBySPCopy.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptDeDupRatioBySPCopy.sp,v $ $Id: RptDeDupRatioBySPCopy.sp,v 1.12 2015/03/11 19:00:28 vmishra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptDeDupRatioBySPCopy <<<'

IF EXISTS (select * from sysobjects where name='RptDeDupRatioBySPCopy')
	drop procedure RptDeDupRatioBySPCopy
IF EXISTS (select * from GxQscripts where name='RptDeDupRatioBySPCopy')
	delete from GxQscripts where name = 'RptDeDupRatioBySPCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDeDupRatioBySPCopy')
	delete from GXDBVersions where aliasname = 'RptDeDupRatioBySPCopy'
GO
print '... Creating Procedure: RptDeDupRatioBySPCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptDeDupRatioBySPCopy
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll,
  @dedupe INT = 1
AS
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 26
IF @blaggregate=1
BEGIN
	IF @dedupe = 1
	BEGIN
	SELECT
		CAST((SUM(csInfo.appSizeGB)*1024.00) AS Decimal(20,2)) AS 'Application Size<SIZEMB>',
		CAST((SUM(csInfo.SizeOnMediaGB)*1024.00)AS Decimal(20,2)) AS 'Size on Media<SIZEMB>',
		CASE
			WHEN SUM(csInfo.SizeOnMediaGB)<=0 THEN 'N/A'
			ELSE CAST(
				CAST((100.0*(SUM(csInfo.appSizeGB)-SUM(csInfo.SizeOnMediaGB))/SUM(csInfo.appSizeGB))AS Decimal(20,2))
				AS VARCHAR(MAX))
		END AS 'DeDup Ratio (%)',
		CASE
			WHEN SUM(csInfo.SizeOnMediaGB)<=0 THEN 'N/A'
		ELSE CAST (CAST (( SUM(csInfo.appSizeGB)/SUM(csInfo.SizeOnMediaGB) +0.5) AS INT) AS NVARCHAR(MAX))+': 1'
		END AS 'DeDup Ratio'
	FROM cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId)  AS result
			ON result.SurverResultId = csInfo.SurveyResultId
			AND csInfo.Jobs>0 and ( csInfo.DedupeRatio <>0 or  csInfo.SizeOnMediaGB <>0)
			AND csInfo.DedupeRatio>-1
	RETURN
	END
	IF @dedupe = 0
	BEGIN
	SELECT
		CAST((SUM(csInfo.appSizeGB)*1024.00) AS Decimal(20,2)) AS 'Application Size<SIZEMB>',
		CAST((SUM(csInfo.SizeOnMediaGB)*1024.00)AS Decimal(20,2)) AS 'Size on Media<SIZEMB>'
	FROM cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId)  AS result
			ON result.SurverResultId = csInfo.SurveyResultId
			AND csInfo.DedupeRatio = -1
	RETURN
	END
	IF @dedupe = -1
	BEGIN
	SELECT
		CAST((SUM(csInfo.appSizeGB)/1024.00) AS Decimal(20,2)) AS 'Application Size (TB)',
		CAST((SUM(csInfo.SizeOnMediaGB)/1024.00)AS Decimal(20,2)) AS 'Media Size (TB)'
	FROM cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId)  AS result
			ON result.SurverResultId = csInfo.SurveyResultId
	RETURN
	END
	IF @dedupe = -1
	BEGIN
	SELECT
		CAST((SUM(csInfo.appSizeGB)/1024.00) AS Decimal(20,2)) AS 'Application Size (TB)',
		CAST((SUM(csInfo.SizeOnMediaGB)/1024.00)AS Decimal(20,2)) AS 'Media Size (TB)'
	FROM cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId)  AS result
			ON result.SurverResultId = csInfo.SurveyResultId
	RETURN
	END
END
DECLARE @strGood VARCHAR(10) = '1_Good'
	DECLARE @strInfo VARCHAR(10) = '2_Info'
	DECLARE @strwarning VARCHAR(10) = '3_Warning'
	DECLARE @strCritical VARCHAR(10) = '4_Critical'
	DECLARE @criticalVal int
	DECLARE @warningVal int
		SELECT	@warningVal = WarningThreshold,
				@criticalVal =CriticalThreshold
		FROM	cf_SurveyHealthParam where queryId = @i_QueryId
IF @i_CommServUniqueID = 0
BEGIN
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
	IF @dedupe = 1
	BEGIN
	SELECT
		resultView.CommServUniqueId  AS 'CommServ UniqueId',
		resultView.CommCellID AS 'CommCell ID',
		CASE
			WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
			ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
		END AS 'CommCell Name',
		csInfo.StoragePolicy AS 'Storage Policy',
		csInfo.Copy AS 'Copy',
		--CONVERT(VARCHAR(12), csInfo.WeekStartDate, 107) AS 'Week Start Date',
		CAST ((csInfo.appSizeGB*1024.00) AS Decimal(20,2)) AS 'Application Size<SIZEMB>',
		CAST ((csInfo.SizeOnMediaGB*1024.00) AS Decimal(20,2))AS 'Size on Media<SIZEMB>',
		CAST (csInfo.DedupeRatio AS Decimal(20,2))AS 'DeDup Ratio (%)',
		csInfo.Jobs AS 'Number of Jobs',
		csInfo.Clients AS 'Number of Clients',
		CASE
			WHEN csInfo.SizeOnMediaGB < =0 THEN 'N/A'
			ELSE CAST (CAST (( csInfo.appSizeGB/csInfo.SizeOnMediaGB +0.5) AS INT) AS NVARCHAR(MAX))+': 1'
		END AS 'DeDup Ratio (%)'
	FROM cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND csInfo.Jobs>0 and ( csInfo.DedupeRatio <>0 or  csInfo.SizeOnMediaGB <>0)
			AND csInfo.DedupeRatio > -1
	ORDER BY csInfo.LogDate DESC, resultView.CustomerName ASC
	END
	IF @dedupe = 0
	BEGIN
	SELECT
		resultView.CommServUniqueId  AS 'CommServ UniqueId',
		resultView.CommCellID AS 'CommCell ID',
		CASE
			WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
			ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
		END AS 'CommCell Name',
		csInfo.StoragePolicy AS 'Storage Policy',
		csInfo.Copy AS 'Copy',
		--CONVERT(VARCHAR(12), csInfo.WeekStartDate, 107) AS 'Week Start Date',
		CAST ((csInfo.appSizeGB*1024.00) AS Decimal(20,2)) AS 'Application Size<SIZEMB>',
		CAST ((csInfo.SizeOnMediaGB*1024.00) AS Decimal(20,2))AS 'Size on Media<SIZEMB>',
		csInfo.Jobs AS 'Number of Jobs',
		csInfo.Clients AS 'Number of Clients'
	FROM cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND csInfo.DedupeRatio=-1
		ORDER BY csInfo.LogDate DESC, resultView.CustomerName ASC
	END
END
ELSE
	IF @dedupe = 1
	BEGIN
	SELECT
		csInfo.CommServUniqueId AS 'CommServ UniqueId',
		csInfo.StoragePolicy AS 'Storage Policy',
		csInfo.Copy AS 'Copy',
		--CONVERT(VARCHAR(12), csInfo.WeekStartDate, 107) AS 'Week Start Date',
		CAST ((csInfo.appSizeGB*1024.00) AS Decimal(20,2))AS 'Application Size<SIZEMB>',
		CAST ((csInfo.SizeOnMediaGB*1024.00) AS Decimal(20,2))AS 'Size on Media<SIZEMB>',
		CAST (csInfo.DedupeRatio AS Decimal(20,2))AS 'DeDup Ratio (%)',
		csInfo.Jobs AS 'Number of Jobs',
		csInfo.Clients AS 'Number of Clients',
		CASE
			WHEN csInfo.SizeOnMediaGB < =0 THEN 'N/A'
			ELSE CAST (CAST (( csInfo.appSizeGB/csInfo.SizeOnMediaGB +0.5) AS INT) AS NVARCHAR(MAX))+': 1'
		END AS 'DeDup Ratio'
	FROM cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND csInfo.Jobs>0 and ( csInfo.DedupeRatio <>0 or  csInfo.SizeOnMediaGB <>0)
			AND csInfo.DedupeRatio>-1
	ORDER BY csInfo.DedupeRatio
	END
	IF @dedupe = 0
	BEGIN
	SELECT
		csInfo.CommServUniqueId AS 'CommServ UniqueId',
		csInfo.StoragePolicy AS 'Storage Policy',
		csInfo.Copy AS 'Copy',
		--CONVERT(VARCHAR(12), csInfo.WeekStartDate, 107) AS 'Week Start Date',
		CAST ((csInfo.appSizeGB*1024.00) AS Decimal(20,2))AS 'Application Size<SIZEMB>',
		CAST ((csInfo.SizeOnMediaGB*1024.00) AS Decimal(20,2))AS 'Size on Media<SIZEMB>',
		csInfo.Jobs AS 'Number of Jobs',
		csInfo.Clients AS 'Number of Clients'
	FROM cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND csInfo.DedupeRatio=-1
	ORDER BY csInfo.LogDate DESC
	END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptDeDupRatioBySPCopy')
	delete from GxQscripts where name = 'RptDeDupRatioBySPCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDeDupRatioBySPCopy')
	delete from GXDBVersions where aliasname = 'RptDeDupRatioBySPCopy'
GO

insert into GXDBVersions values(2, 'RptDeDupRatioBySPCopy',  '00010012000000000000', 'RptDeDupRatioBySPCopy', '00010012000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptDeDupStoreConfig.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptDeDupStoreConfig.sp,v $ $Id: RptDeDupStoreConfig.sp,v 1.9 2014/07/29 21:46:08 dscott Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptDeDupStoreConfig <<<'

IF EXISTS (select * from sysobjects where name='RptDeDupStoreConfig')
	drop procedure RptDeDupStoreConfig
IF EXISTS (select * from GxQscripts where name='RptDeDupStoreConfig')
	delete from GxQscripts where name = 'RptDeDupStoreConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDeDupStoreConfig')
	delete from GXDBVersions where aliasname = 'RptDeDupStoreConfig'
GO
print '... Creating Procedure: RptDeDupStoreConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptDeDupStoreConfig
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 61
IF @i_CommServUniqueID = 0
BEGIN
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
SELECT
	sub.CommServUniqueId AS 'CommServ UniqueId',
	sub.CommCellID AS 'CommCell ID',
	sub.CommCellName AS 'CommCell Name',
	sub.MediaAgentName AS 'Media Agent',
	sub.SIDBCountForMA AS 'DDB Count',
	sub.SubstoreCountForMA AS 'DDB Partition Count'
FROM
(
SELECT
	csInfo.CommServUniqueId,
	resultView.CommCellID AS 'CommCellID',
	CASE
		WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
		ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
	END AS 'CommCellName',
	DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(csInfo.LogDate, '1970-01-01 00:00:00')) AS 'CollectionTime',
	ISNULL(resultView.CommServTimeZone, '')  AS 'TimeZone',
	CASE
		WHEN resultView.RunningTime = -1 THEN 'N/A'
		ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
	END AS 'RunningTime',
	csInfo.MediaAgentName,
	csInfo.SIDBCountForMA,
	csInfo.SubstoreCountForMA
FROM cf_SurveyDeDupStoreConfig AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND	csInfo.MediaAgentId > 1
) AS sub
GROUP BY
	sub.CommServUniqueId,
	sub.CommCellID,
	sub.CommCellName,
	sub.CollectionTime,
	sub.TimeZone,
	sub.RunningTime,
	sub.MediaAgentName,
	sub.SIDBCountForMA,
	sub.SubstoreCountForMA
ORDER BY sub.CommCellName ASC
END
ELSE
SELECT
	sub.CommServUniqueId AS 'CommServ UniqueId',
	sub.MediaAgentName AS 'Media Agent',
	sub.SIDBCountForMA AS 'DDB Count',
	sub.SubstoreCountForMA AS 'DDB Partition Count',
	SUM(IsActive) AS 'Active DDB Partitions',
	SUM(IsSpecialSealed) AS 'Sealed SIDBs with 100M Rows'
FROM
(
SELECT
	csInfo.CommServUniqueId,
	csInfo.MediaAgentName,
	csInfo.SIDBCountForMA,
	csInfo.SubstoreCountForMA,
	CASE
		WHEN csInfo.SealedStatus = 'Active' THEN 1
		ELSE 0
	END AS 'IsActive',
	CASE
		WHEN (csInfo.SIDBStoreStatus <> 1 AND csInfo.TotalRecords >= 100000000) THEN 1
		ELSE 0
	END AS 'IsSpecialSealed'
FROM cf_SurveyDeDupStoreConfig AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND	csInfo.MediaAgentId > 1
) AS sub
GROUP BY sub.CommServUniqueId, sub.MediaAgentName, sub.SIDBCountForMA, sub.SubstoreCountForMA
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptDeDupStoreConfig')
	delete from GxQscripts where name = 'RptDeDupStoreConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDeDupStoreConfig')
	delete from GXDBVersions where aliasname = 'RptDeDupStoreConfig'
GO

insert into GXDBVersions values(2, 'RptDeDupStoreConfig',  '00010009000000000000', 'RptDeDupStoreConfig', '00010009000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptDRBkpConfiguration.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptDRBkpConfiguration.sp,v $ $Id: RptDRBkpConfiguration.sp,v 1.9 2015/07/08 20:06:14 pushpendrasingh Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptDRBkpConfiguration <<<'

IF EXISTS (select * from sysobjects where name='RptDRBkpConfiguration')
	drop procedure RptDRBkpConfiguration
IF EXISTS (select * from GxQscripts where name='RptDRBkpConfiguration')
	delete from GxQscripts where name = 'RptDRBkpConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDRBkpConfiguration')
	delete from GXDBVersions where aliasname = 'RptDRBkpConfiguration'
GO
print '... Creating Procedure: RptDRBkpConfiguration'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptDRBkpConfiguration
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 31
IF @i_CommServUniqueID = 0
BEGIN
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	CASE
		WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
		ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
	END AS 'CommCell Name',
	ISNULL(csInfo.ScheduleName,'') As 'Schedule Name',
	csInfo.Schedule As 'Schedule Type',
	csInfo.FullJobsToRetain AS 'Full Jobs to Retain',
	csInfo.IsUingNetworkPath AS 'Is Using Network Path',
	ISNULL(csInfo.LogFilesToBackup, 'None') AS 'Log Files to Backup',
	csInfo.WritingToTape As 'Writing to Tape',
	csInfo.LastJobId AS 'Last Job Id<NumberNA>'
FROM cf_SurveyDRBkpConfiguration AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
ORDER BY 'CommCell Name' ASC, csInfo.Schedule DESC
END
ELSE
SELECT
	csInfo.CommServUniqueId AS 'CommServ UniqueId',
	ISNULL(csInfo.ScheduleName,'') As 'Schedule Name',
	csInfo.Schedule As 'Schedule Type',
	csInfo.FullJobsToRetain AS 'Full Jobs to Retain',
	csInfo.IsUingNetworkPath AS 'Is Using Network Path',
	ISNULL(csInfo.LogFilesToBackup, 'None') AS 'Log Files to Backup',
	csInfo.WritingToTape As 'Writing to Tape',
	csInfo.LastJobId AS 'Last Job Id<NumberNA>'
FROM cf_SurveyDRBkpConfiguration AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
ORDER BY csInfo.Schedule DESC
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptDRBkpConfiguration')
	delete from GxQscripts where name = 'RptDRBkpConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDRBkpConfiguration')
	delete from GXDBVersions where aliasname = 'RptDRBkpConfiguration'
GO

insert into GXDBVersions values(2, 'RptDRBkpConfiguration',  '00010009000000000000', 'RptDRBkpConfiguration', '00010009000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptDRBkpStatus.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptDRBkpStatus.sp,v $ $Id: RptDRBkpStatus.sp,v 1.6 2014/07/28 21:50:40 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptDRBkpStatus <<<'

IF EXISTS (select * from sysobjects where name='RptDRBkpStatus')
	drop procedure RptDRBkpStatus
IF EXISTS (select * from GxQscripts where name='RptDRBkpStatus')
	delete from GxQscripts where name = 'RptDRBkpStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDRBkpStatus')
	delete from GXDBVersions where aliasname = 'RptDRBkpStatus'
GO
print '... Creating Procedure: RptDRBkpStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptDRBkpStatus
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 19
IF @i_CommServUniqueID = 0
BEGIN
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	resultView.CommServGUID AS 'CommServer GUID',
	CASE
		WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
		ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
	END AS 'CommCell Name',
	--ISNULL((CONVERT(VARCHAR(20), csInfo.LogDate, 100) + ' (' + resultView.CommServTimeZone + ')'), 'N/A') AS 'Collection Time',
	CASE
		WHEN resultView.RunningTime = -1 THEN 'N/A'
		ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
	END AS 'Running Time in Seconds',
	ISNULL(csInfo.LastSuccessfulDRTime,-100) AS 'Last Successful DR<MMMDDYYYY>',
	csInfo.SuccessfulDRJobs AS 'Total Success',
	csInfo.FailedDRJobs AS 'Total Failed'
	--csInfo.AverageFullBkpPeriodInDays AS 'Average FULL Backup in Days',
	--csInfo.AverageDiffBkpFreq AS 'Average Differential Backup Frequency'
FROM cf_SurveyDRStats AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
		AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
		AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
ORDER BY csInfo.LogDate DESC, resultView.CustomerName ASC
END
ELSE
SELECT
	csInfo.CommServUniqueId AS 'CommServ UniqueId',
	--CONVERT(VARCHAR(20), csInfo.LogDate, 100) AS 'Collection Time',
	ISNULL(csInfo.LastSuccessfulDRTime,-100) AS 'Last Successful DR<MMMDDYYYY>',
	csInfo.SuccessfulDRJobs AS 'Total Success',
	csInfo.FailedDRJobs AS 'Total Failed'
	--csInfo.AverageFullBkpPeriodInDays AS 'Average FULL Backup in Days',
	--csInfo.AverageDiffBkpFreq AS 'Average Differential Backup Frequency'
FROM cf_SurveyDRStats AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
		AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
		AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
ORDER BY csInfo.LogDate DESC
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptDRBkpStatus')
	delete from GxQscripts where name = 'RptDRBkpStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDRBkpStatus')
	delete from GXDBVersions where aliasname = 'RptDRBkpStatus'
GO

insert into GXDBVersions values(2, 'RptDRBkpStatus',  '00010006000000000000', 'RptDRBkpStatus', '00010006000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptFailingClients.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptFailingClients.sp,v $ $Id: RptFailingClients.sp,v 1.19 2015/05/15 15:50:33 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptFailingClients <<<'

IF EXISTS (select * from sysobjects where name='RptFailingClients')
	drop procedure RptFailingClients
IF EXISTS (select * from GxQscripts where name='RptFailingClients')
	delete from GxQscripts where name = 'RptFailingClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptFailingClients')
	delete from GXDBVersions where aliasname = 'RptFailingClients'
GO
print '... Creating Procedure: RptFailingClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptFailingClients
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll ,
  @i_AppGroup INT = 0,
  @i_BackupType VARCHAR(32) = '' -- '' for all, 'Full' or 'NonFull'
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
SET @i_BackupType = '' --Not separating Full and NonFull any more
DECLARE @i_QueryId BIGINT = 25
IF(@i_AppGroup = 1)
BEGIN
	SELECT 'File System' as 'AppGroup',
	0 as 'No of Clients'
	return
END
IF(@blaggregate=1)
BEGIN
	 SET @i_QueryId  = 146
	SELECT
            3 as 'Strikes<strikeCount>' ,
			ISNULL(sum(ISNULL(Strike3SubClients,0)),0) as 'Subclients<FORMATNUMBERNA>',
            ISNULL(SUM(ISNULL(Strike3Clients,0)),0) as 'Clients<FORMATNUMBERNA>'
      FROM
            cf_CommcellSummary AS csInfo WITH (NOLOCK)
            INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
            ON resultView.SurverResultId = csInfo.SurveyResultId
      UNION
      SELECT
            2 as 'Strikes<strikeCount>',
			ISNULL(sum(ISNULL(Strike2SubClients,0)),0) as 'Subclients<FORMATNUMBERNA>',
            ISNULL(sum(ISNULL(Strike2Clients,0)),0) as 'Clients<FORMATNUMBERNA>'
      FROM
            cf_CommcellSummary AS csInfo WITH (NOLOCK)
            INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
            ON resultView.SurverResultId = csInfo.SurveyResultId
      UNION
      SELECT
            1 as 'Strikes<strikeCount>',
			ISNULL(sum(ISNULL(Strike1SubClients,0)),0) as 'Subclients<FORMATNUMBERNA>',
            ISNULL(sum(ISNULL(Strike1Clients,0)),0) as 'Clients<FORMATNUMBERNA>'
      FROM
            cf_CommcellSummary AS csInfo WITH (NOLOCK)
            INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
            ON resultView.SurverResultId = csInfo.SurveyResultId
      RETURN
END
ELSE
BEGIN
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
IF @i_CommServUniqueID = 0
BEGIN
	 SET @i_QueryId  = 146
     SELECT
			resultView.CommServUniqueId  AS 'CommServ UniqueId',
			resultView.CommCellID AS 'CommCell ID',
			(CASE WHEN @param_isPrivate = 1 THEN '' ELSE ISNULL(resultView.CustomerName, '') + ' - ' END) + ISNULL(resultView.CommServName, '') AS 'CommCell Name',
            ISNULL(Strike1Clients,0) AS 'Strike1 Clients<FORMATNUMBERNA>',
			ISNULL(Strike1SubClients,0) AS 'Strike1 Subclients<FORMATNUMBERNA>',
			ISNULL(Strike2Clients,0) AS 'Strike2 Clients<FORMATNUMBERNA>',
			ISNULL(Strike2SubClients,0) AS 'Strike2 Subclients<FORMATNUMBERNA>',
			ISNULL(Strike3Clients,0) AS 'Strike3 Clients<FORMATNUMBERNA>',
			ISNULL(Strike3SubClients,0) AS 'Strike3 Subclients<FORMATNUMBERNA>'
      FROM
            cf_CommcellSummary AS csInfo WITH (NOLOCK)
            INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
            ON resultView.SurverResultId = csInfo.SurveyResultId
UNION
	SELECT
			-10  AS 'CommServ UniqueId',
			-10 AS 'CommCell ID',
     		'All CommCells' AS 'CommCell Name',
            ISNULL(SUM(ISNULL(Strike1Clients,0)),0) AS 'Strike1 Clients<FORMATNUMBERNA>',
			ISNULL(SUM(ISNULL(Strike1SubClients,0)),0) AS 'Strike1 Subclients<FORMATNUMBERNA>',
			ISNULL(SUM(ISNULL(Strike2Clients,0)),0) AS 'Strike2 Clients<FORMATNUMBERNA>',
			ISNULL(SUM(ISNULL(Strike2SubClients,0)),0) AS 'Strike2 Subclients<FORMATNUMBERNA>',
			ISNULL(SUM(ISNULL(Strike3Clients,0)),0) AS 'Strike3 Clients<FORMATNUMBERNA>',
			ISNULL(SUM(ISNULL(Strike3SubClients,0)),0) AS 'Strike3 Subclients<FORMATNUMBERNA>'
      FROM
            cf_CommcellSummary AS csInfo WITH (NOLOCK)
            INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
            ON resultView.SurverResultId = csInfo.SurveyResultId
	  ORDER BY  (CASE WHEN @param_isPrivate = 1 THEN '' ELSE ISNULL(resultView.CustomerName, '') + ' - ' END) + ISNULL(resultView.CommServName, '')
      RETURN
END
ELSE
SELECT
	(CASE WHEN @param_isPrivate = 1 THEN '' ELSE ISNULL(resultView.CustomerName, '') + ' - ' END) + ISNULL(resultView.CommServName, '') AS 'CommCell Name<HIDDEN>',
	csInfo.StrikeCounts AS 'Strikes<strikeCount>',
	--csInfo.CommServUniqueId AS 'CommServ UniqueId',
	csInfo.clientName AS Client,
	ISNULL(csInfo.PhysicalClientName,csInfo.clientName) AS 'PhysicalClientName<HIDDEN>',
	ISNULL(csInfo.ClientGroupName,'') AS 'Client Group',
	csInfo.AgentName AS 'Agent',
	csInfo.InstanceName AS 'Instance<HIDDEN>',
	csInfo.Backupset AS 'Backupset',
	csInfo.Subclient AS 'Subclient',
	CASE WHEN csInfo.LastJobStartTime IS NULL THEN -50
		ELSE datediff(second, '01/01/1970', csInfo.LastJobStartTime)
		END AS 'Last Failure Time<MMMDDYYYY>',
	CASE WHEN csInfo.LastJobStartTime IS NULL THEN -6
		ELSE datediff(second, '01/01/1970', csInfo.FailedFrom)
		END AS 'Strikes Since<MMMDDYYYY>',
	CASE
		WHEN RIGHT(RTRIM(csInfo.FailureMsgIds),1) = ';' then SUBSTRING(RTRIM(csInfo.FailureMsgIds ),1,LEN(RTRIM(csInfo.FailureMsgIds ))-1)
		ELSE csInfo.FailureMsgIds END
	AS 'Error Code<HIDDEN>',
	REPLACE(csInfo.FailureReason, ';', '\n\n') AS 'Last Job Failure Reason',
	csInfo.LastJobId AS 'Last Failed Job Id<HIDDEN>',
	csInfo.BackupType AS 'Last Job Backup Type<HIDDEN>',
	csInfo.LastJobStatus AS 'Last Job Status<HIDDEN>',
	CS.TotalClientsCount AS 'Total Client Counts<HIDDEN>',
	CS.TotalSubclientCounts AS 'Total Subclient Counts<HIDDEN>'
FROM cf_SurveyFailingClients AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND csInfo.StrikeCounts >= 0
	INNER JOIN ( SELECT resultView.CommServUniqueId,(Strike1Clients+Strike2Clients+Strike3Clients) TotalClientsCount,(Strike1SubClients+Strike2SubClients+Strike3SubClients) TotalSubclientCounts FROM cf_CommcellSummary AS csInfo WITH (NOLOCK)
            INNER JOIN dbo.cf_SurveyResultFuncV1(146, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
            ON resultView.SurverResultId = csInfo.SurveyResultId ) CS
        ON CS.CommServUniqueId = csInfo.CommServUniqueId
WHERE (@i_BackupType = '' OR csInfo.BackupType = @i_BackupType)
ORDER BY csInfo.StrikeCounts DESC
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptFailingClients')
	delete from GxQscripts where name = 'RptFailingClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptFailingClients')
	delete from GXDBVersions where aliasname = 'RptFailingClients'
GO

insert into GXDBVersions values(2, 'RptFailingClients',  '00010019000000000000', 'RptFailingClients', '00010019000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptGUILoginLanguageSurvey.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptGUILoginLanguageSurvey.sp,v $ $Id: RptGUILoginLanguageSurvey.sp,v 1.6 2015/03/17 17:56:35 pushpendrasingh Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptGUILoginLanguageSurvey <<<'

IF EXISTS (select * from sysobjects where name='RptGUILoginLanguageSurvey')
	drop procedure RptGUILoginLanguageSurvey
IF EXISTS (select * from GxQscripts where name='RptGUILoginLanguageSurvey')
	delete from GxQscripts where name = 'RptGUILoginLanguageSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGUILoginLanguageSurvey')
	delete from GXDBVersions where aliasname = 'RptGUILoginLanguageSurvey'
GO
print '... Creating Procedure: RptGUILoginLanguageSurvey'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGUILoginLanguageSurvey
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
DECLARE @i_QueryId BIGINT = 5
IF(@blaggregate=1)
SELECT DISTINCT
	csInfo.LoginLanguage AS 'Language',
	SUM (csInfo.LoginCount) AS 'Login Count',
	COUNT (csInfo.CommServUniqueId) AS 'CommCell Count'
FROM cf_SurveyGUILoginInfo AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
		AND resultView.SurveyID = @i_QueryId
		AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
		AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
		AND csInfo.LoginLanguage IS NOT NULL
GROUP BY csInfo.LoginLanguage
ORDER BY [Login Count] DESC
ELSE
BEGIN
IF @i_CommServUniqueID = 0
BEGIN
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
SELECT
	resultView.CommServUniqueId AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	resultView.CommServGUID AS 'CommServer GUID',
	CASE
		WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
		ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
	END AS 'CommCell Name',
	DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(csInfo.LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME>',
	ISNULL(resultView.CommServTimeZone, '')  AS 'Time Zone',
	CASE
		WHEN resultView.RunningTime = -1 THEN 'N/A'
		ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
	END AS 'Running Time in Seconds',
	ISNULL(csInfo.LoginLanguage, 'N/A') AS 'Language',
	ISNULL(csInfo.LoginCount, 0) as 'Login Count'
FROM cf_SurveyGUILoginInfo AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
		AND csInfo.LoginLanguage IS NOT NULL
ORDER BY csInfo.LogDateUTC DESC, resultView.CustomerName ASC
END
ELSE
SELECT
	csInfo.CommServUniqueId AS 'CommServ UniqueId',
	DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(csInfo.LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME>',
	CASE
		WHEN resultView.RunningTime = -1 THEN 'N/A'
		ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
	END AS 'Running Time in Seconds',
	ISNULL(csInfo.LoginLanguage, 'N/A') AS 'Language',
	ISNULL(csInfo.LoginCount, 0) as 'Login Count'
FROM cf_SurveyGUILoginInfo AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
		AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
		AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
		AND csInfo.LoginLanguage IS NOT NULL
ORDER BY csInfo.LogDateUTC DESC
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGUILoginLanguageSurvey')
	delete from GxQscripts where name = 'RptGUILoginLanguageSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGUILoginLanguageSurvey')
	delete from GXDBVersions where aliasname = 'RptGUILoginLanguageSurvey'
GO

insert into GXDBVersions values(2, 'RptGUILoginLanguageSurvey',  '00010006000000000000', 'RptGUILoginLanguageSurvey', '00010006000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptHealthCardSummary.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptHealthCardSummary.sp,v $ $Id: RptHealthCardSummary.sp,v 1.4 2015/05/28 18:15:04 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptHealthCardSummary <<<'

IF EXISTS (select * from sysobjects where name='RptHealthCardSummary')
	drop procedure RptHealthCardSummary
IF EXISTS (select * from GxQscripts where name='RptHealthCardSummary')
	delete from GxQscripts where name = 'RptHealthCardSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptHealthCardSummary')
	delete from GXDBVersions where aliasname = 'RptHealthCardSummary'
GO
print '... Creating Procedure: RptHealthCardSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptHealthCardSummary
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL
AS
BEGIN
SET NOCOUNT ON
IF object_id('tempdb.dbo.#HealthCheckTbl') is not null DROP TABLE #HealthCheckTbl
IF object_id('tempdb.dbo.#HealthGrpTbl') is not null DROP TABLE #HealthGrpTbl
CREATE TABLE #HealthCheckTbl
(
    CommServUniqueId INT NOT NULL,
    AsOf DATETIME NULL,
    CapacityPlanning VARCHAR(10) NULL,
    Client VARCHAR(10) NULL,
    CommCell VARCHAR(10) NULL,
    DeDuplication VARCHAR(10) NULL,
    IndexingAndSearch VARCHAR(10) NULL,
    Job VARCHAR(10) NULL,
    ScaleStatistics VARCHAR(10) NULL,
    UsageProfile VARCHAR(10) NULL
)
CREATE TABLE #HealthGrpTbl
(
    CommServUniqueId INT,
    GrpId INT,
    GrpName NVARCHAR(256),
    LogDate DATETIME,
    GrpHealthStatus VARCHAR(10)
)
DECLARE @CSUniqueId INT = 0
DECLARE @ErrorString NVARCHAR(MAX)
IF (@i_GroupId > 0)
	DECLARE SurveyResultCur
	CURSOR FOR
	SELECT ID FROM cf_CommcellIdNameMap c WITH (NOLOCK) INNER JOIN cf_CommCellGroupAssoc ca WITH (NOLOCK)
	ON c.ID = ca.CommcellIdNameMap_ID
	INNER JOIN dbo.cf_SurveyResultFuncV1(16, 0, 1, NULL, NULL, @i_UserId, @i_GroupId)AS RESULT ON
	c.ID = RESULT.CommServUniqueId
	and ca.CommCellGroupId = @i_GroupId
	AND (c.CommCellSurveyServices & 1) = 1
ELSE
	DECLARE SurveyResultCur
	CURSOR FOR
	SELECT ID FROM cf_CommcellIdNameMap c WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(16, 0, 1, NULL, NULL, @i_UserId, @i_GroupId)AS RESULT ON
	c.ID = RESULT.CommServUniqueId and (CommCellSurveyServices & 1) = 1
OPEN SurveyResultCur
FETCH FROM SurveyResultCur INTO @CSUniqueId
WHILE @@FETCH_STATUS = 0
BEGIN
	BEGIN TRY
		INSERT INTO #HealthCheckTbl(CommServUniqueId) VALUES (@CSUniqueId)
		DELETE FROM #HealthGrpTbl
		INSERT INTO #HealthGrpTbl
			SELECT
				CommServUniqueId,
				GroupId,
				GroupName,
				MAX(LogDate),
				CASE
					WHEN MAX(Status) = '2_Info' THEN MIN(Status)
					ELSE MAX(Status)
				END
			FROM RptGetServerHealthFunc(@CSUniqueId, @i_UserId, @i_GroupId) AS hr
			GROUP BY CommServUniqueId, GroupId, GroupName
		UPDATE #HealthCheckTbl SET AsOf = LogDate FROM #HealthGrpTbl HC INNER JOIN #HealthCheckTbl H ON GrpId = 1 AND HC.CommServUniqueId = H.CommServUniqueId
		UPDATE #HealthCheckTbl SET CommCell = GrpHealthStatus FROM #HealthGrpTbl HC INNER JOIN #HealthCheckTbl H ON GrpId = 1 AND HC.CommServUniqueId = H.CommServUniqueId
		UPDATE #HealthCheckTbl SET Client = GrpHealthStatus FROM #HealthGrpTbl HC INNER JOIN #HealthCheckTbl H ON GrpId = 2 AND HC.CommServUniqueId = H.CommServUniqueId
		UPDATE #HealthCheckTbl SET Job = GrpHealthStatus FROM #HealthGrpTbl HC INNER JOIN #HealthCheckTbl H ON GrpId = 3 AND HC.CommServUniqueId = H.CommServUniqueId
		UPDATE #HealthCheckTbl SET DeDuplication = GrpHealthStatus FROM #HealthGrpTbl HC INNER JOIN #HealthCheckTbl H ON GrpId = 4 AND HC.CommServUniqueId = H.CommServUniqueId
		UPDATE #HealthCheckTbl SET IndexingAndSearch = GrpHealthStatus FROM #HealthGrpTbl HC INNER JOIN #HealthCheckTbl H ON GrpId = 6 AND HC.CommServUniqueId = H.CommServUniqueId
		UPDATE #HealthCheckTbl SET UsageProfile = GrpHealthStatus FROM #HealthGrpTbl HC INNER JOIN #HealthCheckTbl H ON GrpId = 13 AND HC.CommServUniqueId = H.CommServUniqueId
		UPDATE #HealthCheckTbl SET CapacityPlanning = GrpHealthStatus FROM #HealthGrpTbl HC INNER JOIN #HealthCheckTbl H ON GrpId = 14 AND HC.CommServUniqueId = H.CommServUniqueId
		UPDATE #HealthCheckTbl SET ScaleStatistics = GrpHealthStatus FROM #HealthGrpTbl HC INNER JOIN #HealthCheckTbl H ON GrpId = 18 AND HC.CommServUniqueId = H.CommServUniqueId
	END TRY
	BEGIN CATCH
		DELETE FROM #HealthCheckTbl WHERE CommServUniqueId = @CSUniqueId
		SET @ErrorString = 'RptHealthCardSummary failed for CommServUniqueId [' + CAST(@CSUniqueId AS VARCHAR(20)) + '] with error :: ' + ERROR_MESSAGE()
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END CATCH
    FETCH FROM SurveyResultCur INTO @CSUniqueId
END
CLOSE SurveyResultCur
DEALLOCATE SurveyResultCur
SELECT
	CAST(HC.CommServUniqueId AS VARCHAR(10)) AS 'commCellId<DONOTSHOW>',
    CASE
        WHEN ccMap.CommCellID = -1 THEN 'FFFFFF'
        ELSE dbo.ConvertBigIntToHexStr(ccMap.CommCellID)
    END AS 'CommCell ID<HIDDEN>',
	ccMap.CommServName AS 'CommCell Name<CC_DRILLDOWN>',
    HC.CommCell AS 'CommCell<DOT_STATUS>',
    HC.Client AS 'Client<DOT_STATUS>',
    HC.Job AS 'Job<DOT_STATUS>',
    HC.CapacityPlanning AS 'Capacity Planning<DOT_STATUS>',
    HC.DeDuplication AS 'DeDuplication<DOT_STATUS>',
    HC.IndexingAndSearch AS 'Indexing and Search<DOT_STATUS>',
    HC.ScaleStatistics AS 'Scale Statistics<DOT_STATUS>',
    CONVERT(VARCHAR, HC.AsOf, 100) AS 'As Of',
    HC.AsOf AS 'As_Of_Actual<ALTSORT><As Of><DONOTSHOW>'
FROM #HealthCheckTbl HC INNER JOIN cf_CommcellIdNameMap AS ccMap ON ccMap.ID = HC.CommServUniqueId
ORDER BY ccMap.CommServName
IF object_id('tempdb.dbo.#HealthCheckTbl') is not null DROP TABLE #HealthCheckTbl
IF object_id('tempdb.dbo.#HealthGrpTbl') is not null DROP TABLE #HealthGrpTbl
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'RptHealthCardSummary')
	delete from GxQscripts where name = 'RptHealthCardSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptHealthCardSummary')
	delete from GXDBVersions where aliasname = 'RptHealthCardSummary'
GO

insert into GXDBVersions values(2, 'RptHealthCardSummary',  '00010004000000000000', 'RptHealthCardSummary', '00010004000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptIncrBkpChangeRate.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptIncrBkpChangeRate.sp,v $ $Id: RptIncrBkpChangeRate.sp,v 1.9 2015/07/08 20:06:17 pushpendrasingh Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptIncrBkpChangeRate <<<'

IF EXISTS (select * from sysobjects where name='RptIncrBkpChangeRate')
	drop procedure RptIncrBkpChangeRate
IF EXISTS (select * from GxQscripts where name='RptIncrBkpChangeRate')
	delete from GxQscripts where name = 'RptIncrBkpChangeRate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptIncrBkpChangeRate')
	delete from GXDBVersions where aliasname = 'RptIncrBkpChangeRate'
GO
print '... Creating Procedure: RptIncrBkpChangeRate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptIncrBkpChangeRate
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
BEGIN
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 28
IF @i_CommServUniqueID = 0
BEGIN
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	resultView.CommServGUID AS 'CommServer GUID',
	CASE
		WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
		ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
	END AS 'CommCell Name',
	--ISNULL((CONVERT(VARCHAR(20), csInfo.LogDate, 100) + ' (' + resultView.CommServTimeZone + ')'), 'N/A') AS 'Collection Time',
	CASE
		WHEN resultView.RunningTime = -1 THEN 'N/A'
		ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
	END AS 'Running Time in Seconds',
	--dbo.FormatBytes(csInfo.TotalBkpSize, 'GB') AS 'Total Backup Size',
	--csInfo.TotalJobs AS 'Total Jobs',
	CONVERT(VARCHAR(10),DATEADD(second, csInfo.UxDate, {d '1970-01-01'}),101) AS 'Date',
	csInfo.ChangePercent AS 'Percentage Change',
	CAST((csInfo.TotalChangeInGB*1024.00) AS DECIMAL(32,2)) AS 'Size Change<SIZEMB_NEG>',
	CAST((csInfo.BackupSize*1024.00) AS DECIMAL(32,2)) AS 'Application Size<SIZEMB>'
FROM cf_SurveyIncrBkpChangeRate AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
		AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
		AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
ORDER BY csInfo.LogDate DESC, resultView.CustomerName ASC
END
ELSE
SELECT
	csInfo.CommServUniqueId AS 'CommServ UniqueId',
	--CONVERT(VARCHAR(20), csInfo.LogDate, 100) AS 'Collection Time',
	--dbo.FormatBytes(csInfo.TotalBkpSize, 'GB') AS 'Total Backup Size',
	--csInfo.TotalJobs AS 'Total Jobs',
	CONVERT(VARCHAR(10),DATEADD(second, csInfo.UxDate, {d '1970-01-01'}),101) AS 'Date',
	csInfo.ChangePercent AS 'Percentage Change',
	CAST((csInfo.TotalChangeInGB*1024.00) AS DECIMAL(32,2)) AS 'Size Change<SIZEMB_NEG>',
	CAST((csInfo.BackupSize*1024.00) AS DECIMAL(32,2)) AS 'Application Size<SIZEMB>'
FROM cf_SurveyIncrBkpChangeRate AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
		AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
		AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
ORDER BY CONVERT(VARCHAR(10),DATEADD(second, csInfo.UxDate, {d '1970-01-01'}),101)
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'RptIncrBkpChangeRate')
	delete from GxQscripts where name = 'RptIncrBkpChangeRate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptIncrBkpChangeRate')
	delete from GXDBVersions where aliasname = 'RptIncrBkpChangeRate'
GO

insert into GXDBVersions values(2, 'RptIncrBkpChangeRate',  '00010009000000000000', 'RptIncrBkpChangeRate', '00010009000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptJobDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptJobDetails.sp,v $ $Id: RptJobDetails.sp,v 1.9 2015/07/07 14:17:41 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptJobDetails <<<'

IF EXISTS (select * from sysobjects where name='RptJobDetails')
	drop procedure RptJobDetails
IF EXISTS (select * from GxQscripts where name='RptJobDetails')
	delete from GxQscripts where name = 'RptJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptJobDetails')
	delete from GXDBVersions where aliasname = 'RptJobDetails'
GO
print '... Creating Procedure: RptJobDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptJobDetails
  @i_UserId INT = -1,
  @i_GroupId INT = NULL,
  @i_CommServUniqueID INT = 0,
  @i_TimeRangeBegin DATETIME = NULL,
  @i_TimeRangeEnd DATETIME = NUll,
  @i_JobStatus INT = 0,
  @blaggregate INT = 0
AS
SET NOCOUNT ON
IF @i_TimeRangeBegin IS NULL
	RETURN
DECLARE @FromTime	INT = DATEDIFF(SECOND, '01/01/1970', @i_TimeRangeBegin)
DECLARE @ToTime		INT = 0x7FFFFFFF
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
IF @i_TimeRangeEnd IS NOT NULL
	SET @ToTime = DATEDIFF(SECOND, '01/01/1970', @i_TimeRangeEnd)
DECLARE @i_QueryId BIGINT = 51
DECLARE @i_LatestSurvey INT = 1
IF(@blaggregate=1)
BEGIN
	DECLARE @Day_table TABLE
	(
	servEndDate					DATE
	)
	DECLARE @DailyJobs TABLE
	(
	Completed					BIGINT ,
	CWEOrCWW					BIGINT ,
	Failed                      BIGINT ,
	Killed                      BIGINT ,
	servEndDate					DATE
	)
	;WITH R(N) AS
	(
	SELECT 0
	UNION ALL
	SELECT N+1
	FROM R
	WHERE N < DATEDIFF(DAY, @i_TimeRangeBegin, @i_TimeRangeEnd)
	)
	INSERT INTO @Day_table
	SELECT  DATEADD(DAY,-N,CAST(@i_TimeRangeEnd AS DATE))
	FROM R
	INSERT INTO @DailyJobs
		SELECT
			SUM(case when Status = 1 then 1 else 0 end) AS Completed,
			SUM(case when Status IN (3, 14) then 1 else 0 end) AS CWEOrCWW,
			SUM(case when Status IN (2, 9) then 1 else 0 end) AS Failed,
			SUM(case when Status =4 then 1 else 0 end) AS Killed,
			CAST(dbo.GetDateTime(EndDate) AS DATE) AS EndDate
	FROM	cf_SurveyJobStats J WITH (NOLOCK)
			INNER JOIN cf_SurveySubclients S WITH (NOLOCK)
				ON J.CommservUniqueId = S.CommservUniqueId AND J.AppId = S.AppId
			AND J.EndDate BETWEEN @FromTime AND @ToTime
		   INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, NULL, NULL,@i_UserId,@i_GroupId) AS resultView
		   ON resultView.CommservUniqueId = J.CommservUniqueId
	GROUP BY CAST(dbo.GetDateTime(EndDate) AS DATE)
	SELECT
		dbo.GetUnixTimeBig(d.servEndDate) AS 'Date<MMMDDYYYY>',
		ISNULL(Completed,0) AS 'Completed',
		ISNULL(CWEOrCWW,0) AS 'Completed with Errors or Warnings',
		ISNULL(Failed,0) AS 'Failed',
		ISNULL(Killed,0) AS 'Killed'
	FROM @Day_table  D
	LEFT OUTER JOIN @DailyJobs J
	ON J.servEndDate = D.servEndDate
	 ORDER BY D.servEndDate
END
ELSE
BEGIN
IF (@i_commservUniqueId=0 )
SELECT
	J.CommServUniqueId AS 'CommServ UniqueId',
	CASE
		WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
		ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
	END AS 'CommCell Name',
	ClientName AS 'Client',
		AgentName AS 'Agent',
		InstanceName AS 'Instance<HIDDEN>',
		BackupsetName AS 'Backupset<HIDDEN>',
		SubclientName AS 'Subclient',
		JobId AS 'Job ID',
		StartDate AS 'Start Time<DATETIME>',
		EndDate AS 'End Time<DATETIME>',
		CASE Status
			WHEN 0 THEN 'Running'
			WHEN 1 THEN 'Completed'
			WHEN 2 THEN 'Failed'
			WHEN 3 THEN 'Completed with errors'
			WHEN 4 THEN 'Killed'
			WHEN 5 THEN 'Suspended'
			WHEN 6 THEN 'Interrupted'
			WHEN 7 THEN 'Any Status'
			WHEN 8 THEN 'Skipped'
			WHEN 9 THEN 'Failed To Start'
			WHEN 10 THEN 'Synchronized'
			WHEN 11 THEN 'Not Synchronized'
			WHEN 12 THEN 'Not Attempted'
			WHEN 13 THEN 'Started'
			WHEN 14 THEN 'Completed with warnings'
			WHEN 15 THEN 'System Failed'
			WHEN 16 THEN 'Committed'
			ELSE 'Unknown'
		END AS 'Job Status',
		CASE OpType
			WHEN 4 THEN (CASE WHEN AppTypeId = 67 THEN N'Compliance Archive' ELSE N'Backup' END)
			WHEN 14 THEN N'Synthetic Full'
			WHEN 18 THEN N'Backup 3RD'
			WHEN 59 THEN N'Snap Backup'
			WHEN 60 THEN N'Backup Copy'
			WHEN 65 THEN N'Snap Backup3RD'
			ELSE N'Unknown'
		END AS 'Operation',
		CASE BkpLevel
			WHEN 1 THEN (CASE WHEN AppTypeId IN (45,56,57,58,67,73) THEN N'New Index' ELSE N'Full' END)
			WHEN 2 THEN (CASE WHEN AppTypeId IN (4,5,16,70,81) THEN N'Transaction Log' WHEN AppTypeId = 125 THEN N'Log Only' ELSE N'Incremental' END)
			WHEN 4 THEN (CASE WHEN AppTypeId IN (37,62) THEN N'Delta' ELSE N'Differential' END)
			WHEN 0x40    THEN N'Synthetic Full' WHEN 0x80 THEN N'Synthetic Full' WHEN 0x4000 THEN N'Synthetic Full'
			WHEN 0x100   THEN (CASE WHEN AppTypeId = 104 THEN N'Incremental' ELSE N'Transaction Log' END)
			WHEN 0x200   THEN N'ASR'
			WHEN 0x800   THEN N'Snapshot'
			WHEN 0x1000  THEN N'New Volume Creation'
			WHEN 0x2000  THEN N'Incremental Volume Update'
			WHEN 0x400   THEN N'Offline Full'
			WHEN 0x20000 THEN N'Analysis'
			WHEN 0x40000 THEN N'Discovery'
			ELSE N'Unknown'
		END AS 'Job Type',
		CASE ScanType
			WHEN 1 THEN 'Change Journal'
			WHEN 2 THEN 'Classic'
			WHEN 3 THEN 'Mixed'
			WHEN 4 THEN 'Optimized Scan'
			ELSE 'N/A'
		END AS 'Scan Type<HIDDEN>',
		CAST(DataProtected/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Application Size<SIZEMB>',
		CAST((CASE WHEN DataProtected > 0 AND DataProtected > DataCompressed THEN 100.0*(DataProtected - DataCompressed)/DataProtected ELSE 0 END)
			AS DECIMAL(20,2)) AS 'Compression Rate (%)<HIDDEN>',
		CAST(DataTransferred/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Transferred<SIZEMB><HIDDEN>',
		CAST(DataWritten/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Written<SIZEMB>',
		CAST((CASE WHEN DataProtected > 0 AND DataProtected > DataWritten THEN 100.0*(DataProtected - DataWritten)/DataProtected ELSE 0 END)
			AS DECIMAL(10,2)) AS 'Space Saving (%)<HIDDEN>',
		SizeChangePct AS 'Data Size Change (%)<HIDDEN>',
		TransferTime AS 'Transfer Time<HIDDEN><HHMMSS>',
		CAST((CASE WHEN TransferTime > 0 THEN 3600.0*DataProtected/1024.0/1024.0/1024.0/TransferTime ELSE 0.0 END)
			AS DECIMAL(10,3)) AS 'Throughput (GB/Hour)<HIDDEN>',
		StoragePolicy AS 'Storage Policy<HIDDEN>',
		ClientGroups AS 'Client Groups<HIDDEN>',
		ErrorCode AS 'Error Code<HIDDEN>',
		FailureReason AS 'Failure Reason<HIDDEN>'
FROM	cf_SurveyJobStats J WITH (NOLOCK)
		INNER JOIN cf_SurveySubclients S WITH (NOLOCK) ON J.CommservUniqueId = S.CommservUniqueId AND J.AppId = S.AppId
		AND J.EndDate BETWEEN @FromTime AND @ToTime
  	    INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, NULL, NULL,@i_UserId,@i_GroupId) AS resultView
		  ON resultView.CommservUniqueId = J.CommservUniqueId
	AND (@i_JobStatus = 0
	  OR @i_JobStatus = 1 AND J.Status = 1
	  OR @i_JobStatus = 2 AND J.Status in (2, 9)
	  OR @i_JobStatus = 3 AND J.Status IN (3, 14)
	  OR @i_JobStatus = 4 AND J.Status = 4
	  OR @i_JobStatus = 5 AND J.Status NOT IN (1, 2, 3, 4, 9, 14))
ORDER BY ClientName, AgentName, JobId DESC
ELSE
BEGIN
SELECT	ClientName AS 'Client',
		AgentName AS 'Agent',
		InstanceName AS 'Instance<HIDDEN>',
		BackupsetName AS 'Backupset<HIDDEN>',
		SubclientName AS 'Subclient',
		JobId AS 'Job ID',
		StartDate AS 'Start Time<DATETIME>',
		EndDate AS 'End Time<DATETIME>',
		CASE Status
			WHEN 0 THEN 'Running'
			WHEN 1 THEN 'Completed'
			WHEN 2 THEN 'Failed'
			WHEN 3 THEN 'Completed with errors'
			WHEN 4 THEN 'Killed'
			WHEN 5 THEN 'Suspended'
			WHEN 6 THEN 'Interrupted'
			WHEN 7 THEN 'Any Status'
			WHEN 8 THEN 'Skipped'
			WHEN 9 THEN 'Failed To Start'
			WHEN 10 THEN 'Synchronized'
			WHEN 11 THEN 'Not Synchronized'
			WHEN 12 THEN 'Not Attempted'
			WHEN 13 THEN 'Started'
			WHEN 14 THEN 'Completed with warnings'
			WHEN 15 THEN 'System Failed'
			WHEN 16 THEN 'Committed'
			ELSE 'Unknown'
		END AS 'Job Status',
		CASE OpType
			WHEN 4 THEN (CASE WHEN AppTypeId = 67 THEN N'Compliance Archive' ELSE N'Backup' END)
			WHEN 14 THEN N'Synthetic Full'
			WHEN 18 THEN N'Backup 3RD'
			WHEN 59 THEN N'Snap Backup'
			WHEN 60 THEN N'Backup Copy'
			WHEN 65 THEN N'Snap Backup3RD'
			ELSE N'Unknown'
		END AS 'Operation',
		CASE BkpLevel
			WHEN 1 THEN (CASE WHEN AppTypeId IN (45,56,57,58,67,73) THEN N'New Index' ELSE N'Full' END)
			WHEN 2 THEN (CASE WHEN AppTypeId IN (4,5,16,70,81) THEN N'Transaction Log' WHEN AppTypeId = 125 THEN N'Log Only' ELSE N'Incremental' END)
			WHEN 4 THEN (CASE WHEN AppTypeId IN (37,62) THEN N'Delta' ELSE N'Differential' END)
			WHEN 0x40    THEN N'Synthetic Full' WHEN 0x80 THEN N'Synthetic Full' WHEN 0x4000 THEN N'Synthetic Full'
			WHEN 0x100   THEN (CASE WHEN AppTypeId = 104 THEN N'Incremental' ELSE N'Transaction Log' END)
			WHEN 0x200   THEN N'ASR'
			WHEN 0x800   THEN N'Snapshot'
			WHEN 0x1000  THEN N'New Volume Creation'
			WHEN 0x2000  THEN N'Incremental Volume Update'
			WHEN 0x400   THEN N'Offline Full'
			WHEN 0x20000 THEN N'Analysis'
			WHEN 0x40000 THEN N'Discovery'
			ELSE N'Unknown'
		END AS 'Job Type',
		CASE ScanType
			WHEN 1 THEN 'Change Journal'
			WHEN 2 THEN 'Classic'
			WHEN 3 THEN 'Mixed'
			WHEN 4 THEN 'Optimized Scan'
			ELSE 'N/A'
		END AS 'Scan Type<HIDDEN>',
		CAST(DataProtected/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Application Size<SIZEMB>',
		CAST((CASE WHEN DataProtected > 0 AND DataProtected > DataCompressed THEN 100.0*(DataProtected - DataCompressed)/DataProtected ELSE 0 END)
			AS DECIMAL(20,2)) AS 'Compression Rate (%)<HIDDEN>',
		CAST(DataTransferred/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Transferred<SIZEMB><HIDDEN>',
		CAST(DataWritten/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Written<SIZEMB>',
		CAST((CASE WHEN DataProtected > 0 AND DataProtected > DataWritten THEN 100.0*(DataProtected - DataWritten)/DataProtected ELSE 0 END)
			AS DECIMAL(10,2)) AS 'Space Saving (%)<HIDDEN>',
		SizeChangePct AS 'Data Size Change (%)<HIDDEN>',
		TransferTime AS 'Transfer Time<HIDDEN><HHMMSS>',
		CAST((CASE WHEN TransferTime > 0 THEN 3600.0*DataProtected/1024.0/1024.0/1024.0/TransferTime ELSE 0.0 END)
			AS DECIMAL(10,3)) AS 'Throughput (GB/Hour)<HIDDEN>',
		StoragePolicy AS 'Storage Policy<HIDDEN>',
		ClientGroups AS 'Client Groups<HIDDEN>',
		ErrorCode AS 'Error Code<HIDDEN>',
		FailureReason AS 'Failure Reason<HIDDEN>'
FROM	cf_SurveyJobStats J WITH (NOLOCK)
		INNER JOIN cf_SurveySubclients S WITH (NOLOCK) ON J.CommservUniqueId = S.CommservUniqueId AND J.AppId = S.AppId
		AND J.EndDate BETWEEN @FromTime AND @ToTime
	   INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, NULL, NULL,@i_UserId,@i_GroupId) AS resultView
	   ON resultView.CommservUniqueId = J.CommservUniqueId
	AND (@i_JobStatus = 0
	  OR @i_JobStatus = 1 AND J.Status = 1
	  OR @i_JobStatus = 2 AND J.Status in (2, 9)
	  OR @i_JobStatus = 3 AND J.Status IN (3, 14)
	  OR @i_JobStatus = 4 AND J.Status = 4
	  OR @i_JobStatus = 5 AND J.Status NOT IN (1, 2, 3, 4, 9, 14))
ORDER BY ClientName, AgentName, JobId DESC
END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptJobDetails')
	delete from GxQscripts where name = 'RptJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptJobDetails')
	delete from GXDBVersions where aliasname = 'RptJobDetails'
GO

insert into GXDBVersions values(2, 'RptJobDetails',  '00010009000000000000', 'RptJobDetails', '00010009000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptLargestClientsByBKPSize.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptLargestClientsByBKPSize.sp,v $ $Id: RptLargestClientsByBKPSize.sp,v 1.10 2015/07/06 20:31:48 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptLargestClientsByBKPSize <<<'

IF EXISTS (select * from sysobjects where name='RptLargestClientsByBKPSize')
	drop procedure RptLargestClientsByBKPSize
IF EXISTS (select * from GxQscripts where name='RptLargestClientsByBKPSize')
	delete from GxQscripts where name = 'RptLargestClientsByBKPSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLargestClientsByBKPSize')
	delete from GXDBVersions where aliasname = 'RptLargestClientsByBKPSize'
GO
print '... Creating Procedure: RptLargestClientsByBKPSize'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptLargestClientsByBKPSize
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll,
  @blNeedTop10 INT = 0,
  @i_trend INT = 0,
  @i_client NVARCHAR(MAX) = NULL
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 23
DECLARE @param_isPrivate INT = 0
IF(@blaggregate=1)
BEGIN
	SELECT
		T.Range AS 'Capacity Range<ALTSORT>',
		T.LowerLimitGB AS 'Capacity Range_SORTCOLUMN',
		ClientCount AS [Client Count],
		TotalSizeGB AS [Total Size (GB)],
		CASE WHEN ClientCount > 0 THEN TotalSizeGB/ClientCount ELSE 0 END AS [Average Size (GB)]
	FROM
		(SELECT C.Range, C.LowerLimitGB, SUM(C.ClientCount) AS ClientCount, SUM(C.TotalSizeGB) AS TotalSizeGB
		FROM	cf_SurveyClientCountBySize C
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId,@i_GroupId) R
			ON C.SurveyResultId = R.SurverResultId
		GROUP BY C.Range, C.LowerLimitGB) T
	ORDER BY T.LowerLimitGB
END
ELSE
IF @i_CommServUniqueID = 0
BEGIN
  IF @blNeedTop10=0 -- health check
  BEGIN
  SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
  SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	CASE
		WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
		ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
	END AS 'CommCell Name',
	csInfo.ClientName AS 'Client',
	CAST(ISNULL(csInfo.applicationSizeGB, 0)*1024.00 AS DECIMAL(32,2)) AS 'Application Size<SIZEMB>'--,
 FROM cf_SurveyLargestClientsByBKPSize AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
 ORDER BY csInfo.applicationSizeGB DESC
 END
 ELSE --operation
 BEGIN
 SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
 SELECT TOP(25)
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	CASE
		WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
		ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
	END AS 'CommCell Name',
	csInfo.ClientName AS 'Client',
	CAST(ISNULL(csInfo.applicationSizeGB, 0)*1024.00 AS DECIMAL(32,2)) AS 'Application Size<SIZEMB>'
 FROM cf_SurveyLargestClientsByBKPSize AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
 ORDER BY csInfo.applicationSizeGB DESC
 END
END
ELSE
	IF @i_trend=0
	BEGIN
	SELECT
		csInfo.CommServUniqueId AS 'CommServ UniqueId',
		csInfo.ClientName AS 'Client',
		CAST(ISNULL(csInfo.applicationSizeGB, 0)*1024.00 AS DECIMAL(32,2)) AS 'Application Size<SIZEMB>',
		CAST(csInfo.ShareOfTotal AS DECIMAL(20,2)) AS 'Share of Total (%)'
	FROM cf_SurveyLargestClientsByBKPSize AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
	ORDER BY csInfo.ShareOfTotal DESC
	END
	ELSE IF @i_trend>0
	BEGIN
	set @blLatestSurvey  = 0
	DECLARE @minStartDate DATETIME
			DECLARE @maxEndDate DATETIME
			SELECT	@minStartDate = MIN(IT.STARTDATE),
					@maxEndDate = MAX(IT.ENDDATE)
			FROM	dbo.RptMetricsTrend(@i_trend) IT
	DECLARE @tempResults TABLE
              (
                    CommServUniqueId INT,
                     CommCellID       VARCHAR(32),
                     CommServIP       VARCHAR(256),
                     CommServGUID     VARCHAR(256),
                     CustomerName     NVARCHAR(256),
                     CommServName     NVARCHAR(256),
                     CommServTimeZone VARCHAR(256),
                     CommServVersion  VARCHAR(256),
                     CommServEdition      VARCHAR(256),
                     SurverResultId   INT,
                     SurveyID         INT,
                     LogDate          DATETIME,
                     LogDateUTC       DATETIME,
                     RunningTime      INT,
                     SureyResultFlags INT
              )
         INSERT INTO @tempResults(CommServUniqueId,CommCellID,CommServIP,CommServGUID, CustomerName,CommServName,CommServTimeZone,CommServVersion,CommServEdition ,SurverResultId,SurveyID,LogDate,LogDateUTC,RunningTime,SureyResultFlags)
        SELECT CommServUniqueId,CommCellID,CommServIP,CommServGUID, CustomerName,CommServName,CommServTimeZone,CommServVersion,CommServEdition ,SurverResultId,SurveyID,LogDate,LogDateUTC,RunningTime,SureyResultFlags FROM dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId)
	SELECT DATEDIFF(s,'1970-01-01',DATEADD(DAY,-1,IT.STARTDATE)) AS 'Date',
		csInfo.CommServUniqueId AS 'CommServ UniqueId',
		csInfo.ClientName AS 'Client',
		CAST(ISNULL(MAX(csInfo.applicationSizeGB), -1) AS DECIMAL(32,6)) AS 'Application Size',
		CAST(ISNULL(MAX(csInfo.ShareOfTotal),-1) AS DECIMAL(20,2)) AS 'Share of Total (%)'
		FROM cf_SurveyLargestClientsByBKPSize AS csInfo WITH (NOLOCK)
		INNER JOIN @tempResults AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND (@i_client= csInfo.ClientName)
		RIGHT OUTER JOIN dbo.RptMetricsTrend(@i_trend) IT ON IT.STARTDATE < resultView.LogDateUTC AND IT.ENDDATE >= resultView.LogDateUTC
		WHERE csInfo.CommServUniqueId IS NOT NULL
			OR (EXISTS (Select * from @tempResults RV1, cf_SurveyLargestClientsByBKPSize D1 WHERE RV1.SurverResultId = D1.SurveyResultId AND D1.ClientName = @i_client AND RV1.LogDateUTC < IT.STARTDATE AND RV1.LogDateUTC >= @minStartDate)
			AND EXISTS (Select * from @tempResults RV2, cf_SurveyLargestClientsByBKPSize D2 WHERE RV2.SurverResultId = D2.SurveyResultId AND D2.ClientName = @i_client AND RV2.LogDateUTC > IT.ENDDATE AND RV2.LogDateUTC <= @maxEndDate))
			GROUP BY csInfo.CommServUniqueId,csInfo.ClientName,IT.STARTDATE
			ORDER BY IT.STARTDATE
	END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptLargestClientsByBKPSize')
	delete from GxQscripts where name = 'RptLargestClientsByBKPSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLargestClientsByBKPSize')
	delete from GXDBVersions where aliasname = 'RptLargestClientsByBKPSize'
GO

insert into GXDBVersions values(2, 'RptLargestClientsByBKPSize',  '00010010000000000000', 'RptLargestClientsByBKPSize', '00010010000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptLeastDedupedSubclients.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptLeastDedupedSubclients.sp,v $ $Id: RptLeastDedupedSubclients.sp,v 1.5 2014/07/28 21:48:08 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptLeastDedupedSubclients <<<'

IF EXISTS (select * from sysobjects where name='RptLeastDedupedSubclients')
	drop procedure RptLeastDedupedSubclients
IF EXISTS (select * from GxQscripts where name='RptLeastDedupedSubclients')
	delete from GxQscripts where name = 'RptLeastDedupedSubclients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLeastDedupedSubclients')
	delete from GXDBVersions where aliasname = 'RptLeastDedupedSubclients'
GO
print '... Creating Procedure: RptLeastDedupedSubclients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptLeastDedupedSubclients
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_Aggregate INT = 0,
  @i_CommServUniqueID INT = 0,
  @i_OnFullJobs INT = 1
AS
-- i_OnFullJobs: 0 for all incremental jobs for last 7 days, 1 for the last full job with 30 days
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 119
DECLARE @IsPrivate INT = 0
SELECT	@IsPrivate = ISNULL(CAST(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
IF(@i_Aggregate=1)
BEGIN
	IF @i_CommServUniqueID = 0
	BEGIN
		SELECT 	TOP(10)
			R.CommServUniqueId  AS 'CommServ UniqueId',
			R.CommCellID AS 'CommCell ID',
			(CASE WHEN @IsPrivate = 1 THEN '' ELSE ISNULL(R.CustomerName, '') + ' - ' END) + ISNULL(R.CommServName, '') AS 'CommCell Name',
			S.Client +'\'+ S.Subclient AS 'Client\Subclient',
			CAST(S.DedupSavingPct AS DECIMAL(30, 2)) AS 'Dedup Saving (%)'
	FROM	cf_SurveyLeastDedupedSubclients AS S WITH (NOLOCK)
			INNER JOIN 	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId,@i_GroupId) R 	ON S.SurveyResultId = R.SurverResultId
	--WHERE	OnFullJobs = @i_OnFullJobs
			ORDER BY S.DedupSavingPct ASC
	END
	ELSE
	BEGIN
		SELECT 	TOP(10)
			S.Client AS 'Client',
			S.Backupset +'\'+ S.Subclient AS 'Backupset\Subclient',
			CAST(S.DedupSavingPct AS DECIMAL(30, 2)) AS 'Dedup Saving (%)'
	FROM	cf_SurveyLeastDedupedSubclients AS S WITH (NOLOCK)
			INNER JOIN 	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId,@i_GroupId) R 	ON S.SurveyResultId = R.SurverResultId
	--WHERE	OnFullJobs = @i_OnFullJobs
			ORDER BY S.DedupSavingPct ASC
	END
END
ELSE
BEGIN
SELECT 	R.CommServUniqueId  AS 'CommServ UniqueId',
		R.CommCellID AS 'CommCell ID',
		(CASE WHEN @IsPrivate = 1 THEN '' ELSE ISNULL(R.CustomerName, '') + ' - ' END) + ISNULL(R.CommServName, '') AS 'CommCell Name',
		S.Client AS 'Client',
		S.Agent AS 'Agent',
		S.Instance AS 'Instance',
		S.Backupset AS 'Backupset<HIDDEN>',
		S.Subclient AS 'Subclient',
		S.StoragePolicy AS 'Storage Policy',
		CAST(1.0*S.appSize/1024.0/1024.0 AS DECIMAL(30, 2)) AS 'Application Size<SIZEMB>',
		CAST(1.0*S.DataWritten/1024.0/1024.0 AS DECIMAL(30, 2)) AS 'Data Written<SIZEMB>',
		CAST(S.DedupSavingPct AS DECIMAL(30, 2)) AS 'Dedup Saving (%)'
FROM	cf_SurveyLeastDedupedSubclients AS S WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId,@i_GroupId) R ON S.SurveyResultId = R.SurverResultId
WHERE	OnFullJobs = @i_OnFullJobs
ORDER BY 'CommCell Name', S.DedupSavingPct
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptLeastDedupedSubclients')
	delete from GxQscripts where name = 'RptLeastDedupedSubclients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLeastDedupedSubclients')
	delete from GXDBVersions where aliasname = 'RptLeastDedupedSubclients'
GO

insert into GXDBVersions values(2, 'RptLeastDedupedSubclients',  '00010005000000000000', 'RptLeastDedupedSubclients', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptLibraryAudit.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptLibraryAudit.sp,v $ $Id: RptLibraryAudit.sp,v 1.7 2015/06/29 19:06:11 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptLibraryAudit <<<'

IF EXISTS (select * from sysobjects where name='RptLibraryAudit')
	drop procedure RptLibraryAudit
IF EXISTS (select * from GxQscripts where name='RptLibraryAudit')
	delete from GxQscripts where name = 'RptLibraryAudit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLibraryAudit')
	delete from GXDBVersions where aliasname = 'RptLibraryAudit'
GO
print '... Creating Procedure: RptLibraryAudit'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptLibraryAudit
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @bAggregate INT = 1,
  @i_stdCommServUniqueID INT = 0,
  @i_stdLibraryID INT = 0,
  @i_stdMountPathID INT = 0,
  @i_CommServUniqueID INT = 0,
  @i_PropertyGroup VARCHAR(32) = ''
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 93
-- default is for all properties
DECLARE @i_PropertyGroupId INT = 0
IF	@i_PropertyGroup = 'Passed Audit'
	SET @i_PropertyGroupId = -1
ELSE IF	@i_PropertyGroup = 'General'
	SET @i_PropertyGroupId = 1
ELSE IF	@i_PropertyGroup = 'Mount Path'
	SET @i_PropertyGroupId = 2
ELSE IF	@i_PropertyGroup = 'Media'
	SET @i_PropertyGroupId = 3
ELSE IF	@i_PropertyGroup = 'Drive'
	SET @i_PropertyGroupId = 4
ELSE IF	@i_PropertyGroup = 'Advanced'
	SET @i_PropertyGroupId = 5
/* Library Types:
1	- TAPE
2	- OPTICAL
3	- DISK
4	- STANDALONE TAPE
5	- STANDALONE OPTICAL
*/
DECLARE @stdLibraryTypeId		INT = 0
DECLARE @LibraryAttributes		BIGINT = 0
DECLARE @stdLibAttributes		BIGINT = 0
DECLARE @LibraryExtAttributes	INT = 0
DECLARE @stdLibExtAttributes	INT = 0
DECLARE @MountPathAttributes	INT = 0
DECLARE @stdMPAttributes		INT = 0
DECLARE @stdDefMediaTypeName	VARCHAR(32) = ''
DECLARE @stdVMSForExport		VARCHAR(32) = ''
DECLARE @stdCustomerName		VARCHAR(256) = ''
DECLARE @isPrivate 				INT = 0
SELECT	@isPrivate = ISNULL(CAST(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
IF	@isPrivate = 0
	SELECT @stdCustomerName = CustomerName FROM cf_CommcellIdNameMap WHERE ID = @i_stdCommServUniqueID
CREATE	TABLE #LatestResult (CommServId INT, SurveyResultId INT, LogDate DATETIME)
INSERT	INTO #LatestResult
SELECT	CommServUniqueId, SurverResultId, LogDate
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, 0, 1, NULL, NULL, @i_UserId,@i_GroupId)
WHERE	(@stdCustomerName = '' OR CustomerName = @stdCustomerName)
IF	@i_stdCommServUniqueID > 0 AND @i_stdLibraryID = 0
BEGIN
	SELECT	R.CommServId	AS 'CommServ UniqueId',
			L.LibraryName	AS 'Library',
			L.LibraryID		AS 'Library ID',
			ISNULL(MP.MountPathName, '') AS 'MountPath',
			ISNULL(MP.MountPathID, 0)    AS 'MountPath ID'
	FROM	#LatestResult R
			INNER JOIN cf_SurveyLibraryProp L
				ON L.SurveyResultId = R.SurveyResultId
			LEFT OUTER JOIN cf_SurveyMountPathProp MP
				ON MP.SurveyResultId = L.SurveyResultId AND MP.LibraryId = L.LibraryId
	WHERE	R.CommServId = @i_stdCommServUniqueID
	ORDER BY 'Library', 'MountPath'
	DROP TABLE #LatestResult
	RETURN
END
ELSE
IF	@i_stdCommServUniqueID > 0 AND @i_stdLibraryID > 0 AND @i_stdMountPathID = 0
BEGIN
	DECLARE	@MountPathCounts INT = 0
	SELECT	@i_stdMountPathID = ISNULL(MAX(MountPathId), 0), @MountPathCounts = COUNT(*)
	FROM	#LatestResult R
			INNER JOIN cf_SurveyMountPathProp MP
				ON MP.SurveyResultId = R.SurveyResultId
	WHERE	R.CommServId = @i_stdCommServUniqueID AND MP.LibraryId = @i_stdLibraryID
	IF	@MountPathCounts > 1
		RETURN
END
DECLARE @TblLibraryAttribute TABLE (attribute BIGINT, name VARCHAR(128), propertyGroup INT)
INSERT INTO @TblLibraryAttribute
		  SELECT 1,	'Enable Auto-Cleaning: On sense code', 4
--UNION ALL SELECT MMS2_LIBRARY_PREIMPORT_OFF, ''
--UNION ALL SELECT MMS2_LIBRARY_INVALID_CONFIG, ''
UNION ALL SELECT 8, 'Enable Auto-Discovery of media into default scratch pool', 3
UNION ALL SELECT 16, 'Overwite media when content verification fails', 3
UNION ALL SELECT 32, 'Overwite media when it is from different CommCell', 3
UNION ALL SELECT 64, 'Enable Auto-Recovery when media is stuck in drive', 3
UNION ALL SELECT 128, 'Start new media when required media is exported', 3
UNION ALL SELECT 256, 'Start new media when required media is stuck in drive', 3
UNION ALL SELECT 512, 'Use Appendable Media', 3
UNION ALL SELECT 1024, 'Mark Library/Drive broken when error threshold exceeded', 4
UNION ALL SELECT 2048, 'Continue using drive even if need cleaning during restore', 4
UNION ALL SELECT 4096, 'Attempt to remove media from the drive when unload fails', 3
UNION ALL SELECT 8192, 'Enable Auto-Cleaning: Cleaning thresholds exceed', 4
UNION ALL SELECT 16384, 'Overwrite Media in Drive if Media Not Written to in N Days/Hours', 3
UNION ALL SELECT 32768, 'Use media in virtual mail slot for data protection', 3
UNION ALL SELECT 65536, 'Check for cleaning media loaded in Drive', 4
UNION ALL SELECT 131072, 'Verify access path using Serial Number for Drive', 4
UNION ALL SELECT 262144, 'Mark Media Appendable', 3
UNION ALL SELECT 524288, 'Check for Tape Alerts', 4
UNION ALL SELECT 1048576, 'Unmount Media after N Hours/Minutes of inactivity', 3
UNION ALL SELECT 2097152, 'Show Media related pop-up messages on CommCell Console', 3
--UNION ALL SELECT MMS2_LIBRARY_ENABLE_STDALN_CACHEMNT, ''
UNION ALL SELECT 8388608, 'Mark Archive files as Read-Only', 1
UNION ALL SELECT 16777216, 'Use SCSI-3 Reserve for contention resolution', 4
UNION ALL SELECT 33554432, 'Set drive as needs cleaning on Cyclic Redundancy Check (CRC) errors', 4
--UNION ALL SELECT MMS2_LIBRARY_SN6K, ''
UNION ALL SELECT 134217728, 'Check for media change in drive every N minute(s)', 4
UNION ALL SELECT 268435456, 'Disks within this library support Hardware Single Instancing', 2
UNION ALL SELECT 536870912, 'Automatically create storage policy for new data paths', 1
UNION ALL SELECT 1073741824, 'Retry read operations on SCSI errors', 5
UNION ALL SELECT 2147483648, 'Automatically add data paths for new drivepools configured', 5
SELECT @LibraryAttributes = SUM(attribute) FROM @TblLibraryAttribute
DECLARE @TblLibraryExtAttribute	TABLE (attribute INT, name VARCHAR(128), propertyGroup INT)
INSERT INTO @TblLibraryExtAttribute
		  SELECT 1, 'Spill and fill mount paths', 2
UNION ALL SELECT 2, 'Use SCSI-2 Reserve for contention resolution', 4
UNION ALL SELECT 4, 'Automatically use spare media from different scratch pool if found in drive', 3
UNION ALL SELECT 8, 'Automatically update barcodes on firmware changes', 5
UNION ALL SELECT 16, 'Unload media in standalone drive when different media is required', 4
UNION ALL SELECT 32, 'Skip unload drive for Autoloaders before unmounting media', 4
UNION ALL SELECT 64, 'Detect and update media type when media is loaded into the drive', 4
UNION ALL SELECT 128, 'Reset container when assigned media re-appears in library', 3
UNION ALL SELECT 256, 'Reset export location when assigned media re-appears in library', 3
UNION ALL SELECT 512, 'Mark library offline for maintenance', 1
--UNION ALL SELECT MMS2_LIBRARY_EXT_VTL, ''
UNION ALL SELECT 2048, 'Prevent use of tapes from a different backup vendor', 3
--UNION ALL SELECT MMS2_LIBRARY_EXT_PNP_DISK_BASED, ''
UNION ALL SELECT 8192, 'Only use PnP disk when it is blank', 3
UNION ALL SELECT 16384, 'Enable Auto Drive Replacement when new device is detected during Mount', 4
UNION ALL SELECT 32768, 'Submit full scan on library when finding an empty barcode during drive unmounts', 5
--UNION ALL SELECT MMS2_LIBRARY_EXT_MAG_SDR_ENABLED, ''
UNION ALL SELECT 131072, 'Do not import media from I/E port back to the slots', 5
UNION ALL SELECT 262144, 'Prevent accidental deletion of data from mount paths', 2
--UNION ALL SELECT MMS2_LIBRARY_EXT_KEEP_SCRATCH_MEDIA_ON_DECONFIGURE, 'Keep scratch media if library is deconfigured', 3
--UNION ALL SELECT MMS2_LIBRARY_EXT_COMMNET2_REGISTERED_COMMCELL, ''
SELECT @LibraryExtAttributes = SUM(attribute) FROM @TblLibraryExtAttribute
DECLARE @TblMountPathAttribute TABLE (attribute INT, name VARCHAR(128))
INSERT INTO @TblMountPathAttribute
		  SELECT 1, 'Use unbuffered I/O'
UNION ALL SELECT 2, 'Reserve space for SILO restores'
UNION ALL SELECT 4, ''
SELECT @MountPathAttributes	= SUM(attribute) FROM @TblMountPathAttribute
CREATE TABLE #LibraryProp
(
	CommServId					INT,
	LibraryId					INT,
	LibraryName					NVARCHAR(128),
	LibraryEnabled				INT,
	LibraryTypeId				INT,
	LowWaterMarkMB				INT,
	LibraryAttribute 			BIGINT,
	MountTimeoutMinutes			INT,
	UnmountTimeoutMinutes		INT,
	DefaultMediaTypeName		VARCHAR(32),
	UseAppendableWithinDays		INT,
	DriveCleanIntervalInDay		INT,
	VirtualMailSlotForExport	VARCHAR(64),
	CacheMountPeriodInMinute	INT,
	StdAlnMedRetentionHours		INT,
	TURIntervalInSec			INT,
	ConfigParams				VARCHAR(256),
	StdAlnChkIntervalInMinute	INT,
	ReadRetryIntervalInMinute	INT,
	ReadRetryAttempts			INT,
	ExtendedAttributes			INT,
	UpperThreshold				INT,
	LowerThreshold				INT,
	WarningWaterMark			INT,
	MaxSwitchForHost			INT,
	PreventPhysicalInventory	INT,
	PeriodicMailSlotCheck		INT,
	PreventAutoImport			INT,
	RemoveMediaFromMailSlot		INT,
	MountPathPropMatch			INT
)
CREATE TABLE #MountPathProp
(
	CommServId					INT,
	LibraryId					INT,
	MountPathId					INT,
	MountPathName				NVARCHAR(1024),
	IsEnabled					INT,
	MaxConcurrentWriters 		INT,
	MaxDataToWriteMB 			INT,
	MagneticSpaceRsrvInMB		INT,
	Attribute 					INT,
	MagneticChunkFileIncrSizeMB INT,
	DeviceEnabled 				INT
)
INSERT	INTO #LibraryProp
SELECT	R.CommServId,
		LibraryId,
		LibraryName,
		LibraryEnabled,
		LibraryTypeId,
		LowWaterMarkMB,
		LibraryAttribute & @LibraryAttributes,
		MountTimeoutSec/60,
		UnmountTimeoutSec/60,
		DefaultMediaTypeName,
		UseWithinDaysInSec/60/24,
		DriveCleanIntervalInSec/60/24,
		CASE VMSDirection
			 WHEN 1 THEN 'Start from Slot ' + CAST(StartVMSElementAddress AS VARCHAR(32)) + ' and UP'
			 WHEN 2 THEN 'Start from Slot ' + CAST(StartVMSElementAddress AS VARCHAR(32)) + ' and DOWN'
			 ELSE 'Not Enabled'
		END,
		CacheMountPeriodInSec/60,
		StdAlnMedRetentionTime/60/60,
		TURIntervalInSec,
		RIGHT(ConfigParams, LEN(ConfigParams) - CHARINDEX('-', ConfigParams)),
		StdAlnChkIntervalInSec/60,
		ReadRetryIntervalInSec/60,
		ReadRetryAttempts,
		(ExtendedAttributes ^ 4) & @LibraryExtAttributes,
		ThresholdPercentage,
		ThresholdPercentage - ThresholdVariation,
		WarningWaterMark,
		MaxSwitchForHost,
		0, 0, 0, 0,
		CASE WHEN R.CommServId = @i_stdCommServUniqueID AND L.LibraryId = @i_stdLibraryID OR @i_stdMountPathID = 0 THEN 1 ELSE 0 END
FROM	#LatestResult R
		INNER JOIN cf_SurveyLibraryProp L
			ON L.SurveyResultId = R.SurveyResultId
WHERE	(R.CommServId = @i_stdCommServUniqueID AND L.LibraryId = @i_stdLibraryID
		OR  @i_CommServUniqueID = 0 OR R.CommServId = @i_CommServUniqueID)
SELECT	@stdLibraryTypeId = LibraryTypeId,
		@stdLibAttributes = LibraryAttribute,
		@stdLibExtAttributes = ExtendedAttributes,
		@stdDefMediaTypeName = DefaultMediaTypeName,
		@stdVMSForExport = VirtualMailSlotForExport
FROM	#LibraryProp
WHERE	CommServId = @i_stdCommServUniqueID AND LibraryId = @i_stdLibraryID
IF @stdLibraryTypeId IN (1, 2)
	DELETE #LibraryProp WHERE LibraryTypeId NOT IN (1, 2)
ELSE IF @stdLibraryTypeId = 3
	DELETE #LibraryProp WHERE LibraryTypeId <> 3
ELSE IF @stdLibraryTypeId IN (4, 5)
	DELETE #LibraryProp WHERE LibraryTypeId NOT IN (4, 5)
UPDATE	#LibraryProp SET ReadRetryIntervalInMinute = S.ReadRetryIntervalInMinute, ReadRetryAttempts = S.ReadRetryAttempts
FROM	(SELECT * FROM #LibraryProp WHERE CommServId = @i_stdCommServUniqueID AND LibraryId = @i_stdLibraryID) S
WHERE	(#LibraryProp.CommServId <> @i_stdCommServUniqueID OR #LibraryProp.LibraryId <> @i_stdLibraryID)
	AND ((#LibraryProp.LibraryAttribute & 1073741824) = 0 OR (S.LibraryAttribute & 1073741824) = 0)
DECLARE	@idx INT = 1
DECLARE	@cnt INT = 1
WHILE @idx > 0 AND @cnt < 10
BEGIN
	IF	@cnt = 1
		UPDATE	#LibraryProp
		SET		ConfigParams = RIGHT(ConfigParams, LEN(ConfigParams) - CHARINDEX('-', ConfigParams)),
				PreventPhysicalInventory =  SUBSTRING(ConfigParams, 0, CHARINDEX('-', ConfigParams))
		WHERE	ConfigParams <> ''
	ELSE IF	@cnt = 2
		UPDATE	#LibraryProp
		SET		ConfigParams = RIGHT(ConfigParams, LEN(ConfigParams) - CHARINDEX('-', ConfigParams)),
				PeriodicMailSlotCheck =  SUBSTRING(ConfigParams, 0, CHARINDEX('-', ConfigParams))
		WHERE	ConfigParams <> ''
	ELSE IF	@cnt = 4
		UPDATE	#LibraryProp
		SET		ConfigParams = RIGHT(ConfigParams, LEN(ConfigParams) - CHARINDEX('-', ConfigParams)),
				PreventAutoImport =  SUBSTRING(ConfigParams, 0, CHARINDEX('-', ConfigParams))
		WHERE	ConfigParams <> ''
	ELSE IF	@cnt = 9
		UPDATE	#LibraryProp
		SET		ConfigParams = RIGHT(ConfigParams, LEN(ConfigParams) - CHARINDEX('-', ConfigParams)),
				RemoveMediaFromMailSlot =  SUBSTRING(ConfigParams, 0, CHARINDEX('-', ConfigParams))
		WHERE	ConfigParams <> ''
	ELSE
		UPDATE	#LibraryProp
		SET		ConfigParams = RIGHT(ConfigParams, LEN(ConfigParams) - CHARINDEX('-', ConfigParams))
		WHERE	ConfigParams <> ''
	SET @cnt = @cnt+1
END
DECLARE	@TblLibraryCount	TABLE (CommServId INT, Count INT)
DECLARE	@TblPassedMountPath TABLE (CommServId INT, LibraryId INT, MountPathId INT, MountPathName NVARCHAR(1024))
IF  @i_stdMountPathID > 0
BEGIN
	INSERT	INTO #MountPathProp
	SELECT	R.CommServId,
			LibraryId,
			MountPathId,
			MountPathName,
			IsEnabled,
			MaxConcurrentWriters,
			MaxDataToWriteMB,
			MagneticSpaceRsrvInMB,
			Attribute & @MountPathAttributes,
			MagneticChunkFileIncrSizeMB,
			DeviceEnabled
	FROM	#LatestResult R
			INNER JOIN cf_SurveyMountPathProp MP
				ON MP.SurveyResultId = R.SurveyResultId
	WHERE	(R.CommServId = @i_stdCommServUniqueID AND MP.MountPathId = @i_stdMountPathID
			OR  @i_CommServUniqueID = 0 OR R.CommServId = @i_CommServUniqueID)
	SELECT	@stdMPAttributes = Attribute
	FROM	#MountPathProp
	WHERE	CommServId = @i_stdCommServUniqueID AND MountPathId = @i_stdMountPathID
	INSERT	INTO @TblPassedMountPath
	SELECT	P.CommServId, P.LibraryId, P.MountPathId, P.MountPathName
	FROM	#MountPathProp P INNER JOIN
			(SELECT * FROM #MountPathProp WHERE CommServId = @i_stdCommServUniqueID AND MountPathId = @i_stdMountPathID) S
		ON	(P.CommServId <> S.CommServId OR P.MountPathId <> S.MountPathId)
		AND P.IsEnabled = S.IsEnabled
		AND P.MaxConcurrentWriters = S.MaxConcurrentWriters
		AND P.MaxDataToWriteMB = S.MaxDataToWriteMB
		AND P.MagneticSpaceRsrvInMB = S.MagneticSpaceRsrvInMB
		AND P.Attribute = S.Attribute
		AND P.MagneticChunkFileIncrSizeMB = S.MagneticChunkFileIncrSizeMB
		AND P.DeviceEnabled = S.DeviceEnabled
	INSERT	INTO @TblLibraryCount
	SELECT	CommServId, COUNT(DISTINCT LibraryId)
	FROM	#MountPathProp
	WHERE	CommServId <> @i_stdCommServUniqueID OR MountPathID <> @i_stdMountPathID
	GROUP BY CommServId
	DELETE	#MountPathProp
	FROM	@TblPassedMountPath D
	WHERE	#MountPathProp.CommServId = D.CommServId AND #MountPathProp.MountPathId = D.MountPathId
	UPDATE	#LibraryProp SET MountPathPropMatch = 1
	FROM	(SELECT DISTINCT CommServId, LibraryId FROM @TblPassedMountPath) P
			LEFT OUTER JOIN #MountPathProp MP ON P.CommServId = MP.CommServId AND P.LibraryId = MP.LibraryId
	WHERE	MP.LibraryId IS NULL
		AND #LibraryProp.CommServId = P.CommServId AND #LibraryProp.LibraryId = P.LibraryId
END
ELSE
	INSERT	INTO @TblLibraryCount
	SELECT	CommServId, COUNT(LibraryId)
	FROM	#LibraryProp
	WHERE	CommServId <> @i_stdCommServUniqueID OR LibraryId <> @i_stdLibraryID
	GROUP BY CommServId
DECLARE	@TblPassedLibrary TABLE (CommServId INT, LibraryId INT, LibraryName NVARCHAR(128))
INSERT	INTO @TblPassedLibrary
SELECT	P.CommServId, P.LibraryId, P.LibraryName
FROM	#LibraryProp P INNER JOIN
		(SELECT * FROM #LibraryProp WHERE CommServId = @i_stdCommServUniqueID AND LibraryId = @i_stdLibraryID) S
	ON	(P.CommServId <> S.CommServId OR P.LibraryId <> S.LibraryId)
	AND P.LowWaterMarkMB = S.LowWaterMarkMB
	AND P.LibraryAttribute = S.LibraryAttribute
	AND P.MountTimeoutMinutes = S.MountTimeoutMinutes
	AND P.UnmountTimeoutMinutes = S.UnmountTimeoutMinutes
	AND P.DefaultMediaTypeName = S.DefaultMediaTypeName
	AND P.UseAppendableWithinDays = S.UseAppendableWithinDays
	AND P.DriveCleanIntervalInDay = S.DriveCleanIntervalInDay
	AND P.VirtualMailSlotForExport = S.VirtualMailSlotForExport
	AND P.CacheMountPeriodInMinute = S.CacheMountPeriodInMinute
	AND P.StdAlnMedRetentionHours = S.StdAlnMedRetentionHours
	AND P.TURIntervalInSec = S.TURIntervalInSec
	AND P.StdAlnChkIntervalInMinute = S.StdAlnChkIntervalInMinute
	AND P.ReadRetryIntervalInMinute = S.ReadRetryIntervalInMinute
	AND P.ReadRetryAttempts = S.ReadRetryAttempts
	AND P.ExtendedAttributes = S.ExtendedAttributes
	AND P.UpperThreshold = S.UpperThreshold
	AND P.LowerThreshold = S.LowerThreshold
	AND P.WarningWaterMark = S.WarningWaterMark
	AND P.MaxSwitchForHost = S.MaxSwitchForHost
	AND	P.PreventPhysicalInventory = S.PreventPhysicalInventory
	AND	P.PeriodicMailSlotCheck = S.PeriodicMailSlotCheck
	AND	P.PreventAutoImport = S.PreventAutoImport
	AND	P.RemoveMediaFromMailSlot = S.RemoveMediaFromMailSlot
	AND P.MountPathPropMatch = 1
IF	@i_PropertyGroupId = -1
BEGIN
	IF	@i_CommServUniqueID = 0
		SELECT	CS.CommServName	AS 'CommCell',
				P.LibraryName AS 'Library'
		FROM	@TblPassedLibrary P
				INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
		ORDER BY CS.CommServName, P.LibraryName
	ELSE
		SELECT	LibraryName AS 'Library'
		FROM	@TblPassedLibrary
		ORDER BY LibraryName
	DROP TABLE #LatestResult
	DROP TABLE #LibraryProp
	DROP TABLE #MountPathProp
	RETURN
END
DELETE	#LibraryProp
FROM	@TblPassedLibrary P
WHERE	#LibraryProp.CommServId = P.CommServId AND #LibraryProp.LibraryId = P.LibraryId
CREATE	TABLE #LibraryProperty (CommServId INT, LibraryId INT, MountPathId INT,
		PropertyGroup INT, Property VARCHAR(128), Value NVARCHAR(MAX), stdValue NVARCHAR(MAX))
;WITH LibraryProperty (CommServId, LibraryId, Property, Value) AS
(
	SELECT	P.CommServId, P.LibraryId, P.Property, P.Value
	FROM	#LibraryProp
			UNPIVOT (Value FOR Property IN (
				LibraryEnabled,	LowWaterMarkMB, MountTimeoutMinutes, UnmountTimeoutMinutes,
				UseAppendableWithinDays, DriveCleanIntervalInDay, CacheMountPeriodInMinute, StdAlnMedRetentionHours,
				TURIntervalInSec, StdAlnChkIntervalInMinute, ReadRetryIntervalInMinute, ReadRetryAttempts,
				UpperThreshold, LowerThreshold, WarningWaterMark, MaxSwitchForHost,
				PreventPhysicalInventory, PeriodicMailSlotCheck, PreventAutoImport, RemoveMediaFromMailSlot)
			) P
)
INSERT	INTO #LibraryProperty
SELECT	P.CommServId, P.LibraryId, 0,
		CASE WHEN P.Property IN ('LibraryEnabled', 'LowWaterMarkMB', 'WarningWaterMark', 'MountTimeoutMinutes',
								'UnmountTimeoutMinutes') THEN 1
			WHEN P.Property IN ('UpperThreshold', 'LowerThreshold', 'MaxSwitchForHost') THEN 2
			WHEN P.Property IN ('UseAppendableWithinDays', 'CacheMountPeriodInMinute', 'StdAlnMedRetentionHours') THEN 3
			WHEN P.Property IN ('DriveCleanIntervalInDay', 'StdAlnChkIntervalInMinute') THEN 4
			WHEN P.Property IN ('TURIntervalInSec', 'ReadRetryIntervalInMinute', 'ReadRetryAttempts', 'PreventPhysicalInventory',
								'PeriodicMailSlotCheck', 'PreventAutoImport', 'RemoveMediaFromMailSlot') THEN 5
		END,
		CASE WHEN P.Property = 'LibraryEnabled' THEN 'Enable Library'
			WHEN P.Property = 'LowWaterMarkMB' THEN 'Low Watermark (%)'
			WHEN P.Property = 'WarningWaterMark' THEN 'Warning Watermark (%)'
			WHEN P.Property = 'MountTimeoutMinutes' THEN 'Mount Timeouts (in minutes)'
			WHEN P.Property = 'UnmountTimeoutMinutes' THEN 'Unmount Timeouts (in minutes)'
			WHEN P.Property = 'UpperThreshold' THEN 'Start aging when data occupied on disk is N%'
			WHEN P.Property = 'LowerThreshold' THEN 'Stop aging when data occupied on disk is N%'
			WHEN P.Property = 'MaxSwitchForHost' THEN 'Mount Path Allocation Policy - Allocate number of Writers'
			WHEN P.Property = 'CacheMountPeriodInMinute' THEN 'Unmount Media from the drive after N minutes of inactivity'
			WHEN P.Property = 'StdAlnMedRetentionHours' THEN 'Overwrite Media in Drive if Media Not Written to in N Days/Hours'
			WHEN P.Property = 'DriveCleanIntervalInDay' THEN 'Enable Auto Cleaning - Wait N day(s) after last cleaning'
			WHEN P.Property = 'StdAlnChkIntervalInMinute' THEN 'Check for media change in drive every N minute(s)'
			WHEN P.Property = 'TURIntervalInSec' THEN 'Library Status Check Interval in seconds'
			WHEN P.Property = 'ReadRetryIntervalInMinute' THEN 'Retry Read operations on SCSI errors - retry interval in minutes'
			WHEN P.Property = 'ReadRetryAttempts' THEN 'Retry Read operations on SCSI errors - retry times'
			WHEN P.Property = 'PreventPhysicalInventory' THEN 'Prevent physical inventory of the library'
			WHEN P.Property = 'PeriodicMailSlotCheck' THEN 'Do Periodic mail slot check for any change in status'
			WHEN P.Property = 'PreventAutoImport' THEN 'Prevent Auto Import of Media from mail slot'
			WHEN P.Property = 'RemoveMediaFromMailSlot' THEN 'Allow Medium Removal from mail slot'
		END,
		CASE WHEN P.Property IN ('LibraryEnabled', 'PreventPhysicalInventory', 'PeriodicMailSlotCheck', 'PreventAutoImport', 'RemoveMediaFromMailSlot')
				THEN (CASE P.Value WHEN 0 THEN 'No' ELSE 'Yes' END)
			WHEN P.Property = 'MaxSwitchForHost'
				THEN (CASE P.Value WHEN -1 THEN 'Maximum Allowed Writers' ELSE 'Allocate number of Writers: ' + CAST(P.Value AS VARCHAR(32)) END)
			WHEN P.Value = -1 THEN 'Maximum'
			ELSE CAST (P.Value AS VARCHAR(32))
		END,
		CASE WHEN S.Property IN ('LibraryEnabled', 'PreventPhysicalInventory', 'PeriodicMailSlotCheck', 'PreventAutoImport', 'RemoveMediaFromMailSlot')
				THEN (CASE S.Value WHEN 0 THEN 'No' ELSE 'Yes' END)
			WHEN S.Property = 'MaxSwitchForHost'
				THEN (CASE S.Value WHEN -1 THEN 'Maximum Allowed Writers' ELSE 'Allocate number of Writers: ' + CAST(S.Value AS VARCHAR(32)) END)
			WHEN S.Value = -1 THEN 'Maximum'
			ELSE CAST (S.Value AS VARCHAR(32))
		END
FROM	LibraryProperty P
		INNER JOIN
		(
			SELECT	Property, Value
			FROM	LibraryProperty
			WHERE	CommServId = @i_stdCommServUniqueID AND LibraryId = @i_stdLibraryID
		) S
		ON P.Property = S.Property AND P.Value <> S.Value
IF	@i_PropertyGroupId IN (0, 3)
BEGIN
	INSERT	INTO #LibraryProperty
	SELECT	CommServId, LibraryId, 0, 3, 'Default Media Type', DefaultMediaTypeName, @stdDefMediaTypeName
	FROM	#LibraryProp
	WHERE	(CommServId <> @i_stdCommServUniqueID OR LibraryId <> @i_stdLibraryID)
		AND DefaultMediaTypeName <> @stdDefMediaTypeName
	INSERT	INTO #LibraryProperty
	SELECT	CommServId, LibraryId, 0, 3, 'Virtual Mail Slot For Export', VirtualMailSlotForExport, @stdVMSForExport
	FROM	#LibraryProp
	WHERE	(CommServId <> @i_stdCommServUniqueID OR LibraryId <> @i_stdLibraryID)
		AND VirtualMailSlotForExport <> @stdVMSForExport
END
INSERT	INTO #LibraryProperty
SELECT	P.CommServId, P.LibraryId, 0, F.propertyGroup, F.name,
		CASE WHEN (P.LibraryAttribute & F.attribute) = 0 THEN 'No' ELSE 'Yes' END,
		CASE WHEN (@stdLibAttributes & F.attribute) = 0 THEN 'No' ELSE 'Yes' END
FROM	(SELECT CommServId, LibraryId, LibraryAttribute FROM #LibraryProp WHERE LibraryAttribute <> @stdLibAttributes) P
		CROSS JOIN @TblLibraryAttribute F
WHERE	(P.LibraryAttribute & F.attribute) <> (@stdLibAttributes & F.attribute)
INSERT	INTO #LibraryProperty
SELECT	P.CommServId, P.LibraryId, 0, F.propertyGroup, F.name,
		CASE WHEN (P.ExtendedAttributes & F.attribute) = 0 THEN 'No' ELSE 'Yes' END,
		CASE WHEN (@stdLibExtAttributes & F.attribute) = 0 THEN 'No' ELSE 'Yes' END
FROM	(SELECT CommServId, LibraryId, ExtendedAttributes FROM #LibraryProp WHERE ExtendedAttributes <> @stdLibExtAttributes) P
		CROSS JOIN @TblLibraryExtAttribute F
WHERE	(P.ExtendedAttributes & F.attribute) <> (@stdLibExtAttributes & F.attribute)
IF	@i_PropertyGroupId IN (0, 2)
BEGIN
	INSERT	INTO #LibraryProperty
	SELECT	P.CommServId, P.LibraryId, P.MountPathId, 2, F.name,
			CASE WHEN (P.Attribute & F.attribute) = 0 THEN 'No' ELSE 'Yes' END,
			CASE WHEN (@stdMPAttributes & F.attribute) = 0 THEN 'No' ELSE 'Yes' END
	FROM	(SELECT CommServId, LibraryId, MountPathId, Attribute FROM #MountPathProp WHERE Attribute <> @stdMPAttributes) P
			CROSS JOIN @TblMountPathAttribute F
	WHERE	(P.Attribute & F.attribute) <> (@stdMPAttributes & F.attribute)
	;WITH MountPathProperty (CommServId, LibraryId, MountPathId, Property, Value) AS
	(
		SELECT	P.CommServId, P.LibraryId, P.MountPathId, P.Property, P.Value
		FROM	#MountPathProp
				UNPIVOT (Value FOR Property IN (
						IsEnabled, MaxConcurrentWriters, MaxDataToWriteMB, MagneticSpaceRsrvInMB,
						MagneticChunkFileIncrSizeMB, DeviceEnabled)
				) P
	)
	INSERT	INTO #LibraryProperty
	SELECT	P.CommServId, P.LibraryId, P.MountPathId, 2,
			CASE WHEN P.Property = 'IsEnabled' THEN 'Enable Mount Path'
				WHEN P.Property = 'MaxConcurrentWriters' THEN 'Mount Path Allocation Policy'
				WHEN P.Property = 'MaxDataToWriteMB' THEN 'Space Allocation'
				WHEN P.Property = 'MagneticSpaceRsrvInMB' THEN 'Space Allocation - Reserve Space in MB'
				WHEN P.Property = 'MagneticChunkFileIncrSizeMB' THEN 'Minimize fragmentation by allocating write blocks of N MB'
				WHEN P.Property = 'DeviceEnabled' THEN 'Device Enabled'
			END,
			CASE WHEN P.Property IN ('IsEnabled', 'DeviceEnabled')
					THEN (CASE P.Value WHEN 0 THEN 'No' ELSE 'Yes' END)
				WHEN P.Property = 'MaxConcurrentWriters'
					THEN (CASE P.Value WHEN 0 THEN 'Disable mount path for write' WHEN 1000 THEN 'Maximum Allowed Writers'
								ELSE 'Allocate number of Writers: ' + CAST(P.Value AS VARCHAR(32)) END)
				WHEN P.Property = 'MaxDataToWriteMB'
					THEN (CASE P.Value WHEN -1 THEN 'Use until free space on mount path reaches Reserved Space'
								ELSE 'Do not consume more than ' + CAST(P.Value AS VARCHAR(32)) + ' GB' END)
				WHEN P.Property = 'MagneticChunkFileIncrSizeMB' AND P.Value = 0 THEN 'Not Enabled'
				ELSE CAST (P.Value AS VARCHAR(32))
			END,
			CASE WHEN S.Property IN ('IsEnabled', 'DeviceEnabled')
					THEN (CASE S.Value WHEN 0 THEN 'No' ELSE 'Yes' END)
				WHEN S.Property = 'MaxConcurrentWriters'
					THEN (CASE S.Value WHEN 0 THEN 'Disable mount path for write' WHEN 1000 THEN 'Maximum Allowed Writers'
								ELSE 'Allocate number of Writers: ' + CAST(S.Value AS VARCHAR(32)) END)
				WHEN S.Property = 'MaxDataToWriteMB'
					THEN (CASE S.Value WHEN -1 THEN 'Use until free space on mount path reaches Reserved Space'
								ELSE 'Do not consume more than ' + CAST(S.Value AS VARCHAR(32))  + ' GB'END)
				WHEN S.Property = 'MagneticChunkFileIncrSizeMB' AND S.Value = 0 THEN 'Not Enabled'
				ELSE CAST (S.Value AS VARCHAR(32))
			END
	FROM	MountPathProperty P
			INNER JOIN
			(
				SELECT	Property, Value
				FROM	MountPathProperty
				WHERE	CommServId = @i_stdCommServUniqueID AND MountPathId = @i_stdMountPathID
			) S
			ON P.Property = S.Property AND P.Value <> S.Value
END
IF @stdLibraryTypeId = 3
	DELETE #LibraryProperty WHERE PropertyGroup IN (3,4,5)
ELSE
	DELETE #LibraryProperty WHERE PropertyGroup = 2
IF @bAggregate = 1
BEGIN
	DECLARE	@TblSummary TABLE (CommServId INT, LibCount INT, AllProp INT,
			General INT, MountPath INT, Media INT, Drive INT, Advanced INT)
	INSERT	INTO @TblSummary
	SELECT	P.CommServId, 0, 0, ISNULL([1], 0), ISNULL([2], 0), ISNULL([3], 0), ISNULL([4], 0), ISNULL([5], 0)
	FROM	(SELECT	CommServId, PropertyGroup, COUNT(DISTINCT LibraryId) AS Counts
			FROM	#LibraryProperty
			GROUP BY CommServId, PropertyGroup) AS S
			PIVOT (MAX(Counts) FOR S.PropertyGroup IN ([1], [2], [3], [4], [5])) AS P
	UPDATE	@TblSummary
	SET		LibCount = C.Count
	FROM	@TblSummary T
			INNER JOIN @TblLibraryCount C ON T.CommServId = C.CommServId
	UPDATE	@TblSummary
	SET		AllProp = S.Counts
	FROM	@TblSummary T
			INNER JOIN
			(SELECT	CommServId, COUNT(DISTINCT LibraryId) AS Counts
			FROM	#LibraryProperty
			GROUP BY CommServId) AS S
			ON T.CommServId = S.CommServId
	IF	NOT EXISTS (SELECT * FROM @TblSummary)
	INSERT	INTO @TblSummary
	SELECT	CommServId, Count, 0, 0,
			CASE WHEN @i_stdMountPathID > 0 THEN 0 ELSE -1 END,
			CASE WHEN @i_stdMountPathID = 0 THEN 0 ELSE -1 END,
			CASE WHEN @i_stdMountPathID = 0 THEN 0 ELSE -1 END,
			CASE WHEN @i_stdMountPathID = 0 THEN 0 ELSE -1 END
	FROM	@TblLibraryCount
	SELECT	'All CommCells' AS 'CommCell',
			'' AS 'CommServ UniqueId',
			'' AS 'CommCell ID',
			D.LibCount		AS 'All Libraries',
			(SELECT COUNT(*) FROM @TblPassedLibrary) AS 'Passed Audit',
			D.General		AS 'General',
			CASE WHEN @i_stdMountPathID > 0 THEN D.MountPath ELSE -1 END AS 'Mount Path',
			CASE WHEN @i_stdMountPathID = 0 THEN D.Media     ELSE -1 END AS 'Media',
			CASE WHEN @i_stdMountPathID = 0 THEN D.Drive     ELSE -1 END AS 'Drive',
			CASE WHEN @i_stdMountPathID = 0 THEN D.Advanced  ELSE -1 END AS 'Advanced',
			D.AllProp		AS 'Any',
			'' AS 'Collection Time (Time Zone)',
			-1				AS 'FirstOrder'
	FROM	(SELECT SUM(LibCount) AS LibCount, SUM(AllProp) AS AllProp, SUM(General) AS General,
					SUM(MountPath) AS MountPath, SUM(Media) AS Media, SUM(Drive) AS Drive, SUM(Advanced) AS Advanced
			FROM	@TblSummary) D
	UNION ALL
	SELECT	CASE
				WHEN @isPrivate = 1 THEN CS.CommServName
				ELSE CS.CustomerName + ' - ' + CS.CommServName
			END AS 'CommCell',
			CS.ID			AS 'CommServ UniqueId',
			CS.CommCellID	AS 'CommCell ID',
			D.LibCount		AS 'All Libraries',
			(SELECT COUNT(*) FROM @TblPassedLibrary WHERE CommServId = D.CommServId) AS 'Passed Audit',
			D.General		AS 'General',
			CASE WHEN @i_stdMountPathID > 0 THEN D.MountPath ELSE -1 END AS 'Mount Path',
			CASE WHEN @i_stdMountPathID = 0 THEN D.Media     ELSE -1 END AS 'Media',
			CASE WHEN @i_stdMountPathID = 0 THEN D.Drive     ELSE -1 END AS 'Drive',
			CASE WHEN @i_stdMountPathID = 0 THEN D.Advanced  ELSE -1 END AS 'Advanced',
			D.AllProp		AS 'Any',
			CONVERT(VARCHAR(20), LR.LogDate, 100) + ' (' + CS.CommServTZ + ')' AS 'Collection Time (Time Zone)',
			0				AS 'FirstOrder'
	FROM	@TblSummary D
			INNER JOIN cf_CommcellIdNameMap CS ON D.CommServId = CS.ID
			INNER JOIN #LatestResult LR ON D.CommServId = LR.CommServId
	ORDER BY 'FirstOrder', 'CommCell'
END
ELSE
BEGIN
	IF	@i_PropertyGroupId <> 0
		DELETE #LibraryProperty WHERE PropertyGroup <> @i_PropertyGroupId
	IF EXISTS (SELECT * FROM #LibraryProperty WHERE MountPathId > 0)
	BEGIN
		IF @i_CommServUniqueID = 0
			SELECT	CASE
						WHEN @isPrivate = 1 THEN CS.CommServName
						ELSE CS.CustomerName + ' - ' + CS.CommServName
					END AS 'CommCell',
					S.LibraryName	AS 'Library',
					ISNULL(M.MountPathName, 'N/A') AS 'Mount Path',
					P.Property		AS 'Property',
					P.Value			AS 'Value',
					P.stdValue		AS 'Template Value'
			FROM	#LibraryProperty P
					INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
					INNER JOIN #LibraryProp S ON P.CommServId = S.CommServId AND P.LibraryId = S.LibraryId
					LEFT OUTER JOIN #MountPathProp M ON P.CommServId = M.CommServId AND P.MountPathId = M.MountPathId
			ORDER BY CS.CommServName, S.LibraryName, 'Mount Path', P.PropertyGroup, P.Property
		ELSE
			SELECT	S.LibraryName AS 'Library',
					ISNULL(M.MountPathName, 'N/A') AS 'Mount Path',
					P.Property		AS 'Property',
					P.Value			AS 'Value',
					P.stdValue		AS 'Template Value'
			FROM	#LibraryProperty P
					INNER JOIN #LibraryProp S ON P.CommServId = S.CommServId AND P.LibraryId = S.LibraryId
					LEFT OUTER JOIN #MountPathProp M ON P.CommServId = M.CommServId AND P.MountPathId = M.MountPathId
			ORDER BY S.LibraryName, 'Mount Path', P.PropertyGroup, P.Property
	END
	ELSE
	IF @i_CommServUniqueID = 0
		SELECT	CASE
					WHEN @isPrivate = 1 THEN CS.CommServName
					ELSE CS.CustomerName + ' - ' + CS.CommServName
				END AS 'CommCell',
				S.LibraryName	AS 'Library',
				P.Property		AS 'Property',
				P.Value			AS 'Value',
				P.stdValue		AS 'Template Value'
		FROM	#LibraryProperty P
				INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
				INNER JOIN #LibraryProp S ON P.CommServId = S.CommServId AND P.LibraryId = S.LibraryId
		ORDER BY CS.CommServName, S.LibraryName, P.PropertyGroup, P.Property
	ELSE
		SELECT	S.LibraryName AS 'Library',
				P.Property		AS 'Property',
				P.Value			AS 'Value',
				P.stdValue		AS 'Template Value'
		FROM	#LibraryProperty P
				INNER JOIN #LibraryProp S ON P.CommServId = S.CommServId AND P.LibraryId = S.LibraryId
		ORDER BY S.LibraryName, P.PropertyGroup, P.Property
END
DROP TABLE #LatestResult
DROP TABLE #LibraryProperty
DROP TABLE #LibraryProp
DROP TABLE #MountPathProp
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptLibraryAudit')
	delete from GxQscripts where name = 'RptLibraryAudit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLibraryAudit')
	delete from GXDBVersions where aliasname = 'RptLibraryAudit'
GO

insert into GXDBVersions values(2, 'RptLibraryAudit',  '00010007000000000000', 'RptLibraryAudit', '00010007000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptLongRunningJobs.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptLongRunningJobs.sp,v $ $Id: RptLongRunningJobs.sp,v 1.11 2014/07/28 21:48:06 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptLongRunningJobs <<<'

IF EXISTS (select * from sysobjects where name='RptLongRunningJobs')
	drop procedure RptLongRunningJobs
IF EXISTS (select * from GxQscripts where name='RptLongRunningJobs')
	delete from GxQscripts where name = 'RptLongRunningJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLongRunningJobs')
	delete from GXDBVersions where aliasname = 'RptLongRunningJobs'
GO
print '... Creating Procedure: RptLongRunningJobs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptLongRunningJobs
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 24
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
IF(@blaggregate=1)
BEGIN
	IF @i_CommServUniqueID = 0
	BEGIN
	SELECT TOP(10)
		resultView.CommServUniqueId  AS 'CommServ UniqueId',
		CASE
			WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
			ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
		END AS 'CommCell Name',
		csInfo.JobId AS 'Job Id',
		CAST(csInfo.DurationHr*60 AS INT) AS 'Duration (hh:mm)<HHMM>'
	FROM cf_SurveyLongRunningJobs AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
	ORDER BY csInfo.DurationHr DESC
	END
	ELSE
	BEGIN
	SELECT TOP(10)
		csInfo.clientName AS 'Client',
		csInfo.JobId AS 'Job Id',
		CAST(csInfo.DurationHr*60 AS INT) AS 'Duration (hh:mm)<HHMM>'
	FROM cf_SurveyLongRunningJobs AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
	ORDER BY csInfo.DurationHr DESC
	END
END
ELSE IF @i_CommServUniqueID = 0
BEGIN
SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	CASE
		WHEN @param_isPrivate = 1 THEN ISNULL(resultView.CommServName, '')
		ELSE ISNULL(resultView.CustomerName,'') + ' - ' + ISNULL(resultView.CommServName, '')
	END AS 'CommCell Name',
	csInfo.clientName AS 'Client',
	csInfo.AgentName AS 'Agent',
	csInfo.BackupType AS 'Backup Type',
	csInfo.JobId AS 'Job Id',
	CAST(csInfo.DurationHr*60 AS INT) AS 'Duration (hh:mm)<HHMM>',
	CAST((csInfo.ApplicationSize/1024.00/1024.00) AS DECIMAL(32,2)) AS 'Application Size<SIZEMB>'
FROM cf_SurveyLongRunningJobs AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
ORDER BY csInfo.DurationHr DESC, 'CommCell Name' ASC
END
ELSE
SELECT
	csInfo.CommServUniqueId AS 'CommServ UniqueId',
	csInfo.clientName AS 'Client',
	csInfo.AgentName AS 'Agent',
	csInfo.BackupType AS 'Backup Type',
	csInfo.JobId AS 'Job Id',
	CAST(csInfo.DurationHr*60 AS INT) AS 'Duration (hh:mm)<HHMM>',
	CAST((csInfo.ApplicationSize/1024.00/1024.00) AS DECIMAL(32,2)) AS 'Application Size<SIZEMB>'
FROM cf_SurveyLongRunningJobs AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
ORDER BY csInfo.DurationHr DESC
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptLongRunningJobs')
	delete from GxQscripts where name = 'RptLongRunningJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLongRunningJobs')
	delete from GXDBVersions where aliasname = 'RptLongRunningJobs'
GO

insert into GXDBVersions values(2, 'RptLongRunningJobs',  '00010011000000000000', 'RptLongRunningJobs', '00010011000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptLotusNotesProvider.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptLotusNotesProvider.sp,v $ $Id: RptLotusNotesProvider.sp,v 1.5 2014/07/28 21:49:48 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptLotusNotesProvider <<<'

IF EXISTS (select * from sysobjects where name='RptLotusNotesProvider')
	drop procedure RptLotusNotesProvider
IF EXISTS (select * from GxQscripts where name='RptLotusNotesProvider')
	delete from GxQscripts where name = 'RptLotusNotesProvider'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLotusNotesProvider')
	delete from GXDBVersions where aliasname = 'RptLotusNotesProvider'
GO
print '... Creating Procedure: RptLotusNotesProvider'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptLotusNotesProvider
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 49
IF @i_CommServUniqueID = 0
BEGIN
DECLARE @param_isPrivate INT = 0
SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
SELECT
	tmpsurveyxml.CommServUniqueId AS 'CommServ UniqueId',
	tmpsurveyxml.CommCellID AS 'CommCell ID',
	tmpsurveyxml.CommServIP AS 'CommServe IP<HIDDEN>',
	tmpsurveyxml.CommServGUID AS 'CommServer GUID',
	CASE
		WHEN @param_isPrivate = 1 THEN ISNULL(tmpsurveyxml.CommServName, '')
		ELSE ISNULL(tmpsurveyxml.CustomerName,'') + ' - ' + ISNULL(tmpsurveyxml.CommServName, '')
	END AS 'CommCell Name',
	CASE
		WHEN tmpsurveyxml.RunningTime = -1 THEN 'N/A'
		ELSE CAST(tmpsurveyxml.RunningTime AS VARCHAR(MAX))
	END AS 'Running Time in Seconds',
	csInfo.n.value('@LNcount','INT') AS 'Lotus Notes Provider Count'
FROM dbo.RptGetSurveyResultsFunc(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId) AS tmpsurveyxml
	CROSS apply tmpsurveyxml.surveyxml.nodes('/LotuNotesProviderXML') AS csInfo(n)
WHERE csInfo.n.value('@LNcount','INT') > 0
END
ELSE
SELECT
	tmpsurveyxml.CommServUniqueId AS 'CommServ UniqueId',
csInfo.n.value('@LNcount','INT') AS 'Lotus Notes Provider Count'
FROM dbo.RptGetSurveyResultsFunc(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId) AS tmpsurveyxml
	CROSS apply tmpsurveyxml.surveyxml.nodes('/LotuNotesProviderXML') AS csInfo(n)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptLotusNotesProvider')
	delete from GxQscripts where name = 'RptLotusNotesProvider'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLotusNotesProvider')
	delete from GXDBVersions where aliasname = 'RptLotusNotesProvider'
GO

insert into GXDBVersions values(2, 'RptLotusNotesProvider',  '00010005000000000000', 'RptLotusNotesProvider', '00010005000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptMailboxQuotaUsage.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptMailboxQuotaUsage.sp,v $ $Id: RptMailboxQuotaUsage.sp,v 1.6 2014/07/28 21:50:50 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptMailboxQuotaUsage <<<'

IF EXISTS (select * from sysobjects where name='RptMailboxQuotaUsage')
	drop procedure RptMailboxQuotaUsage
IF EXISTS (select * from GxQscripts where name='RptMailboxQuotaUsage')
	delete from GxQscripts where name = 'RptMailboxQuotaUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptMailboxQuotaUsage')
	delete from GXDBVersions where aliasname = 'RptMailboxQuotaUsage'
GO
print '... Creating Procedure: RptMailboxQuotaUsage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptMailboxQuotaUsage
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_Aggregate INT = 0,
  @i_CommCellID INT = 0
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 134
DECLARE @IsPrivate INT = 0
SELECT	@IsPrivate = ISNULL(CAST(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
IF @IsPrivate = 0
	RETURN
CREATE	TABLE #OrderedQuotaUsage (
		UserGUID			VARCHAR(64),
		UserName			NVARCHAR(MAX),
		QuotaEnabled		INT,
		QuotaSizeMB			BIGINT,
		SpaceConsumed		BIGINT,
		GlobalSpaceConsumed	BIGINT,
		LastUpdateTime		DATETIME,
		CommCellID			INT,
		OrderId				INT)
INSERT	INTO #OrderedQuotaUsage
SELECT	UserGUID, UserName, QuotaEnabled, QuotaSizeMB, SpaceConsumed, GlobalSpaceConsumed, LastUpdateTime, CommCellID,
		ROW_NUMBER() OVER (PARTITION BY UserGUID ORDER BY LastUpdateTime DESC)
FROM	cf_SurveyMailboxQuotaUsage AS S WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, 0, 1, NULL, NULL, @i_UserId,@i_GroupId) R ON S.SurveyResultId = R.SurverResultId
IF @i_CommCellID > 0 -- Web Server API
BEGIN
	;WITH DuplicatedUser (UserGUID, GlobalSpaceConsumed) AS
	(
		SELECT	UserGUID, SUM(SpaceConsumed)
		FROM	#OrderedQuotaUsage U
		GROUP BY UserGUID
		HAVING MAX(QuotaEnabled) > 0 AND COUNT(*) > 1
	)
	SELECT	U.UserGUID, T.QuotaSizeMB, T.GlobalSpaceConsumed, T.LastUpdateTime
	FROM	#OrderedQuotaUsage U
			INNER JOIN (
			SELECT	Q.UserGUID, Q.QuotaSizeMB, D.GlobalSpaceConsumed, Q.LastUpdateTime
			FROM	#OrderedQuotaUsage Q INNER JOIN DuplicatedUser D ON Q.UserGUID = D.UserGUID AND Q.OrderId = 1
			) T ON U.UserGUID = T.UserGUID
	WHERE	U.CommCellId = @i_CommCellID
		AND (U.QuotaSizeMB <> T.QuotaSizeMB OR U.GlobalSpaceConsumed <> T.GlobalSpaceConsumed OR U.LastUpdateTime <> T.LastUpdateTime)
END
ELSE
IF	@i_Aggregate = 1 -- Usage Distribution chart
BEGIN
	DECLARE @RangeTbl TABLE (RangeBegin INT, RangeEnd INT, Bucket VARCHAR(8))
	INSERT INTO @RangeTbl
	SELECT 0, 10, '0-10' UNION SELECT 10, 20, '10-20' UNION SELECT 20, 30, '20-30' UNION SELECT 30, 40, '30-40'
	UNION SELECT 40, 50, '40-50' UNION SELECT 50, 60, '50-60' UNION SELECT 60, 70, '60-70' UNION SELECT 70, 80, '70-80'
	UNION SELECT 80, 90, '80-90' UNION SELECT 90, 100, '90-100' UNION SELECT 100, 0x7FFFFFFF, '>100'
	;WITH QuotaUsagePct (UserGUID, UsagePct) AS
	(
		SELECT	UserGUID, SUM(SpaceConsumed)/10.24/1024/SUM(CASE WHEN OrderId = 1 THEN QuotaSizeMB ELSE 0 END)
		FROM	#OrderedQuotaUsage
		GROUP BY UserGUID
		HAVING	MAX(QuotaEnabled) > 0 AND SUM(CASE WHEN OrderId = 1 THEN QuotaSizeMB ELSE 0 END) > 0
	)
	SELECT	Bucket AS 'Quota Used (%)',
			ISNULL(Counts, 0) AS 'Number of Users'
	FROM	@RangeTbl R
			LEFT OUTER JOIN (
			SELECT	RangeBegin, COUNT(*) AS Counts
			FROM	QuotaUsagePct INNER JOIN @RangeTbl ON UsagePct >= RangeBegin AND UsagePct < RangeEnd
			GROUP BY RangeBegin
			) T ON R.RangeBegin = T.RangeBegin
	ORDER BY R.RangeBegin
END
ELSE -- Top 100 users and all users with UsagePct >= 100
BEGIN
	;WITH QuotaUsagePct (UserGUID, SpaceConsumed, UsagePct) AS
	(
		SELECT	UserGUID,
				SUM(SpaceConsumed), SUM(SpaceConsumed)/10.24/1024/SUM(CASE WHEN OrderId = 1 THEN QuotaSizeMB ELSE 0 END)
		FROM	#OrderedQuotaUsage
		GROUP BY UserGUID
		HAVING	MAX(QuotaEnabled) > 0 AND SUM(CASE WHEN OrderId = 1 THEN QuotaSizeMB ELSE 0 END) > 0
			AND SUM(SpaceConsumed)/1024.0/1024 >= SUM(CASE WHEN OrderId = 1 THEN QuotaSizeMB ELSE 0 END)
		UNION
		SELECT	TOP 100 UserGUID,
				SUM(SpaceConsumed), SUM(SpaceConsumed)/10.24/1024/SUM(CASE WHEN OrderId = 1 THEN QuotaSizeMB ELSE 0 END)
		FROM	#OrderedQuotaUsage
		GROUP BY UserGUID
		HAVING	MAX(QuotaEnabled) > 0 AND SUM(CASE WHEN OrderId = 1 THEN QuotaSizeMB ELSE 0 END) > 0
		ORDER BY SUM(SpaceConsumed)/SUM(CASE WHEN OrderId = 1 THEN QuotaSizeMB ELSE 0 END) DESC
	)
	SELECT 	U.UserName AS 'User Name',
			U.QuotaSizeMB AS 'Quota Size<SIZEMB>',
			CAST(1.0*P.SpaceConsumed/1024/1024 AS DECIMAL(20,2)) AS 'Space Consumed<SIZEMB>',
			CAST(P.UsagePct AS DECIMAL(20,2)) AS 'Quota Used (%)',
			DATEDIFF(S, '1970-01-01', U.LastUpdateTime) AS 'Last Backup Time<DATETIME>'
	FROM	#OrderedQuotaUsage U
			INNER JOIN QuotaUsagePct P ON U.UserGUID = P.UserGUID AND U.OrderId = 1
	ORDER BY P.UsagePct DESC
END
DROP TABLE #OrderedQuotaUsage
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptMailboxQuotaUsage')
	delete from GxQscripts where name = 'RptMailboxQuotaUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptMailboxQuotaUsage')
	delete from GXDBVersions where aliasname = 'RptMailboxQuotaUsage'
GO

insert into GXDBVersions values(2, 'RptMailboxQuotaUsage',  '00010006000000000000', 'RptMailboxQuotaUsage', '00010006000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptMediaAgentAudit.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptMediaAgentAudit.sp,v $ $Id: RptMediaAgentAudit.sp,v 1.7 2015/06/29 19:06:08 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptMediaAgentAudit <<<'

IF EXISTS (select * from sysobjects where name='RptMediaAgentAudit')
	drop procedure RptMediaAgentAudit
IF EXISTS (select * from GxQscripts where name='RptMediaAgentAudit')
	delete from GxQscripts where name = 'RptMediaAgentAudit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptMediaAgentAudit')
	delete from GXDBVersions where aliasname = 'RptMediaAgentAudit'
GO
print '... Creating Procedure: RptMediaAgentAudit'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptMediaAgentAudit
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @bAggregate INT = 1,
  @i_stdCommServUniqueID INT = 0,
  @i_stdMAClientID INT = 0,
  @i_CommServUniqueID INT = 0,
  @i_PropertyGroup VARCHAR(32) = ''
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 88
-- default is for all properties
DECLARE @i_PropertyGroupId INT = 0
IF	@i_PropertyGroup = 'Passed Audit'
	SET @i_PropertyGroupId = -1
ELSE IF	@i_PropertyGroup = 'Basic'
	SET @i_PropertyGroupId = 1
ELSE IF	@i_PropertyGroup = 'Index Cache'
	SET @i_PropertyGroupId = 2
ELSE IF	@i_PropertyGroup = 'Firewall'
	SET @i_PropertyGroupId = 3
ELSE IF	@i_PropertyGroup = 'Network Throttle'
	SET @i_PropertyGroupId = 4
DECLARE @stdCustomerName	VARCHAR(256) = ''
DECLARE @isPrivate 			INT = 0
SELECT	@isPrivate = ISNULL(CAST(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
IF	@isPrivate = 0
	SELECT @stdCustomerName = CustomerName FROM cf_CommcellIdNameMap WHERE ID = @i_stdCommServUniqueID
CREATE	TABLE #LatestResult (CommServId INT, SurveyResultId INT, LogDate DATETIME)
INSERT	INTO #LatestResult
SELECT	CommServUniqueId, SurverResultId, LogDate
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, 0, 1, NULL, NULL, @i_UserId,@i_GroupId)
WHERE	(@stdCustomerName = '' OR CustomerName = @stdCustomerName)
IF	@i_stdCommServUniqueID > 0 AND @i_stdMAClientID = 0
BEGIN
	SELECT	MA.CommServUniqueId	AS 'CommServ UniqueId',
			MA.MediaAgentName AS 'MediaAgent',
			MA.MAClientID AS 'MediaAgent ID'
	FROM	#LatestResult LD
			INNER JOIN cf_SurveyMediaAgentProp MA
				ON MA.CommServUniqueId = LD.CommServId AND MA.SurveyResultId = LD.SurveyResultId
	WHERE	MA.CommServUniqueId = @i_stdCommServUniqueID
	ORDER BY MA.MediaAgentName
	DROP TABLE #LatestResult
	RETURN
END
DECLARE @TblMediaAgentFlags	TABLE (flag INT, name VARCHAR(128))
DECLARE @MediaAgentFlags	INT
INSERT INTO @TblMediaAgentFlags
		  SELECT 1, 'Auto Update SCSI ID during live operation'
UNION ALL SELECT 2, 'Use Native device driver for data transfer for tape media'
UNION ALL SELECT 4, 'Mark drive inaccessible on error'
UNION ALL SELECT 8, 'Automatically detect WORM Tape Media'
UNION ALL SELECT 16, 'Mark MediaAgent For Maintenance'
UNION ALL SELECT 32, 'Optimize for concurrent LAN backups'
UNION ALL SELECT 64, 'Enable Error Recovery During Backup'
UNION ALL SELECT 128, 'Use MediaAgent Local Drive'
UNION ALL SELECT 256, 'Data Integrity Validation on Network'
UNION ALL SELECT 512, 'Data Integrity Validation on Media'
UNION ALL SELECT 1024, 'Send pass-thru commands to Atape'
--UNION ALL SELECT MMS2_MA_DDB_SUBCLIENT_BACKUP_ENABLED, 'DDB Subclient Backup Enabled'
--UNION ALL SELECT MMS2_MA_HOST_IS_LIBRARY_SERVER, 'Host is Library Server'
--UNION ALL SELECT MMS2_MA_HOST_PUSHED_FROM_ANOTHER_CS, 'Host Pushed from Another CommServ'
SELECT @MediaAgentFlags	= SUM(Flag) FROM @TblMediaAgentFlags
CREATE TABLE #MediaAgentProp
(
	CommServId				int,
	MAClientID				int NOT NULL,
	MediaAgentName			nvarchar(256) NOT NULL,
	MAReleaseVersion		varchar(8) NOT NULL,
	MAEnabled				int NOT NULL,
	MAAttribute				int NOT NULL,
	ScanIntervalInHour		int NOT NULL,
	MaxReservations			int NOT NULL,
	NwErrorRetryEnabled		int NOT NULL,
	NwErrorRetryFrequency	int NOT NULL,
	NwErrorRetryCount		int NOT NULL,
	AccessPathEnabled		int NOT NULL,
	UseNetworkShare			int NOT NULL,
	IntermediateIndexCache	int NOT NULL,
	IdxCleanupPct			int NOT NULL,
	IdxCacheServerEnabled	int NOT NULL,
	IdxMinFreeSpaceMB		int NOT NULL,
	IdxFreeSpaceWarningMB	int NOT NULL,
	IdxPoolIsShared			int NOT NULL,
	IdxRetentionDays		int NOT NULL,
	FirewallSettings		int NOT NULL,
	FwNetworkWithCS			int NOT NULL,
	FwConnectionWithCS		int NOT NULL,
	FwNetworkWithMA			int NOT NULL,
	FwConnectionWithMA		int NOT NULL,
	FwKeepAliveSeconds		int NOT NULL,
	FwTunnelInitSeconds		int NOT NULL,
	FwForeceSSL				int NOT NULL,
	FwLockDown				int NOT NULL,
	FwBindOpenPortsOnly		int NOT NULL,
	FwIsDMZ					int NOT NULL,
	FwIsRoamingClient		int NOT NULL,
	FwDefOutgoingProtocol	int NOT NULL,
	NwThrottlingEnabled		int NOT NULL,
	NwShareBandwidth		int NOT NULL,
	NwDaysOfWeek			varchar(256) NOT NULL,
	NwStartTime				int NOT NULL,
	NwEndTime				int NOT NULL,
	NwIsAbsolute			int NOT NULL,
	NwSendEnabled			int NOT NULL,
	NwSendRate				int NOT NULL,
	NwSendRatePct			int NOT NULL,
	NwRecvEnabled			int NOT NULL,
	NwRecvRate				int NOT NULL,
	NwRecvRatePct			int NOT NULL
)
INSERT	INTO #MediaAgentProp
SELECT	MA.CommServUniqueId,
		MAClientID,
		MediaAgentName,
		MAReleaseVersion,
		MAEnabled,
		(MAAttribute & @MediaAgentFlags),
		ScanIntervalInSec/3600,
		MaxReservations,
		(NwErrorRetryFlag & 1),
		NwErrorRetryFrequency,
		NwErrorRetryCount,
		AccessPathEnabled,
		UseNetworkShare,
		(AccessPathFlags & 1),
		IdxCleanupPct,
		CASE WHEN IdxPoolIsShared = 1 AND IdxCacheServerClientId > 0 THEN 1 ELSE 0 END,
		IdxMinFreeSpaceMB,
		IdxFreeSpaceWarningMB,
		IdxPoolIsShared,
		IdxRetentionDays,
		FirewallSettings,
		FwNetworkWithCS,
		CASE WHEN FwNetworkWithCS = 1 THEN 1 ELSE FwConnectionWithCS END,
		FwNetworkWithMA,
		CASE WHEN FwNetworkWithMA = 1 THEN 1 ELSE FwConnectionWithMA END,
		FwKeepAliveSeconds,
		FwTunnelInitSeconds,
		FwForeceSSL,
		FwLockDown,
		FwBindOpenPortsOnly,
		FwIsDMZ,
		FwIsRoamingClient,
		FwDefOutgoingProtocol,
		NwThrottlingEnabled,
		NwShareBandwidth,
		CASE WHEN NwDaysOfWeek&1 > 0 THEN 'Sunday ' ELSE '' END + CASE WHEN NwDaysOfWeek&2 > 0 THEN 'Monday ' ELSE '' END +
		CASE WHEN NwDaysOfWeek&4 > 0 THEN 'Tuesday ' ELSE '' END + CASE WHEN NwDaysOfWeek&8 > 0 THEN 'Wednesday ' ELSE '' END +
		CASE WHEN NwDaysOfWeek&16> 0 THEN 'Thursday ' ELSE '' END + CASE WHEN NwDaysOfWeek&32> 0 THEN 'Friday ' ELSE '' END +
		CASE WHEN NwDaysOfWeek&64> 0 THEN 'Saturday' ELSE '' END,
		NwStartTime,
		NwEndTime,
		NwIsAbsolute,
		NwSendEnabled,
		NwSendRate,
		NwSendRatePct,
		NwRecvEnabled,
		NwRecvRate,
		NwRecvRatePct
FROM	#LatestResult LD
		INNER JOIN cf_SurveyMediaAgentProp MA
			ON MA.CommServUniqueId = LD.CommServId AND MA.SurveyResultId = LD.SurveyResultId
WHERE	(MA.CommServUniqueId = @i_stdCommServUniqueID AND MAClientID = @i_stdMAClientID
		OR  @i_CommServUniqueID = 0 OR MA.CommServUniqueId = @i_CommServUniqueID)
DECLARE	@TblPassedMA TABLE (CommServId INT, MAClientId INT, MediaAgentName NVARCHAR(256))
INSERT	INTO @TblPassedMA
SELECT	P.CommServId, P.MAClientId, P.MediaAgentName
FROM	#MediaAgentProp P INNER JOIN
		(SELECT * FROM #MediaAgentProp WHERE CommServId = @i_stdCommServUniqueID AND MAClientId = @i_stdMAClientID) S
	ON	(P.CommServId <> S.CommServId OR P.MAClientId <> S.MAClientId)
	AND P.MAReleaseVersion		= S.MAReleaseVersion
	AND P.MAEnabled				= S.MAEnabled
	AND P.MAAttribute			= S.MAAttribute
	AND P.ScanIntervalInHour	= S.ScanIntervalInHour
	AND P.MaxReservations		= S.MaxReservations
	AND P.NwErrorRetryEnabled	= S.NwErrorRetryEnabled
	AND P.NwErrorRetryFrequency	= S.NwErrorRetryFrequency
	AND P.NwErrorRetryCount		= S.NwErrorRetryCount
	AND P.AccessPathEnabled		= S.AccessPathEnabled
	AND P.UseNetworkShare		= S.UseNetworkShare
	AND P.IntermediateIndexCache= S.IntermediateIndexCache
	AND P.IdxCleanupPct			= S.IdxCleanupPct
	AND P.IdxCacheServerEnabled	= S.IdxCacheServerEnabled
	AND P.IdxMinFreeSpaceMB		= S.IdxMinFreeSpaceMB
	AND P.IdxFreeSpaceWarningMB	= S.IdxFreeSpaceWarningMB
	AND P.IdxPoolIsShared		= S.IdxPoolIsShared
	AND P.IdxRetentionDays		= S.IdxRetentionDays
	AND P.FirewallSettings		= S.FirewallSettings
	AND (P.FirewallSettings		= 0
		OR	P.FirewallSettings	= 1
			AND P.FwNetworkWithCS		= S.FwNetworkWithCS
			AND P.FwConnectionWithCS	= S.FwConnectionWithCS
			AND P.FwNetworkWithMA		= S.FwNetworkWithMA
			AND P.FwConnectionWithMA	= S.FwConnectionWithMA
		OR	P.FirewallSettings	= 2
			AND P.FwKeepAliveSeconds	= S.FwKeepAliveSeconds
			AND P.FwTunnelInitSeconds	= S.FwTunnelInitSeconds
			AND P.FwForeceSSL			= S.FwForeceSSL
			AND P.FwLockDown			= S.FwLockDown
			AND P.FwBindOpenPortsOnly	= S.FwBindOpenPortsOnly
			AND P.FwIsDMZ				= S.FwIsDMZ
			AND P.FwIsRoamingClient		= S.FwIsRoamingClient
			AND P.FwDefOutgoingProtocol	= S.FwDefOutgoingProtocol
		)
	AND P.NwThrottlingEnabled	= S.NwThrottlingEnabled
	AND (P.NwThrottlingEnabled	= 0
		OR	P.NwShareBandwidth	= S.NwShareBandwidth
			AND P.NwDaysOfWeek	= S.NwDaysOfWeek
			AND P.NwStartTime	= S.NwStartTime
			AND P.NwEndTime		= S.NwEndTime
			AND P.NwIsAbsolute	= S.NwIsAbsolute
			AND P.NwSendEnabled	= S.NwSendEnabled
			AND P.NwSendRate	= S.NwSendRate
			AND P.NwSendRatePct	= S.NwSendRatePct
			AND P.NwRecvEnabled	= S.NwRecvEnabled
			AND P.NwRecvRate	= S.NwRecvRate
			AND P.NwRecvRatePct	= S.NwRecvRatePct
		)
IF	@i_PropertyGroupId = -1
BEGIN
	IF	@i_CommServUniqueID = 0
		SELECT	CS.CommServName	AS 'CommCell',
				P.MediaAgentName AS 'MediaAgent'
		FROM	@TblPassedMA P
				INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
		ORDER BY CS.CommServName, P.MediaAgentName
	ELSE
		SELECT	MediaAgentName AS 'MediaAgent'
		FROM	@TblPassedMA
		ORDER BY MediaAgentName
	DROP TABLE #LatestResult
	DROP TABLE #MediaAgentProp
	RETURN
END
DECLARE	@TblMACount TABLE (CommServId INT, Count INT)
INSERT	INTO @TblMACount
SELECT	CommServId, COUNT(MAClientId)
FROM	#MediaAgentProp
WHERE	CommServId <> @i_stdCommServUniqueID OR MAClientId <> @i_stdMAClientID
GROUP BY CommServId
DELETE	#MediaAgentProp
FROM	@TblPassedMA P
WHERE	#MediaAgentProp.CommServId = P.CommServId AND #MediaAgentProp.MAClientId = P.MAClientId
DECLARE	@stdMAReleaseVersion	VARCHAR(8)
DECLARE	@stdMAAttribute			INT
DECLARE	@stdNwDaysOfWeek		VARCHAR(256)
SELECT	@stdMAReleaseVersion	= MAReleaseVersion,
		@stdMAAttribute			= MAAttribute,
		@stdNwDaysOfWeek		= NwDaysOfWeek
FROM	#MediaAgentProp
WHERE	CommServId = @i_stdCommServUniqueID AND MAClientId = @i_stdMAClientID
UPDATE	#MediaAgentProp SET ScanIntervalInHour = S.ScanIntervalInHour
FROM	(SELECT * FROM #MediaAgentProp WHERE CommServId = @i_stdCommServUniqueID AND MAClientId = @i_stdMAClientID) S
WHERE	(#MediaAgentProp.CommServId <> @i_stdCommServUniqueID OR #MediaAgentProp.MAClientId <> @i_stdMAClientID)
	AND ((#MediaAgentProp.MAAttribute & 1) = 0
		OR (S.MAAttribute & 1) = 0)
UPDATE	#MediaAgentProp SET NwErrorRetryFrequency = S.NwErrorRetryFrequency, NwErrorRetryCount = S.NwErrorRetryCount
FROM	(SELECT * FROM #MediaAgentProp WHERE CommServId = @i_stdCommServUniqueID AND MAClientId = @i_stdMAClientID) S
WHERE	(#MediaAgentProp.CommServId <> @i_stdCommServUniqueID OR #MediaAgentProp.MAClientId <> @i_stdMAClientID)
	AND (#MediaAgentProp.NwErrorRetryEnabled = 0 OR S.NwErrorRetryEnabled = 0)
UPDATE	#MediaAgentProp
SET		FwKeepAliveSeconds = S.FwKeepAliveSeconds, FwTunnelInitSeconds = S.FwTunnelInitSeconds, FwForeceSSL = S.FwForeceSSL, FwLockDown = S.FwLockDown,
		FwBindOpenPortsOnly = S.FwBindOpenPortsOnly, FwIsDMZ = S.FwIsDMZ, FwIsRoamingClient = S.FwIsRoamingClient, FwDefOutgoingProtocol = S.FwDefOutgoingProtocol
FROM	(SELECT * FROM #MediaAgentProp WHERE CommServId = @i_stdCommServUniqueID AND MAClientId = @i_stdMAClientID) S
WHERE	(#MediaAgentProp.CommServId <> @i_stdCommServUniqueID OR #MediaAgentProp.MAClientId <> @i_stdMAClientID)
	AND (#MediaAgentProp.FirewallSettings IN (0, 1) OR S.FirewallSettings IN (0, 1))
UPDATE	#MediaAgentProp
SET		FwNetworkWithCS = S.FwNetworkWithCS, FwConnectionWithCS = S.FwConnectionWithCS,
		FwNetworkWithMA = S.FwNetworkWithMA, FwConnectionWithMA = S.FwConnectionWithMA
FROM	(SELECT * FROM #MediaAgentProp WHERE CommServId = @i_stdCommServUniqueID AND MAClientId = @i_stdMAClientID) S
WHERE	(#MediaAgentProp.CommServId <> @i_stdCommServUniqueID OR #MediaAgentProp.MAClientId <> @i_stdMAClientID)
	AND (#MediaAgentProp.FirewallSettings IN (0, 2) OR S.FirewallSettings IN (0, 2))
UPDATE	#MediaAgentProp
SET		NwShareBandwidth = S.NwShareBandwidth, NwDaysOfWeek = S.NwDaysOfWeek,
		NwStartTime = S.NwStartTime, NwEndTime = S.NwEndTime, NwIsAbsolute = S.NwIsAbsolute,
		NwSendEnabled = S.NwSendEnabled, NwSendRate = S.NwSendRate, NwSendRatePct = S.NwSendRatePct,
		NwRecvEnabled = S.NwRecvEnabled, NwRecvRate = S.NwRecvRate, NwRecvRatePct = S.NwRecvRatePct
FROM	(SELECT * FROM #MediaAgentProp WHERE CommServId = @i_stdCommServUniqueID AND MAClientId = @i_stdMAClientID) S
WHERE	(#MediaAgentProp.CommServId <> @i_stdCommServUniqueID OR #MediaAgentProp.MAClientId <> @i_stdMAClientID)
	AND (#MediaAgentProp.NwThrottlingEnabled = 0 OR S.NwThrottlingEnabled = 0)
CREATE	TABLE #MediaAgentProperty (CommServId INT, MAClientId INT, PropertyGroup INT, Property VARCHAR(128), Value NVARCHAR(MAX), stdValue NVARCHAR(MAX))
;WITH MediaAgentProperty (CommServId, MAClientId, Property, Value) AS
(
	SELECT	P.CommServId, P.MAClientId, P.Property, P.Value
	FROM	#MediaAgentProp
			UNPIVOT (Value FOR Property IN (
				MAEnabled, ScanIntervalInHour, MaxReservations,
				NwErrorRetryEnabled, NwErrorRetryFrequency, NwErrorRetryCount,
				AccessPathEnabled, UseNetworkShare, IntermediateIndexCache, IdxCleanupPct, IdxCacheServerEnabled,
				IdxMinFreeSpaceMB, IdxFreeSpaceWarningMB, IdxPoolIsShared, IdxRetentionDays,
				FirewallSettings, FwNetworkWithCS, FwConnectionWithCS, FwNetworkWithMA, FwConnectionWithMA,
				FwKeepAliveSeconds, FwTunnelInitSeconds, FwForeceSSL, FwLockDown,
				FwBindOpenPortsOnly, FwIsDMZ, FwIsRoamingClient, FwDefOutgoingProtocol,
				NwThrottlingEnabled, NwShareBandwidth, NwStartTime, NwEndTime, NwIsAbsolute,
				NwSendEnabled, NwSendRate, NwSendRatePct, NwRecvEnabled, NwRecvRate, NwRecvRatePct)
			) P
)
INSERT	INTO #MediaAgentProperty
SELECT	P.CommServId, P.MAClientId,
		CASE WHEN P.Property IN ('MAEnabled', 'ScanIntervalInHour', 'MaxReservations',
								'NwErrorRetryEnabled', 'NwErrorRetryFrequency', 'NwErrorRetryCount') THEN 1
			WHEN P.Property IN ('AccessPathEnabled', 'UseNetworkShare', 'IntermediateIndexCache', 'IdxCleanupPct', 'IdxCacheServerEnabled',
								'IdxMinFreeSpaceMB', 'IdxFreeSpaceWarningMB', 'IdxPoolIsShared', 'IdxRetentionDays') THEN 2
			WHEN P.Property IN ('FirewallSettings',  'FwNetworkWithCS', 'FwConnectionWithCS', 'FwNetworkWithMA', 'FwConnectionWithMA',
								'FwKeepAliveSeconds', 'FwTunnelInitSeconds', 'FwForeceSSL', 'FwLockDown',
								'FwBindOpenPortsOnly', 'FwIsDMZ', 'FwIsRoamingClient', 'FwDefOutgoingProtocol') THEN 3
			WHEN P.Property IN ('NwThrottlingEnabled', 'NwShareBandwidth', 'NwStartTime', 'NwEndTime', 'NwIsAbsolute', 'NwSendEnabled',
								'NwSendRate', 'NwSendRatePct', 'NwRecvEnabled', 'NwRecvRate', 'NwRecvRatePct') THEN 4
		END,
		CASE WHEN P.Property = 'MAEnabled' THEN 'Enable MediaAgent'
			WHEN P.Property = 'ScanIntervalInHour' THEN 'SCSI/SAN device scan interval N Hour(s)'
			WHEN P.Property = 'MaxReservations' THEN 'Maximum number of parallel data transfer operations'
			WHEN P.Property = 'NwErrorRetryEnabled' THEN 'Enable retry on network errors'
			WHEN P.Property = 'NwErrorRetryFrequency' THEN 'Retry Frequency (seconds) on network errors'
			WHEN P.Property = 'NwErrorRetryCount' THEN 'Retry Count on network errors'
			WHEN P.Property = 'AccessPathEnabled' THEN 'Access Path Enabled'
			WHEN P.Property = 'UseNetworkShare' THEN 'Cache Directory Folder Type: Use Network Share'
			WHEN P.Property = 'IntermediateIndexCache' THEN 'Enable Intermediate Index Cache Directory'
			WHEN P.Property = 'IdxCleanupPct' THEN 'Index Cleanup Percent'
			WHEN P.Property = 'IdxCacheServerEnabled' THEN 'Index Cache Server'
			WHEN P.Property = 'IdxMinFreeSpaceMB' THEN 'Index Cache: Minimum Free Space (MB)'
			WHEN P.Property = 'IdxFreeSpaceWarningMB' THEN 'Index Cache: Free Space Warning (MB)'
			WHEN P.Property = 'IdxPoolIsShared' THEN 'Catalog Profile'
			WHEN P.Property = 'IdxRetentionDays' THEN 'Index retention time in days'
			WHEN P.Property = 'FirewallSettings' THEN 'Configure Firewall Settings'
			WHEN P.Property = 'FwNetworkWithCS' THEN 'CommServe Connectivity'
			WHEN P.Property = 'FwConnectionWithCS' THEN 'CommServe Connectivity: When connecting from outside'
			WHEN P.Property = 'FwNetworkWithMA' THEN 'MediaAgent Connectivity'
			WHEN P.Property = 'FwConnectionWithMA' THEN 'MediaAgent Connectivity: When connecting from outside'
			WHEN P.Property = 'FwKeepAliveSeconds' THEN 'Firewall Options: Keep-alive Interval (seconds)'
			WHEN P.Property = 'FwTunnelInitSeconds' THEN 'Firewall Options: Tunnel Init Interval (seconds)'
			WHEN P.Property = 'FwForeceSSL' THEN 'Firewall Options: Force SSL authentication in incoming tunnel connections'
			WHEN P.Property = 'FwLockDown' THEN 'Firewall Options: Force per-client certificate based authentication'
			WHEN P.Property = 'FwBindOpenPortsOnly' THEN 'Firewall Options: Bind all services to open ports only'
			WHEN P.Property = 'FwIsDMZ' THEN 'Firewall Options: This computer is in DMZ and will work as a proxy'
			WHEN P.Property = 'FwIsRoamingClient' THEN 'Firewall Options: Roaming client'
			WHEN P.Property = 'FwDefOutgoingProtocol' THEN 'Firewall Default Outgoing Tunnel Protocol'
			WHEN P.Property = 'NwThrottlingEnabled' THEN 'Enable Network Throttling'
			WHEN P.Property = 'NwShareBandwidth' THEN 'All clients share allocation bandwidth'
			WHEN P.Property = 'NwStartTime' THEN 'Throttling Rule: Time interval start'
			WHEN P.Property = 'NwEndTime' THEN 'Throttling Rule: Time interval end'
			WHEN P.Property = 'NwIsAbsolute' THEN 'Use Absolute Throttling'
			WHEN P.Property = 'NwSendEnabled' THEN 'Enable Throttle Send'
			WHEN P.Property = 'NwSendRate' THEN 'Throttle Send (Kbps)'
			WHEN P.Property = 'NwSendRatePct' THEN 'If send bandwidth is less than (Kbps) throttle at (%)'
			WHEN P.Property = 'NwRecvEnabled' THEN 'Enable Throttle Receive'
			WHEN P.Property = 'NwRecvRate' THEN 'Throttle Receive (Kbps)'
			WHEN P.Property = 'NwRecvRatePct' THEN 'If receive bandwidth is less than (Kbps) throttle at (%)'
		END,
		CASE WHEN P.Property IN ('MAEnabled', 'NwErrorRetryEnabled', 'AccessPathEnabled', 'UseNetworkShare', 'IntermediateIndexCache',
								'IdxCacheServerEnabled', 'IdxPoolIsShared', 'FwConnectionWithCS', 'FwConnectionWithMA',
								'FwForeceSSL', 'FwLockDown', 'FwBindOpenPortsOnly', 'FwIsDMZ', 'FwIsRoamingClient',
								'NwThrottlingEnabled', 'NwShareBandwidth', 'NwIsAbsolute', 'NwSendEnabled', 'NwRecvEnabled')
				THEN (CASE P.Value WHEN 0 THEN 'No' ELSE 'Yes' END)
			WHEN P.Property IN ('NwStartTime', 'NwEndTime') THEN RIGHT(CONVERT(VARCHAR, DATEADD(s, P.value, 0), 100), 7)
			WHEN P.Property = 'FirewallSettings' THEN (CASE P.value WHEN 1 THEN 'Basic' WHEN 2 THEN 'Advanced' ELSE 'No' END)
			WHEN P.Property = 'FwNetworkWithCS'  THEN (CASE P.value WHEN 1 THEN 'Always in the same network as CommServe'
																	WHEN 2 THEN 'Always outside of CommServe network'
																	WHEN 3 THEN 'May travel outside of CommServe network'
																	ELSE 'No' END)
			WHEN P.Property = 'FwNetworkWithMA'  THEN (CASE P.value WHEN 1 THEN 'Always in the same network as MediaAgent'
																	WHEN 2 THEN 'Always outside of MediaAgent network'
																	WHEN 3 THEN 'May travel outside of MediaAgent network'
																	ELSE 'No' END)
			WHEN P.Property = 'FwConnectionWithCS' THEN (CASE P.value WHEN 1 THEN 'Open tunnel directly to CommServe'
																	WHEN 2 THEN 'Use remote proxy'
																	ELSE 'No' END)
			WHEN P.Property = 'FwConnectionWithMA' THEN (CASE P.value WHEN 1 THEN 'Open tunnel directly to MediaAgent'
																	WHEN 2 THEN 'Use remote proxy'
																	ELSE 'No' END)
			WHEN P.Property = 'FwDefOutgoingProtocol' THEN (CASE P.Value WHEN 0 THEN 'HTTP' WHEN 1 THEN 'HTTPS' ELSE 'HTTP Auth Only' END)
			WHEN P.Value = -1 THEN 'Infinite' ELSE CAST (P.Value AS VARCHAR(32))
		END,
		CASE WHEN S.Property IN ('MAEnabled', 'NwErrorRetryEnabled', 'AccessPathEnabled', 'UseNetworkShare', 'IntermediateIndexCache',
								'IdxCacheServerEnabled', 'IdxPoolIsShared', 'FwConnectionWithCS', 'FwConnectionWithMA',
								'FwForeceSSL', 'FwLockDown', 'FwBindOpenPortsOnly', 'FwIsDMZ', 'FwIsRoamingClient',
								'NwThrottlingEnabled', 'NwShareBandwidth', 'NwIsAbsolute', 'NwSendEnabled', 'NwRecvEnabled')
				THEN (CASE S.Value WHEN 0 THEN 'No' ELSE 'Yes' END)
			WHEN S.Property IN ('NwStartTime', 'NwEndTime') THEN RIGHT(CONVERT(VARCHAR, DATEADD(s, S.value, 0), 100), 7)
			WHEN S.Property = 'FirewallSettings' THEN (CASE S.value WHEN 1 THEN 'Basic' WHEN 2 THEN 'Advanced' ELSE 'No' END)
			WHEN S.Property = 'FwNetworkWithCS'  THEN (CASE S.value WHEN 1 THEN 'Always in the same network as CommServe'
																	WHEN 2 THEN 'Always outside of CommServe network'
																	WHEN 3 THEN 'May travel outside of CommServe network'
																	ELSE 'No' END)
			WHEN S.Property = 'FwNetworkWithMA'  THEN (CASE S.value WHEN 1 THEN 'Always in the same network as MediaAgent'
																	WHEN 2 THEN 'Always outside of MediaAgent network'
																	WHEN 3 THEN 'May travel outside of MediaAgent network'
																	ELSE 'No' END)
			WHEN S.Property = 'FwConnectionWithCS' THEN (CASE S.value WHEN 1 THEN 'Open tunnel directly to CommServe'
																	WHEN 2 THEN 'Use remote proxy'
																	ELSE 'No' END)
			WHEN S.Property = 'FwConnectionWithMA' THEN (CASE S.value WHEN 1 THEN 'Open tunnel directly to MediaAgent'
																	WHEN 2 THEN 'Use remote proxy'
																	ELSE 'No' END)
			WHEN S.Property = 'FwDefOutgoingProtocol' THEN (CASE S.Value WHEN 0 THEN 'HTTP' WHEN 1 THEN 'HTTPS' ELSE 'HTTP Auth Only' END)
			WHEN S.Value = -1 THEN 'Infinite' ELSE CAST (S.Value AS VARCHAR(32))
		END
FROM	MediaAgentProperty P
		INNER JOIN
		(
			SELECT	Property, Value
			FROM	MediaAgentProperty
			WHERE	CommServId = @i_stdCommServUniqueID AND MAClientId = @i_stdMAClientID
		) S
		ON P.Property = S.Property AND P.Value <> S.Value
IF	@i_PropertyGroupId IN (0, 1)
BEGIN
	INSERT	INTO #MediaAgentProperty
	SELECT	CommServId, MAClientId, 1, 'MediaAgent Version', MAReleaseVersion, @stdMAReleaseVersion
	FROM	#MediaAgentProp
	WHERE	MAReleaseVersion <> @stdMAReleaseVersion
	INSERT	INTO #MediaAgentProperty
	SELECT	P.CommServId, P.MAClientId, 1, F.name,
			CASE WHEN (P.MAAttribute & F.flag) = 0 THEN 'No' ELSE 'Yes' END,
			CASE WHEN (@stdMAAttribute & F.flag) = 0 THEN 'No' ELSE 'Yes' END
	FROM	(SELECT CommServId, MAClientId, MAAttribute FROM #MediaAgentProp WHERE MAAttribute <> @stdMAAttribute) P
			CROSS JOIN @TblMediaAgentFlags F
	WHERE	(P.MAAttribute & F.flag) <> (@stdMAAttribute & F.flag)
END
IF	@i_PropertyGroupId IN (0, 4)
BEGIN
	INSERT	INTO #MediaAgentProperty
	SELECT	CommServId, MAClientId, 4, 'Throttling Rule: Weekdays', NwDaysOfWeek, @stdNwDaysOfWeek
	FROM	#MediaAgentProp
	WHERE	NwDaysOfWeek <> @stdNwDaysOfWeek
END
IF @bAggregate = 1
BEGIN
	DECLARE	@TblSummary TABLE (CommServId INT, MACount INT, AllProp INT, Basic INT, IndexCache INT, Firewall INT, Throttle INT)
	INSERT	INTO @TblSummary
	SELECT	P.CommServId, 0, 0, ISNULL([1], 0), ISNULL([2], 0), ISNULL([3], 0), ISNULL([4], 0)
	FROM	(SELECT	CommServId, PropertyGroup, COUNT(DISTINCT MAClientId) AS Counts
			FROM	#MediaAgentProperty
			GROUP BY CommServId, PropertyGroup) AS S
			PIVOT (MAX(Counts) FOR S.PropertyGroup IN ([1], [2], [3], [4])) AS P
	UPDATE	@TblSummary
	SET		MACount = C.Count
	FROM	@TblSummary T
			INNER JOIN @TblMACount C ON T.CommServId = C.CommServId
	UPDATE	@TblSummary
	SET		AllProp = S.Counts
	FROM	@TblSummary T
			INNER JOIN
			(SELECT	CommServId, COUNT(DISTINCT MAClientId) AS Counts
			FROM	#MediaAgentProperty
			GROUP BY CommServId) AS S
			ON T.CommServId = S.CommServId
	IF	NOT EXISTS (SELECT * FROM @TblSummary)
	INSERT	INTO @TblSummary
	SELECT	CommServId, Count, 0, 0, 0, 0, 0
	FROM	@TblMACount
	SELECT	'All CommCells' AS 'CommCell',
			'' AS 'CommServ UniqueId',
			'' AS 'CommCell ID',
			D.MACount		AS 'All MediaAgents',
			(SELECT COUNT(*) FROM @TblPassedMA)	AS 'Passed Audit',
			D.Basic			AS 'Basic',
			D.IndexCache	AS 'Index Cache',
			D.Firewall		AS 'Firewall',
			D.Throttle		AS 'Network Throttle',
			D.AllProp		AS 'Any',
			'' AS 'Collection Time (Time Zone)',
			-1				AS 'FirstOrder'
	FROM	(SELECT SUM(MACount) AS MACount, SUM(AllProp) AS AllProp, SUM(Basic) AS Basic,
					SUM(IndexCache) AS IndexCache, SUM(Firewall) AS Firewall, SUM(Throttle) AS Throttle
			FROM	@TblSummary) D
	UNION ALL
	SELECT	CASE
				WHEN @isPrivate = 1 THEN CS.CommServName
				ELSE CS.CustomerName + ' - ' + CS.CommServName
			END AS 'CommCell',
			CS.ID			AS 'CommServ UniqueId',
			CS.CommCellID	AS 'CommCell ID',
			D.MACount		AS 'All Policies',
			(SELECT COUNT(*) FROM @TblPassedMA WHERE CommServId = D.CommServId)	AS 'Passed Audit',
			D.Basic			AS 'Basic',
			D.IndexCache	AS 'Index Cache',
			D.Firewall		AS 'Firewall',
			D.Throttle		AS 'Network Throttle',
			D.AllProp		AS 'Any',
			CONVERT(VARCHAR(20), LR.LogDate, 100) + ' (' + CS.CommServTZ + ')' AS 'Collection Time (Time Zone)',
			0				AS 'FirstOrder'
	FROM	@TblSummary D
			INNER JOIN cf_CommcellIdNameMap CS ON D.CommServId = CS.ID
			INNER JOIN #LatestResult LR ON D.CommServId = LR.CommServId
	ORDER BY 'FirstOrder', 'CommCell'
END
ELSE
BEGIN
	IF	@i_PropertyGroupId <> 0
		DELETE #MediaAgentProperty WHERE PropertyGroup <> @i_PropertyGroupId
	IF @i_CommServUniqueID = 0
		SELECT	CASE
					WHEN @isPrivate = 1 THEN CS.CommServName
					ELSE CS.CustomerName + ' - ' + CS.CommServName
				END AS 'CommCell',
				S.MediaAgentName AS 'MediaAgent',
				P.Property		AS 'Property',
				P.Value			AS 'Value',
				P.stdValue		AS 'Template Value'
		FROM	#MediaAgentProperty P
				INNER JOIN #MediaAgentProp S ON P.CommServId = S.CommServId AND P.MAClientId = S.MAClientId
				INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
		ORDER BY CS.CommServName, S.MediaAgentName, P.PropertyGroup, P.Property
	ELSE
		SELECT	S.MediaAgentName AS 'MediaAgent',
				P.Property		AS 'Property',
				P.Value			AS 'Value',
				P.stdValue		AS 'Template Value'
		FROM	#MediaAgentProperty P
				INNER JOIN #MediaAgentProp S ON P.CommServId = S.CommServId AND P.MAClientId = S.MAClientId
		ORDER BY S.MediaAgentName, P.PropertyGroup, P.Property
END
DROP TABLE #LatestResult
DROP TABLE #MediaAgentProp
DROP TABLE #MediaAgentProperty
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptMediaAgentAudit')
	delete from GxQscripts where name = 'RptMediaAgentAudit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptMediaAgentAudit')
	delete from GXDBVersions where aliasname = 'RptMediaAgentAudit'
GO

insert into GXDBVersions values(2, 'RptMediaAgentAudit',  '00010007000000000000', 'RptMediaAgentAudit', '00010007000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptMediaManagementSummary.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptMediaManagementSummary.sp,v $ $Id: RptMediaManagementSummary.sp,v 1.15 2015/07/06 20:31:48 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptMediaManagementSummary <<<'

IF EXISTS (select * from sysobjects where name='RptMediaManagementSummary')
	drop procedure RptMediaManagementSummary
IF EXISTS (select * from GxQscripts where name='RptMediaManagementSummary')
	delete from GxQscripts where name = 'RptMediaManagementSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptMediaManagementSummary')
	delete from GXDBVersions where aliasname = 'RptMediaManagementSummary'
GO
print '... Creating Procedure: RptMediaManagementSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptMediaManagementSummary
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_Aggregate INT = 0,
  @i_CommServUniqueID INT = 0,
  @i_OnController INT = 0,
  @i_Entity VARCHAR(16) = 'MediaAgent' -- or 'Library' or 'MountPath' or 'Drive'
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 117
DECLARE @i_QueryId96 BIGINT = 96
DECLARE @i_QueryId95 BIGINT = 95
DECLARE @top INT =15
DECLARE @IsPrivate INT = 0
SELECT	@IsPrivate = ISNULL(CAST(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
IF object_id('tempdb.dbo.#LatestResult') is not null DROP TABLE #LatestResult
CREATE	TABLE #LatestResult (
		CommServUniqueId INT,
		CommCellId INT,
		CustomerName NVARCHAR(256),
		CommServName NVARCHAR(256),
		SurveyResultId INT,
		LogDate	DATETIME)
INSERT	INTO #LatestResult
SELECT	CommServUniqueId, CommCellId, CustomerName, CommServName, SurverResultId, LogDate
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId,@i_GroupId)
IF object_id('tempdb.dbo.#LatestResult96') is not null DROP TABLE #LatestResult96
CREATE	TABLE #LatestResult96 (
		CommServUniqueId INT,
		CommCellId INT,
		CustomerName NVARCHAR(256),
		CommServName NVARCHAR(256),
		SurveyResultId INT,
		LogDate	DATETIME)
IF object_id('tempdb.dbo.#LatestResult95') is not null DROP TABLE #LatestResult95
CREATE	TABLE #LatestResult95 (
		CommServUniqueId INT,
		CommCellId INT,
		CustomerName NVARCHAR(256),
		CommServName NVARCHAR(256),
		SurveyResultId INT,
		LogDate	DATETIME)
IF @i_Entity = 'Library'
BEGIN
	INSERT	INTO #LatestResult96
	SELECT	CommServUniqueId, CommCellId, CustomerName, CommServName, SurverResultId, LogDate
	FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId96, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId,@i_GroupId)
END
IF @i_Entity = 'MountPath'  OR  @i_Aggregate = 1 OR @i_Entity = 'Library'
BEGIN
	INSERT	INTO #LatestResult95
	SELECT	CommServUniqueId, CommCellId, CustomerName, CommServName, SurverResultId, LogDate
	FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId95, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId,@i_GroupId)
END
IF @i_Aggregate = 1
BEGIN
	SELECT TOP (@top) L.LibraryName AS 'Library',
		   CASE WHEN libInfo.UsedSpaceGB 			IS NULL THEN -1 ELSE (libInfo.UsedSpaceGB)*1024 END	AS 'Used Space<SIZEMB>',
		   CASE WHEN libInfo.FreeSpaceGB 			IS NULL THEN -1 ELSE (libInfo.FreeSpaceGB)*1024 END	AS 'Free Space<SIZEMB>'
	FROM	cf_SurveyLibrarySummary AS L WITH (NOLOCK)
			INNER JOIN #LatestResult R ON L.SurveyResultId = R.SurveyResultId
			INNER JOIN
				 (SELECT libInfo.CommServUniqueId, libInfo.LibraryId, SUM(libInfo.UsedSpaceGB) AS UsedSpaceGB, SUM(libInfo.FreeSpaceGB)AS FreeSpaceGB
				  FROM cf_Survey95MountPathDetails AS libInfo WITH (NOLOCK)
				  INNER JOIN #LatestResult95 R ON libInfo.SurveyResultId = R.SurveyResultId
				  GROUP BY libInfo.CommServUniqueId, libInfo.LibraryId
				  ) libInfo ON
			libInfo.CommServUniqueId= R.CommServUniqueId AND
			libInfo.LibraryId= L.LibraryId
 		ORDER BY 'Free Space<SIZEMB>' ASC,'Used Space<SIZEMB>' ASC
END
ELSE
IF @i_Entity = 'MediaAgent'
BEGIN
	SELECT 	R.CommServUniqueId  AS 'CommServ UniqueId',
			R.CommCellID AS 'CommCell ID',
			(CASE WHEN @IsPrivate = 1 THEN '' ELSE ISNULL(R.CustomerName, '') + ' - ' END) + ISNULL(R.CommServName, '') AS 'CommCell Name',
			MA.MediaAgentName AS 'MediaAgent',
			CASE WHEN MA.Offline = 1 THEN 'Yes' ELSE 'No' END AS 'Offline',
			CASE (MA.OfflineReason * MA.Offline)
				WHEN 0 THEN (CASE WHEN MA.Offline = 0 THEN '' ELSE 'N/A' END)
				WHEN 1 THEN 'Communication Error'
				WHEN 2 THEN 'Version Mismatch'
				WHEN 3 THEN 'Disabled '
				WHEN 4 THEN 'Disabled on GracePeriod expiry'
				WHEN 5 THEN 'Initializing'
				ELSE 'N/A'
			END AS 'Failure Reason<HIDDEN>',
			CASE WHEN MA.Offline = 1 AND MA.OfflineTimeStamp > 0 THEN MA.OfflineTimeStamp
				ELSE -100 END AS 'Not Operational Since<MMMDDYYYYHrMinAM><HIDDEN>',										-- -100 value is for empty string at frontend
			MA.OSName AS 'OS',
			MA.ReleaseVersion AS 'Product Version'
	FROM	cf_SurveyMediaAgentSummary AS MA WITH (NOLOCK)
			INNER JOIN #LatestResult R ON MA.SurveyResultId = R.SurveyResultId
	ORDER BY 'CommCell Name', MA.MediaAgentName
END
ELSE
IF @i_Entity = 'Library'
BEGIN
		--Never value should be lower than (N/A), to get sorting like Date->Never->N/A order
			DECLARE @Never  BIGINT= CAST(0x7FFFFFFFFF AS bigint)-1
			DECLARE @NA  BIGINT =CAST(0x7FFFFFFFFF AS bigint)
	;WITH Controller (SurveyResultId, LibraryId, Operational, MAName) AS
	(
		SELECT	L.SurveyResultId, L.LibraryId, ISNULL(Active&Enabled, 0), ISNULL(MA.MediaAgentName, '')
		FROM	cf_SurveyLibrarySummary AS L WITH (NOLOCK)
				INNER JOIN #LatestResult R ON L.SurveyResultId = R.SurveyResultId
				LEFT OUTER JOIN cf_SurveyLibraryControllerSummary AS LC WITH (NOLOCK)
					ON L.SurveyResultId = LC.SurveyResultId AND L.LibraryId = LC.LibraryId
				LEFT OUTER JOIN cf_SurveyMediaAgentSummary MA WITH (NOLOCK)
					ON MA.SurveyResultId = LC.SurveyResultId AND MA.MAClientId = LC.MAClientId
		GROUP BY L.SurveyResultId, L.LibraryId, ISNULL(Active&Enabled, 0), ISNULL(MA.MediaAgentName, '')
	)
	, ControllerStr (SurveyResultId, LibraryId, Operational, NotOperational) AS
	(
		SELECT	SurveyResultId, LibraryId,
				STUFF((SELECT ' : ' + MAName FROM Controller
						WHERE SurveyResultId = A.SurveyResultId AND LibraryId = A.LibraryId AND Operational = 1
						ORDER BY MAName FOR XML PATH('')), 1, 3, ''),
				STUFF((SELECT ' : ' + MAName FROM Controller
						WHERE SurveyResultId = A.SurveyResultId AND LibraryId = A.LibraryId AND Operational = 0
						ORDER BY MAName FOR XML PATH('')), 1, 3, '')
		FROM	Controller A
		GROUP BY SurveyResultId, LibraryId
	)
	SELECT 	R.CommServUniqueId  AS 'CommServ UniqueId',
			R.CommCellID AS 'CommCell ID',
			(CASE WHEN @IsPrivate = 1 THEN '' ELSE ISNULL(R.CustomerName, '') + ' - ' END) + ISNULL(R.CommServName, '') AS 'CommCell Name',
			L.LibraryName AS 'Library',
			CASE WHEN libInfo.totalSpaceGB 			IS NULL THEN -1 ELSE CAST(libInfo.FreeSpaceGB*1024 AS DECIMAL(32,2)) END AS 'Free Space<SIZEMB><NumberNA>',
			CASE WHEN libInfo.totalSpaceGB 			IS NULL THEN -1 ELSE CAST(libInfo.UsedSpaceGB*1024 AS DECIMAL(32,2)) END	AS 'Used Space<SIZEMB>',
			CASE WHEN libInfo.totalSpaceGB 			IS NULL THEN -1 ELSE CAST(libInfo.totalSpaceGB*1024 AS DECIMAL(32,2)) 		 END	AS 'Capacity<SIZEMB>',
			CASE WHEN libInfo.totalAppSizeGB		IS NULL THEN -1 ELSE libInfo.totalAppSizeGB*1024  	 END	AS 'App Size<SIZEMB><HIDDEN>',
			CASE WHEN L.Offline = 1 THEN 'Yes' ELSE 'No' END AS 'Offline',
			CASE WHEN L.LibraryTypeId IN (1, 2) THEN L.SpareInLibrary ELSE -1 END AS 'Spare Available in Library<NumberNA><HIDDEN>',
			CASE WHEN L.LibraryTypeId IN (1, 2) THEN L.SpareTotal ELSE -1 END AS 'Spare Available Total<NumberNA><HIDDEN>',
			CASE WHEN L.LibraryTypeId in (1, 2) THEN 'Tape'
				 WHEN L.LibraryTypeId = 3 THEN 'Disk'
					WHEN L.LibraryTypeId = -3 THEN 'Cloud'
				 WHEN L.LibraryTypeId IN (4, 5) THEN 'StandAlone'
			END AS 'Library Type<HIDDEN>',
			CASE (L.OfflineReason * L.Offline)
				WHEN     0 THEN (CASE WHEN L.Offline = 0 THEN '' ELSE 'N/A' END)
				WHEN 46000 THEN 'Library Management service reset by user'
				WHEN 46001 THEN 'Library has been marked as Disabled'
				WHEN 46002 THEN 'The library has been marked as broken'
				WHEN 46003 THEN 'Ready'
				WHEN 46004 THEN 'Library Management service is ready'
				WHEN 46005 THEN 'Library Management service is offline'
				WHEN 46006 THEN 'Library is marked offline as it is being used for an administrative activity'
				WHEN 46007 THEN 'The cleaning media has retired'
				WHEN 46008 THEN 'Cleaning operation detected that a data Cartridge is loaded in the drive instead of Cleaning Media'
				WHEN 46009 THEN 'SCSI-2 Reservation Command to the Drive failed'
				WHEN 46010 THEN 'SCSI-2 Release Command to the Drive failed'
				WHEN 46011 THEN 'This library is migrated for monitoring purpose, data is not accessible'
				ELSE 'N/A'
			END AS 'Failure Reason<HIDDEN>',
			CASE WHEN L.Offline = 1 AND L.OfflineTimeStamp > 0 THEN L.OfflineTimeStamp
				ELSE -100 END AS 'Not Operational Since<HIDDEN><MMMDDYYYYHrMinAM>',
			CASE WHEN ISNULL(C.Operational, '') = '' AND ISNULL(C.NotOperational, '') = '' THEN 'N/A'
				 WHEN ISNULL(C.Operational, '')<> '' THEN 'Operational' ELSE 'Not Operational' END AS 'Controller Status<HIDDEN>',
			ISNULL(C.Operational, '') AS 'Operational Controller<HIDDEN>',
			ISNULL(C.NotOperational, '') AS 'Not Operational Controller<HIDDEN>',
			L.DataWrittenLastWeek AS 'Data Written (Last Week)<SIZEMB>',
			CASE WHEN L.LibraryTypeId = 3 THEN L.LowWaterMark ELSE -1 END AS 'Low WaterMark (%)<HIDDEN><NumberNA>',
			CASE WHEN L.LibraryTypeId IN (1, 2) THEN L.ScratchPoolsBelowLWM
				ELSE -1 END AS 'Scratch Pools (Below Water Mark)<HIDDEN><NumberNA>',
			CASE WHEN L.LibraryTypeId IN (1, 2) THEN L.Slots ELSE -1 END -1 AS 'Slots<HIDDEN><NumberNA>',
			CASE WHEN L.LibraryTypeId IN (1, 2) THEN L.EmptySlots ELSE -1 END AS 'Empty Slots<HIDDEN><NumberNA>',
			CASE WHEN L.LibraryTypeId IN (1, 2) THEN L.Manufacturer ELSE 'N/A' END  AS 'Manufacturer<HIDDEN>',
			CASE WHEN L.LibraryTypeId IN (1, 2) THEN L.Model  ELSE 'N/A' END AS 'Model<HIDDEN>',
			CASE WHEN L.LibraryTypeId IN (1, 2) THEN L.SerialNumber  ELSE 'N/A' END AS 'Serial Number<HIDDEN>',
			CASE WHEN L.LibraryTypeId IN (1, 2) THEN L.FirmwareRevision ELSE 'N/A' END AS 'Firmware Revision<HIDDEN>'
			,CASE WHEN libInfo.totalSpaceGB 			IS NULL THEN @NA -- For N/A
			     WHEN (libInfo.estimatedSpaceRunoutDays -datediff (DAY,libInfo.LogDateUTC,GETUTCDATE())) > 9999 OR libInfo.estimatedSpaceRunoutDays = -1 OR libInfo.estimatedSpaceRunoutDays IS NULL THEN @Never -- For Never
			     ELSE dbo.getUnixtimebig(DATEADD(DAY, libInfo.estimatedSpaceRunoutDays, libInfo.LogDate))
			END AS 'Date to be Full<MMMDDYYYYNEVER>'
		FROM	cf_SurveyLibrarySummary AS L WITH (NOLOCK)
				INNER JOIN #LatestResult R ON L.SurveyResultId = R.SurveyResultId
				LEFT OUTER JOIN ControllerStr C ON L.SurveyResultId = C.SurveyResultId AND L.LibraryId = C.LibraryId
				LEFT OUTER JOIN
				(
					SELECT libInfo.CommServUniqueId, libInfo.LibraryId, libInfo.totalSpaceGB, libInfo.estimatedSpaceRunoutDays, libInfo.LogDate,libInfo.totalAppSizeGB,libInfo.LogDateUTC,
							mpInfo.UsedSpaceGB,mpInfo.FreeSpaceGB
					FROM
					 (SELECT libInfo.CommServUniqueId, libInfo.LibraryId, libInfo.totalSpaceGB, libInfo.estimatedSpaceRunoutDays, libInfo.LogDate,libInfo.totalAppSizeGB,libInfo.LogDateUTC
					  FROM cf_Survey96DiskLibDetails AS libInfo WITH (NOLOCK)
					  INNER JOIN #LatestResult96 R ON libInfo.SurveyResultId = R.SurveyResultId
					  ) libInfo
					 INNER JOIN
					 (SELECT libInfo.CommServUniqueId, libInfo.LibraryId, SUM(libInfo.UsedSpaceGB) AS UsedSpaceGB, SUM(libInfo.FreeSpaceGB)AS FreeSpaceGB
					  FROM cf_Survey95MountPathDetails AS libInfo WITH (NOLOCK)
					  INNER JOIN #LatestResult95 R ON libInfo.SurveyResultId = R.SurveyResultId
					  GROUP BY libInfo.CommServUniqueId, libInfo.LibraryId
					  ) mpInfo ON
					mpInfo.CommServUniqueId= libInfo.CommServUniqueId AND
					mpInfo.LibraryId= libInfo.LibraryId
				)libInfo ON
				libInfo.CommServUniqueId= R.CommServUniqueId AND
				libInfo.LibraryId= L.LibraryId
		ORDER BY 'CommCell Name', L.LibraryName
	END
	ELSE
	IF @i_Entity = 'MountPath'
	BEGIN
		SELECT 	R.CommServUniqueId  AS 'CommServ UniqueId',
				R.CommCellID AS 'CommCell ID',
				(CASE WHEN @IsPrivate = 1 THEN '' ELSE ISNULL(R.CustomerName, '') + ' - ' END) + ISNULL(R.CommServName, '') AS 'CommCell Name',
				MP.LibraryName AS 'Library',
				MP.MountPathName AS 'MountPath',
				CASE WHEN MP.Offline = 1 THEN 'Yes' ELSE 'No' END AS 'Offline',
				CASE (MP.OfflineReason * MP.Offline)
					WHEN 0 THEN (CASE WHEN MP.Offline = 0 THEN '' ELSE 'N/A' END)
					WHEN 1 THEN 'Not Accessible'
					WHEN 2 THEN 'Disabled'
					WHEN 3 THEN 'Mount path is dirty'
					WHEN 4 THEN 'Device of mount path is not enabled, not accessible or broken'
					ELSE 'N/A'
				END AS 'Failure Reason<HIDDEN>',
				CASE WHEN MP.Offline = 1 AND MP.OfflineTimeStamp > 0 THEN MP.OfflineTimeStamp
					ELSE -100 END AS 'Not Operational Since<MMMDDYYYYHrMinAM><HIDDEN>',
				ISNULL(mpInfo.FreeSpaceGB*1024,-1)  AS 'Free Space<SIZEMB><HIDDEN>',
				ISNULL(mpInfo.TotalCapacityGB*1024,-1)  AS 'Capacity<SIZEMB><HIDDEN>',
				ISNULL(mpInfo.UsedSpaceGB*1024,-1)  AS 'Used Space<SIZEMB><HIDDEN>',
				ISNULL(mpInfo.FreeSpacePerc,-1)  AS 'Free Space (%)<NumberNA><HIDDEN>'
		FROM	cf_SurveyMountPathSummary AS MP WITH (NOLOCK)
				INNER JOIN #LatestResult R ON MP.SurveyResultId = R.SurveyResultId
				LEFT OUTER JOIN
					 (SELECT mpInfo.CommServUniqueId, mpInfo.LibraryId, mpInfo.MountPathId, mpInfo.FreeSpaceGB, mpInfo.TotalCapacityGB, mpInfo.UsedSpaceGB, mpInfo.FreeSpacePerc
					  FROM cf_Survey95MountPathDetails AS mpInfo WITH (NOLOCK)
					  INNER JOIN #LatestResult95 R ON mpInfo.SurveyResultId = R.SurveyResultId
					  ) mpInfo ON
				mpInfo.CommServUniqueId= R.CommServUniqueId AND
				mpInfo.LibraryId= MP.LibraryId AND
				mpInfo.MountPathId= MP.MountPathId
		ORDER BY 'CommCell Name', MP.MountPathName
	END
	ELSE
	IF @i_Entity = 'Drive'
	BEGIN
	;WITH Controller (SurveyResultId, DriveId, Operational, MAName) AS
	(
		SELECT	D.SurveyResultId, D.DriveId, ISNULL(Active&Enabled&DriveAccessible, 0), ISNULL(MA.MediaAgentName, '')
		FROM	cf_SurveyDriveSummary AS D WITH (NOLOCK)
				INNER JOIN #LatestResult R ON D.SurveyResultId = R.SurveyResultId
				LEFT OUTER JOIN cf_SurveyDriveControllerSummary AS DC WITH (NOLOCK)
					ON D.SurveyResultId = DC.SurveyResultId AND D.DriveId = DC.DriveId
				LEFT OUTER JOIN cf_SurveyMediaAgentSummary MA WITH (NOLOCK)
					ON MA.SurveyResultId = DC.SurveyResultId AND MA.MAClientId = DC.MAClientId
		GROUP BY D.SurveyResultId, D.DriveId, ISNULL(Active&Enabled&DriveAccessible, 0), ISNULL(MA.MediaAgentName, '')
	)
	, ControllerStr (SurveyResultId, DriveId, Operational, NotOperational) AS
	(
		SELECT	SurveyResultId, DriveId,
				STUFF((SELECT ' : ' + MAName FROM Controller
						WHERE SurveyResultId = A.SurveyResultId AND DriveId = A.DriveId AND Operational = 1
						ORDER BY MAName FOR XML PATH('')), 1, 3, ''),
				STUFF((SELECT ' : ' + MAName FROM Controller
						WHERE SurveyResultId = A.SurveyResultId AND DriveId = A.DriveId AND Operational = 0
						ORDER BY MAName FOR XML PATH('')), 1, 3, '')
		FROM	Controller A
		GROUP BY SurveyResultId, DriveId
	)
		SELECT 	R.CommServUniqueId  AS 'CommServ UniqueId',
				R.CommCellID AS 'CommCell ID',
				(CASE WHEN @IsPrivate = 1 THEN '' ELSE ISNULL(R.CustomerName, '') + ' - ' END) + ISNULL(R.CommServName, '') AS 'CommCell Name',
				D.LibraryName AS 'Library',
				D.DriveName AS 'Drive',
				CASE WHEN D.Offline = 1 THEN 'Yes' ELSE 'No' END AS 'Offline',
				CASE (D.OfflineReason * D.Offline)
					WHEN 0 THEN (CASE WHEN D.Offline = 0 THEN '' ELSE 'N/A' END)
					WHEN 1 THEN 'The drive has been marked as broken'
					WHEN 2 THEN 'There is a media stuck in the drive'
					WHEN 3 THEN 'Drive indicates that cleaning is required'
					WHEN 4 THEN 'Cannot communicate with Media Mount Manager Service'
					WHEN 5 THEN 'The drive is not accessible from the Operating System'
					WHEN 6 THEN 'Initialization in progress'
					WHEN 7 THEN 'The drive has been enabled'
					WHEN 8 THEN 'The drive has been disabled'
					WHEN 9 THEN 'The drive is accessible from the Operating System'
					WHEN 10 THEN 'The drive is not accessible from the Operating System'
					WHEN 11 THEN 'The drive could not be SCSI reserved on the SCSI bus'
					WHEN 12 THEN 'SCSI reservation on drive could not be released'
					WHEN 13 THEN 'SCSI command to drive is stuck on the active drive controlling MediaAgent'
					WHEN 14 THEN 'No online drive controllers can be used to release the SCSI-2 reservation'
					WHEN 15 THEN 'Encountered a SCSI error for which the user has specified to mark the drive as disabled'
					ELSE 'N/A'
				END AS 'Failure Reason<HIDDEN>',
				CASE WHEN D.Offline = 1 AND D.OfflineTimeStamp > 0 THEN D.OfflineTimeStamp
					ELSE -100 END AS 'Not Operational Since<HIDDEN><MMMDDYYYYHrMinAM>',
			CASE WHEN ISNULL(C.Operational, '') = '' AND ISNULL(C.NotOperational, '') = '' THEN 'N/A'
				 WHEN ISNULL(C.Operational, '')<> '' THEN 'Operational' ELSE 'NOT Operational' END AS 'Controller Status',
			ISNULL(C.Operational, '') AS 'Operational Controller<HIDDEN>',
			ISNULL(C.NotOperational, '') AS 'Not Operational Controller<HIDDEN>',
				CASE WHEN D.RatedThroughputMbps > 0 THEN CAST(CAST(3600.0*D.RatedThroughputMbps/1024.0 AS DECIMAL(20, 2)) AS VARCHAR(32))
					ELSE '' END AS 'Manufacturer Rated Throughput (GB/h)<HIDDEN>',
				D.Manufacturer AS 'Manufacturer<HIDDEN>',
				D.Model AS 'Model<HIDDEN>',
				D.Type AS 'Type<HIDDEN>',
				D.SerialNumber AS 'Serial Number<HIDDEN>',
				D.FirmwareRevision AS 'Firmware Revision<HIDDEN>'
		FROM	cf_SurveyDriveSummary AS D WITH (NOLOCK)
				INNER JOIN #LatestResult R ON D.SurveyResultId = R.SurveyResultId
			LEFT OUTER JOIN ControllerStr C ON D.SurveyResultId = C.SurveyResultId AND D.DriveId = C.DriveId
		ORDER BY 'CommCell Name', D.DriveName
	DROP TABLE #LatestResult
	DROP TABLE #LatestResult96
	DROP TABLE #LatestResult95
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptMediaManagementSummary')
	delete from GxQscripts where name = 'RptMediaManagementSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptMediaManagementSummary')
	delete from GXDBVersions where aliasname = 'RptMediaManagementSummary'
GO

insert into GXDBVersions values(2, 'RptMediaManagementSummary',  '00010015000000000000', 'RptMediaManagementSummary', '00010015000000000000')
GO



--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptMonthlyStorageUsage.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptMonthlyStorageUsage.sp,v $ $Id: RptMonthlyStorageUsage.sp,v 1.24 2015/07/06 20:31:48 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptMonthlyStorageUsage <<<'

IF EXISTS (select * from sysobjects where name='RptMonthlyStorageUsage')
	drop procedure RptMonthlyStorageUsage
IF EXISTS (select * from GxQscripts where name='RptMonthlyStorageUsage')
	delete from GxQscripts where name = 'RptMonthlyStorageUsage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptMonthlyStorageUsage')
	delete from GXDBVersions where aliasname = 'RptMonthlyStorageUsage'
GO
print '... Creating Procedure: RptMonthlyStorageUsage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptMonthlyStorageUsage
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_AggregateLevel INT = 0, --0 for Subclient, 1 for Client, 2 for CommCell, 3 for Client Group, 4 for Tag, 5 for Subclient per Copy
  @i_CommServUniqueID INT = 0,
  @i_IncludeCost INT = 0,
  @i_StartDate DATETIME = NULL,
  @i_SizeUnit VARCHAR(8) = NULL,
  @i_ClientGroupName NVARCHAR(512) = NULL,
  @i_Type INT = 1
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @i_QueryId INT = 136 -- Monthly
IF @i_SizeUnit IS NULL
	SET @i_SizeUnit = 'TB'
ELSE
IF @i_SizeUnit NOT IN ('GB', 'TB', 'PB')
	SET @i_SizeUnit = 'TB'
DECLARE @BytesToTB   FLOAT = 1.0/1024/1024/1024/1024
DECLARE @BytesToUnit FLOAT = @BytesToTB
IF @i_SizeUnit = 'GB'
	SET @BytesToUnit = @BytesToUnit*1024.0
ELSE
IF @i_SizeUnit = 'PB'
	SET @BytesToUnit = @BytesToUnit/1024.0
IF @i_StartDate IS NULL
BEGIN
	SELECT	DISTINCT CASE WHEN Type = 1 AND DAY(StartDate) > 1 THEN DATEADD(MM, 1, StartDate) ELSE StartDate END AS StartDate, Type
	FROM	cf_SurveyMonthlyChargeback WITH (NOLOCK)
	WHERE	(@i_CommServUniqueID = 0 OR CommservUniqueId = @i_CommServUniqueID) AND StartDate IS NOT NULL
	ORDER BY Type ASC, StartDate DESC
	RETURN
END
IF OBJECT_ID('tempdb.dbo.#MonthlyResult') IS NOT NULL DROP TABLE #MonthlyResult
IF OBJECT_ID('tempdb.dbo.#FrontEndCopy') IS NOT NULL DROP TABLE #FrontEndCopy
IF OBJECT_ID('tempdb.dbo.#ClientGroupsString') IS NOT NULL DROP TABLE #ClientGroupsString
IF OBJECT_ID('tempdb.dbo.#SubclientTags') IS NOT NULL DROP TABLE #SubclientTags
IF OBJECT_ID('tempdb.dbo.#SubclientCopyCost') IS NOT NULL DROP TABLE #SubclientCopyCost
IF OBJECT_ID('tempdb.dbo.#ClientCopyCost') IS NOT NULL DROP TABLE #ClientCopyCost
IF OBJECT_ID('tempdb.dbo.#ClientCost') IS NOT NULL DROP TABLE #ClientCost
IF OBJECT_ID('tempdb.dbo.#Cost') IS NOT NULL DROP TABLE #Cost
DECLARE @i_fromLogDate DATETIME = DATEADD(MONTH, 1, @i_StartDate)
CREATE	TABLE #MonthlyResult (
		CommServUniqueId INT,
		CommCellId INT,
		CustomerName NVARCHAR(256),
		CommServName NVARCHAR(256),
		CommServTZ VARCHAR(256),
		SurveyResultId INT,
		StartDate DATETIME,
		TagToCopy INT)
IF	@i_Type = 1 AND DAY(@i_StartDate) > 1 SET @i_StartDate = DATEADD(MM, -1, @i_StartDate)
IF	@i_Type = 2 SET @i_QueryId = 162 -- Weekly
ELSE
IF	@i_Type = 4 SET @i_QueryId = 72  -- Daily
INSERT	INTO #MonthlyResult
SELECT	R.CommServUniqueId, R.CommCellId, R.CustomerName, R.CommServName, R.CommServTimeZone, R.SurverResultId, @i_StartDate, 0
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 0, @i_StartDate, NULL, @i_UserId,@i_GroupId) R
		INNER JOIN (
			SELECT	CommServUniqueId, MAX(SurveyResultId) AS SurveyResultId
			FROM	cf_SurveyMonthlyChargeback WITH (NOLOCK)
			WHERe	StartDate = @i_StartDate AND Type = @i_Type
			GROUP BY CommServUniqueId
			) S ON R.SurverResultId = S.SurveyResultId
CREATE INDEX MonthlyResult_idx ON #MonthlyResult (SurveyResultId)
CREATE TABLE #FrontEndCopy (CommServUniqueId INT, SurveyResultId INT, ClientId INT, AppId INT, CopyId INT, IsSnapCopy INT, PolicyId INT, PrimaryCopyId INT)
INSERT INTO #FrontEndCopy
SELECT	T.CommServUniqueId, T.SurveyResultId, T.ClientId, T.AppId, T.CopyId, C.IsSnapCopy, 0, 0
FROM	(SELECT	U.CommServUniqueId, U.SurveyResultId, U.ClientId, U.AppId, U.CopyId, ROW_NUMBER() OVER (PARTITION BY U.SurveyResultId, U.ClientId, U.AppId ORDER BY U.FrontEndSize DESC) AS RowNum
		FROM	cf_SurveyMonthlyChargeback U
			INNER JOIN #MonthlyResult R ON U.SurveyResultId = R.SurveyResultId AND U.StartDate = R.StartDate) T
		INNER JOIN cf_SurveyCopyBasicRetention C WITH (NOLOCK) ON T.CommservUniqueId = C.CommservUniqueId AND T.CopyId = C.CopyId
WHERE	RowNum = 1
-- Exclude VSA subclients since data sizes are counted for each VMs
DELETE	#FrontEndCopy
FROM	#FrontEndCopy C
		INNER JOIN cf_SurveySubclientAssociation A
		ON C.CommServUniqueId = A.CommservUniqueId AND C.ClientId = A.ClientId AND C.AppId = A.AppId AND A.AppId > 0 AND A.AppTypeId = 106
UPDATE	#FrontEndCopy SET PolicyId = C.PolicyId
FROM	cf_SurveyCopyBasicRetention C WITH (NOLOCK)
WHERE	#FrontEndCopy.CommServUniqueId = C.CommservUniqueId AND #FrontEndCopy.CopyId = C.CopyId
UPDATE	#FrontEndCopy SET PrimaryCopyId = C.CopyId
FROM	cf_SurveyCopyBasicRetention C WITH (NOLOCK)
WHERE	#FrontEndCopy.CommServUniqueId = C.CommservUniqueId AND #FrontEndCopy.PolicyId = C.PolicyId AND #FrontEndCopy.IsSnapCopy = C.IsSnapCopy AND C.IsDefaultCopy = 1
CREATE INDEX FrontEndCopy_idx ON #FrontEndCopy (SurveyResultId, ClientId, AppId)
CREATE TABLE #ClientGroupsString (CommservUniqueId INT, ClientId INT, ClientGroups NVARCHAR(1024))
IF	ISNULL(@i_ClientGroupName, '')  <> ''
	INSERT INTO #ClientGroupsString
	SELECT	CGA.CommservUniqueId, CGA.ClientId, CG.ClientGroupName
	FROM	cf_SurveyClientGroup CG INNER JOIN cf_SurveyClientGroupAssociation CGA
		 ON CG.CommservUniqueId = CGA.CommservUniqueId AND CG.ClientGroupId = CGA.ClientGroupId
		 AND CG.ClientGroupName = @i_ClientGroupName AND @i_CommServUniqueID IN (CG.CommservUniqueId, 0)
ELSE
	EXEC GetClientGroupsString @i_CommServUniqueID, 0
DECLARE	@i_FrontEndBackupTBCost		FLOAT = 0
DECLARE	@i_FrontEndArchiveTBCost	FLOAT = 0
DECLARE	@i_PrimaryAppTBCost			FLOAT = 0
DECLARE	@i_DataProtectedTBCost		FLOAT = 0
DECLARE	@i_DataWrittenTBCost		FLOAT = 0
DECLARE	@i_TotalProtectedAppTBCost	FLOAT = 0
DECLARE	@i_TotalDataOnMediaTBCost	FLOAT = 0
DECLARE	@showFrontEndBackupCost		INT = 0
DECLARE	@showFrontEndArchiveCost	INT = 0
DECLARE	@showPrimaryAppCost			INT = 0
DECLARE	@showDataProtectedCost		INT = 0
DECLARE	@showDataWrittenCost		INT = 0
DECLARE	@showTotalProtectedAppCost	INT = 0
DECLARE	@showTotalDataOnMediaCost	INT = 0
DECLARE	@i_BasePricePerClient		FLOAT = 0
DECLARE	@i_BasePricePerSubclient	FLOAT = 0
DECLARE	@i_DiscountLevel			INT   = -1 -- -1 for No Discount, 0 for Subclient, 1 for Client
DECLARE	@i_DiscountTB				FLOAT = 0
DECLARE	@i_DiscountPct				FLOAT = 0
DECLARE	@NumOfCostColumns			INT = 0
DECLARE	@ShowBasePrice				INT = 0
DECLARE	@ShowDiscount				INT = 0
DECLARE	@ShowTotalCost				INT = 1
DECLARE	@UseTagToCopy				INT = 0
DECLARE	@UseTagToClient				INT = 0
DECLARE	@ClientBasePriceTag			INT = 0
DECLARE	@SubclientBasePriceTag		INT = 0
DECLARE	@ClientDiscountTag			INT = 0
DECLARE	@SubclientDiscountTag		INT = 0
SELECT	@i_FrontEndBackupTBCost = FrontEndTBCost, @i_FrontEndArchiveTBCost = FrontEndArchiveTBCost,
		@i_PrimaryAppTBCost = PrimaryAppTBCost, @i_DataProtectedTBCost = DataProtectedTBCost, @i_DataWrittenTBCost = DataWrittenCostPerTB,
		@i_TotalProtectedAppTBCost = TotalProtectedAppTBCost, @i_TotalDataOnMediaTBCost = TotalDataOnMediaTBCost,
		@i_BasePricePerClient = AdminCostPerClient, @i_BasePricePerSubclient = AdminCostPerSubclient,
		@i_DiscountLevel = DiscountLevel, @i_DiscountTB = DiscountSizeTB, @i_DiscountPct = DiscountPercentage
FROM	cf_GlobalCostParamView
IF	@i_BasePricePerClient > 0 OR @i_BasePricePerSubclient > 0
	SET	@ShowBasePrice = 1
IF @i_DiscountLevel IN (0, 1) AND @i_DiscountTB > 0 AND @i_DiscountPct > 0
	SET @ShowDiscount = 1
IF @i_FrontEndBackupTBCost > 0    SET @showFrontEndBackupCost = 1
IF @i_FrontEndArchiveTBCost > 0   SET @showFrontEndArchiveCost = 1
IF @i_PrimaryAppTBCost > 0	      SET @showPrimaryAppCost = 1
IF @i_DataProtectedTBCost > 0     SET @showDataProtectedCost = 1
IF @i_DataWrittenTBCost > 0       SET @showDataWrittenCost = 1
IF @i_TotalProtectedAppTBCost > 0 SET @showTotalProtectedAppCost = 1
IF @i_TotalDataOnMediaTBCost > 0  SET @showTotalDataOnMediaCost = 1
SET @NumOfCostColumns += (@showFrontEndBackupCost + @showFrontEndArchiveCost
	+ @showPrimaryAppCost + @showDataProtectedCost + @showDataWrittenCost
	+ @showTotalProtectedAppCost + @showTotalDataOnMediaCost)
UPDATE	#MonthlyResult SET TagToCopy = 1
WHERE	CommservUniqueId IN (SELECT DISTINCT CommservUniqueId FROM cf_SurveyBillingEntityToCopy WHERE CommservUniqueId > 0 AND CopyId > 0)
IF	EXISTS (SELECT * FROM #MonthlyResult WHERE TagToCopy = 1)
	SET @UseTagToCopy = 1
CREATE TABLE #SubclientTags (CommservUniqueId INT, CopyId INT,
			 ClientGroupId INT, ClientId INT, AppTypeId INT, InstanceId INT, BackupsetId INT, AppId INT,
			 TagId INT, TagLevel INT, Price FLOAT NULL, BasePriceLevel INT NULL, BasePrice FLOAT NULL,
			 DiscountLevel INT NULL, DiscountTB FLOAT NULL, DiscountPct FLOAT NULL)
IF	EXISTS (SELECT * FROM cf_SurveyBillingEntityMember WHERE CommservUniqueId > 0 OR ClientGroupId > 0 OR ClientId > 0)
BEGIN
	CREATE TABLE #ClientTags (CommservUniqueId INT, ClientGroupId INT, ClientId INT, TagId INT, TagLevel INT)
	INSERT	INTO #ClientTags
	SELECT	M.CommservUniqueId, 0, M.ClientId, M.EntityId, 5
	FROM	cf_SurveyBillingEntityMember M
	WHERE	M.ClientId > 0 AND M.AppTypeId = 0 AND @i_CommServUniqueID IN (0, CommservUniqueId)
	INSERT	INTO #ClientTags
	SELECT	M.CommservUniqueId, M.ClientGroupId, C.ClientId, M.EntityId, 6
	FROM	cf_SurveyBillingEntityMember M
			INNER JOIN cf_SurveyClientGroupAssociation C ON M.CommservUniqueId = C.CommservUniqueId
				AND M.ClientGroupId = C.ClientGroupId AND M.ClientId = 0
				AND @i_CommServUniqueID IN (0, M.CommServUniqueId)
			LEFT OUTER JOIN #ClientTags T ON M.CommservUniqueId = T.CommservUniqueId AND M.ClientId = T.ClientId
	WHERE	T.ClientId IS NULL
	INSERT	INTO #ClientTags
	SELECT	M.CommservUniqueId, 0, C.ClientId, M.EntityId, 7
	FROM	(SELECT	CommservUniqueId, EntityId
			FROM	cf_SurveyBillingEntityMember
			WHERE	CommservUniqueId > 0 AND ClientGroupId <= 0 AND ClientId = 0 AND @i_CommServUniqueID IN (0, CommservUniqueId)
			) M
			INNER JOIN
			(SELECT	DISTINCT U.CommservUniqueId, U.ClientId
			FROM	cf_SurveyMonthlyChargeback AS U INNER JOIN #MonthlyResult R
					ON U.SurveyResultId = R.SurveyResultId AND U.StartDate = R.StartDate AND U.Type = @i_Type
			) C	ON M.CommservUniqueId = C.CommservUniqueId
			LEFT OUTER JOIN #ClientTags T ON M.CommservUniqueId = T.CommservUniqueId AND C.ClientId = T.ClientId
	WHERE	T.ClientId IS NULL
	INSERT	INTO #ClientTags
	SELECT	M.CommservUniqueId, 0, M.ClientId, NULL, NULL
	FROM	(SELECT	DISTINCT CommservUniqueId, ClientId
			FROM	cf_SurveyBillingEntityMember
			WHERE	ClientId > 0 AND AppTypeId > 0 AND @i_CommServUniqueID IN (0, CommservUniqueId)
			) M
			LEFT OUTER JOIN #ClientTags C ON M.CommServUniqueId = C.CommservUniqueId AND M.ClientId = C.ClientId
	WHERE	C.ClientId IS NULL
	INSERT	INTO #SubclientTags
	SELECT	U.CommservUniqueId, 0, C.ClientGroupId, U.ClientId, A.AppTypeId, A.InstanceId, A.BackupsetId, U.AppId, C.TagId, C.TagLevel, NULL, NULL, NULL, NULL, NULL, NULL
	FROM	#ClientTags C
			INNER JOIN #MonthlyResult R ON C.CommServUniqueId = R.CommServUniqueId
			INNER JOIN cf_SurveyMonthlyChargeback AS U ON R.SurveyResultId = U.SurveyResultId AND C.ClientId = U.ClientId AND U.StartDate = R.StartDate AND U.Type = @i_Type
			INNER JOIN cf_SurveySubclientAssociation A ON U.CommServUniqueId = A.CommServUniqueId AND U.AppId = A.AppId AND A.AppId > 0
	GROUP BY U.CommservUniqueId, C.ClientGroupId, U.ClientId, A.AppTypeId, A.InstanceId, A.BackupsetId, U.AppId, C.TagId, C.TagLevel
	DROP TABLE #ClientTags
	UPDATE	#SubclientTags SET TagId = M.EntityId, TagLevel = 4
	FROM	#SubclientTags T INNER JOIN cf_SurveyBillingEntityMember M
			 ON T.CommservUniqueId = M.CommservUniqueId AND T.ClientId = M.ClientId AND T.AppTypeId = M.AppTypeId AND M.InstanceId = 0
	UPDATE	#SubclientTags SET TagId = M.EntityId, TagLevel = 3
	FROM	#SubclientTags T INNER JOIN cf_SurveyBillingEntityMember M
			 ON T.CommservUniqueId = M.CommservUniqueId AND T.ClientId = M.ClientId AND T.AppTypeId = M.AppTypeId AND T.InstanceId = M.InstanceId
			 AND M.BackupsetId = 0
	UPDATE	#SubclientTags SET TagId = M.EntityId, TagLevel = 2
	FROM	#SubclientTags T INNER JOIN cf_SurveyBillingEntityMember M
			 ON T.CommservUniqueId = M.CommservUniqueId AND T.ClientId = M.ClientId AND T.AppTypeId = M.AppTypeId AND T.InstanceId = M.InstanceId
			 AND T.BackupsetId = M.BackupsetId AND M.AppId = 0
	UPDATE	#SubclientTags SET TagId = M.EntityId, TagLevel = 1
	FROM	#SubclientTags T INNER JOIN cf_SurveyBillingEntityMember M
			 ON T.CommservUniqueId = M.CommservUniqueId AND T.ClientId = M.ClientId AND T.AppTypeId = M.AppTypeId AND T.InstanceId = M.InstanceId
			 AND T.BackupsetId = M.BackupsetId AND T.AppId = M.AppId
	-- Apply tag associated by the VSA subclient to VM which is not associated to a tag at client level
	UPDATE	#SubclientTags SET TagId = M.EntityId, TagLevel = 5
	FROM	#SubclientTags T INNER JOIN cf_SurveyBillingEntityMember M
			 ON T.CommservUniqueId = M.CommservUniqueId AND T.ClientId <> M.ClientId AND T.AppTypeId = M.AppTypeId AND T.AppId = M.AppId
			 AND T.AppTypeId = 106 AND (T.TagId = 0 OR T.TagLevel <> 5)
END
IF	EXISTS (SELECT * FROM #SubclientTags)
	SET @UseTagToClient = 1
IF @UseTagToCopy = 1
BEGIN
	INSERT	INTO #SubclientTags
	SELECT	E.CommservUniqueId, E.CopyId, 0, 0, 0, 0, 0, 0,
			P.TagNameId, 8, P.PricePerTB, P.BasePriceLevel, P.BasePrice,
			P.DiscountLevel, P.DiscountTB, P.DiscountPct
	FROM	cf_SurveyPriceTag P
			INNER JOIN cf_SurveyBillingEntityToCopy E ON E.EntityId = P.TagNameId
			INNER JOIN
			(SELECT	DISTINCT U.CommservUniqueId, U.CopyId
			FROM	cf_SurveyMonthlyChargeback AS U INNER JOIN #MonthlyResult R
					ON U.SurveyResultId = R.SurveyResultId AND U.StartDate = R.StartDate AND U.Type = @i_Type
			) C	ON E.CommservUniqueId = C.CommservUniqueId AND E.CopyId = C.CopyId
END
IF @UseTagToCopy = 1 OR @UseTagToClient = 1
	UPDATE	#SubclientTags SET Price = P.PricePerTB, BasePriceLevel = P.BasePriceLevel, BasePrice = P.BasePrice,
			DiscountLevel = P.DiscountLevel, DiscountTB = P.DiscountTB, DiscountPct = P.DiscountPct
	FROM	#SubclientTags T INNER JOIN cf_SurveyPriceTag P ON T.TagId = P.TagNameId AND P.TagType = 0 AND P.UsageType = 0
IF	EXISTS (SELECT * FROM #SubclientTags WHERE BasePriceLevel = 0)
	SET @SubclientBasePriceTag = 1
IF	EXISTS (SELECT * FROM #SubclientTags WHERE BasePriceLevel = 1)
	SET @ClientBasePriceTag = 1
IF	@SubclientBasePriceTag = 1 OR @ClientBasePriceTag = 1
	SET @ShowBasePrice = 1
IF	EXISTS (SELECT * FROM #SubclientTags WHERE DiscountLevel = 0)
	SET @SubclientDiscountTag = 1
IF	EXISTS (SELECT * FROM #SubclientTags WHERE DiscountLevel = 1)
	SET @ClientDiscountTag = 1
IF	@SubclientDiscountTag = 1 OR @ClientDiscountTag = 1
	SET @ShowDiscount = 1
IF	@ShowBasePrice = 1 SET @NumOfCostColumns += 1
IF	@ShowDiscount  = 1 SET @NumOfCostColumns += 1
IF	@NumOfCostColumns < 2
	SET	@ShowTotalCost = 0
CREATE TABLE #SubclientCopyCost
(
	CommServUniqueId INT, ClientId INT, AppId INT, CopyId INT, TagId INT, TagLevel INT,
	FrontEndBackupSize BIGINT, FrontEndBackupCost FLOAT, FrontEndArchiveSize BIGINT, FrontEndArchiveCost FLOAT,
	PrimaryAppSize BIGINT, PrimaryAppCost FLOAT, DataProtected BIGINT, DataProtectedCost FLOAT, DataWritten BIGINT, DataWrittenCost FLOAT,
	TotalProtectedApp BIGINT, TotalProtectedAppCost FLOAT, TotalDataOnMedia BIGINT, TotalDataOnMediaCost FLOAT,
	BasePrice FLOAT, Discount FLOAT
)
CREATE TABLE #ClientCopyCost
(
	CommServUniqueId INT, ClientId INT, CopyId INT, TagId INT, TagLevel INT,
	FrontEndBackupSize BIGINT, FrontEndBackupCost FLOAT, FrontEndArchiveSize BIGINT, FrontEndArchiveCost FLOAT,
	PrimaryAppSize BIGINT, PrimaryAppCost FLOAT, DataProtected BIGINT, DataProtectedCost FLOAT, DataWritten BIGINT, DataWrittenCost FLOAT,
	TotalProtectedApp BIGINT, TotalProtectedAppCost FLOAT, TotalDataOnMedia BIGINT, TotalDataOnMediaCost FLOAT,
	nSubclients INT, BasePrice FLOAT, TagBasePriceLevel INT, Discount FLOAT, TagDiscountLevel INT
)
CREATE TABLE #ClientCost
(
	CommServUniqueId INT, ClientId INT,
	FrontEndBackupSize BIGINT, FrontEndBackupCost FLOAT, FrontEndArchiveSize BIGINT, FrontEndArchiveCost FLOAT,
	PrimaryAppSize BIGINT, PrimaryAppCost FLOAT, DataProtected BIGINT, DataProtectedCost FLOAT, DataWritten BIGINT, DataWrittenCost FLOAT,
	TotalProtectedApp BIGINT, TotalProtectedAppCost FLOAT, TotalDataOnMedia BIGINT, TotalDataOnMediaCost FLOAT,
	nSubclients INT, BasePrice FLOAT, Discount FLOAT
)
IF @i_AggregateLevel IN (0, 1, 2, 3, 4)
BEGIN
  IF EXISTS (SELECT * FROM #MonthlyResult WHERE TagToCopy = 0)
	INSERT	INTO #SubclientCopyCost
	SELECT 	U.CommServUniqueId, U.ClientId, U.AppId, 0, ISNULL(T.TagId, 0), ISNULL(T.TagLevel, 0),
			SUM(CASE WHEN U.CopyId = FEC.CopyId AND ISNULL(U.FrontEndSizeType, 0) <> 1 THEN U.FrontEndSize ELSE 0 END),
			@BytesToTB*SUM(CASE WHEN U.CopyId = FEC.CopyId AND ISNULL(U.FrontEndSizeType, 0) <> 1 THEN U.FrontEndSize*ISNULL(T.Price, @i_FrontEndBackupTBCost) ELSE 0 END),
			SUM(CASE WHEN U.CopyId = FEC.CopyId AND ISNULL(U.FrontEndSizeType, 0) = 1 THEN U.FrontEndSize ELSE 0 END),
			@BytesToTB*SUM(CASE WHEN U.CopyId = FEC.CopyId AND ISNULL(U.FrontEndSizeType, 0)  = 1 THEN U.FrontEndSize*ISNULL(T.Price, @i_FrontEndArchiveTBCost) ELSE 0 END),
			SUM(CASE WHEN U.CopyId = FEC.PrimaryCopyId THEN U.DataProtected ELSE 0 END),
			@BytesToTB*SUM(CASE WHEN U.CopyId = FEC.PrimaryCopyId THEN U.DataProtected*ISNULL(T.Price, @i_PrimaryAppTBCost) ELSE 0 END),
			SUM(U.DataProtected),
			@BytesToTB*SUM(U.DataProtected*ISNULL(T.Price, @i_DataProtectedTBCost)),
			SUM(U.DataWritten),
			@BytesToTB*SUM(U.DataWritten*ISNULL(T.Price, @i_DataWrittenTBCost)),
			SUM(U.TotalProtectedApp),
			@BytesToTB*SUM(U.TotalProtectedApp*ISNULL(T.Price, @i_TotalProtectedAppTBCost)),
			SUM(U.TotalDataOnMedia),
			@BytesToTB*SUM(U.TotalDataOnMedia*ISNULL(T.Price, @i_TotalDataOnMediaTBCost)),
			MAX(CASE WHEN ISNULL(T.BasePriceLevel, -1) = 0 THEN T.BasePrice ELSE @i_BasePricePerSubclient END),
			0
	FROM	cf_SurveyMonthlyChargeback AS U WITH (NOLOCK)
			INNER JOIN #MonthlyResult R ON U.SurveyResultId = R.SurveyResultId AND U.StartDate = R.StartDate AND U.Type = @i_Type AND TagToCopy = 0
			INNER JOIN #FrontEndCopy FEC ON U.SurveyResultId = FEC.SurveyResultId AND U.ClientId = FEC.ClientId AND U.AppId = FEC.AppId
			LEFT OUTER JOIN #SubclientTags T ON U.CommServUniqueId = T.CommServUniqueId AND U.ClientId = T.ClientId AND U.AppId = T.AppId
	GROUP BY U.CommServUniqueId, U.ClientId, U.AppId, ISNULL(T.TagId, 0), ISNULL(T.TagLevel, 0)
  IF EXISTS (SELECT * FROM #MonthlyResult WHERE TagToCopy = 1)
	INSERT	INTO #SubclientCopyCost
	SELECT 	U.CommServUniqueId, U.ClientId, U.AppId, U.CopyId, ISNULL(T.TagId, 0), ISNULL(T.TagLevel, 0),
			CASE WHEN U.CopyId = FEC.CopyId AND ISNULL(U.FrontEndSizeType, 0) <> 1 THEN U.FrontEndSize ELSE 0 END,
			CASE WHEN U.CopyId = FEC.CopyId AND ISNULL(U.FrontEndSizeType, 0) <> 1 THEN @BytesToTB*U.FrontEndSize*ISNULL(T.Price, @i_FrontEndBackupTBCost) ELSE 0 END,
			CASE WHEN U.CopyId = FEC.CopyId AND ISNULL(U.FrontEndSizeType, 0)  = 1 THEN U.FrontEndSize ELSE 0 END,
			CASE WHEN U.CopyId = FEC.CopyId AND ISNULL(U.FrontEndSizeType, 0)  = 1 THEN @BytesToTB*U.FrontEndSize*ISNULL(T.Price, @i_FrontEndArchiveTBCost) ELSE 0 END,
			CASE WHEN U.CopyId = FEC.PrimaryCopyId THEN U.DataProtected ELSE 0 END,
			CASE WHEN U.CopyId = FEC.PrimaryCopyId THEN @BytesToTB*U.DataProtected*ISNULL(T.Price, @i_PrimaryAppTBCost) ELSE 0 END,
			U.DataProtected,
			@BytesToTB*U.DataProtected*ISNULL(T.Price, @i_DataProtectedTBCost),
			U.DataWritten,
			@BytesToTB*U.DataWritten*ISNULL(T.Price, @i_DataWrittenTBCost),
			U.TotalProtectedApp,
			@BytesToTB*U.TotalProtectedApp*ISNULL(T.Price, @i_TotalProtectedAppTBCost),
			U.TotalDataOnMedia,
			@BytesToTB*U.TotalDataOnMedia*ISNULL(T.Price, @i_TotalDataOnMediaTBCost),
			CASE WHEN ISNULL(T.BasePriceLevel, -1) = 0 THEN T.BasePrice ELSE @i_BasePricePerSubclient END,
			0
	FROM	cf_SurveyMonthlyChargeback AS U WITH (NOLOCK)
			INNER JOIN #MonthlyResult R ON U.SurveyResultId = R.SurveyResultId AND U.StartDate = R.StartDate AND U.Type = @i_Type AND TagToCopy = 1
			INNER JOIN #FrontEndCopy FEC ON U.SurveyResultId = FEC.SurveyResultId AND U.ClientId = FEC.ClientId AND U.AppId = FEC.AppId
			LEFT OUTER JOIN #SubclientTags T ON U.CommServUniqueId = T.CommServUniqueId AND U.CopyId = T.CopyId
	IF	@SubclientDiscountTag = 1
	UPDATE	#SubclientCopyCost
	SET		Discount = -0.01*DiscountPct*Price*(
				(CASE WHEN @BytesToTB*FrontEndBackupSize < DiscountTB THEN @BytesToTB*FrontEndBackupSize  ELSE DiscountTB END)*@showFrontEndBackupCost
			  + (CASE WHEN @BytesToTB*FrontEndArchiveSize< DiscountTB THEN @BytesToTB*FrontEndArchiveSize ELSE DiscountTB END)*@showFrontEndArchiveCost
			  +	(CASE WHEN @BytesToTB*PrimaryAppSize     < DiscountTB THEN @BytesToTB*PrimaryAppSize      ELSE DiscountTB END)*@showPrimaryAppCost
			  +	(CASE WHEN @BytesToTB*DataProtected      < DiscountTB THEN @BytesToTB*DataProtected       ELSE DiscountTB END)*@showDataProtectedCost
			  +	(CASE WHEN @BytesToTB*DataWritten        < DiscountTB THEN @BytesToTB*DataWritten         ELSE DiscountTB END)*@showDataWrittenCost
			  +	(CASE WHEN @BytesToTB*TotalProtectedApp  < DiscountTB THEN @BytesToTB*TotalProtectedApp   ELSE DiscountTB END)*@showTotalProtectedAppCost
			  +	(CASE WHEN @BytesToTB*TotalDataOnMedia   < DiscountTB THEN @BytesToTB*TotalDataOnMedia    ELSE DiscountTB END)*@showTotalDataOnMediaCost
			  )
	FROM	#SubclientCopyCost S
			INNER JOIN #SubclientTags T
			ON S.CommServUniqueId = T.CommServUniqueId AND S.CopyId = T.CopyId AND T.DiscountLevel = 0
	IF	@i_DiscountLevel = 0
	UPDATE	#SubclientCopyCost
	SET		Discount = -0.01*@i_DiscountPct*(
				(CASE WHEN @BytesToTB*FrontEndBackupSize < @i_DiscountTB THEN @BytesToTB*FrontEndBackupSize  ELSE @i_DiscountTB END)*@i_FrontEndBackupTBCost
			  + (CASE WHEN @BytesToTB*FrontEndArchiveSize< @i_DiscountTB THEN @BytesToTB*FrontEndArchiveSize ELSE @i_DiscountTB END)*@i_FrontEndArchiveTBCost
			  +	(CASE WHEN @BytesToTB*PrimaryAppSize     < @i_DiscountTB THEN @BytesToTB*PrimaryAppSize      ELSE @i_DiscountTB END)*@i_PrimaryAppTBCost
			  +	(CASE WHEN @BytesToTB*DataProtected      < @i_DiscountTB THEN @BytesToTB*DataProtected       ELSE @i_DiscountTB END)*@i_DataProtectedTBCost
			  +	(CASE WHEN @BytesToTB*DataWritten        < @i_DiscountTB THEN @BytesToTB*DataWritten         ELSE @i_DiscountTB END)*@i_DataWrittenTBCost
			  +	(CASE WHEN @BytesToTB*TotalProtectedApp  < @i_DiscountTB THEN @BytesToTB*TotalProtectedApp   ELSE @i_DiscountTB END)*@i_TotalProtectedAppTBCost
			  +	(CASE WHEN @BytesToTB*TotalDataOnMedia   < @i_DiscountTB THEN @BytesToTB*TotalDataOnMedia    ELSE @i_DiscountTB END)*@i_TotalDataOnMediaTBCost
			  )
	FROM	#SubclientCopyCost
	WHERE	Discount = 0
END
IF @i_AggregateLevel IN (1, 2, 3, 4)
BEGIN
	INSERT	INTO #ClientCopyCost
	SELECT	CommServUniqueId, ClientId, CopyId,
			CASE WHEN TagLevel IN (5,6,7,8) THEN TagId ELSE 0 END,
			CASE WHEN TagLevel IN (5,6,7,8) THEN TagLevel ELSE 0 END,
			SUM(FrontEndBackupSize), SUM(FrontEndBackupCost),
			SUM(FrontEndArchiveSize),SUM(FrontEndArchiveCost),
			SUM(PrimaryAppSize),     SUM(PrimaryAppCost),
			SUM(DataProtected),      SUM(DataProtectedCost),
			SUM(DataWritten),        SUM(DataWrittenCost),
			SUM(TotalProtectedApp),  SUM(TotalProtectedAppCost),
			SUM(TotalDataOnMedia),   SUM(TotalDataOnMediaCost),
			COUNT(*),
			SUM(BasePrice),          0,
			SUM(Discount),           0
	FROM	#SubclientCopyCost
	GROUP BY CommServUniqueId, ClientId, CopyId,
			CASE WHEN TagLevel IN (5,6,7,8) THEN TagId ELSE 0 END,
			CASE WHEN TagLevel IN (5,6,7,8) THEN TagLevel ELSE 0 END
	IF @i_AggregateLevel IN (1, 2, 3)
		DROP TABLE #SubclientCopyCost
	UPDATE	#ClientCopyCost
	SET		BasePrice += T.BasePrice, TagBasePriceLevel = 1
	FROM	#ClientCopyCost C INNER JOIN #SubclientTags T
		 ON C.CommServUniqueId = T.CommServUniqueId AND C.ClientId = T.ClientId AND C.TagId = T.TagId AND T.BasePriceLevel = 1
	IF	@i_BasePricePerClient > 0
	UPDATE	#ClientCopyCost
	SET		BasePrice += @i_BasePricePerClient
	WHERE	TagBasePriceLevel <> 1
	UPDATE	#ClientCopyCost
	SET		Discount += -0.01*DiscountPct*Price*(
				(CASE WHEN @BytesToTB*FrontEndBackupSize < DiscountTB THEN @BytesToTB*FrontEndBackupSize  ELSE DiscountTB END)*@showFrontEndBackupCost
			  + (CASE WHEN @BytesToTB*FrontEndArchiveSize< DiscountTB THEN @BytesToTB*FrontEndArchiveSize ELSE DiscountTB END)*@showFrontEndArchiveCost
			  +	(CASE WHEN @BytesToTB*PrimaryAppSize     < DiscountTB THEN @BytesToTB*PrimaryAppSize      ELSE DiscountTB END)*@showPrimaryAppCost
			  +	(CASE WHEN @BytesToTB*DataProtected      < DiscountTB THEN @BytesToTB*DataProtected       ELSE DiscountTB END)*@showDataProtectedCost
			  +	(CASE WHEN @BytesToTB*DataWritten        < DiscountTB THEN @BytesToTB*DataWritten         ELSE DiscountTB END)*@showDataWrittenCost
			  +	(CASE WHEN @BytesToTB*TotalProtectedApp  < DiscountTB THEN @BytesToTB*TotalProtectedApp   ELSE DiscountTB END)*@showTotalProtectedAppCost
			  +	(CASE WHEN @BytesToTB*TotalDataOnMedia   < DiscountTB THEN @BytesToTB*TotalDataOnMedia    ELSE DiscountTB END)*@showTotalDataOnMediaCost
			  ),
			  TagDiscountLevel = 1
	FROM	#ClientCopyCost C INNER JOIN #SubclientTags T
		 ON C.CommServUniqueId = T.CommServUniqueId AND C.ClientId = T.ClientId AND C.TagId = T.TagId AND T.DiscountLevel = 1
	DROP TABLE #SubclientTags
	IF	@i_DiscountLevel = 1
	UPDATE	#ClientCopyCost
	SET		Discount += -0.01*@i_DiscountPct*(
				(CASE WHEN @BytesToTB*FrontEndBackupSize < @i_DiscountTB THEN @BytesToTB*FrontEndBackupSize  ELSE @i_DiscountTB END)*@i_FrontEndBackupTBCost
			  + (CASE WHEN @BytesToTB*FrontEndArchiveSize< @i_DiscountTB THEN @BytesToTB*FrontEndArchiveSize ELSE @i_DiscountTB END)*@i_FrontEndArchiveTBCost
			  +	(CASE WHEN @BytesToTB*PrimaryAppSize     < @i_DiscountTB THEN @BytesToTB*PrimaryAppSize      ELSE @i_DiscountTB END)*@i_PrimaryAppTBCost
			  +	(CASE WHEN @BytesToTB*DataProtected      < @i_DiscountTB THEN @BytesToTB*DataProtected       ELSE @i_DiscountTB END)*@i_DataProtectedTBCost
			  +	(CASE WHEN @BytesToTB*DataWritten        < @i_DiscountTB THEN @BytesToTB*DataWritten         ELSE @i_DiscountTB END)*@i_DataWrittenTBCost
			  +	(CASE WHEN @BytesToTB*TotalProtectedApp  < @i_DiscountTB THEN @BytesToTB*TotalProtectedApp   ELSE @i_DiscountTB END)*@i_TotalProtectedAppTBCost
			  +	(CASE WHEN @BytesToTB*TotalDataOnMedia   < @i_DiscountTB THEN @BytesToTB*TotalDataOnMedia    ELSE @i_DiscountTB END)*@i_TotalDataOnMediaTBCost
			  )
	FROM	#ClientCopyCost
	WHERE	TagDiscountLevel <> 1
	IF @i_AggregateLevel IN (1, 2, 3)
	BEGIN
		INSERT	INTO #ClientCost
		SELECT	CommServUniqueId, ClientId,
				SUM(FrontEndBackupSize), SUM(FrontEndBackupCost),
				SUM(FrontEndArchiveSize),SUM(FrontEndArchiveCost),
				SUM(PrimaryAppSize),     SUM(PrimaryAppCost),
				SUM(DataProtected),      SUM(DataProtectedCost),
				SUM(DataWritten),        SUM(DataWrittenCost),
				SUM(TotalProtectedApp),  SUM(TotalProtectedAppCost),
				SUM(TotalDataOnMedia),   SUM(TotalDataOnMediaCost),
				SUM(nSubclients),
				SUM(BasePrice),
				SUM(Discount)
		FROM	#ClientCopyCost
		GROUP BY CommServUniqueId, ClientId
		DROP TABLE #ClientCopyCost
	END
END
CREATE TABLE #Cost
(
	[Billing Tag] NVARCHAR(256),
	[CommServ UniqueId<DONOTSHOW>] INT, [CommCell Name] NVARCHAR(256),
	[Client Groups] NVARCHAR(MAX), [Client] NVARCHAR(256), [Agent] NVARCHAR(256),
	[Instance] NVARCHAR(256), [Backupset] NVARCHAR(256), [Subclient] NVARCHAR(256),
	[Storage Policy] NVARCHAR(256), [Copy] NVARCHAR(256),
	[Front End Backup Size] DECIMAL(32,3), [Front End Backup Cost<FORMATNUMBERNA>] DECIMAL(32,3),
	[Front End Archive Size] DECIMAL(32,3), [Front End Archive Cost<FORMATNUMBERNA>] DECIMAL(32,3),
	[Primary App Size] DECIMAL(32,3), [Primary App Cost<FORMATNUMBERNA>] DECIMAL(32,3),
	[Protected App Size] DECIMAL(32,3), [Protected App Cost<FORMATNUMBERNA>] DECIMAL(32,3),
	[Media Size] DECIMAL(32,3), [Media Cost<FORMATNUMBERNA>] DECIMAL(32,3),
	[Total Protected App Size] DECIMAL(32,3), [Total Protected App Cost<FORMATNUMBERNA>] DECIMAL(32,3),
	[Total Media Size] DECIMAL(32,3), [Total Media Cost<FORMATNUMBERNA>] DECIMAL(32,3),
	[No. of Clients<FORMATNUMBERNA>] INT, [No. of Subclients<FORMATNUMBERNA>] INT, [Additional Cost<FORMATNUMBERNA>] DECIMAL(32,3),
	[Discount<FORMATNUMBERNA>] DECIMAL(32,3), [Total Cost<FORMATNUMBERNA>] DECIMAL(32,3)
)
IF @i_AggregateLevel = 5 -- Subclient per Copy
BEGIN
	ALTER TABLE #Cost DROP COLUMN [No. of Clients<FORMATNUMBERNA>]
	ALTER TABLE #Cost DROP COLUMN [No. of Subclients<FORMATNUMBERNA>]
	ALTER TABLE #Cost ADD TagID INT
	INSERT	INTO #Cost
	SELECT 	ISNULL(E.Name, ''),
			R.CommservUniqueId,
			R.CommServName,
			ISNULL(CGS.ClientGroups, ''),
			CASE WHEN A.AppTypeId <> 106 THEN A.ClientName
				ELSE ISNULL((SELECT TOP 1 ClientName FROM cf_SurveySubclientAssociation WITH (NOLOCK) WHERE CommServUniqueId = U.CommServUniqueId AND ClientId = U.ClientId),
					'VM Client ID: ' + CAST(U.ClientId AS VARCHAR(32))) END AS 'Client',
			A.AgentName + (CASE WHEN A.AppTypeId = 106 THEN (' in ' + A.ClientName) ELSE '' END) AS 'Agent',
			A.InstanceName,
			A.BackupsetName,
			A.SubclientName,
			C.PolicyName,
			C.CopyName,
			CASE WHEN U.CopyId = FEC.CopyId AND ISNULL(U.FrontEndSizeType, 0) <> 1 THEN @BytesToUnit*U.FrontEndSize ELSE 0 END,
			CASE WHEN U.CopyId = FEC.CopyId AND ISNULL(U.FrontEndSizeType, 0) <> 1 THEN @BytesToTB*U.FrontEndSize*ISNULL(T.Price, @i_FrontEndBackupTBCost) ELSE 0 END,
			CASE WHEN U.CopyId = FEC.CopyId AND ISNULL(U.FrontEndSizeType, 0)  = 1 THEN @BytesToUnit*U.FrontEndSize ELSE 0 END,
			CASE WHEN U.CopyId = FEC.CopyId AND ISNULL(U.FrontEndSizeType, 0)  = 1 THEN @BytesToTB*U.FrontEndSize*ISNULL(T.Price, @i_FrontEndArchiveTBCost) ELSE 0 END,
			CASE WHEN U.CopyId = FEC.PrimaryCopyId THEN @BytesToUnit*U.DataProtected ELSE 0 END,
			CASE WHEN U.CopyId = FEC.PrimaryCopyId THEN @BytesToTB*U.DataProtected*ISNULL(T.Price, @i_PrimaryAppTBCost) ELSE 0 END,
			@BytesToUnit*U.DataProtected,
			@BytesToTB*U.DataProtected*ISNULL(T.Price, @i_DataProtectedTBCost),
			@BytesToUnit*U.DataWritten,
			@BytesToTB*U.DataWritten*ISNULL(T.Price, @i_DataWrittenTBCost),
			@BytesToUnit*U.TotalProtectedApp,
			@BytesToTB*U.TotalProtectedApp*ISNULL(T.Price, @i_TotalProtectedAppTBCost),
			@BytesToUnit*U.TotalDataOnMedia,
			@BytesToTB*U.TotalDataOnMedia*ISNULL(T.Price, @i_TotalDataOnMediaTBCost),
			(CASE WHEN U.CopyId = FEC.CopyId THEN 1.0 ELSE 0 END)*(CASE WHEN ISNULL(T.BasePriceLevel, -1) = 0 THEN T.BasePrice ELSE @i_BasePricePerSubclient END),
			0, 0, ISNULL(E.ID, 0)
	FROM	cf_SurveyMonthlyChargeback AS U WITH (NOLOCK)
			INNER JOIN #MonthlyResult R ON U.SurveyResultId = R.SurveyResultId AND U.StartDate = R.StartDate AND U.Type = @i_Type
			INNER JOIN #FrontEndCopy FEC ON U.SurveyResultId = FEC.SurveyResultId AND U.ClientId = FEC.ClientId AND U.AppId = FEC.AppId
			INNER JOIN cf_SurveySubclientAssociation A WITH (NOLOCK) ON U.CommServUniqueId = A.CommServUniqueId AND U.AppId = A.AppId
			INNER JOIN cf_SurveyCopyBasicRetention C WITH (NOLOCK) ON U.CommServUniqueId = C.CommServUniqueId AND U.CopyId = C.CopyId
			LEFT OUTER JOIN #ClientGroupsString CGS ON U.CommServUniqueId = CGS.CommServUniqueId AND U.ClientId = CGS.ClientId
			LEFT OUTER JOIN #SubclientTags T ON U.CommServUniqueId = T.CommServUniqueId
				AND (U.CopyId = T.CopyId OR T.CopyId = 0 AND U.ClientId = T.ClientId AND U.AppId = T.AppId)
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON T.TagID = E.ID
	WHERE	(ISNULL(@i_ClientGroupName, '') = '' OR CGS.ClientId IS NOT NULL)
	ORDER BY R.CommServName, 'Client', 'Agent', A.InstanceName, A.BackupsetName, A.SubclientName, C.PolicyName, C.CopyName
	IF	@UseTagToClient = 0 AND @UseTagToCopy = 0
		ALTER TABLE #Cost DROP COLUMN [Billing Tag]
	IF	@SubclientDiscountTag = 1
	UPDATE	#Cost
	SET		[Discount<FORMATNUMBERNA>] = -0.01*DiscountPct*Price*(
				(CASE WHEN @BytesToTB*[Front End Backup Size]   < DiscountTB THEN @BytesToTB*[Front End Backup Size]    ELSE DiscountTB END)*@showFrontEndBackupCost
			  + (CASE WHEN @BytesToTB*[Front End Archive Size]  < DiscountTB THEN @BytesToTB*[Front End Archive Size]   ELSE DiscountTB END)*@showFrontEndArchiveCost
			  +	(CASE WHEN @BytesToTB*[Primary App Size]        < DiscountTB THEN @BytesToTB*[Primary App Size]         ELSE DiscountTB END)*@showPrimaryAppCost
			  +	(CASE WHEN @BytesToTB*[Protected App Size]      < DiscountTB THEN @BytesToTB*[Protected App Size]       ELSE DiscountTB END)*@showDataProtectedCost
			  +	(CASE WHEN @BytesToTB*[Media Size]              < DiscountTB THEN @BytesToTB*[Media Size]               ELSE DiscountTB END)*@showDataWrittenCost
			  +	(CASE WHEN @BytesToTB*[Total Protected App Size]< DiscountTB THEN @BytesToTB*[Total Protected App Size] ELSE DiscountTB END)*@showTotalProtectedAppCost
			  +	(CASE WHEN @BytesToTB*[Total Media Size]        < DiscountTB THEN @BytesToTB*[Total Media Size]         ELSE DiscountTB END)*@showTotalDataOnMediaCost
			  )
	FROM	#Cost S
			INNER JOIN #SubclientTags T
			ON S.TagID = T.TagId AND T.DiscountLevel = 0
	IF	@i_DiscountLevel = 0
	UPDATE	#Cost
	SET		[Discount<FORMATNUMBERNA>] = -0.01*@i_DiscountPct*(
				(CASE WHEN @BytesToTB*[Front End Backup Size]   < @i_DiscountTB THEN @BytesToTB*[Front End Backup Size]    ELSE @i_DiscountTB END)*@i_FrontEndBackupTBCost
			  + (CASE WHEN @BytesToTB*[Front End Archive Size]  < @i_DiscountTB THEN @BytesToTB*[Front End Archive Size]   ELSE @i_DiscountTB END)*@i_FrontEndArchiveTBCost
			  +	(CASE WHEN @BytesToTB*[Primary App Size]        < @i_DiscountTB THEN @BytesToTB*[Primary App Size]         ELSE @i_DiscountTB END)*@i_PrimaryAppTBCost
			  +	(CASE WHEN @BytesToTB*[Protected App Size]      < @i_DiscountTB THEN @BytesToTB*[Protected App Size]       ELSE @i_DiscountTB END)*@i_DataProtectedTBCost
			  +	(CASE WHEN @BytesToTB*[Media Size]              < @i_DiscountTB THEN @BytesToTB*[Media Size]               ELSE @i_DiscountTB END)*@i_DataWrittenTBCost
			  +	(CASE WHEN @BytesToTB*[Total Protected App Size]< @i_DiscountTB THEN @BytesToTB*[Total Protected App Size] ELSE @i_DiscountTB END)*@i_TotalProtectedAppTBCost
			  +	(CASE WHEN @BytesToTB*[Total Media Size]        < @i_DiscountTB THEN @BytesToTB*[Total Media Size]         ELSE @i_DiscountTB END)*@i_TotalDataOnMediaTBCost
			  )
	FROM	#Cost
	WHERE	[Discount<FORMATNUMBERNA>] = 0
	IF	@i_BasePricePerSubclient = 0
		SET @ShowBasePrice = 0
	ALTER TABLE #Cost DROP COLUMN TagID
END
ELSE
IF @i_AggregateLevel = 0 -- Subclient
BEGIN
	ALTER TABLE #Cost DROP COLUMN [Storage Policy]
	ALTER TABLE #Cost DROP COLUMN [Copy]
	ALTER TABLE #Cost DROP COLUMN [No. of Clients<FORMATNUMBERNA>]
	ALTER TABLE #Cost DROP COLUMN [No. of Subclients<FORMATNUMBERNA>]
	CREATE TABLE #AppCopyTags (CommServUniqueId INT, ClientId INT, AppId INT, TagName VARCHAR(MAX))
	IF @UseTagToCopy = 1
	BEGIN
		;WITH AppCopyTagName (CommServUniqueId, ClientId, AppId, TagName) AS
		(
			SELECT	S.CommServUniqueId, S.ClientId, S.AppId, E.Name
			FROM	(SELECT CommServUniqueId, ClientId, AppId
					FROM	#SubclientCopyCost
					WHERE	CopyId > 0 AND TagLevel = 8
					GROUP BY CommServUniqueId, ClientId, AppId
					) A
					INNER JOIN #SubclientCopyCost S ON A.CommServUniqueId = S.CommServUniqueId AND A.ClientId = S.ClientId AND A.AppId = S.AppId
					INNER JOIN cf_SurveyBillingEntity E ON S.TagID = E.ID
		)
		INSERT	INTO #AppCopyTags
		SELECT	CommServUniqueId, ClientId, AppId,
				(SELECT TagName + '; '
				FROM	AppCopyTagName T2
				WHERE	T2.CommServUniqueId = T1.CommServUniqueId AND T2.ClientId = T1.ClientId AND T2.AppId = T1.AppId
				ORDER BY TagName
				FOR XML PATH('')) AS Tags
		FROM	AppCopyTagName T1
		GROUP BY CommServUniqueId, ClientId, AppId
	END
	INSERT	INTO #Cost
	SELECT 	CASE WHEN ACT.TagName IS NOT NULL THEN SUBSTRING(ACT.TagName, 1, LEN(ACT.TagName)-1) ELSE ISNULL(E.Name, '') END,
			R.CommservUniqueId,
			R.CommServName,
			ISNULL(CGS.ClientGroups, ''),
			CASE WHEN A.AppTypeId <> 106 THEN A.ClientName
				ELSE ISNULL((SELECT TOP 1 ClientName FROM cf_SurveySubclientAssociation WITH (NOLOCK) WHERE CommServUniqueId = S.CommServUniqueId AND ClientId = S.ClientId),
					'VM Client ID: ' + CAST(S.ClientId AS VARCHAR(32))) END AS 'Client',
			A.AgentName + (CASE WHEN A.AppTypeId = 106 THEN (' in ' + A.ClientName) ELSE '' END) AS 'Agent',
			A.InstanceName,
			A.BackupsetName,
			A.SubclientName,
			@BytesToUnit*S.FrontEndBackupSize,  S.FrontEndBackupCost,
			@BytesToUnit*S.FrontEndArchiveSize,	S.FrontEndArchiveCost,
			@BytesToUnit*S.PrimaryAppSize,      S.PrimaryAppCost,
			@BytesToUnit*S.DataProtected,       S.DataProtectedCost,
			@BytesToUnit*S.DataWritten,         S.DataWrittenCost,
			@BytesToUnit*S.TotalProtectedApp,   S.TotalProtectedAppCost,
			@BytesToUnit*S.TotalDataOnMedia,    S.TotalDataOnMediaCost,
			S.BasePrice, S.Discount, 0
	FROM	(SELECT	CommServUniqueId, ClientId, AppId, MAX(TagID) AS TagID,
					SUM(FrontEndBackupSize)    AS FrontEndBackupSize,  SUM(FrontEndBackupCost)    AS FrontEndBackupCost,
					SUM(FrontEndArchiveSize)   AS FrontEndArchiveSize, SUM(FrontEndArchiveCost)   AS FrontEndArchiveCost,
					SUM(PrimaryAppSize)        AS PrimaryAppSize,      SUM(PrimaryAppCost)        AS PrimaryAppCost,
					SUM(DataProtected)         AS DataProtected,       SUM(DataProtectedCost)     AS DataProtectedCost,
					SUM(DataWritten)           AS DataWritten,         SUM(DataWrittenCost)       AS DataWrittenCost,
					SUM(TotalProtectedApp)     AS TotalProtectedApp,   SUM(TotalProtectedAppCost) AS TotalProtectedAppCost,
					SUM(TotalDataOnMedia)      AS TotalDataOnMedia,    SUM(TotalDataOnMediaCost)  AS TotalDataOnMediaCost,
					SUM(BasePrice)             AS BasePrice,           SUM(Discount)              AS Discount
			FROM	#SubclientCopyCost
			GROUP BY CommServUniqueId, ClientId, AppId
			) S
			INNER JOIN (SELECT DISTINCT CommservUniqueId, CommServName FROM #MonthlyResult) R ON S.CommServUniqueId = R.CommServUniqueId
			INNER JOIN cf_SurveySubclientAssociation A WITH (NOLOCK) ON S.CommServUniqueId = A.CommServUniqueId AND S.AppId = A.AppId
			LEFT OUTER JOIN #ClientGroupsString CGS ON S.CommServUniqueId = CGS.CommServUniqueId AND S.ClientId = CGS.ClientId
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON S.TagID = E.ID
			LEFT OUTER JOIN #AppCopyTags ACT ON S.CommServUniqueId = ACT.CommServUniqueId AND S.ClientId = ACT.ClientId AND S.AppId = ACT.AppId
	WHERE	(ISNULL(@i_ClientGroupName, '') = '' OR CGS.ClientId IS NOT NULL)
	ORDER BY R.CommServName, 'Client', 'Agent', A.InstanceName, A.BackupsetName, A.SubclientName
	DROP TABLE #AppCopyTags
	IF	@UseTagToClient = 0 AND @UseTagToCopy = 0
		ALTER TABLE #Cost DROP COLUMN [Billing Tag]
	IF	@i_BasePricePerSubclient = 0
		SET @ShowBasePrice = 0
END
ELSE
IF @i_AggregateLevel = 1 -- Client
BEGIN
	ALTER TABLE #Cost DROP COLUMN [Agent]
	ALTER TABLE #Cost DROP COLUMN [Instance]
	ALTER TABLE #Cost DROP COLUMN [Backupset]
	ALTER TABLE #Cost DROP COLUMN [Subclient]
	ALTER TABLE #Cost DROP COLUMN [Storage Policy]
	ALTER TABLE #Cost DROP COLUMN [Copy]
	ALTER TABLE #Cost DROP COLUMN [No. of Clients<FORMATNUMBERNA>]
	ALTER TABLE #Cost DROP COLUMN [Billing Tag]
	INSERT	INTO #Cost
	SELECT 	C.CommServUniqueId, C.CommServName, ISNULL(CGS.ClientGroups, ''), C.ClientName,
			@BytesToUnit*S.FrontEndBackupSize,  S.FrontEndBackupCost,
			@BytesToUnit*S.FrontEndArchiveSize,	S.FrontEndArchiveCost,
			@BytesToUnit*S.PrimaryAppSize,      S.PrimaryAppCost,
			@BytesToUnit*S.DataProtected,       S.DataProtectedCost,
			@BytesToUnit*S.DataWritten,         S.DataWrittenCost,
			@BytesToUnit*S.TotalProtectedApp,   S.TotalProtectedAppCost,
			@BytesToUnit*S.T