

--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/CSDRBackupJobInformation.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: CSDRBackupJobInformation"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[CSDRBackupJobInformation]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[CSDRBackupJobInformation]
GO

delete from GXDBVersions where name = 'CSDRBackupJobInformation' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'CSDRBackupJobInformation', '1.1.2.2', 'CSDRBackupJobInformation', '')
GO
CREATE VIEW [dbo].[CSDRBackupJobInformation]
AS
SELECT
	CAST(CC.CommCellID AS INT) AS CommCellID,
	CC.DisplayName AS CommServName,
	2 AS ClientId,
	CC.CommServName AS ClientName,
	'' AS PhysicalClientName,
	0 AS AgentId,
	'N/A' AS AgentName,
	0 AS InstanceId,
	'N/A' AS InstanceName,
	0 AS BackupSetId,
	'N/A' AS BackupsetName,
	0 AS SubclientId,
	'N/A' AS subclientName,
	'N/A' AS Content,
	A.SchedulePolicy AS SchedulePolicy,
	A.ScheduleName AS ScheduleName,
	sub.SchedBackupType AS SchedBackupType,
	sub.SchedPattern AS SchedPattern,
	sub.SchedBackupDay AS SchedBackupDay,
	sub.SchedBackupTime AS SchedBackupTime,
	sub.SchedNextBackupTime AS SchedNextBackupTime,
	Copy.PolicyName AS PolicyName,
	Copy.CopyName AS CopyName,
	'Primary' AS CopyType,
	Copy.RetentionDays AS RetentionDays,
	Copy.RetentionCycles AS RetentionCycles,
    CASE AC.type
		WHEN 0 THEN 'All full'
        WHEN 1 THEN 'Cycle'
        WHEN 2 THEN 'Weekly Fulls'
        WHEN 3 THEN 'Daily Fulls'
        WHEN 4 THEN (CASE AC.NumPeriod
				WHEN 3 THEN 'Quarterly Fulls'
                WHEN 6 THEN 'Half Yearly Fulls'
                WHEN 12 THEN 'Yearly Fulls'
                ELSE 'Monthly' END)
		WHEN 6 THEN 'Monthy On weekday'
        WHEN 8 THEN 'Copy last full when auxillary copy starts'
        WHEN 9 THEN 'Manual'
        WHEN 10 THEN 'Hourly'
		ELSE ''
    END AS 'Job Selection',
    CASE WHEN AC.type = 4 AND AC.NumPeriod IN (3,6,12) THEN '1' ELSE ISNULL(CAST(AC.NumPeriod AS varchar(5)),'') END AS 'Frequency',
    CASE AC.type
		WHEN 2 THEN (CASE AC.dayNumber
						WHEN 0 THEN 'Sunday'
                        WHEN 1 THEN 'Monday'
                        WHEN 2 THEN 'Tuesday'
                        WHEN 3 THEN 'Wednesday'
                        WHEN 4 THEN 'Thursday'
                        WHEN 5 THEN 'Friday'
                        WHEN 6 THEN 'Saturday'
					END)
		WHEN 4 THEN CAST(AC.dayNumber AS varchar(5))
        ELSE ''
	END AS 'Week/Month Start Day'
FROM (
	SELECT DISTINCT AJ.CommservUniqueId, AJ.StoragePolicyID, AJ.SchedulePolicy, AJ.ScheduleName FROM cf_SurveyAdminJobStats AJ WITH(NOLOCK) WHERE AJ.OpType = 11 --CS DR Backup
	) A
	INNER JOIN dbo.cf_SurveyResultFuncV1(2, 0, 1, null, null, -1, -1) as CC
		ON CC.CommServUniqueId = A.CommservUniqueId
	LEFT OUTER JOIN cf_SurveyCopyBasicRetention AS Copy WITH(NOLOCK)
		ON A.CommservUniqueId = Copy.CommservUniqueId
			AND A.StoragePolicyID = Copy.PolicyId
			AND Copy.IsDefaultCopy = 1	--Only Primary Copy
	LEFT OUTER JOIN cf_SurveyArchSelectiveCopy AS AC WITH(NOLOCK)
		ON AC.CommservUniqueId = Copy.CommservUniqueId
			AND Copy.CopyId = AC.CopyId
	LEFT OUTER JOIN (
		SELECT BS.CommservUniqueId,
			BS.SchedulePolicy,
			BS.ScheduleName,
			MAX(BS.SchedBackupType) AS SchedBackupType,
			MAX(BS.SchedPattern) AS SchedPattern,
			MAX(BS.SchedBackupDay) AS SchedBackupDay,
			MAX(BS.SchedBackupTime) AS SchedBackupTime,
			MAX(BS.SchedNextBackupTime) AS SchedNextBackupTime
		FROM cf_SurveyBackupSchedule BS WITH(NOLOCK)
		WHERE BS.ClientId = 0
		GROUP BY BS.CommservUniqueId, BS.SchedulePolicy, BS.ScheduleName
	) sub
		ON sub.CommservUniqueId = CC.CommServUniqueId
		AND sub.SchedulePolicy = A.SchedulePolicy
		AND sub.ScheduleName = A.ScheduleName
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [CSDRBackupJobInformation]'
END
GO

