

--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/Last7DayBackupDetails.view] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
SET ANSI_NULLS  ON
print '... Creating View: Last7DayBackupDetails'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[Last7DayBackupDetails]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[Last7DayBackupDetails]
GO

delete from GXDBVersions where name = 'Last7DayBackupDetails' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'Last7DayBackupDetails', '1.9.2.5', 'Last7DayBackupDetails', '')
GO
CREATE VIEW Last7DayBackupDetails
AS
SELECT
	CAST(CC.CommCellID AS INT) AS CommCellID,
	CC.CommServName AS CommServName,
	SA.ClientId AS 'ClientID',
	SA.clientName AS Client,
	ISNULL(SA.PhysicalClientName,SA.clientName) AS PhysicalClientName,
	SA.AppTypeId AS 'AgentID',
	S.AgentName AS 'Agent',
	SA.InstanceId AS 'InstanceID',
	S.InstanceName AS 'Instance',
	SA.BackupsetId AS 'BackupSetID',
	S.BackupsetName AS 'Backupset',
	SA.AppId AS 'SubclientID',
	S.SubclientName AS 'Subclient',
	JobId AS 'Job ID',
	StartDate AS 'Start Time',
	DATEADD(second, StartDate, CAST('1970-01-01 00:00:00' AS datetime)) AS 'StartDate',
	EndDate AS 'End Time',
	DATEADD(second, EndDate, CAST('1970-01-01 00:00:00' AS datetime)) AS 'EndDate',
	CASE Status
		  WHEN 0 THEN 'Running'
		  WHEN 1 THEN 'Completed'
		  WHEN 2 THEN 'Failed'
		  WHEN 3 THEN 'Completed with errors'
		  WHEN 4 THEN 'Killed'
		  WHEN 5 THEN 'Suspended'
		  WHEN 6 THEN 'Interrupted'
		  WHEN 7 THEN 'Any Status'
		  WHEN 8 THEN 'Skipped'
		  WHEN 9 THEN   CASE WHEN failureErrorCode NOT IN (8)  THEN 'Skipped' ELSE 'Failed To Start' END
		  WHEN 10 THEN 'Synchronized'
		  WHEN 11 THEN 'Not Synchronized'
		  WHEN 12 THEN 'Not Attempted'
		  WHEN 13 THEN 'Started'
		  WHEN 14 THEN 'Completed with warnings'
		  WHEN 15 THEN 'System Failed'
		  WHEN 16 THEN 'Committed'
		  ELSE 'Unknown'
	END AS 'Job Status',
	CASE OpType
		  WHEN 4 THEN (CASE WHEN S.AppTypeId = 67 THEN N'Compliance Archive' ELSE N'Backup' END)
		  WHEN 14 THEN N'Synthetic Full'
		  WHEN 18 THEN N'Backup 3RD'
		  WHEN 59 THEN N'Snap Backup'
		  WHEN 60 THEN N'Backup Copy'
		  WHEN 65 THEN N'Snap Backup3RD'
		  ELSE N'Unknown'
	END AS 'Operation',
	CASE BkpLevel
		  WHEN 1 THEN (CASE WHEN S.AppTypeId IN (45,56,57,58,67,73) THEN N'New Index' ELSE N'Full' END)
		  WHEN 2 THEN (CASE WHEN S.AppTypeId IN (4,5,16,70,81) THEN N'Transaction Log' WHEN S.AppTypeId = 125 THEN N'Log Only' ELSE N'Incremental' END)
		  WHEN 4 THEN (CASE WHEN S.AppTypeId IN (37,62) THEN N'Delta' ELSE N'Differential' END)
		  WHEN 0x40    THEN N'Synthetic Full' WHEN 0x80 THEN N'Synthetic Full' WHEN 0x4000 THEN N'Synthetic Full'
		  WHEN 0x100   THEN (CASE WHEN S.AppTypeId = 104 THEN N'Incremental' ELSE N'Transaction Log' END)
		  WHEN 0x200   THEN N'ASR'
		  WHEN 0x800   THEN N'Snapshot'
		  WHEN 0x1000  THEN N'New Volume Creation'
		  WHEN 0x2000  THEN N'Incremental Volume Update'
		  WHEN 0x400   THEN N'Offline Full'
		  WHEN 0x8000  THEN N'Online Full'
		  WHEN 0x20000 THEN N'Analysis'
		  WHEN 0x40000 THEN N'Discovery'
		  ELSE N'Unknown'
	END AS 'Job Type',
	CASE ScanType
		  WHEN 1 THEN 'Change Journal'
		  WHEN 2 THEN 'Classic'
		  WHEN 3 THEN 'Mixed'
		  WHEN 4 THEN 'Optimized Scan'
		  ELSE ''
	END AS 'Scan Type',
	CAST(DataProtected/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Application Size (MB)',
	CAST((CASE WHEN DataProtected > 0 AND DataProtected > DataCompressed THEN 100.0*(DataProtected - DataCompressed)/DataProtected ELSE 0 END)
		  AS DECIMAL(20,2)) AS 'Compression Rate (%)',
	CAST(DataTransferred/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Transferred (MB)',
	CAST(DataWritten/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Written (MB)',
	CAST((CASE WHEN DataProtected > 0 AND DataProtected > DataWritten THEN 100.0*(DataProtected - DataWritten)/DataProtected ELSE 0 END)
		  AS DECIMAL(10,2)) AS 'Space Saving (%)',
	SizeChangePct AS 'Data Size Change (%)',
	CONVERT(VARCHAR(20), DATEADD(SECOND, TransferTime, 0), 108) AS 'Transfer Time',
	CAST((CASE WHEN TransferTime > 0 THEN 3600.0*DataProtected/1024.0/1024.0/1024.0/TransferTime ELSE 0.0 END)
		  AS DECIMAL(10,3)) AS 'Throughput (GB/Hour)',
	J.StoragePolicy AS 'Storage Policy',
	CAST(C.ClientGroups AS nvarchar(1024)) AS 'Client Groups',
	ErrorCode AS 'Error Code',
	FailureReason AS 'Failure Reason',
	CASE WHEN S.AppTypeId IN (45,56,57,58,66,67,68,73,82,83,89,90) THEN P.MaxArchiverRetDays
		 ELSE P.MaxRetentionDays
	END AS 'Max Retention Days',
	SchedulePolicy AS 'Schedule Policy',
	ScheduleName AS 'Schedule Name',
	Attempts AS 'Job Attempts'
FROM
	cf_SurveyJobStats J WITH (NOLOCK)
	INNER JOIN cf_SurveySubclients S WITH (NOLOCK) ON J.CommservUniqueId = S.CommservUniqueId AND J.AppId = S.AppId
	LEFT JOIN ( --Use left join here to not exclude the failed to start jobs where storage policy would be empty in cf_SurveyJobStats
		SELECT CommservUniqueId, PolicyId, MAX(RetentionDays) AS MaxRetentionDays, MAX(ArchiverRetDays) AS MaxArchiverRetDays
		FROM cf_SurveyCopyBasicRetention WITH (NOLOCK)
		GROUP BY CommservUniqueId, PolicyId
	) AS P ON P.CommservUniqueId = J.CommservUniqueId AND (P.PolicyId = J.StoragePolicyID OR (P.PolicyId = J.LogStoragePolicyID AND J.StoragePolicyID = 0))
	INNER JOIN cf_CommcellIdNameMap as CC WITH (NOLOCK)
            ON CC.ID = J.CommservUniqueId
    INNER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK)
		ON J.CommservUniqueId = SA.CommservUniqueId AND J.AppId = SA.AppId
	INNER JOIN cf_surveyClient C WITH (NOLOCK) ON SA.CommservUniqueId = C.CommservUniqueId AND C.clientId = SA.ClientId
WHERE
	J.EndDate > DATEDIFF(s, '1970-01-01 00:00:00', DATEADD(d, -7, GETUTCDATE()))
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [Last7DayBackupDetails]'
END
GO

