

--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/SubclientCopyRetention.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: SubclientCopyRetention"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SubclientCopyRetention]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[SubclientCopyRetention]
GO

delete from GXDBVersions where name = 'SubclientCopyRetention' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'SubclientCopyRetention', '1.4', 'SubclientCopyRetention', '')
GO
CREATE VIEW [dbo].[SubclientCopyRetention]
AS
SELECT
    CC.CommCellID,
    CC.CommServName,
    SC.ClientId,
    SC.clientName AS ClientName,
	ISNULL(SC.PhysicalClientName,SC.clientName) AS PhysicalClientName,
    SC.AppTypeId,
    SC.AgentName,
    SC.InstanceName,
    SC.BackupsetName,
    SC.AppId,
    SC.SubclientName,
    Copy.PolicyId,
    Copy.PolicyName,
    Copy.CopyId,
    Copy.CopyName,
    Copy.IsDefaultCopy,
    Copy.IsSnapCopy,
    CASE WHEN (Copy.AgingFlags & 4) = 4 THEN -1
	     WHEN SC.AppTypeId IN (45,56,57,58,66,67,68,73,82,83,89,90) THEN Copy.ArchiverRetDays
	     ELSE Copy.RetentionDays
    END AS RetentionDays,
    Copy.RetentionCycles
FROM cf_SurveySubclientAssociation AS SC
    INNER JOIN cf_SurveyCopyBasicRetention AS Copy
       ON SC.CommservUniqueId = Copy.CommservUniqueId AND SC.DataPolicyId = Copy.PolicyId AND SC.AppId > 0 AND SC.Deleted = 0
    INNER JOIN cf_CommcellIdNameMap AS CC
       ON Copy.CommservUniqueId = CC.ID
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [SubclientCopyRetention]'
END
GO

