

--  ------------  Generated from [../../../Source/CommServer/CloudDB/CSView/cf_SurveyResultView.view] ---------- 

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
print "... Creating View: cf_SurveyResultView"
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[cf_SurveyResultView]') and OBJECTPROPERTY(id, N'IsView') = 1)
drop view [dbo].[cf_SurveyResultView]
GO

delete from GXDBVersions where name = 'cf_SurveyResultView' and type=4
insert into GXDBVersions  (type, name, revision, aliasname, SafeRevision) VALUES (4,'cf_SurveyResultView', '1.5', 'cf_SurveyResultView', '')
GO
CREATE VIEW [dbo].[cf_SurveyResultView]
AS
	SELECT
		ccNameMap.ID AS 'CommServUniqueId',
		ccNameMap.CommCellID AS 'CommCellID',
		ccNameMap.CommServIP AS 'CommServIP',
		ccNameMap.CommServGUID AS 'CommServGUID',
		ccNameMap.CustomerName AS 'CustomerName',
		ccNameMap.CommServName AS 'CommServName',
		xmlFile.ID AS 'CustomerFeedbackXMLFileId',
		xmlFile.CommServTZ AS 'CommServTimeZone',
		xmlFile.CommServVersion AS 'CommServVersion',
		result.CommservSurveyResults_ID AS 'SurverResultId',
		result.QueryId AS 'SurveyID',
		result.LogDate AS 'LogDate',
		result.LogDateUTC AS 'LogDateUTC',
		result.RunningTime AS 'RunningTime',
		result.Flags AS 'SureyResultFlags',
		result.collectedResults AS 'CollectedResults'
	FROM dbo.cf_CommservSurveyResults AS result
		INNER JOIN dbo.cf_CustomerFeedbackXmlFile AS xmlFile
			ON xmlFile.ID = result.CustomerFeedbackXmlFile_id
		INNER JOIN dbo.cf_CommcellIdNameMap AS ccNameMap
			ON xmlFile.CommcellIdNameMap_ID = ccNameMap.ID
			AND (ccNameMap.Flags & 1) <> 1 --Remove Blocked CommCells
GO

declare @retCode integer		-- Now do Error Check

set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 View File [cf_SurveyResultView]'
END
GO

