

--  ------------  Generated from [../../../Source/CommServer/CloudDB/TblScript/cf_CommservSurveyQueries.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2007  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/TblScript/cf_CommservSurveyQueries.script,v $ $Id: cf_CommservSurveyQueries.script,v 1.135.2.123.14.1 2021/03/22 20:05:05 pkrishnan Exp $";
-- TABLENAME cf_CommservSurveyQueries

print '... inserting Table: cf_CommservSurveyQueries'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME cf_CommservSurveyQueries

SET NOCOUNT ON;

DECLARE @QueryId int,

		@QueryName nvarchar(200),

		@Description nvarchar(1024),

		@Details nvarchar(MAX),

		@Flags int,

		@Type int,

		@CollectScriptName nvarchar(200),

		@ParserScriptName nvarchar(200),

		@ParserScript nvarchar(max),

		@DataRetentionDays int,

		@DataRetentionIntervalHrs int

DECLARE @param_isPrivate INT = 0

SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'

BEGIN TRY

	DECLARE @dropSPQuery  NVARCHAR(256)

	DECLARE @parserSPName NVARCHAR(200)

	DECLARE	CustomQueryCur CURSOR FOR

	SELECT ParserScript

	FROM   cf_CommservSurveyQueries

	WHERE QueryId >= 10000 AND DataTableName IS NOT NULL AND ParserScript <> 'ParseCustomQueryResult'

	OPEN CustomQueryCur

		FETCH FROM CustomQueryCur INTO @parserSPName

	WHILE @@FETCH_STATUS = 0

	BEGIN

		SET @dropSPQuery = 'DROP PROCEDURE ' + @parserSPName

		EXEC sp_executesql @dropSPQuery

		FETCH FROM CustomQueryCur INTO @parserSPName

	END

	CLOSE CustomQueryCur

	DEALLOCATE CustomQueryCur

	UPDATE cf_CommservSurveyQueries SET ParserScript = 'ParseCustomQueryResult' 

	WHERE QueryId >= 10000 AND DataTableName IS NOT NULL AND ParserScript <> 'ParseCustomQueryResult'

	SELECT @QueryId = 1,

		@QueryName = 'License Usage',

		@Description = 'Information about Total and Used Capacity Licence',

		@Details = 'Information about Total and Used Capacity Licence',

@Flags = 1 | 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'Not Applicable',

		@ParserScriptName = 'RptCapacityLicenseSurvey',

		@ParserScript = 'ParseCapacityLicenseSurvey',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 2,

		@QueryName = 'CommServe Details',

		@Description = 'CommServe Configuration Details',

		@Details = 'CommServe Configuration Details',

@Flags = 2 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_2.sql',

		@ParserScriptName = 'RptCommServDetails',

		@ParserScript = 'ParseCommServDetails',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 3,

		@QueryName = 'Agent Capacity License Usage',

		@Description = 'Capacity Usage and License Usage counts per IDA',

		@Details = 'Capacity Usage and License Usage counts per IDA',

@Flags = 2 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_3.sql',

		@ParserScriptName = 'RptAgentCapacityLicenseSurvey',

		@ParserScript = 'ParseAgentCapacityLicenseSurvey',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = CASE WHEN @param_isPrivate = 1 THEN 168 ELSE 24 END

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 4,

		@QueryName = 'Snap Engine Usage',

		@Description = 'Snap Usage Information',

		@Details = 'Information about usage of Snapshot Engines',

@Flags = 1 | 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_4.sql',

		@ParserScriptName = 'RptSnapshotEngineSurvey',

		@ParserScript = 'ParseSnapshotEngineSurvey',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 5,

		@QueryName = 'GUI Login Languages',

		@Description = 'Information about logged in Languages',

		@Details = 'Information about logged in Languages',

@Flags = CASE WHEN @param_isPrivate = 1 THEN 0 ELSE 1 | 2 END,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_5.sql',

		@ParserScriptName = 'RptGUILoginLanguageSurvey',

		@ParserScript = 'ParseGUILoginLanguageSurvey',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 21600

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 6,

		@QueryName = 'DeDup',

		@Description = 'DeDup Information',

		@Details = 'DeDup Information',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_6.sql',

		@ParserScriptName = 'RptSurveyResultsXML',

		@ParserScript = '',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 168

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 7,

		@QueryName = 'Scale Statistics',

		@Description = 'Scale Statistics',

		@Details = 'Scale Statistics',

@Flags = 2 | 4 | 256 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_7.sql',

		@ParserScriptName = 'RptScalereportCommcellStatusSurvey',

		@ParserScript = 'ParseScalereportCommcellStatusSurvey',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 8,

		@QueryName = 'Client Statistics',

		@Description = 'Clients and laptops count',

		@Details = 'Clients and laptops count',

@Flags = 2 | 256 | 512,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_8.sql',

		@ParserScriptName = 'RptClientStatisticsSurvey',

		@ParserScript = 'ParseClientStatisticsSurvey',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 336

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 9,

		@QueryName = 'Subclient Policies Count',

		@Description = 'Number of Subclient Policies and Associated backupset to Subclient Policies',

		@Details = 'Number of Subclient Policies and Associated backupset to Subclient Policies',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_9.sql',

		@ParserScriptName = 'RptSubClientPoliciesCountSurvey',

		@ParserScript = 'ParseSubClientPoliciesCountSurvey',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 168

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 10,

		@QueryName = 'FAST Usage',

		@Description = 'Fast Configuration and Usage',

		@Details = 'Fast Configuration and Usage',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_10.sql',

		@ParserScriptName = 'RptFastUsageSurvey',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 168

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 11,

		@QueryName = 'GetJobsWrittenAfterSP5bRecon',

		@Description = 'GetJobsWrittenAfterSP5bRecon',

		@Details = 'This survey will returns list of jobs that were written using a DDB that was recently reconstructed',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_11.sql',

		@ParserScriptName = 'RptDDBAffectedCustomers',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 168

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 12,

		@QueryName = 'Software Version',

		@Description = 'CommServe installed updates and update cache information',

		@Details = 'Report installed CS DB service pack and loose updates. Report service pack and loose updates present in update cache.',

@Flags = 1 | 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_12.sql',

		@ParserScriptName = 'RptUpdateInfoSurvey',

		@ParserScript = 'ParseUpdateInfoSurvey',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 168

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 13,

		@QueryName = 'DeDup Backup Stores Report',

		@Description = 'Report identifies the storage policy/copies what have DDBs not backed up using DDB backup subclient.',

		@Details = 'Report identifies the storage policy/copies what have DDBs not backed up using DDB backup subclient.',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_13.sql',

		@ParserScriptName = 'RptSurveyResultsXML',

		@ParserScript = '',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 168

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 14,

		@QueryName = 'DDB Store Usage per Media Agent',

		@Description = 'Provide the Dedup Store Usage Media Agent',

		@Details = 'Health Check - Daily basis history will be stored in table so can be viewed as value.,',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_14.sql',

		@ParserScriptName = 'RptDeDupStoreInfo',

		@ParserScript = 'ParseDeDupStoreInfo',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = CASE WHEN @param_isPrivate = 1 THEN 168 ELSE 24 END

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 15,

		@QueryName = 'QAStatistics',

		@Description = 'Statistics',

		@Details = 'restore job statistics,   Sub client Schedule statistics,  Storage Policy statistics',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_15.sql',

		@ParserScriptName = 'RptQAStatistics',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 16,

		@QueryName = 'Backup Job Statistics for last 60 days',

		@Description = 'Backup Success and failure statistics',

		@Details = 'Health Check - Stats for all backup jobs will be provided in a single go.Each report contains aggregated data',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_16.sql',

		@ParserScriptName = 'RptBkpJobStatus',

		@ParserScript = 'ParseBkpJobStatus',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 17,

		@QueryName = 'Restore Statistics for last 90 days',

		@Description = 'Provides the success and failure job in the CS',

		@Details = 'Health Check - Stats for all restore jobs will be provided in a single go.Each report contains aggregated data',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_17.sql',

		@ParserScriptName = 'RptRestoreStatus',

		@ParserScript = 'ParseRestoreStatus',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 18,

		@QueryName = 'Clients at 2 versions behind CommServe',

		@Description = 'Clients in unsupported version',

		@Details = 'Health Check - Find out Clients and Media agents having version discrepancies. Pick up the clients which are 2 versions less than CS.',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_18.sql',

		@ParserScriptName = 'RptUnsupportedClient',

		@ParserScript = 'ParseUnsupportedClient',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 19,

		@QueryName = 'DR Backup Statistics',

		@Description = 'Total Number of successful DR backups Failed DR backups Last date of Successful DR backup',

		@Details = 'Health Check - Stats for all DR backup jobs will be provided in a single go. Each report contains aggregated data',

@Flags = 2  | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_19.sql',

		@ParserScriptName = 'RptDRBkpStatus',

		@ParserScript = 'ParseDRBkpStatus',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 20,

		@QueryName = 'Subclients without Storage Policy Association',

		@Description = 'Total Number Of clients, Number of Clients without Storage Policy configured, List of clients without Storage Policy configured, % of Client Without Storage Policy Configured',

		@Details = 'Health Check - Clients (containing subclients) which do not have storage policy configured will be provided. This script will be run once a month',

@Flags = 2 | 256 | 512  | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_20.sql',

		@ParserScriptName = 'RptClientsWithoutSP',

		@ParserScript = 'ParseClientsWithoutSP',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 21,

		@QueryName = 'DDB Backups using enhanced process',

		@Description = 'No.of MA have DDB backups been configured to use the enhanced process',

		@Details = 'Health Check - No.of MA have DDB backups been configured to use the enhanced process',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_21.sql',

		@ParserScriptName = 'RptDeDupBkpConfig',

		@ParserScript = 'ParseDeDupBkpConfig',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 22,

		@QueryName = 'Unused Schedule Policies',

		@Description = 'Is Shedule Policy being used?',

		@Details = 'Health Check - Is Shedule Policy being used?',

@Flags = 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_22.sql',

		@ParserScriptName = 'RptSchedulePolicyUsage',

		@ParserScript = 'ParseSchedulePolicyUsage',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 23,

		@QueryName = 'Largest 25 Clients',

		@Description = '25 largest clients by application size',

		@Details = 'Health Check - 25 largest clients by backup size',

@Flags = 2 | 4 | 8 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_23.sql',

		@ParserScriptName = 'RptLargestClientsByBKPSize',

		@ParserScript = 'ParseLargestClientsByBKPSize',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 24,

		@QueryName = 'Long Running Backup Jobs for last 1 day (Top 25 Jobs)',

		@Description = 'Get 25 jobs that are taking more than 12 hours',

		@Details = 'Health Check - Get 25 jobs that are taking more than 12 hours',

@Flags = 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_24.sql',

		@ParserScriptName = 'RptLongRunningJobs',

		@ParserScript = 'ParseLongRunningJobs',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 25,

		@QueryName = 'Strike Count',

		@Description = 'All clients that are continuously failing.',

		@Details = 'Health Check - All clients that are continuously failing',

@Flags = 1 | 2 | 4 | 8 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_25.sql',

		@ParserScriptName = 'RptFailingClients',

		@ParserScript = 'ParseFailingClients',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 26,

		@QueryName = 'Deduplication Ratio For The Last 30 Days',

		@Description = 'Total Deduplication Savings',

		@Details = 'Health Check - Dedupe ratio of each storage policy copy based on jobs in last 30 days',

@Flags = 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_26.sql',

		@ParserScriptName = 'RptDeDupRatioBySPCopy',

		@ParserScript = 'ParseDeDupRatioBySPCopy',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 27,

		@QueryName = 'SLA',

		@Description = 'Clients that are not protected in SLA period',

		@Details = 'Health Check - Clients that are not protected in SLA period',

@Flags = 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_27.sql',

		@ParserScriptName = 'RptUnprotectedClients',

		@ParserScript = 'ParseUnprotectedClients',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 28,

		@QueryName = 'Incremental backup change rate for Last 7 days',

		@Description = 'List out data change rates per day (GB and percentage)',

		@Details = 'Health Check - Stats of the last 8 days incremental backup will be provided. Each report will generate daily change rate of incremental backupsize with respect to previous day. It will run  every week',

@Flags = 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_28.sql',

		@ParserScriptName = 'RptIncrBkpChangeRate',

		@ParserScript = 'ParseIncrBkpChangeRate',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 29,

		@QueryName = 'Clients configured but not backed up',

		@Description = '',

		@Details = 'Health Check',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_29.sql',

		@ParserScriptName = 'RptSurveyResultsXML',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 30,

		@QueryName = 'Top 10 Errors in last 24 hours',

		@Description = 'Top 25 Clients most frequent errors',

		@Details = 'Health Check - Top 25 Clients with most frequent errors',

@Flags = 1 | 2 | 8 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_30.sql',

		@ParserScriptName = 'RptMostFrequentErrors',

		@ParserScript = 'ParseMostFrequentErrors',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 31,

		@QueryName = 'Disaster Recovery Backup',

		@Description = '',

		@Details = 'Health Check',

@Flags = 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_31.sql',

		@ParserScriptName = 'RptDRBkpConfiguration',

		@ParserScript = 'ParseDRBkpConfiguration',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 32,

		@QueryName = 'Concurrent LAN Backup Settings',

		@Description = 'Optimize Concurrent LAN Backups',

		@Details = 'Health Check',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_32.sql',

		@ParserScriptName = 'RptMALANBackups',

		@ParserScript = 'ParseMALANBackups',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 33,

		@QueryName = 'DASH Option',

		@Description = 'Dash Optimization',

		@Details = 'Health Check',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_33.sql',

		@ParserScriptName = 'RptDashOptions',

		@ParserScript = 'ParseDashOptions',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 34,

		@QueryName = 'Client Count by Job Priority',

		@Description = 'Client Count by Job Priority',

		@Details = 'Client Count by Job Priority',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_34.sql',

		@ParserScriptName = 'RptClientsByJobPriority',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 35,

		@QueryName = 'Deduplication Stores with pending pruning for backup jobs',

		@Description = 'DeDup Deleted Archive File Count',

		@Details = 'DeDup Deleted AF Count',

@Flags = 2 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_35.sql',

		@ParserScriptName = 'RptDeDupDeletedAFCount',

		@ParserScript = 'ParseDeDupDeletedAFCount',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = CASE WHEN @param_isPrivate = 1 THEN 0 ELSE 24 END

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 36,

		@QueryName = 'Subclients Without Schedules',

		@Description = 'Subclients Without Schedules',

		@Details = 'Health Check - List of subclients with no schedules and its last backup',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_36.sql',

		@ParserScriptName = 'RptSurveyResultsXML',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 37,

		@QueryName = 'Clients completing with errors in last 30 days',

		@Description = 'Clients with jobs completing with errors',

		@Details = 'Health Check - The query gives information about the clients that have jobs completing with errors.',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_37.sql',

		@ParserScriptName = 'RptClientJobsCompletingWithError',

		@ParserScript = 'ParseClientJobsCompletingWithError',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 38,

		@QueryName = 'Release Adoption Rate',

		@Description = 'CommServ upgrade history',

		@Details = 'To track the time of upgrade of CommServes',

@Flags = CASE WHEN @param_isPrivate = 1 THEN 2 ELSE 1 | 2 END,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_38.sql',

		@ParserScriptName = 'RptUpgradeHistory',

		@ParserScript = 'ParseUpgradeHistory',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 39,

		@QueryName = 'Index Cache Location',

		@Description = 'Media Agent Index Cache Usage',

		@Details = 'Media Agent Index Cache Usage',

@Flags = 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_39.sql',

		@ParserScriptName = 'RptIndexCacheUsage',

		@ParserScript = 'ParseIndexCacheUsage',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 40,

		@QueryName = 'Upgrade Check',

		@Description = 'backup jobs grouped by AppType Statistics.',

		@Details = 'Upgrade Check -- backup jobs grouped by AppType Statistics.',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_40.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseUpgradeCheck',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 41,

		@QueryName = 'Deprecated Agent Usage',

		@Description = 'Deprecated Agent and Feature Usage',

		@Details = 'Deprecated Agent and Feature Usage',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_41.sql',

		@ParserScriptName = 'RptDeprecatedAgentInfo',

		@ParserScript = 'ParseDeprecatedAgentInfo',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 42,

		@QueryName = 'Web Search Server Installation',

		@Description = 'Web Search Server Usage',

		@Details = 'Web Search Server Usage',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_42.sql',

		@ParserScriptName = 'RptWebServerInstallation',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 43,

		@QueryName = 'SQL transaction log database job statistics',

		@Description = 'Gathering Top 20 SQL transaction log database job details',

		@Details = 'The purpose is to find the time taken by SQL transaction log backups.',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_43.sql',

		@ParserScriptName = 'RptSQLDBTranLogInfo',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 44,

		@QueryName = 'Slowest Clients by Throughput',

		@Description = 'slowest clients',

		@Details = 'top 10 slowest clients by throughput',

@Flags = 1 | 2 | 8 | 256 | 512,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_44.sql',

		@ParserScriptName = 'RptSlowestClients',

		@ParserScript = 'ParseSlowestClients',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 45,

		@QueryName = 'PrePostUpgradeSLA',

		@Description = 'Gather 3 and 7 and 21 day SLA before and after upgrade',

		@Details = 'used in upgrade helth check report',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_45.sql',

		@ParserScriptName = 'RptSurveyResultsXML',

		@ParserScript = 'ParsePrePostUpgradeSLA',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 48,

		@QueryName = 'SRM Usage Statistics',

		@Description = 'SRM Enabled client,subcient information,DC enabled,FLA information',

		@Details = 'provide SRM Reporting Client Information',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_48.sql',

		@ParserScriptName = 'RptSRMAgentInfo',

		@ParserScript = 'ParseSRMAgentInfo',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 49,

		@QueryName = 'Lotus Notes Provider',

		@Description = 'Gets the customer if a name server with LN is configured',

		@Details = 'The results will be used to determined if we have any customer using Lotus Notes login as this needs to be implemented for CI search and Web Console.',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_49.sql',

		@ParserScriptName = 'RptLotusNotesProvider',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 50,

		@QueryName = 'WeeklyDataProtectedbyAgents',

		@Description = 'Query to get Weekly Data Protected by Agents',

		@Details = 'We will serve this data to ROMS so they can query CVCloud database to get this info.',

@Flags = 0,

@Type = 1,

		@CollectScriptName = '',

		@ParserScriptName = 'RptSurveyResultsXML',

		@ParserScript = '',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 51,

		@QueryName = 'Backup Job Statistics Operation',

		@Description = 'Backup Success and failure statistics',

		@Details = 'Backup Success and failure statistics',

@Flags = 1 | 2 | 8 | 256 | 512,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_51.sql',

		@ParserScriptName = 'RptBkpJobStatus_WMon',

		@ParserScript = 'ParseBkpJobStatus_WMon',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 52,

		@QueryName = 'Storage Policy Media Type',

		@Description = 'Get the Storage Policies association with Mag and Tape media',

		@Details = 'This will used the new dash copy project',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_52.sql',

		@ParserScriptName = 'RptStoragePolicyMediaType',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 53,

		@QueryName = 'AuxCopy Throughput per Media Agent in last 30 days',

		@Description = 'Calculate aux copy throughput for individual MA for the last n days',

		@Details = 'Calculate aux copy throughput for individual MA for the last n days',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_53.sql',

		@ParserScriptName = 'RptAuxCopyPerMA',

		@ParserScript = 'ParseAuxCopyPerMA',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 54,

		@QueryName = 'Protected data per agent for last 7 days',

		@Description = 'How much data was protected by ida per week/month',

		@Details = 'How much data was protected by ida per week/month',

@Flags = 1 | 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_54.sql',

		@ParserScriptName = 'RptProtectedDataPerAgent',

		@ParserScript = 'ParseProtectedDataPerAgent',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 55,

		@QueryName = 'Average Throughput of Jobs in the Last Week',

		@Description = 'Display average throughput of backup and restore jobs in the last week.',

		@Details = 'Display average throughput of backup and restore jobs in the last week by media types and agent types.',

@Flags = 1 | 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_55.sql',

		@ParserScriptName = 'RptAvgBkpThroughput',

		@ParserScript = 'ParseAvgBkpThroughput',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 56,

		@QueryName = 'DeDup Disk Usage',

		@Description = 'Dedudep size vs size on disk for overall commcell. Disk utilization',

		@Details = 'Dedudep size vs size on disk for overall commcell. Disk utilization',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_56.sql',

		@ParserScriptName = 'RptDeDupDiskUsage',

		@ParserScript = 'ParseDeDupDiskUsage',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 57,

		@QueryName = 'CommServe',

		@Description = 'CommServe details like Alias Name, IP',

		@Details = 'CommServe details like Alias Name, IP',

@Flags = 0 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_57.sql',

		@ParserScriptName = 'RptSurveyResultsXML',

		@ParserScript = 'Parse_57CommservInfo',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 58,

		@QueryName = 'Win32 Commcells',

		@Description = 'CommServe with win32 package',

		@Details = 'CommServe with win32 package',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_58.sql',

		@ParserScriptName = 'RptCommservConfiguration',

		@ParserScript = 'ParseCommservConfiguration',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 59,

		@QueryName = 'Disabled Schedule Policies',

		@Description = 'Disabled Schedule Policies Details',

		@Details = 'Disabled Schedule Policies Details',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_59.sql',

		@ParserScriptName = 'RptSchedulePolicyInfo',

		@ParserScript = 'ParseSchedulePolicyInfo',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 60,

		@QueryName = 'Storage Policy Details',

		@Description = 'Storage Policy Details',

		@Details = 'Storage Policy Details',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_60.sql',

		@ParserScriptName = 'Rpt_60StoragePolicyDetails',

		@ParserScript = 'Parse_60StoragePolicyDetails',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 61,

		@QueryName = 'DDB Partition counts per MediaAgent',

		@Description = 'Provide Media Agent Dedup Partition Configuration',

		@Details = '',

@Flags = 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_61.sql',

		@ParserScriptName = 'RptDeDupStoreConfig',

		@ParserScript = 'ParseDeDupStoreConfig',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 62,

		@QueryName = 'Cloud Connectors',

		@Description = 'Cloud Connectors',

		@Details = 'Query to get list of Cloud Connectors',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_62.sql',

		@ParserScriptName = 'RptSurveyCloudConnector',

		@ParserScript = 'ParseCloudConnector',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 63,

		@QueryName = 'Storage Policy Audit',

		@Description = 'Display differences from a user selected storage policy',

		@Details = 'Display differences from a user selected storage policy',

		@Flags = CASE WHEN @param_isPrivate = 1

THEN 1 | 2 | 256 | 512

ELSE 0

			END,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_63.sql',

		@ParserScriptName = 'RptStoragePolicyAudit',

		@ParserScript = 'ParseArchiveGroupandCopyInfo',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 64,

		@QueryName = 'Fallen Behind Secondary Copies',

		@Description = 'Fallen Behind Secondary Copies',

		@Details = 'Query to get Fallen behind secondary copies',

@Flags = 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_64.sql',

		@ParserScriptName = 'RptSurveyFallenBehindCopies',

		@ParserScript = 'ParseFallenBehindCopies',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 65,

		@QueryName = 'DDB Performance and Status',

		@Description = 'DDB Performance by Average Q&I Time in last 3 days',

		@Details = 'Query to get DDB Performance',

@Flags = 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_65.sql',

		@ParserScriptName = 'RptSurveyDDBPerformance',

		@ParserScript = 'ParseDDBPerformance',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = CASE WHEN @param_isPrivate = 1 THEN 0 ELSE 24 END

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 66,

		@QueryName = 'DDB backups',

		@Description = 'DDB Partitions protected via subclient',

		@Details = 'Query to get DDB Protection',

@Flags = 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_66.sql',

		@ParserScriptName = 'RptSurveyDDBProtection',

		@ParserScript = 'ParseDDBProtection',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 67,

		@QueryName = 'Client Details',

		@Description = 'Client Details',

		@Details = 'Client Details',

		@Flags = CASE WHEN @param_isPrivate = 1

THEN 1

ELSE 64

			END,

@Type = 1,

		@CollectScriptName = '',

		@ParserScriptName = 'Rpt_67ClientDetails',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 68,

		@QueryName = 'Commcells with Outlook Add-in clients',

		@Description = 'provide commcells details with outlook add-in clients',

		@Details = '',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_68.sql',

		@ParserScriptName = 'Rpt_PackagesDetails',

		@ParserScript = 'Parse_PackagesDetails',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 69,

		@QueryName = 'FTP Download Tasks in last 6 months',

		@Description = 'FTP Download jobs started by Scheduled Active, Scheduled Disabled and interactive',

		@Details = 'FTP Download jobs started by Scheduled Active, Scheduled Disabled and interactive',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_69.sql',

		@ParserScriptName = 'RptFTPDownloadTask',

		@ParserScript = 'ParseFTPDownloadTask',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 70,

		@QueryName = 'Storage Policy Disk Usage',

		@Description = 'Storage Policy Disk Usage',

		@Details = 'Query to get Low Disk Space',

@Flags = 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_70.sql',

		@ParserScriptName = 'RptSurveyCopyFreeSpace',

		@ParserScript = 'ParseCopyFreeSpace',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 71,

		@QueryName = 'DDB Store Encrypted Key Information',

		@Description = 'To get information about the encryption enabled stores',

		@Details = 'Based on the results we want to add more functionality to decryption logic',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_71.sql',

		@ParserScriptName = 'RptDDBStoreEncryptedKey',

		@ParserScript = 'ParseDDBStoreEncryptedKey',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 72,

		@QueryName = 'Daily Storage Usage and Chargeback',

		@Description = 'Daily Storage Usage and Chargeback',

		@Details = 'Daily Storage Usage and Chargeback',

		@Flags = CASE WHEN @param_isPrivate = 1

THEN 1 | 2 | 256 | 512

ELSE 0

			END,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_72.sql',

		@ParserScriptName = 'RptMonthlyStorageUsage',

		@ParserScript = 'ParseDailyStorageUsage',

		@DataRetentionDays = 365,

		@DataRetentionIntervalHrs = 0

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 73,

		@QueryName = 'Commcell Statistics',

		@Description = 'Commcell Stats',

		@Details = 'Commcell Stats',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_73.sql',

		@ParserScriptName = 'Rpt_73Backup_Count',

		@ParserScript = 'Parse_73Backup_Count',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 77,

		@QueryName = 'Latest Data Protection',

		@Description = 'To get Laptop and Regular client information',

		@Details = 'To get Laptop and Regular client information',

@Flags = 2 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_77.sql',

		@ParserScriptName = 'Rpt_77ClientDetails',

		@ParserScript = 'Parse_77ClientDetails',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 78,

		@QueryName = 'SP And BaselineSize',

		@Description = 'SIDBStrId, SP name, DB Store name, SP Copy Name, Size of Application, SizeOnMedia and BaselineSize',

		@Details = 'For a commcell ID it provides all SP name, DB Store name, SP Copy Name their corresponding SizeOfApp, SizeOnMedia and BaseLineSize with records having non-zero SizeOfApp and SizeOnMedia',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_78.sql',

		@ParserScriptName = ' Rpt_78TblSIDBStoreAndBaselineSize',

		@ParserScript = ' Parse_78TblSIDBStoreAndBaselineSize',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 81,

		@QueryName = 'Client and MA Version Info',

		@Description = 'Node Id, Stautus id,TypeofNode,Status,Count',

		@Details = 'For a commcell ID it provides the count of clients and MA that are up to date, need update, ahead of cache or has Diagnostic Updates',

@Flags = 2 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_81.sql',

		@ParserScriptName = 'Rpt_81CommCellClientMAVersion',

		@ParserScript = 'Parse_81CommCellClientMAVersion',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 85,

		@QueryName = 'UpgradeIndexRestoreStats',

		@Description = 'Upgrade Check Index Restore Job info',

		@Details = 'Upgrade Check --Upgrade Check Index Restore Job info',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_85.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseUpgradeIndexRestoreStats',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 86,

		@QueryName = 'Index Cache Configuration',

		@Description = 'If catalog server is configured? If a customer has only magnetic libraries and has index cache retentions set to above default.',

		@Details = 'If local media agent retention for which catalog server is configured is more than 7 days : red. If local media agent retention for which catalog server is configured is less than 7 days : green. If there are only magnetic libraries and the index retention is set to a higher number than default (15 days) : red. If there are only magnetic libraries and the index retention is set to a equal or lower than default (15 days) : green.',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_86.sql',

		@ParserScriptName = 'RptIndexCacheConfig',

		@ParserScript = 'ParseIndexCacheConfig',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 87,

		@QueryName = 'Index Cache Server Status',

		@Description = 'If there are storage policies where failover configuration of gridstore\round robin selection is not made then catalog server\shared index cache is not required.',

		@Details = 'If catalog server \ shared index cache is configured : red, If catalog server \ shared index cache is not configured : green.',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_87.sql',

		@ParserScriptName = 'RptIndexCacheServerStatus',

		@ParserScript = 'ParseIndexCacheServerStatus',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 88,

		@QueryName = 'MediaAgent Audit',

		@Description = 'Display differences from a user selected MediaAgent',

		@Details = 'Display differences from a user selected MediaAgent',

		@Flags = CASE WHEN @param_isPrivate = 1

THEN 1 | 2 | 256 | 512

ELSE 0

			END,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_88.sql',

		@ParserScriptName = 'RptMediaAgentAudit',

		@ParserScript = 'ParseMediaAgentProp',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 89,

		@QueryName = 'Win XP Image iDA clients',

		@Description = 'Get number of clients using Windows XP Image iDA',

		@Details = 'Get number of clients using Windows XP Image iDA',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_89.sql',

		@ParserScriptName = 'Rpt_89WinXPImageiDAClients',

		@ParserScript = 'Parse_89WinXPImageiDAClients',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 90,

		@QueryName = 'Dedupe DB Reconstruction statistics',

		@Description = 'Dedupe DB Reconstruction statistics',

		@Details = 'Dedupe DB Reconstruction statistics',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_90.sql',

		@ParserScriptName = 'RptDedupDBReconStats',

		@ParserScript = 'ParseDedupDBReconStats',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 91,

		@QueryName = 'Protected Data Per Agent 6 Weeks Info',

		@Description = 'Gives full and Non-full backup Info about each agent for past 6 weeks.',

		@Details = 'It returns weekNo, Agent Type, Agent Id, FullApplication Size, Non-Full App Size,Full Job Count, Non Full Job Count and Weekly Change',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_91.sql',

		@ParserScriptName = 'Rpt_91ProtectedDataPerAgent6WeekInfo',

		@ParserScript = 'Parse_91ProtectedDataPerAgent6WeekInfo',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 92,

		@QueryName = 'Royalty Report',

		@Description = 'Royalty Report',

		@Details = 'Query to list clients and 1-touch clients',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_92.sql',

		@ParserScriptName = 'RptRoyaltyStats',

		@ParserScript = 'ParseRoyaltyStats',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 93,

		@QueryName = 'Library Audit',

		@Description = 'Display differences from a user selected library',

		@Details = 'Display differences from a user selected library',

		@Flags = CASE WHEN @param_isPrivate = 1

THEN 1 | 2 | 256 | 512

ELSE 0

			END,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_93.sql',

		@ParserScriptName = 'RptLibraryAudit',

		@ParserScript = 'ParseLibraryProp',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 94,

		@QueryName = 'VSA Backup Job Statistics',

		@Description = 'VSA Full and Increamental Backup Job Statistics',

		@Details = 'VSA Full and Increamental Backup Job Statistics',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_94.sql',

		@ParserScriptName = 'RptVSABkpJobInfo',

		@ParserScript = 'ParseVSABkpJobInfo',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 95,

		@QueryName = 'Mount Path',

		@Description = 'Mounth Path Information',

		@Details = 'All Mount Paths and their freespace, Used Space information',

@Flags = 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = '',

		@ParserScriptName = 'Rpt_95MountPathDetails',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 96,

		@QueryName = 'Disk Library Growth',

		@Description = 'Disk Library Information',

		@Details = 'All Disk Libraries and their freespace, Used Space information',

@Flags = 1 | 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_96.sql',

		@ParserScriptName = 'Rpt_96DiskLibDetails',

		@ParserScript = 'Parse_96DiskLibDetails',

		@DataRetentionDays = 365,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 97,

		@QueryName = 'Network Efficiency',

		@Description = 'Value Assessment - Infrastructure Savings - Network Efficiency',

		@Details = 'Value Assessment - Infrastructure Savings - Network Efficiency',

@Flags = 2 | 4 | 256 | 512,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_97.sql',

		@ParserScriptName = 'RptSourceDeDupEfficiency',

		@ParserScript = 'ParseSourceDeDupEfficiency',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 98,

		@QueryName = 'File System Backup Efficiency (Top 25 Jobs)',

		@Description = 'Value Assessment - Infrastructure Savings - File system Backup Efficiency',

		@Details = 'Value Assessment - Infrastructure Savings - File system Backup Efficiency',

@Flags = 4 | 256 | 512,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_98.sql',

		@ParserScriptName = 'RptLongRunningFSFullJobs',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 99,

		@QueryName = 'File Data Placement (Top 25 Clients)',

		@Description = 'Value Assessment - Infrastructure Savings - File Data Placement',

		@Details = 'Value Assessment - Infrastructure Savings - File Data Placement',

@Flags = 4 | 256 | 512,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_99.sql',

		@ParserScriptName = 'RptLargestNoArchiveFSClients',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 100,

		@QueryName = 'Rapid Recovery Capability (Top 25 Clients)',

		@Description = 'Value Assessment - Risk and SLAs - Rapid Recovery Capability',

		@Details = 'Value Assessment - Risk and SLAs - Rapid Recovery Capability',

@Flags = 4 | 256,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_100.sql',

		@ParserScriptName = 'RptLargestNoSnapClients',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 101,

		@QueryName = 'VM Backup Efficiency (Top 25 Jobs)',

		@Description = 'Value Assessment - Risk and SLAs - VM Backup Efficiency',

		@Details = 'Value Assessment - Risk and SLAs - VM Backup Efficiency',

@Flags = 4 | 256,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_101.sql',

		@ParserScriptName = 'RptLongRunningVSAFullJobs',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 102,

		@QueryName = 'Application Backup Efficiency (Top 25 Jobs)',

		@Description = 'Value Assessment - Risk and SLAs - Application Backup Efficiency',

		@Details = 'Value Assessment - Risk and SLAs - Application Backup Efficiency',

@Flags = 4 | 256 | 512,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_102.sql',

		@ParserScriptName = 'RptLongRunningFullJobs',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 103,

		@QueryName = 'Failed Jobs in last 24 hours',

		@Description = 'Collect Failed Jobs in last 24 hours. Reasons for a job not finishing -> failed, failed to start and killed',

		@Details = 'Collect Failed Jobs in last 24 hours. Reasons for a job not finishing -> failed, failed to start and killed',

		@Flags = CASE WHEN @param_isPrivate = 1

THEN 1 | 2 | 64

ELSE 2 | 64

			END,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_103.sql',

		@ParserScriptName = 'Rpt_unfinishedJobs',

		@ParserScript = 'Parse_unfinishedJobs',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 104,

		@QueryName = 'Exceptional Clients',

		@Description = 'Exceptional Clients Information',

		@Details = 'All Exceptional Clients and their category',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_104.sql',

		@ParserScriptName = 'Rpt_104ExceptionalClients',

		@ParserScript = 'Parse_104ExceptionalClients',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 105,

		@QueryName = 'Index Cache Space Utilization',

		@Description = 'Index Cache Space Utilization',

		@Details = 'Index Cache Space Utilization',

@Flags = 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_105.sql',

		@ParserScriptName = 'RptIndexCacheSpaceUsage',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 106,

		@QueryName = 'Client Version History',

		@Description = 'Display count of clients running the latest three versions',

		@Details = 'Display count of clients running the latest three versions',

		@Flags = CASE WHEN @param_isPrivate = 1

THEN 64

ELSE 0

			END,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_77.sql',

		@ParserScriptName = 'Rpt_106ClientVersion',

		@ParserScript = '',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 107,

		@QueryName = 'Remote Cache Statistics',

		@Description = 'Number of Remote Cache',

		@Details = 'Number of Remote Cache',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_107.sql',

		@ParserScriptName = 'RptRemoteCacheStat',

		@ParserScript = 'ParseRemoteCacheStat',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 108,

		@QueryName = 'Passphrase Encryption Statistics',

		@Description = 'Passphrase Encryption Enabled',

		@Details = 'Passphrase Encryption Statistics',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_108.sql',

		@ParserScriptName = 'RptPassphraseEncryptionEnabled',

		@ParserScript = 'ParsePassphraseEncryptionEnabled',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 109,

		@QueryName = 'Lucene Usage',

		@Description = 'Customers are using lucene',

		@Details = 'Customers are using lucene',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_109.sql',

		@ParserScriptName = 'RptLuceneUsage',

		@ParserScript = 'ParseLuceneUsage',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 110,

		@QueryName = 'Turbo Usage',

		@Description = 'Customers are using One pass feature',

		@Details = 'Customers are using One pass feature',

		@Flags = CASE WHEN @param_isPrivate = 1

THEN 0

ELSE 2

			END,

@Type = 1,

		@CollectScriptName = 'turboUsage.sql',

		@ParserScriptName = 'RptTurboUsage',

		@ParserScript = 'ParseTurboUsage',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 111,

		@QueryName = 'Disk Protection Tier Savings',

		@Description = 'Value Assessment - Infrastructure Savings - Disk Protection Tier Savings',

		@Details = 'Value Assessment - Infrastructure Savings - Disk Protection Tier Savings',

@Flags = 4 | 256 | 512,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_26.sql',

		@ParserScriptName = 'RptDeDupRatioBySPCopy',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 112,

		@QueryName = 'Email Data Placement (Top 25 Clients)',

		@Description = 'Value Assessment - Infrastructure Savings - Email Data Placement',

		@Details = 'Value Assessment - Infrastructure Savings - Email Data Placement',

@Flags = 4 | 256 | 512,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_23.sql',

		@ParserScriptName = 'RptEmailDataPlacement',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 113,

		@QueryName = 'Tape Media Management',

		@Description = 'Value Assessment - Operational Efficiency - Tape Media Management',

		@Details = 'Value Assessment - Operational Efficiency - Tape Media Management',

@Flags = 2 | 4 | 256 | 512,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_113.sql',

		@ParserScriptName = 'RptTapeMediaMgmt',

		@ParserScript = 'ParseTapeMediaMgmt',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 114,

		@QueryName = 'Self-Service',

		@Description = 'Value Assessment - Operational Efficiency - Self-Service',

		@Details = 'Value Assessment - Operational Efficiency - Self-Service',

@Flags = 2 | 4 | 256 | 512,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_114.sql',

		@ParserScriptName = 'RptSelfServiceInfo',

		@ParserScript = 'ParseSelfServiceInfo',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 115,

		@QueryName = 'SIDB Media Agent Patch Info',

		@Description = 'SIDB Media Agent Patch Info',

		@Details = 'SIDB Media Agent Patch Info',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_115.sql',

		@ParserScriptName = 'RptSIDBMAPatchInfo',

		@ParserScript = 'ParseSIDBMAPatchInfo',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 116,

		@QueryName = 'Installs before SP2B',

		@Description = 'Installs before SP2B',

		@Details = 'Installs before SP2B',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_116.sql',

		@ParserScriptName = 'RptInstallsBeforeSP2B',

		@ParserScript = 'ParseInstallsBeforeSP2B',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 117,

		@QueryName = 'Storage Resources Summary',

		@Description = 'Storage Resources Summary',

		@Details = 'Storage Resources Summary',

		@Flags = CASE WHEN @param_isPrivate = 1

THEN 1 | 2

ELSE 64 | 2

END | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_117.sql',

		@ParserScriptName = 'RptMediaManagementSummary',

		@ParserScript = 'ParseMediaManagementSummary',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 118,

		@QueryName = 'Upgraded VSA Agents',

		@Description = 'Upgraded VSA Agents',

		@Details = 'Upgraded VSA Agents',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_118.sql',

		@ParserScriptName = 'RptUpgradedVSA',

		@ParserScript = 'ParseUpgradedVSA',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 119,

		@QueryName = 'Least Deduped Subclients',

		@Description = 'Least Deduped Subclients',

		@Details = 'Least Deduped Subclients',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_119.sql',

		@ParserScriptName = 'RptLeastDedupedSubclients',

		@ParserScript = 'ParseLeastDedupedSubclients',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 120,

		@QueryName = 'Interval For Removal Of Invalid Chunk',

		@Description = 'Interval For Removal Of Invalid Chunk',

		@Details = 'Interval For Removal Of Invalid Chunk',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_120.sql',

		@ParserScriptName = 'RptIntervalForRemovalOfInvalidChunk',

		@ParserScript = 'ParseIntervalForRemovalOfInvalidChunk',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 1 ELSE 7 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 121,

		@QueryName = 'Sealed DDBs',

		@Description = 'Sealed DDBs',

		@Details = 'Sealed DDBs',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_61.sql',

		@ParserScriptName = 'RptSealedDDBs',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 122,

		@QueryName = 'Outlook Clients',

		@Description = 'Outlook Clients Information',

		@Details = 'All Outlook Clients and their category',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_122.sql',

		@ParserScriptName = 'Rpt_122OutlookClients',

		@ParserScript = 'Parse_122OutlookClients',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 123,

		@QueryName = 'Sharepoint clients backed up using SQLiDA',

		@Description = 'Sharepoint clients backed up using SQLiDA Information',

		@Details = 'All sharepoint clients backed up using SQLiDA',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_123.sql',

		@ParserScriptName = 'Rpt_123SharepointDBClients',

		@ParserScript = 'Parse_123SharepointDBClients',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 124,

		@QueryName = 'High-risk Settings',

		@Description = 'High-risk Settings - prune all database agent logs only by days retention rule',

		@Details = 'High-risk Settings - Prune all database agent logs only by days retention rule',

@Flags = 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_124.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseHighRiskSettings',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 125,

		@QueryName = 'Stores With Recover Job After SP9',

		@Description = 'List of stores where recover job ran after installing SP9',

		@Details = 'List of stores where recover job ran after installing SP9',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_125.sql',

		@ParserScriptName = 'RptStoresReconRanAfterSP9',

		@ParserScript = 'ParseStoresReconRanAfterSP9',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 126,

		@QueryName = 'DB2 Backup Set Information',

		@Description = 'DB2 Backup Set Information',

		@Details = 'DB2 Backup Set Information',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_126.sql',

		@ParserScriptName = 'Rpt126BackupSetInfo',

		@ParserScript = 'Parse126BackupSetInfo',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 127,

		@QueryName = 'CommServe lock down',

		@Description = 'CommServe lock down status',

		@Details = 'CommServe lock down status',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_127.sql',

		@ParserScriptName = 'RptCommServLockDown',

		@ParserScript = 'ParseCommServLockDown',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 128,

		@QueryName = 'Sync User Info',

		@Description = 'Provide all Sync User and Sync folder info',

		@Details = 'Provide all Sync User and Sync folder info',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_128.sql',

		@ParserScriptName = 'Rpt_128SyncInfo',

		@ParserScript = 'Parse_128SyncInfo',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 129,

		@QueryName = 'Capacity Usage History',

		@Description = 'Capacity Usage History for Last 12 Months',

		@Details = 'Capacity Usage History for Last 12 Months',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'Not Applicable',

		@ParserScriptName = 'RptCapacityLicenseSurvey',

		@ParserScript = 'ParseCapacityUsageHistory',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 130,

		@QueryName = 'Feature Status',

		@Description = 'Feature status',

		@Details = 'Feature status',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_130.sql',

		@ParserScriptName = 'RptFeatureStatus',

		@ParserScript = 'ParseFeatureStatus',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 131,

		@QueryName = 'QNet Global Filter',

		@Description = 'Customers with QNet Global Filter',

		@Details = 'Customers with QNet Global Filter',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_131.sql',

		@ParserScriptName = 'RptQNetGlobalFilter',

		@ParserScript = 'ParseQNetGlobalFilter',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 132,

		@QueryName = 'Library Status',

		@Description = 'Library Status',

		@Details = 'Library Status',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_132.sql',

		@ParserScriptName = 'RptLibraryStatus',

		@ParserScript = 'ParseLibraryStatus',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 133,

		@QueryName = 'Library Prunable Data',

		@Description = 'Library Prunable Data',

		@Details = 'Library Prunable Data',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_133.sql',

		@ParserScriptName = 'RptLibraryPrunableData',

		@ParserScript = 'ParseLibraryPrunableData',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 134,

		@QueryName = 'Mailbox Quota Usage',

		@Description = 'Mailbox Quota Usage Summary',

		@Details = 'Mailbox Quota Usage Summary',

		@Flags = CASE WHEN @param_isPrivate = 1

THEN 2 | 128

ELSE 0

			END,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_134.sql',

		@ParserScriptName = 'RptMailboxQuotaUsage',

		@ParserScript = 'ParseMailboxQuotaUsage',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 135,

		@QueryName = 'SRM Schedule Count',

		@Description = 'SRM Schedule Count',

		@Details = 'SRM Report schedules count',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_135.sql',

		@ParserScriptName = 'RptSRMCount',

		@ParserScript = 'ParseSRMCount',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 136,

		@QueryName = 'Monthly Storage Usage and Chargeback',

		@Description = 'Monthly Storage Usage and Chargeback',

		@Details = 'Monthly Storage Usage and Chargeback',

@Flags = 1 | 2 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_136.sql',

		@ParserScriptName = 'RptMonthlyStorageUsage',

		@ParserScript = 'ParseMonthlyStorageUsage',

		@DataRetentionDays = 400,

		@DataRetentionIntervalHrs = 0

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 137,

		@QueryName = 'Job Details',

		@Description = 'Data Protection Job Details',

		@Details = 'Data Protection Job Details',

		@Flags = CASE WHEN @param_isPrivate = 1

THEN 2

ELSE 0

			END,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_137.sql',

		@ParserScriptName = 'RptJobDetails',

		@ParserScript = 'ParseJobDetails',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 138,

		@QueryName = 'Largest clients by Data Written Size',

		@Description = 'Largest clients by Data Written Size Details',

		@Details = 'Largest clients by Data Written Size Details',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'Not Applicable',

		@ParserScriptName = 'Rpt_LargeStorageUtil',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 139,

		@QueryName = 'Client Coverage Change',

		@Description = 'Client Coverage Change Details',

		@Details = 'Client Coverage Change Details',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'Not Applicable',

		@ParserScriptName = 'Rpt_139ClientCoverage',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 140,

		@QueryName = 'Protected Objects',

		@Description = 'Protected Objects Count for Filesystem and Mailbox',

		@Details = 'Protected Objects Count for Filesystem and Mailbox',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_140.sql',

		@ParserScriptName = 'RptProtectedObjectsSurvey',

		@ParserScript = 'ParseProtectedObjectsSurvey',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 141,

		@QueryName = 'Data Retention',

		@Description = 'Backup data retention',

		@Details = 'Backup data retention',

@Flags = 2 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_141.sql',

		@ParserScriptName = 'RptBkpDataRetention',

		@ParserScript = 'ParseBkpDataRetention',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 142,

		@QueryName = 'Hourly backup job trend',

		@Description = 'Compare backup jobs completion rate on an hourly basis with previous week',

		@Details = 'Week Bkp Job Comparison',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_142.sql',

		@ParserScriptName = 'Rpt_142WeekBkpJobComparison',

		@ParserScript = 'Parse_142WeekBkpJobComparison',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 143,

		@QueryName = 'Oracle Full Dedupe Percentage',

		@Description = 'Oracle Full Dedupe Percentage',

		@Details = 'Oracle Full Dedupe Percentage',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_143.sql',

		@ParserScriptName = 'RptFullDedupePercentage',

		@ParserScript = 'ParseFullDedupePercentage',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 144,

		@QueryName = 'Database Index Fragmentation',

		@Description = 'Database Index Fragmentation Percentage',

		@Details = 'Database Index Fragmentation Percentage',

@Flags = 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_144.sql',

		@ParserScriptName = 'RptIndexFragmentationDetails',

		@ParserScript = 'ParseIndexFragmentation',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 145,

		@QueryName = 'Subclient Configuration',

		@Description = 'Subclient and Storage Policy Association',

		@Details = 'Subclient and Storage Policy Association',

@Flags = 2 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_145.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseSubclientConfig',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 146,

		@QueryName = 'Commcell Summary',

		@Description = 'Commcell Summary',

		@Details = 'Commcell Summary',

@Flags = 2 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_146.sql',

		@ParserScriptName = 'RptCommCellSummary',

		@ParserScript = 'ParseCommCellSummary',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 147,

		@QueryName = 'Number of MAC Laptop Clients',

		@Description = 'Number of MAC Laptop Clients',

		@Details = 'Number of MAC Laptop Clients',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_147.sql',

		@ParserScriptName = 'RptMACLaptopClients',

		@ParserScript = 'ParseMACLaptopClients',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 148,

		@QueryName = 'Number of vCloud Instances',

		@Description = 'Number of vCloud Instances',

		@Details = 'Number of vCloud Instances',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_148.sql',

		@ParserScriptName = 'RptvCloudInstances',

		@ParserScript = 'ParsevCloudInstances',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 149,

		@QueryName = 'NAS SRM Count',

		@Description = 'NAS SRM Count',

		@Details = 'NAS SRM Count',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_149.sql',

		@ParserScriptName = 'RptNasSrmCount',

		@ParserScript = 'ParseNasSrmCount',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 150,

		@QueryName = 'Billing Entities and Members',

		@Description = 'Billing Entities and Members',

		@Details = 'Billing Entities and Members',

		@Flags = CASE WHEN @param_isPrivate = 1

THEN 2

ELSE 0

			END,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_150.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseBillingEntities',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 151,

		@QueryName = 'Client Groups',

		@Description = 'Client Groups',

		@Details = 'Client Groups',

@Flags = 2 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_151.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseClientGroups',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 152,

		@QueryName = 'Restore Job Details',

		@Description = 'Restore Job Details',

		@Details = 'Restore Job Details',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_152.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseRestoreJobDetails',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 153,

		@QueryName = 'Basic Retention',

		@Description = 'Storage Policy Copy Basic Retention',

		@Details = 'Storage Policy Copy Basic Retention',

@Flags = 2 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_153.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseCopyBasicRetention',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 154,

		@QueryName = 'Subclient Contents',

		@Description = 'Subclient Contents',

		@Details = 'Subclient Contents',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_154.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseSubclientContents',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 155,

		@QueryName = 'Backup Schedules',

		@Description = 'Backup Schedules',

		@Details = 'Backup Schedules',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_155.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseBackupSchedules',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 156,

		@QueryName = 'Disk Pruning',

		@Description = 'Number of Pending Deletes',

		@Details = 'Number of Pending Deletes',

@Flags = 4 | 256 | 512,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_65.sql',

		@ParserScriptName = 'RptSurveyDDBPendingDelete',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 157,

		@QueryName = 'Storage Policy Copy Details',

		@Description = 'Uses Fallen Behind Dash Copies report',

		@Details = 'Uses Fallen Behind Dash Copies report',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_64.sql',

		@ParserScriptName = 'RptSurveyFallenBehindCopies',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 158,

		@QueryName = 'Top 10 Largest Tables by Size',

		@Description = 'Top 10 Largest Tables by Size',

		@Details = 'Top 10 Largest Tables by Size',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_158.sql',

		@ParserScriptName = 'RpttopTables',

		@ParserScript = 'ParsetopTables',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 159,

		@QueryName = 'CommCell Parameters Audit',

		@Description = 'Display differences of CommCell parameters from a user selected CommCell',

		@Details = 'Display differences of CommCell parameters from a user selected CommCell',

		@Flags = CASE WHEN @param_isPrivate = 1

THEN 1 | 2 | 256 | 512

ELSE 0

			END,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_159.sql',

		@ParserScriptName = 'RptCommCellParamAudit',

		@ParserScript = 'ParseCommCellParamAudit',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 160,

		@QueryName = 'WebConsole URL',

		@Description = 'WebConsole URL',

		@Details = 'WebConsole URL',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_160.sql',

		@ParserScriptName = 'Rpt160WebNJavaConsoleURLs',

		@ParserScript = 'Parse_160WebConsoleURL',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 161,

		@QueryName = 'Search Engines',

		@Description = 'Display Search Engine information for CommCell',

		@Details = 'Display Search Engine information for CommCell',

@Flags = 2 | 4 | 256 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_161.sql',

		@ParserScriptName = 'RptCloudNodeInfo',

		@ParserScript = 'ParseCloudNodeInfo',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 162,

		@QueryName = 'Weekly Storage Usage and Chargeback',

		@Description = 'Weekly Storage Usage and Chargeback',

		@Details = 'Weekly Storage Usage and Chargeback',

		@Flags = CASE WHEN @param_isPrivate = 1

THEN 1 | 2 | 256 | 512

ELSE 0

			END,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_162.sql',

		@ParserScriptName = 'RptMonthlyStorageUsage',

		@ParserScript = 'ParseWeeklyStorageUsage',

		@DataRetentionDays = 100,

		@DataRetentionIntervalHrs = 0

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 163,

		@QueryName = 'Jobs status in the last 24 hours',

		@Description = 'Display jobs status in the last 24 hours ',

		@Details = 'Display jobs status in the last 24 hours ',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_163.sql',

		@ParserScriptName = 'RptLast24HrJobStatsInfo',

		@ParserScript = 'ParseLast24HrJobStatsInfo',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 165,

		@QueryName = 'Scheduled Job Details',

		@Description = 'Scheduled job details',

		@Details = 'Scheduled job count in next 24 hours',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_165.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseScheduledJobDetails',

		@DataRetentionDays = 7,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 166,

		@QueryName = 'Virtual Machine with Agent Installed',

		@Description = 'Virtual Machine with Agent Installed',

		@Details = 'Virtual Machine with Agent Installed',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_166.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseVMWithAgentInstalled',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 171,

		@QueryName = 'Value Assessment',

		@Description = 'Value Assessment',

		@Details = 'Value Assessment',

@Flags = 256,

@Type = 1,

		@CollectScriptName = '',

		@ParserScriptName = 'RptValueAssessmentInfo',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 173,

		@QueryName = 'IDA Based Activity',

		@Description = 'IDA Based Activity',

		@Details = 'IDA Based Activity',

@Flags = 2 | 4,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_173.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseIDADailyBkpJobStatus',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 174,

		@QueryName = 'Dedupe Saving Trend',

		@Description = 'Dedupe Saving Trend',

		@Details = 'Dedupe Saving Trend',

		@Flags = CASE WHEN @param_isPrivate = 1

THEN 2 | 4

ELSE 0

			END,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_174.sql',

		@ParserScriptName = 'RptDedupeSavingTrend',

		@ParserScript = 'ParseDedupeSavingTrend',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 175,

		@QueryName = 'Hardware Encryption for Tape Copies',

		@Description = 'Hardware Encryption for Tape Copies',

		@Details = 'Hardware Encryption for Tape Copies',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_175.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseHardwareEncryption',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 176,

		@QueryName = 'Monthly Restore Job Stats',

		@Description = 'Monthly Restore Job Stats',

		@Details = 'Monthly Restore Job Stats',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_176.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseDailyRstJobStats',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 177,

		@QueryName = 'Daily Consumer Backup Job Statistics',

		@Description = 'Daily Consumer Backup Job Statistics',

		@Details = 'Daily Consumer Backup Job Statistics',

@Flags = CASE WHEN @param_isPrivate = 1 THEN 2 ELSE 0 END,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_177.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseConsumerDailyBkpJobStats',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 178,

		@QueryName = 'Daily Data Retention Statistics',

		@Description = 'Daily Data Retention Statistics',

		@Details = 'Daily Data Retention Statistics',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_178.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseDailyDataRetentionStats',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 179,

		@QueryName = 'Tape Media History',

		@Description = 'Tape Media History',

		@Details = 'Tape Media History',

		@Flags = CASE WHEN @param_isPrivate = 1

THEN 2

ELSE 0

			END,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_179.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseTapeMediaHistory',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 180,

		@QueryName = 'Client Audit',

		@Description = 'Display differences of client/subclient properties from a user selected client',

		@Details = 'Display differences of client/subclient properties from a user selected client',

		@Flags = CASE WHEN @param_isPrivate = 1

THEN 1 | 2 | 256 | 512

ELSE 0

			END,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_180.sql',

		@ParserScriptName = 'RptClientAudit',

		@ParserScript = 'ParseClientAudit',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 181,

		@QueryName = 'Replication',

		@Description = 'Replicated VM Information',

		@Details = 'Replicated VM details with its status',

@Flags = 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_181.sql',

		@ParserScriptName = 'RptLiveSyncVMDetails',

		@ParserScript = 'ParseLiveSyncVMDetails',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 185,

		@QueryName = 'Client Group Quota Usage',

		@Description = 'Client Group Quota Usage',

		@Details = 'Client Group Quota Usage',

@Flags = (2 | 128) | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_185.sql',

		@ParserScriptName = 'RptClientGroupQuotaUsage',

		@ParserScript = 'ParseClientGroupQuotaUsage',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 186,

		@QueryName = 'Tape Library Growth',

		@Description = 'Tape Media Usage',

		@Details = 'Tape Media Usage',

@Flags = 1 | 2 | 4 | 256 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_186.sql',

		@ParserScriptName = 'RptTapeLibraryUsage',

		@ParserScript = 'ParseTapeMediaUsage',

		@DataRetentionDays = 90,

		@DataRetentionIntervalHrs = 0

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 196,

		@QueryName = 'Cloud Library Growth',

		@Description = 'Cloud Library Information',

		@Details = 'All cloud libraries and their free space, used space information',

@Flags = 1 | 4 | 256,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_96.sql',

		@ParserScriptName = 'RptCloudLibraryUsage',

		@ParserScript = '',

		@DataRetentionDays = 365,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 197,

		@QueryName = 'Threshold Information',

		@Description = 'Collect diffent Threshold specified at Commcell/client/entities level',

		@Details = 'Collect diffent Threshold specified at Commcell/client/entities level',

@Flags = 2 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_197.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseCommcellThresholdInfo',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 199,

		@QueryName = 'Library Throughput',

		@Description = 'Library Throughput',

		@Details = 'Library Throughput',

@Flags = 2 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_199.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseLibraryThroughput',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 200,

		@QueryName = 'Index Backup',

		@Description = 'Display information about Index Backup Status ',

		@Details = 'Display information about Index Backup Status',

@Flags = 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_200.sql',

		@ParserScriptName = 'RptIndexBackupStatus',

		@ParserScript = 'ParseIndexBackupStatus',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 201,

		@QueryName = 'Index State',

		@Description = 'Display information about Index State Status ',

		@Details = 'Display information about Index State Status',

@Flags = 2 | 4 | 256 | 512,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_200.sql',

		@ParserScriptName = 'RptIndexStateStatus',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 202,

		@QueryName = 'APSS Solution Workflow',

		@Description = 'This query will detect and track when WF solutions are executed on a CommServe',

		@Details = 'This query will detect and track when WF solutions are executed on a CommServe',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_202.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseApssSolutionWorkflow',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 203,

		@QueryName = 'APSS Health Workflow',

		@Description = 'This query will detect and track when Health Workflows are executed on a CommServe',

		@Details = 'This query will detect and track when Health Workflows are executed on a CommServe',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_203.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseApssHealthWorkflow',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 204,

		@QueryName = 'Top 25 Growing Clients',

		@Description = 'Top 25 clients for growing application size',

		@Details = 'Top 25 clients for growing application size',

@Flags = 2 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_204.sql',

		@ParserScriptName = 'RptGrowingClients',

		@ParserScript = 'ParseGrowingClients',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 205,

		@QueryName = 'APSS Setup',

		@Description = 'This query will configure proactive support setting on the CommServe',

		@Details = 'This query will configure proactive support setting on the CommServe',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_205.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseApssSetup',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 206,

		@QueryName = 'DDB Disk Space Utilization',

		@Description = 'DDB Disk Space Utilization',

		@Details = 'DDB Disk Space Utilization',

@Flags = 4 | 256 | 512,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_205.sql',

		@ParserScriptName = 'RptDDBDiskSpaceUsage',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 207,

		@QueryName = 'Subclients Not Having Full Backup in 60 Days',

		@Description = 'Subclients Not Having Full Backup in 60 Days',

		@Details = 'Subclients Not Having Full Backup in 60 Days',

@Flags = 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_207.sql',

		@ParserScriptName = 'RptSubclientsNoRecentFull',

		@ParserScript = 'ParseSubclientsNoRecentFull',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 208,

		@QueryName = 'Admin Job Details',

		@Description = 'Admin Job Details',

		@Details = 'Admin Job Details',

@Flags = CASE WHEN @param_isPrivate = 1 THEN 2 ELSE 0 END,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_208.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseAdminJobDetails',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 209,

		@QueryName = 'Fallen Behind Backup Copy Jobs',

		@Description = 'Fallen Behind Backup Copy Jobs',

		@Details = 'Fallen Behind Backup Copy Jobs',

@Flags = 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_209.sql',

		@ParserScriptName = 'RptFallenBehindBackupCopies',

		@ParserScript = 'ParseFallenBehindBackupCopies',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 210,

		@QueryName = 'Mount Path Throughput',

		@Description = 'Mount Path Throughput',

		@Details = 'Mount Path Throughput',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_210.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseMountPathThroughput',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 211,

		@QueryName = 'RTO',

		@Description = 'RTO',

		@Details = 'RTO',

@Flags = 2 | 4 | 256 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_211.sql',

		@ParserScriptName = 'RptRecoverabilitySLA',

		@ParserScript = 'ParseRecoverabilitySLA',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 212,

		@QueryName = 'Copy Redundancy',

		@Description = 'Copy Redundancy',

		@Details = 'Copy Redundancy SLA',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_211.sql',

		@ParserScriptName = 'RptCopyRedundancySLA',

		@ParserScript = '',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

	SELECT @QueryId = 213,

		@QueryName = 'Subclients without full backup in active DDB',

		@Description = 'Subclients without full backup in active DDB',

		@Details = 'Last Full Backup In DDB',

@Flags = 0,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_213.sql',

		@ParserScriptName = 'RptLastFullInDDB',

		@ParserScript = 'ParseLastFullInDDB',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 214,

		@QueryName = 'Cleanup',

		@Description = 'Cleanup Report Security and Alerts',

		@Details = 'Commcell Cleanup',

@Flags = 2 | 4| 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_214.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseCleanupSecurity',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 215,

		@QueryName = 'MAAndStorageCleanup',

		@Description = 'Cleanup Report MA and Storage',

		@Details = 'Commcell Cleanup',

@Flags = 2 | 4 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_215.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseCleanupMAAndStorage',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 216,

		@QueryName = 'Peak usage details of Commserv',

		@Description = 'Peak usage details of Commserv',

		@Details = 'Peak usage details of Commserv',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_216.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseLicPeakUsageDetails',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 217,

		@QueryName = 'ClientCleanup',

		@Description = 'Cleanup Report Client',

		@Details = 'Commcell Cleanup',

@Flags = 2 | 4 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_217.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseCleanupClient',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 218,

		@QueryName = 'Tape Media Information',

		@Description = 'Tape Media Information',

		@Details = 'Tape Media Information',

@Flags = CASE WHEN @param_isPrivate = 0 THEN 0 ELSE 8 | 2 END,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_218.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseTapeMediaInfo',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 219,

		@QueryName = 'Third Party Software Versions',

		@Description = 'Third Party Software Versions',

		@Details = 'Third Party Software Versions',

@Flags = 2 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_219.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseThirdPartySoftwareVersions',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 220,

		@QueryName = 'Jobs on Tape Media',

		@Description = 'Jobs on Tape Media',

		@Details = 'Jobs on Tape Media',

@Flags = CASE WHEN @param_isPrivate = 0 THEN 0 ELSE 8 | 2 END,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_220.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseJobsOnTapeMedia',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 221,

		@QueryName = 'Valid Job Details',

		@Description = 'Valid Job Details',

		@Details = 'Valid Job Details',

@Flags = CASE WHEN @param_isPrivate = 0 THEN 0 ELSE 8 | 2 END,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_221.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseValidJobDetails',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 222,

        @QueryName = 'FeatureTracking',

        @Description = 'FeatureTracking',

        @Details = 'FeatureTracking',

@Flags = 2 | 4 ,

@Type = 1,

        @CollectScriptName = 'CommservSurveyQuery_222.sql',

        @ParserScriptName = '',

        @ParserScript = 'ParseFeatureTracking',

        @DataRetentionDays = 1,

        @DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 223,

		@QueryName = 'Commserv DB Restores',

		@Description = 'Commserv DB Restores',

		@Details = 'CS DB Restore History',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_223.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseCommServDBRestores',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 224,

		@QueryName = 'Alerts Configuration',

		@Description = 'Alerts Configuration',

		@Details = 'Alerts Configuration',

@Flags = CASE WHEN @param_isPrivate = 0 THEN 0 ELSE 2 END,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_224.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseAlertsConfiguration',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 225,

		@QueryName = 'Subclients and VMs',

		@Description = 'Subclients and VMs',

		@Details = 'Subclients and VMs',

@Flags = 2 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_225.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseSubclients',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

DELETE FROM cf_CommservSurveyQueries WHERE QueryId in (227, 228, 229, 230, 231)

SELECT @QueryId = 232,

		@QueryName = 'License Info',

		@Description = 'Collects details of licenses purchased and used from HistoryDB',

		@Details = 'Collects details of licenses purchased and used from HistoryDB',

@Flags = 2,

@Type = 2,

		@CollectScriptName = 'CommservSurveyQuery_232.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseLicLicenseInfo',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 233,

		@QueryName = 'Current License Summary',

		@Description = 'Collects summary of current license usages from HistoryDB',

		@Details = 'Collects summary of current license usages from HistoryDB',

@Flags = 2,

@Type = 2,

		@CollectScriptName = 'CommservSurveyQuery_233.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseLicCurrentSummary',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 234,

		@QueryName = 'CCL License Peak Summary',

		@Description = 'Collects summary of commcell level peak license usages from HistoryDB',

		@Details = 'Collects summary of commcell level peak license usages from HistoryDB',

@Flags = 2,

@Type = 2,

		@CollectScriptName = 'CommservSurveyQuery_234.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseLicCCLPeakSummary',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 235,

		@QueryName = 'SCL License Peak Summary',

		@Description = 'Collects summary of subclient level peak license usages from HistoryDB',

		@Details = 'Collects summary of subclient level peak license usages from HistoryDB',

@Flags = 2,

@Type = 2,

		@CollectScriptName = 'CommservSurveyQuery_235.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseLicSCLPeakSummary',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 236,

		@QueryName = 'Current License Usages',

		@Description = 'Collects details of current license usages from HistoryDB',

		@Details = 'Collects details of current license usages from HistoryDB',

@Flags = 2,

@Type = 2,

		@CollectScriptName = 'CommservSurveyQuery_236.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseLicCurrentUsage',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 237,

		@QueryName = 'CCL License Peak Usages',

		@Description = 'Collects details of commcell level peak license usages from HistoryDB',

		@Details = 'Collects details of commcell level peak license usages from HistoryDB',

@Flags = 2,

@Type = 2,

		@CollectScriptName = 'CommservSurveyQuery_237.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseLicCCLPeakUsage',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 238,

		@QueryName = 'SCL License Peak Usages',

		@Description = 'Collects details of subclient level peak license usages from HistoryDB',

		@Details = 'Collects details of subclient level peak license usages from HistoryDB',

@Flags = 2,

@Type = 2,

		@CollectScriptName = 'CommservSurveyQuery_238.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseLicSCLPeakUsage',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 239,

		@QueryName = 'Version and Service Pack',

		@Description = 'Collect Version and Service Pack of clients on commcells',

		@Details = 'Collect Version and Service Pack of clients on commcells',

@Flags = 2 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_239.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseVersionAndServicePack',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 240,

		@QueryName = 'Clients and VMs',

		@Description = 'To get vM, Laptop and Regular client information',

		@Details = 'To get VM, Laptop and Regular client information',

@Flags = 2 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_240.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseClients',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 241,

		@QueryName = 'Client Group Association',

		@Description = 'Client Group Association',

		@Details = 'Client Group Association',

@Flags = 2 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_241.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseClientGroupAssociation',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 242,

		@QueryName = 'SLA Details',

		@Description = 'Clients that are not protected in SLA period',

		@Details = 'Health Check - Clients that are not protected in SLA period',

@Flags = 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_242.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseSLADetails',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 243,

		@QueryName = 'Backup jobs top 5 offenders per category',

		@Description = 'Collects the top 5 clients with killed jobs, Failed jobs and NoRun jobs',

		@Details = 'Collects the top 5 clients with killed jobs, Failed jobs and NoRun jobs',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_243.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseBackupOffenders',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 244,

		@QueryName = 'Client Registry Info',

		@Description = 'Collects Additional Client Registry Info',

		@Details = 'Collects Additional Client Registry Info',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_244.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseClientRegistryInfo',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 245,

		@QueryName = 'Subclient Contents',

		@Description = 'Subclient Contents',

		@Details = 'Subclient Contents',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_245.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseSubclientContentsCSV',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 246,

		@QueryName = 'Restore Jobs',

		@Description = 'Restore Jobs Details',

		@Details = 'Restore Jobs Details',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_246.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseCSVRestoreJobDetails',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 247,

		@QueryName = 'Jobs Anomaly Data',

		@Description = 'Jobs Anomaly Data',

		@Details = 'Jobs Anomaly Data',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_247.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseJobAnomalyData',

		@DataRetentionDays = 7,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 248,

		@QueryName = 'File Anomaly Data',

		@Description = 'File Anomaly Data',

		@Details = 'File Anomaly Data',

@Flags = 2,

@Type = 2,

		@CollectScriptName = 'CommservSurveyQuery_248.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseFileAnomalyData',

		@DataRetentionDays = 7,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 249,

		@QueryName = 'DDB Anomaly Data',

		@Description = 'DDB Anomaly Data',

		@Details = 'DDB Anomaly Data',

@Flags = 2,

@Type = 2,

		@CollectScriptName = 'CommservSurveyQuery_249.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseDDBAnomalyData',

		@DataRetentionDays = 7,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 250,

		@QueryName = 'Security Assessment',

		@Description = 'Security Assessment collects the results of the comprehensive security assessment offering by product.',

		@Details = 'Security Assessment',

@Flags = 2 | 4 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_250.sql',

		@ParserScriptName = 'RptSecurityAssociationDetails',

		@ParserScript = 'ParseSecurityStatus',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 251,

		@QueryName = 'Tenants',

		@Description = 'Collect various tenants in a commcell',

		@Details = 'Collect various tenants in a commcell',

@Flags = 2,

@Type = 2,

		@CollectScriptName = 'CommservSurveyQuery_251.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseTenants',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 252,

		@QueryName = 'End Users',

		@Description = 'Collect various end users in a commcell',

		@Details = 'Collect various end users in a commcell',

@Flags = 2,

@Type = 2,

		@CollectScriptName = 'CommservSurveyQuery_252.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseEndusers',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 253,

		@QueryName = 'SLA Exclusion',

		@Description = 'Clients and subclients that are excluded from SLA',

		@Details = 'Health Check - Clients that are excluded from SLA',

@Flags = 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_253.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseSLAExclusion',

		@DataRetentionDays = CASE WHEN @param_isPrivate = 1 THEN 365 ELSE 1 END,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 254,

		@QueryName = 'License Application Details',

		@Description = 'License File Application Details',

		@Details = 'License File Application Details',

@Flags = CASE WHEN @param_isPrivate = 1 THEN 0 ELSE 2 END,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_254.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseLicApplDetails',

		@DataRetentionDays = 7,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 255,

        @QueryName = 'HedvigNodes',

        @Description = 'HedvigNodes',

        @Details = 'HedvigNodes',

@Flags = 2,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_255.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseHedvigNodes',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 257,

		@QueryName = 'ConfigurationAudit',

		@Description = 'Collect settings that differ from Commvault default settings',

		@Details = 'Collect settings that differ from Commvault default settings',

@Flags = 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_257.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseSurveyConfigurationAudit',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 259,

		@QueryName = 'CollectBackupCopies',

		@Description = 'Collect Backup Copy Jobs Information',

		@Details = 'Collect Backup Copy Jobs Information',

@Flags = 2 | 4 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_259.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseSurveyBackupCopyJobStats',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 260,

		@QueryName = 'Data Aging Troubleshooting',

		@Description = 'Collect Data Aging Troubleshooting Information',

		@Details = 'Collect Data Aging Troubleshooting Information',

@Flags = 1 | 2 | 256 | 512 | 1024,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_260.sql',

		@ParserScriptName = 'RptDATroubleshootingInfo',

		@ParserScript = 'ParseDATroubleshootingInfo',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

SELECT @QueryId = 261,

		@QueryName = 'CollectVMErrorFlags',

		@Description = 'Collect VM Error Flags and Jobs Information',

		@Details = 'Collect VM Error flags and Jobs Information',

@Flags = 2 | 4 | 256 | 512 ,

@Type = 1,

		@CollectScriptName = 'CommservSurveyQuery_261.sql',

		@ParserScriptName = '',

		@ParserScript = 'ParseVMErrorFlag',

		@DataRetentionDays = 1,

		@DataRetentionIntervalHrs = 24

IF NOT EXISTS (SELECT * FROM cf_CommservSurveyQueries WHERE QueryId = @QueryId)	
		INSERT INTO cf_CommservSurveyQueries (QueryId, Name, Description, Details, Flags, Type, CollectScriptName, ParserScriptName, ParserScript, DataRetentionDays, DataRetentionIntervalHrs, SubmittedBy, AssignedTo, LastUpdatedBy)	
		VALUES(@QueryId, @QueryName, @Description, @Details, @Flags, @Type, @CollectScriptName, @ParserScriptName, @ParserScript, @DataRetentionDays, @DataRetentionIntervalHrs, '', '', '')	
	ELSE	
		UPDATE cf_CommservSurveyQueries	
		SET Name = @QueryName,	
			Description = @Description,	
			Details = @Details,	
			Flags = @Flags,	
			Type = @Type,	
			CollectScriptName = @CollectScriptName,	
			ParserScriptName = @ParserScriptName,	
			ParserScript = @ParserScript,	
			DataRetentionDays = @DataRetentionDays,	
			DataRetentionIntervalHrs = @DataRetentionIntervalHrs,	
			LastUpdatedTime = GETUTCDATE()	
		WHERE QueryId = @QueryId	
	SELECT @QueryId = NULL, @QueryName = NULL, @Description = NULL, @Details = NULL, @Flags = NULL, @Type = NULL, @CollectScriptName = NULL, @ParserScriptName = NULL, @ParserScript = NULL, @DataRetentionDays = NULL, @DataRetentionIntervalHrs = NULL

END TRY

BEGIN CATCH

	DECLARE @ErrorMessage nvarchar(max) = ISNULL(ERROR_MESSAGE(), '')

	RAISERROR('Error while inserting/updating query [%d].

	Error Message: [%s]', 16, 1, @QueryId, @ErrorMessage)

END CATCH

SET NOCOUNT OFF;

