

--  ------------  Generated from [../../../Source/CommServer/CloudDB/TblScript/cf_SurveyDiskLibraryWeeklyPeakSize.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2007  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/TblScript/cf_SurveyDiskLibraryWeeklyPeakSize.script,v $ $Id: cf_SurveyDiskLibraryWeeklyPeakSize.script,v 1.1.2.2 2018/02/16 19:47:50 junlu Exp $";
-- TABLENAME cf_SurveyDiskLibraryWeeklyPeakSize

print '... inserting Table: cf_SurveyDiskLibraryWeeklyPeakSize'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME cf_SurveyDiskLibraryWeeklyPeakSize

IF NOT EXISTS (SELECT * FROM cf_SurveyDiskLibraryWeeklyPeakSize)

BEGIN

	DECLARE @FromWeek DATETIME = DATEADD(WEEK, DATEDIFF(DAY, 0, GETDATE())/7, 0)

	DECLARE @NextWeek DATETIME = DATEADD(WEEK, 1, @FromWeek)

	DECLARE @FromDate DATETIME = DATEADD(WEEK, -4, @FromWeek)

	SET	@FromDate = (SELECT MIN(LogDate) FROM cf_Survey96DiskLibDetails WHERE LogDate >= @FromDate)

	WHILE @FromWeek >= @FromDate

	BEGIN
		INSERT  INTO cf_SurveyDiskLibraryWeeklyPeakSize (


				CommServUniqueId, WeekStart, LibraryId, UsedSpaceMB, FreeSpaceMB, AppSizeMB, DataWrittenMB)

		SELECT  CommServUniqueId, @FromWeek, LibraryId, MAX(totalSpaceGB - totalFreeSpaceGB)*1024, MIN(totalFreeSpaceGB)*1024, 

				MAX(ISNULL(totalAppSizeGB,0))*1024, MAX(ISNULL(totalDataWrittenGB,0))*1024

		FROM    cf_Survey96DiskLibDetails

		WHERE   LogDate >= @FromWeek AND LogDate < @NextWeek

		    AND ISNULL(totalSpaceGB, -1) > 0 AND ISNULL(totalFreeSpaceGB, -1) > 0 AND (totalSpaceGB - totalFreeSpaceGB) >= 0

		GROUP BY CommServUniqueId, LibraryId

		SET	@NextWeek = @FromWeek

		SET	@FromWeek = DATEADD(WEEK, -1, @NextWeek)

	END

END
