

--  ------------  Generated from [../../../Source/CommServer/CloudDB/TblScript/cf_SurveyRestoreJobStats.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2007  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/TblScript/cf_SurveyRestoreJobStats.script,v $ $Id: cf_SurveyRestoreJobStats.script,v 1.1.2.2 2019/11/11 21:29:13 nbirru Exp $";
-- TABLENAME cf_SurveyRestoreJobStats

print '... inserting Table: cf_SurveyRestoreJobStats'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME cf_SurveyRestoreJobStats

DECLARE @updateUTCToLocalTimeZoneGUID    VARCHAR(40) = '1e4549b9-c632-4321-adc7-5cdfd3ac5c0a'

IF NOT EXISTS (SELECT 1 FROM cf_SurveyConfig WITH (NOLOCK) WHERE Value = @updateUTCToLocalTimeZoneGUID AND Name = 'UTCToLocalTimeZoneConversionForRestoreJobStats')

BEGIN

	IF object_id('tempdb.dbo.#CommCellTimeZone') is not null DROP TABLE #CommCellTimeZone

	CREATE TABLE #CommCellTimeZone(

		CommservUniqueId INT,

		LocalTimeZone NVARCHAR(MAX),

		TimeDiff BIGINT

	)
	INSERT INTO #CommCellTimeZone


	SELECT ID, CommServTZ, DATEDIFF(S, GETUTCDATE(), dbo.UTCToLocalDateTimeConversion(GETUTCDATE(), C.CommServTZ))

	FROM cf_CommcellIdNameMap C WITH (NOLOCK)

	UPDATE R

	SET StartTime = StartTime + TimeDiff,

		EndTime = EndTime + TimeDiff

	FROM cf_SurveyRestoreJobStats R

	INNER JOIN #CommCellTimeZone C ON C.CommservUniqueId = R.CommservUniqueId

	IF object_id('tempdb.dbo.#CommCellTimeZone') is not null DROP TABLE #CommCellTimeZone

	IF object_id('tempdb.dbo.#EndTime') is not null DROP TABLE #EndTime

	CREATE TABLE #EndTime(

		CommservUniqueId INT,

		AppTypeId INT,

		EndTime DATETIME

	)
	INSERT INTO #EndTime 


		select S.CommservUniqueId, S.AppTypeId, DATEADD(Day, -1, dbo.getdatetime(MIN(Endtime))) AS EndTime from cf_SurveyRestoreJobStats S

		group by S.CommservUniqueId, S.AppTypeId 

	DELETE D FROM cf_SurveyIDADailyRSTJobStats D 

	INNER JOIN #EndTime X ON X.CommservUniqueId = D.CommservUniqueId AND X.AppTypeId = D.AppTypeId AND D.JobEndDate > X.EndTime

	DELETE D FROM cf_SurveyIDAMonthlyRSTJobStats D 

	INNER JOIN #EndTime X ON X.CommservUniqueId = D.CommservUniqueId AND X.AppTypeId = D.AppTypeId AND D.MonthStart > X.EndTime

	IF object_id('tempdb.dbo.#EndTime') is not null DROP TABLE #EndTime
	INSERT INTO cf_SurveyIDADailyRSTJobStats(CommServUniqueId, JobEndDate, AppTypeId, TotalJobs, CompletedJobs, CWEJobs, CWWJobs, FailedJobs, KilledJobs, SkippedJobs, TotUnCompMB, TotCompMB, CommittedJobs,TotFiles2xfer,TotSuccess,SkippedObjects,FailedObjects)


	SELECT  B.CommservUniqueId ,

				CAST(DBO.GETDATETIME(B.EndTime) AS DATE),

				B.AppTypeId as AppTypeId,

				SUM(CASE WHEN (B.jobstatus) IN (1,2,3,4,9,14,16) THEN 1 ELSE 0 END) as TotalJobs,

				SUM(CASE WHEN B.jobstatus = 1  THEN 1 ELSE 0 END) AS CompletedJobs,

				SUM(CASE WHEN B.jobstatus = 3  THEN 1 ELSE 0 END) as CWEJobs,

				SUM(CASE WHEN B.jobstatus = 14 THEN 1 ELSE 0 END) as CWWJobs,

				SUM(CASE WHEN B.jobstatus = 2  OR (B.jobstatus = 9 AND B.errorcode = '8') THEN 1 ELSE 0 END) as FailedJobs,

				SUM(CASE WHEN B.jobstatus = 4 THEN 1 ELSE 0 END) as KilledJobs,

				SUM(CASE WHEN (B.jobstatus = 9 AND B.errorcode <> '8') THEN 1 ELSE 0 END) as SkippedJobs,

				SUM(CASE WHEN B.jobstatus IN (1,3,14) THEN TotUnCompMB ELSE 0 END) AS TotUnCompMB,

				SUM(TotCompMB) AS TotCompMB,

				SUM(CASE WHEN B.jobstatus = 16 THEN 1 ELSE 0 END) as CommittedJobs,

				SUM(TotFiles2xfer) AS TotFiles2xfer,

				SUM(TotSuccess) AS TotSuccess,

				SUM(SkippedObjects) AS SkippedObjects,

				SUM(FailedObjects) AS FailedObjects

			FROM	 	

				 cf_SurveyRestoreJobStats B WITH (NOLOCK) 

				LEFT OUTER JOIN (SELECT CommServUniqueId,AppTypeId, MAX(JobEndDate) as JobEndDate FROM  cf_SurveyIDADailyRSTJobStats (NOLOCK) GROUP BY CommservUniqueId,AppTypeId ) AS ExData

				ON ExData.CommServUniqueId = B.CommServUniqueId

				AND B.AppTypeID = ExData.AppTypeID

				WHERE ExData.CommServUniqueId IS NULL

				 or ExData.JobEndDate <CAST(DBO.GETDATETIME(B.EndTime) AS DATE) 

				GROUP BY CAST(DBO.GETDATETIME(B.EndTime) AS DATE),B.CommservUniqueId,B.AppTypeId
	INSERT INTO cf_SurveyIDAMonthlyRSTJobStats(CommServUniqueId, MonthStart, AppTypeId, TotalJobs, CompletedJobs, CWEJobs, CWWJobs, FailedJobs, KilledJobs, SkippedJobs, TotUnCompMB, TotCompMB, CommittedJobs,TotFiles2xfer,TotSuccess,SkippedObjects,FailedObjects)


	SELECT  B.CommservUniqueId ,

				CAST (DATEADD(MONTH, DATEDIFF(MONTH, 0, DBO.GETDATETIME(B.EndTime)), 0) AS DATE),

				B.AppTypeId as AppTypeId,

				SUM(CASE WHEN (B.jobstatus) IN (1,2,3,4,9,14,16) THEN 1 ELSE 0 END) as TotalJobs,

				SUM(CASE WHEN B.jobstatus = 1  THEN 1 ELSE 0 END) AS CompletedJobs,

				SUM(CASE WHEN B.jobstatus = 3  THEN 1 ELSE 0 END) as CWEJobs,

				SUM(CASE WHEN B.jobstatus = 14 THEN 1 ELSE 0 END) as CWWJobs,

				SUM(CASE WHEN B.jobstatus = 2  OR (B.jobstatus = 9 AND B.errorcode = '8') THEN 1 ELSE 0 END) as FailedJobs,

				SUM(CASE WHEN B.jobstatus = 4 THEN 1 ELSE 0 END) as KilledJobs,

				SUM(CASE WHEN (B.jobstatus = 9 AND B.errorcode <> '8') THEN 1 ELSE 0 END) as SkippedJobs,

				SUM(CASE WHEN B.jobstatus IN (1,3,14) THEN TotUnCompMB ELSE 0 END) AS TotUnCompMB,

				SUM(TotCompMB) AS TotCompMB,

				SUM(CASE WHEN B.jobstatus = 16 THEN 1 ELSE 0 END) as CommittedJobs,

				SUM(TotFiles2xfer) AS TotFiles2xfer,

				SUM(TotSuccess) AS TotSuccess,

				SUM(SkippedObjects) AS SkippedObjects,

				SUM(FailedObjects) AS FailedObjects

			FROM	 	

				 cf_SurveyRestoreJobStats B WITH (NOLOCK) 

				LEFT OUTER JOIN (SELECT CommServUniqueId,AppTypeId, cast (MAX(MonthStart) as date) as MonthStart FROM  cf_SurveyIDAMonthlyRSTJobStats (NOLOCK) GROUP BY CommservUniqueId,AppTypeId ) AS ExData

				ON ExData.CommServUniqueId = B.CommServUniqueId

				AND B.AppTypeID = ExData.AppTypeID

				WHERE ExData.CommServUniqueId IS NULL

				 or ExData.MonthStart <CAST (DATEADD(MONTH, DATEDIFF(MONTH, 0, DBO.GETDATETIME(B.EndTime)), 0) AS DATE)				

				GROUP BY CAST (DATEADD(MONTH, DATEDIFF(MONTH, 0, DBO.GETDATETIME(B.EndTime)), 0) AS DATE),B.CommservUniqueId,B.AppTypeId
	INSERT INTO cf_SurveyConfig (Name, Value) values ('UTCToLocalTimeZoneConversionForRestoreJobStats', @updateUTCToLocalTimeZoneGUID)


END
