

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Upgrade/ADD_cv_makeTableColumnsNonNullable.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
IF EXISTS (select * from sysobjects where name='cvsp_makeTableColumnsNonNullable')

	drop procedure cvsp_makeTableColumnsNonNullable

IF EXISTS (select * from GXDBVersions where name='cvsp_makeTableColumnsNonNullable')

	delete from GXDBVersions where name = 'cvsp_makeTableColumnsNonNullable'

	GO

create procedure cvsp_makeTableColumnsNonNullable

  @l_TableName varchar(40)

AS

	DECLARE cur CURSOR STATIC FOR

	SELECT	syscolumns.name,

			systypes.name,

			syscolumns.length

	    FROM sysobjects 

	    INNER JOIN syscolumns ON sysobjects.id = syscolumns.id

		INNER JOIN systypes ON syscolumns.xtype=systypes.xtype

	   WHERE	sysobjects.xtype='U' and 

				systypes.name <> 'sysname' and

				syscolumns.isnullable = 1 and

				sysobjects.name = @l_TableName

	declare @colname varchar(512), @coltype varchar(50), @collength int , @retVal int

	OPEN cur

	SELECT	@retVal = @@ERROR

	IF		@retVal != 0

	BEGIN

			print 'Failed to declare cursor to get table columns'

			GOTO CX_ERROR_EXIT

	END

	FETCH	NEXT FROM cur

	INTO @colname, @coltype, @collength

	SELECT	@retVal = @@ERROR

	IF		@retVal != 0

	BEGIN

			print 'Failed to fetch next column name and type'

			GOTO CX_ERROR_EXIT

	END

	WHILE	@@FETCH_STATUS = 0

	BEGIN

		DECLARE @l_update VARCHAR(MAX)

		DECLARE @l_colchange VARCHAR(MAX)

		set @l_colchange  =

		' ALTER TABLE ' + @l_TableName  + ' ALTER COLUMN ' + @colname +

		' ' + @colType

		IF @colType IN ('int', 'smallint', 'tinyint', 'float', 'bigint')

		BEGIN

			SET @l_update =  'update ' + @l_TableName + 

					' set ' +  @colname + ' = 0 ' +

					' where ' + @colname + ' is null'

		END ELSE 

		IF @colType IN ('xml', 'varchar', 'text', 'ntext', 'nvarchar')

		BEGIN

				SET @l_update =  'update ' + @l_TableName + 

					' set ' +  @colname + ' = '''' ' +

					' where ' + @colname + ' is null'

				IF @colType IN ('varchar', 'nvarchar')

				BEGIN

					IF (@collength = -1) 

					BEGIN

						SET @l_colchange  = @l_colchange   + '(max)'

					END ELSE

					BEGIN

						SET @l_colchange  = @l_colchange  + '(' + cast (@collength as varchar(20)) + ')'

					END

				END

		END ELSE

		BEGIN

			declare @errmsg varchar(255)

			set @errmsg = 'Mark columns non-NULLABLE: ' + @colname + ' is an unsupported datatype (' + @colType

				+ ') ! - cannot change to non-nullable!'

			raiserror (@errmsg, 16,1)

			goto CX_ERROR_EXIT

		END

		exec(@l_update )

		SELECT	@retVal = @@ERROR

		IF		@retVal != 0

		BEGIN

				print 'Failed to update NULL columns'

				GOTO CX_ERROR_EXIT

		END

		set @l_colchange  = @l_colchange  + ' not null'

		exec(@l_colchange )

		SELECT	@retVal = @@ERROR

		IF		@retVal != 0

		BEGIN

				print 'Failed to make column not null, statement:' + @l_colchange

				GOTO CX_ERROR_EXIT

		END

		FETCH	NEXT FROM cur

		INTO @colname, @coltype, @collength

		SELECT	@retVal = @@ERROR

		IF		@retVal != 0

		BEGIN

			print 'Failed to fetch next column name and type'

			GOTO CX_ERROR_EXIT

		END

	END

	set @retVal = 0

CX_ERROR_EXIT:

	close cur

	deallocate cur

return @retVal

GO
IF @@error <> 0 RETURN
GO


