# POWERSHELL SCRIPT TO MODIFY DATA
# USING ModifyData.bash AS REFERENCE

Function ModifyData()
    {
        $path         = "##Automation--path--##"
        $rename       = "##Automation--rename--##"
        $modify       = "##Automation--modify--##"
        $acls         = "##Automation--acls--##"
        $xattr        = "##Automation--xattr--##"
        $permissions  = "##Automation--permissions--##"
        $slinks       = "##Automation--slinks--##"
        $hlinks       = "##Automation--hlinks--##"
        $TESTGROUP    = "cvgroup"
        $TESTUSER     = "cvusr"
        $ACLGROUP     = "cvgroup2"
        $ACLUSER      = "cvusr2"

        # Function to create user and group to set on the test data set
        function makeUserAndGroup()
         {
          NET LOCALGROUP $TESTGROUP /ADD
          NET LOCALGROUP $ACLGROUP /ADD
          NET USER $TESTUSER "######"/ADD
          NET USER $ACLUSER "######"/ADD
          NET LOCALGROUP $TESTGROUP $TESTUSER /ADD
          NET LOCALGROUP $ACLGROUP $ACLUSER /ADD
         }

        # Function to rename all the files in a given path
        # Already renamed files won't be renamed again
        function doRename([String]$path)
         {
          $ListOfFiles = (Get-ChildItem -File -Recurse $path).FullName 
          foreach ($file in $ListOfFiles) 
           {
            if($file -notmatch "cvrenamed*")
             {
              Rename-Item $file $file".cvrenamed" -ErrorAction Ignore
             }
            }
          }  

        # Function to modify all the files in a given path by adding extra data
        function doModify([String]$path)
         {
          $ListOfFiles = (Get-ChildItem -File -Recurse $path).FullName
          foreach ($file in $ListOfFiles) 
           {
            echo cvmodified >> $file 
           }
         }


        function doACLS([String]$path)
         {
          $ListOfFiles = (Get-ChildItem -File -Recurse $path).FullName
          # Options for icacls do not always run easily under Powershell, hence we make use of Invoke-Expression
		  $Grant       = "/GRANT"
		  $UserAccount = $ACLUSER
		  $Permission  = ":R" # Grant Read Permission 
          foreach ($File in $ListOfFiles) 
           {
            Invoke-Expression -Command('icacls $File $Grant $UserAccount$Permission') # Granting $UserAccount $Permission on $File, modifying ACLS 
           }           
         }


         # THIS IS A COPY OF doModify() NEED TO IMPLEMENT IT CORRECTLY        
         function doXATTR([String]$path)
         {
          $ListOfFiles = (Get-ChildItem -File -Recurse $path).FullName
          foreach ($File in $ListOfFiles) 
           {
            echo cvmodified >> $File 
           } 
         }


        function doPermissions([String]$path) # THIS IS A COPY OF doModify() NEED TO IMPLEMENT IT CORRECTLY
         {
          $ListOfFiles = (Get-ChildItem -File -Recurse $path).FullName
          foreach ($file in $ListOfFiles) 
           {
            echo cvmodified >> $file 
           } 
         }

        # Function to modify all the files in a given path by adding Symbolic links
        function doSLINKS($path)
         {
          $ListOfFiles = (Get-ChildItem -File -Recurse $path).FullName
          foreach($file in $ListOfFiles)
           {
            New-Item -Path $file".cvslink" -ItemType SymbolicLink -Value $file -ErrorAction Ignore | Out-Null
           }
         }

        # Function to modify all the files in a given path by adding Hard links
        function doHLINKS()
         {
          $ListOfFiles = (Get-ChildItem -File -Recurse $path).FullName
          foreach($file in $ListOfFiles)
           {
            New-Item -Path $file".cvhlink" -ItemType HardLink -Value $file -ErrorAction Ignore | Out-Null
           }
         }


        if ($rename -eq "yes")
         {
          doRename $path
         }


        if ($modify -eq "yes")
         {
          doModify $path
         }

 
        if ($acls -eq "yes")
         {
          doACLS $path
         }

         if ($xattr -eq "yes")
         {
          doXATTR $path
         }

         if ($permissions -eq "yes")
         {
          doPermissions $path
         }

         if ($slinks -eq "yes")
         {
          doSLINKS $path
         }

         if ($hlinks -eq "yes")
         {
          doHLINKS $path
         }
    }








