Function ScanDirectory(){

    $recursive = "##Automation--recursive--##"
    $recursive_flag = $recursive -eq "yes"
    $path ='##Automation--path--##'

    if($path.StartsWith('\\'))
    {
    $BSTR = [System.Runtime.InteropServices.Marshal]::SecureStringToBSTR($using:Credentials.Password)
    $Plaintext = [System.Runtime.InteropServices.Marshal]::PtrToStringAuto($BSTR)
    $username= $using:Credentials.username
    $path1=Split-Path -Path $path
    net use $path1 /user:$username $Plaintext | Out-Null
    }


    $items = Get-ChildItem $path -recurse:$recursive_flag | foreach-object{
        $type = 'file'
        $attrs = [string] $_.Attributes
        if($attrs.contains('Directory')){
            $type = 'directory'
        }
        $modified_time = [Int] (New-TimeSpan -Start (Get-Date -Date '01/01/1970') -End $_.LastWriteTime).TotalSeconds
        return '{0};{1};{2};{3}' -f $_.FullName, $type, $_.Length, $modified_time
    }

    return $items
}