# -*- coding: utf-8 -*-

# --------------------------------------------------------------------------
# Copyright Commvault Systems, Inc.
# See LICENSE.txt in the project root for
# license information.
# --------------------------------------------------------------------------

"""Main file for performing 7z file operations

wrapper7z:

    extract()        -- This Function is used to extract the file present in the given path
"""

import os
from AutomationUtils.windows_machine import WindowsMachine


class Wrapper7Z(object):
    """Helper class to perform 7z file operations"""

    def __init__(self, commcell=None, client=None, log=None, zipfilepath=None):
        """Initializes wrapper7Z object and gets the commserv database object if not specified

            Args:
                client    (object)    --  client database object
                commcell   (object)   --  client database object
                zipfilepath(string)   --  filepath to zip or unzip
        """
        self.log = log
        self.client = client
        self.commcell = commcell
        self.simpana_base_path = self.client.install_directory
        self.zipfilepath = zipfilepath

    def extract(self, dest=None):
        """
        This Function is used to extract the file present in the given path
        Return Value:
            @Success: Tuple, (Status=True/False, output=stdout/stderr)
            @Error: string, (output=stdout/stderr)
        """
        log = self.log
        tmppath = os.path.dirname(self.zipfilepath)
        if not dest:
            dest = os.path.join(tmppath, '*')

        try:
            cmd = self.simpana_base_path.replace(
                " ", "' '") + "\\Base\\cv7z.exe" + " e " + self.zipfilepath.replace(' ', "' '") + " -o" + dest.replace(
                ' ', "' '") + " -y"
            log.info("Command used unzip %s" % cmd)
            client_machine = WindowsMachine(
                self.client.client_name, self.commcell)
            output = client_machine.execute_command(cmd)
            if str(output.output).find("fail") >= 0 or output.exit_code != 0:
                log.error(
                    "Error while unzipping files, error %s" %
                    str(output))
                raise Exception(
                    "Error while unzipping files, error %s" %
                    str(output))
            else:
                log.info("Successfuly unzipped 7z Files on CS")
            return (True, output)
        except Exception as err:
            log.exception("Exception raised. Reason: %s" % (err))
            raise Exception(
                "Error while unzippeing files, error %s" %
                str(output))
