'use strict';
/**
 * @ngdoc overview
 * @name timesheets application
 * @description # timeSheetsCommvaultApp
 * 
 * Main module of the application.
 */

var app = angular
		.module('timesheetsCommvaultApp',
				[
						'ngRoute',
						'ngResource',
						'ngAnimate',
						'ngCookies',
						'ngSanitize',
						'ngTouch',
						'ui.bootstrap',
						'restangular',
						'angularUtils.directives.dirPagination' ])
		.run([
				"$rootScope",
				"$location",
				"$window",
				"i8nConstants",
				"employeeServices",
				"Restangular",
				"Utils",
				function($rootScope, $location, $window, i8nConstants, employeeServices, Restangular, Utils) {
					$rootScope.$location = $location;
					$rootScope.i8nConstants = i8nConstants;
					$rootScope.appRoot = appUtil.appRoot;
					$rootScope.errorMsg = i8nConstants.SOMETHING_WENT_WRONG;
					$rootScope.title = i8nConstants.TIMESHEET_MANAGEMENT_SYSTEM;
					$rootScope.weeksToSubmit = false;
					$rootScope.initialLoading = true;
					$rootScope.contentLoaded = false;
					$rootScope.isAuthorizedPerson = true;
					$rootScope.showError = false;
					$rootScope.loading = 0;

					function incrementLoad() {
						$rootScope.loading += 20;
					}
					function decrementLoad() {
						$rootScope.loading -= 20;
					}

					$window.onload = function() {
						$rootScope.$apply(function() {
							$rootScope.contentLoaded = true;
						});
						$(".wrapper").removeClass("hide");
					};

					employeeServices.setEnvironment("prod");

					if (employeeServices.getEnvironment() === "prod") {
						Restangular.setBaseUrl($window.location.protocol + "//" + $window.location.host +
								appUtil.appRoot);
						$rootScope.$on('$routeChangeStart', function(event, next, current) {
							if (Utils.getCsrfToken() === null) {
								$rootScope.errorMsg = i8nConstants.REDIRECTING_TO_LOGIN_PAGE;
								$rootScope.showError = true;
								$window.location.reload();
							}
						});
						Restangular.addRequestInterceptor(function(element, operation, what, url) {
							var csrfToken = Utils.getCsrfToken();
							if (csrfToken !== null) {
								Restangular.setDefaultHeaders({
									"X-CSRF-Token" : csrfToken
								});
								incrementLoad();
							}

							if (Utils.getCsrfToken() === null) {
								$rootScope.errorMsg = i8nConstants.REDIRECTING_TO_LOGIN_PAGE;
								$rootScope.showError = true;
								$window.location.reload();
							}
							return element;

						});
						Restangular.addResponseInterceptor(function(data, operation, what, url, response, deferred) {
							decrementLoad();
							if (angular.isArray(data) || angular.isObject(data)) {
								if ((response.config.headers["X-CSRF-Token"] === null) &&
										(response.config.method != "GET")) {
									$rootScope.errorMsg = i8nConstants.REDIRECTING_TO_LOGIN_PAGE;
									$rootScope.showError = true;
									$window.location.reload();

								}
							} else {
								$rootScope.errorMsg = i8nConstants.SOMETHING_WENT_WRONG;
								$rootScope.showError = true;
								$window.location.reload();
							}
							return data;
						});
						Restangular.setErrorInterceptor(function(response, deferred, responseHandler) {
							decrementLoad();
							$rootScope.errorMsg = i8nConstants.SOMETHING_WENT_WRONG;
							$rootScope.showError = true;
							$window.location.reload();
						});
					}

				} ])
		.config([
				"$routeProvider",
				"$locationProvider",
				"paginationTemplateProvider",
				function($routeProvider, $locationProvider, paginationTemplateProvider) {
					paginationTemplateProvider.setPath('views/dirPagination.tpl.html');
					$routeProvider
							.when('/submitTimesheets',
									{
										templateUrl : 'views/SubmitTimeSheet.html',
										controller : 'submitTimeSheetCtrl',
										resolve : {
											data : [
													"employeeServices",
													"$q",
													"$rootScope",
													"i8nConstants",
													"$location",
													function(employeeServices, $q, $rootScope, i8nConstants, $location) {
														var deferred = $q.defer();
														employeeServices.getEmpData().then(function(resp) {

															$rootScope.title = i8nConstants.SUBMIT_TIMESHEET;
															$rootScope.basicAuthInfo = resp;
															$rootScope.initialLoading = false;
															$rootScope.isAuthorizedPerson = true;
															$rootScope.reportsUrl = resp.reportsURL;
															if (resp.authorizedFlag === false) {
																if (resp.extraWeeksToSubmit === true) {
																	$location.path("/timesheets");
																} else if (resp.levelFlag === "manager" ||
																		resp.levelFlag === "proxy" ||
																		resp.levelFlag === "admin") {
																	$location.path("/approveTimesheets");
																} else if (resp.needHistoryView === true) {
																	$location.path("/timesheetsHistory");
																} else {
																	$rootScope.isAuthorizedPerson = false;
																	$location.path("/notAuthorized");
																}
															}
															deferred.resolve(resp);
														},
																function(resp) {
																	deferred.reject(resp);
																});
														return deferred.promise;
													} ]
										}
									})
							.when('/editTimeSheets/:id/:weekStart/:weekEnd',
									{
										templateUrl : 'views/SubmitTimeSheet.html',
										controller : 'editTimeSheetCtrl',
										resolve : {
											data : [
													"employeeServices",
													"$q",
													"$rootScope",
													"i8nConstants",
													"$location",
													function(employeeServices, $q, $rootScope, i8nConstants, $location) {
														var deferred = $q.defer();
														employeeServices.getEmpData().then(function(resp) {

															$rootScope.title = i8nConstants.EDIT_TIMESHEET;
															$rootScope.basicAuthInfo = resp;
															$rootScope.initialLoading = false;
															$rootScope.isAuthorizedPerson = true;
															$rootScope.reportsUrl = resp.reportsURL;
															if (resp.authorizedFlag === false &&
																	resp.extraWeeksToSubmit === false &&
																	resp.levelFlag !== "admin") {
																if (resp.levelFlag === "manager" ||
																		resp.levelFlag === "proxy") {
																	$location.path("/approveTimesheets");
																} else if (resp.needHistoryView === true) {
																	$location.path("/timesheetsHistory");
																} else {
																	$rootScope.isAuthorizedPerson = false;
																	$location.path("/notAuthorized");
																}
															}
															deferred.resolve(resp);
														},
																function(resp) {
																	deferred.reject(resp);
																});
														return deferred.promise;
													} ]
										}

									})
							.when('/timesheets',
									{
										templateUrl : 'views/SubmitTimeSheet.html',
										controller : 'pastTimesheetOnlyCtrl',
										resolve : {
											data : [
													"employeeServices",
													"$q",
													"$rootScope",
													"i8nConstants",
													"$location",
													function(employeeServices, $q, $rootScope, i8nConstants, $location) {
														var deferred = $q.defer();
														employeeServices.getEmpData().then(function(resp) {

															$rootScope.title = i8nConstants.SUBMIT_TIMESHEET;
															$rootScope.basicAuthInfo = resp;
															$rootScope.initialLoading = false;
															$rootScope.isAuthorizedPerson = true;
															$rootScope.reportsUrl = resp.reportsURL;
															if (resp.authorizedFlag === true) {
																$location.path("/submitTimesheets");
															} else if (resp.authorizedFlag === false &&
																	resp.extraWeeksToSubmit === false) {
																if (resp.levelFlag === "manager" ||
																		resp.levelFlag === "proxy" ||
																		resp.levelFlag === "admin") {
																	$location.path("/approveTimesheets");
																} else if (resp.needHistoryView === true) {
																	$location.path("/timesheetsHistory");
																} else {
																	$rootScope.isAuthorizedPerson = false;
																	$location.path("/notAuthorized");
																}
															}
															deferred.resolve(resp);
														},
																function(resp) {
																	deferred.reject(resp);
																});
														return deferred.promise;
													} ]
										}
									})
							.when('/timesheetsHistory',
									{
										templateUrl : 'views/timesheetsHistory.html',
										controller : 'timeSheetHistoryCtrl',

										resolve : {
											data : [
													"employeeServices",
													"$q",
													"$rootScope",
													"i8nConstants",
													"$location",
													function(employeeServices, $q, $rootScope, i8nConstants, $location) {
														var deferred = $q.defer();
														employeeServices
																.getEmpData()
																.then(function(resp) {

																	$rootScope.title = i8nConstants.TIMESHEET_HISTORY;
																	$rootScope.basicAuthInfo = resp;
																	$rootScope.initialLoading = false;
																	$rootScope.isAuthorizedPerson = true;
																	$rootScope.reportsUrl = resp.reportsURL;
																	if (!(resp.authorizedFlag === true ||
																			resp.extraWeeksToSubmit === true || resp.needHistoryView === true)) {
																		if (resp.levelFlag === "manager" ||
																				resp.levelFlag === "proxy" ||
																				resp.levelFlag === "admin") {
																			$location.path("/approveTimesheets");
																		} else {
																			$rootScope.isAuthorizedPerson = false;
																			$location.path("/notAuthorized");
																		}
																	}
																	deferred.resolve(resp);
																},
																		function(resp) {
																			deferred.reject(resp);
																		});
														return deferred.promise;
													} ]
										}

									})
							.when('/holidays',
									{
										templateUrl : 'views/holiday.html',
										controller : 'holidayCtrl',
										resolve : {
											data : [
													"employeeServices",
													"$q",
													"$rootScope",
													"i8nConstants",
													"$location",
													function(employeeServices, $q, $rootScope, i8nConstants, $location) {
														var deferred = $q.defer();
														employeeServices
																.getEmpData()
																.then(function(resp) {

																	$rootScope.title = i8nConstants.HOLIDAYS;
																	$rootScope.basicAuthInfo = resp;
																	$rootScope.initialLoading = false;
																	$rootScope.isAuthorizedPerson = true;
																	$rootScope.reportsUrl = resp.reportsURL;
																	if (!(resp.authorizedFlag === true ||
																			resp.extraWeeksToSubmit === true ||
																			resp.needHistoryView === true ||
																			resp.levelFlag === "manager" ||
																			resp.levelFlag === "proxy" || resp.levelFlag === "admin")) {
																		$rootScope.isAuthorizedPerson = false;
																		$location.path("/notAuthorized");
																	}
																	deferred.resolve(resp);
																},
																		function(resp) {
																			deferred.reject(resp);
																		});
														return deferred.promise;
													} ]
										}

									})
							.when('/approveTimesheets',
									{
										templateUrl : 'views/approveTimesheets.html',
										controller : 'approveTimeSheetsCtrl',
										resolve : {
											data : [
													"employeeServices",
													"$q",
													"$rootScope",
													"i8nConstants",
													"$location",
													function(employeeServices, $q, $rootScope, i8nConstants, $location) {
														var deferred = $q.defer();
														employeeServices
																.getEmpData()
																.then(function(resp) {

																	$rootScope.title = i8nConstants.APPROVE_TIMESHEETS;
																	$rootScope.basicAuthInfo = resp;
																	$rootScope.initialLoading = false;
																	$rootScope.isAuthorizedPerson = true;
																	$rootScope.reportsUrl = resp.reportsURL;
																	if (!(resp.levelFlag === "manager" ||
																			resp.levelFlag === "proxy" || resp.levelFlag === "admin")) {
																		if (resp.authorizedFlag === true) {
																			$location.path("/submitTimesheets");
																		} else if (resp.extraWeeksToSubmit === true) {
																			$location.path("/timesheets");
																		} else if (resp.needHistoryView === true) {
																			$location.path("/timesheetsHistory");
																		} else {
																			$rootScope.isAuthorizedPerson = false;
																			$location.path("/notAuthorized");
																		}
																	}
																	deferred.resolve(resp);
																},
																		function(resp) {
																			deferred.reject(resp);
																		});
														return deferred.promise;
													} ]
										}

									})
							.when('/managerProxy',
									{
										templateUrl : 'views/assignProxy.html',
										controller : 'assignProxyCtrl',
										resolve : {
											data : [
													"employeeServices",
													"$q",
													"$rootScope",
													"i8nConstants",
													"$location",
													function(employeeServices, $q, $rootScope, i8nConstants, $location) {
														var deferred = $q.defer();
														employeeServices
																.getEmpData()
																.then(function(resp) {

																	$rootScope.title = i8nConstants.ASSIGN_PROXY;
																	$rootScope.basicAuthInfo = resp;
																	$rootScope.initialLoading = false;
																	$rootScope.isAuthorizedPerson = true;
																	$rootScope.reportsUrl = resp.reportsURL;
																	if (!(resp.levelFlag === "manager" ||
																			resp.levelFlag === "proxy" || resp.levelFlag === "admin")) {
																		if (resp.authorizedFlag === true) {
																			$location.path("/submitTimesheets");
																		} else if (resp.extraWeeksToSubmit === true) {
																			$location.path("/timesheets");
																		} else if (resp.needHistoryView === true) {
																			$location.path("/timesheetsHistory");
																		} else {
																			$rootScope.isAuthorizedPerson = false;
																			$location.path("/notAuthorized");
																		}
																	}
																	deferred.resolve(resp);
																},
																		function(resp) {
																			deferred.reject(resp);
																		});
														return deferred.promise;
													} ]
										}
									})
							.when('/assignProxy',
									{
										templateUrl : 'views/adminAssignProxy.html',
										controller : 'adminAssignProxyCtrl',
										resolve : {
											data : [
													"employeeServices",
													"$q",
													"$rootScope",
													"i8nConstants",
													"$location",
													function(employeeServices, $q, $rootScope, i8nConstants, $location) {
														var deferred = $q.defer();
														employeeServices.getEmpData().then(function(resp) {

															$rootScope.title = i8nConstants.ASSIGN_PROXY;
															$rootScope.basicAuthInfo = resp;
															$rootScope.initialLoading = false;
															$rootScope.isAuthorizedPerson = true;
															$rootScope.reportsUrl = resp.reportsURL;
															if (resp.levelFlag !== "admin") {
																if (resp.authorizedFlag === true) {
																	$location.path("/submitTimesheets");
																} else if (resp.extraWeeksToSubmit === true) {
																	$location.path("/timesheets");
																} else if (resp.levelFlag === "manager") {
																	$location.path("/approveTimesheets");
																} else if (resp.needHistoryView === true) {
																	$location.path("/timesheetsHistory");
																} else {
																	$rootScope.isAuthorizedPerson = false;
																	$location.path("/notAuthorized");
																}
															}
															deferred.resolve(resp);
														}, function(resp) {
															deferred.reject(resp);
														});
														return deferred.promise;
													} ]
										}
									})
							.when('/allTimesheets',
									{
										templateUrl : 'views/viewAllTimesheets.html',
										controller : 'viewAllTimesheetsCtrl',
										resolve : {
											data : [
													"employeeServices",
													"$q",
													"$rootScope",
													"i8nConstants",
													"$location",
													function(employeeServices, $q, $rootScope, i8nConstants, $location) {
														var deferred = $q.defer();
														employeeServices.getEmpData().then(function(resp) {

															$rootScope.title = i8nConstants.TIMESHEETS_PAYROLL;
															$rootScope.basicAuthInfo = resp;
															$rootScope.initialLoading = false;
															$rootScope.isAuthorizedPerson = true;
															$rootScope.reportsUrl = resp.reportsURL;
															if (resp.levelFlag !== "admin") {
																if (resp.authorizedFlag === true) {
																	$location.path("/submitTimesheets");
																} else if (resp.extraWeeksToSubmit === true) {
																	$location.path("/timesheets");
																} else if (resp.levelFlag === "manager") {
																	$location.path("/approveTimesheets");
																} else if (resp.needHistoryView === true) {
																	$location.path("/timesheetsHistory");
																} else {
																	$rootScope.isAuthorizedPerson = false;
																	$location.path("/notAuthorized");
																}
															}
															deferred.resolve(resp);
														}, function(resp) {
															deferred.reject(resp);
														});
														return deferred.promise;
													} ]
										}
									})
							.when('/submitEmployeeTimesheet',
									{
										templateUrl : 'views/SubmitOthersTimesheet.html',
										controller : 'submitTimeSheetForOthersCtrl',
										resolve : {
											data : [
													"employeeServices",
													"$q",
													"$rootScope",
													"i8nConstants",
													"$location",
													function(employeeServices, $q, $rootScope, i8nConstants, $location) {
														var deferred = $q.defer();
														employeeServices
																.getEmpData()
																.then(function(resp) {

																	$rootScope.title = i8nConstants.SUBMIT_TIMESHEET;
																	$rootScope.basicAuthInfo = resp;
																	$rootScope.initialLoading = false;
																	$rootScope.isAuthorizedPerson = true;
																	$rootScope.reportsUrl = resp.reportsURL;
																	if (!(resp.levelFlag === "manager" ||
																			resp.levelFlag === "proxy" || resp.levelFlag === "admin")) {
																		if (resp.authorizedFlag === true) {
																			$location.path("/submitTimesheets");
																		} else if (resp.extraWeeksToSubmit === true) {
																			$location.path("/timesheets");
																		} else if (resp.needHistoryView === true) {
																			$location.path("/timesheetsHistory");
																		} else {
																			$rootScope.isAuthorizedPerson = false;
																			$location.path("/notAuthorized");
																		}
																	}
																	deferred.resolve(resp);
																},
																		function(resp) {
																			deferred.reject(resp);
																		});
														return deferred.promise;
													} ]
										}
									}).when('/notAuthorized', {
								templateUrl : 'views/notAuthorized.html',
								resolve : {
									data : [ "$rootScope", "i8nConstants", function($rootScope, i8nConstants) {

										$rootScope.title = i8nConstants.NOT_AUTHORIZED;
										$rootScope.isAuthorizedPerson = false;
										$rootScope.initialLoading = false;
									} ]
								}
							}).when('/autoApprove/:id/:action', {
								templateUrl : 'views/autoApproveFromEmail.html',
								controller : 'autoApproveCtrl',
								resolve : {
									data : [ "$rootScope", "i8nConstants", function($rootScope, i8nConstants) {

										$rootScope.title = i8nConstants.PROCESS_TIMESHEETS;
										$rootScope.initialLoading = false;
									} ]
								}
							}).otherwise({
								templateUrl : 'views/SubmitTimeSheet.html',
								controller : 'submitTimeSheetCtrl',
								resolve : {
									data : [
											"employeeServices",
											"$q",
											"$rootScope",
											"$location",
											"i8nConstants",
											function(employeeServices, $q, $rootScope, $location, i8nConstants) {
												var deferred = $q.defer();
												employeeServices.getEmpData().then(function(resp) {

													$rootScope.title = i8nConstants.SUBMIT_TIMESHEET;
													$rootScope.basicAuthInfo = resp;
													$rootScope.isAuthorizedPerson = true;
													$rootScope.initialLoading = false;
													$rootScope.reportsUrl = resp.reportsURL;
													if (resp.authorizedFlag === false) {
														if (resp.extraWeeksToSubmit === true) {
															$location.path("/timesheets");
														} else if (resp.levelFlag === "manager" ||
																resp.levelFlag === "proxy" ||
																resp.levelFlag === "admin") {
															$location.path("/approveTimesheets");
														} else if (resp.needHistoryView === true) {
															$location.path("/timesheetsHistory");
														} else {
															$rootScope.isAuthorizedPerson = false;
															$location.path("/notAuthorized");
														}
													}
													deferred.resolve(resp);
												},
														function(resp) {
															deferred.reject(resp);
														});
												return deferred.promise;
											} ]
								}
							});

				} ]);
