(function() {
	app.controller("adminAssignProxyCtrl", [
			"$scope",
			"i8nConstants",
			"$timeout",
			"$anchorScroll",
			"Utils",
			"$filter",
			"$location",
			"employeeServices",
			"apiServices",
			function($scope, i8nConstants, $timeout, $anchorScroll, Utils, $filter, $location, employeeServices,
					apiServices) {

				$scope.i8nConstants = i8nConstants;
				$scope.proxy = {};
				$scope.assignedProxies = [];
				$scope.editFlag = false;
				var departmentList = [];
				$scope.loadingFlag = false;
				//var managersList = [];

				$scope.closeAlertMessage = function() {
					$scope.alerts = {
						deleteSuccess : false,
						deleteFailure : false,
						addSuccess : false,
						addFailure : false,
						editSuccess : false,
						editFailure : false
					};
				};

				$scope.$on('startDateChanged', function(event, date) {
					$scope.proxy.dValidFrom = date;
				});

				$scope.$on('endDateChanged', function(event, date) {
					$scope.proxy.dExpiryDate = date;
				});
				$scope.formatDates = function(dateStr) {
					return Utils.convertDateString(dateStr);
				};

				$scope.preventPropagation = function(event) {
					event.stopPropagation();
				};

				$scope.initData = function() {
					$scope.closeAlertMessage();
					apiServices.getListingObjArray("ManagerDetails").then(function(response) {
						$scope.managersList = response;
					}, function(resp) {
						if (resp.printError === true) {
							Utils.displayError();
						}
						$scope.managersList = [];
					});
					apiServices.getListingObjArray("Department").then(function(response) {
						departmentList = response;
					}, function(resp) {
						if (resp.printError === true) {
							Utils.displayError();
						}
						departmentList = [];
					});

					var actualParams = getProxyParams();
					for ( var key in actualParams) {
						$scope.proxy[key] = actualParams[key];
					}
				};

				$scope.getAssignedProxies = function() {
					//get the list of assigned proxies for the given prodcertname
					$scope.loadingFlag = true;
					var url = employeeServices.getUrlObj().getAllAssignedProxy;
					var params = null;
					params = {
						"apptype" : "timesheet"
					};
					apiServices.cudAPI(url, params).then(function(response) {
						//apiServices.getListingObjArray("AllAssignedProxy").then(function(response) {
						$scope.loadingFlag = false;
						$scope.assignedProxies = response[0].data;
						if ($scope.assignedProxies === null) {
							$scope.assignedProxies = [];
						}
					}, function(resp) {
						if (resp.printError === true) {
							Utils.displayError();
						}
						$scope.assignedProxies = [];
					});
				};

				$scope.clickonCurrManagersList = function() {
					if (!angular.element(event.target.parentElement).hasClass('open')) {
						$scope.showCurrManagersList = false;
						$timeout(function() {
							$scope.showCurrManagersList = true;
						});
					}
					$scope.filteredManagerList = $scope.managersList;
				};

				$scope.keypressCurrManagersName = function(event) {
					$scope.filteredManagerList = $filter('filter')($scope.managersList, {
						'sEmpName' : $scope.proxy.sUserName
					});
					$scope.filteredManagerList = $filter('orderBy')($scope.filteredManagerList, 'sEmpName');
					$scope.proxy.sUser = "";
					$scope.proxy.sUserDept = "";
					if (!angular.element(event.target.parentElement).hasClass('open')) {
						$scope.showCurrManagersList = false;
						$timeout(function() {
							$scope.showCurrManagersList = true;
						});
					}
				};
				$scope.addCurrentManager = function(manager) {
					$scope.showCurrManagersList = false;
					$scope.proxy.sUserName = manager.sEmpName;
					$scope.proxy.sUser = manager.ProdcertName;
					$scope.proxy.sUserDept = manager.sDeptName;
				};
				$scope.clickonTempManagersList = function() {
					if (!angular.element(event.target.parentElement).hasClass('open')) {
						$scope.showTempManagers = false;
						$timeout(function() {
							$scope.showTempManagers = true;
						});
					}
					$scope.filteredManagerList = $scope.managersList;
				};

				$scope.keypressTempManagersName = function(event) {
					$scope.filteredManagerList = $filter('filter')($scope.managersList, {
						'sEmpName' : $scope.proxy.sProxyName
					});
					$scope.filteredManagerList = $filter('orderBy')($scope.filteredManagerList, 'sEmpName');
					$scope.proxy.sProxy = "";
					$scope.proxy.sProxyDept = "";
					if (!angular.element(event.target.parentElement).hasClass('open')) {
						$scope.showTempManagers = false;
						$timeout(function() {
							$scope.showTempManagers = true;
						});
					}
				};

				$scope.addTemporaryManager = function(manager) {
					$scope.showTempManagers = false;
					$scope.proxy.sProxyName = manager.sEmpName;
					$scope.proxy.sProxy = manager.ProdcertName;
					$scope.proxy.sProxyDept = manager.sDeptName;
				};

				$scope.clearFields = function() {
					$scope.editFlag = false;
					$scope.proxyForm.$setPristine();
					var actualParams = getProxyParams();
					for ( var key in actualParams) {
						$scope.proxy[key] = actualParams[key];
					}
					$scope.$broadcast('editDates', $scope.proxy.dValidFrom, $scope.proxy.dExpiryDate);
				};

				$scope.submitForm = function() {
					if ($scope.proxyForm.$valid) {
						//submit the date in $scope.proxy to assign proxy
						var url = employeeServices.getUrlObj().addProxy;
						if ($scope.editFlag === true) {
							url = employeeServices.getUrlObj().editProxy;
						}
						var params = {
							"dExpiryDate" : Utils.respDateFormat($scope.proxy.dExpiryDate, true),
							"dValidFrom" : Utils.respDateFormat($scope.proxy.dValidFrom, true),
							"sProxy" : $scope.proxy.sProxy,
							"sUser" : $scope.proxy.sUser,
							"apptype" : "timesheet"
						};
						if ($scope.editFlag === true) {
							params.nID = $scope.proxy.nID;
						}
						apiServices.cudAPI(url, params).then(function(resp) {
							$scope.assignedProxies = [];
							$scope.loadingFlag = true;
							if ($scope.editFlag === false) {
								$scope.alerts.addSuccess = true;
							} else {
								$scope.alerts.editSuccess = true;
							}
							$anchorScroll();
							$scope.clearFields();
							$scope.getAssignedProxies();
							$timeout(function() {
								$scope.alerts.addSuccess = false;
								$scope.alerts.editSuccess = false;
							}, 3000);
						}, function(resp) {
							if (resp.printError === true) {
								if ($scope.editFlag === false) {
									$scope.alerts.addFailure = true;
								} else {
									$scope.alerts.editFailure = true;
								}
								$anchorScroll();
								$timeout(function() {
									$scope.alerts.addFailure = false;
									$scope.alerts.editFailure = false;
								}, 3000);
							}
						});
					}
				};

				$scope.displayRevokeProxy = function(proxy) {
					$scope.clearFields();
					$scope.revokeProxyObjID = proxy.nID;
				};

				$scope.revokeProxy = function() {
					//submit the data in $scope.proxy to revoke proxy

					var deleteObjParams = {
						"nID" : $scope.revokeProxyObjID,
						"apptype" : "timesheet"
					};
					var url = employeeServices.getUrlObj().revokeProxy;
					apiServices.cudAPI(url, deleteObjParams).then(function(response) {
						$scope.assignedProxies = [];
						$scope.loadingFlag = true;
						$scope.alerts.deleteSuccess = true;
						$scope.getAssignedProxies();
						$anchorScroll();
						$timeout(function() {
							$scope.alerts.deleteSuccess = false;
						}, 3000);
					}, function(resp) {
						if (resp.printError === true) {
							$scope.alerts.deleteFailure = true;
							$anchorScroll();
							$timeout(function() {
								$scope.alerts.deleteFailure = false;
							}, 3000);
						}
					});

				};

				$scope.editProxy = function(proxy) {
					$scope.clearFields();
					$scope.editFlag = true;
					var actualParams = getProxyParams();
					for ( var key in actualParams) {
						$scope.proxy[key] = proxy[key];
					}
					$scope.$broadcast('editDates', $scope.proxy.dValidFrom, $scope.proxy.dExpiryDate);
					$anchorScroll();
				};

				function getProxyParams() {
					return {
						"dExpiryDate" : "",
						"dValidFrom" : "",
						"sProxy" : "",
						"sProxyDept" : "",
						"sProxyName" : "",
						"sUser" : "",
						"nID" : "",
						"sUserName" : "",
						"sUserDept" : ""
					};
				}

			} ]);
})();