(function() {
	app
			.controller("viewAllTimesheetsCtrl",
					[
							"$scope",
							"i8nConstants",
							"TIMESHEET_CONSTANTS",
							"employeeServices",
							"$timeout",
							"$filter",
							"Utils",
							"$location",
							"apiServices",
							"messagesAndPopupServices",
							"$anchorScroll",
							"timesheetServices",
							function($scope, i8nConstants, TIMESHEET_CONSTANTS, employeeServices, $timeout, $filter,
									Utils, $location, apiServices, messagesAndPopupServices, $anchorScroll,
									timesheetServices) {

								$scope.TIMESHEET_CONSTANTS = TIMESHEET_CONSTANTS;
								$scope.excessTimeEntered = {};
								$scope.filteredTimesheets = [];
								$scope.filteredCountriesId = [];
								$scope.filteredLocations = [];
								$scope.filteredEmpName = [];
								$scope.filteredEmpID = [];
								$scope.statusFilter = [];
								$scope.timesheets = [];
								$scope.regionList = [];
								$scope.empFilter = [];
								$scope.reason = "";
								$scope.locationSearchName = "";
								$scope.timesheetsStatusFilter = "";
								$scope.timesheetSubmitComment = "";
								$scope.showMore = false;
								$scope.rejectApprovedError = false;
								var currentTimesheetDetails = {};
								var fromDate = "";
								var toDate = "";
								$scope.searchName = "";
								$scope.searchId = "";

								$scope.pageSizeList = [ 'All', 5, 10, 20, 50 ];
								$scope.weekDays = [
										"Sunday",
										"Monday",
										"Tuesday",
										"Wednesday",
										"Thursday",
										"Friday",
										"Saturday" ];
								$scope.filter = {
									locationOpen : false,
									statusOpen : false,
									empIdOpen : false,
									empNameOpen : false,
									searchName : "",
									searchId : ""
								};
								$scope.timesheetList = {
									totalCount : -1,
									showCount : 10,
									noOfItems : 0,
									currentPage : 1
								};
								$scope.statusFilter = [
										"Saved",
										"Submitted",
										"Approved",
										"Rejected",
										"Cancelled",
										"Submitted to Payroll" ];

								$scope.alerts = {
									success : false,
									failure : false
								};

								$scope.$on('startDateChanged', function(event, startDate) {
									var date = angular.copy(startDate);
									fromDate = date.getDate() - ((date.getDay() + 1) % 7);
									fromDate = new Date(date.setDate(fromDate));
								});

								$scope.$on('endDateChanged', function(event, endDate) {
									var date = angular.copy(endDate);
									toDate = date.getDate() - ((date.getDay() + 1) % 7) + 6;
									toDate = new Date(date.setDate(toDate));
								});

								$scope.preventPropagation = function(event) {
									event.stopPropagation();
								};

								$scope.moreInfo = function() {
									$scope.showMore = !$scope.showMore;
								};

								$scope.closeAlertMessage = function() {
									$scope.alerts = {
										success : false,
										failure : false
									};
								};

								$scope.initData = function() {

									$scope.timesheetsStatusFilter = "All";
									//get the start date and end date
									var date = new Date();
									var startDate = date.getDate() - ((date.getDay() + 1) % 7);
									var endDate = startDate + 6;
									fromDate = new Date("01/01/" + date.getFullYear());
									toDate = new Date(new Date(date).setDate(endDate));
									$timeout(function() {
										$scope.$broadcast('editDates', fromDate, date);
									});

									//get the regions name
									$scope.regionList = employeeServices.getLocationsList();
									for (var i = 0; i < $scope.regionList.length; i++) {
										$scope.filteredCountriesId.push($scope.regionList[i].nLocationID);
									}
									//get all employees data
									$scope.empFilter = [];
									apiServices.getListingObjArray("EmployeeNames").then(function(response) {
										$scope.empFilter = $filter('orderBy')(response, 'sEmpName');
										$scope.filteredEmpList = angular.copy($scope.empFilter);
										for (j = 0; j < $scope.empFilter.length; j++) {
											$scope.filteredEmpName.push($scope.empFilter[j].ProdcertName);
											$scope.filteredEmpID.push($scope.empFilter[j].sEmpID);
										}
										$scope.fetchAllList();
									}, function(resp) {
										if (resp.printError === true) {
											Utils.displayError();
										}
										$scope.empFilter = [];
										$scope.filteredEmpList = [];
										$scope.filteredEmpName = [];
										$scope.filteredEmpID = [];
									});

								};

								$scope.fetchAllList = function() {
									$scope.timesheetList = {
										totalCount : -1,
										showCount : 10,
										noOfItems : 0,
										currentPage : 1
									};
									$scope.pageChangedPending(1);
								};

								$scope.pageChangedPending = function(newPage) {
									if ($scope.timesheetList.showCount === "All") {
										$scope.timesheetList.noOfItems = $scope.timesheetList.totalCount;
									} else {
										$scope.timesheetList.noOfItems = $scope.timesheetList.showCount;
									}
									$scope.timesheetList.totalCount = -1;
									$scope.timesheetList.currentPage = newPage;
									$scope.timesheets = [];
									$scope.filteredTimesheets = [];
									var params = {
										"pageno" : newPage,
										"pageSize" : $scope.timesheetList.noOfItems,
										"startdate" : Utils.respDateFormat(fromDate, true),
										"enddate" : Utils.respDateFormat(toDate, true)
									};
									if ($scope.timesheetsStatusFilter !== "" && $scope.timesheetsStatusFilter !== "All") {
										params.status = $scope.timesheetsStatusFilter;
									}
									if ($scope.filteredCountriesId.length &&
											$scope.regionList.length !== $scope.filteredCountriesId.length) {
										params.location = ($scope.filteredCountriesId).toString();
									}
									if ($scope.filteredEmpID.length > 0 &&
											$scope.empFilter.length !== $scope.filteredEmpID.length) {
										params.empIds = ($scope.filteredEmpID).toString();
									}
									if ($scope.filteredCountriesId.length === 0) {
										$scope.timesheetList.totalCount = 0;
										$scope.alertMessage = i8nConstants.NO_LOCATIONS_SELECTED;
										$scope.alerts.failure = true;
										$anchorScroll();
										$timeout(function() {
											$scope.alerts.failure = false;
										}, 3000);
										return;
									}
									if ($scope.filteredEmpID.length === 0) {
										$scope.timesheets = [];
										$scope.filteredTimesheets = [];
										$scope.timesheetList.totalCount = 0;
										return;
									}

									var url = employeeServices.getUrlObj().getAllTimesheets;

									apiServices.cudAPI(url, params).then(function(resp) {
										$scope.timesheetList.totalCount = 0;
										$scope.timesheets = resp[0].data;
										if ($scope.timesheets) {
											$scope.timesheetList.totalCount = resp[0].TotalCount;
											for (var i = 0; i < $scope.timesheets.length; i++) {
												$scope.timesheets[i].weekStart = new Date(
														$scope.timesheets[i].weekStart);
												$scope.timesheets[i].weekEnd = angular
														.copy($scope.timesheets[i].weekStart);
												$scope.timesheets[i].weekEnd.setDate($scope.timesheets[i].weekEnd
														.getDate() + 6);
											}
											$scope.filteredTimesheets = angular.copy($scope.timesheets);
										} else {
											$scope.timesheets = [];
										}
									},
											function(resp) {
												$scope.timesheetList.totalCount = 0;
												if (resp.printError === true) {
													Utils.displayError();
												}
												$scope.timesheets = [];
											});
								};

								$scope.clickonStatusList = function(event) {
									if (!angular.element(event.target.parentElement).hasClass('open')) {
										$scope.filter.statusOpen = false;
										$timeout(function() {
											$scope.filter.statusOpen = true;
										});
									}
									$scope.filteredStatusList = $scope.statusFilter;
								};

								$scope.selectStatusType = function(status) {
									$scope.timesheetsStatusFilter = status;
									$scope.filter.statusOpen = false;
								};

								$scope.clickOnAllLocationsChkbx = function(value, event) {
									$scope.filteredCountriesId = [];
									if (value === true) {
										for (var i = 0; i < $scope.regionList.length; i++) {
											$scope.filteredCountriesId.push($scope.regionList[i].nLocationID);
										}
									}
									event.stopPropagation();
								};

								$scope.clickonLocationsList = function(event) {
									if (!angular.element(event.target.parentElement).hasClass('open')) {
										$scope.filter.locationOpen = false;
										$timeout(function() {
											$scope.filter.locationOpen = true;
										});
									}
									$scope.filteredLocations = $filter('orderBy')($scope.regionList, 'sRegionName');
								};

								$scope.keypressLocationsList = function(event) {
									$scope.filteredLocations = $filter('filter')($scope.regionList, {
										'sRegionName' : $scope.locationSearchName
									});
									$scope.filteredLocations = $filter('orderBy')($scope.filteredLocations,
											'sRegionName');
									if (!angular.element(event.target.parentElement).hasClass('open')) {
										$scope.filter.locationOpen = false;
										$timeout(function() {
											$scope.filter.locationOpen = true;
										});
									}
								};

								$scope.addLocation = function(region, event) {
									$scope.locationSearchName = "";
									if ($scope.filteredCountriesId.indexOf(region.nLocationID) === -1) {
										$scope.filteredCountriesId.push(region.nLocationID);
									} else {
										$scope.filteredCountriesId.splice($scope.filteredCountriesId
												.indexOf(region.nLocationID), 1);
									}
									event.stopPropagation();
								};

								$scope.clearSearchFilter = function() {
									$scope.filteredEmpList = angular.copy($scope.empFilter);
									$scope.filter.searchName = "";
									$scope.filter.searchId = "";
								};

								$scope.keypressEmpNameSearch = function(event) {
									$scope.filteredEmpList = $filter('filter')($scope.empFilter, {
										"sEmpName" : $scope.filter.searchName
									});
									$scope.filteredEmpList = $filter('orderBy')($scope.filteredEmpList, 'sEmpName');
									event.stopPropagation();
								};

								$scope.keypressEmpIdSearch = function(event) {
									$scope.filteredEmpList = $filter('filter')($scope.empFilter, {
										"sEmpID" : $scope.filter.searchId
									});
									$scope.filteredEmpList = $filter('orderBy')($scope.filteredEmpList, 'sEmpID');
									event.stopPropagation();
								};

								$scope.clickOnAllEmpCheckbox = function(value, event) {
									$scope.filteredEmpID = [];
									$scope.filteredEmpName = [];
									if (value === true) {
										for (var j = 0; j < $scope.empFilter.length; j++) {
											$scope.filteredEmpName.push($scope.empFilter[j].ProdcertName);
											$scope.filteredEmpID.push($scope.empFilter[j].sEmpID);
										}
									}
									event.stopPropagation();
								};

								$scope.selectEmpId = function(id) {
									$scope.filter.searchId = "";
									if ($scope.filteredEmpID.indexOf(id) === -1) {
										$scope.filteredEmpID.push(id);
										for (var i = 0; i < $scope.empFilter.length; i++) {
											if ($scope.empFilter[i].sEmpID === id) {
												$scope.filteredEmpName.push($scope.empFilter[i].ProdcertName);
												break;
											}
										}
									} else {
										$scope.filteredEmpName.splice($scope.filteredEmpID.indexOf(id), 1);
										$scope.filteredEmpID.splice($scope.filteredEmpID.indexOf(id), 1);
									}
									$scope.filteredEmpList = angular.copy($scope.empFilter);
								};

								$scope.selectEmpName = function(name) {
									$scope.filter.searchName = "";
									if ($scope.filteredEmpName.indexOf(name) === -1) {
										$scope.filteredEmpName.push(name);
										for (var i = 0; i < $scope.empFilter.length; i++) {
											if ($scope.empFilter[i].ProdcertName === name) {
												$scope.filteredEmpID.push($scope.empFilter[i].sEmpID);
												break;
											}
										}
									} else {
										$scope.filteredEmpID.splice($scope.filteredEmpName.indexOf(name), 1);
										$scope.filteredEmpName.splice($scope.filteredEmpName.indexOf(name), 1);
									}
									$scope.filteredEmpList = angular.copy($scope.empFilter);
								};

								$scope.submitConfirmation = function(data) {
									currentTimesheetDetails = data;
								};

								$scope.displayTimeSheetDetails = function(displayData) {
									currentTimesheetDetails = displayData;
									$scope.info = messagesAndPopupServices.displayTimeSheetDetails(displayData);
									$scope.info.sRequestor = displayData.sRequestor;
									$scope.info.sRequestStatus = displayData.sRequestStatus;
									$scope.showMore = false;
								};

								$scope.submitTimesheet = function() {
									//submit data
									currentTimesheetDetails.sComments = currentTimesheetDetails.sComments ? currentTimesheetDetails.sComments +
											" " + $scope.timesheetSubmitComment
											: $scope.timesheetSubmitComment;
									currentTimesheetDetails.totalHours = currentTimesheetDetails.regularHours +
											currentTimesheetDetails.overtimeHours +
											currentTimesheetDetails.doubleOvertimeHours;
									let results = timesheetServices.submitTimesheet(currentTimesheetDetails,
											"Submit",
											currentTimesheetDetails.sRequestor);
									apiServices.cudAPI(results.url, results.params).then(function(response) {
										angular.element("#timesheet_submitted").modal("show");
										$scope.timesheetSubmitComment = "";
										$scope.fetchAllList();
									}, function(resp) {
										if (resp.printError === true) {
											Utils.displayError();
										}
									});
								};

								$scope.approveTimesheetFromPopup = function() {
									$scope.error = false;
									ifExcessOT(currentTimesheetDetails);
								};
								$scope.approveTimesheetFromTable = function(data) {
									currentTimesheetDetails = data;
									$scope.error = false;
									ifExcessOT(currentTimesheetDetails);
								};

								function ifExcessOT(data) {
									if (data.overtimeHours > 20) {
										$scope.excessTimeEntered = {
											hours : data.overtimeHours,
											category : "Overtime"
										};
										angular.element("#excessTime").modal("show");
									} else if (data.doubleOvertimeHours > 20) {
										$scope.excessTimeEntered = {
											hours : data.doubleOvertimeHours,
											category : "Double Overtime"
										};
										angular.element("#excessTime").modal("show");
									} else {
										angular.element("#timesheet_approval").modal("show");
									}
								}

								$scope.rejectTimesheetFromTable = function(data) {
									$scope.error = false;
									currentTimesheetDetails = data;
								};
								$scope.rejectTimesheetFromPopup = function() {
									$scope.error = false;
								};

								$scope.rejectTimesheetCheck = function() {
									if ($scope.reason) {
										$scope.error = false;
										currentTimesheetDetails.sApproverComments = $scope.reason;
										$("#timesheet_rejectApproved").modal("hide");
										$("#timesheet_reject").modal("hide");
										$scope.processTimesheet("Reject");
									} else {
										$scope.error = true;
									}
								};

								$scope.processTimesheet = function(type) {
									$scope.rejectApprovedError = false;
									var url = "";
									var requestBody = {
										nID : currentTimesheetDetails.nID,
										sApproverComments : $scope.reason
									};
									if (type === "Approve") {
										url = employeeServices.getUrlObj().approveTimesheet;
									} else if (type === "Reject") {
										url = employeeServices.getUrlObj().rejectTimesheet;
									}
									apiServices
											.cudAPI(url, requestBody)
											.then(function() {
												$scope.reason = "";
												if (type === 'Approve') {
													$scope.alertMessage = i8nConstants.TIMESHEET_APPROVED_SUCCESSFULLY;
												} else {
													$scope.alertMessage = i8nConstants.TIMESHEET_REJECTED_SUCCESSFULLY;
												}
												$scope.alerts.success = true;
												$anchorScroll();
												$scope.fetchAllList();
												$timeout(function() {
													$scope.alerts.success = false;
												}, 3000);
											},
													function(response) {
														$scope.reason = "";
														if (response) {
															if (response[0].error === null &&
																	response.printError === true) {
																if (type === 'Approve') {
																	$scope.alertMessage = i8nConstants.UNABLE_TO_APPROVE_TIMESHEET +
																			' ' + i8nConstants.PLEASE_TRY_AGAIN;
																} else {
																	$scope.alertMessage = i8nConstants.UNABLE_TO_REJECT_TIMESHEET +
																			' ' + i8nConstants.PLEASE_TRY_AGAIN;
																}
																$scope.alerts.failure = true;
																$anchorScroll();
																$timeout(function() {
																	$scope.alerts.failure = false;
																}, 3000);
															}
														}
													});
								};
							} ]);
})();